<?php
	$PHP_SELF = $_SERVER['PHP_SELF'];
	if (preg_match("#block-facebook.php#i", $PHP_SELF)) {
		Header("Location: index.php");
		die();
	}
	
	require_once '/modules/facebook/php-sdk-v4.0/autoload.php';
	
	use Facebook\FacebookSession;
	use Facebook\FacebookRequestException;
	use Facebook\FacebookRedirectLoginHelper;
	use Facebook\FacebookRequest;
	use Facebook\GraphObject;
	
	global $appIdFacebook, $appSecretFacebook, $pageIdFacebook, $nbPostsFacebook;
	$nbUsers = 8;
	
	$content = "";
	
	// Initialisation de l'application
	FacebookSession::setDefaultApplication($appIdFacebook, $appSecretFacebook);
	// Cration d'une nouvelle session pour l'application
	$session = FacebookSession::newAppSession();
	
	try {
		// Vrifie la session
		$session->validate();
		
		if(isset($session)) {
			// Permet de rcuprer la page
			$request = new FacebookRequest($session, 'GET', '/'.$pageIdFacebook);
			$response = $request->execute();
			$graphObjectPage = $response->getGraphObject();
				
			// Le nom de la page
			$namePage = $graphObjectPage->getProperty("name");
			// Le lien de la page
			$linkPage = $graphObjectPage->getProperty("link");
			// Le nombre de j'aime sur la page
			$nbLikesPage = $graphObjectPage->getProperty("likes");
			
			// Permet de rcuprer la photo de profile de la page
			//$request = new FacebookRequest($session, 'GET', '/'.$pageIdFacebook.'/picture?redirect=false&type=large');
			$request = new FacebookRequest($session, 'GET', '/'.$pageIdFacebook.'/picture?redirect=false&type=small');
			$response = $request->execute();
			$graphObjectPicturePage = $response->getGraphObject();
				
			// L'url de l'image de la page
			$urlPicturePage = $graphObjectPicturePage->getProperty('url');
			
			//die('/'.$pageIdFacebook.'/posts?limit='.$nbPostsFacebook);
			
			// Permet de rcuprer la liste des posts
			$request = new FacebookRequest($session, 'GET', '/'.$pageIdFacebook.'/posts?limit='.$nbPostsFacebook);
			$response = $request->execute();
			$graphObjectPagePosts = $response->getGraphObject();
			
			$objectPosts = array();
			$objectLikes = array();
			
			// La liste des posts
			$dataPosts = $graphObjectPagePosts->getProperty("data");
			
			// Permet de parcourir les posts
			for($i=0; $i < count($dataPosts->asArray()); $i++) {
				// Le post courant
				$post = $dataPosts->getProperty($i);
				
				$idPost = $post->getProperty("id");
				// L'object li au post
				$object_idPost = $post->getProperty("object_id");
				// Permet de rcuprer la liste de personnes qui aime ce post
				//$likesPost = $post->getProperty("likes")->getProperty("data");
			
				$objectPosts[$i]["post"] = $post;
			
				if($object_idPost && $object_idPost != "") {
					// Permet de rcuprer l'objet li au post
					$request = new FacebookRequest($session, 'GET', '/'.$object_idPost);
					$response = $request->execute();
					$graphObjectObjectUpload = $response->getGraphObject();
					$objectPosts[$i]["objectUpload"] = $graphObjectObjectUpload;
				}
			
				// Il n'y a pas le nombres de personnes demand
				if(count($objectLikes) < $nbUsers) {
					/*******************************************************************************/
					$limitLikes = $nbUsers - count($objectLikes);
					$requestLikes = new FacebookRequest($session, 'GET', '/'.$idPost.'/likes?limit='.$limitLikes);
					$responseLikes = $requestLikes->execute();
					$objectLikesPost = $responseLikes->getGraphObject();
					$likesPost = $objectLikesPost->getProperty("data");
					/*******************************************************************************/
					
					// Permet de gnrer le nombre de personne qui aime le post
					$countLikesPost = (count($likesPost->asArray()) > $nbUsers) ? $nbUsers : count($likesPost->asArray());
					for($j=0; $j < $countLikesPost; $j++) {
						// La personne courante qui aime le post courant
						$likePost = $likesPost->getProperty($j);
						// L'id de la personne courante
						$idLikePost = $likePost->getProperty("id");
			
						// Permet de rcuprer le profile de la personne qui a quia mis un j'aime au post courant
						$request = new FacebookRequest($session, 'GET', '/'.$idLikePost);
						$response = $request->execute();
						$graphObjectLikeUser = $response->getGraphObject();
			
						// Permet de rcuprer l'image de profile de la personne
						$request = new FacebookRequest($session, 'GET', '/'.$idLikePost.'/picture?redirect=false&type=square');
						$response = $request->execute();
						$graphObjectPictureLike = $response->getGraphObject();
			
						// Il n'y a toujours pas le nombres de personnes demand
						if(count($objectLikes) < $nbUsers) {
							$urlLike = $graphObjectPictureLike->getProperty("url");
							$existeLikePicture = false;
							// Vrifie si la personne n'a pas dja t rcupr
							foreach($objectLikes as $objectLike) {
								$pictureLike = $objectLike["picture"];
								if( $urlLike == $pictureLike->getProperty("url") ) {
									$existeLikePicture = true;
									break;
								}
							}
							// Si la personne n'a pas t rcupr on la stocke
							if( !$existeLikePicture) {
								$indexObjectLikes = count($objectLikes);
								$objectLikes[$indexObjectLikes]["data"] = $graphObjectLikeUser;
								$objectLikes[$indexObjectLikes]["picture"] = $graphObjectPictureLike;
							}
						} else {
							break;
						}
					}
				}
			}
			
			$content .=
				'<script type="text/javascript">
					var optionsFacebook = new Array;
					optionsFacebook["index_post"] = 0;
					optionsFacebook["nb_posts"] = '.count($objectPosts).';
					optionsFacebook["name_page"] = "'.$namePage.'";
					optionsFacebook["link_page"] = "'.$linkPage.'";
					optionsFacebook["nb_likes_page"] = '.$nbLikesPage.';
					optionsFacebook["url_picture_page"] = "'.$urlPicturePage.'";
				';
			$content .= 'var posts = new Array;';
			
			for ($i = 0; $i < count($objectPosts); $i++) {
				$objectPost = $objectPosts[$i];
				$post = $objectPost["post"];
				$objectInPost = $objectPost["objectUpload"];
				
				$namePost = $post->getProperty("name");
				$messagePost = $post->getProperty("message");
				$updated_timePost = $post->getProperty("created_time");
				
				$namePost = utf8_decode($namePost);
				$messagePost = utf8_decode($messagePost);
				$namePost = str_replace('"', '\"', $namePost);
				$messagePost = str_replace('"', '\"', $messagePost);
				
				if( $objectInPost != "" ) {
					$linkObject = $objectInPost->getProperty('link');
					$sourceObject = $objectInPost->getProperty('source');
				}
				
				if( preg_match("#.mp4?#", $sourceObject) ) {
					$type = "video";
				} else if( preg_match("#.jpg?#", $sourceObject) ) {
					$type = "image";
				} else {
					$type = "";
				}
				
				$datePost = DateTime::createFromFormat("Y-m-d\TH:i:sO", $updated_timePost);
				$datePost = date_format($datePost, 'j-M-Y');
				
				$content .= '
					var post = new Array;
					post["name"] = "'.$namePost.'";
					post["message"] = "'.$messagePost.'";
					post["date_pub"] = "'.$datePost.'";
					post["link_object"] = "'.$linkObject.'";
					post["source_object"] = "'.$sourceObject.'";
					post["type_object"] = "'.$type.'";
					posts.push(post);
					';
			}
			$content .= '
					optionsFacebook["posts"] = posts;
					var users_picture = new Array;
					';
			
			foreach($objectLikes as $objectLike) {
				$pictureLike = $objectLike["picture"];
				$dataLike = $objectLike["data"];
				$urlLikePicture = $pictureLike->getProperty("url");
				$linkLikePicture = $dataLike->getProperty("link");
				$nameLikePicture = $dataLike->getProperty("name");
				
				$nameLikePicture = utf8_decode($nameLikePicture);
				$nameLikePicture = str_replace('"', '\"', $nameLikePicture);
				
				$content .= '
					var user = new Array;
					user["url"] = "'.$urlLikePicture.'";
					user["link"] = "'.$linkLikePicture.'";
					user["name"] = "'.$nameLikePicture.'";
					users_picture.push(user);
					';
			}
					
			$content .=	'
					optionsFacebook["users_picture"] = users_picture;
				</script>';
			
			// Script permettant d'utilis le SDL JavaScript de Facebook
			$content .= '
				<script type="text/javascript">
					(function(d, s, id) {
						var js, fjs = d.getElementsByTagName(s)[0];
						if (d.getElementById(id)) return;
							js = d.createElement(s); js.id = id;
							js.src = "//connect.facebook.net/fr_FR/sdk.js#xfbml=1&version=v2.0";
							fjs.parentNode.insertBefore(js, fjs);
						}(document, \'script\', \'facebook-jssdk\'));
				</script>
				';
			
			$content .= 
				'<div style="width: 440px;text-align:center;">
					<div id="div-post">
						<div>
							<script type="text/javascript">
								document.write("<img src=\"" + optionsFacebook.url_picture_page + "\" height=\"50px\" />");
							</script>
							<h2 id="title-post"></h2>
							<h3 id="date_pub-post"></h3>
						</div>
						<div>
							<div id="object-post">
							</div>
							<div id="message-post">
							</div>
							<input type="button" value="previous" onclick="previousPost();" />
							<input type="button" value="next" onclick="nextPost();" />
						</div>
					</div>
					<hr />
					<div id="div-like-page">
						<script type="text/javascript">
							document.write("<div class=\"fb-like\" data-href=\"" + optionsFacebook["link_page"] + "\" data-layout=\"button\" data-action=\"like\" data-show-faces=\"false\" data-share=\"false\"></div>");
							document.write(optionsFacebook["nb_likes_page"] + " mentions j\'aime sur la page de <a href=\"" + optionsFacebook["link_page"] + "\" target=\"_blanck\">" + optionsFacebook["name_page"] + "</a>");
						</script>
					</div>
					<hr />
					<div id="div-users-like">
						<script type="text/javascript">
							for(var i = 0; i < optionsFacebook["users_picture"].length; i++) {
								var user = optionsFacebook["users_picture"][i];
								document.write("<a href=\"" + user.link + "\" target=\"_blanck\"><img src=\"" + user.url + "\" alt=\"" + user.name + "\" width=\"50px\" height=\"50px\" /></a>");
							}
						</script>
					</div>
				<div>';
				
			$content .=	'
					<script type="text/javascript">
						var currentIndex = 0;
						var titlePost = document.getElementById(\'title-post\');
						var datePost = document.getElementById(\'date_pub-post\');
						var messagePost = document.getElementById(\'message-post\');
						var objectPost = document.getElementById(\'object-post\');
					
						if(optionsFacebook["nb_posts"] > 0 ) {
							showPost(currentIndex);
						}
					
						function previousPost() {
							if( currentIndex > 0 ) {
								currentIndex--;
								showPost(currentIndex);
							}
						}
					
						function nextPost() {
							if( currentIndex < (optionsFacebook["posts"].length - 1) ) {
								currentIndex++;
								showPost(currentIndex);
							}
						}
					
						function showPost(index) {
							if( index >= 0 && index < optionsFacebook["posts"].length) {
								var post = optionsFacebook["posts"][index];
						
								titlePost.textContent = post.name;
								datePost.textContent = post.date_pub;
								messagePost.innerHTML = post.message;
					
								var htmlObject = "";
								if( post.type_object == "image" ) {
									htmlObject = "<a href=\"" + post.link_object + "\" target=\"_blanck\"><img src=\"" + post.source_object + "\" width=\"340px\" /></a>";
								} else if( post.type_object == "video") {
									htmlObject = "<video controls src=\"" + post.source_object + "\" width=\"340px\"></video>";
								}
					
								objectPost.innerHTML = htmlObject;
							}
						}
					</script>';
		}
	} catch (FacebookRequestException $ex) {
		echo '<h3 style="color: #ff0000">'.$ex->getMessage().'</h3>';
	} catch (\Exception $ex) {
		echo '<h3 style="color: #ff0000">'.$ex->getMessage().'</h3>';
	}
?>