//drag calendrier
document.onmousemove = mouseMove;
document.onmouseup   = mouseUp;

var dragObject  = null;
var mouseOffset = null;

function mouseCoords(ev){
	if(ev.pageX || ev.pageY){
		return {x:ev.pageX, y:ev.pageY};
	}
	return {
		x:ev.clientX + document.body.scrollLeft - document.body.clientLeft,
		y:ev.clientY + document.body.scrollTop  - document.body.clientTop
	};
}

function getMouseOffset(target, ev){
	ev = ev || window.event;

	var docPos    = getPosition(target);
	var mousePos  = mouseCoords(ev);
	return {x:mousePos.x - docPos.x, y:mousePos.y - docPos.y};
}

function getPosition(e){
	var left = 0;
	var top  = 0;

	while (e.offsetParent){
		left += e.offsetLeft;
		top  += e.offsetTop;
		e     = e.offsetParent;
	}

	left += e.offsetLeft;
	top  += e.offsetTop;

	return {x:left, y:top};
}

function mouseMove(ev){
	ev           = ev || window.event;
	var mousePos = mouseCoords(ev);

	if(dragObject){
		dragObject.style.position = 'absolute';
		dragObject.style.top      = mousePos.y - mouseOffset.y;
		dragObject.style.left     = mousePos.x - mouseOffset.x;
		
		fixed_position = true;
		
		return false;
	}
}
function mouseUp(){
	dragObject = null;
}

function makeDraggable(item){
	if(!item) return;
	item.onmousedown = function(ev){
		dragObject  = this;
		mouseOffset = getMouseOffset(this, ev);
		return false;
	}
}

//fonction de sortie
function writechiffre(valeur) {
	ztexteChiffre.value=valeur;
}
function addCell(valeur,classe) {
	return '<td class="'+classe+'">'+'<a href="" onclick="writechiffre(\''+valeur+'\');hidePopUpChiffres();return false">'+valeur+'</a>'+'</td>';
}
//calcul du calendrier
function buildChiffres(d, m, y) {
	var cM = "mainCal";
	var cH = "month";
	var cD = "days";
	var brdr = 1;

	var t='<table class="'+cM+'" cols="3"><tr align="center">';
	t+='<td colspan="3" align="center" class="'+cH+'">';
	t+='<span class="mois"><a href="#" onclick="writechiffre(\'\');return false;">Gomme</a></span>';
	t+= '<a href="#" onclick="hidePopUpChiffres();return false" class="close"><img src="modules/Sudoku/lib/icns/close_cal.gif" hspace="2" vspace="2" border="0"></a>';
	t+='</td></tr>';
	t+='<tr align="center">';
	t+=addCell("1",cD);
	t+=addCell("2",cD);
	t+=addCell("3",cD);
	t+='</tr>';
	t+='<tr align="center">';
	t+=addCell("4",cD);
	t+=addCell("5",cD);
	t+=addCell("6",cD);
	t+='</tr>';
	t+='<tr align="center">';
	t+=addCell("7",cD);
	t+=addCell("8",cD);
	t+=addCell("9",cD);
	t+='</tr>';
	return t+='</table>';
}

//manipulation des pop-up

function boiteChiffres(x,y,w,h,bgc,id){
	var v=document.createElement('div');
	v.setAttribute('id',id); 
	v.style.position='absolute';
	v.style.left=x+'px';
	v.style.top=y+'px';
	if (w != "") v.style.width=w+'px';
	if (h != "") v.style.height=h+'px';
	if (bgc != "") v.style.backgroundColor=bgc;
	v.style.visibility='hidden';
	v.style.padding='0px 0px 0px 0px';
	v.style.zIndex=100;
	return v;
}

function popUpChiffres(x,y,w,h){
	if (x == "") x = 0;
	if (y == "") y = 0;
	var unepopup = new boiteChiffres(x,y,w,h,"","popUpChiffres");
	document.body.appendChild(unepopup);
	return unepopup;
}

function newPopUpChiffre(){
	chiffres = popUpChiffres("","","","");
	makeDraggable(chiffres);
}

function showPopUpChiffres(champ){
	var x = calculeX(champ)-1;
	var y =  eval(calculeY(champ) + calculeH(champ));
	fillPopUpChiffres(champ.value);
	if (!fixed_position) {
		chiffres.style.left=x+'px';
		chiffres.style.top=y+'px';
	}
	chiffres.style.visibility='visible';
	ztexteChiffre = champ;
}

function hidePopUpChiffres(){
	chiffres.style.visibility='hidden';
}

function fillPopUpChiffres(valeur){
	
	if (valeur == "") {
		var todaydate=new Date();
		var curday=todaydate.getDate();
		var curmonth=todaydate.getMonth()+1;
		var curyear=todaydate.getFullYear();
	}
	else {
		var tab = valeur.split("/");
		var curday=tab[0];
		var curmonth = tab[1];
		var curyear = tab[2];
	}
	chiffres.innerHTML=buildChiffres(curday, curmonth, curyear);
}

function calculeX(r){
  return calculeOffset(r,"offsetLeft")
}

function calculeH(r){
  return r["offsetHeight"];
}

function calculeL(r){
  return r["offsetWidth"];
}

function calculeY(r){
  return calculeOffset(r,"offsetTop")
}
function calculeOffset(element,attr){
  var offset=0;
  while(element){
    offset+=element[attr];
    element=element.offsetParent
  }
  return offset
}

var fixed_position = false;
var chiffres;
var ztexteChiffre;