<?php
/**
* Fonctions publique d'interface entre le CMS et le module de gestion des clients.
* 
* Ces fonctions sont publiques. 
* @package becmsSimpleClient
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

if (eregi("connector_lib.php", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

require_once("lib/g_params.php");
require_once("lib/g_db.php");
require_once("lib/ba_adminclient.php");


$My_SQL["maBase"] = $db;

/**
* Classe des fonctions.
* 
* @package becmsSimpleClient
*/
class clientconnector {
/**
* Rcupre l'intgralit des clients enregistrs.
* 
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
* @return array Tableau contenant la liste des clients trouvs.
*/
	function getClients($My_SQL, $vars_mod) {
		$sgbd = new BD_Clients();
		
		$clients = $sgbd->getClients($My_SQL,"");
		$clientList = array();
		
		foreach ($clients as $client) {
    			array_push($clientList,array($client["Id"], $clients["nom"]." ".$clients["prenom"]));        	
	    }
		
		return $clientList;
	}
	
/**
* Renvoie l'intgralit des clients enregistrs sous forme de de tableau texte.
* 
* @return string Texte contenant la liste des clients trouvs.
*/
	function getClientsTEXT() {
		global $My_SQL, $vars_mod;
		
		$sgbd = new BD_Clients();
		
		$clients = $sgbd->getClients($My_SQL,"");
		
		$clientsTEXT = "";
		$clientsTEXT .= "Nom et prenom";
		$clientsTEXT .= "\t"."Adresse";
		$clientsTEXT .= "\t"."Code postal";
		$clientsTEXT .= "\t"."Ville";
		$clientsTEXT .= "\t"."Pays";
		$clientsTEXT .= "\t"."Tlphone";
		$clientsTEXT .= "\t"."Fax";
		$clientsTEXT .= "\t"."Portable";
		$clientsTEXT .= "\t"."E-mail";
		$clientsTEXT .= "\t"."Anniversaire";
		$clientsTEXT .= "\t"."Valide";
		$clientsTEXT .= "\n";
		foreach($clients as $client) {
			$clientsTEXT .= $client["civilite"]." ".$client["nom"]." ".$client["prenom"];
			$clientsTEXT .= "\t".str_replace("\n"," - ",str_replace("\r","",$client["adresse"]));
			$clientsTEXT .= "\t".$client["codepostal"];
			$clientsTEXT .= "\t".$client["ville"];
			$clientsTEXT .= "\t".$client["pays"];
			$clientsTEXT .= "\t".$client["tel"];
			$clientsTEXT .= "\t".$client["fax"];
			$clientsTEXT .= "\t".$client["portable"];
			$clientsTEXT .= "\t".$client["email"];
			$clientsTEXT .= "\t".$client["datenaissance"];
			$clientsTEXT .= "\t".$client["valide"];
			$clientsTEXT .= "\n";
		}
		return $clientsTEXT;
	}
	
/**
* Renvoie l'intgralit des clients enregistrs sous forme de rfrence  un fichier Excel binaire.
* 
* @return string Texte contenant la liste des clients trouvs.
*/
	function getClientsEXCEL() {
		global $My_SQL, $vars_mod;
		
		$sgbd = new BD_Clients();
		
		$clients = $sgbd->getClients($My_SQL,"");
		
		set_time_limit(10);

		require_once "php_writeexcel/class.writeexcel_workbook.inc.php";
		require_once "php_writeexcel/class.writeexcel_worksheet.inc.php";
		$fname = tempnam("/tmp", "Export.xls");
		$workbook =& new writeexcel_workbook($fname);
		$worksheet =& $workbook->addworksheet('Clients');
		$worksheet->set_column('A:K', 20);
		$worksheet->set_column('A:B', 32);
		$worksheet->set_column('I:I', 32);
		$entete  =& $workbook->addformat(array(
										font		=> 'Arial',
										bg_color	=> 'grey',
                                        bold    => 1,
                                        color   => 'black',
                                        size    => 12,
                                        merge   => 1,
                                        bold    => 1
                                        ));
        $donnee  =& $workbook->addformat(array(
										font		=> 'Arial',
										bold    => 0,
                                        color   => 'black',
                                        size    => 10,
                                        merge   => 1,
                                        text_h_align => 0,
                                        num_format => '@'
                                        ));
		
        $texte = array("Nom et prnom","Adresse","Code postal","Ville","Pays","Tlphone","Fax","Portable","E-mail","Anniversaire","Valide");
		$worksheet->write_row('A1', $texte, $entete);
		
		$compteur = 2;
		foreach($clients as $client) {
			$texte = array(
			$client["civilite"]." ".$client["nom"]." ".$client["prenom"],
			str_replace("\n"," - ",str_replace("\r","",$client["adresse"])),
			$client["codepostal"],
			$client["ville"],
			$client["pays"],
			$client["tel"],
			$client["fax"],
			$client["portable"],
			$client["email"],
			$client["datenaissance"],
			$client["valide"]);
			$worksheet->write_row('A'.$compteur, $texte, $donnee);
			//$worksheet->write_string('C'.$compteur, $client["codepostal"], $donnee);
			$compteur++;
		}
		$workbook->close();
		return $fname;
	}
}

?>