
(function () {
    /**
     * Module permettant l'utilisation d'icons personnalisés.
     * @constructor
     */
    function CustomIconMarker(){
        var _this = this;

        this._customRootPath = "";
        /**
         * Liste des icons disponibles, ajouter ici de nouveau icon à la librairie et dans le dossier assets du module CustomIconMarker
         */

        function getIconDisponibles(){

            return {
                "marker-icon-2x-black" : {
                    iconUrl: _this._customRootPath+"map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-icon-2x-black.png",shadowUrl: _this._customRootPath+"map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-shadow.png",iconSize: [25, 41],iconAnchor: [12, 41],popupAnchor: [1, -34],shadowSize: [41, 41]},    
                "marker-icon-2x-blue" : {
                    iconUrl: _this._customRootPath+"map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-icon-2x-blue.png",shadowUrl: _this._customRootPath+"map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-shadow.png",iconSize: [25, 41],iconAnchor: [12, 41],popupAnchor: [1, -34],shadowSize: [41, 41]},
                "marker-icon-2x-green" : {
                    iconUrl: _this._customRootPath+"map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-icon-2x-green.png",shadowUrl: _this._customRootPath+"map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-shadow.png",iconSize: [25, 41],iconAnchor: [12, 41],popupAnchor: [1, -34],shadowSize: [41, 41]},
                "marker-icon-2x-grey" : {
                    iconUrl: _this._customRootPath+"map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-icon-2x-grey.png",shadowUrl: _this._customRootPath+"map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-shadow.png",iconSize: [25, 41],iconAnchor: [12, 41],popupAnchor: [1, -34],shadowSize: [41, 41]},
                "marker-icon-2x-orange" : {
                    iconUrl: _this._customRootPath+"map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-icon-2x-orange.png",shadowUrl: _this._customRootPath+"map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-shadow.png",iconSize: [25, 41],iconAnchor: [12, 41],popupAnchor: [1, -34],shadowSize: [41, 41]},
                "marker-icon-2x-red" : {
                    iconUrl: _this._customRootPath+"map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-icon-2x-red.png",shadowUrl: _this._customRootPath+"map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-shadow.png",iconSize: [25, 41],iconAnchor: [12, 41],popupAnchor: [1, -34],shadowSize: [41, 41]},
                "marker-icon-2x-violet" : {
                    iconUrl: _this._customRootPath+"map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-icon-2x-violet.png",shadowUrl: _this._customRootPath+"map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-shadow.png",iconSize: [25, 41],iconAnchor: [12, 41],popupAnchor: [1, -34],shadowSize: [41, 41]},
                "marker-icon-2x-yellow" : {
                    iconUrl: _this._customRootPath+"map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-icon-2x-yellow.png",shadowUrl: _this._customRootPath+"map_arob-UImap_arob/map_arob.customIconMarker/assets/marker-shadow.png",iconSize: [25, 41],iconAnchor: [12, 41],popupAnchor: [1, -34],shadowSize: [41, 41]},
            }
        }
        this._iconDisponibles = getIconDisponibles();

        this.setCustomRootPath = function(path){
            this._customRootPath = path;
            this._iconDisponibles = getIconDisponibles();
        }
        
        /**
         * Retourne l'icone demandé, ou celui par défaut
         * @param {string} nameMarker 
         */
        this.getStyle = function(nameMarker){
            var style = _this._iconDisponibles[nameMarker];
            if(typeof style != "undefined"){
                return style;
            }else{
                return _this._iconDisponibles["marker-icon-2x-blue"];
            }
        }

        /**
         * Liste les icons disponibles, utilisé pour la selection
         */
        this.getList = function(){
            var t = [];
            for (var k in _this._iconDisponibles){
                if (typeof _this._iconDisponibles[k] !== 'function') {
                     t.push({"name" : k,"url" : _this._iconDisponibles[k]["iconUrl"]});
                }
            }
            return t;
        }
    }

    map_arob.CustomIconMarker = new CustomIconMarker();
})();
