
function GeoJSON(type)
{
    var _this = this;
    this.feature;
    this.featureCollection;
    this.type;

    if(type == "FeatureCollection"){
        this.type = "FeatureCollection";
        this.featureCollection = new FeatureCollection();
    }else{
        this.type = "Feature";
    }
    
    this.addFeature = function(properties, geometry){
        
        if(this.type == "Feature"){            

            if(this.feature == null){                

                this.feature = new Feature(properties, geometry);
                return this.feature;
            }else{
                
                this.featureCollection = new FeatureCollection();
                this.featureCollection.addFeature(this.feature);                
                delete this.feature; 
                this.type = "FeatureCollection";
                var f = new Feature(properties, geometry);
                this.featureCollection.addFeature(f);
                return f;
            } 
        }else{
            var f = new Feature(properties, geometry);
            this.featureCollection.addFeature(f);
            return f;
        }

    }

    this.removeFeature = function(mFeature){
        if(this.type == "Feature"){
            delete this.feature;
        }else{
            this.featureCollection.removeFeature(mFeature);
        }
    }

    
    this.export = function(toString)
    {
        var geoJsonInArray= {};
        if(this.type == "Feature"){
            geoJsonInArray["type"] = "Feature";
            geoJsonInArray["properties"] = this.feature.properties;

            //Transforme la liste [] en objet json {} si les propriétés sont vides

            featureInArray = {};

            featureInArray["type"] = "Feature";
            featureInArray["properties"] = this.feature.properties;

            //Transforme la liste [] en objet json {} si les propriétés sont vides

            if(featureInArray["properties"].length == 0){
                featureInArray["properties"] =  {};
            }
            
            geoJsonInArray["geometry"] = {};
            geoJsonInArray["geometry"]["type"] = this.feature.geometry.type;
            if(this.feature.geometry.type == "MultiLineString" ||
                this.feature.geometry.type == "MultiPolygon" ||
                this.feature.geometry.type == "MultiPoint"){
                    geoJsonInArray["geometry"]["coordinates"] = this.feature.geometry.exportToArray();
            }if(this.feature.geometry.type == "GeometryCollection"){
                geoJsonInArray["geometry"]["geometries"] = this.feature.geometry.exportToArray();
            }else{
                geoJsonInArray["geometry"]["coordinates"] = this.feature.geometry.exportToArray();
            }

            
            if(toString){
                return JSON.stringify(geoJsonInArray);
            }
            return geoJsonInArray;
        }else
        if(this.type == "FeatureCollection"){
            geoJsonInArray["type"] = "FeatureCollection";
            geoJsonInArray["features"] = [];

            var gF = this.featureCollection.getFeatures();
            for (var i = 0, len = gF.length; i < len; i++) { 
                var f = gF[i];
                featureInArray = {};

                featureInArray["type"] = "Feature";
                featureInArray["properties"] = f.properties;

                //Transforme la liste [] en objet json {} si les propriétés sont vides

                if(featureInArray["properties"].length == 0){
                    featureInArray["properties"] =  {};
                }
                
                featureInArray["geometry"] = {};
                featureInArray["geometry"]["type"] = f.geometry.type;
                if(f.geometry.type == "GeometryCollection" || f.geometry.type == "MultiLineString" ||
                f.geometry.type == "MultiPolygon" ||
                f.geometry.type == "MultiPoint"){
                    featureInArray["geometry"]["coordinates"] = f.geometry.exportToArray();
                }else{
                    featureInArray["geometry"]["coordinates"] = f.geometry.exportToArray();
                }
                geoJsonInArray["features"].push(featureInArray);
            }
            if(toString){
                return JSON.stringify(geoJsonInArray);
            }
            return geoJsonInArray;
        } 
    }

    /**
     * 
     * @param {string} toString return en string
     */
    this.exportNoMulti = function(toString){
        var geoJsonInArray= {};
        if(this.type == "Feature"){
            this.featureCollection = new FeatureCollection();
            this.featureCollection.addFeature(this.feature);                
            delete this.feature; 
            this.type = "FeatureCollection";
        }
        
        if(this.type == "FeatureCollection"){
            geoJsonInArray["type"] = "FeatureCollection";
            geoJsonInArray["features"] = [];

            function recursiveClean(){
                for (var i = 0, len = _this.featureCollection.getFeatures().length; i < len; i++) {
                
                    var f = _this.featureCollection.getFeatures()[i];
                    if(typeof f.geometry != "undefined"){
                        if(f.geometry.type == "GeometryCollection" || 
                        f.geometry.type == "MultiLineString" ||
                        f.geometry.type == "MultiPolygon" ||
                        f.geometry.type == "MultiPoint"){
                            for(var j = 0, lenJ = f.geometry.geometries.length; j < lenJ; j++){
                               
                                _this.addFeature(f.properties,f.geometry.geometries[j])
                            }
                            _this.featureCollection.getFeatures().splice(i, 1);
                            recursiveClean();
                            break;
                        }
                    }
                }
            }
            recursiveClean();

            for (var i = 0, len = _this.featureCollection.getFeatures().length; i < len; i++) {
                var f = _this.featureCollection.getFeatures()[i];
                featureInArray = {};

                featureInArray["type"] = "Feature";
                featureInArray["properties"] = f.properties;

                //Transforme la liste [] en objet json {} si les propriétés sont vides

                if(featureInArray["properties"].length == 0){
                    featureInArray["properties"] =  {};
                }
                
                featureInArray["geometry"] = {};
                featureInArray["geometry"]["type"] = f.geometry.type;
                if(f.geometry.type == "GeometryCollection"){
                    featureInArray["geometry"]["geometries"] = f.geometry.exportToArray();
                }else{
                    featureInArray["geometry"]["coordinates"] = f.geometry.exportToArray();
                }
                geoJsonInArray["features"].push(featureInArray);
            }

            


            if(toString){
                return JSON.stringify(geoJsonInArray);
            }
            return geoJsonInArray;
        } 
    }
}


function FeatureCollection()
{
    this.features = [];

    this.addFeature = function(feature){
        this.features.push(feature);
        return this.features[this.features.length - 1 ];
    }

    this.removeFeature = function(mfeature){
        var i = this.features.indexOf(mfeature);
        if(i > -1){
            this.features.splice(i, 1);
        }
    }

    this.getFeatures = function(){
        return this.features;
    }
    this.getFeatureByIndex = function(index){
        return this.features[index];
    }    
}

function Feature(properties, geometry)
{
     
        this.properties = properties;
        this.geometry = geometry;

        this.getFeatureByIndex = function(index){
            return this;
        }
}


function Geometry(type){
   
    this.coordinates;
    this.type;
    this.geometries = [];
    var _this = this;
   
    
    if(
        type === "Polygon"|| type == "MultiPolygon" || 
        type === "LineString" || type == "MultiLineString" || 
        type === "Point" || type == "MultiPoint" ||
        type == "GeometryCollection"){
        this.type = type;
    }else{
        throw ('Type of geometry invalid');
    }

    
    
    this.setGeo = function(coordinates){
        
        if(this.type === "Point"){
            if(coordinates.length >= 2){
                this.coordinates = new Point(coordinates[0], coordinates[1]);
            }else{
                throw ("Invalid Point coordinates...[float x,float y] expected ");
            }
        }if(this.type === "MultiPoint"){
            /*for (phpjslocvar_0 in coordinates) { 
                value = coordinates[phpjslocvar_0];
                if(value.length >= 2){
                    this.coordinates.push(new Point(value[0], value[1]));
                }else{
                    throw ("Invalid Point coordinates...[float x,float y] expected ");
                }
            }*/
            for (coor in coordinates) { 
                if(coordinates[coor].length >= 2){
                    this.geometries.push(GeoJSONParser.validGeometryJson({"type" : "Point", "coordinates" : coordinates[coor]}))
                }else{
                    throw ("Invalid Point coordinates...[float x,float y] expected ");
                }
            }
        }        
        else 
        if(this.type == "Polygon"){
            this.coordinates = new Polygon(coordinates);
            //throw "Polygon geometry is not implemented yet"
        }else 
        if(this.type == "MultiPolygon"){
            for (coor in coordinates) { 
                
                this.geometries.push(GeoJSONParser.validGeometryJson({"type" : "Polygon", "coordinates" : coordinates[coor]}))
                
            }
        }
        else 
        if(this.type == "LineString"){
            this.coordinates = new LineString(coordinates);
        }else 
        if(this.type == "MultiLineString"){
            for (coor in coordinates) { 
                this.geometries.push(GeoJSONParser.validGeometryJson({"type" : "LineString", "coordinates" : coordinates[coor]}))
                
            }           
        }else 
        if(this.type == "GeometryCollection"){
            this.coordinates = null

            for (coor in coordinates) { 
                
                this.geometries.push(GeoJSONParser.validGeometryJson(coordinates[coor]));
                
            }
            //throw "GeometryCollection geometry is not implemented yet"                       
        }
    }

    this.exportToArray = function()
    {   
        
        if(this.type === "Point" || this.type == "Polygon" || this.type == "LineString"){
            return this.coordinates.toArray();
        }else{
            //throw this.type+"  MultiPoint,MultiPolygon,MultiLineString,GeometryCollection not implemented yet ";
       
            if(this.type === "MultiPoint" || this.type == "MultiPolygon" || this.type == "MultiLineString" ){
                var tmpCoordinatesArray = [];
                for (phpjslocvar_0 in this.geometries) { 
                    coordinate = this.geometries[phpjslocvar_0];
                    tmpCoordinatesArray.push(coordinate.exportToArray());
                }
                return tmpCoordinatesArray;
            }else 
            if(this.type == "GeometryCollection"){            
                var tmpCoordinatesArray = [];
                for (phpjslocvar_1 in this.geometries) { 
                    var geometry = this.geometries[phpjslocvar_1];  
                    var tmpgeo = {};              
                    tmpgeo["type"] = geometry.type;
                    if(geometry.type == "GeometryCollection"){
                        tmpgeo["geometries"] = geometry.exportToArray();
                    }else{
                        tmpgeo["coordinates"] = geometry.exportToArray();
                    }

                    tmpCoordinatesArray.push(tmpgeo);
                }  
                return tmpCoordinatesArray;          
            }
        }
    }
}


function Point(x, y) {
    this.latitude = function() {
        return this._y;
    };

    this.longitude = function() {
        return this._x;
    };

    this.setLatitude = function(y) {        
        if (y >= -90 && y <= 90) {
            this._y = y;
        } else {
            throw "Invalid latitude degree";
        }
    };

    this.setLongitude = function(x) {          
        if(x >= -180 || x <= 180){
            this._x = x;
        }else{
            throw "Invalid longitude degree";
        }
        
    };

    this.toArray = function() {
        return [this.longitude(), this.latitude()];
    }; 


    if(typeof x != "undefined"){
        this._x = x;        
    }else{
        throw "Longitude empty";
    }

    if(typeof y != "undefined"){        
        this._y = y;     
    }else{
        throw "Latitude empty";
    }
    

    this.setLongitude(x);
    this.setLatitude(y);
}
Point.areTwoPointsIdentical = function(point1, point2) {
    
    if (
        point1.latitude() === point2.latitude() &&
        point1.longitude() === point2.longitude()
    ) {
    return true;
    }
    return false;
};



function LineString(points) {
    var _this = this;
    _this._points = [];
    _this.points = points;

    _this.addPoints = function(points) {
        for (var i = 0, len = points.length; i < len; i++) {
            
            if(points[i] instanceof Point){                   
                _this.addPoint(points[i]);
            }else{
                _this.addPoint(new Point(points[i][0],points[i][1]) );
            }
        }
    }        
    
    this.addPoint = function(point) {                
        if(point instanceof Point){
            if(_this._points.length == 0){
                 //_points est vide dans le linestring, donc c'est la creation
                 if(_this.points.length > 0 ){ 
                     // si la creation de linestring se fait avec plusieurs points
                    _this._points.push(point);
                }else{
                    // la creation est faite à partir d'une seule coordonné, UImap_arob
                    _this._points.push(point);
                    _this._points.push(new Point(point.longitude(), point.latitude()));
                }
            }else{
                
                _this._points.push(point);
            }
        }else{
            throw "Erreur is not a Point in function Linestring.addPoint";
        }            
    }        
    
    this.toArray = function() {        
        var arrayCoordinates = [];
        for (var i = 0, len = _this._points.length; i < len; i++) { 
            point = _this._points[i];
            arrayCoordinates.push(point.toArray());
        }        
        return arrayCoordinates;
    } 

    if(points instanceof Array){
        _this.addPoints(points);
    }else
    if(points instanceof Point){
        _this.addPoint(points);
    }          
        
}



function Polygon(points) {
    var _this = this;
    _this._points = [];
    _this._holes = [];
    _this.points = points;
    
    
    this.addHole = function(hole) {
        c = hole.length;
        
        if(c < 4){
            throw ("Coordinates not valid, 4 positions minimum expected for a hole " + c + " given");
        }else{
            tmpPoint = [];
            for(var i = 0; i < c; i++){
                
                if(hole[i].length >= 2){
                    tmpPoint.push(new Point(hole[i][0], hole[i][1]));
                    }else{
                    throw ("Invalid Point coordinates...[float x,float y] expected adding holes, position [" + i+"] ");
                }
                
            }
        }
        _this._holes.push(tmpPoint);
    }   
        
    this.toArray = function() {
        
        var arrayCoordinates = [];
        var __points = [];

        for (var i = 0, len = _this._points.length; i < len; i++) {           
            __points.push(_this._points[i].toArray());
        }
        arrayCoordinates.push(__points);
        
        if(_this._holes != null){
            for (var i = 0, len = _this._holes.length; i < len; i++) {                 
                var ___points = [];
                for (var j = 0, lenj = _this._holes[i].length; j < lenj; j++) {
                    ___points.push(_this._holes[i][j].toArray());
                }
                arrayCoordinates.push(___points);
            }
        }

        return arrayCoordinates;
    }

    this.addPoints = function(points) {
        for (var i = 0, len = points.length; i < len; i++) {            
            if(points[i] instanceof Point){                   
                _this.addPoint(points[i]);
            }else{
                _this.addPoint(new Point(points[i][0],points[i][1]) );
            }
        }
    }        
    
    this.addPoint = function(point) {                
        if(point instanceof Point){
            if(_this._points.length == 0){ 
                //_points est vide dans le polygon, donc c'est la creation

                if(_this.points.length > 0 ){ 
                    // si la creation de polygon se fait avec plusieurs points
                    var a = _this.points[0][0];
                    var b = _this.points[0][_this.points[0].length - 1];
                    var c = _this.points[0].length ;
                    if(Point.areTwoPointsIdentical(new Point(a[0], a[1]),new Point(b[0], b[1])) && c != 1){
                        // si le polygon est bien construit, que le premier et le dernier sont identiques
                        _this._points.push(point);
                    }else{
                        // si le polygon est mal construit, que le premier et le dernier sont différents
                        _this._points.push(point);
                        _this._points.push(point);
                    }
                }else{
                    // la creation est faite à partir d'une seule coordonné, UImap_arob
                    _this._points.push(point);
                    _this._points.push(new Point(point.longitude(), point.latitude()));
                    _this._points.push(new Point(point.longitude(), point.latitude()));
                    _this._points.push(new Point(point.longitude(), point.latitude()));
                }
                
            }else{
                //le polygon possede déjà au moins un point
                if(_this._points.length == 1){
                    //le polygon possede que le premier point
                    _this._points.push(point);
                }else{
                    //le polygon possede plusieurs points
                    if(Point.areTwoPointsIdentical(_this._points[0], _this._points[_this._points.length - 1])){
                        //si le premier est le dernier sont identiques, on insert le nouveau point avant le dernier
                        _this._points.splice(_this._points.length - 1, 0, point)
                    }else{
                        //le dernier point du polygon est différent du premier, on push à la fin de la liste des sommets
                        _this._points.push(point);
                    }
                }
                
            }
        }else{
            throw "Erreur is not a Point in function Polygon.addPoint";
        }            
    }

    if(_this.points.length != 0){
        if(_this.points[0].length >= 4){
            _this.addPoints(_this.points[0]);
    
            
            if(typeof _this.points[1] != "undefined"){
                for(var i = 1, len = _this.points.length; i < len; i++){
                    _this.addHole(_this.points[i]);
                }            
            }
        }
    }
    

}
    
    
   

function GeoJSONParser(geojson) {
    var _this = this;
    this.geojson;
    this._struct;

    if(typeof geojson == "string"){
        var printError = function(error, explicit) {
            console.log(error);
        }
        
        try {       
            this._struct(JSON.parse(json));
        } catch (e) {
            if (e instanceof SyntaxError) {
                printError(e, true);
            } else {
                printError(e, false);
            }
        }
    }else{
        this._struct = geojson;
    }

    this.parse = function() {        
        
        if (this._struct.type == 'Feature') {
            _this.geojson =  new GeoJSON("Feature"); 
            _this.addFeature(_this._struct.properties,_this._struct.geometry);
            }else
        if (this._struct.type == 'FeatureCollection') {
            this.geojson =  new GeoJSON("FeatureCollection");
            for (key in _this._struct.features) { 
                var value = this._struct.features[key];
                this.addFeature(value.properties,value.geometry);
            }
            
        }else{
            throw ('Type of geojson invalid, Feature or FeatureCollection only');
        }
        delete this._struct;
    }

    this.addFeature = function(properties, geometry) {
         this.geojson.addFeature(properties, GeoJSONParser.validGeometryJson(geometry));
                
    }

    this.parse();
    
   
        
}
    
       
    
    
        
GeoJSONParser.validGeometryJson = function(geometry) {
    
            
    if(typeof geometry == "undefined"){
        throw ('Missing in the feature geometry');
    }
    
    if(geometry.type != "GeometryCollection"){
        
    }
    
    if (geometry.type == 'Point') {
        var point = new Geometry("Point");
        point.setGeo(geometry.coordinates);
        return point;
        }else
    if (geometry.type == 'MultiPoint') {
        var multiPoint = new Geometry("MultiPoint");
        multiPoint.setGeo(geometry.coordinates);
        return multiPoint;
        }else
    if (geometry.type == 'Polygon') {
        
        var polygon = new Geometry("Polygon");
        polygon.setGeo(geometry.coordinates);
        return polygon;
        
        }else
    if (geometry.type == 'MultiPolygon') {
        var MultiPolygon = new Geometry("MultiPolygon");
        MultiPolygon.setGeo(geometry.coordinates);
        return MultiPolygon;
        
        }else
    if (geometry.type == 'LineString') {
        var lineString = new Geometry("LineString");
        lineString.setGeo(geometry.coordinates);
        return lineString;
        
        }else
    if (geometry.type == 'MultiLineString') {
        var MultiLineString = new Geometry("MultiLineString");
        MultiLineString.setGeo(geometry.coordinates);
        return MultiLineString;
        
        }else
    if (geometry.type == 'GeometryCollection') {
        var GeometryCollection = new Geometry("GeometryCollection");
        GeometryCollection.setGeo(geometry.geometries);
        return GeometryCollection;
        
        }else
    if(geometry.type){
        throw ('Unsupported geometry type');
    }
}
    
    
        
/*
    var g = new GeoJSON("feature");
    var geoLine = new Geometry("LineString");
    geoLine.setGeo(new Point(9,42.00001));
    g.addFeature({}, geoLine);
    g.exportToString();
    geoLine.coordinates.addPoint(new Point(9,43));
    g.exportToString();var geoMarker = new Geometry("Point");
    geoMarker.coordinates = new Point(9,42);
    g.addFeature({},geoMarker);
    g.exportToString();
    map_arob.map.removeLayer(map_arob.editmap.theLayers);
    map_arob.layerControl.removeLayer(map_arob.editmap.theLayers)
    map_arob.editmap.SET_EditableGeojson(JSON.parse(g.exportToString()), "theLayers", {name : "poisson"});  
*/