// Google trad
function googleTranslateElementInit() {
  new google.translate.TranslateElement({pageLanguage: 'fr', includedLanguages: 'de,en,es,it', layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
}

var ratio = 0;

$(document).ready(function () {
	
	// MENU ROLL OVER
	$('#main-menu .item').hover(function (){
		$(this).find('ul').stop(true,true).show(200);
	}, function () {
		$(this).find('ul').stop(true,true).hide(300);
	});
	
	// RECHERCHE
	$('#search-button').bind('click', function () { setSearchOn() });
	if($('#search-area #query').val() == '') { $('#search-area #query').val($('#search-area #query').data('placeholder')); }
		
	// PLACEHOLDER & FORMS EVENTS
	$('.placeholder').each(function(index, element) {
		if($(this).val() == '') $(this).val($(this).data('placeholder'));
		$(this).focus(function () {
			if($(this).val() == $(this).data('placeholder')) $(this).val('');
		});
		$(this).blur(function () {
			if($(this).val() == '') $(this).val($(this).data('placeholder'));
		});
		//placeHolder($(this), $(this).val());
    });
	
	$('.block-adherent').click(function () {
		$target = $(this);
		if($target.hasClass('opened')) {
			$target.find('.list-adherents-small').stop(true, true).slideUp(300, function () { $target.removeClass('opened') });
		} else {
			$('.block-adherent.opened').find('.list-adherents-small').stop(true, true).slideUp(300, function () { $(this).parent().removeClass('opened') });
			$target.find('.list-adherents-small').stop(true, true).slideDown(300, function () { $target.addClass('opened') });
		}
	});
	
	//--> BLKOCK AGENDA
	$sliderAgenda = $('#block-agenda');
	$sliderAgenda.flexslider({
		itemWidth: 520,
		slideshowSpeed: 7000,
		animationSpeed: 600,
		pauseOnHover: true,
		animation: "slide",
		directionNav: true,
		controlNav: false,
		prevText: '<img src="themes/bocognano/images/common/link-arrow-prev.png" alt="&lt;" />',
		nextText: '<img src="themes/bocognano/images/common/link-arrow-next.png" alt="&lt;" />',
	});
	
	//--> Fiche adhrents slider
	$("#slider-photo-adherents").flexslider({
		slideshow: false,
		animationSpeed: 1000,
		animation: "slide",
		touch: false,
		controlNav: "thumbnails",
		directionNav: true,
		prevText: '<img src="themes/bocognano/images/common/link-arrow-prev.png" alt="&lt;" />',
		nextText: '<img src="themes/bocognano/images/common/link-arrow-next.png" alt="&lt;" />',
	});
	
	// FOOTER ROLL OVER
	$("#logo-footer > a").each(function () {
		var imgH = $(this).children('img').attr('src').split(".")[0] + '-h.' + $(this).children('img').attr('src').split(".")[1];
		$(this).append('<span class="rollover"><img src="'+imgH+'" alt="" /></span>').hover(function () {
			$(this).find('.rollover').stop(true,true).fadeIn(300);
		}, function () {
			$(this).find('.rollover').stop(true,true).fadeOut(300);
		});
	});
	
	// --- Fancy
	if (typeof $.fancybox == 'function')
	{
		$('.fancymage').fancybox();
		$('.fancyframe').fancybox({
			'type':'iframe',
			'width':'860px'
		});
	}
		
	// --- CHARGEMENT (Galerie photo)
	$('.album').addClass('loading');
	$('.galerie_photo').addClass('loading');
	
	// --------- FORMULAIRES --o===)===============>------------ //
	// -- SELECT PERSONALISE //
	if( typeof $.selecter == 'function' ){
		$('.formatselect').selecter({customClass: $(this).data('class')});
	} 
	
});

$(window).load(function () {
	
	// ---- LOADING EVENTS
	$('#loader-page').fadeOut(500, function () {$(this).remove() });
	// -> loading gallery
	$('.album').removeClass('loading');
	$('.galerie_photo').removeClass('loading');
	
	// CHARGEMENT DE LA PHOTO DE HEAD-PAGE SI ELLE EXISTE
	
	if($(document).find('#head-photo-tpl').length != 0) {
		var bgnd = $('#head-photo-tpl').attr('src');
		$('#head-photo').css('background-image', "url('" + bgnd +"')");
		$('#head-photo-tpl').remove();
	} else {
		$('#head-photo').css('background-image', "url(themes/bocognano/images/headphoto/headphoto_nopic.jpg)");
	}
});


// FUNCTIONS BUTTON SEARCH
function setSearchOn () {
	$('#search-button').unbind('click').addClass('active').children('a').bind('click', function () { setSearchOff() });
	$('#search-area #query').keypress(function () {
		if($(this).val() == $(this).data('placeholder')) {
			$(this).val('');
		}
	}).keyup(function () {
		if($(this).val() == '') {
			$(this).val($(this).data('placeholder'));
		}
	});
	$('#submit-query').click(function () {
		if( $('#search-area #query').val() != '' &&
    	    $('#search-area #query').val() != $('#search-area #query').data('placeholder')) {
			$('#search-area').submit()
		}
	});
	$('#search-area').slideDown(200, function () { $('#search-area #query').focus(); });
}
function setSearchHolder () {
}
function setSearchOff () {
	$('#search-button > a').unbind('click');
	$('#search-area').slideUp(200, function () {
		$('#search-button').removeClass('active').bind('click', function () { setSearchOn() });
	}).children('#query').blur();;
}


// UTILS
function photoResize (target, container, cropped) {
	$target = $(target);
	$container = $(container);
	var ratImg = $target.width()/$target.height();
	if(cropped == null || cropped != false) {
		if(ratImg >= ($container.width()/$container.height())) {
			$target.height($container.height()).width($container.height()*ratImg)
			.css('margin-left', ($container.width() - $target.width())/2);
		} else {
			$target.width($container.width()).height($container.width()/ratImg)
			.css('margin-top', ($container.height() - $target.height())/2);
		}
	} else {
		if(ratImg < ($container.width()/$container.height())) {
			$target.height($container.height()).width($container.height()*ratImg)
			.css('margin-left', ($container.width() - $target.width())/2);
		} else {
			$target.width($container.width()).height($container.width()/ratImg)
			.css('margin-top', ($container.height() - $target.height())/2);
		}
	}
}
