<?php
    global $scripts_extra, $_headerContent;


    function b_icon_file($name, $file, $classplus="") {
        $extension = strrchr($name,'.');
        switch ($extension) {
            case ".gif":
            case ".png":
            case ".jpg":
            case ".jpeg":
            case ".ai":
            case ".dxf":
            case ".tif":
            case ".tiff":
            case ".wmf":
            case ".ps":
            case ".eps":
                $icon = "fa fa-file-image-o fa-fw";
                break;
            case ".json":
            case ".php":
            case ".js":
            case ".css":
            case ".htm":
            case ".html":
                $icon = "fa fa-file-code-o fa-fw";
                break;
            case ".xls":
            case ".xlsx":
            case ".csv":
            case ".dbf":
            case ".ods":
            case ".sql":
                $icon = "fa fa-file-excel-o fa-fw";
                break;
            case ".ppt":
            case ".pptx":
            case ".pps":
            case ".pot":
            case ".potx":
            case ".odp":
                $icon = "fa fa-file-powerpoint-o fa-fw";
                break;
            case ".doc":
            case ".docx":
            case ".rtf":
            case ".odt":
            case ".pages":
                $icon = "fa fa-file-word-o fa-fw";
                break;
            case ".txt":
            case ".md":
                $icon = "fa fa-file-text-o fa-fw";
                break;
            case ".o":
            case ".og":
            case ".mp4":
            case ".webm":
            case ".mg":
            case ".mpg":
            case ".mov":
            case ".3gp":
                $icon = "fa fa-file-video-o fa-fw";
                break;
            case ".mp3":
            case ".wav":
            case ".m4a":
                $icon = "fa fa-file-audio-o fa-fw";
                break;
            case ".pdf":
                $icon = "fa fa-file-pdf-o fa-fw";
                break;
            case ".zip":
            case ".gz":
            case ".7z":
            case ".tar":
            case ".tgz":
            case ".rar":
                $icon = "fa fa-file-archive-o fa-fw";
                break;
            default:
                $icon = "fa fa-file-o fa-fw";;
                break;
        }
        return '<a href="'.$file.'" target="_blank"><i class="'.$icon." ".$classplus.' fa-lg" data-original-title="'.str_replace('"', '\"', $name).'" data-placement="bottom" data-toggle="tooltip"></i></a>';
    }
    
    function add_infos_bib($texte, $sep = ", ", $classe = "") {
        $sortie = "";
        
        if ($texte != "") {
            $sortie = $sep.$texte;
            if ($classe != "") {
                $sortie = '<span class="'.$classe.'">'.$sortie.'</span>';
            }
        }
        
        return $sortie;
    }
    function template_biblio($biblios) {
        global $currentlang;
        
        $sortie = '';
        if (count($biblios) > 0 ) {
            if ($currentlang == "french") {
                $sortie .= '<h4>Bibliographie trouve</h4>';
            }
            if ($currentlang == "italian") {
                $sortie .= '<h4>Bibliografia trovata</h4>';
            }
            $sortie .='<ul id="biblio">';
            foreach($biblios as $biblio) {
                $sortie .= '<li>';
                $sortie .= add_infos_bib(utf8_decode($biblio["auteur"]), "");
                $sortie .= add_infos_bib(utf8_decode($biblio["annee"]), ", ");
                $sortie .= add_infos_bib(utf8_decode($biblio["titre"]), " - ", "em");
                $sortie .= add_infos_bib(utf8_decode($biblio["journal"]).((utf8_decode($biblio["journal"]) != "" && utf8_decode($biblio["editeur"]) != "") ? " - " : "" ).utf8_decode($biblio["editeur"]), ". ");
                if ($biblio["tome"] != "" && $biblio["volume"] != "") {
                    $sortie .=  add_infos_bib($biblio["tome"]." (".utf8_decode($biblio["volume"].")"));
                }
                else {
                    $sortie .=  add_infos_bib(utf8_decode($biblio["tome"]));
                    $sortie .=  add_infos_bib(utf8_decode($biblio["volume"]));
                }
                if ($biblio["tome"] != "" || $biblio["volume"] != "") {
                    $sortie .=  add_infos_bib(utf8_decode($biblio["pages"]),":");
                }
                else {
                    $sortie .=  add_infos_bib(utf8_decode($biblio["pages"]));
                }
                if (count($biblio["fichiers"]) > 0) {
                    $sortie .= '&nbsp;';
                    $fichiers = $biblio["fichiers"];
                    foreach ($fichiers as $unficher) {
                        $sortie .= b_icon_file($unficher["nom"], $unficher["url"]);
                    }
                }
                $sortie .= '</li>';
            }
            $sortie .= '</ul>';
        }        
        return $sortie;
    }
    
    function conv2iso($texte) {
        $sortie = $texte;
        $sortie = str_replace("\\u2019", "'", $sortie);
        return $sortie;
    }
    
    /* Espces invasives */
    $taxons =  json_decode(conv2iso(file_get_contents("https://gaia.oec.fr/getdata.php?do=get_especes_inv&key=fea9a667df9db40499ebf94e5b6a07f6")), true)["result"]["data"];
    
    global $currentlang;
    if ($currentlang == "french") {
        $menu_espece = '<select size= "1" name="options[espece]">
    			<option value="" data-default>Espce : </option>';
        if ($espece != "") {
            $menu_espece .= '<option value="" >Aucune espce</option>';
        }
        foreach($taxons as $taxon) {
            $selected = '';
            if ($espece == $taxon["id_taxon"]) {
                $selected = ' selected="selected"';
            }
            $nomvern = "";
            if ($taxon["nom_vernaculaire"] != "") {
                $nomvern = ' - '.utf8_decode($taxon["nom_vernaculaire"]);
            }
            $menu_espece .= '<option value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($taxon["id_taxon"]).'"'.$selected.'>'.utf8_decode($taxon["nom_scientifique"]).$nomvern.'</option>';
        }
        $menu_espece .= '</select>';
        
        /* formulaire de recherche */
        $formulaire = '
                <form id="contact-form" action="mobiles.php" method="post">
    			    <div class="contact-form-loader"></div>
    			    <fieldset>
    			    	<label class="twocols">
    						<input type="text" name="options[auteur]" placeholder="Auteur :" value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($auteur).'">
    					</label>
    					<label class="twocols">
    						<input type="text" name="options[titre]" placeholder="Titre :" value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($titre).'">
    					</label>
    
    					<div>
    			    		<label class="twocols">
    			    			<input name="options[mot_clef]" placeholder="Mot_clef :" value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($mot_cle).'" type="text">
    			    		</label>
    			    		<label class="twocols">
    			    			<!-- <input name="options[espece]" placeholder="Espce :" value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($espece).'" type="text" > -->
                                '.$menu_espece.'
    			    		</label>
    			    	</div>
    					<div class="clear"></div>
    			    	<div id="brecaptcha">
            				<!-- <div class="g-recaptcha" data-size="compact" data-sitekey="'.$recaptcha_public.'"></div> -->
            				<a href="#" class="btn" data-type="submit_query"><i class="fa fa-book fa-fw fa-lg" aria-hidden="true">&nbsp;</i>Rechercher</a>
            			</div>
    			    </fieldset>
                    <input type="hidden" name="from_me" value="1">
                    <input type="hidden" name="name" value="SimpleBiblioExt">
    			</form>
                ';
    }
    if ($currentlang == "italian") {
        $menu_espece = '<select size= "1" name="options[espece]">
    			<option value="" data-default>Specie: </option>';
        if ($espece != "") {
            $menu_espece .= '<option value="" >Nessuna specie</option>';
        }
        foreach($taxons as $taxon) {
            $selected = '';
            if ($espece == $taxon["id_taxon"]) {
                $selected = ' selected="selected"';
            }
            $nomvern = "";
            if ($taxon["nom_vernaculaire"] != "") {
                $nomvern = ' - '.utf8_decode($taxon["nom_vernaculaire"]);
            }
            $menu_espece .= '<option value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($taxon["id_taxon"]).'"'.$selected.'>'.utf8_decode($taxon["nom_scientifique"]).$nomvern.'</option>';
        }
        $menu_espece .= '</select>';
        
        /* formulaire de recherche */
        $formulaire = '
                <form id="contact-form" action="mobiles.php" method="post">
    			    <div class="contact-form-loader"></div>
    			    <fieldset>
    			    	<label class="twocols">
    						<input type="text" name="options[auteur]" placeholder="Autore:" value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($auteur).'">
    					</label>
    					<label class="twocols">
    						<input type="text" name="options[titre]" placeholder="Titolo:" value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($titre).'">
    					</label>
    						    
    					<div>
    			    		<label class="twocols">
    			    			<input name="options[mot_clef]" placeholder="Parola chiave:" value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($mot_cle).'" type="text">
    			    		</label>
    			    		<label class="twocols">
    			    			<!-- <input name="options[espece]" placeholder="Specie:" value="'.utilFuncs_simpleBiblioExt::conditionnerFORM($espece).'" type="text" > -->
                                '.$menu_espece.'
    			    		</label>
    			    	</div>
    					<div class="clear"></div>
    			    	<div id="brecaptcha">
            				<a href="#" class="btn" data-type="submit_query"><i class="fa fa-book fa-fw fa-lg" aria-hidden="true">&nbsp;</i>Cercare</a>
            			</div>
    			    </fieldset>
                    <input type="hidden" name="from_me" value="1">
                    <input type="hidden" name="name" value="SimpleBiblioExt">
    			</form>
                ';
    }
    /* listing des biblios */
    
    if ($titre.$mot_cle.$espece.$auteur != "") {
        $params = "";
        if ($titre != "") {
            $params .= "&titre=".urlencode($titre);
        }
        if ($mot_cle != "") {
            $params .= "&mot_clef=".urlencode($mot_cle);
        }
        if ($espece != "") {
            $params .= "&espece=".urlencode($espece);
        }
        if ($auteur != "") {
            $params .= "&auteur=".urlencode($auteur);
        }
        $biblios =  json_decode(conv2iso(file_get_contents("https://gaia.oec.fr/getdata.php?do=get_biblio_inv&key=fea9a667df9db40499ebf94e5b6a07f6".$params)), true)["result"]["data"];
        
        if (count($biblios) > 0) {
            $listingb = template_biblio($biblios);
        }
        else {
            if ($currentlang == "french") {
                $listingb = '<p class="mt20">Aucune fiche bibliographique correspondante n\'a t trouv</p>';
            }
            if ($currentlang == "italian") {
                $listingb = '<p class="mt20">Non  stata trovata alcuna registrazione bibliografica corrispondente</p>';
            }
        }
    }
    else {
        global $from_me;
        if ($currentlang == "french") {
            if ($from_me == "1") {
                $listingb = '<p class="mt20">Il faut un peu plus de critres de recherche que cela...</p>';
            }
            else {
                $listingb = '<p class="mt20">Veuillez saisir un ou plusieurs critres ci-dessus pour effectuer la recherche</p>';
            }
        }
        if ($currentlang == "italian") {
            if ($from_me == "1") {
                $listingb = '<p class="mt20">Ci vogliono un po \'pi di criteri di ricerca di quello ...</p>';
            }
            else {
                $listingb = '<p class="mt20">Si prega di inserire uno o pi criteri sopra per la ricerca</p>';
            }
        }
    }
    
    if ($listingb != "") {
        $zoneresult = '<article class="content_gray">
                            <div class="container"><div class="row">
                                <div class="grid_12">
                        			'.$listingb.'
                        		</div>
                            </div></div></div>
                        </article>';    
    }
    else {
        $zoneresult = "";
    }
    if ($currentlang == "french") {
        $sortie = '<div class="container">
                <div class="row">
            		<div class="grid_12">
                        <h3>Recherche bibliographique</h3>
                        <p>Vous pourrez chercher ici toute la documentation rfrence par ALIEM sur les espces exotiques envahissantes.</p>
            			'.$formulaire.'
            		</div>
            	</div>
            </div>'.
            $zoneresult;
    }
    if ($currentlang == "italian") {
        $sortie = '<div class="container">
                <div class="row">
            		<div class="grid_12">
                        <h3>Ricerca bibliografica</h3>
                        <p>Puoi cercare qui tutta la documentazione referenziata da ALIEM sulle specie aliene invasive.</p>
            			'.$formulaire.'
            		</div>
            	</div>
            </div>'.
            $zoneresult;
    }
	
	require_once('themes/'.$Default_Theme.'/btn_retour.php');

	$_headerContent .= '
<script>
	var nosmoothscroll = true;
</script>
	';	
	
	$scripts_extra .= '
<script type="text/javascript" src="javascripts/lang/lang-french.js" charset="ISO-8859-1"></script>
<script type="text/javascript" src="javascripts/control_form.js" charset="ISO-8859-1"></script>
<script type="text/javascript" src="themes/aliem/js/jquery.growl.js"></script>
<link rel="stylesheet" href="themes/aliem/style/jquery.growl.css">
<link rel="stylesheet" href="themes/aliem/style/contact-form.css">
<script>
	function expedier_post(form) {
	    form.trigger("submit");
	}
	
	jQuery(function () {
		/* validation du post */
		if (jQuery("form [data-type=submit_query]").length > 0) {
			jQuery("form [data-type=submit_query]").click(function(){
				var form = jQuery(this).parents("form");
                expedier_post(form);
				/*if (submit_submit_query(form.get(0))) {
					if (desc_is_empty()) {
						alerte_erreur("Erreur","Veuillez remplir la zone de texte de votre post.", 5000);
					    return false;
					}
					if (jQuery("form [data-type=filesstate]").length > 0 && jQuery("form [data-type=filesstate]")[0].value == "") {
						alerte_erreur("Erreur","Tous vos fichiers n\'ont pas t envoys.<br />Envoyez-les tous ou supprimez-les.", 5000);
					    return false;
					}
					else {
						expedier_post(form);
					}
				}*/
				return false;
			});
		}
	});
	jQuery(function () {
		jQuery("#contact-form").on("keyup keypress", function(e) {
			var keyCode = e.keyCode || e.which;
			if (keyCode === 13) { 
				console.log("submit formulaire neutralis");
				e.preventDefault();
				return false;
			}
		});
	});
</script>
';
	 
	$sortie .= $btn_retour;
	
?>