
function editmap(coucheSavedAuto) {
  var _this = this;
  /**
   * Ensemble des strings affichés à l'utilisateur
   */
  this._strings = {
    fr : {
      alertErreurLineString : "Un chemin doit cooporter au minimum 2 coordonnées, layer supprimé..",
      layerCtrlNouveauxLayer : "Layers ajoutés",
      labelRectangle : "Rectangle",
      labelMarker : "Marker",
      labelLinestring : "Chemin",
      labelPolygon : "Polygon",
      title_btn_edit : "Editer l'élement",
      title_btn_focus : "Zoomer sur l'élement",
      title_btn_delete : "Supprimer l'élement",
      CustomPolygonContour : "Contour",
      CustomPolygonLargeurContour : "Largeur du contour",
      CustomPolygonCouleurRemplissage : "Couleur du remplissage",
      CustomPolygonOpaciteRemplissage : "Opacité du remplissage",
      layerControlCoucheAjoute : "Couches non sauvegardés",
      layerControlCoucheImportee : "Couches sauvegardés",
      title_btn_ajouterUnPolygon : "Ajouter un polygon",
      title_btn_ajouterUnPolygonRectangulaire : "rectangulaire (clicker-glisser le curseur)",
      title_btn_ajouterUnChemin : "Ajouter un chemin",
      title_btn_ajouterUnMarker : "Ajouter un marker",
      title_btn_regrouperCouchesAjoutees : "Sauvegarder les couches",
      title_btn_regrouperTouteCouchesAjoutees : "Sauvegarder tout",
      title_btn_regrouperMarker : "Regrouper les markers",
      title_btn_regrouperPolygon : "Regrouper les polygons",
      windowsconfirm_suppressionLayer : "Etes-vous sûr de vouloir supprimer cet élèment ?",
      labelLayerControl_editables : "Obersations"
    }
  };
  /**
   * retourne la string dans la langue courante (map_arob.langue);
   * @param {string} s 
   */
  this.getString = function(s){
    return _this._strings[map_arob.langue][s];
  };

  /**
   * Est le style par défaut d'un polygon crée par l'editeur de map
   */
  this.stylePolygonDefault = {
    color: "#111111",
    weight: 5,
    fillColor: "#111111",
    fillOpacity: 0.1 
  };

  /**
   * Est le style par défaut d'un polygon importé et non modifiable
   */
  this.styleBackgroundPolygonDefault = {
    color: "#2e6da4",
    weight: 2,
    fillColor: "#049fff",
    fillOpacity: 0.1
  };

  /**
   * Est le style de l'icon d'un marker lorsqu'il se trouve en mode édition
   */
  this.styleEditionMarker = {
    iconUrl: map_arob.CustomIconMarker._customRootPath+"map_arob-UImap_arob/map_arob.editmap/assets/marker-icon-edit.png",
    shadowUrl: map_arob.CustomIconMarker._customRootPath+"map_arob-UImap_arob/map_arob.editmap/assets/marker-shadow.png",
    iconSize: [30, 50],
    iconAnchor: [14, 50],
    popupAnchor: [1, -34],
    shadowSize: [50, 50]
  };

  /**
   * Est le style par default d'une line string générée
   */
  this.styleLineStringDefault = {
    color: "#FF2600",
    weight: 5
  };

  /**
   * Fonction à redefinir pour capturer les changements dans la map
   */
  this.changed = function() {
    console.log("Redefinir editmap.changed()");
  };

  this.isEditingTheLayers = function(e){
    console.log(e);
  }

  this._isEditingTheLayers = function(){
    var a = false;
    map_arob.editmap.theLayers.eachLayer(function(el){
      if(el.editEnabled()){
        a = true;
      }
    })
    this.isEditingTheLayers(a);
  }

  /**
   * Le layer crée et sauvegardé
   */
  this.theLayers = [];

  /**
   * Les layers de fond, non modifiables
   */
  this.BGLayers = [];

  /**
   * Les layers crée mais non sauvegardé
   */
  this.newLayers = [];

  /**
   * Le layer temporaire,le temps de l'édition
   */
  this.addedLayer = null;

  /**
   * Le bouton d'importation de fichier de donnée
   */
  _this.fileLayerLoad = null;
  

  /**
   * Retourne le Geojson de la carte
   */
  this.GET_geoJSON = function() {
    if (Object.keys(map_arob.editmap.theLayers).length !== 0) {
      return map_arob.editmap.theLayers.toGeoJSON();
    }
  };

  /**
   * Applique le style définit dans le marker, soit via le plugin CustomIconMarker, soit directement via son style, ou alors defaut
   * @param {feature} feature 
   * @param {layer} layer 
   */
  this._setStyleIcon = function(feature, layer){
    if(typeof feature.properties.style != "undefined" && feature.properties.style != ""){
      if(typeof map_arob.CustomIconMarker == "undefined"){console.error("map_arob.CustomIconMarker doit être importé");}
      
      if(typeof feature.properties.style["map_arob.CustomIconMarker.title"] != "undefined"){  
        /*Style definit par map_arob.CustomIconMarker*/              
        layer.setIcon(new L.Icon( map_arob.CustomIconMarker.getStyle( feature.properties.style["map_arob.CustomIconMarker.title"])));
      }else{
        /*Style definit en dur dans le geojson*/
        layer.setIcon(new L.Icon(feature.properties.style));
      }
    }else{
      //layer.setIcon(new L.Icon.Default());
      layer.setIcon(new L.Icon( map_arob.CustomIconMarker.getStyle("marker-icon-2x-green")));
      
    }
  };

  /**
   * Permet de nettoyer un import, retirer les multigeometry, multiPolygon etc
   * @param {string} geoPoly Geojson sous forme d'une string
   */
  function removeMultis(geoPoly){
    try {       
      var GJP =  new GeoJSONParser(geoPoly);
      var clean = GJP.geojson.exportNoMulti(false);
  } catch (e) {
      console.log(e);
  }
   
    
    return clean;
  }
  /**
   * Ajout un layer à partir d'un geojson, layer sauvegardé ou non et lui applique ses evenements d'édition
   * @param {object} geoPoly Geojson sous forme d'un objet json
   * @param {string} source String (theLayers ou newLayers)
   * @param {object} options {name : (string nom de la couche),}
   */
  this.SET_EditableGeojson = function(geoPoly, source, options) {
    var _defautOption = {
      name : _this.getString("labelLayerControl_editables"),
      changed : true
    };

    geoPoly = removeMultis(geoPoly);

    if(typeof options === "undefined"){
      var options = _defautOption;
    }else{
      if(typeof options.changed === "undefined"){
        options.changed = _defautOption.changed;
      }
      options.name = _defautOption.name;
    }
    
    if (geoPoly !== null && source !== null) {            
      /**
       * Les styles pour les geojson et linestring sont loadés à partir du styles.
       * Les styles des markers passe par 'eachfeature'
       */
      var geoJsonParseOptions =  {
        style: function(feature) {
          if (feature.properties.style != null && feature.properties.style != "") {
            return feature.properties.style;
          } else {
            if (feature.geometry.type == "LineString") {
              return _this.styleLineStringDefault;
            }
            return _this.stylePolygonDefault;
          }
        },
        autoZIndex: false,
        onEachFeature: function(feature, layer) {
          if(feature.geometry.type == "Point"){
            _this._setStyleIcon(feature, layer);
          }
        }
      };

      /**
       * Ajout les evenements d'édition à un layer et l'ajoute au groupe newLayers
       * @param {Layer} l 
       */
      function eventEditable(l){        
        l.off("click"); 
        l.editEnabled();
        l.on("dblclick", L.DomEvent.stop).on("dblclick", function(){
          l.toggleEdit();
          map_arob.editmap._isEditingTheLayers();
          $(".layerArobControl_edit[_leaflet_id='"+l._leaflet_id+"']").toggleClass('btn-warning');
          _this.changed();          
        });

        if (l instanceof L.Marker == false){
          l.on('click', function (e) {
            if ((e.originalEvent.ctrlKey || e.originalEvent.metaKey) && this.editEnabled()) {
              this.editor.newHole(e.latlng);
            }
          });
        }else{
          l.on('editable:enable',function (e){
            l.setIcon(new L.Icon(_this.styleEditionMarker))
          })
        } 

        l.on("contextmenu", function(e) {
          
          if (e.target.editEnabled()) {            
            e.target.closePopup();
            _this._setPopupEdit(e.target.feature, e.target);
            var popup = e.target.getPopup();
            popup.setLatLng(e.latlng).openOn(map_arob.map);
            l.off("click"); 


            if (l instanceof L.Marker == false){
              l.on('click', function (e) {
                console.log("--------------------- Click");
                if ((e.originalEvent.ctrlKey || e.originalEvent.metaKey) && this.editEnabled()) {
                  this.editor.newHole(e.latlng);
                }
              });
            }else{
              l.on('editable:enable',function (e){
                l.setIcon(new L.Icon(_this.styleEditionMarker))
              })
            }
          }else{
            l.toggleEdit();
            $(".layerArobControl_edit[_leaflet_id='"+l._leaflet_id+"']").toggleClass('btn-warning');
            map_arob.editmap._isEditingTheLayers();
          }
        });

        l.on("editable:editing", function(e) {
          //_this.changed();
        });

        l.on("editable:disable", function(e) {
          
          e.target.closePopup();
          l.off("click");
          if (l instanceof L.Marker){
            _this._setStyleIcon(l.feature, l);
          }
        }); 

        if(source == "newLayers"){
          _this.newLayers.addLayer(l);

          if(coucheSavedAuto){
            
            mnewLayersLength--;
            if(mnewLayersLength == 0){
              _this.mergeLayersAjouteeImportee()
            }
            
          }
        }
      }

      if(source == "theLayers"){
        
        /**
         * Parse le geojson pour transformer en editable les layers
         */

        map_arob.layerControl.removeLayer(_this.theLayers);
        _this.theLayers = new L.GeoJSON(geoPoly, geoJsonParseOptions).addTo(map_arob.map);
        map_arob.layerControl.addOverlay( _this.theLayers, options.name, {
          collapsed: false,
          autoZIndex: true
        });
        _this.theLayers.getLayers().forEach(eventEditable);
        
        _this.LayerArobControl.updateRow("theLayers");
        


        if(options.changed){
          _this.changed(); 
          map_arob.editmap._isEditingTheLayers();
        }
      }else
      if(source == "newLayers"){
        var mnewLayers = new L.GeoJSON(geoPoly, geoJsonParseOptions); 
        var mnewLayersLength = mnewLayers.getLayers().length;        
        mnewLayers.getLayers().forEach(eventEditable);
        _this.newLayersToControl();
        _this.LayerArobControl.updateRow("newLayers");

        if(coucheSavedAuto){
          map_arob.layerControl.removeLayer(map_arob.editmap.theLayers);
          map_arob.layerControl.addOverlay( _this.theLayers, options.name, {
            collapsed: false,
            autoZIndex: true
          });
        }
      }

      
      
      
    }
  };

  /**
   * 
   * @param {Geojson} geoPoly 
   */
  this.SET_backgroundGeojson = function(geoPoly) {
    if (geoPoly != null) {
      if (geoPoly.type == "FeatureCollection") {
        for (var i = 0, len = geoPoly.features.length; i < len; i++) {}

        var a = new L.GeoJSON(geoPoly, {
          style: function(feature) {
            if (typeof feature.properties.style != "undefined") {
              return feature.properties.style;
            } else {
              return _this.styleBackgroundPolygonDefault;
            }
          },onEachFeature: function(feature, layer) {
            if(feature.geometry.type == "Point"){
              _this._setStyleIcon(feature, layer);
            }
          }
        }).addTo(map_arob.map);

        _this.BGLayers.addLayer(a);

        if(typeof geoPoly.name == "undefined"){
          geoPoly.name = "Feature collection " + a._leaflet_id
        }
        a.options.name = geoPoly.name;
        /*map_arob.layerControl.addOverlay(a, geoPoly.name, {
          collapsed: false,
          autoZIndex: true
        });*/
        if(typeof map_arob.editmap.arob_controlOpacity != "undefined"){
          map_arob.editmap.arob_controlOpacity.ajoutLayer(false,map_arob.editmap.BGLayers.getLayers());
        }
        

        if(typeof _this.theLayers.bringToFront == "function"){
          _this.theLayers.bringToFront();
        }
      }else
      if(geoPoly.type == "Feature"){
        var a = new L.GeoJSON(geoPoly, {
          style: function(feature) {
            return _this.styleBackgroundPolygonDefault;
          },
          onEachFeature: function(feature, layer) {
            if(feature.geometry.type == "Point"){
              _this._setStyleIcon(feature, layer);
            }
          }
        }).addTo(map_arob.map);

        
        _this.BGLayers.addLayer(a);

        if(typeof geoPoly.name == "undefined"){
          geoPoly.name = "Feature collection"
        }
        /*
        map_arob.layerControl.addOverlay(a, geoPoly.name, {
          collapsed: false,
          autoZIndex: true
        });*/

        if(typeof a.bringToFront == "function"){

          a.bringToFront();
        }


      }
    }
  };

  this.DELETE_allEditableLayers = function(){
    map_arob.editmap.theLayers.getLayers().forEach(function(l){
      map_arob.map.removeLayer(l);
      map_arob.editmap.theLayers.removeLayer(l);
      map_arob.editmap.LayerArobControl.updateRow("theLayers");
    })


    map_arob.layerControl.removeLayer(map_arob.editmap.theLayers);

    map_arob.map.removeLayer(map_arob.editmap.theLayers);
    _this.changed();
  }

  this.DELETE_allBackgroundLayers = function(){
    map_arob.editmap.BGLayers.getLayers().forEach(function(l){
      map_arob.map.removeLayer(l);
      map_arob.editmap.BGLayers.removeLayer(l);
      if(typeof map_arob.editmap.arob_controlOpacity != "undefined"){
        map_arob.editmap.arob_controlOpacity.ajoutLayer(false,map_arob.editmap.BGLayers.getLayers())
      }
    })

  }

  this._setPopupEdit = function(feature, layer) {
    var popupOptions = { minWidth: 300 };
   
    

    if(feature.geometry.type == "Point"){
      var table ='<form class="custommarker"  _leaflet_id="' +layer._leaflet_id +'" >';
      var markerDispo = map_arob.CustomIconMarker.getList();
      table += '<span class="markerPopupTitle">Choix du marker</span>';
      table += '<div class="markerPopupLine">';

      markerDispo.forEach(function(m){
        table += '<label class="radio-inline">\
        <input type="radio" name="markerRadioPopup"  value="'+m.name+'">\
        <img src="'+m.url+'">\
      </label>';
      });
      
      table += '</div>';
      table += '<button type="button" class="btn btn-default btn-xs editionLayerPropInEditMap" onclick="map_arob.editLayerProperties.openLayerProperties('+layer._leaflet_id +')" indexfeature="0"><i class="fa fa-database" aria-hidden="true"></i>&nbsp;Données</button>';
      table += "<input type='submit' class='btn-primary'  style='float:right;' value='Sauvegarder'></button>";
      table += "<input type='button' class='btn-danger custompolygon_delete' style='float:right;margin-right:5px;'  _leaflet_id='"+layer._leaflet_id +"' value='Supprimer'></button>&nbsp;&nbsp;";
     
      table +='</form>';        
    }else{
      //Si le polygon a un style 
      if (typeof feature.properties.style == "object") {
        var s = feature.properties.style;
      } else {
        if (feature.geometry.type == "Polygon") {
          var s = _this.stylePolygonDefault;
        } else {
          var s = _this.styleLineStringDefault;
        }

        feature.properties.style = s;
      }
    
      var table ='<form class="custompolygon"  _leaflet_id="' +layer._leaflet_id +'" > <table class="table table-striped table-bordered">';
      table += "<tbody>";
        if (s.color != null) {
          table +=
            '<tr><th scope="row">'+_this.getString("CustomPolygonContour")+'</th><td>' +
            '<input type="color" idfeature="' +feature.id +'" styleGeo="color" name="color" value="' +
            s.color +
            '" />' +
            "</td></tr>";
        }
        if (s.weight != null) {
          table +=
            '<tr><th scope="row">'+_this.getString("CustomPolygonLargeurContour")+'</th><td>' +
            '<input type="number" min="0" max="10" step="1" idfeature="' +
            feature.id +
            '" styleGeo="weight" name="weight" value="' +
            s.weight +
            '" />' +
            "</td></tr>";
        }
        if (s.fillColor != null && feature.geometry.type == "Polygon") {
          table +=
            '<tr><th scope="row">'+_this.getString("CustomPolygonCouleurRemplissage")+'</th><td>' +
            '<input type="color" idfeature="' +
            feature.id +
            '" styleGeo="fillColor" name="fillColor" value="' +
            s.fillColor +
            '" />' +
            "</td></tr>";
        }
        if (s.fillOpacity != null && feature.geometry.type == "Polygon") {
          table +=
            '<tr><th scope="row">'+_this.getString("CustomPolygonOpaciteRemplissage")+'</th><td>' +
            '<input type="number" min="0" max="1" step="0.1" idfeature="' +
            feature.id +
            '" styleGeo="fillOpacity" name="fillOpacity" value="' +
            s.fillOpacity +
            '" />' +
            "</td></tr>";
        }      

      table += "</tbody>";
      table += "</table>";
      table +=
        "<input type='submit' class='btn-primary' value='Sauvegarder' style='float:right;'></button>";
      table +=
        "<input type='button' class='btn-danger custompolygon_delete' style='float:right;margin-right:5px;' _leaflet_id='"+layer._leaflet_id +"' value='Supprimer'></button>&nbsp;&nbsp;";
      
      table += '<button type="button" class="btn btn-default btn-xs editionLayerPropInEditMap" onclick="map_arob.editLayerProperties.openLayerProperties('+layer._leaflet_id +')" indexfeature="0"><i class="fa fa-database" aria-hidden="true"></i>&nbsp;Données</button>';
      table += "</form>";

       
    }

    layer.bindPopup(table, popupOptions);
  };

  this.updateStylePolygon = function(s, layer) {
    var style = {};

    for (var i = 0, len = s.length; i < len; i++) {
      if (s[i].name == "color") {
        style.color = s[i].value;
      }
      if (s[i].name == "weight") {
        style.weight = parseInt(s[i].value);
      }
      if (s[i].name == "fillColor") {
        style.fillColor = s[i].value;
      }
      if (s[i].name == "fillOpacity") {
        style.fillOpacity = s[i].value;
      }
    }
    layer.feature.properties.style = style;
    layer.setStyle(style);

    _this._setPopupEdit(layer.feature, layer);
    _this.changed();
    map_arob.editmap._isEditingTheLayers();
  };

  this.updateStyleMarker = function(s, layer){
    var style = {};
    for (var i = 0, len = s.length; i < len; i++) {
      if(s[i].name == "markerRadioPopup"){
        style = map_arob.CustomIconMarker.getStyle(s[i].value);
        layer.feature.properties.style = {};
        layer.feature.properties.style["map_arob.CustomIconMarker.title"] = s[i].value;
      }
    }

    layer.setIcon(new L.Icon( style ));
    _this.changed();
    map_arob.editmap._isEditingTheLayers();
  }

  this.createALayer = function(type) {
    if (type == "LineString") {
      var refLayer = map_arob.map.editTools.startPolyline();
      _this.addedLayer.addLayer(refLayer); 
      
      refLayer.on("editable:drawing:end", function(e) {
        //validation lineString
        refLayerEnJson = refLayer.toGeoJSON();
        if (refLayerEnJson.geometry.coordinates.length <= 1) {
          
          map_arob.map.removeLayer(refLayer);
          _this.addedLayer.removeLayer(refLayer);
        } else {

          var geo = refLayer.toGeoJSON();
          map_arob.map.removeLayer(refLayer);
          _this.addedLayer.removeLayer(refLayer);

          _this.SET_EditableGeojson(geo, "newLayers", {changed : false});
          
        }
      });      
    } 
    
    
    else if (type == "Rectangle" || type == "Polygon") {
      if(type =="Rectangle"){
        var refLayer = map_arob.map.editTools.startRectangle();
      }

      if(type == "Polygon"){
        var refLayer = map_arob.map.editTools.startPolygon()
      }
      
      _this.addedLayer.addLayer(refLayer);

      refLayer.on("editable:drawing:end", function(e) {
        var geo = refLayer.toGeoJSON();
        
        map_arob.map.removeLayer(refLayer);
        _this.addedLayer.removeLayer(refLayer);

        if(geo.geometry.coordinates[0].length >= 3){
          _this.SET_EditableGeojson(geo, "newLayers", {changed : false});
        }

      });
    }
    
    
    else if (type == "Marker"){
      var refLayer = map_arob.map.editTools.startMarker();

      _this.addedLayer.addLayer(refLayer);

      refLayer.on("editable:drawing:end", function(e) {      
        var geo = refLayer.toGeoJSON();
        map_arob.map.removeLayer(refLayer);
        _this.addedLayer.removeLayer(refLayer);

        _this.SET_EditableGeojson(geo, "newLayers", {changed : false});         

      });


    }
  };

  this.newLayersToControl = function() {
    if (_this.newLayers.getLayers().length == 1) {
     /* map_arob.layerControl.removeLayer(_this.newLayers);
      map_arob.layerControl.addOverlay(_this.newLayers, _this.getString("layerCtrlNouveauxLayer"), {
        collapsed: false,
        autoZIndex: true
      });*/
      
    }

    setTimeout(function(){
      map_arob.layerControl.expand();
    }, 1)
    
  };


  this._redIcon = new L.Icon({
    iconUrl: "leaflet/images/marker-icon-2x-red.png",
    shadowUrl: "leaflet/images/marker-shadow.png",
    iconSize: [25, 41],
    iconAnchor: [12, 41],
    popupAnchor: [1, -34],
    shadowSize: [41, 41]
  });

  this.LayerArobControl = {
    init : function(){
      $(".leaflet-bottom.leaflet-right").append(
        '<div id="newLayersArobControl" style="display:none;" class="leaflet-control editmap">' +
          "<div style='text-align: center; max-height: 300px;overflow: auto;'>" +
            "<div class='showHide' >"+_this.getString('layerControlCoucheAjoute')+"&nbsp;<i class='fa fa-chevron-circle-up' style='float: right;padding-right: 5px;padding-top: 3px;' aria-hidden='true'></i></div>" +
            '<div class="zonebtn">'+
              '<button title="'+_this.getString("title_btn_focus")+'" type="button" class="btn btn-default btn-sm  _mergeSelectedMarker actioncouche" >'+_this.getString("title_btn_regrouperCouchesAjoutees")+'<i class="fa fa fa-compress fa-fw" aria-hidden="true"></i></button><br>'+           
              '<button title="'+_this.getString("title_btn_focus")+'" type="button" class="btn btn-default btn-sm _mergeLayerBtn actioncouche" >'+_this.getString("title_btn_regrouperTouteCouchesAjoutees")+'</button><br>'+
              '<!--<button title="'+_this.getString("title_btn_focus")+'" type="button" class="btn btn-default btn-sm _mergeSelectedPolygon actioncouche" >'+_this.getString("title_btn_regrouperPolygon")+'</button> -->'+           
            '</div>' +
            '<table class="table ">' +
              "<tbody>" +
              "</tbody>" +
            "</table>" +
            
            "</div>" +
        "</div>"
      );

      $(".leaflet-bottom.leaflet-right").append(
        '<div id="importedLayerArobControl" style="display:none;" class="leaflet-control editmap">' +
          "<div style='text-align: center; max-height: 300px;overflow: auto;min-width: 250px;'>" +
          "<div class='showHide'>"+_this.getString('layerControlCoucheImportee')+"&nbsp;<i class='fa fa-chevron-circle-up' style='float: right;padding-right: 5px;padding-top: 3px;' aria-hidden='true'></i></div>" +
          '<table class="table ">' +
          "<tbody>" +
          "</tbody>" +
          "</table>" +
          "</div>" +
          "</div>"
      );
    },
    updateRow : function(layername){
      var mlayers = null;
      if(layername == "newLayers"){
        var id = "newLayersArobControl";

        if(_this.newLayers.getLayers().length > 0){        
          mlayers = _this.newLayers.getLayers()
        }
      }

      if(layername == "theLayers"){
        var id = "importedLayerArobControl";

        if(_this.theLayers.getLayers().length > 0){        
          mlayers = _this.theLayers.getLayers()
        }
      }

      $("#"+id+"").show();
      $("#"+id+" tbody").html("");  

      if(mlayers != null){
        var index = 0;
        mlayers.forEach(function(element){
          index++;
          var typeShape = "";
          var _typeshape = "L.Polygon";
          if(element.editEnabled()){
            element.disableEdit();
          }
          if(element instanceof L.Rectangle){
            typeShape = _this.getString("labelRectangle");
          }else
          if(element instanceof L.Polygon){            
            typeShape = _this.getString("labelPolygon");
            if(element.toGeoJSON().geometry.type == "MultiPolygon"){
              typeShape = "MultiPolygon";
            }
          }else
          if(element instanceof L.Polyline){
            var _typeshape = "L.Polyline";
            typeShape = _this.getString("labelLinestring");
          }else
          if(element instanceof L.Marker){
            var _typeshape = "L.Marker";
            typeShape = _this.getString("labelMarker");
          }
          
          if(typeShape == ""){
            typeShape = element.toGeoJSON().geometry.type;
          }
          
          var displaycheckbox = '<span style="display: inline-block;">&nbsp;</span>';
          if(id == "newLayersArobControl"){
            displaycheckbox = '<input type="checkbox" class="updateRowcheckbox" typeGeo="'+_typeshape+'" _leaflet_id="'+element._leaflet_id+'">';
          }
          var s = 
            '<tr>'+
              '<td scope="row" style="padding-left:0px; padding-right:0px;">'+
                displaycheckbox+
                '<span style="padding-right:15px;font-weight:bold;">'+index +'</span>'+
                '<span class="labelArobControl">'+typeShape +'</span>'+
                '<button title="'+_this.getString("title_btn_focus")+'" type="button" class="btn btn-default btn-xs  layerArobControl_focus" _leaflet_id="'+element._leaflet_id+'" ><i class="fa fa fa-eye fa-fw" aria-hidden="true"></i></button> '+           
                '<button title="'+_this.getString("title_btn_edit")+'" type="button" class="btn btn-default btn-xs  layerArobControl_edit" _leaflet_id="'+element._leaflet_id+'" ><i class="fa fa-pencil-square-o fa-fw" aria-hidden="true"></i></button> '+
                '<button title="'+_this.getString("title_btn_delete")+'" type="button" class="btn btn-danger btn-xs  layerArobControl_delete" _leaflet_id="'+element._leaflet_id+'" ><i class="fa fa-trash-o fa-fw" aria-hidden="true"></i></button> '+
              '</td>'+
            '</tr>';
  
            $("#"+id+" tbody").append(s);
        }); 
      }else{
        $("#"+id+"").hide();
        map_arob.map.scrollWheelZoom.enable();
        map_arob.map.doubleClickZoom.enable();
      }           
    }
  }

  this.setFileLayerLoad = function(mFileLayerLoad){
    if(mFileLayerLoad instanceof L.Control.FileLayerLoad){
      _this.fileLayerLoad = mFileLayerLoad;
    }else{
      throw  "function setFileLayerLoad, le pamarètre n'est pas un objet L.Control.FileLayerLoad "
    }
  }

  this.disableAllEasyButton = function(){
    if(_this.easyButtonPolygon != null){_this.easyButtonPolygon.disable();}
    if(_this.easyButtonRectangle != null){_this.easyButtonRectangle.disable();}
    if(_this.easyButtonLineString != null){_this.easyButtonLineString.disable();}
    if(_this.easyButtonMarker != null){_this.easyButtonMarker.disable();}
    if(_this.fileLayerLoad != null){_this.fileLayerLoad.getContainer().classList.add("disabled")}
  }

  this.enableAllEasyButton = function(){
    if(_this.easyButtonPolygon != null){_this.easyButtonPolygon.enable();}
    if(_this.easyButtonRectangle != null){_this.easyButtonRectangle.enable();}
    if(_this.easyButtonLineString != null){_this.easyButtonLineString.enable();}
    if(_this.easyButtonMarker != null){_this.easyButtonMarker.enable();}
    if(_this.fileLayerLoad != null){_this.fileLayerLoad.getContainer().classList.remove("disabled")}
  }

  this.deleteLayerClickButton = function(event){
    event.preventDefault();
    
    if (window.confirm(_this.getString("windowsconfirm_suppressionLayer"))) {
      var l = _this.theLayers.getLayer($(this).attr("_leaflet_id"));      
      if(typeof l != "undefined"){
        if(l.editEnabled()){
          l.toggleEdit();
        }
        _this.theLayers.removeLayer(l);
        _this.LayerArobControl.updateRow("theLayers");
      }else{
        var l = _this.newLayers.getLayer($(this).attr("_leaflet_id"));    
        if(l.editEnabled()){
          l.toggleEdit();
        }    
          _this.newLayers.removeLayer(l);
          _this.LayerArobControl.updateRow("newLayers");        
      }
      map_arob.map.removeLayer(l);
      _this.changed();
      map_arob.editmap._isEditingTheLayers();
    }

    map_arob.map.scrollWheelZoom.enable();
    map_arob.map.doubleClickZoom.enable();
    
  }
  this.editLayerClickButton = function(event){
    var l = _this.newLayers.getLayer($(this).attr("_leaflet_id"));
    if(typeof l == "undefined"){
      var l = _this.theLayers.getLayer($(this).attr("_leaflet_id"));  
      _this.changed();      
    }

    if(typeof l != "undefined"){
      l.toggleEdit();
      map_arob.editmap._isEditingTheLayers();
      $(this).toggleClass("btn-warning")
    }
  }

  /**
   * 
   * @param {string nom du featureGroup "theLayers, BGLayers, newLayers"} nameLayersGroup 
   * @param {int index dans le featureGroup, -1 pour le dernier} index 
   */
  this.focusWithIndex = function(nameLayersGroup, index){
    if(nameLayersGroup == "theLayers"){
      var l = _this.theLayers;
    }else
    if(nameLayersGroup == "BGLayers"){
      var l = _this.BGLayers;
    }else
    if(nameLayersGroup == "newLayers"){
      var l = _this.newLayers;
    }

    var llenght = l.getLayers().length;
    if(index == -1){
      if(llenght != 0){
        var lay = l.getLayers()[llenght - 1];    
      }
    }else
    if(index < llenght){
      var lay = l.getLayers()[index];
    }else{
      console.error("focusWithIndex impossible sur "+nameLayersGroup+" avec l'index : "+index);
    }    

    if(typeof lay != "undefined"){
      if (lay instanceof L.Marker == false){
        var bounds = lay.getBounds();          
        map_arob.map.fitBounds(bounds);
        /*
        setTimeout(function(){
          var z = map_arob.map.getZoom();
          if(z > 4){
            map_arob.map.setZoom(z - 2);
          }
        },10) */
      }else{
        map_arob.map.setView(lay.getLatLng(),14)
      }        
    } 
  }

  /**
   * 
   * @param {*} options 
   */

  this.mergeLayersAjouteeImportee = function(){
    var getL = _this.newLayers.getLayers(); 
      getL.forEach(function(l){
        l.disableEdit();        
        _this.theLayers.addLayer(l);
       // _this.LayerArobControl.updateRow("theLayers"); 
       //_this.LayerArobControl.updateRow("newLayers"); 
      });

      _this.newLayers.getLayers().forEach(function(l){        
        _this.newLayers.removeLayer(l);
        //_this.LayerArobControl.updateRow("newLayers"); 
        map_arob.map.addLayer(l);
      });
      _this.LayerArobControl.updateRow("newLayers"); 
      _this.LayerArobControl.updateRow("theLayers"); 
      _this.changed();
      map_arob.editmap._isEditingTheLayers();
  }
  this.init = function(options) {
    //Droit d'auteur en fonction de la carte

    this.displayControlBackground = true;

    if (typeof options == "object") {
      if (typeof options.stylePolygonDefault == "object") {
        this.stylePolygonDefault = options.stylePolygonDefault;
      }
      if (typeof options.styleBackgroundPolygonDefault == "object") {
        this.styleBackgroundPolygonDefault = options.styleBackgroundPolygonDefault;
      }
      if (typeof options.styleLineStringDefault == "object") {
        this.styleLineStringDefault = options.styleLineStringDefault;
      }

      if (typeof options.displayControlBackground == "boolean"){
        this.displayControlBackground = options.displayControlBackground;
      }

      if(typeof options.strings == "object"){
        for (var k in options.strings){
          for(var kk in options.strings[k]){
            _this._strings[k][kk] = options.strings[k][kk];
          };
        }
      }
    }


    var mmap = map_arob.map;

    var buttonsEdtionHTML = {
      "Polygon" : '<span class="Polygon"></span>',
      "Rectangle" : '<span class="Rectangle" ></span>',
      "LineString" : '<span class="LineString"></span>',
      "Marker" : '<span class="Marker"></span>'
    }

    _this.easyButtonPolygon = null; 
    _this.easyButtonRectangle = null;
    _this.easyButtonLineString = null;
    _this.easyButtonMarker = null;
    if (typeof options.buttonsEdition == "object") {
      for(var i = 0, l = options.buttonsEdition.length; i < l; i++ ){
        switch (options.buttonsEdition[i]) {
          case 'Polygon':
            _this.easyButtonPolygon = L.easyButton( buttonsEdtionHTML["Polygon"], function(){_this.createALayer("Polygon");},_this.getString("title_btn_ajouterUnPolygon") ).addTo(mmap);
            break;
          case 'Rectangle':
            _this.easyButtonRectangle = L.easyButton( buttonsEdtionHTML["Rectangle"], function(){_this.createALayer("Rectangle");},_this.getString("title_btn_ajouterUnPolygonRectangulaire")).addTo(mmap);
            break;
          case 'LineString':
            _this.easyButtonLineString = L.easyButton( buttonsEdtionHTML["LineString"], function(){_this.createALayer("LineString");},_this.getString("title_btn_ajouterUnChemin")).addTo(mmap);
            break;
          case 'Marker':
            _this.easyButtonMarker = L.easyButton( buttonsEdtionHTML["Marker"], function(){_this.createALayer("Marker");},_this.getString("title_btn_ajouterUnMarker")).addTo(mmap);
            break;
        }
      }
    }else{
      // Bouton d'édition par default
      _this.easyButtonPolygon = L.easyButton( buttonsEdtionHTML["Polygon"], function(){_this.createALayer("Polygon");}).addTo(mmap);
      _this.easyButtonRectangle = L.easyButton( buttonsEdtionHTML["Rectangle"], function(){_this.createALayer("Rectangle");}).addTo(mmap);
      _this.easyButtonLineString = L.easyButton( buttonsEdtionHTML["LineString"], function(){_this.createALayer("LineString");}).addTo(mmap);
      _this.easyButtonMarker = L.easyButton( buttonsEdtionHTML["Marker"], function(){_this.createALayer("Marker");}).addTo(mmap);
    }
    

    

    /**
     * Dom Evenement suppression d'un layer
     * @param {*} event 
     */
    function focusLayerClickButton(event){
      /*var btn = $(this);
      btn.prop('disabled', true);
      setTimeout(function(){
          btn.prop('disabled', false);
      }, 5*1000);*/

      var l = _this.newLayers.getLayer($(this).attr("_leaflet_id"));
      if(typeof l == "undefined"){
        var l = _this.theLayers.getLayer($(this).attr("_leaflet_id"));       
      }

      if(typeof l != "undefined"){
        if (l instanceof L.Marker == false){
          var bounds = l.getBounds();          
          map_arob.map.fitBounds(bounds);
          
          /*setTimeout(function(){
            var z = map_arob.map.getZoom();
            if(z > 4){
              map_arob.map.setZoom(z - 2);
            }
          },10) */
        }else{
          map_arob.map.setView(l.getLatLng(),16)
        }        
      }      
    }

    function mergeLayersAjouteeImportee(event){
      _this.mergeLayersAjouteeImportee();
    }

    /**
     * Regroupe les markers des couches non sauvegardés en MultiPoint
     * @param {Jquery.Event} event 
     */
    function mergeLayersAjouteeImporteeSelectionnee(event){
      var multipoint = [];
      var LtoRemove = [];
      $("input[type=checkbox].updateRowcheckbox").each(function(){
        if(($(this).is(':checked'))){
          var l = _this.newLayers.getLayer($(this).attr("_leaflet_id"));
          l.disableEdit(); 
          _this.theLayers.addLayer(l);
        };        
      });

      $("input[type=checkbox].updateRowcheckbox").each(function(){
        if(($(this).is(':checked'))){
          var l = _this.newLayers.getLayer($(this).attr("_leaflet_id"));
          _this.newLayers.removeLayer(l);
          l.disableEdit(); 
          //_this.LayerArobControl.updateRow("newLayers"); 
          map_arob.map.addLayer(l);
        };        
      });

      _this.LayerArobControl.updateRow("newLayers"); 
      _this.LayerArobControl.updateRow("theLayers"); 
      _this.changed();
      map_arob.editmap._isEditingTheLayers();
           
    }

    /**
     * Regroupe les markers des couches non sauvegardés en MultiPoint
     * @param {Jquery.Event} event 
     */
    function mergeSelectedMarker(event){
      var multipoint = [];
      var LtoRemove = [];
      $("input[type=checkbox].updateRowcheckbox").each(function(){
        if(($(this).is(':checked'))){
          var l = _this.newLayers.getLayer($(this).attr("_leaflet_id"));
          if(l instanceof L.Marker){
            multipoint.push([l["_latlng"]["lng"], l["_latlng"]["lat"]]);
            //multipoint.push(l.feature);
            map_arob.map.removeLayer(l);
            _this.newLayers.removeLayer(l);      
          }         
        };        
      });
      if(multipoint.length>0){
        var tg = {"type": "Feature","geometry": {"type": "MultiPoint","coordinates": multipoint},"properties": {}};
        //var tg = {"type": "FeatureCollction", features : multipoint};
        _this.SET_EditableGeojson(tg, "newLayers"); 
      }
           
    }

    /**
     * Regroupe les polygons selectionnés des couches non sauvegardés en MultiPolygon
     * @param {*} event 
     */
    function mergeSelectedPolygon(event){
      var multipolygon = [];
      $("input[type=checkbox].updateRowcheckbox").each(function(){
        if(($(this).is(':checked'))){
          var l = _this.newLayers.getLayer($(this).attr("_leaflet_id"));
          if(l instanceof L.Polygon){
            multipolygon.push(l.feature.geometry.coordinates);
            map_arob.map.removeLayer(l);
            _this.newLayers.removeLayer(l) 
          }          
        };        
      });

      if(multipolygon.length>0){
        var tg = {"type": "Feature","geometry": {"type": "MultiPolygon","coordinates": multipolygon},"properties": {}};      
        _this.SET_EditableGeojson(tg, "newLayers"); 
      }
       
    }

    /**
     * Evenement "sauvegarde" du style d'un polygon
     * @param {*} event 
     */
    function submitFormCustomPolygon(event) {
      event.preventDefault();
      var data = $(".custompolygon :input").serializeArray();
      var l = _this.theLayers.getLayer($(this).attr("_leaflet_id"));
      if(typeof l == "undefined"){
        //c'est un newlayer
        var l = _this.newLayers.getLayer($(this).attr("_leaflet_id"));
      }
      _this.updateStylePolygon(data, l);
      _this.changed();
      map_arob.editmap._isEditingTheLayers();
    }

    /**
     * Evenement "sauvegarde" du style d'un marker
     * @param {*} event 
     */
    function submitFormCustomMarker(event) {
      event.preventDefault();
      var data = $(".custommarker :input").serializeArray();
      var l = _this.theLayers.getLayer($(this).attr("_leaflet_id"));
      if(typeof l == "undefined"){
        //c'est un newlayer
        var l = _this.newLayers.getLayer($(this).attr("_leaflet_id"));
      }
      _this.updateStyleMarker(data, l);
      l.toggleEdit();
      map_arob.editmap._isEditingTheLayers();
    }
    
    /**
     * Affichage/reduction du tableau de layer de couche ajouté ou sauvegardé
     */

    function showHideRows(event){      
      $(this).find()
      $(this).nextAll(".table").toggle();

      var ic = $(this).find("i");
      ic.toggleClass("fa-chevron-circle-up");
      ic.toggleClass("fa-chevron-circle-down");
    }

    this.hideRowsLeaftletControlEditmap = function(){
      $('.leaflet-control.editmap .showHide').nextAll(".table").hide();
    }
    this.showRowsLeaftletControlEditmap = function(){
      $('.leaflet-control.editmap .showHide').nextAll(".table").show();
    }

    L.Control.Arob_controlOpacity =  L.Control.extend({
     
      onAdd: function (map) {
        return this.ajoutLayer(true, [])
      },

      ajoutLayer : function(create, data){
        if(create){
          L.control.arob_controlOpacity.container = L.DomUtil.create('div', 'Arob_controlOpacity');
          L.DomEvent.disableClickPropagation(L.control.arob_controlOpacity.container);
          L.control.arob_controlOpacity.container.onmouseover = function(e){            
            L.control.arob_controlOpacity.container.style.height = 'auto'; 
            L.control.arob_controlOpacity.container.style.width = 'auto'; 
            L.control.arob_controlOpacity.container.style.overflow = 'scroll'; 
          }
          L.control.arob_controlOpacity.container.onmouseout = function(){
            L.control.arob_controlOpacity.container.style.height = ''; 
            L.control.arob_controlOpacity.container.style.width = ''; 
            L.control.arob_controlOpacity.container.style.overflow = 'hidden'; 
          }
        }
        
        var s = '<div class="leaflet-control-layers " aria-haspopup="true">\
        <div style="padding: 5px;">Couches de fond</div>';

        s += '<div style="border-top: 2px solid rgba(0,0,0,0.2);">';
        for(var i = 0, len = data.length; i < len; i++){
          console.log(data[i]);
          var mt ="";
          var separator = '<div class="leaflet-control-layers-separator" style=""></div>';          
          if(i == 0){
            mt = "margin-top:5px;";
          }

          if(i == len - 1){
            separator = "";
            mt+="margin-bottom:5px;";
          }
          s += '<div style="padding:5px;'+mt+'">'+data[i].options.name+ '&nbsp; \
          <button title="Editer l\'élement" type="button" class="btn btn-default btn-xs  arob_controlOpacityToggleVisibilty" _leaflet_id="'+data[i]._leaflet_id+'" style="outline: none;float: right;"><i class="fa fa-eye fa-fw" aria-hidden="true"></i></button>\
          <button title="'+_this.getString("title_btn_delete")+'" type="button" class="btn btn-danger btn-xs  arob_controlOpacity_Delete" _leaflet_id="'+data[i]._leaflet_id+'"style="outline: none;float: right;" ><i class="fa fa-trash-o fa-fw" aria-hidden="true"></i></button>\
          <input type="range" _leaflet_id="'+data[i]._leaflet_id+'" name="opacity" min="0" max="100" value="100" step="10">\
          </div>'+separator;
        }
        s += "</div>";
        
        L.control.arob_controlOpacity.container.innerHTML = s + "</div>"; 

        if(data.length == 0){
          map_arob.map.scrollWheelZoom.enable();
          map_arob.map.doubleClickZoom.enable();
        }
    
        return L.control.arob_controlOpacity.container;
      }
    });

    L.control.arob_controlOpacity = function(opts){
      return new L.Control.Arob_controlOpacity(opts);
    }
    L.control.arob_controlOpacity.toggle = function(event){
      //console.log($(this).attr('_leaflet_id'));
      var l = map_arob.editmap.BGLayers.getLayer($(this).attr('_leaflet_id'));
      if( map_arob.map.hasLayer(l) ){
        map_arob.map.removeLayer(l);
        $(this).find("i").addClass("fa-eye-slash");
        $(this).addClass("btn-warning");
      }else{
        map_arob.map.addLayer(l);
        $(this).find("i").removeClass("fa-eye-slash");
        $(this).removeClass("btn-warning");
      }     
    }

    L.control.arob_controlOpacity.delete = function(event){
      //console.log($(this).attr('_leaflet_id'));
      var l = map_arob.editmap.BGLayers.getLayer($(this).attr('_leaflet_id'));
      
        map_arob.map.removeLayer(l);
        map_arob.editmap.BGLayers.removeLayer(l);
        map_arob.editmap.arob_controlOpacity.ajoutLayer(false,map_arob.editmap.BGLayers.getLayers())
        
    }

    L.control.arob_controlOpacity.changeOpacity = function(event){
      var v = $(this).val() / 100;
      var layers = map_arob.editmap.BGLayers._layers[$(this).attr('_leaflet_id')]; 
      
      layers.getLayers().forEach(function(l){        
        
        if(typeof l.setOpacity == "function"){          
          l.setOpacity(v)
        }else{
          var vOpacity = v;
          var vFillOpacity = v;

          if(typeof l.feature.properties != "undefined"){
            if(typeof l.feature.properties.style != "undefined"){
              if(typeof l.feature.properties.style.fillOpacity != "undefined"){
                vFillOpacity = l.feature.properties.style.fillOpacity * v;
              }
            }
          }


          l.setStyle({"fillOpacity" : vFillOpacity, "opacity":v})
        }
      })
      
    }

    if(_this.displayControlBackground == true){
      _this.arob_controlOpacity = L.control.arob_controlOpacity(["e"],{ position: 'topright' }).addTo(map_arob.map);
    }
    

    // Les formulaires dans les popup d'edition
    $("#map").on("submit", ".custompolygon", submitFormCustomPolygon);
    $("#map").on("submit", ".custommarker", submitFormCustomMarker);
    $("#map").on("click", ".custompolygon_delete", _this.deleteLayerClickButton);

    // Desactiver les scrolls dans la map au dessus du ArobControl
    $( "#map" ).on( "mouseenter","#importedLayerArobControl, #newLayersArobControl, .Arob_controlOpacity", function() {
        map_arob.map.scrollWheelZoom.disable();
        map_arob.map.doubleClickZoom.disable()
    }).on( "mouseleave","#importedLayerArobControl, #newLayersArobControl, .Arob_controlOpacity", function() {
        map_arob.map.scrollWheelZoom.enable();
        map_arob.map.doubleClickZoom.enable()
    });

    // Evenement des boutons du ArobControl
    $("#map").on("click", ".layerArobControl_delete", _this.deleteLayerClickButton);
    $("#map").on("click", ".layerArobControl_edit", _this.editLayerClickButton);
    $("#map").on("click", ".layerArobControl_focus", focusLayerClickButton);
    $("#map").on('click', '._mergeLayerBtn', mergeLayersAjouteeImportee);
    $("#map").on('click', '._mergeSelectedMarker', mergeLayersAjouteeImporteeSelectionnee);
    $("#map").on('click', '._mergeSelectedPolygon', mergeSelectedPolygon);

    // Evenement des boutons du arob_controlOpacity
    $("#map").on('click', '.arob_controlOpacityToggleVisibilty', L.control.arob_controlOpacity.toggle);
    $("#map").on('click', '.arob_controlOpacity_Delete',L.control.arob_controlOpacity.delete);
    $("#map").on('input', '.Arob_controlOpacity input[type=range]', L.control.arob_controlOpacity.changeOpacity);
    
    

    $("#map").on('click', '.leaflet-control.editmap .showHide', showHideRows);

    _this.LayerArobControl.init();
    _this.addedLayer = L.featureGroup([]).addTo(mmap);
    _this.newLayers = L.featureGroup([]).addTo(mmap);
   
    _this.theLayers = L.featureGroup([]).addTo(mmap);
    _this.BGLayers = L.featureGroup([]).addTo(mmap);

    if(!coucheSavedAuto){
      map_arob.layerControl.addOverlay(_this.newLayers, "Couches non sauvegardés", {
        collapsed: false,
        autoZIndex: true
      });
    }
    

    
/*
    map_arob.layerControl.addOverlay(_this.theLayers, "Couches sauvegardés", {
      collapsed: false,
      autoZIndex: true
    });*/

    if(typeof map_arob.screenshot != "undefined"){
      map_arob.screenshot.editableLayers = [];
      map_arob.screenshot.editableLayers.push(_this.theLayers);
      map_arob.screenshot.editableLayers.push(_this.newLayers);
    }

    //map_arob.map.addControl(new Arob_controlOpacity());
   
  };
}
map_arob.map.editTools = new L.Editable(map_arob.map, {});