var startPoint = [42.2, 9];
var map = L.map("map_accueil", {editable: true, doubleClickZoom: false}).fitWorld().setView(startPoint, 9);

map.options.minZoom = 3;
//map.options.maxZoom = 19;

map.addControl(new L.Control.Fullscreen({
    title: {
        "false": "Plein écran",
        "true": "Réduire"
    }
}));

L.NewInteractivityControl = L.Control.extend({
    options: {
        position: "topleft",
    },

    onAdd: function(map) {
        var container = L.DomUtil.create("div", "leaflet-control leaflet-bar"),
            link = L.DomUtil.create("a", "", container);

        link.href = "#";
        link.title = "Activer/Désactiver interactivité";
        link.id = "btn_active_touch";
        link.innerHTML = "<i class='fa fa-hand-pointer-o fa-lg' aria-hidden='true'></i>";
        L.DomEvent.on(link, "click", L.DomEvent.stop)
                  .on(link, "click", function (e) {
                	  	if (map.scrollWheelZoom.enabled()) {
                			disableHandleMap();
                		}
                		else {
                			enableHandleMap();
                		}
                  });

        return container;
    }
});
map.addControl(new L.NewInteractivityControl());

/* fonds de carte */
var fonds_carto = {};	
fonds_carto["Outdoors"]=  L.tileLayer("https://api.mapbox.com/styles/v1/vincent2b/ckacgndr602if1iloq3zpxoif/tiles/{z}/{x}/{y}?access_token=pk.eyJ1IjoidmluY2VudDJiIiwiYSI6ImNqM3BsbzBtbDAwMzgyd3FkYWx4ZmNpcjIifQ.mre2Z8qhzbp3CUmy2YtFlg", {
    tileSize: 512,
	maxZoom: 20,
	zoomOffset: -1,
    attribution: "Mapbox",
    noWrap: true
});
fonds_carto["Satellite monde"] = L.tileLayer("https://api.mapbox.com/styles/v1/vincent2b/ckadls8ql0l7k1ilo0lps4swq/tiles/{z}/{x}/{y}?access_token=pk.eyJ1IjoidmluY2VudDJiIiwiYSI6ImNqM3BsbzBtbDAwMzgyd3FkYWx4ZmNpcjIifQ.mre2Z8qhzbp3CUmy2YtFlg", {
    tileSize: 512,
	maxZoom: 20,
	zoomOffset: -1,
    attribution: "Mapbox",
    noWrap: true
});
fonds_carto["Light"] = 	L.tileLayer("https://api.mapbox.com/styles/v1/vincent2b/ckadl6ni406ou1irtli71fwll/tiles/{z}/{x}/{y}?access_token=pk.eyJ1IjoidmluY2VudDJiIiwiYSI6ImNqM3BsbzBtbDAwMzgyd3FkYWx4ZmNpcjIifQ.mre2Z8qhzbp3CUmy2YtFlg", {
    tileSize: 512,
	maxZoom: 20,
	zoomOffset: -1,
    attribution: "Mapbox",
    noWrap: true
});
fonds_carto["Open Street Map"] = L.tileLayer("http://{s}.tile.openstreetmap.fr/hot/{z}/{x}/{y}.png", {
    attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
});
fonds_carto["Open Street Map 2"] = L.tileLayer("https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png", {
    attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
});
fonds_carto["Opentopo Map"] = L.tileLayer("https://c.tile.opentopomap.org/{z}/{x}/{y}.png", {
    attribution: "&copy; OpenStreetMap contributors, SRTM | map style: © OpenTopoMap (CC-BY-SA)"
});

fonds_carto["Outdoors"].addTo(map)
L.control.layers(fonds_carto).addTo(map);

/* comportement souris */
function enableHandleMap() {
	console.log("active");
	var element = document.getElementById("btn_active_touch");
	element.title = "Désactiver interactivité";
	var i = element. querySelector("i");
	i.classList.add("fa-hand-pointer-o");
	i.classList.remove("fa-hand-rock-o");
	map.scrollWheelZoom.enable();
	map.dragging.enable();
}
function disableHandleMap() {
	console.log("desactive");
	var element = document.getElementById("btn_active_touch");
	element.title = "Activer interactivité";
	var i = element. querySelector("i");
	i.classList.remove("fa-hand-pointer-o");
	i.classList.add("fa-hand-rock-o");
	map.scrollWheelZoom.disable();
	map.dragging.disable();
}
disableHandleMap();
map.on('click', function() {
	if (map.scrollWheelZoom.enabled()) {
		disableHandleMap();
	}
	else {
		enableHandleMap();
	}
});
map.on('blur', function() {
	//disableHandleMap(); // provoque un souci avec le bouton btn_activ_touch
});

/* action sur les pictos */

var picto_sentier = L.Icon.extend({
    options :{
  		iconUrl:       "modules/SimpleCarto/lib/pictos/atlas/vc1.png",
  		shadowUrl:     "javascripts/leaflet/images/marker-shadow.png",
  		iconSize:    [33, 40],
  		iconAnchor:  [16, 41],
  		popupAnchor: [1, -34],
  		tooltipAnchor: [16, -28],
  		shadowSize:  [55, 41]
    }
});

function onEachFeature(feature, layer) {
	if (layer.feature.geometry.type == "Point") {
		layer.setIcon(new picto_sentier);	
	}
}

/* récup données sentiers */
jQuery.ajax({
	url: "mobiles.php?name=sdp&sop=get_map_itineraires&ti=fini",
	type: "GET",
	dataType: "json",
	contentType: false,
	processData: false,
	beforeSend: function(xhr) {
		xhr.setRequestHeader("pragma", "no-cache");
	},
	xhr: function() {
		var xhr = new window.XMLHttpRequest();
		return xhr;
	}
}).done(function(zones) {
	if (zones.error != "") {
		alert(zones.error);
	}
	else {
		sentiers = L.geoJSON(zones.result, {
			style: function (feature) {
				return {
		            weight: 2,
		            color: "#f00"
		        };
			},
			onEachFeature: onEachFeature
		});
		
		map.addLayer(sentiers);
		
		map.fitBounds(sentiers.getBounds());
	}
});