<?php
if (! preg_match ( "#modules.php#i", $_SERVER ['PHP_SELF'] )) {
	die ( "You can't access this file directly..." );
}

$module_name = basename ( dirname ( __FILE__ ) );
// get_lang($module_name);

require_once ("core/becms_mainlib_lib.php");
require_once ("modules/" . $module_name . "/system/params.php");
require_once 'modules/'.$module_name.'/system/fonctions.php';
require_once 'images/filetypes/filetypes.php';

/**
 * Si la page n'existe pas
 */
function display_menu() {
	echo "Pas accs. Mauvais paramtre";
}

/**
 * Pages parmettant d'afficher tous les itineraires en un block non clickable sur une Google Maps
 * @param unknown $theme le theme
 * @param unknown $circuit le circuit
 */
function display_map_symbol_block_itineraires() {
	global $module_name, $_headerContent, $currentlang;
	global $rep, $expression;
	global $My_SQL, $vars_mod, $carteSdp, $urlRedirection;
	require_once ("modules/SimpleCarto/lib/g_params.php");

	/* <!--<script type="text/javascript" src="modules/'.$module_name.'/language/lang-'.$currentlang.'.js" charset="UTF-8"></script>--> */
	$_headerContent = '
		<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key=' . $keymap . '" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_autostart.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_XML_parser.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_AJAX.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_interface.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_string.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_carto_symb_block_itineraires.js" charset="UTF-8"></script>
		<script type="text/javascript">
		//<![CDATA[
			var options = new Array;
			var racine_lib_module = "modules/SimpleCarto/lib";
			options["url_redirection"] = "'.$urlRedirection.'";
		   //]]>
		</script>
		<script type="text/javascript">
		// <![CDATA[
			addToStart("GetMap('.$carteSdp.')");
			addToStop(GUnload);
		// ]]>
		</script>';

	setHeader ( $_headerContent );

	$sortie = '
		<div class="sdp">
			<h1 id="titre"></h1>
			<div id="commentaire"></div>
			<table border="0" cellpadding="0" cellspacing="0">
			<tr><td valign="center" colspan=3>
			<div id="map"></div>
			</td><td width="20"></td><td valign="top">
			<div id="leg"></div>
			</td></tr></table>
			<p>&nbsp;</p>
			<div id="obs"></div>
		</div>';
	include ('header.php');
	echo $sortie;
	$bardef = array ( // "print"=>"modules.php?name=Chuck_Norris_Facts&sop=print&page=$page",
			// "pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back" => "javascript:window.history.back();",
			"top" => "#top"
	);
	buttonBar ( $bardef, "align" );
	include ('footer.php');
}

/**
 * Pages parmettant d'afficher tous les itineraires sur une Google Maps
 * @param unknown $theme le theme
 * @param unknown $circuit le circuit
 */
function display_map_symbol_itineraires($typeItineraire = '') {
	global $module_name, $_headerContent, $currentlang;
	global $rep, $expression;
	global $My_SQL, $vars_mod, $carteSdp, $lienFicheItineraire, $icon_plus_infos;
	require_once ("modules/SimpleCarto/lib/g_params.php");

	/* <!--<script type="text/javascript" src="modules/'.$module_name.'/language/lang-'.$currentlang.'.js" charset="UTF-8"></script>--> */
	$_headerContent = '
		<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key=' . $keymap . '" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_autostart.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_XML_parser.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_AJAX.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_interface.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_string.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_carto_symb_itineraires.js" charset="UTF-8"></script>
		<script type="text/javascript">
		//<![CDATA[
			var options = new Array;
			var racine_lib_module = "modules/SimpleCarto/lib";
			options["lienItineraire"] = "'.$lienFicheItineraire.'";
			options["icon_plus_infos"] = "'.$icon_plus_infos.'";
		   //]]>
		</script>
		<script type="text/javascript">
		// <![CDATA[
			addToStart("GetMap('.$carteSdp.', \"'.$typeItineraire.'\")");
			addToStop(GUnload);
		// ]]>
		</script>';

	setHeader ( $_headerContent );
	if ($typeItineraire == "trav") {
		$sortie = '
			<h1 id="titre">Les sentiers en travaux<br/><span style="font-size: smaller; font-style: italic">I sentieri in lavori</span></h1>
			<p> &nbsp;</p>
			<p style="text-align: center;">Cette carte prsente les itinraires en phase de ralisation.<br />Vous pourrez accder aux informations disponibles et  l\'tat d\'avancement de ces sentiers en cliquant sur les pictogrammes disposs sur la carte.</p>
			<p style="text-align: center;font-style: italic;">Questa carta presenta gli itinerari in fase di realizzazione.<br />Potrete accedere alle informazioni disponibili ed ai progressi di questi sentieri premendo sui pittogrammi disposti sulla carta.</p>
			<p> &nbsp;</p>
			<div class="sdp">
				<div id="map"></div>
				<p>&nbsp;</p>
				<div id="obs"></div>
			</div>';
	}
	else {
		$sortie = '
			<h1 id="titre">Sentiers du patrimoine<br/><span style="font-size: smaller; font-style: italic">Sentieri del patrimonio</span></h1>
			<p> &nbsp;</p>
			<p style="text-align: center;">Cette carte prsente les itinraires raliss.<br />Vous pourrez accder aux informations dtailles de ces sentiers en cliquant sur les pictogrammes disposs sur la carte.</p>
			<p style="text-align: center;font-style: italic;">Questa carta presenta gli itinerari realizzati.<br />Potrete accedere alle informazioni dettagliate di questi sentieri premendo sui pittogrammi disposti sulla carta.</p>
			<p> &nbsp;</p>
			<div class="sdp">
				<div id="map"></div>
				<p>&nbsp;</p>
				<div id="obs"></div>
			</div>';
	}
	include ('header.php');
	echo $sortie;
	$bardef = array ( // "print"=>"modules.php?name=Chuck_Norris_Facts&sop=print&page=$page",
			// "pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back" => "javascript:window.history.back();",
			"top" => "#top"
	);
	buttonBar ( $bardef, "align" );
	include ('footer.php');
}

/**
 * Permet de crer l'album photo a partir d'un lien
 *
 * @param unknown $url
 *        	le lien
 * @return string l'album
 */
function createAlbum($album, $prefix_id="") {
	global $module_name, $separatorImageAlbum;
	$album_photos = '<div class="diaporamazoom"><div class="highslide-gallery">';
	$count = 1;
	$urls = explode($separatorImageAlbum, $album);
	foreach ($urls as $url) {
		if( $url != "" ) {
			$resizedImg = $url;
			$tumbImg = $url;
			/*
			 * $resizedImg = "modules.php?name=becmsGallery&sop=Resizer&imgfile=$laphoto&max_width=800&max_height=800"; $tumbImg = "modules.php?name=becmsGallery&sop=Resizer&imgfile=$laphoto&max_width=100&max_height=100";
			*/
			$album_photos .= '
				<table border="0" cellpadding="0" cellspacing="0" class="diapo">
				<tr><td>
				<a id="'.$prefix_id.'thumb' . $count . '" href="' . $resizedImg . '" class="highslide" onclick="return hs.expand(this)"><img src="' . $tumbImg . '" alt="' . $nom . '" title="Cliquez pour agrandir" style="max-width: 100px; max-height: 100px;" /></a>
				<div class="highslide-heading">
					' . $nom . '
				</div>';
			$photo_comments = $credit;
			if ($photo_comments != "") {
				$album_photos .= '
					<div class="highslide-caption">
						' . $photo_comments . '
					</div>';
			}
			$album_photos .= '</td></tr></table>';
			$count ++;
		}
	}
	$album_photos .= '</div></div>';
	return $album_photos;
}

function createAlbums($albums) {
	global $db, $prefix;
	
	$sortie = "";
	foreach ($albums as $id_album) {
		$sql = "SELECT albumid, album_name, photo_id, photo_file FROM ".$prefix."_gallery_album INNER JOIN ".$prefix."_gallery_photo ON ".$prefix."_gallery_photo.photo_albumid=".$prefix."_gallery_album.albumid WHERE ".$prefix."_gallery_album.albumid='".$id_album."' AND ".$prefix."_gallery_photo.photo_album='1';";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows ( $results ) != 0) {
			while( list($albumid, $album_name, $photo_id, $photo_file) = $db->sql_fetchrow ( $results ) ) {
				//echo "**".$albumid."**".$album_name."**".$photo_id."**\n";
				$tumbImg="modules.php?name=becmsGallery&sop=Resizer&imgfile=$photo_file&max_width=100&max_height=100";
				$sortie .= '<table border="0" cellpadding="0" cellspacing="0" class="diapomulti">
						<caption><a href="modules.php?name=becmsGallery&sop=getAlbum&albumid='.$albumid.'" class="highslide" title="'."Ouvrir cet album".'">'.$album_name.'</a></caption>
						<tr><td>
						<a href="modules.php?name=becmsGallery&sop=getAlbum&albumid='.$albumid.'" class="highslide" title="'."Ouvrir cet album".'"><img src="'.$tumbImg.'" alt="'.$album_name.'" /></a>
						</td></tr>
					</table>';
			}
		}
	}
	return $sortie;
}

function CoolSize($size) {
    $mb = 1024*1024;
    if ( $size > $mb ) {
        $mysize = sprintf ("%01.2f",$size/$mb) . " MB";
    } elseif ( $size >= 1024 ) {
        $mysize = sprintf ("%01.2f",$size/1024) . " Kb";
    } else {
        $mysize = $size . " bytes";
    }
    return $mysize;
}

function display_map_symbol_fiche_itineraire($idItineraire) {
	global $module_name, $_headerContent, $currentlang, $db, $prefix, $Default_Theme;
	global $rep, $expression;
	global $My_SQL, $vars_mod, $carteSdp, $lienFicheSite, $name_table_itineraire, $separatorImageAlbum, $icon_plus_infos;
	require_once ("modules/SimpleCarto/lib/g_params.php");
	
	/* <!--<script type="text/javascript" src="modules/'.$module_name.'/language/lang-'.$currentlang.'.js" charset="UTF-8"></script>--> */
	$_headerContent = '
		<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key=' . $keymap . '" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_autostart.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_XML_parser.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_AJAX.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_interface.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_string.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_carto_symb_fiche_itineraire.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/becmsGallery/type/zoom_gallery/highslide/highslide-with-gallery.js"></script>
		<link rel="stylesheet" type="text/css" href="modules/becmsGallery/type/zoom_gallery/highslide/highslide.css" />
		<link rel="stylesheet" type="text/css" href="modules/becmsGallery/type/zoom_gallery/css/default.css" />
		<link rel="stylesheet" href="themes/' . $Default_Theme . '/style/becmsGallery.css" type="text/css">
		<script type="text/javascript">
			hs.lang = {
			   loadingText :     \'Chargement...\',
			   loadingTitle :    \'Cliquer pour annuler\',
			   focusTitle :      \'Cliquer pour amener au premier plan\',
			   fullExpandTitle : \'Afficher en taille relle\',
			   fullExpandText :  \'Taille relle\',
			   creditsText :     \'Dvelopp sur <i>Highslide JS</i>\',
			   creditsTitle :    \'Site Web de Highslide JS\',
			   previousText :    \'Prcdent\',
			   previousTitle :   \'Prcdent (flche gauche)\',
			   nextText :        \'Suivant\',
			   nextTitle :       \'Suivant (flche droite)\',
			   moveTitle :       \'Dplacer\',
			   moveText :        \'Dplacer\',
			   closeText :       \'Fermer\',
			   closeTitle :      \'Fermer (esc ou Echap)\',
			   resizeTitle :     \'Redimensionner\',
			   playText :        \'Lancer\',
			   playTitle :       \'Lancer le diaporama (barre d\\\'espace)\',
			   pauseText :       \'Pause\',
			   pauseTitle :      \'Suspendre le diaporama (barre d\\\'espace)\',
			   restoreTitle :    \'Cliquer pour fermer l\\\'image, cliquer et faire glisser pour dplacer, utiliser les touches flches droite et gauche pour suivant et prcdent.\'
			};
			hs.graphicsDir = \'modules/becmsGallery/type/zoom_gallery/highslide/graphics/\';
			hs.align = \'center\';
			hs.transitions = [\'expand\', \'crossfade\'];
			hs.outlineType = \'rounded-white\';
			hs.wrapperClassName = \'controls-in-heading\';
			hs.fadeInOut = true;
			//hs.numberPosition = \'caption\';
			hs.dimmingOpacity = 0.5;
			hs.showCredits = false;
			// Add the controlbar
			if (hs.addSlideshow) hs.addSlideshow({
				//slideshowGroup: \'group1\',
				interval: 5000,
				repeat: false,
				useControls: true,
				fixedControls: false,
				overlayOptions: {
					opacity: 1,
					position: \'top right\',
					hideOnMouseOut: false
				}
			});
		</script>
		<script type="text/javascript">
		//<![CDATA[
			var options = new Array;
			var racine_lib_module = "modules/SimpleCarto/lib";
			options["lienSite"] = "'.$lienFicheSite.'";
			options["icon_plus_infos"] = "'.$icon_plus_infos.'";
		   //]]>
		</script>
		<script type="text/javascript">
		// <![CDATA[
			addToStart("GetMap('.$carteSdp.', '.$idItineraire.')");
			addToStop(GUnload);
		// ]]>
		</script>';
	
	setHeader ( $_headerContent );
	$album = "";
	$album_travaux = "";
	$en_travaux = "0";
	
	$sql = "SELECT * FROM `".$prefix.$name_table_itineraire."` WHERE `id`=".$idItineraire;
	$search = $db->sql_query ( $sql );
	if ($db->sql_numrows ( $search ) != 0) {
		$donnees = $db->sql_fetchrow ( $search );
		
		$nom = strFrenchAndCorsican($donnees["nom_french"], $donnees["nom_corsican"]);
		$commune = $donnees['commune'];
		$description = strFrenchAndCorsican($donnees["description_french"], $donnees["description_corsican"], " ");
		$longueur = $donnees['longueur'];
		$difficulte = $donnees['difficulte_french'];
		$etat = $donnees['etat_french'];
		$commentaire = $donnees['commentaire'];
		$id_file = $donnees['id_download'];
		$en_travaux = $donnees['en_travaux'];
		$visite = $donnees['visite'];
	
		if( $en_travaux == "0" ) {
			$sql = "select photo_file FROM ".$prefix."_gallery_photo WHERE photo_albumid=".$donnees["id_album"]." ORDER BY photo_album DESC";
			$results = $db->sql_query ( $sql );
			
			if ($db->sql_numrows ( $results ) != 0) {
				while( $donnees_album = $db->sql_fetchrow ( $results ) ) {
					$album .= $donnees_album['photo_file'].$separatorImageAlbum;
				}
			}
		}
		
		$sql = "select photo_file FROM ".$prefix."_gallery_photo WHERE photo_albumid=".$donnees["id_album_travaux"]." ORDER BY photo_album DESC";
		$results = $db->sql_query ( $sql );
		
		if ($db->sql_numrows ( $results ) != 0) {
			while( $donnees_album_trav = $db->sql_fetchrow ( $results ) ) {
				$album_travaux .= $donnees_album_trav['photo_file'].$separatorImageAlbum;
			}
		}
		
		$sql = "select url, title, filesize from ".$prefix."_downloads_downloads where lid=".$id_file;
		$results = $db->sql_query ( $sql );
		
		if ($db->sql_numrows ( $results ) != 0) {
			$donnees_file = $db->sql_fetchrow ( $results );
			$titleFile = $donnees_file['title'];
			$urlFile = $donnees_file['url'];
			$sizeFile = $donnees_file['filesize'];
		}
		
		$listAlbums = array();
		if ($donnees["id_album"] != "0") {
			$listAlbums[] = $donnees["id_album"];
		}
		if ($donnees["id_album_travaux"] != "0") {
			$listAlbums[] = $donnees["id_album_travaux"];
		}
		$sql = "SELECT id_album FROM ".$prefix."_sdp_site WHERE id_itineraire='".$idItineraire."';";
		$results = $db->sql_query ( $sql );
		if ($db->sql_numrows ( $results ) != 0) {
			while( list($id_album) = $db->sql_fetchrow ( $results ) ) {
				if ($id_album != "0") {
					$listAlbums[] = $id_album;
				}
			}
		}
	}
	
	$htmlNom = "";
	if( $nom != "" ) {
		$htmlNom = $nom;
	}
	$htmlDescription = "";
	if( $description != "" ) {
		if (preg_match("#^\<#", $description)) {
			$htmlDescription = $description;
		}
		else {
			$htmlDescription = "<p>" . nl2br($description) . "</p>";
		}
	}
	
	$htmlInfos = "";
	if ($commune != "" || $longueur != "" || $difficulte != "" | $etat || "") {
		$htmlInfos = '<fieldset class="zoneinfo"><legend>Fiche technique</legend>';
		if ($commune != "") {
			$htmlInfos .= '<p><span class="label">Commune : </span>'.$commune.'</p>';
		}
		if ($longueur != "") {
			$htmlInfos .= '<p><span class="label">Longueur du parcours : </span>'.$longueur.'</p>';
			}
		if ($difficulte != "") {
			$htmlInfos .= '<p><span class="label">Niveau de difficult : </span>'.$difficulte.'</p>';
		}
		if ($etat != "") {
			$htmlInfos .= '<p><span class="label">tat du sentier : </span>'.$etat.'</p>';
		}
		$htmlInfos .= '</fieldset>';
	}
	
	$htmlCommentaire = "";
	if( $commentaire != "" ) {
		if (!preg_match("#^\<#", $commentaire)) {
			$commentaire = "<p>" . nl2br($commentaire) . "</p>";
		}
		$htmlCommentaire = '<p style="margin-top: 26px; margin-bottom: 10px ;"><span class="label">Avis d\'experts :</span></p>' . $commentaire;
	}
	
	$htmlAlbum = "";
	/*if( $album != "" ) {
		$htmlAlbum = '<div style="clear:both;"></div><p style="margin-top: 26px; margin-bottom: 10px ;"><span class="label">Album de photos du sentier :</span></p>'.createAlbum($album);
	}*/
	$htmlAlbumTravaux = "";
	/*if( $album_travaux != "" ) {
		$htmlAlbumTravaux = '<div style="clear:both;"></div><p style="margin-top: 26px; margin-bottom: 10px ;"><span class="label">Photos du sentier en travaux :</span></p>'.createAlbum($album_travaux, "trav_");	
	}*/	
	
	$htmlVisite = "";
	if ($visite != "") {
		$htmlVisite = '<form style="margin-top: 26px; margin-bottom: 10px ;"><input name="visite" value="Visite virtuelle 360" type="button" onclick="window.open(\''.$visite.'\')" class="btnstyle"></form>';
	}
	
	$htmlTitleFile = "";
	if ($id_file != "" && $id_file != "0") {
		$htmlTitleFile = '<form style="margin-top: 26px; margin-bottom: 10px ;"><input name="visite" value="En savoir plus... ('.CoolSize($sizeFile).')" type="button" onclick="window.open(\'modules.php?name=Downloads&d_op=getit&lid='.$id_file.'\')" class="btnstyle"></form>';
	}
	
	/*$htmlTitleFile = "";
	if( $titleFile != "" ) {
		$htmlTitleFile = '<p><a target="_blank" href="modules.php?name=Downloads&d_op=getit&lid='.$id_file.'"><img src="'.get_icon_for_file($urlFile).'" alt="" />'.$titleFile.'</a></p>';
	}*/
	$htmlAlbums = createAlbums($listAlbums);
	if ($htmlAlbums != "") {
		$htmlAlbums = '<div style="clear:both;"></div><p style="margin-top: 26px; margin-bottom: 10px ;"><span class="label">Albums de photos du sentier :</span></p>'.$htmlAlbums;
	}
	
	
	
	$sortie = '
		<div class="sdp">
			<h1>'.$htmlNom.'</h1>
			<p>&nbsp;</p>
			<table border="0" cellpadding="0" cellspacing="0" width="1000" align="center">
			<tr>
			<td width="640" valign="top">'.$htmlDescription.'</td>
			<td width="30"></td>
			<td width="315" valign="top">'.$htmlInfos.'</td>
			</tr>
			</table>
			<h2>Parcours du sentier</h2>
			<div id="map" style="width: 1000px; height: 800px; margin-left: 0;"></div>
			<table border="0" cellpadding="0" cellspacing="0" width="1000" align="center">
			<td width="640" valign="top">'.$htmlCommentaire.'</td>
			<td width="30"></td>
			<td width="315" valign="top">'.$htmlVisite.$htmlTitleFile.'</td>
			</table>
			'.$htmlAlbum.$htmlAlbumTravaux.$htmlAlbums.'<div style="clear: both"></div>
			<p>&nbsp;</p>
		</div>';
	include ('header.php');
	
	
	/*if( $en_travaux == "1" ) {
		$sortie .= '<script type="text/javascript">
				//<![CDATA[
					document.getElementById("map").style.width = "200px";
					document.getElementById("map").style.height = "200px";
		   		//]]>
				</script>';
	}*/
	
	echo $sortie;
	
	$bardef = array ( // "print"=>"modules.php?name=Chuck_Norris_Facts&sop=print&page=$page",
			// "pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back" => "javascript:window.history.back();",
			"top" => "#top"
	);
	buttonBar ( $bardef, "align" );
	include ('footer.php');
}

function display_map_symbol_fiche_site($idSite) {
	global $module_name, $_headerContent, $currentlang, $db, $prefix, $Default_Theme;
	global $rep, $expression;
	global $My_SQL, $vars_mod, $carteSdp, $lienFicheSite, $name_table_site, $separatorImageAlbum;
	require_once ("modules/SimpleCarto/lib/g_params.php");

	/* <!--<script type="text/javascript" src="modules/'.$module_name.'/language/lang-'.$currentlang.'.js" charset="UTF-8"></script>--> */
	$_headerContent = '
		<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key=' . $keymap . '" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_autostart.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_XML_parser.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_AJAX.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_interface.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_string.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_carto_symb_fiche_site.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/becmsGallery/type/zoom_gallery/highslide/highslide-with-gallery.js"></script>
		<link rel="stylesheet" type="text/css" href="modules/becmsGallery/type/zoom_gallery/highslide/highslide.css" />
		<link rel="stylesheet" href="themes/' . $Default_Theme . '/style/becmsGallery.css" type="text/css">
		<link rel="stylesheet" type="text/css" href="modules/becmsGallery/type/zoom_gallery/css/default.css" />
		<script type="text/javascript">
			hs.lang = {
			   loadingText :     \'Chargement...\',
			   loadingTitle :    \'Cliquer pour annuler\',
			   focusTitle :      \'Cliquer pour amener au premier plan\',
			   fullExpandTitle : \'Afficher en taille relle\',
			   fullExpandText :  \'Taille relle\',
			   creditsText :     \'Dvelopp sur <i>Highslide JS</i>\',
			   creditsTitle :    \'Site Web de Highslide JS\',
			   previousText :    \'Prcdent\',
			   previousTitle :   \'Prcdent (flche gauche)\',
			   nextText :        \'Suivant\',
			   nextTitle :       \'Suivant (flche droite)\',
			   moveTitle :       \'Dplacer\',
			   moveText :        \'Dplacer\',
			   closeText :       \'Fermer\',
			   closeTitle :      \'Fermer (esc ou Echap)\',
			   resizeTitle :     \'Redimensionner\',
			   playText :        \'Lancer\',
			   playTitle :       \'Lancer le diaporama (barre d\\\'espace)\',
			   pauseText :       \'Pause\',
			   pauseTitle :      \'Suspendre le diaporama (barre d\\\'espace)\',
			   restoreTitle :    \'Cliquer pour fermer l\\\'image, cliquer et faire glisser pour dplacer, utiliser les touches flches droite et gauche pour suivant et prcdent.\'
			};
			hs.graphicsDir = \'modules/becmsGallery/type/zoom_gallery/highslide/graphics/\';
			hs.align = \'center\';
			hs.transitions = [\'expand\', \'crossfade\'];
			hs.outlineType = \'rounded-white\';
			hs.wrapperClassName = \'controls-in-heading\';
			hs.fadeInOut = true;
			//hs.numberPosition = \'caption\';
			hs.dimmingOpacity = 0.5;
			hs.showCredits = false;
			// Add the controlbar
			if (hs.addSlideshow) hs.addSlideshow({
				//slideshowGroup: \'group1\',
				interval: 5000,
				repeat: false,
				useControls: true,
				fixedControls: false,
				overlayOptions: {
					opacity: 1,
					position: \'top right\',
					hideOnMouseOut: false
				}
			});
		</script>
		<script type="text/javascript">
		//<![CDATA[
			var options = new Array;
			var racine_lib_module = "modules/SimpleCarto/lib";
		   //]]>
		</script>
		<script type="text/javascript">
		// <![CDATA[
			addToStart("GetMap('.$carteSdp.', '.$idSite.')");
			addToStop(GUnload);
		// ]]>
		</script>
		';

	

	$album = "";
	
	$sql = "SELECT * FROM `".$prefix.$name_table_site."` WHERE `id`=".$idSite;
	$search = $db->sql_query ( $sql );
	if ($db->sql_numrows ( $search ) != 0) {
		$donnees = $db->sql_fetchrow ( $search );

		$longitude = $donnees["longitude"];
		$latitude = $donnees["latitude"];
		/*$nom = strFrenchAndCorsican($donnees["nom_french"], $donnees["nom_corsican"]);
		$description = strFrenchAndCorsican($donnees["description_french"], $donnees["description_corsican"]);*/
		
		if (!preg_match("#^\<#", $donnees["description_french"])) {
			$donnees["description_french"] = "<p>" . nl2br($donnees["description_french"]) . "</p>";
		}
		if (!preg_match("#^\<#", $donnees["description_corsican"])) {
			$donnees["description_corsican"] = "<p>" . nl2br($donnees["description_corsican"]) . "</p>";
		}
		
		$nom = $donnees["nom_french"];
		$description = $donnees["description_french"];
		
		if (($donnees["description_corsican"] == "<p></p>") && $donnees["nom_corsican"] != "") {
			$donnees["description_corsican"] = $donnees["description_french"];
		}
		if ($donnees["description_corsican"] != "<p></p>" && $donnees["nom_corsican"] == "") {
			$donnees["nom_corsican"] = $donnees["nom_french"];
		}
		$btnlang = "";
		if ($donnees["description_corsican"] != "<p></p>" && $donnees["nom_corsican"] != "") {
			$btnlang = '<span style="float: right; font-size: 18px;"><a href="#" onclick="translateto(\'corsican\'); return false;"><img src="themes/' . $Default_Theme . '/images/corse.png" width="50" style="border: 1px solid #ccc"></a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="#" onclick="translateto(\'french\'); return false;"><img src="themes/' . $Default_Theme . '/images/france.png" width="50" style="border: 1px solid #ccc"></a></span>';
		}
		
		$_headerContent .= '
		<script type="text/javascript">
			var nom_corsican = "'.str_replace("\n","",str_replace("\"","&quot;", $donnees["nom_corsican"])).'";
			var nom_french = "'.str_replace("\n","",str_replace("\"","&quot;", $donnees["nom_french"])).'";
			var description_corsican = "'.str_replace("\r","",str_replace("\n","",str_replace("\"","&quot;", $donnees["description_corsican"]))).'";
			var description_french = "'.str_replace("\r","",str_replace("\n","",str_replace("\"","&quot;", $donnees["description_french"]))).'";
			function translateto(lang) {
				var leDiv1 = document.getElementById("titresite");
				var leDiv2 = document.getElementById("descsite");
				if (lang == "french") {
					leDiv1.innerHTML = nom_french;
					leDiv2.innerHTML = description_french;
				}
				if (lang == "corsican") {
					leDiv1.innerHTML = nom_corsican;
					leDiv2.innerHTML = description_corsican;
				}
			}
		</script>';
		
		//la liaison n'est l que pour ne pas prendre des photos d'un album qui a t supprim mais qui est toujours attribu  une fiche
		$sql = "select photo_file FROM ".$prefix."_gallery_photo INNER JOIN ".$prefix."_gallery_album ON ".$prefix."_gallery_photo.photo_albumid=".$prefix."_gallery_album.albumid WHERE photo_albumid=".$donnees["id_album"]." ORDER BY photo_album DESC";
		$results = $db->sql_query ( $sql );
		
		if ($db->sql_numrows ( $results ) != 0) {
			while( $donnees = $db->sql_fetchrow ( $results ) ) {
				$album .= $donnees['photo_file'].$separatorImageAlbum;
			}
		}
	}
	
	$htmlNom = "";
	if( $nom != "" ) {
		$htmlNom = $nom;
	}
	$htmlDescription = "";
	if( $description != "" ) {
		if (preg_match("#^\<#", $description)) {
			$htmlDescription = $description;
		}
		else {
			$htmlDescription = "<p>" . nl2br($description) . "</p>";
		}
	}
	
	$htmlInfos = "";
	if( $longitude != "" && $latitude != "" ) {
		$htmlInfos = '<fieldset class="zoneinfo"><legend>Infos technique</legend>';
		if ($latitude != "") {
			$htmlInfos .= '<p><span class="label">Latitude : </span>'.$latitude.'</p>';
		}
		if ($longitude != "") {
			$htmlInfos .= '<p><span class="label">Longitude : </span>'.$longitude.'</p>';
		}
		$htmlInfos .= '</fieldset>';
	}
	
	$htmlAlbum = "";
	if( $album != "" ) {
		$htmlAlbum = '<div style="clear:both;"></div><p style="margin-top: 26px; margin-bottom: 10px ;"><span class="label">Album de photos du sentier :</span></p>'.createAlbum($album);
	}

	$sortie = '
		<div class="sdp">
			<h1 id="titresite">'.$htmlNom.'</h1>
			<p>'.$btnlang.'&nbsp;</p>
			<table border="0" cellpadding="0" cellspacing="0" width="1000" align="center">
			<tr>
			<td colspan="3" valign="top" id="descsite">'.$htmlDescription.'</td>
			</tr>
			<tr>
			<td width="485" style="vertical-align: top"><div id="mini_map" style="width: 485px; height: 400px; margin: 0;"></div></td>
			<td width="30"></td>
			<td width="485" valign="top">'.$htmlInfos.'</td>
			</tr>
			</table>
			'.$htmlAlbum.$htmlAlbumTravaux.'<div style="clear: both"></div>
			<p>&nbsp;</p>
		</div>';
	
	setHeader ( $_headerContent );
	
	include ('header.php');
	echo $sortie;
	
	$bardef = array ( // "print"=>"modules.php?name=Chuck_Norris_Facts&sop=print&page=$page",
			// "pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back" => "javascript:window.history.back();",
			"top" => "#top"
	);
	buttonBar ( $bardef, "align" );
	include ('footer.php');
}

/**
 * Permet de retourner et d'afficher la carte en fonction du xml
 * @param unknown $theme le theme
 * @param unknown $circuit le circuit
 * @param unknown $rech la recherche
 */
function get_map_pict_XML_itineraires($ti, $theme, $circuit, $rech) {
	global $module_name, $Idc;
	require_once ("modules/" . $module_name . "/lib/getXMLcarto_pict_itineraires.php");
	$sortie = getXMLcarto ( $Idc, $ti, $theme, $circuit, $rech );
	header ( "Content-Type: text/xml; charset=UTF-8" );
	echo $sortie;
}

function get_map_pict_XML_fiche_itineraires($idItineraire) {
	global $module_name, $Idc;
	require_once ("modules/" . $module_name . "/lib/getXMLcarto_pict_fiche_itineraire.php");
	$sortie = getXMLcarto ( $Idc, $idItineraire );
	header ( "Content-Type: text/xml; charset=UTF-8" );
	echo $sortie;
}

function get_map_pict_XML_fiche_site($idSite) {
	global $module_name, $Idc;
	require_once ("modules/" . $module_name . "/lib/getXMLcarto_pict_fiche_site.php");
	$sortie = getXMLcarto ( $Idc, $idSite );
	header ( "Content-Type: text/xml; charset=UTF-8" );
	echo $sortie;
}

function display_map_symbol_itineraires_3d() {
	global $module_name, $_headerContent, $currentlang;
	global $rep, $expression;
	global $My_SQL, $vars_mod, $carteSdp, $lienFicheItineraire3d, $icon_plus_infos;
	require_once ("modules/SimpleCarto/lib/g_params.php");
	
	/* <!--<script type="text/javascript" src="modules/'.$module_name.'/language/lang-'.$currentlang.'.js" charset="UTF-8"></script>--> */
	$_headerContent = '
		<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key=' . $keymap . '" charset="UTF-8"></script>
		<script type="text/javascript" src="https://www.google.com/jsapi"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_autostart.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_XML_parser.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_AJAX.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_interface.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_string.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_carto_symb_itineraires_3d.js" charset="UTF-8"></script>
		<script type="text/javascript">
		//<![CDATA[
			var options = new Array;
			var racine_lib_module = "modules/SimpleCarto/lib";
			options["lienItineraire"] = "'.$lienFicheItineraire3d.'";
			options["icon_plus_infos"] = "'.$icon_plus_infos.'";
			options["id_carte"] = "'.$carteSdp.'";
			options["http_host"] = "http://'.$_SERVER[HTTP_HOST].'/";
		   //]]>
		</script>
		<script type="text/javascript">
		// <![CDATA[
			//addToStart("getEarth('.$carteSdp.')");
			//addToStop(GUnload);
		// ]]>
		</script>';
	
	setHeader ( $_headerContent );
	
	$sortie = '
		<div class="sdp">
			<h1 id="titre"></h1>
			<div id="commentaire"></div>
			<table border="0" cellpadding="0" cellspacing="0">
			<tr><td valign="center" colspan=3>
			<div id="map3d"></div>
			</td><td width="20"></td><td valign="top">
			<div id="leg"></div>
			</td></tr></table>
			<p>&nbsp;</p>
			<div id="obs"></div>
		</div>';
	include ('header.php');
	echo $sortie;
	$bardef = array ( // "print"=>"modules.php?name=Chuck_Norris_Facts&sop=print&page=$page",
			// "pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back" => "javascript:window.history.back();",
			"top" => "#top"
	);
	buttonBar ( $bardef, "align" );
	include ('footer.php');
}

function display_map_symbol_fiche_itineraire_3d($idItineraire) {
	global $module_name, $_headerContent, $currentlang, $db, $prefix;
	global $rep, $expression;
	global $My_SQL, $vars_mod, $carteSdp, $lienFicheSite3d, $name_table_itineraire, $separatorImageAlbum, $icon_plus_infos;
	require_once ("modules/SimpleCarto/lib/g_params.php");

	/* <!--<script type="text/javascript" src="modules/'.$module_name.'/language/lang-'.$currentlang.'.js" charset="UTF-8"></script>--> */
	$_headerContent = '
		<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key=' . $keymap . '" charset="UTF-8"></script>	
		<script type="text/javascript" src="https://www.google.com/jsapi" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/extensions-0.2.1.pack.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_autostart.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_XML_parser.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_AJAX.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_interface.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_string.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_carto_symb_fiche_itineraire_3d.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/becmsGallery/type/zoom_gallery/highslide/highslide-with-gallery.js"></script>
		<link rel="stylesheet" type="text/css" href="modules/becmsGallery/type/zoom_gallery/highslide/highslide.css" />
		<link rel="stylesheet" href="themes/' . $Default_Theme . '/style/becmsGallery.css" type="text/css">
		<link rel="stylesheet" type="text/css" href="modules/becmsGallery/type/zoom_gallery/css/default.css" />
		<script type="text/javascript">
			hs.lang = {
			   loadingText :     \'Chargement...\',
			   loadingTitle :    \'Cliquer pour annuler\',
			   focusTitle :      \'Cliquer pour amener au premier plan\',
			   fullExpandTitle : \'Afficher en taille relle\',
			   fullExpandText :  \'Taille relle\',
			   creditsText :     \'Dvelopp sur <i>Highslide JS</i>\',
			   creditsTitle :    \'Site Web de Highslide JS\',
			   previousText :    \'Prcdent\',
			   previousTitle :   \'Prcdent (flche gauche)\',
			   nextText :        \'Suivant\',
			   nextTitle :       \'Suivant (flche droite)\',
			   moveTitle :       \'Dplacer\',
			   moveText :        \'Dplacer\',
			   closeText :       \'Fermer\',
			   closeTitle :      \'Fermer (esc ou Echap)\',
			   resizeTitle :     \'Redimensionner\',
			   playText :        \'Lancer\',
			   playTitle :       \'Lancer le diaporama (barre d\\\'espace)\',
			   pauseText :       \'Pause\',
			   pauseTitle :      \'Suspendre le diaporama (barre d\\\'espace)\',
			   restoreTitle :    \'Cliquer pour fermer l\\\'image, cliquer et faire glisser pour dplacer, utiliser les touches flches droite et gauche pour suivant et prcdent.\'
			};
			hs.graphicsDir = \'modules/becmsGallery/type/zoom_gallery/highslide/graphics/\';
			hs.align = \'center\';
			hs.transitions = [\'expand\', \'crossfade\'];
			hs.outlineType = \'rounded-white\';
			hs.wrapperClassName = \'controls-in-heading\';
			hs.fadeInOut = true;
			//hs.numberPosition = \'caption\';
			hs.dimmingOpacity = 0.5;
			hs.showCredits = false;
			// Add the controlbar
			if (hs.addSlideshow) hs.addSlideshow({
				//slideshowGroup: \'group1\',
				interval: 5000,
				repeat: false,
				useControls: true,
				fixedControls: false,
				overlayOptions: {
					opacity: 1,
					position: \'top right\',
					hideOnMouseOut: false
				}
			});
		</script>
		<script type="text/javascript">
		//<![CDATA[
			var options = new Array;
			var racine_lib_module = "modules/SimpleCarto/lib";
			options["lienSite"] = "'.$lienFicheSite3d.'";
			options["icon_plus_infos"] = "'.$icon_plus_infos.'";
			options["id_carte"] = "'.$carteSdp.'";
			options["id_itineraire"] = "'.$idItineraire.'";
			options["http_host"] = "http://'.$_SERVER[HTTP_HOST].'/";
		   //]]>
		</script>
		<script type="text/javascript">
		// <![CDATA[
			//addToStart("GetMap('.$carteSdp.', '.$idItineraire.')");
			//addToStop(GUnload);
		// ]]>
		</script>';

	setHeader ( $_headerContent );
	$album = "";
	$album_travaux = "";
	$en_travaux = "0";

	$sql = "SELECT * FROM `".$prefix.$name_table_itineraire."` WHERE `id`=".$idItineraire;
	$search = $db->sql_query ( $sql );
	if ($db->sql_numrows ( $search ) != 0) {
		$donnees = $db->sql_fetchrow ( $search );

		$nom = strFrenchAndCorsican($donnees["nom_french"], $donnees["nom_corsican"]);
		$commune = $donnees['commune'];
		$description = strFrenchAndCorsican($donnees["description_french"], $donnees["description_corsican"]);
		$longueur = $donnees['longueur'];
		$difficulte = $donnees['difficulte_french'];
		$etat = $donnees['etat_french'];
		$commentaire = $donnees['commentaire'];
		$id_file = $donnees['id_download'];
		$en_travaux = $donnees['en_travaux'];

		$sql = "select photo_file FROM ".$prefix."_gallery_photo WHERE photo_albumid=".$donnees["id_album"]." ORDER BY photo_album DESC";
		$results = $db->sql_query ( $sql );

		if ($db->sql_numrows ( $results ) != 0) {
			while( $donnees_album = $db->sql_fetchrow ( $results ) ) {
				$album .= $donnees_album['photo_file'].$separatorImageAlbum;
			}
		}

		$sql = "select photo_file FROM ".$prefix."_gallery_photo WHERE photo_albumid=".$donnees["id_album_travaux"]." ORDER BY photo_album DESC";
		$results = $db->sql_query ( $sql );

		if ($db->sql_numrows ( $results ) != 0) {
			while( $donnees_album_trav = $db->sql_fetchrow ( $results ) ) {
				$album_travaux .= $donnees_album_trav['photo_file'].$separatorImageAlbum;
			}
		}

		$sql = "select url, title from ".$prefix."_downloads_downloads where lid=".$id_file;
		$results = $db->sql_query ( $sql );

		if ($db->sql_numrows ( $results ) != 0) {
			$donnees_file = $db->sql_fetchrow ( $results );
			$titleFile = $donnees_file['title'];
			$urlFile = $donnees_file['url'];
		}
	}

	$htmlNom = "";
	if( $nom != "" ) {
		$htmlNom = "<p>Nom : " . $nom . "</p><br />";
	}

	$htmlCommune = "";
	if( $commune != "" ) {
		$htmlCommune = "<p>Commune : ".$commune . "</p><br />";
	}

	$htmlDescription = "";
	if( $description != "" ) {
		$htmlDescription = "<p>Description : " . $description . "</p><br />";
	}

	$htmLongueur = "";
	if( $longueur != "" ) {
		$htmLongueur = "<p>Longueur : " . $longueur . "</p><br />";
	}

	$htmlDifficulte = "";
	if( $difficulte != "" ) {
		$htmlDifficulte = "<p>Difficulte : " . $difficulte . "</p><br />";
	}

	$htmlEtat = "";
	if( $etat != "" ) {
		$htmlEtat = "<p>Etat : " . $etat . "</p><br />";
	}

	$htmlCommentaire = "";
	if( $commentaire != "" ) {
		$htmlCommentaire = "<p>Commentaire : " . $commentaire . "</p><br />";
	}

	$htmlTitleFile = "";
	if( $titleFile != "" ) {
		$htmlTitleFile = '<p><a target="_blank" href="modules.php?name=Downloads&d_op=getit&lid='.$id_file.'"><img src="'.get_icon_for_file($urlFile).'" alt="" />'.$titleFile.'</a></p>';
	}

	$htmlAlbum = "";
	if( $album != "" )
		$htmlAlbum = "album : <br />".createAlbum($album);

	$htmlAlbumTravaux = "";
	if( $album_travaux != "" )
		$htmlAlbumTravaux = "album travaux : <br />".createAlbum($album_travaux);

	$sortie = '
		<div class="sdp">
			<h1 id="titre"></h1>
			<div id="commentaire"></div>
			<table border="0" cellpadding="0" cellspacing="0">
			<tr><td align="center" valign="top">
			<div class="desc_itineraire">
				'.$htmlNom.'
			</div>
			</td></tr>
			<tr><td valign="top">
			<input type="button" onclick="pointPrecedent();" value="Precedent"/>
       	  	<input type="button" onclick="pointSuivant();" value="Suivant"/>
			<input type="button" onclick="enterTour();" value="Enter Tour"/>
         	<input type="button" onclick="playTour();" value="Play Tour"/>
         	<input type="button" onclick="pauseTour();" value="Pause Tour"/>
        	<input type="button" onclick="resetTour();" value="Stop/Reset Tour"/>
       	  	<input type="button" onclick="exitTour();" value="Exit Tour"/>
			<div id="map3d"></div>
			</td><td width="20"></td><td valign="top">
			<div id="leg"></div>
			</td></tr></table>
			<p>&nbsp;</p>
			<div id="obs"></div>
			<div class="desc_itineraire">
				'.$htmlCommune.$htmlDescription.$htmLongueur.$htmlDifficulte.$htmlEtat.$htmlCommentaire.$htmlTitleFile.'
			</div>
			<div class="desc_itineraire">
				' . $htmlAlbum . $htmlAlbumTravaux . '
			</div>
		</div>';
	include ('header.php');


	if( $en_travaux == "1" ) {
		$sortie .= '<script type="text/javascript">
				//<![CDATA[
					document.getElementById("map").style.width = "200px";
					document.getElementById("map").style.height = "200px";
		   		//]]>
				</script>';
	}

	echo $sortie;

	$bardef = array ( // "print"=>"modules.php?name=Chuck_Norris_Facts&sop=print&page=$page",
			// "pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back" => "javascript:window.history.back();",
			"top" => "#top"
	);
	buttonBar ( $bardef, "align" );
	include ('footer.php');
}

function get_all_itineraires() {
    global $onglet, $db, $prefix, $page;
	global $name_table_itineraire;
	
	$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $domainName = $_SERVER['HTTP_HOST'];
    $serveur = $protocol.$domainName.'/';
	
	$r = new stdClass();
	
	$r->error = "";
	$r->result = "";
	
	$tab_sentier = array();
	
	$sql = "SELECT * FROM `".$prefix.$name_table_itineraire."`";
	$results = $db->sql_query ($sql);
	if ($db->sql_numrows ($results) != 0) {
	    while ($ligne = $db->sql_fetchrow ($results)) {
	        $sent = new stdClass();
	        
	        $sent->id = $ligne["id"];
	        
	        $nom_sent = new stdClass();
	        $nom_sent->fr = utf8_encode($ligne["nom_french"]);
	        $nom_sent->co = utf8_encode($ligne["nom_corsican"]);
	        $nom_sent->it = utf8_encode($ligne["nom_italian"]);
	        $nom_sent->uk = utf8_encode($ligne["nom_english"]);
	        $sent->nom_sentier = $nom_sent;
	        
	        $desc_sent = new stdClass();
	        $desc_sent->fr = utf8_encode($ligne["description_french"]);
	        $desc_sent->co = utf8_encode($ligne["description_corsican"]);
	        $desc_sent->it = utf8_encode($ligne["description_italian"]);
	        $desc_sent->uk = utf8_encode($ligne["description_english"]);
	        $sent->description = $desc_sent;
	        
	        $sent->longueur = utf8_encode($ligne["longueur"]);
	        
	        $diff_sent = new stdClass();
	        $diff_sent->fr = utf8_encode($ligne["difficulte_french"]);
	        $diff_sent->co = utf8_encode($ligne["difficulte_corsican"]);
	        $diff_sent->it = utf8_encode($ligne["difficulte_italian"]);
	        $diff_sent->uk = utf8_encode($ligne["difficulte_english"]);
	        $sent->difficulte = $diff_sent;
	        
	        if ($ligne["geom_centre"] == "") {
	            $sent->geom_centre = utf8_encode('{"type":"FeatureCollection","features":[]}');
	        }
	        else {
                $sent->geom_centre = utf8_encode($ligne["geom_centre"]);
	        }
	        
	        if ($ligne["id_album"] > 0) {
	            $sql = "SELECT photo_file FROM ".$prefix."_gallery_photo WHERE photo_albumid='".$ligne["id_album"]."' ORDER BY photo_album DESC;";
	            $results2 = $db->sql_query($sql);
                if ($db->sql_numrows($results2) != 0) {
                    if ($ligne2 = $db->sql_fetchrow($results2)) {
                        $sent->vignette = utf8_encode($serveur.$ligne2["photo_file"]);
                    }
                }
                else {
                    $sent->vignette = "";
                }
	        }
	        else {
	            $sent->vignette = "";
	        }
	        
	        $sent->md5 = md5(serialize($sent));
	        
	        $tab_sentier[] = $sent;
	    }
	}

	$r->result = $tab_sentier;
	
	$sortie = json_encode($r); 
	
	if (isset($_SERVER['HTTP_ORIGIN'])) {
        header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
        header('Access-Control-Allow-Credentials: true');
        header('Access-Control-Max-Age: 86400');    // cache for 1 day
    }
    // Access-Control headers are received during OPTIONS requests
    if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
        if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
            header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
                die();
    }
	
	header("Content-Type: application/json; charset=UTF-8");
    header('cache-control: no-cache'); // no-cache (important for mobile safari)
	echo $sortie;	
}

function get_one_itineraire($id_sentier) {
    global $onglet, $db, $prefix, $page;
	global $name_table_itineraire, $name_table_site;
	
	$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $domainName = $_SERVER['HTTP_HOST'];
    $serveur = $protocol.$domainName.'/';
	
    $result = new stdClass();
    $result->sentier = null;
    
	$r = new stdClass();
	
	$r->error = "";
	$r->result = $result;
	
	if ($id_sentier == "") {
	    $r->error = "Vous devez fixer un identifiant de sentier valide (idItineraire)";
	}
	else {
		$sql = "SELECT * FROM `".$prefix.$name_table_itineraire."` WHERE id='".$id_sentier."'";
    	$results = $db->sql_query ($sql);
    	if ($db->sql_numrows ($results) != 0) {
    	    if ($ligne = $db->sql_fetchrow ($results)) {
    	        $sent = new stdClass();
    	        
    	        $sent->id = $ligne["id"];
    	        
    	        $nom_sent = new stdClass();
    	        $nom_sent->fr = utf8_encode($ligne["nom_french"]);
    	        $nom_sent->co = utf8_encode($ligne["nom_corsican"]);
    	        $nom_sent->it = utf8_encode($ligne["nom_italian"]);
    	        $nom_sent->uk = utf8_encode($ligne["nom_english"]);
    	        $sent->nom_sentier = $nom_sent;
    	        
    	        $desc_sent = new stdClass();
    	        $desc_sent->fr = utf8_encode($ligne["description_french"]);
    	        $desc_sent->co = utf8_encode($ligne["description_corsican"]);
    	        $desc_sent->it = utf8_encode($ligne["description_italian"]);
    	        $desc_sent->uk = utf8_encode($ligne["description_english"]);
    	        $sent->description = $desc_sent;
    	        
    	        $sent->commune = utf8_encode($ligne["commune"]);  	            	        
    	        $sent->longueur = utf8_encode($ligne["longueur"]);
    	        
    	        $diff_sent = new stdClass();
    	        $diff_sent->fr = utf8_encode($ligne["difficulte_french"]);
    	        $diff_sent->co = utf8_encode($ligne["difficulte_corsican"]);
    	        $diff_sent->it = utf8_encode($ligne["difficulte_italian"]);
    	        $diff_sent->uk = utf8_encode($ligne["difficulte_english"]);
    	        $sent->difficulte = $diff_sent;
    	        
    	        $etat_sent = new stdClass();
    	        $etat_sent->fr = utf8_encode($ligne["etat_french"]);
    	        $etat_sent->co = utf8_encode($ligne["etat_corsican"]);
    	        $etat_sent->it = utf8_encode($ligne["etat_italian"]);
    	        $etat_sent->uk = utf8_encode($ligne["etat_english"]);
    	        $sent->etat = $etat_sent;
    	        
    	        $sent->tel_ot = utf8_encode($ligne["tel_ot"]);
    	        $sent->mail_ot = utf8_encode($ligne["mail_ot"]);
    	        
    	        if ($ligne["geom_centre"] == "") {
    	            $sent->geom_centre = utf8_encode('{"type":"FeatureCollection","features":[]}');
    	        }
    	        else {
                    $sent->geom_centre = utf8_encode($ligne["geom_centre"]);
    	        }
    	        
    	        if ($ligne["geom"] == "") {
    	            $sent->geom = utf8_encode('{"type":"FeatureCollection","features":[]}');
    	        }
    	        else {
                    $sent->geom = utf8_encode($ligne["geom"]);
    	        }
    	        
    	        if ($ligne["id_album"] > 0) {
    	            $sql = "SELECT * FROM ".$prefix."_gallery_photo WHERE photo_albumid='".$ligne["id_album"]."' ORDER BY photo_album DESC;";
    	            $results2 = $db->sql_query($sql);
                    if ($db->sql_numrows($results2) != 0) {
                        if ($ligne2 = $db->sql_fetchrow($results2)) {
                            $sent->vignette = utf8_encode($serveur.$ligne2["photo_file"]);
                        }
                        $db->sql_rowseek(0,$results2);
                        $tab_album = array();
                        while ($ligne2 = $db->sql_fetchrow($results2)) {
                            $photo = new stdClass();
                            
                            $photo->legende = utf8_encode($ligne2["photo_name"]);
                            $photo->photo = utf8_encode($serveur.$ligne2["photo_file"]);
                            
                            $tab_album[] = $photo;
                        }
                        $sent->album = $tab_album;
                    }
                    else {
                        $sent->vignette = "";
                        $sent->album = array();
                    }
    	        }
    	        else {
    	            $sent->vignette = "";
    	            $sent->album = array();
    	        }
    	        
    	        if (preg_match("#^http#", $ligne["visite"])) {
    	            $sent->visite_virtuelle = utf8_encode($ligne["visite"]);
    	        }
    	        else {
    	            if (preg_match("#^/#", $ligne["visite"])) {
    	                $ligne["visite"] = preg_replace("#^/#","",$ligne["visite"]);
    	            }
    	            $sent->visite_virtuelle = utf8_encode($serveur.$ligne["visite"]);
    	        }
    	        
    	        /* POI */
    	        $poi_tab = array();
    	        
    	        $sql = "SELECT * FROM `".$prefix.$name_table_site."` WHERE id_itineraire='".$id_sentier."'";
                $results3 = $db->sql_query($sql);
                if ($db->sql_numrows($results3) != 0) {
                    while ($ligne3 = $db->sql_fetchrow($results3)) {
                        $poi = new stdClass();
                        
                        $poi->nom_sentier = $nom_sent;
                        
                        $nom_poi = new stdClass();
            	        $nom_poi->fr = utf8_encode($ligne3["nom_french"]);
            	        $nom_poi->co = utf8_encode($ligne3["nom_corsican"]);
            	        $nom_poi->it = utf8_encode($ligne3["nom_italian"]);
            	        $nom_poi->uk = utf8_encode($ligne3["nom_english"]);
            	        $poi->nom = $nom_poi;
            	        
            	        $description_poi = new stdClass();
            	        $description_poi->fr = utf8_encode($ligne3["description_french"]);
            	        $description_poi->co = utf8_encode($ligne3["description_corsican"]);
            	        $description_poi->it = utf8_encode($ligne3["description_italian"]);
            	        $description_poi->uk = utf8_encode($ligne3["description_english"]);
            	        $poi->description = $description_poi;
            	        
            	        if ($ligne3["id_album"] > 0) {
            	            $sql = "SELECT * FROM ".$prefix."_gallery_photo WHERE photo_albumid='".$ligne["id_album"]."' ORDER BY photo_album DESC;";
            	            $results4 = $db->sql_query($sql);
                            if ($db->sql_numrows($results4) != 0) {
                                if ($ligne4 = $db->sql_fetchrow($results4)) {
                                    $poi->vignette = utf8_encode($serveur.$ligne4["photo_file"]);
                                    $poi->legende = utf8_encode($ligne4["photo_name"]);
                                }
                            }
                            else {
                                $poi->vignette = "";
                                $poi->legende = "";
                            }
            	        }
            	        else {
            	            $poi->vignette = "";
            	            $poi->legende = "";
            	        }
            	        
            	        $audio = new stdClass();
            	        $audio->fr = ($ligne3["audio_french"] != "" ? utf8_encode($serveur.$ligne3["audio_french"]) : "");
            	        $audio->co = ($ligne3["audio_corsican"] != "" ? utf8_encode($serveur.$ligne3["audio_corsican"]) : "");
            	        $audio->it = ($ligne3["audio_italian"] != "" ? utf8_encode($serveur.$ligne3["audio_italian"]) : "");
            	        $audio->uk = ($ligne3["audio_english"] != "" ? utf8_encode($serveur.$ligne3["audio_english"]) : "");
            	        
            	        $poi->audio = $audio;
            	        
            	        $poi->geom = $ligne3["geom"];
            	        $poi->geom_centre = $ligne3["geom_centre"];
            	        
                        $poi_tab[] = $poi;
                    }
                }
    	     
    	        $sent->pois = $poi_tab;
    	        
    	        $sent->md5 = md5(serialize($sent));
    	    }
    	}
    	else {
    	    $r->error = "Vous devez fixer un identifiant de sentier valide (idItineraire)";
    	}
	}
	
	$r->result->sentier = $sent;
	
	$sortie = json_encode($r);
	
	if (isset($_SERVER['HTTP_ORIGIN'])) {
        header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
        header('Access-Control-Allow-Credentials: true');
        header('Access-Control-Max-Age: 86400');    // cache for 1 day
    }
    // Access-Control headers are received during OPTIONS requests
    if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
        if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
            header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
                die();
    }
	
	header("Content-Type: application/json; charset=UTF-8");
    header('cache-control: no-cache'); // no-cache (important for mobile safari)
	echo $sortie;	
}

switch ($sop) {
	case "map_itineraires":
		display_map_symbol_itineraires ($ti);
		break;
	case "map_block_itineraires" :
		display_map_symbol_block_itineraires ();
		break;
	case "map_fiche_itineraire":
		display_map_symbol_fiche_itineraire($idItineraire);
		break;
	case "map_fiche_site":
		display_map_symbol_fiche_site($idSite);
		break;
	case "map_itineraires_3d":
		display_map_symbol_itineraires_3d();
		break;
	case "map_fiche_itineraire_3d":
		display_map_symbol_fiche_itineraire_3d($idItineraire);
		break;
	case "map_pict_XML_itineraires" :
		get_map_pict_XML_itineraires ( $ti, $theme, $circuit, $rech );
		break;
	case "map_pict_XML_fiche_itineraire" :
		get_map_pict_XML_fiche_itineraires ( $idItineraire );
		break;
	case "map_pict_XML_fiche_site":
		get_map_pict_XML_fiche_site($idSite);
		break;
		
	case "get_all_itineraires":
	    get_all_itineraires();
	    break;
	case "get_one_itineraire":
	    get_one_itineraire($idItineraire);
	    break;
		
	default :
		display_menu ();
		break;
}
?>