<?php
global $prefix, $db, $nukeurl, $currentlang;
global $sql_create_table_temp, $module_name;

require_once ("modules/$module_name/system/params.php");
require_once ("modules/$module_name/system/functions.php");
require_once ("modules/$module_name/system/xmlparser.php");

require_once ("core/becms_mainlib_lib.php");

$nomsFichiers = dezip_file($url_point_kmz);

$dir_picts = $uploadFolder."/../cbnc_3D/";
foreach($nomsFichiers as $fichier_move) {
	if (preg_match("#\.png$#i", $fichier_move)) {
		rename($dirtemp.$fichier_move, $dirtemp."cbnc_3D/".$fichier_move);
	}
	if (preg_match("#\.kml$#i", $fichier_move)) {
		$fichier_source = $dirtemp.$fichier_move;
	}
}

global $observation, $contentTag;
global $bool_placemark, $bool_style;

$contentTag = "";
$observation = array();
$bool_placemark = false;
$style = array();
$bool_style = false;
$bool_multigeom = false;
$content_multigeom = "";

$sortie_result = "";

if (file_exists ( $fichier_source )) {
	alerte("begin parsing : " . $fichier_source);
	if (! empty_data_file ( $fichier_source )) {
		viderDbObservation();
		parse_file ( $fichier_source, "openTagObservation", "closeTagObservation", "contentTagObservation" );
		viderDbObservationStyle();
		parse_file ( $fichier_source, "openTagStyle", "closeTagStyle", "contentTagStyle" );
	}
	alerte("end parsing : " . $fichier_source);
	unlink($fichier_source);
}

function openTagObservation($parseur, $nomBalise, $tableauAttributs) {
	global $bool_placemark, $bool_multigeom;
	global $contentTag, $content_multigeom;
	
	$contentTag = "";
	
	if ($nomBalise == "Placemark") {
		$bool_placemark = true;
	}
	if ($bool_multigeom) {
		$content_multigeom .= '<'.$nomBalise.'>';
	}
	else {
		$content_multigeom = "";
	}
	if ($nomBalise == "Point") {
		$bool_multigeom = true;
	} 
}

function closeTagObservation($parseur, $nomBalise) {
	global $observation, $bool_placemark, $bool_multigeom;
	global $rub_observation;
	global $contentTag, $content_multigeom;
	global $sortie_result;
	
	if ($bool_placemark) {
		if ($contentTag != "" && isset ($rub_observation [$nomBalise])) {
			if ($rub_observation [$nomBalise] == "id_style") {
				$contentTag = str_replace("#", "", $contentTag);
			}
			$observation[$rub_observation[$nomBalise]] .= convertToDB($contentTag);
		}
	} 
	if ($bool_placemark && $nomBalise == "Placemark") {
		$bool_placemark = false;
		//traiter la description avant l'enregistrement
		$valeursplusobservation = parse_description($observation[$rub_observation["description"]]);
		foreach ($valeursplusobservation as $key=>$value) {
			$observation[$key] = $value;
		}
		$valeursplusobservation = array();
	
		$sortie_result .= "Enregistrement ".$observation["id_fiche"]."\n";
		$result = saveDbObservation($observation);
		if ($result === false) {
			$sortie_result .= "====================================> Erreur";
		}
		
		//array_splice ($observation, 0, count ($observation));
		$observation = array();
	}
	if ($bool_multigeom) {
		if ($nomBalise == "Point") {
			$observation[$rub_observation["$nomBalise"]] = trim($content_multigeom);
			$bool_multigeom = false;
		}
		else {
			$content_multigeom .= '</'.$nomBalise.'>';
		}
	}
}

function contentTagObservation($parseur, $texte) {
	global $bool_placemark, $bool_multigeom;
	global $contentTag, $content_multigeom;
	if ($bool_placemark) {
		$contentTag .= $texte;
	}
	if ($bool_multigeom) {
		$content_multigeom .= $texte;
	}
}

function openTagStyle($parseur, $nomBalise, $tableauAttributs) {
	global $bool_style;
	global $contentTag;
	global $style;
	global $rubstyle;
	
	
	if ($bool_style) {
		$contentTag .= '<'.$nomBalise.'>';
	}
	else {
		$contentTag = "";
	}
	
	if ($nomBalise ==  "Style") {
		$bool_style = true;
		$contentTag = "";
		$style[$rubstyle["id"]] = $tableauAttributs["id"];
	}
}

function closeTagStyle($parseur, $nomBalise) {
	global $style, $bool_style;
	global $contentTag;
	global $rubstyle;
	global $sortie_result;
	
	if ($bool_style) {
		if ($nomBalise == "Style") {
			$style[$rubstyle["content"]] = trim($contentTag);
			$bool_style = false;
			
			$sortie_result .= "Enregistrement ".$style["id_style"]."\n";
			$result = saveDbObservationStyle($style);
			if ($result === false) {
				$sortie_result .= "====================================> Erreur";
			}
			//print_r($style);
			$style = array();
		}
		else {
			$contentTag .= '</'.$nomBalise.'>';
		}
	}
}

function contentTagStyle($parseur, $texte) {
	global $bool_style;
	global $contentTag;
	if ($bool_style) {
		$contentTag .= $texte;
	}
}

function parse_description($texte = "") {
	global $rub_suppl_observation;
	//on parse le tableau HTML sous forme de titre/valeur
	$sortie = array();
	foreach ($rub_suppl_observation as $label=>$valeur) {
		if (preg_match("#<td>".$label."</td>[^<]*<td>([^<]*)</td>#ims", $texte,$matches)) {
			$sortie[$valeur] = $matches[1];
		}
	}
	return $sortie;
}
?>