<?php
	/**
	 * Permet de copier un fichier dans un autre
	 * @param unknown $nomsource le nom du fichier source
	 * @param unknown $nomdest le nom du fichier destinatere
	 */
	function get_data_to_file($nomsource, $nomdest) {
		alerteoption("\ndebut : " .$nomsource. " ".date("H:i:s"));
		$kb = 0;
		$len = 0;
		$tailledatablock = 8192;
		$tentatives = 1;
		unset($source);
		$source = "";
		while (!$source) {
			$source = fopen($nomsource, "rb");
			if ($tentatives >= 20) {
				die('Erreur sur ouverture de : '.$nomsource);
			}
			$tentatives++;
		}
		if( !$source ) {
			die('Erreur sur ouverture de : '.$nomsource);
		}
		
		unset($dest);
		$dest = fopen($nomdest,"wb");
		if (!$dest) {
			die('Erreur sur ouverture de : '.$nomdest);
		}
		while (!feof($source)) {
			$tampon = fread($source,$tailledatablock);
			fwrite($dest,$tampon);
			$kb+=strlen($tampon);
			$cnt = $kb." octets tÃ©lÃ©chargÃ©s";
			//alerteoption(str_repeat(chr(8),$len).$cnt);
			$len = strlen($cnt);
		}
		fclose($source);
		fclose($dest);
		alerteoption("\nfin : " .$nomsource. " ".date("H:i:s"));
		alerteoption("\n");
	}
	
	/**
	 * Permet de vérifier si le fichier est vide ou non
	 * @param unknown $nomsource le nom du fichier a vérifier
	 * @return boolean true le fichier est vide, false sinon
	 */
	function empty_data_file($nomsource) {
		$tailledatablock = 8192;
		if (file_exists($nomsource)) {
			$source = fopen($nomsource,"rb");
			$data = fread($source,$tailledatablock);
			if (preg_match("/^<([^>]+)>(\n|\r|\s)*<([^>]+)><\/([^>]+)>(\n|\r|\s)*$/im", $data)) {
				fclose($source);
				return true;
			}
			if (preg_match("/^<([^>]+)>(\n|\r|\s)*<([^>]+)><fault>/im", $data)) {
				fclose($source);
				return true;
			}
			fclose($source);
			return false;
		}
	}
	
	/**
	 * Permet d'afficher le texte
	 * @param unknown $texte le text
	 */
	function alerte($texte) {
		global $sortie_result;
		$sortie_result .= $texte."\n";
	}
	
	/**
	 * PErmet d'afficher les messages ou pas
	 * @param unknown $texte le texte
	 */
	function alerteoption($texte) {
		global $withlogfile;
		global $sortie_result;
		if (!$withlogfile) {
			$sortie_result .= $texte;
		}
	}
	
	function escquote($texte) {
		$texte = str_replace("\"", "\\\"", $texte);
		return $texte;
	}
	
	function delantislash($texte) {
		$texte = str_replace("\\", "", $texte);
		return $texte;
	}
	
	/**
	 * Permet de convertir la chaine pour la base de donnees
	 * @param unknown $texte le texte
	 * @return unknown le texte
	 */
	function convertToDB($texte) {
		//$texte = str_replace("\xCA\xBC", "'", $texte);//conversion de "�" en "'"
		$texte = str_replace("&#039;", "'", $texte);
		$texte = str_replace("’", "'", $texte);//conversion de "�" en "'"
		$texte = str_replace("", "'", $texte); //il y a caractère invisible dans la chaîne à trouver
		$texte = str_replace("…", "...", $texte);
		$texte = str_replace("“", "\"", $texte);
		$texte = str_replace("”", "\"", $texte);
		$texte = str_replace("‘", "'", $texte);
		$texte = str_replace("€", "&euro;", $texte);
		$texte = str_replace("•", "&bull;", $texte);
		$texte = str_replace("–", "-", $texte);
		$texte = str_replace("é", "é", $texte);
		$texte = str_replace("à", "à", $texte);
		$texte = escquote($texte);
		$texte = delantislash($texte);
		$texte = utf8_decode($texte);
		return $texte;
	}
	
	function conditionnertodb($texte) {
		return str_replace("'", "''", $texte);
	}
	
	/**
	 * Permet de convertir une chaine de caractère en boolean
	 * @param unknown $texte le texte a convertire
	 * @return string le boolean
	 */
	function conditionnerBoolean($texte) {
		if( $texte == "SI" || $texte == "Sito Accessit" ) {
			$texte = "1";
		} else {
			$texte = "0";
		}
		return $texte;
	}
	
	/**
	 * Permet de sauvegarder un itineraire dans la base de donnees
	 * @param unknown $itineraires le tableau de l'itineraire
	 * @return boolean l'id de l'itineraire, false sinon
	 */
	function saveDbItineraire($itineraires) {
		global $prefix, $db;
		global $name_table_itineraire_temp;
		global $fr_boolean_itineraire;
		if (isset($fr_boolean_itineraire) && (is_array($fr_boolean_itineraire))) {
			foreach ($fr_boolean_itineraire as $champBoolean) {
				if( isset($itineraires[$champBoolean]) ) {
					$itineraires[$champBoolean] = conditionnerBoolean($itineraires[$champBoolean]);
				}
			}
		}
		$itineraires = array_map('conditionnertodb', $itineraires);
		$list_champs = "";
		$list_valeurs = "";
		if ($itineraires["id"] == "-1" || $itineraires["id"] == "" || $itineraires["id"] == "0") {
			$list_champs = ""; 
			$list_valeurs = "";
			foreach($itineraires as $key => $value) {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."`";
				$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
				$list_valeurs .= "'".$value."'";
			}
			$sql = "INSERT INTO ".$prefix.$name_table_itineraire_temp." (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		} else {
			$list_champs = ""; 
			$list_valeurs = "";
			foreach($itineraires as $key => $value) {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."` = '".$value."'";
			}
			$sql = "UPDATE ".$prefix.$name_table_itineraire_temp." SET ".$list_champs." WHERE `id` = '".$itineraires["id"]."';";
		}
		//die($sql);
		if( $db->sql_query($sql)) {
			return $db->sql_nextid();
		} else {
			return false;
		}
	}
	
	/**
	 * Permet de sauvegarder un site dans la base de donnees
	 * @param unknown $itineraires le tableau d'un site
	 * @return boolean l'id du site, false sinon
	 */
	function saveDbSite($site) {
		global $prefix, $db;
		global $name_table_site_temp;
		global $fr_boolean_site;
		foreach ($fr_boolean_site as $champBoolean => $arrayBooleanSite) {
			if( isset($site[$champBoolean]) ) {
				$site[$champBoolean] = conditionnerBoolean($site[$champBoolean]);
			}
		}
		$site = array_map('conditionnertodb', $site);
		$list_champs = "";
		$list_valeurs = "";
		if ($site["id"] == "-1" || $site["id"] == "" || $site["id"] == "0") {
			$list_champs = "";
			$list_valeurs = "";
			foreach($site as $key => $value) {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."`";
				$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
				$list_valeurs .= "'".$value."'";
			}
			$sql = "INSERT INTO ".$prefix.$name_table_site_temp." (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		} else {
			$list_champs = "";
			$list_valeurs = "";
			foreach($site as $key => $value) {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."` = '".$value."'";
			}
			$sql = "UPDATE ".$prefix.$name_table_site_temp." SET ".$list_champs." WHERE `id` = '".$site["id"]."';";
		}
		//die($sql);
		if( $db->sql_query($sql)) {
			return $db->sql_nextid();
		} else {
			return false;
		}
	}
	
	/**
	 * Permet de vérifier l'integrite des donnees
	 * @return boolean true si tout est bon, false sinon
	 */
	function verifDonneesTables() {
		global $nbItineraire, $nbSite;
		global $prefix, $db;
		global $name_table_itineraire_temp, $name_table_site_temp;
		$ok = true;
		// Table itineraire
		$result = $db->sql_query("select count(id) from ".$prefix.$name_table_itineraire_temp);
		if ($db->sql_numrows($result) > 0) {
			if( list($nbIds) = $db->sql_fetchrow($result) ) {
				if( $nbIds != $nbItineraire || $nbIds == 0 ) {
					alerte("Une erreur c'est produite dans la table des itineraires (nombres d'éléments récupéré est différents au nombres d'élément dans la base de données ou pas d'éléments)");
					$ok = false;
				}
			}
		}
		// Table site
		$result = $db->sql_query("select count(id) from ".$prefix.$name_table_site_temp);
		if ($db->sql_numrows($result) > 0) {
			if( list($nbIds) = $db->sql_fetchrow($result) ) {
				if( $nbIds != $nbSite || $nbIds == 0 ) {
					alerte("Une erreur c'est produite dans la table des sites (nombres d'éléments récupéré est différents au nombres d'élément dans la base de données ou pas d'éléments)");
					$ok = false;
				}
			}
		}
		return $ok;
	}
	
	/**
	 * Permet de deplacer les bases de donnees en les renomment
	 * @return boolean true si tout est bon, false sinon
	 */
	function movedatabase() {
		global $prefix, $db;
		global $name_table_itineraire, $name_table_site;
		global $name_table_itineraire_temp, $name_table_site_temp;
		$ok = true;
		if( $db->sql_query("DROP TABLE IF EXISTS `".$prefix.$name_table_itineraire."`;") ) {
			if( !$db->sql_query("RENAME TABLE ".$prefix.$name_table_itineraire_temp." to ".$prefix.$name_table_itineraire.";") ) {
				$ok = false;
			}
		} else {
			$ok = false;
		}
		if( $db->sql_query("DROP TABLE IF EXISTS `".$prefix.$name_table_site."`;") ) {
			if( !$db->sql_query("RENAME TABLE ".$prefix.$name_table_site_temp." to ".$prefix.$name_table_site.";") ) {
				$ok = false;
			}
		} else {
			$ok = false;
		}
		return $ok;
	}
	
	/**
	 * Permet de récupérer une image et de la copier
	 * @param unknown $nomsource le nom de la source de l'image
	 * @param unknown $nomdest le nom du destinatere de l'image
	 */
	function get_data_to_image($nomsource, $nomdest) {
		alerteoption("\ndebut : " .$nomsource. " ".date("H:i:s"));
		$kb = 0;
		$len = 0;
		$tailledatablock = 8192;
		$tentatives = 1;
		unset($source);
		$source = "";
		while (!$source) {
			$source = fopen($nomsource, "rb");
			if ($tentatives >= 20) {
				die('Erreur sur ouverture de : '.$nomsource);
			}
			$tentatives++;
		}
		if( !$source ) {
			die('Erreur sur ouverture de : '.$nomsource);
		}
	
		$tmp = tmpfile();
		if( !$tmp ) {
			die("Erreur dans la création du fichier temporaire");
		}
		while(!feof($source)) {
			$tampon = fread($source, $tailledatablock);
			fwrite($tmp, $tampon);
		}
		fclose($source);
		rewind($tmp);
		
		unset($dest);
		$dest = fopen($nomdest,"wb");
		if (!$dest) {
			die('Erreur sur ouverture de : '.$nomdest);
		}
		while (!feof($tmp)) {
			$tampon = fread($tmp, $tailledatablock);
			fwrite($dest, $tampon);
			$kb += strlen($tampon);
			$cnt = $kb." octets tÃ©lÃ©chargÃ©s";
			//alerteoption(str_repeat(chr(8),$len).$cnt);
			$len = strlen($cnt);
		}
		fclose($tmp);
		fclose($dest);
		alerteoption("\nfin : " .$nomsource. " ".date("H:i:s"));
		alerteoption("\n");
	}
	
	function dezip_file($zipfile) {
		$return = true;
		$sortie = array();
		$zip = zip_open($zipfile);
		if(is_resource($zip)){
			while(($zip_entry = zip_read($zip)) !== false){
				alerte("Unpacking ".zip_entry_name($zip_entry)."\n");
				if(strpos(zip_entry_name($zip_entry), DIRECTORY_SEPARATOR) !== false){
					$last = strrpos(zip_entry_name($zip_entry), DIRECTORY_SEPARATOR);
					$dir = substr(zip_entry_name($zip_entry), 0, $last);
					$file = substr(zip_entry_name($zip_entry), strrpos(zip_entry_name($zip_entry), DIRECTORY_SEPARATOR)+1);
					if(!is_dir($dir)){
						@mkdir($dir, 0755, true) or die("Unable to create $dir\n");
					}
					if(strlen(trim($file)) > 0){
						//mon ancienne façon de faire
						//$return = @file_put_contents(dirname($zipfile)."/".$dir."/".$file, zip_entry_read($zip_entry, zip_entry_filesize($zip_entry)));
						
						$size = zip_entry_filesize($zip_entry);
			            $name = $file;
			            $unzipped = fopen(dirname($zipfile)."/".$dir."/".$name,'wb');
			            while($size > 0){
			                $chunkSize = ($size > 10240) ? 10240 : $size;
			                $size -= $chunkSize;
			                $chunk = zip_entry_read($zip_entry, $chunkSize);
			                if($chunk !== false) {
			                	$return = $return && fwrite($unzipped, $chunk);
			                }
			            }
			            fclose($unzipped);
		            
						if($return === false){
							die("Unable to write file $dir/$file\n");
						}
						else {
							$sortie[] = $dir."/".$file;
						}
					}
				}
				else {
					//mon ancienne façon de faire...
					//$return = file_put_contents(dirname($zipfile)."/".zip_entry_name($zip_entry), zip_entry_read($zip_entry, zip_entry_filesize($zip_entry)));
					
					$size = zip_entry_filesize($zip_entry);
		            $name = zip_entry_name($zip_entry);
		            $unzipped = fopen(dirname($zipfile)."/".$name,'wb');
		            while($size > 0){
		                $chunkSize = ($size > 10240) ? 10240 : $size;
		                $size -= $chunkSize;
		                $chunk = zip_entry_read($zip_entry, $chunkSize);
		                if($chunk !== false) {
		                	$return = $return && fwrite($unzipped, $chunk);
		                }
		            }
		            fclose($unzipped);
					
					if($return === false){
						die("Unable to write file ".zip_entry_name($zip_entry)."\n");
					}
					else {
						$sortie[] = zip_entry_name($zip_entry);
					}
				}
			}
		}
		else {
			die("Unable to open zip file. Error : $zip\n");
		}
		return $sortie;
	}
	
	function saveDbSerie($serie) {
		global $prefix, $db;
		$serie = array_map('conditionnertodb', $serie);
		$list_champs = "";
		$list_valeurs = "";
		if ($serie["id"] == "-1" || $serie["id"] == "" || $serie["id"] == "0") {
			$list_champs = ""; 
			$list_valeurs = "";
			foreach($serie as $key => $value) {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."`";
				$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
				$list_valeurs .= "'".$value."'";
			}
			$sql = "INSERT INTO ".$prefix."_cbnc_serie_vegetation (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		}
		else {
			$list_champs = ""; 
			$list_valeurs = "";
			foreach($serie as $key => $value) {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."` = '".$value."'";
			}
			$sql = "UPDATE ".$prefix."_cbnc_serie_vegetation SET ".$list_champs." WHERE `id` = '".$serie["id"]."';";
		}
		if( $db->sql_query($sql)) {
			return $db->sql_nextid();
		}
		else {
			return false;
		}
	}
	
	function viderDbSerie() {
		global $prefix, $db;
		
		$sql = "TRUNCATE `".$prefix."_cbnc_serie_vegetation` ";
		return $db->sql_query($sql);
	}
	
	function saveDbSerieStyle($style) {
		global $prefix, $db;
		$style = array_map('conditionnertodb', $style);
		$list_champs = "";
		$list_valeurs = "";
		if ($style["id"] == "-1" || $style["id"] == "" || $style["id"] == "0") {
			$list_champs = ""; 
			$list_valeurs = "";
			foreach($style as $key => $value) {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."`";
				$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
				$list_valeurs .= "'".$value."'";
			}
			$sql = "INSERT INTO ".$prefix."_cbnc_serie_vegetation_styles  (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		}
		else {
			$list_champs = ""; 
			$list_valeurs = "";
			foreach($style as $key => $value) {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."` = '".$value."'";
			}
			$sql = "UPDATE ".$prefix."_cbnc_serie_vegetation_styles  SET ".$list_champs." WHERE `id` = '".$style["id"]."';";
		}
		if( $db->sql_query($sql)) {
			return $db->sql_nextid();
		}
		else {
			return false;
		}
	}
	
	function viderDbSerieStyle() {
		global $prefix, $db;
		
		$sql = "TRUNCATE `".$prefix."_cbnc_serie_vegetation_styles` ";
		return $db->sql_query($sql);
	}
	
	function date2AMJ($ladate){
		if ($ladate == "") {
			return "0000-00-00 00:00:00";
		}
		else {
			list ($ladate,$lheure) = explode(" ",$ladate);
			list($jour,$mois,$annee) = explode("/",$ladate);
			$jour = str_pad($jour, 2, "0",STR_PAD_LEFT);
			$mois = str_pad($mois, 2, "0",STR_PAD_LEFT);
			if (strlen($annee) == 2) {
				$annee = "20".$annee;
			}
			elseif (strlen($annee) == 1) {
				$annee = "200".$annee;
			}
		}
		if ($lheure != "") {
			$lheure = " ".$lheure;
		}
		return "$annee-$mois-$jour$lheure";
	}
	
	function date2JMA($ladate){
		if ($ladate == "0000-00-00 00:00:00" || $ladate == "0000-00-00" || $ladate == "") {
			return "";
		}
		else {
			//list($an,$mois,$jour) = explode("-",$ladate);
			//return $jour."/".$mois."/".$an;
			return preg_replace("#([0-9]{4})-([0-9]{2})-([0-9]{2})#i","\\3/\\2/\\1",$ladate);
		}
	}
	
	function saveDbObservation($observation) {
		global $prefix, $db;
		$observation = array_map('conditionnertodb', $observation);
		$observation["date_obs"] = date2AMJ($observation["date_obs"]);
		$observation["latitude"] = str_replace(",", ".", $observation["latitude"]);
		$observation["longitude"] = str_replace(",", ".", $observation["longitude"]);
		$list_champs = "";
		$list_valeurs = "";
		if ($observation["id"] == "-1" || $observation["id"] == "" || $observation["id"] == "0") {
			$list_champs = ""; 
			$list_valeurs = "";
			foreach($observation as $key => $value) {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."`";
				$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
				$list_valeurs .= "'".$value."'";
			}
			$sql = "INSERT INTO ".$prefix."_cbnc_serie_observations (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		}
		else {
			$list_champs = ""; 
			$list_valeurs = "";
			foreach($observation as $key => $value) {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."` = '".$value."'";
			}
			$sql = "UPDATE ".$prefix."_cbnc_serie_observations SET ".$list_champs." WHERE `id` = '".$observation["id"]."';";
		}
		//echo $sql."\n**************************";
		if( $db->sql_query($sql)) {
			return $db->sql_nextid();
		}
		else {
			return false;
		}
	}
	
	function viderDbObservation() {
		global $prefix, $db;
		
		$sql = "TRUNCATE `".$prefix."_cbnc_serie_observations` ";
		return $db->sql_query($sql);
	}
	
	function saveDbObservationStyle($style) {
		global $prefix, $db;
		$style = array_map('conditionnertodb', $style);
		$list_champs = "";
		$list_valeurs = "";
		if ($style["id"] == "-1" || $style["id"] == "" || $style["id"] == "0") {
			$list_champs = ""; 
			$list_valeurs = "";
			foreach($style as $key => $value) {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."`";
				$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
				$list_valeurs .= "'".$value."'";
			}
			$sql = "INSERT INTO ".$prefix."_cbnc_serie_observation_styles (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		}
		else {
			$list_champs = ""; 
			$list_valeurs = "";
			foreach($style as $key => $value) {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."` = '".$value."'";
			}
			$sql = "UPDATE ".$prefix."_cbnc_serie_observation_styles SET ".$list_champs." WHERE `id` = '".$style["id"]."';";
		}
		if( $db->sql_query($sql)) {
			return $db->sql_nextid();
		}
		else {
			return false;
		}
	}
	
	function viderDbObservationStyle() {
		global $prefix, $db;
		
		$sql = "TRUNCATE `".$prefix."_cbnc_serie_observation_styles` ";
		return $db->sql_query($sql);
	}
?>