<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2005 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

//if (!defined('MODULE_FILE')) {
//	die ("You can't access this file directly...");
//}
if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}
require_once("core/becms_mainlib_lib.php");
require_once("core/becms_ui_component.php");
require_once("images/filetypes/filetypes.php");
require_once("includes/truncate_string.php");

$module_name = basename(dirname(__FILE__));
get_lang($module_name);
$userpage = 1;

//require_once("modules/$module_name/lib_db.php");
require_once("modules/$module_name/utils.php");

function array_implode( $glue, $separator, $array ) {
	if ( ! is_array( $array ) ) return $array;
	$string = array();
	foreach ( $array as $key => $val ) {
		if ( is_array( $val ) )
		$val = implode( ',', $val );
		$string[] = "{$key}{$glue}{$val}";
		 
	}
	return implode( $separator, $string );
	 
}

function array_explode( $glue, $separator, $string ) {
	$groupes = explode($separator, $string);
	$sortie = array();
	foreach($groupes as $groupe) {
		list($key, $value) = explode ($glue,$groupe);
		$sortie[$key]=$value;
	}
	return $sortie;
}

function format_nuke_url_2($nukeurl) {
	$tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}
	return $racine;
}

function array_explode_2( $glue, $separator, $string ) {
	$groupes = explode($separator, $string);
	$sortie = array();
	foreach($groupes as $groupe) {
		list($key, $value) = explode ($glue,$groupe);
		$sortie[$key]=$value;
	}
	return $sortie;
}

function new_pratique($id="") {
	global $_headerContent, $group, $user,$module_name, $db, $user_prefix, $downloadprivspacecat, $admin;
	global $formatdateprivspacepub, $bpusersgroups, $page;

	if (is_user($user) || is_admin($admin)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode_2( "@",";", $userdata[11]);

		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];
	  
		$lignebp = array();
		//pour dition de la fiche
		if ($id != "") {
			$result = $db->sql_query("SELECT  `id` , `id_user` , `titre`, `partenaire` , `resume` , `contexte`, `targetobs`, `objectifs` , `resultat` , `perspective` , `pays` , `region` , `statut` , `id_file`, `photo` FROM ".$user_prefix."_bpratique WHERE id='".$id."';");
			if ($db->sql_numrows($result) > 0) {
				$lignebp = $db->sql_fetchrow($result);
				if ($lignebp["id_user"] != $userdata[0] && !is_admin($admin)) {
					die("Accs non autoris !");
				}
			}
			else {
				die("Commentaire inexistant !");
			}
		}
		//rcup liens
		if ($id != "") {
			if (file_exists('themes/'.$Default_Theme.'/images/icon_eye.gif')) {
				$icneye = 'themes/'.$Default_Theme.'/images/icon_eye.gif';
			}
			else {
				$icneye = 'images/icon_eye.gif';
			}
			if (file_exists('themes/'.$Default_Theme.'/images/deletesmall.gif')) {
				$icn = 'themes/'.$Default_Theme.'/images/deletesmall.gif';
			}
			else {
				$icn = 'images/deletesmall.gif';
			}
				
			$sql = "SELECT id, titre, url";
			$sql .= " FROM `".$user_prefix."_bpratique_liens`";
			$sql .= " WHERE id_pratique='".$id."';";
			$result = $db->sql_query($sql);
			$listeliens = "";
			if ($db->sql_numrows($result) > 0) {
				while ($lignebp2 = $db->sql_fetchrow($result)) {
					$lelien = '<input type="text" name="data[newlinksurl]['.$lignebp2["id"].']" value="'.$lignebp2["url"].'" size="50" maxlength="100" class="newurl">';
					$lelien .= '<input type="text" name="data[newlinkstitre]['.$lignebp2["id"].']" value="'.$lignebp2["titre"].'" size="50" maxlength="100" class="newurl">';
					 
					$btnview = "<a href=\"".$lignebp2["url"]."\" target=\"_blank\">";
					$btnview .= "<img src=\"$icneye\" border=\"0\" align=\"top\">";
					$btnview .= "</a>";
					 
					$btndel = "<a href=\"modules.php?name=".$module_name."&op=dellink&id_link=".$lignebp2["id"]."&id=".$id."&page=".$page."\">";
					$btndel .= "<img src=\"$icn\" border=\"0\" align=\"top\">";
					$btndel .= "</a>";
					 
					$listeliens .= '<li style="clear: both;"><span style="float: right">'.$btnview." ".$btndel.'</span> '.$lelien.''.'</li>';
				}
				$listeliens = "<ul class=\"listpubli\">".$listeliens."</ul>";
			}
		}
		//rcup catgories
		if ($id != "") {
			$sql = "SELECT id_cat";
			$sql .= " FROM `".$user_prefix."_bpratique_cat_link`";
			$sql .= " WHERE id_pratique='".$id."' AND level='1';";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				$lignebp2 = $db->sql_fetchrow($result);
				$cat1 = all_way_cat($lignebp2["id_cat"]);
				$catid1 = $lignebp2["id_cat"];
			}
			$sql = "SELECT id_cat";
			$sql .= " FROM `".$user_prefix."_bpratique_cat_link`";
			$sql .= " WHERE id_pratique='".$id."' AND level='2';";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				$cat2 = "";
				while ($lignebp2 = $db->sql_fetchrow($result)) {
					$cat2 .= ($cat2 != "" ? "\n" : "");
					$cat2 .= all_way_cat($lignebp2["id_cat"]);
					$catid2 .= ($catid2 != "" ? "\n" : "");
					$catid2 .= $lignebp2["id_cat"];
				}
			}
		}
		//rcup valeurs statut
		$menustatut = '<select name="data[statut]" size="1">';
		$menustatut .= '<option value="">'._FBP_STATUS_CHOOSE.'</option>';
		$sql = "SHOW COLUMNS FROM ".$user_prefix."_bpratique LIKE 'statut';";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) > 0) {
			if ($lignebp2 = $db->sql_fetchrow($result)) {
				$regex = "/'(.*?)'/";
				preg_match_all( $regex , $lignebp2[1], $enum_array );
				$enum_fields = $enum_array[1];
				foreach ($enum_fields as $values) {
					$selected = ($values == $lignebp["statut"]) ? " selected=\"selected\"" : "" ;
					$menustatut .= '<option value="'.$values.'"'.$selected.'>'.$values.'</option>';
				}
			}
		}
		$menustatut .= "</select>";
	  
		//rcup users du groupe - A virer aprs premire opration de saisie
		$menuusers = '<select name="data[id_user]" size="1">';
		$menuusers .= '<option value="">'._FBP_USER_CHOOSE.'</option>';
		$sql = "SELECT uid,uname, user_name, user_firstname, adh_web";
		$sql .= " FROM `".$user_prefix."_users`";
		$sql .= " INNER JOIN `".$user_prefix."_users_groups` ON uid=user_id";
		$sql .= " WHERE group_id='".$bpusersgroups."' ORDER BY uname ASC;";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) > 0) {
			while ($lignebp2 = $db->sql_fetchrow($result)) {
				$selected = ($lignebp2["uid"] == $lignebp["id_user"]) ? " selected=\"selected\"" : "" ;
				//$menuusers .= '<option value="'.$lignebp2["uid"].'"'.$selected.'>'.$lignebp2["user_firstname"]." ".$lignebp2["user_name"]." - ".$lignebp2["uname"].'</option>';
				$lignebp2["adh_web"] = str_replace("http://", "", $lignebp2["adh_web"]);
				$menuusers .= '<option value="'.$lignebp2["uid"].'"'.$selected.'>'.$lignebp2["uname"]." - ".$lignebp2["adh_web"].'</option>';
			}
		}
		$menuusers .= "</select>";
	  
		//rcup valeurs public
		$tabpub = array();
		if ($id != "") {
			$sql = "SELECT id_target FROM ".$user_prefix."_bpratique_target_link WHERE id_pratique='$id';";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($lignebp2 = $db->sql_fetchrow($result)) {
					$tabpub[] = $lignebp2["id_target"];
				}
			}
		}
		$targetbox = "";
		$sql = "SELECT id, target FROM ".$user_prefix."_bpratique_target ORDER BY target ASC;";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) > 0) {
			while ($lignebp2 = $db->sql_fetchrow($result)) {
				$selected = (in_array($lignebp2["id"],$tabpub)) ? " checked=\"checked\"" : "" ;
				$targetbox .= '<input name="data[target][]" type="checkbox" id="tgt'.$lignebp2["id"].'" value="'.$lignebp2["id"].'"'.$selected.'>';
				$targetbox .= '<label for="tgt'.$lignebp2["id"].'">'.$lignebp2["target"].'</label><br />';
			}
		}
		//rcup valeurs pays et rgion
		//$sql = "SELECT DISTINCT pays FROM ".$user_prefix."_bpratique ORDER BY pays ASC;";
		$sql = "SELECT pays_F as pays FROM ".$user_prefix."_commerce_pays ORDER BY pays_F ASC;";
		$result = $db->sql_query($sql);
		$menupays = '<select name="data[paysnew]" size="1" onchange="this.form.elements[\'data[pays]\'].value=this.value">';
		$menupays .= '<option value="">'._FBP_COUNTRY_CHOOSE.'</option>';
		if ($db->sql_numrows($result) > 0) {
			while ($lignebp2 = $db->sql_fetchrow($result)) {
				$selected = ($lignebp2["pays"] == $lignebp["pays"]) ? " selected=\"selected\"" : "" ;
				$menupays .= '<option value="'.$lignebp2["pays"].'"'.$selected.'>'.$lignebp2["pays"].'</option>';
			}
		}
		$menupays .= "</select>";
		
		$sql = "SELECT DISTINCT region, pays FROM ".$user_prefix."_bpratique ORDER BY pays ASC, region ASC;";
		$result = $db->sql_query($sql);
		$paysencours = "";
		$premierpays = true;
		$menuregion = '<select name="data[regionnew]" size="1" onchange="this.form.elements[\'data[region]\'].value=this.value">';
		$menuregion .= '<option value="">'._FBP_REGION_CHOOSE.'</option>';
		if ($db->sql_numrows($result) > 0) {
			while ($lignebp2 = $db->sql_fetchrow($result)) {
				if ($paysencours != $lignebp2["pays"]) {
					$paysencours = $lignebp2["pays"];
					if (!$premierpays) {
						$menuregion .= '</optgroup>';
					}
					$premierpays = false;
					$menuregion .= '<optgroup label="'.$lignebp2["pays"].'">';
				}
				$selected = ($lignebp2["region"] == $lignebp["region"]) ? " selected=\"selected\"" : "" ;
				$menuregion .= '<option value="'.$lignebp2["region"].'"'.$selected.'>'.$lignebp2["region"].'</option>';
			}
			$menuregion .= '</optgroup>';
		}
		$menuregion .= "</select>";
	  
		//recup fichier
		if ($lignebp["id_file"] != "0" && $lignebp["id_file"] != "") {
			$sql = "SELECT `lid`, `title`, `url`, `filesize` FROM ".$user_prefix."_downloads_downloads";
			$sql .= " WHERE lid='".$lignebp["id_file"]."';";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while($ligne = $db->sql_fetchrow($result)) {
					$lapubli = "";
					$lapubli .= '<input type="text" name="data[newnomfichier]['.$ligne["lid"].']" value="'.$ligne["title"].'" size="50" maxlength="100" class="newfile">'." ".utilFuncs_bp::coolSize($ligne["filesize"]);
					$btnview = "<a href=\"modules.php?name=Downloads&d_op=getit&lid=".$ligne["lid"]."\" target=\"_blank\">";
					$btnview .= "<img src=\"$icneye\" border=\"0\" align=\"top\">";
					$btnview .= "</a>";
					 
					$btndel = "<a href=\"modules.php?name=".$module_name."&op=delfile&id_file=".$ligne["lid"]."&id=".$id."&page=".$page."\">";
					$btndel .= "<img src=\"$icn\" border=\"0\" align=\"top\">";
					$btndel .= "</a>";
					 
					$sortieliste .= '<li style="clear: both;"><span style="float: right">'.$btnview." ".$btndel.'</span><span style="width: 30px;display: block; float: left"><img src="'.get_icon_for_file($ligne["url"]).'"></span> '.$lapubli.''.'</li>';
				}
				$list_fichiers .= "<ul class=\"listpubli\">".$sortieliste."</ul>";
			}
			else {
				die("Erreur trange");
			}
		}
		else {
			$list_fichiers = '<input type="file" name="fichier[]" value="" size="50" class=""><br />';
			$list_fichiers .= _BP_NEWFILE_TITLE.'<input type="text" name="data[nomfichier]" value="" size="50" maxlength="100" class="newurl">';
		}
		//recup photo
		$laphoto = "";
		if ($lignebp["photo"] != "") {
			$laphoto = '<img src="'.$lignebp["photo"].'" /> ';
			$laphoto .= "<a href=\"modules.php?name=".$module_name."&op=delphoto&id=".$id."&page=".$page."\">";
			$laphoto .= "<img src=\"$icn\" border=\"0\" align=\"top\">";
			$laphoto .= "</a><br /><br />";
		}
		$laphoto .= '<input type="file" name="photo[]" value="" size="50" class="">';

		$_headerContent ='
<script type="text/javascript" src="modules/'.$module_name.'/system/lib_interface.js"></script>
<script type="text/javascript" src="modules/'.$module_name.'/system/lib_bp.js"></script>
<script language="Javascript" src="javascripts/control_form.js"></script>
<script language="JavaScript" src="javascripts/lang/lang-french.js"></script>
<script type="text/javascript" src="javascripts/fckeditor/fckeditor.js"></script>
<script type="text/javascript" src="javascripts/initfck.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/prototype.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/effects.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window_ext.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/debug.js"></script>
<link href="javascripts/windows_js/themes/default.css" rel="stylesheet" type="text/css" />
<link href="javascripts/windows_js/themes/becms_alphacube.css" rel="stylesheet" type="text/css" />
<script type="text/javascript">
	var win=null;
	function ouvre_dialogue(titre,url,width) {
		win = new Window({className: "becms_alphacube", title: titre, width:width, height:550, destroyOnClose: true, recenterAuto:true, url: url, minimizable: false, maximizable: false});
		win.showCenter(true);
	}
</script>
';

		setHeader($_headerContent);

		$sortie = "";
		$sortie .= '<h1>'._FBP.'</h1>';
		$sortie .= "<form action=\"modules.php?name=".$module_name."\" method=\"post\" onsubmit=\"return submit_form(this)\" name=\"bp\" enctype=\"multipart/form-data\">";
		$sortie .= '<input type="hidden" name="op" value="savepratique">';
		$sortie .= '<input type="hidden" name="data[id]" value="'.$id.'">';
		//$sortie .= '<input type="hidden" name="data[id_user]" value="'.$userdata[0].'">';

		if ($id == "") {
			$sortie .= '<h2>'._FBP_NEWFILE.'</h2>';
		}
		else {
			$sortie .= '<h2>'._FBP_EDITFILE.'</h2>';
		}
		$sortie .= '
		
		<fieldset class="newpub"><legend>'._FBP_THEFILE.'</legend>
	    <table cellspacing="5" cellpadding="0" border="0" align="center" summary="">
		    <tr>
		        <td class="label">
		        <p>'._FBP_TITRE.'</p>
		        </td>
		        <td class="content"><champ lib="'._FBP_TITLE_VERIF.'" nom="data[titre]" lim="1,100"></champ><input type="text" name="data[titre]" value="'.$lignebp["titre"].'" class="saisiepub" /></td>
		    </tr>
			<tr>
		        <td class="label">
		        <p>'._FBP_CAT1.'</p>
		        </td>
		        <td class="content"><!--<champ lib="'._FBP_CAT1_VERIF.'" nom="data[newcatname1]" lim="1,250"></champ>--><input type="text" name="data[newcatname1]" value="'.$cat1.'" class="saisiepub" onfocus="ouvre_dialogue(\'Catgorie\',\'modules.php?name=bp&op=catone&id='.$id.'\',400)"/><input type="hidden" name="data[newcatid1]" value="'.$catid1.'" /></td>
		    </tr>
			<tr>
		        <td class="label">
		        <p>'._FBP_CAT2.'</p>
		        </td>
		        <!--<td class="content"><input type="text" name="data[newcatname2]" value="'.$cat2.'" class="saisiepub" onfocus="ouvre_dialogue(\'Thmatiques\',\'modules.php?name=bp&op=catmulti\',400)"/><input type="hidden" name="data[newcatid2]" value="'.$catid2.'" /></td>-->
		        <td class="content"><textarea name="data[newcatname2]" rows="3" class="saisiepub" onfocus="ouvre_dialogue(\'Thmatiques\',\'modules.php?name=bp&op=catmulti&id='.$id.'\',400)"/>'.$cat2.'</textarea><input type="hidden" name="data[newcatid2]" value="'.$catid2.'" /></td>
		    </tr>
			<tr>
		        <td class="label">
		        <p>'._FBP_USER.'</p>
		        </td>
		        <td class="content">'.$menuusers.'</td>
		    </tr>
			<tr>
		        <td class="label">
		        <p>'._FBP_STATUS.'</p>
		        </td>
		        <td class="content"><!--<champ lib="'._FBP_STATUS_VERIF.'" nom="data[statut]" lim="1,100"></champ>-->'.$menustatut.'</td>
		    </tr>
			<tr>
		        <td class="label">
		        <p>'._FBP_COUNTRY.'</p>
		        </td>
		        <td class="content"><!--<champ lib="'._FBP_COUNTRY_VERIF.'" nom="data[pays]" lim="1,100"></champ>--><!-- <input type="text" name="data[pays]" value="'.$lignebp["pays"].'" class="saisiepub" style="margin-bottom: 3px"/><br /><p>Valeurs dj saisies : --><p><input type="hidden" name="data[pays]" value="'.$lignebp["pays"].'" />'.$menupays.'</p></td>
		    </tr>
			<tr>
		        <td class="label">
		        <p>'._FBP_REGION.'</p>
		        </td>
		        <td class="content"><!--<champ lib="'._FBP_REGION_VERIF.'" nom="data[region]" lim="1,100"></champ>--><input type="text" name="data[region]" value="'.$lignebp["region"].'" class="saisiepub" style="margin-bottom: 3px"/><br /><p>Valeurs dj saisies : '.$menuregion.'</p></td>
		    </tr>
		    <tr>
		        <td class="label">
		        <p>'._FBP_PARTNERS.'</p>
		        </td>
		        <td class="content">
<div class="dimztexte"><div class="encadreedit">
<textarea id="data[partenaire]" cols="70" rows="30" name="data[partenaire]">'.$lignebp["partenaire"].'</textarea>
<script type="text/javascript">editTen("data[partenaire]");</script></div></div></td>
		    </tr>
			<tr>
		        <td class="label">
		        <p>'._FBP_ABSTRACT.'</p>
		        </td>
		        <td class="content">
<div class="dimztexte"><div class="encadreedit">
<textarea id="data[resume]" cols="70" rows="30" name="data[resume]">'.$lignebp["resume"].'</textarea>
<script type="text/javascript">editTen("data[resume]");</script></div></div></td>
		    </tr>
		    
		    <tr>
		        <td class="label">
		        <p>'._FBP_PHOTO.'</p>
		        </td>
		        <td class="content">'.$laphoto.'</td>
		    </tr>
		    
			<tr>
		        <td class="label">
		        <p>'._FBP_CONTEXT.'</p>
		        </td>
		        <td class="content">
<div class="dimztexte"><div class="encadreedit">
<textarea id="data[contexte]" cols="70" rows="30" name="data[contexte]">'.$lignebp["contexte"].'</textarea>
<script type="text/javascript">editTen("data[contexte]");</script></div></div></td>
		    </tr>
			<tr>
		        <td class="label">
		        <p>'._FBP_TARGET.'</p>
		        </td>
		        <td class="content">'.$targetbox.'<input type="hidden" name="data[newtarget]" value="'.$lignebp["newtarget"].'" /><!-- <p>'._FBP_TARGET_NEWVALUES.'</p><input type="text" name="data[newtarget]" value="'.$lignebp["newtarget"].'" class="saisiepub" /> -->
				<p>'._FBP_TARGET_OBS.'</p>
				<div class="dimztexte"><div class="encadreedit">
<textarea id="data[targetobs]" cols="70" rows="30" name="data[targetobs]">'.$lignebp["targetobs"].'</textarea>
<script type="text/javascript">editTen("data[targetobs]");</script></div></div></td>
		    </tr>
			<tr>
		        <td class="label">
		        <p>'._FBP_OBJECTIF.'</p>
		        </td>
		        <td class="content">
<div class="dimztexte"><div class="encadreedit">
<textarea id="data[objectifs]" cols="70" rows="30" name="data[objectifs]">'.$lignebp["objectifs"].'</textarea>
<script type="text/javascript">editTen("data[objectifs]");</script></div></div></td>
		    </tr>
			<tr>
		        <td class="label">
		        <p>'._FBP_RESULTAT.'</p>
		        </td>
		        <td class="content">
<div class="dimztexte"><div class="encadreedit">
<textarea id="data[resultat]" cols="70" rows="30" name="data[resultat]">'.$lignebp["resultat"].'</textarea>
<script type="text/javascript">editTen("data[resultat]");</script></div></div></td>
		    </tr>
			<tr>
		        <td class="label">
		        <p>'._FBP_PERSPECTIVES.'</p>
		        </td>
		        <td class="content">
<div class="dimztexte"><div class="encadreedit">
<textarea id="data[perspective]" cols="70" rows="30" name="data[perspective]">'.$lignebp["perspective"].'</textarea>
<script type="text/javascript">editTen("data[perspective]");</script></div></div></td>
		    </tr>
			<tr>
		        <td class="label">
		        <p>'._FBP_LINKS.'</p>
		        </td>
		        <td id="alllinks" class="content">'.$listeliens.'<input type="text" name="data[linksurl][]" value="http://" size="50" onchange="handle_inputs_links(this)" class="url"><br />
					'._BP_NEWLINK_TITLE.'<input type="text" name="data[linkstitre][]" value="" size="50" maxlength="100" class="title"></td>
		    </tr>
			<tr>
		        <td class="label">
		        <p>'._FBP_FILE.'</p>
		        </td>
		        <td class="content">'.$list_fichiers.'</td>
		    </tr>
		</table>
		</fieldset>
	';
		$sortie .= "<div align=\"center\"><input type=\"submit\" value=\""._BP_SAVE_FILE."\"></div>";

		$sortie .= "</form>";

		include("header.php");
		echo $sortie;
		$bardef=array("back"=>"javascript:window.history.back()",
		/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
		/*"mailto"=>"#",*/
			"top"=>"#top" );
		buttonBar($bardef, "align");
		include("footer.php");
	}
	else {
		header("Location: modules.php?name=$module_name");
		die();
	}
}

function save_pratique($data) {
	global $module_name, $user_prefix, $db,$user, $group, $admin;

	if (is_user($user) || is_admin($admin)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);

		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];

		//print_r($data);
		//print_r(array("titre" => $data["newlinkstitre"], "liens"=>$data["newlinksurl"]));
		//die();

		$ok = true;
		$date = date("Y-m-d H:i:s");
		$sql = "SELECT uid,uname, user_name, user_firstname";
		$sql .= " FROM `".$user_prefix."_users`";
		$sql .= " WHERE uid='".$data["id_user"]."';";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) == 1) {
			$ligneuser = $db->sql_fetchrow($result);
		}
		//enregistrement du fichier
		global $praticsizemaxphoto, $downloadbpcat, $praticsizemaxillustration;
		list($width,$height) = explode("/",$praticsizemaxphoto);
		include("core/conf/uploadconfig.php");
		$chemin = $uploadFolder."/".$downloadbpcat;
		$filesSaved = uploadFiles($_FILES["fichier"], $chemin, $width, $height);
		for($i=0 ; $i < count($filesSaved) ; $i++) { //normalement il ne peut y en avoir qu'un, mais si un jour a change, le code est prt !
			$fileSaved = $filesSaved[$i];
			if ($data["nomfichier"] == "") {
				$nomfichier = utilFuncs_bp::conditionnertodb($data["titre"]);
			}
			else {
				$nomfichier = utilFuncs_bp::conditionnertodb($data["nomfichier"]);
			}
			$filesize = filesize($fileSaved);
			$date = date("Y-m-d H:i:s");
			$sql ="insert into ".$user_prefix."_downloads_downloads values (NULL, '".$downloadbpcat."', '0', '".$nomfichier."', '$fileSaved', '".$data["resume"]."', '$date', '', '', '0','".$ligneuser["uid"]."',0,0,0, '$filesize', '', '')";
			$ok = $ok && $db->sql_query($sql);
			$id_download = $db->sql_nextid();
			if ($data["id"] != "" && $data["id"] != 0) {
				$db->sql_query("UPDATE ".$user_prefix."_bpratique SET `id_file`='".$id_download."' WHERE id='".$data["id"]."';");
			}
		}

		$newfichiers = $data["newnomfichier"];
		if (count($newfichiers) > 0) {
			foreach($newfichiers as $key=>$value) {
				$sql = "UPDATE ".$user_prefix."_downloads_downloads SET `title`='".$value."' WHERE `lid` ='".$key."';";
				$ok = $ok && $db->sql_query($sql);
			}
		}

		//enregistrement pratique
		$targets = $data["target"];
		$liens = array("linksurl"=>array_map(array('utilFuncs_bp', 'conditionnertodb'), $data["linksurl"]), "linkstitre"=>array_map(array('utilFuncs_bp', 'conditionnertodb'), $data["linkstitre"]));
		$newliens = array("titres" => $data["newlinkstitre"], "liens"=>$data["newlinksurl"]);
		$data = array_map(array('utilFuncs_bp', 'conditionnertodb'), $data);
		if ($data["id"] != "") {
			$sql = "UPDATE ".$user_prefix."_bpratique SET `id_user`='".$data["id_user"]."', `titre`='".$data["titre"]."', `partenaire`='".$data["partenaire"]."' , `resume`='".$data["resume"]."' , `contexte`='".$data["contexte"]."',`targetobs`='".$data["targetobs"]."', `objectifs`='".$data["objectifs"]."' , `resultat`='".$data["resultat"]."' , `perspective`='".$data["perspective"]."' , `pays`='".$data["pays"]."' , `region`='".$data["region"]."' , `statut`='".$data["statut"]."' WHERE id='".$data["id"]."'";
			$ok = $ok && $db->sql_query($sql);
			$id_bp = $data["id"];
		}
		else {
			$date = date("Y-m-d H:i:s");
			$sql = "INSERT INTO ".$user_prefix."_bpratique (`id_user` , `date` , `titre`, `partenaire` , `resume` , `contexte`, `targetobs`, `objectifs` , `resultat` , `perspective` , `pays` , `region` , `statut` , `id_file`, `photo`)";
			$sql .= " VALUES ('".$data["id_user"]."', '".$date."','".$data["titre"]."','".$data["partenaire"]."','".$data["resume"]."','".$data["contexte"]."', '".$data["targetobs"]."','".$data["objectifs"]."','".$data["resultat"]."', '".$data["perspective"]."', '".$data["pays"]."', '".$data["region"]."', '".$data["statut"]."', '".$id_download."', '".$data["photo"]."')";
			$ok = $ok && $db->sql_query($sql);
			$id_bp = $db->sql_nextid();
		}

		//enregistrement photo
		if ($_FILES["photo"]["name"][0] != "") { //si au moins une photo
			$sql ="SELECT `photo` FROM ".$user_prefix."_bpratique WHERE id='".$id_bp."';";
			$resultbp = $db->sql_query($sql);
			$lignebp = $db->sql_fetchrow($resultbp);
			if ($lignebp["photo"] != "") {
				unlink($lignebp["photo"]);
			}
			list($width,$height) = explode("/",$praticsizemaxillustration);
			$chemin = $uploadFolder."/../bp/";
			$filesSaved = uploadFiles($_FILES["photo"], $chemin, $width, $height);
			$laphoto = $filesSaved[0];
			$sql = "UPDATE ".$user_prefix."_bpratique SET `photo`='".$laphoto."' WHERE id='".$id_bp."'";
			$ok = $ok && $db->sql_query($sql);
		}
		
		//enregistrement catgories
		$cat = $data["newcatid1"];
		$sql = "DELETE FROM ".$user_prefix."_bpratique_cat_link WHERE `id_pratique`='$id_bp' && level='1';";
		$ok = ($ok && $db->sql_query($sql));
		$sql = "INSERT INTO ".$user_prefix."_bpratique_cat_link (id_pratique, id_cat, level) VALUES ('$id_bp','$cat', '1');";
		//echo $sql;
		$ok = ($ok && $db->sql_query($sql));

		$cats = $data["newcatid2"];
		if ($cats != "") {
			$cats = str_replace("\r", "", $cats);
			$cats = explode("\n",$cats);
			$cats = array_unique($cats);
		}
		else {
			$cats = array();
		}
		if ($ok && $id_bp != "") {
			$sql = "DELETE FROM ".$user_prefix."_bpratique_cat_link WHERE `id_pratique`='$id_bp' && level='2';";
			$ok = ($ok && $db->sql_query($sql));
			foreach ($cats as $cat) {
				if ($cat != "") {
					$sql = "INSERT INTO ".$user_prefix."_bpratique_cat_link (id_pratique, id_cat, level) VALUES ('$id_bp','$cat', '2');";
					//echo $sql;
					$ok = ($ok && $db->sql_query($sql));
				}
			}
		}
		//enregistrement publics cible
		$sql = "DELETE FROM ".$user_prefix."_bpratique_target_link WHERE `id_pratique`='$id_bp';";
		$ok = ($ok && $db->sql_query($sql));
		foreach ($targets as $target) {
			if ($cat != "") {
				$sql = "INSERT INTO ".$user_prefix."_bpratique_target_link (id_pratique, id_target) VALUES ('$id_bp','$target');";
				//echo $sql;
				$ok = ($ok && $db->sql_query($sql));
			}
		}
		$data["newtarget"] = trim($data["newtarget"]);
		if ($data["newtarget"] != "")	{
			$newtargets = explode(";",$data["newtarget"]);
			$newtargets = array_map(trim, $newtargets);
			foreach($newtargets as $newtarget) {
				$sql = "INSERT INTO ".$user_prefix."_bpratique_target (target) VALUES ('$newtarget');";
				$ok = ($ok && $db->sql_query($sql));
				$id_target = $db->sql_nextid();
				$sql = "INSERT INTO ".$user_prefix."_bpratique_target_link (id_pratique, id_target) VALUES ('$id_bp','$id_target');";
				//echo $sql;
				$ok = ($ok && $db->sql_query($sql));
			}
		}
		//enregistrement des liens
		if (count($newliens["liens"]) > 0) {
			foreach($newliens["liens"] as $key=>$value) {
				$sql = "UPDATE ".$user_prefix."_bpratique_liens SET `titre`='".utilFuncs_bp::conditionnertodb($newliens["titres"][$key])."', `url`='".utilFuncs_bp::conditionnertodb($newliens["liens"][$key])."' WHERE `id` ='".$key."';";
				$ok = $ok && $db->sql_query($sql);
			}
		}
		for ($i=0; $i < count($liens["linksurl"]); $i++) {
			$liens["linksurl"][$i] = trim($liens["linksurl"][$i]);
			if ($liens["linksurl"][$i] != "" && $liens["linksurl"][$i] != "http://") {
				$sql = "INSERT INTO ".$user_prefix."_bpratique_liens (id_pratique, titre, url) VALUES ('$id_bp','".$liens["linkstitre"][$i]."', '".$liens["linksurl"][$i]."');";
				//echo $sql;
				$ok = ($ok && $db->sql_query($sql));
			}
		}

		//expdition des e-mail
		/*if ($ok) {
		$data = array_map(array('utilFuncs_simpleSpace', 'anti_conditionnertodb'), $data);
		global $sitename, $mailadminprivspacepub, $mailsenderprivspacepub;
		$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
		require_once("system/modules/becmsNewsletter/class.html2text.inc");
		$h2t = new html2text($data["comment"],false,70);
		$comment_text = $h2t->get_text();
		//suppression & commercial
		$comment_text = str_replace("&amp;","&",$comment_text);
		//fin suppression
		$nukeurl = format_nuke_url_2($nukeurl);
		//$publink = "$nukeurl/modules.php?name=$module_name&op=showpub&id=".$id_publi;
		$publink = "$nukeurl/workspace_".$data["id_publi"].".htm";
		$saut = "\n";
		$sep = "--------------------------------------------------\n";
			
		$sujet = "Commentaire dans le groupe \"".$current_group_name."\" par ".$userdata[1];
		$message = "";
		$message .= "Commentaire de ".$userdata[1]." pour la publication \"".$lignepubli["titre"]."\" dans le groupe \"".$current_group_name."\" sur l'espace collaboratif de \"".$sitename."\" : ".$saut.$saut;
		$message .= $data["subject"].$saut;
		$message .= $comment_text.$saut.$saut;
			
		$message .= $sep;
		$message .= "Date du commentaire : ".date("d/m/Y H:i").$saut;
		$message .= "Voir la publication : ".$publink.$saut;
		$obj_pub = new utilFuncs_simpleSpace();
		$okmail = true;
		$sql = "SELECT uname, email, user_name, user_firstname FROM ".$user_prefix."_users INNER JOIN ".$user_prefix."_users_groups on user_id=uid WHERE group_id ='".$current_group."'";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) > 0) {
		while ($leusers = $db->sql_fetchrow($result)) {
		$okmail = $ok && $obj_pub->send_email($leusers["email"], $mailsenderprivspacepub,$sujet,$message,$mailadminprivspacepub);
		}
		}
		if (!$okmail) {
		die("Erreur d'expdition de mail !");
		}
		}*/
		if (!$ok) {
			die("Erreur d'enregistrement dans la base de donnes !");
		}
		header("Location: modules.php?name=$module_name");
		die();
	}
	else {
		header("Location: modules.php?name=$module_name");
		die();
	}
}


global $tabsortie;
$tabsortie = array();

function all_way_cat($id) {
	global $prefix, $db;
	$name = "";
	if ($id != "") {
		do {
			$result = $db->sql_query("select name, parent from ".$prefix."_bpratique_cat where id='".$id."'");
			$lignecat = $db->sql_fetchrow($result);
			$name = $lignecat["name"].(($name != "") ? "/".$name : "");
			$id = $lignecat["parent"];
		} while ($lignecat["parent"] != 0);
	}
	return $name;
}

function cats_cats($parent="0", $level="0") {
	global $tabsortie, $prefix, $db;
	$result = $db->sql_query("select id, name from ".$prefix."_bpratique_cat where parent='".$parent."' order by name asc");
	while(list($id, $name) = $db->sql_fetchrow($result)) {
		$tabsortie[] = array("id"=>$id,"name"=>$name,"level"=>$level);
		cats_cats($id, ($level+1));
	}
}

function catone($id_fiche="") {
	global $tabsortie,$module_name,$Default_Theme, $user_prefix, $db;
	$catid1 = "";
	if ($id_fiche != "") {
		$sql = "SELECT id_cat";
		$sql .= " FROM `".$user_prefix."_bpratique_cat_link`";
		$sql .= " WHERE id_pratique='".$id_fiche."' AND level='1';";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) > 0) {
			$lignebp2 = $db->sql_fetchrow($result);
			$catid1 = $lignebp2["id_cat"];
		}
	}

	cats_cats();
	//print_r($tabsortie);
	$sep = "&nbsp;&nbsp;&nbsp;&nbsp;";
	$liste = "";
	$prefix = "";
	foreach($tabsortie as $ligne) {
		$id = $ligne["id"];
		$name = $ligne["name"];
		$level = $ligne["level"];
		$box = "";
		if ($level == 0) {
			$prefix = $name;
			$name = "<b>$name</b>";
			$liste .= "<p>".str_repeat($sep,$level).$name."</p>";
		}
		else {
			$selected = ($catid1 == $id ) ? " checked=\"checked\"" : "";
			$box = '<input type="radio" name="cat[]" value="'.$id.'@'.$prefix."/".$name.'" id="radio'.$id.'"'.$selected.'>';
			$liste .= "<p>".str_repeat($sep,$level).$box.'<label for="radio'.$id.'">'.$name."</label></p>";
		}
			
	}
	echo '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
		<meta http-equiv="content-type" content="text/html;charset=iso-8859-1">
		<title>Edition biblio</title>
		<link rel="StyleSheet" href="themes/'.$Default_Theme.'/style/style.css" media="screen, handheld" type="text/css">
		<link rel="StyleSheet" href="themes/'.$Default_Theme.'/style/'.$module_name.'.css" media="screen, handheld" type="text/css">
		<script type="text/javascript" src="modules/'.$module_name.'/system/lib_bp.js"></script>
	</head>

	<body style="background-color: transparent">';
	echo '<p>'._FBP_CHOOSEONECAT.'<br />&nbsp;</p>';
	echo '<form method="post">';
	echo $liste;
	echo '<p style="text-align: center;"><br><input type="submit" value="'._FBP_VALIDCHOICE.'" onclick="validonecat(this);parent.win.close()"></p>';
	echo '</form>';
	echo '</body></html>';
}

function catmulti($id_fiche="") {
	global $tabsortie, $module_name, $Default_Theme, $user_prefix, $db;
	$catid2 = array();
	$sql = "SELECT id_cat";
	$sql .= " FROM `".$user_prefix."_bpratique_cat_link`";
	$sql .= " WHERE id_pratique='".$id_fiche."' AND level='2';";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) > 0) {
		while ($lignebp2 = $db->sql_fetchrow($result)) {
			$catid2[] .= $lignebp2["id_cat"];
		}
	}

	cats_cats();
	//print_r($tabsortie);
	$sep = "&nbsp;&nbsp;&nbsp;&nbsp;";
	$liste = "";
	$prefix = "";
	foreach($tabsortie as $ligne) {
		$id = $ligne["id"];
		$name = $ligne["name"];
		$level = $ligne["level"];
		$box = "";
		if ($level == 0) {
			$prefix = $name;
			$name = "<b>$name</b>";
			$liste .= "<p>".str_repeat($sep,$level).$name."</p>";
		}
		else {
			$selected = (in_array($id, $catid2)) ? " checked=\"checked\"" : "";
			$box = '<input type="checkbox" name="cat[]" value="'.$id.'@'.$prefix."/".$name.'" id="radio'.$id.'"'.$selected.'>';
			$liste .= "<p>".str_repeat($sep,$level).$box.'<label for="radio'.$id.'">'.$name."</label></p>";
		}
			
	}
	echo '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
		<meta http-equiv="content-type" content="text/html;charset=iso-8859-1">
		<title>Edition biblio</title>
		<link rel="StyleSheet" href="themes/'.$Default_Theme.'/style/style.css" media="screen, handheld" type="text/css">
		<link rel="StyleSheet" href="themes/'.$Default_Theme.'/style/'.$module_name.'.css" media="screen, handheld" type="text/css">
		<script type="text/javascript" src="modules/'.$module_name.'/system/lib_bp.js"></script>
	</head>

	<body style="background-color: transparent">';
	echo '<p>'._FBP_CHOOSEPLUSCAT.'<br />&nbsp;</p>';
	echo '<form method="post">';
	echo $liste;
	echo '<p style="text-align: center;"><br><input type="submit" value="'._FBP_VALIDCHOICE.'" onclick="validmulticat(this);parent.win.close()"></p>';
	echo '</form>';
	echo '</body></html>';
}

function uploadFiles($fichiersUpload, $chemin="", $maxWith = 0, $maxHeight = 0) {
	$chemin = rtrim($chemin, "/");

	if (!file_exists($chemin)) {
		//$old = umask(0);
		if (!mkdir($chemin,0777,true)) {
			die("Impossible de crer le dossier de destination de l'upload !");
		}
		touch($chemin."/index.htm");
		//chmod($chemin, "0777");
		//umask($old);
	}

	$fichier = array();

	for ($i=0; $i<count($fichiersUpload["name"]); $i++) {
		if ($fichiersUpload["name"][$i] != "") {
			$nomDestination = md5(time()+rand(0,10)).strrchr($fichiersUpload["name"][$i],'.');
			while (file_exists($chemin."/".$nomDestination)) {
				$nomDestination = md5(time()+rand(0,10)).strrchr($fichiersUpload["name"][$i],'.');
			}
			if (is_uploaded_file($fichiersUpload["tmp_name"][$i])) {
				//$fichier[$i] = strtolower($chemin."/".$nomDestination);
				//$fichier[$i] = str_replace($_SERVER['DOCUMENT_ROOT'],'',realpath($chemin)."/".$nomDestination);
				$fichier[$i] = str_replace(realpath("."),'',realpath($chemin)."/".$nomDestination);
				$fichier[$i] = trim($fichier[$i], "/");
				if (rename($fichiersUpload["tmp_name"][$i],$fichier[$i])) {
					chmod($fichier[$i],0777);

					$extension = strtolower(strrchr($fichier[$i],'.'));

					if (($extension == '.jpg') || ($extension == '.jpeg') || ($extension == '.gif') || ($extension == '.png')) {
						$size = getimagesize($fichier[$i]);
						$width = $size[0];
						$height = $size[1];
					}
					else {
						$width = 0;
						$height = 0;
					}

					//test si les dimensions de l'image sont correctes et sinon applique le redimensionnement
					if ($width >= $maxWith || $height >= $maxHeight) {
						//calcul nouvelle taille
						if (($width/$maxWith) > ($height/$maxHeight)) {
							if ($maxWith != 0) {
								$newwidth = $maxWith;
								$newheight = ($height * $maxWith) / $width;
							}
							else {
								$newwidth = ($width * $maxHeight) / $height;
								$newheight = $maxHeight;
							}
						}
						else {
							if ($maxHeight != 0) {
								$newwidth = ($width * $maxHeight) / $height;
								$newheight = $maxHeight;
							}
							else {
								$newwidth = $maxWith;
								$newheight = ($height * $maxWith) / $width;
							}
						}
						//pour les cas des jpg
						if($extension == '.jpg' || $extension == '.jpeg') {
							$src = imagecreatefromjpeg($fichier[$i]);
							$tmp=imagecreatetruecolor($newwidth,$newheight);
							imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
							imagejpeg($tmp,$fichier[$i],70);
							imagedestroy($src);
							imagedestroy($tmp);
						}
						//pour les cas des gif
						if($extension == '.gif') {
							$src = imagecreatefromgif($fichier[$i]);
							$tmp=imagecreatetruecolor($newwidth,$newheight);
							$trans = imagecolorallocate($tmp,255,255,255);
							imagefilledrectangle($tmp,0,0,$newwidth,$newheight,$trans);
							imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
							imageinterlace($tmp);
							imagegif($tmp,$fichier[$i]);
							imagedestroy($src);
							imagedestroy($tmp);
						}
						//pour les cas des png
						if($extension == '.png') {
							$src = imagecreatefrompng($fichier[$i]);
							$tmp=imagecreatetruecolor($newwidth,$newheight);
							imagealphablending($tmp, false);
							imagesavealpha($tmp, true);
							imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
							$fond_noir = imagecolorallocate($destination, 0, 0, 0);
							imagecolortransparent($destination, $fond_noir);
							imagepng($tmp,$fichier[$i]);
							imagedestroy($src);
							imagedestroy($tmp);
						}
					}
				}
				else {
					die("Le dplacement du fichier temporaire a chou. Vrifiez l'existence du rpertoire $chemin");
				}
			}
			else {
				die("Le fichier n'a pas t upload (trop gros ? droits ?)");
			}
		}
	}
	return $fichier;
}

function showallpratiques($search=array()) {
	global $user, $group, $module_name, $db, $user_prefix, $formatdatebp, $admin, $page;
	global $tabsortie;
	/*if (is_user($user)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);
		$userdata[11] = array_explode( "@",";", $userdata[11]);

		$group_data_bloc = base64_decode($group);
		$groupdata = explode(":", $group_data_bloc);
		$current_group = $groupdata[0];
		$current_group_name = $groupdata[1];*/

	if (file_exists('themes/'.$Default_Theme.'/images/deletesmall.gif')) {
		$icn = 'themes/'.$Default_Theme.'/images/deletesmall.gif';
	}
	else {
		$icn = 'images/deletesmall.gif';
	}
	if (file_exists('themes/'.$Default_Theme.'/images/edit.gif')) {
		$icn2 = 'themes/'.$Default_Theme.'/images/edit.gif';
	}
	else {
		$icn2 = 'images/edit22.gif';
	}

	include("header.php");
	$sortie = "";
	$sortie .= '<h1>'._FBP.'</h1>';
	
	/*
	 * formulaire de recherche
	 * 
	 */

	//catgories
	cats_cats();
	//print_r($tabsortie);
	$tabsortie = array_map(array('utilFuncs_bp', 'conditionnerFORM'),$tabsortie);
	$liste = '<select name="search[cat]" size="1" class="saisiepub">';
	$liste .= '<option value="">'._COMSPACE_CATPUB_CHOOSE.'</option>';
	$premierecat = true;
	foreach($tabsortie as $ligne) {
		if ($ligne["level"] == 0) {
			if ($premierecat) {
				$premierecat = false;
			}
			else {
				$liste .= '</optgroup>';
			}
			$liste .= '<optgroup label="'.$ligne["name"].'">';
		}
		else {
			$selected = ($search["cat"] == $ligne["id"] ) ? " selected=\"selected\"" : "";
			$liste .= '<option value="'.$ligne["id"].'"'.$selected.'>'.$ligne["name"].'</option>';
		}
			
	}
	$liste .= '</optgroup></select>';
	
	//statut du responsable
	$menustatut = '<select name="search[statut]" size="1" class="saisiepub">';
	$menustatut .= '<option value="">'._FBP_STATUS_CHOOSE2.'</option>';
	$sql = "SHOW COLUMNS FROM ".$user_prefix."_bpratique LIKE 'statut';";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) > 0) {
		if ($lignebp2 = $db->sql_fetchrow($result)) {
			$regex = "/'(.*?)'/";
			preg_match_all( $regex , $lignebp2[1], $enum_array );
			$enum_fields = $enum_array[1];
			foreach ($enum_fields as $values) {
				$selected = ($values == $search["statut"]) ? " selected=\"selected\"" : "" ;
				$menustatut .= '<option value="'.$values.'"'.$selected.'>'.$values.'</option>';
			}
		}
	}
	$menustatut .= "</select>";
	
	//public cible
	$sql = "SELECT id, target FROM ".$user_prefix."_bpratique_target ORDER BY target ASC;";
	$result = $db->sql_query($sql);
	$menupublic = '<select name="search[public]" size="1" class="saisiepub">';
	$menupublic .= '<option value="">'._FBP_TARGET2.'</option>';
	if ($db->sql_numrows($result) > 0) {
		while ($lignebp2 = $db->sql_fetchrow($result)) {
			$selected = ($lignebp2["id"] == $search["public"]) ? " selected=\"selected\"" : "" ;
			$menupublic .= '<option value="'.$lignebp2["id"].'"'.$selected.'>'.$lignebp2["target"].'</option>';
		}
	}
	$menupublic .= '</select>';
	
	//pays/rgion
	$sql = "SELECT DISTINCT pays FROM ".$user_prefix."_bpratique ORDER BY pays ASC, region ASC;";
	$result = $db->sql_query($sql);
	$menupays = '<select name="search[pays]" size="1" class="saisiepub">';
	$menupays .= '<option value="">'._FBP_COUNTRY_CHOOSE2.'</option>';
	if ($db->sql_numrows($result) > 0) {
		while ($lignebp2 = $db->sql_fetchrow($result)) {
			$selected = ($lignebp2["pays"] == $search["pays"]) ? " selected=\"selected\"" : "" ;
			$menupays .= '<option value="'.$lignebp2["pays"].'"'.$selected.'>'.$lignebp2["pays"].'</option>';
		}
	}
	$menupays .= "</select>";
	
	$sql = "SELECT DISTINCT region, pays FROM ".$user_prefix."_bpratique ORDER BY pays ASC, region ASC;";
	$result = $db->sql_query($sql);
	$paysencours = "";
	$premierpays = true;
	$menuregion = '<select name="search[region]" size="1" class="saisiepub">';
	$menuregion .= '<option value="">'._FBP_REGION_CHOOSE2.'</option>';
	if ($db->sql_numrows($result) > 0) {
		while ($lignebp2 = $db->sql_fetchrow($result)) {
			if ($paysencours != $lignebp2["pays"]) {
				$paysencours = $lignebp2["pays"];
				if (!$premierpays) {
					$menuregion .= '</optgroup>';
				}
				$premierpays = false;
				$menuregion .= '<optgroup label="'.$lignebp2["pays"].'">';
			}
			$selected = ($lignebp2["region"] == $search["region"]) ? " selected=\"selected\"" : "" ;
			$menuregion .= '<option value="'.$lignebp2["region"].'"'.$selected.'>'.$lignebp2["region"].'</option>';
		}
		$menuregion .= '</optgroup>';
	}
	$menuregion .= "</select>";
	
	//public cible
	$sql = "SELECT id, target FROM ".$user_prefix."_bpratique_target ORDER BY target ASC;";
	$result = $db->sql_query($sql);
	$menupublic = '<select name="search[public]" size="1" class="saisiepub">';
	$menupublic .= '<option value="">'._FBP_TARGET2.'</option>';
	if ($db->sql_numrows($result) > 0) {
		while ($lignebp2 = $db->sql_fetchrow($result)) {
			$selected = ($lignebp2["id"] == $search["public"]) ? " selected=\"selected\"" : "" ;
			$menupublic .= '<option value="'.$lignebp2["id"].'"'.$selected.'>'.$lignebp2["target"].'</option>';
		}
	}
	$menupublic .= '</select>';
	
	$search = array_map(array('utilFuncs_bp', 'conditionnerFORM'), $search);
	
	$sortie .= '<form name="search" action="modules.php?name='.$module_name.'" method="POST">';
	$sortie .= '<fieldset class="newpub"><legend>'._BP_FILESFIND.'</legend>';
	$sortie .= '<table border="0" cellpadding="0" cellspacing="5">';
	
	$sortie .= '<tr><td class="label"><p>'._BP_FILESFINDKW.'</p></td>';
	$sortie .= '<td class="content">';
	$sortie .= '<input type="text" value="'.$search["kw"].'" class="saisiepub" name="search[kw]">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label"><p>'._BP_FILESFINDCAT.'</p></td>';
	$sortie .= '<td class="content">';
	$sortie .= $liste;
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label"><p>'._FBP_STATUS2.'</p></td>';
	$sortie .= '<td class="content">';
	$sortie .= $menustatut;
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label"><p>'._FBP_COUNTRY.'</p></td>';
	$sortie .= '<td class="content">';
	$sortie .= $menupays;
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label"><p>'._FBP_REGION.'</p></td>';
	$sortie .= '<td class="content">';
	$sortie .= $menuregion;
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label"><p>'._FBP_TARGET.'</p></td>';
	$sortie .= '<td class="content">';
	$sortie .= $menupublic;
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr>';
	$sortie .= '<td colspan="2" align="center">';
	$sortie .= '<input type="submit" value="Chercher">';
	$sortie .= '</td></tr>';
	
	$sortie.= '</table>';
	$sortie .= '</fieldset>';
	$sortie .= '</form>';
	
	/*
	 * fin formulaire
	 */

	if (join("",$search) == "") {
		$sortie .= "<h2>"._BP_ALLFILES."</h2>";
	}
	else {
		$sortie .= "<h2>"._BP_FILESFOUND."</h2>";
	}
	//pagination
	if (!isset($page) || $page == "") {
		$page = 1;
	}
	$pagesize = 10;
	$min = $pagesize * ($page - 1);
	$max = $pagesize;
	$limit = " LIMIT ".$min.", ".$max;
	
	
	$where ="";
	if ($search["kw"] != "") {
		$kw2 = htmlentities($search["kw"],ENT_NOQUOTES);
		$where .= ($where != "") ? " AND " : " WHERE ";
		$where .= "(";
		$where .= "titre LIKE '%".$search["kw"]."%'";
		$where .= " OR ";
		$where .= "partenaire LIKE '%".$search["kw"]."%'";
		$where .= " OR ";
		$where .= "resume LIKE '%".$search["kw"]."%'";
		$where .= " OR ";
		$where .= "contexte LIKE '%".$search["kw"]."%'";
		$where .= " OR ";
		$where .= "objectifs LIKE '%".$search["kw"]."%'";
		$where .= " OR ";
		$where .= "resultat LIKE '%".$search["kw"]."%'";
		$where .= " OR ";
		$where .= "perspective LIKE '%".$search["kw"]."%'";
		$where .= " OR ";
		$where .= "titre LIKE '%".$kw2."%'";
		$where .= " OR ";
		$where .= "partenaire LIKE '%".$kw2."%'";
		$where .= " OR ";
		$where .= "resume LIKE '%".$kw2."%'";
		$where .= " OR ";
		$where .= "contexte LIKE '%".$kw2."%'";
		$where .= " OR ";
		$where .= "objectifs LIKE '%".$kw2."%'";
		$where .= " OR ";
		$where .= "resultat LIKE '%".$kw2."%'";
		$where .= " OR ";
		$where .= "perspective LIKE '%".$kw2."%'";
		$where .= ")";
	}
	
	if ($search["cat"] != "") {
		$where .= ($where != "") ? " AND " : " WHERE ";
		$where .= "".$user_prefix."_bpratique_cat_link.id_cat='".$search["cat"]."' AND ".$user_prefix."_bpratique_cat_link.level='1'";
	}
	else {
		$where .= ($where != "") ? " AND " : " WHERE ";
		$where .= "".$user_prefix."_bpratique_cat_link.level='1'";
	}
	
	if ($search["statut"] != "") {
		$where .= ($where != "") ? " AND " : " WHERE ";
		$where .= "".$user_prefix."_bpratique.statut='".$search["statut"]."'";
	}
	
	if ($search["pays"] != "") {
		$where .= ($where != "") ? " AND " : " WHERE ";
		$where .= "".$user_prefix."_bpratique.pays='".$search["pays"]."'";
	}
	
	if ($search["region"] != "") {
		$where .= ($where != "") ? " AND " : " WHERE ";
		$where .= "".$user_prefix."_bpratique.region='".$search["region"]."'";
	}
	
	$leftjoinplus = "";
	if ($search["public"]) {
		$leftjoinplus .= " LEFT JOIN ".$user_prefix."_bpratique_target_link ON ".$user_prefix."_bpratique_target_link.id_pratique=".$user_prefix."_bpratique.id";
		$where .= ($where != "") ? " AND " : " WHERE ";
		$where .= "".$user_prefix."_bpratique_target_link.id_target='".$search["public"]."'";
	}

	$sql = "SELECT COUNT(".$user_prefix."_bpratique.id) as nbre";
	$sql .= " FROM ".$user_prefix."_bpratique";
	$sql .= " LEFT JOIN ".$user_prefix."_users ON id_user=uid";
	$sql .= " LEFT JOIN ".$user_prefix."_bpratique_cat_link ON ".$user_prefix."_bpratique_cat_link.id_pratique=".$user_prefix."_bpratique.id";
	$sql .= " LEFT JOIN ".$user_prefix."_bpratique_cat ON ".$user_prefix."_bpratique_cat_link.id_cat=".$user_prefix."_bpratique_cat.id";
	$sql .= $leftjoinplus;
	//$sql .= " WHERE id_group='".$current_group."'";
	$sql .= $where;
//echo $sql;
	$result = $db->sql_query($sql);
	list($nbre) = $db->sql_fetchrow($result);

	$params = "";
	foreach($search as $key=>$value) {
		$params .= "&search[".urlencode($key)."]=".urlencode($value);
	}
	$indexpages = list_index($nbre, $page, $pagesize, "modules.php?name=".$module_name."&op=allbp".$params, _BP_FILES_FOUND, _BP_FILES_NOTFOUND, _BP_FILES_PAGES);

	//affichage des publis
	$sortiepub = $indexpages;
	$sortieliste = "";
	$sql = "SELECT ".$user_prefix."_bpratique.id, id_user, date, titre, resume, uname,".$user_prefix."_bpratique_cat.name as catpratique";
	$sql .= " FROM ".$user_prefix."_bpratique";
	$sql .= " LEFT JOIN ".$user_prefix."_users ON id_user=uid";
	$sql .= " LEFT JOIN ".$user_prefix."_bpratique_cat_link ON ".$user_prefix."_bpratique_cat_link.id_pratique=".$user_prefix."_bpratique.id";
	$sql .= " LEFT JOIN ".$user_prefix."_bpratique_cat ON ".$user_prefix."_bpratique_cat_link.id_cat=".$user_prefix."_bpratique_cat.id";
	$sql .= $leftjoinplus;
	//$sql .= " WHERE ".$user_prefix."_bpratique_cat_link.level='1'";
	$sql .= $where;
	$sql .= " ORDER BY date DESC".$limit;
//print_r($search);
//echo $sql;
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) > 0) {
		while($ligne = $db->sql_fetchrow($result)) {
			if ($ligne["id_user"] == $userdata[0] || is_admin($admin)) {
				$deletebutton = '<a href="modules.php?name='.$module_name.'&op=delpratique&id='.$ligne["id"].'&page='.$page.'" title="'._BP_DELFILE.'"><img src="'.$icn.'" border="0"></a>';
				$editbutton = '<a href="modules.php?name='.$module_name.'&op=editpratique&id='.$ligne["id"].'&page='.$page.'" title="'._BP_EDITFILE.'"><img src="'.$icn2.'" border="0"></a>';
				$actions = '<span class="actions">&nbsp;'.$editbutton.'&nbsp;'.$deletebutton.'</span>';
			}
			else {
				$actions = "";
			}
//echo  '<pre>'.htmlspecialchars(truncate_string($ligne["resume"],"200"),ENT_QUOTES,'ISO-8859-1',true).'</pre><br />*******************************<br />';
			$story_link = "<a href=\"modules.php?name=".$module_name."&op=showpratique&id=".$ligne["id"]."&page=".$page."\">";
			$sortieliste .= '<li><span class="titre">'.$actions.$story_link.$ligne["titre"].'<span class="sstitle">'.truncate_string($ligne["resume"],"200").'</span></a></span><span class="auteur"><span class="categorie">'.$ligne["catpratique"].'</span>'.$ligne["uname"]." - ".utilFuncs_bp::date2JMA($ligne["date"],$formatdatebp).'</span>'.'</li>';
		}
		$sortiepub .= "<ul class=\"listpubli\">".$sortieliste."</ul>";
	}
	else {
		$sortiepub .= "Pas de fiche publie !!";
	}

	$sortiepub .= $indexpages;

	$sortie .= $sortiepub;

	echo $sortie;
	$bardef=array("back"=>"javascript:window.history.back()",
	/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",*/
			"mailto"=>"#",
			"top"=>"#top" );
	buttonBar($bardef, "align");
	include("footer.php");

	/*}
	 else {
		header("Location: modules.php?name=$module_name");
		die();
		}*/
}

function list_index($nbreFiches, $page, $ligne_par_page,$url, $txtfound=_BP_ELTS_FOUND, $txtnotfound = _BP_ELTS_NOTFOUND, $txtpage = _BP_ELTS_PAGES, $extraurl="") {
	$nboites = 5;
	$liminf = $page - floor($nboites/2);
	$limsup = $page + floor($nboites/2);
	if ($liminf < 1) {
		$liminf = 1;
		$limsup = $nboites;
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
		}
	}
	if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
		$limsup = ceil($nbreFiches/$ligne_par_page);
		$liminf = $limsup - $nboites;
		if ($liminf < 1) {
			$liminf = 1;
		}
	}
	$min = 1;
	$max = ceil($nbreFiches/$ligne_par_page);

	$repParPage = $ligne_par_page;
	$p = $page;
	$nbrepages = ceil($nbreFiches/$repParPage);
	if ($p>$nbrepages) {
		$p = $nbrepages;
	}
	$indexPages .= "<div class=\"pages\">";
	if ($nbreFiches != 0) {
		$indexPages .= $nbreFiches.$txtfound;
		$indexPages .= $txtpage;
		if ($min < $liminf) {
			if ($min == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$min";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$extraurl = str_replace("<!--page-->",$min,$extraurl);
				if ($url != "") {
					$indexPages .= "<a href=\"$url&page=$min"."\"$extraurl)>$min</a>";
				}
				else {
					$indexPages .= "<a href=\"#\"".$extraurl.")>$min</a>";
				}
				$indexPages .= "</div>";
			}
			if ($min < $liminf - 1) {
				$indexPages .= "...";
			}
		}
		for ($i=$liminf;$i<=$limsup;$i++) {
			if ($i == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$i";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$extraurl = str_replace("<!--page-->",$i,$extraurl);
				if ($url != "") {
					$indexPages .= "<a href=\"$url&page=$i"."\"$extraurl>$i</a>";
				}
				else {
					$indexPages .= "<a href=\"#\"".$extraurl.")>$i</a>";
				}
				$indexPages .= "</div>";
			}
		}
		if ($max > $limsup) {
			if ($max > $limsup + 1) {
				$indexPages .= "...";
			}
			if ($max == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$max";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$extraurl = str_replace("<!--page-->",$max,$extraurl);
				if ($url != "") {
					$indexPages .= "<a href=\"$url&page=$max"."\"$extraurl>$max</a>";
				}
				else {
					$indexPages .= "<a href=\"#\"".$extraurl.")>$max</a>";
				}
				$indexPages .= "</div>";
			}
		}
	}
	else {
		$indexPages .= $txtnotfound;
	}
	$indexPages .= "</div>";
	return $indexPages;
}

function delfile($id_file, $id, $ok="n") {
	global $user, $group, $module_name, $user_prefix, $db, $mailadminprivspacepub, $mailsenderprivspacepub, $nukeurl, $page, $admin;
	if (is_user($user)  || is_admin($admin)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);

		$sql = "SELECT `title` FROM ".$user_prefix."_downloads_downloads";
		$sql .= " WHERE  lid='".$id_file."';";

		$result = $db->sql_query($sql);
		$ligne = array();
		if ($db->sql_numrows($result) > 0) {
			$ligne = $db->sql_fetchrow($result);
		}
		else {
			die("Autorisation refuse !");
		}
		if ($ok=="y") {
			$result = $db->sql_query("SELECT `url` FROM ".$user_prefix."_downloads_downloads WHERE lid='".$id_file."';");
			list($url) = $db->sql_fetchrow($result);
			$db->sql_query("DELETE FROM ".$user_prefix."_downloads_downloads WHERE lid=".$id_file.";");
			unlink($url);
			$db->sql_query("UPDATE ".$user_prefix."_bpratique SET `id_file`='0' WHERE id='".$id."';");
			header("Location: modules.php?name=$module_name&op=editpratique&id=$id&page=$page");
			die();
		}
		else {
			$sortie .= '<h1>'._FBP.'</h1>';
			$sortie .= "<p style=\"text-align: center; font-weight: bold\"><br />".$ligne["title"]."</p>";
			$sortie .= "<p style=\"text-align: center\"><br />"._BP_DELFILE_CONF."</p>";
			$sortie .= "<p style=\"text-align: center\"><br /><a href=\"modules.php?name=".$module_name."&op=delfile&id=".$id."&id_file=".$id_file."&page=".$page."&ok=y\">[ "._YES." ]</a>&nbsp;&nbsp;&nbsp;<a href=\"javascript:window.history.back()\">[ "._NO." ]</a></p>";
				
			include("header.php");
			//Accueil de l'espace collaboratif !!!!!
			echo $sortie;
			include("footer.php");
		}
	}
	else {
		header("Location: modules.php?name=$module_name");
		die();
	}
}

function delphoto($id, $ok="n") {
	global $user, $group, $module_name, $user_prefix, $db, $mailadminprivspacepub, $mailsenderprivspacepub, $nukeurl, $page, $admin;
	if (is_user($user) || is_admin($admin)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);

		if ($ok=="y") {
			$sql ="SELECT `photo` FROM ".$user_prefix."_bpratique WHERE id='".$id."';";
			$resultbp = $db->sql_query($sql);
			$lignebp = $db->sql_fetchrow($resultbp);
			if ($lignebp["photo"] != "") {
				unlink($lignebp["photo"]);
			}
			$db->sql_query("UPDATE ".$user_prefix."_bpratique SET `photo`='' WHERE id='".$id."';");
			header("Location: modules.php?name=$module_name&op=editpratique&id=$id&page=$page");
			die();
		}
		else {
			$sortie .= '<h1>'._FBP.'</h1>';
			$sortie .= "<p style=\"text-align: center; font-weight: bold\"><br />".$ligne["title"]."</p>";
			$sortie .= "<p style=\"text-align: center\"><br />"._BP_DELFILE_CONF."</p>";
			$sortie .= "<p style=\"text-align: center\"><br /><a href=\"modules.php?name=".$module_name."&op=delphoto&id=".$id."&page=".$page."&ok=y\">[ "._YES." ]</a>&nbsp;&nbsp;&nbsp;<a href=\"javascript:window.history.back()\">[ "._NO." ]</a></p>";
				
			include("header.php");
			//Accueil de l'espace collaboratif !!!!!
			echo $sortie;
			include("footer.php");
		}
	}
	else {
		header("Location: modules.php?name=$module_name");
		die();
	}
}

function dellink($id_link, $id, $ok="n") {
	global $user, $group, $module_name, $user_prefix, $db, $mailadminprivspacepub, $mailsenderprivspacepub, $nukeurl, $page, $admin;
	if (is_user($user)  || is_admin($admin)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);

		$sql = "SELECT `titre` FROM ".$user_prefix."_bpratique_liens";
		$sql .= " WHERE  id='".$id_link."';";

		$result = $db->sql_query($sql);
		$ligne = array();
		if ($db->sql_numrows($result) > 0) {
			$ligne = $db->sql_fetchrow($result);
		}
		else {
			die("Autorisation refuse !");
		}

		if ($ok=="y") {
			$db->sql_query("DELETE FROM ".$user_prefix."_bpratique_liens WHERE id=".$id_link.";");
			header("Location: modules.php?name=$module_name&op=editpratique&id=$id&page=$page");
			die();
		}
		else {
			$sortie .= '<h1>'._FBP.'</h1>';
			$sortie .= "<p style=\"text-align: center; font-weight: bold\"><br />".$ligne["titre"]."</p>";
			$sortie .= "<p style=\"text-align: center\"><br />"._BP_DELLINK_CONF."</p>";
			$sortie .= "<p style=\"text-align: center\"><br /><a href=\"modules.php?name=".$module_name."&op=dellink&id=".$id."&id_link=".$id_link."&page=".$page."&ok=y\">[ "._YES." ]</a>&nbsp;&nbsp;&nbsp;<a href=\"javascript:window.history.back()\">[ "._NO." ]</a></p>";
				
			include("header.php");
			//Accueil de l'espace collaboratif !!!!!
			echo $sortie;
			include("footer.php");
		}
	}
	else {
		header("Location: modules.php?name=$module_name");
		die();
	}
}

function del_pratique($id, $ok="n") {
	global $user, $group, $module_name, $user_prefix, $db, $mailadminprivspacepub, $mailsenderprivspacepub, $nukeurl, $page, $admin;
	if (is_user($user) || is_admin($admin)) {
		$user_data_bloc = base64_decode($user);
		$userdata = explode(":", $user_data_bloc);

		$sql = "SELECT `titre`, `id_file` FROM ".$user_prefix."_bpratique";
		$sql .= " WHERE  id='".$id."';";

		$result = $db->sql_query($sql);
		$ligne = array();
		if ($db->sql_numrows($result) > 0) {
			$ligne = $db->sql_fetchrow($result);
		}
		else {
			die("Autorisation refuse !");
		}
		if ($ok=="y") {
			$result = $db->sql_query("SELECT `url` FROM ".$user_prefix."_downloads_downloads WHERE lid='".$ligne["id_file"]."';");
			list($url) = $db->sql_fetchrow($result);
			$db->sql_query("DELETE FROM ".$user_prefix."_downloads_downloads WHERE lid=".$ligne["id_file"].";");
			unlink($url);
			$db->sql_query("DELETE FROM ".$user_prefix."_bpratique_liens WHERE id_pratique=".$id.";");
			$db->sql_query("DELETE FROM ".$user_prefix."_bpratique_target_link WHERE id_pratique=".$id.";");
			$db->sql_query("DELETE FROM ".$user_prefix."_bpratique_cat_link WHERE id_pratique=".$id.";");
			$db->sql_query("DELETE FROM ".$user_prefix."_bpratique WHERE id=".$id.";");
				
			header("Location: modules.php?name=$module_name&page=$page");
			die();
		}
		else {
			$sortie .= '<h1>'._FBP.'</h1>';
			$sortie .= "<p style=\"text-align: center; font-weight: bold\"><br />".$ligne["title"]."</p>";
			$sortie .= "<p style=\"text-align: center\"><br />"._BP_DELPRATIQUE_CONF."</p>";
			$sortie .= "<p style=\"text-align: center\"><br /><a href=\"modules.php?name=".$module_name."&op=delpratique&id=".$id."&page=".$page."&ok=y\">[ "._YES." ]</a>&nbsp;&nbsp;&nbsp;<a href=\"javascript:window.history.back()\">[ "._NO." ]</a></p>";
				
			include("header.php");
			//Accueil de l'espace collaboratif !!!!!
			echo $sortie;
			include("footer.php");
		}
	}
	else {
		header("Location: modules.php?name=$module_name");
		die();
	}
}

function display_pratique($id) {
	global $user, $group, $module_name, $user_prefix, $db, $nukeurl, $page, $admin, $op;
	if ($id != "") {
		$sql = "SELECT `id_user` , `date` , `titre` , `partenaire` , `resume` , `contexte` , `targetobs` , `objectifs` , `resultat` , `perspective` , `pays` , `region` , `statut` , `id_file`, `photo` ";
		$sql .= " FROM ".$user_prefix."_bpratique";
		$sql .= " WHERE  id='".$id."';";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) > 0) {
			$lignebp = $db->sql_fetchrow($result);
				
			//recup user
			$sql = "SELECT email, adh_entreprise, adh_adresse, user_name, user_firstname, user_func, adh_tel, adh_web ";
			$sql .= " FROM ".$user_prefix."_users";
			$sql .= " WHERE  uid='".$lignebp["id_user"]."';";
			$resultuser = $db->sql_query($sql);
			$bpuser = "";
			if ($db->sql_numrows($resultuser) > 0) {
				if($ligneuser = $db->sql_fetchrow($resultuser)) {
					$bpuser .= ($ligneuser["user_name"].$ligneuser["user_firstname"] == "") ? "" : $ligneuser["user_firstname"]." ".$ligneuser["user_name"];
					$bpuser .= ($ligneuser["adh_entreprise"]== "") ? "" : "<br />".$ligneuser["adh_entreprise"];
					$bpuser .= ($ligneuser["user_func"]== "") ? "" : "<br />".$ligneuser["user_func"];
					$bpuser .= ($ligneuser["adh_adresse"]== "") ? "" : "<br />".$ligneuser["adh_adresse"];
					$bpuser .= ($ligneuser["adh_tel"]== "") ? "" : "<br />Tl : ".$ligneuser["adh_tel"];
					$bpuser .= ($ligneuser["email"]== "") ? "" : "<br />Courriel : <a href= \"mailto:".$ligneuser["email"]."\" target=\"_blank\">".$ligneuser["email"]."</a>";
					$bpuser .= ($ligneuser["adh_web"]== "") ? "" : "<br />Web : <a href= \"http://".str_replace("http://","",$ligneuser["adh_web"])."\" target=\"_blank\">"."http://".str_replace("http://","",$ligneuser["adh_web"])."</a>";
				}
			}
			$bpuser = preg_replace("#^<br />#i","",$bpuser);
				
			//rcup liens
			$sql = "SELECT id, titre, url";
			$sql .= " FROM `".$user_prefix."_bpratique_liens`";
			$sql .= " WHERE id_pratique='".$id."';";
			$resultliens = $db->sql_query($sql);
			$bplinks = "";
			if ($db->sql_numrows($resultliens) > 0) {
				while($ligneliens = $db->sql_fetchrow($resultliens)) {
					$bplinks .= '<li><a href="http://'.str_replace("http://","",$ligneliens["url"]).'" target="_blank">'.$ligneliens["titre"].'<a></li>';
				}
				$bplinks = '<ul>'.$bplinks.'</ul>';
			}
				
			//rcup catgories
			$cat1 = "";
			$id_cat = "";
			$sql = "SELECT id_cat";
			$sql .= " FROM `".$user_prefix."_bpratique_cat_link`";
			$sql .= " WHERE id_pratique='".$id."' AND level='1';";
			$resultcat1 = $db->sql_query($sql);
			if ($db->sql_numrows($resultcat1) > 0) {
				$lignebp2 = $db->sql_fetchrow($resultcat1);
				$cat1 = all_way_cat($lignebp2["id_cat"]);
				$id_cat = $lignebp2["id_cat"];
			}
		  
			$cat2 = "";
			$id_themes = array();
			$sql = "SELECT id_cat";
			$sql .= " FROM `".$user_prefix."_bpratique_cat_link`";
			$sql .= " WHERE id_pratique='".$id."' AND level='2';";
			$resultcat2 = $db->sql_query($sql);
			if ($db->sql_numrows($resultcat2) > 0) {
				while ($lignebp2 = $db->sql_fetchrow($resultcat2)) {
					$cat2 .= '<li>'.all_way_cat($lignebp2["id_cat"]).'</li>';
					$id_themes[] = $lignebp2["id_cat"];
				}
				$cat2 = '<ul>'.$cat2.'</ul>';
			}
		  
			//rcup public cible
			$target = "";
			$sql = "SELECT `target` FROM `".$user_prefix."_bpratique_target`";
			$sql .= " INNER JOIN ".$user_prefix."_bpratique_target_link ON ".$user_prefix."_bpratique_target.id=id_target";
			$sql .= " WHERE id_pratique = ".$id.";";
			$resulttarget = $db->sql_query($sql);
			if ($db->sql_numrows($resulttarget) > 0) {
				$cat2 = "";
				while ($lignebp2 = $db->sql_fetchrow($resulttarget)) {
					$target .= '<li>'.$lignebp2["target"].'</li>';
				}
				$target = "<ul>".$target."</ul>";
			}
		  
				
			//recup fichier
			$sql = "SELECT `lid`, `title`, `url`, `filesize` FROM ".$user_prefix."_downloads_downloads";
			$sql .= " WHERE lid='".$lignebp["id_file"]."';";
			$resultfile = $db->sql_query($sql);
			$files = "";
			if ($db->sql_numrows($resultfile) > 0) {
				if ($ligne = $db->sql_fetchrow($resultfile)) {
					$files .=  '<li><a href="file_'.$ligne["lid"].'.htm" target="_blank">';
					$files .= $ligne["title"];
					$files .= "</a></li>";
				}
				$files = "<ul>".$files."</ul>";
			}

			//recup photo
			$laphoto = "";
			if ($lignebp["photo"] != ""){
				$laphoto = '<img src="'.$lignebp["photo"].'" class="illustbp" />';
			}
			$lignebp["resume"] = preg_replace("#<p([^>]*)>#mi", "<p\\1>".$laphoto, $lignebp["resume"],1);
			
			//modif partenaire
			if ($lignebp["partenaire"]) {
				$lignebp["partenaire"] = preg_replace("#(([A-Za-z0-9_-]|\.)+@[A-Za-z0-9_-]+\.([A-Za-z0-9_-][A-Za-z0-9_]+))#mi","<a href=\"mailto:\\1\">\\1</a>",$lignebp["partenaire"]);
			}
			
			//recup fiches lies
			/* catgories identiques */
			$sql = "SELECT ".$user_prefix."_bpratique.id, `titre` ";
			$sql .= " FROM ".$user_prefix."_bpratique";
			$sql .= " INNER JOIN ".$user_prefix."_bpratique_cat_link ON ".$user_prefix."_bpratique_cat_link.id_pratique=".$user_prefix."_bpratique.id";
			$sql .= " WHERE  ".$user_prefix."_bpratique_cat_link.level='1' AND ".$user_prefix."_bpratique_cat_link.id_cat='".$id_cat."' AND ".$user_prefix."_bpratique.id<>'".$id."';";
			$result = $db->sql_query($sql);
			$listefichesliees = "";
			if ($db->sql_numrows($result) > 0) {
				while ($lignebplinked = $db->sql_fetchrow($result)) {
					$listefichesliees .= '<li><a href="modules.php?name='.$module_name.'&op='.$op.'&id='.$lignebplinked["id"].'&page='.$page.'">'.$lignebplinked["titre"].'</a></li>';
				}
			}
			/* catgories et thmes croiss */
			// $id_cat = catgorie de la fiche courante
			// $id_themes : tableau des thmes de la fiche courante
			$tabfichesliees1 = array();
			$sql = "SELECT ".$user_prefix."_bpratique.id ";
			$sql .= " FROM ".$user_prefix."_bpratique";
			$sql .= " INNER JOIN ".$user_prefix."_bpratique_cat_link ON ".$user_prefix."_bpratique_cat_link.id_pratique=".$user_prefix."_bpratique.id";
			$sql .= " WHERE  ".$user_prefix."_bpratique_cat_link.level='2' AND ".$user_prefix."_bpratique_cat_link.id_cat='".$id_cat."' AND ".$user_prefix."_bpratique.id<>'".$id."';";
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) > 0) {
				while ($lignebplinked = $db->sql_fetchrow($result)) {
					$tabfichesliees1[] .= $lignebplinked["id"];
					$tabfichesliees1 = array_unique($tabfichesliees1); //on se sait jamais...
				}	
			}
			//$tabfichesliees1 contient les fiches dont un thme gale la catgorie de la fiche courante
			$tabfichesliees2 = array();
			foreach($id_themes as $id_theme) {
				$sql = "SELECT ".$user_prefix."_bpratique.id ";
				$sql .= " FROM ".$user_prefix."_bpratique";
				$sql .= " INNER JOIN ".$user_prefix."_bpratique_cat_link ON ".$user_prefix."_bpratique_cat_link.id_pratique=".$user_prefix."_bpratique.id";
				$sql .= " WHERE  ".$user_prefix."_bpratique_cat_link.level='1' AND ".$user_prefix."_bpratique_cat_link.id_cat='".$id_theme."' AND ".$user_prefix."_bpratique.id<>'".$id."';";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					while ($lignebplinked = $db->sql_fetchrow($result)) {
						$tabfichesliees2[] .= $lignebplinked["id"];
					}
					$tabfichesliees2 = array_unique($tabfichesliees2);	
				}
			}
			//$tabfichesliees2 contient les fiches dont la catgorie gale un thme de la fiche courante
			//prendre les valeurs communes aux deux tableaux
			$tabficheslieesIndices = array_intersect($tabfichesliees1, $tabfichesliees2);
			/*if (count($tabficheslieesIndices) > 0 && $listefichesliees != "") {
				$listefichesliees .= '<li>--</li>';
			}*/
			//on rcupre les fiches
			foreach($tabficheslieesIndices as $indice) {
				$sql = "SELECT ".$user_prefix."_bpratique.id, `titre` ";
				$sql .= " FROM ".$user_prefix."_bpratique";
				$sql .= " WHERE ".$user_prefix."_bpratique.id='".$indice."';";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					if ($lignebplinked = $db->sql_fetchrow($result)) {
						$listefichesliees .= '<li><a href="modules.php?name='.$module_name.'&op='.$op.'&id='.$lignebplinked["id"].'&page='.$page.'">'.$lignebplinked["titre"].'</a></li>';
					}
				}
			}
			
			if ($listefichesliees != "") {
				$listefichesliees = "<ul>".$listefichesliees."</ul>";
			}
		  
			$sortie .= "<h1>"._FBP."</h1>";
				
			$sortie .= '<table border="0" cellpadding="0" cellspacing="0" class="bpfilescreen">';
				
			$sortie .= '<tr class="titlebp">';
			$sortie .= '<td colspan="2">';
			$sortie .= $lignebp["titre"];
			$sortie .= '</td>';
			$sortie .= '</tr>';
				
			$sortie .= '<tr>';
			$sortie .= '<td width="50%">';
			$sortie .= '<span class="legend">Contact : </span>';
			$sortie .= $bpuser;
			$sortie .= '</td>';
			$sortie .= '<td width="50%">';
			$sortie .= '<span class="legend">Institution et/ou personne : </span>';
			$sortie .= $lignebp["partenaire"];
			$sortie .= '</td>';
			$sortie .= '</tr>';
				
			$sortie .= '<tr>';
			$sortie .= '<td colspan="2">';
			$sortie .= '<span class="legend">Rsum de la pratique : </span>';
			$sortie .= $lignebp["resume"];
			$sortie .= '</td>';
			$sortie .= '</tr>';
				
			$sortie .= '<tr>';
			$sortie .= '<td width="50%">';
			$sortie .= '<span class="legend">Contexte de sa mise en oeuvre : </span>';
			$sortie .= $lignebp["contexte"];
			$sortie .= '</td>';
			$sortie .= '<td width="50%">';
			$sortie .= '<span class="legend">Public cible : </span>';
			$sortie .= $target;
			if ($lignebp["targetobs"] != "") {
				$sortie .= $lignebp["targetobs"];
			}
			$sortie .= '</td>';
			$sortie .= '</tr>';
				
			$sortie .= '<tr>';
			$sortie .= '<td>';
			$sortie .= '<span class="legend">Objectif de la dmarche : </span>';
			$sortie .= $lignebp["objectifs"];
			$sortie .= '</td>';
			$sortie .= '<td>';
			$sortie .= '<span class="legend">Rsultat : </span>';
			$sortie .= $lignebp["resultat"];
			$sortie .= '</td>';
			$sortie .= '</tr>';
				
			$sortie .= '<tr>';
			$sortie .= '<td width="50%">';
			$sortie .= '<span class="legend">Perspective d\'usage et de dissmination : </span>';
			$sortie .= $lignebp["perspective"];
			$sortie .= '</td>';
			$sortie .= '<td width="50%">';
			$sortie .= '<span class="legend">Liens utiles : </span>';
			$sortie .= $bplinks;
			$sortie .= '</td>';
			$sortie .= '</tr>';
				
			if ($files != "") {
				$sortie .= '<tr>';
				$sortie .= '<td colspan="2">';
				$sortie .= '<span class="legend">Fichier joint : </span>';
				$sortie .= $files;
				$sortie .= '</td>';
				$sortie .= '</tr>';
			}
			$sortie .= '</table>';
			if ($listefichesliees != "") {
				$sortie .= '&nbsp;<br /><h3>Actions lies</h3>';
				$sortie .= $listefichesliees;
			}
			if (is_user($user)) {
				$user_data_bloc = base64_decode($user);
				$userdata = explode(":", $user_data_bloc);
				$userdata[11] = array_explode_2( "@",";", $userdata[11]);
			}
			if ($userdata[0] == $lignebp["id_user"] || is_admin($admin)) {
				$sortie .='
<br />
<form method="post" action="modules.php?name='.$module_name.'&op=newpratique&id='.$id.'">
<div align="center"><input type="submit" value="Modifier la fiche"></div>
</form>';
			}
				
			include("header.php");
			echo $sortie;
			$bardef=array("back"=>"javascript:window.history.back()",
				"print"=>"modules.php?name=bp&op=printpratique&id=$id",
				"mailto"=>"#",
				"top"=>"#top" );
			buttonBar($bardef, "align");
			include("footer.php");
		}
		else {
			die("erreur");
		}
	}
	else {
		header("Location: modules.php?name=$module_name&page=$page");
		die();
	}
}

function format_nuke_url($nukeurl) {
	$tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}
	return $racine;
}

function print_pratique($id) {
	global $user, $group, $module_name, $user_prefix, $db, $page;
	global $sitename, $Default_Theme, $site_logo;
	if ($id != "") {
		$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
		$nukeurl = format_nuke_url($nukeurl);

		$sql = "SELECT `id_user` , `date` , `titre` , `partenaire` , `resume` , `contexte` , `targetobs` , `objectifs` , `resultat` , `perspective` , `pays` , `region` , `statut` , `id_file` ";
		$sql .= " FROM ".$user_prefix."_bpratique";
		$sql .= " WHERE  id='".$id."';";
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) > 0) {
			$lignebp = $db->sql_fetchrow($result);
				
			//recup user
			$sql = "SELECT email, adh_entreprise, adh_adresse, user_name, user_firstname, user_func, adh_tel, adh_web ";
			$sql .= " FROM ".$user_prefix."_users";
			$sql .= " WHERE  uid='".$lignebp["id_user"]."';";
			$resultuser = $db->sql_query($sql);
			$bpuser = "";
			if ($db->sql_numrows($resultuser) > 0) {
				if($ligneuser = $db->sql_fetchrow($resultuser)) {
					$bpuser .= ($ligneuser["user_name"].$ligneuser["user_firstname"] == "") ? "" : $ligneuser["user_firstname"]." ".$ligneuser["user_name"];
					$bpuser .= ($ligneuser["adh_entreprise"]== "") ? "" : "<br />".$ligneuser["adh_entreprise"];
					$bpuser .= ($ligneuser["user_func"]== "") ? "" : "<br />".$ligneuser["user_func"];
					$bpuser .= ($ligneuser["adh_adresse"]== "") ? "" : "<br />".$ligneuser["adh_adresse"];
					$bpuser .= ($ligneuser["adh_tel"]== "") ? "" : "<br />Tl : ".$ligneuser["adh_tel"];
					$bpuser .= ($ligneuser["email"]== "") ? "" : "<br />Courriel : <a href= \"mailto:".$ligneuser["email"]."\" target=\"_blank\">".$ligneuser["email"]."</a>";
					$bpuser .= ($ligneuser["adh_web"]== "") ? "" : "<br />Web : <a href= \"http://".str_replace("http://","",$ligneuser["adh_web"])."\" target=\"_blank\">"."http://".str_replace("http://","",$ligneuser["adh_web"])."</a>";
				}
			}
				
			//rcup liens
			$sql = "SELECT id, titre, url";
			$sql .= " FROM `".$user_prefix."_bpratique_liens`";
			$sql .= " WHERE id_pratique='".$id."';";
			$resultliens = $db->sql_query($sql);
			$bplinks = "";
			if ($db->sql_numrows($resultliens) > 0) {
				while($ligneliens = $db->sql_fetchrow($resultliens)) {
					$bplinks .= '<li>'.$ligneliens["titre"].'<br />http://'.str_replace("http://","",$ligneliens["url"]).'</li>';
				}
				$bplinks = '<ul>'.$bplinks.'</ul>';
			}
				
			//rcup catgories
			$cat1 = "";
			$sql = "SELECT id_cat";
			$sql .= " FROM `".$user_prefix."_bpratique_cat_link`";
			$sql .= " WHERE id_pratique='".$id."' AND level='1';";
			$resultcat1 = $db->sql_query($sql);
			if ($db->sql_numrows($resultcat1) > 0) {
				$lignebp2 = $db->sql_fetchrow($resultcat1);
				$cat1 = all_way_cat($lignebp2["id_cat"]);
			}
		  
			$cat2 = "";
			$sql = "SELECT id_cat";
			$sql .= " FROM `".$user_prefix."_bpratique_cat_link`";
			$sql .= " WHERE id_pratique='".$id."' AND level='2';";
			$resultcat2 = $db->sql_query($sql);
			if ($db->sql_numrows($resultcat2) > 0) {
				while ($lignebp2 = $db->sql_fetchrow($resultcat2)) {
					$cat2 .= '<li>'.all_way_cat($lignebp2["id_cat"]).'</li>';
				}
				$cat2 = '<ul>'.$cat2.'</ul>';
			}
		  
			//rcup public cible
			$target = "";
			$sql = "SELECT `target` FROM `".$user_prefix."_bpratique_target`";
			$sql .= " INNER JOIN ".$user_prefix."_bpratique_target_link ON ".$user_prefix."_bpratique_target.id=id_target";
			$sql .= " WHERE id_pratique = ".$id.";";
			$resulttarget = $db->sql_query($sql);
			if ($db->sql_numrows($resulttarget) > 0) {
				$cat2 = "";
				while ($lignebp2 = $db->sql_fetchrow($resulttarget)) {
					$target .= '<li>'.$lignebp2["target"].'</li>';
				}
				$target = "<ul>".$target."</ul>";
			}
		  
				
			//recup fichier
			$sql = "SELECT `lid`, `title`, `url`, `filesize` FROM ".$user_prefix."_downloads_downloads";
			$sql .= " WHERE lid='".$lignebp["id_file"]."';";
			$resultfile = $db->sql_query($sql);
			$files = "";
			if ($db->sql_numrows($resultfile) > 0) {
				if ($ligne = $db->sql_fetchrow($resultfile)) {
					$files .=  '<li>';
					$files .= $ligne["title"].' : '.$nukeurl.'/file_'.$ligne["lid"].'.htm';
					$files .= "</li>";
				}
				$files = "<ul>".$files."</ul>";
			}
		  
				
			$sortie .= '<table border="0" cellpadding="0" cellspacing="0" class="bpfilescreen">';
				
			$sortie .= '<tr>';
			$sortie .= '<td width="50%">';
			$sortie .= '<span class="legend">Intitul de la bonne pratique : </span>';
			$sortie .= $lignebp["titre"];
			$sortie .= '</td>';
			$sortie .= '<td width="50%">';
			$sortie .= '<span class="legend">Contact : </span>'.'<br />';
			$sortie .= $bpuser;
			$sortie .= '</td>';
			$sortie .= '</tr>';
				
			$sortie .= '<tr>';
			$sortie .= '<td colspan="2">';
			$sortie .= '<span class="legend">Institution et/ou personne : </span>';
			$sortie .= $lignebp["partenaire"];
			$sortie .= '</td>';
			$sortie .= '</tr>';
				
			$sortie .= '<tr>';
			$sortie .= '<td colspan="2">';
			$sortie .= '<span class="legend">Rsum de la pratique : </span>';
			$sortie .= $lignebp["resume"];
			$sortie .= '</td>';
			$sortie .= '</tr>';
				
			$sortie .= '<tr>';
			$sortie .= '<td width="50%">';
			$sortie .= '<span class="legend">Contexte de sa mise en oeuvre : </span>';
			$sortie .= $lignebp["contexte"];
			$sortie .= '</td>';
			$sortie .= '<td width="50%">';
			$sortie .= '<span class="legend">Public cible : </span>';
			$sortie .= $target;
			if ($lignebp["targetobs"] != "") {
				$sortie .= $lignebp["targetobs"];
			}
			$sortie .= '</td>';
			$sortie .= '</tr>';
				
			$sortie .= '<tr>';
			$sortie .= '<td width="50%">';
			$sortie .= '<span class="legend">Objectif de la dmarche : </span>';
			$sortie .= $lignebp["contexte"];
			$sortie .= '</td>';
			$sortie .= '<td width="50%">';
			$sortie .= '<span class="legend">Rsultat : </span>';
			$sortie .= $lignebp["resultat"];
			$sortie .= '</td>';
			$sortie .= '</tr>';
				
			$sortie .= '<tr>';
			$sortie .= '<td width="50%">';
			$sortie .= '<span class="legend">Perspective d\'usage et de dissmination : </span>';
			$sortie .= $lignebp["perspective"];
			$sortie .= '</td>';
			$sortie .= '<td width="50%">';
			$sortie .= '<span class="legend">Liens utiles : </span>';
			$sortie .= $bplinks;
			$sortie .= '</td>';
			$sortie .= '</tr>';
				
			if ($files != "") {
				$sortie .= '<tr>';
				$sortie .= '<td colspan="2">';
				$sortie .= '<span class="legend">Fichier joint : </span>';
				$sortie .= $files;
				$sortie .= '</td>';
				$sortie .= '</tr>';
			}
			$sortie .= '</table>';
				
				
			if (file_exists("themes/$Default_Theme/style/Sections.css")) {
				$moduleStyle= "<LINK REL=\"stylesheet\" HREF=\"themes/$Default_Theme/style/bp.css\" TYPE=\"text/css\">\n";
			}
			else if (file_exists("modules/Sections/css/default.css")) {
				$moduleStyle= "<LINK REL=\"StyleSheet\" HREF=\"modules/Sections/css/default.css\" TYPE=\"text/css\">\n";
			}
			else $moduleStyle="";

			echo "
			<html>
			<head>
			<title>$sitename</title>
			<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=ISO-8859-1\">\n
			<LINK REL=\"StyleSheet\" HREF=\"themes/$Default_Theme/style/style.css\" TYPE=\"text/css\">\n
			$moduleStyle
			</head>
			<body bgcolor=\"#FFFFFF\" text=\"#000000\">
			<table border=\"0\" align=\"center\"><tr><td>
			<!--<table border=\"0\" width=\"650\" cellpadding=\"0\" cellspacing=\"1\" bgcolor=\"#000000\"><tr><td>
			<table border=\"0\" width=\"650\" cellpadding=\"20\" cellspacing=\"1\" bgcolor=\"#FFFFFF\"><tr><td>-->
			<table border=\"0\" width=\"650\" cellpadding=\"0\" cellspacing=\"1\" bgcolor=\"#ffffff\"><tr><td>
			<div class=\"printHeader\"><img src=\"images/$site_logo\" border=\"0\" alt=\"\" align=\"absmiddle\" hspace=\"15\"><span class=\"title\">Fiche bonne pratique</span></div>
			<div class=\"zprint\">
			$sortie
			</div>
			<!--</td></tr></table></td></tr></table>-->
			</td></tr></table>
	
			<div class=\"printFooter\">
			<div class=\"siteName\">
	    "._COMESFROM." $sitename<br>
			<a href=\"$nukeurl\">$nukeurl</a>
			</div>
			<div class=\"pageURL\">
	    "._THEURL."<br>
			<a href=\"$nukeurl/modules.php?name=bp&op=showpratique&id=$id\">$nukeurl/modules.php?name=bp&op=showpratique&id=$id</a>
			</div>
			</div>
			</td></tr></table>
			</body>
			</html>
	    ";
				
		}
		else {
			die("erreur");
		}
	}
}

if (! isset($id)) {
	$id = "";
}

if (!isset($search)) {
	$search = array();
}

// -------------------------------- SWITCH PART --------------------------------
switch($op) {
	case "editpratique":
	case "newpratique":
		new_pratique($id);
		break;
	case "catone":
		catone($id);
		break;
	case "catmulti":
		catmulti($id);
		break;
	case "savepratique":
		save_pratique($data);
		break;
	case "delpratique":
		del_pratique($id, $ok);
		break;
	case "delfile":
		delfile($id_file, $id, $ok);
		break;
	case "delphoto":
		delphoto($id, $ok);
		break;
	case "dellink":
		dellink($id_link, $id, $ok);
		break;
	case "showpratique":
		display_pratique($id);
		break;
	case "printpratique":
		print_pratique($id);
		break;
	case "allbp" :
	default:
		//$sortie .= show_comments($id,$user_data);//$id est l'identifiant de la publication !!!
		showallpratiques($search);
		break;
}

?>