<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.balistis.com                                              */
/*                                                                      */
/*   																	*/
/* Baliste "Annuaire de Acteur" Module . Stephan ACQUATELLA 2004		*/
/* Project: Environmental Corsican Observatory       					*/
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

// Init Part
if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

require_once("core/becms_mainlib_lib.php");
$module_name = basename(dirname(__FILE__));
get_lang($module_name);


function navigActeurs() {
	global $module_name;
	echo "<h1>".ANNUTITLE."</h1>";
	echo "<fieldset><legend>"._SEARCHCRITERIA."</legend>";
	echo "<div class=\"search_search\">";
	echo "<form action=\"modules.php?name=Search\" method=\"post\">"
	."<input type=\"hidden\" name=\"type\" value=\"acteurs\">"
	.""._SEARCHONACTEUR." <input type=\"name\" name=\"query\" size=\"30\">&nbsp;&nbsp;"
	."<input type=\"submit\" value=\""._SEARCH."\">"
	."</form>"
	."<div><br>[ "
	."<a href=\"modules.php?name=$module_name\">"._ALPHAACCES."</a>"
	." ]</div>";
	echo "</div>";
	echo "</fieldset>";

	echo "&nbsp;<br>";
	echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"tabfiche\"><tr>";
	echo "<td colspan=\"3\">";
	echo "<fieldset><legend>"._ANNULISTDOMAINCOMP."</legend>";
	echo listCompetence();
	echo "</fieldset>";
	echo "<p>&nbsp;</p>";
	echo "</td>";
	echo "</tr><tr>";
	echo "<td width=\"49%\" valign=\"top\">";
	echo "<fieldset><legend>"._ANNULISTTYPEORGA."</legend>";
	echo listOrganismType();
	echo "</fieldset>";
	echo "</td>";
	echo "<td width=\"2%\">";
	echo "&nbsp;";
	echo "</td>";
	echo "<td width=\"49%\" valign=\"top\">";
	echo "<fieldset><legend>"._ANNULISTPAYS."</legend>";
	echo listPays();
	echo "</fieldset>";
	echo "</td>";
	echo "</tr></table>";
}

/**
 * displayAccess
 * display liste by organisme type, and competences
 * @param
 * @return
 * @see
 */
function displayAccess() {
	global $sitename, $prefix, $db, $module_name;
	include ('header.php');
	navigActeurs();
	include ('footer.php');
}

/**
 * listActeur()
 * display acteur list sorted by compentence or activity or organisme type
 * @param typid :organism type id
 * @param comid :competences domaine id
 * @param sortBy : data sorted by competence or organism type
 * @return
 * @see
 */
function listActeur($typid, $domid, $country, $sortBy) {
	global $sitename, $prefix, $db, $module_name;
	include ('header.php');
	
	navigActeurs();

	echo "&nbsp;<a name=\"acteurs\"></a><br>";
	if (!is_null($typid)) {
		if ($typid == "-1") {
			$result2 = $db->sql_query("select type_organisme,typid from ".$prefix."_annuaireacteur_liste_type order by type_organisme asc");
		}
		else {
			$result2 = $db->sql_query("select type_organisme,typid from ".$prefix."_annuaireacteur_liste_type where typid='$typid'");
		}
		if (!$result2) {
			print_r ( $db->sql_error () );
			die('Invalid query');
		}
		while (list($type_organisme,$typid)= $db->sql_fetchrow($result2)) {
			//echo "<h2>".ucfirst($type_organisme)."</h2>";
			echo "<fieldset><legend>".ucfirst($type_organisme)."</legend>";
			echo "<div class=\"padfield\"></div>";
			$result = $db->sql_query("select actid, nom_acteur, ville_acteur, sigle_acteur, web_acteur from ".$prefix."_annuaireacteur_acteur where type_acteur='$typid' order by nom_acteur");
			if (!$result) {
				print_r ( $db->sql_error () );
				die('Invalid query');
			}
			if ($db->sql_numrows($result) > 0) {
				echo "<table class=\"tabannu\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
				$pos=1;
				while(list($actid, $nom_acteur, $ville_acteur, $sigle_acteur, $web_acteur) = $db->sql_fetchrow($result)) {
					if ($pos % 2 == 0)	{
						$style = " class=\"odd\"";
					}
					else {
						$style = " class=\"notodd\"";
					}
					if (function_exists("theme_acteur_list_elt")) {
						theme_acteur_list_elt($actid,$pos);
						$pos++;
					}
					else {
						$sectionLink="<a href=\"modules.php?name=$module_name&sop=viewActeur&actid=$actid\" >";
						echo "<tr>"
						."<th align=\"center\"".$style."> $sigle_acteur</th>"
						."<td align=\"left\"".$style.">$sectionLink $nom_acteur</a></td>"
						."</tr>";
						$pos++;
					}
				}
				echo "</table>";	
			}
			else {
				echo "<p>"._ANNUNOORGTYPE."</p>";
			}
			echo "</fieldset>";
		}
	}
	if (!is_null($domid)) {
		if ($domid == "-1") {
			$result2 = $db->sql_query("select domainename,domid from ".$prefix."_annuaireacteur_liste_domaine order by domainename asc ");
		}
		else {
			$result2 = $db->sql_query("select domainename,domid from ".$prefix."_annuaireacteur_liste_domaine where domid='$domid'");
		}
		if (!$result2) {
			print_r ( $db->sql_error () );
			die('Invalid query');
		}
		while (list($domaine,$domid)= $db->sql_fetchrow($result2)) {
			//echo "<h2>".ucfirst($domaine)."</h2>";
			echo "<fieldset><legend>".ucfirst($domaine)."</legend>";
			echo "<div class=\"padfield\"></div>";
			$result = $db->sql_query("select ".$prefix."_annuaireacteur_domaine.acteur_actid, ".$prefix."_annuaireacteur_domaine.domaine, ".$prefix."_annuaireacteur_domaine.com_domaine, ".$prefix."_annuaireacteur_acteur.nom_acteur,".$prefix."_annuaireacteur_acteur.sigle_acteur from ".$prefix."_annuaireacteur_domaine inner join ".$prefix."_annuaireacteur_acteur on ".$prefix."_annuaireacteur_domaine.acteur_actid = ".$prefix."_annuaireacteur_acteur.actid where domaine_domid='$domid' order by ".$prefix."_annuaireacteur_acteur.nom_acteur");
			if (!$result) {
				print_r ( $db->sql_error () );
				die('Invalid query');
			}
			if ($db->sql_numrows($result) > 0) {
				echo "<table class=\"tabannu\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
				$pos=1;
				while(list($actid, $domaine, $com_domaine, $nom_acteur, $sigle_acteur) = $db->sql_fetchrow($result)) {
					if ($pos % 2 == 0)	{
						$style = " class=\"odd\"";
					}
					else {
						$style = " class=\"notodd\"";
					}
					$sectionLink="<a href=\"modules.php?name=$module_name&sop=viewActeur&actid=$actid\" >";
					if (function_exists("theme_acteur_list_elt")) {
						theme_acteur_list_elt($actid,$pos);
						$pos++;
					}
					else {
						echo "<tr>"
						."<th align=\"center\"".$style."> $sigle_acteur</th>"
						."<td align=\"left\"".$style.">$sectionLink $com_domaine</a></td>"
						."</tr>";
						$pos++;
					}
				}
				echo "</table>";
			}
			else {
				echo "<p>"._ANNUNOORGCOMP."</p>";
			}
			echo "</fieldset>";
		}
	}
	if (!is_null($country)) {
		echo "<fieldset><legend>".ucfirst($country)."</legend>";
		echo "<div class=\"padfield\"></div>";
		$result = $db->sql_query("select actid, nom_acteur, sigle_acteur from ".$prefix."_annuaireacteur_acteur where pays_acteur='$country' order by nom_acteur");
		if (!$result) {
			print_r ( $db->sql_error () );
			die('Invalid query');
		}
		if ($db->sql_numrows($result) > 0) {
			echo "<table class=\"tabannu\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
			$pos=1;
			while(list($actid, $nom_acteur, $sigle_acteur) = $db->sql_fetchrow($result)) {
				if ($pos % 2 == 0)	{
					$style = " class=\"odd\"";
				}
				else {
					$style = " class=\"notodd\"";
				}
				if (function_exists("theme_acteur_list_elt")) {
					theme_acteur_list_elt($actid,$pos);
					$pos++;
				}
				else {
					$sectionLink="<a href=\"modules.php?name=$module_name&sop=viewActeur&actid=$actid\" >";
					echo "<tr>"
					."<th align=\"center\"".$style."> $sigle_acteur</th>"
					."<td align=\"left\"".$style.">$sectionLink $nom_acteur</a></td>"
					."</tr>";
					$pos++;
				}
			}
			echo "</table>";
		}
		else {
			echo "<p>"._ANNUNOORGCOMP."</p>";
		}
		echo "</fieldset>";
	}
	include ('footer.php');
}
/**
 * listActeurArbo()
 * Affiche les acteurs regroups par domaine puis par type. Si aucune domaine n'est indiqu, tous sont affichs, sinon seul le domaine indiqu est affich.
 * @param domid :competences domaine id
 * @see
 */
function listActeurArbo($domid) {
	global $sitename, $prefix, $db, $module_name;
	include ('header.php');
	echo "<h1>".ANNUTITLE."</h1>";
	$result4 = $db->sql_query("select domainename,domid from ".$prefix."_annuaireacteur_liste_domaine order by domainename asc ");
	if (!$result4) {
		print_r ( $db->sql_error () );
		die('Invalid query');
	}
	$menu_dom = '<select name="domid" size="1" onchange="window.location.href=\'modules.php?name='.$module_name.'&sop=listActeurArbo&domid=\'+this.value">';
	$menu_dom .= '<option value="">'._ANNUFIRSTLINECHOOSE.'</option>';
	while (list($domaine,$domidsel)= $db->sql_fetchrow($result4)) {
		$select = ($domid == $domidsel) ? " selected=\"selected\"" : "";
		$menu_dom .= '<option value="'.$domidsel.'"'.$select.'>'.$domaine.'</option>';
	}
	$menu_dom .= "</select>";
	echo "<fieldset><legend>"._ANNUCHOOSEDOM."</legend>";
	echo "<div class=\"search_search\">";
	echo "<form action=\"\" method=\"post\">"
	.""._ANNUCHOOSEDOMMENU.$menu_dom
	."</form>";
	echo "</div>";
	echo "</fieldset>";
	echo "&nbsp;<br />";
	if ($domid == "-1" || $domid == "") {
		$result2 = $db->sql_query("select domainename,domid from ".$prefix."_annuaireacteur_liste_domaine order by domainename asc ");
	}
	else {
		$result2 = $db->sql_query("select domainename,domid from ".$prefix."_annuaireacteur_liste_domaine where domid='$domid'");
	}
	if (!$result2) {
		print_r ( $db->sql_error () );
		die('Invalid query');
	}
	while (list($domaine,$domid)= $db->sql_fetchrow($result2)) {
		echo "<h2>".ucfirst($domaine)."</h2>";
		$result = $db->sql_query("select distinct type_acteur from ".$prefix."_annuaireacteur_domaine inner join ".$prefix."_annuaireacteur_acteur on acteur_actid=actid where domaine_domid='$domid'");
		if (!$result) {
			print_r ( $db->sql_error () );
			die('Invalid query');
		}
		if ($db->sql_numrows($result) > 0) {
			while(list($typid) = $db->sql_fetchrow($result)) {
				$result3 = $db->sql_query("select type_organisme,typid from ".$prefix."_annuaireacteur_liste_type where typid='$typid'");
				if (!$result3) {
					print_r ( $db->sql_error () );
					die('Invalid query');
				}
				while (list($type_organisme,$typid)= $db->sql_fetchrow($result3)) {
					echo "<h3>".ucfirst($type_organisme)."</h3>";
					$result5 = $db->sql_query("select actid, nom_acteur, ville_acteur, sigle_acteur, web_acteur from ".$prefix."_annuaireacteur_acteur inner join ".$prefix."_annuaireacteur_domaine on acteur_actid=actid where type_acteur='$typid' and domaine_domid='$domid' order by nom_acteur");
					if (!$result5) {
						print_r ( $db->sql_error () );
						die('Invalid query');
					}
					if ($db->sql_numrows($result5) > 0) {
						echo "<ul class=\"listact\">";
						while(list($acteurid, $nom_acteur, $ville_acteur, $sigle_acteur, $web_acteur) = $db->sql_fetchrow($result5)) {
							echo "<li><a href=\"modules.php?name=$module_name&sop=viewActeur&actid=$acteurid\">".$nom_acteur."</a></li>";
						}
						echo "</ul>";
					}
					else {
						echo "<p>"._ANNUNOORGTYPE."</p>";
					}
				}
			}
		}
		else {
			echo "<p>"._ANNUNOORGCOMP."</p>";
		}
	}
	include ('footer.php');
}
/**
 * listOrganismType()
 * display list of existinf organism type
 * @param
 * @return
 * @see
 */
function listOrganismType() {
	global $sitename, $prefix, $db, $module_name;
	$result = $db->sql_query("select typid, type_organisme from ".$prefix."_annuaireacteur_liste_type order by type_organisme");
	//	$mycontent="";
	//	//$mycontent.="<TABLE borderColor=#ffffff cellSpacing=2 borderColorDark=#ff8000 cellPadding=2 width=300 border=0>";
	//	$mycontent.="<TABLE class=\"tab\" cellSpacing=2 cellPadding=2 width=260 border=0>";
	//	$mycontent.="<TBODY>";
	//	//$mycontent.="<TR borderColor=#ffffff bgColor=darkorange>";
	//	$mycontent.="<TR>";
	//	$mycontent.="<TD height=39 align=center class=\"titretab\">";
	//	//$mycontent.="<FONT style=\"BACKGROUND-COLOR: darkorange\" color=#ffffff><B>Acc&egrave;s par type d'organisme</B></FONT></TD>";
	//	$mycontent.="Acc&egrave;s par type d'organisme</TD>";
	if ($db->sql_numrows($result) != 0){
		$mycontent ="<ul class=\"listcomp\">";
		while(list($typid, $type_organisme) = $db->sql_fetchrow($result)) {
			//		$mycontent.="<TR >";
			//		$mycontent.="<TD width=351 ><A href=\"modules.php?name=$module_name&amp;sop=listActeur&typid=$typid\">$type_organisme</A></TD>";
			//		$mycontent.="</TR>";
			$mycontent.="<li><a href=\"modules.php?name=$module_name&amp;sop=listActeur&typid=$typid#acteurs\">$type_organisme</a></li>";
		}
		$mycontent.="</ul>";
	}
	else {
		$mycontent = "<p>"._ANNULISTNOTHING."</p>";
	}
	// $mycontent.="</TABLE>";
	return $mycontent;
}
/**
 * listCompetence()
 * list existing competences domaine
 * @param
 * @return
 * @see
 */
function listCompetence() {
	global $sitename, $prefix, $db, $module_name;
	$result = $db->sql_query("select domid, domainename from ".$prefix."_annuaireacteur_liste_domaine order by domainename");
	//	$mycontent.="<TABLE  class=\"tab\" cellSpacing=2  cellPadding=2 width=270 border=0>";
	//	$mycontent.="<TBODY>";
	//	$mycontent.="<TR>";
	//	$mycontent.="<TD height=39 align=center class=\"titretab\">";
	//	$mycontent.="Acc&egrave;s par domaines de comp&eacute;tence</TD>";
	//	$mycontent.="</TR>";
	if ($db->sql_numrows($result) != 0){
		$mycontent ="<ul class=\"listcomp\">";
		while(list($domid, $domainename) = $db->sql_fetchrow($result)) {
			//$mycontent.="<TR borderColor=#ffffff bgColor=navajowhite>";
			//		$mycontent.="<TR >";
			//		$mycontent.="<TD width=351><A href=\"modules.php?name=$module_name&amp;sop=listActeur&domid=$domid\">$domainename</A></TD>";
			//		$mycontent.="</TR>";
			$mycontent.="<li><a href=\"modules.php?name=$module_name&amp;sop=listActeur&domid=$domid#acteurs\">".ucfirst($domainename)."</a></li>";
		}
		$mycontent.="</ul>";
	}
	else {
		$mycontent = "<p>"._ANNULISTNOTHING."</p>";
	}
	//	$mycontent.="</TABLE>";
	return $mycontent;
}

function listPays() {
	global $sitename, $prefix, $db, $module_name;
	$result = $db->sql_query("select distinct pays_acteur from ".$prefix."_annuaireacteur_acteur order by pays_acteur");
	if ($db->sql_numrows($result) != 0){
		$mycontent ="<ul class=\"listcomp\">";
		while(list($country) = $db->sql_fetchrow($result)) {
			$mycontent.="<li><a href=\"modules.php?name=$module_name&sop=listActeur&country=$country#acteurs\">".ucfirst($country)."</a></li>";
		}
		$mycontent.="</ul>";
	}
	else {
		$mycontent = "<p>"._ANNULISTNOTHING."</p>";
	}
	return $mycontent;
}
/**
 * listActeurByChar()
 *
 *
 *
 *
 */
function listActeurByChar($myfilter){
	global $sitename, $prefix, $db, $module_name;
	include ('header.php');
	if ($myfilter == "") $myfilter="A";
	if ($myfilter!="") 	$thefilter="WHERE nom_acteur LIKE '\\$myfilter%'";
	$result = $db->sql_query("select actid, nom_acteur, sigle_acteur from ".$prefix."_annuaireacteur_acteur $thefilter order by nom_acteur");

	echo "<h1>".ANNUTITLE."</h1>";
	echo "<fieldset><legend>"._SEARCHCRITERIA."</legend>";
	echo "<div class=\"search_search\">";
	echo "<form action=\"modules.php?name=Search\" method=\"post\">"
	."<input type=\"hidden\" name=\"type\" value=\"acteurs\">"
	.""._SEARCHONACTEUR." <input type=\"name\" name=\"query\" size=\"30\">&nbsp;&nbsp;"
	."<input type=\"submit\" value=\""._SEARCH."\">"
	."</form>"
	."<div><br>[ <a href=\"modules.php?name=$module_name&sop=displayAccess\">"._THEMECATEGORYACCES."</a> ]</div>";
	echo "</div>";
	echo "</fieldset>";

	echo "&nbsp;<br>";

	if (function_exists("theme_acteur_list_elt")) {
		$ncols = theme_acteur_list_elt("-1");
	}
	else {
		$ncols = "2";
	}
	
	echo "<fieldset><legend>"._ANNUALPHA."</legend>";
	echo "<table class=\"tabannu\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>"
	//."<td class=\"titretab\ width=\"75%\"><b>"._ACTEUR_NAME."</b></td>"
	//."<td class=\"titretab\ width=\"25%\"><b>"._ACTEUR_SIGLE."</b></td>"
	."<td class=\"acttab\" colspan=\"$ncols\">"._ANNULISTALPHA.displayAlphabet("modules.php?name=$module_name&sop=listActeurByChar",$myfilter)."</td>"
	."</tr>";
	echo "<tr><td colspan=\"$ncols\"><hr class=\"annu\"></td></tr>";

	$pos=1;
	while(list($actid, $nom_acteur, $sigle_acteur) = $db->sql_fetchrow($result)) {
		if (function_exists("theme_acteur_list_elt")) {
			theme_acteur_list_elt($actid,$pos);
			$pos++;
		}
		else {
			if ($pos % 2 == 0)	{
				$style = " class=\"odd\"";
			}
			else {
				$style = " class=\"notodd\"";
			}
			$sectionLink="<a href=\"modules.php?name=$module_name&sop=viewActeur&actid=$actid\" >";
			echo "<tr>"
			."<th align=\"center\"".$style."> $sigle_acteur</th>"
			."<td align=\"left\"".$style.">$sectionLink $nom_acteur</a></td>"
			."</tr>";
			$pos++;
		}
	}
	echo "</table>";
	echo "</fieldset>";

	include ('footer.php');
}


function display_line_not_null($libelle,$texte) {
	$texte = trim($texte);
	if ($texte != "") {
		return "<tr><td class=annuaireAttr>$libelle</td><td align=left>$texte</td></tr>";
	}
	else {
		return "";
	}
}

/**
 * viewActeur()
 * view Acteur data
 * @param acid :acteur id
 * @return
 * @see
 */
function viewActeur($actid) {
	global $sitename, $prefix, $db, $admin, $module_name;
	include ('header.php');
	if (function_exists("theme_Acteur")) {
		theme_Acteur($actid);
	}
	else {
		// get information about Acteur
		$result = $db->sql_query("select actid, nom_acteur, adresse_acteur, ville_acteur, codepostal_acteur, sigle_acteur, telephone_acteur, fax_acteur, email_acteur, web_acteur, nom_president_acteur, nom_directeur_acteur, status_acteur, mission_acteur, carte_acteur,type_acteur  from ".$prefix."_annuaireacteur_acteur where actid='$actid'");
		if (!$result) {
			print_r ( $db->sql_error () );
			die('Invalid query');
		}
		// get information about Competences
		$result2 = $db->sql_query("select domaine from ".$prefix."_annuaireacteur_domaine where acteur_actid='$actid'");
		if (!$result2) {
			print_r ( $db->sql_error () );
			die('Invalid query');
		}
		// get Information about Activities
		$result3 = $db->sql_query("select activite from ".$prefix."_annuaireacteur_activite where acteur_actid='$actid'");
		if (!$result3) {
			print_r ( $db->sql_error () );
			die('Invalid query');
		}
		// get Contacts
		$result4 = $db->sql_query("select nom_contact, prenom_contact, telephone_contact, telephone_mobile_contact, fax_contact, email_contact, web_contact, titre_contact, domaine_contact, role_contact from ".$prefix."_annuaireacteur_contact where acteur_actid='$actid' order by position_contact ");
		if (!$result4) {
			print_r ( $db->sql_error () );
			die('Invalid query');
		}
		list($actid, $nom_acteur, $adresse_acteur, $ville_acteur, $codepostal_acteur, $sigle_acteur, $telephone_acteur, $fax_acteur, $email_acteur, $web_acteur, $nom_president_acteur, $nom_directeur_acteur, $status_acteur, $mission_acteur, $carte_acteur, $type_acteur)= $db->sql_fetchrow($result);
		// get Status
		$myresult = $db->sql_query("select statusname from ".$prefix."_annuaireacteur_liste_status where statusid='$status_acteur'");
		list($statusname) = $db->sql_fetchrow($myresult);
		// get type
		$myresult = $db->sql_query("select type_organisme from ".$prefix."_annuaireacteur_liste_type where typid='$type_acteur'");
		list($typename) = $db->sql_fetchrow($myresult);
	
		// #####################" Titre #########################""
		$sigle_acteur = (!preg_match("#^(\ *)$#",$sigle_acteur)) ? "<br /><span class=\"sigle\">(".$sigle_acteur.")</span>" : "";
		echo "<h1>".$nom_acteur.$sigle_acteur."</h1>";
		echo "<hr class=\"annufiche\">";
		// Carte & info
		/*if ($carte_acteur=="") {
		$carte_acteur="images/annuaire_acteur/carte_corse_ba.jpg";
		}*/
	
		echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"tabfiche\" align=\"center\">"
		."<tr>";
		if ($carte_acteur != "") {
			echo "<td align=\"center\" valign=\"center\"><img src=\"$carte_acteur\" border=0><td>";
			echo "<td width=\"10\">";
		}
		if ($web_acteur != "") {
			$web_acteur = str_replace("http://","",$web_acteur);
			$web_acteur = '<a href="http://'.$web_acteur.'" target="_blank">'.$web_acteur."</a>";
		}
		echo "<td valign=top>"
		."<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\">"
		.display_line_not_null(_ADRESSE_ACTEUR,nl2br($adresse_acteur)."<br />".$codepostal_acteur." ".$ville_acteur)
		.display_line_not_null(_TELEPHONE_ACTEUR,$telephone_acteur)
		.display_line_not_null(_FAX_ACTEUR,$fax_acteur)
		.display_line_not_null(_EMAIL_ACTEUR,$email_acteur)
		.display_line_not_null(_WEB_ACTEUR,$web_acteur)
		.display_line_not_null(_STATUS_ACTEUR,$statusname)
		.display_line_not_null(_TYPE_ACTEUR,$typename);
	
		if ($nom_president_acteur != "" || $nom_directeur_acteur!= "") {
			echo "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>"
			."<tr><td><u><b>"._RESPONSABLE."</b></u></td><td align=left></td></tr>"
			.display_line_not_null(_PRESIDENT_ACTEUR,$nom_president_acteur)
			.display_line_not_null(_DIRECTEUR_ACTEUR,$nom_directeur_acteur);
		}
		echo "</table></td>"
		."</tr></table>";
		//mission
		if ($mission_acteur != "") {
			echo "&nbsp;<br />";
			echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"tabfiche\" align=\"center\"><tr><td valign=\"top\">";
			echo "<fieldset><legend>"._MISSION."</legend>";
			echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=annuaireTexteAttr>".$mission_acteur."</td></tr></table>";
			echo "</fieldset>";
			echo "</td></tr></table>";
		}
		// mission
		/*echo "<br><table width=\"90%\"><tr>"
		."<td align=center class=annuaireFormTitle >".strtoupper(_MISSION)."<td>"
		."</tr>"
		."<tr>"
		."<td class=annuaireTexteAttr>$mission_acteur</td>"
		."</tr></table>";*/
		// Domaine et Activite
		if (($db->sql_numrows($result2) != 0) || ($db->sql_numrows($result3) != 0)) {
			$domaine_list = "";
			while(list($domaine) = $db->sql_fetchrow($result2)) {
				$domaine_list .= "<li>$domaine</li>";
			}
			$domaine_list = ($domaine_list != "") ? "<ul>".$domaine_list."</ul>" : "";
			$activite_list = "";
			while(list($activite) = $db->sql_fetchrow($result3)) {
				$activite_list .= "<li>$activite</li>";
			}
			$activite_list = ($activite_list != "") ? "<ul>".$activite_list."</ul>" : "";
	
			echo "&nbsp;<br />";
			echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"tabfiche\" align=\"center\"><tr>";
			if (($db->sql_numrows($result2) != 0) && ($db->sql_numrows($result3) != 0)) {
				echo "<td valign=\"top\" width=\"49%\">";
			}
			else {
				if ($db->sql_numrows($result2) != 0) {
					echo "<td valign=\"top\">";
				}
			}
			if ($db->sql_numrows($result2) != 0) {
				echo "<fieldset><legend>"._DOMAINE_ACTEUR."</legend>";
				echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=annuaireTexteAttr>".$domaine_list."</td></tr></table>";
				echo "</fieldset>";
			}
			if (($db->sql_numrows($result2) != 0) && ($db->sql_numrows($result3) != 0)) {
				echo "</td><td width=\"2%\"></td><td valign=\"top\" width=\"49%\">";
			}
			else {
				if ($db->sql_numrows($result3) != 0) {
					echo "<td valign=\"top\">";
				}
			}
			if ($db->sql_numrows($result3) != 0) {
				echo "<fieldset><legend>"._ACTIVITE_ACTEUR."</legend>";
				echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=annuaireTexteAttr>".$activite_list."</td></tr></table>";
				echo "</fieldset>";
			}
			echo "</td></tr></table>";
		}
		/*echo "<br><table width=\"90%\"><tr>"
		 ."<td align=center class=annuaireFormTitle width=\"50%\">"._DOMAINE_ACTEUR."</td>"
		 ."<td align=center class=annuaireFormTitle width=\"50%\">"._ACTIVITE_ACTEUR."</td>"
		 ."</tr>"
		 ."<tr>"
		 ."<td class=annuaireTexteAttr><UL>";
		 while(list($domaine) = $db->sql_fetchrow($result2)) {
			echo "<LI> $domaine";
			}
			echo "</UL></td>"
			."<td class=annuaireTexteAttr><UL>";
			while(list($activite) = $db->sql_fetchrow($result3)) {
			echo "<LI> $activite";
			}
			echo "</UL></td>"
			."</tr></table>";*/
	
		// Contact
		//mission
		if ($db->sql_numrows($result4) != 0) {
			echo "&nbsp;<br />";
			echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"tabfiche\" align=\"center\"><tr><td valign=\"top\">";
			echo "<fieldset><legend>"._CONTACT."</legend>";
			echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">";
			while(list($nom_contact, $prenom_contact, $telephone_contact, $telephone_mobile_contact, $fax_contact, $email_contact, $web_contact, $titre_contact, $domaine_contact, $role_contact) = $db->sql_fetchrow($result4)) {
				if (trim($telephone_contact) != "") {
					$TelephoneDisplay = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>";
					$TelephoneDisplay .= "<img src=\"images/annuaire_acteur/attribut/icone_telephonenumber.gif\" border=\"0\">";
					$TelephoneDisplay .= "</td><td>";
					$TelephoneDisplay .= $telephone_contact;
					$TelephoneDisplay .= "</td></tr></table>";
				}
				else {
					$TelephoneDisplay = "";
				}
				if (trim($email_contact) != "") {
					$MailDisplay = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>";
					$MailDisplay .= "<img src=\"images/annuaire_acteur/attribut/icone_mail.gif\" border=\"0\">";
					$MailDisplay .= "</td><td>";
					$MailDisplay .= $email_contact;
					$MailDisplay .= "</td></tr></table>";
				}
				else {
					$MailDisplay = "";
				}
				echo "<tr><td class=\"annuaireAttr\" colspan=\"4\" id=\"contact\">$nom_contact $prenom_contact </td>"
				."<tr class=annuaireTexteAttr ><td width=\"30%\"> ".trim($domaine_contact." - ".$role_contact." - ".$titre_contact," -")."</td><td width=\"35%\">$TelephoneDisplay</td><td width=\"35%\">$MailDisplay</td></tr>";
			}
			echo "</table>";
			echo "</fieldset>";
			echo "</td></tr></table>";
		}
	
		/*	echo "<br><table width=\"90%\"><tr>"
		 ."<td align=center class=annuaireFormTitle>".strtoupper(_CONTACT)."<td>"
		 ."</tr>"
		 ."<tr>"
		 ."<td><table  >";
		 while(list($nom_contact, $prenom_contact, $telephone_contact, $telephone_mobile_contact, $fax_contact, $email_contact, $web_contact, $titre_contact, $domaine_contact, $role_contact) = $db->sql_fetchrow($result4)) {
			if (trim($telephone_contact)!="")$TelephoneDisplay="<img src=\"images/annuaire_acteur/attribut/icone_telephonenumber.gif\" border=0> $telephone_contact";
			if (trim($email_contact)!="")$MailDisplay="<img src=\"images/annuaire_acteur/attribut/icone_mail.gif\" border=0> $email_contact";
			echo "<tr ><td class=annuaireAttr colspan=3><b>$nom_contact $prenom_contact</b> </td>"
			."<tr class=annuaireTexteAttr ><td style=\" border-bottom: thin dotted darkorange \" width=\"30%\"> $domaine_contact</td><td style=\" vertical-align: middle ;border-bottom: thin dotted darkorange \" width=\"35%\">$TelephoneDisplay</td><td style=\" border-bottom: thin dotted darkorange \" width=\"35%\">$MailDisplay</td></tr></UL>";
			}
			echo "</table></td>"
			."</tr></table>";*/
	}
	// Impression et PDF
	$bardef=array(
	"print"=>"modules.php?name=$module_name&sop=printActeurPage&actid=$actid",
	//"pdf"=>"modules.php?name=balisteEcmspdf&sop=view&actid=$actid&pdfname=FicheActeur",
	"back"=>"javascript:window.history.back()",
	"top"=>"#top"
	);
	buttonBar($bardef, "align");

	/*echo "<br><table width=\"100%\"><tr><td align=right>";
	 echo "<a href=\"modules.php?name=$module_name&sop=printActeurPage&amp;actid=$actid\" target=\"_blank\"><img src=\"images/print.gif\" border=\"0\" Alt=\""._PRINTER."\" width=\"18\" height=\"20\"></a>"
	 ." <a href=\"modules.php?name=balisteEcmspdf&sop=view&amp;actid=$actid&pdfname=FicheActeur\"><img src=\"images/pdf15x15.jpg\" border=\"0\" Alt=\""._PDF."\" width=\"15\" height=\"15\"></a>"
	 ."</font></td></tr></table>";*/

	adminEditButton("system.php?op=acteurEdit&onglet=acteur&actid=$actid&editForm=1");

	include ('footer.php');
}

/**
 * printActeurPage($acid)
 * format acteur page for an HTML print
 * @param acid :acteur id
 * @return
 * @see
 */
function printActeurPage($actid,$ok=1) {
	global $site_logo,$Default_Theme, $nukeurl, $sitename, $datetime, $prefix, $db, $module_name;

	$printPage="<html>"
	."<head>"
	."<title>$sitename</title>"
	."<LINK REL=\"StyleSheet\" HREF=\"themes/$Default_Theme/style/style.css\" TYPE=\"text/css\">\n\n\n"
	."</head>"
	."<body bgcolor=\"#FFFFFF\" text=\"#000000\" >"
	."<table border=\"0\"><tr><td>"
	."<table border=\"0\" width=\"640\" cellpadding=\"0\" cellspacing=\"1\" bgcolor=\"#000000\"><tr><td>"
	."<table border=\"0\" width=\"640\" cellpadding=\"20\" cellspacing=\"1\" bgcolor=\"#FFFFFF\"><tr><td>"
	."<center>"
	."<img src=\"images/$site_logo\" border=\"0\" alt=\"\"><br><br>"
	."<font class=\"content\"> ";

	// get information about Acteur
	$result = $db->sql_query("select actid, nom_acteur, adresse_acteur, ville_acteur, codepostal_acteur, sigle_acteur, telephone_acteur, fax_acteur, email_acteur, web_acteur, nom_president_acteur, nom_directeur_acteur, status_acteur, mission_acteur, carte_acteur  from ".$prefix."_annuaireacteur_acteur where actid='$actid'");
	if (!$result) {
		print_r ( $db->sql_error () );
		die('Invalid query');
	}
	// get information about Competences
	$result2 = $db->sql_query("select domaine from ".$prefix."_annuaireacteur_domaine where acteur_actid='$actid'");
	if (!$result2) {
		print_r ( $db->sql_error () );
		die('Invalid query');
	}
	// get Information about Activities
	$result3 = $db->sql_query("select activite from ".$prefix."_annuaireacteur_activite where acteur_actid='$actid'");
	if (!$result3) {
		print_r ( $db->sql_error () );
		die('Invalid query');
	}

	// get Contacts
	$result4 = $db->sql_query("select nom_contact, prenom_contact, telephone_contact, telephone_mobile_contact, fax_contact, email_contact, web_contact, titre_contact, domaine_contact, role_contact from ".$prefix."_annuaireacteur_contact where acteur_actid='$actid' order by position_contact ");
	if (!$result4) {
		print_r ( $db->sql_error () );
		die('Invalid query');
	}
	list($actid, $nom_acteur, $adresse_acteur, $ville_acteur, $codepostal_acteur, $sigle_acteur, $telephone_acteur, $fax_acteur, $email_acteur, $web_acteur, $nom_president_acteur, $nom_directeur_acteur, $status_acteur, $mission_acteur, $carte_acteur)= $db->sql_fetchrow($result);
	// get type
	$myresult = $db->sql_query("select statusname from ".$prefix."_annuaireacteur_liste_status where statusid='$status_acteur'");
	list($statusname) = $db->sql_fetchrow($myresult);
	// Titre
	$printPage.= "<center><FONT class=annuaireTitle>".$nom_acteur."</FONT></center>";
	$printPage.= "<div align=center>$sigle_acteur</div>";
	// Carte & info
	if ($carte_acteur=="") { $carte_acteur="images/annuaire_acteur/carte_corse_ba.jpg"; }
	$printPage.= "<center><br><table width=\"90%\"><tr>"
	."<td height=\"1\" colspan=\"3\" bgcolor=\"#FF0000\"><strong><img src=\"themes/Oec/images/pixel.jpg\" width=\"1\" height=\"1\"></strong></tr>"
	."<tr>"
	."<td align=center valign=center>LOCALISATION<br><img src=\"$carte_acteur\" border=0><td>"
	."<td valign=top>"
	."<br><br><table>"
	."<tr><td class=annuaireAttr>"._STATUS_ACTEUR.": </td><td align=left>$statusname</td></tr>"
	."<tr><td class=annuaireAttr>"._ADRESSE_ACTEUR.": </td><td align=left>$adresse_acteur $codepostal_acteur $ville_acteur</td></tr>"
	."<tr><td class=annuaireAttr>"._TELEPHONE_ACTEUR.": </td><td align=left>$telephone_acteur</td></tr>"
	."<tr><td class=annuaireAttr>"._FAX_ACTEUR.": </td><td align=left>$fax_acteur</td></tr>"
	."<tr><td class=annuaireAttr>"._EMAIL_ACTEUR.": </td><td align=left>$email_acteur</td></tr>"
	."<tr><td class=annuaireAttr>"._WEB_ACTEUR.": </td><td align=left>$web_acteur</td></tr>"
	."<tr><td><br><br></td><td></td></tr>"
	."<tr><td><u><B>"._RESPONSABLE."</B></u></td><td align=left></td></tr>"
	."<tr><td class=annuaireAttr>"._PRESIDENT_ACTEUR.":</td><td align=left>$nom_president_acteur</td></tr>"
	."<tr><td class=annuaireAttr>"._DIRECTEUR_ACTEUR.":</td><td align=left>$nom_directeur_acteur</td></tr>"
	."</table></td>"
	."</tr></table></center>";
	// mission

	$printPage.= "<br><center><table width=\"90%\"><tr>"
	."<td align=center class=annuaireFormTitle> "._MISSION." <td>"
	."</tr>"
	."<tr>"
	."<td>$mission_acteur</td>"
	."</tr></table></center>";
	// Domaine et Activite
	$printPage.= "<br><center><table width=\"90%\"><tr>"
	."<td align=center class=annuaireFormTitle>"._DOMAINE_ACTEUR."</td>"
	."<td align=center class=annuaireFormTitle>"._ACTIVITE_ACTEUR."</td>"
	."</tr>"
	."<tr>"
	."<td><UL>";
	while(list($domaine) = $db->sql_fetchrow($result2)) {
		$printPage.= "<LI> $domaine";
	}
	$printPage.= "</UL></td>"
	."<td><UL>";
	while(list($activite) = $db->sql_fetchrow($result3)) {
		$printPage.= "<LI> $activite";
	}
	$printPage.= "</UL></td>"
	."</tr></table></center>";
	// Contact
	$printPage.= "<br><center><table width=\"90%\"><tr>"
	."<td align=center class=annuaireFormTitle>"._CONTACT."<td>"
	."</tr>"
	."<tr>"
	."<td><table>";
	while(list($nom_contact, $prenom_contact, $telephone_contact, $telephone_mobile_contact, $fax_contact, $email_contact, $web_contact, $titre_contact, $domaine_contact, $role_contact) = $db->sql_fetchrow($result4)) {
		$TelephoneDisplay = "";
		$MailDisplay = "";
		if (trim($telephone_contact)!="")$TelephoneDisplay="<img src=\"images/annuaire_acteur/attribut/icone_telephonenumber.gif\" border=0> $telephone_contact";
		if (trim($email_contact)!="")$MailDisplay="<img src=\"images/annuaire_acteur/attribut/icone_mail.gif\" border=0> $email_contact";
		$printPage.= "<tr><td colspan=3><b>$nom_contact $prenon_contact</b> </td>"
		."<tr><td style=\" border-bottom: thin dotted darkorange \" width=\"30%\">$domaine_contact</td><td style=\" border-bottom: thin dotted darkorange \" width=\"35%\">$TelephoneDisplay</td><td style=\" border-bottom: thin dotted darkorange \" width=\"35%\">$MailDisplay</td></tr></UL>";
	}
	$printPage.= "</table></td>"
	."</tr></table></center>";

	$printPage.= " <br><center>
    <font class=\"annuairePrintFooter\">
    "._COMESFROM." $sitename :::
	<a href=\"$nukeurl\">$nukeurl</a><br><br>
	</font></center>
	</td></tr></table>
	</body>
	</html>
    ";
	if ($ok) {
		echo $printPage;
	}else{
		return $printPage;
	}
}
/**
 * exportActeurAsPdf()
 * export Acteur page as a pdf document
 * @param acid :acteur id
 * @return
 * @see
 */
function exportActeurAsPdf($acid) {
	//require('modules/Annuaire_Acteurs/html2pdf.php');
	$myhtmlPage=printActeurPage($actid,0);

	if (isset($myhtmlPage))
	{
		$pdf = new createPDF(
		$myhtmlPage,   // html  convertir
		$mytitle,  // titre de l'article
		$myurl,    // URL de l'article
		$author, // nom de l'auteur
		time()
		);
		$pdf->run();
	}
}
/**
 * displayAlphabet()
 *
 * @param datatype paramname description
 * @return datatype description
 */
function displayAlphabet($thelink,$lettreencours="A"){
	global $db,$prefix;
	$acteurLink=$thelink."&myfilter=";
	//$lettres = array("A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z");
	$lettres = array();
	$result = $db->sql_query("SELECT DISTINCT SUBSTRING(".$prefix."_annuaireacteur_acteur.nom_acteur,1,1) as initiale FROM ".$prefix."_annuaireacteur_acteur order by initiale");
	if ($db->sql_numrows($result)) {
		while($initiale = $db->sql_fetchrow($result)) {
			$lettres[] = $initiale[0];
		}
	}
	
	$alpha = "<div class=\"pages\">";
	foreach($lettres as $lettre) {
		if ($lettreencours == $lettre) {
			$alpha .= "<div class=\"pagevide\">".$lettre."</div>";
		}
		else {
			$alpha .= "<div class=\"page\"><a href=\"".$acteurLink.$lettre."\">".$lettre."</a></div>";
		}
	}
	$alpha .= "</div>";
	return $alpha;
}

/*--------------------------------------*/
/*           start Switch				*/
/*--------------------------------------*/
$index = 1;
switch($sop) {

	case "displayAccess":
		displayAccess();
		break;

	case "listActeur":
		listActeur($typid, $domid, $country ,$sortBy);
		break;

	case "listOrganismType":
		listOrganismType();
		break;

	case "listCompetence":
		listCompetence();
		break;

	case "viewActeur":
		viewActeur($actid);
		break;

	case "printActeurPage":
		printActeurPage($actid);
		break;

	case "listActeurByChar":
		listActeurByChar($myfilter);
		break;

	case "listActeurArbo" :
		listActeurArbo($domid);
		break;

	case "exportActeurAsPdf":
		exportActeurAsPdf($actid);
		break;

	default:
		listActeurByChar($myfilter);
		break;
}

?>