<?php
/* ----------------------------------------------------------------
Script coming with JonDesign's SmoothGallery (http://smoothgallery.jondesign.net).

It is an adapted version of
http://sneak.co.nz/2006/10/27/dynamic-image-resizing/
which is itself an improvement of the original script from
Timothy Crowe's 'veryraw' website, with caching additions added by Trent Davies:
http://veryraw.com/history/2005/03/image-resizing-with-php/

Thanks to:
Tim Novinger for finding the image extension problem (fixed by an strtolower())
---------------------------------------------------------------- */

if(!function_exists("imageantialias")){
	function imageantialias($ressource, $bool){
	}
}

$path = '../../';
set_include_path(get_include_path() . PATH_SEPARATOR . $path);
require_once("core/becms_mainlib_lib.php");
if ($gallerywithwatermak == "1" && isset($idpict)) {
	$idpict = rawurldecode($idpict);
    $plaintexte = str_dechiffrer($idpict);
    eval($plaintexte);
    $_GET["imgfile"] = $imgfile;
    $_GET["max_width"] = $max_width;
    $_GET["max_height"] = $max_height;
}
$max_height = 1000;
$max_width = 2000;
if (isset($_GET["imgfile"]))
{
	$image = $_GET["imgfile"];
	if (isset($_GET["max_width"])) { if($_GET["max_width"] < 2000) $max_width = $_GET["max_width"]; }
	if (isset($_GET["max_height"])) { if($_GET["max_height"] < 2000) $max_height = $_GET["max_height"]; }
	
	if (strrchr($image, '/')) {
		$filename = substr(strrchr($image, '/'), 1); // remove folder references
	} else {
		$filename = $image;
	}
	
	$size = getimagesize($image);
	$width = $size[0];
	$height = $size[1];
	
	// get the ratio needed
	$x_ratio = $max_width / $width;
	$y_ratio = $max_height / $height;
	$ratio = max($x_ratio,$y_ratio);
	
	$tn_width = ceil($ratio * $width);
	$tn_height = ceil($ratio * $height);
	
	$delta_x = floor(($max_width - $tn_width)/2);
	$delta_y = floor(($max_height - $tn_height)/2);
	
	// read image
	$ext = strtolower(substr(strrchr($image, '.'), 1)); // get the file extension
	switch ($ext) {
		case 'jpeg': 
		case 'jpg':     // jpg
			$src = imagecreatefromjpeg($image) or notfound();
			break;
		case 'png':     // png
			$src = imagecreatefrompng($image) or notfound();
			break;
		case 'gif':     // gif
			$src = imagecreatefromgif($image) or notfound();
			break;
		default:
			notfound();
	}
	
	// set up canvas
	$dst = imagecreatetruecolor($max_width,$max_height);
	if ($ext == "jpg" || $ext == "jpeg") {
		imageantialias ($dst, true);
		imagecopyresampled($dst,$src,$delta_x,$delta_y,0,0,$tn_width, $tn_height, $width, $height);
		header("Content-type: image/jpeg");
		imagejpeg($dst, null, 90);
	}
	if ($ext == "gif") {
		imagealphablending($dst, false);
		imageantialias ($dst, true);
		$transindex = imagecolortransparent($src);
		if($transindex >= 0) {
		  $transcol = imagecolorsforindex($src, $transindex);
		  $transindex = imagecolorallocatealpha($dst, $transcol['red'], $transcol['green'], $transcol['blue'], 127);
		  imagefill($dst, 0, 0, $transindex);
		}
		imagecopyresampled($dst,$src,$delta_x,$delta_y,0,0,$tn_width, $tn_height, $width, $height);
		if($transindex >= 0) {
		  imagecolortransparent($dst, $transindex);
		  for($y=0; $y<$tn_height; ++$y)
		    for($x=0; $x<$tn_width; ++$x)
		      if(((imagecolorat($dst, $x, $y)>>24) & 0x7F) >= 100) imagesetpixel($dst, $x, $y, $transindex);
		}
		imagetruecolortopalette($dst, true, 255);
		imagesavealpha($dst, false);
		
		imageinterlace($dst);
		header("Content-type: image/gif");
		imagegif($dst);
		//imagegif($dst, $resized); //le chache est dsactiv
	}
	if ($ext == "png") {
		imageantialias ($dst, true);
		imagealphablending($dst, false);
		imagecopyresampled($dst,$src,$delta_x,$delta_y,0,0,$tn_width, $tn_height, $width, $height);
		imagesavealpha($dst, true);
		header("Content-type: image/png");
		imagepng($dst);
		//imagepng($dst,$resized); //le chache est dsactiv
	}
	// clear out the resources
	imagedestroy($src);
	imagedestroy($dst);
}
?>