<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="/">
		<html>
			<head>
				<title>Menu</title>
				<style type="text/css" media="all">
					body { background-color: #dfdfdf; }
	
					h1 {
						font: bold 14px/16px Verdana, Arial, Helvetica,Geneva, sans-serif;
						background-color: #717171;
						padding: 2px 0 3px 2px; 
						margin: 0;
						color: #fff;
					}
					
					ul {
						margin-top: 3px;
						margin-bottom: 0px;
						padding-right: 10px;
						margin-left: 20px;
						padding-left: 0;
					}
					
					ul li {
						color: #717171;
						font-size: 14px;
						font-family: Arial, Verdana, Helvetica, sans-serif;
						font-weight: normal;
						line-height: 18px;
						margin-bottom: 4px;
					}

					table {
						margin: 0;
						padding: 0;
						border-collapse: collapse;
						border: 1px solid #717171;
					}
		
					table td {
						margin: 0;
						padding: 0;
						background-color: #fff;
					}
					
					a {
						color: #717171;
						text-decoration: none;
					}
					
					a:hover {
						color: #717171;
						text-decoration: underline;
					}
					
					li.encours>a {
						font-weight: bold;
					}
				</style>
			</head>
			<body>
				<table border="0" cellpadding="0" cellspacing="0"><tr><td>
				<h1>
					<xsl:value-of select="menu/titre" />
				</h1>
				<xsl:for-each select="menu">
					<xsl:apply-templates />
				</xsl:for-each>
				</td></tr></table>
			</body>
		</html>


	</xsl:template>
	<xsl:template match="*"></xsl:template>



	<xsl:template match="lignes">
		<ul>
			<xsl:apply-templates />
		</ul>
	</xsl:template>

	<xsl:template match="ligne">
		<xsl:element name="li">
			<xsl:choose>
				<xsl:when test="@current='true'">
					<xsl:attribute name="class">
						<!-- <xsl:value-of select="@current"/> -->
						encours
					</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
				</xsl:otherwise>
			</xsl:choose>
			<a href="{pageLink}" target="{target}">
				<xsl:value-of select="intitule" />
			</a>
			<xsl:apply-templates />
		</xsl:element>
	</xsl:template>

</xsl:stylesheet>