<?php
/**
* Classes de menus pour affichage dans les thmes.
* 
* @package becmsDynMenu
* @version 1.2
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2006, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
* @todo vrifier la non excution sur URL = #
* @todo parler du lancement du script javascript pour les survols de menu et voir comment a marche
* @todo prvisualisation du menu dfectueux avec les survols sous IE
*/

if (preg_match("#becms_menu_class.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

/**
* Retourne le type du menu dsign
* 
* 1 : Hierarchique
* 2 : Droulant Horizontal (OEC,OCIC)
* 3 : Droulant Vertical
* 4 : Arborescent
* 5 : Indisponible
* 6 : Colonne droule fixe verticale
* 7 : Colonne droulante verticale
* 8 : Colonne droulante verticale unique (Zonza)
* 9 : Droulant Vertical Unique (Corbara,Demo)
* @param array $Myqsl Paramtres de la base de donnes
* @param integer $Id Identifiant du menu
* @return integer Type de menu
*/
function genreMenu($Myqsl,$Id) {
	$famille = getFamilies($Myqsl,$Id);
	if (count($famille) != 0) {
		return $famille[0]["genre"];
	}
	else {
		return "";
	}
}
/**
* Classe d'affichage de menu hirarchique
* 
* Ce menu est fourni sous forme de tableau. Les lment du menu sont affichs en colonne. Les niveaux hierarchiques sont indiqus par indentation.
* Par dfaut, seul le niveau 1 est affich. Un clic sur une ligne affiche la page correspondante ou affiche le niveau hierachique suivant.
* Seuls les lments correspondants  l'lment cliqu sont dploys.
* @package becmsDynMenu
*/
class menuHierarchique	{
/**
* @var integer Identifiant du menu en cours. Vaut 1 par dfaut.
*/	
	var $IdMenu;
/**
* Initialise l'identifiant du menu par dfaut  1
*/	
	function menuHierarchique() {
		$this->IdMenu = "1";
	} 
/**
* Fixe la valeur de l'identifiant du menu
* @param integer $num Identifiant du menu  afficher
*/	
	function initMenu($num) {
		$this->IdMenu = $num;
	}
/**
* Retourne le menu encod en  HTML
* 
* L'apparence du menu est fixe dans un fichier CSS (MxT1, avec x = IdMenu)
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Chaine contenant le code HTML du menu
*/
	function MakeTree($Myqsl,$modmenu,$icns){
		
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		
		if ($this->IdMenu != $menu) {
			$menu = $this->IdMenu;
			$Page=0;
		}
		//open_db($Myqsl);
		$sortie = getArrayMenu($Myqsl,$menu);
		$famille = getFamilies($Myqsl,$menu);
		//close_db($Myqsl);
		$table = $sortie["table"];
		$partable = $sortie["partable"];
		$Folder = $sortie["Folder"];
	
		$levels=$this->TreeLevels(0,$table,0);
		if(!isset($Folder[$Page]["Name"])) {
			$Folder[$Page]["Name"]="Racine menu";
		}
		$Name=$Folder[$Page]["Name"];
		
		if ($Page == 0) {
			if(!isset($_SESSION["expandtree"])) {
				$_SESSION["expandtree"]=1;
			}
			$levelexpand=1;
			$results = $this->racinemenuouvert($famille,$modmenu,$icns);
			$results .= $this->TreeExpand(0,$table,$partable,$Folder,$Page,0,$levelexpand,$modmenu,$icns);
		}
		else {
			$results=$this->racinemenuferme($famille,$modmenu,$icns);
			$ID=$Page;
			$results.=$this->TreeNodes($ID,$table,$partable,$Folder,$Page,$levels,$modmenu,$icns);
			$_SESSION["expandtree"]=1;
		}
		
		$results = '<table border="0" cellspacing="0" cellpadding="0" class="menu'.$menu .'">'.$results.'</table>';
		return $results;
	}
/**
* Fonction interne de dcodage du menu
*/
	function  TreeLevels($Parent,$table,$level){
		$_SESSION["levels"][$Parent]=$level;
		if (count($table) != 0) {
			while(list($key,$val)=each($table[$Parent])) {
				if (isset($table[$key])) {
					$this->TreeLevels($key,$table,$level+1);
				}
			}
		}
		return $_SESSION["levels"];
	}
/**
* Fonction interne de dcodage du menu
*/
	function TreeNodes($ID,$table,$partable,$Folder0,$Page,$levels,$modmenu,$icns) {
		$rez0="";
		if(isset($table[$ID])) {
			$lisd=$table[$ID];
			$ID0=$ID;
			$fiplevel=$levels[$ID];
			while(list($key,$val)=each($lisd)){
				if($Page==$key)	{
					$rez0.= $this->textemenuouvert($levels[$ID]+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
				}
				else {
					$rez0 .= $this->textemenuferme($levels[$ID]+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
				}
			}
		}
		$res="";
		while ($ID!=0) {
			$fip=$partable[$ID];
			$fiplevel=$levels[$fip];
			$fiplist=$table[$fip];
			$rez="";
			while(list($key,$val)=each($fiplist)){
				if($Page==$key){
					$rez.= $this->textemenuouvert($fiplevel+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
					$rez .= $rez0;
				}
				else {
					$rez.= $this->textemenuferme($fiplevel+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
				}
				if($ID==$key) {
					$rez.=$res;
					$res="";
				}
			}
			$res.=$rez;
			$ID=$partable[$ID];
		}
		return $rez;
	}
/**
* Fonction interne de dcodage du menu
*/
	function TreeExpand($Parent,$table,$partable,$Folder0,$Page,$level,$levelexpand,$modmenu,$icns){
		$result='';
		if (count($partable) != 0) {
			$list=$table[$Parent];
			while(list($key,$val)=each($list)){
				if($level<$levelexpand) {
					$result.= $this->textemenuferme($level+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
				}
				if (isset($table[$key])) {
					$result.=$this->TreeExpand($key,$table,$partable,$Folder0,$Page,$level+1,$levelexpand,$modmenu,$icns);
				}
			}
		}
		return $result;
	}
/**
* Retourne une image dont la dimension correspond au dcalage du niveau de la ligne du menu
* @param integer $niveau Niveau du menu  afficher
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image de calage
*/
	function decalage($niveau,$icns) {
		$width = ($niveau - 1) * 10;
		$lacale = "<img src='".$icns["menuindent"]."' width='".$width."' height='1'>";
		return $lacale;
	}
/**
* Retourne l'icne de la ligne de menu sur lequel l'utilisateur vient de cliquer
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image symbolisant un menu ouvert
*/
	function menuouvert($icns) {
		return "<img src='".$icns["menuselected"]."' alt='' width='20' height='20' align='absmiddle'>";
	}
/**
* Retourne l'icne par dfaut des lignes de menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image symbolisant un menu ferm
*/
	function menuferme($icns) {
		return "<img src='".$icns["menunotselected"]."' alt='' width='20' height='20' align='absmiddle'>";
	}
/**
* Retourne l'ensemble des variables transmises dans URL sauf celles dsignes dans $sauf
* @param string $sauf Liste des variables  ne pas renvoyer. Le sparateur est "|"
* @return string Toutes les variables mises en forme pour usage dans un URL
*/
	function getVars($sauf) {
		//global $_GET;
		
		$elimines = explode("|",$sauf);
		$args = "";
		$elts = $_GET;
		
		while(list($key, $val) = each($elts)) {
			$ok = true;
			foreach ($elimines as $elimine) {
				if ($elimine == $key) {
					$ok = false;
				}
			}
			if ($ok) {
				if ($args != "") {
					$args .= "&";
				}
				$args .= $key."=".stripslashes($val);
			}
		}
		
	 	return $args;
	}
/**
* Retourne la ligne du menu slectionn
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans un tableau HTML
*/
	function textemenuouvert($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$modmenu,$icns) {	
		if ($nom != "-") {
			if (!$nomenu) {
				$sauf = "";
				$variablessauf = "";
				$urlseul = "";
				if ($url != "") {
					list($urlseul,$args) = explode("?",$url);
					if ($args != "") {
						$argsT = explode("&",$args);
						foreach ($argsT as $temp) {
							list($key,$val) = explode("=",$temp);
							$sauf .= $key."|";
							$variablessauf .= $key."=".$val."&";
						}
					}
				}
				$sauf .= $modmenu["Menu"];
				$variablessauf = "?".$variablessauf.$modmenu["Menu"]."=".$idmenu.",".$noeud;
				
				$variables = $this->getVars($sauf);
				if ($variables != "") {
					$variables = "&".$variables;
				}
				$variables = $variablessauf.$variables;
				$url = $urlseul.$variables;
			}
			$sortie = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td nowrap>";
			$sortie .= $this->decalage($niveau,$icns);
			$sortie .= $this->menuouvert($icns);
			$sortie .= "</td><td>";
			$sortie .= "<a href=\"".$url."\"";
			if ($target != "") {
				$sortie .= " target='".$target."'";
			}
			$sortie .= "><b>".$nom."</b></a>";
			$sortie .= "</td></tr></table>";
			$sortie = "<tr><td>".$sortie."</td></tr>";
		}
		else {
			$sortie = "<tr><td class=\"sep\"></td></tr>";
		}
		return $sortie;
	}
/**
* Retourne la ligne d'un menu non slectionn
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans un tableau HTML
*/
	function textemenuferme($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$modmenu,$icns) {
		if ($nom != "-") {
			if (!$nomenu) {
				$trouve = false;
				if (substr_count($url,"?") == 0) {
					$variables = "?";
				}
				else {
					$variables = "&";
				}
				if ($url != "") {
					list($urlseul,$args) = explode("?",$url);
					if ($args != "") {
						$argsT = explode("&",$args);
						foreach ($argsT as $temp) {
							list($key,$val) = explode("=",$temp);
							if ($key==$modmenu["Menu"]) {
								$trouve = true;
							}
						}
					}
				}
				if (!$trouve) {
					$variables .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
				}
				if ($variables == "&" || $variables == "?") {
					$variables = "";
				}
			}
			else {
				$variables = "";
			}
			$sortie = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td nowrap>";
			$sortie .= $this->decalage($niveau,$icns);
			$sortie .= $this->menuferme($icns);
			$sortie .= "</td><td>";
			$sortie .= "<a href=\"".$url.$variables."\"";
			if ($target != "") {
				$sortie .= " target='".$target."'";
			}
			$sortie .= ">".$nom."</a>";
			$sortie .= "</td></tr></table>";
			$sortie = "<tr><td>".$sortie."</td></tr>";
		}
		else {
			$sortie = "<tr><td class=\"sep\"></td></tr>";
		}
		return $sortie;
	}
/**
* Retourne la racine du menu slectionn
* @param array $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans un tableau HTML
*/
	function racinemenuouvert($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		$sortie = "<tr><td>".$FIntitule."</td></tr>";
		
		return $sortie;
	}
/**
* Retourne la racine du menu non slectionn
* @param array $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans un tableau HTML
*/
	function racinemenuferme($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		$sortie = "<tr><td>".$FIntitule."</td></tr>";
		
		return $sortie;
	}
}

/**
* Classe d'affichage de menu deroulant horizontal
* 
* Ce menu est fourni sous forme de liste UL. Les lment de niveau 1 sont affichs en ligne. Les niveaux hierarchiques suprieurs sont affichs au survol des lments de niveau infrieur.
* Seuls les lments correspondants  l'lment survol sont dploys.
* @package becmsDynMenu
*/
class menuDeroulantH {
/**
* @var integer Identifiant du menu en cours. Vaut 1 par dfaut.
*/	
	var $IdMenu;
/**
* Initialise l'identifiant du menu par dfaut  1
*/	
	function menuDeroulantH() {
		$this->IdMenu = "1";
	}
/**
* Fixe la valeur de l'identifiant du menu
* @param integer $num Identifiant du menu  afficher
*/
	function initMenu($num) {
		$this->IdMenu = $num;
	}
/**
* Retourne le menu encod en  HTML
* 
* L'apparence du menu est fixe dans un fichier CSS (MxT2, avec x = IdMenu)
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Chaine contenant le code HTML du menu
*/	
	function MakeTree($Myqsl,$modmenu,$icns){
		
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		
		if ($this->IdMenu != $menu) {
			$menu = $this->IdMenu;
			$Page=0;
		}
		//open_db($Myqsl);
		
		$sortie = getArrayMenu($Myqsl,$menu);
		$table = $sortie["table"];
		$partable = $sortie["partable"];
		$Folder = $sortie["Folder"];
	
		$levels=$this->TreeLevels(0,$table,0);
		if(!isset($Folder[$Page]["Name"])) {
			$Folder[$Page]["Name"]="Racine menu";
		}
		$Name=$Folder[$Page]["Name"];
		$results = $this->racinemenuouvert($modmenu,$icns);
		$levelexpand=100000;
		$results.= "<ul id=\"menu".$menu."\">";
		$results .= $this->TreeExpand(0,$table,$partable,$Folder,$Page,0,$levelexpand,$Myqsl,$modmenu,$icns);
		$results.= "</ul>";
		//close_db($Myqsl);
		
		return $results;
	}
/**
* Fonction interne de dcodage du menu
*/	
	function  TreeLevels($Parent,$table,$level){
		$_SESSION["levels"][$Parent]=$level;
		if (count($table) != 0) {
			while(list($key,$val)=each($table[$Parent])) {
				if (isset($table[$key])) {
					$this->TreeLevels($key,$table,$level+1);
				}
			}
		}
		return $_SESSION["levels"];
	}
/**
* Fonction interne de dcodage du menu
*/	
	function TreeExpand($Parent,$table,$partable,$Folder0,$Page,$level,$levelexpand,$Myqsl,$modmenu,$icns){
		$result='';
		if (count($partable) != 0) {
			$list=$table[$Parent];
			while(list($key,$val)=each($list)){
				if($level<$levelexpand) {
					$result.= "<li>";
					$result.= $this->textemenuferme($level+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$Myqsl,$modmenu,$icns);
				}
				if (isset($table[$key])) {
					$result.= "<ul>";
					$result.=$this->TreeExpand($key,$table,$partable,$Folder0,$Page,$level+1,$levelexpand,$Myqsl,$modmenu,$icns);
					$result.= "</ul>";
				}
				$result.= "</li>";
			}
		}
		return $result;
	}
/**
* Retourne une image dont la dimension correspond au dcalage du niveau de la ligne du menu
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion d'indentation.
* @param integer $niveau Niveau du menu  afficher
* @return string Image de calage
*/
	function decalage($niveau) {
		$width = ($niveau - 1) * 10;
		$lacale = "<img src='tr.gif' width='".$width."' height='1'>";
		return $lacale;
	}
/**
* Retourne l'icne de la ligne de menu sur lequel l'utilisateur vient de cliquer
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion de menu ouvert ou ferm.
* @return string Image symbolisant un menu ouvert
*/
	function menuouvert() {
		//return "<img src='folderopen.gif' alt='' width='20' height='20' align='absmiddle'>&nbsp;";
		return "";
	}
/**
* Retourne l'icne par dfaut des lignes de menu
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion de menu ouvert ou ferm.* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image symbolisant un menu ferm
*/
	function menuferme() {
		//return "<img src='folder.gif' alt='' width='20' height='20' align='absmiddle'>&nbsp;";
		return "";
	}
/**
* Retourne l'ensemble des variables transmises dans URL sauf celles dsignes dans $sauf
* @param string $sauf Liste des variables  ne pas renvoyer. Le sparateur est "|"
* @return string Toutes les variables mises en forme pour usage dans un URL
*/
	function getVars($sauf) {
		//global $_GET;
		
		$elimines = explode("|",$sauf);
		$args = "";
		$elts = $_GET;
		
		while(list($key, $val) = each($elts)) {
			$ok = true;
			foreach ($elimines as $elimine) {
				if ($elimine == $key) {
					$ok = false;
				}
			}
			if ($ok) {
				if ($args != "") {
					$args .= "&";
				}
				$args .= $key."=".stripslashes($val);
			}
		}
		
	 	return $args;
	}
/**
* Retourne une ligne de menu
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $position position de la ligne de menu en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans une liste HTML
*/
	function textemenuferme($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$Myqsl,$modmenu,$icns) {
		if ($nom != "-") {
			if (preg_match("/^#/",$url)) {
				$variables = "";
				$ancre = "";
			}
			else {
				if (!$nomenu) {
					list($url,$ancre) = explode("#",$url);
					if ($ancre != "") {
						$ancre = "#".$ancre;
					}
					global $withrewriting;
					if ($withrewriting  && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$url)) {
						if (!preg_match("#_([0-9])+,([0-9])+.htm#i",$url)) {
							$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$url);
						}
						$variables = "";
					}
					else {
						$trouve = false;
						if (substr_count($url,"?") == 0) {
							$variables = "?";
						}
						else {
							$variables = "&";
						}
						if ($url != "") {
							list($urlseul,$args) = explode("?",$url);
							if ($args != "") {
								$argsT = explode("&",$args);
								foreach ($argsT as $temp) {
									list($key,$val) = explode("=",$temp);
									if ($key==$modmenu["Menu"]) {
										$trouve = true;
									}
								}
							}
						}
						if (!$trouve) {
							$variables .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
						}
						if ($variables == "&" || $variables == "?") {
							$variables = "";
						}
					}
				}
				else {
					$variables = "";
				}
			}
			
			//$sortie = decalage($niveau);
			$sortie = $this->menuferme();
			$sortie .= "<a href=\"".$url.$variables.$ancre."\"";
			if (subMenu($Myqsl,$noeud,$idmenu)) {
				$sortie .= "class=\"next\"";
			}
			if ($target != "") {
				$sortie .= " target='".$target."'";
			}
			$nom = preg_replace("/(.*)(\\\\n)(.*)/i","\\1<div class=\"l2\">\\3</div>", $nom);
			$sortie .= "><span>".$nom."</span></a>";
		}
		else {
			$sortie = "<hr />";
		}
		return $sortie;
	}
/**
* Retourne la racine du menu slectionn
* 
* Pour ce menu, le retour est vide.
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans un tableau HTML
*/
	function racinemenuouvert($modmenu,$icns) {
		$sortie = "";
		
		return $sortie;
	}
/**
* Retourne la racine du menu non slectionn
* 
* Pour ce menu, le retour est vide.
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans un tableau HTML
*/
	function racinemenuferme($modmenu,$icns) {
		$sortie = "";
		
		return $sortie;
	}
}

/**
* Classe d'affichage de menu deroulant vertical
* 
* Ce menu est fourni sous forme de liste UL. Les lment de niveau 1 sont affichs en colonne. Les niveaux hierarchiques suprieurs sont affichs au survol des lments de niveau infrieur.
* Seuls les lments correspondants  l'lment survol sont dploys.
* @package becmsDynMenu
*/
class menuDeroulantV {
/**
* @var integer Identifiant du menu en cours. Vaut 1 par dfaut.
*/		
	var $IdMenu;
/**
* Initialise l'identifiant du menu par dfaut  1
*/		
	function menuDeroulantV() {
		$this->IdMenu = "1";
	}
/**
* Fixe la valeur de l'identifiant du menu
* @param integer $num Identifiant du menu  afficher
*/		
	function initMenu($num) {
		$this->IdMenu = $num;
	}
/**
* Retourne le menu encod en  HTML
* 
* L'apparence du menu est fixe dans un fichier CSS (MxT3, avec x = IdMenu)
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Chaine contenant le code HTML du menu
*/		
	function MakeTree($Myqsl,$modmenu,$icns){
		
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		
		if ($this->IdMenu != $menu) {
			$menu = $this->IdMenu;
			$Page=0;
		}
		//open_db($Myqsl);
		
		$sortie = getArrayMenu($Myqsl,$menu);
		$table = $sortie["table"];
		$partable = $sortie["partable"];
		$Folder = $sortie["Folder"];
	
		$levels=$this->TreeLevels(0,$table,0);
		if(!isset($Folder[$Page]["Name"])) {
			$Folder[$Page]["Name"]="Racine menu";
		}
		$Name=$Folder[$Page]["Name"];
		$results = $this->racinemenuouvert($modmenu,$icns);
		$levelexpand=100000;
		$results.= "<ul id=\"menu".$menu."\">";
		$results .= $this->TreeExpand(0,$table,$partable,$Folder,$Page,0,$levelexpand,$Myqsl,$modmenu,$icns);
		$results.= "</ul>";
		//close_db($Myqsl);
		
		return $results;
	}
/**
* Fonction interne de dcodage du menu
*/		
	function  TreeLevels($Parent,$table,$level){
		$_SESSION["levels"][$Parent]=$level;
		if (count($table) != 0) {
			while(list($key,$val)=each($table[$Parent])) {
				if (isset($table[$key])) {
					$this->TreeLevels($key,$table,$level+1);
				}
			}
		}
		return $_SESSION["levels"];
	}
/**
* Fonction interne de dcodage du menu
*/		
	function TreeExpand($Parent,$table,$partable,$Folder0,$Page,$level,$levelexpand,$Myqsl,$modmenu,$icns){
		$result='';
		if (count($partable) != 0) {
			$list=$table[$Parent];
			while(list($key,$val)=each($list)){
				if($level<$levelexpand) {
					$result.= "<li>";
					$result.= $this->textemenuferme($level+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$Myqsl,$modmenu,$icns);
				}
				if (isset($table[$key])) {
					$result.= "<ul>";
					$result.=$this->TreeExpand($key,$table,$partable,$Folder0,$Page,$level+1,$levelexpand,$Myqsl,$modmenu,$icns);
					$result.= "</ul>";
				}
				$result.= "</li>";
			}
		}
		return $result;
	}
/**
* Retourne une image dont la dimension correspond au dcalage du niveau de la ligne du menu
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion d'indentation.
* @param integer $niveau Niveau du menu  afficher
* @return string Image de calage
*/
	function decalage($niveau) {
		$width = ($niveau - 1) * 10;
		$lacale = "<img src='tr.gif' width='".$width."' height='1'>";
		return $lacale;
	}
/**
* Retourne l'icne de la ligne de menu sur lequel l'utilisateur vient de cliquer
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion de menu ouvert ou ferm.* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image symbolisant un menu ouvert
*/
	function menuouvert() {
		//return "<img src='folderopen.gif' alt='' width='20' height='20' align='absmiddle'>&nbsp;";
		return "";
	}
/**
* Retourne l'icne par dfaut des lignes de menu
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion de menu ouvert ou ferm.* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image symbolisant un menu ferm
*/
	function menuferme() {
		//return "<img src='folder.gif' alt='' width='20' height='20' align='absmiddle'>&nbsp;";
		return "";
	}
/**
* Retourne l'ensemble des variables transmises dans URL sauf celles dsignes dans $sauf
* @param string $sauf Liste des variables  ne pas renvoyer. Le sparateur est "|"
* @return string Toutes les variables mises en forme pour usage dans un URL
*/
	function getVars($sauf) {
		//global $_GET;
		
		$elimines = explode("|",$sauf);
		$args = "";
		$elts = $_GET;
		
		while(list($key, $val) = each($elts)) {
			$ok = true;
			foreach ($elimines as $elimine) {
				if ($elimine == $key) {
					$ok = false;
				}
			}
			if ($ok) {
				if ($args != "") {
					$args .= "&";
				}
				$args .= $key."=".stripslashes($val);
			}
		}
		
	 	return $args;
	}
/**
* Retourne une ligne de menu
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $position position de la ligne de menu en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans une liste HTML
*/
	function textemenuferme($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$Myqsl,$modmenu,$icns) {
		if ($nom != "-") {
			if (preg_match("/^#/",$url)) {
				$variables = "";
				$ancre = "";
			}
			else {
				if (!$nomenu) {
					list($url,$ancre) = explode("#",$url);
					if ($ancre != "") {
						$ancre = "#".$ancre;
					}
					$trouve = false;
					if (substr_count($url,"?") == 0) {
						$variables = "?";
					}
					else {
						$variables = "&";
					}
					if ($url != "") {
						list($urlseul,$args) = explode("?",$url);
						if ($args != "") {
							$argsT = explode("&",$args);
							foreach ($argsT as $temp) {
								list($key,$val) = explode("=",$temp);
								if ($key==$modmenu["Menu"]) {
									$trouve = true;
								}
							}
						}
					}
					if (!$trouve) {
						$variables .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
					}
					if ($variables == "&" || $variables == "?") {
						$variables = "";
					}
				}
				else {
					$variables = "";
				}
			}
			
			//$sortie = decalage($niveau);
			$sortie = $this->menuferme();
			$sortie .= "<a href=\"".$url.$variables.$ancre."\"";
			if (subMenu($Myqsl,$noeud,$idmenu)) {
				$sortie .= "class=\"next\"";
			}
			if ($target != "") {
				$sortie .= " target='".$target."'";
			}
			$sortie .= "><span><div class=\"marge\">".$nom."</div></span></a>";
		}
		else {
			$sortie = "<hr />";
		}
		return $sortie;
	}
/**
* Retourne la racine du menu slectionn
* 
* Pour ce menu, le retour est vide.
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans un tableau HTML
*/
	function racinemenuouvert($modmenu,$icns) {
		$sortie = "";
		
		return $sortie;
	}
	function racinemenuferme($modmenu,$icns) {
		$sortie = "";
		
		return $sortie;
	}
}

/**
* Classe d'affichage de menu colonne droulante
* 
* Ce menu est fourni sous forme de liste UL. Les lment de niveau 1 sont affichs en colonne. Les niveaux hierarchiques suprieurs sont affichs au clic des lments de niveau infrieur.
* Seuls les lments correspondants  l'lment cliqu sont dploys.
* @package becmsDynMenu
*/
class menuColonneDynamique {
/**
* @var integer Identifiant du menu en cours. Vaut 1 par dfaut.
*/
	var $IdMenu;
/**
* Initialise l'identifiant du menu par dfaut  1
*/		
	function menuColonneDynamique() {
		$this->IdMenu = "1";
	} 
/**
* Fixe la valeur de l'identifiant du menu
* @param integer $num Identifiant du menu  afficher
*/	
	function initMenu($num) {
		$this->IdMenu = $num;
	}
/**
* Retourne le menu encod en  HTML
* 
* L'apparence du menu est fixe dans un fichier CSS (MxT7, avec x = IdMenu)
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Chaine contenant le code HTML du menu
*/	
	function MakeTree($Myqsl,$modmenu,$icns){
		
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		
		if ($this->IdMenu != $menu) {
			$menu = $this->IdMenu;
			$Page=0;
		}
		//open_db($Myqsl);
		$sortie = getArrayMenu($Myqsl,$menu);
		$famille = getFamilies($Myqsl,$menu);
		//close_db($Myqsl);
		$table = $sortie["table"];
		$partable = $sortie["partable"];
		$Folder = $sortie["Folder"];
	
		$levels=$this->TreeLevels(0,$table,0);
		if(!isset($Folder[$Page]["Name"])) {
			$Folder[$Page]["Name"]="Racine menu";
		}
		$Name=$Folder[$Page]["Name"];
		
		if ($Page == 0) {
			if(!isset($_SESSION["expandtree"])) {
				$_SESSION["expandtree"]=1;
			}
			$levelexpand=1;
			$results = $this->racinemenuouvert($famille,$modmenu,$icns);
			$results .= $this->TreeExpand(0,$table,$partable,$Folder,$Page,0,$levelexpand,$modmenu,$icns);
		}
		else {
			$results=$this->racinemenuferme($famille,$modmenu,$icns);
			$ID=$Page;
			$results.=$this->TreeNodes($ID,$table,$partable,$Folder,$Page,$levels,$modmenu,$icns);
			$_SESSION["expandtree"]=1;
		}
		
		//$results = '<ul class="menu'.$menu .'">'.$results.'</ul>';
		$results = '<ul class="menu">'.$results.'</ul>';
		return $results;
	}
/**
* Fonction interne de dcodage du menu
*/
	function  TreeLevels($Parent,$table,$level){
		$_SESSION["levels"][$Parent]=$level;
		if (count($table) != 0) {
			while(list($key,$val)=each($table[$Parent])) {
				if (isset($table[$key])) {
					$this->TreeLevels($key,$table,$level+1);
				}
			}
		}
		return $_SESSION["levels"];
	}
/**
* Fonction interne de dcodage du menu
*/
	function TreeNodes($ID,$table,$partable,$Folder0,$Page,$levels,$modmenu,$icns) {
		$rez0="";
		if(isset($table[$ID])) {
			$lisd=$table[$ID];
			$ID0=$ID;
			$fiplevel=$levels[$ID];
			while(list($key,$val)=each($lisd)){
				if($Page==$key)	{
					$rez0.= $this->textemenuouvert($levels[$ID]+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
				}
				else {
					$rez0 .= $this->textemenuferme($levels[$ID]+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
				}
			}
		}
		$res="";
		while ($ID!=0) {
			$fip=$partable[$ID];
			$fiplevel=$levels[$fip];
			$fiplist=$table[$fip];
			$rez="";
			while(list($key,$val)=each($fiplist)){
				if($Page==$key){
					$rez.= $this->textemenuouvert($fiplevel+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
					$rez .= $rez0;
				}
				else {
					$rez.= $this->textemenuferme($fiplevel+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
				}
				if($ID==$key) {
					$rez.=$res;
					$res="";
				}
			}
			$res.=$rez;
			$ID=$partable[$ID];
		}
		return $rez;
	}
/**
* Fonction interne de dcodage du menu
*/
	function TreeExpand($Parent,$table,$partable,$Folder0,$Page,$level,$levelexpand,$modmenu,$icns){
		$result='';
		if (count($partable) != 0) {
			$list=$table[$Parent];
			while(list($key,$val)=each($list)){
				if($level<$levelexpand) {
					$result.= $this->textemenuferme($level+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
				}
				if (isset($table[$key])) {
					$result.=$this->TreeExpand($key,$table,$partable,$Folder0,$Page,$level+1,$levelexpand,$modmenu,$icns);
				}
			}
		}
		return $result;
	}
/**
* Retourne une image dont la dimension correspond au dcalage du niveau de la ligne du menu
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion d'indentation.
* @param integer $niveau Niveau du menu  afficher
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image de calage
*/
	function decalage($niveau,$icns) {
		$width = ($niveau - 1) * 10;
		$lacale = "<img src='".$icns["menuindent"]."' width='".$width."' height='1'>";
		return $lacale;
	}
/**
* Retourne l'icne de la ligne de menu sur lequel l'utilisateur vient de cliquer
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion de menu ouvert ou ferm.
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image symbolisant un menu ouvert
*/
	function menuouvert($icns) {
		return "<img src='".$icns["menuselected"]."' alt='' width='20' height='20' align='absmiddle'>";
	}
/**
* Retourne l'icne par dfaut des lignes de menu
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion de menu ouvert ou ferm.
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image symbolisant un menu ferm
*/
	function menuferme($icns) {
		return "<img src='".$icns["menunotselected"]."' alt='' width='20' height='20' align='absmiddle'>";
	}
/**
* Retourne l'ensemble des variables transmises dans URL sauf celles dsignes dans $sauf
* @param string $sauf Liste des variables  ne pas renvoyer. Le sparateur est "|"
* @return string Toutes les variables mises en forme pour usage dans un URL
*/
	function getVars($sauf) {
		//global $_GET;
		
		$elimines = explode("|",$sauf);
		$args = "";
		$elts = $_GET;
		
		while(list($key, $val) = each($elts)) {
			$ok = true;
			foreach ($elimines as $elimine) {
				if ($elimine == $key) {
					$ok = false;
				}
			}
			if ($ok) {
				if ($args != "") {
					$args .= "&";
				}
				$args .= $key."=".stripslashes($val);
			}
		}
		
	 	return $args;
	}
/**
* Retourne la ligne du menu slectionn
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans la liste HTML
*/
	function textemenuouvert($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$modmenu,$icns) {	
		if ($nom != "-") {
			/*if (!$nomenu) {
				$sauf = "";
				$variablessauf = "";
				$urlseul = "";
				if ($url != "") {
					list($urlseul,$args) = explode("?",$url);
					if ($args != "") {
						$argsT = explode("&",$args);
						foreach ($argsT as $temp) {
							list($key,$val) = explode("=",$temp);
							$sauf .= $key."|";
							$variablessauf .= $key."=".$val."&";
						}
					}
				}
				$sauf .= $modmenu["Menu"];
				$variablessauf = "?".$variablessauf.$modmenu["Menu"]."=".$idmenu.",".$noeud;
				
				$variables = $this->getVars($sauf);
				if ($variables != "") {
					$variables = "&".$variables;
				}
				$variables = $variablessauf.$variables;
				$url = $urlseul.$variables;
			}*/
			if (preg_match("/^#/",$url)) {
				global $withrewriting;
				if ($withrewriting && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$url)) {
					if (!preg_match("#_([0-9])+,([0-9])+.htm#i",$url)) {
						$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$url);
					}
				}
				else {
					$variables = "";
					$ancre = "";
					$sauf = $modmenu["Menu"];
					$variablessauf = "?".$variablessauf.$modmenu["Menu"]."=".$idmenu.",".$noeud;
					$urlseul = "";
					
					$variables = $this->getVars($sauf);
					if ($variables != "") {
						$variables = "&".$variables;
					}
					$variables = $variablessauf.$variables;
					$url = $urlseul.$variables;
				}
			}
			else {
				if (!$nomenu) {
					global $withrewriting;
					if ($withrewriting && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$url)) {
						if (!preg_match("#_([0-9])+,([0-9])+.htm#i",$url)) {
							$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$url);
						}
					}
					else {
						if ($url != "") {
							$trouve = false;
							list($urlseul,$args) = explode("?",$url);
							if ($args != "") {
								$argsT = explode("&",$args);
								foreach ($argsT as $temp) {
									list($key,$val) = explode("=",$temp);
									if ($key==$modmenu["Menu"]) {
										$trouve = true;
									}
								}
							}
							if (!$trouve) {
								$variables = "?";
								$variables .= $args;
								if ($variables != "?") {
									$variables .= "&";
								}
								$variables .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
								$url = $urlseul.$variables;
							}
						}
						else {
							$url = "?".$modmenu["Menu"]."=".$idmenu.",".$noeud;
						}
					}
				}
			}
			
			//$sortie = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td nowrap>";
			//$sortie .= $this->decalage($niveau,$icns);
			//$sortie .= $this->menuouvert($icns);
			//$sortie .= "</td><td>";
			$sortie = "<a href=\"".$url."\"";
			if ($target != "") {
				$sortie .= " target='".$target."'";
			}
			//$sortie .= "><div class=\"marge\"><b>&bull; ".$nom."</b></div></a>";
			$sortie .= "><div class=\"marge\" id=\"encours\">".$nom."</div></a>";
			//$sortie .= "</td></tr></table>";
			//$sortie = "<tr><td>".$sortie."</td></tr>";
			$sortie = "<li class=\"N".$niveau."\">".$sortie."</li>";
		}
		else {
			$sortie = "";
		}
		return $sortie;
	}
/**
* Retourne une ligne de menu
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans la liste HTML
*/
	function textemenuferme($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$modmenu,$icns) {
		if ($nom != "-") {
			/*if (!$nomenu) {
				$trouve = false;
				if (substr_count($url,"?") == 0) {
					$variables = "?";
				}
				else {
					$variables = "&";
				}
				if ($url != "") {
					list($urlseul,$args) = explode("?",$url);
					if ($args != "") {
						$argsT = explode("&",$args);
						foreach ($argsT as $temp) {
							list($key,$val) = explode("=",$temp);
							if ($key==$modmenu["Menu"]) {
								$trouve = true;
							}
						}
					}
				}
				if (!$trouve) {
					$variables .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
				}
				if ($variables == "&" || $variables == "?") {
					$variables = "";
				}
			}
			else {
				$variables = "";
			}*/

			if (preg_match("/^#/",$url)) {
				global $withrewriting;
				if ($withrewriting && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$url)) {
					if (!preg_match("#_([0-9])+,([0-9])+.htm#i",$url)) {
						$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$url);
					}
				}
				else {
					$variables = "";
					$ancre = "";
					$sauf = $modmenu["Menu"];
					$variablessauf = "?".$variablessauf.$modmenu["Menu"]."=".$idmenu.",".$noeud;
					$urlseul = "";
					
					$variables = $this->getVars($sauf);
					if ($variables != "") {
						$variables = "&".$variables;
					}
					$variables = $variablessauf.$variables;
					$url = $urlseul.$variables;
				}
			}
			else {
				if (!$nomenu) {
					global $withrewriting;
					if ($withrewriting && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$url)) {
						if (!preg_match("#_([0-9])+,([0-9])+.htm#i",$url)) {
							$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$url);
						}
					}
					else {
						if ($url != "") {
							$trouve = false;
							list($urlseul,$args) = explode("?",$url);
							if ($args != "") {
								$argsT = explode("&",$args);
								foreach ($argsT as $temp) {
									list($key,$val) = explode("=",$temp);
									if ($key==$modmenu["Menu"]) {
										$trouve = true;
									}
								}
							}
							if (!$trouve) {
								$variables = "?";
								$variables .= $args;
								if ($variables != "?") {
									$variables .= "&";
								}
								$variables .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
								$url = $urlseul.$variables;
							}
						}
						else {
							$url = "?".$modmenu["Menu"]."=".$idmenu.",".$noeud;
						}
					}
				}
			}
			
			//$sortie = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td nowrap>";
			//$sortie .= $this->decalage($niveau,$icns);
			//$sortie .= $this->menuferme($icns);
			//$sortie .= "</td><td>";
			//$sortie = "<a href=\"".$url.$variables."\"";
			
			$sortie = "<a href=\"".$url."\"";
			
			if ($target != "") {
				$sortie .= " target='".$target."'";
			}
			$sortie .= "><div class=\"marge\">".$nom."</div></a>";
			//$sortie .= "</td></tr></table>";
			//$sortie = "<tr><td>".$sortie."</td></tr>";
			$sortie = "<li class=\"N".$niveau."\">".$sortie."</li>";
		}
		else {
			$sortie = "";
		}
		return $sortie;
	}
/**
* Retourne la racine du menu slectionn
* @param array $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans une liste HTML
*/
	function racinemenuouvert($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		//$sortie = "<tr><td>".$FIntitule."</td></tr>";
		$sortie = "<li class=\"N0\"><div class=\"marge\">".$FIntitule."</div></li>";
		
		return $sortie;
	}
/**
* Retourne la racine du menu non slectionn
* @param array $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans une liste HTML
*/
	function racinemenuferme($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		//$sortie = "<tr><td>".$FIntitule."</td></tr>";
		$sortie = "<li class=\"N0\"><div class=\"marge\">".$FIntitule."</div></li>";
		
		return $sortie;
	}
}

/**
* Classe d'affichage de menu colonne
* 
* Ce menu est fourni sous forme de liste UL. Les lment de tous les niveaux sont affichs en colonne en permanence.
* @package becmsDynMenu
*/
class menuColonneStatique {
/**
* @var integer Identifiant du menu en cours. Vaut 1 par dfaut.
*/
	var $IdMenu;
/**
* Initialise l'identifiant du menu par dfaut  1
*/		
	function menuColonneStatique() {
		$this->IdMenu = "1";
	} 
/**
* Fixe la valeur de l'identifiant du menu
* @param integer $num Identifiant du menu  afficher
*/	
	function initMenu($num) {
		$this->IdMenu = $num;
	}
/**
* Retourne le menu encod en  HTML
* 
* L'apparence du menu est fixe dans un fichier CSS (MxT6, avec x = IdMenu)
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Chaine contenant le code HTML du menu
*/
	function MakeTree($Myqsl,$modmenu,$icns){
		
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		
		if ($this->IdMenu != $menu) {
			$menu = $this->IdMenu;
			$Page=0;
		}
		//open_db($Myqsl);
		$sortie = getArrayMenu($Myqsl,$menu);
		$famille = getFamilies($Myqsl,$menu);
		//close_db($Myqsl);
		$table = $sortie["table"];
		$partable = $sortie["partable"];
		$Folder = $sortie["Folder"];
	
		if(!isset($Folder[$Page]["Name"])) {
			$Folder[$Page]["Name"]="Racine menu";
		}
		$Name=$Folder[$Page]["Name"];
		
		$levelexpand=100000;
		$results = $this->racinemenuouvert($famille,$modmenu,$icns);
		$results .= $this->TreeExpand(0,$table,$partable,$Folder,$Page,0,$levelexpand,$modmenu,$icns);
		
		$results = '<ul class="menu'.$menu .'">'.$results.'</ul>';
		return $results;
	}
/**
* Fonction interne de dcodage du menu
*/
	function  TreeLevels($Parent,$table,$level){
		$_SESSION["levels"][$Parent]=$level;
		if (count($table) != 0) {
			while(list($key,$val)=each($table[$Parent])) {
				if (isset($table[$key])) {
					$this->TreeLevels($key,$table,$level+1);
				}
			}
		}
		return $_SESSION["levels"];
	}
/**
* Fonction interne de dcodage du menu
*/
	function TreeExpand($Parent,$table,$partable,$Folder0,$Page,$level,$levelexpand,$modmenu,$icns){
		$result='';
		if (count($partable) != 0) {
			$list=$table[$Parent];
			while(list($key,$val)=each($list)){
				if($level<$levelexpand) {
					if($Page==$key){
						$result.= $this->textemenuouvert($level+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
					}
					else {
						$result.= $this->textemenuferme($level+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
					}
					
				}
				if (isset($table[$key])) {
					$result.=$this->TreeExpand($key,$table,$partable,$Folder0,$Page,$level+1,$levelexpand,$modmenu,$icns);
				}
			}
		}
		return $result;
	}
/**
* Retourne une image dont la dimension correspond au dcalage du niveau de la ligne du menu
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion d'indentation.
* @param integer $niveau Niveau du menu  afficher
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image de calage
*/
	function decalage($niveau,$icns) {
		$width = ($niveau - 1) * 10;
		$lacale = "<img src='".$icns["menuindent"]."' width='".$width."' height='1'>";
		return $lacale;
	}
/**
* Retourne l'icne de la ligne de menu sur lequel l'utilisateur vient de cliquer
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion de menu ouvert ou ferm.
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image symbolisant un menu ouvert
*/
	function menuouvert($icns) {
		return "<img src='".$icns["menuselected"]."' alt='' width='20' height='20' align='absmiddle'>";
	}
/**
* Retourne l'icne par dfaut des lignes de menu
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion de menu ouvert ou ferm.
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image symbolisant un menu ferm
*/
	function menuferme($icns) {
		return "<img src='".$icns["menunotselected"]."' alt='' width='20' height='20' align='absmiddle'>";
	}
/**
* Retourne l'ensemble des variables transmises dans URL sauf celles dsignes dans $sauf
* @param string $sauf Liste des variables  ne pas renvoyer. Le sparateur est "|"
* @return string Toutes les variables mises en forme pour usage dans un URL
*/
	function getVars($sauf) {
		//global $_GET;
		$elimines = explode("|",$sauf);
		$args = "";
		$elts = $_GET;
	
		while(list($key, $val) = each($elts)) {
			$ok = true;
			foreach ($elimines as $elimine) {
				if ($elimine == $key) {
					$ok = false;
				}
			}
			if ($ok) {
				if ($args != "") {
					$args .= "&";
				}
				$args .= $key."=".stripslashes($val);
			}
		}
		
	 	return $args;
	}
/**
* Retourne la ligne du menu slectionn
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans la liste HTML
*/
	/*function textemenuouvert($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$modmenu,$icns) {	
		if ($nom != "-") {
			if (!$nomenu) {
				$sauf = "";
				$variablessauf = "";
				$urlseul = "";
				if ($url != "") {
					list($urlseul,$args) = explode("?",$url);
					if ($args != "") {
						$argsT = explode("&",$args);
						foreach ($argsT as $temp) {
							list($key,$val) = explode("=",$temp);
							$sauf .= $key."|";
							$variablessauf .= $key."=".$val."&";
						}
					}
				}
				$sauf .= $modmenu["Menu"];
				$variablessauf = "?".$variablessauf.$modmenu["Menu"]."=".$idmenu.",".$noeud;
				
				$variables = $this->getVars($sauf);
				if ($variables != "") {
					$variables = "&".$variables;
				}
				$variables = $variablessauf.$variables;
				$url = $urlseul.$variables;
			}
			//$sortie = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td nowrap>";
			//$sortie .= $this->decalage($niveau,$icns);
			//$sortie .= $this->menuouvert($icns);
			//$sortie .= "</td><td>";
			$sortie = "<a href=\"".$url."\"";
			if ($target != "") {
				$sortie .= " target='".$target."'";
			}
			$nom = preg_replace("/(.*)(\\\\n)(.*)/i","\\1<span class=\"l2\">\\3</span>", $nom);
			$sortie .= "><div class=\"marge\">".$nom."</div></a>";
			//$sortie .= "</td></tr></table>";
			//$sortie = "<tr><td>".$sortie."</td></tr>";
			$sortie = "<li class=\"N".$niveau."\" id=\"encours".$idmenu."\">".$sortie."</li>";
		}
		else {
			$sortie = "";
		}
		return $sortie;
	}*/
	function textemenuouvert($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$modmenu,$icns) {	
		if ($nom != "-") {
			if (preg_match("/^#/",$url)) {
				global $withrewriting;
				if ($withrewriting && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$_SERVER["REDIRECT_URL"])) {
					if (preg_match("#_([0-9])+,([0-9])+\.htm#i",$_SERVER["REDIRECT_URL"])) {
						$url = preg_replace("#_([0-9])+,([0-9])+\.htm#i","_".$idmenu.",".$noeud.".htm",$_SERVER["REDIRECT_URL"]).$url;
					}
					else {
						$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$_SERVER["REDIRECT_URL"]).$url;
					}
				}
				else {
					$variables = "";
					$ancre = "";
					$sauf = $modmenu["Menu"];
					$variablessauf = "?".$variablessauf.$modmenu["Menu"]."=".$idmenu.",".$noeud;
					$urlseul = "";
					
					$variables = $this->getVars($sauf);
					if ($variables != "") {
						$variables = "&".$variables;
					}
					$variables = $variablessauf.$variables;
					$url = $urlseul.$variables;
				}
			}
			else {
				if (!$nomenu) {
					global $withrewriting;
					if ($withrewriting && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$url)) {
						if (!preg_match("#_([0-9])+,([0-9])+.htm#i",$url)) {
							$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$url);
						}
					}
					else {
						$urlseul = "";
						$trouve = false;
						if ($url != "") {
							list($urlseul,$args) = explode("?",$url);
							if ($args != "") {
								$argsT = explode("&",$args);
								foreach ($argsT as $temp) {
									list($key,$val) = explode("=",$temp);
									if ($key == $modmenu["Menu"]) {
										$trouve = true;
									}
								}
							}
						}
						$url = $urlseul."?".$args;
						if (!$trouve) {
							if ($args != "") {
								$url .= "&";
							}
							else {
								$url .= "?";
							}
							$url .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
						}
					}
				}
			}
			$sortie = "<a href=\"".$url."\"";
			if ($target != "") {
				$sortie .= " target='".$target."'";
			}
			$nom = preg_replace("/(.*)(\\\\n)(.*)/i","\\1<span class=\"l2\">\\3</span>", $nom);
			$sortie .= "><div class=\"marge\">".$nom."</div></a>";
			$sortie = "<li class=\"N".$niveau."\" id=\"encours".$idmenu."\">".$sortie."</li>";
		}
		else {
			$sortie = "";
		}
		return $sortie;
	}
/**
* Retourne une ligne de menu
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans la liste HTML
*/
	/*function textemenuferme($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$modmenu,$icns) {
		if ($nom != "-") {
			if (!$nomenu) {
				$trouve = false;
				if (substr_count($url,"?") == 0) {
					$variables = "?";
				}
				else {
					$variables = "&";
				}
				if ($url != "") {
					list($urlseul,$args) = explode("?",$url);
					if ($args != "") {
						$argsT = explode("&",$args);
						foreach ($argsT as $temp) {
							list($key,$val) = explode("=",$temp);
							if ($key==$modmenu["Menu"]) {
								$trouve = true;
							}
						}
					}
				}
				if (!$trouve) {
					$variables .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
				}
				if ($variables == "&" || $variables == "?") {
					$variables = "";
				}
			}
			else {
				$variables = "";
			}
			//$sortie = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td nowrap>";
			//$sortie .= $this->decalage($niveau,$icns);
			//$sortie .= $this->menuferme($icns);
			//$sortie .= "</td><td>";
			$sortie = "<a href=\"".$url.$variables."\"";
			if ($target != "") {
				$sortie .= " target='".$target."'";
			}
			$nom = preg_replace("/(.*)(\\\\n)(.*)/i","\\1<span class=\"l2\">\\3</span>", $nom);
			$sortie .= "><div class=\"marge\">".$nom."</div></a>";
			//$sortie .= "</td></tr></table>";
			//$sortie = "<tr><td>".$sortie."</td></tr>";
			$sortie = "<li class=\"N".$niveau."\">".$sortie."</li>";
		}
		else {
			$sortie = "";
		}
		return $sortie;
	}*/
	function textemenuferme($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$modmenu,$icns) {
		if ($nom != "-") {
			if (preg_match("/^#/",$url)) {
				global $withrewriting;
				if ($withrewriting && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$_SERVER["REDIRECT_URL"])) {
					if (preg_match("#_([0-9])+,([0-9])+\.htm#i",$_SERVER["REDIRECT_URL"])) {
						$url = preg_replace("#_([0-9])+,([0-9])+\.htm#i","_".$idmenu.",".$noeud.".htm",$_SERVER["REDIRECT_URL"]).$url;
					}
					else {
						$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$_SERVER["REDIRECT_URL"]).$url;
					}
				}
				else {
					$variables = "";
					$ancre = "";
					$sauf = $modmenu["Menu"];
					$variablessauf = "?".$variablessauf.$modmenu["Menu"]."=".$idmenu.",".$noeud;
					$urlseul = "";
					
					$variables = $this->getVars($sauf);
					if ($variables != "") {
						$variables = "&".$variables;
					}
					$variables = $variablessauf.$variables;
					$url = $urlseul.$variables;
				}
			}
			else {
				if (!$nomenu) {
					global $withrewriting;
					if ($withrewriting && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$url)) {
						if (!preg_match("#_([0-9])+,([0-9])+.htm#i",$url)) {
							$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$url);
						}
					}
					else {
						if ($url != "") {
							$trouve = false;
							list($urlseul,$args) = explode("?",$url);
							if ($args != "") {
								$argsT = explode("&",$args);
								foreach ($argsT as $temp) {
									list($key,$val) = explode("=",$temp);
									if ($key==$modmenu["Menu"]) {
										$trouve = true;
									}
								}
							}
							if (!$trouve) {
								$variables = "?";
								$variables .= $args;
								if ($variables != "?") {
									$variables .= "&";
								}
								$variables .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
								$url = $urlseul.$variables;
							}
						}
						else {
							$url = "?".$modmenu["Menu"]."=".$idmenu.",".$noeud;
						}
					}
				}
			}
			$sortie = "<a href=\"".$url."\"";
			if ($target != "") {
				$sortie .= " target='".$target."'";
			}
			$nom = preg_replace("/(.*)(\\\\n)(.*)/i","\\1<span class=\"l2\">\\3</span>", $nom);
			$sortie .= "><div class=\"marge\">".$nom."</div></a>";
			$sortie = "<li class=\"N".$niveau."\">".$sortie."</li>";
		}
		else {
			$sortie = "";
		}
		return $sortie;
	}
/**
* Retourne la racine du menu slectionn
* @param array $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans une liste HTML
*/
	function racinemenuouvert($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		//$sortie = "<tr><td>".$FIntitule."</td></tr>";
		$sortie = "<li class=\"N0\"><div class=\"marge\">".$FIntitule."</div></li>";
		
		return $sortie;
	}
/**
* Retourne la racine du menu non slectionn
* @param array $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans une liste HTML
*/
	function racinemenuferme($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		//$sortie = "<tr><td>".$FIntitule."</td></tr>";
		$sortie = "<li class=\"N0\"><div class=\"marge\">".$FIntitule."</div></li>";
		
		return $sortie;
	}
}

/**
* Classe d'affichage de menu arborescent
* 
* Ce menu est fourni sous forme de tableau. Le menu peut tre manipul indpendemment des pages affiches.
* @package becmsDynMenu
*/
class menuArborescent {
/**
* @var integer Identifiant du menu en cours. Vaut 1 par dfaut.
*/
	var $IdMenu;
/**
* @var array Contient le nom de la variable d'tat d'affichage de l'arboresecence.
*/
	var $varlocal;
/**
* Initialise l'identifiant du menu par dfaut  1
*/	
	function menuArborescent() {
		$this->IdMenu = "1";
	}
/**
* Fixe la valeur de l'identifiant du menu et du nom de la variable d'tat d'affichage de l'arboresecence.
* @param integer $num Identifiant du menu  afficher
*/	
	function initMenu($num) {
		$this->IdMenu = $num;
		$this->varlocal = array("V1" => "m".$num);
	}
/**
* Retourne le tout le menu encod en TEXT. Ce code sera repris par la mthode "MenuArbo" de cette mme classe pour tre converti en HTML.
* 
* L'apparence du menu est fixe dans un fichier CSS (MxT4, avec x = IdMenu)
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Chaine contenant le code TEXT de l'intgralit du menu
*/
	function MakeTree($Myqsl,$modmenu,$icns){
		
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		
		if ($this->IdMenu != $menu) {
			$menu = $this->IdMenu;
			$Page=0;
		}
		//open_db($Myqsl);
		$sortie = getArrayMenu($Myqsl,$menu);
		//close_db($Myqsl);
		$table = $sortie["table"];
		$partable = $sortie["partable"];
		$Folder = $sortie["Folder"];
	
		$levels=$this->TreeLevels(0,$table,0);
		if(!isset($Folder[$Page]["Name"])) {
			$Folder[$Page]["Name"]="Racine menu";
		}
		
		$Name=$Folder[$Page]["Name"];
		$levelexpand=100000;
		$results = $this->racinemenuouvert($modmenu,$icns);
		$results .= $this->TreeExpand(0,$table,$partable,$Folder,$Page,0,$levelexpand,$modmenu,$icns);
		
		$sortie2 = array();
		$sortie1 = explode("//\\",$results);
		foreach ($sortie1 as $ligne) {
			if ($ligne != "") {
				array_push($sortie2,$ligne);
			}
		}
		return $sortie2;
	}
/**
* Fonction interne de dcodage du menu
*/
	function  TreeLevels($Parent,$table,$level){
		$_SESSION["levels"][$Parent]=$level;
		if (count($table) != 0) {
			while(list($key,$val)=each($table[$Parent])) {
				if (isset($table[$key])) {
					$this->TreeLevels($key,$table,$level+1);
				}
			}
		}
		return $_SESSION["levels"];
	}
/**
* Fonction interne de dcodage du menu
*/
	function TreeExpand($Parent,$table,$partable,$Folder0,$Page,$level,$levelexpand,$modmenu,$icns){
		$result='';
		if (count($partable) != 0) {
			$list=$table[$Parent];
			while(list($key,$val)=each($list)){
				if($level<$levelexpand) {
					$result.= $this->textemenuferme($level+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
				}
				if (isset($table[$key])) {
					$result.=$this->TreeExpand($key,$table,$partable,$Folder0,$Page,$level+1,$levelexpand,$modmenu,$icns);
				}
			}
		}
		return $result;
	}
/**
* Retourne une suite de points dont le nombre correspond au dcalage du niveau de la ligne du menu
* @param integer $niveau Niveau du menu  afficher
* @return string Image de calage
*/
	function decalage($niveau) {
		$lacale = str_pad("", $niveau ,".");
		return $lacale;
	}
/**
* Retourne l'icne de la ligne de menu sur lequel l'utilisateur vient de cliquer
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion de menu ouvert ou ferm.
* @return string Image symbolisant un menu ouvert
*/
	function menuouvert() {
		return "<img src='folderopen.gif' alt='' width='20' height='20' align='absmiddle'>";
	}
/**
* Retourne l'icne par dfaut des lignes de menu
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion de menu ouvert ou ferm.
* @return string Image symbolisant un menu ferm
*/
	function menuferme() {
		return "<img src='folder.gif' alt='' width='20' height='20' align='absmiddle'>";
	}
/**
* Retourne l'ensemble des variables transmises dans URL sauf celles dsignes dans $sauf
* @param string $sauf Liste des variables  ne pas renvoyer. Le sparateur est "|"
* @return string Toutes les variables mises en forme pour usage dans un URL
*/
	function getVars($sauf) {
		//global $_GET;
		
		$elimines = explode("|",$sauf);
		$args = "";
		$elts = $_GET;
		
		while(list($key, $val) = each($elts)) {
			$ok = true;
			foreach ($elimines as $elimine) {
				if ($elimine == $key) {
					$ok = false;
				}
			}
			if ($ok) {
				if ($args != "") {
					$args .= "&";
				}
				$args .= $key."=".stripslashes($val);
			}
		}
		
	 	return $args;
	}
/**
* Retourne une ligne de menu
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate en TEXT
*/
	function textemenuferme($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$modmenu,$icns) {
		if ($nom != "-") {
			/*if (!$nomenu) {
				$trouve = false;
				if (substr_count($url,"?") == 0) {
					$variables = "?";
				}
				else {
					$variables = "&";
				}
				if ($url != "") {
					list($urlseul,$args) = explode("?",$url);
					if ($args != "") {
						$argsT = explode("&",$args);
						foreach ($argsT as $temp) {
							list($key,$val) = explode("=",$temp);
							if ($key==$modmenu["Menu"]) {
								$trouve = true;
							}
						}
					}
				}
				if (!$trouve) {
					$variables .= $modmenu["Menu"]."=".$noeud;
				}
				if ($variables == "&" || $variables == "?") {
					$variables = "";
				}
			}
			else {
				$variables = "";
			}*/
			$variables = "";
			
			$sortie = $this->decalage($niveau);
			$sortie .= $nom;
			$sortie .= "|";
			$sortie .= $url.$variables;
			$sortie .= "|";
			if ($target != "") {
				$sortie .= $target;
			}
			else {
				$sortie .= "_self";
			}
		}
		else {
			$sortie = "";
		}
		return $sortie."//\\";
	}
/**
* Retourne la racine du menu slectionn
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans une liste HTML
*/
	function racinemenuouvert($modmenu,$icns) {
		$sortie = "";
		
		return $sortie."//\\";
	}
/**
* Retourne la racine du menu non slectionn
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans une liste HTML
*/
	function racinemenuferme($modmenu,$icns) {
		$sortie = "";
		
		return $sortie."//\\";
	}
/**
* Retourne le menu encod en  HTML
* 
* L'apparence du menu est fixe dans un fichier CSS (MxT6, avec x = IdMenu)'
* @param array $Myqsl Paramtres de la base de donnes
* @param string $fd Intgralit du menu en TEXT
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @param string $p Encodage de la visibilit des branches de l'arboresecnce du menu du menu
* @return string Chaine contenant le code HTML du menu
*/
	function MenuArbo($Myqsl,$fd,$modmenu,$icns,$p) {
		global $SCRIPT_NAME;
		global $PATH_INFO;
		//global $p;
		
		//open_db($Myqsl);
		$famille = getFamilies($Myqsl,$modmenu[$modmenu["Encours"]]);
		//close_db($Myqsl);
		
		if (isset($PATH_INFO)) {
			$script = $PATH_INFO; 
		}
		else {
			$script = $SCRIPT_NAME;
		}
		
		/*$img_expand   = "tree_expand.gif";
		$img_collapse = "tree_collapse.gif";
		$img_line     = "tree_vertline.gif";  
		$img_split	= "tree_split.gif";
		$img_end      = "tree_end.gif";
		$img_leaf     = "tree_leaf.gif";
		$img_spc      = "tree_space.gif";*/
		
		$img_expand   = $icns["img_expand"];
		$img_collapse = $icns["img_collapse"];
		$img_line     = $icns["img_line"];  
		$img_split	  = $icns["img_split"];
		$img_end      = $icns["img_end"];
		$img_leaf     = $icns["img_leaf"];
		$img_spc      = $icns["img_spc"];
		
		/*********************************************/
		/*  Read text file with tree structure       */
		/*********************************************/
		
		/*********************************************/
		/* read file to $tree array                  */
		/* tree[x][0] -> tree level                  */
		/* tree[x][1] -> item text                   */
		/* tree[x][2] -> item link                   */
		/* tree[x][3] -> link target                 */
		/* tree[x][4] -> last item in subtree        */
		/*********************************************/
		
		$maxlevel=0;
		$cnt=0;
		$sortie = "<div class=\"menuarbo".$modmenu[$modmenu["Encours"]]."\"><b>".$famille[0]["intitule"]."</b></div>";
		//$racine = "icns/";
		$racine = "";
		$tree = array();
		
		/*$fd = fopen($treefile, "r");
		if ($fd==0) die("treemenu.inc : Unable to open file ".$treefile);
		while ($buffer = fgets($fd, 4096))*/
		foreach($fd as $buffer)
		{
		  $tree[$cnt][0]=strspn($buffer,".");
		  $tmp=rtrim(substr($buffer,$tree[$cnt][0]));
		  $node=explode("|",$tmp);
		  if (!isset($node[0])) {$node[0]=0;};
		  if (!isset($node[1])) {$node[1]=0;};
		  if (!isset($node[2])) {$node[2]=0;};
		  $tree[$cnt][1]=$node[0];
		  $tree[$cnt][2]=str_replace("\\n", " ", $node[1]);
		  $tree[$cnt][3]=$node[2];
		  $tree[$cnt][4]=0;
		  if ($tree[$cnt][0] > $maxlevel) $maxlevel=$tree[$cnt][0];   
		  $cnt++;
		}
		//fclose($fd);
		
		for ($i=0; $i<count($tree); $i++) {
		   $expand[$i]=0;
		   $visible[$i]=0;
		   $levels[$i]=0;
		}
		
		/*********************************************/
		/*  Get Node numbers to expand               */
		/*********************************************/
		
		if (!isset($p)) {$p="";};
		if ($p!="") {$explevels = explode("|",$p);} else {$explevels=array();};
		
		$i=0;
		while($i<count($explevels))
		{
		  $expand[$explevels[$i]]=1;
		  $i++;
		}
		
		/*********************************************/
		/*  Find last nodes of subtrees              */
		/*********************************************/
		
		$lastlevel=$maxlevel;
		for ($i=count($tree)-1; $i>=0; $i--)
		{
		   if ( $tree[$i][0] < $lastlevel )
		   {
		     for ($j=$tree[$i][0]+1; $j <= $maxlevel; $j++)
		     {
		        $levels[$j]=0;
		     }
		   }
		   if (!isset($levels[$tree[$i][0]])) {
		   		$levels[$tree[$i][0]] = 0;
		   }
		   if ( $levels[$tree[$i][0]]==0 )
		   {
		     $levels[$tree[$i][0]]=1;
		     $tree[$i][4]=1;
		   }
		   else
		     $tree[$i][4]=0;
		   $lastlevel=$tree[$i][0];  
		}
		
		
		/*********************************************/
		/*  Determine visible nodes                  */
		/*********************************************/
		
		// all root nodes are always visible
		for ($i=0; $i < count($tree); $i++) if ($tree[$i][0]==1) $visible[$i]=1;
		
		
		for ($i=0; $i < count($explevels); $i++)
		{
		  $n=$explevels[$i];
		  if (!isset($visible[$n])) {$visible[$n] = 0;};
		  if (!isset($expand[$n])) {$expand[$n] = 0;};
		  if ( ($visible[$n]==1) && ($expand[$n]==1) )
		  {
		     $j=$n+1;
		     while ( $tree[$j][0] > $tree[$n][0] )
		     {
		       if ($tree[$j][0]==$tree[$n][0]+1) $visible[$j]=1;     
		       $j++;
		     }
		  }
		}
		
		
		/*********************************************/
		/*  Output nicely formatted tree             */
		/*********************************************/
		
		for ($i=0; $i<$maxlevel; $i++) $levels[$i]=1;
		
		$maxlevel++;
		
		$sortie .= "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" cols=\"".($maxlevel+3)."\" class=\"menuarbo\">\n";
		/*$sortie .= "<tr>";
		for ($i=0; $i<$maxlevel; $i++) $sortie .= "<td width=16></td>";
		$sortie .= "<td width=100%>&nbsp;</td></tr>\n";*/
		$cnt=0;
		while ($cnt<count($tree))
		{
			if (!isset($visible[$cnt])) {$visible[$cnt] = false;};
		  if ($visible[$cnt])
		  {
		    /****************************************/
		    /* start new row                        */
		    /****************************************/      
		    $sortie .= "<tr>";
		    
		    /****************************************/
		    /* vertical lines from higher levels    */
		    /****************************************/
		    $i=0;
		    while ($i<$tree[$cnt][0]-1) 
		    {
		      if ($levels[$i]==1)
		          $sortie .= "<td width=\"16\"><a name='$cnt'></a><img width=\"16\" height=\"16\" src=\"".$racine.$img_line."\"></td>";
		      else
		          $sortie .= "<td width=\"16\"><a name='$cnt'></a><img width=\"16\" height=\"16\" src=\"".$racine.$img_spc."\"></td>";
		      $i++;
		    }
		    
		    /****************************************/
		    /* corner at end of subtree or t-split  */
		    /****************************************/         
		    
		    if ($tree[$cnt][4]==1) 
		    {
		      $sortie .= "<td width=\"16\"><img width=\"16\" height=\"16\" src=\"".$racine.$img_end."\"></td>";
		      $levels[$tree[$cnt][0]-1]=0;
		    }
		    else
		    {
		      $sortie .= "<td width=\"16\"><img width=\"16\" height=\"16\" src=\"".$racine.$img_split."\"></td>";                  
		      $levels[$tree[$cnt][0]-1]=1;    
		    } 
		    
		    /********************************************/
		    /* Node (with subtree) or Leaf (no subtree) */
		    /********************************************/
		    if (!isset($tree[$cnt+1][0])) {$tree[$cnt+1][0]=0;};
		    if ($tree[$cnt+1][0]>$tree[$cnt][0])
		    {
		      
		      /****************************************/
		      /* Create expand/collapse parameters    */
		      /****************************************/
		      $i=0; $params="?".$this->varlocal["V1"]."=";
		      $vcount = count($expand);
		      while($i<$vcount)
		      {
		        if (!isset($expand[$i])) {$expand[$i]=0;};
		        if ( ($expand[$i]==1) && ($cnt!=$i) || ($expand[$i]==0 && $cnt==$i))
		        {
		          $params=$params.$i;
		          $params=$params."|";
		        }
		        $i++;
		      }
		      
		      //rajout par vince
		      $params_plus = $this->getVars($this->varlocal["V1"]);
		      if ($params != "" && $params_plus != "") {
		      	$params .= "&";
		      }
		      $params .= $params_plus;
		      if ($expand[$cnt]==0)
		          //$sortie .= "<td width=\"16\"><a href=\"".$script.$params."#$cnt\"><img width=\"16\" height=\"16\" src=\"".$racine.$img_expand."\" border=0></a></td>";
		      	  //$sortie .= "<td width=\"16\"><a href=\"".$script.$params."#".$cnt."\"><img width=\"16\" height=\"16\" src=\"".$racine.$img_expand."\" border=0></a></td>";
		      		$sortie .= "<td width=\"16\"><a href=\"".$script.$params."\"><img width=\"16\" height=\"16\" src=\"".$racine.$img_expand."\" border=0></a></td>";
		      else
		          //$sortie .= "<td width=\"16\"><a href=\"".$script.$params."#$cnt\"><img width=\"16\" height=\"16\" src=\"".$racine.$img_collapse."\" border=0></a></td>";         
				  //$sortie .= "<td width=\"16\"><a href=\"".$script.$params."#".$cnt."\"><img width=\"16\" height=\"16\" src=\"".$racine.$img_collapse."\" border=0></a></td>";         
				    $sortie .= "<td width=\"16\"><a href=\"".$script.$params."\"><img width=\"16\" height=\"16\" src=\"".$racine.$img_collapse."\" border=0></a></td>";         
			}
		    else
		    {
		      /*************************/
		      /* Tree Leaf             */
		      /*************************/
		
		      $sortie .= "<td width=\"16\"><img width=\"16\" height=\"16\" src=\"".$racine.$img_leaf."\"></td>";         
		    }
		    /****************************************/
		    /* output item text                     */
		    /****************************************/
		    
		    $adresse = parse_url($tree[$cnt][2]);
		    if (!isset($adresse["path"])) {
		    	$adresse["path"] = "";
		    }
		    if (!isset($adresse["host"])) {
		    	$adresse["host"] = "";
		    }
		    if ($adresse["host"] !="" || $adresse["path"] != "") {
		    	$script = "";
		    }
		    if ($adresse["host"] =="") {
			    if ($p != "") {
				    if ($tree[$cnt][2] != "") {
				    	$tree[$cnt][2] .= "&".$this->varlocal["V1"]."=";
				    }
				    else {
				    	$tree[$cnt][2] .= "?".$this->varlocal["V1"]."=";
				    }
				    $tree[$cnt][2]  .= $p;
			    }
			    /*if ($tree[$cnt][2] != "") {
				   	$tree[$cnt][2] .= "&".$modmenu["Menu"]."=";
				}
				else {
				 	$tree[$cnt][2] .= "?".$modmenu["Menu"]."=";
				}
				$tree[$cnt][2]  .= $modmenu[$modmenu["Encours"]];*/
			}
		    if ($tree[$cnt][2]=="")
		        $sortie .= "<td colspan=".($maxlevel-$tree[$cnt][0]).">".$tree[$cnt][1]."</td>";
		    else
		        $sortie .= "<td colspan=".($maxlevel-$tree[$cnt][0])."><a href=\"".$script.$tree[$cnt][2]."\" target=\"".$tree[$cnt][3]."\">".$tree[$cnt][1]."</a></td>";
		        
		    /****************************************/
		    /* end row                              */
		    /****************************************/
		            
		    $sortie .= "</tr>\n";      
		  }
		  $cnt++;    
		}
		$sortie .= "</table>\n";
		return $sortie;
	}
}

/**
* Classe d'affichage de menu colonne droulante
* 
* Ce menu est fourni sous forme de liste UL. Le nom du menu est affich. Les lment de niveau 1 sont affichs en colonne. Les niveaux hierarchiques suprieurs sont affichs au clic des lments de niveau infrieur.
* Seuls les lments correspondants  l'lment cliqu sont dploys.
* @package becmsDynMenu
*/
class menuColonneDynamiqueUnique {
/**
* @var integer Identifiant du menu en cours. Vaut 1 par dfaut.
*/
	var $IdMenu;
/**
* Initialise l'identifiant du menu par dfaut  1
*/
	function menuColonneDynamiqueUnique() {
		$this->IdMenu = "1";
	} 
/**
* Fixe la valeur de l'identifiant du menu
* @param integer $num Identifiant du menu  afficher
*/	
	function initMenu($num) {
		$this->IdMenu = $num;
	}
/**
* Retourne le menu encod en  HTML
* 
* L'apparence du menu est fixe dans un fichier CSS (MxT8, avec x = IdMenu)
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Chaine contenant le code HTML du menu
*/	
	function MakeTree($Myqsl,$modmenu,$icns){
		
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		
		if ($this->IdMenu != $menu) {
			$menu = $this->IdMenu;
			$Page=0;
		}
		//open_db($Myqsl);
		$sortie = getArrayMenu($Myqsl,$menu);
		$famille = getFamilies($Myqsl,$menu);
		//close_db($Myqsl);
		$table = $sortie["table"];
		$partable = $sortie["partable"];
		$Folder = $sortie["Folder"];
	
		$levels=$this->TreeLevels(0,$table,0);
		if(!isset($Folder[$Page]["Name"])) {
			$Folder[$Page]["Name"]="Racine menu";
		}
		$Name=$Folder[$Page]["Name"];
		
		if ($Page == 0) {
			if(!isset($_SESSION["expandtree"])) {
				$_SESSION["expandtree"]=1;
			}
			$levelexpand=1;
			$results = $this->racinemenuouvert($famille,$modmenu,$icns);
			$results .= $this->TreeExpand(0,$table,$partable,$Folder,$Page,0,$levelexpand,$modmenu,$icns);
		}
		else {
			$results=$this->racinemenuferme($famille,$modmenu,$icns);
			$ID=$Page;
			$results.=$this->TreeNodes($ID,$table,$partable,$Folder,$Page,$levels,$modmenu,$icns);
			$_SESSION["expandtree"]=1;
		}
		
		$results = '<ul class="menu'.$menu.'">'.$results.'</ul>';
		return $results;
	}
/**
* Fonction interne de dcodage du menu
*/
	function  TreeLevels($Parent,$table,$level){
		$_SESSION["levels"][$Parent]=$level;
		if (count($table) != 0) {
			while(list($key,$val)=each($table[$Parent])) {
				if (isset($table[$key])) {
					$this->TreeLevels($key,$table,$level+1);
				}
			}
		}
		return $_SESSION["levels"];
	}
/**
* Fonction interne de dcodage du menu
*/
	function TreeNodes($ID,$table,$partable,$Folder0,$Page,$levels,$modmenu,$icns) {
		$rez0="";
		if(isset($table[$ID])) {
			$lisd=$table[$ID];
			$ID0=$ID;
			$fiplevel=$levels[$ID];
			while(list($key,$val)=each($lisd)){
				if($Page==$key)	{
					$rez0.= $this->textemenuouvert($levels[$ID]+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
				}
				else {
					$rez0 .= $this->textemenuferme($levels[$ID]+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
				}
			}
		}
		$res="";
		while ($ID!=0) {
			$fip=$partable[$ID];
			$fiplevel=$levels[$fip];
			$fiplist=$table[$fip];
			$rez="";
			while(list($key,$val)=each($fiplist)){
				if($Page==$key){
					$rez.= $this->textemenuouvert($fiplevel+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
					$rez .= $rez0;
				}
				else {
					$rez.= $this->textemenuferme($fiplevel+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
				}
				if($ID==$key) {
					$rez.=$res;
					$res="";
				}
			}
			$res.=$rez;
			$ID=$partable[$ID];
		}
		return $rez;
	}
/**
* Fonction interne de dcodage du menu
*/
	function TreeExpand($Parent,$table,$partable,$Folder0,$Page,$level,$levelexpand,$modmenu,$icns){
		$result='';
		if (count($partable) != 0) {
			$list=$table[$Parent];
			while(list($key,$val)=each($list)){
				if($level<$levelexpand) {
					$result.= $this->textemenuferme($level+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
				}
				if (isset($table[$key])) {
					$result.=$this->TreeExpand($key,$table,$partable,$Folder0,$Page,$level+1,$levelexpand,$modmenu,$icns);
				}
			}
		}
		return $result;
	}
/**
* Retourne une image dont la dimension correspond au dcalage du niveau de la ligne du menu
* 
* Cette mthode n'est pas utilise dans ce type de menu : tout est fait en utilisant les styles CSS.
* @param integer $niveau Niveau du menu  afficher
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image de calage
*/
	function decalage($niveau,$icns) {
		$width = ($niveau - 1) * 10;
		$lacale = "<img src='".$icns["menuindent"]."' width='".$width."' height='1'>";
		return $lacale;
	}
/**
* Retourne l'icne de la ligne de menu sur lequel l'utilisateur vient de cliquer
* 
* Cette mthode n'est pas utilise dans ce type de menu : tout est fait en utilisant les styles CSS.
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image symbolisant un menu ouvert
*/
	function menuouvert($icns) {
		return "<img src='".$icns["menuselected"]."' alt='' width='20' height='20' align='absmiddle'>";
	}
/**
* Retourne l'icne par dfaut des lignes de menu
* 
* Cette mthode n'est pas utilise dans ce type de menu : tout est fait en utilisant les styles CSS.
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image symbolisant un menu ferm
*/
	function menuferme($icns) {
		return "<img src='".$icns["menunotselected"]."' alt='' width='20' height='20' align='absmiddle'>";
	}
/**
* Retourne l'ensemble des variables transmises dans URL sauf celles dsignes dans $sauf
* @param string $sauf Liste des variables  ne pas renvoyer. Le sparateur est "|"
* @return string Toutes les variables mises en forme pour usage dans un URL
*/
	function getVars($sauf) {
		//global $_GET;
		$elimines = explode("|",$sauf);
		$args = "";
		$elts = $_GET;
	
		while(list($key, $val) = each($elts)) {
			$ok = true;
			foreach ($elimines as $elimine) {
				if ($elimine == $key) {
					$ok = false;
				}
			}
			if ($ok) {
				if ($args != "") {
					$args .= "&";
				}
				$args .= $key."=".stripslashes($val);
			}
		}
		
	 	return $args;
	}
/**
* Retourne la ligne du menu slectionn
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans la liste HTML
*/
	function textemenuouvert($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$modmenu,$icns) {	
		if ($nom != "-") {
			if (preg_match("/^#/",$url)) {
				global $withrewriting;
				if ($withrewriting && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$_SERVER["REDIRECT_URL"])) {
					if (preg_match("#_([0-9])+,([0-9])+\.htm#i",$_SERVER["REDIRECT_URL"])) {
						$url = preg_replace("#_([0-9])+,([0-9])+\.htm#i","_".$idmenu.",".$noeud.".htm",$_SERVER["REDIRECT_URL"]).$url;
					}
					else {
						$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$_SERVER["REDIRECT_URL"]).$url;
					}
				}
				else {
					$variables = "";
					$ancre = "";
					$sauf = $modmenu["Menu"];
					$variablessauf = "?".$variablessauf.$modmenu["Menu"]."=".$idmenu.",".$noeud;
					$urlseul = "";
					
					$variables = $this->getVars($sauf);
					if ($variables != "") {
						$variables = "&".$variables;
					}
					$variables = $variablessauf.$variables;
					$url = $urlseul.$variables;
				}
			}
			else {
				if (!$nomenu) {
					global $withrewriting;
					if ($withrewriting && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$url)) {
						if (!preg_match("#_([0-9])+,([0-9])+.htm#i",$url)) {
							$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$url);
						}
					}
					else {
						/*$sauf = "";
						$variablessauf = "";
						$urlseul = "";
						if ($url != "") {
							list($urlseul,$args) = explode("?",$url);
							if ($args != "") {
								$argsT = explode("&",$args);
								foreach ($argsT as $temp) {
									list($key,$val) = explode("=",$temp);
									$sauf .= $key."|";
									$variablessauf .= $key."=".$val."&";
									if (preg_match("#(.*)\\[\\]$#",$key,$tabvar)) {
										 $sauf .= $tabvar[1]."|";
									}
								}
							}
						}
						$sauf .= $modmenu["Menu"];
						$variablessauf = "?".$variablessauf.$modmenu["Menu"]."=".$idmenu.",".$noeud;	
						$variables = $this->getVars($sauf);
						if ($variables != "") {
							$variables = "&".$variables;
						}
						$variables = $variablessauf.$variables;
						$url = $urlseul.$variables;*/
						$urlseul = "";
						$trouve = false;
						if ($url != "") {
							list($urlseul,$args) = explode("?",$url);
							if ($args != "") {
								$argsT = explode("&",$args);
								foreach ($argsT as $temp) {
									list($key,$val) = explode("=",$temp);
									if ($key == $modmenu["Menu"]) {
										$trouve = true;
									}
								}
							}
						}
						$url = $urlseul."?".$args;
						if (!$trouve) {
							if ($args != "") {
								$url .= "&";
							}
							else {
								$url .= "?";
							}
							$url .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
						}
					}
				}
			}
			$sortie = "<a href=\"".$url."\"";
			if ($target != "") {
				$sortie .= " target='".$target."'";
			}
			$nom = preg_replace("/(.*)(\\\\n)(.*)/i","\\1<span class=\"l2\">\\3</span>", $nom);
			$sortie .= "><div class=\"marge\">".$nom."</div></a>";
			$sortie = "<li class=\"N".$niveau."\" id=\"encours".$idmenu."\">".$sortie."</li>";
		}
		else {
			$sortie = "";
		}
		return $sortie;
	}
/**
* Retourne une ligne de menu
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans la liste HTML
*/
	function textemenuferme($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$modmenu,$icns) {
		if ($nom != "-") {
			if (preg_match("/^#/",$url)) {
				global $withrewriting;
				if ($withrewriting && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$_SERVER["REDIRECT_URL"])) {
					if (preg_match("#_([0-9])+,([0-9])+\.htm#i",$_SERVER["REDIRECT_URL"])) {
						$url = preg_replace("#_([0-9])+,([0-9])+\.htm#i","_".$idmenu.",".$noeud.".htm",$_SERVER["REDIRECT_URL"]).$url;
					}
					else {
						$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$_SERVER["REDIRECT_URL"]).$url;
					}
				}
				else {
					$variables = "";
					$ancre = "";
					$sauf = $modmenu["Menu"];
					$variablessauf = "?".$variablessauf.$modmenu["Menu"]."=".$idmenu.",".$noeud;
					$urlseul = "";
					
					$variables = $this->getVars($sauf);
					if ($variables != "") {
						$variables = "&".$variables;
					}
					$variables = $variablessauf.$variables;
					$url = $urlseul.$variables;
				}
			}
			else {
				if (!$nomenu) {
					global $withrewriting;
					if ($withrewriting && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$url)) {
						if (!preg_match("#_([0-9])+,([0-9])+.htm#i",$url)) {
							$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$url);
						}
					}
					else {
						if ($url != "") {
							$trouve = false;
							list($urlseul,$args) = explode("?",$url);
							if ($args != "") {
								$argsT = explode("&",$args);
								foreach ($argsT as $temp) {
									list($key,$val) = explode("=",$temp);
									if ($key==$modmenu["Menu"]) {
										$trouve = true;
									}
								}
							}
							if (!$trouve) {
								$variables = "?";
								$variables .= $args;
								if ($variables != "?") {
									$variables .= "&";
								}
								$variables .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
								$url = $urlseul.$variables;
							}
						}
						else {
							$url = "?".$modmenu["Menu"]."=".$idmenu.",".$noeud;
						}
					}
				}
			}
			$sortie = "<a href=\"".$url."\"";
			if ($target != "") {
				$sortie .= " target='".$target."'";
			}
			$nom = preg_replace("/(.*)(\\\\n)(.*)/i","\\1<span class=\"l2\">\\3</span>", $nom);
			$sortie .= "><div class=\"marge\">".$nom."</div></a>";
			$sortie = "<li class=\"N".$niveau."\">".$sortie."</li>";
		}
		else {
			$sortie = "";
		}
		return $sortie;
	}
/**
* Retourne la racine du menu slectionn
* @param array $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans une liste HTML
*/
	function racinemenuouvert($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		$sortie = "<li class=\"N0\"><div class=\"marge\"><div class=\"lettrine\">".$FIntitule."</div></div></li>";
		
		return $sortie;
	}
/**
* Retourne la racine du menu non slectionn
* @param array $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans une liste HTML
*/
	function racinemenuferme($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		$sortie = "<li class=\"N0\"><div class=\"marge\"><div class=\"lettrine\">".$FIntitule."</div></div></li>";
		
		return $sortie;
	}
}

/**
* Classe d'affichage de menu deroulant vertical
* 
* Ce menu est fourni sous forme de liste UL. Le nom du menu est affich. Les lment de niveau 1 sont affichs en colonne. Les niveaux hierarchiques suprieurs sont affichs au survol des lments de niveau infrieur.
* Seuls les lments correspondants  l'lment survol sont dploys.
* @package becmsDynMenu
*/
class menuDeroulantVUnique {
/**
* @var integer Identifiant du menu en cours. Vaut 1 par dfaut.
*/		
	var $IdMenu;
/**
* Initialise l'identifiant du menu par dfaut  1
*/
	function menuDeroulantVUnique() {
		$this->IdMenu = "1";
	}
/**
* Fixe la valeur de l'identifiant du menu
* @param integer $num Identifiant du menu  afficher
*/
	function initMenu($num) {
		$this->IdMenu = $num;
	}
/**
* Retourne le menu encod en  HTML
* 
* L'apparence du menu est fixe dans un fichier CSS (MxT9, avec x = IdMenu)
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Chaine contenant le code HTML du menu
*/	
	function MakeTree($Myqsl,$modmenu,$icns){
		
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		
		if ($this->IdMenu != $menu) {
			$menu = $this->IdMenu;
			$Page=0;
		}
		//open_db($Myqsl);
		
		$sortie = getArrayMenu($Myqsl,$menu);
		$famille = getFamilies($Myqsl,$menu);
		$table = $sortie["table"];
		$partable = $sortie["partable"];
		$Folder = $sortie["Folder"];
	
		$levels=$this->TreeLevels(0,$table,0);
		if(!isset($Folder[$Page]["Name"])) {
			$Folder[$Page]["Name"]="Racine menu";
		}
		$Name=$Folder[$Page]["Name"];
		$levelexpand=100000;
		$results = "<ul id=\"menu".$menu."\">";
		$results .= $this->racinemenuouvert($famille,$modmenu,$icns);
		$results .= $this->TreeExpand(0,$table,$partable,$Folder,$Page,0,$levelexpand,$Myqsl,$modmenu,$icns);
		$results.= "</ul>";
		//close_db($Myqsl);
		
		return $results;
	}
/**
* Fonction interne de dcodage du menu
*/
	function  TreeLevels($Parent,$table,$level){
		$_SESSION["levels"][$Parent]=$level;
		if (count($table) != 0) {
			while(list($key,$val)=each($table[$Parent])) {
				if (isset($table[$key])) {
					$this->TreeLevels($key,$table,$level+1);
				}
			}
		}
		return $_SESSION["levels"];
	}
/**
* Fonction interne de dcodage du menu
*/
	function TreeExpand($Parent,$table,$partable,$Folder0,$Page,$level,$levelexpand,$Myqsl,$modmenu,$icns){
		$result='';
		if (count($partable) != 0) {
			$list=$table[$Parent];
			while(list($key,$val)=each($list)){
				if($level<$levelexpand) {
					$result.= "<li>";
					$result.= $this->textemenuferme($level+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$Myqsl,$modmenu,$icns);
				}
				if (isset($table[$key])) {
					$result.= "<ul>";
					$result.=$this->TreeExpand($key,$table,$partable,$Folder0,$Page,$level+1,$levelexpand,$Myqsl,$modmenu,$icns);
					$result.= "</ul>";
				}
				$result.= "</li>";
			}
		}
		return $result;
	}
/**
* Retourne une image dont la dimension correspond au dcalage du niveau de la ligne du menu
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion d'indentation.
* @param integer $niveau Niveau du menu  afficher
* @return string Image de calage
*/
	function decalage($niveau) {
		$width = ($niveau - 1) * 10;
		$lacale = "<img src='tr.gif' width='".$width."' height='1'>";
		return $lacale;
	}
/**
* Retourne l'icne de la ligne de menu sur lequel l'utilisateur vient de cliquer
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion de menu ouvert ou ferm.* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image symbolisant un menu ouvert
*/
	function menuouvert() {
		//return "<img src='folderopen.gif' alt='' width='20' height='20' align='absmiddle'>&nbsp;";
		return "";
	}
/**
* Retourne l'icne par dfaut des lignes de menu
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion de menu ouvert ou ferm.
* @return string Image symbolisant un menu ferm
*/
	function menuferme() {
		//return "<img src='folder.gif' alt='' width='20' height='20' align='absmiddle'>&nbsp;";
		return "";
	}
/**
* Retourne l'ensemble des variables transmises dans URL sauf celles dsignes dans $sauf
* @param string $sauf Liste des variables  ne pas renvoyer. Le sparateur est "|"
* @return string Toutes les variables mises en forme pour usage dans un URL
*/
	function getVars($sauf) {
		//global $_GET;
		
		$elimines = explode("|",$sauf);
		$args = "";
		$elts = $_GET;
		
		while(list($key, $val) = each($elts)) {
			$ok = true;
			foreach ($elimines as $elimine) {
				if ($elimine == $key) {
					$ok = false;
				}
			}
			if ($ok) {
				if ($args != "") {
					$args .= "&";
				}
				$args .= $key."=".stripslashes($val);
			}
		}
		
	 	return $args;
	}
/**
* Retourne une ligne de menu
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $position position de la ligne de menu en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans une liste HTML
*/
	function textemenuferme($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$Myqsl,$modmenu,$icns) {
		if ($nom != "-") {
			if (preg_match("/^#/",$url)) {
				$variables = "";
				$ancre = "";
			}
			else {
				if (!$nomenu) {
					list($url,$ancre) = explode("#",$url);
					if ($ancre != "") {
						$ancre = "#".$ancre;
					}
					$trouve = false;
					if (substr_count($url,"?") == 0) {
						$variables = "?";
					}
					else {
						$variables = "&";
					}
					if ($url != "") {
						list($urlseul,$args) = explode("?",$url);
						if ($args != "") {
							$argsT = explode("&",$args);
							foreach ($argsT as $temp) {
								list($key,$val) = explode("=",$temp);
								if ($key==$modmenu["Menu"]) {
									$trouve = true;
								}
							}
						}
					}
					if (!$trouve) {
						$variables .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
					}
					if ($variables == "&" || $variables == "?") {
						$variables = "";
					}
				}
				else {
					$variables = "";
				}
			}
			//$sortie = decalage($niveau);
			$sortie = $this->menuferme();
			$sortie .= "<a href=\"".$url.$variables.$ancre."\"";
			if (subMenu($Myqsl,$noeud,$idmenu)) {
				$sortie .= "class=\"next\"";
			}
			if ($target != "") {
				$sortie .= " target='".$target."'";
			}
			$sortie .= "><span><div class=\"marge\">".$nom."</div></span></a>";
		}
		else {
			$sortie = "<hr />";
		}
		return $sortie;
	}
/**
* Retourne la racine du menu slectionn
* 
* Pour ce menu, le retour est vide.
* @param array $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans un tableau HTML
*/
	function racinemenuouvert($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		$sortie = "<li class=\"titre\">".$FIntitule."</li>";
		
		return $sortie;
	}
/**
* Retourne la racine du menu non slectionn
* @param array $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans une liste HTML
*/
	function racinemenuferme($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		$sortie = "<li class=\"titre\">".$FIntitule."</li>";
		
		return $sortie;
	}
}

/**
* Classe d'affichage de menu sous forme dlments horizontaux
* 
* Ce menu est fourni sous forme de tableau. Les lment de niveau 1 sont affichs en ligne. Les niveaux hierarchiques suprieurs ne sont pas affichs.
* @package becmsDynMenu
*/
class menuTableauHUnique {
/**
* @var integer Identifiant du menu en cours. Vaut 1 par dfaut.
*/	
	var $IdMenu;
/**
* Initialise l'identifiant du menu par dfaut  1
*/	
	function menuTableauHUnique() {
		$this->IdMenu = "1";
	}
/**
* Fixe la valeur de l'identifiant du menu
* @param integer $num Identifiant du menu  afficher
*/
	function initMenu($num) {
		$this->IdMenu = $num;
	}
/**
* Retourne le menu encod en  HTML
* 
* L'apparence du menu est fixe dans un fichier CSS (MxT2, avec x = IdMenu)
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Chaine contenant le code HTML du menu
*/	
	function MakeTree($Myqsl,$modmenu,$icns){		
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		
		if ($this->IdMenu != $menu) {
			$menu = $this->IdMenu;
			$Page=0;
		}
		//open_db($Myqsl);
		
		$sortie = getArrayMenu($Myqsl,$menu);
		$table = $sortie["table"];
		$partable = $sortie["partable"];
		$Folder = $sortie["Folder"];
	
		$levels=$this->TreeLevels(0,$table,0);
		if(!isset($Folder[$Page]["Name"])) {
			$Folder[$Page]["Name"]="Racine menu";
		}
		$Name=$Folder[$Page]["Name"];
		$results = $this->racinemenuouvert($modmenu,$icns);
		$levelexpand=100000;
		$results.= "<table id=\"menu".$menu."\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr>";
		//$results.= "<td class=\"cotegauche\"><img src=\"themes/".get_theme()."/images/menu_coteg_".$menu.".gif\" alt=\"\" border=\"0\">&nbsp;</td>";
		$results.= "<td class=\"cotegauche\"></td>";
		$results .= $this->TreeExpand(0,$table,$partable,$Folder,$Page,0,$levelexpand,$Myqsl,$modmenu,$icns);
		//$results.= "<td class=\"cotedroit\">&nbsp;<img src=\"themes/".get_theme()."/images/menu_coted_".$menu.".gif\" alt=\"\" border=\"0\"></td>";
		$results.= "<td class=\"cotedroit\"></td>";
		$results.= "</tr></table>";
		//close_db($Myqsl);
		
		return $results;
	}
/**
* Fonction interne de dcodage du menu
*/	
	function  TreeLevels($Parent,$table,$level){
		$_SESSION["levels"][$Parent]=$level;
		if (count($table) != 0) {
			while(list($key,$val)=each($table[$Parent])) {
				if (isset($table[$key])) {
					$this->TreeLevels($key,$table,$level+1);
				}
			}
		}
		return $_SESSION["levels"];
	}
/**
* Fonction interne de dcodage du menu
*/	
	function TreeExpand($Parent,$table,$partable,$Folder0,$Page,$level,$levelexpand,$Myqsl,$modmenu,$icns){
		$result='';
		if (count($partable) != 0) {
			$list=$table[$Parent];
			while(list($key,$val)=each($list)){
				if($level<$levelexpand) {
					if ($result != "") {
						//$result .= "<td class=\"sep\">"."-"."</td>";
						$result .= "<td class=\"sep\"></td>";
					}
					
					if ($Page == $Folder0[$key]["ID"]) {
						$result.= "<td id=\"encours".$Folder0[$key]["idmenu"]."\">";
						$result.= $this->textemenuouvert($level+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$Myqsl,$modmenu,$icns);	
					}
					else {
						$result.= "<td>";
						$result.= $this->textemenuferme($level+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$Myqsl,$modmenu,$icns);
					}
				}
				if (isset($table[$key])) {
					//niveaux sup non affichs
					/*$result.= "<ul>";
					$result.=$this->TreeExpand($key,$table,$partable,$Folder0,$Page,$level+1,$levelexpand,$Myqsl,$modmenu,$icns);
					$result.= "</ul>";*/
				}
				$result.= "</td>";
			}
		}
		return $result;
	}
/**
* Retourne une image dont la dimension correspond au dcalage du niveau de la ligne du menu
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion d'indentation.
* @param integer $niveau Niveau du menu  afficher
* @return string Image de calage
*/
	function decalage($niveau) {
		$width = ($niveau - 1) * 10;
		$lacale = "<img src='tr.gif' width='".$width."' height='1'>";
		return $lacale;
	}
/**
* Retourne l'icne de la ligne de menu sur lequel l'utilisateur vient de cliquer
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion de menu ouvert ou ferm.
* @return string Image symbolisant un menu ouvert
*/
	function menuouvert() {
		//return "<img src='folderopen.gif' alt='' width='20' height='20' align='absmiddle'>&nbsp;";
		return "";
	}
/**
* Retourne l'icne par dfaut des lignes de menu
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion de menu ouvert ou ferm.* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image symbolisant un menu ferm
*/
	function menuferme() {
		//return "<img src='folder.gif' alt='' width='20' height='20' align='absmiddle'>&nbsp;";
		return "";
	}
/**
* Retourne l'ensemble des variables transmises dans URL sauf celles dsignes dans $sauf
* @param string $sauf Liste des variables  ne pas renvoyer. Le sparateur est "|"
* @return string Toutes les variables mises en forme pour usage dans un URL
*/
	function getVars($sauf) {
		//global $_GET;
		
		$elimines = explode("|",$sauf);
		$args = "";
		$elts = $_GET;
		
		while(list($key, $val) = each($elts)) {
			$ok = true;
			foreach ($elimines as $elimine) {
				if ($elimine == $key) {
					$ok = false;
				}
			}
			if ($ok) {
				if ($args != "") {
					$args .= "&";
				}
				$args .= $key."=".stripslashes($val);
			}
		}
		
	 	return $args;
	}
/**
* Retourne une ligne de menu
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $position position de la ligne de menu en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans une liste HTML
*/
	function textemenuouvert($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$Myqsl,$modmenu,$icns) {
		if ($nom != "-") {
			if (preg_match("/^#/",$url)) {
				$variables = "";
				$ancre = "";
			}
			else {
				if (!$nomenu) {
					list($url,$ancre) = explode("#",$url);
					if ($ancre != "") {
						$ancre = "#".$ancre;
					}
					global $withrewriting;
					if ($withrewriting  && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$url)) {
						if (!preg_match("#_([0-9])+,([0-9])+.htm#i",$url)) {
							$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$url);
						}
						$variables = "";
					}
					else {
						$trouve = false;
						if (substr_count($url,"?") == 0) {
							$variables = "?";
						}
						else {
							$variables = "&";
						}
						if ($url != "") {
							list($urlseul,$args) = explode("?",$url);
							if ($args != "") {
								$argsT = explode("&",$args);
								foreach ($argsT as $temp) {
									list($key,$val) = explode("=",$temp);
									if ($key==$modmenu["Menu"]) {
										$trouve = true;
									}
								}
							}
						}
						if (!$trouve) {
							$variables .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
						}
						if ($variables == "&" || $variables == "?") {
							$variables = "";
						}
					}
				}
				else {
					$variables = "";
				}
			}
			//$sortie = decalage($niveau);
			$sortie = $this->menuferme();
			$sortie .= "<a href=\"".$url.$variables.$ancre."\"";
			if ($target != "") {
				$sortie .= " target='".$target."'";
			}
			//$nom = str_replace('\n', "<br />", $nom);
			$nom = preg_replace("/(.*)(\\\\n)(.*)/i","\\1<span class=\"l2\">\\3</span>", $nom);
			$sortie .= ">".$nom."</a>";
		}
		else {
			$sortie = "-";
		}
		return $sortie;
	}
	function textemenuferme($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$Myqsl,$modmenu,$icns) {
		if ($nom != "-") {
			if (preg_match("/^#/",$url)) {
				$variables = "";
				$ancre = "";
			}
			else {
				if (!$nomenu) {
					list($url,$ancre) = explode("#",$url);
					if ($ancre != "") {
						$ancre = "#".$ancre;
					}
					global $withrewriting;
					if ($withrewriting  && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$url)) {
						if (!preg_match("#_([0-9])+,([0-9])+.htm#i",$url)) {
							$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$url);
						}
						$variables = "";
					}
					else {
						$trouve = false;
						if (substr_count($url,"?") == 0) {
							$variables = "?";
						}
						else {
							$variables = "&";
						}
						if ($url != "") {
							list($urlseul,$args) = explode("?",$url);
							if ($args != "") {
								$argsT = explode("&",$args);
								foreach ($argsT as $temp) {
									list($key,$val) = explode("=",$temp);
									if ($key==$modmenu["Menu"]) {
										$trouve = true;
									}
								}
							}
						}
						if (!$trouve) {
							$variables .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
						}
						if ($variables == "&" || $variables == "?") {
							$variables = "";
						}
					}
				}
				else {
					$variables = "";
				}
			}
			//$sortie = decalage($niveau);
			$sortie = $this->menuferme();
			$sortie .= "<a href=\"".$url.$variables.$ancre."\"";
			if ($target != "") {
				$sortie .= " target='".$target."'";
			}
			//$nom = str_replace('\n', "<br />", $nom);
			$nom = preg_replace("/(.*)(\\\\n)(.*)/i","\\1<span class=\"l2\">\\3</span>", $nom);
			$sortie .= ">".$nom."</a>";
		}
		else {
			$sortie = "-";
		}
		return $sortie;
	}
/**
* Retourne la racine du menu slectionn
* 
* Pour ce menu, le retour est vide.
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans un tableau HTML
*/
	function racinemenuouvert($modmenu,$icns) {
		$sortie = "";
		
		return $sortie;
	}
/**
* Retourne la racine du menu non slectionn
* 
* Pour ce menu, le retour est vide.
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans un tableau HTML
*/
	function racinemenuferme($modmenu,$icns) {
		$sortie = "";
		
		return $sortie;
	}
}

/**
* Classe d'affichage du chemin de navigation en vertical
* 
* Ce chemin de navigation est fourni sous forme de liste UL. Le nom du menu est affich. Les lment affichs en colonne.
* @package becmsDynMenu
*/
class navigDerouleeV {
/**
* Retourne le menu encod en  HTML
* 
* L'apparence du menu est fixe dans un fichier CSS (NxT1.css, avec x = identifiant unique fix mauellement dans connector_lib.php)
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @param string $titre Intitul du bloc de navigation
* @return string Chaine contenant le code HTML du menu
*/
	function MakePath($Myqsl,$modmenu,$icns,$titre,$lien=""){
		
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		
		
		//open_db($Myqsl);
		
		//recup menus en boucle dans $chemin
		
		if ($lien == "") {
			$lien = "index.php";
		}
		$results = "<ul id=\"navig1\">";
		$results.= "<li class=\"titre\"><div class=\"marge0\"><a href=\"$lien\">$titre</a></div></li>";
		
		if ($Page != "0") {
			$famille = getFamilies($Myqsl,$menu);
			$results .= "<li class=\"l1\"><a href=\"#\" class=\"a1\"><div class=\"marge1\">".$famille[0]["intitule"]."</div></a></li>";
		}
		
		$chemin = getPathMenu($Myqsl,$menu,$Page);
		for ($i=count($chemin); $i>=1;$i--) {
			$tabm = $chemin[$i-1];
			$niveau = count($chemin) - $i + 2;
			$name = $tabm["Name"];
			$url = $tabm["url"];
			$menu = $tabm["idmenu"];
			$lignemenu = $tabm["ID"];
			//$results .= "<li><a href=\"?Page=9,61\" class=\"a1\"><div class=\"marge".(count($chemin) - $i + 2)."\">".$tabm["Name"]."</div></a></li>";
			$results .= $this->textemenu($menu,$lignemenu,$niveau,$name,$url,$Myqsl,$modmenu,$icns);
		}
		
		$results.= "</ul>";
		//close_db($Myqsl);
		
		return $results;
	}
/**
* Retourne une ligne de menu  intgrer dans le chemin
* @param integer $menu Identifiant du menu en cours
* @param integer $lignemenu Identifiant de la ligne de menu en cours
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de chemin formate pour tre incluse dans une liste HTML
*/
	function textemenu($menu,$lignemenu,$niveau, $nom,$url,$Myqsl,$modmenu,$icns) {
		if ($nom != "-") {
			global $withrewriting;
			if ($withrewriting  && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$url)) {
				if (!preg_match("#_([0-9])+,([0-9])+.htm#i",$url)) {
					$url = str_replace(".htm","_".$menu.",".$lignemenu.".htm",$url);
				}
				$variables = "";
			}
			else {
				$trouve = false;
				if (substr_count($url,"?") == 0) {
					$variables = "?";
				}
				else {
					$variables = "&";
				}
				if ($url != "") {
					list($urlseul,$args) = explode("?",$url);
					if ($args != "") {
						$argsT = explode("&",$args);
						foreach ($argsT as $temp) {
							list($key,$val) = explode("=",$temp);
							if ($key==$modmenu["Menu"]) {
								$trouve = true;
							}
						}
					}
				}
				if (!$trouve) {
					//$variables .= $modmenu["Menu"]."=".$modmenu[$modmenu["Encours"]].",".$modmenu[$modmenu["Menu"]];
					$variables .= $modmenu["Menu"]."=".$menu.",".$lignemenu;
				}
				if ($variables == "&" || $variables == "?") {
					$variables = "";
				}
			}
				
			$nom = preg_replace("/(.*)(\\\\n)(.*)/i","\\1<span class=\"l2\">\\3</span>", $nom);
			//$sortie = decalage($niveau);
			$sortie = "<li class=\"l".$niveau."\">";
			$sortie .= "<a href=\"".$url.$variables."\" class=\"a".$niveau."\">";
			$sortie .= "<div class=\"marge".$niveau."\">".$nom."</div>";
			$sortie .= "</a>";
			$sortie .= "</li>";
		}
		else {
			$sortie = "<hr />";
		}
		return $sortie;
	}
/**
* Retourne la racine du menu pour inclusion dans le chemin
* @param array $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de chemin formate pour tre incluse dans une liste HTML
*/
	function racinemenuferme($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		$sortie = "<li class=\"titre\">".$FIntitule."</li>";
		
		return $sortie;
	}
}

class navigArray {
	
	var $tab_menu;
	
/**
* Retourne le tableau de la navigation
* 
* L'apparence du menu est fixe dans un fichier CSS (NxT1.css, avec x = identifiant unique fix mauellement dans connector_lib.php)
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @param string $titre Intitul du bloc de navigation
* @return string Chaine contenant le code HTML du menu
*/
	function MakeTree($Myqsl,$modmenu,$icns){
		
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];

		$this->tab_menu = array();
		
		//recup menus en boucle dans $chemin
		
		if ($lien == "") {
			$lien = "index.php";
		}
		
		if ($Page != "0") {
			$famille = getFamilies($Myqsl,$menu);
			$this->tab_menu[] = array(
					"label" => $famille[0]["intitule"],
					"url" => '',
					"niveau" => '1',
					"target" => '',
					"image" => ''
				);
		}
		
		$chemin = getPathMenu($Myqsl,$menu,$Page);
		for ($i=count($chemin); $i>=1;$i--) {
			$tabm = $chemin[$i-1];
			$niveau = count($chemin) - $i + 2;
			$name = $tabm["Name"];
			$url = $tabm["url"];
			$menu = $tabm["idmenu"];
			$lignemenu = $tabm["ID"];
			$picture = $tabm["picture"];
			$this->tab_menu[] =  $this->textemenu($menu,$lignemenu,$niveau,$name,$url,$Myqsl,$modmenu,$icns,$picture);
		}
		
		return $this->tab_menu;
	}
/**
* Retourne une ligne de menu  intgrer dans le chemin
* @param integer $menu Identifiant du menu en cours
* @param integer $lignemenu Identifiant de la ligne de menu en cours
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de chemin formate pour tre incluse dans une liste HTML
*/
	function textemenu($menu,$lignemenu,$niveau, $nom,$url,$Myqsl,$modmenu,$icns, $picture) {
		if ($nom != "-") {
			global $withrewriting;
			if ($withrewriting  && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$url)) {
				if (!preg_match("#_([0-9])+,([0-9])+.htm#i",$url)) {
					$url = str_replace(".htm","_".$menu.",".$lignemenu.".htm",$url);
				}
				$variables = "";
			}
			else {
				$trouve = false;
				if (substr_count($url,"?") == 0) {
					$variables = "?";
				}
				else {
					$variables = "&";
				}
				if ($url != "") {
					list($urlseul,$args) = explode("?",$url);
					if ($args != "") {
						$argsT = explode("&",$args);
						foreach ($argsT as $temp) {
							list($key,$val) = explode("=",$temp);
							if ($key==$modmenu["Menu"]) {
								$trouve = true;
							}
						}
					}
				}
				if (!$trouve) {
					//$variables .= $modmenu["Menu"]."=".$modmenu[$modmenu["Encours"]].",".$modmenu[$modmenu["Menu"]];
					$variables .= $modmenu["Menu"]."=".$menu.",".$lignemenu;
				}
				if ($variables == "&" || $variables == "?") {
					$variables = "";
				}
			}
				
			/*$nom = preg_replace("/(.*)(\\\\n)(.*)/i","\\1<span class=\"l2\">\\3</span>", $nom);
			//$sortie = decalage($niveau);*/
			
			
			$sortie = array(
				"label" => $nom,
				"url" => $url.$variables,
				"niveau" => $niveau,
				"image" => $picture
			);
		}
		else {
			$sortie = array();;
		}
		return $sortie;
	}
/**
* Retourne la racine du menu pour inclusion dans le chemin
* @param array $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de chemin formate pour tre incluse dans une liste HTML
*/
	function racinemenuferme($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		$sortie = "<li class=\"titre\">".$FIntitule."</li>";
		
		return $sortie;
	}
}

/**
* Classe d'affichage de plan en liste
* 
* Ce plan est fourni sous forme de liste UL. Les lment de tous les niveaux sont affichs en permanence.
* @package becmsDynMenu
*/
class planListe {
/**
* @var integer Identifiant du menu en cours. Vaut 1 par dfaut.
*/
	var $IdMenu;
/**
* Initialise l'identifiant du menu par dfaut  1
*/		
	function planListe() {
		$this->IdMenu = "1";
	} 
/**
* Fixe la valeur de l'identifiant du menu
* @param integer $num Identifiant du menu  afficher
*/	
	function initPlan($num) {
		$this->IdMenu = $num;
	}
/**
* Retourne le menu encod en  HTML
* 
* L'apparence du menu est fixe dans un fichier CSS (PLT1.css)
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Chaine contenant le code HTML du menu
*/
	function MakeTree($Myqsl,$modmenu,$icns){
		
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		
		if ($this->IdMenu != $menu) {
			$menu = $this->IdMenu;
			$Page=0;
		}
		//open_db($Myqsl);
		$sortie = getArrayMenu($Myqsl,$menu);
		$famille = getFamilies($Myqsl,$menu);
		//close_db($Myqsl);
		$table = $sortie["table"];
		$partable = $sortie["partable"];
		$Folder = $sortie["Folder"];
	
		if(!isset($Folder[$Page]["Name"])) {
			$Folder[$Page]["Name"]="Racine menu";
		}
		$Name=$Folder[$Page]["Name"];
		
		$levelexpand=100000;
		$results = $this->racinemenuferme($famille,$modmenu,$icns);
		$results .= $this->TreeExpand(0,$table,$partable,$Folder,$Page,0,$levelexpand,$modmenu,$icns);
		
		$results = '<ul class="plan1">'.$results.'</ul>';
		return $results;
	}
/**
* Fonction interne de dcodage du menu
*/
	function  TreeLevels($Parent,$table,$level){
		$_SESSION["levels"][$Parent]=$level;
		if (count($table) != 0) {
			while(list($key,$val)=each($table[$Parent])) {
				if (isset($table[$key])) {
					$this->TreeLevels($key,$table,$level+1);
				}
			}
		}
		return $_SESSION["levels"];
	}
/**
* Fonction interne de dcodage du menu
*/
	function TreeExpand($Parent,$table,$partable,$Folder0,$Page,$level,$levelexpand,$modmenu,$icns){
		$result='';
		if (count($partable) != 0) {
			$list=$table[$Parent];
			while(list($key,$val)=each($list)){
				if($level<$levelexpand) {
					$result.= $this->textemenuferme($level+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns);
				}
				if (isset($table[$key])) {
					$result.=$this->TreeExpand($key,$table,$partable,$Folder0,$Page,$level+1,$levelexpand,$modmenu,$icns);
				}
			}
		}
		return $result;
	}
/**
* Retourne une image dont la dimension correspond au dcalage du niveau de la ligne du menu
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion d'indentation.
* @param integer $niveau Niveau du menu  afficher
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image de calage
*/
	function decalage($niveau,$icns) {
		$width = ($niveau - 1) * 10;
		$lacale = "<img src='".$icns["menuindent"]."' width='".$width."' height='1'>";
		return $lacale;
	}
/**
* Retourne l'icne de la ligne de menu sur lequel l'utilisateur vient de cliquer
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion de menu ouvert ou ferm.
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image symbolisant un menu ouvert
*/
	function menuouvert($icns) {
		return "<img src='".$icns["menuselected"]."' alt='' width='20' height='20' align='absmiddle'>";
	}
/**
* Retourne l'icne par dfaut des lignes de menu
* 
* Cette mthode n'est pas utilise dans ce type de menu : il n'y a pas de notion de menu ouvert ou ferm.
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image symbolisant un menu ferm
*/
	function menuferme($icns) {
		return "<img src='".$icns["menunotselected"]."' alt='' width='20' height='20' align='absmiddle'>";
	}
/**
* Retourne l'ensemble des variables transmises dans URL sauf celles dsignes dans $sauf
* @param string $sauf Liste des variables  ne pas renvoyer. Le sparateur est "|"
* @return string Toutes les variables mises en forme pour usage dans un URL
*/
	function getVars($sauf) {
		//global $_GET;
		
		$elimines = explode("|",$sauf);
		$args = "";
		$elts = $_GET;
		
		while(list($key, $val) = each($elts)) {
			$ok = true;
			foreach ($elimines as $elimine) {
				if ($elimine == $key) {
					$ok = false;
				}
			}
			if ($ok) {
				if ($args != "") {
					$args .= "&";
				}
				$args .= $key."=".stripslashes($val);
			}
		}
		
	 	return $args;
	}

/**
* Retourne une ligne de menu
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans la liste HTML
*/
	function textemenuferme($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$modmenu,$icns) {
		/*if ($nom != "-") {
			if (!$nomenu) {
				$trouve = false;
				if (substr_count($url,"?") == 0) {
					$variables = "?";
				}
				else {
					$variables = "&";
				}
				if ($url != "") {
					list($urlseul,$args) = explode("?",$url);
					if ($args != "") {
						$argsT = explode("&",$args);
						foreach ($argsT as $temp) {
							list($key,$val) = explode("=",$temp);
							if ($key==$modmenu["Menu"]) {
								$trouve = true;
							}
						}
					}
				}
				if (!$trouve) {
					$variables .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
				}
				if ($variables == "&" || $variables == "?") {
					$variables = "";
				}
			}
			else {
				$variables = "";
			}
			$sortie = "<a href=\"".$url.$variables."\"";
			if ($target != "") {
				$sortie .= " target='".$target."'";
			}
			$sortie .= ">".$nom."</a>";
			$sortie = "<li class=\"N".$niveau."\">".$sortie."</li>";
		}
		else {
			$sortie = "";
		}
		return $sortie;*/
		$nom = str_replace("\\n", " ", $nom);
		if ($nom != "-") {
			if (preg_match("/^#/",$url)) {
				$variables = "";
				$ancre = "";
			}
			else {
				if (!$nomenu) {
					list($url,$ancre) = explode("#",$url);
					if ($ancre != "") {
						$ancre = "#".$ancre;
					}
					$trouve = false;
					if (substr_count($url,"?") == 0) {
						$variables = "?";
					}
					else {
						$variables = "&";
					}
					if ($url != "") {
						list($urlseul,$args) = explode("?",$url);
						if ($args != "") {
							$argsT = explode("&",$args);
							foreach ($argsT as $temp) {
								list($key,$val) = explode("=",$temp);
								if ($key==$modmenu["Menu"]) {
									$trouve = true;
								}
							}
						}
					}
					if (!$trouve) {
						$variables .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
					}
					if ($variables == "&" || $variables == "?") {
						$variables = "";
					}
				}
				else {
					$variables = "";
				}
			}
			$sortie .= "<a href=\"".$url.$variables.$ancre."\"";
			if ($target != "") {
				$sortie .= " target='".$target."'";
			}
			$sortie .= ">".$nom."</a>";
			$sortie = "<li class=\"N".$niveau."\">".$sortie."</li>";
		}
		else {
			$sortie = "--";
			$sortie = "<li class=\"N".($niveau*100)."\">".$sortie."</li>";
		}
		
		return $sortie;
	}

/**
* Retourne la racine du menu non slectionn
* @param array $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans une liste HTML
*/
	function racinemenuferme($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		//$sortie = "<tr><td>".$FIntitule."</td></tr>";
		$sortie = "<li class=\"N0\">".$FIntitule."</li>";
		
		return $sortie;
	}
}

/**
* Classe de rcupration des lments constitutifs d'un menu
* 
* Ces lments sont fournis dans un tableau PHP. Les lment de tous les niveaux sont renvoys en permanence.
* @package becmsDynMenu
*/
class menuElements {
/**
* @var integer Identifiant du menu en cours. Vaut 1 par dfaut.
*/
	var $IdMenu;
	var $tab_menu;
/**
* Initialise l'identifiant du menu par dfaut  1
*/		
	function menuElements() {
		$this->IdMenu = "1";
		$this->tab_menu = array();
	} 
/**
* Fixe la valeur de l'identifiant du menu
* @param integer $num Identifiant du menu  afficher
*/	
	function initMenu($num) {
		$this->IdMenu = $num;
	}
/**
* Retourne le menu encod en  HTML
* 
* L'apparence du menu est fixe dans un fichier CSS (PLT1.css)
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Chaine contenant le code HTML du menu
*/
	function MakeTree($Myqsl,$modmenu,$icns){
		
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		
		if ($this->IdMenu != $menu) {
			$menu = $this->IdMenu;
			$Page=0;
		}
		//open_db($Myqsl);
		$sortie = getArrayMenu($Myqsl,$menu);
		$famille = getFamilies($Myqsl,$menu);
		//close_db($Myqsl);
		$table = $sortie["table"];
		$partable = $sortie["partable"];
		$Folder = $sortie["Folder"];
	
		if(!isset($Folder[$Page]["Name"])) {
			$Folder[$Page]["Name"]="Racine menu";
		}
		$Name=$Folder[$Page]["Name"];
		
		$levelexpand=100000;
		$titre = $this->racinemenuferme($famille,$modmenu,$icns);
		$this->TreeExpand(0,$table,$partable,$Folder,$Page,0,$levelexpand,$modmenu,$icns);
		$lignes = $this->tab_menu;
		$results = array("Id" => $this->IdMenu, "titre" => $titre, "lignemenu" => $lignes);
		return $results;
	}


/**
* Fonction interne de dcodage du menu
*/
	function TreeExpand($Parent,$table,$partable,$Folder0,$Page,$level,$levelexpand,$modmenu,$icns){
		$result='';
		if (count($partable) != 0) {
			$list=$table[$Parent];
			while(list($key,$val)=each($list)){
				if($level<$levelexpand) {
					array_push($this->tab_menu,$this->textemenuferme($level+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns));
				}
				if (isset($table[$key])) {
					$this->TreeExpand($key,$table,$partable,$Folder0,$Page,$level+1,$levelexpand,$modmenu,$icns);
				}
			}
		}
	}

/**
* Retourne l'ensemble des variables transmises dans URL sauf celles dsignes dans $sauf
* @param string $sauf Liste des variables  ne pas renvoyer. Le sparateur est "|"
* @return string Toutes les variables mises en forme pour usage dans un URL
*/
	function getVars($sauf) {
		//global $_GET;
		
		$elimines = explode("|",$sauf);
		$args = "";
		$elts = $_GET;
		
		while(list($key, $val) = each($elts)) {
			$ok = true;
			foreach ($elimines as $elimine) {
				if ($elimine == $key) {
					$ok = false;
				}
			}
			if ($ok) {
				if ($args != "") {
					$args .= "&";
				}
				$args .= $key."=".stripslashes($val);
			}
		}
		
	 	return $args;
	}

/**
* Retourne une ligne de menu
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans la liste HTML
*/
	function textemenuferme($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$modmenu,$icns) {
	
		if ($nom != "-") {
			if (preg_match("/^#/",$url)) {
				$variables = "";
				$ancre = "";
			}
			else {
				if (!$nomenu) {
					global $withrewriting;
					if ($withrewriting && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$url)) {
						if (!preg_match("#_([0-9])+,([0-9])+.htm#i",$url)) {
							$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$url);
						}
					}
					else {
						list($url,$ancre) = explode("#",$url);
						if ($ancre != "") {
							$ancre = "#".$ancre;
						}
						$trouve = false;
						if (substr_count($url,"?") == 0) {
							$variables = "?";
						}
						else {
							$variables = "&";
						}
						if ($url != "") {
							list($urlseul,$args) = explode("?",$url);
							if ($args != "") {
								$argsT = explode("&",$args);
								foreach ($argsT as $temp) {
									list($key,$val) = explode("=",$temp);
									if ($key==$modmenu["Menu"]) {
										$trouve = true;
									}
								}
							}
						}
						if (!$trouve) {
							$variables .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
						}
						if ($variables == "&" || $variables == "?") {
							$variables = "";
						}
					}
				}
				else {
					$variables = "";
				}
			}
			$lien = "<a href=\"".$url.$variables.$ancre."\"";
			if ($target != "") {
				$lien .= " target='".$target."'";
			}
			$lien .= ">".$nom."</a>";
			
			//$lien = "<li class=\"N".$niveau."\">".$lien."</li>";
			
			$ligne = array(
				"lien" => $lien,
				"niveau" => $niveau
			);
		}
		else {
			$ligne = array(
				"lien" => "&nbsp;",
				"niveau" => $niveau
			);
		}
		
		return $ligne;
	}
	
	

/**
* Retourne la racine du menu non slectionn
* @param array $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans une liste HTML
*/
	function racinemenuferme($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		$sortie =$FIntitule;
		
		return $sortie;
	}
}

class menuArray {
/**
* @var integer Identifiant du menu en cours. Vaut 1 par dfaut.
*/
	var $IdMenu;
	var $tab_menu;
	var $with_empty_lines;
/**
* Initialise l'identifiant du menu par dfaut  1
*/		
	function menuArray() {
		$this->IdMenu = "1";
		$this->tab_menu = array();
		$this->with_empty_lines = false;
	} 
/**
* Fixe la valeur de l'identifiant du menu
* @param integer $num Identifiant du menu  afficher
*/	
	function initMenu($num, $emptylines = false) {
		$this->IdMenu = $num;
		$this->with_empty_lines = $emptylines;
	}
/**
* Retourne le menu encod en  HTML
* 
* L'apparence du menu est fixe dans un fichier CSS (PLT1.css)
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Chaine contenant le code HTML du menu
*/
	function MakeTree($Myqsl,$modmenu,$icns){
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		
		if ($this->IdMenu != $menu) {
			$menu = $this->IdMenu;
			$Page=0;
		}
		//open_db($Myqsl);
		$sortie = getArrayMenu($Myqsl,$menu);
		$famille = getFamilies($Myqsl,$menu);
		//close_db($Myqsl);
		$table = $sortie["table"];
		$partable = $sortie["partable"];
		$Folder = $sortie["Folder"];
	
		if(!isset($Folder[$Page]["Name"])) {
			$Folder[$Page]["Name"]="Racine menu";
		}
		$Name=$Folder[$Page]["Name"];
		
		$levelexpand=100000;
		$titre = $this->racinemenuferme($famille,$modmenu,$icns);
		$this->TreeExpand(0,$table,$partable,$Folder,$Page,0,$levelexpand,$modmenu,$icns);
		$lignes = $this->tab_menu;
		$results = array("Id" => $this->IdMenu, "titre" => $titre, "lignemenu" => $lignes);
		return $results;
	}


/**
* Fonction interne de dcodage du menu
*/
	function TreeExpand($Parent,$table,$partable,$Folder0,$Page,$level,$levelexpand,$modmenu,$icns){
		$result='';
		if (count($partable) != 0) {
			$list=$table[$Parent];
			while(list($key,$val)=each($list)){
				if($level<$levelexpand) {
					$temp = $this->textemenuferme($level+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns,$Folder0[$key]["picture"]);
					if (is_array($temp)) {
						array_push($this->tab_menu, $temp);
					}
				}
				if (isset($table[$key])) {
					$this->TreeExpand($key,$table,$partable,$Folder0,$Page,$level+1,$levelexpand,$modmenu,$icns);
				}
			}
		}
	}

/**
* Retourne l'ensemble des variables transmises dans URL sauf celles dsignes dans $sauf
* @param string $sauf Liste des variables  ne pas renvoyer. Le sparateur est "|"
* @return string Toutes les variables mises en forme pour usage dans un URL
*/
	function getVars($sauf) {
		//global $_GET;
		
		$elimines = explode("|",$sauf);
		$args = "";
		$elts = $_GET;
		
		while(list($key, $val) = each($elts)) {
			$ok = true;
			foreach ($elimines as $elimine) {
				if ($elimine == $key) {
					$ok = false;
				}
			}
			if ($ok) {
				if ($args != "") {
					$args .= "&";
				}
				$args .= $key."=".stripslashes($val);
			}
		}
		
	 	return $args;
	}

/**
* Retourne une ligne de menu
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans la liste HTML
*/
	function textemenuferme($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$modmenu,$icns, $picture) {
	
		if ($nom != "-") {
			if (preg_match("/^#/",$url)) {
				$variables = "";
				$ancre = "";
			}
			else {
				if (!$nomenu) {
					global $withrewriting;
					if ($withrewriting && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$url)) {
						if (!preg_match("#_([0-9])+,([0-9])+.htm#i",$url)) {
							$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$url);
						}
					}
					else {
						list($url,$ancre) = explode("#",$url);
						if ($ancre != "") {
							$ancre = "#".$ancre;
						}
						$trouve = false;
						if (substr_count($url,"?") == 0) {
							$variables = "?";
						}
						else {
							$variables = "&";
						}
						if ($url != "") {
							list($urlseul,$args) = explode("?",$url);
							if ($args != "") {
								$argsT = explode("&",$args);
								foreach ($argsT as $temp) {
									list($key,$val) = explode("=",$temp);
									if ($key==$modmenu["Menu"]) {
										$trouve = true;
									}
								}
							}
						}
						if (!$trouve) {
							$variables .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
						}
						if ($variables == "&" || $variables == "?") {
							$variables = "";
						}
					}
				}
				else {
					$variables = "";
				}
			}
			/*$lien = "<a href=\"".$url.$variables.$ancre."\"";
			if ($target != "") {
				$lien .= " target='".$target."'";
			}
			$lien .= ">".$nom."</a>";*/
			
			//$lien = "<li class=\"N".$niveau."\">".$lien."</li>";
			
			$ligne = array(
				"label" => $nom,
				"url" => $url.$variables.$ancre,
				"niveau" => $niveau,
				"target" => $target,
				"image" => $picture,
				"id" => $noeud
			);
		}
		else {
			if ($this->with_empty_lines) {
				$ligne = array(
					"label" => $nom,
					"url" => "",
					"niveau" => $niveau,
					"target" => "",
					"image" => $picture,
					"id" => $noeud
				);
			}
			else {
				$ligne = "";
			}
		}
		
		return $ligne;
	}
/**
* Retourne la racine du menu non slectionn
* @param array $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans une liste HTML
*/
	function racinemenuferme($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		$sortie =$FIntitule;
		
		return $sortie;
	}
}

class menuArrayPlan {
	/**
	 * @var integer Identifiant du menu en cours. Vaut 1 par dfaut.
	 */
	var $IdMenu;
	var $tab_menu;
	/**
	 * Initialise l'identifiant du menu par dfaut  1
	 */
	function menuArrayPlan() {
		$this->IdMenu = "1";
		$this->tab_menu = array();
	}
	/**
	 * Fixe la valeur de l'identifiant du menu
	 * @param integer $num Identifiant du menu  afficher
	 */
	function initMenu($num) {
		$this->IdMenu = $num;
	}
	/**
	 * Retourne le menu encod en  HTML
	 *
	 * L'apparence du menu est fixe dans un fichier CSS (PLT1.css)
	 * @param array $Myqsl Paramtres de la base de donnes
	 * @param array $modmenu Tableau des valeurs pour afficher un menu
	 * @param array $icns Tableau des icnes  afficher pour la manipulation des menus
	 * @return string Chaine contenant le code HTML du menu
	 */
	function MakeTree($Myqsl,$modmenu,$icns){
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];

		if ($this->IdMenu != $menu) {
			$menu = $this->IdMenu;
			$Page=0;
		}
		//open_db($Myqsl);
		$sortie = getArrayMenuPlan($Myqsl);
		$famille = getFamilies($Myqsl,$menu);
		//close_db($Myqsl);
		$table = $sortie["table"];
		$partable = $sortie["partable"];
		$Folder = $sortie["Folder"];

		if(!isset($Folder[$Page]["Name"])) {
			$Folder[$Page]["Name"]="Racine menu";
		}
		$Name=$Folder[$Page]["Name"];

		$levelexpand=100000;
		$titre = $this->racinemenuferme($famille,$modmenu,$icns);
		$this->TreeExpand(0,$table,$partable,$Folder,$Page,0,$levelexpand,$modmenu,$icns);
		$lignes = $this->tab_menu;
		$results = array("Id" => $this->IdMenu, "titre" => $titre, "lignemenu" => $lignes);
		return $results;
	}


	/**
	 * Fonction interne de dcodage du menu
	 */
	function TreeExpand($Parent,$table,$partable,$Folder0,$Page,$level,$levelexpand,$modmenu,$icns){
		$result='';
		if (count($partable) != 0) {
			$list=$table[$Parent];
			if($list) {
				while(list($key,$val)=each($list)){
					if($level<$levelexpand) {
						$temp = $this->textemenuferme($level+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$modmenu,$icns,$Folder0[$key]["picture"],$Folder0[$key]["pos_plan"]);
						if (is_array($temp)) {
							array_push($this->tab_menu, $temp);
						}
					}
					if (isset($table[$key])) {
						$this->TreeExpand($key,$table,$partable,$Folder0,$Page,$level+1,$levelexpand,$modmenu,$icns);
					}
				}
			}
		}
	}

	/**
	 * Retourne l'ensemble des variables transmises dans URL sauf celles dsignes dans $sauf
	 * @param string $sauf Liste des variables  ne pas renvoyer. Le sparateur est "|"
	 * @return string Toutes les variables mises en forme pour usage dans un URL
	 */
	function getVars($sauf) {
		//global $_GET;

		$elimines = explode("|",$sauf);
		$args = "";
		$elts = $_GET;

		while(list($key, $val) = each($elts)) {
			$ok = true;
			foreach ($elimines as $elimine) {
				if ($elimine == $key) {
					$ok = false;
				}
			}
			if ($ok) {
				if ($args != "") {
					$args .= "&";
				}
				$args .= $key."=".stripslashes($val);
			}
		}

		return $args;
	}

	/**
	 * Retourne une ligne de menu
	 * @param integer $niveau Niveau hirachique de la ligne de menu en en cours
	 * @param integer $noeud Identifiant de la ligne de menu en cours
	 * @param string $nom Texte de la ligne de menu en cours
	 * @param string $url URL de la ligne de menu en cours
	 * @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
	 * @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
	 * @param integer $idmenu Identifiant du menu en cours
	 * @param array $modmenu Tableau des valeurs pour afficher un menu
	 * @param array $icns Tableau des icnes  afficher pour la manipulation des menus
	 * @return string Toute la ligne de menu formate pour tre incluse dans la liste HTML
	 */
	function textemenuferme($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$modmenu,$icns, $picture, $pos_plan) {

		if ($nom != "-") {
			if (preg_match("/^#/",$url)) {
				$variables = "";
				$ancre = "";
			}
			else {
				if (!$nomenu) {
					global $withrewriting;
					if ($withrewriting && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$url)) {
						if (!preg_match("#_([0-9])+,([0-9])+.htm#i",$url)) {
							$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$url);
						}
					}
					else {
						list($url,$ancre) = explode("#",$url);
						if ($ancre != "") {
							$ancre = "#".$ancre;
						}
						$trouve = false;
						if (substr_count($url,"?") == 0) {
							$variables = "?";
						}
						else {
							$variables = "&";
						}
						if ($url != "") {
							list($urlseul,$args) = explode("?",$url);
							if ($args != "") {
								$argsT = explode("&",$args);
								foreach ($argsT as $temp) {
									list($key,$val) = explode("=",$temp);
									if ($key==$modmenu["Menu"]) {
										$trouve = true;
									}
								}
							}
						}
						if (!$trouve) {
							$variables .= $modmenu["Menu"]."=".$idmenu.",".$noeud;
						}
						if ($variables == "&" || $variables == "?") {
							$variables = "";
						}
					}
				}
				else {
					$variables = "";
				}
			}
			/*$lien = "<a href=\"".$url.$variables.$ancre."\"";
			 if ($target != "") {
			$lien .= " target='".$target."'";
			}
			$lien .= ">".$nom."</a>";*/
				
			//$lien = "<li class=\"N".$niveau."\">".$lien."</li>";
				
			$ligne = array(
					"label" => $nom,
					"url" => $url.$variables.$ancre,
					"niveau" => $niveau,
					"target" => $target,
					"image" => $picture,
					"id" => $noeud,
					"pos_plan" => $pos_plan
			);
		}
		else {
			$ligne = "";
		}

		return $ligne;
	}
	/**
	 * Retourne la racine du menu non slectionn
	 * @param array $famille Nom du menu
	 * @param array $modmenu Tableau des valeurs pour afficher un menu
	 * @param array $icns Tableau des icnes  afficher pour la manipulation des menus
	 * @return string Toute la ligne de la racine du menu formate pour tre incluse dans une liste HTML
	 */
	function racinemenuferme($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		$sortie =$FIntitule;

		return $sortie;
	}
}

class menuXML {
/**
* @var integer Identifiant du menu en cours. Vaut 1 par dfaut.
*/		
	var $IdMenu;
/**
* Initialise l'identifiant du menu par dfaut  1
*/
	function menuDeroulantVUnique() {
		$this->IdMenu = "1";
	}
/**
* Fixe la valeur de l'identifiant du menu
* @param integer $num Identifiant du menu  afficher
*/
	function initMenu($num) {
		$this->IdMenu = $num;
	}
/**
* Retourne le menu encod en  HTML
* 
* L'apparence du menu est fixe dans un fichier CSS (MxT9, avec x = IdMenu)
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Chaine contenant le code HTML du menu
*/	
	function MakeTree($Myqsl,$modmenu,$icns){
		
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		
		if ($this->IdMenu != $menu) {
			$menu = $this->IdMenu;
			$Page=0;
		}
		
		$sortie = getArrayMenu($Myqsl,$menu);
		$famille = getFamilies($Myqsl,$menu);
		$table = $sortie["table"];
		$partable = $sortie["partable"];
		$Folder = $sortie["Folder"];
	
		$levels=$this->TreeLevels(0,$table,0);
		if(!isset($Folder[$Page]["Name"])) {
			$Folder[$Page]["Name"]="Racine menu";
		}
		$Name=$Folder[$Page]["Name"];
		$levelexpand=100000;
		$results = "\n<menu id=\"$menu\">";
		$results .= $this->racinemenuouvert($famille,$modmenu,$icns);
		$results .= "\n<lignes>";
		$results .= $this->TreeExpand(0,$table,$partable,$Folder,$Page,0,$levelexpand,$Myqsl,$modmenu,$icns);
		$results .= "\n</lignes>";
		$results.= "\n</menu>";
		
		return $results;
	}
/**
* Fonction interne de dcodage du menu
*/
	function  TreeLevels($Parent,$table,$level){
		$_SESSION["levels"][$Parent]=$level;
		if (count($table) != 0) {
			while(list($key,$val)=each($table[$Parent])) {
				if (isset($table[$key])) {
					$this->TreeLevels($key,$table,$level+1);
				}
			}
		}
		return $_SESSION["levels"];
	}
/**
* Fonction interne de dcodage du menu
*/
	function TreeExpand($Parent,$table,$partable,$Folder0,$Page,$level,$levelexpand,$Myqsl,$modmenu,$icns) {
		$result='';
		if (count($partable) != 0) {
			$list=$table[$Parent];
			while(list($key,$val)=each($list)){
				$temp = "";
				if (isset($table[$key])) {
					if ($Page == $Folder0[$key]["ID"]) {
						$temp .= "\n<lignes>";
					}
					else {
						$temp .= "\n<lignes>";
					}
					$temp .= $this->TreeExpand($key,$table,$partable,$Folder0,$Page,$level+1,$levelexpand,$Myqsl,$modmenu,$icns);
					$temp .= "\n</lignes>";
				}
				if ($level < $levelexpand) {
					if (($Page == $Folder0[$key]["ID"]) || stripos($temp,'current="true"')) {
						$result .= "\n<ligne id=\"".$Folder0[$key]["ID"]."\" current=\"true\">";
					}
					else {
						$result .= "\n<ligne id=\"".$Folder0[$key]["ID"]."\" current=\"false\">";
					}
					$result .= $this->textemenuferme($level+1,$Folder0[$key]["ID"],$Folder0[$key]["Name"],$Folder0[$key]["url"],$Folder0[$key]["target"],$Folder0[$key]["nomenu"],$Folder0[$key]["idmenu"],$Myqsl,$modmenu,$icns);
				}
				$result .= $temp;
				$result .= "\n</ligne>";
			}
		}
		return $result;
	}
/**
* Retourne l'ensemble des variables transmises dans URL sauf celles dsignes dans $sauf
* @param string $sauf Liste des variables  ne pas renvoyer. Le sparateur est "|"
* @return string Toutes les variables mises en forme pour usage dans un URL
*/
	function getVars($sauf) {
		//global $_GET;
		
		$elimines = explode("|",$sauf);
		$args = "";
		$elts = $_GET;
		
		while(list($key, $val) = each($elts)) {
			$ok = true;
			foreach ($elimines as $elimine) {
				if ($elimine == $key) {
					$ok = false;
				}
			}
			if ($ok) {
				if ($args != "") {
					$args .= "&";
				}
				$args .= $key."=".stripslashes($val);
			}
		}
		
	 	return $args;
	}
/**
* Retourne une ligne de menu
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $position position de la ligne de menu en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans une liste HTML
*/
	function textemenuferme($niveau,$noeud,$nom,$url,$target,$nomenu,$idmenu,$Myqsl,$modmenu,$icns) {
		if ($nom != "-") {
			if ($url != "#") {
				if (preg_match("/^#/",$url)) {
					global $withrewriting;
					if ($withrewriting && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$_SERVER["REDIRECT_URL"])) {
						if (preg_match("#_([0-9])+,([0-9])+\.htm#i",$_SERVER["REDIRECT_URL"])) {
							$url = preg_replace("#_([0-9])+,([0-9])+\.htm#i","_".$idmenu.",".$noeud.".htm",$_SERVER["REDIRECT_URL"]).$url;
						}
						else {
							$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$_SERVER["REDIRECT_URL"]).$url;
						}
					}
					else {
						$variables = "";
						$ancre = "";
						$sauf = $modmenu["Menu"]."|Id";
						$variablessauf = "?".$variablessauf.$modmenu["Menu"]."=".$idmenu.",".$noeud;
						$urlseul = "";
						
						$variables = $this->getVars($sauf);
						if ($variables != "") {
							$variables = "&".$variables;
						}
						$variables = $variablessauf.$variables;
						$url = $urlseul.$variables;
					}
				}
				else {
					if (!$nomenu) {
						global $withrewriting;
						if ($withrewriting && preg_match("#(".$modmenu["url_court"].")(.*)\.htm#i",$url)) {
							if (!preg_match("#_([0-9])+,([0-9])+.htm#i",$url)) {
								$url = str_replace(".htm","_".$idmenu.",".$noeud.".htm",$url);
							}
						}
						else {
							$sauf = "";
							$variablessauf = "";
							$urlseul = "";
							if ($url != "") {
								list($urlseul,$args) = explode("?",$url);
								if ($args != "") {
									$argsT = explode("&",$args);
									foreach ($argsT as $temp) {
										list($key,$val) = explode("=",$temp);
										$sauf .= $key."|";
										$variablessauf .= $key."=".$val."&";
									}
								}
							}
							$sauf .= $modmenu["Menu"]."|Id";
							$variablessauf = "?".$variablessauf.$modmenu["Menu"]."=".$idmenu.",".$noeud;
							
							$variables = $this->getVars($sauf);
							if ($variables != "") {
								$variables = "&".$variables;
							}
							$variables = $variablessauf.$variables;
							$url = $urlseul.$variables;
						}
					}
				}
			}
			
			$sortie .= "\n<intitule><![CDATA[".html_entity_decode($nom,ENT_QUOTES,"UTF-8")."]]></intitule>";
			$sortie .= "\n<pageLink><![CDATA[".html_entity_decode($url,ENT_QUOTES,"UTF-8")."]]></pageLink>";
			$sortie .= "\n<target><![CDATA[".html_entity_decode($target,ENT_QUOTES,"UTF-8")."]]></target>";
		}
		else {
			$sortie .= "\n<intitule><![CDATA[--]]></intitule>";
			$sortie .= "\n<pageLink><![CDATA[]]></pageLink>";
			$sortie .= "\n<target><![CDATA[]]></target>";
		}
		return $sortie;
	}
/**
* Retourne la racine du menu slectionn
* 
* Pour ce menu, le retour est vide.
* @param array $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans un tableau HTML
*/
	function racinemenuouvert($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		$sortie = "\n<titre>".$FIntitule."</titre>";
		
		return $sortie;
	}
/**
* Retourne la racine du menu non slectionn
* @param array $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans une liste HTML
*/
	function racinemenuferme($famille,$modmenu,$icns) {
		$untype = $famille[0];
		$FIntitule = $untype["intitule"];
		$sortie = "\n<titre><![CDATA[".$FIntitule."]]></titre>";
		
		return $sortie;
	}
}

?>
