<?php
/**
* Classes d'administration du module de menu.
* 
* @package becmsDynMenu
* @version 1.2
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2006, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
* @todo prvisualisation du menu dfectueux avec les survols sous IE
*/

/**
* Classe permettant de manipuler le menu.
* @package becmsDynMenu
*/
class adminMenu {
/**
* @var integer Identifiant du menu en cours. Vaut 1 par dfaut.
*/
	var $IdMenu;
/**
* @var string Paramtres supplmentaires au fonctionnement du menu formats pour un URL
*/
	var $varsenplus;

/**
* Initialise l'identifiant du menu par dfaut  1
*/
	function adminMenu() {
		$this->IdMenu = "1";
	}
/**
* Fixe les variables reues dans l'URL hors variables du module becmsDynMenu
* @param array $modmenu Tableau des valeurs pour afficher un menu
*/
	function init($modmenu) {
		$this->varsenplus = $this->getVars($modmenu["Menu"] . "|" . $modmenu["Operation"] . "|" . $modmenu["Etat"]);
		if ($this->varsenplus != "") {
			$this->varsenplus = "&" . $this->varsenplus;
		}
	}
/**
* Retourne le menu mis en forme pour sa gestion
* @param array $Myqsl Paramtres de la base de donnes
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Chaine contenant le tableau HTML de gestion du menu
*/
	function MakeTree($Myqsl, $modmenu, $icns) {

		$this->init($modmenu);

		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		$openall = $modmenu[$modmenu["Etat"]];

		if ($this->IdMenu != $menu) {
			$menu = $this->IdMenu;
			$Page = 0;
		}

		$sortie = getArrayMenu($Myqsl, $menu);
		$table = $sortie["table"];
		$partable = $sortie["partable"];
		$Folder = $sortie["Folder"];

		$famille = getFamilies($Myqsl, $menu);

		$levels = $this->TreeLevels(0, $table, 0);
		if (!isset ($Folder[$Page]["Name"])) {
			$Folder[$Page]["Name"] = _EDITMENUSROOT;
		}
		$Name = $Folder[$Page]["Name"];
		if ($Page == 0) {
			if (!isset ($_SESSION["expandtree"])) {
				$_SESSION["expandtree"] = 1;
			}
			$levelexpand = 1;
			if ($openall == "1") {
				$levelexpand = 100000;
			}
			$results = $this->racinemenuouvert($menu, $famille, $modmenu, $icns);
			$results .= $this->TreeExpand(0, $table, $partable, $Folder, $Page, 0, $levelexpand, $modmenu, $icns);
		} else {
			$results = $this->racinemenuferme($menu, $famille, $modmenu, $icns);
			$ID = $Page;
			$results .= $this->TreeNodes($ID, $table, $partable, $Folder, $Page, $levels, $modmenu, $icns);
			$_SESSION["expandtree"] = 1;
		}
		/*
		$resultsS = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"tabadmin\"><tr><th>Arborescence</th>";
		if ($modmenu[$modmenu["View"]] == 1) {
			$resultsS .= "<th>URL combin&eacute;</th><th>Id</th>";
		}
		$resultsS .= "<th  width=\"160\">Actions</th></tr>" . $results;
		$resultsS .= "</table>";*/
		$resultsS = "<table class=\"lisTable\" ><tr class=systemTabHeader><th>"._EDITMENUSARBO."</th>";
		if ($modmenu[$modmenu["View"]] == 1) {
			$resultsS .= "<th>"._EDITMENUSURL."</th><th>"._EDITMENUSID."</th>";
		}
		$resultsS .= "<th  width=\"160\">"._EDITMENUSACTIONS."</th></tr>" . $results;
		$resultsS .= "</table>";
		
		return $resultsS;
	}
/**
* Fonction interne de dcodage du menu
*/
	function TreeLevels($Parent, $table, $level) {
		$_SESSION["levels"][$Parent] = $level;
		if (count($table) != 0) {
			while (list ($key, $val) = each($table[$Parent])) {
				if (isset ($table[$key])) {
					$this->TreeLevels($key, $table, $level +1);
				}
			}
		}
		return $_SESSION["levels"];
	}
/**
* Fonction interne de dcodage du menu
*/
	function TreeNodes($ID, $table, $partable, $Folder0, $Page, $levels, $modmenu, $icns) {
		$rez0 = "";
		if (isset ($table[$ID])) {
			$lisd = $table[$ID];
			$ID0 = $ID;
			$fiplevel = $levels[$ID];
			while (list ($key, $val) = each($lisd)) {
				if ($Page == $key) {
					$rez0 .= $this->textemenuouvert($levels[$ID] + 1, $Folder0[$key]["ID"], $Folder0[$key]["Name"], $Folder0[$key]["url"], $Folder0[$key]["target"], $Folder0[$key]["nomenu"], $Folder0[$key]["position"], $Folder0[$key]["idmenu"], $modmenu, $icns);
				} else {
					$rez0 .= $this->textemenuferme($levels[$ID] + 1, $Folder0[$key]["ID"], $Folder0[$key]["Name"], $Folder0[$key]["url"], $Folder0[$key]["target"], $Folder0[$key]["nomenu"], $Folder0[$key]["position"], $Folder0[$key]["idmenu"], $modmenu, $icns);
				}
			}
		}
		$res = "";
		while ($ID != 0) {
			$fip = $partable[$ID];
			$fiplevel = $levels[$fip];
			$fiplist = $table[$fip];
			$rez = "";
			while (list ($key, $val) = each($fiplist)) {
				if ($Page == $key) {
					$rez .= $this->textemenuouvert($fiplevel +1, $Folder0[$key]["ID"], $Folder0[$key]["Name"], $Folder0[$key]["url"], $Folder0[$key]["target"], $Folder0[$key]["nomenu"], $Folder0[$key]["position"], $Folder0[$key]["idmenu"], $modmenu, $icns);
					$rez .= $rez0;
				} else {
					$rez .= $this->textemenuferme($fiplevel +1, $Folder0[$key]["ID"], $Folder0[$key]["Name"], $Folder0[$key]["url"], $Folder0[$key]["target"], $Folder0[$key]["nomenu"], $Folder0[$key]["position"], $Folder0[$key]["idmenu"], $modmenu, $icns);
				}
				if ($ID == $key) {
					$rez .= $res;
					$res = "";
				}
			}
			$res .= $rez;
			$ID = $partable[$ID];
		}
		return $rez;
	}
/**
* Fonction interne de dcodage du menu
*/
	function TreeExpand($Parent, $table, $partable, $Folder0, $Page, $level, $levelexpand, $modmenu, $icns) {
		$result = '';
		if (count($partable) != 0) {
			$list = $table[$Parent];
			while (list ($key, $val) = each($list)) {
				if ($level < $levelexpand) {
					$result .= $this->textemenuferme($level +1, $Folder0[$key]["ID"], $Folder0[$key]["Name"], $Folder0[$key]["url"], $Folder0[$key]["target"], $Folder0[$key]["nomenu"], $Folder0[$key]["position"], $Folder0[$key]["idmenu"], $modmenu, $icns);
				}
				if (isset ($table[$key])) {
					$result .= $this->TreeExpand($key, $table, $partable, $Folder0, $Page, $level +1, $levelexpand, $modmenu, $icns);
				}
			}
		}
		return $result;
	}

/**
* Retourne une image dont la dimension correspond au dcalage du niveau de la ligne du menu
* @param integer $niveau Niveau du menu  afficher
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image de calage
*/
	function decalage($niveau, $icns) {
		$width = $niveau * 10;
		$lacale = "<img src='" . $icns["mindent"] . "' width='" . $width . "' height='1'>";
		return $lacale;
	}

/**
* Retourne l'icne de la ligne de menu sur lequel l'utilisateur vient de cliquer
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image symbolisant un menu ouvert
*/
	function menuouvert($icns) {
		return $icns["mselected"] . "&nbsp;";
	}

/**
* Retourne l'icne par dfaut des lignes de menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Image symbolisant un menu ferm
*/
	function menuferme($icns) {
		return $icns["mnotselected"] . "&nbsp;";
	}

/**
* Retourne l'ensemble des boutons qui permettent d'agir sur une ligne de menu particulire
* @param integer $menu Identifiant du menu en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Tous les boutons d'action
*/
	function boutonsactions($menu, $noeud, $modmenu, $icns) {
		$bacts = "<a href=\"?" . $modmenu["Menu"] . "=" . $menu . "," . $noeud . "&" . $modmenu["Operation"] . "=new" . $this->varsenplus . "\">" . $icns["new"] . "</a> ";
		$bacts .= "<a href=\"?" . $modmenu["Menu"] . "=" . $menu . "," . $noeud . "&" . $modmenu["Operation"] . "=edit" . $this->varsenplus . "\">" . $icns["edit"] . "</a> ";
		$bacts .= "<a href=\"?" . $modmenu["Menu"] . "=" . $menu . "," . $noeud . "&" . $modmenu["Operation"] . "=delete" . $this->varsenplus . "\" onclick=\"return confirmsuppr();\">" . $icns["del"] . "</a> ";
		$bacts .= "<a href=\"?" . $modmenu["Menu"] . "=" . $menu . "," . $noeud . "&" . $modmenu["Operation"] . "=upmenu" . $this->varsenplus . "\">" . $icns["upm"] . "</a> ";
		$bacts .= "<a href=\"?" . $modmenu["Menu"] . "=" . $menu . "," . $noeud . "&" . $modmenu["Operation"] . "=downmenu" . $this->varsenplus . "\">" . $icns["downm"] . "</a> ";
		$bacts .= "<a href=\"?" . $modmenu["Menu"] . "=" . $menu . "," . $noeud . "&" . $modmenu["Operation"] . "=uparbmenu" . $this->varsenplus . "\">" . $icns["aupm"] . "</a> ";
		$bacts .= "<a href=\"?" . $modmenu["Menu"] . "=" . $menu . "," . $noeud . "&" . $modmenu["Operation"] . "=downarbmenu" . $this->varsenplus . "\">" . $icns["adownm"] . "</a> ";

		return $bacts;
	}
/**
* Retourne l'ensemble des boutons qui permettent d'agir sur un menu (galement appel la "racine")
* @param integer $idmenu Identifiant du menu en cours
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Tous les boutons d'action
*/
	function boutonRacineAction($idmenu, $modmenu, $icns) {
		$sortie = "<a href=\"?" . $modmenu["Menu"] . "=" . "-1" . ",0&" . $modmenu["Operation"] . "=newmenu" . $this->varsenplus . "\">" . $icns["mnew"] . "</a> ";
		if ($idmenu >= 1) {
			$sortie .= "<a href=\"?" . $modmenu["Menu"] . "=" . $idmenu . ",0&" . $modmenu["Operation"] . "=editmenu" . $this->varsenplus . "\">" . $icns["edit"] . "</a> ";
			$sortie .= "<a href=\"?" . $modmenu["Menu"] . "=" . "$idmenu" . ",0&" . $modmenu["Operation"] . "=delmenu" . $this->varsenplus . "\" onclick=\"return confirmsuppr();\">" . $icns["del"] . "</a> ";
			$sortie .= "<a href=\"?" . $modmenu["Menu"] . "=" . $idmenu . ",0&" . $modmenu["Operation"] . "=new" . $this->varsenplus . "\">" . $icns["new"] . "</a> ";
			$sortie .= "<img src='" . $icns["mindent"] . "' width=\"20\" height=\"20\">";
			$sortie .= "<a href=\"?" . $modmenu["Menu"] . "=" . $idmenu . ",0&" . $modmenu["Etat"] . "=1" . $this->varsenplus . "\">" . $icns["arbo"] . "</a> ";
			$varstabmodif = $this->getVars($modmenu["View"] . "|" . $modmenu["Operation"]);
			if ($varstabmodif != "") {
				$varstabmodif = "&" . $varstabmodif;
			}
			if ($modmenu[$modmenu["View"]] == 1) {
				//$sortie .= "<a href=\"?".$modmenu["Menu"]."=".$idmenu.",".$modmenu[$modmenu["Menu"]]."&".$modmenu["View"]."=0".$this->varsenplus."\">".$icns["tabmoins"]."</a>";
				$sortie .= "<a href=\"?" . $modmenu["View"] . "=0" . $varstabmodif . "\">" . $icns["tabmoins"] . "</a> ";
			} else {
				//$sortie .= "<a href=\"?".$modmenu["Menu"]."=".$idmenu.",".$modmenu[$modmenu["Menu"]]."&".$modmenu["View"]."=1".$this->varsenplus."\">".$icns["tabplus"]."</a>";
				$sortie .= "<a href=\"?" . $modmenu["View"] . "=1" . $varstabmodif . "\">" . $icns["tabplus"] . "</a> ";
			}
		}
		return $sortie;
	}

/**
* Retourne l'ensemble des variables transmises dans URL sauf celles dsignes dans $sauf
* @param string $sauf Liste des variables  ne pas renvoyer. Le sparateur est "|"
* @return string Toutes les variables mises en forme pour usage dans un URL
*/
	function getVars($sauf) {
		//global $_GET;

		$elimines = explode("|", $sauf);
		$args = "";
		$elts = $_GET;

		while (list ($key, $val) = each($elts)) {
			$ok = true;
			foreach ($elimines as $elimine) {
				if ($elimine == $key) {
					$ok = false;
				}
			}
			if ($ok) {
				if ($args != "") {
					$args .= "&";
				}
				$args .= $key . "=" . stripslashes($val);
			}
		}
		return $args;
	}
/**
* Retourne la ligne complte du menu slectionn
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $position position de la ligne de menu en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans un tableau HTML
*/
	function textemenuouvert($niveau, $noeud, $nom, $url, $target, $nomenu, $position, $idmenu, $modmenu, $icns) {
		if ($nom != "-") {
			if (!$nomenu) {
				$trouve = false;
				if (substr_count($url, "?") == 0) {
					$variables = "?";
				} else {
					$variables = "&";
				}
				if ($url != "") {
					list ($urlseul, $args) = explode("?", $url);
					if ($args != "") {
						$argsT = explode("&", $args);
						foreach ($argsT as $temp) {
							list ($key, $val) = explode("=", $temp);
							if ($key == $modmenu["Menu"]) {
								$trouve = true;
							}
						}
					}
				}
				if (!$trouve) {
					$variables .= $modmenu["Menu"] . "=" . $idmenu . "," . $noeud;
				}
				if ($variables == "&" || $variables == "?") {
					$variables = "";
				}
			} else {
				$variables = "";
			}
			$url .= $variables;
		} else {
			$url = "";
		}
		$url_local = "?" . $modmenu["Menu"] . "=" . $idmenu . "," . $noeud;
		$url_local .= $this->varsenplus;

		$sortie = $this->decalage($niveau, $icns);
		$sortie .= $this->menuouvert($icns);
		//$sortie .= "&nbsp;<span style='height: 20px; font: 11px Arial, Helvetica; '>";
		$sortie .= "<a href=\"" . $url_local . "\"";
		$sortie .= "><b>" . $nom . "</b></a>";
		//$sortie .= "</span>";
		if ($modmenu[$modmenu["View"]] == 1) {
			$sortie .= "</td><td>";
			$sortie .= $this->afficheURL($url);
			$sortie .= "</td><td align=\"center\">";
			$sortie .= $noeud;
		}
		$sortie .= "</td><td nowrap width=\"160\">";
		$sortie .= $this->boutonsactions($idmenu, $noeud, $modmenu, $icns);

		return "<tr><td nowrap>" . $sortie . "</td></tr>";
	}
/**
* Retourne la ligne complte d'un menu non slectionn
* @param integer $niveau Niveau hirachique de la ligne de menu en en cours
* @param integer $noeud Identifiant de la ligne de menu en cours
* @param string $nom Texte de la ligne de menu en cours
* @param string $url URL de la ligne de menu en cours
* @param string $target Cible (fentre) de l'URL de la ligne de menu en cours
* @param bool $nomenu Neutralise l'URL et toutes ses variables pour l'excution d'une URL externe au site en cours
* @param integer $position position de la ligne de menu en cours
* @param integer $idmenu Identifiant du menu en cours
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de menu formate pour tre incluse dans un tableau HTML
*/
	function textemenuferme($niveau, $noeud, $nom, $url, $target, $nomenu, $position, $idmenu, $modmenu, $icns) {
		if ($nom != "-") {
			if (!$nomenu) {
				$trouve = false;
				if (substr_count($url, "?") == 0) {
					$variables = "?";
				} else {
					$variables = "&";
				}
				if ($url != "") {
					list ($urlseul, $args) = explode("?", $url);
					if ($args != "") {
						$argsT = explode("&", $args);
						foreach ($argsT as $temp) {
							list ($key, $val) = explode("=", $temp);
							if ($key == $modmenu["Menu"]) {
								$trouve = true;
							}
						}
					}
				}
				if (!$trouve) {
					$variables .= $modmenu["Menu"] . "=" . $idmenu . "," . $noeud;
				}
				if ($variables == "&" || $variables == "?") {
					$variables = "";
				}
			} else {
				$variables = "";
			}
			$url .= $variables;
		} else {
			$url = "";
		}

		$url_local = "?" . $modmenu["Menu"] . "=" . $idmenu . "," . $noeud;
		$url_local .= $this->varsenplus;

		$sortie = $this->decalage($niveau, $icns);
		$sortie .= $this->menuferme($icns);
		//$sortie .= "&nbsp;<span style='height: 20px; font: 11px Arial, Helvetica; '>";
		$sortie .= "<a href=\"" . $url_local . "\"";
		$sortie .= ">" . $nom . "</a>";
		//$sortie .= "</span>";
		if ($modmenu[$modmenu["View"]] == 1) {
			$sortie .= "</td><td>";
			$sortie .= $this->afficheURL($url);
			$sortie .= "</td><td align=\"center\">";
			$sortie .= $noeud;
		}
		$sortie .= "</td><td nowrap width=\"160\">";
		$sortie .= $this->boutonsactions($idmenu, $noeud, $modmenu, $icns);

		return "<tr><td nowrap>" . $sortie . "</td></tr>";
	}
/**
* Retourne la ligne complte de la racine du menu slectionn
* @param integer $idmenu Identifiant du menu
* @param string $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans un tableau HTML
*/
	function racinemenuouvert($idmenu, $famille, $modmenu, $icns) {
		if (count($famille) != 0) {
			$untype = $famille[0];
			$FId = $untype["Id"];
			$FIntitule = $untype["intitule"];
			$FGenre = $untype["genre"];
			$nomTab = _EDITMENUSCURRENT;
		} else {
			$FId = "-1";
			$FIntitule = _EDITMENUSNOEXIST;
			$FGenre = "";
			$nomTab = _EDITMENUSNEW;
		}

		$sortie = $this->menuouvert($icns);
		$sortie .= "<a href=\"?" . $modmenu["Menu"] . "=" . $idmenu . ",0" . $this->varsenplus . "\"><b>" . $FIntitule . "</b></a>";
		if ($modmenu[$modmenu["View"]] == 1) {
			$sortie .= "</td><td>";
			$sortie .= "</td><td align=\"center\">";
			$sortie .= "<b>" . $FId . "</b>";
		}
		$sortie .= "</td><td width=\"160\">";
		$sortie .= $this->boutonRacineAction($idmenu, $modmenu, $icns);
		return "<tr><td nowrap>" . $sortie . "</td></tr>";
	}

/**
* Retourne la ligne complte de la racine du menu non slectionn
* @param integer $idmenu Identifiant du menu
* @param string $famille Nom du menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $icns Tableau des icnes  afficher pour la manipulation des menus
* @return string Toute la ligne de la racine du menu formate pour tre incluse dans un tableau HTML
*/
	function racinemenuferme($idmenu, $famille, $modmenu, $icns) {
		if (count($famille) != 0) {
			$untype = $famille[0];
			$FId = $untype["Id"];
			$FIntitule = $untype["intitule"];
			$FGenre = $untype["genre"];
			$nomTab = EDITMENUSCURRENT;
		} else {
			$FId = "-1";
			$FIntitule = _EDITMENUSNOEXIST;
			$FGenre = "";
			$nomTab = _EDITMENUSNEW;
		}

		$sortie = $this->menuferme($icns);
		$sortie .= "<a href=\"?" . $modmenu["Menu"] . "=" . $idmenu . ",0" . $this->varsenplus . "\"><b>" . $FIntitule . "</b></a>";
		if ($modmenu[$modmenu["View"]] == 1) {
			$sortie .= "</td><td>";
			$sortie .= "</td><td align=\"center\">";
			$sortie .= "<b>" . $FId . "</b>";
		}
		$sortie .= "</td><td width=\"160\">";
		$sortie .= $this->boutonRacineAction($idmenu, $modmenu, $icns);

		return "<tr><td nowrap>" . $sortie . "</td></tr>";
	}

/**
* Retourne l'URL format pour un affichage de dtail de la ligne du menu
* @param string $url URL de la ligne de menu en cours
* @return string URL formate pour tre incluse dans un tableau HTML
*/
	function afficheURL($url) {
		$url = nl2br(htmlentities(str_replace("?", "\n?", str_replace("&", "\n&", $url)), ENT_QUOTES, "ISO-8859-1"));
		$saut = nl2br("\n");
		if (substr($url, 0, strlen($saut)) == $saut) {
			$url = substr($url, strlen($saut));
		}
		return $url;
	}

	// Partie gestion du Menu

/**
* Retourne le contenu en tableau HTML pour amliorer la prsentation
* 
* Ce tableau est celui qui contient les formulaires de modification des menus
* @param string $nomtab Nom du tableau
* @param string $contenu Contenu du tableau
* @return string Chaine contenant l'intgralit du tableau HTML
*/
	function enTableau($nomtab, $contenu) {
		//$sortie = '<table class="tabresult" border="0" cellspacing="0" cellpadding="0">';
		$sortie = '<table id="tabresult"  class="lisTable" border="0" cellspacing="0" cellpadding="0">';
		$sortie .= '<tr class=systemTabHeader ><th>' . $nomtab . '</th></tr>';
		$sortie .= '<tr><td>' . $contenu . '</td></tr>';
		$sortie .= '</table>';
		return $sortie;
	}

/**
* Retourne le contenu en tableau HTML pour amliorer la prsentation
* 
* Ce tableau est celui qui contient la preview du menu en cours
* @param string $nomtab Nom du tableau
* @param string $contenu Contenu du tableau
* @return string Chaine contenant l'intgralit du tableau HTML
*/
	function enTableauPrev($nomtab, $contenu) {
		$sortie = '<table class="tabpreview" border="0" cellspacing="0" cellpadding="0">';
		$sortie .= '<tr><th>' . $nomtab . '</th></tr>';
		$sortie .= '<tr><td>' . $contenu . '</td></tr>';
		$sortie .= '</table>';
		return $sortie;
	}

/**
* Retourne le formulaire pour editer une ligne de menu
* 
* Il est galement utilis pour crer une ligne de menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $Myqsl Paramtres de la base de donnes
* @return string Chaine contenant l'intgralit du formulaire HTML
*/
	function editMenu($modmenu, $Myqsl) {
		global $picturemaxwidth, $picturemaxheight;
		
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		$this->init($modmenu);

		if ($modmenu[$modmenu["Operation"]] == "edit") {
			//open_db($Myqsl);
			$menuCourant = getOneMenu($Myqsl, $Page, $menu);
			$menuParent = getOneMenu($Myqsl, $menuCourant["Parent"], $menu);
			if (count($menuParent) == 0) {
				$menuParent["Name"] = _EDITMENUSPARENT;
			}
			//close_db($Myqsl);
			$id = $menu . "," . $Page;

		}

		if ($modmenu[$modmenu["Operation"]] == "new") {
			//open_db($Myqsl);
			$menuParent = getOneMenu($Myqsl, $Page, $menu);
			if (count($menuParent) == 0) {
				$menuParent["Name"] = _EDITMENUSPARENT;
			}
			$menuCourant = array ();
			$menuCourant["Name"] = "";
			$menuCourant["Description"] = "";
			$menuCourant["PublicUse"] = "1";
			$menuCourant["position"] = NextSubMenuPos($Myqsl, $Page, $menu);
			;
			$menuCourant["url"] = "";
			$menuCourant["target"] = "";
			$menuCourant["nomenu"] = "0";
			
			$menuCourant["picture"] = "";

			$menuCourant["Parent"] = $Page;
			$id = $menu . ",-1";
		}
		
		$typeMenu = getFamilies($Myqsl,$menu);
		$langueMenuEnCours = $typeMenu[0]["langue"];
		$rub_url = "Furl";
		$urlEnCours = $menuCourant["url"];
		require_once 'get_all_urls_modules.php';
		
		$codeSortie = "";

		if ($modmenu[$modmenu["Operation"]] == "edit" || $modmenu[$modmenu["Operation"]] == "new") {
			$codeSortie = '	<form id="unMenu" action="?' . $modmenu["Menu"] . '=' . $modmenu[$modmenu["Encours"]] . ',' . $modmenu[$modmenu["Menu"]] . '&' . $modmenu["Operation"] . '=save' . $this->varsenplus . '" method="post" name="unMenu">
											<table border="0" cellspacing="2" cellpadding="0">
												<tr>
													<td>'._EDITMENUSNAME.'</td>
													<td><input class="saisie" type="text" name="FName" size="24" value="' . $menuCourant["Name"] . '"></td>
												</tr>
												<tr style="display: none">
													<td>'._EDITMENUSDESCR.'</td>
													<td><input class="saisie" type="text" name="FDescription" size="24" value="' . $menuCourant["Description"] . '"></td>
												</tr>
												<tr>
													<td>'._EDITMENUSBUBMENU.'</td>
													<td><input class="saisie" type="text" name="FParentL" readonly size="24" value="' . $menuParent["Name"] . '"><input type="hidden" name="FParent" value="' . $menuCourant["Parent"] . '"></td>
												</tr>
												<tr style="display: none">
													<td>'._EDITMENUSPUBLIC.'</td>
													<td><input class="radio" type="radio" name="FPublicUse" value="1"';
			if ($menuCourant["PublicUse"] == '1') {
				$codeSortie .= ' checked';
			}
			$codeSortie .= '> '._EDITMENUSYES.' <input class="radio" type="radio" name="FPublicUse" value="0"';
			if ($menuCourant["PublicUse"] == '0') {
				$codeSortie .= ' checked';
			}
			$img_menu = "";
			if (file_exists($menuCourant["picture"])) {
				$img_menu = '<img src="'.$menuCourant["picture"].'" id="preview_pict" width="100" style="display: inline" />';
			}
			$codeSortie .= '>'._EDITMENUSNO.'</td>
												</tr>
												<tr style="display: none">
													<td>'._EDITMENUSPOSITION.'</td>
													<td><input class="saisie" type="text" name="Fposition" size="24" value="' . $menuCourant["position"] . '"></td>
												</tr>
												<tr>
													<td valign="top">'._EDITMENUSLINK.'</td>
													<!--<td><input class="saisie" type="text" name="Furl" size="24" value="' . $menuCourant["url"] . '"><br>&nbsp;&nbsp;&nbsp;'._EDITMENUSPAGES.' : ' . $menuPagesDispo . '<br>&nbsp;&nbsp;&nbsp;'._EDITMENUSMAPS.' : ' . $menuMapsDispo .'</td>-->
													<td><input class="saisie" type="text" id="Furl" name="Furl" size="24" value="' . $menuCourant["url"] . '"><br>'.$menus_modules. '</td>
												</tr>
												<tr>
													<td valign="top">'._EDITMENUSPICTURE.'</td>
													<td><input class="saisie" type="text" name="Fpicture" size="24" value="' . $menuCourant["picture"] . '"><br />
													<table border="0" cellpadding="0" cellspacing="0">
													</tr><td>&nbsp;&nbsp;&nbsp;<input id="btnBrowse" onclick="openFileManager()" type="button" value="Parcourir le serveur" />
														&nbsp;&nbsp;&nbsp;<input id="btnDelPict" onclick="delpicture()" type="button" value="Supprimer" /></td>
														<td rowspan="2">&nbsp;&nbsp;&nbsp;'.$img_menu.'</td></tr>
													</tr><td>&nbsp;&nbsp;&nbsp;Largeur Max upload : <input id="txtWidth" type="text" value="'.$picturemaxwidth.'" class="saisiedemi" /><br />
															&nbsp;&nbsp;&nbsp;Hauteur Max upload : <input id="txtHeight" type="text" value="'.$picturemaxheight.'" class="saisiedemi" /></td></tr>
													</table>
														</td>
												</tr>
												<tr>
													<td>'._EDITMENUSTARGET.'</td>
													<td><input class="saisie" type="text" name="Ftarget" size="24" value="' . $menuCourant["target"] . '"></td>
												</tr>
												<tr>
													<td>'._EDITMENUSEXTERNAL.'</td>
													<td><input class="radio" type="radio" name="Fnomenu" value="1"';
			if ($menuCourant["nomenu"] == '1') {
				$codeSortie .= ' checked';
			}
			$codeSortie .= '>'._EDITMENUSYES.' <input class="radio" type="radio" name="Fnomenu" value="0"';
			if ($menuCourant["nomenu"] == '0') {
				$codeSortie .= ' checked';
			}
			$codeSortie .= '>'._EDITMENUSNO.'</td>
												</tr>
												<tr>
													<td></td>
													<td></td>
												</tr>
											</table>
											<p style="text-align: center"><input type="hidden" name="FID" value="' . $id . '"><input type="submit" name="Enregistrer" value="'._EDITMENUSSAVE.'"></p>
										</form>';
		}
		$codeSortie = $this->enTableau(_EDITMENUSEDITROW, $codeSortie);
		return $codeSortie;
	}

/**
* Effectue l'enregistrement d'une ligne de menu.
* 
* Cette mthode est utilise aussi bien pour crer que pour modifier une ligne de menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $Myqsl Paramtres de la base de donnes
* @param array $menuASauver Tableau contenant les donnes du menu  enregistrer
* @return string Chaine contenant le message donnant le rsultat de l'opration
*/
	function saveMenu($modmenu, $Myqsl, $menuASauver) {
		//open_db($Myqsl);
		if (!saveOneMenu($Myqsl, $menuASauver)) {
			$sortie = "<p>"._EDITMENUSNOTSAVED."</p>";
		} else {
			$sortie = "<p>"._EDITMENUSSAVED."</p>";
		}
		//close_db($Myqsl);
		$sortie = $this->enTableau(_EDITMENUSISSAVED, $sortie);
		return $sortie;
	}

/**
* Effectue la suppression d'une ligne de menu.
* 
* Tous les sous-menus relatifs  cette ligne de menu seront galement supprims
* @param array $modmenu Tableau des valeurs pour afficher un menu. Cette variable est modifie par l'opration.
* @param array $Myqsl Paramtres de la base de donnes
* @return string Chaine contenant le message donnant le rsultat de l'opration
*/
	function delMenu(&$modmenu, $Myqsl) {
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];

		if ($Page != 0) {
			//open_db($Myqsl);
			$menu = getOneMenu($Myqsl, $Page, $menu);
			$modmenu[$modmenu["Menu"]] = $menu["Parent"];
			$modmenu[$modmenu["Encours"]] = $menu["idmenu"];

			$menu = array (
				"ID" => $Page,
				"idmenu" => $modmenu[$modmenu["Encours"]]
			);
			if (!delOneMenu($Myqsl, $menu)) {
				die(_EDITMENUSNOTDELETED);
			} else {
				$sortie = "<p>"._EDITMENUSDELETED."</p>";
			}
			//close_db($Myqsl);
		} else {
			$sortie = "<p>"._EDITMENUSDELBADPARAM."</p>";
		}
		$sortie = $this->enTableau(_EDITMENUSISDELETED, $sortie);
		return $sortie;
	}

/**
* Change la position d'une ligne de menu
* 
* Selon la valeur de l'lment "Operation", le menu peut monter (upmenu) ou descendre (downmenu)
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $Myqsl Paramtres de la base de donnes
* @return string Chaine contenant le message donnant le rsultat de l'opration
*/
	function moveMenu($modmenu, $Myqsl) {
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];

		if ($Page == 0) {
			$sortie = "<p>"._EDITMENUSNOTSELECTED."</p>";
		} else {
			//open_db($Myqsl);
			if ($modmenu[$modmenu["Operation"]] == "upmenu") {
				if (!upMenu($Myqsl, $Page, $menu)) {
					$sortie = "<p>"._EDITMENUSNOTMOVED."</p>";
				} else {
					$sortie = "<p>"._EDITMENUSMOVED."</p>";
				}
			}
			if ($modmenu[$modmenu["Operation"]] == "downmenu") {
				if (!downMenu($Myqsl, $Page, $menu)) {
					$sortie = "<p>"._EDITMENUSNOTMOVED."</p>";
				} else {
					$sortie = "<p>"._EDITMENUSMOVED."</p>";
				}
			}
			//close_db($Myqsl);
		}
		$sortie = $this->enTableau(_EDITMENUSISMOVED, $sortie);
		return $sortie;
	}

/**
* Change la position hirachique d'une ligne de menu
* 
* Selon la valeur de l'lment "Operation", la fonction peut monter directement la ligne de menu au niveau suprieur (uparbmenu) ou afficher un formulaire de choix de position (downarbmenu)
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $Myqsl Paramtres de la base de donnes
* @return string Chaine contenant le message donnant le rsultat de l'opration
*/
	function moveArboMenu($modmenu, $Myqsl) {
		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		$this->init($modmenu);

		if ($Page == 0) {
			$sortie = "<p>"._EDITMENUSNOTSELECTED."</p>";
			$sortie = $this->enTableau(_EDITMENUSISMOVED, $sortie);
		} else {
			//open_db($Myqsl);
			if ($modmenu[$modmenu["Operation"]] == "uparbmenu") {
				if (!upArboMenu($Myqsl, $Page, $menu)) {
					$sortie = "<p>"._EDITMENUSNOTMOVED."</p>";
				} else {
					$sortie = "<p>"._EDITMENUSMOVED."</p>";
				}
				$sortie = $this->enTableau(_EDITMENUSISMOVED, $sortie);
			}
			if ($modmenu[$modmenu["Operation"]] == "downarbmenu") {
				$tempObjetMenu = new menuText();
				$tempObjetMenu->IdMenu = $modmenu[$modmenu["Encours"]];
				$tempmenu = $tempObjetMenu->makeselect($tempObjetMenu->MakeTree($Myqsl, $modmenu), "newparent", $Page);
				$sortie = '<form id="unMenu" action="?' . $modmenu["Menu"] . '=' . $modmenu[$modmenu["Encours"]] . ',' . $modmenu[$modmenu["Menu"]] . '&' . $modmenu["Operation"] . '=savefixarbmenu' . $this->varsenplus . '" method="post" name="unMenu">';
				$menuencours = getOneMenu($Myqsl, $Page, $menu);
				$sortie .= _EDITMENUSMENUMOVED . $menuencours["Name"] . "<br>";
				$sortie .= "<p>"._EDITMENUSMOVETO."<br>$tempmenu</p>";
				$sortie .= '<p><input type="hidden" name="FID" value="' . $Page . '"><input type="submit" name="Enregistrer" value="'._EDITMENUSSAVE.'"></p>';
				$sortie .= "</form>";

				$sortie = $this->enTableau(_EDITMENUSMOVEROW, $sortie);
			}
			//close_db($Myqsl);
		}

		return $sortie;
	}

/**
* Enregistre le changement de position hirachique d'une ligne de menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $Myqsl Paramtres de la base de donnes
* @param integer $parent Identifiant de la ligne de menu parent
* @return string Chaine contenant le message donnant le rsultat de l'opration
*/
	function fixArboMenu($modmenu, $Myqsl, $parent) {

		$chemintab = array ();
		$chemintab = allArboMenu($Myqsl, $modmenu[$modmenu["Encours"]]);

		foreach ($chemintab as $ligne) {

			if ($ligne["Id"] == $parent) {
				$menudest = $ligne;
			}
		}
		$noeuds = explode("|", $menudest["Chemin"]);
		$ok = true;
		foreach ($noeuds as $noeud) {
			if ($noeud == $modmenu[$modmenu["Menu"]]) {
				$ok = false;
			}
		}
		if ($ok) {
			$retour = fixArboMenu($Myqsl, $modmenu[$modmenu["Menu"]], $parent, $modmenu[$modmenu["Encours"]]);
			if ($retour) {
				$sortie = _EDITMENUSMOVEDONE;
			} else {
				$sortie = _EDITMENUSMOVENOTDONE;
			}
		} else {
			$sortie = _EDITMENUSBADTARGET;
		}

		return $this->enTableau(_EDITMENUSMOVESAVE, $sortie);
	}

/**
* Renvoie " selected" si $v1 gale $v2 et "" sinon
* 
* Est utilise par des fonctions de construction de menu pop-up pour formulaires HTML
* @param integer $v1,$v2 Indentifiants  tester
* @return string Chaine contenant " selected " ou ""
*/
	function testSelected($v1, $v2) {
		if ($v1 == $v2) {
			$sortie = " selected";
		} else {
			$sortie = "";
		}
		return $sortie;
	}

/**
* Revoie le menu de la liste des menus disponibles
* 
* Ce menu pop-up est mis en forme dans un tableau HTML prt pour l'affichage
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $Myqsl Paramtres de la base de donnes
* @return string Chaine contenant le code HTML
*/
	function getFamilyMenu($modmenu, $Myqsl) {
		$this->init($modmenu);

		$sortie = "";
		$nommenupop = "FMenuEnCours";
		//open_db($Myqsl);
		$famille = getFamilies($Myqsl, "");
		//close_db($Myqsl);
		if (count($famille) != 0) {
			$sortie = '
			<table border="0" cellspacing="2" cellpadding="0">
			<tr><td>';
			$sortie .= _EDITMENUSCURRENTMENU;
			//$sortie .= "<select name=\"" . $nommenupop . "\" size=\"1\" onchange=\"if (this.value != '') { window.location.href='?" . $modmenu["Menu"] . "='+this.value+'" . $this->varsenplus . "' }\">";
			$sortie .= "<select name=\"" . $nommenupop . "\" size=\"1\" onchange=\"if (this.value != '') { window.location.href='?" . $modmenu["Menu"] . "='+this.value+'" . $this->varsenplus . "&".$modmenu["Operation"]."=".$modmenu[$modmenu["Operation"]]."' }\">";
			$sortie .= "<option value=\"\">Choisissez le menu</option>";
			foreach ($famille as $untype) {
				$sortie .= "<option value=\"" . $untype["Id"] . "\"" . $this->testSelected($untype["Id"], $modmenu[$modmenu["Encours"]]) . ">" . $untype["intitule"] . "</option>";
			}
			$sortie .= "</select>";
			$sortie .= "</td></tr></table>";
		}
		$sortie = '<table class="lisTable" border="0" cellspacing="0" cellpadding="0">'
				.'<tr class=systemTabHeader ><th>'._EDITMENUSISCURRENTMENU.'</th></tr>'
				.'<tr><td>' . $sortie . '</td></tr>'
				.'</table>';
		return $sortie;
	}

/**
* Retourne le formulaire pour editer un menu
* 
* Il est galement utilis pour crer un menu
* @param array $modmenu Tableau des valeurs pour afficher un menu
* @param array $Myqsl Paramtres de la base de donnes
* @return string Chaine contenant l'intgralit du formulaire HTML
*/
	function editFamilyMenu($modmenu, $Myqsl) {
		$this->init($modmenu);

		$sortie = "";
		$nommenupop = "FMenuEnCours";
		$menu = $modmenu[$modmenu["Encours"]];
		//open_db($Myqsl);
		$famille = getFamilies($Myqsl, $menu);
		//close_db($Myqsl);
		if (count($famille) != 0) {
			$untype = $famille[0];
			$FId = $untype["Id"];
			$FIntitule = $untype["intitule"];
			$FGenre = $untype["genre"];
			$nomTab = _EDITMENUSFAMILYEDIT;
			$Flangue = $untype["langue"];
		} else {
			$FId = "-1";
			$FIntitule = "";
			$FGenre = "";
			$nomTab = _EDITMENUSFAMILYNEW;
			$Flangue = "All";
		}
		$sortie = '<form id="typemenu" action="?' . $modmenu["Menu"] . '=' . $modmenu[$modmenu["Encours"]] . '&' . $modmenu["Operation"] . '=savemenu' . $this->varsenplus . '" method="post" name="typemenu">
							<table border="0" cellspacing="2" cellpadding="0">
								<tr>
									<td nowrap>Intitul&eacute;</td>
									<td><input class="saisie" type="text" name="FIntitule" size="24" value="' . $FIntitule . '"></td>
								</tr>
								<tr>
									<td nowrap>Type de menu</td>
									<td><select name="FGenre" size="1">
											<option value="1"' . $this->testSelected($FGenre, "1") . '>'._EDITMENUSFAMILYKIND1.'</option>
											<option value="4"' . $this->testSelected($FGenre, "4") . '>'._EDITMENUSFAMILYKIND4.'</option>
											<option value="2"' . $this->testSelected($FGenre, "2") . '>'._EDITMENUSFAMILYKIND2.'</option>
											<option value="3"' . $this->testSelected($FGenre, "3") . '>'._EDITMENUSFAMILYKIND3.'</option>
											<option value="7"' . $this->testSelected($FGenre, "7") . '>'._EDITMENUSFAMILYKIND7.'</option>
											<option value="8"' . $this->testSelected($FGenre, "8") . '>'._EDITMENUSFAMILYKIND8.'</option>
											<option value="6"' . $this->testSelected($FGenre, "6") . '>'._EDITMENUSFAMILYKIND6.'</option>
											<option value="9"' . $this->testSelected($FGenre, "9") . '>'._EDITMENUSFAMILYKIND9.'</option>
											<option value="10"' . $this->testSelected($FGenre, "10") . '>'._EDITMENUSFAMILYKIND10.'</option>
										</select></td>
								</tr>
								<tr>
									<td nowrap>Langue</td>
									<td>'.$this->langues_dispo($Flangue).'</td>
								</tr>
							</table>
							<p><input type="hidden" name="FId" value="' . $FId . '"><input type="submit" name="Enregistrer" value="'._EDITMENUSSAVE.'"></p>
						</form>';
		$sortie = $this->enTableau($nomTab, $sortie);
		return $sortie;
	}

/**
* Effectue l'enregistrement d'un menu.
* 
* Cette mthode est utilise aussi bien pour crer que pour modifier un menu
* @param integer $retourId Retourne le numro du menu modifi ou cr
* @param array $Myqsl Paramtres de la base de donnes
* @param array $menuASauver Tableau contenant les donnes du menu  enregistrer
* @return string Chaine contenant le message donnant le rsultat de l'opration
*/
	function saveFamilyMenu(&$retourId, $Myqsl, $menuASauver) {
		//open_db($Myqsl);
		if (!saveFamilyMenu($retourId, $Myqsl, $menuASauver)) {
			$sortie = "<p>"._EDITMENUSFAMILYNOTSAVED."</p>";
		} else {
			$sortie = "<p>"._EDITMENUSFAMILYSAVED."</p>";
		}
		//close_db($Myqsl);
		$sortie = $this->enTableau(_EDITMENUSFAMILYISSAVED, $sortie);
		return $sortie;
	}

/**
* Effectue la suppression d'un menu.
* 
* Toutes les lignes de ce menu seront supprimes
* @param array $Myqsl Paramtres de la base de donnes
* @param array $menuAVirer Tableau contenant les donnes du menu  supprimer
* @return string Chaine contenant le message donnant le rsultat de l'opration
*/
	function delFamilyMenu($Myqsl, $menuAVirer) {
		//open_db($Myqsl);
		if (!delFamilyMenu($Myqsl, $menuAVirer)) {
			$sortie = "<p>"._EDITMENUSFAMILYNOTDELETED."</p>";
		} else {
			$sortie = "<p>"._EDITMENUSFAMILYDELETED."</p>";
		}
		//close_db($Myqsl);
		$sortie = $this->enTableau(_EDITMENUSFAMILYISDELETED, $sortie);
		return $sortie;
	}

/**
* Renvoie l'identifiant du premier menu non nul
* @param array $Myqsl Paramtres de la base de donnes
* @return integer
*/
	function firstFamilyMenu($Myqsl) {
		//open_db($Myqsl);
		$sortie = firstFamilyMenu($Myqsl);
		//close_db($Myqsl);
		return $sortie;
	}

/**
* Renvoie un tableau HTML pour signifier qu'aucune opration concernant une ligne de menu ne vient d'tre effectue
* @return string Chaine contenant le message indiquant qu'aucune opration n'a t effectue
*/
	function noAction() {
		$nom = _EDITMENUSADMINROWS;
		$result = _EDITMENUSADMINNOOP;
		$codeSortie = $this->enTableau($nom, $result);
		return $codeSortie;
	}

/**
* Renvoie un tableau HTML pour signifier qu'aucune opration concernant un menu ne vient d'tre effectue
* @return string Chaine contenant le message indiquant qu'aucune opration n'a t effectue
*/
	function noAction2() {
		$nom = _EDITMENUSADMINMENU;
		$result = _EDITMENUSADMINNOOP;
		$codeSortie = $this->enTableau($nom, $result);
		return $codeSortie;
	}

/**
* Cre un menu pop-up contenant la liste des pages disponibles ordonnes par rubrique.
* 
* Cette fonction s'appuie sur la methode "getSectionList" du module "Sections"'
* @param string $nomselect Nom du menu pop-up
* @param string $link URL de le ligne de menu en cours
* @return string Chaine contenant le code HTML du menu pop-up
*/
	function makeListPages($nomselect, $link,$langue_en_cours) {
		$urlprefix = "modules.php?name=Sections&sop=viewarticle&artid=";
		$cc = new pageconnector();
		$sections = $cc->getSectionList();
		$sortie = "<select name=\"$nomselect\" size=\"1\" onchange=\"if (this.value != '') {this.form.Furl.value = '$urlprefix'+this.value; }\" class=\"pages\">";
		$sortie .= "<option value=\"\">" . _CARTOPAGESSDISPOCHOIX . "</option>";
		foreach ($sections as $section) {
			$sortie .= "<option value=\"\">" . $section[1] . "</option>";
			$articles = $cc->getPageList($section[0], $langue_en_cours);
			if ($articles != "") {
				foreach ($articles as $article) {
					if ($urlprefix . $article[0] == $link) {
						$selected = "selected=\"selected\"";
					} else {
						$selected = "";
					}
					$sortie .= "<option value=\"" . $article[0] . "\" $selected> -> " . $article[1] . "</option>";
				}
			}
		}
		$sortie .= "</select>";
		return $sortie;
	}

/**
* Cre un menu pop-up contenant la liste des cartes disponibles.
* 
* Cette fonction s'appuie sur la methode "getMaps" du module "SimpleCarto"'
* @param string $nomselect Nom du menu pop-up
* @param string $link URL de le ligne de menu en cours
* @return string Chaine contenant le code HTML du menu pop-up
*/
	function makeListMaps($nomselect, $link,$langue_en_cours) {
		if (file_exists("modules/SimpleCarto/lib/pro/admin.inc")){
			$urlprefix = "modules.php?name=SimpleCarto&sop=display&br=1&bl=TC&tl=0&ic=1&pl=1&v=M&Idc=";
		}
		else {
			$urlprefix = "modules.php?name=SimpleCarto&sop=display&br=1&bl=T&tl=0&ic=1&pl=0&v=M&Idc=";
		}
		if (file_exists("modules/SimpleCarto")){
			$cc = new mapconnector();
			$maps = $cc->getMaps();
		}
		else {
			$maps = array();
		}

		$sortie = "<select name=\"$nomselect\" size=\"1\" onchange=\"if (this.value != '') {this.form.Furl.value = '$urlprefix'+this.value; }\" class=\"pages\">";
		$sortie .= "<option value=\"\">" . _CARTOMAPSSDISPOCHOIX . "</option>";
		foreach ($maps as $map) {
			if ($urlprefix . $map[0] == $link) {
				$selected = "selected=\"selected\"";
			} else {
				$selected = "";
			}
			$sortie .= "<option value=\"" . $map[0] . "\" $selected> -> " . $map[1] . "</option>";
		}
		$sortie .= "</select>";
		return $sortie;
	}

/**
* Cre un menu pop-up contenant la liste des langues disponibles.
*
* @param string $languecourante Langue pour selectionner la ligne du menu
* @return string Chaine contenant le code SELECT HTML du menu pop-up des langues
*/
	function langues_dispo($languecourante) {
		$langdir = dir("language");
	    while($func=$langdir->read()) {
			if(substr($func, 0, 5) == "lang-") {
			    $menulist .= "$func ";
			}
	    }
	    closedir($langdir->handle);
	    $menulist = explode(" ", $menulist);
	    sort($menulist);
	    $content = "";
	    for ($i=0; $i < sizeof($menulist); $i++) {
			if($menulist[$i]!="") {
			    $tl = preg_replace("#lang-#","",$menulist[$i]);
			    $tl = preg_replace("#.php#","",$tl);
			    $altlang = ucfirst($tl);
			    if ($languecourante == $altlang) {
			    		$selected = " selected";
			    }
			    else {
			    		$selected ="";
			    }
			    $content .= "<option value=\"$altlang\"$selected>$altlang</option>";
			}
	    }
	    $menu = '<select name="Flangue" size=1><option value="All">Toutes</option>'.$content.'</select>';
	    return $menu;
	}
	
	function MakeTreePlan($Myqsl, $modmenu, $icns) {
		global $prefix, $db;
	
		$this->init($modmenu);
	
		//$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];
		//$openall = $modmenu[$modmenu["Etat"]];
	
		if ($this->IdMenu != $menu) {
			$menu = $this->IdMenu;
			//$Page = 0;
		}
		
		$resultsS = "";
		$menuTab = getmenuatom($menu);
		$ligneMenu = &$menuTab["lignemenu"];
		
		foreach($ligneMenu as &$ligne) {
			$sql = "SELECT pos_plan FROM ".$prefix."_menu WHERE ID=".$ligne["id"].";";
			$result = $db->sql_query($sql);
			if($donnees = $db->sql_fetchrow($result)) {
				$ligne["pos_plan"] = $donnees["pos_plan"];
			}
		}
		
		$results = $this->TreeNodesPlan($menuTab);
		$resultsS .= '<div>'.$results.'</div>';
		return $resultsS;
	}
	
	function TreeNodesPlan($menuTab) {
		$lignesMenu = $menuTab["lignemenu"];
		$result = '<script type="text/javascript" src="javascripts/jquery-1.6.2.min.js"></script>';
		$result .= '<script type="text/javascript" src="modules/becmsDynMenu/lib/lib_AJAX.js"></script>';
		$result .= '<script type="text/javascript">
						function showMenu(id) {
							jQuery("#div-" + id).toggle("fast");
						}
					</script>';
		$result .= '<script type="text/javascript">
						function checkMenu(id) {
							var posPlan = 0;
							if(jQuery("#checkbox-" + id).attr("checked")) {
								var className = jQuery("#checkbox-" + id).attr("class");
								var niveau = className.split("-")[1];
								if(niveau == 1 ) {
									posPlan = GetAJAXData("system.php?op=menuplan&action=posplan&idPlan=" + id);
								} else {
									posPlan = 1;
								}
								var parentMenu = jQuery("#checkbox-" + id).parent();
								var parentName = parentMenu.attr("id");
								if(parentName) {
									var tabParentName = parentName.split("-");
									if(tabParentName.length > 1) {
										var idMenuParent = tabParentName[1];
										if( !jQuery("#checkbox-" + idMenuParent).attr("checked") ) {
											jQuery("#checkbox-" + idMenuParent).prop("checked", true);
											checkMenu(idMenuParent);
										}
									}
								}
							} else {
								var childrensMenu = jQuery("#div-" + id).children();
								for(var i = 0; i < childrensMenu.length; i++) {
									if( childrensMenu[i].type == "checkbox" ) {
										if( childrensMenu[i].checked == true ) {
											childrensMenu[i].checked = false;
											var childrenId = childrensMenu[i].id;
					
											var tabChildrenName = childrenId.split("-");
											if(tabChildrenName.length > 1) {
												var idMenuChildren = tabChildrenName[1];
												checkMenu(idMenuChildren);
											}
										}
									}
								}
							}
							var link = "system.php?op=menuplan&action=saveposplan&idMenu="+id+"&posplan="+posPlan;
							var results = GetAJAXData(link);
							if (results == "") {
								//window.location.reload();//inutile : les rsultats sont dj affich...
							} else {
								alert(results);
							}
						}
				
						function reloadTablePlan(idMenu) {
							var link = "system.php?op=menuplan&action=tableplan&mmg="+idMenu;
							var results = GetAJAXData(link);
							jQuery("#tabPlan").html(results);
						}
				
						$(document).ready(function() {
							reloadTablePlan(\''.$menuTab["Id"].'\');
						});
					</script>';
		$result .= '<script type="text/javascript">
						var ligne = [];';
		foreach($lignesMenu as $ligne) {
			$result .= 'ligne.push('.$ligne["id"].');';
		}
		$result .= '</script>';
		$result .= '<script type="text/javascript">
						function deplier() {
							for(var i = 0; i < ligne.length; i++) {
								if(jQuery("#div-" + ligne[i])) {
									jQuery("#div-" + ligne[i]).css("display", "block");
								}
							}
						}
				
						function plier() {
							for(var i = 0; i < ligne.length; i++) {
								if(jQuery("#div-" + ligne[i])) {
									jQuery("#div-" + ligne[i]).css("display", "none");
								}
							}
						}
				
						function cocher() {
							for(var i = 0; i < ligne.length; i++) {
								if(jQuery("#checkbox-" + ligne[i])) {
									jQuery("#checkbox-" + ligne[i]).prop("checked", true);
									jQuery("#checkbox-" + ligne[i]).change();
								}
							}
						}
				
						function decocher() {
							for(var i = 0; i < ligne.length; i++) {
								if(jQuery("#checkbox-" + ligne[i])) {
									jQuery("#checkbox-" + ligne[i]).prop("checked", false);
									jQuery("#checkbox-" + ligne[i]).change();
								}
							}
						}
					</script>';
		
		/*$sortie = '<table class="lisTable" border="0" cellspacing="0" cellpadding="0">'
		 .'<tr class=systemTabHeader ><th>'._EDITMENUSISCURRENTMENU.'</th></tr>'
		.'<tr><td>' . $sortie . '</td></tr>'
		.'</table>';
		*/
		
		$result .= '<table class="lisTable" border="0" cellspacing="0" cellpadding="0">'
				.'<tr class=systemTabHeader ><th>'._EDITMENUPLANMENU.'</th></tr>';
		$result .= '<tr><td><input type="button" value="Tout cocher" onclick="cocher();" /><input type="button" value="Tout dcocher" onclick="decocher();" /><input type="button" value="Tout plier" onclick="plier();" /><input type="button" value="Tout dplier" onclick="deplier();" /></td></tr>';
		$result .= '<tr><td><div>';
		for($i = 0; $i < count($lignesMenu); $i++) {
			$ligne = $lignesMenu[$i];
			if( $i > 0 ) {
				$lignePrev = $lignesMenu[$i-1];
				if( $ligne["niveau"] > $lignePrev["niveau"] ) {
					$result .= '<div id="div-'.$lignePrev["id"].'" style="display:none;padding-left: 20px;">';
				} else if( $ligne["niveau"] < $lignePrev["niveau"] ) {
					$result .= '</div>';
				}
			}
			$checked = '';
			if($ligne["pos_plan"] > "0") $checked = 'checked';
			$result .= '<input id="checkbox-'.$ligne["id"].'" class="niveau-'.$ligne["niveau"].'" type="checkbox" onchange="checkMenu(\''.$ligne["id"].'\', '.$ligne["niveau"].');reloadTablePlan(\''.$menuTab["Id"].'\');" '.$checked.' /><label id="label-'.$ligne["id"].'" for="checkbox-'.$ligne["id"].'"><a href="#" onclick="showMenu(\''.$ligne["id"].'\')">'.$ligne['label'].'</a></label><br />';
		}
		$result .= '</div></div></td></tr></table>';
		return $result;
	}
	
	function tablePlan($Myqsl, $modmenu, $icns, $tabMenu) {
		$resultsS = "";
		/*$lignesMenu = array();
		foreach ($tabMenu as $menu) {
			$menuPlanTab = getmenuatomplan($menu);
			$lignesMenu = array_merge($lignesMenu, $menuPlanTab["lignemenu"]);
		}*/
		$menuPlanTab = getmenuatomplan($menu);
		$lignesMenu = $menuPlanTab["lignemenu"];
		$resultsS .= '<script type="text/javascript">
						function savePosPlan(id, value) {
							var link = "system.php?op=menuplan&action=modifposmenu&idMenu="+id+"&posplan="+value;
							var results = GetAJAXData(link);
							if (results == "") {
								//window.location.reload();//inutile : les rsultats sont dj affich...
							} else {
								alert(results);
							}
							reloadTablePlan(\''.$menuPlanTab["Id"].'\');
						}
					</script>';
		$resultsS .= '<div>';
		
		$nbNiveau1 = 0;
		foreach ($lignesMenu as $ligne) {
			if($ligne['niveau'] == "1") {
				$nbNiveau1++;
			}
		}
		
		$displayTable = '';
		if( $nbNiveau1 == "0" ) $displayTable = 'style="display:none;"';
		
		$resultsS .= '<table border="0" cellspacing="0" cellpadding="10" '.$displayTable.'>
				<tr class=systemTabHeader ><th colspan="'.$nbNiveau1.'">'._EDITMENUPOSPLANMENU.'</th></tr><tr>';
		for($i = 0; $i < count($lignesMenu); $i++) {
			$result = "";
			$ligne = $lignesMenu[$i];
			if( $i > 0 ) {
				$lignePrev = $lignesMenu[$i-1];
				if( $ligne["niveau"] > $lignePrev["niveau"] ) {
					$result .= '<div style="padding-left: 10px;">';
				} else if( $ligne["niveau"] < $lignePrev["niveau"] ) {
					$result .= '</div>';
					if( $ligne["niveau"] == "1" ) {
						$result .= '</div></td>';
					}
				}
			}
			if( $ligne["niveau"] == "1" ) {
				$result .= '<td valign="top">';
				$result .= '<label for="select-'.$ligne["id"].'">'.$ligne['label'].'</label>';
				$result .= '<select id="select-'.$ligne["id"].'" onchange="savePosPlan(\''.$ligne["id"].'\', this.value)">';
				foreach ($lignesMenu as $ligneMenu) {
					if( $ligneMenu['niveau'] == "1" && $ligneMenu['pos_plan'] >= 1 ) {
						$selected = '';
						if( $ligne["id"] == $ligneMenu["id"] ) $selected = 'selected';
						$result .= '<option value="'.$ligneMenu["pos_plan"].'" '.$selected.'>'.$ligneMenu['pos_plan'].'</option>';
					}
				}
				$result .= '</select>';
				$result .= '<br />';
			} else {
				$result .= $ligne['label'].'<br />';
			}
			
			$resultsS .= $result;
		}
		$resultsS .= '</div></tr></table>';
		$resultsS .= '</div>';
		
		return $resultsS;
	}
}

/**
* Classe retournant l'intgralit du menu dsign sous forme de contrle SELECT pour formulaire HTML.
* @package becmsDynMenu
*/
class menuText {

	var $IdMenu;

	function menuArborescent() {
		$this->IdMenu = "1";
	}

	function initMenu($num) {
		$this->IdMenu = $num;
	}

	function MakeTree($Myqsl, $modmenu) {

		$Page = $modmenu[$modmenu["Menu"]];
		$menu = $modmenu[$modmenu["Encours"]];

		if ($this->IdMenu != $menu) {
			$menu = $this->IdMenu;
			$Page = 0;
		}
		//open_db($Myqsl);
		$sortie = getArrayMenu($Myqsl, $menu);
		//close_db($Myqsl);
		$table = $sortie["table"];
		$partable = $sortie["partable"];
		$Folder = $sortie["Folder"];

		$levels = $this->TreeLevels(0, $table, 0);
		if (!isset ($Folder[$Page]["Name"])) {
			$Folder[$Page]["Name"] = "Racine menu";
		}

		$Name = $Folder[$Page]["Name"];
		$levelexpand = 100000;
		$results = $this->racinemenuouvert($modmenu);
		$results .= $this->TreeExpand(0, $table, $partable, $Folder, $Page, 0, $levelexpand, $modmenu);

		$sortie2 = array ();
		$sortie1 = explode("//\\", $results);
		foreach ($sortie1 as $ligne) {
			if ($ligne != "") {
				array_push($sortie2, $ligne);
			}
		}
		return $sortie2;
	}
	
	function TreeLevels($Parent, $table, $level) {
		$_SESSION["levels"][$Parent] = $level;
		if (count($table) != 0) {
			while (list ($key, $val) = each($table[$Parent])) {
				if (isset ($table[$key])) {
					$this->TreeLevels($key, $table, $level +1);
				}
			}
		}
		return $_SESSION["levels"];
	}
	function TreeExpand($Parent, $table, $partable, $Folder0, $Page, $level, $levelexpand, $modmenu) {
		$result = '';
		if (count($partable) != 0) {
			$list = $table[$Parent];
			while (list ($key, $val) = each($list)) {
				if ($level < $levelexpand) {
					$result .= $this->textemenuferme($level +1, $Folder0[$key]["ID"], $Folder0[$key]["Name"], $Folder0[$key]["url"], $Folder0[$key]["target"], $Folder0[$key]["nomenu"], $Folder0[$key]["idmenu"], $modmenu);
				}
				if (isset ($table[$key])) {
					$result .= $this->TreeExpand($key, $table, $partable, $Folder0, $Page, $level +1, $levelexpand, $modmenu);
				}
			}
		}
		return $result;
	}
	function decalage($niveau) {
		$lacale = str_pad("", $niveau, ".");
		return $lacale;
	}
	function menuouvert() {

		return "<img src='folderopen.gif' alt='' width='20' height='20' align='absmiddle'>";
	}
	function menuferme() {
		return "<img src='folder.gif' alt='' width='20' height='20' align='absmiddle'>";
	}

	function textemenuferme($niveau, $noeud, $nom, $url, $target, $nomenu, $idmenu, $modmenu) {
		if ($nom != "-") {
			$variables = "";

			$sortie = $this->decalage($niveau);
			$sortie .= $nom;
			$sortie .= "|";
			$sortie .= $noeud;

		} else {
			$sortie = "";
		}
		return $sortie . "//\\";
	}
	function racinemenuouvert($modmenu) {
		$sortie = "";

		return $sortie . "//\\";
	}
	function racinemenuferme($modmenu) {
		$sortie = "";

		return $sortie . "//\\";
	}
	function makeselect($menus, $nomselect, $noeud) {
		$sortie = "<select name=\"$nomselect\" size=\"1\">";
		$sortie .= "<option value=\"0\">"._EDITMENUSTEXTTOP."</option>";
		foreach ($menus as $ligne) {
			list ($nom, $num) = explode("|", $ligne);
			if ($noeud == $num) {
				$selected = " selected";
			} else {
				$selected = "";
			}
			$nom = htmlentities($nom, ENT_QUOTES, "ISO-8859-1");
			while (preg_match("#^([&nbsp;]*)([.])#", $nom)) {
				$nom = preg_replace("#^([&nbsp;]*)([.])#", "\\1&nbsp;&nbsp;", $nom);
			}
			$sortie .= "<option value=\"$num\"$selected>$nom</option>";
		}
		$sortie .= "</select>";
		return $sortie;
	}
}
?>