<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */                                           
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/


define('FPDF_FONTPATH','modules/balisteEcmspdf/font/');
require('modules/balisteEcmspdf/lib/fpdf.php');

/*
* Class PDF
* extend DFDF
* 
*/ 
class PDF extends FPDF
{
//Current column
var $col=0;
//Ordinate of column start
var $y0;
var $x0;
var $templatePath; // template path

/*
* CONTRUCTOR
* @param full template path
* 
*/
function PDF($templatePath){
$this->templatePath=$templatePath;
parent::FPDF('P','mm','A4');
}
/*
* Header
* PDF header, generate pdf header
*/ 
function Header()
{
    //Logo
    //$this->Image($this->templatePath."/images/BalisteCom_Sans_Texte_fb.png",10,8,33);
   
	//Arial bold 15
    $this->SetFont('Arial','B',8);
    //Move to the right
    //$this->Cell(80);
    //Title
    //$this->Cell(0,0,'ANNUAIRE DES ACTEURS DE L ENVIRONNEMENT DE LA CORSE',0,0,'C');
    //Line break
    $this->Ln(20);
}
/*
* Footer()
* PDF Footer, Generate pdf footer
*/ 
function Footer()
{
    //Page footer
    $this->SetY(-15);
    $this->SetFont('Arial','I',8);
    $this->SetTextColor(128);
    $this->Cell(0,10,'Page '.$this->PageNo(),0,0,'C');
}

/*
* Unit
* Generate, Unit information part of the pdf document
* 
*/
function printActeur($actid, $nom_acteur, $adresse_acteur, $ville_acteur, $codepostal_acteur, $sigle_acteur, $telephone_acteur, $fax_acteur, $email_acteur, $web_acteur, $nom_president_acteur, $nom_directeur_acteur, $status_acteur, $mission_acteur, $carte_acteur)
{
	
	$this->SetFont('Arial','B',14);
	$this->Cell(0,0,strtoupper($nom_acteur),0,0,'C');
	$this->Ln(20);
	if ($carte_acteur=="") { $carte_acteur="images/annuaire_acteur/carte_corse_ba.jpg"; }
    $posx=80;
    //Title
    $this->SetFont('Arial','',12);
    $this->SetFillColor(0,0,0);
    $this->Cell(0,0,'Identit',0,1,'C',0);
     $this->Ln(4);
    //$this->Cell(0,0,"   ",0,0,'LT',1);
    $this->Ln(4);
	$this->SetFont('Arial','',9);
	$this->SetX($posx);
	$this->Cell(0,0,"Status : $status_acteur",0,1,'L',0);
	$this->y0=$this->GetY(); 
	$this->Ln(4);
	$this->Image($carte_acteur,20,$this->y0, 30);
	$this->SetX($posx);
	$this->Cell(0,0,"Adresse :$adresse_acteur $ville_acteur $codepostal_acteur",0,1,'L',0);
	$this->Ln(4);
	$this->SetX($posx);
	$this->Cell(0,0,"Tlphone : $telephone_acteur",0,1,'L',0);
	$this->Ln(4);
	$this->SetX($posx);
	$this->Cell(0,0,"Tlcopie : $fax_acteur",0,1,'L',0);
	$this->Ln(4);
	$this->SetX($posx);
	$this->Cell(0,0,"Email : $email_acteur",0,1,'L',0);
	$this->Ln(4);
	$this->SetX($posx);
	$this->Cell(0,0,"Site Internet : $web_acteur",0,1,'L',0);
	$this->Ln(4);
	$this->Ln(4);
	$this->SetX($posx);
	$this->SetFont('Arial','BU',9);
	$this->Cell(0,0,"Responsable :",0,1,'L',0);
	$this->Ln(4);
	$this->SetX($posx);
	$this->SetFont('Arial','',9);
	$this->Cell(0,0,"Prsident : $president_acteur",0,1,'L',0);
	$this->Ln(4);
	$this->SetX($posx);
	$this->Cell(0,0,"Directeur : $directeur_acteur",0,1,'L',0);
	$this->Ln(4);
	$this->Ln(4);
	$this->Ln(4);
	$this->Ln(4);
	$this->Ln(4);
	// saut de ligne
    $this->Ln(1);
    //Save ordinate
    //$this->y0=$this->GetY();
}
/*
* role
* Geenrate role information part of the document
* 
*/ 
function printMission($mission_acteur)
{
    //Font
    $this->SetFont('Arial','B',9);
    $this->Cell(0,0,"MISSION",0,1,'C',0);    
	$this->Ln(4);
	$this->SetFont('Arial','',9);
	$this->MultiCell(0,4,"$mission_acteur",0,1,'L',0);
	$this->Ln(4); 
	$this->Ln(4);
	$this->Ln(4); 
    
}

/*
* person
* Generate person part of the document
* 
*/ 
function printActiviteDomaine($domaineArray, $activityArray)
{
	$posx=80;
	$this->Ln(4);
	$this->Ln(4); 
	$this->SetFont('Arial','B',9);
    $this->Cell(80,0,"Domaines de comptence",0,1,'C',0);
    $this->y0=$this->GetY();
    $this->SetFont('Arial','',9);
    $this->Ln(4);
    for ($i=0;$i<count($domaineArray);$i++) {
    $this->Cell(0,0,"- ".$domaineArray[$i],0,1,'L',0);
    $this->Ln(4);
    }
	

	$this->SetY($this->y0);
	$this->SetX($posx);
	$this->SetFont('Arial','B',9);
	$this->Cell(0,0,"Activits",0,1,'C',0);
	$this->Ln(4);
	$this->SetX($posx);
	$this->SetFont('Arial','',9);
	for ($i=0;$i<count($activityArray);$i++) {
    $this->SetX($posx);
    $this->Cell(0,0,"- ".$activityArray[$i],0,1,'L',0);
    $this->Ln(4);
    }
	
	$this->Ln(4); 
	$this->Ln(4);
	$this->Ln(4); 
}
/*
* person
* Generate person part of the document
* 
*/ 
function printContact($contactArray) {

	$posx=0;
    $this->SetFont('Arial','B',9);
    $this->Cell(0,0,"CONTACT",0,1,'C',0);    
	$this->Ln(4);
	$this->SetFont('Arial','',9);
	for ($i=0;$i<count($contactArray);$i++) {
		$this->SetFont('Arial','B',9);
    	$this->Cell(0,0,"".$contactArray[$i]['nom_contact']." ".$contactArray[$i]['prenom_contact'],0,1,'L',0);
    	$this->Ln(4);
    	$this->SetFont('Arial','',9);
    	$this->Cell(60,0," ".$contactArray[$i]['domaine_contact'],0,0,'L',0);
    	$this->Cell(40,0," Tlphone:".$contactArray[$i]['telephone_contact'],0,0,'L',0);
    	$this->Cell(40,0," Email:".$contactArray[$i]['telephone_contact'],0,1,'L',0);
    	$this->Ln(4);
    }
}
}// End Class
?>