<?php
global $Default_Theme, $prefix, $uploadFolder, $module_name;

require_once("core/conf/uploadconfig.php");
require_once ("modules/atlas_accessit/system/functions.php");

$url_xml_atlas = "http://accessit-git.eu/cartaro/xml-it-siti.php";
$dirtemp = "modules/atlas_accessit/system/temp/";
$f_atlas = "atlas";
$dirImg = $uploadFolder."/../atlas/";
$separatorImageAlbum = ";";

// Liens des pages
$lienFicheItineraire = "modules.php?name=atlas_accessit&sop=map_fiche_itineraire&idItineraire=<!--id-->";
$lienCourtFicheItineraire = "<!--nom-->_atlasparcours_<!--id-->.htm";
$lienFicheSite = "modules.php?name=atlas_accessit&sop=fiche_site&idSite=<!--id-->";
$lienCourtFicheSite = "<!--nom-->_atlassite_<!--id-->.htm";

// Liens des pages mobile
$lienFicheItineraireMobile = "mobiles.php?name=atlas_accessit&op=map_fiche_itineraire&idItineraire=<!--id-->";
$lienCourtFicheItineraireMobile = "<!--nom-->_mobile_atlasparcours_<!--id-->.htm";
$lienFicheSiteMobile = "mobiles.php?name=atlas_accessit&op=fiche_site&idSite=<!--id-->";
$lienCourtFicheSiteMobile = "<!--nom-->_mobile_atlassite_<!--id-->.htm";

$dicotheme = array(
	"Archeologia" => "Archeologia / Archeologie",
	"Cultura del Mare" => "Cultura del Mare / Culture de la mer",
	"Identit del Territorio" => "Identit del Territorio / Identit du Territoire",
	"I Romani nel Mediterraneo" => "I Romani nel Mediterraneo / Les Romains en Mditerrane",
	"Musei e siti archeologici" => "Musei e siti archeologici / Rseau des muses et sites archologiques",
	"Rete dei musei del mare" => "Rete dei musei del mare / Le rseau des muses de la mer",
	"Patrimonio Comune" => "Patrimonio Comune / Patrimoine Commun",

	"All" => "Tutti i percorsi / Tous les itinraires ",
);

$colortheme = array(
	"" => "#cdcdcd",
	"Archeologia" => "#751f5A",
	"Cultura del Mare" => "#1EA99A",
	"Identita del Territorio" => "#F29400",
);

$picto_theme = array(
	"" => "modules/SimpleCarto/lib/pictos/atlas/vc0.png",
	"Archeologia" => "modules/SimpleCarto/lib/pictos/atlas/vc3.png",
	"Cultura del Mare" => "modules/SimpleCarto/lib/pictos/atlas/vc2.png",
	"Identit del Territorio" => "modules/SimpleCarto/lib/pictos/atlas/vc1.png"
);

$icon_control_circuit = array(
		"" => "themes/".$Default_Theme."/images/btn_carto_filter.png",
		"Archeologia" => "themes/".$Default_Theme."/images/btn_carto_archeo.png",
		"Cultura del Mare" => "themes/".$Default_Theme."/images/btn_carto_cult.png",
		"Identita del Territorio" => "themes/".$Default_Theme."/images/btn_carto_ident.png",
		"Filter" => "themes/".$Default_Theme."/images/btn_carto_filter.png",
		"Archeologia_filter" => "themes/".$Default_Theme."/images/btn_carto_archeo_filter.png",
		"Cultura del Mare_filter" => "themes/".$Default_Theme."/images/btn_carto_cult_filter.png",
		"Identita del Territorio_filter" => "themes/".$Default_Theme."/images/btn_carto_ident_filter.png",
		"zoomplus" => "themes/".$Default_Theme."/images/btn_carto_zoomplus.png",
		"zoommoins" => "themes/".$Default_Theme."/images/btn_carto_zoommoins.png"
);

$it_fr_itineraire = array(
	"Nid" => "id_origine",
	"title" => "Nom_itineraire",
	"Tema" => "Theme",
	"Descrizione" => "Description",
	"Servizi" => "Services",
	"Circuiti" => "Circuits",
	"AllegatiItinerario" => "Pieces_jointes",
	"Galleriaimmagini" => "Album",
	"Caratteristichedellamp039intinerario" => "Caracteristique_itineraire",
	"Attivitedeventisulterritorio" => "Activite_event_territoire",
	"Sitoweb" => "Site_web"
);

$it_fr_site = array(
	"title" => "Nom",
	"Descrizione" => "Description",
	"AppartenenzaAccessit" => "Site_accessit",
	"Tema" => "Theme",
	"Categorie" => "Categorie",
	"Indirizzo" => "Adresse",
	"Orariodiapertura" => "Horaires_ouverture",
	"Ingresso" => "Entree",
	"Telefono" => "Telephone",
	"Servizi" => "Services",
	"Specificheservizi" => "Services_specifiques",
	"Raggiungimentobene" => "Raggiungimento_bene",
	"Parcheggiodisabili" => "Parking_handicape",
	"Percorsoaccessibile" => "Percorso_accessibile",
	"Strutturedisabili" => "Strutture_disabili",
	"Ass.Barrierearchitettoniche" => "Ass.Barriere_architettoniche",
	"Ausilirosa" => "Ausili_rosa",
	"Ingressoaccessibile" => "Ingresso_accessibile",
	"Ingressoaccessibileassistito" => "Ingresso_accessibile_assistito",
	"Itinerariaccessibili" => "Itinerari_accessibili",
	"Panoramiaccessibili" => "Panorami_accessibili",
	"Ascensoreaccessibileassistito" => "Ascensore_accessibile_assistito",
	"Ascensoriaccessibili" => "Ascensori_accessibili",
	"Bagnoaccessibile" => "Bagno_accessibile",
	"Bagnoaccessibileconaiuto" => "Bagno_accessibile_con_aiuto",
	"Fondopercorsicompatto" => "Fondo_percorsi_compatto",
	"Ausiliciechiipovedenti" => "Ausili_ciechi_ipovedenti",
	"Ausilimuti" => "Ausili_muti",
	"Ausilisordiipovedenti" => "Ausili_sordi_ipovedenti",
	"Didascaliecontenutiaudio" => "Didascalie_contenuti_audio",
	"Documentiaccessibili" => "Documenti_accessibili",
	"Esposizionecalchiemodellini" => "Esposizione_calchi_e_modellini",
	"Serv.accoglienzaqualificato" => "Serv.accoglienza_qualificato",
	"Eventiaccessibili" => "Eventi_accessibili",
	"Eventiristorazionepernottamento" => "Eventi_ristorazione_pernottamento",
	"Formazionedisabili" => "Formazione_disabili",
	"Promozioneeventiculturali" => "Promozione_eventi_culturali",
	"Disp.sussidiaccessibiliusabili" => "Disp.sussidi_accessibili_usabili",
	"Disp.tramitewebinfocontentuti" => "Disp.tramite_web_info_contentuti",
	"Disp.tramitewebinfomultilingua" => "Disp.tramite_web_info_multilingua",
	"Disp.tramitewebinfostruttura" => "Disp.tramite_web_info_struttura",
	"Disp.tramitewebpercorsiacc." => "Disp.tramite_web_percorsi_acc",
	"Iniziativeaccessibilit" => "Iniziative_accessibilita",
	"Modalitinfoaccessibilitstruttura" => "Modalita_info_accessibilita_struttura",
	"Postazionimultimedialiaccessibili" => "Postazioni_multimediali_accessibili",
	"PresenzamobilewebApp" => "Presenza_mobile_web_App",
	"Reperibilitinformazioni" => "Reperibilita_informazioni",
	"Lat" => "Latitude",
	"Lon" => "Longitude",
	"Circuiti" => "Circuits",
	"Comune" => "Commune",
	"Allegati" => "Divers",
	"Ulteriorimateriali" => "Info_supplementaires",
	"Attiviteeventisulterritorio" => "Activite_event",
	"Altreinformazionieprogetticollegati" => "Altre_informazioni_e_progetti_collegati",
	"Galleriaimmagini" => "Album",
	"Noteaccessibilit" => "Note_accessibilita"
);

$icon_plus_infos = "themes/".$Default_Theme."/images/atlas_accessit_next.gif";

//Accessibilite physique
$fr_boolean_site_access_physique = array(
		"Raggiungimento_bene" => array(
									"label_french" => "Raggiungimento bene (fr)",
									"label_italian" => "Raggiungimento bene",
									"picto" => "themes/".$Default_Theme."/images/atlas/raggiungimento_bene.gif"
								),
		"Parking_handicape" => array(
									"label_french" => "Parking handicape (fr)",
									"label_italian" => "Parking handicape",
									"picto" => "themes/".$Default_Theme."/images/atlas/parking_handicape.gif"
								),
		"Percorso_accessibile" => array(
									"label_french" => "Percorso accessibile (fr)",
									"label_italian" => "Percorso accessibile",
									"picto" => "themes/".$Default_Theme."/images/atlas/percorso_accessibile.gif"
								),
		"Strutture_disabili" => array(
									"label_french" => "Strutture disabili (fr)",
									"label_italian" => "Strutture disabili",
									"picto" => "themes/".$Default_Theme."/images/atlas/strutture_disabili.gif"
								),
		"Itinerari_accessibili" => array(
										"label_french" => "Itinerari accessibili (fr)",
										"label_italian" => "Itinerari accessibili",
										"picto" => "themes/".$Default_Theme."/images/atlas/itinerari_accessibili.gif"
									),
		"Panorami_accessibili" => array(
										"label_french" => "Panorami accessibili (fr)",
										"label_italian" => "Panorami accessibili",
										"picto" => "themes/".$Default_Theme."/images/atlas/panorami_accessibili.gif"
									),
		"Ass.Barriere_architettoniche" => array(
												"label_french" => "Barriere architettoniche (fr)",
												"label_italian" => "Barriere architettoniche",
												"picto" => "themes/".$Default_Theme."/images/atlas/barriere_architettoniche.gif"
											),
		"Ingresso_accessibile" => array(
										"label_french" => "Ingresso accessibile (fr)",
										"label_italian" => "Ingresso accessibile",
										"picto" => "themes/".$Default_Theme."/images/atlas/ingresso_accessibile.gif"
								),
		"Ingresso_accessibile_assistito" => array(
												"label_french" => "Ingresso accessibile assistito (fr)",
												"label_italian" => "Ingresso accessibile assistito",
												"picto" => "themes/".$Default_Theme."/images/atlas/ingresso_accessibile_assistito.gif"
											),
		"Ausili_rosa" => array(
							"label_french" => "Ausili rosa (fr)",
							"label_italian" => "Ausili rosa",
							"picto" => "themes/".$Default_Theme."/images/atlas/ausili_rosa.gif"
						),
		"Fondo_percorsi_compatto" => array(
										"label_french" => "Fondo percorsi compatto (fr)",
										"label_italian" => "Fondo percorsi compatto",
										"picto" => "themes/".$Default_Theme."/images/atlas/fondo_percorsi_compatto.gif"
									),
		"Ascensori_accessibili" => array(
										"label_french" => "Ascensori accessibili (fr)",
										"label_italian" => "Ascensori accessibili",
										"picto" => "themes/".$Default_Theme."/images/atlas/ascensori_accessibili.gif"
									),
		"Ascensore_accessibile_assistito" => array(
												"label_french" => "Ascensore accessibile assistito (fr)",
												"label_italian" => "Ascensore accessibile assistito",
												"picto" => "themes/".$Default_Theme."/images/atlas/ascensore_accessibile_assistito.gif"
											),
		"Bagno_accessibile" => array(
									"label_french" => "Bagno accessibile (fr)",
									"label_italian" => "Bagno accessibile",
									"picto" => "themes/".$Default_Theme."/images/atlas/bagno_accessibile.gif"
								),
		"Bagno_accessibile_con_aiuto" => array(
											"label_french" => "Bagno accessibile con aiuto (fr)",
											"label_italian" => "Bagno accessibile con aiuto",
											"picto" => "themes/".$Default_Theme."/images/atlas/bagno_accessibile_con_aiuto.gif"
										)
);

// Accessibilite culturelle
$fr_boolean_site_access_culture = array(
		"Serv.accoglienza_qualificato" => array(
											"label_french" => "Accoglienza qualificato (fr)",
											"label_italian" => "Accoglienza qualificato",
											"picto" => "themes/".$Default_Theme."/images/atlas/accoglienza_qualificato.gif"
										),
		"Ausili_muti" => array(
							"label_french" => "Ausili muti (fr)",
							"label_italian" => "Ausili muti",
							"picto" => "themes/".$Default_Theme."/images/atlas/ausili_muti.gif"			
						),
		"Ausili_sordi_ipovedenti" => array(
										"label_french" => "Ausili sordi ipovedenti (fr)",
										"label_italian" => "Ausili sordi ipovedenti",
										"picto" => "themes/".$Default_Theme."/images/atlas/ausili_sordi_ipovedenti.gif"
									),
		"Ausili_ciechi_ipovedenti" => array(
										"label_french" => "Ausili ciechi ipovedenti (fr)",
										"label_italian" => "Ausili ciechi ipovedenti",
										"picto" => "themes/".$Default_Theme."/images/atlas/ausili_ciechi_ipovedenti.gif"
									),
		"Documenti_accessibili" => array(
										"label_french" => "Documenti accessibili (fr)",
										"label_italian" => "Documenti accessibili",
										"picto" => "themes/".$Default_Theme."/images/atlas/documenti_accessibili.gif"
									),
		"Didascalie_contenuti_audio" => array(
											"label_french" => "Didascalie contenuti audio (fr)",
											"label_italian" => "Didascalie contenuti audio",
											"picto" => "themes/".$Default_Theme."/images/atlas/didascalie_contenuti_audio.gif"
										),
		"Esposizione_calchi_e_modellini" => array(
												"label_french" => "Esposizione calchi e modellini (fr)",
												"label_italian" => "Esposizione calchi e modellini",
												"picto" => "themes/".$Default_Theme."/images/atlas/esposizione_calchi_modellini.gif"
											),
		"Formazione_disabili" => array(
									"label_french" => "Formazione disabili (fr)",
									"label_italian" => "Formazione disabili",
									"picto" => "themes/".$Default_Theme."/images/atlas/formazione_disabili.gif"
								),
		"Promozione_eventi_culturali" => array(
											"label_french" => "Promozione eventi culturali (fr)",
											"label_italian" => "Promozione eventi culturali",
											"picto" => "themes/".$Default_Theme."/images/atlas/promozione_eventi_culturali.gif"
										),
		"Eventi_ristorazione_pernottamento" => array(
													"label_french" => "Eventi ristorazione pernottamento (fr)",
													"label_italian" => "Eventi ristorazione pernottamento",
													"picto" => "themes/".$Default_Theme."/images/atlas/eventi_ristorazione_pernottamento.gif"
												),
		"Eventi_accessibili" => array(
									"label_french" => "Eventi accessibili (fr)",
									"label_italian" => "Eventi accessibili",
									"picto" => "themes/".$Default_Theme."/images/atlas/eventi_accessibili.gif"
								)
);

// Accessibilite virtuelle
$fr_boolean_site_access_virtuelle = array(
		"Reperibilita_informazioni" => array(
											"label_french" => "Reperibilita informazioni (fr)",
											"label_italian" => "Reperibilita informazioni",
											"picto" => "themes/".$Default_Theme."/images/atlas/reperibilita_informazioni.gif"
										),
		"Disp.tramite_web_info_multilingua" => array(
													"label_french" => "Tramite web info multilingua (fr)",
													"label_italian" => "Tramite web info multilingua",
													"picto" => "themes/".$Default_Theme."/images/atlas/tramite_web_info_multilingua.gif"
												),
		"Disp.tramite_web_percorsi_acc" => array(
												"label_french" => "Tramite web percorsi acc (fr)",
												"label_italian" => "Tramite web percorsi acc",
												"picto" => "themes/".$Default_Theme."/images/atlas/tramite_web_percorsi_acc.gif"
											),
		"Disp.tramite_web_info_struttura" => array(
												"label_french" => "Tramite web info struttura (fr)",
												"label_italian" => "Tramite web info struttura",
												"picto" => "themes/".$Default_Theme."/images/atlas/tramite_web_info_struttura.gif"
											),
		"Disp.tramite_web_info_contentuti" => array(
													"label_french" => "Tramite web info contentuti (fr)",
													"label_italian" => "Tramite web info contentuti",
													"picto" => "themes/".$Default_Theme."/images/atlas/tramite_web_info_contentuti.gif"
												),
		"Iniziative_accessibilita" => array(
										"label_french" => " Iniziative accessibilita (fr)",
										"label_italian" => "Iniziative accessibilita",
										"picto" => "themes/".$Default_Theme."/images/atlas/iniziative_accessibilita.gif"
									),
		"Modalita_info_accessibilita_struttura" => array(
														"label_french" => "Modalita info accessibilita struttura (fr)",
														"label_italian" => "Modalita info accessibilita struttura",
														"picto" => "themes/".$Default_Theme."/images/atlas/modalita_info_accessibilita_struttura.gif"
													),
		"Disp.sussidi_accessibili_usabili" => array(
													"label_french" => "Sussidi accessibili usabili (fr)",
													"label_italian" => "Sussidi accessibili usabili",
													"picto" => "themes/".$Default_Theme."/images/atlas/sussidi_accessibili_usabili.gif"
												),
		"Postazioni_multimediali_accessibili" => array(
													"label_french" => "Postazioni multimediali accessibili (fr)",
													"label_italian" => "Postazioni multimediali accessibili",
													"picto" => "themes/".$Default_Theme."/images/atlas/postazioni_multimediali_accessibili.gif"
												),
		"Presenza_mobile_web_App" => array(
										"label_french" => "Presenza mobile web App (fr)",
										"label_italian" => "Presenza mobile web App",
										"picto" => "themes/".$Default_Theme."/images/atlas/presenza_mobile_web_app.gif"
									)
);

// Infos generales
$fr_boolean_site_infos_generales = array(
	"Site_accessit" => array(
							"label_french" => array(
													"Site non Accessit",
													"Site Accessit"
												),
							"label_italian" => array(
													"Sito non Accessit",
													"Sito Accessit"
												),
							"picto" => "themes/".$Default_Theme."/images/atlas/site_accessit.gif"
						)
);

$fr_boolean_site = array_merge(
		$fr_boolean_site_access_physique, 
		$fr_boolean_site_access_culture, 
		$fr_boolean_site_access_virtuelle, 
		$fr_boolean_site_infos_generales
);

$sql_create_table_temp = '

DROP TABLE IF EXISTS `becms_atlas_itineraire_temp`;
CREATE TABLE `becms_atlas_itineraire_temp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_origine` int(11) NOT NULL,
  `Theme` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Circuits` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Nom_itineraire` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Commune` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Telephone` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Messagerie` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Site_web` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Caracteristique_itineraire` text COLLATE latin1_general_ci NOT NULL,
  `Services` text COLLATE latin1_general_ci NOT NULL,
  `Album` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Description` text COLLATE latin1_general_ci NOT NULL,
  `Format_texte` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Infos_supplementaires` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Langue` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Activite_event_territoire` text COLLATE latin1_general_ci NOT NULL,
  `Autres_infos` text COLLATE latin1_general_ci NOT NULL,
  `Pieces_jointes` text COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_origine` (`id_origine`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
				
DROP TABLE IF EXISTS `becms_atlas_site_temp`;
CREATE TABLE `becms_atlas_site_temp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_itineraire` int(11) NOT NULL,
  `Nom` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Langue` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Site_accessit` tinyint(1) NOT NULL,
  `Theme` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Circuits` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Categorie` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Commune` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Localite` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Latitude` double NOT NULL,
  `Longitude` double NOT NULL,
  `Adresse` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Horaires_ouverture` text COLLATE latin1_general_ci NOT NULL,
  `Entree` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Telephone` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Site_web` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Services` text COLLATE latin1_general_ci NOT NULL,
  `Services_specifiques` text COLLATE latin1_general_ci NOT NULL,
  `Raggiungimento_bene` tinyint(1) NOT NULL,
  `Parking_handicape` tinyint(1) NOT NULL,
  `Percorso_accessibile` tinyint(1) NOT NULL,
  `Strutture_disabili` tinyint(1) NOT NULL,
  `Itinerari_accessibili` tinyint(1) NOT NULL,
  `Panorami_accessibili` tinyint(1) NOT NULL,
  `Ass.Barriere_architettoniche` tinyint(1) NOT NULL,
  `Ingresso_accessibile` tinyint(1) NOT NULL,
  `Ingresso_accessibile_assistito` tinyint(1) NOT NULL,
  `Ausili_rosa` tinyint(1) NOT NULL,
  `Fondo_percorsi_compatto` tinyint(1) NOT NULL,
  `Ascensori_accessibili` tinyint(1) NOT NULL,
  `Ascensore_accessibile_assistito` tinyint(1) NOT NULL,
  `Bagno_accessibile` tinyint(1) NOT NULL,
  `Bagno_accessibile_con_aiuto` tinyint(1) NOT NULL,
  `Serv.accoglienza_qualificato` tinyint(1) NOT NULL,
  `Ausili_muti` tinyint(1) NOT NULL,
  `Ausili_sordi_ipovedenti` tinyint(1) NOT NULL,
  `Ausili_ciechi_ipovedenti` tinyint(1) NOT NULL,
  `Documenti_accessibili` tinyint(1) NOT NULL,
  `Didascalie_contenuti_audio` tinyint(1) NOT NULL,
  `Esposizione_calchi_e_modellini` tinyint(1) NOT NULL,
  `Formazione_disabili` tinyint(1) NOT NULL,
  `Promozione_eventi_culturali` tinyint(1) NOT NULL,
  `Eventi_ristorazione_pernottamento` tinyint(1) NOT NULL,
  `Eventi_accessibili` tinyint(1) NOT NULL,
  `Reperibilita_informazioni` tinyint(1) NOT NULL,
  `Disp.tramite_web_info_multilingua` tinyint(1) NOT NULL,
  `Disp.tramite_web_percorsi_acc` tinyint(1) NOT NULL,
  `Disp.tramite_web_info_struttura` tinyint(1) NOT NULL,
  `Disp.tramite_web_info_contentuti` tinyint(1) NOT NULL,
  `Iniziative_accessibilita` tinyint(1) NOT NULL,
  `Modalita_info_accessibilita_struttura` tinyint(1) NOT NULL,
  `Disp.sussidi_accessibili_usabili` tinyint(1) NOT NULL,
  `Postazioni_multimediali_accessibili` tinyint(1) NOT NULL,
  `Presenza_mobile_web_App` tinyint(1) NOT NULL,
  `Album` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Pieces_jointes` text COLLATE latin1_general_ci NOT NULL,
  `Description` text COLLATE latin1_general_ci NOT NULL,
  `Format_texte` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Info_supplementaires` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Activite_event` text COLLATE latin1_general_ci NOT NULL,
  `Divers` varchar(255) COLLATE latin1_general_ci NOT NULL,
  `Altre_informazioni_e_progetti_collegati` text COLLATE latin1_general_ci NOT NULL,
  `Note_accessibilita` text COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;';

$temp = array();
foreach ($it_fr_itineraire as $key=>$value) {
	$temp[strtoupper($key)] = $value;
}
$it_fr_itineraire = $temp;
$temp = null;

$temp = array();
foreach ($it_fr_site as $key=>$value) {
	$temp[strtoupper($key)] = $value;
}
$it_fr_site = $temp;
$temp = null;

$name_table_itineraire_temp = "_atlas_itineraire_temp";
$name_table_site_temp = "_atlas_site_temp";
$name_table_itineraire = "_atlas_itineraire";
$name_table_site = "_atlas_site";

$champs_recherche = array(
		$prefix.$name_table_itineraire.".Nom_itineraire",
		$prefix.$name_table_itineraire.".Commune",
		$prefix.$name_table_itineraire.".Description",
		$prefix.$name_table_itineraire.".Services",
		$prefix.$name_table_site.".Nom",
		$prefix.$name_table_site.".Commune",
		$prefix.$name_table_site.".Localite",
		$prefix.$name_table_site.".Adresse",
		$prefix.$name_table_site.".Description",
		$prefix.$name_table_site.".Activite_event"
);

$withlogfile = false;

if (isset($argv) && (is_array($argv))) {
	foreach($argv as $unparam) {
		switch ($unparam) {
			case "-withlogfile":
				$withlogfile = true;
				break;
		}
	}
}
?>