<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2005 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

//if (!defined('MODULE_FILE')) {
//	die ("You can't access this file directly...");
//}
if (!preg_match("#mobiles.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}
require_once("core/becms_mainlib_lib.php");
//require_once("core/becms_ui_component.php");
//require_once("images/filetypes/filetypes.php");
//require_once("includes/truncate_string.php");

$module_name = basename(dirname(__FILE__));
get_lang($module_name);
$userpage = 1;

//require_once("modules/$module_name/lib_db.php");
require_once("modules/$module_name/utils.php");
require_once ("modules/" . $module_name . "/system/params.php");

/**
 * Permet de crer l'album photo a partir d'un lien
 *
 * @param unknown $url le lien
 * @return string l'album
 */
function createAlbum($album) {
	global $module_name, $separatorImageAlbum;
	$album_photos = '<div class="diaporamazoom"><div class="highslide-gallery">';
	$count = 1;
	$urls = explode($separatorImageAlbum, $album);
	foreach ($urls as $url) {

		/*
		 * $resizedImg = "modules.php?name=becmsGallery&sop=Resizer&imgfile=$laphoto&max_width=800&max_height=800"; $tumbImg = "modules.php?name=becmsGallery&sop=Resizer&imgfile=$laphoto&max_width=100&max_height=100";
		*/
		/*
		 * modules/'.$module_name.'/resizer_small.php?imgfile=../../'.$laphoto.'&max_width=900&max_height=600
		* */
		/*
			$resizedImg = $url;
		$tumbImg = $url;
		$album_photos .= '
		<table border="0" cellpadding="0" cellspacing="0" class="diapo">
		<tr><td>
		<a id="thumb' . $count . '" href="' . $resizedImg . '" class="highslide" onclick="return hs.expand(this)"><img src="' . $tumbImg . '" alt="' . $nom . '" title="Click to enlarge" style="max-width: 260px; max-height: 200px;" /></a>
		<div class="highslide-heading">
		' . $nom . '
		</div>';*/
		$resizedImg = $url;
		$tumbImg =  'modules/'.$module_name.'/resizer_small.php?imgfile=../../'.$url.'&max_width=260&max_height=200';
		$album_photos .= '
			<table border="0" cellpadding="0" cellspacing="0" class="diapo">
			<tr><td>
			<a id="thumb' . $count . '" href="' . $resizedImg . '" class="highslide" onclick="return hs.expand(this)"><img src="' . $tumbImg . '" alt="' . $nom . '" title="Click to enlarge" /></a>
			<div class="highslide-heading">
				' . $nom . '
			</div>';

		$photo_comments = $credit;
		if ($photo_comments != "") {
			$album_photos .= '
				<div class="highslide-caption">
					' . $photo_comments . '
				</div>';
		}
		$album_photos .= '</td></tr></table>';
		$count ++;
	}
	$album_photos .= '</div></div>';
	return $album_photos;
}

function show_accueil() {
	global $_headerContent, $module_name, $Default_Theme;
	
	$_headerContent .= '
			<script type="text/javascript" src="modules/javascripts/jquery-1.6.2.min.js"></script>
			<script type="text/javascript" src="modules/'.$module_name.'/lib/lib_open_box.js"></script>
			<script type="text/javascript">
				$(function() {
					$(\'.divBox\').hide();
					clickShowAndHide("box", "divb", 5, 1000);
				});
			</script>
			';
	include("header_mobile.php");
	
	$sortie .= '<div id="barre_btn"><a href="mobiles.php?name='.$module_name.'&op=map_itineraires"><img height="33" src="themes/'.$Default_Theme.'/images/btn_geo.png" alt="" /></a>
<!--<div class="cale">&nbsp;</div>
<a href="#"><img height="30" src="themes/'.$Default_Theme.'/images/btn_geo.png" alt="" /></a>--></div>
<h1>Temi / Thmes</h1>
<div class="ecran">
<table cellspacing="0" cellpadding="0" border="0" style="width: 100%; height: 100%">
    <tbody>
        <tr style="height: 32%">
            <td><a href="mobiles.php?name=atlas_accessit&op=map_itineraires&theme=Archeologia" style="display:block; border-radius: 8px; background-color: #751f5a;height: 100%;vertical-align: middle">
            <table width="100%" cellspacing="0" cellpadding="0" border="0" height="100%">
                <tbody>
                    <tr>
                        <td>
                        <table width="100%" cellspacing="0" cellpadding="0" border="0">
                            <tbody>
                                <tr>
                                    <td width="20">&nbsp;</td>
                                    <td width="43"><img width="43" height="50" alt="" src="themes/'.$Default_Theme.'/images/pointgeo.png" /></td>
                                    <td style="font-family:Arial, Helvetica, sans-serif;font-size:16px;line-height:25px;
                                    font-weight:bold; color: #fff; text-transform: uppercase; text-align:center">Archeologia<br />
                                    Arch&eacute;ologie</td>
                                </tr>
                            </tbody>
                        </table>
                        </td>
                    </tr>
                </tbody>
            </table>
            </a></td>
        </tr>
        <tr style="height: 2%">
            <td>
            <div style="display: none">&nbsp;</div>
            </td>
        </tr>
        <tr style="height: 32%">
            <td><a href="mobiles.php?name=atlas_accessit&op=map_itineraires&theme=Cultura del Mare" style="display:block; border-radius: 8px; background-color: #1ea99a;height: 100%;vertical-align: middle">
            <table width="100%" cellspacing="0" cellpadding="0" border="0" height="100%">
                <tbody>
                    <tr>
                        <td>
                        <table width="100%" cellspacing="0" cellpadding="0" border="0">
                            <tbody>
                                <tr>
                                    <td width="20">&nbsp;</td>
                                    <td width="43"><img width="43" height="50" alt="" src="themes/'.$Default_Theme.'/images/pointgeo.png" /></td>
                                    <td style="font-family:Arial, Helvetica, sans-serif;font-size:16px;line-height:25px;
                                    font-weight:bold; color: #fff; text-transform: uppercase; text-align:center">Cultura del mare<br />
                                    Culture maritime</td>
                                </tr>
                            </tbody>
                        </table>
                        </td>
                    </tr>
                </tbody>
            </table>
            </a></td>
        </tr>
        <tr style="height: 2%">
            <td>
            <div style="display: none">&nbsp;</div>
            </td>
        </tr>
        <tr style="height: 32%">
            <td><a href="mobiles.php?name=atlas_accessit&op=map_itineraires&theme=Identita del Territorio" style="display:block; border-radius: 8px; background-color: #f29400;height: 100%;vertical-align: middle">
            <table width="100%" cellspacing="0" cellpadding="0" border="0" height="100%">
                <tbody>
                    <tr>
                        <td>
                        <table width="100%" cellspacing="0" cellpadding="0" border="0">
                            <tbody>
                                <tr>
                                    <td width="20">&nbsp;</td>
                                    <td width="43"><img width="43" height="50" alt="" src="themes/'.$Default_Theme.'/images/pointgeo.png" /></td>
                                    <td style="font-family:Arial, Helvetica, sans-serif;font-size:16px;line-height:25px;
                                    font-weight:bold; color: #fff; text-transform: uppercase; text-align:center">Identit&agrave; del Territorio<br />
                                    Identit&eacute; du Territoire</td>
                                </tr>
                            </tbody>
                        </table>
                        </td>
                    </tr>
                </tbody>
            </table>
            </a></td>
        </tr>
    </tbody>
</table>
</div>';
	
	$sortie = utilFuncs_atlas::conditionnerMobile($sortie);
	echo $sortie;
	include("footer_mobile.php");
}

function show_map_itineraires($theme, $circuit) {
	global $module_name, $Default_Theme;
	global $carteAtlasMobile, $icon_plus_infos;
	global $withrewriting, $lienFicheItineraireMobile, $lienCourtFicheItineraireMobile, $icon_control_circuit, $dicotheme, $colortheme;
	global $_headerContent;
	
	/*if( $withrewriting ) {
		$lienItineraire = $lienCourtFicheItineraireMobile;
	} else {
		$lienItineraire = $lienFicheItineraireMobile;
	}*/
	$lienItineraire = $lienFicheItineraireMobile;
	
	foreach ($icon_control_circuit as $key => $value) {
		$array_icon_control .= 'options["icon_control_circuit"]["'.$key.'"] = "'.$value.'";
				';
	}
	foreach ($dicotheme as $key => $value) {
		$key = utilFuncs_atlas::noaccent($key);
		$array_titre_theme .= 'options["titre_theme"]["'.$key.'"] = "'.$value.'";
				';
	}
	foreach ($colortheme as $key => $value) {
		$array_color_theme .= 'options["color_theme"]["'.$key.'"] = "'.$value.'";
				';
	}
	
	
	$_headerContent .= utilFuncs_atlas::conditionnerMobile('
		<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAgE7r6EIas9zvUYnxgcRb8v6BfyAeB9Yc&sensor=false" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/'.$module_name.'/lib/lib_autostart.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/'.$module_name.'/lib/lib_XML_parser.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/'.$module_name.'/lib/lib_AJAX.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/'.$module_name.'/lib/lib_string_mobile.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/'.$module_name.'/lib/lib_carto_symb_itineraires_mobile.js" charset="UTF-8"></script>
			
		<script type="text/javascript">
			//<![CDATA[
				var options = new Array;
				options["icon_plus_infos"] = "'.$icon_plus_infos.'";
				options["rewrite"] = '.$withrewriting.'
				options["lienItineraire"] = "'.$lienItineraire.'"
				var racine_lib_module = "modules/SimpleCarto/lib";
				options["icon_control_circuit"] = new Array;
				options["titre_theme"] = new Array;
				options["color_theme"] = new Array;
				'.$array_icon_control.$array_titre_theme.$array_color_theme.'
	    	//]]>
	    </script>
	    <script type="text/javascript">
			// <![CDATA[
				addToStart("GetMap('.$carteAtlasMobile.', \''.$theme.'\', \''.$circuit.'\', \'\')");
			// ]]>
		</script>

	    <link href="themes/'.$Default_Theme.'/style/SimpleCarto.css" rel="stylesheet" type="text/css" media="all"/>');
	
	include("header_mobile.php");
	$sortie = "";
	$sortie .= '<div id="barre_btn"><a href="mobiles.php?name='.$module_name.'"><img height="26" src="themes/'.$Default_Theme.'/images/btn_themes.png" alt="" /></a></div>
<h1>Temi / Thmes</h1>
<div id="map" class="ecran"></div>';
	$sortie = utilFuncs_atlas::conditionnerMobile($sortie);
	echo $sortie;
	
	$bardef=array("back"=>"javascript:window.history.back()");
	buttonBar($bardef, "align");
	include("footer_mobile.php");
}

/**
 * Permet de retourner et d'afficher la carte en fonction du xml
 * @param unknown $theme le theme
 * @param unknown $circuit le circuit
 * @param unknown $rech la recherche
 */
function get_map_pict_XML_itineraires($theme, $circuit, $rech) {
	global $module_name, $Idc;
	require_once ("modules/" . $module_name . "/lib/getXMLcarto_pict_itineraires_mobile.php");
	$sortie = getXMLcarto ( $Idc, $theme, $circuit, $rech );
	header ( "Content-Type: text/xml; charset=UTF-8" );
	echo $sortie;
}

function case_infos($contenu) {
	$sortie = "";
	if ($contenu != "") {
		$sortie .= '<div class="case_info">'.$contenu.'</div>';
	}
	return $sortie;
}

function titrer_info($texte, $titre="") {
	$sortie = "";
	if ($texte != "") {
		$sortie .= '<p style="margin: 4px 0;"><span class="titre">'.$titre.'</span>'.$texte.'</p>';
	}
	return $sortie;
}

function tableau($contenu) {
	$sortie = "";
	if ($contenu != "") {
		$sortie .= '<table cellpadding="0" cellspacing="0" border="0">'.$contenu.'</table>';
	}
	return $sortie;
}
function titrer_info_tab($texte, $titre="") {
	$sortie = "";
	if ($texte != "") {
		$sortie .= '<tr><td class="titre">'.$titre.'</td><td class="texte">'.$texte.'</td></tr>';
	}
	return $sortie;
}

function show_map_fiche_itineraire($idItineraire) {
	global $module_name, $Default_Theme;
	global $carteAtlasMobile, $icon_plus_infos;
	global $withrewriting, $lienFicheSiteMobile, $lienCourtFicheSiteMobile, $icon_control_circuit, $dicotheme, $colortheme;
	global $_headerContent;
	global $prefix, $name_table_itineraire, $db;
	
	/*if( $withrewriting ) {
		$lienSite = $lienCourtFicheSiteMobile;
	} else {
		$lienSite = $lienFicheSiteMobile;
	}*/
	$lienSite = $lienFicheSiteMobile;
	
	foreach ($icon_control_circuit as $key => $value) {
		$array_icon_control .= 'options["icon_control_circuit"]["'.$key.'"] = "'.$value.'";
				';
	}
	
	$_headerContent .= '
		<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAgE7r6EIas9zvUYnxgcRb8v6BfyAeB9Yc&sensor=false" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/'.$module_name.'/lib/lib_autostart.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/'.$module_name.'/lib/lib_XML_parser.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/'.$module_name.'/lib/lib_AJAX.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/'.$module_name.'/lib/lib_string_mobile.js"></script>
		<script type="text/javascript" src="modules/'.$module_name.'/lib/lib_carto_symb_fiche_itineraire_mobile.js" charset="UTF-8"></script>
	
		<script type="text/javascript">
			//<![CDATA[
				var options = new Array;
				options["icon_plus_infos"] = "'.$icon_plus_infos.'";
				options["rewrite"] = '.$withrewriting.'
				options["lienSite"] = "'.$lienSite.'"
				var racine_lib_module = "modules/SimpleCarto/lib";
				options["icon_control_circuit"] = new Array;
				'.$array_icon_control.'
			//]]>
	    </script>
	    <script type="text/javascript">
			// <![CDATA[
				addToStart("GetMap('.$carteAtlasMobile.', \''.$idItineraire.'\', \'\', \'\')");
			// ]]>
		</script>
		<script type="text/javascript">
			// <![CDATA[
			function clic_fiche(lestyle) {
				document.getElementById("titre_page").className = lestyle+"bis";
				document.getElementById("div_map_itineraire").style.display = "none";
				document.getElementById("div_fiche_itineraire").style.display = "block";
				document.getElementById("btn_geo").style.backgroundColor = "#fff";
				document.getElementById("btn_fiche").style.backgroundColor = "#aaa";
			}
			function clic_geo(lestyle) {
				document.getElementById("titre_page").className = lestyle;
				document.getElementById("div_map_itineraire").style.display = "block";
				document.getElementById("div_fiche_itineraire").style.display = "none";
				document.getElementById("btn_geo").style.backgroundColor = "#aaa";
				document.getElementById("btn_fiche").style.backgroundColor = "#fff";
			}
			function placerfond(eltname) {
				var body = document.body,
    			html = document.documentElement;
				var height = Math.max(body.scrollHeight, body.offsetHeight, html.clientHeight, html.scrollHeight, html.offsetHeight);
				var decal = jQuery("div#"+eltname).css("top");
				decal = decal.replace("px", "");
				var decalpad1 = jQuery("div#"+eltname).css("padding-top");
				decalpad1 = decalpad1.replace("px", "");
				var decalpad2 = jQuery("div#"+eltname).css("padding-top");
				decalpad2 = decalpad2.replace("px", "");				
				jQuery("#"+eltname).height(height-eval(decal) - eval(decalpad1) - eval(decalpad1));
			}
			function show_infos() {
				//alert(jQuery("#div_fiche_itineraire").findPos().y);
				//$("body").bind("touchmove", function(e){e.preventDefault()});
				//alert(jQuery("#div_fiche_itineraire").height() + "px");
				//jQuery("#plusinfos").height(jQuery("#div_fiche_itineraire").height());
				placerfond("plusinfos");
				document.getElementById("plusinfos").style.display = "block";
			}
			function show_contacts() {
				//$("body").bind("touchmove", function(e){e.preventDefault()});
				placerfond("pluscontacts");
				document.getElementById("pluscontacts").style.display = "block";
			}
			function hide_infos() {
				document.getElementById("plusinfos").style.display = "none";
				document.getElementById("pluscontacts").style.display = "none";
				//$("body").unbind("touchmove");
			}
			// ]]>
		</script>
		
		<script type="text/javascript" src="modules/becmsGallery/type/mobile_gallery/photoswipe/js/klass.min.js"></script>
		<script type="text/javascript" src="modules/becmsGallery/type/mobile_gallery/photoswipe/js/code.photoswipe.jquery-3.0.5.min.js"></script>
		<script type="text/javascript">
			$(document).ready(function (){
					if (jQuery("div.photoEntete a").length > 0) {
						var myPhotoSwipe = jQuery("div.photoEntete a").photoSwipe({ 
							enableMouseWheel: false , 
							enableKeyboard: false,
							minUserZoom : 1,
							maxUserZoom : 5
						});
					}
				}
			);
		</script>
<link rel="stylesheet" type="text/css" href="modules/becmsGallery/type/mobile_gallery/photoswipe/css/default.css" />
		
	    <link href="themes/'.$Default_Theme.'/style/SimpleCarto.css" rel="stylesheet" type="text/css" media="all"/>';
	
	include("header_mobile.php");
	
	// Lecture de la table itineraire et recuperation des infos le concernent
	$sql = "SELECT * FROM `" . $prefix . $name_table_itineraire . "` WHERE `id`=" . $idItineraire;
	$search = $db->sql_query ( $sql );
	if ($db->sql_numrows ( $search ) != 0) {
		$donnees = $db->sql_fetchrow ( $search );
	
		$desc = nl2br(trim($donnees ['Description']));
		$nom = $donnees ['Nom_itineraire'];
		$circuit = (isset($dicotheme[$donnees['Circuits']])) ? $dicotheme[$donnees ['Circuits']] : $donnees ['Circuits'];
		$theme = (isset($dicotheme[$donnees['Theme']])) ? $dicotheme[$donnees ['Theme']] : $donnees ['Theme'];
		$commune = $donnees ['Commune'];
		$tel = $donnees ['Telephone'];
		$messagerie = $donnees ['Messagerie'];
		$siteWeb = $donnees ['Site_web'];
		$caract = nl2br(trim($donnees ['Caracteristique_itineraire']));
		$services = nl2br(trim($donnees ['Services']));
		$activ_event = nl2br(trim($donnees ['Activite_event_territoire']));
		$pieceJointe = $donnees ['Pieces_jointes'];
		$album = $donnees ['Album'];
		$infosSupplement = trim($donnees['Infos_supplementaires']);
		$autresInfos = trim(nl2br(trim($donnees['Autres_infos'])));
		
		$classstyle = "";
		if ($theme != "") {
			if (preg_match("#^Archeologia#", $theme)) $classstyle="archeo";
			if (preg_match("#^Identit#", $theme)) $classstyle="identite";
			if (preg_match("#^Cultura#", $theme)) $classstyle="culture";
		} 
	
		// Test
		if( $nom != "" )
			$nomStr = '<tr><td>Nom</td><td>'.$nom.'</td></tr>';
		if($desc != "")
			$descStr = '<tr><td>Description</td><td>'.$desc.'</td></tr>';
		if( $theme != "")
			$ThemeStr = '<tr><td>Theme</td><td>'.$theme.'</td></tr>';
		if( $circuit != "")
			$circuitStr = '<tr><td>Circuit</td><td>'.$circuit.'</td></tr>';
		if(tel != "")
			$telStr = '<tr><td>Tel</td><td>'.$tel.'</td></tr>';
		if($messagerie != "")
			$messagerieStr = '<tr><td>Messagerie</td><td>'.$messagerie.'</td></tr>';
		if($siteWeb != "")
			$siteWebStr = '<tr><td>Site web</td><td>'.$siteWeb.'</td></tr>';
		if($caract != "")
			$caractStr = '<tr><td>Caract</td><td>'.$caract.'</td></tr>';
		if($services != "")
			$servicesStr = '<tr><td>Services</td><td>'.$services.'</td></tr>';
		if($activ_event != "")
			$activ_eventStr = '<tr><td>Activ event</td><td>'.$activ_event.'</td></tr>';
		if($pieceJointe != "")
			$pieceJointeStr = '<tr><td>Piece jointe</td><td>'.$pieceJointe.'</td></tr>';
		if($infosSupplement != "")
			$infosSupplementStr = '<tr><td>Info supplement</td><td>'.$infosSupplement.'</td></tr>';
		if($autresInfos != "")
			$autresInfosStr = '<tr><td>Autres infos</td><td>'.$autresInfos.'</td></tr>';
		if ($album != "") {
			//$albumStr = createAlbum ( $album );
			$albumStr = '<tr><td>Album</td><td>'.$album.'</td></tr>';
		}
		// Fin Test
	}
	
	$sortie = "";
	
	$sortie .= '<div id="barre_btn">
<a href="#" onclick="clic_geo(\''.$classstyle.'\');return false" id="btn_geo" style="background-color: #aaa;"><img src="themes/'.$Default_Theme.'/images/btn_geo.png" alt="" height="33" /></a>
<div class="cale">&nbsp;</div>
<a href="#" onclick="clic_fiche(\''.$classstyle.'\');return false" id="btn_fiche" style="background-color: #fff;"><img src="themes/'.$Default_Theme.'/images/btn_fiche.png" alt="" height="30" /></a></div>
<h1 id="titre_page" class="'.$classstyle.'">'.$nom.'</h1>';

	$sortie .= '<div id="div_fiche_itineraire" class="ecran" style="display: none;">';
	if ($circuit != "") {
		$sortie .= '<h2 class="'.$classstyle.'">'.$circuit.'</h2>';
	}
	if ($album != "") {
		$sortie .= '<div class="photoEntete" style="visibility: visible;"><a href="modules/atlas_accessit/resizer_small.php?imgfile=../../'.$album.'&max_width=1024&max_height=1024"><img src="modules/atlas_accessit/resizer_small.php?imgfile=../../'.$album.'&max_width=1024&max_height=1024"></a></div>';
	}
	$sortie .= '<div id="barre_btn_atlas" class="'.$classstyle.'">
<a href="#" onclick="show_infos(); return false;"><img src="themes/'.$Default_Theme.'/images/btn_infos.png" alt="" height="25" /></a>
<div class="cale">&nbsp;</div>
<a href="#" onclick="show_contacts(); return false;return false"><img src="themes/'.$Default_Theme.'/images/btn_url.png" alt="" height="25" /></a></div>';
	$sortie .= '<div style="margin:0; padding: 0; line-height: 0; height: 0; clear: both;"></div>';
	if ($desc != "") {
		$sortie .= '<p>'.$desc.'</p>';
	}
	if ($caract != "") {
		$sortie .= '<h3 class="'.$classstyle.'">'.'Caratteristiche dell\'intinerario /<br />Caractristiques de l\'itinraire : '.'</h3>'.'<p>'.$caract.'</p>';
	}
	/*$sortie .= '<table border="1">';
	$sortie .= $nomStr.$descStr.$ThemeStr.$circuitStr.$telStr.$messagerieStr.$siteWebStr.$caractStr.$servicesStr.$activ_eventStr
	.$pieceJointeStr.$infosSupplementStr.$autresInfosStr.$albumStr;
	$sortie .= '</table>';*/
	$sortie .= '</div>';
	
	$pieceJointeStr = ""; 
	if ($pieceJointe != "") {
		$pieceJointeStr = '<a href="' . $pieceJointe . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/docs'.$classstyle.'.gif" border="0">'.'</a>';
	}
		
	$contenu_infs = case_infos(tableau(
		titrer_info_tab($services, "Servizi / Services :")
		.titrer_info_tab($activ_event, 'Attivit ed eventi sul territorio /<br />Activits sur le territoire : ')
		.titrer_info_tab($infosSupplement, 'Ulteriori materiali  / Informations supplmentaires : ')
		.titrer_info_tab($autresInfos,'Altre informazioni  /<br />Autres informations : ')
		.titrer_info_tab($pieceJointeStr,'Allegati Itinerario /<br /> Pices jointes : : ')
		));
	
	$btn_close_info = '<a href="#" onclick="hide_infos(); return false"><img src="themes/'.$Default_Theme.'/images/btn_close_infos.png" height="14" align="top" border="0" style="float: right" ></a>';
		
	$sortie .= '<div id="plusinfos" class="'.$classstyle.'"><div class="contour">
	<h2>'.$btn_close_info.'Informazioni / Informations</h2>
	<div class="marge">
	'.($contenu_infs != "" ? $contenu_infs : "<p>Non sono disponibili ulteriori informazioni.<br />Aucune information supplmentaire n'est disponible.</p>").'
	</div>
	</div></div>';
	
	$siteWebStr = "";
	if ($siteWeb != "") {
		$siteWebStr = '<a href="'.$siteWeb.'" target="_blank">'.$siteWeb.'</a>';
	}
	$messagerieStr = "";
	if ($messagerie != "") {
		$messagerieStr =  '<a href="mailto:'.$messagerie.'" target="_blank">'.$messagerie.'</a>';
	}
	
	$contenu_conts = case_infos(tableau(
		titrer_info_tab($tel, "Telefono / Tlphone : ")
		.titrer_info_tab($messagerieStr, 'E-mail / Courriel : ')
		.titrer_info_tab($siteWebStr,'Sito web / Site WEB : ')
		));
	
	$sortie .= '<div id="pluscontacts" class="'.$classstyle.'"><div class="contour">
	<h2>'.$btn_close_info.'Contatti / Contacts</h2>
	<div class="marge">
	'.($contenu_conts != "" ? $contenu_conts : "<p>Non sono disponibili ulteriori informazioni.<br />Aucune information supplmentaire n'est disponible.</p>").'
	</div>
	</div></div>';

	//$sortie .= titrer_info($commune,'Commune / Commune');
	
	$sortie .= '<div id="div_map_itineraire" style="display: block;">';
	$sortie .= '<div id="map" class="ecran"></div>';
	$sortie .= '</div>';
	
	$sortie = utilFuncs_atlas::conditionnerMobile($sortie);
	echo $sortie;
	
	$bardef=array("back"=>"javascript:window.history.back()");
	buttonBar($bardef, "align");
	include("footer_mobile.php");
}

/**
 * Retourne et affiche la carte des sites en fonction de l'id d'un itineraire
 * @param unknown $idItineraire l'id de l'itineraire
 */
function get_map_pict_XML_fiche_itineraire($idItineraire) {
	global $module_name, $Idc;
	require_once ("modules/" . $module_name . "/lib/getXMLcarto_pict_fiche_itineraire_mobile.php");
	$sortie = getXMLcarto ( $Idc, $idItineraire );
	header ( "Content-Type: text/xml; charset=UTF-8" );
	echo $sortie;
}

function show_map_fiche_site($idSite) {
	global $module_name, $Default_Theme;
	global $carteAtlasMobile;
	global $_headerContent, $db, $prefix, $name_table_site;
	global $fr_boolean_site_access_physique, $fr_boolean_site_access_culture, $fr_boolean_site_access_virtuelle, $fr_boolean_site_infos_generales;
	global $dicotheme;
	global $lienFicheSiteMobile, $icon_control_circuit, $icon_plus_infos, $withrewriting;
	
	$lienSite = $lienFicheSiteMobile;
	
	foreach ($icon_control_circuit as $key => $value) {
		$array_icon_control .= 'options["icon_control_circuit"]["'.$key.'"] = "'.$value.'";
				';
	}
	
	$_headerContent .= '
		<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAgE7r6EIas9zvUYnxgcRb8v6BfyAeB9Yc&sensor=false" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/'.$module_name.'/lib/lib_autostart.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/'.$module_name.'/lib/lib_XML_parser.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/'.$module_name.'/lib/lib_AJAX.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/'.$module_name.'/lib/lib_string_mobile.js"></script>
		<script type="text/javascript" src="modules/'.$module_name.'/lib/lib_carto_symb_fiche_site_mobile.js" charset="UTF-8"></script>
	
		<script type="text/javascript">
			//<![CDATA[
				var options = new Array;
				options["icon_plus_infos"] = "'.$icon_plus_infos.'";
				options["rewrite"] = '.$withrewriting.'
				options["lienSite"] = "'.$lienSite.'"
				var racine_lib_module = "modules/SimpleCarto/lib";
				options["icon_control_circuit"] = new Array;
				'.$array_icon_control.'
	    	//]]>
	    </script>
	    <script type="text/javascript">
			// <![CDATA[
			//addToStart("GetMap('.$carteAtlasMobile.', \''.$idSite.'\', \'\', \'\')");
			// ]]>
		</script>

		<script type="text/javascript">
			// <![CDATA[
			function clic_fiche(lestyle) {
				document.getElementById("titre_page").className = lestyle+"bis";
				document.getElementById("div_map_itineraire").style.display = "none";
				document.getElementById("div_fiche_itineraire").style.display = "block";
				document.getElementById("btn_geo").style.backgroundColor = "#fff";
				document.getElementById("btn_fiche").style.backgroundColor = "#aaa";
			}
			function clic_geo(lestyle) {
				document.getElementById("titre_page").className = lestyle;
				document.getElementById("div_map_itineraire").style.display = "block";
				document.getElementById("div_fiche_itineraire").style.display = "none";
				document.getElementById("btn_geo").style.backgroundColor = "#aaa";
				document.getElementById("btn_fiche").style.backgroundColor = "#fff";
				if (map ==  null) {
					GetMap('.$carteAtlasMobile.', \''.$idSite.'\', \'\', \'\');
				}
			}
			function placerfond(eltname) {
				var body = document.body,
    			html = document.documentElement;
				var height = Math.max(body.scrollHeight, body.offsetHeight, html.clientHeight, html.scrollHeight, html.offsetHeight);
				var decal = jQuery("div#"+eltname).css("top");
				decal = decal.replace("px", "");
				var decalpad1 = jQuery("div#"+eltname).css("padding-top");
				decalpad1 = decalpad1.replace("px", "");
				var decalpad2 = jQuery("div#"+eltname).css("padding-bottom");
				decalpad2 = decalpad2.replace("px", "");				
				jQuery("#"+eltname).height(height-eval(decal) - eval(decalpad1) - eval(decalpad1));
			}
			function show_infos() {
				//alert(jQuery("#div_fiche_itineraire").findPos().y);
				//$("body").bind("touchmove", function(e){e.preventDefault()});
				//alert(jQuery("#div_fiche_itineraire").height() + "px");
				//jQuery("#plusinfos").height(jQuery("#div_fiche_itineraire").height());
				placerfond("plusinfos");
				document.getElementById("plusinfos").style.display = "block";
			}
			function show_contacts() {
				//$("body").bind("touchmove", function(e){e.preventDefault()});
				placerfond("pluscontacts");
				document.getElementById("pluscontacts").style.display = "block";
			}
			function hide_infos() {
				document.getElementById("plusinfos").style.display = "none";
				document.getElementById("pluscontacts").style.display = "none";
				//$("body").unbind("touchmove");
			}
			// ]]>
		</script>
		
		<script type="text/javascript" src="modules/becmsGallery/type/mobile_gallery/photoswipe/js/klass.min.js"></script>
		<script type="text/javascript" src="modules/becmsGallery/type/mobile_gallery/photoswipe/js/code.photoswipe.jquery-3.0.5.min.js"></script>
		<script type="text/javascript">
			$(document).ready(function (){
					if (jQuery("div.photoEntete a").length > 0) {
						var myPhotoSwipe = jQuery("div.photoEntete a").photoSwipe({ 
							enableMouseWheel: false , 
							enableKeyboard: false,
							minUserZoom : 1,
							maxUserZoom : 5
						});
					}
				}
			);
		</script>
		<link rel="stylesheet" type="text/css" href="modules/becmsGallery/type/mobile_gallery/photoswipe/css/default.css" />
		
	    <link href="themes/'.$Default_Theme.'/style/SimpleCarto.css" rel="stylesheet" type="text/css" media="all"/>';
	
	include("header_mobile.php");
	$sortie = "";
	
	// Lecture et recuperation des infos concernant le site
	$sql = "SELECT * FROM `".$prefix.$name_table_site."` WHERE `id`=". $idSite;
	$search = $db->sql_query ( $sql );
	if ($db->sql_numrows ( $search ) != 0) {
		$donnees = $db->sql_fetchrow ( $search );
/**/		$nom = $donnees['Nom'];
/**/		$circuits = (isset($dicotheme[$donnees['Circuits']])) ? $dicotheme[$donnees ['Circuits']] : $donnees ['Circuits'];
		$theme = (isset($dicotheme[$donnees['Theme']])) ? $dicotheme[$donnees ['Theme']] : $donnees ['Theme'];
/**/		$categorie = $donnees['Categorie'];
/**/		$commune = $donnees['Commune'];
/**/		$localite = $donnees['Localite'];
/**/		$latitude = $donnees['Latitude'];
/**/		$longitude = $donnees['Longitude'];
/**/		$adresse = nl2br(trim($donnees['Adresse']));
/**/		$horairesOuverture = nl2br(trim($donnees['Horaires_ouverture']));
/**/		$entree = nl2br(trim($donnees['Entree']));
/**/		$tel = $donnees['Telephone'];
/**/		$siteWeb = $donnees['Site_web'];
/**/		$services = nl2br(trim($donnees['Services']));
/**/		$servicesSpe = nl2br(trim($donnees['Services_specifiques']));
/**/		$album = $donnees['Album'];
/**/		$piecesJointes = $donnees['Pieces_jointes'];
/**/		$desc = nl2br(trim($donnees['Description']));
/**/		$infosSupplement = $donnees['Info_supplementaires'];
/**/		$activiteEvent = $donnees['Activite_event'];
/**/		$divers = $donnees['Divers'];
/**/		$autresInfos = nl2br(trim($donnees['Altre_informazioni_e_progetti_collegati']));
/**/		$noteAccessibilite = nl2br(trim($donnees['Note_accessibilita']));
/**/		$siteAccessit = $donnees['Site_accessit'];
	
		$messagerie = "";
	
		$arrayAccessPhysique = array();
		foreach ($fr_boolean_site_access_physique as $champ => $arrayAccess) {
			if( isset($donnees[$champ]) && $donnees[$champ] == 1 ) {
				$arrayAccessPhysique[$champ] = $arrayAccess;
			}
		}
	
		$arrayAccessCulture = array();
		foreach ($fr_boolean_site_access_culture as $champ => $arrayAccess) {
			if( isset($donnees[$champ]) && $donnees[$champ] == 1 ) {
				$arrayAccessCulture[$champ] = $arrayAccess;
			}
		}
	
		$arrayAccessVirtuelle = array();
		foreach ($fr_boolean_site_access_virtuelle as $champ => $arrayAccess) {
			if( isset($donnees[$champ]) && $donnees[$champ] == 1 ) {
				$arrayAccessVirtuelle[$champ] = $arrayAccess;
			}
		}
		
		$classstyle = "";
		if ($theme != "") {
			if (preg_match("#^Archeologia#", $theme)) $classstyle="archeo";
			if (preg_match("#^Identit#", $theme)) $classstyle="identite";
			if (preg_match("#^Cultura#", $theme)) $classstyle="culture";
		} 
	
		// test
		if($nom != "")
			$nomStr = '<tr><td>Nom</td><td>'.$nom.'</td></tr>';
		if($circuits != "")
			$circuitsStr = '<tr><td>Circuit</td><td>'.$circuits.'</td></tr>';
		if($theme != "")
			$themeStr = '<tr><td>Theme</td><td>'.$theme.'</td></tr>';
		if($categorie != "")
			$categorieStr = '<tr><td>categorie</td><td>'.$categorie.'</td></tr>';
		if($commune != "")
			$communeStr = '<tr><td>commune</td><td>'.$commune.'</td></tr>';
		if($localite != "")
			$localiteStr = '<tr><td>localite</td><td>'.$localite.'</td></tr>';
		if($latitude != "")
			$latitudeStr = '<tr><td>latitude</td><td>'.$latitude.'</td></tr>';
		if($longitude != "")
			$longitudeStr = '<tr><td>longitude</td><td>'.$longitude.'</td></tr>';
		if($adresse != "")
			$adresseStr = '<tr><td>adresse</td><td>'.$adresse.'</td></tr>';
		if($horairesOuverture != "")
			$horairesOuvertureStr = '<tr><td>horairesOuverture</td><td>'.$horairesOuverture.'</td></tr>';
		if($entree != "")
			$entreeStr = '<tr><td>entree</td><td>'.$entree.'</td></tr>';
		if($tel != "")
			$telStr = '<tr><td>tel</td><td>'.$tel.'</td></tr>';
		if($siteWeb != "")
			$siteWebStr = '<tr><td>siteWeb</td><td>'.$siteWeb.'</td></tr>';
		if($services != "")
			$servicesStr = '<tr><td>services</td><td>'.$services.'</td></tr>';
		if($servicesSpe != "")
			$servicesSpeStr = '<tr><td>servicesSpe</td><td>'.$servicesSpe.'</td></tr>';
		if($piecesJointes != "")
			$piecesJointesStr = '<tr><td>piecesJointes</td><td>'.$piecesJointes.'</td></tr>';
		if($desc != "")
			$descStr = '<tr><td>desc</td><td>'.$desc.'</td></tr>';
		if($infosSupplement != "")
			$infosSupplementStr = '<tr><td>infosSupplement</td><td>'.$infosSupplement.'</td></tr>';
		if($activiteEvent != "")
			$activiteEventStr = '<tr><td>activiteEvent</td><td>'.$activiteEvent.'</td></tr>';
		if($divers != "")
			$diversStr = '<tr><td>divers</td><td>'.$divers.'</td></tr>';
		if($autresInfos != "")
			$autresInfosStr = '<tr><td>autresInfos</td><td>'.$autresInfos.'</td></tr>';
		if($noteAccessibilite != "")
			$noteAccessibiliteStr = '<tr><td>noteAccessibilite</td><td>'.$noteAccessibilite.'</td></tr>';
		if($siteAccessit != "")
			$siteAccessitStr = '<tr><td>siteAccessit</td><td>'.$siteAccessit.'</td></tr>';
		if ($album != "") {
			//$albumStr = createAlbum ( $album );
			$albumStr = '<tr><td>Album</td><td>'.$album.'</td></tr>';
		}
		//fin test
	}
	
	$sortie .= '<div id="barre_btn">
<a href="#" onclick="clic_geo(\''.$classstyle.'\');return false" id="btn_geo" style="background-color: #fff;"><img src="themes/'.$Default_Theme.'/images/btn_geo.png" alt="" height="33" /></a>
<div class="cale">&nbsp;</div>
<a href="#" onclick="clic_fiche(\''.$classstyle.'\');return false" id="btn_fiche" style="background-color: #aaa;"><img src="themes/'.$Default_Theme.'/images/btn_fiche.png" alt="" height="30" /></a></div>
<h1 id="titre_page" class="'.$classstyle.'">'.$nom.'</h1>';
	
	$sortie .= '<div id="div_fiche_itineraire" class="ecran">';
	if ($circuits != "") {
		$sortie .= '<h2 class="'.$classstyle.'">'.$circuits.'</h2>';
	}
	if ($album != "") {
		$sortie .= '<div class="photoEntete" style="visibility: visible;"><a href="modules/atlas_accessit/resizer_small.php?imgfile=../../'.$album.'&max_width=1024&max_height=1024"><img src="modules/atlas_accessit/resizer_small.php?imgfile=../../'.$album.'&max_width=1024&max_height=1024"></a></div>';
	}
	
	$sortie .= '<div id="barre_btn_atlas" class="'.$classstyle.'">
<a href="#" onclick="show_infos(); return false;"><img src="themes/'.$Default_Theme.'/images/btn_infos.png" alt="" height="25" /></a>
<div class="cale">&nbsp;</div>
<a href="#" onclick="show_contacts(); return false;return false"><img src="themes/'.$Default_Theme.'/images/btn_url.png" alt="" height="25" /></a></div>';
	
	$sortie .= '<div style="margin:0; padding: 0; line-height: 0; height: 0; clear: both;"></div>';
	if ($desc != "") {
		$sortie .= '<p>'.$desc.'</p>';
	}
	if ($activiteEvent != "") {
		$sortie .= '<h3 class="'.$classstyle.'">'.'Attivit e eventi sul territorio /<br>Activits sur le territoire :  : '.'</h3>'.'<p>'.$activiteEvent.'</p>';
	}
	$sortie .= '</div>';
	
	$pieceJointeLnk = ""; 
	if ($piecesJointes != "") {
		$pieceJointeLnk = '<a href="' . $piecesJointes . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/docs'.$classstyle.'.gif" border="0">'.'</a>';
	}

	$infosSupplementsLnk = ""; 
	if ($infosSupplement != "") {
		$infosSupplementsLnk = '<a href="' . $infosSupplement . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/docs'.$classstyle.'.gif" border="0">'.'</a>';
	}
	
	$diversLnk = ""; 
	if ($divers != "") {
		$diversLnk = '<a href="' . $divers . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/docs'.$classstyle.'.gif" border="0">'.'</a>';
	}
	
	$contenu_infs = titrer_info($categorie, "Categorie / Catgorie : ")
		.case_infos(tableau(
		titrer_info_tab($commune, "Comune / Commune :")
		.titrer_info_tab($localite, "Localit / Localit :")
		.titrer_info_tab(number_format($latitude,4), "Latitudine / Latitude :")
		.titrer_info_tab(number_format($longitude,4), "Longitudine / Longitude :")
		/*.titrer_info_tab($activ_event, 'Attivit ed eventi sul territorio /<br />Activits sur le territoire : ')
		.titrer_info_tab($infosSupplement, 'Ulteriori materiali  / Informations supplmentaires : ')
		.titrer_info_tab($autresInfos,'Altre informazioni  /<br />Autres informations : ')
		.titrer_info_tab($pieceJointeStr,'Allegati Itinerario /<br /> Pices jointes : : ')*/
		))
		.titrer_info($services.(($servicesSpe != "") ? "<br/>" : "").$servicesSpe, "Servizi / Services : ")
		//.case_infos(titrer_info(($adresse != '') ? '<center>'.$adresse.'</center>' : '' , "Indirizzo  / Adresse : ")
		.case_infos(tableau(
		titrer_info_tab($adresse, "Indirizzo / Adresse : ")
		.titrer_info_tab($horairesOuverture, "Orario di apertura  /Horaires d'ouverture : ")
		.titrer_info_tab($entree, "Ingresso / Entre : ")
		))
		.titrer_info($noteAccessibilite, "Note accessibilit / Autres informations sur l\'accessibilit : ")
		.case_infos(tableau(
		titrer_info_tab($infosSupplementsLnk, "Ulteriori materiali  / Informations supplmentaires : ")
		.titrer_info_tab($autresInfos, "Altre informazioni / Autres informations : ")
		.titrer_info_tab($pieceJointeLnk, "Allegati Itinerario / Pices jointes : ")
		.titrer_info_tab($diversLnk, "Diverso / Divers : ")
		))
		.titrer_info(($siteAccessit != "") ? $fr_boolean_site_infos_generales["Site_accessit"]["label_french"][$siteAccessit] . " / " . $fr_boolean_site_infos_generales["Site_accessit"]["label_italian"][$siteAccessit] : "", "Appartenenza Accessit / Inclus dans le projet Accessit : ")			
		;
	
	$btn_close_info = '<a href="#" onclick="hide_infos(); return false"><img src="themes/'.$Default_Theme.'/images/btn_close_infos.png" height="14" align="top" border="0" style="float: right" ></a>';
		
	$sortie .= '<div id="plusinfos" class="'.$classstyle.'"><div class="contour">
	<h2>'.$btn_close_info.'Informazioni / Informations</h2>
	<div class="marge">
	'.($contenu_infs != "" ? $contenu_infs : "<p>Non sono disponibili ulteriori informazioni.<br />Aucune information supplmentaire n'est disponible.</p>").'
	</div>
	</div></div>';
	
	
	$siteWebStr = "";
	if ($siteWeb != "") {
		$siteWebStr = '<a href="'.$siteWeb.'" target="_blank">'.$siteWeb.'</a>';
	}
	
	$contenu_conts = case_infos(tableau(
		titrer_info_tab($tel, "Telefono / Tlphone : ")
		.titrer_info_tab($siteWebStr,'Sito web / Site WEB : ')
		));
	
	$sortie .= '<div id="pluscontacts" class="'.$classstyle.'"><div class="contour">
	<h2>'.$btn_close_info.'Contatti / Contacts</h2>
	<div class="marge">
	'.($contenu_conts != "" ? $contenu_conts : "<p>Non sono disponibili ulteriori informazioni.<br />Aucune information supplmentaire n'est disponible.</p>").'
	</div>
	</div></div>';
	
	// Test
	/*$sortie .= '<div id="div_fiche_site" style="display: block;">';
	$sortie .= '<input type="button" value="Fiche" onclick="document.getElementById(\'div_map_site\').style.display = \'none\';document.getElementById(\'div_fiche_site\').style.display = \'block\';" />';
	$sortie .= '<input type="button" value="Map" onclick="document.getElementById(\'div_map_site\').style.display = \'block\';document.getElementById(\'div_fiche_site\').style.display = \'none\';GetMap('.$carteAtlasMobile.', \''.$idSite.'\', \'\', \'\');" />';
	$sortie .= '<table border="1">';
	$sortie .= $nomStr.$circuitsStr.$themeStr.$categorieStr.$communeStr.$localiteStr.$latitudeStr.$longitudeStr.$adresseStr.$horairesOuvertureStr.$entreeStr
	.$telStr.$siteWebStr.$servicesStr.$servicesSpeStr.$piecesJointesStr.$descStr.$infosSupplementStr.$activiteEventStr.$diversStr.$autresInfosStr
	.$noteAccessibiliteStr.$siteAccessitStr.$albumStr;
	$sortie .= '</table>';
	$sortie .= '</div>';
	// Fin test*/

	/*$sortie .= '<div id="div_map_site" style="display: none;">';
	$sortie .= '<input type="button" value="Fiche" onclick="document.getElementById(\'div_map_site\').style.display = \'none\';document.getElementById(\'div_fiche_site\').style.display = \'block\';" />';
	$sortie .= '<input type="button" value="Map" onclick="document.getElementById(\'div_map_site\').style.display = \'block\';document.getElementById(\'div_fiche_site\').style.display = \'none\';GetMap('.$carteAtlasMobile.', \''.$idSite.'\', \'\', \'\');" />';
	$sortie .= '<div id="map" style="width: 100%; height: 300px;"></div>';
	$sortie .= '</div>';*/
	
	$sortie .= '<div id="div_map_itineraire"  style="display: none;">';
	$sortie .= '<div id="map" class="ecran"></div>';
	$sortie .= '</div>';
	
	$sortie = utilFuncs_atlas::conditionnerMobile($sortie);
	echo $sortie;
	
	$bardef=array("back"=>"javascript:window.history.back()");
	buttonBar($bardef, "align");
	include("footer_mobile.php");
}

/**
 * Permet d'afficher la carte en fonction du xml et de l'id du site choisi
 * @param unknown $idSite l'id du site
 */
function get_map_pict_XML_fiche_site($idSite) {
	global $module_name, $Idc;
	require_once ("modules/" . $module_name . "/lib/getXMLcarto_pict_fiche_site_mobile.php");
	$sortie = getXMLcarto ( $Idc, $idSite );
	header ( "Content-Type: text/xml; charset=UTF-8" );
	echo $sortie;
}

if (! isset($theme)) {
	$theme = "";
}


// -------------------------------- SWITCH PART --------------------------------
switch($op) {
	case "map_itineraires":
		show_map_itineraires($theme, $circuit);
		break;
	case "map_pict_XML_itineraires":
		get_map_pict_XML_itineraires($theme, $circuit, $rech);
		break;
	case "map_fiche_itineraire":
		show_map_fiche_itineraire($idItineraire);
		break;
	case "map_pict_XML_fiche_itineraire":
		get_map_pict_XML_fiche_itineraire($idItineraire);
		break;
	case "fiche_site":
		show_map_fiche_site($idSite);
		break;
	case "map_pict_XML_fiche_site" :
		get_map_pict_XML_fiche_site ( $idSite );
		break;
	case "accueil":
	default:
		show_accueil();
		break;
}

?>