<?php
if (! preg_match ( "#modules.php#i", $_SERVER ['PHP_SELF'] )) {
	die ( "You can't access this file directly..." );
}

$module_name = basename ( dirname ( __FILE__ ) );
// get_lang($module_name);

require_once ("core/becms_mainlib_lib.php");
require_once ("modules/" . $module_name . "/system/params.php");
require_once ("modules/atlas_accessit/system/functions.php");

/**
 * Si la page n'existe pas
 */
function display_menu() {
	echo "Pas accs. Mauvais paramtre";
}

/**
 * Cration du menu theme pour itineraire
 * @param unknown $value la valeur par defaut
 * @param string $extrajs si des evenement son rajoute
 * @return string le menu
 */

/*
 * LE menu n'est plus affich mais il reste fonctionnel 
 * (voir aussi la fonction initMenu de params.js)
 * */
function menuThemeItineraire($value, $extrajs = "") {
	/*global $prefix, $db, $name_table_itineraire, $module_name;
	$query = "select distinct Theme from " . $prefix . $name_table_itineraire;
	$result = $db->sql_query ( $query );
	if ($db->sql_numrows ( $result ) != 0) {
		$mycontent = '<select id="themeItineraire" name="themeItineraire" size="1" ' . $extrajs . ' style="display: none">';
		$mycontent .= '<option value="">Choisissez une valeur</option>';
		while ( list ( $theme ) = $db->sql_fetchrow ( $result ) ) {
			$select = ($value == $theme) ? ' selected="selected"' : "";
			$mycontent .= '<option value="' . $theme . '" ' . $select . '>' . $theme . '</option>';
		}
		$mycontent .= '</select>';
	} else {
		$mycontent = "";
	}*/
	$mycontent = '<input type="hidden" name="themeItineraire" value= "'.$value.'" >';
	return $mycontent;
}

/**
 * Cration du menu circuit pour itineraire
 * @param unknown $value la valeur par defaut
 * @param string $extrajs si des evenement son rajoute
 * @return string le menu
 */
function menuCircuitItineraire($value, $extrajs = "", $theme = "") {
	global $prefix, $db, $name_table_itineraire, $module_name;
	
	$where = "";
	if($theme != "" ) {
		$where .= ($where == "") ? " WHERE " : " AND ";
		//$where .= " Theme='".conditionnertodb(stripslashes($theme))."'";
		$where .= "Theme COLLATE latin1_swedish_ci LIKE '".str_replace("'", "''", $theme)."'";
	}
	
	$query = "select distinct Circuits from " . $prefix . $name_table_itineraire . $where . ";";
	$result = $db->sql_query ( $query );
	if ($db->sql_numrows ( $result ) != 0) {
		$mycontent = '<select id="circuitItineraire" name="circuitItineraire" size="1" ' . $extrajs . '>';
		$mycontent .= '<option value="">Choisissez une valeur</option>';
		while ( list ( $circuit ) = $db->sql_fetchrow ( $result ) ) {
			if( $circuit != "" ) {
				$select = ($value == $circuit) ? ' selected="selected"' : "";
				$mycontent .= '<option value="' . $circuit . '" ' . $select . '>' . $circuit . '</option>';
			}
		}
		$mycontent .= '</select>';
	} else {
		$mycontent = "";
	}
	return $mycontent;
}

/**
 * Pages parmettant d'afficher tous les itineraires sur une Google Maps
 * @param unknown $theme le theme 
 * @param unknown $circuit le circuit
 */
function display_map_symbol_itineraires($theme="") {
	global $module_name, $_headerContent, $currentlang, $Default_Theme;
	global $rep, $expression, $icon_plus_infos;
	global $My_SQL, $vars_mod, $carteAtlas;
	global $withrewriting, $lienFicheItineraire, $lienCourtFicheItineraire;
	global $code_memo_carto;
	require_once ("modules/SimpleCarto/lib/g_params.php");
	
	if( $withrewriting ) {
		$lienItineraire = $lienCourtFicheItineraire;
	} else {
		$lienItineraire = $lienFicheItineraire;
	}
	
	/* <!--<script type="text/javascript" src="modules/'.$module_name.'/language/lang-'.$currentlang.'.js" charset="UTF-8"></script>--> */
	$_headerContent = $code_memo_carto.'
		<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key=' . $keymap . '" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_autostart.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_XML_parser.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_AJAX.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_interface.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_string.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/params.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_carto_symb_itineraires.js" charset="UTF-8"></script>
		<script type="text/javascript">
		//<![CDATA[
			//var detruirCookie = false;
			var options = new Array;
			var racine_lib_module = "modules/SimpleCarto/lib";
			options["icon_plus_infos"] = "'.$icon_plus_infos.'";
			options["detruirCookie"] = false;
			options["rewrite"] = '.$withrewriting.'
			options["lienItineraire"] = "'.$lienItineraire.'"
		   //]]>
		</script>
		<script type="text/javascript">
		// <![CDATA[
			addToStart(recupParamsItineraires);	
			addToStart(initMenu);
			addToStart("GetMap('.$carteAtlas.', \''.$theme.'\', circuit, recherche)");
			addToStart(recupParamsMap);	
			addToStop(memoParamsMap);
			addToStop(memoParamsItineraires);
			addToStop(GUnload);
		// ]]>
		</script>';

	setHeader ( $_headerContent );

	$stylecrit = '';
	if ($theme == "") {
		$stylecrit = ' style="display: none"';
	}
	
	if ($theme == "") {
		$pictarcheo = 'archeo_archeo.gif';
		$pictculture = 'culture_culture.gif';
		$pictidentite = 'identite_identite.gif';
	}
	else {
		$pictarcheo = ($theme == 'Archeologia') ? 'archeo_archeo.gif' : 'archeo.gif';
		$pictculture = ($theme == 'Cultura del Mare') ? 'culture_culture.gif' : 'culture.gif';
		$pictidentite = ($theme == 'Identita del Territorio') ? 'identite_identite.gif' : 'identite.gif';
	}
	
	$sortie = '
		<div class="atlas">
			<table border="0" cellpadding="0" cellspacing="0" align="center" width="880">
				<tr>
					<td width="430" valign="top" class="casetexte">Percorrendo questo Grande Itinerario, potrete scoprire tutti gli luoghi che sono stati valorizzati nell\'ambito del progetto ACCESSIT.<br />Potete selezionare i percorsi del mapa scegliendo uno dei temi qui sotto. Fate clic su gli punti per aprire la scheda detagliata.</td>
					<td width="20"></td>
					<td width="430" valign="top" class="casetexte">Parcourez ce Grand Itinraire Tyrrhnien qui vous permettra de dcouvrir les lieux mis en valeur au cours du projet ACCESSIT.<br />Vous pouvez slectionner les parcours affichs sur la carte en choississant un des thmes ci-dessous. Cliquez sur les points pour accder  une fiche dtaille.</td>
				</tr>
			</table>
			<h1 id="titre"></h1>
			<div id="commentaire"></div>
			<form method="" action="" onsubmit="reloadsymboles('.$carteAtlas.', this.elements[\'themeItineraire\'].value, this.elements[\'circuitItineraire\'].value, this.elements[\'recherche\'].value);return false;">
			<div class="sepcaseatlas"></div>
			<table border="0" cellpadding="0" cellspacing="0" align="center">
				<tr>
					<td><a href="atlas_theme_Archeologia.htm"><img src="themes/'.$Default_Theme.'/images/'.$pictarcheo.'" border="0" onmouseover="this.src=\'themes/'.$Default_Theme.'/images/archeo_archeo.gif\'" onmouseout="this.src=\'themes/'.$Default_Theme.'/images/'.$pictarcheo.'\'" /></a></td>
					<td width="13"></td>
					<td><a href="atlas_theme_Cultura%20del%20Mare.htm"><img src="themes/'.$Default_Theme.'/images/'.$pictculture.'" border="0" onmouseover="this.src=\'themes/'.$Default_Theme.'/images/culture_culture.gif\'" onmouseout="this.src=\'themes/'.$Default_Theme.'/images/'.$pictculture.'\'" /></a></td>
					<td width="13"></td>
					<td><a href="atlas_theme_Identita%20del%20Territorio.htm"><img src="themes/'.$Default_Theme.'/images/'.$pictidentite.'" border="0" onmouseover="this.src=\'themes/'.$Default_Theme.'/images/identite_identite.gif\'" onmouseout="this.src=\'themes/'.$Default_Theme.'/images/'.$pictidentite.'\'" /></a></td>
				</tr>
			</table>
			<div class="sepcaseatlas"></div>
			
			<table border="0" cellpadding="0" cellspacing="0" align="center"'.$stylecrit.'>
				<tr>
					<td width="291" class="casetexte">Potete migliorare la vostra selezione adesso, sia scegliendo un circuito, sia facendo una ricerca con parola chiave.<br />Vous pouvez maintenant amliorer votre slection, soit en choisissant un circuit, soit en faisant une recherche avec mot-cl.
					'.menuThemeItineraire ( $theme, 'onchange="reloadsymboles('.$carteAtlas.', this.value, this.form.elements[\'circuitItineraire\'].value, this.form.elements[\'recherche\'].value);"' ).'</td>
					<td width="13"></td>
					<td width="291" class="casecrit">Circuito / Circuit :<br />'.menuCircuitItineraire ( $circuit, 'onchange="reloadsymboles('.$carteAtlas.', this.form.elements[\'themeItineraire\'].value, this.value, this.form.elements[\'recherche\'].value);"', $theme ) .'</td>
					<td width="13"></td>
					<td width="291" class="casecrit">Parola chiave / Mot-cl :<br /><input type="text" id="recherche" name="recherche" value="" /><input type="button" value="Go" name="Go" onclick="reloadsymboles('.$carteAtlas.', this.form.elements[\'themeItineraire\'].value, this.form.elements[\'circuitItineraire\'].value, this.form.elements[\'recherche\'].value);" /></td>
				</tr>
			</table>
			<!--<table border="0" cellpadding="0" cellspacing="0" align="center"'.$stylecrit.'>
			<tr><td>
			<p>Thme des itinraires</p>
			</td><td>
			<p>Recherche</p>
			</td><td>
			<p>Circuit des itinraires</p>
			</td></tr>
			<tr><td>
			<p>' . menuThemeItineraire ( $theme, 'onchange="reloadsymboles('.$carteAtlas.', this.value, this.form.elements[\'circuitItineraire\'].value, this.form.elements[\'recherche\'].value);"' ) . '</p>
			</td><td>
			<p><input type="text" id="recherche" name="recherche" value="" /><input type="button" value="Go" name="Go" onclick="reloadsymboles('.$carteAtlas.', this.form.elements[\'themeItineraire\'].value, this.form.elements[\'circuitItineraire\'].value, this.form.elements[\'recherche\'].value);" /></p>
			</td><td>
			<p>' . menuCircuitItineraire ( $circuit, 'onchange="reloadsymboles('.$carteAtlas.', this.form.elements[\'themeItineraire\'].value, this.value, this.form.elements[\'recherche\'].value);"', $theme ) . '</p>
			</td></tr>
			</table>-->
			<p id="message_itineraire"></p>
			<div id="map"></div>
			</form>
			<p>&nbsp;</p>
			<div id="obs"></div>
		</div>
		<div align="center"><img src="themes/'.$Default_Theme.'/images/accessit.jpg"></div>';
	include ('header.php');
	echo $sortie;
	$bardef = array ( // "print"=>"modules.php?name=Chuck_Norris_Facts&sop=print&page=$page",
			// "pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back" => "javascript:window.history.back();",
			"top" => "#top"
	);
	buttonBar ( $bardef, "align" );
	include ('footer.php');
}

/**
 * Permet de retourner et d'afficher la carte en fonction du xml
 * @param unknown $theme le theme
 * @param unknown $circuit le circuit
 * @param unknown $rech la recherche
 */
function get_map_pict_XML_itineraires($theme, $circuit, $rech) {
	global $module_name, $Idc;
	require_once ("modules/" . $module_name . "/lib/getXMLcarto_pict_itineraires.php");
	$sortie = getXMLcarto ( $Idc, $theme, $circuit, $rech );
	header ( "Content-Type: text/xml; charset=UTF-8" );
	echo $sortie;
}

/**
 * Permet de crer l'album photo a partir d'un lien
 * 
 * @param unknown $url
 *        	le lien
 * @return string l'album
 */
function createAlbum($album) {
	global $module_name, $separatorImageAlbum;
	$album_photos = '<div class="diaporamazoom"><div class="highslide-gallery">';
	$count = 1;
	$urls = explode($separatorImageAlbum, $album);
	foreach ($urls as $url) {
		
		/*
		 * $resizedImg = "modules.php?name=becmsGallery&sop=Resizer&imgfile=$laphoto&max_width=800&max_height=800"; $tumbImg = "modules.php?name=becmsGallery&sop=Resizer&imgfile=$laphoto&max_width=100&max_height=100";
		 */
		/*
		 * modules/'.$module_name.'/resizer_small.php?imgfile=../../'.$laphoto.'&max_width=900&max_height=600
		 * */
		/*
			$resizedImg = $url;
			$tumbImg = $url;
			$album_photos .= '
			<table border="0" cellpadding="0" cellspacing="0" class="diapo">
			<tr><td>
			<a id="thumb' . $count . '" href="' . $resizedImg . '" class="highslide" onclick="return hs.expand(this)"><img src="' . $tumbImg . '" alt="' . $nom . '" title="Click to enlarge" style="max-width: 260px; max-height: 200px;" /></a>
			<div class="highslide-heading">
				' . $nom . '
			</div>';*/
		$resizedImg = $url;
		$tumbImg =  'modules/'.$module_name.'/resizer_small.php?imgfile=../../'.$url.'&max_width=260&max_height=200';
		$album_photos .= '
			<table border="0" cellpadding="0" cellspacing="0" class="diapo">
			<tr><td>
			<a id="thumb' . $count . '" href="' . $resizedImg . '" class="highslide" onclick="return hs.expand(this)"><img src="' . $tumbImg . '" alt="' . $nom . '" title="Click to enlarge" /></a>
			<div class="highslide-heading">
				' . $nom . '
			</div>';
		
		$photo_comments = $credit;
		if ($photo_comments != "") {
			$album_photos .= '
				<div class="highslide-caption">
					' . $photo_comments . '
				</div>';
		}
		$album_photos .= '</td></tr></table>';
		$count ++;
	}
	$album_photos .= '</div></div>';
	return $album_photos;
}

function liste($valeur, $classe="nopuce") {
	$sortie = "";
	if (count($valeur) > 0) {
		$sortie .= "<ul";
		if ($classe != "" ) {
			$sortie .= ' class="'.$classe.'"';
		}
		$sortie .= ">";
		foreach ($valeur as $elt) {
			$sortie .= "<li>".$elt."</li>";
		}
		$sortie .= "</ul>";
	}
	return $sortie;
}

function colonnes($valeurs = array(), $nbcols = 1,$largeur = "", $equicols = false, $senslecture = "v", $classe = "") {
	$nbrevals = count($valeurs);
	if ($nbrevals > 0) {
		$largeurscols = array();
		if ($equicols) { //calcul des largeurs de colonnes si elles doivent tre gales
			$largeurcol = floor(100/$nbcols);
			$total = 0;
			for ($i=0;$i<$nbcols-1;$i++) {
				$largeurscols[] = ' width="'.$largeurcol.'%"';
				$total += $largeurcol;
			}
			$largeurscols[] = $largeurscols[] = ' width="'.(100 - $total).'%"';
		}
		$lignesMax = ceil(count($valeurs)/$nbcols); //nbre de lignes maximal
		$classe = ($classe != "") ? ' class="'.$classe.'"' : "";

		$sortie = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"".$classe;
		if ($largeur != "") {
			$sortie .= " width=\"".$largeur."\"";
		}
		$sortie .= ">";
		$contenus = array();
		if ($senslecture == "v") {
			for ($c=0;$c<$nbcols;$c++) {
				$contenus[$c] = '<td'.$largeurscols[$c].'>';
				$contenus[$c] .= liste(array_slice($valeurs,$lignesMax*$c,$lignesMax));
				$contenus[$c] .= '</td>';
			}
		}
		if ($senslecture == "h") {
			for ($c=0;$c<$nbcols;$c++) {
				$cvaleurs = array();
				for ($i=0;$i<$lignesMax;$i++) {
					$indice = $i*$nbcols+$c;
					if (isset($valeurs[$indice])) {
						$cvaleurs[] = $valeurs[$indice];
					}
				}
				$contenus[$c] = '<td'.$largeurscols[$c].'>';
				$contenus[$c] .= liste($cvaleurs);
				$contenus[$c] .= '</td>';
			}
		}
		$sortie .= '<tr>';
		foreach($contenus as $contenu) {
			$sortie .= $contenu;
		}
		$sortie .= '</tr>';
		$sortie .= "</table>";
	}
	else {
		$sortie = "";
	}
	return $sortie;
}

function casefiche($titre, $contenu, $contenugras="") {
	$contenu = trim($contenu);
	if ($contenu == "" && $contenugras == "") {
		return "";
	}
	else {
		if ($titre != "") {
			if ($contenugras == "") {
				return '<div class="sepcaseatlas"></div><div class="caseinfo"><div class="caseinfotitre">'.$titre.'</div><div class="caseinfocontent">'.$contenu.'</div></div>';
			}
			else {
				return '<div class="sepcaseatlas"></div><div class="caseinfo"><table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td><div class="caseinfotitre">'.$titre.'</div></td><td class="caseinfocontentgras">'.$contenugras.'</td></table><div class="caseinfocontent">'.$contenu.'</div></div>';
			}
		}
		else {
			return '<div class="sepcaseatlas"></div><div class="caseinfo"><div class="caseinfocontent">'.$contenu.'</div></div>';
		}
	}
}

function casefichetab($valeurs) {
	if (!is_array($valeurs)) {
		return "";
	}
	else {
		$contenu = "";
		foreach ($valeurs as $valeur) {
			if ($valeur["contenu"] != "") {
				$contenu .= '<div class="caseinfotitre">'.$valeur["titre"].'</div><div class="caseinfocontent">'.$valeur["contenu"].'</div>';
			}
		}	
		if ($contenu !="") {
			$contenu = '<div class="sepcaseatlas"></div><div class="caseinfo">'.$contenu.'</div>';
		}
		return $contenu;
	}
}

/**
 * Page d'affichage de la description d'un itineraire avec les site associe
 * @param unknown $idItineraire l'id de l'itineraire
 */
function display_map_symbol_fiche_itineraire($idItineraire) {
	global $module_name, $_headerContent, $currentlang, $Default_Theme;
	global $prefix, $db, $name_table_itineraire, $icon_plus_infos;
	global $rep, $expression;
	global $My_SQL, $vars_mod, $carteAtlas;
	global $withrewriting, $lienFicheSite, $lienCourtFicheSite;
	global $code_memo_carto, $dicotheme;
	require_once ("modules/SimpleCarto/lib/g_params.php");
	
	if( $withrewriting ) {
		$lienSite = $lienCourtFicheSite;
	} else {
		$lienSite = $lienFicheSite;
	}
	
	/* <!--<script type="text/javascript" src="modules/'.$module_name.'/language/lang-'.$currentlang.'.js" charset="UTF-8"></script>--> */
	$_headerContent = $code_memo_carto.'
		<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key=' . $keymap . '" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_autostart.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_XML_parser.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_AJAX.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_interface.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_string.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/params.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_carto_symb_fiche_itineraire.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/becmsGallery/type/zoom_gallery/highslide/highslide-with-gallery.js"></script>
		<link rel="stylesheet" type="text/css" href="modules/becmsGallery/type/zoom_gallery/highslide/highslide.css" />
		<!--<link rel="stylesheet" href="themes/' . $Default_Theme . '/style/becmsGallery.css" type="text/css">-->
		<script type="text/javascript">
			hs.lang = { 
			   loadingText :     \'Chargement...\', 
			   loadingTitle :    \'Cliquer pour annuler\', 
			   focusTitle :      \'Cliquer pour amener au premier plan\', 
			   fullExpandTitle : \'Afficher en taille relle\', 
			   fullExpandText :  \'Taille relle\', 
			   creditsText :     \'Dvelopp sur <i>Highslide JS</i>\', 
			   creditsTitle :    \'Site Web de Highslide JS\', 
			   previousText :    \'Prcdent\', 
			   previousTitle :   \'Prcdent (flche gauche)\', 
			   nextText :        \'Suivant\', 
			   nextTitle :       \'Suivant (flche droite)\', 
			   moveTitle :       \'Dplacer\', 
			   moveText :        \'Dplacer\', 
			   closeText :       \'Fermer\', 
			   closeTitle :      \'Fermer (esc ou Echap)\', 
			   resizeTitle :     \'Redimensionner\', 
			   playText :        \'Lancer\', 
			   playTitle :       \'Lancer le diaporama (barre d\\\'espace)\', 
			   pauseText :       \'Pause\', 
			   pauseTitle :      \'Suspendre le diaporama (barre d\\\'espace)\', 
			   restoreTitle :    \'Cliquer pour fermer l\\\'image, cliquer et faire glisser pour dplacer, utiliser les touches flches droite et gauche pour suivant et prcdent.\' 
			};
			hs.graphicsDir = \'modules/becmsGallery/type/zoom_gallery/highslide/graphics/\';
			hs.align = \'center\';
			hs.transitions = [\'expand\', \'crossfade\'];
			hs.outlineType = \'rounded-white\';
			hs.wrapperClassName = \'controls-in-heading\';
			hs.fadeInOut = true;
			//hs.numberPosition = \'caption\';
			hs.dimmingOpacity = 0.5;
			hs.showCredits = false;
			// Add the controlbar
			if (hs.addSlideshow) hs.addSlideshow({
				//slideshowGroup: \'group1\',
				interval: 5000,
				repeat: false,
				useControls: true,
				fixedControls: false,
				overlayOptions: {
					opacity: 1,
					position: \'top right\',
					hideOnMouseOut: false
				}
			});
		</script>
		<script type="text/javascript">
		//<![CDATA[
			//var detruirCookie = false;
			var options = new Array;
			var racine_lib_module = "modules/SimpleCarto/lib";
			options["icon_plus_infos"] = "'.$icon_plus_infos.'";
			options["detruirCookie"] = false;
			options["rewrite"] = '.$withrewriting.'
			options["lienSite"] = "'.$lienSite.'"
		   //]]>
		</script>
		<script type="text/javascript">
		// <![CDATA[
			addToStart(setParamsCookiesItineraire);
			addToStart("GetMap('.$carteAtlas.', '.$idItineraire.')");	
			addToStop(GUnload);
		// ]]>
		</script>';
	setHeader ( $_headerContent );
	
	$sortie = "";
	
	// Lecture de la table itineraire et recuperation des infos le concernent
	$sql = "SELECT * FROM `" . $prefix . $name_table_itineraire . "` WHERE `id`=" . $idItineraire;
	$search = $db->sql_query ( $sql );
	if ($db->sql_numrows ( $search ) != 0) {
		$donnees = $db->sql_fetchrow ( $search );
		
		$desc = nl2br(trim($donnees ['Description']));
		$nom = $donnees ['Nom_itineraire'];
		$circuit = (isset($dicotheme[$donnees['Circuits']])) ? $dicotheme[$donnees ['Circuits']] : $donnees ['Circuits'];
		$theme = (isset($dicotheme[$donnees['Theme']])) ? $dicotheme[$donnees ['Theme']] : $donnees ['Theme'];
		$commune = $donnees ['Commune'];
		$tel = $donnees ['Telephone'];
		$messagerie = $donnees ['Messagerie'];
		$siteWeb = $donnees ['Site_web'];
		$caract = nl2br(trim($donnees ['Caracteristique_itineraire']));
		$services = nl2br(trim($donnees ['Services']));
		$activ_event = nl2br(trim($donnees ['Activite_event_territoire']));
		$pieceJointe = $donnees ['Pieces_jointes'];
		$album = $donnees ['Album'];
		$infosSupplement = $donnees['Infos_supplementaires'];
		$autresInfos = nl2br(trim($donnees['Autres_infos']));
		
		$classstyle = "";
		if ($theme != "") {
			if (preg_match("#^Archeologia#", $theme)) $classstyle="archeo";
			if (preg_match("#^Identit#", $theme)) $classstyle="identite";
			if (preg_match("#^Cultura#", $theme)) $classstyle="culture";
		} 
		
		if ($desc != "") {
			$desc = casefiche('Descrizione /<br />Description : ', $desc);
		} else {
			$desc = "";
		}
		
		$infolieu = "";
		if ($commune != "" || $services != "") {
			$infolieu .= '<div class="sepcaseatlas"></div>';
			$infolieu .= '<table border="0" cellpadding="0" cellspacing= "0">';
			$infolieu .= ($commune != "") ? '<tr><td class="caseinfotitre" valign="top">Comuni / Commune : </td><td class="caseinfocontent2">'.$commune.'</td></tr>' : '';
			$infolieu .= ($services != "") ? '<tr><td class="caseinfotitre" valign="top">Servizi / Services :</td><td class="caseinfocontent2">'.$services.'</td></tr>' : '';
			$infolieu .= '</table>';
		}
		
		$coords = "";
		if ($siteWeb != "" || $messagerie != "" || $tel != "") {
			$coords .= '<div class="sepcaseatlas"></div>';
			$coords .= '<table border="0" cellpadding="0" cellspacing= "0" width="244" >';
			//$coords .= ($siteWeb != "" || $messagerie != "") ? '<tr><td align="center" valign="middle" height="42" background="themes/'.$Default_Theme.'/images/coords'.$classstyle.'.gif">' : '';
			$coords .= '<tr><td align="center" valign="middle" height="42" background="themes/'.$Default_Theme.'/images/coords'.$classstyle.'.gif">';
			$coords .= ($siteWeb != "") ? '<a href="' . $siteWeb . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/webatlas.png" border="0">'.'</a>' :'';
			$coords .= ($siteWeb != "" && $messagerie != "") ? '<span style="width: 50px; display: inline-block;"></span>' : '';
			$coords .= ($messagerie != "") ? '<a href="mailto:' . $messagerie . '">'.'<img src="themes/'.$Default_Theme.'/images/mailatlas.png" border="0">'.'</a>' :'';
			//$coords .= ($siteWeb != "" || $messagerie != "") ? '</td></tr>' : '';
			$coords .=  '</td></tr>';
			//$coords .= (($siteWeb != "" || $messagerie != "") && $tel != "") ? '<tr><td height="18"></td></tr>' : '';
			$coords .= ($tel != "") ? '<tr><td height="18"></td></tr>' : '';
			$coords .= ($tel != "") ? '<tr><td align="center"><table border="0" cellpaddind="0" cellspacing="0"><tr><td><img src="themes/'.$Default_Theme.'/images/tel'.$classstyle.'.gif"></td><td width="10"></td><td class="caseinfocontent">'.$tel.'</td></tr></table></td></tr>' : '';
			$coords .= '</table>';
		}
		else {
			$coords .= '<div class="sepcaseatlas"></div>';
			$coords .= '<table border="0" cellpadding="0" cellspacing= "0" width="244" >';
			$coords .= '<tr><td align="center" valign="middle" height="42" background="themes/'.$Default_Theme.'/images/coords'.$classstyle.'.gif">';
			$coords .= '&nbsp;';
			$coords .= '</td></tr>';
			$coords .= '</table>';
		}
		
		if ($caract != "") {
			$caract = casefiche('Caratteristiche dell\'intinerario /<br />Caractristiques de l\'itinraire : ', $caract);
		} else {
			$caract = "";
		}
		if ($desc == "" && $caract != "") {
			$desc = $caract;
			$caract = "";
		} 
		
		if ($activ_event != "") {
			$activ_event = casefiche('Attivit ed eventi sul territorio /<br />Activits sur le territoire : ', $activ_event);
		} else {
			$activ_event = "";
		}
		
		if( $autresInfos != "" ) {
			$autresInfos = casefiche('Altre informazioni  /<br />Autres informations : ', $autresInfos);
		} else {
			$autresInfos = "";
		}

		$infopluspj = "";
		if ($infosSupplement != "" || $pieceJointe != "") {
			$infopluspj .= '<div class="sepcaseatlas"></div>';
			$infopluspj .= '<table border="0" cellpadding="0" cellspacing= "0">';
			$infopluspj .= ($infosSupplement != "") ? '<tr><td class="caseinfotitre">Ulteriori materiali  / Informations supplmentaires : </td><td class="caseinfocontent2">'.'<a href="' . $infosSupplement . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/docs'.$classstyle.'.gif" border="0">'.'</a>'.'</td></tr>' : '';
			$infopluspj .= ($pieceJointe != "") ? '<tr><td class="caseinfotitre">Allegati Itinerario / Pices jointes :</td><td class="caseinfocontent2">'.'<a href="' . $pieceJointe . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/docs'.$classstyle.'.gif" border="0">'.'</a>'.'</td></tr>' : '';
			$infopluspj .= '</table>';
		}
		
		if ($album != "") {
			$album = createAlbum ( $album );
		} else {
			$album = "";
		}
		
		$sortie .= '
		<div class="atlas"><div class="'.$classstyle.'">
		<table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td valign="top"><h1 id="titre">'.$nom /*strtoupper($nom)*/.'</h1></td><td width="15"></td><td valign="top" align="right"><table border="0" cellpadding="0" cellspacing="0"><tr><td nowrap="nowrap" align="right"><h1 class="theme">'.$theme.'</h1></td></tr>'.(($circuit != "") ? '<tr><td align="right"><h2 class="circuit">'.$circuit.'</h2></td></tr>' : '').'</table></td></tr></table>
		<div id="commentaire"></div>
		<div class="sepcaseatlas"></div>
		<div id="map"></div>
		<table border="0" cellpadding="0" cellspacing="0" width=880 align="center">
		<tr>
		<td width="608" height="1"><img src="themes/'.$Default_Theme.'/images/spacer.gif" height="1" width="608"></td>
		<td width="28"><img src="themes/'.$Default_Theme.'/images/spacer.gif" height="1" width="28"></td>
		<td width="244"><img src="themes/'.$Default_Theme.'/images/spacer.gif" height="1" width="244"></td>
		</tr>
		<tr>
		<td colspan="3">'.$desc.'</td>
		</tr>
		<tr>
		<td width="608" valign="top">'.$infolieu.$caract.$activ_event.$infopluspj.'</td>
		<td width="28">&nbsp;</td>
		<td width="244"  valign="top">'.$coords.$autresInfos.'</td>
		</tr>
		</table>
		' . $album . '
		</div></div>
		';
	}
	else {
		$sortie = "<p>Erreur : pas de fiche correspondante</p>";
	}
	
	include ('header.php');
	echo $sortie;
	$bardef = array ( // "print"=>"modules.php?name=Chuck_Norris_Facts&sop=print&page=$page",
	                  // "pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back" => "javascript:window.history.back();",
			"top" => "#top" 
	);
	buttonBar ( $bardef, "align" );
	include ('footer.php');
}

/**
 * Retourne et affiche la carte des sites en fonction de l'id d'un itineraire
 * @param unknown $idItineraire l'id de l'itineraire
 */
function get_map_pict_XML_fiche_itineraire($idItineraire) {
	global $module_name, $Idc;
	require_once ("modules/" . $module_name . "/lib/getXMLcarto_pict_fiche_itineraire.php");
	$sortie = getXMLcarto ( $Idc, $idItineraire );
	header ( "Content-Type: text/xml; charset=UTF-8" );
	echo $sortie;
}

/**
 * Page permettant d'afficher la description d'un site
 * @param unknown $idSite l'id du site
 */
function display_map_symbol_fiche_site($idSite) {
	global $module_name, $_headerContent, $currentlang, $Default_Theme;
	global $prefix, $db, $name_table_site;
	global $fr_boolean_site_access_physique, $fr_boolean_site_access_culture, $fr_boolean_site_access_virtuelle, $fr_boolean_site_infos_generales;
	global $rep, $expression;
	global $My_SQL, $vars_mod, $miniCarteAtlas;
	global $code_memo_carto, $dicotheme;
	require_once ("modules/SimpleCarto/lib/g_params.php");
	/* <!--<script type="text/javascript" src="modules/'.$module_name.'/language/lang-'.$currentlang.'.js" charset="UTF-8"></script>--> */
	$_headerContent = $code_memo_carto.'
		<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key=' . $keymap . '" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_autostart.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_XML_parser.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_AJAX.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_interface.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_string.js"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/lib_carto_symb_fiche_site.js" charset="UTF-8"></script>
		<script type="text/javascript" src="modules/' . $module_name . '/lib/params.js"></script>
		<script type="text/javascript" src="modules/becmsGallery/type/zoom_gallery/highslide/highslide-with-gallery.js"></script>
		<link rel="stylesheet" type="text/css" href="modules/becmsGallery/type/zoom_gallery/highslide/highslide.css" />
		<!--<link rel="stylesheet" href="themes/' . $Default_Theme . '/style/becmsGallery.css" type="text/css">-->
		<script type="text/javascript">
			hs.lang = { 
			   loadingText :     \'Chargement...\', 
			   loadingTitle :    \'Cliquer pour annuler\', 
			   focusTitle :      \'Cliquer pour amener au premier plan\', 
			   fullExpandTitle : \'Afficher en taille relle\', 
			   fullExpandText :  \'Taille relle\', 
			   creditsText :     \'Dvelopp sur <i>Highslide JS</i>\', 
			   creditsTitle :    \'Site Web de Highslide JS\', 
			   previousText :    \'Prcdent\', 
			   previousTitle :   \'Prcdent (flche gauche)\', 
			   nextText :        \'Suivant\', 
			   nextTitle :       \'Suivant (flche droite)\', 
			   moveTitle :       \'Dplacer\', 
			   moveText :        \'Dplacer\', 
			   closeText :       \'Fermer\', 
			   closeTitle :      \'Fermer (esc ou Echap)\', 
			   resizeTitle :     \'Redimensionner\', 
			   playText :        \'Lancer\', 
			   playTitle :       \'Lancer le diaporama (barre d\\\'espace)\', 
			   pauseText :       \'Pause\', 
			   pauseTitle :      \'Suspendre le diaporama (barre d\\\'espace)\', 
			   restoreTitle :    \'Cliquer pour fermer l\\\'image, cliquer et faire glisser pour dplacer, utiliser les touches flches droite et gauche pour suivant et prcdent.\' 
			};
			hs.graphicsDir = \'modules/becmsGallery/type/zoom_gallery/highslide/graphics/\';
			hs.align = \'center\';
			hs.transitions = [\'expand\', \'crossfade\'];
			hs.outlineType = \'rounded-white\';
			hs.wrapperClassName = \'controls-in-heading\';
			hs.fadeInOut = true;
			//hs.numberPosition = \'caption\';
			hs.dimmingOpacity = 0.5;
			hs.showCredits = false;
			// Add the controlbar
			if (hs.addSlideshow) hs.addSlideshow({
				//slideshowGroup: \'group1\',
				interval: 5000,
				repeat: false,
				useControls: true,
				fixedControls: false,
				overlayOptions: {
					opacity: 1,
					position: \'top right\',
					hideOnMouseOut: false
				}
			});
		</script>
		<script type="text/javascript">
		//<![CDATA[
			var options = new Array;
			var racine_lib_module = "modules/SimpleCarto/lib";
		   //]]>
		</script>
		<script type="text/javascript">
		// <![CDATA[
			addToStart("GetMap('.$miniCarteAtlas.', '.$idSite.')");
			addToStop(GUnload);
		// ]]>
		</script>';
	setHeader ( $_headerContent );
	
	// Lecture et recuperation des infos concernent le site
	$sql = "SELECT * FROM `".$prefix.$name_table_site."` WHERE `id`=". $idSite;
	$search = $db->sql_query ( $sql );
	if ($db->sql_numrows ( $search ) != 0) {
		$donnees = $db->sql_fetchrow ( $search );
		$nom = $donnees['Nom'];
		$circuits = (isset($dicotheme[$donnees['Circuits']])) ? $dicotheme[$donnees ['Circuits']] : $donnees ['Circuits'];
		$theme = (isset($dicotheme[$donnees['Theme']])) ? $dicotheme[$donnees ['Theme']] : $donnees ['Theme'];
		$categorie = $donnees['Categorie'];
		$commune = $donnees['Commune'];
		$localite = $donnees['Localite'];
		$latitude = $donnees['Latitude'];
		$longitude = $donnees['Longitude'];
		$adresse = nl2br(trim($donnees['Adresse']));
		$horairesOuverture = nl2br(trim($donnees['Horaires_ouverture']));
		$entree = nl2br(trim($donnees['Entree']));
		$tel = $donnees['Telephone'];
		$siteWeb = $donnees['Site_web'];
		$services = nl2br(trim($donnees['Services']));
		$servicesSpe = nl2br(trim($donnees['Services_specifiques']));
		$album = $donnees['Album'];
		$piecesJointes = $donnees['Pieces_jointes'];
		$desc = nl2br(trim($donnees['Description']));
		$infosSupplement = $donnees['Info_supplementaires'];
		$activiteEvent = $donnees['Activite_event'];
		$divers = $donnees['Divers'];
		$autresInfos = nl2br(trim($donnees['Altre_informazioni_e_progetti_collegati']));
		$noteAccessibilite = nl2br(trim($donnees['Note_accessibilita']));
		$siteAccessit = $donnees['Site_accessit'];
		
		$messagerie = "";
		
		
		$arrayAccessPhysique = array();
		foreach ($fr_boolean_site_access_physique as $champ => $arrayAccess) {
			if( isset($donnees[$champ]) && $donnees[$champ] == 1 ) {
				$arrayAccessPhysique[$champ] = $arrayAccess;
			}
		}

		$arrayAccessCulture = array();
		foreach ($fr_boolean_site_access_culture as $champ => $arrayAccess) {
			if( isset($donnees[$champ]) && $donnees[$champ] == 1 ) {
				$arrayAccessCulture[$champ] = $arrayAccess;
			}
		}
		
		$arrayAccessVirtuelle = array();
		foreach ($fr_boolean_site_access_virtuelle as $champ => $arrayAccess) {
			if( isset($donnees[$champ]) && $donnees[$champ] == 1 ) {
				$arrayAccessVirtuelle[$champ] = $arrayAccess;
			}
		}

		
		
		
		
		$classstyle = "";
		if ($theme != "") {
			if (preg_match("#^Archeologia#", $theme)) $classstyle="archeo";
			if (preg_match("#^Identit#", $theme)) $classstyle="identite";
			if (preg_match("#^Cultura#", $theme)) $classstyle="culture";
		}
		$classstylecase = ($classstyle == "") ? "rien" : $classstyle;
		
		if ($desc != "") {
			$desc = casefiche('Descrizione /<br />Description : ', $desc);
		} else {
			$desc = "";
		}
		
		$infocat = "";
		if ($categorie) {
			$infocat .= '<div class="sepcaseatlas"></div>';
			$infocat .= '<div class="sepcaseatlas"></div>';
			$infocat .= '<table border="0" cellpadding="0" cellspacing= "0">';
			$infocat .= ($categorie != "") ? '<tr><td class="caseinfotitre" valign="top">Categorie / Catgorie : </td><td class="caseinfocontent2"><b>'.$categorie.'</b></td></tr>' : '';
			$infocat .= '</table>';
		}
		
		$infolieu = "";
		if ($commune != "" || $localite != "" || $latitude != "" || $longitude != "") {
			$infolieu .= '<table border="0" cellpadding="0" cellspacing= "0">';
			$infolieu .= ($commune != "") ? '<tr><td class="caseinfotitre" valign="top">Comuni / Commune : </td><td class="caseinfocontent2"><b>'.$commune.'</b></td></tr>' : '';
			$infolieu .= ($localite != "") ? '<tr><td class="caseinfotitre" valign="top">Localit / Localit :</td><td class="caseinfocontent2"><b>'.$localite.'</b></td></tr>' : '';
			$infolieu .= ($latitude != "") ? '<tr><td class="caseinfotitre" valign="top">Latitudine / Latitude :</td><td class="caseinfocontent2"><b>'.$latitude.'</b></td></tr>' : '';
			$infolieu .= ($longitude != "") ? '<tr><td class="caseinfotitre" valign="top">Longitudine / Longitude :</td><td class="caseinfocontent2"><b>'.$longitude.'</b></td></tr>' : '';
			$infolieu .= '</table>';
			$infolieu = casefiche("", $infolieu);
		}
		
		$servs = "";
		if ($services != "" || $servicesSpe != "") {
			$servs = casefiche('Servizi&nbsp;/<br />Services&nbsp;: ', $servicesSpe, $services);
		} 
		else {
			$servs = "";
		}
		
		if ($activiteEvent != "") {
			$activiteEvent = casefiche('Attivit e eventi sul territorio /<br>Activits sur le territoire : ', $activiteEvent);
		} 
		else {
			$activiteEvent = "";
		}
		
		if( $autresInfos != "" ) {
			$autresInfos = casefiche('Altre informazioni e progetti collegati /<br />Autres informations et projets : ', $autresInfos);
		} 
		else {
			$autresInfos = "";
		}
		
		$infopluspj = "";
		if ($siteAccessit != "" || $infosSupplement != "" || $pieceJointe != "") {
			$infopluspj .= '<div class="sepcaseatlas"></div>';
			$infopluspj .= '<table border="0" cellpadding="0" cellspacing= "0">';
			$siteAccessit = ($siteAccessit != "") ? $fr_boolean_site_infos_generales["Site_accessit"]["label_french"][$siteAccessit] . " / " . $fr_boolean_site_infos_generales["Site_accessit"]["label_italian"][$siteAccessit] : "";
			$infopluspj .= ($siteAccessit != "") ? '<tr><td class="caseinfotitre" valign="top">Appartenenza Accessit / Inclus dans le projet Accessit : </td><td class="caseinfocontent2">'.$siteAccessit.'</td></tr>' : '';
			$infopluspj .= ($infosSupplement != "") ? '<tr><td class="caseinfotitre">Ulteriori materiali  / Informations supplmentaires : </td><td class="caseinfocontent2">'.'<a href="' . $infosSupplement . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/docs'.$classstyle.'.gif" border="0">'.'</a>'.'</td></tr>' : '';
			$infopluspj .= ($pieceJointe != "") ? '<tr><td class="caseinfotitre">Allegati Itinerario / Pices jointes :</td><td class="caseinfocontent2">'.'<a href="' . $pieceJointe . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/docs'.$classstyle.'.gif" border="0">'.'</a>'.'</td></tr>' : '';
			$infopluspj .= ($divers != "") ? '<tr><td class="caseinfotitre">Diverso / Divers :</td><td class="caseinfocontent2">'.'<a href="' . $divers . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/docs'.$classstyle.'.gif" border="0">'.'</a>'.'</td></tr>' : '';
			$infopluspj .= '</table>';
		}
		
		$adhorent = "";
		if ($adresse != "" || $horairesOuverture != "" || $entree != "") {
			$adhorent = casefichetab(array(
						array("titre"=>"Indirizzo  /<br />Adresse : " ,"contenu"=>'<div align="center"><i>'.$adresse."</i></div>"),
						array("titre"=>"Orario di apertura  /<br/>Horaires d'ouverture :" ,"contenu"=>$horairesOuverture),
						array("titre"=>"Ingresso /<br />Entre :" ,"contenu"=>$entree)
			));
		}		
		
		$coords = "";
		if ($siteWeb != "" || $messagerie != "" || $tel != "") {
			$coords .= '<div class="sepcaseatlas"></div>';
			$coords .= '<table border="0" cellpadding="0" cellspacing= "0" width="302" >';
			$coords .= '<tr><td align="center" valign="middle" height="42" background="themes/'.$Default_Theme.'/images/coords'.$classstyle.'2.gif">';
			$coords .= ($siteWeb != "") ? '<a href="' . $siteWeb . '" target="_blank">'.'<img src="themes/'.$Default_Theme.'/images/webatlas.png" border="0">'.'</a>' :'';
			$coords .= ($siteWeb != "" && $messagerie != "") ? '<span style="width: 50px; display: inline-block;"></span>' : '';
			$coords .= ($messagerie != "") ? '<a href="mailto:' . $messagerie . '">'.'<img src="themes/'.$Default_Theme.'/images/mailatlas.png" border="0">'.'</a>' :'';
			$coords .= '</td></tr>';
			$coords .= ($tel != "") ? '<tr><td height="18"></td></tr>' : '';
			$coords .= ($tel != "") ? '<tr><td align="center"><table border="0" cellpaddind="0" cellspacing="0"><tr><td><img src="themes/'.$Default_Theme.'/images/tel'.$classstyle.'.gif"></td><td width="10"></td><td class="caseinfocontent">'.$tel.'</td></tr></table></td></tr>' : '';
			$coords .= '</table>';
		}
		/*else {
			$coords .= '<div class="sepcaseatlas"></div>';
			$coords .= '<table border="0" cellpadding="0" cellspacing= "0" width="302" >';
			$coords .= '<tr><td align="center" valign="middle" height="42" background="themes/'.$Default_Theme.'/images/coords'.$classstyle.'2.gif">';
			$coords .= '&nbsp;';
			$coords .= '</td></tr>';
			$coords .= '</table>';
		}*/
		
		$htmlPicto1 = "";
		$accessPhy = array();
		foreach ($arrayAccessPhysique as $champ => $arrayAccess) {
			if( file_exists($arrayAccess["picto"]) ) {
				$htmlPicto1 .= '<img src="'.$arrayAccess["picto"].'" width="20" alt="'.$arrayAccess["label_".$currentlang].'" /> ';
			} else {
				$accessPhy[] = $arrayAccess["label_french"] . " / " . $arrayAccess["label_italian"];
			}
		}
		
		if( $htmlPicto1 != "" || count($accessPhy) > 0 ) {
			$htmlPicto1 = "<p>Accessibilit physique : ".$htmlPicto1."</p>";
		}
		
		$htmlPicto2 = "";
		$accessCult = array();
		foreach ($arrayAccessCulture as $champ => $arrayAccess) {
			if( file_exists($arrayAccess["picto"]) ) {
				$htmlPicto2 .= '<img src="'.$arrayAccess["picto"].'" width="20" alt="'.$arrayAccess["label_".$currentlang].'" /> ';
			} else {
				$accessCult[] = $arrayAccess["label_french"] . " / " . $arrayAccess["label_italian"];
			}
		}
		
		if( $htmlPicto2 != "" || count($accessCult) > 0 ) {
			$htmlPicto2 = "<p>Accessibilit culturelle : ".$htmlPicto2."</p>";
		}
		
		$htmlPicto3 = "";
		$accessVirtu = array();
		foreach ($arrayAccessVirtuelle as $champ => $arrayAccess) {
			if( file_exists($arrayAccess["picto"]) ) {
				$htmlPicto3 .= '<img src="'.$arrayAccess["picto"].'" width="20" alt="'.$arrayAccess["label_".$currentlang].'" /> ';
			} else {
				$accessVirtu[] = $arrayAccess["label_french"] . " / " . $arrayAccess["label_italian"];
			}
		}
		
		if( $htmlPicto3 != "" || count($accessVirtu) > 0 ) {
			$htmlPicto3 = "<p>Accessibilit virtuelle : ".$htmlPicto3."</p>";
		}
		 /* htmlPicto pas utilis pour l'instant */
		$accessibilite = "";
		if (count($accessPhy) > 0) {
			$accessibilite.= ($accessibilite != "") ? '<td width="20"></td>' : '';
			$accessibilite .= '<td valign="top">'.'<div class="caseinfotitre2">Accessibilit Fisica /<br />Accessibilit Physique : </div>'.liste($accessPhy,"caseacces").'</td>';
		}
		if (count($accessCult) > 0) {
			$accessibilite.= ($accessibilite != "") ? '<td width="20"></td>' : '';
			$accessibilite .= '<td valign="top">'.'<div class="caseinfotitre2">Accessibilit Culturale /<br />Accessibilit Culturelle : </div>'.liste($accessCult,"caseacces").'</td>';
		}
		if (count($accessVirtu) > 0) {
			$accessibilite.= ($accessibilite != "") ? '<td width="20"></td>' : '';
			$accessibilite .= '<td valign="top">'.'<div class="caseinfotitre2">Accessibilit Virtuale /<br />Accessibilit Virtuelle : </div>'.liste($accessVirtu,"caseacces").'</td>';
		}
		$accessibilite = '<div class="sepcaseatlas"></div><table border="0" cellpadding="0" cellspacing="0" width="880" align="center"><tr>'.$accessibilite.'</tr></table>';
		
		$noteaccess = "";
		if ($noteAccessibilite != "") {
			$noteaccess .= '<div class="sepcaseatlas"></div>';
			$noteaccess .= '<table border="0" cellpadding="0" cellspacing= "0">';
			$noteaccess .= ($noteAccessibilite != "") ? '<tr><td class="caseinfotitre" valign="top">Note accessibilit /<br />Autres informations sur l\'accessibilit : </td><td class="caseinfocontent2">'.$noteAccessibilite.'</td></tr>' : '';
			$noteaccess .= '</table>';
		}
		

		if( $album != "" ) {
			$album = createAlbum ( $album );
		} 
		else {
			$album = "";
		}
	}
	
	/*$sortie = '
		<div class="atlas">
			<h1 id="titre"></h1>
			<div id="commentaire"></div>
			<table border="0" cellpadding="0" cellspacing="0">
			<tr><td align="center" valign="top">
			<div class="desc_itineraire">
				' .$nom .$desc .$theme .$circuits .$commune .$tel 
				.$siteWeb .$services .$infosSupplement .$noteAccessibilite
				.$autresInfos .$categorie .$adresse .$horairesOuverture .$entree 
				.$servicesSpe .$piecesJointes .$activiteEvent .$divers .$siteAccessit
				.$htmlPicto1 .colonnes($accessPhy, 2, "700", true, "v", "picto")
				.$htmlPicto2 .colonnes($accessCult, 2, "700", true, "v", "picto")
				.$htmlPicto3 .colonnes($accessVirtu, 2, "700", true, "v", "picto")
				.'</div>
			</td></tr>
			<tr><td valign="top">
			<div id="mini_map"></div>
			</td><td width="20"></td><td valign="top">
			<div id="leg"></div>
			</td></tr></table>
			<p>&nbsp;</p>
			<div id="obs"></div>
			<div class="desc_itineraire">
				' . $album . '
			</div>
		</div>';*/
	
	$sortie .= '
	<div class="atlas"><div class="'.$classstylecase.'">
	<table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td valign="top"><h1 id="titre">'.$nom /*strtoupper($nom)*/.'</h1></td><td width="15"></td><td valign="top" align="right"><table border="0" cellpadding="0" cellspacing="0"><tr><td nowrap="nowrap" align="right"><h1 class="theme">'.$theme.'</h1></td></tr>'.(($circuits != "") ? '<tr><td align="right"><h2 class="circuit">'.$circuits.'</h2></td></tr>' : '').'</table></td></tr></table>
	<div id="commentaire"></div>
	<table border="0" cellpadding="0" cellspacing="0" width=880 align="center">
	<tr>
	<td width="550" height="1"><img src="themes/'.$Default_Theme.'/images/spacer.gif" height="1" width="550"></td>
	<td width="28"><img src="themes/'.$Default_Theme.'/images/spacer.gif" height="1" width="28"></td>
	<td width="302"><img src="themes/'.$Default_Theme.'/images/spacer.gif" height="1" width="302"></td>
	</tr>
	<tr>
	<td colspan="3">'.$desc.'</td>
	</tr>
	<tr>
	<td width="608" valign="top">'.$infocat.$infolieu.$servs.$activiteEvent.$autresInfos.$infopluspj.'</td>
	<td width="28">&nbsp;</td>
	<td width="244"  valign="top"><div class="sepcaseatlas"></div><div id="mini_map"></div>'.$adhorent.$coords.'</td>
	</tr>
	</table>
	'.$accessibilite.'
	'.$noteaccess.'
	'.$album .'
	</div></div>
	';
	
	include ('header.php');
	echo $sortie;
	$bardef = array ( // "print"=>"modules.php?name=Chuck_Norris_Facts&sop=print&page=$page",
			// "pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back" => "javascript:window.history.back();",
			"top" => "#top"
	);
	buttonBar ( $bardef, "align" );
	include ('footer.php');
}

/**
 * Permet d'afficher la carte en fonction du xml et de l'id du site choisi
 * @param unknown $idSite l'id du site
 */
function get_map_pict_XML_fiche_site($idSite) {
	global $module_name, $Idc;
	require_once ("modules/" . $module_name . "/lib/getXMLcarto_pict_fiche_site.php");
	$sortie = getXMLcarto ( $Idc, $idSite );
	header ( "Content-Type: text/xml; charset=UTF-8" );
	echo $sortie;
}

$code_memo_carto = '
		<script type="text/javascript">
			if( typeof(options) != "undefined" && typeof(options["detruirCookie"]) == "undefined" ) {
				if( \'function\' == typeof(setCookie) ){
					setCookie("activeParam", "false");
				}
			}
		</script>';


switch ($sop) {
	case "map_itineraires" :
		display_map_symbol_itineraires ($theme);
		break;
	case "map_pict_XML_itineraires" :
		get_map_pict_XML_itineraires ( $theme, $circuit, $rech );
		break;
	case "map_fiche_itineraire" :
		display_map_symbol_fiche_itineraire ( $idItineraire );
		break;
	case "map_pict_XML_fiche_itineraire" :
		get_map_pict_XML_fiche_itineraire ( $idItineraire );
		break;
	case "fiche_site":
		display_map_symbol_fiche_site($idSite);
		break;
	case "map_pict_XML_fiche_site" :
		get_map_pict_XML_fiche_site ( $idSite );
		break;
	default :
		display_menu ();
		break;
}
?>