<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2005 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

//if (!defined('MODULE_FILE')) {
//	die ("You can't access this file directly...");
//}
if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}
require_once("core/becms_mainlib_lib.php");
require_once("core/becms_ui_component.php");
$module_name = basename(dirname(__FILE__));
get_lang($module_name);
$userpage = 1;

if(isset($_GET['redirect'])) $redirect = substr($_SERVER['QUERY_STRING'], strpos($_SERVER['QUERY_STRING'], "redirect=") + strlen("redirect="), strlen($_SERVER['QUERY_STRING']));

if(is_user($user)) {
	include("modules/$module_name/navbar.php");
}

function format_nuke_url($nukeurl) {
	$tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}
	return $racine;	
}

function userCheck($username, $user_email) {
	$username = filter($username, "nohtml", 1);
	$user_email = filter($user_email, "nohtml", 1);
	global $stop, $user_prefix, $db;
	if ((!$user_email) || (empty($user_email)) || (!preg_match("#^[_\.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,25}$#i",$user_email))) $stop = "<center>"._ERRORINVEMAIL."</center><br>";
	if (strrpos($user_email,' ') > 0) $stop = "<center>"._ERROREMAILSPACES."</center>";
	if ((!$username) || (empty($username)) || (preg_match("#[^a-zA-Z0-9_-]#",$username))) $stop = "<center>"._ERRORINVNICK."</center><br>";
	if (strlen($username) > 25) $stop = "<center>"._NICK2LONG."</center>";
	if (preg_match("#^((root)|(adm)|(linux)|(webmaster)|(admin)|(god)|(administrator)|(administrador)|(nobody)|(anonymous)|(anonimo)|(annimo)|(operator)|(JackFromWales4u2))$#i",$username)) $stop = "<center>"._NAMERESERVED."</center>";
	if (strrpos($username,' ') > 0) $stop = "<center>"._NICKNOSPACES."</center>";
	if ($db->sql_numrows($db->sql_query("SELECT uname FROM ".$user_prefix."_users WHERE uname='$username'")) > 0) $stop = "<center>"._NICKTAKEN."</center><br>";
	if ($db->sql_numrows($db->sql_query("SELECT uname FROM ".$user_prefix."_users_temp WHERE uname='$username'")) > 0) $stop = "<center>"._NICKTAKEN."</center><br>";
	if ($db->sql_numrows($db->sql_query("SELECT email FROM ".$user_prefix."_users WHERE email='$user_email'")) > 0) $stop = "<center>"._EMAILREGISTERED."</center><br>";
	if ($db->sql_numrows($db->sql_query("SELECT email FROM ".$user_prefix."_users_temp WHERE user_email='$user_email'")) > 0) $stop = "<center>"._EMAILREGISTERED."</center><br>";
	return $stop;
}
/**
 *
 *
 */
function confirmNewUser($username, $user_email, $user_password, $user_password2, $random_num, $gfx_check) {
	global $stop, $EditedMessage, $sitename, $module_name, $minpass;
	include("header.php");
	include("config.php");
	$username = filter($username, "nohtml");
	$user_email = filter($user_email, "nohtml");
	$user_viewemail = "0";
	userCheck($username, $user_email);
	$user_email = validate_mail($user_email);
	$user_password = htmlspecialchars(stripslashes($user_password),ENT_QUOTES,'ISO-8859-1',true);
	$user_password2 = htmlspecialchars(stripslashes($user_password2),ENT_QUOTES,'ISO-8859-1',true);
	echo "<h1>"._USERIDENT."</h1>";
	echo "<center><br /><br /><b>"._USERREGLOGIN."</b></center>\n";
	echo "<br /><br />\n";
	if (!$stop) {
		$datekey = date("F j");
		$rcode = hexdec(md5($_SERVER['HTTP_USER_AGENT'] . $sitekey . $_POST['random_num'] . $datekey));
		$code = substr($rcode, 2, 6);
		if (extension_loaded("gd") AND $code != $gfx_check AND ($gfx_chk == 3 OR $gfx_chk == 4 OR $gfx_chk == 6 OR $gfx_chk == 7)) {
			title(""._NEWUSERERROR."");
			OpenTable();
			echo "<center><b>"._SECCODEINCOR."</b><br><br>"
			.""._GOBACK."</center>";
			CloseTable();
			include("footer.php");
			die();
		}
		if (empty($user_password) AND empty($user_password2)) {
			$user_password = makepass();
		}
		elseif ($user_password != $user_password2) {
			echo "<fieldset><legend>"._REGNEWUSER."</legend>";
			echo "<center><b><br />"._NEWUSERERROR."<br /><br />"._PASSDIFFERENT."</b><br><br>"."<input type=\"button\" value=\""._BTNGOBACK."\" onclick=\"window.history.back()\">"."</center>";
			echo "</fieldset>";
			include("footer.php");
			die();
		}
		elseif ($user_password == $user_password2 AND strlen($user_password) < $minpass) {
			echo "<fieldset><legend>"._REGNEWUSER."</legend>";
			echo "<center><b><br />"._NEWUSERERROR."<br /><br />"._YOUPASSMUSTBE." <b>$minpass</b> "._CHARLONG."</b><br><br>"."<input type=\"button\" value=\""._BTNGOBACK."\" onclick=\"window.history.back()\">"."</center>";
			echo "</fieldset>";
			include("footer.php");
			die();
		}
		echo "<fieldset><legend>"._REGNEWUSER."</legend>";
		echo "<center><b><br />"._USERFINALSTEP."</b><br><br>$username, "._USERCHECKDATA."</center><br><br>"
		."<table align='center' border='0'>"
		."<tr><td><b>"._UUSERNAME.":</b> $username<br></td></tr>"
		."<tr><td><b>"._EMAIL.":</b> $user_email</td></tr></table><br><br>"
		."<center><b>"._NOTE."</b> "._YOUWILLRECEIVE."";
		echo "<form action=\"modules.php?name=$module_name\" method=\"post\">"
		."<input type=\"hidden\" name=\"random_num\" value=\"$random_num\">"
		."<input type=\"hidden\" name=\"gfx_check\" value=\"$gfx_check\">"
		."<input type=\"hidden\" name=\"username\" value=\"$username\">"
		."<input type=\"hidden\" name=\"user_email\" value=\"$user_email\">"
		."<input type=\"hidden\" name=\"user_password\" value=\"$user_password\">"
		."<input type=\"hidden\" name=\"op\" value=\"finish\"><br><br>"
		."<input type=\"submit\" value=\""._FINISH."\"> &nbsp;&nbsp;"."<input type=\"button\" value=\""._BTNGOBACK."\" onclick=\"window.history.back()\">"."</form></center>";
		echo "</fieldset>";
	}
	else {
		echo "<fieldset><legend>"._REGNEWUSER."</legend>";
		echo "<center><b>"._REGERROR."</b><br><br>";
		echo "$stop<br>"."<input type=\"button\" value=\""._BTNGOBACK."\" onclick=\"window.history.back()\">"."</center>";
		echo "</fieldset>";
	}
	include("footer.php");
}

function finishNewUser($username, $user_email, $user_password, $random_num, $gfx_check) {
	global $stop, $EditedMessage, $adminmail, $sitename, $Default_Theme, $user_prefix, $db, $storyhome, $module_name, $nukeurl;
	include("header.php");
	include("config.php");
	userCheck($username, $user_email);
	$user_email = validate_mail($user_email);
	$user_regdate = date("M d, Y");
	$user_password = htmlspecialchars(stripslashes($user_password),ENT_QUOTES,'ISO-8859-1',true);
	if (!isset($stop)) {
		$datekey = date("F j");
		$rcode = hexdec(md5($_SERVER['HTTP_USER_AGENT'] . $sitekey . $random_num . $datekey));
		$code = substr($rcode, 2, 6);
		if (extension_loaded("gd") AND $code != $gfx_check AND ($gfx_chk == 3 OR $gfx_chk == 4 OR $gfx_chk == 6 OR $gfx_chk == 7)) {
			Header("Location: modules.php?name=$module_name");
			die();
		}
		mt_srand ((double)microtime()*1000000);
		$maxran = 1000000;
		$check_num = mt_rand(0, $maxran);
		$check_num = md5($check_num);
		$time = time();
		
		$nukeurl = format_nuke_url($nukeurl);
		
		$finishlink = "$nukeurl/modules.php?name=$module_name&op=activate&username=$username&check_num=$check_num";
		$new_password = md5($user_password);
		$new_password = htmlspecialchars(stripslashes($new_password),ENT_QUOTES,'ISO-8859-1',true);
		$username = filter($username, "nohtml", 1);
		$user_email = filter($user_email, "nohtml", 1);
		$result = $db->sql_query("INSERT INTO ".$user_prefix."_users_temp (user_id, username, user_email, user_password, user_regdate, check_num, time) VALUES (NULL, '$username', '$user_email', '$new_password', '$user_regdate', '$check_num', '$time')");
		if(!$result) {
			echo ""._ERROR."<br>";
		}
		else {
			$message = ""._WELCOMETO." $sitename!\n\n"._YOUUSEDEMAIL." ($user_email) "._TOREGISTER." $sitename.\n\n "._TOFINISHUSER."\n\n $finishlink\n\n "._FOLLOWINGMEM."\n\n"._UNICKNAME." $username\n"._UPASSWORD." $user_password";
			$subject = ""._ACTIVATIONSUB."";
			$from = "$adminmail";
			mail($user_email, $subject, $message, "From: $from\nX-Mailer: PHP/" . phpversion());
			
			echo "<h1>"._USERIDENT."</h1>";
			echo "<center><br /><br /><b>"._USERREGLOGIN."</b></center>\n";
			echo "<br /><br />\n";
			echo "<fieldset><legend>"._REGNEWUSER."</legend>";
			echo "<center><br /><b>"._ACCOUNTCREATED."</b><br><br>";
			echo _FINISHUSERCONF."<br><br>"
			.""._THANKSUSER." $sitename!</center>";
			echo "</fieldset>";
		}
	}
	else {
		echo "<h1>"._USERIDENT."</h1>";
		echo "<center><br /><br /><b>"._USERREGLOGIN."</b></center>\n";
		echo "<br /><br />\n";
		echo "<fieldset><legend>"._REGNEWUSER."</legend>";
		echo "<center><b>"._REGERROR."</b><br><br>";
		echo "$stop<br>"."<input type=\"button\" value=\""._BTNGOBACK."\" onclick=\"window.history.back()\">"."</center>";
		echo "</fieldset>";
	}
	include("footer.php");
}


function activate($username, $check_num) {
	global $db, $user_prefix, $module_name, $language, $prefix;
	$username = filter($username, "nohtml", 1);
	$past = time()-86400;
	$db->sql_query("DELETE FROM ".$user_prefix."_users_temp WHERE time < $past");
	$sql = "SELECT * FROM ".$user_prefix."_users_temp WHERE username='$username' AND check_num='$check_num'";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) == 1) {
		$row = $db->sql_fetchrow($result);
		$user_password = htmlspecialchars(stripslashes($row['user_password']),ENT_QUOTES,'ISO-8859-1',true);
		if ($check_num == $row['check_num']) {
			$db->sql_query("INSERT INTO ".$user_prefix."_users (uid, uname, email, pass, user_avatar, user_avatar_type, user_regdate, user_lang) VALUES (NULL, '".$row['username']."', '".$row['user_email']."', '$user_password', 'blank.gif', '3', '".$row['user_regdate']."', '$language')");
			$result2 = $db->sql_query("SELECT uid FROM ".$user_prefix."_users WHERE uname='".$row['username']."'");
			$row2 = $db->sql_fetchrow($result2);
			$guserid = intval($row2['user_id']);
			// $db->sql_query("INSERT INTO ".$prefix."_bbgroups (group_name, group_description, group_single_user, group_moderator) VALUES ('', 'Personal User', '1', '0')");
			// $group_id = $db->sql_nextid();
			// $db->sql_query("INSERT INTO ".$prefix."_bbuser_group (user_id, group_id, user_pending) VALUES ('$guserid', '$group_id', '0')");
			$db->sql_query("DELETE FROM ".$user_prefix."_users_temp WHERE username='$username' AND check_num='$check_num'");
			include("header.php");
			echo "<h1>"._USERIDENT."</h1>";
			echo "<fieldset><legend>"._REGNEWUSER."</legend>";
			echo "<center><b><br />"._ACTIVATIONYES."</b></center><br><br>";
			echo "<center><b>".$row['username'].":</b> "._ACTMSG."</center>";
			echo "<p>&nbsp;</p>";
			echo "</fieldset>";
			include("footer.php");
			die();
		}
		else {
			include("header.php");
			echo "<h1>"._USERIDENT."</h1>";
			echo "<fieldset><legend>"._REGNEWUSER."</legend>";
			echo "<center><b><br />"._ACTIVATIONERROR."</b></center><br><br>";
			echo "<center><b>".$row['username'].":</b> "._ACTERROR1."</center>";
			echo "<p>&nbsp;</p>";
			echo "</fieldset>";
			include("footer.php");
			die();
		}
	}
	else {
		include("header.php");
		echo "<h1>"._USERIDENT."</h1>";
		echo "<fieldset><legend>"._REGNEWUSER."</legend>";
		echo "<center><b><br />"._ACTIVATIONERROR."</b></center><br><br>";
		echo "<center><b>".$username." :</b> "._ACTERROR2."</center>";
		echo "<p>&nbsp;</p>";
		echo "</fieldset>";
		include("footer.php");
		die();
	}
}
/**
 * userinfo()
 * Display user Informations
 * @param
 * @param
 */
function userinfo($username, $bypass=0, $hid=0, $url=0) {
	global $articlecomm, $user, $cookie, $sitename, $prefix, $user_prefix, $db, $admin, $broadcast_msg, $my_headlines, $module_name, $subscription_url, $admin_file, $trace;

	$username = filter($username, "nohtml", 1);
	$username = substr("$username", 0,25);
	//$sql = "SELECT * FROM ".$prefix."_bbconfig";
	//$result = $db->sql_query($sql);
	//while ( $row = $db->sql_fetchrow($result) )
	//{
	//	$board_config[$row['config_name']] = $row['config_value'];
	//}
	//$trace->trace("DB Prefix:".$user_prefix);
	//$trace->trace("User_Name :".$username);
	$board_config['avatar_gallery_path']="modules/Forum/images/avatar";
	$sql2 = "SELECT * FROM ".$user_prefix."_users WHERE uname='$username'";

	$result2 = $db->sql_query($sql2);
	$num = $db->sql_numrows($result2);

	if ($num != 1) {
		Header("Location: modules.php?name=$module_name");
		die();
	}

	$userinfo = $db->sql_fetchrow($result2);

	if(!$bypass) cookiedecode($user);
	include("header.php");
	//OpenTable();
	if ($username != '') // SecurityReason.com Fix 2005 [sp3x]
	if((isset($cookie[1])) AND (strtolower($username) == strtolower($cookie[1])) AND ($userinfo['pass'] == $cookie[2])) {
		echo "<H1>"._WELCOMETO._YOURPERSONALPAGE.", ".htmlentities($username)."</H1>";
		echo "<div class=\"ya_buttonBarDiv\">";
		themesidebox(_MENUTODO, nav(1, "valign"));
		echo "</div>";
		echo "<p>&nbsp;<br />&nbsp;<br />"._THISISYOURPAGE."</P>";
	}
	else {
		echo "<H1>"._PERSONALINFO._USERINFOOF.htmlentities($username)."</H1>";
	}
	else Header("Location: modules.php?name=$module_name");
	// ----- URL -----
	if ($userinfo['url']) {
		if (!preg_match('#^http[s]?:\/\/#i', $userinfo['url'])) {
			$userinfo['url'] = "http://" . $userinfo['url'];
		}
		if (!preg_match('#^http[s]?\\:\\/\\/[a-z0-9\-]+\.([a-z0-9\-]+\.)?[a-z]+#i', $userinfo['url'])) {
			$userinfo['url'] = '';
		}
	}
	// ------ AVATAR ------
	if ($userinfo['user_avatar_type'] == 1) {
		$userinfo['user_avatar'] = $board_config['avatar_path']."/".$userinfo['user_avatar'];
	}
	elseif ($userinfo['user_avatar_type'] == 2) {
		$userinfo['user_avatar'] = $userinfo['user_avatar'];
	}
	else {
		$userinfo['user_avatar'] = $board_config['avatar_gallery_path']."/".$userinfo['user_avatar'];
	}
	// ----- USER PIN ----------
	if(($num == 1) && ($userinfo['url'] || $userinfo['femail'] || $userinfo['bio'] || $userinfo['user_avatar'] || $userinfo['user_icq'] || $userinfo['user_aim'] || $userinfo['user_yim'] || $userinfo['user_msnm'] || $userinfo['user_location'] || $userinfo['user_occ'] || $userinfo['user_interests'] || $userinfo['user_sig'])) {
		echo '<fieldset class="ya_user_div"><legend>'._PERSONALINFO.'</legend>';

		//echo "<table class=ya_main_table>"
		//."<tr><td>";
		//
		//echo "<div class=ya_main_table>";

		echo "<table class=\"ya_user_table\">";
		echo "<tr><td rowspan=20 class=\"ya_img_td\"><img src=\"".$userinfo['user_avatar']."\"></td></tr>\n";
		if ($userinfo['url'] != "http://" AND !empty($userinfo['url'])) {
			echo "<tr><td class=ya_user_attr>"._MYHOMEPAGE."</td><td class=ya_user_data> <a href=\"".$userinfo['url']."\" target=\"new\">".$userinfo['url']."</a></td></tr>\n";
		}
		if ($userinfo['femail']) {
			echo "<tr><td class=ya_user_attr>"._MYEMAIL."</td><td class=ya_user_data> <a href=\"mailto:".$userinfo['femail']."\">".$userinfo['femail']."</a></td></tr>\n";
		}
		if ($userinfo['user_icq'] && preg_match('/^[0-9]+$/', $userinfo['user_icq'])) {
			echo "</td><td class=ya_user_attr>"._ICQ.":</td><td class=ya_user_data> ".$userinfo['user_icq']."</td></tr>\n";
		}
		if ($userinfo['user_aim']) {
			echo "<tr><td class=ya_user_attr>"._AIM.":</td><td class=ya_user_data> ".$userinfo['user_aim']."</td></tr>\n";
		}
		if ($userinfo['user_yim']) {
			echo "<tr><td class=ya_user_attr>"._YIM.":</td><td class=ya_user_data> ".$userinfo['user_yim']."</td></tr>\n";
		}
		if ($userinfo['user_msnm']) {
			echo "<tr><td class=ya_user_attr>"._MSNM.":</td><td class=ya_user_data> ".$userinfo['user_msnm']."</td></tr>\n";
		}
		if ($userinfo['user_from']) {
			echo "<tr><td class=ya_user_attr>"._LOCATION.":</td><td class=ya_user_data> ".preg_replace("#\.gif|\.jpg|\.jpeg|\.png#i","",$userinfo['user_from'])."</td></tr>\n";
		}
		if ($userinfo['user_occ']) {
			echo "<tr><td class=ya_user_attr>"._OCCUPATION.":</td><td class=ya_user_data> ".$userinfo['user_occ']."</td></tr>\n";
		}
		if ($userinfo['user_interests']) {
			echo "<tr><td class=ya_user_attr>"._INTERESTS.":</td><td class=ya_user_data> ".$userinfo['user_interests']."</td></tr>\n";
		}
		$userinfo['user_sig'] = nl2br($userinfo['user_sig']);
		if ($userinfo['user_sig']) {
			echo "<tr><td class=ya_user_attr>"._SIGNATURE.":</td><td class=ya_user_data>".$userinfo['user_sig']."</td></tr>\n";
		}
		if ($userinfo['bio']) {
			echo "<tr><td class=ya_user_attr>"._EXTRAINFO.":</td><td class=ya_user_data>".$userinfo['bio']."</td></tr>\n";
		}
		if (is_user($user) AND $cookie[1] == "$username" OR is_admin($admin)) {
			$numpoints = $db->sql_fetchrow($db->sql_query("SELECT points FROM ".$user_prefix."_users WHERE uid = '".intval($cookie[0])."'"));
			$n_points = intval($numpoints['points']);
			echo "<tr><td class=\"ya_user_attr\">"._YOUHAVEPOINTS."</td><td class=ya_user_data>$n_points</td></tr>";
		}
		echo "<tr><td colspan=2>";
		$sql2 = "SELECT username FROM ".$prefix."_session WHERE username='$username'";
		$result2 = $db->sql_query($sql2);
		$row2 = $db->sql_fetchrow($result2);
		$username_pm = $username;
		$username_online = $row2['username'];
		if (empty($username_online)) {
			$online = _OFFLINE;
		} else {
			$online = _ONLINE;
		}
		echo "<br>"._USERSTATUS." : $online<br>\n";
		if (($userinfo['newsletter'] == 1) AND ($username == $cookie[1]) AND ($userinfo['pass'] == $cookie[2]) OR (is_admin($admin) AND ($userinfo['newsletter'] == 1))) {
			echo _SUBSCRIBED."<br>";
		}
		elseif ((isset($cookie[1])) AND ($userinfo['newsletter'] == 0) AND ($username == $cookie[1]) AND ($userinfo['pass'] == $cookie[2]) OR (is_admin($admin) AND ($userinfo['newsletter'] == 0))) {
			echo _NOTSUBSCRIBED."<br>";
		}

		if ((isset($cookie[1])) AND is_active("Private_Messages") AND ($username == $cookie[1]) AND ($userinfo['pass'] == $cookie[2])) {
			$numrow = $db->sql_numrows($db->sql_query("select to_userid from ".$prefix."_priv_msgs where to_userid='$userinfo[uid]'"));
			if (!empty($mem_list) AND !empty($mod_search)) {
				$a = " | ";
			}
			else {
				$a = "";
			}
			if (!empty($mem_list) OR !empty($mod_search)) {
				$links = "[ $mem_list $a $mod_search ]";
			}
			elseif (empty($mem_list) AND empty($mod_search)) {
				$links = "";
			}
			echo ""._YOUHAVE." <a href=\"modules.php?name=Private_Messages\"><b>$numrow</b> "._PRIVATEMSG."</a>";
		}
		echo "</td></tr>";
		echo "</table>";

		echo '</fieldset>';


		//echo "<div id=\"ya_list_div\">";
		// -------------------- POSTED COMMENTS ----------------------
		echo "&nbsp;<br />";
		echo '<fieldset class="ya_user_div"><legend>'._LAST10COMMENTS." ".$userinfo['uname'].'</legend>';
		if ($articlecomm == 1) {
			echo "<ul>";
			$sql6 = "SELECT tid, sid, subject FROM ".$prefix."_comments WHERE name='".$userinfo['uname']."' ORDER BY tid DESC LIMIT 0,10";
			$result6 = $db->sql_query($sql6);
			while($row6 = $db->sql_fetchrow($result6)) {
				$tid = intval($row6['tid']);
				$sid = intval($row6['sid']);
				$subject = filter($row6['subject'], "nohtml");
				echo "<li><a href=\"modules.php?name=News&file=article&thold=-1&mode=flat&order=0&sid=$sid#$tid\">$subject</a></li>";
			}
			echo "</ul>";
		}
		else {
			echo _NONE;
		}
		echo '</fieldset>';
		// -------------------- POSTED ARTICLES ----------------------
		echo "&nbsp;<br />";
		echo '<fieldset class="ya_user_div"><legend>'._LAST10SUBMISSIONS." ".$userinfo['uname'].'</legend>';
		$sql7 = "SELECT sid, title FROM ".$prefix."_stories WHERE informant='".$userinfo['uname']."' ORDER BY sid DESC LIMIT 0,10";
		$result7 = $db->sql_query($sql7);
		if ($db->sql_numrows($result7)>=1){
			echo "<ul>";
			while($row7 = $db->sql_fetchrow($result7)) {
				$sid = intval($row7['sid']);
				$title = filter($row7['title'], "nohtml");
				echo "<li><a href=\"modules.php?name=News&file=article&sid=$sid\">$title</a></li>";
			}
			echo "</ul>";
		}
		else {
			echo _NONE;
		}
		echo '</fieldset>';
		// -------------------- SUDOKUS ENREGISTRES ----------------------
		if (file_exists("modules/Sudoku/connector_lib.php")) {
			echo "&nbsp;<br />";
			echo '<fieldset class="ya_user_div"><legend>'._MYSUDOKUS." ".$userinfo['uname'].'</legend>';
			require("modules/Sudoku/connector_lib.php");
			$mes_sudokus = new sudokuconnector();
			$parties = $mes_sudokus->getMySudokus($My_SQL,$vars_mod,"0,10");
			$parties_ligne = "";
			foreach ($parties as $partie) {
				if ($partie["grille"] == $partie["grille_utilisateur"]) {
					$picto = "resolusp.gif";
					$mess_survol = _SUDOKUSOLVED;
				}
				else {
					$picto = "nonresolusp.gif";
					$mess_survol = _SUDOKUNOTSOLVED;
				}
				$urlpicto = 'modules/Sudoku/lib/icns/'.$picto;
				$parties_ligne .= "<li>";
				$parties_ligne .= "<img src=\"".$urlpicto."\" align=\"top\" alt=\"".$mess_survol."\" title=\"".$mess_survol."\"> ";
				$parties_ligne .= '<a href="modules.php?name=Sudoku&sop=play_my_grid&id_partie_sudoku='.$partie["id_partie"].'">';
				$parties_ligne .= "N ".$partie["id_grille"]." - Niveau ".$partie["niveau"]." - "._SODOKULASTSAVE.adminSudoku::date2JMA($partie["date"]);
				$parties_ligne .= "</a>";
				$parties_ligne .= "</li>";
			}
			if ($parties_ligne != "") {
				$parties_ligne = "<ul>".$parties_ligne."</ul>";
			}
			else {
				$parties_ligne = _NONE;
			}
			echo $parties_ligne;
			echo '</fieldset>';
		}
		//echo "</div>";

		//echo "<hr>";
		//echo "</td></tr></table>"
		//."</td></table>";


		/*if (paid()) {
		 $row = $db->sql_fetchrow($db->sql_query("SELECT * FROM ".$prefix."_subscriptions WHERE userid='".intval($cookie[0])."'"));
		 if (!empty($subscription_url)) {
		 $content = "<br><center>"._YOUARE." <a href='$subscription_url'>"._SUBSCRIBER."</a> "._OF." $sitename<br>";
		 } else {
		 $content = "<br><center>"._YOUARE." "._SUBSCRIBER." "._OF." $sitename<br>";
		 }
		 $diff = $row['subscription_expire']-time();
		 $yearDiff = floor($diff/60/60/24/365);
		 $diff -= $yearDiff*60*60*24*365;
		 if ($yearDiff < 1) {
		 $diff = $row['subscription_expire']-time();
		 }
		 $daysDiff = floor($diff/60/60/24);
		 $diff -= $daysDiff*60*60*24;
		 $hrsDiff = floor($diff/60/60);
		 $diff -= $hrsDiff*60*60;
		 $minsDiff = floor($diff/60);
		 $diff -= $minsDiff*60;
		 $secsDiff = $diff;
		 if ($yearDiff < 1) {
		 $rest = "$daysDiff "._SBDAYS.", $hrsDiff "._SBHOURS.", $minsDiff "._SBMINUTES.", $secsDiff "._SBSECONDS."";
		 } elseif ($yearDiff == 1) {
		 $rest = "$yearDiff "._SBYEAR.", $daysDiff "._SBDAYS.", $hrsDiff "._SBHOURS.", $minsDiff "._SBMINUTES.", $secsDiff "._SBSECONDS."";
		 } elseif ($yearDiff > 1) {
		 $rest = "$yearDiff "._SBYEARS.", $daysDiff "._SBDAYS.", $hrsDiff "._SBHOURS.", $minsDiff "._SBMINUTES.", $secsDiff "._SBSECONDS."";
		 }
		 $content .= "<b>"._SUBEXPIREIN."<br><font color='#FF0000'>$rest</font></b></center>";
			} else {
			if (!empty($subscription_url)) {
			$content .= "<br><center>"._NOTSUB." $sitename. "._SUBFROM." <a href='$subscription_url'>"._HERE."</a> "._NOW."";
			} else {
			$content .= "<br><center>"._NOTSUB." $sitename.";
			}
			}
			echo "$content<br><br>";

			if (is_admin($admin)) {
			$subnum = $db->sql_numrows($db->sql_query("SELECT * FROM ".$prefix."_subscriptions WHERE userid='".intval($userinfo['user_id'])."'"));
			if ($subnum != 0) {
			echo "<center><b>"._ADMSUB."</b></center><br>";
			$row = $db->sql_fetchrow($db->sql_query("SELECT * FROM ".$prefix."_subscriptions WHERE userid='".intval($userinfo['user_id'])."'"));
			$diff = $row['subscription_expire']-time();
			$yearDiff = floor($diff/60/60/24/365);
			$diff -= $yearDiff*60*60*24*365;
			if ($yearDiff < 1) {
			$diff = $row['subscription_expire']-time();
			}
			$daysDiff = floor($diff/60/60/24);
			$diff -= $daysDiff*60*60*24;
			$hrsDiff = floor($diff/60/60);
			$diff -= $hrsDiff*60*60;
			$minsDiff = floor($diff/60);
			$diff -= $minsDiff*60;
			$secsDiff = $diff;
			if ($yearDiff < 1) {
			$rest = "$daysDiff "._SBDAYS.", $hrsDiff "._SBHOURS.", $minsDiff "._SBMINUTES.", $secsDiff "._SBSECONDS."";
			} elseif ($yearDiff == 1) {
			$rest = "$yearDiff "._SBYEAR.", $daysDiff "._SBDAYS.", $hrsDiff "._SBHOURS.", $minsDiff "._SBMINUTES.", $secsDiff "._SBSECONDS."";
			} elseif ($yearDiff > 1) {
			$rest = "$yearDiff "._SBYEARS.", $daysDiff "._SBDAYS.", $hrsDiff "._SBHOURS.", $minsDiff "._SBMINUTES.", $secsDiff "._SBSECONDS."";
			}
			$content = "<b>"._ADMSUBEXPIREIN."<br><font color='#FF0000'>$rest</font></b><br><br>";
			echo "$content";
			} else {
			echo "<center><b>"._ADMNOTSUB."</b><br><br>";
			}
			}
			}
			if (is_active("Journal") AND $cookie[1] != $username) {
			$sql3 = "SELECT jid FROM ".$prefix."_journal WHERE aid='$username' AND status='yes' ORDER BY pdate,jid DESC LIMIT 0,1";
			$result3 = $db->sql_query($sql3);
			$row3 = $db->sql_fetchrow($result3);
			$jid = intval($row3['jid']);
			if (!empty($jid) AND isset($jid)) {
			echo "[ <a href=\"modules.php?name=Journal&amp;file=search&amp;bywhat=aid&amp;forwhat=$username\">"._READMYJOURNAL."</a> ]<br>";
			}
			}*/
		// Not need !!! this function is provided by message
		// ------------- PRIVATE MESSAGE ---------------------
		//echo "<div id=ya_private_msg>";
		//if (((is_user($user) AND $cookie[1] != $username) OR is_admin($admin)) AND is_active("Private_Messages")) {
		//	echo "[ <a href=\"modules.php?name=Private_Messages&amp;mode=post&amp;u=".intval($userinfo['uid'])."\">"._USENDPRIVATEMSG." $username_pm</a> ]<br>\n";}
		//echo "</div>";
	}
	else {
		echo "<center>"._NOINFOFOR." ".htmlentities($username)."</center>";
	}

	// ---------------------------------------- HEADLINE ------------------------------------------
	//echo "<div id=\"ya_headline\">";
	$my_headlines = 1;
	if ((isset($cookie[1])) AND $my_headlines == 1 AND ($username == $cookie[1]) AND ($userinfo['pass'] == $cookie[2])) {
		echo "&nbsp;<br />";
		echo '<fieldset class="ya_user_div"><legend>'._MYHEADLINES.'</legend>';
		echo "<center>"._SELECTASITE."<br /><br />"
		."<form action=\"modules.php?name=$module_name\" method=\"post\">"
		."<input type=\"hidden\" name=\"op\" value=\"userinfo\">"
		."<input type=\"hidden\" name=\"username\" value=\"$username\">"
		."<input type=\"hidden\" name=\"bypass\" value=\"$bypass\">"
		."<input type=\"hidden\" name=\"url\" value=\"0\">"
		."<select name=\"hid\" onChange='submit()'>\n"
		."<option value=\"0\">"._SELECTASITE2."</option>";
		$sql4 = "SELECT hid, sitename FROM ".$prefix."_headlines ORDER BY sitename";
		$headl = $db->sql_query($sql4);
		while($row4 = $db->sql_fetchrow($headl)) {
			$nhid = intval($row4['hid']);
			$hsitename = $row4['sitename'];
			if ($hid == $nhid ) {
				$sel = "selected";
			} else {
				$sel = "";
			}
			echo "<option value=\"$nhid\" $sel>$hsitename</option>\n";
		}
		echo "</select></form>"
		.""._ORTYPEURL."<br><br>"
		."<form action=\"modules.php?name=$module_name\" method=\"post\">"
		."<input type=\"hidden\" name=\"op\" value=\"userinfo\">"
		."<input type=\"hidden\" name=\"username\" value=\"$username\">"
		."<input type=\"hidden\" name=\"bypass\" value=\"$bypass\">"
		."<input type=\"hidden\" name=\"hid\" value=\"0\">"
		."<input type=\"text\" name=\"url\" size=\"40\" maxlength=\"200\" value=\"http://\">&nbsp;&nbsp;"
		."<input type=\"submit\" value=\""._GO."\"></form>";
		if ($hid != 0 OR ($hid == 0 AND $url != "0" AND $url != "http://") AND !empty($url)) {
			if ($hid != 0) {
				$sql5 = "SELECT sitename, headlinesurl FROM ".$prefix."_headlines WHERE hid='$hid'";
				$result5 = $db->sql_query($sql5);
				$row5 = $db->sql_fetchrow($result5);
				$nsitename = $row5[sitename];
				$url = filter($row5[headlinesurl], "nohtml");
				$title = $nsitename;
				$siteurl = preg_replace("#http://#i", "", $url);
				$siteurl = explode("/", $siteurl);
			}
			else {
				if (!preg_match("#http://#", $url)) {
					$url = "http://$url";
				}
				$siteurl = preg_replace("#http://#i", "", $url);
				$siteurl = explode("/", $siteurl);
				$title = "http://$siteurl[0]";
			}
			$rdf = parse_url($url);
			$fp = fsockopen($rdf['host'], 80, $errno, $errstr, 15);
			if (!$fp) {
				$content = "<center><b>"._RSSPROBLEM."</b></center>";
			}
			if ($fp) {
				fputs($fp, "GET " . $rdf['path'] . "?" . $rdf['query'] . " HTTP/1.0\r\n");
				fputs($fp, "HOST: " . $rdf['host'] . "\r\n\r\n");
				$string	= "";
				while(!feof($fp)) {
					$pagetext = fgets($fp,300);
					$string .= chop($pagetext);
				}
				fputs($fp,"Connection: close\r\n\r\n");
				fclose($fp);
				$items = explode("</item>",$string);
				$content = "<font class=\"content\">";
				for ($i=0;$i<10;$i++) {
					$link = preg_replace("#.*<link>#","",$items[$i]);
					$link = preg_replace("#</link>.*#","",$link);
					$link = stripslashes(check_html($link, "nohtml"));
					$title2 = preg_replace("#.*<title>#","",$items[$i]);
					$title2 = preg_replace("#</title>.*#","",$title2);
					$title2 = stripslashes(check_html($title2, "nohtml"));
					if (empty($items[$i]) AND $cont != 1) {
						$content = "<tr><td colspan=\"2\"><center>"._RSSPROBLEM."</center></td></tr>";
					} else {
						if (strcmp($link,$title2) AND !empty($items[$i])) {
							$cont = 1;
							$content .= "<tr><td width=\"15\"><img src=\"/modules/".$module_name."/images/arrow.gif\" border=\"0\"></td><td><a href=\"$link\" target=\"new\">$title2</a></td></tr>\n";
						}
					}
				}
			}
			if (!empty($content)) {
				echo '<table border="0" cellpadding="0" cellspacing="0" class="ya_headline">';
				echo "<tr><th colspan=\"2\">"._HEADLINESFROM." <a href=\"http://$siteurl[0]\" target=\"new\">$title</a></th></tr>";
				echo "$content";
				echo '</table>';
			}
			elseif (($cont == 0) OR (empty($content))) {
				echo "<center>"._RSSPROBLEM."</center><br>";
			}
			echo "<br>";
		}
		echo "</center>";
		echo "</fieldset>";
	}
	//echo "</div>";

	//echo "<div id=\"ya_broadcast\" >";
	// ----------------- BROADCAST -------------------
	if ((isset($cookie[1])) AND $broadcast_msg == 1 AND ($username == $cookie[1]) AND ($userinfo['pass'] == $cookie[2])) {
		echo "&nbsp;<br />";
		echo '<fieldset class="ya_user_div"><legend>'._BROADCAST.'</legend>';
		echo "<center>"._BROADCASTTEXT."<br><br>"
		."<form action=\"modules.php?name=$module_name\" method=\"post\">"
		."<input type=\"hidden\" name=\"who\" value=\"$username\">"
		."<input type=\"hidden\" name=\"op\" value=\"broadcast\">"
		."<input type=\"hidden\" name=\"broadcast_msg\" value=\"".$broadcast_msg."\">"
		."<input type=\"text\" size=\"60\" maxlength=\"255\" name=\"the_message\">&nbsp;&nbsp;<input type=\"submit\" value=\""._SEND."\">"
		."</form></center>";
		echo "</fieldset>";
	}
	//echo "</div>";

	userinfoForAdmin($userinfo);
	adminEditButton("system.php?op=modifyUser&chng_uid=".$userinfo['uid']);

	include("footer.php");
}

/**
 * userinfoForAdmin()
 * @param array userinfo array
 */
function userinfoForAdmin($userinfo){
	global $admin, $admin_file, $module_name, $trace;

	$imgLink="modules/$module_name/images";
	if (is_admin($admin)) {
		echo "&nbsp;<br />";
		echo '<fieldset class="ya_admin_div"><legend>'._ADMINFUNCTIONS." "._USER." ".$userinfo['uname'].'</legend>';

		//echo "<div id=ya_admin_box >";
		echo "<table border=\"0\"class=ya_admin_table>";
		//echo "<tr><th colspan=2>"._ADMINFUNCTIONS." "._USER." ".$userinfo['name']."</th></tr>";
		if ($userinfo['last_ip'] != 0) {
			echo "<tr><th align=\"left\" nowrap=\"nowrap\">"._LASTIP."  :<b>".$userinfo['last_ip']."</b></th>";
			echo "<td><a href='".$admin_file.".php?op=ipban&ip=".$userinfo['last_ip']."'><img src=\"$imgLink/stop.gif\" border=\"0\" alt=\""._BANTHIS."\" title=\""._BANTHIS."\" hspace=\"9\"></a></td>";
			echo "</tr>";
		}
		// -------------- KARMA ----------------
		if ($userinfo['karma'] == 0) {
			$karma = _KARMAGOOD;
			$karma_help = _KARMAGOODHLP;
		}
		elseif ($userinfo['karma'] == 1) {
			$karma = _KARMALOW;
			$karma_help = _KARMALOWHLP;
		}
		elseif ($userinfo['karma'] == 2) {
			$karma = _KARMABAD;
			$karma_help = _KARMABADHLP;
		}
		elseif ($userinfo['karma'] == 3) {
			$karma = _KARMADEVIL;
			$karma_help = _KARMADEVILHLP;
		}
		$change_karma = '<table border="0" cellpadding="0" cellspacing="4"><tr>';
		$change_karma .= '<th colspan="2">';
		$change_karma .= _CHANGEKARMA;
		$change_karma .= '</th></tr><tr><td>';
		$change_karma .= "<a href=\"modules.php?name=$module_name&op=change_karma&user_id=".$userinfo['uid']."&karma=0\"><img src=\"$imgLink/karma/0.gif\" border=\"0\" alt=\""._KARMAGOOD."\" title=\""._KARMAGOOD."\" hspace=\"5\"></a>";
		$change_karma .= '</td><td>';
		$change_karma .= _KARMAGOODHLP."<br />"._KARMAGOODREF;
		$change_karma .= '</td></tr><tr><td>';
		$change_karma .= "<a href=\"modules.php?name=$module_name&op=change_karma&user_id=".$userinfo['uid']."&karma=1\"><img src=\"$imgLink/karma/1.gif\" border=\"0\" alt=\""._KARMALOW."\" title=\""._KARMALOW."\" hspace=\"5\"></a>";
		$change_karma .= '</td><td>';
		$change_karma .= _KARMALOWHLP."<br />"._KARMALOWREF;
		$change_karma .= '</td></tr><tr><td>';
		$change_karma .= "<a href=\"modules.php?name=$module_name&op=change_karma&user_id=".$userinfo['uid']."&karma=2\"><img src=\"$imgLink/karma/2.gif\" border=\"0\" alt=\""._KARMABAD."\" title=\""._KARMABAD."\" hspace=\"5\"></a>";
		$change_karma .= '</td><td>';
		$change_karma .= _KARMABADHLP."<br />"._KARMABADREF;
		$change_karma .= '</td></tr><tr><td>';
		$change_karma .= "<a href=\"modules.php?name=$module_name&op=change_karma&user_id=".$userinfo['uid']."&karma=3\"><img src=\"$imgLink/karma/3.gif\" border=\"0\" alt=\""._KARMADEVIL."\" title=\""._KARMADEVIL."\" hspace=\"5\"></a>";
		$change_karma .= '</td><td>';
		$change_karma .= _KARMADEVILHLP."<br />"._KARMADEVILREF;
		$change_karma .= '</td></tr></table>';
		echo "<tr>";
		echo "<td valign=\"top\"><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><th align=\"left\" nowrap=\"nowrap\">"._USERKARMA."</th><td><img src=\"$imgLink/karma/".$userinfo['karma'].".gif\" border=\"0\" alt=\"$karma\" title=\"$karma\"></td></tr></table></td>";
		//OpenTable2();
		echo "<td>";
		echo "$change_karma</td>";
		echo "</tr></table>";
		//echo "</div>";
		echo "</fieldset>";
		/*
		 echo "<table border=\"0\" width=\"80%\" cellpadding=\"3\" cellspacing=\"3\" align=\"center\">";
		 echo "<tr><td valign=\"middle\"><img src=\"images/karma/0.gif\" border=\"0\" alt=\""._KARMAGOOD."\" title=\""._KARMAGOOD."\"></td><td>"._KARMAGOODREF."</td></tr>";
		 echo "<tr><td valign=\"middle\"><img src=\"images/karma/1.gif\" border=\"0\" alt=\""._KARMALOW."\" title=\""._KARMALOW."\"></td><td>"._KARMALOWREF."</td></tr>";
		 echo "<tr><td valign=\"middle\"><img src=\"images/karma/2.gif\" border=\"0\" alt=\""._KARMABAD."\" title=\""._KARMABAD."\"></td><td>"._KARMABADREF."</td></tr>";
		 echo "<tr><td valign=\"middle\"><img src=\"images/karma/3.gif\" border=\"0\" alt=\""._KARMADEVIL."\" title=\""._KARMADEVIL."\"></td><td>"._KARMADEVILREF."</td></tr></table>";
		 //CloseTable2(); */
	}
}
/**
 * Main call
 *
 */
function main($user,$force=0) {
	global $stop, $module_name, $redirect, $mode, $t, $f, $gfx_chk, $userhome;
	global $bypass,$hid,$url;
	if(!is_user($user)) {
		include("header.php");
		echo "<h1>"._USERIDENT."</h1>";
		if ($stop) {
			echo "<center><br /><br /><b>"._LOGININCOR."</b></center>";
		}
		else {
			echo "<center><br /><br /><b>"._USERREGLOGIN."</b></center>";
		}
		echo "<br /><br />";
		if (!is_user($user)) {
			//OpenTable();
			mt_srand ((double)microtime()*1000000);
			$maxran = 1000000;
			$random_num = mt_rand(0, $maxran);
			/* echo "<form action=\"modules.php?name=$module_name\" method=\"post\">\n"
			 ."<b>"._USERLOGIN."</b><br><br>\n"
			 ."<table border=\"0\"><tr><td>\n"
			 .""._NICKNAME.":</td><td><input type=\"text\" name=\"username\" size=\"15\" maxlength=\"25\"></td></tr>\n"
			 ."<tr><td>"._PASSWORD.":</td><td><input type=\"password\" name=\"user_password\" size=\"15\" maxlength=\"20\"></td></tr>\n";
			 if (extension_loaded("gd") AND ($gfx_chk == 2 OR $gfx_chk == 4 OR $gfx_chk == 5 OR $gfx_chk == 7)) {
				echo "<tr><td colspan='2'>"._SECURITYCODE.": <img src='?gfx=gfx&random_num=$random_num' border='1' alt='"._SECURITYCODE."' title='"._SECURITYCODE."'></td></tr>\n"
				."<tr><td colspan='2'>"._TYPESECCODE.": <input type=\"text\" NAME=\"gfx_check\" SIZE=\"7\" MAXLENGTH=\"6\"></td></tr>\n"
				."<input type=\"hidden\" name=\"random_num\" value=\"$random_num\">\n";
				}
				echo "</table><input type=\"hidden\" name=\"redirect\" value=\"$redirect\">\n"
				."<input type=\"hidden\" name=\"mode\" value=$mode>\n"
				."<input type=\"hidden\" name=\"f\" value=$f>\n"
				."<input type=\"hidden\" name=\"t\" value=$t>\n"
				."<input type=\"hidden\" name=\"op\" value=\"login\">\n"
				."<input type=\"submit\" value=\""._LOGIN."\"></form><br>\n\n"
				."<center><font class=\"content\">[ <a href=\"modules.php?name=$module_name&amp;op=pass_lost\">"._PASSWORDLOST."</a> | <a href=\"modules.php?name=$module_name&amp;op=new_user\">"._REGNEWUSER."</a> ]</font></center>\n";
					
				*/

			echo "<fieldset><legend>"._USERLOGIN."</legend>"
			."<form action=\"modules.php?name=$module_name\" method=\"post\">\n"
			."<center><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">"
			."<tr align=center><td valign=\"top\"><!--<img src=\"images/security.png\">--></td>"
			."<td>"
			."<table border=\"0\" cellpadding=\"0\" cellspacing=\"5\" class=\"ya_edituser\"> "
			."<tr><th>"._NICKNAME."</th>"
			."<td><input type=\"text\" NAME=\"username\" SIZE=\"20\" MAXLENGTH=\"20\"></td></tr>"
			."<tr><th>"._PASSWORD."</th>"
			."<td><input type=\"password\" NAME=\"user_password\" SIZE=\"20\" MAXLENGTH=\"18\"></td></tr>";
			if (extension_loaded("gd") && ($gfx_chk == 2 OR $gfx_chk == 4 OR $gfx_chk == 5 OR $gfx_chk == 7)) {
				echo "<tr><td colspan='2'>"._SECURITYCODE.": <img src='?gfx=gfx&random_num=$random_num' border='1' alt='"._SECURITYCODE."' title='"._SECURITYCODE."'></td></tr>\n"
				."<tr><td colspan='2'>"._TYPESECCODE.": <input type=\"text\" NAME=\"gfx_check\" SIZE=\"7\" MAXLENGTH=\"6\"></td></tr>\n"
				."<input type=\"hidden\" name=\"random_num\" value=\"$random_num\">\n";
			}
			echo "<tr><td align=\"center\">"
			."<input type=\"hidden\" name=\"redirect\" value=\"$redirect\">\n"
			."<input type=\"hidden\" name=\"mode\" value=$mode>\n"
			."<input type=\"hidden\" name=\"f\" value=$f>\n"
			."<input type=\"hidden\" name=\"t\" value=$t>\n"
			."<input type=\"hidden\" name=\"op\" value=\"login\">\n"
			."</td><td>"
			."<input type=\"submit\" value=\""._LOGIN."\"> "
			."</td></tr></table>"
			."</td></tr></table></center>"
			."</form>";
			echo "<br>\n<center>[ <a href=\"modules.php?name=$module_name&amp;op=pass_lost\">"._PASSWORDLOST."</a> | <a href=\"modules.php?name=$module_name&amp;op=new_user\">"._REGNEWUSER."</a> ]</center>\n";
			echo "</fieldset>";
			
			//CloseTable();
		}
		include("footer.php");
	}
	elseif (is_user($user)) {
		global $cookie;
		cookiedecode($user);
		if ($force){
			userinfo($cookie[1],$bypass,$hid,$url);
		}
		elseif ((isset($userhome)) && ($userhome!="default")){
			Header("Location: $userhome");
		}
		else {
			userinfo($cookie[1],$bypass,$hid,$url);
		}
	}
}

function new_user() {
	global $my_headlines, $module_name, $db, $gfx_chk, $user;
	global $bypass,$hid,$url;
	if (!is_user($user)) {
		mt_srand ((double)microtime()*1000000);
		$maxran = 1000000;
		$random_num = mt_rand(0, $maxran);
		include("header.php");
		echo "<h1>"._USERIDENT."</h1>";
		echo "<center><br /><br /><b>"._USERREGLOGIN."</b></center>\n";
		echo "<br /><br />\n";
		echo "<fieldset><legend>"._REGNEWUSER."</legend>";
		echo "<form action=\"modules.php?name=$module_name\" method=\"post\">\n"
		."<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"ya_edituser\">\n"
		."<tr><th nowrap=\"nowrap\">"._NICKNAME.":</th><td><input type=\"text\" name=\"username\" size=\"30\" maxlength=\"25\"></td></tr>\n"
		."<tr><th nowrap=\"nowrap\">"._EMAIL.":</th><td><input type=\"text\" name=\"user_email\" size=\"30\" maxlength=\"255\"></td></tr>\n"
		."<tr><th nowrap=\"nowrap\">"._PASSWORD.":</th><td><input type=\"password\" name=\"user_password\" size=\"11\" maxlength=\"40\"></td></tr>\n"
		."<tr><th nowrap=\"nowrap\">"._RETYPEPASSWORD.":</th><td><input type=\"password\" name=\"user_password2\" size=\"11\" maxlength=\"40\"></td></tr>"
		."<tr><td colspan=\"2\" style=\"padding-left: 0px;\">("._ALLREQUIRED." - "._BLANKFORAUTO.")</td></tr>\n";
		if (extension_loaded("gd") AND ($gfx_chk == 3 OR $gfx_chk == 4 OR $gfx_chk == 6 OR $gfx_chk == 7)) {
			echo "<tr><th nowrap=\"nowrap\">"._SECURITYCODE.":</th><td><img src='?gfx=gfx&random_num=$random_num' border='1' alt='"._SECURITYCODE."' title='"._SECURITYCODE."'></td></tr>\n"
			."<tr><th nowrap=\"nowrap\">"._TYPESECCODE.":</th><td><input type=\"text\" NAME=\"gfx_check\" SIZE=\"7\" MAXLENGTH=\"6\"></td></tr>\n"
			."<input type=\"hidden\" name=\"random_num\" value=\"$random_num\">\n";
		}
		echo "<tr><td></td><td>\n"
		."<input type=\"hidden\" name=\"op\" value=\"new user\">\n"
		."<input type=\"submit\" value=\""._NEWUSER."\">\n"
		."</td></tr></table>\n"
		."</form>\n"
		."<br>\n"
		.""._YOUWILLRECEIVE."<br><br>\n"
		.""._COOKIEWARNING."<br>\n"
		.""._ASREGUSER."<br>\n"
		."<ul>\n"
		."<li>"._ASREG1."</li>\n"
		."<li>"._ASREG2."</li>\n"
		."<li>"._ASREG3."</li>\n"
		."<li>"._ASREG4."</li>\n"
		."<li>"._ASREG5."</li>\n";
		$handle=opendir('themes');
		$thmcount = 0;
		while ($file = readdir($handle)) {
			if ((!preg_match("#[.]#",$file) AND file_exists("themes/$file/theme.php"))) {
				$thmcount++;
			}
		}
		closedir($handle);
		if ($thmcount > 1) {
			echo "<li>"._ASREG6."</li>\n";
		}
		$sql = "SELECT custom_title FROM ".$prefix."_modules WHERE active='1' AND view='1' AND inmenu='1'";
		$result = $db->sql_query($sql);
		while ($row = $db->sql_fetchrow($result)) {
			$custom_title = filter($row[custom_title], "nohtml");
			if (!empty($custom_title)) {
				echo "<li>"._ACCESSTO." $custom_title</li>\n";
			}
		}
		$sql = "SELECT title FROM ".$prefix."_blocks WHERE active='1' AND view='1'";
		$result = $db->sql_query($sql);
		while ($row = $db->sql_fetchrow($result)) {
			$b_title = filter($row[title], "nohtml");
			if (!empty($b_title)) {
				echo "<li>"._ACCESSTO." $b_title</li>\n";
			}
		}
		// if (is_active("Journal")) {
		//		echo "<li>"._CREATEJOURNAL."\n";
		//	}
		if ($my_headlines == 1) {
			echo "<li>"._READHEADLINES."</li>\n";
		}
		echo "<li>"._ASREG7."</li>\n"
		."</ul>\n"
		.""._REGISTERNOW."<br />\n"
		.""._WEDONTGIVE."<br />&nbsp;<br />&nbsp;<br />\n"
		."<center>[ <a href=\"modules.php?name=$module_name\">"._USERLOGIN."</a> | <a href=\"modules.php?name=$module_name&amp;op=pass_lost\">"._PASSWORDLOST."</a> ]</center>\n";
		echo "</fieldset>";
		include("footer.php");
	}
	elseif (is_user($user)) {
		global $cookie;
		cookiedecode($user);
		userinfo($cookie[1],$bypass,$hid,$url);
	}
}

function pass_lost() {
	global $user, $module_name;
	global $bypass,$hid,$url;
	if (!is_user($user)) {
		include("header.php");
		echo "<h1>"._USERIDENT."</h1>";
		echo "<center><br /><br /><b>"._USERREGLOGIN."</b></center>\n";
		echo "<br /><br />\n";
		echo "<fieldset><legend>"._PASSWORDLOST."</legend>"
		.""._NOPROBLEM."<br><br>\n"
		."<form action=\"modules.php?name=$module_name\" method=\"post\">\n"
		."<center>"
		."<table border=\"0\" cellpadding=\"0\" cellspacing=\"5\" class=\"ya_edituser\"><tr><th>\n"
		.""._NICKNAME.":</th><td><input type=\"text\" name=\"username\" size=\"15\" maxlength=\"25\"></td></tr>\n"
		."<tr><th>"._CONFIRMATIONCODE.":</th><td><input type=\"text\" name=\"code\" size=\"15\" maxlength=\"10\"></td></tr>"
		."<tr><td></td><td><input type=\"submit\" value=\""._SENDPASSWORD."\"></td></tr>"
		."</table><br>\n"
		."<input type=\"hidden\" name=\"op\" value=\"mailpasswd\">\n"
		."</center></form>\n"
		."<center>[ <a href=\"modules.php?name=$module_name\">"._USERLOGIN."</a> | <a href=\"modules.php?name=$module_name&amp;op=new_user\">"._REGNEWUSER."</a> ]</center>\n"
		."</fieldset>";
		include("footer.php");
	}
	elseif(is_user($user)) {
		global $cookie;
		cookiedecode($user);
		userinfo($cookie[1],$bypass,$hid,$url);
	}
}
/**
 * logout()
 * logout member
 */
function logout() {
	global $prefix, $db, $user, $cookie, $redirect;
	cookiedecode($user);
	$r_uid = $cookie[0];
	$r_username = $cookie[1];
	setcookie("user", false);
	$db->sql_query("DELETE FROM ".$prefix."_session WHERE username='$r_username'");
	$user = "";
	undocookie();
	include("header.php");
	if (!empty($redirect)) {
		echo "<META HTTP-EQUIV=\"refresh\" content=\"3;URL=modules.php?name=$redirect\">";
	} else {
		echo "<META HTTP-EQUIV=\"refresh\" content=\"3;URL=index.php\">";
	}
	echo "<h1>"._USERIDENT."</h1>";
	echo "<center><b>"._YOUARELOGGEDOUT."</b></center>";
	include("footer.php");
}

function mail_password($username, $code) {
	global $sitename, $adminmail, $nukeurl, $user_prefix, $db, $module_name;
	$username = filter($username, "nohtml", 1);
	$username = substr($username, 0, 25);
	$username = htmlspecialchars($username,ENT_QUOTES,'ISO-8859-1',true);
	$sql = "SELECT email, pass FROM ".$user_prefix."_users WHERE uname='$username'";
	$result = $db->sql_query($sql);
	include("header.php");
	echo "<h1>"._USERIDENT."</h1>";
	echo "<center><br /><br /><b>"._USERREGLOGIN."</b></center>\n";
	echo "<br /><br />";
	
	if($db->sql_numrows($result) == 0) {
		echo "<fieldset><legend>"._USERLOGIN."</legend>";
		echo "<center><b><br />"._SORRYNOUSERINFO."</b><br><br>"."<input type=\"button\" value=\""._BTNGOBACK."\" onclick=\"window.history.back()\">"."</center>";
		echo "</fieldset>";
	}
	else {
		$host_name = $_SERVER['REMOTE_ADDR'];
		$row = $db->sql_fetchrow($result);
		$user_email = filter($row['email'], "nohtml");
		$user_password = $row['pass'];
		$user_password = htmlspecialchars(stripslashes($user_password),ENT_QUOTES,'ISO-8859-1',true);
		$areyou = substr($user_password, 0, 10);
		if ($areyou==$code) {
			$newpass=makepass();
			$nukeurl = format_nuke_url($nukeurl);
			$message = ""._USERACCOUNT." '$username' "._AT." $sitename "._HASTHISEMAIL."  "._AWEBUSERFROM." $host_name "._HASREQUESTED."\n\n"._YOURNEWPASSWORD." $newpass\n\n "._YOUCANCHANGE." $nukeurl/modules.php?name=$module_name\n\n"._IFYOUDIDNOTASK."";
			$subject = ""._USERPASSWORD4." $username";
			mail($user_email, $subject, $message, "From: $adminmail\nX-Mailer: PHP/" . phpversion());
			/* Next step: add the new password to the database */
			$cryptpass = md5($newpass);
			$query = "UPDATE ".$user_prefix."_users SET pass='$cryptpass' WHERE uname='$username'";
			if (!$db->sql_query($query)) {
				echo ""._UPDATEFAILED."";
			}
			echo "<fieldset><legend>"._USERLOGIN."</legend>";
			echo "<center><b><br />"._PASSWORD4." $username "._MAILED."</b><br><br>"."<input type=\"button\" value=\""._BTNGOBACK."\" onclick=\"window.history.back()\">"."</center>";
			echo "</fieldset>";
//			echo $message;
			/* If no Code, send it */
		}
		else {
			$sql = "SELECT email, pass FROM ".$user_prefix."_users WHERE uname='$username'";
			$result = $db->sql_query($sql);
			if($db->sql_numrows($result) == 0) {
				echo "<fieldset><legend>"._USERLOGIN."</legend>";
				echo "<center><b><br />"._SORRYNOUSERINFO."</b><br><br>"."<input type=\"button\" value=\""._BTNGOBACK."\" onclick=\"window.history.back()\">"."</center>";
				echo "</fieldset>";
			}
			else {
				$host_name = $_SERVER['REMOTE_ADDR'];
				$row = $db->sql_fetchrow($result);
				$user_email = filter($row['email'], "nohtml");
				$user_password = $row['pass'];
				$areyou = substr($user_password, 0, 10);
				$nukeurl = format_nuke_url($nukeurl);
				$message = ""._USERACCOUNT." '$username' "._AT." $sitename "._HASTHISEMAIL." "._AWEBUSERFROM." $host_name "._CODEREQUESTED."\n\n"._YOURCODEIS." $areyou \n\n"._WITHTHISCODE." $nukeurl/modules.php?name=$module_name&op=pass_lost\n"._IFYOUDIDNOTASK2."";
				$subject=""._CODEFOR." $username";
				mail($user_email, $subject, $message, "From: $adminmail\nX-Mailer: PHP/" . phpversion());
				echo "<fieldset><legend>"._USERLOGIN."</legend>";
				echo "<center><b><br />"._CODEFOR." $username "._MAILED."</b><br><br>"."<input type=\"button\" value=\""._BTNGOBACK."\" onclick=\"window.history.back()\">"."</center>";
				echo "</fieldset>";
//				echo $message;
			}
		}
	}
	include ("footer.php");
}
/**
 * docookie
 *
 */
function docookie($setuid, $setusername, $setpass, $setstorynum, $setumode, $setuorder, $setthold, $setnoscore, $setublockon, $settheme, $setcommentmax) {
	$info = base64_encode("$setuid:$setusername:$setpass:$setstorynum:$setumode:$setuorder:$setthold:$setnoscore:$setublockon:$settheme:$setcommentmax");
	setcookie("user","$info",time()+2592000);
}
/**
 * TestCookie
 * remove cookie
 */
function undocookie(){
	setcookie ("user", "", time() - 3600);
}

function login($username, $user_password, $redirect, $mode, $f, $t, $random_num, $gfx_check) {
	global $setinfo, $user_prefix, $db, $module_name, $pm_login, $prefix;
	$user_password = htmlspecialchars(stripslashes($user_password),ENT_QUOTES,'ISO-8859-1',true);
	include("config.php");
	$sql = "SELECT pass, uid, storynum, umode, uorder, thold, noscore, ublockon, theme, commentmax FROM ".$user_prefix."_users WHERE uname='$username'";
	$result = $db->sql_query($sql);
	$setinfo = $db->sql_fetchrow($result);
	$forward = preg_replace("#redirect=#", "", "$redirect");
	if (preg_match("#privmsg#", $forward)) {
		$pm_login = "active";
	}
	if (($db->sql_numrows($result)==1) AND ($setinfo['uid'] != 1) AND (!empty($setinfo['pass']))) {
		$dbpass=$setinfo['pass'];
		$non_crypt_pass = $user_password;
		$old_crypt_pass = crypt($user_password,substr($dbpass,0,2));
		$new_pass = md5($user_password);
		if (($dbpass == $non_crypt_pass) OR ($dbpass == $old_crypt_pass)) {
			$db->sql_query("UPDATE ".$user_prefix."_users SET pass='$new_pass' WHERE uname='$username'");
			$sql = "SELECT pass FROM ".$user_prefix."_users WHERE uname='$username'";
			$result = $db->sql_query($sql);
			$row = $db->sql_fetchrow($result);
			$dbpass = $row['pass'];
		}
		if ($dbpass != $new_pass) {
			Header("Location: modules.php?name=$module_name&stop=1");
			return;
		}
		$datekey = date("F j");
		$rcode = hexdec(md5($_SERVER['HTTP_USER_AGENT'] . $sitekey . $random_num . $datekey));
		$code = substr($rcode, 2, 6);
		if (extension_loaded("gd") AND $code != $gfx_check AND ($gfx_chk == 2 OR $gfx_chk == 4 OR $gfx_chk == 5 OR $gfx_chk == 7)) {
			Header("Location: modules.php?name=$module_name&stop=1");
			die();
		}
		else {
			docookie($setinfo['uid'], $username, $new_pass, $setinfo['storynum'], $setinfo['umode'], $setinfo['uorder'], $setinfo['thold'], $setinfo['noscore'], $setinfo['ublockon'], $setinfo['theme'], $setinfo['commentmax']);
			$uname = $_SERVER['REMOTE_ADDR'];
			$db->sql_query("DELETE FROM ".$prefix."_session WHERE username='$uname' AND guest='1'");
			$db->sql_query("UPDATE ".$prefix."_users SET last_ip='$uname' WHERE uname='$username'");
		}
		if (!empty($pm_login)) {
			Header("Location: modules.php?name=Private_Messages&file=index&folder=inbox");
			exit;
		}
		if (empty($redirect)) {
		 if (($userhome!="default") && (isset($userhome))) {
		 	Header("Location: modules.php?name=Your_Account");
		 } else {
		 	Header("Location: modules.php?name=Your_Account&op=userinfo&bypass=1&username=$username");
		 }
		} else if (empty($mode)) {
			Header("Location: modules.php?name=Forums&file=$forward");
		} else if (!empty($t)) {
			Header("Location: modules.php?name=Forums&file=$forward&mode=$mode&t=$t");
		} else {
			Header("Location: modules.php?name=Forums&file=$forward&mode=$mode&f=$f");
		}
	} else {
		Header("Location: modules.php?name=$module_name&stop=1");
	}
}
/**
 * edituser()
 *
 */
function edituser() {
	global $prefix, $db, $user, $userinfo, $cookie, $module_name, $bgcolor2, $bgcolor3;
	cookiedecode($user);
	getusrinfo($user);
	if ((is_user($user)) AND (strtolower($userinfo['uname']) == strtolower($cookie[1])) AND ($userinfo['pass'] == $cookie[2])) {
		include("header.php");
		echo "<H1>"._PERSONALINFO."</H1>";
		$mycontent="<script type=\"text/javascript\"> var ol_width = 600;</script>";
		$mycontent.="<script language=\"JavaScript\" src=\"javascripts/overlib.js\"></script>";
		$mycontent.="<div id=\"overDiv\" style=\"position:absolute; visibility:hidden; z-index:1000;\"></div>";
		echo $mycontent;
		echo "<div class=\"ya_buttonBarDiv\">";
		themesidebox(_MENUTODO, nav(0, "valign"));
		echo "</div>";
		echo "<p>&nbsp;<br />&nbsp;<br />"._PUTYOURINFORMATIONS."</p>";

		if (!preg_match('#^http[s]?:\/\/#i', $userinfo['url'])) {
			$userinfo['url'] = "http://" . $userinfo['url'];
		}
		if (!preg_match('#^http[s]?\\:\\/\\/[a-z0-9\-]+\.([a-z0-9\-]+\.)?[a-z]+#i', $userinfo['url'])) {
			$userinfo['url'] = '';
		}
		if (!preg_match('/^[0-9]+$/', $userinfo['user_icq'])) {
			$userinfo['user_icq'] = "";
		}

		$dir = @opendir("modules/Forum/images/flags");
		$s_user_from = '<select name="user_from" class="saisieUser">';
		$s_user_from .= '<option value="">' . _LOCATIONNONE . '</option>';
		while( $file = @readdir($dir) ) {
			if( preg_match('/(\.gif$|\.png$|\.jpg|\.jpeg)$/is', $file) ) {
				$lepays = ucfirst(str_replace("_", " ", preg_replace('/^(.*)\..*$/', '\1', $file)));
				if ($file == $userinfo['user_from']) {
					$selected = " selected=\"selected\"";
				}
				else {
					$selected = "";
				}
				$s_user_from .= '<option value="' . $file . '"' . $selected . '>' . $lepays . '</option>';
			}
		}
		@closedir($dir);
		$s_user_from .= '</select>';

		//echo "<table class=ya_edituser_table>";
		echo "<form name=\"Register\" class=\"ya_edituser_form\" action=\"modules.php?name=$module_name\" method=\"post\">";
		echo "<fieldset class=\"ya_user_div\"><legend>"._INFORMATIONS."</legend>";
		echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"ya_edituser\">"
		."<tr><th>"._USRNICKNAME."</th><td><b>".$userinfo['uname']."</b></td></tr>"
		."<tr><th>"._UREALNAME." ".displayHelp(_UUSERNAME)."</th><td>"
		."<input type=\"text\" name=\"realname\" value=\"".$userinfo['name']."\" size=\"40\" maxlength=\"60\" class=\"saisieUser\"></td></tr>"
		."<tr><th>"._UREALEMAIL." ".displayHelp(_EMAILNOTPUBLIC)." "._REQUIRED."</th><td>"
		."<input type=\"text\" name=\"user_email\" value=\"".$userinfo['email']."\" size=\"40\" maxlength=\"255\" class=\"saisieUser\"></td></tr>"
		."<tr><th>"._UFAKEMAIL." ".displayHelp(_EMAILPUBLIC)."</th><td>"
		."<input type=\"text\" name=\"femail\" value=\"".$userinfo['femail']."\" size=\"40\" maxlength=\"255\" class=\"saisieUser\"></td></tr>"
		."<tr><th>"._YOURHOMEPAGE."</th><td>"
		."<input type=\"text\" name=\"user_website\" value=\"".$userinfo['url']."\" size=\"40\" maxlength=\"255\" class=\"saisieUser\">"."</td></tr>"
		."<tr><th>"._YICQ."</th><td>"
		."<input type=\"text\" name=\"user_icq\" value=\"".$userinfo['user_icq']."\" size=\"30\" maxlength=\"100\" class=\"saisieUser\">"."</td></tr>"
		."<tr><th>"._YAIM."</th><td>"
		."<input type=\"text\" name=\"user_aim\" value=\"".$userinfo['user_aim']."\" size=\"30\" maxlength=\"100\" class=\"saisieUser\">"."</td></tr>"
		."<tr><th>"._YYIM."</th><td>"
		."<input type=\"text\" name=\"user_yim\" value=\"".$userinfo['user_yim']."\" size=\"30\" maxlength=\"100\" class=\"saisieUser\">"."</td></tr>"
		."<tr><th>"._YMSNM."</th><td>"
		."<input type=\"text\" name=\"user_msnm\" value=\"".$userinfo['user_msnm']."\" size=\"30\" maxlength=\"100\" class=\"saisieUser\">"."</td></tr>"
		."<tr><th>"._YLOCATION."</th><td>"
		.$s_user_from."<!--<input type=\"text\" name=\"user_from\" value=\"".$userinfo['user_from']."\" size=\"30\" maxlength=\"100\" class=\"saisieUser\">-->"."</td></tr>"
		."<tr><th>"._YOCCUPATION."</th><td>"
		."<input type=\"text\" name=\"user_occ\" value=\"".$userinfo['user_occ']."\" size=\"30\" maxlength=\"100\" class=\"saisieUser\">"."</td></tr>"
		."<tr><th>"._YINTERESTS."</th><td>"
		."<input type=\"text\" name=\"user_interests\" value=\"".$userinfo['user_interests']."\" size=\"30\" maxlength=\"100\" class=\"saisieUser\">"."</td></tr>";
		echo "<tr><th>"._SIGNATURE." ".displayHelp(_255CHARMAX)."</th><td>"
		."<textarea wrap=\"virtual\" cols=\"40\" rows=\"5\" name=\"user_sig\" class=\"saisieUser\">".$userinfo['user_sig']."</textarea></td></tr>"
		."<tr><th>"._EXTRAINFO." ".displayHelp(_CANKNOWABOUT)."</th><td>"
		."<textarea wrap=\"virtual\" cols=\"40\" rows=\"5\" name=\"bio\" class=\"saisieUser\">".$userinfo['bio']."</textarea></td></tr>";
		echo "</table>";


		echo "&nbsp;<br />";
		echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"ya_edituser\">";
		echo "<tr><th>"._RECEIVENEWSLETTER."</th><td>";
		if ($userinfo['newsletter'] == 1) {
			echo "<input type=\"radio\" name=\"newsletter\" value=\"1\" checked>"._YES." &nbsp;"
			."<input type=\"radio\" name=\"newsletter\" value=\"0\">"._NO."";
		} elseif ($userinfo['newsletter'] == 0) {
			echo "<input type=\"radio\" name=\"newsletter\" value=\"1\">"._YES." &nbsp;"
			."<input type=\"radio\" name=\"newsletter\" value=\"0\" checked>"._NO."";
		}
		echo "</td></tr>";

		echo "<tr><th>"._ALWAYSSHOWEMAIL."</th><td>";
		if ($userinfo['user_viewemail'] == 1) {
			echo "<input type=\"radio\" name=\"user_viewemail\" value=\"1\" checked>"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_viewemail\" value=\"0\">"._NO."";
		} elseif ($userinfo['user_viewemail'] == 0) {
			echo "<input type=\"radio\" name=\"user_viewemail\" value=\"1\">"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_viewemail\" value=\"0\" checked>"._NO."";
		}
		echo "</td></tr>";

		echo "<tr><th>"._HIDEONLINE."</th><td>";
		if ($userinfo['user_allow_viewonline'] == 1) {
			echo "<input type=\"radio\" name=\"user_allow_viewonline\" value=\"0\">"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_allow_viewonline\" value=\"1\" checked>"._NO."";
		} elseif ($userinfo['user_allow_viewonline'] == 0) {
			echo "<input type=\"radio\" name=\"user_allow_viewonline\" value=\"0\" checked>"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_allow_viewonline\" value=\"1\">"._NO."";
		}
		echo "</td></tr>";

		echo "<tr><th>"._REPLYNOTIFY." ".displayHelp(_REPLYNOTIFYMSG)."</th><td>";
		if ($userinfo['user_notify'] == 1) {
			echo "<input type=\"radio\" name=\"user_notify\" value=\"1\" checked>"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_notify\" value=\"0\">"._NO."";
		} elseif ($userinfo['user_notify'] == 0) {
			echo "<input type=\"radio\" name=\"user_notify\" value=\"1\">"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_notify\" value=\"0\" checked>"._NO."";
		}
		echo "</td></tr>";

		echo "<tr><th>"._PMNOTIFY."</th><td>";
		if ($userinfo['user_notify_pm'] == 1) {
			echo "<input type=\"radio\" name=\"user_notify_pm\" value=\"1\" checked>"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_notify_pm\" value=\"0\">"._NO."";
		} elseif ($userinfo['user_notify_pm'] == 0) {
			echo "<input type=\"radio\" name=\"user_notify_pm\" value=\"1\">"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_notify_pm\" value=\"0\" checked>"._NO."";
		}
		echo "</td></tr>";

		echo "<tr><th>"._POPPM." ".displayHelp(_POPPMMSG)."</th><td>";
		if ($userinfo['user_popup_pm'] == 1) {
			echo "<input type=\"radio\" name=\"user_popup_pm\" value=\"1\" checked>"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_popup_pm\" value=\"0\">"._NO."";
		} elseif ($userinfo['user_popup_pm'] == 0) {
			echo "<input type=\"radio\" name=\"user_popup_pm\" value=\"1\">"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_popup_pm\" value=\"0\" checked>"._NO."";
		}
		echo "</td></tr>";

		echo "<tr><th>"._ATTACHSIG."</th><td>";
		if ($userinfo['user_attachsig'] == 1) {
			echo "<input type=\"radio\" name=\"user_attachsig\" value=\"1\" checked>"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_attachsig\" value=\"0\">"._NO."";
		} elseif ($userinfo['user_attachsig'] == 0) {
			echo "<input type=\"radio\" name=\"user_attachsig\" value=\"1\">"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_attachsig\" value=\"0\" checked>"._NO."";
		}
		echo "</td></tr>";

		echo "<tr><th>"._ALLOWBBCODE."</th><td>";
		if ($userinfo['user_allowbbcode'] == 1) {
			echo "<input type=\"radio\" name=\"user_allowbbcode\" value=\"1\" checked>"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_allowbbcode\" value=\"0\">"._NO."";
		} elseif ($userinfo['user_allowbbcode'] == 0) {
			echo "<input type=\"radio\" name=\"user_allowbbcode\" value=\"1\">"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_allowbbcode\" value=\"0\" checked>"._NO."";
		}
		echo "</td></tr>";

		echo "<tr><th>"._ALLOWHTMLCODE."</th><td>";
		if ($userinfo['user_allowhtml'] == 1) {
			echo "<input type=\"radio\" name=\"user_allowhtml\" value=\"1\" checked>"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_allowhtml\" value=\"0\">"._NO."";
		} elseif ($userinfo['user_allowhtml'] == 0) {
			echo "<input type=\"radio\" name=\"user_allowhtml\" value=\"1\">"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_allowhtml\" value=\"0\" checked>"._NO."";
		}
		echo "</td><tr>";

		echo "<tr><th>"._ALLOWSMILIES."</th><td";
		if ($userinfo['user_allowsmile'] == 1) {
			echo "<input type=\"radio\" name=\"user_allowsmile\" value=\"1\" checked>"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_allowsmile\" value=\"0\">"._NO."";
		} elseif ($userinfo['user_allowsmile'] == 0) {
			echo "<input type=\"radio\" name=\"user_allowsmile\" value=\"1\">"._YES." &nbsp;"
			."<input type=\"radio\" name=\"user_allowsmile\" value=\"0\" checked>"._NO."";
		}
		echo "</td></tr>";


		echo "<tr><th>"._FORUMSTIME."</th><td>";
		echo "<select name='user_timezone'>";
		for ($i=-12; $i<13; $i++) {
			if ($i == 0) {
				$dummy = "GMT";
			} else {
				if (!preg_match("#-#", $i)) {
					$i = "+$i";
				}
				$dummy = "GMT $i "._HOURS."";
			}
			if ($userinfo['user_timezone'] == $i) {
				echo "<option name=\"user_timezone\" value=\"$i\" selected>$dummy</option>";
			} else {
				echo "<option name=\"user_timezone\" value=\"$i\">$dummy</option>";
			}

		}
		echo "</select>";
		echo "</td>";
		echo "</tr><tr>";
		echo "<th>"._FORUMSDATE." ".displayHelp(_FORUMSDATEMSG)."</th><td>";
		echo "<input size='15' maxlength='14' type=\"text\" name=\"user_dateformat\" value=\"".$userinfo['user_dateformat']."\">";
		echo "</td></tr>";
		echo "</table>";

		echo "&nbsp;<br />";

		echo "<center><b>"._PASSWORD." "._TYPENEWPASSWORD."</b><br /><br />"
		."<input type=\"password\" name=\"user_password\" size=\"22\" maxlength=\"20\">&nbsp;&nbsp;<input type=\"password\" name=\"vpass\" size=\"22\" maxlength=\"20\">"
		."<input type=\"hidden\" name=\"username\" value=\"".$userinfo['uname']."\">"
		."<input type=\"hidden\" name=\"user_id\" value=\"".intval($userinfo['uid'])."\">"
		."<input type=\"hidden\" name=\"op\" value=\"saveuser\">"
		."<br /><br /><input class=button type=\"submit\" value=\""._SAVECHANGES."\"></center>";
		echo "</fieldset></form>";
		include("footer.php");
	} else {
		//main($user);
	}
}


/**
 * editAvatar()
 *
 */
function editAvatar(){
	global $prefix, $db, $user, $userinfo, $cookie, $module_name, $bgcolor2, $bgcolor3;
	cookiedecode($user);
	getusrinfo($user);
	if ((is_user($user)) AND (strtolower($userinfo['uname']) == strtolower($cookie[1])) AND ($userinfo['pass'] == $cookie[2])) {
		$mycontent.="<div id=\"overDiv\" style=\"position:absolute; visibility:hidden; z-index:1000;\"></div>";
		include("header.php");
		echo "<h1>"._PERSONALINFO."</h1>";
		$mycontent="<script type=\"text/javascript\"> var ol_width = 600;</script>";
		$mycontent.="<script language=\"JavaScript\" src=\"javascripts/overlib.js\"></script>\n";
		echo $mycontent;
		echo "<div class=\"ya_buttonBarDiv\">";
		themesidebox(_MENUTODO, nav(0, "valign"));
		echo "</div>";


		$avatar_category = ( !empty($HTTP_POST_VARS['avatarcategory']) ) ? $HTTP_POST_VARS['avatarcategory'] : '';
		$direktori = "modules/Forum/images/avatar";
		$board_config['allow_avatar_local']=true;
		$board_config['allow_avatar_remote']=true;
		$board_config['avatar_path']=$direktori;
		$board_config['avatar_gallery_path']=$direktori;
		$board_config['avatar_max_width'] = 50;
		$board_config['avatar_max_height'] = 50;
		$board_config['avatar_filesize'] = 5000;
		$dir = @opendir($direktori);
		$avatar_images = array();
		while( $file = @readdir($dir) ) {
			if( substr($file,0,1) != "!" && substr($file,0,1) != "_" && $file != '.' && $file != '..' && !is_file($direktori . '/' . $file) && !is_link($direktori . '/' . $file) )
			{
				$sub_dir = @opendir($direktori . '/' . $file);
				$avatar_row_count = 0;
				$avatar_col_count = 0;
				while( $sub_file = @readdir($sub_dir) )
				{
					if( preg_match('/(\.gif$|\.png$|\.jpg|\.jpeg)$/is', $sub_file) ) {
						$avatar_images[$file][$avatar_row_count][$avatar_col_count] = $file . '/' . $sub_file;
						$avatar_name[$file][$avatar_row_count][$avatar_col_count] = ucfirst(str_replace("_", " ", preg_replace('/^(.*)\..*$/', '\1', $sub_file)));
						$avatar_col_count++;
						if( $avatar_col_count == 5 )
						{
							$avatar_row_count++;
							$avatar_col_count = 0;
						}
					}
				}
			}
		}
		@closedir($dir);
		@ksort($avatar_images);
		@reset($avatar_images);
		if( empty($category) ){
			list($category, ) = each($avatar_images);
		}
		@reset($avatar_images);
		$s_categories = '<select name="avatarcategory">';
		while( list($key) = each($avatar_images) )
		{
			$selected = ( $key == $category ) ? ' selected="selected"' : '';
			if( count($avatar_images[$key]) )
			{
				$s_categories .= '<option value="' . $key . '"' . $selected . '>' . ucfirst($key) . '</option>';
			}
		}
		$s_categories .= '</select>';

		if ($userinfo['user_avatar_type'] == 1) {
			$userinfo['user_avatar'] = $board_config['avatar_path']."/".$userinfo['user_avatar'];
		}
		elseif ($userinfo['user_avatar_type'] == 2) {
			$userinfo['user_avatar'] = $userinfo['user_avatar'];
		}
		else {
			$userinfo['user_avatar'] = $board_config['avatar_gallery_path']."/".$userinfo['user_avatar'];
		}
		//echo "<table class=\"ya_edituser_table\">";
		echo "<fieldset class=\"ya_user_div\"><legend>"._YOURAVATAR."</legend>";
		//$curAv="Displays a small graphic image below your details in forum posts and on your profile. Only one image can be displayed at a time, its width can be no greater than ".$board_config['avatar_max_width']." pixels, the height no greater than ".$board_config['avatar_max_height']." pixels, and the file size no more than ".CoolSize($board_config['avatar_filesize']);
		$curAv = str_replace("<!--avatar_max_width-->",$board_config['avatar_max_width'],str_replace("<!--avatar_max_height-->",$board_config['avatar_max_height'], str_replace("<!--avatar_filesize-->",CoolSize($board_config['avatar_filesize']),_AVATARDEF)));
		echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"ya_edituser\" width=\"100%\">";
		echo "<tr>"
		."<td class=\"ya_img_td\" width=\"10\" style=\"padding: 0px;\"><img src=\"".$userinfo['user_avatar']."\"></td><td width=\"10\" style=\"padding-right: 5px; padding-left: 5px;\">".displayHelp($curAv)."</td>";

		echo "<th><center>";
		if ($board_config['allow_avatar_local']) {
			echo "<form class=\"ya_edituser_form\" action=\"modules.php?name=Your_Account&op=avatarlist\" method=\"post\">"
			._SELECTAVATAR
			." ".$s_categories
			."<br /><br />"
			."<INPUT type=submit value=\""._SHOWGALLERY."\">"
			."</form>";
		}
		else {
			echo ""._SELECTAVATAR."<br />"
			.""._AVATARDESABLE."";
		}
		echo "<br /><br />";
		if ($board_config['allow_avatar_remote']) {
			//$avatarTxt="Enter the URL of the location containing the Avatar image you wish to link to and click on the submit button below";
			$avatarTxt=_AVATAREXTHELP;
			echo "<form class=\"ya_edituser_form\" action=\"modules.php?name=Your_Account&op=avatarlinksave\" method=\"post\">"
			._OFFSITEAVATER
			." <INPUT type=text size=30 maxlength=\"100\" name=avatar>".displayHelp($avatarTxt)." "
			."<br /><br/>"
			."<INPUT type=submit value=\""._GETAVATAR."\">"
			."</form>";
		}
		else {
			echo _AVATAREXTHELP."<br />"
			._CURENTLYDISABLED;
		}
		echo "</center></th></tr>";

		echo "</table";
		echo "</fieldset>";
		include("footer.php");
	}

}
/**
 * saveuser()
 * Save user personnal informations
 */
function saveuser($realname, $user_email, $femail, $user_website, $user_icq, $user_aim, $user_yim, $user_msnm, $user_from, $user_occ, $user_interests, $newsletter, $user_viewemail, $user_allow_viewonline, $user_notify, $user_notify_pm, $user_popup_pm, $user_attachsig, $user_allowbbcode, $user_allowhtml, $user_allowsmile, $user_timezone, $user_dateformat, $user_sig, $bio, $user_password, $vpass, $username, $user_id) {
	global $user, $cookie, $userinfo, $EditedMessage, $user_prefix, $db, $module_name, $minpass;
	$user_password = htmlspecialchars(stripslashes($user_password),ENT_QUOTES,'ISO-8859-1',true);
	cookiedecode($user);
	$check = $cookie[1];
	$check = filter($check, "nohtml", 1);
	$check2 = $cookie[2];
	$sql = "SELECT uid, pass FROM ".$user_prefix."_users WHERE uname='$check'";
	$result = $db->sql_query($sql);
	$row = $db->sql_fetchrow($result);
	$vuid = intval($row['uid']);
	$ccpass = filter($row['pass'], "nohtml", 1);
	$ccpass = htmlspecialchars(stripslashes($ccpass),ENT_QUOTES,'ISO-8859-1',true);
	$user_sig = filter($user_sig, "", 1);
	$user_email = filter($user_email, "nohtml", 1);
	$femail = filter($femail, "nohtml", 1);
	$user_website = filter($user_website, "nohtml", 1);
	$bio = filter($bio, "", 1);
	$user_icq = filter($user_icq, "nohtml", 1);
	$user_aim = filter($user_aim, "nohtml", 1);
	$user_yim = filter($user_yim, "nohtml", 1);
	$user_msnm = filter($user_msnm, "nohtml", 1);
	$user_occ = filter($user_occ, "nohtml", 1);
	$user_from = filter($user_from, "nohtml", 1);
	$user_interests = filter($user_interests, "nohtml", 1);
	$realname = filter($realname, "nohtml", 1);
	$user_avatar = "$user_avatar";
	if (($user_id == $vuid) AND ($check2 == $ccpass)) {
		if (!preg_match('#^http[s]?:\/\/#i', $user_website)) {
			$user_website = "http://" . $user_website;
		}
		if (!preg_match('#^http[s]?\\:\\/\\/[a-z0-9\-]+\.([a-z0-9\-]+\.)?[a-z]+#i', $user_website)) {
			$user_website = '';
		}
		if ((isset($user_password)) && ("$user_password" != "$vpass")) {
			echo "<center>"._PASSDIFFERENT."</center>";
		}
		elseif ((!empty($user_password)) && (strlen($user_password) < $minpass)) {
			echo "<center>"._YOUPASSMUSTBE." <b>$minpass</b> "._CHARLONG."</center>";
		}
		else {
			if ($bio) {
				filter_text($bio);
				$bio = $EditedMessage;
				$bio = FixQuotes($bio);
			}
			if (!empty($user_password)) {
				cookiedecode($user);
				$db->sql_query("LOCK TABLES ".$user_prefix."_users WRITE");
				$user_password = md5($user_password);
				$newsletter = intval($newsletter);
				$user_allow_viewonline = intval($user_allow_viewonline);
				$user_notify = intval($user_notify);
				$user_notify_pm = intval($user_notify_pm);
				$user_popup_pm = intval($user_popup_pm);
				$user_allowbbcode = intval($user_allowbbcode);
				$user_allowhtml = intval($user_allowhtml);
				$user_allowsmile = intval($user_allowsmile);
				$user_id = intval($user_id);
				$result=$db->sql_query("UPDATE ".$user_prefix."_users SET name='$realname', email='$user_email', femail='$femail', url='$user_website', pass='$user_password', bio='$bio', user_icq='$user_icq', user_occ='$user_occ', user_from='$user_from', user_interests='$user_interests', user_sig='$user_sig', user_aim='$user_aim', user_yim='$user_yim', user_msnm='$user_msnm', newsletter='$newsletter', user_viewemail='$user_viewemail', user_allow_viewonline='$user_allow_viewonline', user_notify='$user_notify', user_notify_pm='$user_notify_pm', user_popup_pm='$user_popup_pm', user_attachsig='$user_attachsig', user_allowbbcode='$user_allowbbcode', user_allowhtml='$user_allowhtml', user_allowsmile='$user_allowsmile', user_timezone='$user_timezone', user_dateformat='$user_dateformat' WHERE uid='$user_id'");
				if (!$result) {
					$error=$db->sql_error();
					die('Invalid query: saveuser() [1] :'.$error['message']);
				}

				$sql = "SELECT uid, uname, pass, storynum, umode, uorder, thold, noscore, ublockon, theme FROM ".$user_prefix."_users WHERE uname='$username' AND pass='$user_password'";
				$result = $db->sql_query($sql);
				if (!$result) {
					$error=$db->sql_error();
					die('Invalid query: saveuser() [2]:'.$error['message']);
				}
				if ($db->sql_numrows($result) == 1) {
					$userinfo = $db->sql_fetchrow($result);
					docookie($userinfo['uid'],$userinfo['uname'],$userinfo['pass'],$userinfo['storynum'],$userinfo['umode'],$userinfo['uorder'],$userinfo['thold'],$userinfo['noscore'],$userinfo['ublockon'],$userinfo['theme'],$userinfo['commentmax']); 
				}
				else {
					echo "<center>"._SOMETHINGWRONG."</center><br>";
				}
				$db->sql_query("UNLOCK TABLES");
			}
			else {
				$result=$db->sql_query("UPDATE ".$user_prefix."_users SET name='$realname', email='$user_email', femail='$femail', url='$user_website', bio='$bio', user_icq='$user_icq', user_occ='$user_occ', user_from='$user_from', user_interests='$user_interests', user_sig='$user_sig', user_aim='$user_aim', user_yim='$user_yim', user_msnm='$user_msnm', newsletter='$newsletter', user_viewemail='$user_viewemail', user_allow_viewonline='$user_allow_viewonline', user_notify='$user_notify', user_notify_pm='$user_notify_pm', user_popup_pm='$user_popup_pm', user_attachsig='$user_attachsig', user_allowbbcode='$user_allowbbcode', user_allowhtml='$user_allowhtml', user_allowsmile='$user_allowsmile', user_timezone='$user_timezone', user_dateformat='$user_dateformat' WHERE uid='$user_id'");
				if (!$result) {
					$error=$db->sql_error();
					die('Invalid query: saveuser() [3]:'.$error['message']);
				}
			}
			Header("Location: modules.php?name=$module_name");
		}
	}
}
/**
 * edithome()
 * Edit home page
 *
 */
function edithome() {
	global $user, $userinfo, $Default_Theme, $cookie, $broadcast_msg, $user_news, $storyhome, $module_name;
	cookiedecode($user);
	getusrinfo($user);
	if ((is_user($user)) AND (strtolower($userinfo['uname']) == strtolower($cookie[1])) AND ($userinfo['pass'] == $cookie[2])) {
		include ("header.php");
		echo "<H1>"._HOMECONFIG."</H1>";
		echo "<div class=\"ya_buttonBarDiv\">";
		themesidebox(_MENUTODO, nav(0, "valign"));
		echo "</div>";
		echo "<p>&nbsp;<br />&nbsp;<br />"._CONFYOURHOMEPAGE."</p>";
		if(empty($userinfo['theme'])) {
			$userinfo['theme'] = $Default_Theme;
		}
		echo "<fieldset class=\"ya_user_div\"><legend>"._INFORMATIONS."</legend>";
		echo "<form action=\"modules.php?name=$module_name\" method=\"post\"><center>";
		if ($user_news == 1) {
			echo "<b>"._NEWSINHOME."</b> "._MAX127." "
			."<input type=\"text\" name=\"storynum\" size=\"4\" maxlength=\"3\" value=\"".$userinfo['storynum']."\">"
			."<br><br>";
		}
		else {
			echo "<input type=\"hidden\" name=\"storynum\" value=\"$storyhome\">";
		}
		if ($userinfo['ublockon']==1) {
			$sel = "checked";
		}
		if ($broadcast_msg == 1) {
			if ($userinfo['broadcast'] == 1) {
				$sel1 = "checked=\"checked\"";
				$sel2 = "";
			}
			elseif ($userinfo['broadcast'] == 0) {
				$sel1 = "";
				$sel2 = "checked=\"checked\"";
			}
			echo "<b>"._MESSAGEACTIVATE."</b> <input type=\"radio\" name=\"broadcast\" value=\"1\" $sel1>"._YES." &nbsp;&nbsp;<input type=\"radio\" name=\"broadcast\" value=\"0\" $sel2>"._NO."<br /><br />";
		}
		else {
			echo "<input type=\"hidden\" name=\"broadcast\" value=\"1\">";
		}
		echo "<b>"._ACTIVATEPERSONAL."</b>"." <input type=\"checkbox\" name=\"ublockon\" $sel>"
		."<br>"._CHECKTHISOPTION.""
		."<br>"._YOUCANUSEHTML."<br>"
		."<textarea cols=\"55\" rows=\"10\" name=\"ublock\" class=\"saisieUser\">".$userinfo['ublock']."</textarea>"
		."<br><br>"
		."<input type=\"hidden\" name=\"username\" value=\"".$userinfo['uname']."\">"
		."<input type=\"hidden\" name=\"user_id\" value=\"".intval($userinfo['uid'])."\">"
		."<input type=\"hidden\" name=\"op\" value=\"savehome\">"
		."<input type=\"submit\" value=\""._SAVECHANGES."\">"
		."</center></form>";
		echo "</fieldset>";
		include ("footer.php");
	}
	else {
		main($user);
	}
}
/**
 * chgtheme()
 * Change user theme (if allowed)
 */
function chgtheme() {
	global $user, $userinfo, $Default_Theme, $cookie, $module_name;
	cookiedecode($user);
	getusrinfo($user);
	if ((is_user($user)) AND (strtolower($userinfo['uname']) == strtolower($cookie[1])) AND ($userinfo['pass'] == $cookie[2])) {
		include ("header.php");
		nav(0,"valign");
		echo "<center><font class=\"title\"><b>"._THEMESELECTION."</b></font></center>";

		echo "<br>";
		OpenTable();
		echo "<center>"
		."<form action=\"modules.php?name=$module_name\" method=\"post\">"
		."<b>"._SELECTTHEME."</b><br>"
		."<select name=\"theme\">";
		$handle=opendir('themes');
		while ($file = readdir($handle)) {
			if ( (!preg_match("#[.]#",$file) AND file_exists("themes/".$file."/theme.php")) ) {
				$themelist .= "$file ";
			}
		}
		closedir($handle);
		$themelist = explode(" ", $themelist);
		sort($themelist);
		for ($i=0; $i < sizeof($themelist); $i++) {
			if(!empty($themelist[$i])) {
				echo "<option value=\"$themelist[$i]\" ";
				if(((empty($userinfo['theme'])) && ($themelist[$i]==$Default_Theme)) || ($userinfo['theme']==$themelist[$i])) echo "selected";
				echo ">$themelist[$i]\n";
			}
		}
		if(empty($userinfo['theme'])) $userinfo['theme'] = $Default_Theme;
		echo "</select><br>"
		.""._THEMETEXT1."<br>"
		.""._THEMETEXT2."<br>"
		.""._THEMETEXT3."<br><br>"
		."<input type=\"hidden\" name=\"user_id\" value=\"".$userinfo['uid']."\">"
		."<input type=\"hidden\" name=\"op\" value=\"savetheme\">"
		."<input type=\"submit\" value=\""._SAVECHANGES."\">"
		."</form>";
		CloseTable();
		include ("footer.php");
	} else {
		main($user);
	}
}


function savehome($user_id, $username, $storynum, $ublockon, $ublock, $broadcast) {
	global $user, $cookie, $userinfo, $user_prefix, $db, $module_name;
	cookiedecode($user);
	$check = $cookie[1];
	$check = filter($check, "nohtml", 1);
	$check2 = $cookie[2];
	$sql = "SELECT uid, pass FROM ".$user_prefix."_users WHERE uname='$check'";
	$result = $db->sql_query($sql);
	$row = $db->sql_fetchrow($result);
	$vuid = intval($row['uid']);
	$ccpass = $row['pass'];
	if (($user_id == $vuid) && ($check2 == $ccpass)) {
		if(isset($ublockon)) {
			$ublockon=1;
		}
		else {
			$ublockon=0;
		}
		$ublock = FixQuotes($ublock);
		$db->sql_query("UPDATE ".$user_prefix."_users SET storynum='$storynum', ublockon='$ublockon', ublock='$ublock', broadcast='$broadcast' WHERE uid='$user_id'");
		getusrinfo($user);
		docookie($userinfo['uid'],$userinfo['uname'],$userinfo['pass'],$userinfo['storynum'],$userinfo['umode'],$userinfo['uorder'],$userinfo['thold'],$userinfo['noscore'],$userinfo['ublockon'],$userinfo['theme'],$userinfo['commentmax']);
		Header("Location: modules.php?name=$module_name");
	}
}

function savetheme($user_id, $theme) {
	global $user, $cookie, $userinfo, $user_prefix, $db, $module_name;
	cookiedecode($user);
	$user_id = intval($user_id);
	$check = $cookie[1];
	$check = filter($check, "nohtml", 1);
	$check2 = $cookie[2];
	$theme_error = "";
	$sql = "SELECT uid, pass FROM ".$user_prefix."_users WHERE uname='$check'";
	$result = $db->sql_query($sql);
	$row = $db->sql_fetchrow($result);
	$vuid = intval($row['uid']);
	$ccpass = filter($row['pass'], "nohtml", 1);
	if (($user_id == $vuid) AND ($check2 == $ccpass)) {
		$db->sql_query("UPDATE ".$user_prefix."_users SET user_style='$theme_id' WHERE uid='$user_id'");
		$db->sql_query("UPDATE ".$user_prefix."_users SET theme='$theme' WHERE uid='$user_id'");
		getusrinfo($user);
		docookie($userinfo['user_id'],$userinfo['username'],$userinfo['user_password'],$userinfo['storynum'],$userinfo['umode'],$userinfo['uorder'],$userinfo['thold'],$userinfo['noscore'],$userinfo['ublockon'],$userinfo['theme'],$userinfo['commentmax']);
		Header("Location: modules.php?name=$module_name&theme=$theme");
	}
}

function editcomm() {
	global $user, $userinfo, $cookie, $module_name;
	cookiedecode($user);
	getusrinfo($user);
	if ((is_user($user)) AND (strtolower($userinfo['uname']) == strtolower($cookie[1])) AND ($userinfo['pass'] == $cookie[2])) {
		include ("header.php");
		echo "<h1>"._COMMENTSCONFIG."</h1>";
		echo "<div class=\"ya_buttonBarDiv\">";
		themesidebox(_MENUTODO, nav(0, "valign"));
		echo "</div>";
		echo "<p>&nbsp;<br />&nbsp;<br />"._USERPREFCOMMENTS."</P>";
		
		$sel_umode = "<select name=\"umode\"><option value=\"nocomments\"";
		if ($userinfo['umode'] == 'nocomments') {
			$sel_umode .= " selected=\"selected\"";
		}
		$sel_umode .= ">"._NOCOMMENTS."</option>";
		$sel_umode .= "<option value=\"nested\"";
		if ($userinfo['umode'] == 'nested') {
			$sel_umode .=  " selected=\"selected\"";
		}
		$sel_umode .= ">"._NESTED."</option>";
		$sel_umode .= "<option value=\"flat\"";
		if ($userinfo['umode'] == 'flat') {
			$sel_umode .= " selected=\"selected\"";
		}
		$sel_umode .= ">"._FLAT."</option>";
		$sel_umode .= "<option value=\"thread\"";
		if (!isset($userinfo['umode']) || (empty($userinfo['umode'])) || $userinfo['umode']=='thread') {
			$sel_umode .= " selected=\"selected\"";
		}
		$sel_umode .= ">"._THREAD."</option>";
		$sel_umode .= "</select>";
		
		$sel_uorder = "<select name=\"uorder\">";
		$sel_uorder .= "<option value=\"0\"";
		if (!$userinfo['uorder']) {
			$sel_uorder .= " selected=\"selected\"";
		}
		$sel_uorder .= ">"._OLDEST."</option>";
		$sel_uorder .= "<option value=\"1\"";
		if ($userinfo['uorder']==1) {
			$sel_uorder .= " selected=\"selected\"";
		}
		$sel_uorder .= ">"._NEWEST."</option>";
		$sel_uorder .= "<option value=\"2\"";
		if ($userinfo['uorder']==2) {
			$sel_uorder .= " selected=\"selected\"";
		}
		$sel_uorder .= ">"._HIGHEST."</option>";
		$sel_uorder .= "</select>";
		
		$sel_thold = "<select name=\"thold\">";
		$sel_thold .= "<option value=\"-1\"";
		if ($userinfo['thold']==-1) {
			$sel_thold .= " selected=\"selected\"";
		}
		$sel_thold .= ">-1: "._UNCUT."</option>";	
		$sel_thold .= "<option value=\"0\"";
		if ($userinfo['thold']==0) {
			$sel_thold .=" selected=\"selected\"";
		}
		$sel_thold .= ">0: "._EVERYTHING."</option>";
		$sel_thold .= "<option value=\"1\"";
		if ($userinfo['thold']==1) {
			$sel_thold .= " selected=\"selected\"";
		}
		$sel_thold .= ">1: "._FILTERMOSTANON."</option>";
		$sel_thold .= "<option value=\"2\"";
		if ($userinfo['thold']==2) {
			$sel_thold .= " selected=\"selected\"";
		}
		$sel_thold .= ">2: "._USCORE." +2</option>";
		$sel_thold .= "<option value=\"3\"";
		if ($userinfo['thold']==3) {
			$sel_thold .= " selected=\"selected\"";
		}
		$sel_thold .= ">3: "._USCORE." +3</option>";
		$sel_thold .= "<option value=\"4\"";
		if ($userinfo['thold']==4) {
			$sel_thold .= " selected=\"selected\"";
		}
		$sel_thold .= ">4: "._USCORE." +4</option>";
		$sel_thold .= "<option value=\"5\"";
		if ($userinfo['thold']==5) {
			$sel_thold .= " selected=\"selected\"";
		}
		$sel_thold .= ">5: "._USCORE." +5</option>";
		$sel_thold .= "</select>";
		
		$check_score = "<INPUT type=\"checkbox\" name=\"noscore\" id=\"check_1\"";
		if ($userinfo['noscore']==1) {
			$check_score .= " checked=\"checked\"";
		}
		$check_score .= ">";
		
		$text_length = "<input type=\"text\" name=\"commentmax\" value=\"".intval($userinfo['commentmax'])."\" size=\"11\" maxlength=\"11\"> ";
		
		echo "<form action=\"modules.php?name=$module_name\" method=\"post\">";
		echo "<fieldset class=\"ya_user_div\"><legend>"._USERPREFS."</legend>";
		echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"ya_edituser\">";
		echo "<tr><th nowrap=\"nowrap\">"._DISPLAYMODE."</th><td>".$sel_umode."</td></tr>";
		echo "<tr><th nowrap=\"nowrap\">"._SORTORDER."</th><td>".$sel_uorder."</td></tr>";
		echo "<tr><th nowrap=\"nowrap\">"._THRESHOLD."</th><td>".$sel_thold."<br />"._COMMENTSWILLIGNORED."<br />"._SCORENOTE."</td></tr>";
		echo "<tr><th nowrap=\"nowrap\">"._SCORE."</th><td>".$check_score."<label for=\"check_1\"><b>"._NOSCORES."</b></label><br />"._HIDDESCORES."</td></tr>";
		echo "<tr><th nowrap=\"nowrap\">"._MAXCOMMENT."</th><td>".$text_length." "._BYTESNOTE."<br />"._TRUNCATES."</td></tr>";
		echo "</table>";
		echo "<center>"
			."<input type=\"hidden\" name=\"username\"	value=\"".$userinfo['uname']."\">"
			."<input type=\"hidden\" name=\"user_id\" value=\"".intval($userinfo['uid'])."\">"
			."<input type=\"hidden\" name=\"op\" value=\"savecomm\">"
			."<br /><input type=\"submit\" value=\""._SAVECHANGES."\"><br >&nbsp;</center>";
		echo "</fieldset>";
		echo "</form>";
/*		OpenTable();
		echo "<table cellpadding=\"8\" border=\"0\"><tr><td>"
		."<form action=\"modules.php?name=$module_name\" method=\"post\">"
		."<b>"._DISPLAYMODE."</b>"
		."<select name=\"umode\">";
		?>
<option value="nocomments"
		<?php if ($userinfo['umode'] == 'nocomments') { echo "selected"; } ?>><?php echo _NOCOMMENTS ?>
<option value="nested"
		<?php if ($userinfo['umode'] == 'nested') { echo "selected"; } ?>><?php echo _NESTED ?>
<option value="flat"
		<?php if ($userinfo['umode'] == 'flat') { echo "selected"; } ?>><?php echo _FLAT ?>
<option value="thread"
		<?php if (!isset($userinfo['umode']) || (empty($userinfo['umode'])) || $userinfo['umode']=='thread') { echo "selected"; } ?>><?php echo _THREAD ?>
</select> <br>
<br>
<b><?php echo _SORTORDER ?></b> <select name="uorder">
	<option value="0"
	<?php if (!$userinfo['uorder']) { echo "selected"; } ?>><?php echo _OLDEST ?>
	
	
	<option value="1"
	<?php if ($userinfo['uorder']==1) { echo "selected"; } ?>><?php echo _NEWEST ?>
	
	
	<option value="2"
	<?php if ($userinfo['uorder']==2) { echo "selected"; } ?>><?php echo _HIGHEST ?>

</select> <br>
<br>
<b><?php echo _THRESHOLD ?></b> <?php echo _COMMENTSWILLIGNORED ?><br>
<select name="thold">
	<option value="-1"
	<?php if ($userinfo['thold']==-1) { echo "selected"; } ?>>-1: <?php echo _UNCUT ?>
	
	
	<option value="0"
	<?php if ($userinfo['thold']==0) { echo "selected"; } ?>>0: <?php echo _EVERYTHING ?>
	
	
	<option value="1"
	<?php if ($userinfo['thold']==1) { echo "selected"; } ?>>1: <?php echo _FILTERMOSTANON ?>
	
	
	<option value="2"
	<?php if ($userinfo['thold']==2) { echo "selected"; } ?>>2: <?php echo _USCORE ?>
	+2
	
	
	<option value="3"
	<?php if ($userinfo['thold']==3) { echo "selected"; } ?>>3: <?php echo _USCORE ?>
	+3
	
	
	<option value="4"
	<?php if ($userinfo['thold']==4) { echo "selected"; } ?>>4: <?php echo _USCORE ?>
	+4
	
	
	<option value="5"
	<?php if ($userinfo['thold']==5) { echo "selected"; } ?>>5: <?php echo _USCORE ?>
	+5

</select><br>
<i><?php echo _SCORENOTE ?></i> <br>
<br>
<INPUT type="checkbox" name="noscore"
	<?php if ($userinfo['noscore']==1) { echo "checked"; } ?>><b> <?php echo _NOSCORES ?></b>
	<?php echo _HIDDESCORES ?> <br>
<br>
<b><?php echo _MAXCOMMENT ?></b> <?php echo _TRUNCATES ?><br>
<input type="text" name="commentmax"
	value="<?php echo "".intval($userinfo['commentmax'])."" ?>" size=11
	maxlength=11> <?php echo _BYTESNOTE ?> <br>
<br>
<input type="hidden" name="username"
	value="<?php echo"".$userinfo['uname'].""; ?>"> <input type="hidden"
	name="user_id" value="<?php echo"".intval($userinfo['uid']).""; ?>"> <input
	type="hidden" name="op" value="savecomm"> <input type="submit"
	value="<?php echo _SAVECHANGES ?>">
</form>
</td>
</tr>
</table>
	<?php
	CloseTable();
	echo "<br><br>";*/
		include ("footer.php");
	} 
	else {
		main($user);
	}
}

function savecomm($user_id, $username, $umode, $uorder, $thold, $noscore, $commentmax) {
	global $user, $cookie, $userinfo, $user_prefix, $db, $module_name;
	cookiedecode($user);
	$check = $cookie[1];
	$check2 = $cookie[2];
	$sql = "SELECT uid, pass FROM ".$user_prefix."_users WHERE uname='$check'";
	$result = $db->sql_query($sql);
	$row = $db->sql_fetchrow($result);
	$vuid = intval($row['uid']);
	$ccpass = filter($row['pass'], "nohtml", 1);
	if (($user_id == $vuid) AND ($check2 == $ccpass)) {
		if(isset($noscore)) {
			$noscore=1;
		}
		else {
			$noscore=0;
		}
		$db->sql_query("UPDATE ".$user_prefix."_users SET umode='$umode', uorder='$uorder', thold='$thold', noscore='$noscore', commentmax='$commentmax' WHERE uid='$user_id'");
		getusrinfo($user);
//		docookie($userinfo['user_id'],$userinfo['username'],$userinfo['user_password'],$userinfo['storynum'],$userinfo['umode'],$userinfo['uorder'],$userinfo['thold'],$userinfo['noscore'],$userinfo['ublockon'],$userinfo['theme'],$userinfo['commentmax']);
		docookie($userinfo['uid'],$userinfo['uname'],$userinfo['pass'],$userinfo['storynum'],$userinfo['umode'],$userinfo['uorder'],$userinfo['thold'],$userinfo['noscore'],$userinfo['ublockon'],$userinfo['theme'],$userinfo['commentmax']);
		Header("Location: modules.php?name=$module_name");
	}
}

function avatarlist($avatarcategory) {
	global $user, $userinfo, $cookie, $module_name;
	cookiedecode($user);
	getusrinfo($user);
	include("header.php");
	if ((is_user($user)) AND (strtolower($userinfo['uname']) == strtolower($cookie[1])) AND ($userinfo['pass'] == $cookie[2])) { // SecurityReason Fix 2005 - sp3x -> check if we are user if not then Access Denied
		$avatarcatname = preg_replace ("#_#", " ", $avatarcategory);
		$avatarcategory = htmlspecialchars($avatarcategory,ENT_QUOTES,'ISO-8859-1',true); //SecurityReason Fix 2005 - sp3x
		echo "<h1>"._AVATARGALERY.$avatarcatname."</h1>";
		echo "<div class=\"ya_buttonBarDiv\">";
		themesidebox(_MENUTODO, nav(0, "valign"));
		echo "</div>";
		echo "<p>&nbsp;<br />&nbsp;<br />"._CHOOSEAVATAR."</P>";
		echo "<fieldset class=\"ya_user_div\"><legend>".$avatarcatname."</legend>";
		echo "<div class=\"ya_avatarlist\">";
		$d = dir("modules/Forum/images/avatar/$avatarcategory");
		//		$temcount = 1;
		while (false !== ($entry = $d->read())) {
			if( preg_match('/(\.gif$|\.png$|\.jpg|\.jpeg)$/is', $entry) ) {
				if( $entry != '.' && $entry != '..' ) {
					$patterns[0] = "/\.gif/";
					$patterns[1] = "/\.png/";
					$patterns[2] = "/\.jpg/";
					$patterns[3] = "/\.jpeg/";
					$patterns[4] = "/-/";
					$patterns[5] = "/_/";
					$replacements[5] = "";
					$replacements[4] = "&nbsp;";
					$replacements[3] = "";
					$replacements[2] = "";
					$replacements[1] = "";
					$replacements[0] = "";
					ksort($patterns);
					ksort($replacements);
					$entryname =  preg_replace($patterns, $replacements, $entry);
					$a=1;
					echo "<a href=\"modules.php?name=$module_name&op=avatarsave&category=$avatarcategory&avatar=$entry\"><img src=\"modules/Forum/images/avatar/$avatarcategory/$entry\" border=\"0\" alt=\"$entryname\" title=\"$entryname\"></a> ";
				}
				//				if ($temcount == 10) {
				//					echo "<br>";
				//					$temcount -= 10;
				//				}
				//				$temcount ++;
			}
		}
		$d->close();
		echo "</fieldset>";
	
		echo "&nbsp;<br />";
		$avatar_category = ( !empty($HTTP_POST_VARS['avatarcategory']) ) ? $HTTP_POST_VARS['avatarcategory'] : '';
		$direktori = "modules/Forum/images/avatar";
		$board_config['allow_avatar_local']=true;
		$board_config['allow_avatar_remote']=true;
		$board_config['avatar_path']=$direktori;
		$board_config['avatar_gallery_path']=$direktori;
		$board_config['avatar_max_width'] = 50;
		$board_config['avatar_max_height'] = 50;
		$board_config['avatar_filesize'] = 5000;
		$dir = @opendir($direktori);
		$avatar_images = array();
		while( $file = @readdir($dir) ) {
			if( substr($file,0,1) != "!" && substr($file,0,1) != "_" && $file != '.' && $file != '..' && !is_file($direktori . '/' . $file) && !is_link($direktori . '/' . $file) ) {
				$sub_dir = @opendir($direktori . '/' . $file);
				$avatar_row_count = 0;
				$avatar_col_count = 0;
				while( $sub_file = @readdir($sub_dir) )
				{
					if( preg_match('/(\.gif$|\.png$|\.jpg|\.jpeg)$/is', $sub_file) ) {
						$avatar_images[$file][$avatar_row_count][$avatar_col_count] = $file . '/' . $sub_file;
						$avatar_name[$file][$avatar_row_count][$avatar_col_count] = ucfirst(str_replace("_", " ", preg_replace('/^(.*)\..*$/', '\1', $sub_file)));
						$avatar_col_count++;
						if( $avatar_col_count == 5 )
						{
							$avatar_row_count++;
							$avatar_col_count = 0;
						}
					}
				}
			}
		}
		@closedir($dir);
		@ksort($avatar_images);
		@reset($avatar_images);
		if( empty($category) ){
			list($category, ) = each($avatar_images);
		}
		@reset($avatar_images);
		$s_categories = '<select name="avatarcategory">';
		while( list($key) = each($avatar_images) ) {
			$selected = ( $key == $category ) ? ' selected="selected"' : '';
			if( count($avatar_images[$key]) )
			{
				$s_categories .= '<option value="' . $key . '"' . $selected . '>' . ucfirst($key) . '</option>';
			}
		}
		$s_categories .= '</select>';
		echo "<fieldset class=\"ya_user_div\"><legend>"._CHANGEGALLERY."</legend>";
		echo "<center>";
		echo "<form class=\"ya_edituser_form\" action=\"modules.php?name=Your_Account&op=avatarlist\" method=\"post\">"
		._SELECTAVATAR
		." ".$s_categories
		."<br /><br />"
		."<INPUT type=submit value=\""._SHOWGALLERY."\">"
		."</form>";
		echo "</center>";
		echo "</fieldset>";
	
		include("footer.php");
	}
	else die("Access Denied");
}
/**
 * avatarsave()
 * @param string avatar img
 * @param string avatar category
 */
function avatarsave($avatar, $category) {
	global $user_prefix, $db, $module_name, $user, $cookie;
	if (is_user($user)) {
		getusrinfo($user);
		cookiedecode($user);
		include("header.php");
		echo "<h1>"._PERSONALINFO."</h1>";
		echo "<div class=\"ya_buttonBarDiv\">";
		themesidebox(_MENUTODO, nav(0, "valign"));
		echo "</div>";
		echo "<p>&nbsp;<br />"._CONFIRMAVATARSAVED."<br />".""."</p>";
		$newavatar=$category."/".$avatar;
		$avatardir="modules/Forum/images/avatar/".$newavatar;
		$db->sql_query("UPDATE ".$user_prefix."_users SET user_avatar='$newavatar', user_avatar_type='3' WHERE uid = '".intval($cookie[0])."'");
		echo "<fieldset class=\"ya_user_div\"><legend>"._SAVEYOURAVATAR."</legend>";
		echo "<center><b>"._AVATARSAVED."</b></center>";
		if (preg_match("#(http)#", $newavatar)) {
			echo '<table align="center" class="ya_user_table">
			<tr><th>'._YOURNEWAVATAR.'</th></tr>
			<tr><td class="ya_img_td"><img alt="" src="'.$avatardir.'"></td></tr>
			<!--<tr><td><form><input type="button" value="'._BACKTOYOURPROFILE.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&op=edituser\'"> <input type="button" value="'._RETURNPAGE.'" onclick="window.location.href=\'modules.php?name='.$module_name.'\'"></form></td></tr>-->
			</table>';
		}
		elseif ($newavatar) {
			echo '<table align="center" class="ya_user_table">
			<tr><th>'._YOURNEWAVATAR.'</th></tr>
			<tr><td class="ya_img_td"><img alt="" src="'.$avatardir.'"></td></tr>
			<!--<tr><td><form><input type="button" value="'._BACKTOYOURPROFILE.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&op=edituser\'"> <input type="button" value="'._RETURNPAGE.'" onclick="window.location.href=\'modules.php?name='.$module_name.'\'"></form></td></tr>-->
			</table>';
		}
		echo "</fieldset>";
		include("footer.php");
	}
}

function avatarlinksave($avatar) {
	global $user_prefix, $db, $module_name, $user, $cookie;
	if (is_user($user)) {
		getusrinfo($user);
		cookiedecode($user);
		include("header.php");
		title("Avatar Selection Successful!");
		OpenTable();
		nav(0,"valign");
		CloseTable();
		OpenTable();
		$db->sql_query("UPDATE ".$user_prefix."_users SET user_avatar='$avatar', user_avatar_type='2' WHERE uid = '".intval($cookie[0])."'");
		echo "<center><font class=\"content\">Avatar for ".$cookie[1]." Saved!</center></font><br><br>";
		if (preg_match("#(http)#", $avatar)) { echo "<center>Your New Avatar:<br><br><IMG alt=\"\" src=\"$avatar\"><br><br>[ <a href=\"modules.php?name=$module_name&op=edituser\">Back to Profile</a> | <a href=\"modules.php?name=$module_name\">Done</a> ]<br><br></center>"; } elseif ($avatar) { echo "<center>Your New Avatar:<br><br><IMG alt=\"\" src=\"modules/Forums/images/avatars/$avatar\"><br><br>[ <a href=\"modules.php?name=$module_name&op=edituser\">Back to Profile</a> | <a href=\"modules.php?name=$module_name\">Done</a> ]<br><br></center>"; }
		CloseTable();
		include("footer.php");
	}
}

function broadcast($the_message, $who) {
	global $prefix, $db, $broadcast_msg, $module_name, $cookie, $user, $userinfo, $user_prefix;
	cookiedecode($user);
	getusrinfo($user);

	$row = $db->sql_fetchrow($db->sql_query("SELECT karma FROM ".$user_prefix."_users WHERE uid = '".intval($cookie[0])."'"));
	if (($row['karma'] == 2) OR ($row['karma'] == 3)) {
		Header("Location: modules.php?name=".$module_name);
		die();
	}

	if ((is_user($user)) AND (strtolower($who) == strtolower($cookie[1])) AND (strtolower($userinfo['uname']) == strtolower($cookie[1])) AND ($userinfo['pass'] == $cookie[2])) {
		$who = $cookie[1];
		$the_message = filter($the_message, "nohtml", 1);
		if ($broadcast_msg == 1) {
			include("header.php");
			title(""._BROADCAST."");
			OpenTable();
			$numrows = $db->sql_numrows($db->sql_query("SELECT * FROM ".$prefix."_public_messages WHERE who='$who'"));
			if (!empty($the_message) AND $numrows == 0) {
				$the_time = time();
				$who = filter($who, "nohtml", 1);
				$db->sql_query("INSERT INTO ".$prefix."_public_messages VALUES (NULL, '$the_message', '$the_time', '$who')");
				update_points(20);
				echo "<center>"._BROADCASTSENT."<br><br>[ <a href=\"modules.php?name=$module_name\">"._RETURNPAGE."</a> ]</center>";
			}
			else {
				echo "<center>"._BROADCASTNOTSENT."<br><br>[ <a href=\"modules.php?name=$module_name\">"._RETURNPAGE."</a> ]</center>";
			}
			CloseTable();
			include("footer.php");
		}
		else {
			echo "I don't like you...";
		}
	}
}

function my_headlines($hid, $url=0) {
	global $prefix, $db, $user;
	if (!is_user($user) || empty($url)) {
		die();
	}
	$hid = intval($hid);
	$sql = "SELECT headlinesurl FROM ".$prefix."_headlines WHERE hid='$hid'";
	$result = $db->sql_query($sql);
	$row = $db->sql_fetchrow($result);
	$url = filter($row[headlinesurl], "nohtml");
	$rdf = parse_url($url);
	$fp = fsockopen($rdf['host'], 80, $errno, $errstr, 15);
	if (!$fp) {
		$content = "<font class=\"content\">Problema!</font>";
		return;
	}
	if ($fp) {
		fputs($fp, "GET " . $rdf['path'] . "?" . $rdf['query'] . " HTTP/1.0\r\n");
		fputs($fp, "HOST: " . $rdf['host'] . "\r\n\r\n");
		$string	= "";
		while(!feof($fp)) {
			$pagetext = fgets($fp,300);
			$string .= chop($pagetext);
		}
		fputs($fp,"Connection: close\r\n\r\n");
		fclose($fp);
		$items = explode("</item>",$string);
		$content = "<font class=\"content\">";
		for ($i=0;$i<10;$i++) {
			$link = preg_replace("#.*<link>#","",$items[$i]);
			$link = preg_replace("#</link>.*#","",$link);
			$title2 = preg_replace("#.*<title>#","",$items[$i]);
			$title2 = preg_replace("#</title>.*#","",$title2);
			if (empty($items[$i])) {
				$content = "";
				return;
			} else {
				if (strcmp($link,$title)) {
					$cont = 1;
					$content .= "<img src=\"images/arrow.gif\" border=\"0\" hspace=\"5\"><a href=\"$link\" target=\"new\">$title2</a><br>\n";
				}
			}
		}
	}
	echo "$content";
}

function CoolSize($size) {
	$mb = 1024*1024;
	if ( $size > $mb ) {
		$mysize = sprintf ("%01.2f",$size/$mb) . " MB";
	} elseif ( $size >= 1024 ) {
		$mysize = sprintf ("%01.2f",$size/1024) . " Kb";
	} else {
		$mysize = $size . " bytes";
	}
	return $mysize;
}

function change_karma($user_id, $karma) {
	global $admin, $user_prefix, $db, $module_name;
	if (!is_admin($admin)) {
		Header("location: index.php");
		die();
	} else {
		if ($user_id > 1) {
			$karma = intval($karma);
			$db->sql_query("UPDATE ".$user_prefix."_users SET karma='$karma' WHERE uid='$user_id'");
			$row = $db->sql_fetchrow($db->sql_query("SELECT username FROM ".$user_prefix."_users WHERE uid='$user_id'"));
			$username = filter($row[username], "nohtml");
			Header("location: modules.php?name=$module_name&op=userinfo&username=$username");
			die();
		}
	}
}

if (!isset($hid)) { $hid = ""; }
if (!isset($url)) { $url = ""; }
if (!isset($bypass)) { $bypass = ""; }

// -------------------------------- SWITCH PART --------------------------------
switch($op) {

	case "change_karma":
		change_karma($user_id, $karma);
		break;

	case "logout":
		logout();
		break;

	case "avatarsave":
		avatarsave($avatar, $category);
		break;

	case "avatarlinksave":
		avatarlinksave($avatar);
		break;

	case "broadcast":
		broadcast($the_message, $who);
		break;

	case "lost_pass":
		lost_pass();
		break;

	case "new user":
		confirmNewUser($username, $user_email, $user_password, $user_password2, $random_num, $gfx_check);
		break;

	case "finish":
		finishNewUser($username, $user_email, $user_password, $random_num, $gfx_check);
		break;

	case "mailpasswd":
		mail_password($username, $code);
		break;

	case "userinfo":
		userinfo($username, $bypass, $hid, $url);
		break;

	case "login":
		login($username, $user_password, $redirect, $mode, $f, $t, $random_num, $gfx_check);
		break;

	case "edituser":
		edituser();
		break;

	case "saveuser":
		saveuser($realname, $user_email, $femail, $user_website, $user_icq, $user_aim, $user_yim, $user_msnm, $user_from, $user_occ, $user_interests, $newsletter, $user_viewemail, $user_allow_viewonline, $user_notify, $user_notify_pm, $user_popup_pm, $user_attachsig, $user_allowbbcode, $user_allowhtml, $user_allowsmile, $user_timezone, $user_dateformat, $user_sig, $bio, $user_password, $vpass, $username, $user_id);
		break;

	case "edithome":
		edithome();
		break;

	case "chgtheme":
		chgtheme();
		break;

	case "savehome":
		savehome($user_id, $username, $storynum, $ublockon, $ublock, $broadcast);
		break;

	case "savetheme":
		savetheme($user_id, $theme);
		break;

	case "avatarlist":
		avatarlist($avatarcategory);
		break;

	case "editAvatar":
		editAvatar();
		break;

	case "editcomm":
		editcomm();
		break;

	case "savecomm":
		savecomm($user_id, $username, $umode, $uorder, $thold, $noscore, $commentmax);
		break;

	case "pass_lost":
		pass_lost();
		break;

	case "new_user":
		new_user();
		break;

	case "my_headlines":
		if (is_user($user)) {
			if (!empty($url)) {
				my_headlines($hid, $url);
			} else { die(); }
		} else {
			Header("Location: modules.php?name=$module_name");
		}
		break;

	case "gfx":
		gfx($random_num);
		break;

	case "activate":
		activate($username, $check_num);
		break;

	case "CoolSize":
		CoolSize($size);
		break;

	default:
		main($user,$force);
		break;

}

?>