<?php

/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2002 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight($module_name)) {
setPath(_TXT_User,0);
setPath(_EDITUSERS,1);

//require_once("modules/$module_name/lib_db.php");
require_once("modules/$module_name/utils.php");
require_once("modules/$module_name/language/lang-".$currentlang.".php");

function list_index($nbreFiches, $page, $ligne_par_page,$letter,$url) {
		global $sortby, $selectgroup;
		$nboites = 5;
		$letterurl = ($letter != "" ) ? "&letter=".$letter : ""; 
		$sortbyurl = ($sortby != "") ? "&sortby=".$sortby :  "";
		$selectgroupurl = ($selectgroup != "" ) ? "&selectgroup=".$selectgroup : "";
		$liminf = $page - floor($nboites/2);
		$limsup = $page + floor($nboites/2);
		if ($liminf < 1) {
			$liminf = 1;
			$limsup = $nboites;
			if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
				$limsup = ceil($nbreFiches/$ligne_par_page);
			}
		}
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
			$liminf = $limsup - $nboites;
			if ($liminf < 1) {
				$liminf = 1;
			}
		}
		$min = 1;
		$max = ceil($nbreFiches/$ligne_par_page);


		$repParPage = $ligne_par_page;
		$p = $page;
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches._SNLUSERSFOUND."\"".$letter."\"";
			$indexPages .= _SNLUSERSPAGES;
			if ($min < $liminf) {
				if ($min == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$min";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"$url&page=$min".$selectgroupurl.$sortbyurl.$letterurl."\">$min</a>";
					$indexPages .= "</div>";
				}
				if ($min < $liminf - 1) {
					$indexPages .= "...";
				}
			}
			for ($i=$liminf;$i<=$limsup;$i++) {
				if ($i == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$i";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"$url&page=$i".$selectgroupurl.$sortbyurl.$letterurl."\">$i</a>";
					$indexPages .= "</div>";
				}
			}
			if ($max > $limsup) {
				if ($max > $limsup + 1) {
					$indexPages .= "...";
				}
				if ($max == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$max";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"$url&page=$max".$selectgroupurl.$sortbyurl.$letterurl."\">$max</a>";
					$indexPages .= "</div>";
				}

			}
		}
		else {
			$indexPages .= _SNLUSERSNOTFOUND;
		}
		$indexPages .= "</div>";
		return $indexPages;
	}

/**
 * userList()
 *
 *
 *
 */
function list_users_priv_sp($letter, $sortby, $page, $onglet, $selectgroup){
	global $user_prefix,$prefix, $db, $ongletDef, $admin, $user, $action, $op;
	
	$result3 = $db->sql_query("SELECT * FROM ".$user_prefix."_groups ORDER BY name ASC");
	$menugroup = "";
	if ($db->sql_numrows($result3) != 0) {
		$menugroup = '<select size="1" name="selectgroup" onchange="this.form.submit()">';
		$menugroup .= '<option value="">'._SNLUSERSLISTEFILTERGROUP."</option>";
		while ($ligneencours = $db->sql_fetchrow($result3)) {
			$selected = ($selectgroup == $ligneencours["id"]) ? " selected=\"selected\"" : "";
			$menugroup .= '<option value="'.$ligneencours["id"].'"'.$selected.'>'.$ligneencours["name"]."</option>";
		}
		$menugroup .= "</select>";
	}
	
	$pagesize = 20;

	$resultbuff=$db->sql_query("select uid from ".$user_prefix."_users");
	if (!$resultbuff) {
		print_r($db->sql_error());
		die('Invalid query:');
	}
	$numrows = $db->sql_numrows($resultbuff);

	$min = $pagesize * ($page - 1); // This is where we start our record set from
	$max = $pagesize; // This is how many rows to select
	
	$count = "SELECT COUNT(uid) AS total FROM ".$user_prefix."_users "; // Count all the users in the db..
	//$select = "SELECT uid, uname, email, user_name, user_firstname, user_tel, user_filiere, user_categorie, ".$user_prefix."_groups.name as groupe  from ".$user_prefix."_users left join ".$user_prefix."_groups ON ".$user_prefix."_users.user_group=".$user_prefix."_groups.id "; //select our data
	$select = "SELECT uid, uname, email, user_name, user_firstname, adh_tel from ".$user_prefix."_users "; //select our data
	$where = " WHERE uname <> 'Anonymous'";
	if (( $letter != "Other" ) AND ( $letter != "All" ) ) {
		$where .= "AND uname like '".$letter."%'";
	} 
	else if ( ( $letter == "Other" ) AND ( $letter != "All" ) ) {
		$where .= "AND uname REGEXP \"^\[1-9]\"";
	} 
	else {
		$where .= "";
	}
	$join = "";
	if ($selectgroup != "") {
		$join = " left join ".$user_prefix."_users_groups ON ".$user_prefix."_users.uid=".$user_prefix."_users_groups.user_id ";
		$where .= ($where =="") ? " WHERE " : " AND ";
		$where .= $user_prefix."_users_groups.group_id='".$selectgroup."'";
	}
	if ($sortby == "") {
		$sortby = "uname";
	}
	$sort = " ORDER BY $sortby ASC";
	$limit = " LIMIT ".$min.", ".$max;
	$count_result = $db->sql_query($count.$join.$where);
	if (!$count_result) {
		print_r($db->sql_error());
		die('Invalid query:');
	}
	list($num_rows_per_order) = $db->sql_fetchrow($count_result);
	
	$sortie = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td>';
	$paramplus = "";
	if ($selectgroup != "") {
		$paramplus = "&selectgroup=".$selectgroup;
	}
	if ($sortby != "") {
		$paramplus = "&sortby=".$sortby;
	}
	$sortie .= list_index($num_rows_per_order,$page,$pagesize,$letter,"system.php?op=users_privatespace&action=list_users".$paramplus);
	$sortie .= '</td><td width="30">&nbsp;</td><td>';
	$sortie .= '<form name="formgroup" action="system.php" method="POST">';
	$sortie .= '<input type="hidden" name="letter" value="'.$letter.'">';
	$sortie .= '<input type="hidden" name="sortby" value="'.$sortby.'">';
	//$sortie .= '<input type="hidden" name="page" value="'.$page.'">';
	$sortie .= '<input type="hidden" name="onglet" value="'.$onglet.'">';
	$sortie .= '<input type="hidden" name="op" value="'.$op.'">';
	$sortie .= '<input type="hidden" name="action" value="'.$action.'">';
	$sortie .= $menugroup;
	$sortie .= "</form>";
	$sortie .= '</td><td width="30">&nbsp;</td><td>';
	$sortie .= alpha($sortby,$onglet,$action,$selectgroup);
	$sortie .= '</td></tr></table>';
	$result = $db->sql_query($select.$join.$where.$sort.$limit); // Now lets do it !!
	if (!$result) {
		echo $select.$where.$sort.$limit;
		print_r($db->sql_error());
		die('Invalid query:');
	}

	$sortie .= "<table class=\"lisTable\"><tr class=\"systemTabHeader\">\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTPSEUDO." ".SortLinks($letter,$sortby,"uname")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTNOM." ".SortLinks($letter,$sortby,"user_name")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTMAIL."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTTEL."</td>\n";
	//$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTGROUP." ".SortLinks($letter,$sortby,"user_group")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTGROUP."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._FUNCTIONS."</font></td>\n";
	$sortie .= "</tr>";
	$a = 0;
	$dcolor_A = "$bgcolor2";
	$dcolor_B = "$bgcolor1";

	if (($result)){
		$num_users = $db->sql_numrows($result); 
	} 
	else {
		$num_users=0;
	}

	if ( $num_rows_per_order > 0  ) {
		$pos=0;
		while($user = $db->sql_fetchrow($result)) {
			if ($pos % 2 == 0){
				$thestyle="listTableOdd";
			} 
			else {
				$thestyle="listTableNone";
			}
			$result2 = $db->sql_query("SELECT name FROM ".$user_prefix."_groups JOIN ".$user_prefix."_users_groups ON ".$user_prefix."_users_groups.group_id=".$user_prefix."_groups.id WHERE ".$user_prefix."_users_groups.user_id='".$user["uid"]."'");
			$groupes = "";
			if ($db->sql_numrows($result2)>0) {
				while ($legroupe = $db->sql_fetchrow($result2)) {
					$groupes .= ($groupes != "") ? ", " : "";
					$groupes .= $legroupe["name"];
				}
			}
			$dcolor = ($a == 0 ? $dcolor_A : $dcolor_B);
			$sortie .= "<tr class=\"$thestyle\">";
			$sortie .= "<td >&nbsp;&nbsp;&nbsp;&nbsp;<b>$user[uname]</b></td>\n";
			$sortie .= "<td ><b>$user[user_name] $user[user_firstname]</b></td>\n";
			$sortie .= "<td><a href=\"mailto:".$user["email"]."\">$user[email]</a></td>\n";
			$sortie .= "<td>$user[adh_tel]</td>\n";
			//$sortie .= "<td >$user[groupe]</td>\n";
			$sortie .= "<td >$groupes</td>\n";
			$barDef=array(
				"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=users_privatespace&action=edit_user&Id=$user[uid]&letter=".$letter."&onglet=".$onglet."&sortby=".$sortby."&page=".$page.$paramplus,"comment"=>_EDIT, "status"=>"ON"),
				"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=users_privatespace&action=delete_user&Id=$user[uid]&letter=".$letter."&onglet=".$onglet."&sortby=".$sortby."&page=".$page.$paramplus,"comment"=>_DELETE,"status"=>"ON"));
			$sortie .= "<td>";
			$sortie .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
			$sortie .= "</td>";	
			$sortie .= "</tr>";
			$a = ($dcolor == $dcolor_A ? 1 : 0);
			$pos++;
		}
	}
	$sortie .= "\n</table>";
	$sortie .= '<a href="system.php?op=users_privatespace&action=new_user">'._SNLUSERSLISTEADD.'</a>';
	$sortie .= '<br><a href="system.php?op=users_privatespace&action=usersToExcel">'._SNLUSERSLISTEEXPORTXLS.'</a>';
	return $sortie;
}

function list_users_priv_sp_no($letter, $sortby, $page, $onglet){
	global $user_prefix,$prefix, $db, $ongletDef, $admin, $user, $action;
	
	$pagesize = 20;

	$min = $pagesize * ($page - 1); // This is where we start our record set from
	$max = $pagesize; // This is how many rows to select

	$count = "SELECT COUNT(user_id) AS total FROM ".$user_prefix."_users_temp "; // Count all the users in the db..
	$select = "SELECT user_id, username, user_email, user_name, user_firstname, user_valid from ".$user_prefix."_users_temp";
	//$where = " WHERE user_valid = '0'";
	$where = "";
	if (( $letter != "Other" ) AND ( $letter != "All" ) ) {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "username like '".$letter."%'";
	} 
	else if ( ( $letter == "Other" ) AND ( $letter != "All" ) ) {
		$where .= ($where == "") ? " WHERE " : " AND ";
		$where .= "username REGEXP \"^\[1-9]\"";
	} 
	else {
		$where .= "";
	}
	if ($sortby == "") {
		$sortby = "username";
	}
	$sort = " ORDER BY $sortby ASC";
	$limit = " LIMIT ".$min.", ".$max;
	$count_result = $db->sql_query($count.$where);
	if (!$count_result) {
		print_r($db->sql_error());
		die('Invalid query:');
	}
	list($num_rows_per_order) = $db->sql_fetchrow($count_result);
	
	$sortie = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td>';
	$sortie .= list_index($num_rows_per_order,$page,$pagesize,$letter,"system.php?action=list_usersno&op=users_privatespace&onglet=users_notvalid");
	$sortie .= '</td><td width="50">&nbsp;</td><td>';
	$sortie .= alpha($sortby,$onglet,"list_usersno");
	$sortie .= '</td></tr></table>';
	$result = $db->sql_query($select.$where.$sort.$limit); // Now lets do it !!
	if (!$result) {
		echo $select.$where.$sort.$limit;
		print_r($db->sql_error());
		die('Invalid query:');
	}

	$sortie .= "<table class=\"lisTable\"><tr class=\"systemTabHeader\">\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTPSEUDO." ".SortLinks($letter,$sortby,"username")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTNOM." ".SortLinks($letter,$sortby,"user_name")."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTMAIL."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTGROUP."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._SNLLISTSTATUS."</td>\n";
	$sortie .= "<td class=\"systemTabHeader\">"._FUNCTIONS."</font></td>\n";
	$sortie .= "</tr>";
	$a = 0;
	$dcolor_A = "$bgcolor2";
	$dcolor_B = "$bgcolor1";

	if (($result)){
		$num_users = $db->sql_numrows($result); 
	} 
	else {
		$num_users=0;
	}

	if ( $num_rows_per_order > 0  ) {
		$pos=0;
		while($user = $db->sql_fetchrow($result)) {
			if ($pos % 2 == 0){
				$thestyle="listTableOdd";
			} 
			else {
				$thestyle="listTableNone";
			}
			$result2 = $db->sql_query("SELECT name FROM ".$user_prefix."_groups JOIN ".$user_prefix."_users_temp_groups ON ".$user_prefix."_users_temp_groups.group_id=".$user_prefix."_groups.id WHERE ".$user_prefix."_users_temp_groups.user_id='".$user["user_id"]."'");
			$groupes = "";
			if ($db->sql_numrows($result2)>0) {
				while ($legroupe = $db->sql_fetchrow($result2)) {
					$groupes .= ($groupes != "") ? ", " : "";
					$groupes .= $legroupe["name"];
				}
			}
			$status = ($user["user_valid"] == "1") ? _SNLLISTSTATUSOK : "<b>"._SNLLISTSTATUSPASOK."</b>";
			$dcolor = ($a == 0 ? $dcolor_A : $dcolor_B);
			$sortie .= "<tr class=\"$thestyle\">";
			$sortie .= "<td >&nbsp;&nbsp;&nbsp;&nbsp;<b>$user[username]</b></td>\n";
			$sortie .= "<td ><b>$user[user_name] $user[user_firstname]</b></td>\n";
			$sortie .= "<td><a href=\"mailto:".$user["user_email"]."\">$user[user_email]</a></td>\n";
			$sortie .= "<td >$groupes</td>\n";
			$sortie .= "<td >$status</td>\n";
			$barDef=array(
				"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=users_privatespace&action=edit_user_no&Id=$user[user_id]&letter=".$letter."&onglet=".$onglet."&sortby=".$sortby."&page=".$page,"comment"=>_EDIT, "status"=>"ON"),
				"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=users_privatespace&action=delete_userno&Id=$user[user_id]&letter=".$letter."&onglet=".$onglet."&sortby=".$sortby."&page=".$page,"comment"=>_DELETE,"status"=>"ON"));
			$sortie .= "<td>";
			$sortie .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
			$sortie .= "</td>";	
			$sortie .= "</tr>";
			$a = ($dcolor == $dcolor_A ? 1 : 0);
			$pos++;
		}
	}
	$sortie .= "\n</table>";
	//$sortie .= '<a href="system.php?op=users_data&action=new_user">'._SNLUSERSLISTEADD.'</a>';
	return $sortie;
}

function edit_member_priv_sp($Id, $page="",$letter="", $onglet="",$membre=array(),$stop="",$selectgroup="") {
	global $module_name, $db, $user_prefix,$language;
	if ($Id != "" && $Id != "-1") {
		$select = "SELECT uid, uname, email, user_name, user_firstname, user_town, user_filiere, user_categorie, user_group, adh_tel, adh_entreprise  from ".$user_prefix."_users WHERE uid='$Id'"; //select our data
		$result = $db->sql_query($select);
		$membre = $db->sql_fetchrow($result);
		$lesgroupes= array();
		$result = $db->sql_query("SELECT * FROM ".$user_prefix."_users_groups WHERE user_id='".$membre["uid"]."'");
		if ($db->sql_numrows($result) != 0) {
			while ($ligneencours = $db->sql_fetchrow($result)) {
				$lesgroupes[$ligneencours["group_id"]] = "ok";
			}
		}
	}
	else {
		$membre["uid"] = $Id;
		$lesgroupes= array();
		if (!isset($membre["groups"])) {
			$membre["groups"] = array();
		}
		foreach ($membre["groups"] as $groupencours) {
			$lesgroupes[$groupencours] = "ok";
		}
	}
	$groupesbox = "";
	$result = $db->sql_query("SELECT * FROM ".$user_prefix."_groups ORDER BY name ASC");
	if ($db->sql_numrows($result) != 0) {
		while ($ligneencours = $db->sql_fetchrow($result)) {
			$checked = ($lesgroupes[$ligneencours["id"]] == "ok") ? " checked=\"checked\"" : "";
			$groupesbox .= '<input name="groups[]" type="checkbox" id="'.$ligneencours["id"].'" value="'.$ligneencours["id"].'"'.$checked.'>';
			$groupesbox .= '<label for="'.$ligneencours["id"].'">'.$ligneencours["name"].'</label><br />';
		}
	}
	
	$sortie .= '<script type="text/javascript" src="javascripts/lang/lang-'.$language.'.js"></script>
	<script type="text/javascript" src="javascripts/control_form.js"></script>
	';
	$sortie .= '<form name="edit_member" action="system.php?op=users_privatespace&action=save_user&onglet='.$onglet.'" method="POST" onsubmit="return submit_form(this)">';
	$sortie .= '<center><div class="fiche_adh">';
	if ($stop !="") {
		$sortie .= '&nbsp;<br />'.'<b>'.$stop.'</b>'; 
	}
	$sortie .= '&nbsp;<br />';
	$sortie .= '<fieldset><legend>'._SNLUSERBLOC.'</legend>';
	$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SNLUSERSBLOCNICKNAME;
	$sortie .= '</td><td>';
	$sortie .= '<champ lib="'._SUBSURNAME.'" nom="uname" lim="1,100"></champ>';
	$sortie .= '<input type="text" name="uname" value="'.$membre["uname"].'" class="saisie">';
	$sortie .= '</td></tr>';

	$sortie .= '<tr><td class="label">';
	$sortie .= _SNLUSERSBLOCNAME;
	$sortie .= '</td><td>';
	$sortie .= '<champ lib="'._SUBNAME.'" nom="user_name" lim="1,100"></champ>';
	$sortie .= '<input type="text" name="user_name" value="'.$membre["user_name"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SNLUSERSBLOCFIRSTNAME;
	$sortie .= '</td><td>';
	$sortie .= '<champ lib="'._SUBPRENAME.'" nom="user_firstname" lim="1,100"></champ>';
	$sortie .= '<input type="text" name="user_firstname" value="'.$membre["user_firstname"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SNLUSERSBLOCEMAIL;
	$sortie .= '</td><td>';
	$sortie .= '<champ ctl="email" lib="'._SUBMAIL.'" nom="email" lim="3,100"></champ>';
	$sortie .= '<input type="text" name="email" value="'.$membre["email"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
		$sortie .= '<tr><td class="label">';
	$sortie .= _SNLUSERSBLOCSOCIETE;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_entreprise" value="'.$membre["adh_entreprise"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SNLUSERSBLOCTEL;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_tel" value="'.$membre["adh_tel"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SNLUSERSBLOCGROUP;
	$sortie .= '</td><td>';
	$sortie .= $groupesbox;
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SNLUSERSBLOCPASSWD;
	$sortie .= '</td><td>';
	$sortie .= '<input type="password" name="newpass" value="" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '</table>';
	$sortie .= '</fieldset>';
	
	$sortie .= '<br />&nbsp;<br />';
	$sortie .= '<input type="submit" value="'._SNLUSERSSAVEBTN.'" name="valid">';
	$sortie .= '<input type="hidden" value="'.$membre["uid"].'" name="uid">';
	$sortie .= '<input type="hidden" value="'.$page.'" name="page">';
	$sortie .= '<input type="hidden" value="'.$letter.'" name="letter">';
	$sortie .= '<input type="hidden" value="'.$selectgroup.'" name="selectgroup">';
	
	$sortie .= '<br />&nbsp;';
	$sortie .= '</div></center>';
	$sortie .= "</form>";
	
	return $sortie;
}

function edit_member_priv_sp_no($Id, $page="",$letter="", $onglet="",$membre=array(),$stop="") {
	global $module_name, $db, $user_prefix,$language;
	if ($Id != "" && $Id != "-1") {
		$select = "SELECT user_id, username, user_email, user_name, user_firstname, user_valid,adh_entreprise,adh_tel, user_language, user_domain_reg from ".$user_prefix."_users_temp WHERE user_id='$Id'"; //select our data
		$result = $db->sql_query($select);
		$membre = $db->sql_fetchrow($result);
		$lesgroupes= array();
		$result = $db->sql_query("SELECT * FROM ".$user_prefix."_users_temp_groups WHERE user_id='".$membre["user_id"]."'");
		if ($db->sql_numrows($result) != 0) {
			while ($ligneencours = $db->sql_fetchrow($result)) {
				$lesgroupes[$ligneencours["group_id"]] = "ok";
			}
		}
	}
	else {
		//un enregistrement ne s'est pas bien droul
	}
	$groupesbox = "";
	$result = $db->sql_query("SELECT * FROM ".$user_prefix."_groups ORDER BY name ASC");
	if ($db->sql_numrows($result) != 0) {
		while ($ligneencours = $db->sql_fetchrow($result)) {
			$checked = ($lesgroupes[$ligneencours["id"]] == "ok") ? " checked=\"checked\"" : "";
			$groupesbox .= '<input name="groups[]" type="checkbox" id="'.$ligneencours["id"].'" value="'.$ligneencours["id"].'"'.$checked.'>';
			$groupesbox .= '<label for="'.$ligneencours["id"].'">'.$ligneencours["name"].'</label><br />';
		}
	}
	
	
	$checked = "";
	if ($membre["user_valid"] == "1") {
		$checked = " checked=\"checked\"";
	}
	$radiovalid = '<input type="checkbox" value="1" name="user_valid"'.$checked.'>';
	
	
	$sortie .= '<script type="text/javascript" src="javascripts/lang/lang-'.$language.'.js"></script>
	<script type="text/javascript" src="javascripts/control_form.js"></script>
	';
	$sortie .= '<form name="edit_member" action="system.php?op=users_privatespace&action=save_userno&onglet='.$onglet.'" method="POST" onsubmit="return submit_form(this)">';
	$sortie .= '<center><div class="fiche_adh">';
	if ($stop !="") {
		$sortie .= '&nbsp;<br />'.'<b>'.$stop.'</b>'; 
	}
	$sortie .= '&nbsp;<br />';
	$sortie .= '<fieldset><legend>'._SNLUSERBLOC.'</legend>';
	$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SNLUSERSBLOCNICKNAME;
	$sortie .= '</td><td>';
	$sortie .= '<champ lib="'._SUBSURNAME.'" nom="username" lim="1,100"></champ>';
	$sortie .= '<input type="text" name="username" value="'.$membre["username"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SNLUSERSBLOCNAME;
	$sortie .= '</td><td>';
	$sortie .= '<champ lib="'._SUBNAME.'" nom="user_name" lim="1,100"></champ>';
	$sortie .= '<input type="text" name="user_name" value="'.$membre["user_name"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SNLUSERSBLOCFIRSTNAME;
	$sortie .= '</td><td>';
	$sortie .= '<champ lib="'._SUBPRENAME.'" nom="user_firstname" lim="1,100"></champ>';
	$sortie .= '<input type="text" name="user_firstname" value="'.$membre["user_firstname"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SNLUSERSBLOCSOCIETE;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_entreprise" value="'.$membre["adh_entreprise"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SNLUSERSBLOCTEL;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="adh_tel" value="'.$membre["adh_tel"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SNLUSERSBLOCEMAIL;
	$sortie .= '</td><td>';
	$sortie .= '<champ ctl="email" lib="'._SUBMAIL.'" nom="user_email" lim="3,100"></champ>';
	$sortie .= '<input type="text" name="user_email" value="'.$membre["user_email"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SNLUSERSBLOCGROUP;
	$sortie .= '</td><td>';
	$sortie .= $groupesbox;
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SDDATAVALID;
	$sortie .= '</td><td>';
	$sortie .= $radiovalid;
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td class="label">';
	$sortie .= _SNLUSERSBLOCPASSWD;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="user_password" value="" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '</table>';
	$sortie .= '</fieldset>';
	
	$sortie .= '<br />&nbsp;<br />';
	$sortie .= '<input type="submit" value="'._SNLUSERSSAVEBTN.'" name="valid">';
	$sortie .= '<input type="hidden" value="'.$membre["user_id"].'" name="user_id">';
	$sortie .= '<input type="hidden" value="'.$membre["user_language"].'" name="user_language">';
	$sortie .= '<input type="hidden" value="'.$membre["user_domain_reg"].'" name="user_domain_reg">';
	$sortie .= '<input type="hidden" value="'.$page.'" name="page">';
	$sortie .= '<input type="hidden" value="'.$letter.'" name="letter">';
	
	$sortie .= '<br />&nbsp;';
	$sortie .= '</div></center>';
	$sortie .= "</form>";
	
	return $sortie;
}

function save_userpriv_sp($member) {
	global $module_name, $db, $user_prefix, $simplenewslettergroup, $language,$stop;
	if ($member["uname"] == "") {
		$member["uname"] = $member["user_name"]." ".$member["user_firstname"];
	}
	$member["uname"] = str_replace(" ", "_", $member["uname"]);
	$member["uname"] = str_replace("'", "", $member["uname"]);
	$member["uname"] = filter($member["uname"], "nohtml");
	$obj_util = new utilFuncs_simpleUsers();
	$member["uname"] = $obj_util->normaliser($member["uname"]);
	$member["uname"] = substr($member["uname"],0,25);
	
	$member["email"] = filter($member["email"], "nohtml");
	$member["user_name"] = filter($member["user_name"], "nohtml");
	$member["user_firstname"] = filter($member["user_firstname"], "nohtml");
	
	$member["adh_entreprise"] = filter($member["adh_entreprise"], "nohtml");
	$member["adh_tel"] = filter($member["adh_tel"], "nohtml");
	
	if ($member["uid"] == "-1" || $member["uid"]=="") {
		$stop = userCheck($member["uname"], $member["email"], $member["uid"]);
		if ($stop =="") {
			$user_regdate = date("M d, Y");
			$user_password = "nopass";
			$newpass = md5($member["pass"]);
			$newpass = htmlspecialchars(stripslashes($newpass),ENT_QUOTES,'ISO-8859-1',true);
			$result = $db->sql_query("INSERT INTO ".$user_prefix."_users (uname, pass, user_regdate, user_lang, email, user_name, user_firstname, adh_entreprise, adh_tel) VALUES ('".$member['uname']."', '".$newpass."', '".$user_regdate."', '".$language."', '".$member['email']."', '".$member['user_name']."', '".$member['user_firstname']."', '".$member["adh_entreprise"]."', '".$member['adh_tel']."')");
			$member["uid"] = $db->sql_nextid();
		}
	}
	else {
		$result = $db->sql_query("UPDATE ".$user_prefix."_users SET `uname` = '".$member["uname"]."',`email` = '".$member["email"]."', `user_name` = '".$member["user_name"]."', `user_firstname` = '".$member["user_firstname"]."', `adh_entreprise`='".$member["adh_entreprise"]."', `adh_tel` = '".$member["adh_tel"]."' WHERE `uid` = '".$member["uid"]."';");
		//modification du mot de passe
		if ($member["pass"] != "") {
			$new_password = md5($member["pass"]);
			$new_password = htmlspecialchars(stripslashes($new_password),ENT_QUOTES,'ISO-8859-1',true);
			$db->sql_query("UPDATE ".$user_prefix."_users SET `pass`='".$new_password."' WHERE `uid` = '".$member["uid"]."';");
		}
	}
	if (($stop=="") && ($result)) {
		//supprimer anciens groupes
		$result = $db->sql_query("DELETE FROM ".$user_prefix."_users_groups WHERE user_id='".$member["uid"]."'");
		//ajouter nouveaux groupes
		foreach ($member["groups"] as $groupencours) {
			$result = $db->sql_query("INSERT INTO ".$user_prefix."_users_groups (user_id, group_id) VALUES ('".$member["uid"]."','".$groupencours."')");
		}
		return true;
	}
	return false;
}

function format_nuke_url($nukeurl) {
	$tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}
	return $racine;	
}

function save_userpriv_sp_no($member) {
	global $module_name, $db, $user_prefix, $simplenewslettergroup, $language,$stop, $sitename, $simpleusersprivateadminmail;
	
	if ($member["user_domain_reg"] != "") {
		$nukeurl = $member["user_domain_reg"];
	}
	else {
		$nukeurl = "http://".$_SERVER["HTTP_HOST"].($_SERVER["SERVER_PORT"]!="80" ? ":".$_SERVER["SERVER_PORT"] : "");
	}
	
	if ($member["user_language"] != "") {
		$sujetmailtab = array("french" => _SUBSPRIVSPMAILSUBJECTFRENCH,"italian" => _SUBSPRIVSPMAILSUBJECTITALIAN);
		$sujetmail = $sujetmailtab[$member["user_language"]];
		$corpsmailtab = array("french" => _SUBSPRIVSPMAILMESSAGEFRENCH,"italian" => _SUBSPRIVSPMAILMESSAGEITALIAN);
		$corpsmail = $corpsmailtab[$member["user_language"]];
	}
	else {
		$sujetmail = _SUBSPRIVSPMAILSUBJECT;
		$corpsmail = _SUBSPRIVSPMAILMESSAGE;
	}
	
	$member["username"] = str_replace(" ", "_", $member["username"]);
	$member["username"] = str_replace("'", "", $member["username"]);
	$member["username"] = filter($member["username"], "nohtml");
	$obj_util = new utilFuncs_simpleUsers();
	$member["username"] = $obj_util->normaliser($member["username"]);
	$member["username"] = substr($member["username"],0,25);
	
	$member["user_email"] = filter($member["user_email"], "nohtml");
	$member["user_name"] = filter($member["user_name"], "nohtml");
	$member["user_firstname"] = filter($member["user_firstname"], "nohtml");

	$member["adh_entreprise"] = filter($member["adh_entreprise"], "nohtml");
	$member["adh_tel"] = filter($member["adh_tel"], "nohtml");
	if ($member["user_id"] == "-1" || $member["user_id"]=="") {
		die("Erreur : cration d'utilisateurs non autorise");
	}
	else {
		$stop = userCheck($member["username"], $member["user_email"], 0);
		if ($stop =="") {
			$result = $db->sql_query("UPDATE ".$user_prefix."_users_temp SET `username` = '".$member["username"]."',`user_email` = '".$member["user_email"]."',`user_group` = '".$member["user_group"]."', `user_name` = '".$member["user_name"]."', `user_firstname` = '".$member["user_firstname"]."', `user_level` = '".$member["user_level"]."', `user_valid` = '".$member["user_valid"]."', `adh_entreprise` = '".$member["adh_entreprise"]."',`adh_tel` = '".$member["adh_tel"]."', `time`='".(time()+(3600*24*8))."'  WHERE `user_id` = '".$member["user_id"]."';");
			if ($result) {
				//modification du mot de passe
				if ($member["user_password"] != "") {
					$new_password = md5($member["user_password"]);
					$new_password = htmlspecialchars(stripslashes($new_password),ENT_QUOTES,'ISO-8859-1',true);
					$db->sql_query("UPDATE ".$user_prefix."_users_temp SET `user_password` = '".$new_password."' WHERE `user_id` = '".$member["user_id"]."';");
				}
				//enregistrement des groupes attribus
				$result = $db->sql_query("DELETE FROM ".$user_prefix."_users_temp_groups WHERE user_id='".$member["user_id"]."'");
				//ajouter nouveaux groupes
				foreach ($member["groups"] as $groupencours) {
					$result = $result && $db->sql_query("INSERT INTO ".$user_prefix."_users_temp_groups (user_id, group_id) VALUES ('".$member["user_id"]."','".$groupencours."')");
				}
				if ($result && ($member["user_valid"]=="1")) {
					//email au membre qui veut s'enregistrer
					$result = $db->sql_query("SELECT check_num from ".$user_prefix."_users_temp WHERE `user_id` = '".$member["user_id"]."'");
					$ligneencours = $db->sql_fetchrow($result);
					$nukeurl = format_nuke_url($nukeurl);
					$finishlink = "$nukeurl/modules.php?name=$module_name&op=activateprivatesp&check_num=".$ligneencours["check_num"];
					if ($member["user_password"] != "") {
						$identifiants = str_replace("<!--login-->", $member["username"], _SUBSPRIVSPMAILMESSAGELOG);
						$identifiants = str_replace("<!--password-->", $member["user_password"], $identifiants);
					}
					else {
						$identifiants = "";
					}
					
					$member["user_name"] = str_replace("''", "'",$member["user_name"]);
					$member["user_firstname"] = str_replace("''", "'",$member["user_firstname"]);
	//echo $finishlink;				
					$subject = "".$sujetmail."\"".$sitename."\"";
					$message = str_replace("<!--nom-->", $member["user_name"], $corpsmail);
					$message = str_replace("<!--prenom-->", $member["user_firstname"], $message);
					$message = str_replace("<!--lien-->", $finishlink, $message);
					$message = str_replace("<!--identifiants-->", $identifiants, $message);
					$objutil = new utilFuncs_simpleUsers();
					$objutil->send_email($member["user_email"], $simpleusersprivateadminmail,$subject,$message);
				}
			}
		}
	}
	return (($stop=="") && ($result));
}
	
function userCheck($username, $user_email,$uid) {
	$username = filter($username, "nohtml");
	$user_email = filter($user_email, "nohtml");
	global $user_prefix, $db;
	$stop = "";
	if ((!$user_email) || (empty($user_email)) || (!preg_match("#^[_\.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,25}$#i",$user_email))) $stop = "<center>"._ERRORINVEMAIL."</center><br>";
	if (strrpos($user_email,' ') > 0) $stop = "<center>"._ERROREMAILSPACES."</center>";
	if ((!$username) || (empty($username)) || (preg_match("#[^a-zA-Z0-9_-]#",$username))) $stop = "<center>"._ERRORINVNICK."</center><br>";
	if (strlen($username) > 25) $stop = "<center>"._NICK2LONG."</center>";
	if (preg_match("#^((root)|(adm)|(linux)|(webmaster)|(admin)|(god)|(administrator)|(administrador)|(nobody)|(anonymous)|(anonimo)|(annimo)|(operator)|(JackFromWales4u2))$#i",$username)) $stop = "<center>"._NAMERESERVED."</center>";
	if (strrpos($username,' ') > 0) $stop = "<center>"._NICKNOSPACES."</center>";
	if ($db->sql_numrows($db->sql_query("SELECT uname FROM ".$user_prefix."_users WHERE uname='$username' AND uid<>'$uid'")) > 0) $stop = "<center>"._NICKTAKEN."</center><br>";
	if ($db->sql_numrows($db->sql_query("SELECT username FROM ".$user_prefix."_users_temp WHERE username='$username' AND uid<>'$uid'")) > 0) $stop = "<center>"._NICKTAKEN."</center><br>";
	if ($db->sql_numrows($db->sql_query("SELECT email FROM ".$user_prefix."_users WHERE email='$user_email' AND uid<>'$uid'")) > 0) $stop = "<center>"._EMAILREGISTERED."</center><br>";
	if ($db->sql_numrows($db->sql_query("SELECT user_email FROM ".$user_prefix."_users_temp WHERE user_email='$user_email' AND uid<>'$uid'")) > 0) $stop = "<center>"._EMAILREGISTERED."</center><br>";
	return $stop;
}

function delete_userpriv_sp($Id,$confirm="n",$letter,$sortby,$page, $onglet) {
	global $db, $user_prefix;
	if ($Id != "") {
		if ($confirm == "y"){
			$sql ="DELETE FROM ".$user_prefix."_users WHERE uid=".$Id;
			if ($db->sql_query($sql)) {
				$db->sql_query("DELETE FROM ".$user_prefix."_users_groups WHERE user_id='".$Id."'");
				return "";
			}
			else {
				die("Error : DB problem");
			}
		}
		else {
			$sortie = "<div style=\"text-align: center; font-weight: bold\">";
			$sortie .= "<p>"._SNLUSERSCONFIRMDELETEMEMEMBER."</p>";
			$sortie .= "<p>&nbsp;</p>";
			$sortie .= "<p>";
			$sortie .= '<a href="system.php?op=users_privatespace&action=delete_user&Id='.$Id.'&letter='.$letter.'&onglet='.$onglet.'&sortby='.$sortby.'&page='.$page.'&confirm=y">';
			$sortie .= "["._YES."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._NO."]";
			$sortie .= '</a>';
			$sortie .= "</p>";
			$sortie .= "</div>";
			return $sortie;
		}
	}
}

function delete_userprivno_sp($Id,$confirm="n",$letter,$sortby,$page, $onglet) {
	global $db, $user_prefix;
	if ($Id != "") {
		if ($confirm == "y"){
			$sql ="DELETE FROM ".$user_prefix."_users_temp WHERE user_id=".$Id;
			if ($db->sql_query($sql)) {
				$db->sql_query("DELETE FROM ".$user_prefix."_users_temp_groups WHERE user_id='".$Id."'");
				return "";
			}
			else {
				die("Error : DB problem");
			}
		}
		else {
			$sortie = "<div style=\"text-align: center; font-weight: bold\">";
			$sortie .= "<p>"._SNLUSERSCONFIRMDELETEMEMEMBERNO."</p>";
			$sortie .= "<p>&nbsp;</p>";
			$sortie .= "<p>";
			$sortie .= '<a href="system.php?op=users_privatespace&action=delete_userno&Id='.$Id.'&letter='.$letter.'&onglet='.$onglet.'&sortby='.$sortby.'&page='.$page.'&confirm=y">';
			$sortie .= "["._YES."]";
			$sortie .= "</a>";
			$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
			$sortie .= '<a href="javascript:window.history.back()">';
			$sortie .= "["._NO."]";
			$sortie .= '</a>';
			$sortie .= "</p>";
			$sortie .= "</div>";
			return $sortie;
		}
	}
}

function alpha($sortby,$onglet,$action,$selectgroup="") {
	/* Creates the list of letters and makes them a link. */
	$sortie = "";
	$alphabet = array ("All", "A","B","C","D","E","F","G","H","I","J","K","L","M",
	"N","O","P","Q","R","S","T","U","V","W","X","Y","Z","Other");
	$num = count($alphabet) - 1;
	$sortie .= "<div>";
	$sortie .= _SNLUSERSLISTEFILTER;
	$sortie .= "[ ";
	$counter = 0;
	$paramplus = "";
	if ($selectgroup != "") {
		$paramplus = "&selectgroup=".$selectgroup;
	}
	while (list(, $ltr) = each($alphabet)) {
		$sortie .= "<A HREF=\"system.php?op=users_privatespace&action=$action&letter=$ltr&sortby=$sortby&onglet=$onglet$paramplus\">$ltr</a>";
		if ( $counter == round($num/2) ) {
			$sortie .= " ]\n[ ";
		} elseif ( $counter != $num ) {
			$sortie .= "&nbsp;|&nbsp;\n";
		}
		$counter++;
	}
	$sortie .= " ]\n</div>\n\n";
	return $sortie;
}

function SortLinks($letter, $sortby, $what) {  // Makes order by links..
	global $Default_Skin,$action,$onglet,$page,$selectgroup;
	
	$skinPath="system/skins/$Default_Skin";
       if ($letter == "front") {
		$letter = "All";
	}
	$sorticon="$skinPath/down.png";
	//echo "$sortby||$what//";
	if ($sortby != $what || $sortby == "") {
		$sortimg= "<img src=\"$sorticon\" onclick=\"window.location.href='system.php?op=users_privatespace&action=$action&onglet=$onglet&letter=$letter&sortby=$what&page=$page&selectgroup=$selectgroup'\">";
	}
	else {
		$sortimg= "";
	}
	return $sortimg;       
}

function usersToExcel() {
	global $prefix, $db, $module_name;
	
	$sql = " SELECT `id` , `name` FROM `".$prefix."_groups` ORDER BY `name` ASC";
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) > 0) {
		set_time_limit(60);
		require_once "modules/$module_name/php_writeexcel/class.writeexcel_workbook.inc.php";
		require_once "modules/$module_name//php_writeexcel/class.writeexcel_worksheet.inc.php";
		$fname = tempnam("/tmp", "Export.xls");
		$workbook = new writeexcel_workbook($fname);
		$entete  =& $workbook->addformat(array(
										font		=> 'Arial',
										bg_color	=> 'silver',
                                        bold    => 1,
                                        color   => 'black',
                                        size    => 12,
                                        merge   => 1,
                                        bold    => 1
                                        ));
        $donnee  =& $workbook->addformat(array(
										font		=> 'Arial',
										bold    => 0,
                                        color   => 'black',
                                        size    => 10,
                                        merge   => 1,
                                        text_h_align => 0,
                                        num_format => '@'
                                        ));
        $titres = array("Nom", "Prnom", "Organisme", "Tlphone", "E-mail", "Pseudo");
		while ($thegroup = $db->sql_fetchrow($result)) {
			$worksheet =& $workbook->addworksheet(substr($thegroup["name"],0,31));
			$worksheet->set_column(0, 5, 30);
			$worksheet->write_row('A1', $titres, $entete);
			$compteur = 2;
			$sql = "SELECT uname, email, user_name, user_firstname, adh_tel, adh_entreprise  from ".$prefix."_users INNER JOIN becms_users_groups ON user_id=uid WHERE group_id='".$thegroup["id"]."' order by user_name;";
			$result2 = $db->sql_query($sql);
			if ($db->sql_numrows($result2) > 0) {
				while ($theuser = $db->sql_fetchrow($result2)) {
					$ligne = array($theuser["user_name"], $theuser["user_firstname"], $theuser["adh_entreprise"], $theuser["adh_tel"], $theuser["email"], $theuser["uname"]);
					$worksheet->write_row('A'.$compteur, $ligne, $donnee);
					$compteur++;
				}
			}
		}
		$workbook->close();
		header("Content-Type: application/x-msexcel; name=\"example-demo.xls\"");
		header('Content-Disposition: inline; filename="Membres '.date("d-m-Y").'.xls"');
		$fh=fopen($fname, "rb");
		fpassthru($fh);
		unlink($fname);
	}
}

function process_members(){
		global $prefix, $db, $language, $multilingual, $Default_Skin, $SkinPath, $onglet,$module_name,$action,$page,$confirm,$valid,$letter,$sortby;
		global $Id, $uid, $uname, $user_name, $user_firstname, $user_town,$email, $user_group, $user_filiere, $user_categorie, $newsletter, $stop, $autre;
		global $groups, $user_tel, $selectgroup;
		global $user_id, $username, $user_name, $user_firstname, $user_email, $user_valid, $groups, $adh_entreprise, $adh_tel,$newpass;
		global $user_language, $user_domain_reg;

		if (!isset($action) || (action == "")) {
			$action = "list_users";
		}
		if (!isset($letter) || ($letter == "")) {
			$letter = "All"; 
		}
		if (!isset($sortby)) {
			$sortby = "";
		}
		if (!isset($page) || $page == "" || $page == 0) {
			$page = 1;
		}
		if (!isset($onglet) || $onglet == "") {
			$onglet = "users_privsp";
		}
		if (!isset($confirm) || $confirm == "") {
			$confirm = "n";
		}
		if (!isset($selectgroup)) {
			$selectgroup = "";
		}
	
		if ($action != "usersToExcel") {
			include("system/header_system.php");
		}
		
		$sortie = "";
		$operationOnglet = "";
		switch ($action) {
			case "list_usersno" :
				$sortie = list_users_priv_sp_no($letter, $sortby, $page, $onglet);
				$operationOnglet = _SNLUSERSLISTOP;
				break;
			case "list_users" :
				$sortie = list_users_priv_sp($letter,$sortby,$page,$onglet, $selectgroup);
				$operationOnglet = _SNLUSERSLISTOP;
				break;
			case "edit_user" :
				$sortie = edit_member_priv_sp($Id,$page,$letter,$onglet,array(),"",$selectgroup);
				$operationOnglet = _SNLUSERSEDITOP;
				break;
			case "edit_user_no":
				$sortie = edit_member_priv_sp_no($Id,$page,$letter,$onglet);
				$operationOnglet = _SNLUSERSEDITOP;
				break;
			case "save_user" :
				if (!isset($groups)) {
					$groups = array();
				}	
				$the_user = array(
				"uid" => $uid,
				"uname" => $uname,
				"user_name" => $user_name,
				"user_firstname" => $user_firstname,
				"email" => $email,
				"adh_entreprise" => $adh_entreprise,
				"adh_tel" => $adh_tel,
				"pass" => $newpass,
				"groups" => $groups
				);
				//print_r ($the_user);
				//die();
				if (save_userpriv_sp($the_user)) {
					$sortie = list_users_priv_sp($letter,$sortby,$page,$onglet, $selectgroup);
					$operationOnglet = _SNLUSERSLISTOP;
				}
				else {
					$sortie = edit_member_priv_sp($uid,$page,$letter,$onglet,$the_user,$stop,$selectgroup);
					$operationOnglet = _SNLUSERSEDITOP;
				}
				break;
			case "save_userno":
				if (!isset($groups)) {
					$groups = array();
				}
				if (!isset($user_valid) || $user_valid == "") {
					$user_valid = 0;
				}
				$the_user = array(
				"user_id" => $user_id,
				"username" => $username,
				"user_name" => $user_name,
				"user_firstname" => $user_firstname,
				"user_email" => $user_email,
				"user_valid" => $user_valid,
				"adh_entreprise" => $adh_entreprise,
				"adh_tel" => $adh_tel,
				"user_password" => $user_password,
				"groups" => $groups,
				"user_language"=>$user_language,
				"user_domain_reg"=> $user_domain_reg
				);
				//print_r ($the_user);
				if (save_userpriv_sp_no($the_user)) {
					$sortie = list_users_priv_sp_no($letter,$sortby,$page,$onglet, $selectgroup);
					$operationOnglet = _SNLUSERSLISTOP;
				}
				else {
					$sortie = edit_member_priv_sp_no($user_id,$page,$letter,$onglet,$the_user,$stop);
					$operationOnglet = _SNLUSERSEDITOP;
				}
				break;	
			case "new_user" :
				$sortie = edit_member_priv_sp("-1",$page,$letter,$onglet);
				$operationOnglet = _SNLUSERSEDITOP;
				break;		
			case "delete_user" :
				$sortie = delete_userpriv_sp($Id,$confirm,$letter,$sortby,$page, $onglet);
				$operationOnglet = _SNLUSERSDELSUSER;
				if ($sortie == "") {
					$sortie = list_users_priv_sp($letter,$sortby,$page,$onglet, $selectgroup);
					$operationOnglet = _SNLUSERSLISTOP;
				}
				break;
			case "delete_userno" :
				$sortie = delete_userprivno_sp($Id,$confirm,$letter,$sortby,$page, $onglet);
				$operationOnglet = _SNLUSERSDELSUSER;
				if ($sortie == "") {
					$sortie = list_users_priv_sp_no($letter,$sortby,$page,$onglet);
					$operationOnglet = _SNLUSERSLISTOP;
				}
				break;
			case "usersToExcel":
				usersToExcel();
				break;
		}
		$ongletDef=array("users_privsp"=> array( "text"=>_SNLUSERSLISTPRIV, "url"=>"system.php?action=list_users&op=users_privatespace&onglet=users_privsp"),
						//"doms"=> array( "text"=>_SMEMBERSDOMAIN, "url"=>"system.php?action=list_dom&op=members&onglet=doms"),
						"users_notvalid"=> array( "text"=>_SNLUSERSLISTPRIVTEMP, "url"=>"system.php?action=list_usersno&op=users_privatespace&onglet=users_notvalid"),
						//"stats"=> array( "text"=>_SMEMBERSSTATS, "url"=>"system.php?action=list_stats&op=members&onglet=stats")
						);

		echo "<link rel=\"StyleSheet\" type=\"text/css\" href=\"modules/".$module_name."/system/stl_users.css\">";
		GraphicAdmin(_SIMPLEUSERPRIVATESP);
		OpenOngletTable();
		displayOngletBar($onglet,$operationOnglet,$ongletDef);
		//OpenSysTable();
		echo $sortie;
		//CloseSysTable();
		CloseOngletTable();
		include("system/footer_system.php");
	}
	
//--------------------------------------------------
//            Switch part
//--------------------------------------------------
	switch($op) {
	    case "users_privatespace":
			process_members();
			break;
	}
}
else {
    display_denied();
}
?>