<?php

if (!preg_match("#system_mobile.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight("SimpleResto")) {
	
	function getCatList() {
		global $db, $prefix;
		
		$catList = array();
		$result = $db->sql_query("select `Id`, `cat_fr`, `desc_fr`, `cat_uk`, `desc_uk`, `cat_de`, `desc_de`, `cat_sp`, `desc_sp`, `cat_it`, `desc_it`, `valide`, `photo`, `position` from ".$prefix."_resto_categorie order by position ASC;");
		while (list($Id, $cat_fr, $desc_fr, $cat_uk, $desc_uk, $cat_de, $desc_de, $cat_sp, $desc_sp, $cat_it, $desc_it, $valide, $photo, $position) = $db->sql_fetchrow($result)) {
			$catList[]= array(
				"Id" => $Id,
				"cat_fr" => $cat_fr,
				"descr_fr" => $desc_fr,
				"cat_uk" => $cat_uk,
				"descr_uk" => $desc_uk,
				"cat_de" => $cat_de,
				"descr_de" => $desc_de,
				"cat_sp" => $cat_sp,
				"descr_sp" => $desc_sp,
				"cat_it" => $cat_it,
				"descr_it" => $desc_it,
				"valide" => $valide,
				"photo" => $photo,
				"position" => $position
			);
		}
		$db->sql_freeresult($result);
		return $catList;
	}
	
	function getCatContent($id) {
		global $db, $prefix;
		
		if ($id =="") {
			return "";
		}
		else {
			$cond = "";
			if ($id !="") {
				$cond .= ($cond == "" ) ? " WHERE " : " AND ";
				$cond .= "Id=$id";
			}
			$result = $db->sql_query("select `Id`, `cat_fr`,`desc_fr`, `cat_uk`, `desc_uk`, `cat_de`, `desc_de`, `cat_sp`, `desc_sp`, `cat_it`, `desc_it`, `position`, `valide`, `photo` from ".$prefix."_resto_categorie $cond;");
			if (list($Id, $cat_fr, $desc_fr, $cat_uk, $desc_uk, $cat_de, $desc_de, $cat_sp, $desc_sp, $cat_it, $desc_it, $position, $valide, $photo) = $db->sql_fetchrow($result)) {
				$sortie = array(
					"Id" => $Id,
					"cat_fr" => $cat_fr,
					"desc_fr" => $desc_fr,
					"cat_uk" => $cat_uk,
					"desc_uk" => $desc_uk,
					"cat_de" => $cat_de,
					"desc_de" => $desc_de,
					"cat_sp" => $cat_sp,
					"desc_sp" => $desc_sp,
					"cat_it" => $cat_it,
					"desc_it" => $desc_it,
					"position" => $position,
					"photo" => $photo,
					"valide" => $valide
				);
			}
			$db->sql_freeresult($result);
			return $sortie;
		}
	}
	
	function getNextCatPosition() {
		global $db, $prefix;
		$result = $db->sql_query("select max(`position`) as current_position from ".$prefix."_resto_categorie;");
		if (list($current_position) = $db->sql_fetchrow($result)) {
			$current_position++;
			return $current_position;
		}
		else {
			die('erreur rcup position cat');
		}
	}
	
	function list_cats() {
		global $username, $language, $admin, $aid, $prefix, $file, $db, $sitename, $user, $currentlang, $page_header_title, $module_name, $header_system;
    
	    $page_header_title = 'Liste des catgories';
	    
	    $header_system .= '
<script>
	var url_up = \'var url = "system_mobile.php?op=swapcatsresto&Id="+id_elt+"&sens=up"\';
	var url_down = \'var url = "system_mobile.php?op=swapcatsresto&Id="+id_elt+"&sens=down"\';
</script>';
	    
	    include ("system/header_system_mobile.php");
	   	
	    $sortie = "";
	    
	    $sortie .= '<div class="marge">';
	    
	    $catcats = array();
	    $catcats[] = array("Id" => "0", "catcat_fr" => "Toutes les catgories");
	    $compteur = -1;
	    foreach ($catcats as $onecatcats) {
	    	$compteur++;
	    	$sortie .= '
<div class="combo"><a href="javascript:void(0)" class="combo" id="btn_content'.$compteur.'">'.$onecatcats["catcat_fr"].'</a>
<div class="ztxt_content" id="ztxt_content-btn_content'.$compteur.'">';
	    	
	    	$listecats= '';
	    	$cats = getCatList();
	    	foreach ($cats as $onecat) {
	    		//$pub = ($oneplat["valide"] == "P") ? "Publi" : "Non publi";
	    		$np = ($onecat["valide"] == "1") ? "" : " np";
	    		//$src_picto = ($oneplat[6] == 1) ? 'themes/System_mobile/images/mobile.png' : 'themes/System_mobile/images/desktop.png';
	    		//$picto = '<img src="'.$src_picto.'" />';
	    		$style_item = '';
	    		if ($onecat["photo"] != "") {
	    			$style_item = ' class="with_photo"';
	    		}
	    		$btn_up = '<img src="themes/System_mobile/images/btn_up.png" class="btn_up" id_elt="'.$onecat["Id"].'" />';
	    		$btn_down = '<img src="themes/System_mobile/images/btn_down.png" class="btn_down" id_elt="'.$onecat["Id"].'"/>';
	    		$listecats .= '<li class="collection-item-combo-doc'.$np.'"><a href="system_mobile.php?op=editcatresto&id='.$onecat["Id"].'"'.$style_item.'><span class="act">'.$onecat["cat_fr"].$btn_up.'<img src="themes/System_mobile/images/space.png" style="width: 5px;" />'.$btn_down.'</span></a></li>';
	    	}
			if ($listecats != '') {
				$sortie .= '<ul class="collection-combo-docs">'.$listecats.'</ul>';
			}
	    	
			$sortie .= '
</div>
</div>';
	    }
	    
	    //$sortie .= '<help><span style="display: inline-block"><img src="themes/System_mobile/images/desktop.png"> page au format desktop</span> <span style="display: inline-block"><img src="themes/System_mobile/images/mobile.png"> page au format mobile</span></help>';
	    
	    $sortie .= '</div>';
    
	    echo $sortie;
	    
	    include ("system/footer_system_mobile.php");
	}
	
	function edit_cat($id) {
		global $username, $language, $admin, $aid, $prefix, $file, $db, $sitename, $user, $currentlang, $page_header_title, $header_system;
		
		$contenu = array();
		$menusections = '';
		if ($id != "") {
			$contenu = getCatContent($id);
		}
		else {
			$contenu= array(
					"Id" => "",
					"cat_fr" => "",
					"desc_fr" => "",
					"cat_uk" => "",
					"desc_uk" => "",
					"cat_de" => "",
					"desc_de" => "",
					"cat_sp" => "",
					"desc_sp" => "",
					"cat_it" => "",
					"desc_it" => "",
					"position" => getNextCatPosition(),
					"photo" => "",
					"valide" => "0"
				);
		}		
		
		$vignette = "";
		if ($contenu["photo"] != "") {
			$vignette = '<img src="'.$contenu["photo"].'" class="width_all hide_nophoto" />';
		}
		$photo = '<input type="file" name="photo[]" class="saisie_text photo_upload show_nophoto" accept="image/*" />';
		$photo .= '<div id="img_vignettes" class="width_all">'.$vignette.'</div>';
		$photo .= '<input type="button" value="Supprimer la photo" name="delphoto" class="saisie_text hide_nophoto" onclick="delete_photo()" />';
		
		
	    $page_header_title = 'dition de catgorie';
	    
	    $header_system .= '
<script src="themes/System_mobile/js/jquery.exif.js"></script>
<script src="themes/System_mobile/js/jquery.canvasResize.js"></script>
<script>
	jQuery(function() {
		jQuery( "#tabs" ).tabs({
			show: { effect: "fade", duration: 500 },
			hide: { effect: "fade", duration: 500 }
		});
		jQuery("input[type=checkbox]").checkboxradio();
	});
</script>
<script>
		jQuery(document).ready(function(){
			var state_upload = ("'.$contenu["photo"].'" == "");
			//console.log(state_upload);
			if (state_upload) {
				//montrer ce qui sert  uploader et masquer le reste
				jQuery(".hide_nophoto").hide();
				jQuery(".show_nophoto").show();
			}
			else {
				//masquer ce qui sert  uploader et montrer le reste
				jQuery(".hide_nophoto").show();
				jQuery(".show_nophoto").hide();
			}
		});
		function delete_photo() {
			if (confirm("En tes-vous sr(e) ?\nLa photo sera immdiatement supprime.")) {
				if (jQuery("#dataId").val() != "") {
					var urldel = "system_mobile.php?op=deletephotocatresto&Id="+jQuery("#dataId").val();
				}
				else {
					if (jQuery("#dataPhoto").val() != "") {
						var urldel = "system_mobile.php?op=deletephotocatresto&photo="+jQuery("#dataPhoto").val();
					}
					else {
						alert("Erreur : il n\'y a aucune image  supprimer !");
					}
				}
				jQuery.ajax(urldel,{
					success: function (msg) {
						if (msg == "ok") {
							jQuery("#dataPhoto").val("");
							jQuery(".hide_nophoto").slideUp(function() {
								jQuery(".show_nophoto").slideDown();
							});
						}
						else {
							alert("Aucune modification effectue !");
						}
					}
				});
			}
		}
		var op_upload_photo = "uploadphotocatresto";
</script>
';
	    
	    include ("system/header_system_mobile.php");
	    	    
	    $sortie = '';
	    
	    $sortie .= '
<form action="system_mobile.php" method="post" class="nomarge">
	<div class="marge">
			<div id="tabs">
				<ul>
					<li><a href="#tabs-1"><img src="themes/System_mobile/images/flags/flags_iso/32/fr.png" width="32" /></a></li>
					<li><a href="#tabs-2"><img src="themes/System_mobile/images/flags/flags_iso/32/gb.png" width="32" /></a></li>
					<li><a href="#tabs-3"><img src="themes/System_mobile/images/flags/flags_iso/32/it.png" width="32" /></a></li>
					<li><a href="#tabs-4"><img src="themes/System_mobile/images/flags/flags_iso/32/de.png" width="32" /></a></li>
					<li><a href="#tabs-5"><img src="themes/System_mobile/images/flags/flags_iso/32/es.png" width="32" /></a></li>
				</ul>
				<div id="tabs-1">
					Catgorie franais : <input type="text" name="data[cat_fr]" value="'.str_replace('"', "&quot;", $contenu["cat_fr"]).'" class="saisie_text" />
					Description franais : <textarea name="data[desc_fr]" rows="4" class="saisie_text" >'.$contenu["desc_fr"].'</textarea>
				</div>
				<div id="tabs-2">
					Catgorie anglais : <input type="text" name="data[cat_uk]" value="'.str_replace('"', "&quot;", $contenu["cat_uk"]).'" class="saisie_text" />
					Description anglais : <textarea name="data[desc_uk]" rows="4" class="saisie_text" >'.$contenu["desc_uk"].'</textarea>
				</div>
				<div id="tabs-3">
					Catgorie italien : <input type="text" name="data[cat_it]" value="'.str_replace('"', "&quot;", $contenu["cat_it"]).'" class="saisie_text" />
					Description italien : <textarea name="data[desc_it]" rows="4" class="saisie_text" >'.$contenu["desc_it"].'</textarea>
				</div>
				<div id="tabs-4">
					Catgorie allemand : <input type="text" name="data[cat_de]" value="'.str_replace('"', "&quot;", $contenu["cat_de"]).'" class="saisie_text" />
					Description allemand : <textarea name="data[desc_de]" rows="4" class="saisie_text" >'.$contenu["desc_de"].'</textarea>
				</div>
				<div id="tabs-5">
					Catgorie espagnol : <input type="text" name="data[cat_sp]" value="'.str_replace('"', "&quot;", $contenu["cat_sp"]).'" class="saisie_text" />
					Description espagnol : <textarea name="data[desc_sp]" rows="4" class="saisie_text" >'.$contenu["desc_sp"].'</textarea>
				</div>
			</div>
		</div>
	<div class="marge">
		Publication : <br />
		<div class="width_300"><input type="checkbox" value="1" name="data[valide]"'.(($contenu["valide"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="publiaccomp" /><label for="publiaccomp">Catgorie publie</label></div>
	</div>
	<div class="marge">
		Photo : '.$photo.'
	</div>
	<div class="marge"><input type="submit" value="Enregistrer la catgorie" class="saisie_text submit" name="valid"></div>
	<input type="hidden" name="op" value="savecatresto" />
	<input type="hidden" name="data[Id]" value="'.$contenu["Id"].'" id="dataId" />
	<input type="hidden" name="data[position]" value="'.$contenu["position"].'" />
	<input type="hidden" name="data[photo]" value="'.$contenu["photo"].'" id="dataPhoto" />
</form>';

	    
	    echo $sortie;
	    
	    include ("system/footer_system_mobile.php");
	}
	
	function edit_cat_old($id) {
		global $username, $language, $admin, $aid, $prefix, $file, $db, $sitename, $user, $currentlang, $page_header_title, $header_system;
	
		$header_system .= '
		<script>
		jQuery(function() {
		jQuery( "#tabs" ).tabs({
		show: { effect: "fade", duration: 500 },
		hide: { effect: "fade", duration: 500 }
	});
	});
	</script>
	';
	
		$contenu = array();
		$menusections = '';
		if ($id != "") {
			$contenu = getCatContent($id);
		}
		else {
			$contenu= array(
					"Id" => "",
					"cat_fr" => "",
					"cat_uk" => "",
					"cat_de" => "",
					"cat_sp" => "",
					"cat_it" => "",
					"position" => getNextCatPosition(),
					"valide" => "0"
			);
		}
		$page_header_title = 'dition de catgorie';
		 
		include ("system/header_system_mobile.php");
	
		$sortie = '';
		 
		$sortie .= '
		<form action="system_mobile.php" method="post" class="nomarge">
		<div class="marge">
		<div id="tabs">
		<ul>
		<li><a href="#tabs-1"><img src="themes/System_mobile/images/flags/flags_iso/32/fr.png" width="32" /></a></li>
		<li><a href="#tabs-2"><img src="themes/System_mobile/images/flags/flags_iso/32/gb.png" width="32" /></a></li>
		<li><a href="#tabs-3"><img src="themes/System_mobile/images/flags/flags_iso/32/it.png" width="32" /></a></li>
		<li><a href="#tabs-4"><img src="themes/System_mobile/images/flags/flags_iso/32/de.png" width="32" /></a></li>
		<li><a href="#tabs-5"><img src="themes/System_mobile/images/flags/flags_iso/32/es.png" width="32" /></a></li>
		</ul>
		<div id="tabs-1">
		Catgorie franais : <input type="text" name="data[cat_fr]" value="'.str_replace('"', "&quot;", $contenu["cat_fr"]).'" class="saisie_text" />
		</div>
		<div id="tabs-2">
		Catgorie anglais : <input type="text" name="data[cat_uk]" value="'.str_replace('"', "&quot;", $contenu["cat_uk"]).'" class="saisie_text" />
		</div>
		<div id="tabs-3">
		Catgorie italien : <input type="text" name="data[cat_it]" value="'.str_replace('"', "&quot;", $contenu["cat_it"]).'" class="saisie_text" />
		</div>
		<div id="tabs-4">
		Catgorie allemand : <input type="text" name="data[cat_de]" value="'.str_replace('"', "&quot;", $contenu["cat_de"]).'" class="saisie_text" />
		</div>
		<div id="tabs-5">
		Catgorie espagnol : <input type="text" name="data[cat_sp]" value="'.str_replace('"', "&quot;", $contenu["cat_sp"]).'" class="saisie_text" />
		</div>
		</div>
		</div>
		<div class="marge">
		Publie : <input type="checkbox" value="1" name="data[valide]"'.(($contenu["valide"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" />
		</div>
		<div class="marge"><input type="submit" value="Enregistrer la catgorie" class="saisie_text submit" name="valid"></div>
		<input type="hidden" name="op" value="savecatresto" />
		<input type="hidden" name="data[Id]" value="'.$contenu["Id"].'" />
		<input type="hidden" name="data[position]" value="'.$contenu["position"].'" />
		</form>';
	
		 
		echo $sortie;
		 
		include ("system/footer_system_mobile.php");
	}
	
	function save_cat($cat) {
		global $page_header_title, $header_system;
		global $prefix, $db ;
		$cat = array_map("FixQuotes", $cat);
		$cat = array_map("stripslashes", $cat);
	
		$cat["valide"] = ($cat["valide"] == "1") ? "1" : "0";
		
	    if ($cat["Id"] != "") {
	    	$contenu = getCatContent($cat["Id"]);
	    	$cat["position"] = $contenu["position"];
	    	
		    $sql = "UPDATE ".$prefix."_resto_categorie";
		    $sql .= " SET cat_fr='".$cat["cat_fr"]."', cat_uk='".$cat["cat_uk"]."', cat_de='".$cat["cat_de"]."', cat_sp='".$cat["cat_sp"]."', cat_it='".$cat["cat_it"]."', position='".$cat["position"]."', valide='".$cat["valide"]."'";
		    $sql .= ", desc_fr='".$cat["desc_fr"]."', desc_uk='".$cat["desc_uk"]."', desc_de='".$cat["desc_de"]."', desc_sp='".$cat["desc_sp"]."', desc_it='".$cat["desc_it"]."'";
		    $sql .= " WHERE Id = ".$cat["Id"]."";
			$result=$db->sql_query($sql);
			if (!$result) {
				$error = $db->sql_error();
				die('Invalid query:'.$error["message"]);
			}
	    }
	    else {
	    	$cat["position"] = getNextCatPosition(); //au cas o une nouvelle catgorie aurait t cre avant que celle-ci ne soit enregistre.
	    	
	    	$sql = "INSERT INTO ".$prefix."_resto_categorie";
		    $sql .= " (cat_fr, desc_fr, cat_uk, desc_uk, cat_de, desc_de, cat_sp, desc_sp, cat_it, desc_it, position, photo, valide)";
		    $sql .= "VALUES ('".$cat["cat_fr"]."','".$cat["desc_fr"]."','".$cat["cat_uk"]."','".$cat["desc_uk"]."','".$cat["cat_de"]."','".$cat["desc_de"]."','".$cat["cat_sp"]."', '".$cat["desc_sp"]."','".$cat["cat_it"]."', '".$cat["desc_it"]."','".$cat["position"]."', '".$cat["photo"]."', '".$cat["valide"]."');"; 
	    	$result=$db->sql_query($sql);
			if (!$result) {
				$error = $db->sql_error();
				die('Invalid query:'.$error["message"]);
			}
	    }
		
		$header_system .= '
		<script>
			allerPage("system_mobile.php?op=listcatresto",2000);
		</script>';
		
		$page_header_title = 'Enregistrement de catgorie';
		include ("system/header_system_mobile.php");
		
		//enregistrement dans la base de donnes  faire
		
		$sortie = '<alert class="center_v_abs">Catgorie enregistre</alert>';

		echo $sortie;
		include ("system/footer_system_mobile.php");
	}
	
	function swap_cats($Id, $sens) {
		global $prefix, $db;
		
		$onecat = getCatContent($Id);
		
		$where = " WHERE false ";
		switch ($sens) {
			case "up":
				$where = " WHERE `position` <= ".$onecat["position"]." ORDER BY `position` DESC limit 2";
				break;
			case "down":
				$where = " WHERE `position` >= ".$onecat["position"]." ORDER BY `position` ASC limit 2";
				break;
		}
		
		$ok = true;
		
		$sql = "SELECT Id, `position` FROM ".$prefix."_resto_categorie".$where.";";
//echo $sql;
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) == 2) {
			list($Id_init, $position_init) = $db->sql_fetchrow($result);
			list($Id_new, $position_new) = $db->sql_fetchrow($result);
			$sql = "UPDATE ".$prefix."_resto_categorie";
			$sql .= " SET position='".$position_new."'";
			$sql .= " WHERE Id = ".$Id_init.";";
//echo "\n".$sql;
			$ok = $ok && $db->sql_query($sql);
			$sql = "UPDATE ".$prefix."_resto_categorie";
			$sql .= " SET position='".$position_init."'";
			$sql .= " WHERE Id = ".$Id_new.";";
//echo "\n".$sql;
			$ok = $ok && $db->sql_query($sql);
			if ($ok) {
				echo "ok";
			}
			else {
				echo "pas ok";
			}
			die();
		}
		else {
			echo "pas ok du tout";
			die();
		}
	}

	function getPlatList($catid, $formid = ""){
		global $db, $prefix, $multilingual;
		
		$platList = array();
		$cond = "";
		$join = "";
		if ($catid !="") {
			$cond .= ($cond == "" ) ? " WHERE " : " AND ";
			$cond .= "catid=$catid";
		}
		if ($formid !="") {
			$cond .= ($cond == "" ) ? " WHERE " : " AND ";
			$cond .= "id_formule=$formid";
			$join = " inner join ".$prefix."_resto_link_plat_formule on ".$prefix."_resto_link_plat_formule.id_plat=".$prefix."_resto_plat.Id ";
		}

		$sql = "select ".$prefix."_resto_plat.`Id`, ".$prefix."_resto_plat.`position`, `catid`, `nom_fr`, `com_fr`, `desc_fr`, `nom_uk`, `com_uk`, `desc_uk`, `nom_de`, `com_de`, `desc_de`, `nom_sp`, `com_sp`, `desc_sp`, `nom_it`, `com_it`, `desc_it`, `gluten`, `crustace`, `oeuf`, `poisson`, `arachide`, `soja`, `lait`, `fruitacoque`, `celeri`, `moutarde`, `sesame`, `sulfite`, `lupin`, `mollusque`,".$prefix."_resto_plat.`prix`, ".$prefix."_resto_plat.`photo`, ".$prefix."_resto_plat.`valide`";
		$sql .= " from ".$prefix."_resto_plat";
		$sql .= " $join";
		$sql .= " $cond  order by `position` ASC, `nom_fr`ASC;";
		
		$result = $db->sql_query($sql);

		while ($ligne = $db->sql_fetchrow($result)) {
			$platList[]= array(
				"Id" => $ligne["Id"],
				"position" => $ligne["position"],
				"catid" => $ligne["catid"],
				"nom_fr" => $ligne["nom_fr"],
				"com_fr" => $ligne["com_fr"],
				"desc_fr" => $ligne["desc_fr"],
				"nom_uk" => $ligne["nom_uk"],
				"com_uk" => $ligne["com_uk"],
				"desc_uk" => $ligne["desc_uk"],
				"nom_de" => $ligne["nom_de"],
				"com_de" => $ligne["com_de"],
				"desc_de" => $ligne["desc_de"],
				"nom_sp" => $ligne["nom_sp"],
				"com_sp" => $ligne["com_sp"],
				"desc_sp" => $ligne["desc_sp"],
				"nom_it" => $ligne["nom_it"],
				"com_it" => $ligne["com_it"],
				"desc_it" => $ligne["desc_it"],
				"gluten" => $ligne["gluten"],
				"crustace" => $ligne["crustace"],
				"oeuf" => $ligne["oeuf"],
				"poisson" => $ligne["poisson"],
				"arachide" => $ligne["arachide"],
				"soja" => $ligne["soja"],
				"lait" => $ligne["lait"],
				"fruitacoque" => $ligne["fruitacoque"],
				"celeri" => $ligne["celeri"],
				"moutarde" => $ligne["moutarde"],
				"sesame" => $ligne["sesame"],
				"sulfite" => $ligne["sulfite"],
				"lupin" => $ligne["lupin"],
				"mollusque" => $ligne["mollusque"],
				"prix" => $ligne["prix"],
				"photo" => $ligne["photo"],
				"valide" => $ligne["valide"]
			);
		}
		$db->sql_freeresult($result);
		return $platList;
	}
		
	function date2JMA($ladate, $formatdate="d/m/Y H:i:s"){
		if ($ladate == "0000-00-00 00:00:00" || $ladate == "0000-00-00" || $ladate == "") {
			return "";
		}
		else {
			list($lejour,$lemoment) = explode(" ",$ladate);
			list($an,$mois,$jour) = explode("-",$lejour);
			if ($lemoment != "") {
				list($heure, $minute,$seconde) = explode(":", $lemoment);
			}
			else {
				list($heure, $minute,$seconde) = array(0,0,0);
			}
			$ladate = date($formatdate, mktime($heure, $minute,$seconde, $mois,$jour,$an));
			return $ladate;
		}
	}
	
	function list_plats() {
		global $username, $language, $admin, $aid, $prefix, $file, $db, $sitename, $user, $currentlang, $page_header_title, $module_name, $header_system;
    
	    $page_header_title = 'Liste des plats';
	    
	    $header_system .= '
<script>
	var url_up = \'var url = "system_mobile.php?op=swapplatsresto&Id="+id_elt+"&sens=up"\';
	var url_down = \'var url = "system_mobile.php?op=swapplatsresto&Id="+id_elt+"&sens=down"\';
</script>';
	    
	    include ("system/header_system_mobile.php");
	   	
	    $sortie = "";
	    
	    $sortie .= '<div class="marge">';
	    
	    $categories = getCatList();
	    //$categories[] = array("Id" => "0", "cat_fr" => "Plats sans catgorie");
	    $compteur = -1;
	    foreach ($categories as $onecategorie) {
	    	$compteur++;
	    	$stlplus = ($onecategorie["valide"]) ? "" : " nopub" ;
	    	$sortie .= '
<div class="combo"><a href="javascript:void(0)" class="combo'.$stlplus.'" id="btn_content'.$compteur.'">'.$onecategorie["cat_fr"].'</a>
<div class="ztxt_content" id="ztxt_content-btn_content'.$compteur.'">';
	    	
	    	$listeplats= '';
	    	$plats = getPlatList($onecategorie["Id"]);
	    	foreach ($plats as $oneplat) {
	    		$pub = ($oneplat["valide"] == "1") ? "Publi" : "Non publi";
	    		$np = ($oneplat["valide"] == "1") ? "" : " np";
    		
	    		$with_allergo = ($oneplat["gluten"] == "1") || ($oneplat["crustace"] == "1") || ($oneplat["oeuf"] == "1") || ($oneplat["poisson"] == "1") || ($oneplat["arachide"] == "1") || ($oneplat["soja"] == "1") || ($oneplat["lait"] == "1") || ($oneplat["fruitacoque"] == "1") || ($oneplat["celeri"] == "1") || ($oneplat["moutarde"] == "1") || ($oneplat["sesame"] == "1") || ($oneplat["sulfite"] == "1") || ($oneplat["lupin"] == "1") || ($oneplat["mollusque"] =="1");
	    		$allergisants = ($with_allergo) ? " - avec allergisants" : "";
	    		
	    		$prix = " - ".number_format($oneplat["prix"],2,',',' ')." &euro;";
	    		
	    		//$src_picto = ($oneplat[6] == 1) ? 'themes/System_mobile/images/mobile.png' : 'themes/System_mobile/images/desktop.png';
	    		//$picto = '<img src="'.$src_picto.'" />';
	    		$style_item = '';
	    		if ($oneplat["photo"] != "") {
	    			$style_item = ' class="with_photo"';
	    		}
	    		$btn_up = '<img src="themes/System_mobile/images/btn_up.png" class="btn_up" id_elt="'.$oneplat["Id"].'" />';
	    		$btn_down = '<img src="themes/System_mobile/images/btn_down.png" class="btn_down" id_elt="'.$oneplat["Id"].'"/>';
	    		//$listeplats .= '<li class="collection-item-combo-doc'.$np.'"><a href="system_mobile.php?op=editplatresto&id='.$oneplat["Id"].'"><span class="act">'.$oneplat["nom_fr"].$btn_up.'<img src="themes/System_mobile/images/space.png" style="width: 5px;" />'.$btn_down.'</span><span class="infos">'.$pub.$allergisants.$prix.'</span></a></li>';
	    		$listeplats .= '<li class="collection-item-combo-doc'.$np.'"><a href="system_mobile.php?op=editplatresto&id='.$oneplat["Id"].'"'.$style_item.'>'.$oneplat["nom_fr"].'<span class="infos">'.$pub.$allergisants.$prix.$btn_up.'<img src="themes/System_mobile/images/space.png" style="width: 5px;" />'.$btn_down.'</span></a></li>';
	    	}
			if ($listeplats != '') {
				$sortie .= '<ul class="collection-combo-docs">'.$listeplats.'</ul>';
			}
			$sortie .= '<div class="btn_extra"><a href="system_mobile.php?op=newplatresto">+</a></div>';
	    	
			$sortie .= '
</div>
</div>';
	    }
	    
	    //$sortie .= '<help><span style="display: inline-block"><img src="themes/System_mobile/images/desktop.png"> page au format desktop</span> <span style="display: inline-block"><img src="themes/System_mobile/images/mobile.png"> page au format mobile</span></help>';
	    
	    $sortie .= '</div>';
    
	    echo $sortie;
	    
	    include ("system/footer_system_mobile.php");
	}
	
	function getPlatContent($id){
		global $db,$prefix;
		
		if ($id =="") {
			return "";
		}
		else {
			$cond = "";
			if ($id !="") {
				$cond .= ($cond == "" ) ? " WHERE " : " AND ";
				$cond .= "Id=$id";
			}
			
			$result = $db->sql_query("select `Id`, `position`, `catid`, `nom_fr`, `com_fr`, `desc_fr`, `nom_uk`, `com_uk`, `desc_uk`, `nom_de`, `com_de`, `desc_de`, `nom_sp`, `com_sp`, `desc_sp`, `nom_it`, `com_it`, `desc_it`, `gluten`, `crustace`, `oeuf`, `poisson`, `arachide`, `soja`, `lait`, `fruitacoque`, `celeri`, `moutarde`, `sesame`, `sulfite`, `lupin`, `mollusque`, `prix`, `photo`, `valide` from ".$prefix."_resto_plat  $cond");
			if ($ligne = $db->sql_fetchrow($result)) {
				$sortie= array(
					"Id" => $ligne["Id"],
					"position" => $ligne["position"],
					"catid" => $ligne["catid"],
					"nom_fr" => $ligne["nom_fr"],
					"com_fr" => $ligne["com_fr"],
					"desc_fr" => $ligne["desc_fr"],
					"nom_uk" => $ligne["nom_uk"],
					"com_uk" => $ligne["com_uk"],
					"desc_uk" => $ligne["desc_uk"],
					"nom_de" => $ligne["nom_de"],
					"com_de" => $ligne["com_de"],
					"desc_de" => $ligne["desc_de"],
					"nom_sp" => $ligne["nom_sp"],
					"com_sp" => $ligne["com_sp"],
					"desc_sp" => $ligne["desc_sp"],
					"nom_it" => $ligne["nom_it"],
					"com_it" => $ligne["com_it"],
					"desc_it" => $ligne["desc_it"],
					"gluten" => $ligne["gluten"],
					"crustace" => $ligne["crustace"],
					"oeuf" => $ligne["oeuf"],
					"poisson" => $ligne["poisson"],
					"arachide" => $ligne["arachide"],
					"soja" => $ligne["soja"],
					"lait" => $ligne["lait"],
					"fruitacoque" => $ligne["fruitacoque"],
					"celeri" => $ligne["celeri"],
					"moutarde" => $ligne["moutarde"],
					"sesame" => $ligne["sesame"],
					"sulfite" => $ligne["sulfite"],
					"lupin" => $ligne["lupin"],
					"mollusque" => $ligne["mollusque"],
					"prix" => $ligne["prix"],
					"photo" => $ligne["photo"],
					"valide" => $ligne["valide"]
				);
			}
			$db->sql_freeresult($result);
			return $sortie; 
		}
	}
	
	function getNextPlatPosition() {
		global $db, $prefix;
		$result = $db->sql_query("select max(`position`) as current_position from ".$prefix."_resto_plat;");
		if (list($current_position) = $db->sql_fetchrow($result)) {
			$current_position++;
			return $current_position;
		}
		else {
			die('erreur rcup position plat');
		}
	}

	function edit_plat($id, $next="bycats") {
		global $username, $language, $admin, $aid, $prefix, $file, $db, $sitename, $user, $currentlang, $page_header_title, $header_system;
		
		$contenu = array();
		$menusections = '';
		if ($id != "") {
			$contenu = getPlatContent($id);
			$accomps = getAccompList($contenu["catid"], true);
			$accomps_plat = getAccompListPlat($id);
			$forms =getFormList();
			$forms_plat = getFormListPlat($id);
		}
		else {
			$contenu= array(
					"Id" => "",
					"position" => getNextPlatPosition(),
					"catid" => 0,
					"nom_fr" => "",
					"com_fr" => "",
					"desc_fr" => "",
					"nom_uk" => "",
					"com_uk" => "",
					"desc_uk" => "",
					"nom_de" => "",
					"com_de" => "",
					"desc_de" => "",
					"nom_sp" => "",
					"com_sp" => "",
					"desc_sp" => "",
					"nom_it" => "",
					"com_it" => "",
					"desc_it" => "",
					"gluten" => "0",
					"crustace" => "0",
					"oeuf" => "0",
					"poisson" => "0",
					"arachide" => "0",
					"soja" => "0",
					"lait" => "0",
					"fruitacoque" => "0",
					"celeri" => "0",
					"moutarde" => "0",
					"sesame" => "0",
					"sulfite" => "0",
					"lupin" => "0",
					"mollusque" => "0",
					"prix" => "0.00",
					"photo" => "",
					"valide" => "0"
			);
			$accomps = getAccompList();
			$accomps_plat = array();
			$forms =getFormList();
			$forms_plat =array();
		}
		
		$cats = getCatList();
		$menucats = '<select name="data[catid]" class="saisie_text">';
		foreach($cats as $cat) {
			$selected = ($cat["Id"] == $contenu["catid"]) ? ' selected="selected"' : '';
			$menucats .= '<option value="'.$cat["Id"].'"'.$selected.'>'.$cat["cat_fr"].'</option>';
		}
		$menucats .= '</select>';		
		$accompagnements = "";
		$accompstab = array();
		foreach ($accomps_plat as $oneaccomp) {
			$accompstab[] = $oneaccomp["id_accompagnement"];
		}
		foreach ($accomps as $oneaccomp) {
			$accompagnements .= '<div class="width_250"><input type="checkbox" value="'.$oneaccomp["Id"].'" name="data[accomp][]"'.((in_array($oneaccomp["Id"], $accompstab)) ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="accomp_'.$oneaccomp["Id"].'" /><label for="accomp_'.$oneaccomp["Id"].'">'.$oneaccomp["nom_fr"].'</label></div>';
		}
		if ($accompagnements != "") {
			$accompagnements = '<div class="marge">Supplments :<br />'.$accompagnements.'</div>';
		}
		$formules = "";
		$formstab =array ();
		foreach ($forms_plat as $oneform) {
			$formstab[] = $oneform["id_formule"];
		}
		foreach ($forms as $oneform) {
			$formules .= '<div class="width_250"><input type="checkbox" value="'.$oneform["Id"].'" name="data[form][]"'.((in_array($oneform["Id"], $formstab)) ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="form_'.$oneform["Id"].'" /><label for="form_'.$oneform["Id"].'">'.$oneform["form_fr"].'</label></div>';
		}
		if ($formules != "") {
			$formules = '<div class="marge">Formules :<br />'.$formules.'</div>';
		}
		
		$vignette = "";
		if ($contenu["photo"] != "") {
			$vignette = '<img src="'.$contenu["photo"].'" class="width_all hide_nophoto" />';
		}
		$photo = '<input type="file" name="photo[]" class="saisie_text photo_upload show_nophoto" accept="image/*" />';
		$photo .= '<div id="img_vignettes" class="width_all">'.$vignette.'</div>';
		$photo .= '<input type="button" value="Supprimer la photo" name="delphoto" class="saisie_text hide_nophoto" onclick="delete_photo()" />';
		
		$page_header_title = 'dition de plat';
		
		$header_system .= '
		<script src="themes/System_mobile/js/jquery.exif.js"></script>
		<script src="themes/System_mobile/js/jquery.canvasResize.js"></script>
		<script>
		jQuery(function() {
			jQuery( "#tabs" ).tabs({
				show: { effect: "fade", duration: 500 },
				hide: { effect: "fade", duration: 500 }
			});
			jQuery("input[type=checkbox]").checkboxradio();
		});
		</script>
		<script>
		jQuery(document).ready(function(){
			var state_upload = ("'.$contenu["photo"].'" == "");
			//console.log(state_upload);
			if (state_upload) {
				//montrer ce qui sert  uploader et masquer le reste
				jQuery(".hide_nophoto").hide();
				jQuery(".show_nophoto").show();
			}
			else {
				//masquer ce qui sert  uploader et montrer le reste
				jQuery(".hide_nophoto").show();
				jQuery(".show_nophoto").hide();
			}
		});
		function delete_photo() {
			if (confirm("En tes-vous sr(e) ?\nLa photo sera immdiatement supprime.")) {
				if (jQuery("#dataId").val() != "") {
					var urldel = "system_mobile.php?op=deletephotoplatresto&Id="+jQuery("#dataId").val();
				}
				else {
					if (jQuery("#dataPhoto").val() != "") {
						var urldel = "system_mobile.php?op=deletephotoplatresto&photo="+jQuery("#dataPhoto").val();
					}
					else {
						alert("Erreur : il n\'y a aucune image  supprimer !");
					}
				}
				jQuery.ajax(urldel,{
					success: function (msg) {
						if (msg == "ok") {
							jQuery("#dataPhoto").val("");
							jQuery(".hide_nophoto").slideUp(function() {
								jQuery(".show_nophoto").slideDown();
							});
						}
						else {
							alert("Aucune modification effectue !");
						}
					}
				});
			}
		}
		var op_upload_photo = "uploadphotoplatresto";
		</script>
		';
		 
		include ("system/header_system_mobile.php");
		
		$sortie = '';
		 
		$sortie .= '
	<form action="system_mobile.php" method="post" class="nomarge">
		<div class="marge">
			<div id="tabs">
				<ul>
					<li><a href="#tabs-1"><img src="themes/System_mobile/images/flags/flags_iso/32/fr.png" width="32" /></a></li>
					<li><a href="#tabs-2"><img src="themes/System_mobile/images/flags/flags_iso/32/gb.png" width="32" /></a></li>
					<li><a href="#tabs-3"><img src="themes/System_mobile/images/flags/flags_iso/32/it.png" width="32" /></a></li>
					<li><a href="#tabs-4"><img src="themes/System_mobile/images/flags/flags_iso/32/de.png" width="32" /></a></li>
					<li><a href="#tabs-5"><img src="themes/System_mobile/images/flags/flags_iso/32/es.png" width="32" /></a></li>
				</ul>
				<div id="tabs-1">
					Nom franais : <input type="text" name="data[nom_fr]" value="'.str_replace('"', "&quot;", $contenu["nom_fr"]).'" class="saisie_text" />
					Description franais : <textarea name="data[com_fr]" rows="4" class="saisie_text" >'.$contenu["com_fr"].'</textarea>
					Description longue franais : <textarea name="data[desc_fr]" rows="4" class="saisie_text" >'.$contenu["desc_fr"].'</textarea>
				</div>
				<div id="tabs-2">
					Nom anglais : <input type="text" name="data[nom_uk]" value="'.str_replace('"', "&quot;", $contenu["nom_uk"]).'" class="saisie_text" />
					Description anglais : <textarea name="data[com_uk]" rows="4" class="saisie_text" >'.$contenu["com_uk"].'</textarea>
					Description longue anglais : <textarea name="data[desc_uk]" rows="4" class="saisie_text" >'.$contenu["desc_uk"].'</textarea>
				</div>
				<div id="tabs-3">
					Nom italien : <input type="text" name="data[nom_it]" value="'.str_replace('"', "&quot;", $contenu["nom_it"]).'" class="saisie_text" />
					Description italien : <textarea name="data[com_it]" rows="4" class="saisie_text" >'.$contenu["com_it"].'</textarea>
					Description longue italien : <textarea name="data[desc_it]" rows="4" class="saisie_text" >'.$contenu["desc_it"].'</textarea>
				</div>
				<div id="tabs-4">
					Nom allemand : <input type="text" name="data[nom_de]" value="'.str_replace('"', "&quot;", $contenu["nom_de"]).'" class="saisie_text" />
					Description allemand : <textarea name="data[com_de]" rows="4" class="saisie_text" >'.$contenu["com_de"].'</textarea>
					Description longue allemand : <textarea name="data[desc_de]" rows="4" class="saisie_text" >'.$contenu["desc_de"].'</textarea>
				</div>
				<div id="tabs-5">
					Nom espagnol : <input type="text" name="data[nom_sp]" value="'.str_replace('"', "&quot;", $contenu["nom_sp"]).'" class="saisie_text" />
					Description espagnol : <textarea name="data[com_sp]" rows="4" class="saisie_text" >'.$contenu["com_sp"].'</textarea>
					Description longue espagnol : <textarea name="data[desc_sp]" rows="4" class="saisie_text" >'.$contenu["desc_sp"].'</textarea>
				</div>
			</div>
		</div>
		<div class="marge">
		Catgorie : '.$menucats.'
		
		Tarif &euro; : <input type="number" min="0.00" step="0.01" max="9999.99" name="data[prix]" value="'.str_replace('"', "&quot;", $contenu["prix"]).'" class="saisie_text" />
		
		</div>
		'.$accompagnements.'
		'.$formules.'
		<div class="marge">
		Allergnes : <br />
		<div class="width_150"><input type="checkbox" value="1" name="data[gluten]"'.(($contenu["gluten"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="gluten" /><label for="gluten">Gluten</label></div>'.
		'<div class="width_150"><input type="checkbox" value="1" name="data[crustace]"'.(($contenu["crustace"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="crustace" /><label for="crustace">Crustac</label></div>'.
		'<div class="width_150"><input type="checkbox" value="1" name="data[oeuf]"'.(($contenu["oeuf"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="oeuf" /><label for="oeuf">Oeuf</label></div>'.
		'<div class="width_150"><input type="checkbox" value="1" name="data[poisson]"'.(($contenu["poisson"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="poisson" /><label for="poisson">Poisson</label></div>'.
		'<div class="width_150"><input type="checkbox" value="1" name="data[arachide]"'.(($contenu["arachide"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="arachide" /><label for="arachide">Arachide</label></div>'.
		'<div class="width_150"><input type="checkbox" value="1" name="data[soja]"'.(($contenu["soja"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="soja" /><label for="soja">Soja</label></div>'.
		'<div class="width_150"><input type="checkbox" value="1" name="data[lait]"'.(($contenu["lait"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="lait" /><label for="lait">Lait</label></div>'.
		'<div class="width_150"><input type="checkbox" value="1" name="data[fruitacoque]"'.(($contenu["fruitacoque"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="fruitacoque" /><label for="fruitacoque">Fuit  coque</label></div>'.
		'<div class="width_150"><input type="checkbox" value="1" name="data[celeri]"'.(($contenu["celeri"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="celeri" /><label for="celeri">Cleri</label></div>'.
		'<div class="width_150"><input type="checkbox" value="1" name="data[moutarde]"'.(($contenu["moutarde"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="moutarde" /><label for="moutarde">Moutarde</label></div>'.
		'<div class="width_150"><input type="checkbox" value="1" name="data[sesame]"'.(($contenu["sesame"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="sesame" /><label for="sesame">Ssame</label></div>'.
		'<div class="width_150"><input type="checkbox" value="1" name="data[sulfite]"'.(($contenu["sulfite"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="sulfite" /><label for="sulfite">Sulfite</label></div>'.
		'<div class="width_150"><input type="checkbox" value="1" name="data[lupin]"'.(($contenu["lupin"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="lupin" /><label for="lupin">Lupin</label></div>'.
		'<div class="width_150"><input type="checkbox" value="1" name="data[mollusque]"'.(($contenu["mollusque"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="mollusque" /><label for="mollusque">Mollusque</label></div>
		</div>
		<div class="marge">
			Publication : <br />
			<div class="width_150"><input type="checkbox" value="1" name="data[valide]"'.(($contenu["valide"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="publiplat" /><label for="publiplat">Plat publi</label></div>
		</div>
		<div class="marge">
		Photo : '.$photo.'
		</div>
		<div class="marge"><input type="submit" value="Enregistrer le plat" class="saisie_text submit" name="valid"></div>
		<input type="hidden" name="op" value="saveplatresto" />
		<input type="hidden" name="next" value="'.$next.'" />
		<input type="hidden" name="data[Id]" value="'.$contenu["Id"].'" id="dataId" />
		<input type="hidden" name="data[position]" value="'.$contenu["position"].'" />
		<input type="hidden" name="data[photo]" value="'.$contenu["photo"].'" id="dataPhoto" />
	</form>';
		
		 
		echo $sortie;
		 
		include ("system/footer_system_mobile.php");
	}
	
	function edit_plat_old($id) {
		global $username, $language, $admin, $aid, $prefix, $file, $db, $sitename, $user, $currentlang, $page_header_title, $header_system;
	
		$header_system .= '
		<script>
		jQuery(function() {
		jQuery( "#tabs" ).tabs({
		show: { effect: "fade", duration: 500 },
		hide: { effect: "fade", duration: 500 }
	});
	});
	</script>
	';
	
		$contenu = array();
		$menusections = '';
		if ($id != "") {
			$contenu = getPlatContent($id);
		}
		else {
			$contenu= array(
					"Id" => "",
					"position" => getNextPlatPosition(),
					"catid" => 0,
					"nom_fr" => "",
					"com_fr" => "",
					"nom_uk" => "",
					"com_uk" => "",
					"nom_de" => "",
					"com_de" => "",
					"nom_sp" => "",
					"com_sp" => "",
					"nom_it" => "",
					"com_it" => "",
					"gluten" => "0",
					"crustace" => "0",
					"oeuf" => "0",
					"poisson" => "0",
					"arachide" => "0",
					"soja" => "0",
					"lait" => "0",
					"fruitacoque" => "0",
					"celeri" => "0",
					"moutarde" => "0",
					"sesame" => "0",
					"sulfite" => "0",
					"lupin" => "0",
					"mollusque" => "0",
					"prix" => "0.00",
					"photo" => "",
					"valide" => "0"
			);
		}
	
		$cats = getCatList();
		$menucats = '<select name="data[catid]" class="saisie_text">';
		foreach($cats as $cat) {
			$selected = ($cat["Id"] == $contenu["catid"]) ? ' selected="selected"' : '';
			$menucats .= '<option value="'.$cat["Id"].'"'.$selected.'>'.$cat["cat_fr"].'</option>';
		}
		$menucats .= '</select>';
	
		$photo = '<input type="file" name="photo[]" class="saisie_text" accept="image/*" />';
		if ($contenu["photo"] != "") {
			$header_system .= '
			<script>
			function delete_photo() {
				if (confirm("En tes-vous sr(e) ?\nLa photo sera immdiatement supprime.")) {
					jQuery.ajax("system_mobile.php?op=deletephotoplatresto&Id='.$contenu["Id"].'",{
						success: function (msg) {
							if (msg == "ok") {
								jQuery(".hide_nophoto").slideUp(function() {
									jQuery(".show_nophoto").slideDown();
								});
							}
							else {
								alert("Aucune modification effectue !");
							}
						}
					});
				}
			}
		</script>
		';
			$photo = '<img src="'.$contenu["photo"].'" class="width_all hide_nophoto" /><input type="button" value="Supprimer la photo" name="delphoto" class="saisie_text hide_nophoto" onclick="delete_photo()" /><input type="file" name="photo[]" accept="image/*" class="saisie_text show_nophoto" style="display: none" />';
		}
	
		$page_header_title = 'dition de plat';
			
		include ("system/header_system_mobile.php");
	
		$sortie = '';
			
		$sortie .= '
		<form action="system_mobile.php" method="post" class="nomarge" enctype="multipart/form-data">
		<div class="marge">
		<div id="tabs">
		<ul>
		<li><a href="#tabs-1"><img src="themes/System_mobile/images/flags/flags_iso/32/fr.png" width="32" /></a></li>
		<li><a href="#tabs-2"><img src="themes/System_mobile/images/flags/flags_iso/32/gb.png" width="32" /></a></li>
		<li><a href="#tabs-3"><img src="themes/System_mobile/images/flags/flags_iso/32/it.png" width="32" /></a></li>
		<li><a href="#tabs-4"><img src="themes/System_mobile/images/flags/flags_iso/32/de.png" width="32" /></a></li>
		<li><a href="#tabs-5"><img src="themes/System_mobile/images/flags/flags_iso/32/es.png" width="32" /></a></li>
		</ul>
		<div id="tabs-1">
		Nom franais : <input type="text" name="data[nom_fr]" value="'.str_replace('"', "&quot;", $contenu["nom_fr"]).'" class="saisie_text" />
		Description franais : <textarea name="data[com_fr]" rows="4" class="saisie_text" >'.$contenu["nom_fr"].'</textarea>
		</div>
		<div id="tabs-2">
		Nom anglais : <input type="text" name="data[nom_uk]" value="'.str_replace('"', "&quot;", $contenu["nom_uk"]).'" class="saisie_text" />
		Description anglais : <textarea name="data[com_uk]" rows="4" class="saisie_text" >'.$contenu["nom_uk"].'</textarea>
		</div>
		<div id="tabs-3">
		Nom italien : <input type="text" name="data[nom_it]" value="'.str_replace('"', "&quot;", $contenu["nom_it"]).'" class="saisie_text" />
		Description italien : <textarea name="data[com_it]" rows="4" class="saisie_text" >'.$contenu["nom_it"].'</textarea>
		</div>
		<div id="tabs-4">
		Nom allemand : <input type="text" name="data[nom_de]" value="'.str_replace('"', "&quot;", $contenu["nom_de"]).'" class="saisie_text" />
		Description allemand : <textarea name="data[com_de]" rows="4" class="saisie_text" >'.$contenu["nom_de"].'</textarea>
		</div>
		<div id="tabs-5">
		Nom espagnol : <input type="text" name="data[nom_sp]" value="'.str_replace('"', "&quot;", $contenu["nom_sp"]).'" class="saisie_text" />
		Description espagnol : <textarea name="data[com_sp]" rows="4" class="saisie_text" >'.$contenu["nom_sp"].'</textarea>
		</div>
		</div>
		</div>
		<div class="marge">
		Catgorie : '.$menucats.'
	
		Tarif : <input type="number" min="0.00" step="0.01" max="9999.99" name="data[prix]" value="'.str_replace('"', "&quot;", $contenu["prix"]).'" class="saisie_text" />
	
		</div>
		<div class="marge">
		Allergnes : <br />
		<div class="width_100"><input type="checkbox" value="1" name="data[gluten]"'.(($contenu["gluten"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="gluten" /><label for="gluten">Gluten</label></div>
		<div class="width_100"><input type="checkbox" value="1" name="data[crustace]"'.(($contenu["crustace"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="crustace" /><label for="crustace">Crustac</label></div>
		<div class="width_100"><input type="checkbox" value="1" name="data[oeuf]"'.(($contenu["oeuf"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="oeuf" /><label for="oeuf">Oeuf</label></div>
		<div class="width_100"><input type="checkbox" value="1" name="data[poisson]"'.(($contenu["poisson"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="poisson" /><label for="poisson">Poisson</label></div>
		<div class="width_100"><input type="checkbox" value="1" name="data[arachide]"'.(($contenu["arachide"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="arachide" /><label for="arachide">Arachide</label></div>
		<div class="width_100"><input type="checkbox" value="1" name="data[soja]"'.(($contenu["soja"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="soja" /><label for="soja">Soja</label></div>
		<div class="width_100"><input type="checkbox" value="1" name="data[lait]"'.(($contenu["lait"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="lait" /><label for="lait">Lait</label></div>
		<div class="width_100"><input type="checkbox" value="1" name="data[fruitacoque]"'.(($contenu["fruitacoque"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="fruitacoque" /><label for="fruitacoque">Fuit  coque</label></div>
		<div class="width_100"><input type="checkbox" value="1" name="data[celeri]"'.(($contenu["celeri"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="celeri" /><label for="celeri">Cleri</label></div>
		<div class="width_100"><input type="checkbox" value="1" name="data[moutarde]"'.(($contenu["moutarde"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="moutarde" /><label for="moutarde">Moutarde</label></div>
		<div class="width_100"><input type="checkbox" value="1" name="data[sesame]"'.(($contenu["sesame"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="sesame" /><label for="sesame">Ssame</label></div>
		<div class="width_100"><input type="checkbox" value="1" name="data[sulfite]"'.(($contenu["sulfite"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="sulfite" /><label for="sulfite">Sulfite</label></div>
		<div class="width_100"><input type="checkbox" value="1" name="data[lupin]"'.(($contenu["lupin"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="lupin" /><label for="lupin">Lupin</label></div>
		<div class="width_100"><input type="checkbox" value="1" name="data[mollusque]"'.(($contenu["mollusque"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="mollusque" /><label for="mollusque">Mollusque</label></div>
		</div>
		<div class="marge">
		Publie : <input type="checkbox" value="1" name="data[valide]"'.(($contenu["valide"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" />
		</div>
		<div class="marge">
		Photo : '.$photo.'
		</div>
		<div class="marge"><input type="submit" value="Enregistrer le plat" class="saisie_text submit" name="valid"></div>
		<input type="hidden" name="op" value="saveplatresto" />
		<input type="hidden" name="data[Id]" value="'.$contenu["Id"].'" />
		<input type="hidden" name="data[position]" value="'.$contenu["position"].'" />
		</form>';
	
			
		echo $sortie;
			
		include ("system/footer_system_mobile.php");
	}
	

	function save_plat($plat,$next="bycats") {
		global $page_header_title, $header_system;
		global $prefix, $db ;
	
		$accomps = $plat["accomp"];
		unset($plat["accomp"]);
		$forms = $plat["form"];
		unset($plat["form"]);
		
		$plat = array_map("FixQuotes", $plat);
		$plat = array_map("stripslashes", $plat);
		$plat["valide"] = ($plat["valide"] == "1") ? "1" : "0";
    	    
	    if ($plat["Id"] != "") {
	    	$contenu = getPlatContent($plat["Id"]);
	    	$plat["position"] = $contenu["position"];
	    	
		    $sql = "UPDATE ".$prefix."_resto_plat";
		    $sql .= " SET position='".$plat["position"]."', catid='".$plat["catid"]."', nom_fr='".$plat["nom_fr"]."', com_fr='".$plat["com_fr"]."', nom_uk='".$plat["nom_uk"]."', com_uk='".$plat["com_uk"]."', nom_de='".$plat["nom_de"]."', com_de='".$plat["com_de"]."'";
		    $sql .= ", nom_sp='".$plat["nom_sp"]."', com_sp='".$plat["com_sp"]."', nom_it='".$plat["nom_it"]."', com_it='".$plat["com_it"]."', gluten='".$plat["gluten"]."', crustace='".$plat["crustace"]."', oeuf='".$plat["oeuf"]."', poisson='".$plat["poisson"]."'";
		    $sql .= ", desc_fr='".$plat["desc_fr"]."', desc_uk='".$plat["desc_uk"]."', desc_de='".$plat["desc_de"]."', desc_sp='".$plat["desc_sp"]."', desc_it='".$plat["desc_it"]."'";
		    $sql .= ", arachide='".$plat["arachide"]."', soja='".$plat["soja"]."', lait='".$plat["lait"]."', fruitacoque='".$plat["fruitacoque"]."', celeri='".$plat["celeri"]."', moutarde='".$plat["moutarde"]."', sesame='".$plat["sesame"]."', sulfite='".$plat["sulfite"]."'";
		    $sql .= ", lupin='".$plat["lupin"]."', mollusque='".$plat["mollusque"]."', prix='".$plat["prix"]."', valide='".$plat["valide"]."'";
		    $sql .= " WHERE Id = ".$plat["Id"]."";
		    $result=$db->sql_query($sql);
			if (!$result) {
				$error = $db->sql_error();
				die('Invalid query:'.$error["message"]);
			}
			$id_plat = $plat["Id"];
	    }
	    else {
	    	$plat["position"] = getNextPlatPosition(); //au cas o une nouvelle catgorie aurait t cre avant que celle-ci ne soit enregistre.
	    	
	    	$sql = "INSERT INTO ".$prefix."_resto_plat";
		    $sql .= " (position, catid, nom_fr, com_fr, nom_uk, com_uk, nom_de, com_de, nom_sp, com_sp, nom_it, com_it, desc_fr, desc_uk, desc_de, desc_sp, desc_it, gluten, crustace, oeuf, poisson, arachide, soja, lait, fruitacoque, celeri, moutarde, sesame, sulfite, lupin, mollusque, prix, photo, valide)";
		    $sql .= "VALUES ('".$plat["position"]."','".$plat["catid"]."','".$plat["nom_fr"]."','".$plat["com_fr"]."', '".$plat["nom_uk"]."', '".$plat["com_uk"]."', '".$plat["nom_de"]."', '".$plat["com_de"]."'";
		    $sql .= ", '".$plat["nom_sp"]."','".$plat["com_sp"]."','".$plat["nom_it"]."','".$plat["com_it"]."','".$plat["desc_fr"]."','".$plat["desc_uk"]."','".$plat["desc_de"]."','".$plat["desc_sp"]."','".$plat["desc_it"]."'";
		    $sql .= ", '".$plat["gluten"]."', '".$plat["crustace"]."', '".$plat["oeuf"]."', '".$plat["poisson"]."'";
		    $sql .= ", '".$plat["arachide"]."','".$plat["soja"]."','".$plat["lait"]."','".$plat["fruitacoque"]."', '".$plat["celeri"]."', '".$plat["moutarde"]."', '".$plat["sesame"]."', '".$plat["sulfite"]."'";
		    $sql .= ", '".$plat["lupin"]."','".$plat["mollusque"]."','".$plat["prix"]."','".$plat["photo"]."','".$plat["valide"]."'";
		    $sql .= ");"; 
	    	$result=$db->sql_query($sql);
			if (!$result) {
				$error = $db->sql_error();
				die('Invalid query:'.$error["message"]);
			}
			$id_plat = $db->sql_nextid($result);
	    }
	    
	    $sql = "DELETE FROM ".$prefix."_resto_link_plat_accompagnement WHERE id_plat='$id_plat'";
	    $result=$db->sql_query($sql);
	    if (!$result) {
	    	$error = $db->sql_error();
	    	die('Invalid query:'.$error["message"]);
	    }
	    if (is_array($accomps)) {
		    foreach ($accomps as $id_accomp) {
		    	$sql = "INSERT INTO ".$prefix."_resto_link_plat_accompagnement";
		    	$sql .= " (id_plat, id_accompagnement)";
		    	$sql .= "VALUES ('$id_plat','$id_accomp');";
		    	$result=$db->sql_query($sql);
		    	if (!$result) {
		    		$error = $db->sql_error();
		    		die('Invalid query:'.$error["message"]);
		    	}
		    }
	    }
	    
	    $sql = "DELETE FROM ".$prefix."_resto_link_plat_formule WHERE id_plat='$id_plat'";
	    $result=$db->sql_query($sql);
	    if (!$result) {
	    	$error = $db->sql_error();
	    	die('Invalid query:'.$error["message"]);
	    }
	    if (is_array($forms)) {
	    	foreach ($forms as $id_formule) {
	    		$sql = "INSERT INTO ".$prefix."_resto_link_plat_formule";
	    		$sql .= " (id_plat, id_formule)";
	    		$sql .= "VALUES ('$id_plat','$id_formule');";
	    		$result=$db->sql_query($sql);
	    		if (!$result) {
	    			$error = $db->sql_error();
	    			die('Invalid query:'.$error["message"]);
	    		}
	    	}
	    }
	    
	    /*$width = 1024;
	    $height = 768;
	    include("core/conf/uploadconfig.php");
	    $chemin = $uploadFolder."/../simple_resto";
	    $photosSaved = uploadFiles($_FILES["photo"], $chemin, $width, $height);
	    if (count($photosSaved) > 0) {
	    	$sql = "UPDATE ".$prefix."_resto_plat";
	    	$sql .= " SET photo='".$photosSaved[0]."'";
	    	$sql .= " WHERE Id = ".$id_plat."";
	    	$result = $db->sql_query($sql);
	    	if (!$result) {
	    		$error = $db->sql_error();
	    		die("Erreur sur mise  jour photo : ".$error["message"]);
	    	}
	    }*/
	    /*for($i=0 ; $i < count($photosSaved) ; $i++) {
		    $photoSaved = $photosSaved[$i];
		    $sql = "UPDATE ".$user_prefix."_adherents SET photo='".$photosSaved[$i]."' WHERE `id` = '".$id_had."';";
		    $ok = ($ok && $db->sql_query($sql));
	    }*/
	    
	    switch ($next) {
	    	case "byforms":
	    		$urlnext = "system_mobile.php?op=designformresto";
	    		break;
	    	case "bycats":
	    	default:
	    		$urlnext = "system_mobile.php?op=listplatresto";
	    		break;
	    }	    
	
		$header_system .= '
		<script>
			allerPage("'.$urlnext.'",2000);
		</script>';
		
		$page_header_title = 'Enregistrement de plat';
		include ("system/header_system_mobile.php");
		
		//enregistrement dans la base de donnes  faire
		
		$sortie = '<alert class="center_v_abs">Plat enregistr</alert>';

		echo $sortie;
		include ("system/footer_system_mobile.php");
	}
	
	function uploadFiles($fichiersUpload, $chemin="", $maxWith = 0, $maxHeight = 0) {
		$chemin = rtrim($chemin, "/");
	
		if (!file_exists($chemin)) {
			//$old = umask(0);
			if (!mkdir($chemin,0777,true)) {
				die("Impossible de crer le dossier de destination de l'upload !");
			}
			touch($chemin."/index.htm");
			//chmod($chemin, "0777");
			//umask($old);
		}
	
		$fichier = array();
		for ($i=0; $i<count($fichiersUpload["name"]); $i++) {
			if ($fichiersUpload["name"][$i] != "") {
				$nomDestination = md5(time()+rand(0,10)).strrchr($fichiersUpload["name"][$i],'.');
				while (file_exists($chemin."/".$nomDestination)) {
					$nomDestination = md5(time()+rand(0,10)).strrchr($fichiersUpload["name"][$i],'.');
				}
				if (is_uploaded_file($fichiersUpload["tmp_name"][$i])) {
					$fichier[$i] = str_replace(str_replace('\\', '/', realpath("."))."/",'',str_replace('\\', '/', realpath($chemin))."/".$nomDestination);
					
					$extension = strtolower(strrchr($fichier[$i],'.'));
					$types = Array('.png', '.gif', '.jpeg', '.jpg');
					if (!in_array($extension, $types)) {
						if ($fichiersUpload['type'][0] == "image/png") {
							$extension = ".png";
						}
						if ($fichiersUpload['type'][0] == "image/jpeg") {
							$extension = ".jpg";
						}
						if ($fichiersUpload['type'][0] == "image/gif") {
							$extension = ".gif";
						}
						$fichier[$i] .= $extension;
					}
						
					if (rename($fichiersUpload["tmp_name"][$i],$fichier[$i])) {
						chmod($fichier[$i],0777);
	
						$size = getimagesize($fichier[$i]);
						$width = $size[0];
						$height = $size[1];
	
						//test si les dimensions de l'image sont correctes et sinon applique le redimensionnement
						if (($width > $maxWith || $height > $maxHeight) && ($maxWith > 0 && $maxHeight > 0)) {
							//calcul nouvelle taille
							if (($width/$maxWith) > ($height/$maxHeight)) {
								if ($maxWith != 0) {
									$newwidth = $maxWith;
									$newheight = ($height * $maxWith) / $width;
								}
								else {
									$newwidth = ($width * $maxHeight) / $height;
									$newheight = $maxHeight;
								}
							}
							else {
								if ($maxHeight != 0) {
									$newwidth = ($width * $maxHeight) / $height;
									$newheight = $maxHeight;
								}
								else {
									$newwidth = $maxWith;
									$newheight = ($height * $maxWith) / $width;
								}
							}
							//pour les cas des jpg
							if($extension == '.jpg' || $extension == '.jpeg') {
								$src = imagecreatefromjpeg($fichier[$i]);
								$tmp=imagecreatetruecolor($newwidth,$newheight);
								imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
								imagejpeg($tmp,$fichier[$i],70);
								imagedestroy($src);
								imagedestroy($tmp);
							}
							//pour les cas des gif
							if($extension == '.gif') {
								$src = imagecreatefromgif($fichier[$i]);
								$tmp=imagecreatetruecolor($newwidth,$newheight);
								$trans = imagecolorallocate($tmp,255,255,255);
								imagefilledrectangle($tmp,0,0,$newwidth,$newheight,$trans);
								imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
								imageinterlace($tmp);
								imagegif($tmp,$fichier[$i]);
								imagedestroy($src);
								imagedestroy($tmp);
							}
							//pour les cas des png
							if($extension == '.png') {
								$src = imagecreatefrompng($fichier[$i]);
								$tmp=imagecreatetruecolor($newwidth,$newheight);
								imagealphablending($tmp, false);
								imagesavealpha($tmp, true);
								imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
								$fond_noir = imagecolorallocate($destination, 0, 0, 0);
								imagecolortransparent($destination, $fond_noir);
								imagepng($tmp,$fichier[$i]);
								imagedestroy($src);
								imagedestroy($tmp);
							}
						}
					}
					else {
						die("Le dplacement du fichier temporaire a chou. Vrifiez l'existence du rpertoire $chemin");
					}
				}
				else {
					die("Le fichier n'a pas t upload (trop gros ? droits ?)");
				}
			}
		}
		return $fichier;
	}
	
	function swap_plats($Id, $sens) {
		global $prefix, $db;

		$oneplat = getPlatContent($Id);
	
		$where = " WHERE false ";
		switch ($sens) {
			case "up":
				$where = " WHERE `position` <= ".$oneplat["position"]." AND catid='".$oneplat["catid"]."' ORDER BY `position` DESC limit 2";
				break;
			case "down":
				$where = " WHERE `position` >= ".$oneplat["position"]." AND catid='".$oneplat["catid"]."' ORDER BY `position` ASC limit 2";
				break;
		}
	
		$ok = true;
	
		$sql = "SELECT Id, `position` FROM ".$prefix."_resto_plat ".$where.";";
		//echo $sql;
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) == 2) {
			list($Id_init, $position_init) = $db->sql_fetchrow($result);
			list($Id_new, $position_new) = $db->sql_fetchrow($result);
			$sql = "UPDATE ".$prefix."_resto_plat";
			$sql .= " SET position='".$position_new."'";
			$sql .= " WHERE Id = ".$Id_init.";";
			//echo "\n".$sql;
			$ok = $ok && $db->sql_query($sql);
			$sql = "UPDATE ".$prefix."_resto_plat";
			$sql .= " SET position='".$position_init."'";
			$sql .= " WHERE Id = ".$Id_new.";";
			//echo "\n".$sql;
			$ok = $ok && $db->sql_query($sql);
			if ($ok) {
				echo "ok";
			}
			else {
				echo "pas ok";
			}
			die();
		}
		else {
			echo "pas ok du tout";
			die();
		}
	}
	
	function swap_accomps($Id, $sens) {
		global $prefix, $db;
	
		$oneaccomp = getAccompContent($Id);
	
		$where = " WHERE false ";
		switch ($sens) {
			case "up":
				$where = " WHERE `position` <= ".$oneaccomp["position"]." AND catid='".$oneaccomp["catid"]."' ORDER BY `position` DESC limit 2";
				break;
			case "down":
				$where = " WHERE `position` >= ".$oneaccomp["position"]." AND catid='".$oneaccomp["catid"]."' ORDER BY `position` ASC limit 2";
				break;
		}
	
		$ok = true;
	
		$sql = "SELECT Id, `position` FROM ".$prefix."_resto_accompagnement ".$where.";";
		//echo $sql;
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) == 2) {
			list($Id_init, $position_init) = $db->sql_fetchrow($result);
			list($Id_new, $position_new) = $db->sql_fetchrow($result);
			$sql = "UPDATE ".$prefix."_resto_accompagnement";
			$sql .= " SET position='".$position_new."'";
			$sql .= " WHERE Id = ".$Id_init.";";
			//echo "\n".$sql;
			$ok = $ok && $db->sql_query($sql);
			$sql = "UPDATE ".$prefix."_resto_accompagnement";
			$sql .= " SET position='".$position_init."'";
			$sql .= " WHERE Id = ".$Id_new.";";
			//echo "\n".$sql;
			$ok = $ok && $db->sql_query($sql);
			if ($ok) {
				echo "ok";
			}
			else {
				echo "pas ok";
			}
			die();
		}
		else {
			echo "pas ok du tout";
			die();
		}
	}
	
	function getAccompList($catid = "", $withall = false){
		global $db, $prefix, $multilingual;
		
		$accompList = array();
		$cond = "";
		if ($catid !="") {
			$cond .= ($cond == "" ) ? " WHERE " : " AND ";
			$cond .= "catid=$catid";
		}
		if ($withall) {
			$cond .= ($cond == "" ) ? " WHERE " : " OR ";
			$cond .= "catid=0";
		}
		$sql = "select `Id`, `position`, `catid`, `nom_fr`, `com_fr`, `desc_fr`, `nom_uk`, `com_uk`, `desc_uk`, `nom_de`, `com_de`, `desc_de`, `nom_sp`, `com_sp`, `desc_sp`, `nom_it`, `com_it`, `desc_it`, `gluten`, `crustace`, `oeuf`, `poisson`, `arachide`, `soja`, `lait`, `fruitacoque`, `celeri`, `moutarde`, `sesame`, `sulfite`, `lupin`, `mollusque`,`prix`, `photo`, `valide` from ".$prefix."_resto_accompagnement  $cond  order by `position` ASC, `nom_fr`ASC;";
		$result = $db->sql_query($sql);

		while ($ligne = $db->sql_fetchrow($result)) {
			$accompList[]= array(
				"Id" => $ligne["Id"],
				"position" => $ligne["position"],
				"catid" => $ligne["catid"],
				"nom_fr" => $ligne["nom_fr"],
				"com_fr" => $ligne["com_fr"],
				"desc_fr" => $ligne["desc_fr"],
				"nom_uk" => $ligne["nom_uk"],
				"com_uk" => $ligne["com_uk"],
				"desc_uk" => $ligne["desc_uk"],
				"nom_de" => $ligne["nom_de"],
				"com_de" => $ligne["com_de"],
				"desc_de" => $ligne["desc_de"],
				"nom_sp" => $ligne["nom_sp"],
				"com_sp" => $ligne["com_sp"],
				"desc_sp" => $ligne["desc_sp"],
				"nom_it" => $ligne["nom_it"],
				"com_it" => $ligne["com_it"],
				"desc_it" => $ligne["desc_it"],
				"gluten" => $ligne["gluten"],
				"crustace" => $ligne["crustace"],
				"oeuf" => $ligne["oeuf"],
				"poisson" => $ligne["poisson"],
				"arachide" => $ligne["arachide"],
				"soja" => $ligne["soja"],
				"lait" => $ligne["lait"],
				"fruitacoque" => $ligne["fruitacoque"],
				"celeri" => $ligne["celeri"],
				"moutarde" => $ligne["moutarde"],
				"sesame" => $ligne["sesame"],
				"sulfite" => $ligne["sulfite"],
				"lupin" => $ligne["lupin"],
				"mollusque" => $ligne["mollusque"],
				"prix" => $ligne["prix"],
				"photo" => $ligne["photo"],
				"valide" => $ligne["valide"]
			);
		}
		$db->sql_freeresult($result);
		return $accompList;
	}
	
	function getAccompListPlat($id_plat){
		global $db, $prefix, $multilingual;
	
		$accompList = array();
		$cond = "";
		if ($id_plat !="") {
			$cond .= ($cond == "" ) ? " WHERE " : " AND ";
			$cond .= "id_plat=$id_plat";
		}
		$sql = "select `Id`, `id_plat`, `id_accompagnement` from ".$prefix."_resto_link_plat_accompagnement $cond;";
		$result = $db->sql_query($sql);
	
		while ($ligne = $db->sql_fetchrow($result)) {
			$accompList[]= array(
					"Id" => $ligne["Id"],
					"id_plat" => $ligne["id_plat"],
					"id_accompagnement" => $ligne["id_accompagnement"]
			);
		}
		$db->sql_freeresult($result);
		return $accompList;
	}
	
	function getAccompContent($id){
		global $db,$prefix;
	
		if ($id =="") {
			return "";
		}
		else {
			$cond = "";
			if ($id !="") {
				$cond .= ($cond == "" ) ? " WHERE " : " AND ";
				$cond .= "Id=$id";
			}
				
			$result = $db->sql_query("select `Id`, `position`, `catid`, `nom_fr`, `com_fr`, `desc_fr`, `nom_uk`, `com_uk`, `desc_uk`, `nom_de`, `com_de`, `desc_de`, `nom_sp`, `com_sp`, `desc_sp`, `nom_it`, `com_it`, `desc_it`, `gluten`, `crustace`, `oeuf`, `poisson`, `arachide`, `soja`, `lait`, `fruitacoque`, `celeri`, `moutarde`, `sesame`, `sulfite`, `lupin`, `mollusque`, `prix`, `photo`, `valide` from ".$prefix."_resto_accompagnement  $cond");
			if ($ligne = $db->sql_fetchrow($result)) {
				$sortie= array(
						"Id" => $ligne["Id"],
						"position" => $ligne["position"],
						"catid" => $ligne["catid"],
						"nom_fr" => $ligne["nom_fr"],
						"com_fr" => $ligne["com_fr"],
						"desc_fr" => $ligne["desc_fr"],
						"nom_uk" => $ligne["nom_uk"],
						"com_uk" => $ligne["com_uk"],
						"desc_uk" => $ligne["desc_uk"],
						"nom_de" => $ligne["nom_de"],
						"com_de" => $ligne["com_de"],
						"desc_de" => $ligne["desc_de"],
						"nom_sp" => $ligne["nom_sp"],
						"com_sp" => $ligne["com_sp"],
						"desc_sp" => $ligne["desc_sp"],
						"nom_it" => $ligne["nom_it"],
						"com_it" => $ligne["com_it"],
						"desc_it" => $ligne["desc_it"],
						"gluten" => $ligne["gluten"],
						"crustace" => $ligne["crustace"],
						"oeuf" => $ligne["oeuf"],
						"poisson" => $ligne["poisson"],
						"arachide" => $ligne["arachide"],
						"soja" => $ligne["soja"],
						"lait" => $ligne["lait"],
						"fruitacoque" => $ligne["fruitacoque"],
						"celeri" => $ligne["celeri"],
						"moutarde" => $ligne["moutarde"],
						"sesame" => $ligne["sesame"],
						"sulfite" => $ligne["sulfite"],
						"lupin" => $ligne["lupin"],
						"mollusque" => $ligne["mollusque"],
						"prix" => $ligne["prix"],
						"photo" => $ligne["photo"],
						"valide" => $ligne["valide"]
				);
			}
			$db->sql_freeresult($result);
			return $sortie;
		}
	}
	
	function getNextAccompPosition() {
		global $db, $prefix;
		$result = $db->sql_query("select max(`position`) as current_position from ".$prefix."_resto_accompagnement;");
		if (list($current_position) = $db->sql_fetchrow($result)) {
			$current_position++;
			return $current_position;
		}
		else {
			die('erreur rcup position accompagnement');
		}
	}
	
	function edit_accomp($id) {
		global $username, $language, $admin, $aid, $prefix, $file, $db, $sitename, $user, $currentlang, $page_header_title, $header_system;
	
		$contenu = array();
		$menusections = '';
		if ($id != "") {
			$contenu = getAccompContent($id);
		}
		else {
			$contenu= array(
					"Id" => "",
					"position" => getNextAccompPosition(),
					"catid" => 0,
					"nom_fr" => "",
					"com_fr" => "",
					"desc_fr" => "",
					"nom_uk" => "",
					"com_uk" => "",
					"desc_uk" => "",
					"nom_de" => "",
					"com_de" => "",
					"desc_de" => "",
					"nom_sp" => "",
					"com_sp" => "",
					"desc_sp" => "",
					"nom_it" => "",
					"com_it" => "",
					"desc_it" => "",
					"gluten" => "0",
					"crustace" => "0",
					"oeuf" => "0",
					"poisson" => "0",
					"arachide" => "0",
					"soja" => "0",
					"lait" => "0",
					"fruitacoque" => "0",
					"celeri" => "0",
					"moutarde" => "0",
					"sesame" => "0",
					"sulfite" => "0",
					"lupin" => "0",
					"mollusque" => "0",
					"prix" => "0.00",
					"photo" => "",
					"valide" => "0"
			);
		}
	
		$cats = getCatList();
		$menucats = '<select name="data[catid]" class="saisie_text">';
		$selected = ("0" == $contenu["catid"]) ? ' selected="selected"' : '';
		$menucats .= '<option value="0"'.$selected.'>Toutes les catgories</option>';
		foreach($cats as $cat) {
			$selected = ($cat["Id"] == $contenu["catid"]) ? ' selected="selected"' : '';
			$menucats .= '<option value="'.$cat["Id"].'"'.$selected.'>'.$cat["cat_fr"].'</option>';
		}
		$menucats .= '</select>';
	
		$vignette = "";
		if ($contenu["photo"] != "") {
			$vignette = '<img src="'.$contenu["photo"].'" class="width_all hide_nophoto" />';
		}
		$photo = '<input type="file" name="photo[]" class="saisie_text photo_upload show_nophoto" accept="image/*" />';
		$photo .= '<div id="img_vignettes" class="width_all">'.$vignette.'</div>';
		$photo .= '<input type="button" value="Supprimer la photo" name="delphoto" class="saisie_text hide_nophoto" onclick="delete_photo()" />';
	
		$page_header_title = 'dition de supplment';
	
		$header_system .= '
		<script src="themes/System_mobile/js/jquery.exif.js"></script>
		<script src="themes/System_mobile/js/jquery.canvasResize.js"></script>
		<script>
		jQuery(function() {
			jQuery( "#tabs" ).tabs({
				show: { effect: "fade", duration: 500 },
				hide: { effect: "fade", duration: 500 }
			});
			jQuery("input[type=checkbox]").checkboxradio();
		});
		</script>
		<script>
		jQuery(document).ready(function(){
			var state_upload = ("'.$contenu["photo"].'" == "");
			//console.log(state_upload);
			if (state_upload) {
				//montrer ce qui sert  uploader et masquer le reste
				jQuery(".hide_nophoto").hide();
				jQuery(".show_nophoto").show();
			}
			else {
				//masquer ce qui sert  uploader et montrer le reste
				jQuery(".hide_nophoto").show();
				jQuery(".show_nophoto").hide();
			}
		});
		function delete_photo() {
			if (confirm("En tes-vous sr(e) ?\nLa photo sera immdiatement supprime.")) {
				if (jQuery("#dataId").val() != "") {
					var urldel = "system_mobile.php?op=deletephotoaccompresto&Id="+jQuery("#dataId").val();
				}
				else {
					if (jQuery("#dataPhoto").val() != "") {
						var urldel = "system_mobile.php?op=deletephotoaccompresto&photo="+jQuery("#dataPhoto").val();
					}
					else {
						alert("Erreur : il n\'y a aucune image  supprimer !");
					}
				}
				jQuery.ajax(urldel,{
					success: function (msg) {
						if (msg == "ok") {
							jQuery("#dataPhoto").val("");
							jQuery(".hide_nophoto").slideUp(function() {
								jQuery(".show_nophoto").slideDown();
							});
						}
						else {
							alert("Aucune modification effectue !");
						}
					}
				});
			}
		}
		var op_upload_photo = "uploadphotoaccompresto";
		</script>
		';
			
		include ("system/header_system_mobile.php");
	
		$sortie = '';
			
		$sortie .= '
		<form action="system_mobile.php" method="post" class="nomarge">
			<div class="marge">
				<div id="tabs">
					<ul>
						<li><a href="#tabs-1"><img src="themes/System_mobile/images/flags/flags_iso/32/fr.png" width="32" /></a></li>
						<li><a href="#tabs-2"><img src="themes/System_mobile/images/flags/flags_iso/32/gb.png" width="32" /></a></li>
						<li><a href="#tabs-3"><img src="themes/System_mobile/images/flags/flags_iso/32/it.png" width="32" /></a></li>
						<li><a href="#tabs-4"><img src="themes/System_mobile/images/flags/flags_iso/32/de.png" width="32" /></a></li>
						<li><a href="#tabs-5"><img src="themes/System_mobile/images/flags/flags_iso/32/es.png" width="32" /></a></li>
					</ul>
					<div id="tabs-1">
						Nom franais : <input type="text" name="data[nom_fr]" value="'.str_replace('"', "&quot;", $contenu["nom_fr"]).'" class="saisie_text" />
						Description franais : <textarea name="data[com_fr]" rows="4" class="saisie_text" >'.$contenu["com_fr"].'</textarea>
						Description longue franais : <textarea name="data[desc_fr]" rows="4" class="saisie_text" >'.$contenu["desc_fr"].'</textarea>
					</div>
					<div id="tabs-2">
						Nom anglais : <input type="text" name="data[nom_uk]" value="'.str_replace('"', "&quot;", $contenu["nom_uk"]).'" class="saisie_text" />
						Description anglais : <textarea name="data[com_uk]" rows="4" class="saisie_text" >'.$contenu["com_uk"].'</textarea>
						Description longue anglais : <textarea name="data[desc_uk]" rows="4" class="saisie_text" >'.$contenu["desc_uk"].'</textarea>
					</div>
					<div id="tabs-3">
						Nom italien : <input type="text" name="data[nom_it]" value="'.str_replace('"', "&quot;", $contenu["nom_it"]).'" class="saisie_text" />
						Description italien : <textarea name="data[com_it]" rows="4" class="saisie_text" >'.$contenu["com_it"].'</textarea>
						Description longue italien : <textarea name="data[desc_it]" rows="4" class="saisie_text" >'.$contenu["desc_it"].'</textarea>
					</div>
					<div id="tabs-4">
						Nom allemand : <input type="text" name="data[nom_de]" value="'.str_replace('"', "&quot;", $contenu["nom_de"]).'" class="saisie_text" />
						Description allemand : <textarea name="data[com_de]" rows="4" class="saisie_text" >'.$contenu["com_de"].'</textarea>
						Description longue allemand : <textarea name="data[desc_de]" rows="4" class="saisie_text" >'.$contenu["desc_de"].'</textarea>
					</div>
					<div id="tabs-5">
						Nom espagnol : <input type="text" name="data[nom_sp]" value="'.str_replace('"', "&quot;", $contenu["nom_sp"]).'" class="saisie_text" />
						Description espagnol : <textarea name="data[com_sp]" rows="4" class="saisie_text" >'.$contenu["com_sp"].'</textarea>
						Description longue espagnol : <textarea name="data[desc_sp]" rows="4" class="saisie_text" >'.$contenu["desc_sp"].'</textarea>
					</div>
				</div>
			</div>
			<div class="marge">
				Catgorie : '.$menucats.'	
				Tarif : <input type="number" min="0.00" step="0.01" max="9999.99" name="data[prix]" value="'.str_replace('"', "&quot;", $contenu["prix"]).'" class="saisie_text" />
			</div>
			<div class="marge">
				Allergnes : <br />
				<div class="width_150"><input type="checkbox" value="1" name="data[gluten]"'.(($contenu["gluten"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="gluten" /><label for="gluten">Gluten</label></div>'.
				'<div class="width_150"><input type="checkbox" value="1" name="data[crustace]"'.(($contenu["crustace"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="crustace" /><label for="crustace">Crustac</label></div>'.
				'<div class="width_150"><input type="checkbox" value="1" name="data[oeuf]"'.(($contenu["oeuf"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="oeuf" /><label for="oeuf">Oeuf</label></div>'.
				'<div class="width_150"><input type="checkbox" value="1" name="data[poisson]"'.(($contenu["poisson"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="poisson" /><label for="poisson">Poisson</label></div>'.
				'<div class="width_150"><input type="checkbox" value="1" name="data[arachide]"'.(($contenu["arachide"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="arachide" /><label for="arachide">Arachide</label></div>'.
				'<div class="width_150"><input type="checkbox" value="1" name="data[soja]"'.(($contenu["soja"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="soja" /><label for="soja">Soja</label></div>'.
				'<div class="width_150"><input type="checkbox" value="1" name="data[lait]"'.(($contenu["lait"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="lait" /><label for="lait">Lait</label></div>'.
				'<div class="width_150"><input type="checkbox" value="1" name="data[fruitacoque]"'.(($contenu["fruitacoque"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="fruitacoque" /><label for="fruitacoque">Fuit  coque</label></div>'.
				'<div class="width_150"><input type="checkbox" value="1" name="data[celeri]"'.(($contenu["celeri"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="celeri" /><label for="celeri">Cleri</label></div>'.
				'<div class="width_150"><input type="checkbox" value="1" name="data[moutarde]"'.(($contenu["moutarde"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="moutarde" /><label for="moutarde">Moutarde</label></div>'.
				'<div class="width_150"><input type="checkbox" value="1" name="data[sesame]"'.(($contenu["sesame"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="sesame" /><label for="sesame">Ssame</label></div>'.
				'<div class="width_150"><input type="checkbox" value="1" name="data[sulfite]"'.(($contenu["sulfite"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="sulfite" /><label for="sulfite">Sulfite</label></div>'.
				'<div class="width_150"><input type="checkbox" value="1" name="data[lupin]"'.(($contenu["lupin"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="lupin" /><label for="lupin">Lupin</label></div>'.
				'<div class="width_150"><input type="checkbox" value="1" name="data[mollusque]"'.(($contenu["mollusque"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="mollusque" /><label for="mollusque">Mollusque</label></div>
			</div>
			<div class="marge">
				Publication : <br />
				<div class="width_300"><input type="checkbox" value="1" name="data[valide]"'.(($contenu["valide"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="publiaccomp" /><label for="publiaccomp">Supplment publi</label></div>
			</div>
			<div class="marge">
				Photo : '.$photo.'
			</div>
			<div class="marge"><input type="submit" value="Enregistrer le supplment" class="saisie_text submit" name="valid"></div>
			<input type="hidden" name="op" value="saveaccompresto" />
			<input type="hidden" name="data[Id]" value="'.$contenu["Id"].'" id="dataId" />
			<input type="hidden" name="data[position]" value="'.$contenu["position"].'" />
			<input type="hidden" name="data[photo]" value="'.$contenu["photo"].'" id="dataPhoto" />
		</form>';
	
			
		echo $sortie;
			
		include ("system/footer_system_mobile.php");
	}
	
	function save_accomp($accomp) {
		global $page_header_title, $header_system;
		global $prefix, $db ;
		$accomp = array_map("FixQuotes", $accomp);
		$accomp = array_map("stripslashes", $accomp);
	
		$accomp["valide"] = ($accomp["valide"] == "1") ? "1" : "0";
			
		if ($accomp["Id"] != "") {
			$contenu = getAccompContent($accomp["Id"]);
			$accomp["position"] = $contenu["position"];
	
			$sql = "UPDATE ".$prefix."_resto_accompagnement";
			$sql .= " SET position='".$accomp["position"]."', catid='".$accomp["catid"]."', nom_fr='".$accomp["nom_fr"]."', com_fr='".$accomp["com_fr"]."', nom_uk='".$accomp["nom_uk"]."', com_uk='".$accomp["com_uk"]."', nom_de='".$accomp["nom_de"]."', com_de='".$accomp["com_de"]."'";
			$sql .= ", nom_sp='".$accomp["nom_sp"]."', com_sp='".$accomp["com_sp"]."', nom_it='".$accomp["nom_it"]."', com_it='".$accomp["com_it"]."', gluten='".$accomp["gluten"]."', crustace='".$accomp["crustace"]."', oeuf='".$accomp["oeuf"]."', poisson='".$accomp["poisson"]."'";
			$sql .= ", desc_fr='".$accomp["desc_fr"]."', desc_uk='".$accomp["desc_uk"]."', desc_de='".$accomp["desc_de"]."', desc_sp='".$accomp["desc_sp"]."', desc_it='".$accomp["desc_it"]."'";
			$sql .= ", arachide='".$accomp["arachide"]."', soja='".$accomp["soja"]."', lait='".$accomp["lait"]."', fruitacoque='".$accomp["fruitacoque"]."', celeri='".$accomp["celeri"]."', moutarde='".$accomp["moutarde"]."', sesame='".$accomp["sesame"]."', sulfite='".$accomp["sulfite"]."'";
			$sql .= ", lupin='".$accomp["lupin"]."', mollusque='".$accomp["mollusque"]."', prix='".$accomp["prix"]."', valide='".$accomp["valide"]."'";
			$sql .= " WHERE Id = ".$accomp["Id"]."";
			$result=$db->sql_query($sql);
			if (!$result) {
				$error = $db->sql_error();
				die('Invalid query:'.$error["message"]);
			}
			$id_accomp = $accomp["Id"];
		}
		else {
			$accomp["position"] = getNextAccompPosition(); //au cas o une nouvelle catgorie aurait t cre avant que celle-ci ne soit enregistre.
	
			$sql = "INSERT INTO ".$prefix."_resto_accompagnement";
			$sql .= " (position, catid, nom_fr, com_fr, nom_uk, com_uk, nom_de, com_de, nom_sp, com_sp, nom_it, com_it, desc_fr, desc_uk, desc_de, desc_sp, desc_it, gluten, crustace, oeuf, poisson, arachide, soja, lait, fruitacoque, celeri, moutarde, sesame, sulfite, lupin, mollusque, prix, photo, valide)";
			$sql .= "VALUES ('".$accomp["position"]."','".$accomp["catid"]."','".$accomp["nom_fr"]."','".$accomp["com_fr"]."', '".$accomp["nom_uk"]."', '".$accomp["com_uk"]."', '".$accomp["nom_de"]."', '".$accomp["com_de"]."'";
			$sql .= ", '".$accomp["nom_sp"]."','".$accomp["com_sp"]."','".$accomp["nom_it"]."','".$accomp["com_it"]."','".$accomp["desc_fr"]."','".$accomp["desc_uk"]."','".$accomp["desc_de"]."','".$accomp["desc_sp"]."','".$accomp["desc_it"]."'";
			$sql .= ", '".$accomp["gluten"]."', '".$accomp["crustace"]."', '".$accomp["oeuf"]."', '".$accomp["poisson"]."'";
			$sql .= ", '".$accomp["arachide"]."','".$accomp["soja"]."','".$accomp["lait"]."','".$accomp["fruitacoque"]."', '".$accomp["celeri"]."', '".$accomp["moutarde"]."', '".$accomp["sesame"]."', '".$accomp["sulfite"]."'";
			$sql .= ", '".$accomp["lupin"]."','".$accomp["mollusque"]."','".$accomp["prix"]."','".$accomp["photo"]."','".$accomp["valide"]."'";
			$sql .= ");";
			$result=$db->sql_query($sql);
			if (!$result) {
				$error = $db->sql_error();
				die('Invalid query:'.$error["message"]);
			}
			$id_accomp = $db->sql_nextid($result);
		}

		$header_system .= '
		<script>
			allerPage("system_mobile.php?op=listaccompresto",2000);
		</script>';
	
		$page_header_title = 'Enregistrement de supplment';
		include ("system/header_system_mobile.php");
	
		//enregistrement dans la base de donnes  faire
	
		$sortie = '<alert class="center_v_abs">Supplment enregistr</alert>';
	
		echo $sortie;
		include ("system/footer_system_mobile.php");
	}
	
	function list_accomps() {
		global $username, $language, $admin, $aid, $prefix, $file, $db, $sitename, $user, $currentlang, $page_header_title, $module_name, $header_system;
	
		$page_header_title = 'Liste des supplments';
		 
		$header_system .= '
		<script>
		var url_up = \'var url = "system_mobile.php?op=swapaccompsresto&Id="+id_elt+"&sens=up"\';
		var url_down = \'var url = "system_mobile.php?op=swapaccompsresto&Id="+id_elt+"&sens=down"\';
		</script>';
		 
		include ("system/header_system_mobile.php");
		 
		$sortie = "";
		 
		$sortie .= '<div class="marge">';
		 
		$categories = getCatList();
		$categories[] = array("Id" => "0", "cat_fr" => "Supplments toutes catgories");
		$compteur = -1;
		foreach ($categories as $onecategorie) {
			$compteur++;
			$sortie .= '
			<div class="combo"><a href="javascript:void(0)" class="combo" id="btn_content'.$compteur.'">'.$onecategorie["cat_fr"].'</a>
			<div class="ztxt_content" id="ztxt_content-btn_content'.$compteur.'">';
	
			$listeaccomps= '';
			$accomps = getAccompList($onecategorie["Id"]);
			foreach ($accomps as $oneaccomp) {
				$pub = ($oneaccomp["valide"] == "1") ? "Publi" : "Non publi";
				$np = ($oneaccomp["valide"] == "1") ? "" : " np";
	
				$with_allergo = ($oneaccomp["gluten"] == "1") || ($oneaccomp["crustace"] == "1") || ($oneaccomp["oeuf"] == "1") || ($oneaccomp["poisson"] == "1") || ($oneaccomp["arachide"] == "1") || ($oneaccomp["soja"] == "1") || ($oneaccomp["lait"] == "1") || ($oneaccomp["fruitacoque"] == "1") || ($oneaccomp["celeri"] == "1") || ($oneaccomp["moutarde"] == "1") || ($oneaccomp["sesame"] == "1") || ($oneaccomp["sulfite"] == "1") || ($oneaccomp["lupin"] == "1") || ($oneaccomp["mollusque"] =="1");
				$allergisants = ($with_allergo) ? " - avec allergisants" : "";
		   
				$prix = " - ".number_format($oneaccomp["prix"],2,',',' ')." &euro;";
		   
				//$src_picto = ($oneaccomp[6] == 1) ? 'themes/System_mobile/images/mobile.png' : 'themes/System_mobile/images/desktop.png';
				//$picto = '<img src="'.$src_picto.'" />';
				$style_item = '';
				if ($oneaccomp["photo"] != "") {
					$style_item = ' class="with_photo"';
				}
				$btn_up = '<img src="themes/System_mobile/images/btn_up.png" class="btn_up" id_elt="'.$oneaccomp["Id"].'" />';
				$btn_down = '<img src="themes/System_mobile/images/btn_down.png" class="btn_down" id_elt="'.$oneaccomp["Id"].'"/>';
				//$listeaccomps .= '<li class="collection-item-combo-doc'.$np.'"><a href="system_mobile.php?op=editaccompresto&id='.$oneaccomp["Id"].'"><span class="act">'.$oneaccomp["nom_fr"].$btn_up.'<img src="themes/System_mobile/images/space.png" style="width: 5px;" />'.$btn_down.'</span><span class="infos">'.$pub.$allergisants.$prix.'</span></a></li>';
				$listeaccomps .= '<li class="collection-item-combo-doc'.$np.'"><a href="system_mobile.php?op=editaccompresto&id='.$oneaccomp["Id"].'"'.$style_item.'>'.$oneaccomp["nom_fr"].'<span class="infos">'.$pub.$allergisants.$prix.$btn_up.'<img src="themes/System_mobile/images/space.png" style="width: 5px;" />'.$btn_down.'</span></a></li>';
			}
			if ($listeaccomps != '') {
				$sortie .= '<ul class="collection-combo-docs">'.$listeaccomps.'</ul>';
			}
	
			$sortie .= '
			</div>
			</div>';
		}
		 
		//$sortie .= '<help><span style="display: inline-block"><img src="themes/System_mobile/images/desktop.png"> page au format desktop</span> <span style="display: inline-block"><img src="themes/System_mobile/images/mobile.png"> page au format mobile</span></help>';
		 
		$sortie .= '</div>';
	
		echo $sortie;
		 
		include ("system/footer_system_mobile.php");
	}
	
	function getFormContent($id) {
		global $db, $prefix;
	
		if ($id =="") {
			return "";
		}
		else {
			$cond = "";
			if ($id !="") {
				$cond .= ($cond == "" ) ? " WHERE " : " AND ";
				$cond .= "Id=$id";
			}
			$result = $db->sql_query("select `Id`, `form_fr`, `form_uk`, `form_de`, `form_sp`, `form_it`, `position`, `valide`,`prix`, `photo` from ".$prefix."_resto_formule $cond;");
			if (list($Id, $form_fr, $form_uk, $form_de, $form_sp, $form_it, $position, $valide, $prix, $photo) = $db->sql_fetchrow($result)) {
				$sortie = array(
						"Id" => $Id,
						"form_fr" => $form_fr,
						"form_uk" => $form_uk,
						"form_de" => $form_de,
						"form_sp" => $form_sp,
						"form_it" => $form_it,
						"position" => $position,
						"prix" => $prix,
						"photo" => $photo,
						"valide" => $valide
				);
			}
			$db->sql_freeresult($result);
			return $sortie;
		}
	}
	
	function getFormList() {
		global $db, $prefix;
	
		$formList = array();
		$result = $db->sql_query("select `Id`, `form_fr`, `form_uk`, `form_de`, `form_sp`, `form_it`, `prix`, `valide`, `photo`, `position` from ".$prefix."_resto_formule order by position ASC;");
		while (list($Id, $form_fr, $form_uk, $form_de, $form_sp, $form_it, $prix, $valide, $photo, $position) = $db->sql_fetchrow($result)) {
			$formList[]= array(
					"Id" => $Id,
					"form_fr" => $form_fr,
					"form_uk" => $form_uk,
					"form_de" => $form_de,
					"form_sp" => $form_sp,
					"form_it" => $form_it,
					"prix" => $prix,
					"valide" => $valide,
					"photo" => $photo,
					"position" => $position
			);
		}
		$db->sql_freeresult($result);
		return $formList;
	}
	
	function getFormListPlat($id_plat){
		global $db, $prefix, $multilingual;
	
		$accompList = array();
		$cond = "";
		if ($id_plat !="") {
			$cond .= ($cond == "" ) ? " WHERE " : " AND ";
			$cond .= "id_plat=$id_plat";
		}
		$sql = "select `Id`, `id_plat`, `id_formule` from ".$prefix."_resto_link_plat_formule $cond;";
		$result = $db->sql_query($sql);
	
		while ($ligne = $db->sql_fetchrow($result)) {
			$accompList[]= array(
					"Id" => $ligne["Id"],
					"id_plat" => $ligne["id_plat"],
					"id_formule" => $ligne["id_formule"]
			);
		}
		$db->sql_freeresult($result);
		return $accompList;
	}
	
	function getNextFormPosition() {
		global $db, $prefix;
		$result = $db->sql_query("select max(`position`) as current_position from ".$prefix."_resto_formule;");
		if (list($current_position) = $db->sql_fetchrow($result)) {
			$current_position++;
			return $current_position;
		}
		else {
			die('erreur rcup position formule');
		}
	}
	
	function edit_formule($id) {
		global $username, $language, $admin, $aid, $prefix, $file, $db, $sitename, $user, $currentlang, $page_header_title, $header_system;
	
		$contenu = array();
		$menusections = '';
		if ($id != "") {
			$contenu = getFormContent($id);
		}
		else {
			$contenu= array(
					"Id" => "",
					"form_fr" => "",
					"form_uk" => "",
					"form_de" => "",
					"form_sp" => "",
					"form_it" => "",
					"position" => getNextFormPosition(),
					"prix" => "0.00",
					"photo" => "",
					"valide" => "0"
			);
		}
	
		$vignette = "";
		if ($contenu["photo"] != "") {
			$vignette = '<img src="'.$contenu["photo"].'" class="width_all hide_nophoto" />';
		}
		$photo = '<input type="file" name="photo[]" class="saisie_text photo_upload show_nophoto" accept="image/*" />';
		$photo .= '<div id="img_vignettes" class="width_all">'.$vignette.'</div>';
		$photo .= '<input type="button" value="Supprimer la photo" name="delphoto" class="saisie_text hide_nophoto" onclick="delete_photo()" />';
	
	
		$page_header_title = 'dition de formule';
		 
		$header_system .= '
<script src="themes/System_mobile/js/jquery.exif.js"></script>
<script src="themes/System_mobile/js/jquery.canvasResize.js"></script>
<script>
	jQuery(function() {
		jQuery( "#tabs" ).tabs({
			show: { effect: "fade", duration: 500 },
			hide: { effect: "fade", duration: 500 }
		});
		jQuery("input[type=checkbox]").checkboxradio();
	});
</script>
<script>
		jQuery(document).ready(function(){
			var state_upload = ("'.$contenu["photo"].'" == "");
			//console.log(state_upload);
			if (state_upload) {
				//montrer ce qui sert  uploader et masquer le reste
				jQuery(".hide_nophoto").hide();
				jQuery(".show_nophoto").show();
			}
			else {
				//masquer ce qui sert  uploader et montrer le reste
				jQuery(".hide_nophoto").show();
				jQuery(".show_nophoto").hide();
			}
		});
		function delete_photo() {
			if (confirm("En tes-vous sr(e) ?\nLa photo sera immdiatement supprime.")) {
				if (jQuery("#dataId").val() != "") {
					var urldel = "system_mobile.php?op=deletephotoformresto&Id="+jQuery("#dataId").val();
				}
				else {
					if (jQuery("#dataPhoto").val() != "") {
						var urldel = "system_mobile.php?op=deletephotoformresto&photo="+jQuery("#dataPhoto").val();
					}
					else {
						alert("Erreur : il n\'y a aucune image  supprimer !");
					}
				}
				jQuery.ajax(urldel,{
					success: function (msg) {
						if (msg == "ok") {
							jQuery("#dataPhoto").val("");
							jQuery(".hide_nophoto").slideUp(function() {
								jQuery(".show_nophoto").slideDown();
							});
						}
						else {
							alert("Aucune modification effectue !");
						}
					}
				});
			}
		}
		var op_upload_photo = "uploadphotoformresto";
</script>
	';
		 
		include ("system/header_system_mobile.php");
	
		$sortie = '';
		 
		$sortie .= '
<form action="system_mobile.php" method="post" class="nomarge">
	<div class="marge">
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><img src="themes/System_mobile/images/flags/flags_iso/32/fr.png" width="32" /></a></li>
				<li><a href="#tabs-2"><img src="themes/System_mobile/images/flags/flags_iso/32/gb.png" width="32" /></a></li>
				<li><a href="#tabs-3"><img src="themes/System_mobile/images/flags/flags_iso/32/it.png" width="32" /></a></li>
				<li><a href="#tabs-4"><img src="themes/System_mobile/images/flags/flags_iso/32/de.png" width="32" /></a></li>
				<li><a href="#tabs-5"><img src="themes/System_mobile/images/flags/flags_iso/32/es.png" width="32" /></a></li>
			</ul>
			<div id="tabs-1">
				Formule franais : <input type="text" name="data[form_fr]" value="'.str_replace('"', "&quot;", $contenu["form_fr"]).'" class="saisie_text" />
			</div>
			<div id="tabs-2">
				Formule anglais : <input type="text" name="data[form_uk]" value="'.str_replace('"', "&quot;", $contenu["form_uk"]).'" class="saisie_text" />
			</div>
			<div id="tabs-3">
				Formule italien : <input type="text" name="data[form_it]" value="'.str_replace('"', "&quot;", $contenu["form_it"]).'" class="saisie_text" />
			</div>
			<div id="tabs-4">
				Formule allemand : <input type="text" name="data[form_de]" value="'.str_replace('"', "&quot;", $contenu["form_de"]).'" class="saisie_text" />
			</div>
			<div id="tabs-5">
				Formule espagnol : <input type="text" name="data[form_sp]" value="'.str_replace('"', "&quot;", $contenu["form_sp"]).'" class="saisie_text" />
			</div>
		</div>
	</div>
	<div class="marge">
		Tarif : <input type="number" min="0.00" step="0.01" max="9999.99" name="data[prix]" value="'.str_replace('"', "&quot;", $contenu["prix"]).'" class="saisie_text" />
		
		</div>
	<div class="marge">
		Publication : <br />
		<div class="width_300"><input type="checkbox" value="1" name="data[valide]"'.(($contenu["valide"] == "1") ? ' checked="checked"' : '' ).' class="saisie_checkbox" id="publiform" /><label for="publiform">Formule publie</label></div>
	</div>
	<div class="marge">
		Photo : '.$photo.'
	</div>
	<div class="marge"><input type="submit" value="Enregistrer la formule" class="saisie_text submit" name="valid"></div>
	<input type="hidden" name="op" value="saveformresto" />
	<input type="hidden" name="data[Id]" value="'.$contenu["Id"].'" id="dataId" />
	<input type="hidden" name="data[position]" value="'.$contenu["position"].'" />
	<input type="hidden" name="data[photo]" value="'.$contenu["photo"].'" id="dataPhoto" />
</form>';
	
		 
		echo $sortie;
		 
		include ("system/footer_system_mobile.php");
	}
	
	function save_formule($form) {
		global $page_header_title, $header_system;
		global $prefix, $db ;
		$form = array_map("FixQuotes", $form);
		$form = array_map("stripslashes", $form);
	
		$form["valide"] = ($form["valide"] == "1") ? "1" : "0";
	
		if ($form["Id"] != "") {
			$contenu = getFormContent($form["Id"]);
			$form["position"] = $contenu["position"];
	
			$sql = "UPDATE ".$prefix."_resto_formule";
			$sql .= " SET form_fr='".$form["form_fr"]."', form_uk='".$form["form_uk"]."', form_de='".$form["form_de"]."', form_sp='".$form["form_sp"]."', form_it='".$form["form_it"]."', prix='".$form["prix"]."', position='".$form["position"]."', valide='".$form["valide"]."'";
			$sql .= " WHERE Id = ".$form["Id"]."";
			$result=$db->sql_query($sql);
			if (!$result) {
				$error = $db->sql_error();
				die('Invalid query:'.$error["message"]);
			}
		}
		else {
			$form["position"] = getNextFormPosition(); //au cas o une nouvelle formule aurait t cre avant que celle-ci ne soit enregistre.
	
			$sql = "INSERT INTO ".$prefix."_resto_formule";
			$sql .= " (form_fr, form_uk, form_de, form_sp, form_it, prix, position, photo, valide)";
			$sql .= "VALUES ('".$form["form_fr"]."','".$form["form_uk"]."','".$form["form_de"]."','".$form["form_sp"]."', '".$form["form_it"]."', '".$form["prix"]."', '".$form["position"]."', '".$form["photo"]."', '".$form["valide"]."');";
			$result=$db->sql_query($sql);
			if (!$result) {
				$error = $db->sql_error();
				die('Invalid query:'.$error["message"]);
			}
		}
	
		$header_system .= '
	<script>
		allerPage("system_mobile.php?op=listformresto",2000);
	</script>';
	
		$page_header_title = 'Enregistrement de formule';
		include ("system/header_system_mobile.php");
	
		//enregistrement dans la base de donnes  faire
	
		$sortie = '<alert class="center_v_abs">Formule enregistre</alert>';
	
		echo $sortie;
		include ("system/footer_system_mobile.php");
	}
	
	function swap_forms($Id, $sens) {
		global $prefix, $db;
	
		$oneform = getFormContent($Id);
	
		$where = " WHERE false ";
		switch ($sens) {
			case "up":
				$where = " WHERE `position` <= ".$oneform["position"]." ORDER BY `position` DESC limit 2";
				break;
			case "down":
				$where = " WHERE `position` >= ".$oneform["position"]." ORDER BY `position` ASC limit 2";
				break;
		}
	
		$ok = true;
	
		$sql = "SELECT Id, `position` FROM ".$prefix."_resto_formule".$where.";";
		//echo $sql;
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) == 2) {
			list($Id_init, $position_init) = $db->sql_fetchrow($result);
			list($Id_new, $position_new) = $db->sql_fetchrow($result);
			$sql = "UPDATE ".$prefix."_resto_formule";
			$sql .= " SET position='".$position_new."'";
			$sql .= " WHERE Id = ".$Id_init.";";
			//echo "\n".$sql;
			$ok = $ok && $db->sql_query($sql);
			$sql = "UPDATE ".$prefix."_resto_formule";
			$sql .= " SET position='".$position_init."'";
			$sql .= " WHERE Id = ".$Id_new.";";
			//echo "\n".$sql;
			$ok = $ok && $db->sql_query($sql);
			if ($ok) {
				echo "ok";
			}
			else {
				echo "pas ok";
			}
			die();
		}
		else {
			echo "pas ok du tout";
			die();
		}
	}
	
	function list_forms() {
		global $username, $language, $admin, $aid, $prefix, $file, $db, $sitename, $user, $currentlang, $page_header_title, $module_name, $header_system;
	
		$page_header_title = 'Liste des formules';
		 
		$header_system .= '
<script>
	var url_up = \'var url = "system_mobile.php?op=swapformsresto&Id="+id_elt+"&sens=up"\';
	var url_down = \'var url = "system_mobile.php?op=swapformsresto&Id="+id_elt+"&sens=down"\';
</script>';
		 
		include ("system/header_system_mobile.php");
		 
		$sortie = "";
		 
		$sortie .= '<div class="marge">';
		 
		$catforms = array();
		$catforms[] = array("Id" => "0", "catform_fr" => "Toutes les formules");
		$compteur = -1;
		foreach ($catforms as $onecatforms) {
			$compteur++;
			$sortie .= '
			<div class="combo"><a href="javascript:void(0)" class="combo" id="btn_content'.$compteur.'">'.$onecatforms["catform_fr"].'</a>
				<div class="ztxt_content" id="ztxt_content-btn_content'.$compteur.'">';
	
			$listeforms= '';
			$forms = getFormList();
			foreach ($forms as $oneform) {
				//$pub = ($oneplat["valide"] == "P") ? "Publi" : "Non publi";
				$np = ($oneform["valide"] == "1") ? "" : " np";
				//$src_picto = ($oneplat[6] == 1) ? 'themes/System_mobile/images/mobile.png' : 'themes/System_mobile/images/desktop.png';
				//$picto = '<img src="'.$src_picto.'" />';
				$style_item = '';
				if ($oneform["photo"] != "") {
					$style_item = ' class="with_photo"';
				}
				$prix = number_format($oneform["prix"],2,',',' ')." &euro;";
				$btn_up = '<img src="themes/System_mobile/images/btn_up.png" class="btn_up" id_elt="'.$oneform["Id"].'" />';
				$btn_down = '<img src="themes/System_mobile/images/btn_down.png" class="btn_down" id_elt="'.$oneform["Id"].'"/>';
				//$listeforms .= '<li class="collection-item-combo-doc'.$np.'"><a href="system_mobile.php?op=editformresto&id='.$oneform["Id"].'"'.$style_item.'><span class="act">'.$oneform["form_fr"].$btn_up.'<img src="themes/System_mobile/images/space.png" style="width: 5px;" />'.$btn_down.'</span></a></li>';
				$listeforms .= '<li class="collection-item-combo-doc'.$np.'"><a href="system_mobile.php?op=editformresto&id='.$oneform["Id"].'"'.$style_item.'>'.$oneform["form_fr"].'<span class="infos">'.$prix.$btn_up.'<img src="themes/System_mobile/images/space.png" style="width: 5px;" />'.$btn_down.'</span></a></li>';
			}
			if ($listeforms != '') {
				$sortie .= '<ul class="collection-combo-docs">'.$listeforms.'</ul>';
			}
	
			$sortie .= '
				</div>
			</div>';
		}
		 
		//$sortie .= '<help><span style="display: inline-block"><img src="themes/System_mobile/images/desktop.png"> page au format desktop</span> <span style="display: inline-block"><img src="themes/System_mobile/images/mobile.png"> page au format mobile</span></help>';
		 
		$sortie .= '</div>';
	
		echo $sortie;
		 
		include ("system/footer_system_mobile.php");
	}
	
	function getPlatsSansFormule() {
		global $db, $prefix, $multilingual;

		$platList = array();
		
		$sql = "SELECT ".$prefix."_resto_plat.Id,  ".$prefix."_resto_plat.`position`, `catid`, `nom_fr`, `com_fr`, `desc_fr`, `nom_uk`, `com_uk`, `desc_uk`, `nom_de`, `com_de`, `desc_de`, `nom_sp`, `com_sp`, `desc_sp`, `nom_it`, `com_it`, `desc_it`, `gluten`, `crustace`, `oeuf`, `poisson`, `arachide`, `soja`, `lait`, `fruitacoque`, `celeri`, `moutarde`, `sesame`, `sulfite`, `lupin`, `mollusque`,".$prefix."_resto_plat.`prix`, ".$prefix."_resto_plat.`photo`, ".$prefix."_resto_plat.`valide`, ".$prefix."_resto_link_plat_formule.id_formule";
		$sql .= " FROM  ".$prefix."_resto_plat";
		$sql .= " LEFT OUTER JOIN ".$prefix."_resto_link_plat_formule ON ".$prefix."_resto_plat.Id = ".$prefix."_resto_link_plat_formule.id_plat";
		$sql .= " WHERE ".$prefix."_resto_link_plat_formule.id_formule IS NULL";
		$sql .= " ORDER BY ".$prefix."_resto_plat.`nom_fr`ASC;";
	
		$result = $db->sql_query($sql);
	
		while ($ligne = $db->sql_fetchrow($result)) {
			$platList[]= array(
					"Id" => $ligne["Id"],
					"position" => $ligne["position"],
					"catid" => $ligne["catid"],
					"nom_fr" => $ligne["nom_fr"],
					"com_fr" => $ligne["com_fr"],
					"desc_fr" => $ligne["desc_fr"],
					"nom_uk" => $ligne["nom_uk"],
					"com_uk" => $ligne["com_uk"],
					"desc_uk" => $ligne["desc_uk"],
					"nom_de" => $ligne["nom_de"],
					"com_de" => $ligne["com_de"],
					"desc_de" => $ligne["desc_de"],
					"nom_sp" => $ligne["nom_sp"],
					"com_sp" => $ligne["com_sp"],
					"desc_sp" => $ligne["desc_sp"],
					"nom_it" => $ligne["nom_it"],
					"com_it" => $ligne["com_it"],
					"desc_it" => $ligne["desc_it"],
					"gluten" => $ligne["gluten"],
					"crustace" => $ligne["crustace"],
					"oeuf" => $ligne["oeuf"],
					"poisson" => $ligne["poisson"],
					"arachide" => $ligne["arachide"],
					"soja" => $ligne["soja"],
					"lait" => $ligne["lait"],
					"fruitacoque" => $ligne["fruitacoque"],
					"celeri" => $ligne["celeri"],
					"moutarde" => $ligne["moutarde"],
					"sesame" => $ligne["sesame"],
					"sulfite" => $ligne["sulfite"],
					"lupin" => $ligne["lupin"],
					"mollusque" => $ligne["mollusque"],
					"prix" => $ligne["prix"],
					"photo" => $ligne["photo"],
					"valide" => $ligne["valide"]
			);
		}
		$db->sql_freeresult($result);
		return $platList;
	}
	
	function list_plats_formule() {
		global $username, $language, $admin, $aid, $prefix, $file, $db, $sitename, $user, $currentlang, $page_header_title, $module_name, $header_system;
	
		$page_header_title = 'Organisation des formules';
		 
		$header_system .= '
		<script>
		var url_up = \'var url = "system_mobile.php?op=swapplatsresto&Id="+id_elt+"&sens=up"\';
		var url_down = \'var url = "system_mobile.php?op=swapplatsresto&Id="+id_elt+"&sens=down"\';
		</script>';
		 
		include ("system/header_system_mobile.php");
		 
		$sortie = "";
		 
		$sortie .= '<div class="marge">';
		 
		$formules = getFormList();
		//$categories[] = array("Id" => "0", "cat_fr" => "Plats sans catgorie");
		$compteur = -1;
		foreach ($formules as $oneformule) {
			$compteur++;
			$stlplus = ($oneformule["valide"]) ? "" : " nopub" ;
			$sortie .= '
			<div class="combo"><a href="javascript:void(0)" class="combo'.$stlplus.'" id="btn_content'.$compteur.'">'.$oneformule["form_fr"].'</a>
			<div class="ztxt_content" id="ztxt_content-btn_content'.$compteur.'">';
	
			$listeplats= '';
			$plats = getPlatList("",$oneformule["Id"]);
			foreach ($plats as $oneplat) {
				$pub = ($oneplat["valide"] == "1") ? "Publi" : "Non publi";
				$np = ($oneplat["valide"] == "1") ? "" : " np";
	
				$with_allergo = ($oneplat["gluten"] == "1") || ($oneplat["crustace"] == "1") || ($oneplat["oeuf"] == "1") || ($oneplat["poisson"] == "1") || ($oneplat["arachide"] == "1") || ($oneplat["soja"] == "1") || ($oneplat["lait"] == "1") || ($oneplat["fruitacoque"] == "1") || ($oneplat["celeri"] == "1") || ($oneplat["moutarde"] == "1") || ($oneplat["sesame"] == "1") || ($oneplat["sulfite"] == "1") || ($oneplat["lupin"] == "1") || ($oneplat["mollusque"] =="1");
				$allergisants = ($with_allergo) ? " - avec allergisants" : "";
		   
				$prix = " - ".number_format($oneplat["prix"],2,',',' ')." &euro;";
		   
				//$src_picto = ($oneplat[6] == 1) ? 'themes/System_mobile/images/mobile.png' : 'themes/System_mobile/images/desktop.png';
				//$picto = '<img src="'.$src_picto.'" />';
				$style_item = '';
				if ($oneplat["photo"] != "") {
					$style_item = ' class="with_photo"';
				}
				//$btn_up = '<img src="themes/System_mobile/images/btn_up.png" class="btn_up" id_elt="'.$oneplat["Id"].'" />';
				//$btn_down = '<img src="themes/System_mobile/images/btn_down.png" class="btn_down" id_elt="'.$oneplat["Id"].'"/>';
				//$listeplats .= '<li class="collection-item-combo-doc'.$np.'"><a href="system_mobile.php?op=editplatresto&next=byforms&id='.$oneplat["Id"].'"'.$style_item.'>'.$oneplat["nom_fr"].'<span class="infos">'.$pub.$allergisants.$prix.$btn_up.'<img src="themes/System_mobile/images/space.png" style="width: 5px;" />'.$btn_down.'</span></a></li>';
				$listeplats .= '<li class="collection-item-combo-doc'.$np.'"><a href="system_mobile.php?op=editplatresto&next=byforms&id='.$oneplat["Id"].'"'.$style_item.'>'.$oneplat["nom_fr"].'<span class="infos">'.$pub.$allergisants.$prix.'</span></a></li>';
			}
			
			if ($listeplats != '') {
				$sortie .= '<ul class="collection-combo-docs">'.$listeplats.'</ul>';
			}
	
			$sortie .= '
			</div>
			</div>';
		}
		
		$compteur++;
		$sortie .= '
		<div class="combo"><a href="javascript:void(0)" class="combo nopub" id="btn_content'.$compteur.'">Tous les plats</a>
		<div class="ztxt_content" id="ztxt_content-btn_content'.$compteur.'">';
		
		$listeplats= '';
		//$plats = getPlatsSansFormule();
		$plats = getPlatList(0);
		foreach ($plats as $oneplat) {
			$pub = ($oneplat["valide"] == "1") ? "Publi" : "Non publi";
			$np = ($oneplat["valide"] == "1") ? "" : " np";
		
			$with_allergo = ($oneplat["gluten"] == "1") || ($oneplat["crustace"] == "1") || ($oneplat["oeuf"] == "1") || ($oneplat["poisson"] == "1") || ($oneplat["arachide"] == "1") || ($oneplat["soja"] == "1") || ($oneplat["lait"] == "1") || ($oneplat["fruitacoque"] == "1") || ($oneplat["celeri"] == "1") || ($oneplat["moutarde"] == "1") || ($oneplat["sesame"] == "1") || ($oneplat["sulfite"] == "1") || ($oneplat["lupin"] == "1") || ($oneplat["mollusque"] =="1");
			$allergisants = ($with_allergo) ? " - avec allergisants" : "";
			 
			$prix = " - ".number_format($oneplat["prix"],2,',',' ')." &euro;";
			 
			//$src_picto = ($oneplat[6] == 1) ? 'themes/System_mobile/images/mobile.png' : 'themes/System_mobile/images/desktop.png';
			//$picto = '<img src="'.$src_picto.'" />';
			$style_item = '';
			if ($oneplat["photo"] != "") {
				$style_item = ' class="with_photo"';
			}
			//$btn_up = '<img src="themes/System_mobile/images/btn_up.png" class="btn_up" id_elt="'.$oneplat["Id"].'" />';
			//$btn_down = '<img src="themes/System_mobile/images/btn_down.png" class="btn_down" id_elt="'.$oneplat["Id"].'"/>';
			//$listeplats .= '<li class="collection-item-combo-doc'.$np.'"><a href="system_mobile.php?op=editplatresto&next=byforms&id='.$oneplat["Id"].'"'.$style_item.'>'.$oneplat["nom_fr"].'<span class="infos">'.$pub.$allergisants.$prix.$btn_up.'<img src="themes/System_mobile/images/space.png" style="width: 5px;" />'.$btn_down.'</span></a></li>';
			$listeplats .= '<li class="collection-item-combo-doc'.$np.'"><a href="system_mobile.php?op=editplatresto&next=byforms&id='.$oneplat["Id"].'"'.$style_item.'>'.$oneplat["nom_fr"].'<span class="infos">'.$pub.$allergisants.$prix.'</span></a></li>';
		}
			
		if ($listeplats != '') {
			$sortie .= '<ul class="collection-combo-docs">'.$listeplats.'</ul>';
		}
		
		$sortie .= '
		</div>
		</div>';
		 
		//$sortie .= '<help><span style="display: inline-block"><img src="themes/System_mobile/images/desktop.png"> page au format desktop</span> <span style="display: inline-block"><img src="themes/System_mobile/images/mobile.png"> page au format mobile</span></help>';
		 
		$sortie .= '</div>';
	
		echo $sortie;
		 
		include ("system/footer_system_mobile.php");
	}
	
	function delete_photo_plat($Id, $photo = "") {
		global $prefix, $db;
	
		if ($Id != "") {
			$oneplat = getPlatContent($Id);
			
			$sql = "UPDATE ".$prefix."_resto_plat";
			$sql .= " SET photo=''";
			$sql .= " WHERE Id = ".$Id."";
			$result = $db->sql_query($sql);
			if ($result) {
				if (file_exists($oneplat["photo"])) {
					unlink($oneplat["photo"]);
				}
				echo "ok";
			}
			else {
				echo "pas ok du tout";
			}
		}
		else {
			if ($photo != "") {
				if (file_exists($photo)) {
					unlink($photo);
					echo "ok";
				}
				else {
					echo "pas ok : mauvais nom de fichier transmis";
				}
			}
			else {
				echo "Erreur : rien  modifier !";
			}
		}
		die();
	}
	
	function delete_photo_cat($Id, $photo = "") {
		global $prefix, $db;
	
		if ($Id != "") {
			$onecat = getCatContent($Id);
				
			$sql = "UPDATE ".$prefix."_resto_categorie";
			$sql .= " SET photo=''";
			$sql .= " WHERE Id = ".$Id."";
			$result = $db->sql_query($sql);
			if ($result) {
				if (file_exists($onecat["photo"])) {
					unlink($onecat["photo"]);
				}
				echo "ok";
			}
			else {
				echo "pas ok du tout";
			}
		}
		else {
			if ($photo != "") {
				if (file_exists($photo)) {
					unlink($photo);
					echo "ok";
				}
				else {
					echo "pas ok : mauvais nom de fichier transmis";
				}
			}
			else {
				echo "Erreur : rien  modifier !";
			}
		}
		die();
	}
	
	function delete_photo_accomp($Id, $photo = "") {
		global $prefix, $db;
	
		if ($Id != "") {
			$oneaccomp = getAccompContent($Id);
				
			$sql = "UPDATE ".$prefix."_resto_accompagnement";
			$sql .= " SET photo=''";
			$sql .= " WHERE Id = ".$Id."";
			$result = $db->sql_query($sql);
			if ($result) {
				if (file_exists($oneaccomp["photo"])) {
					unlink($oneaccomp["photo"]);
				}
				echo "ok";
			}
			else {
				echo "pas ok du tout";
			}
		}
		else {
			if ($photo != "") {
				if (file_exists($photo)) {
					unlink($photo);
					echo "ok";
				}
				else {
					echo "pas ok : mauvais nom de fichier transmis";
				}
			}
			else {
				echo "Erreur : rien  modifier !";
			}
		}
		die();
	}
	
	function delete_photo_form($Id, $photo = "") {
		global $prefix, $db;
	
		if ($Id != "") {
			$oneform = getFormContent($Id);
	
			$sql = "UPDATE ".$prefix."_resto_formule";
			$sql .= " SET photo=''";
			$sql .= " WHERE Id = ".$Id."";
			$result = $db->sql_query($sql);
			if ($result) {
				if (file_exists($oneform["photo"])) {
					unlink($oneform["photo"]);
				}
				echo "ok";
			}
			else {
				echo "pas ok du tout";
			}
		}
		else {
			if ($photo != "") {
				if (file_exists($photo)) {
					unlink($photo);
					echo "ok";
				}
				else {
					echo "pas ok : mauvais nom de fichier transmis";
				}
			}
			else {
				echo "Erreur : rien  modifier !";
			}
		}
		die();
	}
	
	function upload_photo_plat_resto($id_plat) {
		global $prefix, $db;
		// Result object
		$r = new stdClass();
		
		header('cache-control: no-cache'); // no-cache (important for mobile safari)
		header('content-type: application/json'); // Result content type

		// Maximum file size
		$maxsize = 2; //Mb
		$r->error = '';
		$r->result_upload = 'false';
		// File size control
		if ($_FILES['photo']['size'][0] > ($maxsize * 1048576)) {		
			$r->error .= "Error: Max file size: $maxsize Kb";
		}
		else {
			// If the file is an image
			if (!preg_match('/image/i', $_FILES['photo']['type'][0])) {
				$r->error .= "Error: Only image files";
			}
			else {
				// Supporting image file types
				$types = Array('image/png', 'image/gif', 'image/jpeg');
				// File type control
				$r->debug = $_FILES['photo']['type'][0];
				if (in_array($_FILES['photo']['type'][0], $types)) {
					include("core/conf/uploadconfig.php");
				    $chemin = $uploadFolder."/../simple_resto";
				    $photosSaved = uploadFiles($_FILES["photo"], $chemin);
				    if (count($photosSaved) > 0) {
				    	if ($id_plat != "") {
					    	$sql = "UPDATE ".$prefix."_resto_plat";
					    	$sql .= " SET photo='".$photosSaved[0]."'";
					    	$sql .= " WHERE Id = ".$id_plat."";
					    	$result = $db->sql_query($sql);
					    	if (!$result) {
					    		$error = $db->sql_error();
					    		die("Erreur sur mise  jour photo : ".$error["message"]);
					    	}
				    	}
				    	$r->filenamesaved = $photosSaved[0];
				    	$r->result_upload = 'true';
				    }
				}
				else {
					// If the file is not an image
					$r->error .= "Error: this is not an image file";
				}
				// Result data
				/*$r->filename = $filename;
				$r->path = $path;
				$r->img = '<img src="' . $r->path . $r->filename . '" alt="image" />';*/
			}
		}
		
		// Return to JSON
		echo json_encode($r);
		die();
	}
	
	function upload_photo_cat_resto($id_cat) {
		global $prefix, $db;
		// Result object
		$r = new stdClass();
	
		header('cache-control: no-cache'); // no-cache (important for mobile safari)
		header('content-type: application/json'); // Result content type
	
		// Maximum file size
		$maxsize = 2; //Mb
		$r->error = '';
		$r->result_upload = 'false';
		// File size control
		if ($_FILES['photo']['size'][0] > ($maxsize * 1048576)) {
			$r->error .= "Error: Max file size: $maxsize Kb";
		}
		else {
			// If the file is an image
			if (!preg_match('/image/i', $_FILES['photo']['type'][0])) {
				$r->error .= "Error: Only image files";
			}
			else {
				// Supporting image file types
				$types = Array('image/png', 'image/gif', 'image/jpeg');
				// File type control
				$r->debug = $_FILES['photo']['type'][0];
				if (in_array($_FILES['photo']['type'][0], $types)) {
					include("core/conf/uploadconfig.php");
					$chemin = $uploadFolder."/../simple_resto";
					$photosSaved = uploadFiles($_FILES["photo"], $chemin);
					if (count($photosSaved) > 0) {
						if ($id_cat != "") {
							$sql = "UPDATE ".$prefix."_resto_categorie";
							$sql .= " SET photo='".$photosSaved[0]."'";
							$sql .= " WHERE Id = ".$id_cat."";
							$result = $db->sql_query($sql);
							if (!$result) {
								$error = $db->sql_error();
								die("Erreur sur mise  jour photo 2 : ".$error["message"]);
							}
						}
						$r->filenamesaved = $photosSaved[0];
						$r->result_upload = 'true';
					}
				}
				else {
					// If the file is not an image
					$r->error .= "Error: this is not an image file";
				}
				// Result data
				/*$r->filename = $filename;
					$r->path = $path;
				$r->img = '<img src="' . $r->path . $r->filename . '" alt="image" />';*/
			}
		}
	
		// Return to JSON
		echo json_encode($r);
		die();
	}
	
	function upload_photo_accomp_resto($id_accomp) {
		global $prefix, $db;
		// Result object
		$r = new stdClass();
	
		header('cache-control: no-cache'); // no-cache (important for mobile safari)
		header('content-type: application/json'); // Result content type
	
		// Maximum file size
		$maxsize = 2; //Mb
		$r->error = '';
		$r->result_upload = 'false';
		// File size control
		if ($_FILES['photo']['size'][0] > ($maxsize * 1048576)) {
			$r->error .= "Error: Max file size: $maxsize Kb";
		}
		else {
			// If the file is an image
			if (!preg_match('/image/i', $_FILES['photo']['type'][0])) {
				$r->error .= "Error: Only image files";
			}
			else {
				// Supporting image file types
				$types = Array('image/png', 'image/gif', 'image/jpeg');
				// File type control
				$r->debug = $_FILES['photo']['type'][0];
				if (in_array($_FILES['photo']['type'][0], $types)) {
					include("core/conf/uploadconfig.php");
					$chemin = $uploadFolder."/../simple_resto";
					$photosSaved = uploadFiles($_FILES["photo"], $chemin);
					if (count($photosSaved) > 0) {
						if ($id_accomp != "") {
							$sql = "UPDATE ".$prefix."_resto_accompagnement";
							$sql .= " SET photo='".$photosSaved[0]."'";
							$sql .= " WHERE Id = ".$id_accomp."";
							$result = $db->sql_query($sql);
							if (!$result) {
								$error = $db->sql_error();
								die("Erreur sur mise  jour photo : ".$error["message"]);
							}
						}
						$r->filenamesaved = $photosSaved[0];
						$r->result_upload = 'true';
					}
				}
				else {
					// If the file is not an image
					$r->error .= "Error: this is not an image file";
				}
				// Result data
				/*$r->filename = $filename;
					$r->path = $path;
				$r->img = '<img src="' . $r->path . $r->filename . '" alt="image" />';*/
			}
		}
	
		// Return to JSON
		echo json_encode($r);
		die();
	}
	
	function upload_photo_formule_resto($id_formule) {
		global $prefix, $db;
		// Result object
		$r = new stdClass();
	
		header('cache-control: no-cache'); // no-cache (important for mobile safari)
		header('content-type: application/json'); // Result content type
	
		// Maximum file size
		$maxsize = 2; //Mb
		$r->error = '';
		$r->result_upload = 'false';
		// File size control
		if ($_FILES['photo']['size'][0] > ($maxsize * 1048576)) {
			$r->error .= "Error: Max file size: $maxsize Kb";
		}
		else {
			// If the file is an image
			if (!preg_match('/image/i', $_FILES['photo']['type'][0])) {
				$r->error .= "Error: Only image files";
			}
			else {
				// Supporting image file types
				$types = Array('image/png', 'image/gif', 'image/jpeg');
				// File type control
				$r->debug = $_FILES['photo']['type'][0];
				if (in_array($_FILES['photo']['type'][0], $types)) {
					include("core/conf/uploadconfig.php");
					$chemin = $uploadFolder."/../simple_resto";
					$photosSaved = uploadFiles($_FILES["photo"], $chemin);
					if (count($photosSaved) > 0) {
						if ($id_formule != "") {
							$sql = "UPDATE ".$prefix."_resto_formule";
							$sql .= " SET photo='".$photosSaved[0]."'";
							$sql .= " WHERE Id = ".$id_formule."";
							$result = $db->sql_query($sql);
							if (!$result) {
								$error = $db->sql_error();
								die("Erreur sur mise  jour photo : ".$error["message"]);
							}
						}
						$r->filenamesaved = $photosSaved[0];
						$r->result_upload = 'true';
					}
				}
				else {
					// If the file is not an image
					$r->error .= "Error: this is not an image file";
				}
				// Result data
				/*$r->filename = $filename;
				 $r->path = $path;
				$r->img = '<img src="' . $r->path . $r->filename . '" alt="image" />';*/
			}
		}
	
		// Return to JSON
		echo json_encode($r);
		die();
	}
	
	if (!isset($id)) {
		$id = "";
	}
	if (!isset($next)) {
		$next = "";
	}
	
	switch ($op) {
		case "listcatresto":
			list_cats();
			break;
		case "newcatresto":
		case "editcatresto":
			edit_cat($id);
			break;
		case "savecatresto":
			save_cat($data);
			break;
		case "swapcatsresto":
			swap_cats($Id,$sens);
			break;
		case "deletephotocatresto":
			delete_photo_cat($Id, $photo);
			break;
		case "uploadphotocatresto" :
			upload_photo_cat_resto($Id);
			break;
					
		case "listaccompresto":
			list_accomps();
			break;
		case "newaccompresto":
		case "editaccompresto":
			edit_accomp($id);
			break;
		case "saveaccompresto":
			save_accomp($data);
			break;
		case "swapaccompsresto":
			swap_accomps($Id,$sens);
			break;
		case "deletephotoaccompresto":
			delete_photo_accomp($Id, $photo);
			break;
		case "uploadphotoaccompresto" :
			upload_photo_accomp_resto($Id);
			break;

		case "listformresto":
			list_forms();
			break;
		case "newformresto":
		case "editformresto":
			edit_formule($id);
			break;
		case "saveformresto":
			save_formule($data);
			break;
		case "swapformsresto":
			swap_forms($Id,$sens);
			break;
		case "uploadphotoformresto" :
			upload_photo_formule_resto($Id);
			break;
		case "deletephotoformresto":
			delete_photo_form($Id, $photo);
			break;
		case "designformresto":
			list_plats_formule();
			break;
			
		case "newplatresto":
		case "editplatresto":
			edit_plat($id,$next);
			break;
		case "saveplatresto":
			save_plat($data,$next);
			break;
		case "swapplatsresto":
			swap_plats($Id,$sens);
			break;
		case "deletephotoplatresto":
			delete_photo_plat($Id, $photo);
			break;
		case "uploadphotoplatresto" :
			upload_photo_plat_resto($Id);
			break;		
		case "listplatresto":
		default:
			list_plats();
			break;
	}
}
else {
	display_denied();
}

?>