<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2005 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

//if (!defined('MODULE_FILE')) {
//	die ("You can't access this file directly...");
//}
if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}
require_once("core/becms_mainlib_lib.php");
require_once("core/becms_ui_component.php");
$module_name = basename(dirname(__FILE__));
get_lang($module_name);
$userpage = 1;

if(isset($_GET['redirect'])) $redirect = substr($_SERVER['QUERY_STRING'], strpos($_SERVER['QUERY_STRING'], "redirect=") + strlen("redirect="), strlen($_SERVER['QUERY_STRING']));

function format_nuke_url($nukeurl) {
	$tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}
	return $racine;	
}

/**
 *
 *
 */
function list_newsletters() {
	global $prefix,$sitename, $module_name,$db;
	global $displaynewsletterpopup, $Default_Theme, $sizenewsletterpopup;
	global $pagenewsletterlisthead;
	include("header.php");
	$sortie = "";
	if ($displaynewsletterpopup) {
		if ($sizenewsletterpopup != "") {
			list($largeur,$hauteur) = explode("/",$sizenewsletterpopup);
		}
		else {
			$largeur = "800";
			$hauteur = "400";
		}
		$themePopUp = (!file_exists('javascripts/windows_js/themes/'.'becms_'.$Default_Theme.'.css')) ? "becms_alphacube" : "becms_".$Default_Theme;
		$sortie .= '
<script type="text/javascript" src="javascripts/windows_js/javascripts/prototype.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/effects.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/window_ext.js"></script>
<script type="text/javascript" src="javascripts/windows_js/javascripts/debug.js"></script>
<link href="javascripts/windows_js/themes/default.css" rel="stylesheet" type="text/css" />
<link type="text/css" rel="stylesheet" href="javascripts/windows_js/themes/'.$themePopUp.'.css" />
<script type="text/javascript">
	var win=null;
	function ouvre_minifiche(titre,url) {
		win = new Window({className: "'.$themePopUp.'", title: titre, width:'.$largeur.', height:'.$hauteur.', destroyOnClose: true, recenterAuto:true, url: url, minimizable: true, maximizable: true});
		win.showCenter(true);
	}
</script>
';
	}	
	$result = $db->sql_query("select newsletterid, seccont_artid, title,  date, informant from ".$prefix."_newsletter where public='1' order by date desc");
	if ($db->sql_numrows($result) == 0) {
		$sortie .= "<h1>"._NEWLETTERTITLELISTING."</h1>";
		$sortie .= "<p>"._NEWLETTERNOTFOUND."</p>";
	}
	else {
		if (function_exists("FormatIndexNewsletter")) {
			$lignes = array();
			while ($ligne = $db->sql_fetchrow($result)) {
				$lignes[] = $ligne;
			}
			FormatIndexNewsletter($lignes);
		}
		else {
			if ($pagenewsletterlisthead != "") {
				require_once("modules/Sections/connector_class.php");
				$sectmodule = new pageconnector();
				$sortie .= $sectmodule->getPageContent($pagenewsletterlisthead,"",true);
			}
			else {
				$sortie .= "<h1>"._NEWLETTERTITLELISTING."</h1>";
				$sortie .= "<p>".str_replace("<!--lien-->", "modules.php?name=SimpleUsers&op=submituser", _NEWLETTERTEXTLISTING)."</p>";
			}
			$sortie .= "<ul>";
			while ($ligne = $db->sql_fetchrow($result)) {
				$sortie .= "<li>";
				//$sortie .= "<a href=\"modules.php?name=Sections&sop=viewarticle&artid=".$ligne["seccont_artid"]."\">";
				if ($displaynewsletterpopup) {
					$sortie .= "<a href=\"modules.php?name=".$module_name."&op=display_newsletter&artid=".$ligne["seccont_artid"]."\" title=\"Cliquez pour ouvrir\" onclick=\"ouvre_minifiche(this.title,this.href); return false\">";
				}
				else {
					$sortie .= "<a href=\"modules.php?name=".$module_name."&op=display_newsletter&artid=".$ligne["seccont_artid"]."\">";
				}
				$sortie .= preg_replace("#([0-9]{4})-([0-9]{2})-([0-9]{2}) ([0-9]{2}):([0-9]{2}):([0-9]{2})#","\\3/\\2/\\1",$ligne["date"])." : ".$ligne["title"];
				$sortie .= "</a>";
				$sortie .= "</li>";
			}
			$sortie .= "</ul>";
		}
	}
	echo $sortie;
	$bardef=array(
		//"print"=>"modules.php?name=Sections&sop=printpage&amp;artid=$artid",
		//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
		"back"=>"javascript:window.history.back()",
        "top"=>"#top"
	);
	buttonBar($bardef, "align");	
	include("footer.php");
}

function displayNewsletter($artid) {
	global $sitename,$Default_Theme;
	global $displaynewsletterpopup;
	
	require_once("modules/Sections/connector_class.php");
	$cc = new pageconnector();
	$sortie = "";
	
	if (!$displaynewsletterpopup) {
		include("header.php");	
		$sortie .= "<h1 id=\"nl\">"._NEWLETTERTITLELISTING."</h1>";
	}
	else {
		$sortie = '<html>
		<head><title>'.$sitename.'</title>
		<link rel="StyleSheet" href="themes/'.$Default_Theme.'/style/style.css" type="text/css" media="screen">
		</head>
		<body>';
	}
	
	$sortie .= $cc->getPageContent($artid,"", true);
	echo $sortie;
	
	if (!$displaynewsletterpopup) {
		$bardef=array(
			//"print"=>"modules.php?name=Sections&sop=printpage&amp;artid=$artid",
			//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back"=>"javascript:window.history.back()",
            "top"=>"#top"
		);
		buttonBar($bardef, "align");
		include("footer.php");
	}
	else {
		echo '</body></html>';
	}
}


// -------------------------------- SWITCH PART --------------------------------
switch($op) {
	case "list_newsletters":
		list_newsletters();
		break;

	case "display_newsletter":
		displayNewsletter($artid);
		break;

	default:
		list_newsletters();
		break;

}

?>