<?php
/*Numrotation des actions
 * 001 : recherche par domaine dans l'annuaire
 * 002 : consultation d'une fiche de l'annuaire
 * 101 : login d'un membre
 * 102 : modification de fiche membre (et donc d'annuaire)
 * 201 : dpot d'offre d'emploi et de stage
 * 202 : consultation des candidatures spontannes
 * 203 : dpot de candidature spontanne
 * 301 : consultation des marchs publics
 */
class membersStats {
	
	var $My_SQL = array();
	var $doit = "1";
	
	function membersStats() {
		global $db,$prefix,$stats_for_members;
		$this->My_SQL["maBase"] = $db;
		$this->My_SQL["stats"] = $prefix."_users_stats";
		$this->doit = $stats_for_members;
	}
	
	function conditionnertodb($texte) {
		//$texte = utf8_encode($texte);
		return (str_replace("'","''",stripslashes($texte)));
	}
	
	function add_action($action) {
		if ($this->doit == "0") {
			return false;
		}
		global $user;
		if (is_user($user)) {
			$user_data_bloc = base64_decode($user);
		    $userdata = explode(":", $user_data_bloc);
			$uid = $userdata[0];
			$username = $userdata[1];
		}
		else {
			$uid = "0";
			$username = "Anonyme";
		}
		$action = $this->conditionnertodb($action);
		$username = $this->conditionnertodb($username);
		$ip = $_SERVER["REMOTE_ADDR"];
		$quand = date("Y-m-d H:i:s");
		$sql = "INSERT INTO ".$this->My_SQL["stats"]."(`quand`, `ip`, `user_id`, `user_name`, `action`) VALUES ('$quand','$ip','$uid','$username','$action')";
		return $this->My_SQL["maBase"]->sql_query($sql);
	}
	
	function date2AMJ($ladate,$with_heure=true){
		if ($ladate == "") {
			return "0000-00-00 00:00:00";
		}
		else {
			list ($ladate,$lheure) = explode(" ",$ladate);
			list($jour,$mois,$annee) = explode("/",$ladate);
			$jour = str_pad($jour, 2, "0",STR_PAD_LEFT);
			$mois = str_pad($mois, 2, "0",STR_PAD_LEFT);
			if (strlen($annee) == 2) {
				$annee = "20".$annee;
			}
			elseif (strlen($annee) == 1) {
				$annee = "200".$annee;
			}
		}
		if ($with_heure) {
			if ($lheure != "") {
				$lheure = " ".$lheure;
			}
			return "$annee-$mois-$jour$lheure";
		}
		else {
			return "$annee-$mois-$jour";
		}
	}
	
	function datePlusUn ($ladate) {
		list($an, $mois, $jour) = explode("-",$ladate);
		return date("Y-m-d",mktime(0,0,0,$mois,($jour + 1),$an));
	}
	
	function commun_chaine_gauche($string1,$string2) {
		for ($i=0;$i<(strlen($string1)); $i++) {
			if ($string1{$i} != $string2{$i}) {
				break;
			}
		}
 		return substr($string1,0,$i);
	}
	function commun_chaine_gauche_mot($string1,$string2) {
		for ($i=0;$i<(strlen($string1)); $i++) {
			if ($string1{$i} != $string2{$i}) {
				break;
			}
		}
		if ($string1{($i)} != " ") {
			for ($j=$i;$j>=0; $j--) {
				if ($string1{$j} == " ") {
					break;
				}
			}
			$i = $j+1;
		}
 		return substr($string1,0,$i);
	}
	
	function suppr_chaine_gauche($chaine, $suppr) {
		return substr_replace($chaine,"",0,strlen($suppr));
	}
	
	function diff_str_right($chaine1, $chaine2) {
		return $this->suppr_chaine_gauche($chaine1, $this->commun_chaine_gauche($chaine1,$chaine2));
	}
	
	function stat_fic_annu($debstat,$finstat) {
		$valeurs = array();
		$periode = "";
		if ($debstat != "") {
			$periode .= _SMEMBERSSTATFROM.$debstat;
		}
		if ($finstat != "") {
			$periode .= _SMEMBERSSTATTO.$finstat;
		}
		$debstat = $this->date2AMJ($debstat,false);
		$finstat = $this->date2AMJ($finstat,false);
		$finstat = $this->datePlusUn($finstat);
		$cond = " WHERE `action` like '002%'";
		$sql = "SELECT DISTINCT action FROM ".$this->My_SQL["stats"].$cond.";";
		
		$result = $this->My_SQL["maBase"]->sql_query($sql);
		if ($this->My_SQL["maBase"]->sql_numrows($result) != 0) {
			while ($ligne = $this->My_SQL["maBase"]->sql_fetchrow($result)) {
				$chaine[] = $ligne["action"];
			}
		}
		$commun = $this->commun_chaine_gauche_mot($chaine[0],$chaine[1]);

		if ($debstat != "") {
			$cond .= ($cond == "") ? " WHERE " : " AND ";
			$cond .= "`quand`>='".$debstat."'";
		}
		if ($finstat != "") {
			$cond .= ($cond == "") ? " WHERE " : " AND ";
			$cond .= "`quand`<'".$finstat."'";
		}
		
		
		$sql = "SELECT count(Id) AS nbre, action FROM ".$this->My_SQL["stats"].$cond." GROUP BY `action`;";
		$result = $this->My_SQL["maBase"]->sql_query($sql);
		if ($this->My_SQL["maBase"]->sql_numrows($result) != 0) {
			while ($ligne = $this->My_SQL["maBase"]->sql_fetchrow($result)) {
				$nbre = $ligne["nbre"];
				$chaine2 = $this->suppr_chaine_gauche($ligne["action"], $commun);
				$valeurs[$chaine2] = $nbre;
			}
		}
		
		$sql = "SELECT count(Id) AS nbre FROM ".$this->My_SQL["stats"].$cond.";";
		$result = $this->My_SQL["maBase"]->sql_query($sql);
		if ($this->My_SQL["maBase"]->sql_numrows($result) != 0) {
			$ligne = $this->My_SQL["maBase"]->sql_fetchrow($result);
			$nbre = $ligne["nbre"];
			$valeurs["Total"] = $nbre;
		}
		//print_r($valeurs);
		$sortie = "<table class=\"lisTable\"><tr class=\"systemTabHeader\">\n";
		$sortie .= "<td class=\"systemTabHeader\">"._SMEMBERSSTATTHEMEMBER.$periode."</td>\n";
		$sortie .= "<td class=\"systemTabHeader\">"._SMEMBERSSTATNUMBEROFTIMES."</td>\n";
		$sortie .= "</tr>";
		
		foreach ($valeurs as $key=>$valeur) {
			if ($pos % 2 == 0){
				$thestyle="listTableOdd";
			} 
			else {
				$thestyle="listTableNone";
			}
			$sortie .= "<tr class=\"$thestyle\">";
			$sortie .= "<td >&nbsp;&nbsp;&nbsp;&nbsp;<b>$key</b></td>\n";
			$sortie .= "<td>$valeur</td>\n";
			$sortie .= "</tr>";
			$pos++;
		}

		$sortie .= "\n</table>";
		
		return $sortie;
	}

	function stat_rec_dom_annu($debstat,$finstat) {
		$valeurs = array();
		$periode = "";
		if ($debstat != "") {
			$periode .= _SMEMBERSSTATFROM.$debstat;
		}
		if ($finstat != "") {
			$periode .= _SMEMBERSSTATTO.$finstat;
		}
		$debstat = $this->date2AMJ($debstat,false);
		$finstat = $this->date2AMJ($finstat,false);
		$finstat = $this->datePlusUn($finstat);
		$cond = " WHERE `action` like '001%'";
		$sql = "SELECT DISTINCT action FROM ".$this->My_SQL["stats"].$cond.";";
		
		$result = $this->My_SQL["maBase"]->sql_query($sql);
		if ($this->My_SQL["maBase"]->sql_numrows($result) != 0) {
			while ($ligne = $this->My_SQL["maBase"]->sql_fetchrow($result)) {
				$chaine[] = $ligne["action"];
			}
		}
		$commun = $this->commun_chaine_gauche_mot($chaine[0],$chaine[1]);

		if ($debstat != "") {
			$cond .= ($cond == "") ? " WHERE " : " AND ";
			$cond .= "`quand`>='".$debstat."'";
		}
		if ($finstat != "") {
			$cond .= ($cond == "") ? " WHERE " : " AND ";
			$cond .= "`quand`<'".$finstat."'";
		}
		
		
		$sql = "SELECT count(Id) AS nbre, action FROM ".$this->My_SQL["stats"].$cond." GROUP BY `action`;";
		$result = $this->My_SQL["maBase"]->sql_query($sql);
		if ($this->My_SQL["maBase"]->sql_numrows($result) != 0) {
			while ($ligne = $this->My_SQL["maBase"]->sql_fetchrow($result)) {
				$nbre = $ligne["nbre"];
				$chaine2 = $this->suppr_chaine_gauche($ligne["action"], $commun);
				$valeurs[$chaine2] = $nbre;
			}
		}
		
		$sql = "SELECT count(Id) AS nbre FROM ".$this->My_SQL["stats"].$cond.";";
		$result = $this->My_SQL["maBase"]->sql_query($sql);
		if ($this->My_SQL["maBase"]->sql_numrows($result) != 0) {
			$ligne = $this->My_SQL["maBase"]->sql_fetchrow($result);
			$nbre = $ligne["nbre"];
			$valeurs["Total"] = $nbre;
		}
		//print_r($valeurs);
		$sortie = "<table class=\"lisTable\"><tr class=\"systemTabHeader\">\n";
		$sortie .= "<td class=\"systemTabHeader\">"._SMEMBERSSTATTHESEARCH.$periode."</td>\n";
		$sortie .= "<td class=\"systemTabHeader\">"._SMEMBERSSTATNUMBEROFTIMES."</td>\n";
		$sortie .= "</tr>";
		
		foreach ($valeurs as $key=>$valeur) {
			if ($pos % 2 == 0){
				$thestyle="listTableOdd";
			} 
			else {
				$thestyle="listTableNone";
			}
			$sortie .= "<tr class=\"$thestyle\">";
			$sortie .= "<td >&nbsp;&nbsp;&nbsp;&nbsp;<b>$key</b></td>\n";
			$sortie .= "<td>$valeur</td>\n";
			$sortie .= "</tr>";
			$pos++;
		}

		$sortie .= "\n</table>";
		
		return $sortie;
	}
	
}


function home_stats() {
	$debut = "01/01/".date("Y");
	$fin = "31/12/".date("Y");
	$sortie = '
<script type="text/javascript" src="javascripts/lang/lang-french.js"></script><script type="text/javascript" src="javascripts/control_form.js"></script>
<form name="choose_stat" method="POST" action="system.php?action=do_stats&op=members&onglet=stats" onsubmit="return submit_form(this)">
<div align="center">
<table cellpadding="0" cellspacing="10" border="0">
<tr><td  align="center"><b>'._SMEMBERSCHOOSESTATS.'</b></td></tr>
<tr><td>
'._SMEMBERSSTATSPERIODFROM.'<champ nom="debstat" lib="dbut du calcul" ctl="date"></champ><input type="text" name="debstat" class="saisiepetit" value="'.$debut.'">
'._SMEMBERSSTATSPERIODTO.'<champ nom="finstat" lib="fin du calcul" ctl="date"></champ><input type="text" name="finstat" class="saisiepetit" value="'.$fin.'">
</td></tr>
<tr><td>
<input type="radio" name="typestat" id="ts01" value="1"> <label for="ts01">'._SMEMBERSSTATSFICANNU.'</label>
</td></tr>
<tr><td>
<input type="radio" name="typestat" id="ts02" value="2"> <label for="ts02">'._SMEMBERSSTATSRECDOMANNU.'</label>
</td></tr>
<tr><td>
<input type="radio" name="typestat" id="ts03" value="3" disabled="disabled"> <label for="ts03">'._SMEMBERSSTATSHERE.'</label>
</td></tr>
<tr><td>
&nbsp;
</td></tr>
<tr><td align="center">
<champ nom="typestat" lib="type de calcul"></champ>
<input type="submit" name="go" value="'._SMEMBERSSTATSGO.'">
</td></tr>
</table>
</div>
</form>
';
	return $sortie;
}

function do_stats($typestat,$debstat,$finstat) {
	$obj_stats = new membersStats();
	switch ($typestat) {
		case "1" :
			//fiches individuelles
			return $obj_stats->stat_fic_annu($debstat,$finstat);
			break;
		case "2" :
			//recherches par domaine dans l'annuaire
			return $obj_stats->stat_rec_dom_annu($debstat,$finstat);
			break;
		case "3" :
			
			break;
	}
}

?>