<?php

/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2002 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (!preg_match("#mobiles.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

require_once("core/becms_mainlib_lib.php");
$module_name = basename(dirname(__FILE__));
require_once("modules/$module_name/utils.php");


function choose_commune() {
	global $prefix,$admin, $db, $trace,$currentlang, $pagetitle,$Default_Theme,$module_name,$_headerContent;
	global $cartobuttons,$cartopictowidth, $cartopictoheight, $cartopleinecran, $cartopospicto;
	
	require_once("modules/SimpleCarto/lib/g_params.php");
	require("modules/$module_name/system/params.php");
	
	$btns = "";
	foreach ($cartobuttons as $typedemap) {
		$btns .= ($btns == "") ? "" : ",";
		$btns .= "'".$typedemap."'";
	}
	if($cartopleinecran == "1") {
		$fullscreen = 'true';
	}
	else {
		$fullscreen = 'false';
	}
	$commune_script = '';
	foreach($communes as $comm_g => $commune) {
		$commune_script .= ($commune_script != "") ? ", " : "";
		$commune_script .= '"'.$comm_g.'":"'.$commune.'"';
	}
	if ($commune_script != '') {
		$commune_script = 'var communes = {'.$commune_script.'};';
	}
	
	$_headerContent .= '
	<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?v=3&key='.$keymap.'&sensor=false" charset="UTF-8"></script>
	<script type="text/javascript" src="modules/'.$module_name.'/system/getscript_display.php"  charset="UTF-8"></script>
	<script type="text/javascript">
		var options = new Array;
		options["btnstypes"] = ['.$btns.'];
		options["anchor_picto"] = "'.$cartopospicto.'";
		options["width_picto"] = '.$cartopictowidth.';
		options["height_picto"] = '.$cartopictoheight.';
		options["fullscreen"] = '.$fullscreen.';
		var racine_lib_module = "modules/SimpleCarto/lib";
		'.$commune_script.'
    </script>
    <link href="modules/SimpleCarto/lib/style-map.css" rel="stylesheet" type="text/css" media="all"/>
<script>
	function memo_commune(commune) {
		//jQuery.cookie("commune_enlevement",commune);
		Cookies.set("commune_enlevement",commune,{ secure: true, sameSite: "None" });
        return true;
	}
</script>
	';
	
	$liste_communes = "";
	/*foreach ($communes as $commune) {
		$liste_communes .= '<li><a href="mobiles.php?name=SimpleLozzu&op=choose_date" onclick="return memo_commune(\''.addslashes($commune).'\');">'.$commune.'</a></li>';
	}
	if ($liste_communes != "") {
			$liste_communes = '<ul>'.$liste_communes.'</ul>';
	}*/
	foreach ($communes as $commune) {
		$liste_communes .= '<a class="ui-button ui-widget ui-corner-all" href="mobiles.php?name=SimpleLozzu&op=choose_date" onclick="return memo_commune(\''.addslashes($commune).'\');">'.$commune.'</a>';
	}
	if ($liste_communes != "") {
		$liste_communes = '<div id="btns_communes">'.$liste_communes.'</div>';
	}
	
	$pagetitle = "Choix de la commune de l'enlvement";
	
	$sortie = '<h1>Choix de la commune de l\'enlvement</h1>';
	
	$sortie .= '<div id="etape"><img src="modules/'.$module_name.'/images/etape1.png"></div>';
	$sortie .= '<div id="etape_mobile"><img src="modules/'.$module_name.'/images/etape_mobile1.png"></div>';
	
	$sortie .= '<p>Indiquez votre commune de rsidence en utilisant la carte interactive ou la liste des communes ci-dessous.</p><p>&nbsp;</p>';
	
	$sortie .= '<div id="tabs">
				<ul>
					<li><a href="#tabs-1">Cartographie</a></li>
					<li><a href="#tabs-2">Communes</a></li>
				</ul>
				<div id="tabs-1">
					<div id="zonemap"><div id="map" style="width: 100%; height:100%"></div></div>
				</div>
				<div id="tabs-2">
					'.$liste_communes.'
				</div>
			</div>
	';
	
	$_headerContent = utilFuncs_lozzu::conditionnerMobile($_headerContent);
	$sortie = utilFuncs_lozzu::conditionnerMobile($sortie);
	
	include("header_mobile.php");
	echo $sortie;
	include ('footer_mobile.php');
	
}

function choose_date() {
	global $prefix,$admin, $db, $trace,$currentlang, $pagetitle,$Default_Theme,$module_name,$_headerContent;
	
	$_headerContent .= '
<script>
	function memo_date(ladate) {
		//jQuery.cookie("date_enlevement",ladate);
		Cookies.set("date_enlevement",ladate,{ secure: true, sameSite: "None" });
		return true;
	}
</script>
	';

	require("modules/$module_name/system/params.php");
	
	$pagetitle = "Choix de la date de l'enlvement";
	
	$sortie = '<h1>Choix de la date de l\'enlvement</h1>';
	
	$sortie .= '<div id="etape"><img src="modules/'.$module_name.'/images/etape2.png"></div>';
	$sortie .= '<div id="etape_mobile"><img src="modules/'.$module_name.'/images/etape_mobile2.png"></div>';
	
	$commune = $_COOKIE["commune_enlevement"];
	
	$sortie .= '<p class="sautmobile">Choisissez la date de l\'enlvement dsire.</p><p>&nbsp;</p>';
	
	
	$sortie .= '<div id="encomb_values">';
	$sortie .= '<table cellpadding="0" cellspacing="0" border="0" class="encomb_values">';
	$sortie .= '<tr><td class="caddie_gris"><h2>Commune : </h2></td></tr>';
	$sortie .= '<tr><td>'.$_COOKIE["commune_enlevement"].'</td></tr>';
	$sortie .= '</table>';
	$sortie .= '</div>';
	
	$sortie .= '<div id="legende_date">';
	$sortie .= '<div class="btns_dates">';
	$sortie .= 'Dates disponibles<a class="ui-button ui-widget ui-corner-all" href="javascript:void(0)">'.'&nbsp;'.'</a>';
	$sortie .= '</div>';
	
	$sortie .= '<div class="btns_dates">';
	$sortie .= 'Dates non disponibles<a class="ui-button ui-widget ui-corner-all disabled" href="javascript:void(0)">'.'&nbsp;'.'</a>';
	$sortie .= '</div>';
	
	$sortie .= '<div class="btns_dates">';
	$sortie .= 'Dates occupes<a class="ui-button ui-widget ui-corner-all disabled complet" href="javascript:void(0)">'.'&nbsp;'.'</a>';
	$sortie .= '</div>';
	$sortie .= '</div>';
	

	
	$planning = array();
	
	$sql = "SELECT jour FROM ".$prefix."_encombrants_planning WHERE commune='".utilFuncs_lozzu::anti_conditionnertodb($commune)."';";
	$result2 = $db->sql_query($sql);
	if ($db->sql_numrows($result2) > 0) {
		while (list($jour_p) = $db->sql_fetchrow($result2)) {
			$planning[] = $jour_p;
		}
	}
	$date = strtotime("last Sunday");
	$maintenant = time()+(12*3600); // pour arrter la prise de rdv  12h la veille
	$nbresemaines = 6;
	/*for ($i=0; $i<$nbresemaines;$i++) {
		$sortie .= '<p>Semaine du '.date("d/m/Y",($date)+(3600*24)*(1+$i*7)).' au '.date("d/m/Y",($date)+(3600*24*($i*7+5))).' : </p>';
		$liste = "";
		foreach ($jours as $jour => $valeur) {
			$enlevementsdispo = 5;
			$enlevementsrestant = 5;
			$tempsencours = ($date)+(3600*24*$valeur)+($i*7*24*3600);
			$dateencours = date("Y-m-d",$tempsencours);
			if (in_array($valeur, $planning) && $maintenant < $tempsencours) {
				$sql = "SELECT SUM(Id) as nbre_elevement, date_enlevement FROM ".$prefix."_encombrants WHERE commune_enlevement='".utilFuncs_lozzu::anti_conditionnertodb($commune)."' AND date_enlevement='".$dateencours."' GROUP BY date_enlevement;";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					if (list($nbre_enlevement,$date_elevement) = $db->sql_fetchrow($result)) {
						$enlevementsrestant = $enlevementsdispo-$nbre_enlevement;
					}
				}
			}
			else {
				$enlevementsrestant = 0;
			}
			if ($enlevementsrestant > 0) {
				$liste .= '<li><a href="mobiles.php?name='.$module_name.'&op=resa_enlevement" onclick="return memo_date(\''.addslashes($tempsencours).'\');">'.array_search($valeur,$jours).' '.date("d/m/Y",$tempsencours).'</a></li>';
			}
			else {
				$liste .= '<li style="color:#f00;">'.array_search($valeur,$jours).' '.date("d/m/Y",$tempsencours).'</li>';
			}
		}
		if ($liste != "") {
			$sortie .= '<ul>'.$liste.'</ul>';
		}
	}*/
	
	/*$tableau = '<tr>';
	foreach ($jours as $jour => $valeur) {
		$tableau .= '<th>'.ucfirst($jour).'</th>';
	}
	$tableau .= '</tr>';
	for ($i=0; $i<$nbresemaines;$i++) {
		$tableau .= '<tr>';
		foreach ($jours as $jour => $valeur) {
			$enlevementsdispo = 5;
			$enlevementsrestant = 5;
			$tempsencours = ($date)+(3600*24*$valeur)+($i*7*24*3600);
			$dateencours = date("Y-m-d",$tempsencours);
			if (in_array($valeur, $planning) && $maintenant < $tempsencours) {
				$sql = "SELECT SUM(Id) as nbre_elevement, date_enlevement FROM ".$prefix."_encombrants WHERE commune_enlevement='".utilFuncs_lozzu::anti_conditionnertodb($commune)."' AND date_enlevement='".$dateencours."' GROUP BY date_enlevement;";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					if (list($nbre_enlevement,$date_elevement) = $db->sql_fetchrow($result)) {
						$enlevementsrestant = $enlevementsdispo-$nbre_enlevement;
					}
				}
			}
			else {
				$enlevementsrestant = 0;
			}
			if ($enlevementsrestant > 0) {
				$tableau .='<td><a href="mobiles.php?name=SimpleLozzu&op=resa_enlevement" onclick="return memo_date(\''.addslashes($tempsencours).'\');">'.date("d/m",$tempsencours).'</a></td>';
			}
			else {
				$tableau .='<td><span>'.date("d/m",$tempsencours).'</span></td>';
			}
		}
		$tableau .= '</tr>';
	}
	
	$sortie .= '<p>Les dates en vert sont disponibles</p>';
	if ($tableau != "") {
		$sortie .= '<table border="0" cellpadding="0" cellspacing="0" id="tab_resa">'.$tableau.'</table>';
	}*/
	
	//$liste_communes .= '<a class="ui-button ui-widget ui-corner-all" href="mobiles.php?name=SimpleLozzu&op=choose_date" onclick="return memo_commune(\''.addslashes($commune).'\');">'.$commune.'</a>';
	
	$tableau = '<div class="btns_dates fond_jours saut">';
	foreach ($jours as $jour => $valeur) {
		$tableau .= '<a class="ui-button ui-widget ui-corner-all disabled joursem" href="javascript:void(0)">'.ucfirst($jour).'</a>';
	}
	$tableau .= '</div>';
	for ($i=0; $i<$nbresemaines;$i++) {
		$tableau .= '<div class="btns_dates">';
		foreach ($jours as $jour => $valeur) {
			$enlevementsdispo = 5;
			$enlevementsrestant = 5;
			$tempsencours = ($date)+(3600*24*$valeur)+($i*7*24*3600)+(12*3600);
			$dateencours = date("Y-m-d",$tempsencours);
			$classenplus = "";
			if (in_array($valeur, $planning) && $maintenant < $tempsencours) {
				$sql = "SELECT COUNT(Id) as nbre_elevement, date_enlevement FROM ".$prefix."_encombrants WHERE commune_enlevement='".utilFuncs_lozzu::anti_conditionnertodb($commune)."' AND date_enlevement='".$dateencours."' GROUP BY date_enlevement;";
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) > 0) {
					if (list($nbre_enlevement,$date_elevement) = $db->sql_fetchrow($result)) {
						$enlevementsrestant = $enlevementsdispo-$nbre_enlevement;
						if ($enlevementsrestant <= 0) {
							$classenplus = " complet";
						}
					}
				}
			}
			else {
				$enlevementsrestant = 0;
			}
			if ($enlevementsrestant > 0) {
				$tableau .='<a class="ui-button ui-widget ui-corner-all" href="mobiles.php?name=SimpleLozzu&op=resa_enlevement" onclick="return memo_date(\''.addslashes($tempsencours).'\');">'.date("d/m",$tempsencours).'</a>';
			}
			else {
				$tableau .='<a class="ui-button ui-widget ui-corner-all disabled'.$classenplus.'" href="javascript:void(0)">'.date("d/m",$tempsencours).'</a>';
			}
		}
		$tableau .= '</div>';
	}
	
	$sortie .= $tableau;
	
	
	$sortie = utilFuncs_lozzu::conditionnerMobile($sortie);
	
	/*pour que la page ne soit pas garde en cache*/
	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
	header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // always modified
	header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0"); // HTTP/1.1
	header("Cache-Control: post-check=0, pre-check=0", false);
	header("Pragma: no-cache"); // HTTP/1.0
	/*fin no cache*/
	
	include("header_mobile.php");
	echo $sortie;
	include ('footer_mobile.php');	
}

function add_cat_lozzu($label_famille, $objets) {
	global $compteur_famille;
	$sortie = "";
	$sortie .= '
<div class="combo"><span class="combo" id="btn'.$compteur_famille.'">'.$label_famille.'</span>
	<div class="ztxt" id="ztxt-btn'.$compteur_famille.'">
		<ul class="collection-combo">
';
	foreach($objets as $objet) {
		$sortie .= '<li class="collection-item-combo "><span class="add_cart">'.$objet.'</span></li>';
	}
	$sortie .= '
		</ul>
	</div>
</div>';
	$compteur_famille++;
	
	return $sortie;
}

function add_cat_lozzu2($famille, $img_famille, $objets,$compteur_famille) {
	$sortie = "";
	$sortie .= '
<div class="btn_dialog" dialog="dialog_'.$compteur_famille.'">'.$img_famille."<br />".$famille.'</div>	
<div id="dialog_'.$compteur_famille.'" title="'.$famille.'" class="no_show">
	<ul>
';
	foreach($objets as $objet) {
		$sortie .= '<li><span class="add_cart">'.$objet.'</span></li>';
	}
	$sortie .= '
	</ul>
</div>';
	
	return $sortie;
}

function add_cat_lozzu3($famille, $img_famille, $objets,$compteur_famille) {
	$sortie = "";
	$sortie .= '	
	<div class="btn_dialog" dialog="dialog_'.$compteur_famille.'"><a class="ui-button ui-widget ui-corner-all" href="javascript:void(0)">'.$img_famille.'</a><br />'.$famille.'</div>
	<div id="dialog_'.$compteur_famille.'" title="'.$famille.'" class="no_show">
	<!--<ul>-->
		<div class="btns_objet">
	';
	foreach($objets as $objet) {
		//$sortie .= '<li><span class="add_cart">'.$objet.'</span></li>';
		if ($objet != "*") {
			$sortie .= '<a class="ui-button ui-widget ui-corner-all add_cart" href="javascript:void(0)">'.$objet.'</a>';
		}
		else {
			$sortie.= '<div style="position: relative;"><div class = "btn_add_cart_txt add_cart_text"></div><input style="margin-left: 0 !important;" class="ui-button ui-widget ui-corner-all ui-widget ui-textfield" type="text" id="add_cart_text" placeholder="Autres encombrants..." /></div>';
		}
	}
	$sortie .= '
	<!--</ul>-->
		</div>
	</div>';

	return $sortie;
}

function resa_enlevement() {
	global $prefix,$admin, $db, $trace,$currentlang, $pagetitle,$Default_Theme,$module_name,$_headerContent;
	global $compteur_famille;
	
	require("modules/$module_name/system/params.php");

	$_headerContent .= utilFuncs_lozzu::conditionnerMobile('
<script>
	function verif_cart() {
		if (nbre_cart() > 0) {
			return true;
		}
		else {
			alert("Vous devez d\'abord indiquer la nature des encombrants  enlever.");
			return false;
		}
	}
	function verif_form(formulaire) {
		return true;
	}
</script>
	');
	
	$sortie = '<h1>Dtails des encombrants  enlever</h1>';
	$sortie .= '<div id="etape"><img src="modules/'.$module_name.'/images/etape3.png"></div>';
	$sortie .= '<div id="etape_mobile"><img src="modules/'.$module_name.'/images/etape_mobile3.png"></div>';
	
	$sortie .= '<p class="sautmobile">Choisissez vos encombrants dans les catgories ci-dessous. Un dtail des objets vous permettra de choisir prcisment vos encombrants quand vous aurez slectionn une catgorie.</p>
	<p>Vous pouvez cumuler jusqu\' cinq encombrants par demande d\'enlvement.</p><p>&nbsp;</p>';
	
	$sortie .= '<div id="encomb_values">';
	$sortie .= '<table cellpadding="0" cellspacing="0" border="0" class="encomb_values">';
	$sortie .= '<tr><td class="caddie_gris"><h2>Commune : </h2></td></tr>';
	$sortie .= '<tr><td>'.$_COOKIE["commune_enlevement"].'</td></tr>';
	$sortie .= '<tr><td class="caddie_gris"><h2>Date choisie : </h2></td></tr>';
	$sortie .= '<tr><td>'.date("d/m/Y",$_COOKIE["date_enlevement"]).'</td></tr>';
	$sortie .= '</table>';
	$sortie .= '</div>';
	
	$sortie .= '<div id="panier" class="sautmobile" with_control="true"></div>';
	
	
	/*
	foreach ($tabencombrants as $famille => $encombrants) {
		$sortie .= '<h2>'.$famille.'</h2>';
		$sortie .= '<img src="modules/'.$module_name.'/images/'.$encombrants["picto"].'">';
		$sortie .= '<ul>';
		foreach ($encombrants["detail"] as $objet) {
			$sortie .= '<li>'.$objet.'</li>';
		}
		$sortie .= '</ul>';
	}
	*/
	/*$compteur_famille = 0;
	foreach ($tabencombrants as $famille => $encombrants) {
		$label_famille = '<img src="modules/'.$module_name.'/images/'.$encombrants["picto"].'"><br />';
		$label_famille .=  $famille;
		$sortie .= add_cat_lozzu($label_famille, $encombrants["detail"]);
	}
	
	$sortie.= '<hr class="saut" />';*/
	/*$compteur_famille = 0;
	foreach ($tabencombrants as $famille => $encombrants) {
		$img_famille = '<img src="modules/'.$module_name.'/images/'.$encombrants["picto"].'">';
		$sortie .= add_cat_lozzu2($famille, $img_famille, $encombrants["detail"],$compteur_famille);
		$compteur_famille++;
	}*/
	
	//$sortie.= '<hr class="saut" />';
	
	$sortie .= '<div id="btns_objets" class="saut">';
	
	$compteur_famille = 0;
	foreach ($tabencombrants as $famille => $encombrants) {
		$img_famille = '<img src="modules/'.$module_name.'/images/'.$encombrants["picto"].'">';
		$sortie .= add_cat_lozzu3($famille, $img_famille, $encombrants["detail"],$compteur_famille);
		$compteur_famille++;
	}
	$sortie .= '</div>';
	
	$sortie .= '<div style="position: absolute; top: 10px; left: 0; width: 20px; height: 20px; width: 100%" id="repere_dialog"></div>';
	
	//$sortie .= '<p class="saut"><br /><a href="mobiles.php?name='.$module_name.'&op=resa_suite_enlevement" onclick="return verif_cart();">Suite de la demande</a></p>';
	
	$sortie = utilFuncs_lozzu::conditionnerMobile($sortie);
	
	/*pour que la page ne soit pas garde en cache*/
	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
	header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // always modified
	header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0"); // HTTP/1.1
	header("Cache-Control: post-check=0, pre-check=0", false);
	header("Pragma: no-cache"); // HTTP/1.0
	/*fin no cache*/
	
	include("header_mobile.php");
	echo $sortie;
	include ('footer_mobile.php');
}

function resa_suite_enlevement() {
	global $prefix,$admin, $db, $trace,$currentlang, $pagetitle,$Default_Theme,$module_name,$_headerContent;
	global $compteur_famille;
	
	require("modules/$module_name/system/params.php");
	
	if ($_COOKIE["commune_enlevement"] == "" || $_COOKIE["date_enlevement"] == "" || $_COOKIE["caddie_enlevement"] == "") {
		header("Location: mobiles.php?name=".$module_name);
		die();
	}

	$_headerContent .= '
<script type="text/javascript" src="javascripts/lang/lang-french.js" charset="ISO-8859-1"></script>
<script type="text/javascript" src="javascripts/control_form.js" charset="ISO-8859-1"></script>
<script>
	function verif_form(formulaire) {
		if (!submit_form(formulaire)) {
			return false;
		}
		if (formulaire["enlevement[tel]"].value + formulaire["enlevement[email]"].value + formulaire["enlevement[portable]"].value == "") {
			//alerte_erreur("Erreur", "'.utilFuncs_lozzu::conditionnerMobile('Le formulaire n\'a pu tre envoy pour les raisons suivantes :<ul><li>au moins une des rubriques \'Tlphone\', \'Portable\' ou \'Adresse e-mail\' doit tre renseigne</li></ul>').'");
			alerte_erreur("Erreur", "'.utilFuncs_lozzu::conditionnerMobile('Le formulaire n\'a pu tre envoy pour les raisons suivantes :<ul><li>au moins une des rubriques \'Tlphone\' ou \'Portable\' doit tre renseigne</li></ul>').'");
			return false;
		}
		else {
			return true;
		}
	}
</script>
	';
	
	$sortie = '<h1>Vos coordonnes</h1>';
	
	$sortie .= '<div id="etape"><img src="modules/'.$module_name.'/images/etape4.png"></div>';
	$sortie .= '<div id="etape_mobile"><img src="modules/'.$module_name.'/images/etape_mobile4.png"></div>';
	
	$sortie .= '<p class="sautmobile">Veuillez indiquer votre nom et vos coordonnes. N\'ommettez-pas votre adresse e-mail, si vous en avez-une, pour recevoir la confirmation de l\'enlvement.</p><p>&nbsp;</p>';
	
	$sortie .= '<div id="encomb_values">';
	$sortie .= '<table cellpadding="0" cellspacing="0" border="0" class="encomb_values">';
	$sortie .= '<tr><td class="caddie_gris"><h2>Commune : </h2></td></tr>';
	$sortie .= '<tr><td>'.$_COOKIE["commune_enlevement"].'</td></tr>';
	$sortie .= '<tr><td class="caddie_gris"><h2>Date choisie : </h2></td></tr>';
	$sortie .= '<tr><td>'.date("d/m/Y",$_COOKIE["date_enlevement"]).'</td></tr>';
	$sortie .= '</table>';
	$sortie .= '</div>';
	
	$sortie .= '<div id="panier" class="sautmobile"></div>';
	
	/*
	$sortie .= '<p class="saut">Commune : '.$_COOKIE["commune_enlevement"].'</p>';
	$sortie .= '<p>Date : '.date("Y-m-d",$_COOKIE["date_enlevement"]).'</p>';
	$sortie .= '<p>Encombrants  enlever :</p>';
	$caddie = json_decode(stripslashes($_COOKIE["caddie_enlevement"]),true);
	$liste = '';
	$listeform = '';
	foreach($caddie as $objet => $nbre) {
		$liste .= '<li>'.$nbre.' '.$objet.'</li>';
		$listeform .= '- '.$nbre.' '.$objet."\n";		
	}
	if ($liste != '') {
		$sortie .= '<ul>'.utf8_decode($liste).'</ul>';
	}
	*/
	$caddie = json_decode(stripslashes($_COOKIE["caddie_enlevement"]),true);
	$liste = '';
	foreach($caddie as $objet => $nbre) {
		$listeform .= '- '.$nbre.' '.$objet."\n";
	}
	$sortie .= '<form action="mobiles.php" name="thelozzu" method="post" onsubmit="return verif_form(this)">
			<div class="coords saut">
				<champ nom="enlevement[nom]" lib="Nom"></champ><input type="text" name="enlevement[nom]" value="" size="50" maxlength="50" placeholder="Votre nom" class="ui-widget ui-state-default ui-corner-all ui-state-hover saisie">
				<br />
				<input type="text" name="enlevement[prenom]" value="" size="50" maxlength="50" placeholder="Votre prnom" class="ui-widget ui-state-default ui-corner-all ui-state-hover saisie">
				<br />
				<champ nom="enlevement[adresse]" lib="Adresse"></champ><textarea name="enlevement[adresse]" rows="3" cols="50" placeholder="Votre adresse" class="ui-widget ui-state-default ui-corner-all ui-state-hover saisie"></textarea>
				
				<br />
				<input type="tel" name="enlevement[tel]" value="" size="50" maxlength="50" placeholder="Tlphone" class="ui-widget ui-state-default ui-corner-all ui-state-hover saisie">
				<br />
				<input type="tel" name="enlevement[portable]" value="" size="50" maxlength="50" placeholder="Portable" class="ui-widget ui-state-default ui-corner-all ui-state-hover saisie">
				<br />
				<champ nom="enlevement[email]" lib="E-mail" ctl="email" lim="0,-1"></champ><input type="text" name="enlevement[email]" value="" size="50" maxlength="50" placeholder="Adresse e-mail" class="ui-widget ui-state-default ui-corner-all ui-state-hover saisie">
				<br />
				<textarea name="enlevement[lieu_enlevement]" rows="3" cols="50" placeholder="Lieu de l\'enlvement (si diffrent de votre adresse)" class="ui-widget ui-state-default ui-corner-all ui-state-hover saisie"></textarea>
				
				<br />
				<input type="hidden" name="op" value="resa_valid_enlevement">
					<input type="hidden" name="name" value="'.$module_name.'">
					<input type="hidden" name="enlevement[commune_enlevement]" value="'.utf8_decode(utilFuncs_lozzu::conditionnerFORM($_COOKIE["commune_enlevement"])).'">
					<input type="hidden" name="enlevement[date_enlevement]" value="'.utf8_decode(utilFuncs_lozzu::conditionnerFORM(date("Y-m-d",$_COOKIE["date_enlevement"]))).'">
					<input type="hidden" name="enlevement[liste_encombrants]" value="'.utf8_decode($listeform).'">
					<!--<input type="submit" value="Enregistrer la demande" class="ui-button ui-widget ui-state-default ui-corner-all marge_1">-->
					<a href="javascript:void(0)" onclick="if ( verif_form(document.forms[\'thelozzu\'])) {document.forms[\'thelozzu\'].submit();}" class="ui-button ui-widget ui-state-default ui-corner-all marge_1">Enregistrer la demande</a>
				</div></form>';
	$sortie .= '<p>&nbsp;</p>';
			
	
	//$sortie .= '<p><a href="mobiles.php?name='.$module_name.'&op=resa_suite_enlevement" onclick="return verif_cart();">valider la demande</a></p>';
	
	$sortie = utilFuncs_lozzu::conditionnerMobile($sortie);
	
	/*pour que la page ne soit pas garde en cache*/
	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
	header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // always modified
	header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0"); // HTTP/1.1
	header("Cache-Control: post-check=0, pre-check=0", false);
	header("Pragma: no-cache"); // HTTP/1.0
	/*fin no cache*/
	
	include("header_mobile.php");
	echo $sortie;
	include ('footer_mobile.php');
}

function ajout_ligne_recap($label, $valeur) {
	if ($valeur != "") {
		return '<tr><td class="label">'.$label.' : </td><td>'.$valeur.'</td></tr>';
	}
	else {
		return '';
	}
}

function resa_valid_enlevement($enlevement) {
	global $user_prefix,$admin, $db, $trace,$currentlang, $pagetitle,$Default_Theme,$module_name,$_headerContent,$nukeurl;
	global $lozzuadminmail,$communes;
	
	require("modules/$module_name/system/params.php");
	
	if (!isset($enlevement["Id"])) {
		$enlevement["Id"] = "-1";
	}
	$enlevement["valide"] = "0";
	
	$ok = true;
	$enlevement = array_map('utf8_decode', $enlevement);
	$enlevement = array_map(array('utilFuncs_lozzu', 'conditionnertodb'), $enlevement);
	
	if ($enlevement["lieu_enlevement"] == "") {
		$enlevement["lieu_enlevement"] = $enlevement["adresse"];
	}
	
	$id_fiche = "";
	$list_champs = "";
	$list_valeurs = "";
	if ($enlevement["Id"] == "-1" || $enlevement["Id"] == "" || $enlevement["Id"] == "0") {
		$list_champs = ""; $list_valeurs="";
		foreach($enlevement as $key => $value) {
			if ($key != "Id") {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."`";
				$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
				$list_valeurs .= "'".$value."'";
			}
		}
		$sql = "INSERT INTO ".$user_prefix."_encombrants (".$list_champs.")";
		$sql .= " VALUES (".$list_valeurs.");";
	}
	else {
		$list_champs = ""; $list_valeurs="";
		foreach($enlevement as $key => $value) {
			if ($key != "Id") {
				$list_champs .= ($list_champs == "") ? "" : ", ";
				$list_champs .= "`".$key."` = '".$value."'";
			}
		}
		$sql = "UPDATE ".$user_prefix."_encombrants SET ".$list_champs." WHERE `Id` = '".$enlevement["Id"]."';";
		$id_fiche = $enlevement["Id"];
	}

	$ok = $db->sql_query($sql);
	if ($ok) {
		if ($id_fiche == "") {
			$id_fiche = $db->sql_nextid();
		}
		
		$caddie = json_decode(stripslashes($_COOKIE["caddie_enlevement"]),true);
		$liste = '';
		if (is_array($caddie)) {
			foreach($caddie as $objet => $nbre) {
				$liste .= '<li>'.$nbre.' '.$objet.'</li>';
			}
			if ($liste != '') {
				$liste = '<ul>'.utf8_decode($liste).'</ul>';
			}
		}
		else {
			$liste = $caddie;
		}
		
		$dateEnlevement = date("d/m/Y",$_COOKIE["date_enlevement"]);
		$communeEnlevement = array_search($_COOKIE["commune_enlevement"],$communes);
		
		setcookie ("commune_enlevement", "", time()-3600);
		setcookie ("date_enlevement", "", time()-3600);
		setcookie ("caddie_enlevement", "", time()-3600);
		unset($_COOKIE["commune_enlevement"]);
		unset($_COOKIE["date_enlevement"]);
		unset($_COOKIE["caddie_enlevement"]);
	
		$sortie = '<h1>Enregistrement de votre demande</h1>';	
		
		$sortie .= '<p>Votre demande a t enregistre.</p>';
		$sortie .= '<p>Vous recevrez un message de confirmation quand votre demande aura t valide.</p>';
		$sortie .= '<p>Merci d\'avoir utilis notre systme.</p>';
		
		$sortie .= '<div id="infos_sent">';
		$sortie .= '<table cellpadding="0" cellspacing="0" border="0">';
		$sortie .= '<tr><td class="caddie_gris" colspan="2"><h2>Informations transmises</h2></td></tr>';
		
		$sortie .= ajout_ligne_recap('Commune', $communeEnlevement);
		$sortie .= ajout_ligne_recap('Date de l\'enlvement', $dateEnlevement);
		
		$sortie .= '<tr><td colspan="2" class="intercal"></td></tr>';
		
		$sortie .= ajout_ligne_recap('Nom', $enlevement["nom"]);;
		$sortie .= ajout_ligne_recap('Prnom', $enlevement["prenom"]);;
		
		$sortie .= '<tr><td colspan="2" class="intercal"></td></tr>';
		
		$sortie .= ajout_ligne_recap('Adresse', nl2br($enlevement["adresse"]));
		
		$sortie .= '<tr><td colspan="2" class="intercal"></td></tr>';
		
		$sortie .= ajout_ligne_recap('Tlphone', $enlevement["tel"]);
		$sortie .= ajout_ligne_recap('Portable', $enlevement["portable"]);
		$sortie .= ajout_ligne_recap('E-mail', $enlevement["email"]);
		
		$sortie .= '<tr><td colspan="2" class="intercal"></td></tr>';
		
		$sortie .= ajout_ligne_recap('Enlvement', nl2br($enlevement["lieu_enlevement"]));
		
		$sortie .= ajout_ligne_recap('Encombrants', $liste);
		
		$sortie .= '</table>';
		$sortie .= '</div>';
		
		/* envoyer mail admin*/
		$tab_serveur = parse_url($nukeurl);
		$racine = $tab_serveur["scheme"]."://";
		if ($tab_serveur["user"] != "") {
			$racine .= $tab_serveur["user"];
		}
		if ($tab_serveur["pass"] != "") {
			$racine .= ":".$tab_serveur["pass"];
		}
		if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
			$racine .= "@";
		}
		$racine .= $tab_serveur["host"];
		if ($tab_serveur["port"] != "") {
			$racine .= ":".$tab_serveur["port"];
		}
		$subject = "Demande d'enlvement d'encombrants";
		$from = $lozzuadminmail;
		$email = $lozzuadminmail;
		$message = "Une demande d'enlvement d'encombrant a t enregistre sur le site. Pour qu'elle apparaisse dans le planning de ramassage, vous devrez la valider. Vous pourrez expdier un message de confirmation automatique au demandeur  cette occasion.\n\n";
		$message .= "Adresse directe de validation :\n";
		$message .= "$racine./system.php?op=lozzu&action=edit_enlevement&onglet=enlevementno&Id=".$id_fiche;
		
		if (!utilFuncs_lozzu::send_email($email, $from, $subject, $message, $return="")) {
			//die("Problme d'envoi de validation de demande ! Contacter administrateur !");
		}
		
		//$sortie .= '<p>'.$message.'</p>';
	}
	else {
		die("Problme enregistrement demande ! Contacter administrateur !");
	}
	
	$sortie .= '<p>&nbsp;</p>';
	
	$sortie = utilFuncs_lozzu::conditionnerMobile($sortie);
	
	/*pour que la page ne soit pas garde en cache*/
	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
	header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // always modified
	header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0"); // HTTP/1.1
	header("Cache-Control: post-check=0, pre-check=0", false);
	header("Pragma: no-cache"); // HTTP/1.0
	/*fin no cache*/
	
	include("header_mobile.php");
	echo $sortie;
	include ('footer_mobile.php');
}

//--------------------POUR que IE accepte les cookies dans les iframes ----------------------

header('P3P:CP="IDC DSP COR ADM DEVi TAIi PSA PSD IVAi IVDi CONi HIS OUR IND CNT"');

// ------------------------------- SWITCH PART ---------------------------------------------
if (!isset($highlite)) {
	$highlite = "";
}
switch($op) {
	default:
	case "choose_commune":
		choose_commune();
		break;
	case "choose_date":
		choose_date();
		break;
	case "resa_enlevement":
		resa_enlevement();
		break;
	case "resa_suite_enlevement":
		resa_suite_enlevement();
		break;
	case "resa_valid_enlevement":
		resa_valid_enlevement($enlevement);
		break;
}

?>