<?php

if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once("core/becms_mainlib_lib.php");
require_once("modules/$module_name/lib_db.php");
require_once("modules/$module_name/utils.php");

if (file_exists("modules/SimpleUsersStats/stats.php")) {
	require_once("modules/SimpleUsersStats/stats.php");
	$stat_membre = new membersStats();
}
function ajoutStat($action) {
	global $stat_membre;
	if (isset($stat_membre)) {
		$stat_membre->add_action($action);
	}
}

function list_index($nbreFiches, $page, $ligne_par_page,$url) {
	global $module_name;

	$nboites = 5;
	$liminf = $page - floor($nboites/2);
	$limsup = $page + floor($nboites/2);
	if ($liminf < 1) {
		$liminf = 1;
		$limsup = $nboites;
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
		}
	}
	if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
		$limsup = ceil($nbreFiches/$ligne_par_page);
		$liminf = $limsup - $nboites;
		if ($liminf < 1) {
			$liminf = 1;
		}
	}
	$min = 1;
	$max = ceil($nbreFiches/$ligne_par_page);


	$repParPage = $ligne_par_page;
	$p = $page;
	$nbrepages = ceil($nbreFiches/$repParPage);
	if ($p>$nbrepages) {
		$p = $nbrepages;
	}
	$indexPages .= "<div class=\"pages\">";
	if ($nbreFiches != 0) {
		$indexPages .= $nbreFiches._JOBSFOUND;
		$indexPages .= _JOBSPAGES;
		if ($min < $liminf) {
			if ($min == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$min";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"".$url."&page=$min\">$min</a>";
				$indexPages .= "</div>";
			}
			if ($min < $liminf - 1) {
				$indexPages .= "...";
			}
		}
		for ($i=$liminf;$i<=$limsup;$i++) {
			if ($i == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$i";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"".$url."&page=$i\">$i</a>";
				$indexPages .= "</div>";
			}
		}
		if ($max > $limsup) {
			if ($max > $limsup + 1) {
				$indexPages .= "...";
			}
			if ($max == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$max";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"".$url."&page=$max\">$max</a>";
				$indexPages .= "</div>";
			}
	
		}
	}
	else {
		$indexPages .= _JOBSNOTFOUND;
	}
	$indexPages .= "</div>";
	return $indexPages;
}

function list_cats() {
	global $module_name, $adsnbrebycat, $admin;
	global $user;
	
	if (!is_user($user)) {
		die("Not Allowed !!!");
	}

	$sortie = "<h1>"._JOBTITLE."</h1>";
	
	$sortie .= _JOBSINTRO;
	
	$obj_ads = new BD_Jobs();
	$results = $obj_ads->getCats();
	if (count($results) != 0) {
		$sortie .= "<h2>"._JOBSCATS."</h2>";
		$sortie .= "<ul>";
		foreach($results as $result) {
			list($Id,$categorie,$image) = $result;
			$nbre = $obj_ads->getJobs("count","",$Id);
			$sortie .= '<li>';
			$sortie .= '<a href="modules.php?name='.$module_name.'&sop=listjobs&Id='.$Id.'">'.$categorie."</a> (".$nbre._JOBSOFFERS.")";
			$sortie .='</li>';
		}
		list($Id,$categorie,$image) = $result;
		$nbre = $obj_ads->getJobs("count","","");
		$sortie .= '<li>';
		$sortie .= '<a href="modules.php?name='.$module_name.'&sop=listjobs">'._JOBSALLJOBS."</a> (".$nbre._JOBSOFFERS.")";
		$sortie .='</li>';
		$sortie .= "</ul>";
	}
	
	if (is_admin($admin)) {
		$sortie .= "<h1>"._WANTEDADMACTIONS."</h1>";
		$sortie .= "<ul>";
		$sortie .= "<li><a href=\"modules.php?name=SimpleJob&sop=new_wanted\">"._WANTEDADMNEW."</a></li>";
		$sortie .= "<li><a href=\"modules.php?name=SimpleJob&sop=list_wanted\">"._WANTEDADMVIEW."</a></li>";
		$sortie .= "</ul>";
	}
	return $sortie;
}

function list_cats_public() {
	global $module_name, $adsnbrebycat, $admin;
	global $user;

	$sortie = "<h1>"._JOBTITLE."</h1>";
	
	$sortie .= _JOBSINTROPUBLIC;
	
	$obj_ads = new BD_Jobs();
	$results = $obj_ads->getCats();
	if (count($results) != 0) {
		$sortie .= "<h2>"._JOBSCATS."</h2>";
		$sortie .= "<ul>";
		foreach($results as $result) {
			list($Id,$categorie,$image) = $result;
			$nbre = $obj_ads->getJobs("count","",$Id);
			$sortie .= '<li>';
			$sortie .= '<a href="modules.php?name='.$module_name.'&sop=listjobs&Id='.$Id.'">'.$categorie."</a> (".$nbre._JOBSOFFERS.")";
			$sortie .='</li>';
		}
		/*$nbre = $obj_ads->getJobs("count","","");
		$sortie .= '<li>';
		$sortie .= '<a href="modules.php?name='.$module_name.'&sop=listjobs">'._JOBSALLJOBS."</a> (".$nbre._JOBSOFFERS.")";
		$sortie .='</li>';*/
		$sortie .= "</ul>";
	}
	$sortie .= "<p>&nbsp;</p>";
	$sortie .= "<h2>"._WANTEDADMACTIONS."</h2>";
	$sortie .= "<p>"._JOBSWANTEDINTROPUBLIC."</p>";
	$sortie .= "<ul>";
	$sortie .= "<li><a href=\"modules.php?name=SimpleJob&sop=new_wanted\">"._WANTEDADMNEW."</a></li>";
	//$sortie .= "<li><a href=\"modules.php?name=SimpleJob&sop=list_wanted\">"._WANTEDADMVIEW."</a></li>";
	$sortie .= "</ul>";

	return $sortie;
}

function list_jobs($cat,$page) {
	global $module_name, $jobslinesperpage;
	$ligne_par_page = $jobslinesperpage;
	$page = ($page < 1) ? 1 : $page;

	$obj_ads = new BD_Jobs();
	if ($cat != "") {
		$results = $obj_ads->getCats($cat);
		$result = $results[0];
		list($cat,$categorie,$image) = $result;
		$sortie = "<h1>".'<img src="images/topics/'.$image.'" alt="'.$categorie.'" class="ads">'.$categorie."</h1>";
		$url = "modules.php?name=".$module_name."&sop=listjobs&Id=".$cat;
	}
	else {
		$sortie = "<h1>"._JOBSALLJOBS."</h1>";
		$url = "modules.php?name=".$module_name."&sop=listjobs";
	}
	$sortie .= '&nbsp;<br />';
	//$sortie .= '<img src="images/topics/'.$image.'" alt="'.$categorie.'">';
	$nbreFiches = $obj_ads->getJobs("count","",$cat);
	$indexlist = list_index($nbreFiches, $page, $ligne_par_page,$url);

	$sortie .= "<hr class=\"pages\">".$indexlist."<hr class=\"pages\">";

	//$sortie .= '&nbsp;<br />';
	$limit = (($ligne_par_page*($page-1))).",".$ligne_par_page;
	$result2s = $obj_ads->getJobs("files","",$cat,"","",$limit);
	$first = true;
	if (count($result2s) != 0) {
		foreach($result2s as $result2) {
			if (!$first) {
				$sortie .= "<hr class=\"sepjobs\">";
			}
			else {
				$first = false;
			}
			$sortie .= '<h2>'.$result2["intitule"].'</h2>';
			$sortie .= '<p>'.nl2br($result2["description"]).'</p>';
			if ($result2["profil"] != "") {
				$sortie .= '<p><b>'._JOBSPROFIL."</b>".$result2["profil"]."</p>";
			}
			if ($result2["contrat"] != "") {
				$sortie .= '<p><b>'._JOBSCONTRAT."</b>".$result2["contrat"]."</p>";
			}
			if ($result2["email"] != "") {
				$sortie .= '<p><b>'._JOBSCONTACT."</b><a href=\"mailto:".$result2["email"]."?subject=".addslashes($result2["intitule"])."\">".$result2["email"]."</a></p>";
				//$adresse = 'modules.php?name='.$module_name.'&sop=sendMail&Id='.$result2["Id"];
				//$sortie .= '<br /><a href="'.$adresse.'&retour='.urlencode($_SERVER["REQUEST_URI"]).'">'._ADSEMAILANNONCE.'</a>';
			}
		}
	}
	//$sortie .= '&nbsp;<br />';
	$sortie .= "<hr class=\"pages\">".$indexlist."<hr class=\"pages\">";
	return $sortie;
}

function edit_wanted($clef) {
	global $module_name;
	
	$obj_cat = new BD_Jobs();
	$results = array();
	
	$wanted = array();
	
	if ($clef != "") {
		$wanteds = $obj_cat->getWanted("files","","",$clef);
		$wanted = $wanteds[0];
	}
	
	require_once("modules/SimpleMembers/lib_db.php");
	$obj_dom = new BD_Members();
	$domaines = $obj_dom->getDoms();
	$menudom = '<table cellpadding="0" cellspacing="5" border="0" class="saisie">';
	foreach($domaines as $domaine) {
		if ($domaine["code"] % 100 == 0) {
			$menudom .= '<tr><td width="30" align="center">';
			$checked = "";
			if ($wanted["domaine"] == $domaine["code"]) {
				$checked = " checked=\"checked\"";
			}
			$menudom .= '<input type="radio" name="domaine" value="'.$domaine["code"].'" id="'.$domaine["code"].'"'.$checked.'>';
			$menudom .= '</td><td>';
			$menudom .= '<label for="'.$domaine["code"].'"><b>'.$domaine["label"]."</b><br />".$domaine["description"].'</label>';
			$menudom .= '</td></tr>';
		}
	}
	$menudom .= '</table><champ nom="domaine" lib="Domaine"></champ>';

	$sortie = '<h1>'._JOBSWANTED.'</h1>';
	$sortie .= '<p>'._JOBSWANTEDINTRO.'</p>';
	$sortie .= '<form name="editwanted" action="modules.php?name='.$module_name.'&sop=save_wanted" method="POST" onsubmit="return validform(this)" enctype="multipart/form-data">';
	$sortie .= '<div align="center">';
	$sortie .= '&nbsp;<br />';
	$sortie .= '<fieldset><legend>'._JOBSWANTEDFILE.'</legend>';
	$sortie .= '<table border="0" cellspacing="5" cellpadding="0">';
	
	$sortie .= '<tr><td>';
	$sortie .= "<p>"._JOBSWANTEDDOMAIN."</p>";
	$sortie .= '</td><td>';
	//$sortie .= '<input type="text" name="domaine" value="'.$wanted["domaine"].'" class="saisie">';
	$sortie .= $menudom;
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td>';
	$sortie .= "<p>"._JOBSWANTEDDESC."</p>";
	$sortie .= '</td><td>';
	$sortie .= '<textarea name="candidature" cols="50" rows="10" class="saisie">'.$wanted["candidature"].'</textarea>';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td>';
	$sortie .= "<p>"._JOBSWANTEDCV."</p>";
	$sortie .= '</td><td>';
	if ($wanted["cv"] != "") {
		$chemin="catalog_repository/simple_jobs";
		$lien = $chemin."/".$wanted["cv"];
		$sortie .= "<p>".str_replace("<!--lien-->",$lien,_JOBSCVUPLOADED)."</p>";
	}
	$sortie .= '<input type="file" name="cv" value="" class="saisie">';
	
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td>';
	$sortie .= "<p>"._JOBSWANTEDMAIL."</p>";
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="email" value="'.$wanted["email"].'" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td colspan="2" style="text-align: center">';
	$sortie .= "<p style=\"text-align: center\">"._JOBSREQUIREDEDIT."</p>";
	$sortie .= '</td></tr>';
	
	$sortie .= '</table>';
	
	$sortie .= '<br />&nbsp;<br />';
	$sortie .= '<input type="submit" value="'._JOBSSAVEBTN.'" name="valid">';
	$sortie .= '<input type="hidden" value="'.$wanted["Id"].'" name="Id">';
	$sortie .= '<input type="hidden" value="'.$wanted["clef"].'" name="clef">';
	$sortie .= '<input type="hidden" value="'.$wanted["date_inscription"].'" name="date_inscription">';
	$sortie .= '<input type="hidden" value="'.$wanted["valide"].'" name="valide">';
	$sortie .= '<input type="hidden" value="'.$wanted["cv"].'" name="cv_old">';
	$sortie .= '<br />&nbsp;';
	$sortie .= '</fieldset>';
	$sortie .= '</div>';
	$sortie .= "</form>";
	
	
	$sortie .= '
<script type="text/javascript">
	function validMail(email) {
		if (email == "") {
			return(true);
		}
		else {
			if ((email.indexOf("@") == -1) || (email.indexOf("@") == 0) || (email.indexOf("@") != email.lastIndexOf("@")) || (email.indexOf(".") == email.indexOf("@")-1) || (email.indexOf(".") == email.indexOf("@") + 1) || (email.indexOf("@") == email.length -1) || (email.indexOf (".") == -1) || (email.lastIndexOf (".") == email.length -1) || (email.indexOf (";") != -1) || (email.indexOf (" ") != -1)) {
				return(false);
			}
			else return(true);
		}
	}
	function validform(formulaire) {
		var ok = true;
		var compteur=0;
		if (formulaire.domaine.length) {
			var ok = false;
			for (var i=0;i<formulaire.domaine.length;i++) {
				if (formulaire.domaine[i].checked) {
					ok = true;
				}
			}
			if (!ok) {
				alert("'._JOBSVERIFDOM.'");
				return false;
			}
		}
		else {
			if (formulaire.domaine.value == "") {
				alert("'._JOBSVERIFDOM.'");
				return false;
			}
		}
		if (formulaire.candidature.value == "") {
			alert("'._JOBSVERIFDESC.'");
			return false;
		}
		if (formulaire.cv.value == "" && '.(($wanted["cv"] == "") ? "true" : "false").') {
			alert("'._JOBSVERIFCV.'");
			return false;
		}
		if (formulaire.cv.value != ""){
			var fichier = formulaire.cv.value;
			var reg=new RegExp("\\\\.", "g");
			tabfic = String(fichier).split(reg);
			var extension = tabfic[eval(tabfic.length-1)];
			if (extension != "pdf" && extension != "doc" && extension != "rtf" && extension != "PDF" && extension != "DOC" && extension != "RTF") {
				alert("'._JOBSVERIFTYPECV.'");
				return false;
			}
		}
		if (formulaire.email.value =="") {
			alert("'._JOBSVERIFMAIL.'");
			return false;
		}
		if (!validMail(formulaire.email.value)) {
			alert("'._JOBSVERIFMAIL2.'");
			return false;
		}
		return ok;
	}
</script>';
	return $sortie;
}

function send_email_ads($Id,$retour) {
	global $module_name;
	$obj_ads = new BD_Annonce();
	$results = $obj_ads->getAds("files",$Id,"","","","","","",true);
	$result = $results[0];
	$sortie = "<h1>"._ADSTITREMAILREPONSE."</h1>";
	$sortie .='<form name="newmail" action="modules.php?name='.$module_name.'&sop=mailSent" method="POST" onsubmit="return validform(this)">';
	$sortie .= "<h2>"._ADSMAILANNONCE."</h2>";
	$sortie .= "<ul class=\"ads\">";
	$sortie .= "<li>";
	$sortie .= nl2br($result["annonce"]);
	if ($result["tel"] != "") {
		$sortie .= '<br />'._ADSTELANNONCE.$result["tel"];
	}
	$sortie .= "</li>";
	$sortie .= "</ul>";
	$sortie .= "<div style=\"clear: both;\">";
	$sortie .= '<fieldset><legend>'._ADSMAILREPONSE.'</legend>';
	$sortie .= '<div align="center">';
	$sortie .= '<table border="0" cellpadding="0" cellspacing="0" class="formulaire">';
	
	$sortie .= '<tr><td>';
	$sortie .= _ADSMAILREPONSEYOURNAME;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="nom" value="" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td>';
	$sortie .= _ADSMAILREPONSEYOURMESSAGE;
	$sortie .= '</td><td>';
	$sortie .= '<textarea name="message" cols="50" rows="10" class="saisie"></textarea>';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td>';
	$sortie .= _ADSMAILREPONSEYOURMAIL;
	$sortie .= '</td><td>';
	$sortie .= '<input type="text" name="email" value="" class="saisie">';
	$sortie .= '</td></tr>';
	
	$sortie .= '<tr><td colspan="2" style="text-align: center">';
	$sortie .= _ADSREQUIREDEDIT;
	$sortie .= '</td></tr>';
	
	$sortie .= '</table>';
	
	$sortie .= '<br />&nbsp;<br />';
	$sortie .= '<input type="submit" value="'._ADSCATSENDBTN.'" name="valid">';
	$sortie .= '<input type="hidden" value="'.$Id.'" name="Id">';
	$sortie .= '<input type="hidden" value="'.urldecode($retour).'" name="retour">';
	$sortie .= '<br />&nbsp;';
	$sortie .= '</div>';
	$sortie .= '</fieldset>';
	
	$sortie .= '</form>';
	
	$sortie .= '
<script type="text/javascript">
	function validMail(email) {
		if (email == "") {
			return(true);
		}
		else {
			if ((email.indexOf("@") == -1) || (email.indexOf("@") == 0) || (email.indexOf("@") != email.lastIndexOf("@")) || (email.indexOf(".") == email.indexOf("@")-1) || (email.indexOf(".") == email.indexOf("@") + 1) || (email.indexOf("@") == email.length -1) || (email.indexOf (".") == -1) || (email.lastIndexOf (".") == email.length -1) || (email.indexOf (";") != -1) || (email.indexOf (" ") != -1)) {
				return(false);
			}
			else return(true);
		}
	}
	function validform(formulaire) {
		var ok = true;
		var compteur=0;
		
		if (formulaire.message.value == "") {
			alert("'._ADSVERIFMESSAGE.'");
			return false;
		}
		if (formulaire.nom.value == "") {
			alert("'._ADSVERIFAUTEUR.'");
			return false;
		}
		if (formulaire.email.value =="") {
			alert("'._ADSVERIFEMAILEMPTY.'");
			return false;
		}
		if (!validMail(formulaire.email.value)) {
			alert("'._ADSVERIFEMAIL.'");
			return false;
		}
		return ok;
	}
</script>';
	return $sortie;
}

function email_sent_ads($Id,$nom,$message,$email,$retour) {
	$sortie = "<h1>"._ADSTITREMAILREPONSE."</h1>";
	$obj_ads = new BD_Annonce();
	$results = $obj_ads->getAds("files",$Id,"","","","","","",true);
	$result = $results[0];
	$nom = stripslashes($nom);
	$message = stripslashes($message);
	$message = _ADSEXPEDITEURNAME.$nom."\n\n"._ADSEXPEDITEURMAIL.$email."\n\n".$message."\n\n.";
	if (utilFuncs_simpleJob::send_email($result["email"], $email, _ADSSUBJECTMAIL, $message)) {
		$sortie .= "<p><br />"._ADSMAILSENT."</p>";
	}
	else {
		$sortie .= "<p><br />"._ADSMAILNOTSENT."</p>";
	}
	$obj_ads->ajoutReponse();
	/*$sortie .='<form name="return" action="'.$retour.'" method="POST">';
	$sortie .= '<div align="center"';
	$sortie .= '<br />&nbsp;<br />';
	$sortie .= '<input type="submit" value="'._ADSMAILRETURN.'" name="valid">';
	$sortie .= '</div>';
	$sortie .= '</form>';*/
	return $sortie;
}

function save_wanted($newwanted) {
	global $module_name,$nukeurl,$jobsadminmail;
	$obj_ads = new BD_Jobs();
	
	$sortie = "<h1>"._JOBSWANTEDSAVETITLE."</h1>";
	
/*	if ($newwanted["Id"] != "-1" && $newwanted["Id"] != "") {
		$wanteds = $obj_ads->getWanted("files",$newwanted["Id"]);
		$wanted = $wanteds[0];
		$newwanted["cv"] = $wanted["cv"];
	}*/
	
	if ($newwanted["date_inscription"] == "") {
		$newwanted["date_inscription"] = date("Y-m-d H:i:s");
	}
	if ($newwanted["clef"] == "") {
		$newwanted["clef"] = md5(date("Y-m-d H:i:s").$newwanted["email"]);
	}
	if ($newwanted["valide"] == "") {
		$newwanted["valide"] = "0";
	}
	
	
	if ($_FILES["cv"]["name"] != "") {
		//upload cv
		$chemin="catalog_repository/simple_jobs";
		$nomDestination = $newwanted["clef"].strrchr($_FILES["cv"]["name"],'.');
		if ($newwanted["cv_old"] != "" && file_exists($chemin."/".$newwanted["cv_old"])) {
			unlink($chemin."/".$newwanted["cv_old"]);
		}
		if (!file_exists($chemin)) {
			if (mkdir("$chemin", 0777)) {
				chmod("$chemin",0777);
				//echo "Dossier des photos cr&eacute;&eacute;.";
			}
			else {
				die("Dossier $chemin non cr&eacute;&eacute; - V&eacute;rifiez les droits");
			}	
		}
		if (is_uploaded_file($_FILES["cv"]["tmp_name"])) {
			$cv = $chemin."/".$nomDestination;
			if (rename($_FILES["cv"]["tmp_name"],$cv)) { 
				chmod($cv,0777);
			}
			else {
				die("Le dplacement du fichier temporaire a chou. Vrifiez l'existence du rpertoire $chemin");
			}          
		}
		else {
			die("Le fichier n'a pas t upload (trop gros ? droits ?)");
		}
		$newwanted["cv"] = $nomDestination;
		//fin de l'upload
	}
	else {
		$newwanted["cv"] = $newwanted["cv_old"];
	}
	unset($newwanted["cv_old"]);
	
	if ($obj_ads->saveWanted($newwanted)) {
		$tab_serveur = parse_url($nukeurl);
		$racine = $tab_serveur["scheme"]."://";
		if ($tab_serveur["user"] != "") {
			$racine .= $tab_serveur["user"];
		}
		if ($tab_serveur["pass"] != "") {
			$racine .= ":".$tab_serveur["pass"];
		}
		if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
			$racine .= "@";
		}
		$racine .= $tab_serveur["host"];
		if ($tab_serveur["port"] != "") {
			$racine .= ":".$tab_serveur["port"];
		}
		
		$lien = $racine."/modules.php?name=SimpleJob&sop=edit_wanted&clef=".$newwanted["clef"];
		$sortie .= "<p>".str_replace("<!--lien-->",'<a href="'.$lien.'">'.$lien."</a>",_JOBSWANTEDSAVED)."</p>";
		//e-mail internaute
		utilFuncs_simpleJob::send_email($newwanted["email"], $jobsadminmail, _JOBSWANTEDSUBJECTSAVEDMAIL, str_replace("<!--lien-->",$lien,_JOBSWANTEDSAVEDMAIL));
		//e-mail adminstrateur
		$lien = $racine."/system.php?action=list_wanted_no&op=jobswanted&onglet=wantedno";
		if ($newwanted["Id"] != "-1" && $newwanted["Id"] != "") {
			$message = _JOBSWANTEDSAVEDMAILADMIN2;
		}
		else {
			$message = _JOBSWANTEDSAVEDMAILADMIN;
		}
		utilFuncs_simpleJob::send_email($jobsadminmail, $jobsadminmail, _JOBSWANTEDSUBJECTSAVEDMAILADMIN, str_replace("<!--lien-->",$lien,$message));
	}
	else {
		$sortie .= "<p>"._JOBSWANTEDNOTSAVED."</p>";
	}
	return $sortie;
}

function list_cat_wanted($page) {
	global $module_name,$modmenu;
	require_once("modules/SimpleMembers/lib_db.php");
	require_once("modules/becmsDynMenu/lib/g_params.php");
	$obj_dom = new BD_Members();
	$domaines = $obj_dom->getDoms();
	$obj_ads = new BD_Jobs();
	$sortie = '<fieldset><legend>'._JOBSALLMETIERS.'</legend>';
	$sortie .= '<ul class=\"listmetiers\">';
	foreach ($domaines as $domaine) {
		if ($domaine["code"]%100 == 0) {
			$nbreFiches = $obj_ads->getWanted("count","",$domaine["code"],"",true);
			$lien = "modules.php?name=".$module_name."&sop=list_wanted";
			$lien .= "&domaine=".$domaine["code"];
			if ($page != "") {
				$lien .= "&page=".$page;
			}
			if ($GLOBALS[$modmenu["Menu"]] != "") {
				$lien .= '&'.$modmenu["Menu"].'='.$GLOBALS[$modmenu["Menu"]];
			}
			$sortie .= '<li><a href="'.$lien.'">'.$domaine["label"]." (".$nbreFiches.")</a></li>";
		}
	}
	$sortie .= '</ul>';
	$sortie .= '</fieldset>';
	return $sortie;
}

function display_one_wanted($result2,$withdomain=false) {
	$sortie .= '<p><b>'.utilFuncs_simpleJob::date2JMA($result2["date_inscription"]).'</b></p>';
	if ($result2["domaine"] != "" && $withdomain) {
		$sortie .= '<p><b>'._WANTEDDOMAIN."</b>".$result2["domaine"]."</p>";
	}
	$sortie .= '<p>'.nl2br($result2["candidature"]).'</p>';
	if ($result2["cv"] != "") {
		$chemin="catalog_repository/simple_jobs";
		$lien = $chemin."/".$result2["cv"];
		$sortie .= '<p>'.str_replace("<!--lien-->",$lien,_WANTEDCV).'</p>';
	}
	if ($result2["email"] != "") {
		$sortie .= '<p><b>'._WANTEDCONTACT."</b><a href=\"mailto:".$result2["email"]."?subject=".addslashes(_JOBSWANTEDABOUT)."\">".$result2["email"]."</a></p>";
		//$adresse = 'modules.php?name='.$module_name.'&sop=sendMail&Id='.$result2["Id"];
		//$sortie .= '<br /><a href="'.$adresse.'&retour='.urlencode($_SERVER["REQUEST_URI"]).'">'._ADSEMAILANNONCE.'</a>';
	}
	return $sortie;
}

function list_wanted($domaine,$page) {
	global $module_name,$jobslinesperpage;
	
	global $user;
	
	if (!is_user($user)) {
		$sortie = "<h1>Authentification</h1>";
		$sortie .= "<p>Pour consulter cette partie du site, vous devez tre identifi comme membre.<br />Veuillez remplir vos indentifiant et mot de passe dans le bloc situ en haut  gauche. Merci.</p>";
		return $sortie;
	}
	
	ajoutStat("202 : consultation des candidatures spontannes");
	
	require_once("modules/SimpleMembers/lib_db.php");
	$obj_dom = new BD_Members();
	
	$ligne_par_page = $jobslinesperpage;
	$page = ($page < 1) ? 1 : $page;
	//$ligne_par_page = $adsnbreforcat;

	$obj_ads = new BD_Jobs();
	
	$sortie = "<h1>"._JOBSWANTED."</h1>";
	
	if ($domaine != "") {
		/*$results = $obj_ads->getCats($cat);
		$result = $results[0];
		list($cat,$categorie,$image) = $result;
		$sortie = "<h1>".'<img src="images/topics/'.$image.'" alt="'.$categorie.'" class="ads">'.$categorie."</h1>";*/
		$domaines = $obj_dom->getDoms("", "", $domaine);
		$sortie .= "<h2>".$domaines[0]["label"]."</h2>";
		$url = "modules.php?name=".$module_name."&sop=listwanted&domaine=".$domaine;
			$sortie .= '&nbsp;<br />';
		//$sortie .= '<img src="images/topics/'.$image.'" alt="'.$categorie.'">';
		$nbreFiches = $obj_ads->getWanted("count","",$domaine,"",true);
		$indexlist = list_index($nbreFiches, $page, $ligne_par_page,$url);
	
		$sortie .= "<hr class=\"pages\">".$indexlist."<hr class=\"pages\">";
	
		//$sortie .= '&nbsp;<br />';
		$limit = (($ligne_par_page*($page-1))).",".$ligne_par_page;
		$result2s = $obj_ads->getWanted("files","",$domaine,"",true,"",$limit);
		$first = true;
		if (count($result2s) != 0) {
			foreach($result2s as $result2) {
				$domaines = $obj_dom->getDoms("","",$result2["domaine"]);
				$result2["domaine"] = $domaines[0]["label"];
				if (!$first) {
					$sortie .= "<hr class=\"sepjobs\">";
				}
				else {
					$first = false;
				}
				$sortie .= display_one_wanted($result2,false);
			}
		}
		//$sortie .= '&nbsp;<br />';
		$sortie .= "<hr class=\"pages\">".$indexlist."<hr class=\"pages\">";
	}
	else {
		$sortie = "<h1>"._JOBSWANTED."</h1>";
		$url = "modules.php?name=".$module_name."&sop=listwanted";
		$sortie .= list_cat_wanted($page);
		$sortie .= "&nbsp;<br />";
		$sortie .= '<h2>'._JOBSLASTFIVEWANTED.'</h2>';
		$sortie .= "&nbsp;<br />";
		$result2s = $obj_ads->getWanted("files","",$domaine,"",true,"","0,5");
		$first = true;
		if (count($result2s) != 0) {
			foreach($result2s as $result2) {
				$domaines = $obj_dom->getDoms("","",$result2["domaine"]);
				$result2["domaine"] = $domaines[0]["label"];
				if (!$first) {
					$sortie .= "<hr class=\"sepjobs\">";
				}
				else {
					$first = false;
				}
				$sortie .= display_one_wanted($result2,true);
			}
		}
	}
	return $sortie;
}

function displayCats() {
	global $module_name;
	include ('header.php');
	echo list_cats();
	$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
                  "top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

function displayCatsPublic() {
	global $module_name;
	include ('header.php');
	echo list_cats_public();
	$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
                  "top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

function displayJobs($cat,$page) {
	global $module_name;
	include ('header.php');
	echo list_jobs($cat,$page);
	$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
			//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back"=>"modules.php?name=$module_name",
            "top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

function addNewWanted() {
	global $module_name;
	include ('header.php');
	echo edit_wanted("");
	$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
				"back"=>"javascript:window.history.back()",
                "top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

function saveWanted($newwanted) {
	global $module_name;
	include ('header.php');
	echo save_wanted($newwanted);
	$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
				"back"=>"modules.php?name=$module_name",
                "top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

function EditWanted($clef) {
	global $module_name;
	include ('header.php');
	echo edit_wanted($clef);
	$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
				"back"=>"javascript:window.history.back()",
                "top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

function displayWanted($domaine,$page) {
	global $module_name;
	include ('header.php');
	echo list_wanted($domaine,$page);
	$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
			//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
			"back"=>"modules.php?name=$module_name",
            "top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

function sendMailAds($Id,$retour) {
	global $module_name;
	if ($Id == "") {
		header("Location: modules.php?name=".$module_name);
	}
	else {
		include ('header.php');
		
		echo send_email_ads($Id,$retour);
		
		$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
		//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
					"back"=>"javascript:window.history.back()",
	                "top"=>"#top" );
		buttonBar($bardef, "align");
		include ('footer.php');
	}
}


function mailAdsSent($Id,$nom,$message,$email,$retour) {
	global $module_name;
	if ($Id == "") {
		header("Location: modules.php?name=".$module_name);
	}
	else {
		include ('header.php');
		
		echo email_sent_ads($Id,$nom,$message,$email,$retour);
		
		$bardef=array(//"print"=>"modules.php?name=".$module_name."&sop=print",
		//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
					"back"=>$retour,
	                "top"=>"#top" );
		buttonBar($bardef, "align");
		include ('footer.php');
	}
}

function print_facts($page) {
	global $site_logo,$Default_Theme, $nukeurl, $sitename, $datetime, $prefix, $db;

	if (file_exists("themes/$Default_Theme/style/Sections.css")){
		$moduleStyle= "<LINK REL=\"stylesheet\" HREF=\"themes/$Default_Theme/style/Chuck_Norris_Facts.css\" TYPE=\"text/css\">\n";
	} else if (file_exists("modules/Sections/css/default.css")) {
		$moduleStyle= "<LINK REL=\"StyleSheet\" HREF=\"modules/Chuck_Norris_Facts/css/default.css\" TYPE=\"text/css\">\n";
	} else $moduleStyle="";

	echo "
	<html>
	<head>
	<title>$sitename</title>
	<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=ISO-8859-1\">\n
	<LINK REL=\"StyleSheet\" HREF=\"themes/$Default_Theme/style/style.css\" TYPE=\"text/css\">\n
	$moduleStyle
	</head>
	<body bgcolor=\"#FFFFFF\" text=\"#000000\">
	<table border=\"0\"><tr><td>
	<table border=\"0\" width=\"650\" cellpadding=\"0\" cellspacing=\"1\" bgcolor=\"#000000\"><tr><td>
	<table border=\"0\" width=\"650\" cellpadding=\"20\" cellspacing=\"1\" bgcolor=\"#FFFFFF\"><tr><td>
	<div class=\"printHeader\"><img src=\"images/$site_logo\" border=\"0\" alt=\"\"></div>
	<div class=\"zprint\">"
	.list_citations($page)
	."</div>
		</td></tr></table></td></tr></table>

		<div class=\"printFooter\">
		<div class=\"siteName\">
    "._COMESFROM." $sitename<br>
	<a href=\"$nukeurl\">$nukeurl</a>
	</div>
	<div class=\"pageURL\">
    "._THEURL."<br>
	<a href=\"$nukeurl/modules.php?name=Chuck_Norris_Facts&sop=list&page=$page\">$nukeurl/modules.php?name=Chuck_Norris_Facts&sop=list&page=$page</a>
	</div>
	</div>
	</td></tr></table>
	</body>
	</html>
    ";

}

if (!isset($page)) {
	$page = "1";
}
if ($page == "") {
	$page = "1";
}

$newwanted = array(
"Id"=>(!isset($Id))?"":$Id,
"domaine"=>(!isset($domaine))?"":$domaine,
"candidature"=>(!isset($candidature))?"":$candidature,
"cv"=>(!isset($cv))?"":$cv,
"cv_old"=>(!isset($cv_old))?"":$cv_old,
"date_inscription"=>(!isset($date_inscription))?"":$date_inscription,
"email"=>(!isset($email))?"":$email,
"clef"=>(!isset($clef))?"":$clef,
"valide"=>(!isset($valide))?"":$valide
);

switch($sop) {
	case "public":
		displayCatsPublic();
		break;
	case "list":
		displayCats();
		break;
	case "listjobs":
		displayJobs($Id,$page);
		break;
	case "new_wanted":
		addNewWanted();
		break;
	case "save_wanted":
		saveWanted($newwanted);
		break;
	case "edit_wanted":
		editWanted($clef);
		break;
	case "list_wanted":
		displayWanted($domaine,$page);
		break;
	case "sendMail":
		sendMailAds($Id,$retour);
		break;
	case "mailSent":
		mailAdsSent($Id,$nom,$message,$email,$retour);
		break;
	case "print":
		print_facts($page);
		break;
	default:
		displayCatsPublic();
		//echo "Aucune opration  effectuer n'a t choisie'";
		break;
}
?>