<?php
/**
 * Interface d'administration du module de gestion du glossaire.
 *
 * Cette valeur est fixe dans link.php.
 * @package becmsSimpleGlossaire
 * @version 0.1
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2008, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight($module_name)) {
	//setPath(_TXT_Modules,0);
	//setPath(_SIMPLECARTO,1);
	require_once("modules/$module_name/lib_db.php");
	require_once("modules/$module_name/utils.php");
	require_once("core/becms_ui_component.php");

	function list_index($nbreFiches, $page, $ligne_par_page,$tab_words="") {
		if ($tab_words != "") {
			$tab_words = "&search_words=".urlencode($tab_words);
		}
		$nboites = 5;
		$liminf = $page - floor($nboites/2);
		$limsup = $page + floor($nboites/2);
		if ($liminf < 1) {
			$liminf = 1;
			$limsup = $nboites;
			if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
				$limsup = ceil($nbreFiches/$ligne_par_page);
			}
		}
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
			$liminf = $limsup - $nboites;
			if ($liminf < 1) {
				$liminf = 1;
			}
		}
		$min = 1;
		$max = ceil($nbreFiches/$ligne_par_page);


		$repParPage = $ligne_par_page;
		$p = $page;
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches._BOARDFOUND;
			$indexPages .= _BOARDPAGES;
			if ($min < $liminf) {
				if ($min == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$min";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=board&action=list_comm&page=$min".$tab_words."\">$min</a>";
					$indexPages .= "</div>";
				}
				if ($min < $liminf - 1) {
					$indexPages .= "...";
				}
			}
			for ($i=$liminf;$i<=$limsup;$i++) {
				if ($i == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$i";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=board&action=list_comm&page=$i".$tab_words."\">$i</a>";
					$indexPages .= "</div>";
				}
			}
			if ($max > $limsup) {
				if ($max > $limsup + 1) {
					$indexPages .= "...";
				}
				if ($max == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$max";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?op=board&action=list_comm&page=$max".$tab_words."\">$max</a>";
					$indexPages .= "</div>";
				}

			}
		}
		else {
			$indexPages .= _BOARDNOTFOUND;
		}
		$indexPages .= "</div>";
		return $indexPages;
	}

	function list_glossaire() {
		$ongletencours = "glossaire";
		
		$obj_cat = new BD_Gloss();
		$nbrefiches = $obj_cat->getTerme("count");
		
		$liste = '<table border="0" cellpadding="0" cellspacing="0" align="center"><tr><td>';
		$liste .= "<div class=\"pages\">".$nbrefiches._GLOSSFOUND."</div>";
		$liste .= '</td></tr></table>';
		$results = $obj_cat->getTerme("files");
		$liste .= '
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader" style="text-align: left">'._GLOSSLISTTERME.'</th>
					<th class="systemTabHeader" style="text-align: left">'._GLOSSLISTDEF.'</th>
					<th class="systemTabHeader">'._GLOSSLISTPICT.'</th>
					<th class="systemTabHeader" style="text-align: left">'._GLOSSLISTLEGENDE.'</th>
	    			<th class="systemTabHeader">'._GLOSSACTIONS.'</th>
		    	</tr>';
		$pos=0;
		foreach ($results as $result) {
			$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=gloss&action=edit_terme&onglet=".$ongletencours."&Id=".$result["Id"],"comment"=>_EDIT, "status"=>"ON"),
	  			  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=gloss&action=delete_terme&onglet=".$ongletencours."&Id=".$result["Id"],"comment"=>_DELETE,"status"=>"ON"));
			if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
			$pos++;
			$liste .= '<tr class="'.$thestyle.'">';
			$liste .= '<td>';
			$liste .= utilFuncs_SimpleGloss::conditionnerHTML($result["terme"]);
			$liste .= '</td><td>';
			$result["definition"] = utilFuncs_SimpleGloss::conditionnerHTML($result["definition"]);
			$longlim = 150;
			if (strlen($result["definition"]) > $longlim) {
				$i = $longlim;
				while (substr($result["definition"],$i,1) != " ") {
					$i--;
				}
				$liste .= substr($result["definition"],0,$i)."...";
			}
			else {
				$liste .= $result["definition"];
			}
			$liste .= '</td><td>';
			$liste .= utilFuncs_SimpleGloss::conditionnerHTML($result["illustration"]);
			$liste .= '</td><td>';
			$liste .= utilFuncs_SimpleGloss::conditionnerHTML($result["legende"]);
			$liste .= '</td><td align="center">';
			$liste .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
			$liste .= '</td>';
			$liste .= '</tr>';
		}
		$liste .= '</table>';
		$liste .= '<div><a href="system.php?op=gloss&action=add_terme&onglet=glossaire">'._GLOSSADDTERME.'</a></div>';
		return $liste;
	}
	
	function edit_terme($Id) {
	    global $header_system, $module_name;
	    
	    $header_system = '
<script src="modules/'.$module_name.'/system/lib_AJAX.js" type="text/javascript"></script>
<script type="text/javascript">       
	function deletePhoto(id) {
		if (confirm("En tes-vous sr ? La photo sera supprime immdiatement et les modifications de la fiche courante seront perdues.")) {
			var result = GetAJAXData("system.php?op=gloss&action=delete_photo&Id="+id);
			//alert(result);
			window.location.reload();
		}
		return false;
	}
</script>
';
	    
		$obj_cat = new BD_Gloss();
		$results = array();
		if ($Id == "") {
			$Id = "-1";
		}
		if ($Id != "-1") {
			$results = $obj_cat->getTerme("files",$Id);
			$result = $results[0];
		}
		else {
		    $result = array(
		        "terme" => "",
		        "definition" => "",
		        "illustration" => "",
		        "legende" => "",
		        "radical" => ""
		    );
		}
		
		$photo1 = "";
		if ($result["illustration"] != "" && file_exists($result["illustration"])) {		    
		    $photo1 .= '<div style="float: left;">';
		    $photo1 .= '<img src="'.$result["illustration"].'" width="100" align="top"/>';
		    $photo1 .= '<a href="#" onclick="return deletePhoto(\''.$result["Id"].'\')" title="Effacer la photo">'
		        .'<img src="system/skins/joomla/delete_16x16.png" align="top" style="position: relative; left: -20px; background-color: #ccc; border: 2px outset #fff">'
		            .'</a>';
		            $photo1 .= '<br />'.$result["illustration"].'</div><span style="clear: both; display: block"></span>';
		            if ($hauteur_fic == 0 || $largeur_fic == 0) {
		                $taille = getimagesize($result["illustration"]);
		                $largeur_fic = $taille[0];
		                $hauteur_fic = $taille[1];
		            }
		}
		
		$ongletcourant = "glossaire";

		$sortie = '<form name="editgloss" action="system.php?op=gloss&action=save_terme&onglet='.$ongletcourant.'" method="POST" enctype="multipart/form-data">';
		$sortie .= '<div align="center">';
		$sortie .= '&nbsp;<br />';
		$sortie .= '<table border="0" cellpadding="5" cellspacing="0">';
		
		$sortie .= '<tr><td>';
		$sortie .= _GLOSSTERMEEDIT;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="terme" value="'.utilFuncs_SimpleGloss::conditionnerFORM($result["terme"]).'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _GLOSSDEFEDIT;
		$sortie .= '</td><td>';
		$sortie .= '<textarea name="definition" cols="50" rows="10" class="saisie">'.$result["definition"].'</textarea>';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _GLOSSPHOTOEDIT;
		$sortie .= '</td><td>';
		$sortie .= $photo1.(($photo1 == "") ? ('<input type="file" name="illustration[]" value="'.$result["illustration"].'" size="50" class="fichier">'):'');		
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _GLOSSLEGENDEEDIT;
		$sortie .= '</td><td>';
		$sortie .= '<input type="text" name="legende" value="'.utilFuncs_SimpleGloss::conditionnerFORM($result["legende"]).'" class="saisie">';
		$sortie .= '</td></tr>';
		
		$sortie .= '<tr><td>';
		$sortie .= _GLOSSRADEDIT;
		$sortie .= '</td><td>';
		$sortie .= '<textarea name="radical" cols="50" rows="10" class="saisie">'.$result["radical"].'</textarea>';
		$sortie .= '</td></tr>';
		
		$sortie .= '</table>';
		$sortie .= '<br />&nbsp;<br />';
		$sortie .= '<input type="submit" value="'._GLOSSSAVEBTN.'" name="validbtn">';
		$sortie .= '<input type="hidden" value="'.$Id.'" name="Id">';
		$sortie .= '<br />&nbsp;';
		$sortie .= '</div>';
		$sortie.= "</form>";
		return $sortie;
	}
	
	function save_terme($Id, $terme, $definition, $legende, $radical) {
		$termetab = array(
			"Id"=>$Id,
		    "terme"=>$terme,
		    "definition"=>$definition,
		    "legende"=>$legende,
		    "radical"=>$radical
		);
		$obj_gloss = new BD_Gloss();
		if (!$obj_gloss->saveTerme($termetab) ) {
			die("DB problem 1");
		}
		
		if ($Id == "-1") {
		    $termetab["Id"] = $obj_gloss->lastSaved();
		}
		//enregistrement photos
		$width = 1024;
		$height = 768;
		include("core/conf/uploadconfig.php");
		$chemin = $uploadFolder."/../simple_glossaire";
		//pour plus tard : virer la photo courante si elle existe
		if (count($_FILES["illustration"]) > 0) {
		    $photosSaved = uploadFiles($_FILES["illustration"], $chemin, $width, $height);
		    
		    $termetab["illustration"] = $photosSaved[0];
		    if (!$obj_gloss->saveTerme($termetab)) {
		        die("DB problem 2 - terme enregistr sans la photo");
		    }
		}
		return true;
	}
	
	function delete_photo($Id) {
	    $obj_gloss = new BD_Gloss();
	    $results = $obj_gloss->getTerme("files",$Id);
	    $result = $results[0];
	        
        if (file_exists($result["illustration"])){
            unlink($result["illustration"]);
            $obj_gloss->delPhotoTerme($Id);
        }
	}
	
	function delete_terme($Id, $confirm="n") {
		if ($Id != "") {
		    $obj_gloss = new BD_Gloss();
		    if ($confirm == "y"){
		        $results = $obj_gloss->getTerme("files",$Id);
		        $result = $results[0];
		        if (file_exists($result["illustration"])){
		            unlink($result["illustration"]);
		        }
				if($obj_gloss->delTerme($Id)) {
					$sortie = list_glossaire();
					return ($sortie);
				}
				else {
					die("DB problem");
				}
			}
			else {
			    $results = $obj_gloss->getTerme("files",$Id);
			    $result = $results[0];
				$sortie = "<div style=\"text-align: center; font-weight: bold\">";
				$sortie .= "<p>"._GLOSSCONFIRMDELETE."&quot;".$result["terme"]."&quot; ?</p>";
				$sortie .= "<p>&nbsp;</p>";
				$sortie .= "<p>";
				$sortie .= '<a href="system.php?op=gloss&action=delete_terme&Id='.$Id.'&confirm=y">';
				$sortie .= "["._GLOSSYES."]";
				$sortie .= "</a>";
				$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				$sortie .= '<a href="javascript:window.history.back()">';
				$sortie .= "["._GLOSSNO."]";
				$sortie .= '</a>';
				$sortie .= "</p>";
				$sortie .= "</div>";
			
				return ($sortie);
			}
		}
		return list_glossaire();
	}
	
	function uploadFiles($fichiersUpload, $chemin="", $maxWith = 0, $maxHeight = 0) {
	    $chemin = rtrim($chemin, "/");
	    
	    if (!file_exists($chemin)) {
	        //$old = umask(0);
	        if (!mkdir($chemin,0777,true)) {
	            die("Impossible de crer le dossier de destination de l'upload !");
	        }
	        touch($chemin."/index.htm");
	        //chmod($chemin, "0777");
	        //umask($old);
	    }
	    
	    $fichier = array();
	    for ($i=0; $i<count($fichiersUpload["name"]); $i++) {
	        if ($fichiersUpload["name"][$i] != "") {
	            $nomDestination = md5(time()+rand(0,10)).strrchr($fichiersUpload["name"][$i],'.');
	            while (file_exists($chemin."/".$nomDestination)) {
	                $nomDestination = md5(time()+rand(0,10)).strrchr($fichiersUpload["name"][$i],'.');
	            }
	            if (is_uploaded_file($fichiersUpload["tmp_name"][$i])) {
	                //$fichier[$i] = strtolower($chemin."/".$nomDestination);
	                //$fichier[$i] = str_replace($_SERVER['DOCUMENT_ROOT']."/",'',realpath($chemin)."/".$nomDestination);
	                
	                $fichier[$i] = str_replace(str_replace('\\', '/', realpath("."))."/",'',str_replace('\\', '/', realpath($chemin))."/".$nomDestination);
	                
	                if (rename($fichiersUpload["tmp_name"][$i],$fichier[$i])) {
	                    chmod($fichier[$i],0777);
	                    
	                    $size = getimagesize($fichier[$i]);
	                    $width = $size[0];
	                    $height = $size[1];
	                    
	                    $extension = strtolower(strrchr($fichier[$i],'.'));
	                    
	                    //test si les dimensions de l'image sont correctes et sinon applique le redimensionnement
	                    if ($width >= $maxWith || $height >= $maxHeight) {
	                        //calcul nouvelle taille
	                        if (($width/$maxWith) > ($height/$maxHeight)) {
	                            if ($maxWith != 0) {
	                                $newwidth = $maxWith;
	                                $newheight = ($height * $maxWith) / $width;
	                            }
	                            else {
	                                $newwidth = ($width * $maxHeight) / $height;
	                                $newheight = $maxHeight;
	                            }
	                        }
	                        else {
	                            if ($maxHeight != 0) {
	                                $newwidth = ($width * $maxHeight) / $height;
	                                $newheight = $maxHeight;
	                            }
	                            else {
	                                $newwidth = $maxWith;
	                                $newheight = ($height * $maxWith) / $width;
	                            }
	                        }
	                        //pour les cas des jpg
	                        if($extension == '.jpg' || $extension == '.jpeg') {
	                            $src = imagecreatefromjpeg($fichier[$i]);
	                            $tmp=imagecreatetruecolor($newwidth,$newheight);
	                            imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
	                            imagejpeg($tmp,$fichier[$i],70);
	                            imagedestroy($src);
	                            imagedestroy($tmp);
	                        }
	                        //pour les cas des gif
	                        if($extension == '.gif') {
	                            $src = imagecreatefromgif($fichier[$i]);
	                            $tmp=imagecreatetruecolor($newwidth,$newheight);
	                            $trans = imagecolorallocate($tmp,255,255,255);
	                            imagefilledrectangle($tmp,0,0,$newwidth,$newheight,$trans);
	                            imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
	                            imageinterlace($tmp);
	                            imagegif($tmp,$fichier[$i]);
	                            imagedestroy($src);
	                            imagedestroy($tmp);
	                        }
	                        //pour les cas des png
	                        if($extension == '.png') {
	                            $src = imagecreatefrompng($fichier[$i]);
	                            $tmp=imagecreatetruecolor($newwidth,$newheight);
	                            imagealphablending($tmp, false);
	                            imagesavealpha($tmp, true);
	                            imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
	                            $fond_noir = imagecolorallocate($destination, 0, 0, 0);
	                            imagecolortransparent($destination, $fond_noir);
	                            imagepng($tmp,$fichier[$i]);
	                            imagedestroy($src);
	                            imagedestroy($tmp);
	                        }
	                    }
	                }
	                else {
	                    die("Le dplacement du fichier temporaire a chou. Vrifiez l'existence du rpertoire $chemin");
	                }
	            }
	            else {
	                die("Le fichier n'a pas t upload (trop gros ? droits ?)");
	            }
	        }
	    }
	    return $fichier;
	}

	/**
	 * Renvoie l'interface d'administration de ce module.
	 *
	 * La liste des clients, les formulaires d'dition et le rsultats des oprations sont affichs par cette fonction.
	 * Elle ne retourne aucune valeur mais effectue rellement l'affichage.
	 */
	function process_gloss(){
		global $prefix, $db, $language, $multilingual, $Default_Skin, $SkinPath, $onglet,$module_name,$action,$page,$image,$search_words,$cat, $confirm,$valid;
		global $Id, $terme, $definition, $legende, $radical;

		if (!isset($action) || $action == "") {
			$action = "list_gloss";
		}
		if (!isset($page) || $page == "") {
			$page = "1";
		}

		$sortie = "";
		$operationOnglet = "";

		switch ($action) {
		    case "list_gloss" :
				$sortie = list_glossaire();
				$operationOnglet = _GLOSSLIST;
				break;
			case "edit_terme" :
				$sortie = edit_terme($Id);
				$operationOnglet = _GLOSSEDIT;
				break;
			case "add_terme" :
			    $sortie = edit_terme("");
			    $operationOnglet = _GLOSSNEWTERME;
			    break;
			case "save_terme" :
			    if (save_terme($Id, $terme, $definition, $legende, $radical)) {
					$sortie = list_glossaire();
					$operationOnglet = _GLOSSLIST;
				}
				break;
			case "delete_photo":
			    $sortie = delete_photo($Id);
			    return $sortie;
			    break;
			case "delete_terme" :
				$sortie = delete_terme($Id, $confirm);
				$operationOnglet = _GLOSSLIST;
				break;
		}

		if (!isset($onglet)) {
			$onglet = "glossaire";
		}
		if ($onglet == "") {
			$onglet = "glossaire";
		}
		$ongletDef=array("glossaire"=> array( "text"=>_GLOSSONGLETLIST, "url"=>"system.php?action=list_gloss&op=gloss&onglet=glossaire"));
		
		include("system/header_system.php");

		echo "<link rel=\"StyleSheet\" type=\"text/css\" href=\"modules/".$module_name."/system/stl_glossaire.css\">";
		GraphicAdmin(_GLOSSMODULE);
		OpenOngletTable();
		displayOngletBar($onglet,$operationOnglet,$ongletDef);
		OpenSysTable();
		echo $sortie;
		CloseSysTable();
		CloseOngletTable();
		include("system/footer_system.php");
	}

	/**
	 * Vrifie que le paramtre d'opration est bien "client", sinon affiche "Access denied".
	 */
	switch ($op) {
		case "gloss":
			process_gloss();
			break;
	}
}
else {
	display_denied();
}

?>