<?php
if (preg_match("#connector_class.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

class cursinuconnector {

	var $db; // db Object
	var $prefix; // db prefix
	var $multilingual; // is multilingual
	var $currentlang; // current language
	var $niveau_valid;
	var $nM_min;
	var $nF_min;
	var $lignee;
	var $lignee_list;
	var $champs_lignee;
	var $indice;
	var $genealogie;
	var $niveau_desc;
	var $liste_desc;

	/**
	 * Constructor
	 */
	function cursinuconnector(){
		// get data from framwork
		global $db, $prefix, $multilingual, $currentlang;
		$this->db=$db;
		$this->prefix=$prefix;
		$this->multilingual=$multilingual;
		$this->currentlang=$currentlang;
		$this->niveau_valid = 3;
		$this->nM_min = 2;
		$this->nF_min = 6;
		$this->lignee = array();
		$this->lignee_list = array();
		$this->champs_lignee = array("Id","lof","icad","nom_complet","affixe","sexe","naissance","id_proprio", "user_name", "user_firstname","id_pere", "nom_pere", "nom_mere", "id_mere","lignee_valide");
		$this->champs_genealogie = array("Id","lof","icad","nom_complet","affixe","sexe","naissance","id_proprio", "user_name", "user_firstname","lignee_valide");
		$this->indice = 0;
		$this->genealogie = array();
		$this->niveau_desc = 1000;
		$this->liste_desc=array();
		$this->profondeur_desc = 0;
	}

	function get_lignee($id_chien, $niveau=0){
		if ($id_chien != 0 && $niveau <= $this->niveau_valid) {
			$sql = 'SELECT `'.$this->prefix.'_cursinu_chien`.`Id`, `'.$this->prefix.'_cursinu_chien`.`lof`,`'.$this->prefix.'_cursinu_chien`.`icad`, CONCAT(`'.$this->prefix.'_cursinu_chien`.`prefixe`,`'.$this->prefix.'_cursinu_chien`.`nom`,`'.$this->prefix.'_cursinu_chien`.`suffixe`) as nom_complet, `'.$this->prefix.'_cursinu_chien`.`affixe`, `'.$this->prefix.'_cursinu_chien`.`sexe`, `'.$this->prefix.'_cursinu_chien`.`naissance`, `'.$this->prefix.'_cursinu_chien`.`id_pere`, `'.$this->prefix.'_cursinu_chien`.`id_mere`, `'.$this->prefix.'_cursinu_chien`.`lignee_valide` ';
			$sql .= ', CONCAT(`parentpere`.`prefixe`, `parentpere`.`nom`, `parentpere`.`suffixe`) as nom_pere, CONCAT(`parentmere`.`prefixe`, `parentmere`.`nom`, `parentmere`.`suffixe`) as nom_mere ';
			$sql .= ', `user_name`, `user_firstname`,'.$this->prefix.'_cursinu_chien.id_proprio';
			$sql .= ' FROM '.$this->prefix.'_cursinu_chien';
			$sql .= ' LEFT JOIN `'.$this->prefix.'_cursinu_chien` as parentpere ON `'.$this->prefix.'_cursinu_chien`.id_pere=parentpere.id';
			$sql .= ' LEFT JOIN `'.$this->prefix.'_cursinu_chien` as parentmere ON `'.$this->prefix.'_cursinu_chien`.id_mere=parentmere.id';
			$sql .= ' LEFT JOIN `'.$this->prefix.'_users` ON '.$this->prefix.'_cursinu_chien.id_proprio='.$this->prefix.'_users.uid';
			$sql .= ' WHERE `'.$this->prefix.'_cursinu_chien`.`Id`=\''.$id_chien.'\'';
			$sql .= ';';
			
			$chien = array();			
			$result = $this->db->sql_query($sql);
			if ($this->db->sql_numrows($result) > 0) {
				if ($ligne = $this->db->sql_fetchrow($result)) {
					foreach ($this->champs_lignee as $unchamp) {
						$chien[$unchamp] = $ligne[$unchamp];
					}
					$chien["pere"] = $this->get_lignee($ligne["id_pere"],($niveau+1));
					$chien["mere"] = $this->get_lignee($ligne["id_mere"],($niveau+1));
					return $chien;
				}
				else die("Erreur 2");
			}
			else {
				die("Erreur 1");
			}	
		}
		else {
			return false;
		}
	}
	
	function get_lignee_virtuelle($id_male, $id_femelle){
		$niveau = 0;
		if ($id_male != 0 && $id_femelle != 0) {
			$chien = array();
			$chien["lof"] = "LOFTEST";
			$chien["nom_complet"] = "NOMTEST";
			$chien["pere"] = $this->get_lignee($id_male,($niveau+1));
			$chien["mere"] = $this->get_lignee($id_femelle,($niveau+1));	
			return $chien;	
		}
		else {
			return false;
		}
	}
	
	function get_descendance($id_chien, $niveau=0) {
		if ($id_chien != 0 && $niveau == 0) {
			$sql = 'SELECT `'.$this->prefix.'_cursinu_chien`.`Id`, `'.$this->prefix.'_cursinu_chien`.`lof`,`'.$this->prefix.'_cursinu_chien`.`icad`, CONCAT(`'.$this->prefix.'_cursinu_chien`.`prefixe`, `'.$this->prefix.'_cursinu_chien`.`nom`, `'.$this->prefix.'_cursinu_chien`.`suffixe`) as nom_complet, `'.$this->prefix.'_cursinu_chien`.`affixe`, `'.$this->prefix.'_cursinu_chien`.`sexe`, `'.$this->prefix.'_cursinu_chien`.`naissance`, `'.$this->prefix.'_cursinu_chien`.`id_pere`, `'.$this->prefix.'_cursinu_chien`.`id_mere`, `'.$this->prefix.'_cursinu_chien`.`lignee_valide` ';
			$sql .= ', CONCAT(`parentpere`.`prefixe`, `parentpere`.`nom`, `parentpere`.`suffixe`) as nom_pere, CONCAT(`parentmere`.`prefixe`, `parentmere`.`nom`, `parentmere`.`suffixe`) as nom_mere ';
			$sql .= ', `user_name`, `user_firstname`, `user_firstname`,'.$this->prefix.'_cursinu_chien.id_proprio';
			$sql .= ' FROM '.$this->prefix.'_cursinu_chien';
			$sql .= ' LEFT JOIN `'.$this->prefix.'_cursinu_chien` as parentpere ON `'.$this->prefix.'_cursinu_chien`.id_pere=parentpere.id';
			$sql .= ' LEFT JOIN `'.$this->prefix.'_cursinu_chien` as parentmere ON `'.$this->prefix.'_cursinu_chien`.id_mere=parentmere.id';
			$sql .= ' LEFT JOIN `'.$this->prefix.'_users` ON '.$this->prefix.'_cursinu_chien.id_proprio='.$this->prefix.'_users.uid';
			$sql .= ' WHERE `'.$this->prefix.'_cursinu_chien`.`Id`=\''.$id_chien.'\';';
			$result = $this->db->sql_query($sql);
			if ($this->db->sql_numrows($result) > 0) {
				$ligne = $this->db->sql_fetchrow($result);
				$chien = array();
				foreach ($this->champs_lignee as $unchamp) {
					$chien[$unchamp] = $ligne[$unchamp];
				}
				$chien["enfants"] = $this->get_descendance($id_chien,($niveau+1));
				return array($chien);
			}
		}
		if ($id_chien != 0 && $niveau <= $this->niveau_desc && $niveau > 0) {
			$sql = 'SELECT `'.$this->prefix.'_cursinu_chien`.`sexe`';
			$sql .= ' FROM '.$this->prefix.'_cursinu_chien';
			$sql .= ' WHERE `'.$this->prefix.'_cursinu_chien`.`Id`=\''.$id_chien.'\';';
			$result = $this->db->sql_query($sql);
			if ($this->db->sql_numrows($result) > 0) {
				list($sexe) = $this->db->sql_fetchrow($result);
			}
			else {
				die("Erreur 3");
			}
			$where = "";
			if ($sexe == "M" ) {
				$where = ' WHERE `'.$this->prefix.'_cursinu_chien`.`id_pere`=\''.$id_chien.'\'';
			}
			if ($sexe == "F") {
				$where = ' WHERE `'.$this->prefix.'_cursinu_chien`.`id_mere`=\''.$id_chien.'\'';
			}
			if ($where == "") {
				die("Erreur 4");
			}
			
			$sql = 'SELECT `'.$this->prefix.'_cursinu_chien`.`Id`, `'.$this->prefix.'_cursinu_chien`.`lof`,`'.$this->prefix.'_cursinu_chien`.`icad`, CONCAT(`'.$this->prefix.'_cursinu_chien`.`prefixe`, `'.$this->prefix.'_cursinu_chien`.`nom`, `'.$this->prefix.'_cursinu_chien`.`suffixe`) as nom_complet, `'.$this->prefix.'_cursinu_chien`.`affixe`, `'.$this->prefix.'_cursinu_chien`.`sexe`, `'.$this->prefix.'_cursinu_chien`.`naissance`, `'.$this->prefix.'_cursinu_chien`.`id_pere`, `'.$this->prefix.'_cursinu_chien`.`id_mere`, `'.$this->prefix.'_cursinu_chien`.`lignee_valide` ';
			$sql .= ', CONCAT(`parentpere`.`prefixe`, `parentpere`.`nom`, `parentpere`.`suffixe`) as nom_pere, CONCAT(`parentmere`.`prefixe`, `parentmere`.`nom`, `parentmere`.`suffixe`) as nom_mere ';
			$sql .= ', `user_name`, `user_firstname`';
			$sql .= ' FROM '.$this->prefix.'_cursinu_chien';
			$sql .= ' LEFT JOIN `'.$this->prefix.'_cursinu_chien` as parentpere ON `'.$this->prefix.'_cursinu_chien`.id_pere=parentpere.id';
			$sql .= ' LEFT JOIN `'.$this->prefix.'_cursinu_chien` as parentmere ON `'.$this->prefix.'_cursinu_chien`.id_mere=parentmere.id';
			$sql .= ' LEFT JOIN `'.$this->prefix.'_users` ON '.$this->prefix.'_cursinu_chien.id_proprio='.$this->prefix.'_users.uid';
			$sql .= $where;
			$sql .= ';';
		
			$enfants = array();
			$result = $this->db->sql_query($sql);
			if ($this->db->sql_numrows($result) > 0) {
				while ($ligne = $this->db->sql_fetchrow($result)) {
					$chien = array();
					foreach ($this->champs_lignee as $unchamp) {
						$chien[$unchamp] = $ligne[$unchamp];
					}
					$chien["enfants"] = $this->get_descendance($ligne["Id"],($niveau+1));
					$enfants[] = $chien;
				}
				return $enfants;
			}
			else {
				return false;
			}
		}
		else {
			return false;
		}
	}
	//profondeur_desc
	function profondeur_genealogie($lignee,$niveau=0) {
		if (is_array($lignee)) {
			if ($this->profondeur_desc < $niveau) {
				$this->profondeur_desc = $niveau;
			}
			foreach($lignee as $unchien) {
				if (is_array($unchien["enfants"])) {
					$this->profondeur_genealogie($unchien["enfants"],$niveau+1);
				}
			}
			return $this->profondeur_desc;
		}
		else {
			return false;
		}
	}
	
	function list_genealogie($lignee,$niveau=0	) {
		if (is_array($lignee)) {
			foreach($lignee as $unchien) {
				$ligne=array();
				for ($i=0; $i<=$this->profondeur_desc; $i++) {
					$ligne[$i] = false;
				}
				$chien = array("Id"=>$unchien["Id"],"lof"=>$unchien["lof"],"nom_complet"=>$unchien["nom_complet"],"sexe"=>$unchien["sexe"]);
				$ligne[$niveau] = $chien;
				$this->liste_desc[] = $ligne;
				if (is_array($unchien["enfants"])) {
					$this->list_genealogie($unchien["enfants"],$niveau+1);
				}
			}
			return $this->liste_desc;
		}
		else {
			return false;
		}
	}
	
	function add_individu($chien, &$individusM, &$individusF) {
		if (true) {
			if ($chien["sexe"] == "M") {
				if (!in_array($chien, $individusM)) {
					$individusM[] = $chien;				}
			}
			if ($chien["sexe"] == "F") {
				if (!in_array($chien, $individusF)) {
					$individusF[] = $chien;				}
			}
		}
	}
	//array("Id","lof","icad","nom_complet","affixe","sexe","naissance","id_proprio", "user_name", "user_firstname","id_pere", "nom_pere", "nom_mere", "id_mere","lignee_valide");
	function list_individus($lignee) {
		if (is_array($lignee)) {
			$chien = array("Id"=>$lignee["Id"],"lof"=>$lignee["lof"],"id_pere"=>$lignee["id_pere"],"id_mere"=>$lignee["id_mere"],"sexe"=>$lignee["sexe"], "nom_complet"=>$lignee["nom_complet"], "naissance"=>$lignee["naissance"]);
			$this->lignee_list[] = $chien;
			$this->list_individus($lignee["pere"]);
			$this->list_individus($lignee["mere"]);
			return $this->lignee_list;
		}
		else {
			return false;
		}
	}
	
	function valid_lignee($lignee,$aveclimiteage = 1, $ligneecomplete = 0) {
		$individusM = array();
		$individusF = array();
		
		if ($ligneecomplete == 1) {
			if (count($lignee) < 15) {
				return false;
			}
		}
		
		if ($aveclimiteage == 1) {
			$agelimiteM = 5;
			$agelimiteF = 5;
		}
		else {
			$agelimiteM = 5;
			$agelimiteF = 1000;
		}
		//unset($lignee[0]); 							//on ne tient pas compte du chien dont on tudie l'ascendance car il se trouve en indice 0//finalement il faut en tenir compte
		foreach($lignee as $unchien) {
			$this->add_individu($unchien, $individusM, $individusF);
		}
		//$maintenant = mktime();
		$maintenant = date("Y-m-d");
		$nM = 0;
		foreach($individusM as $unchien) {
			list($an,$mois,$jour) = explode("-",$unchien["naissance"]);
			//$tempschien = mktime(0,0,0,$mois,$jour,($an+$agelimiteM));
			$tempschien = ($an+$agelimiteM)."-".$mois."-".$jour;
			if ($tempschien > $maintenant) {
				$nM++;
			}
		}
		//$nM = count($individusM);
		$nF = 0;
		foreach($individusF as $unchien) {
			list($an,$mois,$jour) = explode("-",$unchien["naissance"]);
			//$tempschien = mktime(0,0,0,$mois,$jour,($an+$agelimiteF));
			$tempschien = ($an+$agelimiteF)."-".$mois."-".$jour;
			if ($tempschien > $maintenant) {
				$nF++;
			}
		}
		//$nF = count($individusF);				
		if ($nM >= $this->nM_min && $nF >= $this->nF_min) {
			return true;
		}
		else {
			return false;
		}
	}
	
	function valid_lignee_64bits($lignee,$aveclimiteage = 1, $ligneecomplete = 0) { //cette fonction ne fonctionne pas sur des systmes 32 bits : mktime ne sait pas faire des timestamp > anne 2038
		$individusM = array();
		$individusF = array();
		
		if ($ligneecomplete == 1) {
			if (count($lignee) < 15) {
				return false;
			}
		}
		
		if ($aveclimiteage == 1) {
			$agelimiteM = 5;
			$agelimiteF = 5;
		}
		else {
			$agelimiteM = 5;
			$agelimiteF = 1000;
		}

		//unset($lignee[0]); 							//on ne tient pas compte du chien dont on tudie l'ascendance car il se trouve en indice 0//finalement il faut en tenir compte
		foreach($lignee as $unchien) {
			$this->add_individu($unchien, $individusM, $individusF);
		}
		$maintenant = mktime();
		$nM = 0;
		foreach($individusM as $unchien) {
			list($an,$mois,$jour) = explode("-",$unchien["naissance"]);
			$tempschien = mktime(0,0,0,$mois,$jour,($an+$agelimiteM));
			if ($tempschien > $maintenant) {
				$nM++;
			}
		}
		//$nM = count($individusM);
		$nF = 0;
		foreach($individusF as $unchien) {
			list($an,$mois,$jour) = explode("-",$unchien["naissance"]);
			$tempschien = mktime(0,0,0,$mois,$jour,($an+$agelimiteF));
			if ($tempschien > $maintenant) {
				$nF++;
			}
		}
		//$nF = count($individusF);				
		if ($nM >= $this->nM_min && $nF >= $this->nF_min) {
			return true;
		}
		else {
			return false;
		}
	}
	
	function valid_lignee_old($lignee) { //validation qui tient compte de la parente des chiens
		$individusM = array();
		$individusF = array();

		unset($lignee[0]); 							//on ne tient pas compte du chien dont on tudie l'ascendance car il se trouve en indice 0
		foreach($lignee as $unchien) {
			$this->add_individu($unchien, $individusM, $individusF);
		}
		$nM = count($individusM);
		$nF = count($individusF);
		
		if ($nM < $this->nM_min || $nF < $this->nF_min) {
			return false;
		}
		//dtermination des chiens sans aucune parent dans l'arbre
		for($i=1; $i<=count($lignee); $i++) {
			$lignee[$i]["avec_parente"] = false;
			for($j=1; $j<=count($lignee); $j++) {
				if ($i!= $j) {
					if (($lignee[$i]["id_pere"] == $lignee[$j]["id_pere"]) || ($lignee[$i]["id_mere"] == $lignee[$j]["id_mere"])) {
						$lignee[$i]["avec_parente"] = true;
					}
				}
			}
		}
		$nbre_M_seuls = 0;
		$nbre_F_seuls = 0;
		foreach($lignee as $unchien) {
			if (!$unchien["avec_parente"]) {
				if ($unchien["sexe"]=="M") {
					$nbre_M_seuls++;
				}
				if ($unchien["sexe"]=="F") {
					$nbre_F_seuls++;
				}
			}
		}
//print_r($lignee);
//echo "males : $nbre_M_seuls - femelles : $nbre_F_seuls";

		if ($nbre_M_seuls >= $this->nM_min && $nbre_F_seuls >= $this->nF_min) {
			return true;
		}
		else {
			return false;
		}
	}
	
	function score_lignee($lignee) {
		$individusM = array();
		$individusF = array();

		$lof = $lignee[0]["lof"];
		$nom_complet = $lignee[0]["nom_complet"];
		$sexe = $lignee[0]["sexe"];
		$Id = $lignee[0]["Id"];
		
		unset($lignee[0]);	//on ne tient pas compte du chien dont on tudie l'ascendance car il se trouve en indice 0
		foreach($lignee as $unchien) {
			$this->add_individu($unchien, $individusM, $individusF);
		}
		/*$nM = count($individusM);
		$nF = count($individusF);
		
		if ($nM < $this->nM_min || $nF < $this->nF_min) {
			return false;
		}*/
		//dtermination des chiens sans aucune parent dans l'arbre
		for($i=1; $i<=count($lignee); $i++) {
			$lignee[$i]["avec_parente"] = false;
			for($j=1; $j<=count($lignee); $j++) {
				if ($i!= $j) {
					if (($lignee[$i]["id_pere"] == $lignee[$j]["id_pere"]) || ($lignee[$i]["id_mere"] == $lignee[$j]["id_mere"])) {
						$lignee[$i]["avec_parente"] = true;
					}
				}
			}
		}
		$nbre_M_seuls = 0;
		$nbre_F_seuls = 0;
		foreach($lignee as $unchien) {
			if (!$unchien["avec_parente"]) {
				if ($unchien["sexe"]=="M") {
					$nbre_M_seuls++;
				}
				if ($unchien["sexe"]=="F") {
					$nbre_F_seuls++;
				}
			}
		}

		return array("Id"=>$Id, "lof"=>$lof, "nom_complet"=>$nom_complet, "sexe"=>$sexe , "M"=>$nbre_M_seuls, "F"=>$nbre_F_seuls);
	}
	
	function get_genealogie($chien, $niveau=0) {
		$this->indice++;
		$chien_courant = array();
		foreach ($this->champs_lignee as $unchamp) {
			$chien_courant[$unchamp] = $chien[$unchamp];
		}
		$this->genealogie[$this->indice] = $chien_courant;
		if (is_array($chien[pere])) {
			$this->get_genealogie($chien[pere], $niveau+1);
		}
		else {
			switch ($niveau) {
				case "0":
					$this->indice = $this->indice + 7;
					break;
				case "1":
					$this->indice = $this->indice + 3;
					break;
				case "2":
					$this->indice = $this->indice + 1;
					break;
			}
		}
		if (is_array($chien[mere])) {
			$this->get_genealogie($chien[mere], $niveau+1);
		}
		else {
			switch ($niveau) {
				case "0":
					$this->indice = $this->indice + 7;
					break;
				case "1":
					$this->indice = $this->indice + 3;
					break;
				case "2":
					$this->indice = $this->indice + 1;
					break;
			}
		}
		return $this->genealogie;
	}
	
	function lignees_independantes($lignee1,$lignee2) {
		if ((count(array_unique($lignee1)) + count(array_unique($lignee2))) == count(array_unique(array_merge($lignee1,$lignee2)))) {
			$ok = true;
		}
		else {
			$ok = false;
		}
		return $ok;
	}
	
	function lignees_independantes_old($lignee1,$lignee2) {
		$ok = true;
		foreach ($lignee1 as $chien1) {
			foreach ($lignee2 as $chien2) {
				if ($chien1[Id]==$chien2[Id]) {
					$ok = false;
				}
			}
		}
		return $ok;
	}
	
	function get_enfants($idpere,$idmere) {
		$sql = 'SELECT `'.$this->prefix.'_cursinu_chien`.`Id`, `'.$this->prefix.'_cursinu_chien`.`lof`,`'.$this->prefix.'_cursinu_chien`.`icad`, CONCAT(`'.$this->prefix.'_cursinu_chien`.`prefixe`, `'.$this->prefix.'_cursinu_chien`.`nom`, `'.$this->prefix.'_cursinu_chien`.`suffixe`) as nom_complet, `'.$this->prefix.'_cursinu_chien`.`affixe`, `'.$this->prefix.'_cursinu_chien`.`sexe`, `'.$this->prefix.'_cursinu_chien`.`naissance`, `'.$this->prefix.'_cursinu_chien`.`id_pere`, `'.$this->prefix.'_cursinu_chien`.`id_mere`, `'.$this->prefix.'_cursinu_chien`.`lignee_valide` ';
		$sql .= ' FROM '.$this->prefix.'_cursinu_chien';
		$sql .= ' WHERE id_pere=\''.$idpere.'\' AND id_mere=\''.$idmere.'\'';
		$sql .= ';';
	
		$enfants = array();
		$result = $this->db->sql_query($sql);
		if ($this->db->sql_numrows($result) > 0) {
			while ($ligne = $this->db->sql_fetchrow($result)) {
				$chien = array();
				foreach ($this->champs_lignee as $unchamp) {
					$chien[$unchamp] = $ligne[$unchamp];
				}
				$enfants[] = $chien;
			}
			return $enfants;
		}
		else {
			return false;
		}
	}
	
	function get_num_lof() {
	    $nbre = 0;
	    $sql = "SELECT count(Id) AS nbre FROM ".$this->prefix."_cursinu_chien WHERE lof != '';";
	    $result = $this->db->sql_query($sql);
	    if ($this->db->sql_numrows($result) > 0) {
	        if ($ligne = $this->db->sql_fetchrow($result)) {
	            $nbre = $ligne["nbre"];
	        }
	    }
	    return $nbre;
	}
	
	function get_num_champion() {
	    $nbre = 0;
	    $sql = "SELECT count(Id) AS nbre FROM ".$this->prefix."_cursinu_chien WHERE champion = '1';";
	    $result = $this->db->sql_query($sql);
	    if ($this->db->sql_numrows($result) > 0) {
	        if ($ligne = $this->db->sql_fetchrow($result)) {
	            $nbre = $ligne["nbre"];
	        }
	    }
	    return $nbre;
	}
	
	function get_individu($id_chien) {
	    if ($id_chien != 0) {
	        $sql = 'SELECT '.$this->prefix.'_cursinu_chien.`Id`,'.$this->prefix.'_cursinu_chien.`lof`,'.$this->prefix.'_cursinu_chien.`icad`,'.$this->prefix.'_cursinu_chien.`nom`,'.$this->prefix.'_cursinu_chien.`affixe`,'.$this->prefix.'_cursinu_chien.`sexe`,'.$this->prefix.'_cursinu_chien.`naissance`,'.$this->prefix.'_cursinu_chien.`id_proprio`,'.$this->prefix.'_cursinu_chien.`id_pere`,'.$this->prefix.'_cursinu_chien.`id_mere`,'.$this->prefix.'_cursinu_chien.`lignee_valide`,'.$this->prefix.'_cursinu_chien.`verrou`,'.$this->prefix.'_cursinu_chien.`champion`,'.$this->prefix.'_cursinu_chien.`description`,'.$this->prefix.'_cursinu_chien.`producteur`,'.$this->prefix.'_cursinu_chien.`photo`,'.$this->prefix.'_cursinu_chien.`prefixe`,'.$this->prefix.'_cursinu_chien.`suffixe`,'.$this->prefix.'_cursinu_chien.`tancs`,'.$this->prefix.'_cursinu_chien.`tanct`,'.$this->prefix.'_cursinu_chien.`tancc`,'.$this->prefix.'_cursinu_chien.`tancp`,'.$this->prefix.'_cursinu_chien.`hanche_droite`,'.$this->prefix.'_cursinu_chien.`hanche_gauche`,'.$this->prefix.'_cursinu_chien.`test_adn`,'.$this->prefix.'_cursinu_chien.`cotation`, CONCAT(`'.$this->prefix.'_cursinu_chien`.`prefixe`, `'.$this->prefix.'_cursinu_chien`.`nom`, `'.$this->prefix.'_cursinu_chien`.`suffixe`) as nom_complet ';
	        $sql .= ', CONCAT(`parentpere`.`prefixe`, `parentpere`.`nom`, `parentpere`.`suffixe`) as nom_pere, CONCAT(`parentmere`.`prefixe`, `parentmere`.`nom`, `parentmere`.`suffixe`) as nom_mere ';
	        $sql .= ', `user_name`, `user_firstname`, `user_firstname`,'.$this->prefix.'_cursinu_chien.id_proprio';
	        $sql .= ' FROM '.$this->prefix.'_cursinu_chien';
	        $sql .= ' LEFT JOIN `'.$this->prefix.'_cursinu_chien` as parentpere ON `'.$this->prefix.'_cursinu_chien`.id_pere=parentpere.id';
	        $sql .= ' LEFT JOIN `'.$this->prefix.'_cursinu_chien` as parentmere ON `'.$this->prefix.'_cursinu_chien`.id_mere=parentmere.id';
	        $sql .= ' LEFT JOIN `'.$this->prefix.'_users` ON '.$this->prefix.'_cursinu_chien.id_proprio='.$this->prefix.'_users.uid';
	        $sql .= ' WHERE `'.$this->prefix.'_cursinu_chien`.`Id`=\''.$id_chien.'\';';
	        $result = $this->db->sql_query($sql);
	        if ($this->db->sql_numrows($result) > 0) {
	            $ligne = $this->db->sql_fetchrow($result);
	            return $ligne;
	        }
	    }
	    else {
	        return false;
	    }
	}
}

?>