<?php
/**
* Interface d'administration du module de clients.
* 
* @package becmsSimpleClient
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight($module_name)) {
//setPath(_TXT_Modules,0);
//setPath(_SIMPLECARTO,1);
require_once("modules/$module_name/lib/g_db.php");
require_once("modules/$module_name/lib/ba_adminclient.php");

/**
* Renvoie l'interface d'administration de ce module.
* 
* La liste des clients, les formulaires d'dition et le rsultats des oprations sont affichs par cette fonction.
* Elle ne retourne aucune valeur mais effectue rellement l'affichage.
*/
function editclient(){
	global $prefix, $db, $language, $multilingual, $Default_Skin, $SkinPath, $onglet,$module_name, $aid, $sendmodif;
		
	include("modules/$module_name/lib/g_params.php");
	
	include("system/header_system.php");	

	$My_SQL["maBase"] = $db;
	$vars_mod["auteur"] = $aid;
	$form_client = "";	
	$objetClient = new adminClients();
	$script_init_client = "";
	$corpsadminclient = "";
	$message = "";
	
	switch ($vars_mod[$vars_mod["action"]]) {
		case "list" :
			$corpsadminclient = $objetClient->get_list_clients($My_SQL,$vars_mod,$crit_find_article);
			$operationOnglet = _CLIENTONGLETLIST;
			break;
		case "edit" :
			$form_client = $objetClient->edit_client($My_SQL,$vars_mod,$new_client,$crit_find_article);
			$operationOnglet = _CLIENTONGLETEDIT;
			break;
		case "new" :
			$vars_mod[$vars_mod[id_client]] = "-1";
			$form_client = $objetClient->edit_client($My_SQL,$vars_mod,$new_client,$crit_find_article);
			$operationOnglet = _CLIENTONGLETNEW;
			break;
		case "save" :
			$send_confirm = false;
			if ($new_client[$vars_mod["id_client"]] == "-1" && $new_client["codeconfirm"] !== "" && $new_client["categorie"] != "") {
				$send_confirm = true;
			}
			$vars_mod[$vars_mod["id_client"]] = $objetClient->save_client($My_SQL,$new_client);
			if ($vars_mod[$vars_mod["id_client"]] != "-1") {
				$corpsadminclient = "";
				if ($send_confirm) {
					$corpsadminclient .= $objetClient->send_confirm_client($My_SQL,$vars_mod,_CLIENTMESSAGESUBJECTNEWSUBMITCLIENT,_CLIENTMESSAGENEWSUBMITCLIENT);
				}
				if ($sendmodif == "1" && $new_client["valide"] == "1") {
					$objetClient->send_modif_client($My_SQL,$vars_mod,_CLIENTMESSAGESUBJECTNEWSUBMITCLIENT2,_CLIENTMESSAGENEWSUBMITCLIENT2);
				}
				/*$form_client = $objetClient->edit_client($My_SQL,$vars_mod,$new_client);
				$message = "<center>"._CLIENTSAVED."</center>";
				$operationOnglet = _CLIENTONGLETEDIT._CLIENTONGLETAFTERSAVE;*/
				$vars_mod[$vars_mod["id_client"]] = "-1";
				$corpsadminclient .= $objetClient->get_list_clients($My_SQL,$vars_mod,$crit_find_article);
				$operationOnglet = _CLIENTONGLETLIST._CLIENTONGLETAFTERSAVE;
			}
			else {
				$new_client["id_client"] = $vars_mod["id_client"];
				$new_client[$vars_mod["id_client"]] = "-1";
				$new_client["action"] = $vars_mod["action"];
				$form_client = $objetClient->edit_client($My_SQL,$vars_mod,$new_client,$crit_find_article);
				$message = "<div class=\"resultop\">"._CLIENTNOTSAVED."</div>";
				$operationOnglet = _CLIENTONGLETEDIT._CLIENTONGLETAFTERSAVE;
			}
			break;
		case "delete" :
			if ($vars_mod[$vars_mod["confirm"]] == "y") {
				$message = "<div class=\"resultop\">".$objetClient->delete_client($My_SQL,$vars_mod)."</div>";
				$vars_mod[$vars_mod["id_client"]] = "-1";
				$form_client = $objetClient->get_list_clients($My_SQL,$vars_mod,$crit_find_article);
				$operationOnglet = _CLIENTONGLETSUPPR;
				break;
			}
			else {
				$message = "<div class=\"resultop\">".$objetClient->confirm_delete($My_SQL,$vars_mod,_CLIENTCONFSUPPR)."</div>";
				$operationOnglet = _CLIENTONGLETSUPPR;
			}
			$script_init_client = "";
			break;
	}
	
	$scriptstyle = '
	<link href="modules/'.$module_name.'/lib/style-edit-client.css" rel="stylesheet" type="text/css" media="all" />';
	
	$corpsadminclient .= $message.$form_client;
	
	if (!isset($onglet)) {
		$onglet = "client";
	}
	if ($onglet == "") {
		$onglet = "client";
	}
	$varsenplus = $objetClient->getVars("*",$vars_mod["page_en_cours"]."|".$vars_mod["tri"]);
	if ($varsenplus != "") {
		$varsenplus = "&".$varsenplus;
	}
	$ongletDef=array("client"=> array( "text"=>"Clients",
                                   "url"=>"system.php?".$vars_mod["action"]."=list&op=client&onglet=client".$varsenplus),
                 "clientnew"=> array( "text"=>"Nouveau client",
                                   "url"=>"system.php?".$vars_mod["action"]."=new&op=client&onglet=clientnew".$varsenplus));

    GraphicAdmin(_SIMPLECLIENT);
	OpenOngletTable();
	displayOngletBar($onglet,_CLIENTONGLET.$operationOnglet,$ongletDef);
	
	OpenSysTable();
	echo $scriptstyle;
	echo $corpsadminclient;
	CloseSysTable();
	CloseOngletTable();
    include("system/footer_system.php");
}

/**
* Vrifie que le paramtre d'opration est bien "client", sinon affiche "Access denied".
*/
switch ($op) {
    case "client":
    		editclient();
    		break;
	}
}
else {
    display_denied();
}

?>