<?php
/**
* Classes d'accs  la base de donnes pour la gestion des clients.
* 
* Toutes les fonctions utilisent l'API de la plateforme pour tre indpendante de la base de donnes utilise
* @package becmsSimpleClient
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

/**
* Classe d'accs  la base de donnes clients pour isoler les fonctions.
* 
* @package becmsSimpleCarto
*/
class BD_Clients {
/**
* Efface la fiche du client dsign
* @param array $My_SQL Paramtres de la base de donnes
* @param integer $Id Identifiant du client  supprimer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/		
	function delClient($My_SQL,$Id) {
		$db=$My_SQL["maBase"];
		
		if ($Id != "") {
			$cond = "`Id` = ".$Id;
			$sql = "DELETE FROM `".$My_SQL["clients"]."` WHERE ".$cond.";";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
/**
* Enregistre une fiche client
* 
* Si le client esiste dj, il est simplement modifi, sinon il est cr.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $client Tableau contenant tous les champs du lieu  enregistrer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/	
	function saveClient($My_SQL,$client) {
		$db=$My_SQL["maBase"];
		$client = array_map(array('adminClients', 'conditionnertodb'), $client);
		if ($client["Id"] == "-1") {
			$sql = "INSERT INTO `".$My_SQL["clients"]."` (`civilite`,`nom`,`prenom`,`societe`,`adresse`,`codepostal`,`ville`,`pays`,`tel`,`fax`,`portable`,`email`,`services`,`codeclient`,`passwd`,`valide`,`divers`,`datenaissance`,`categorie`,`codeconfirm`,`pageperso`,`newsletter`)";
			$sql .= " VALUES ('".$client["civilite"]."','".$client["nom"]."','".$client["prenom"]."','".$client["societe"]."','".$client["adresse"]."','".$client["codepostal"]."','".$client["ville"]."','".$client["pays"]."','".$client["tel"]."','".$client["fax"]."','".$client["portable"]."','".$client["email"]."','".$client["services"]."','".$client["codeclient"]."','".$client["passwd"]."','".$client["valide"]."','".$client["divers"]."','".$client["datenaissance"]."','".$client["categorie"]."','".$client["codeconfirm"]."','".$client["pageperso"]."','".$client["newsletter"]."');";
		}
		else {
			$sql = "UPDATE `".$My_SQL["clients"]."` SET `civilite` = '".$client["civilite"]."',`nom` = '".$client["nom"]."',`prenom` = '".$client["prenom"]."',`societe` = '".$client["societe"]."', `adresse` = '".$client["adresse"]."', `codepostal` = '".$client["codepostal"]."', `ville` = '".$client["ville"]."', `pays` = '".$client["pays"]."', `tel` = '".$client["tel"]."', `fax` = '".$client["fax"]."', `portable` = '".$client["portable"]."', `email` = '".$client["email"]."', `services` = '".$client["services"]."', `codeclient` = '".$client["codeclient"]."', `passwd` = '".$client["passwd"]."', `valide` = '".$client["valide"]."', `divers` = '".$client["divers"]."', `datenaissance` = '".$client["datenaissance"]."', `categorie` = '".$client["categorie"]."', `codeconfirm` = '".$client["codeconfirm"]."', `pageperso` = '".$client["pageperso"]."', `newsletter` = '".$client["newsletter"]."' WHERE `Id` = '".$client["Id"]."';";
		}
		return $db->sql_query($sql);
	}
/**
* Renvoie la liste des clients correspondants  la demande
* 
* Un tableau vide est renvoy si aucun client n'est trouv. Si Id vaut "", tous les clients sont renvoys.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $clef Tableau contenant les identifiants du compte.
* @param string $tri_par Nom de la rubrique servant au tri.
* @param string $codeconfirm Code expdi par mail au client pour valider son compte.
* @param string $categorie Catgorie des clients  rechercher.
* @return array Retourne la liste des clients retrouvs
*/	
	function getClients($My_SQL,$clef,$tri_par="",$limit="",$codeconfirm="",$categorie="",$valid="") {
		$db=$My_SQL["maBase"];
		
		$clients = array();
		$cond = "";
		/*if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["clients"]."`.`Id`='".$Id."'";
		}*/
		
		if (isset($clef["Id"]) && $clef["Id"] != "-1" && $clef["Id"] != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= $My_SQL["clients"].".`Id`='".$clef["Id"]."'";
		}
		if (isset($clef["codeclient"]) && $clef["codeclient"] != "" && $clef["passwd"] != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= $My_SQL["clients"].".`codeclient`='".$clef["codeclient"]."' AND ".$My_SQL["clients"].".`passwd`='".$clef["passwd"]."'";
		}
		
		if ($codeconfirm != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["clients"]."`.`codeconfirm`='".$codeconfirm."'";
		}
		
		if ($categorie != "") {
			$categorie = str_replace("'","''",stripslashes($categorie));
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["clients"]."`.`categorie`='".$categorie."'";
		}
		if ($valid != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			if ($valid == "yes") {
				$cond .= "`".$My_SQL["clients"]."`.`valide`='1'";
			}
			if ($valid == "no") {
				$cond .= "`".$My_SQL["clients"]."`.`valide`='0'";
			}
		}
		$oderby = "";
		if ($tri_par =="") {
			$oderby = " ORDER BY `".$My_SQL["clients"]."`.`nom` ASC, `".$My_SQL["clients"]."`.`prenom` ASC";
		}
		if ($tri_par == "nom") {
			$oderby = " ORDER BY `".$My_SQL["clients"]."`.`nom` ASC, `".$My_SQL["clients"]."`.`prenom` ASC";
		}
		if ($tri_par == "societe") {
			$oderby = " ORDER BY `".$My_SQL["clients"]."`.`societe` ASC, `".$My_SQL["clients"]."`.`nom` ASC, `".$My_SQL["clients"]."`.`prenom` ASC";
		}
		if ($tri_par == "codepostal") {
			$oderby = " ORDER BY `".$My_SQL["clients"]."`.`codepostal` ASC, `".$My_SQL["clients"]."`.`nom` ASC, `".$My_SQL["clients"]."`.`prenom` ASC";
		}
		if ($tri_par == "categorie") {
			$oderby = " ORDER BY `".$My_SQL["clients"]."`.`categorie` DESC, `".$My_SQL["clients"]."`.`nom` ASC, `".$My_SQL["clients"]."`.`prenom` ASC";
		}
		if ($tri_par == "Id") {
			$oderby = " ORDER BY `".$My_SQL["clients"]."`.`Id` DESC";
		}
		if ($limit != "") {
			$limit = " LIMIT ".trim($limit);
		}
		$resultatRecherche = $db->sql_query("SELECT `".$My_SQL["clients"]."`.`Id`,`".$My_SQL["clients"]."`.`civilite`,`".$My_SQL["clients"]."`.`nom`,`".$My_SQL["clients"]."`.`prenom`,`".$My_SQL["clients"]."`.`societe`,`".$My_SQL["clients"]."`.`adresse`,`".$My_SQL["clients"]."`.`codepostal`,`".$My_SQL["clients"]."`.`ville`,`".$My_SQL["clients"]."`.`pays`,`".$My_SQL["clients"]."`.`tel`,`".$My_SQL["clients"]."`.`fax`,`".$My_SQL["clients"]."`.`portable`,`".$My_SQL["clients"]."`.`email`,`".$My_SQL["clients"]."`.`services`,`".$My_SQL["clients"]."`.`codeclient`,`".$My_SQL["passwd"]."`.`passwd`,`".$My_SQL["clients"]."`.`valide`,`".$My_SQL["clients"]."`.`divers`,`".$My_SQL["clients"]."`.`datenaissance`,`".$My_SQL["clients"]."`.`categorie`,`".$My_SQL["clients"]."`.`codeconfirm`,`".$My_SQL["clients"]."`.`pageperso`,`".$My_SQL["clients"]."`.`newsletter` FROM `".$My_SQL["clients"]."` ".$cond.$oderby.$limit.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				array_push($clients, $ligneCourante);
			}
		}
		return $clients;
	}
	
/**
* Renvoie la liste des catgories des clients correspondants  la demande
* 
* Un tableau vide est renvoy si aucune catgorie n'est trouve. Si Id vaut "", toutes les catgories sont renvoys.
* @param array $My_SQL Paramtres de la base de donnes
* @param integer $Id Identifiant du client  renvoyer
* @return array Retourne la liste des clients retrouvs
*/	
	function getCategorieClients($My_SQL,$Id="") {
		$db=$My_SQL["maBase"];
		
		$categories = array();
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["clients"]."`.`Id`='".$Id."'";
		}
		$oderby = " ORDER BY `".$My_SQL["clients"]."`.`categorie` ASC";
		$resultatRecherche = $db->sql_query("SELECT DISTINCT `".$My_SQL["clients"]."`.`categorie` FROM `".$My_SQL["clients"]."` ".$cond.$oderby.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				array_push($categories, $ligneCourante["categorie"]);
			}
		}
		return $categories;
	}

/**
* Teste l'existance d'un compte client.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $clef Tableau contenant les identifiants du compte.
* @return boolean Retourne vrai si une unique fiche a t trouve, et faux sinon.
*/
	function exists_client($My_SQL,$clef) {
		$db=$My_SQL["maBase"];
		$cond = "";
		if ($clef["Id"] != "-1" && $clef["Id"] != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`Id`='".$clef["Id"]."'";
		}
		if ($clef["codeclient"] != "" && $clef["passwd"] != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`codeclient`='".$clef["codeclient"]."' AND `passwd`='".$clef["passwd"]."'";
		}
		$resultatRecherche = $db->sql_query("SELECT count(`Id`) as `nbrefiches` FROM `".$My_SQL["clients"]."` ".$cond." GROUP BY `Id`;");
		if ($db->sql_numrows($resultatRecherche) == 1) {
			$fiche = $db->sql_fetchrow($resultatRecherche);
			return ($fiche["nbrefiches"] == "1");
		}
		return false;
	}
	
/**
* Renvoie le nombre de clients correspondants  la demande.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Identifiant de la commande  renvoyer.
* @return integer Retourne le nombre de clients trouvs.
*/	
	function getNumClients($My_SQL,$Id="",$valid="", $groupe="") {
		$db=$My_SQL["maBase"];
		
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["clients"]."`.`Id`='".$Id."'";
		}
		if ($groupe != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["categorie"]."`.`categorie`='".$groupe."'";
		}
		if ($valid != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			if ($valid == "yes") {
				$cond .= "`".$My_SQL["clients"]."`.`valide`='1'";
			}
			if ($valid == "no") {
				$cond .= "`".$My_SQL["clients"]."`.`valide`='0'";
			}
		}
		$resultatRecherche = $db->sql_query("SELECT COUNT(`".$My_SQL["clients"]."`.`Id`) as `nbrefiches` FROM `".$My_SQL["clients"]."` ".$cond.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			if ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				return $ligneCourante["nbrefiches"];
			}
		}
		return 0;
	}
	
/**
* Rcupre la valeur de l'indentifiant du dernier enregistrement cr.
* @param array $My_SQL Paramtres de la base de donnes
* @return integer Identifiant
*/
	function getLastId($My_SQL) {
		$db=$My_SQL["maBase"];
		return $db->sql_nextid();
	}
/**
* Renvoie la liste des pays.
* 
* Seuls les pays actifs sont retourns.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $tri Suffixe de la langue dans laquelle le tri doit tre effectu (_F;_E;_A;_I;_S).
* @return array Retourne la liste des pays retrouvs.
*/
	function getPays($My_SQL, $tri="") {
		$db=$My_SQL["maBase"];
		if ($tri != "") {
			$orderby = " ORDER BY `pays".$tri."` ASC";
		}
		else {
			$orderby = "";
		}
		$pays = array();
		$sql = "SELECT `code`,`pays_F`,`pays_E`,`pays_A`,`pays_I`,`pays_S` FROM `".$My_SQL["pays"]."` WHERE `active`='1'".$orderby.";";
		$search = $db->sql_query($sql);
		if ($db->sql_numrows($search) != 0) {
			while ($ligneencours = $db->sql_fetchrow($search)) {
				array_push($pays,$ligneencours);
			}
		}
		return $pays;
	}
	
/**
* Retourne le code client et le mot de passe d'un compte client.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $email E-mail du compte  retrouver.
* @return integer Retourne les identifiants du compte client s'il est trouv ou un tableau vide sinon.
*/
	function get_client_ids($My_SQL,$email) {
		$db=$My_SQL["maBase"];
		$clients = array();
		$cond = "";
		if ($email != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`email`='".$email."'";
		}
		$resultatRecherche = $db->sql_query("SELECT `nom`,`prenom`,`codeclient`,`passwd` FROM `".$My_SQL["clients"]."` ".$cond.";");
		if ($db->sql_numrows($resultatRecherche) != 0 && $email != "") {
			while ($fiche = $db->sql_fetchrow($resultatRecherche)) {
				array_push($clients,$fiche);
			}
		}
		return $clients;
	}
	
/**
* Retourne les civilit, noms et prnom d'un compte client.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Identifiant de la fiche client.
* @return array Retourne les champs nom du client correspond  l'Id.
*/
	function get_client_identity($My_SQL,$Id) {
		$db=$My_SQL["maBase"];
		$cond = "";
		if ($Id != "" && $Id != "-1") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`Id`='".$Id."'";
		}
		$resultatRecherche = $db->sql_query("SELECT `civilite`, `nom`, `prenom` FROM `".$My_SQL["clients"]."` ".$cond.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			$fiche = $db->sql_fetchrow($resultatRecherche);
			return array("civilite" => $fiche["civilite"], "prenom" => $fiche["prenom"],"nom" => $fiche["nom"]);
		}
		return "";
	}
}

/**
* Classe d'enregistrement des variables des session dans la base de donnes.
* @package becmsSimpleCatalog
*/
class BD_Sessions_client { 
/**
* @var integer Dure de vie des variables de session.
*/
	var $lifeTime;
/**
* @var mixed Objet base de donnes utilisant l'API de la plateforme.
*/
	var $dbHandle;
/**
* Initialisation des sessions.
* 
* @param string $savePath Chemin de sauvegarde des variables de session. Non utilise.
* @param string $sessName Nom de la session. Non utilise.
* @return boolean Retourne true si la base de donnes est ouverte, false sinon.
*/
	function open($savePath, $sessName) {
		// get session-lifetime 
		//$this->lifeTime = get_cfg_var("session.gc_maxlifetime");
		$this->lifeTime = 24 * 60 * 60; //dure de vie d'une journe
		// open database-connection 
		global $db;
		$dbHandle = $db;
		if(!$dbHandle) {
			return false;
		} 
		$this->dbHandle = $dbHandle;
		return true;
	}
/**
* Fermeture des sessions. Dtruit les sesssions arrives  terme
*/
	function close() {
		$this->gc(ini_get('session.gc_maxlifetime')); 
		// close database-connection 
	}
/**
* Lecture des variables de session.
* 
* @param integer $sessID Identifiant de la session.
* @return mixed Retourne la valeur trouvs ou NULL. NULL est utilis pour que isset($SESSION["xxx"]) renvoie false.
*/	
	function read($sessID) {
		// fetch session-data 
		$res = $this->dbHandle->sql_query("SELECT session_data AS d FROM becms_commerce_sessions 
							WHERE session_id = '$sessID' 
							AND session_expires > ".time()); 
		// return data or NULL at failure 
		if($row = $this->dbHandle->sql_fetchrow($res)) 
			return $row['d']; 
		return NULL; 
	}
/**
* Ecriture des variables de session.
* 
* Chaque criture repousse le dlai d'expiration.
* @param integer $sessID Identifiant des variables de session en cours.
* @param mixed $sessData Variables de session  mmoriser.
* @return boolean Retourne true les donnes sont enregistres, false sinon.
*/	
	function write($sessID,$sessData) {
		// new session-expire-time
		$newExp = time() + $this->lifeTime; 
		// is a session with this id in the database? 
		$res = $this->dbHandle->sql_query("SELECT * FROM becms_commerce_sessions
						WHERE session_id = '$sessID'"); 
		// if yes, 
		if($this->dbHandle->sql_numrows($res)) {
			// ...update session-data 
			$this->dbHandle->sql_query("UPDATE becms_commerce_sessions 
						 SET session_expires = '$newExp', 
						 session_data = '$sessData' 
						 WHERE session_id = '$sessID'"); 
			// if something happened, return true 
			if($this->dbHandle->sql_affectedrows()) 
				return true; 
		}
		// if no session-data was found, 
		else { 
			// create a new row
			$this->dbHandle->sql_query("INSERT INTO becms_commerce_sessions ( 
						 session_id, 
						 session_expires, 
						 session_data) 
						 VALUES( 
						 '$sessID', 
						 '$newExp', 
						 '$sessData')"); 
			// if row was created, return true 
			if($this->dbHandle->sql_affectedrows()) 
				return true;
		} 
		// an unknown error occured 
		return false;
	}
/**
* Dtruit une session particulire.
* 
* @param integer $sessID Identifiant des variables de session  dtruire.
* @return boolean Retourne true si la session a t dtruite, false sinon.
*/
	function destroy($sessID) { 
		// delete session-data 
		$this->dbHandle->sql_query("DELETE FROM becms_commerce_sessions WHERE session_id = '$sessID'"); 
		// if session was deleted, return true, 
		if($this->dbHandle->sql_affectedrows()) 
			return true; 
		// ...else return false 
		return false; 
	}
/**
* Dtruit les sessions trop anciennes.
* 
* @param string $sessMaxLifeTime Dure de survie d'une variable de session. Non utilise.
* @return boolean Retourne true si une ou plusieurs session ont t dtruites, false sinon.
*/
	function gc($sessMaxLifeTime) { 
		// delete old sessions 
		$this->dbHandle->sql_query("DELETE FROM becms_commerce_sessions WHERE session_expires < ".time()); 
		// return affected rows 
		return $this->dbHandle->sql_affectedrows(); 
	}
 }
?>