<?php
/**
* Interface d'administration du module de catalogue.
* 
* Ce module dispose d'une partie gestion du catalogue et d'une partie gestion des commandes, qui sont accessibles au travers de deux menus distincts.
* @package becmsSimpleCatalog
* @version 1.0
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

if (!preg_match("#system.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

if (checkModuleRight($module_name)) {
//setPath(_TXT_Modules,0);
//setPath(_SIMPLECARTO,1);
require_once("core/becms_ui_component.php");
require_once("modules/$module_name/lib/g_db.php");
require_once("modules/$module_name/lib/ba_admincatalog.php");

/**
* Renvoie l'interface d'administration de ce module.
* 
* Les listes des articles, des catgories, des soldes, leur dition et le rsultats des oprations sont affichs par cette fonction.
* Elle ne retourne aucune valeur mais effectue rellement l'affichage.
*/

function editcatalog(){
	global $prefix, $db, $language, $multilingual, $Default_Skin, $SkinPath, $onglet,$module_name, $aid, $new_tarif;
	
	require_once("modules/$module_name/lib/g_params.php");
	
	$My_SQL["maBase"] = $db;
	$vars_mod["auteur"] = $aid;
	$form_catalog = "";	
	$objetCatalog = new adminCatalog();
	$script_init_catalog = "";
	$corpsadmincatalog = "";
	$message = "";
	
	switch ($vars_mod[$vars_mod["action"]]) {
		case "list" :
			$corpsadmincatalog = $objetCatalog->get_list_articles($My_SQL,$vars_mod,$crit_admin_article);
			$operationOnglet = _ARTICLEONGLETLIST;
			break;
		case "edit" :
			$form_catalog = $objetCatalog->edit_article($My_SQL,$vars_mod,$crit_admin_article,$seps);
			$operationOnglet = _ARTICLEONGLETEDIT;
			break;
		case "new" :
			$vars_mod[$vars_mod[id_catalog]] = "-1";
			$form_catalog = $objetCatalog->new_article($My_SQL,$vars_mod,$crit_admin_article,$seps);
			$operationOnglet = _ARTICLEONGLETNEW;
			break;
		case "save_new" :
			$vars_mod[$vars_mod["id_article"]] = $objetCatalog->save_new_article($My_SQL,$vars_mod,$new_article,$seps);
			if ($vars_mod[$vars_mod["id_article"]] != "-1") {
				//$form_catalog = $objetCatalog->edit_article($My_SQL,$vars_mod,$crit_admin_article,$seps);
				$corpsadmincatalog = $objetCatalog->get_list_articles($My_SQL,$vars_mod,$crit_admin_article);
				$message = "<div class=\"resultop\">"._ARTICLESAVED."</div>";
			}
			else {
				$new_article["id_article"] = $vars_mod["id_article"];
				$new_article[$vars_mod["id_article"]] = "-1";
				$new_article["action"] = $vars_mod["action"];
				$form_catalog = $objetCatalog->edit_article($My_SQL,$new_article,$crit_admin_article,$seps);
				$message = "<div class=\"resultop\">"._ARTICLENOTSAVED."</div>";
			}
			$operationOnglet = _ARTICLEONGLETEDIT._ARTICLEONGLETAFTERSAVE;
			break;
		case "save" :
			$vars_mod[$vars_mod["id_article"]] = $objetCatalog->save_article($My_SQL,$vars_mod,$new_article,$seps);
			if ($vars_mod[$vars_mod["id_article"]] != "-1") {
				//$form_catalog = $objetCatalog->edit_article($My_SQL,$vars_mod,$crit_admin_article,$seps);
				//$message = "<div class=\"resultop\">"._ARTICLESAVED."</div>";
				$corpsadmincatalog = $objetCatalog->get_list_articles($My_SQL,$vars_mod,$crit_admin_article);
				$operationOnglet = _ARTICLEONGLETAFTERSAVE;
			}
			else {
				$new_article["action"] = $vars_mod["action"];
				$form_catalog = $objetCatalog->edit_article($My_SQL,$new_article,$crit_admin_article,$seps);
				$message = "<div class=\"resultop\">"._ARTICLENOTSAVED."</div>";
				$operationOnglet = _ARTICLEONGLETEDIT;
			}
			break;
		case "new_photo" :
			$form_catalog = $objetCatalog->exchange_photo($My_SQL,$vars_mod);
			$operationOnglet = _ARTICLEONGLETEXCHANGEPHOTO;
			break;
		case "save_new_photo" :
			if ($objetCatalog->save_new_photo($My_SQL,$vars_mod,$new_article) != "") {
				$message = "<div class=\"resultop\">"._ARTICLEPHOTOSAVED."</div>";
			}
			else {
				$message = "<div class=\"resultop\">"._ARTICLEPHOTONOTSAVED."</div>";
			}
			$form_catalog = $objetCatalog->edit_article($My_SQL,$vars_mod,$crit_admin_article,$seps);
			$operationOnglet = _ARTICLEONGLETEDIT;
			break;
		case "delete" :
			if ($vars_mod[$vars_mod["confirm"]] == "y") {
				$message = "<div class=\"resultop\">".$objetCatalog->delete_article($My_SQL,$vars_mod)."</div>";
				$form_catalog = $objetCatalog->get_list_articles($My_SQL,$vars_mod,$crit_admin_article);
				$operationOnglet = _ARTICLEONGLETSUPPR;
			}
			else {
				$message = "<div class=\"resultop\">".$objetCatalog->confirm_delete($My_SQL,$vars_mod,_ARTICLECONFSUPPR)."</div>";
				$operationOnglet = _ARTICLEONGLETSUPPR;
			}
			break;
		case "deletegroup" :
			if ($vars_mod[$vars_mod["confirm"]] == "y") {
				$message = "<div class=\"resultop\">".$objetCatalog->delete_articles($My_SQL,$vars_mod)."</div>";
				$form_catalog = $objetCatalog->get_list_articles($My_SQL,$vars_mod,$crit_admin_article);
				$operationOnglet = _ARTICLEONGLETSUPPRGROUP;
			}
			else {
				$message = "<div class=\"resultop\">".$objetCatalog->confirm_delete($My_SQL,$vars_mod,_ARTICLECONFSUPPR)."</div>";
				$operationOnglet = _ARTICLEONGLETSUPPRGROUP;
			}
			break;
		case "list_category" :
			$corpsadmincatalog = $objetCatalog->list_categories($My_SQL,$vars_mod);
			$operationOnglet = _ARTICLEONGLETLISTCATEGORIE;
			break;
		case "edit_category" :
			$corpsadmincatalog = $objetCatalog->edit_categorie($My_SQL,$vars_mod);
			$operationOnglet = _ARTICLEONGLETEDITCATEGORIE;
			break;
		case "save_category" :
			$objetCatalog->save_categorie($My_SQL,$new_categorie);
			$corpsadmincatalog = $objetCatalog->list_categories($My_SQL,$vars_mod);
			$operationOnglet = _ARTICLEONGLETLISTCATEGORIE;
			break;
		case "delete_category" :
			if ($vars_mod[$vars_mod["confirm"]] == "y") {
				$message = "<div class=\"resultop\">".$objetCatalog->delete_categorie($My_SQL,$vars_mod)."</div>";
				$corpsadmincatalog = $objetCatalog->list_categories($My_SQL,$vars_mod);
				$operationOnglet = _ARTICLEONGLETSUPPRCATEGORIE;
			}
			else {
				$message = "<div class=\"resultop\">".$objetCatalog->confirm_delete($My_SQL,$vars_mod,_ARTICLECONFSUPPRCATEGORIE)."</div>";
				$operationOnglet = _ARTICLEONGLETSUPPRCATEGORIE;
			}
			break;
		case "list_arbo" :
			$corpsadmincatalog = $objetCatalog->list_arborescence($My_SQL,$vars_mod);
			$operationOnglet = _ARTICLEONGLETLISTARBO;
			break;
		case "edit_arbo" :
			$corpsadmincatalog = $objetCatalog->edit_arborescence($My_SQL,$vars_mod);
			$operationOnglet = _ARTICLEONGLETEDITARBO;
			break;
		case "save_arbo" :
			$objetCatalog->save_arborescence($My_SQL,$new_arbo);
			$corpsadmincatalog = $objetCatalog->list_arborescence($My_SQL,$vars_mod);
			$operationOnglet = _ARTICLEONGLETLISTARBO;
			break;
		case "delete_arbo" :
			if ($vars_mod[$vars_mod["confirm"]] == "y") {
				$message = "<div class=\"resultop\">".$objetCatalog->delete_arbo($My_SQL,$vars_mod)."</div>";
				$corpsadmincatalog = $objetCatalog->list_arborescence($My_SQL,$vars_mod);
				$operationOnglet = _ARTICLEONGLETSUPPRARBO;
			}
			else {
				$message = "<div class=\"resultop\">".$objetCatalog->confirm_delete($My_SQL,$vars_mod,_ARTICLECONFSUPPRARBO)."</div>";
				$operationOnglet = _ARTICLEONGLETSUPPRARBO;
			}
			break;
		case "list_period_soldes" : 
			$corpsadmincatalog = $objetCatalog->list_soldes($My_SQL,$vars_mod);
			$operationOnglet = _ARTICLEONGLETLISTPERIODSOLDE;
			break;
		case "new_period_soldes" : 
			$corpsadmincatalog = $objetCatalog->edit_soldes($My_SQL,$vars_mod,$new_period_soldes);
			$operationOnglet = _ARTICLEONGLETNEWPERIODSOLDE;
			break;
		case "save_period_soldes" :
			$objetCatalog->save_soldes($My_SQL,$new_period_soldes);
			$corpsadmincatalog = $objetCatalog->list_soldes($My_SQL,$vars_mod);
			$operationOnglet = _ARTICLEONGLETLISTPERIODSOLDE;
			break;
		case "edit_period_soldes" : 
			$corpsadmincatalog = $objetCatalog->edit_soldes($My_SQL,$vars_mod,$new_period_soldes);
			$operationOnglet = _ARTICLEONGLETEDITPERIODSOLDE;
			break;
		case "delete_period_soldes" :
			if ($vars_mod[$vars_mod["confirm"]] == "y") {
				$message = "<div class=\"resultop\">".$objetCatalog->delete_soldes($My_SQL,$vars_mod)."</div>";
				$corpsadmincatalog = $objetCatalog->list_soldes($My_SQL,$vars_mod);
				$operationOnglet = _ARTICLEONGLETSUPPRPERIODSOLDE;
			}
			else {
				$message = "<div class=\"resultop\">".$objetCatalog->confirm_delete($My_SQL,$vars_mod,_ARTICLECONFSUPPRPERIODSOLDE)."</div>";
				$operationOnglet = _ARTICLEONGLETSUPPRPERIODSOLDE;
			}
			break;
		case "list_ports" : 
			$corpsadmincatalog = $objetCatalog->list_ports($My_SQL,$vars_mod);
			$operationOnglet = _ARTICLEONGLETLISTPORTS;
			break;
		case "edit_ports" :
			$corpsadmincatalog = $objetCatalog->edit_ports($My_SQL,$vars_mod,$new_port,$seps);
			$operationOnglet = _ARTICLEONGLETPORTSEDIT;
			break;
		case "save_port" :
			$objetCatalog->save_port($My_SQL,$vars_mod,$new_port,$seps);
			$corpsadmincatalog = $objetCatalog->list_ports($My_SQL,$vars_mod);
			$operationOnglet = _ARTICLEONGLETPORTSAVE;
			break;
		case "new_port" :
			$corpsadmincatalog = $objetCatalog->edit_ports($My_SQL,$vars_mod,$new_port,$seps);
			$operationOnglet = _ARTICLEONGLETPORTSNEW;
			break;
		case "delete_port" :
			if ($vars_mod[$vars_mod["confirm"]] == "y") {
				$message = "<div class=\"resultop\">".$objetCatalog->delete_port($My_SQL,$vars_mod)."</div>";
				$corpsadmincatalog = $objetCatalog->list_ports($My_SQL,$vars_mod);
				$operationOnglet = _ARTICLEONGLETSUPPRPORT;
			}
			else {
				$message = "<div class=\"resultop\">".$objetCatalog->confirm_delete($My_SQL,$vars_mod,_ARTICLECONFSUPPRPORT)."</div>";
				$operationOnglet = _ARTICLEONGLETSUPPRPORT;
			}
			break;
		case "edit_tarif" :
			$sortie = $objetCatalog->edit_tarif($My_SQL,$vars_mod);
			header('Content-Type: text/html; charset=ISO-8859-1');
			echo $sortie;
			die();
			break;
		case "save_tarif" :
			$sortie = $objetCatalog->save_tarif($My_SQL, $vars_mod, $new_tarif);
			header('Content-Type: text/html; charset=ISO-8859-1');
			echo $sortie;
			die();
			break;
		case "delete_tarif":
			$sortie = $objetCatalog->delete_tarif($My_SQL, $vars_mod);
			echo $sortie;
			die();
			break;
		case "tarifsXML" :
			$sortie = $objetCatalog->get_tarifs_xml($My_SQL, $vars_mod);
			header("Content-Type: text/xml; charset=UTF-8");
			echo $sortie;
			die();
			break;
	}
	
	$scriptstyle = '
	<link href="modules/'.$module_name.'/lib/style-edit-catalog.css" rel="stylesheet" type="text/css" media="all" />';
	
	$corpsadmincatalog .= $message.$form_catalog;
	
	if (!isset($onglet)) {
		$onglet = "article";
	}
	if ($onglet == "") {
		$onglet = "article";
	}

	$ongletDef=array("article"=> array( "text"=>_CATALOGONGLETARTICLE, "url"=>"system.php?".$vars_mod["action"]."=list&op=catalog&onglet=article"),
                 "articlenew"=> array( "text"=>_CATALOGONGLETARTICLENEW, "url"=>"system.php?".$vars_mod["action"]."=new&op=catalog&onglet=articlenew"),
                 "categorie"=> array( "text"=>_CATALOGONGLETKEYWORD, "url"=>"system.php?".$vars_mod["action"]."=list_category&op=catalog&onglet=categorie"),
                 "arbo"=> array( "text"=>_CATALOGONGLETARBO, "url"=>"system.php?".$vars_mod["action"]."=list_arbo&op=catalog&onglet=arbo"),
                 "soldes"=> array( "text"=>_CATALOGONGLETSOLDES, "url"=>"system.php?".$vars_mod["action"]."=list_period_soldes&op=catalog&onglet=soldes"),
                 "soldesnew"=> array( "text"=>_CATALOGONGLETSOLDESNEW, "url"=>"system.php?".$vars_mod["action"]."=new_period_soldes&op=catalog&onglet=soldesnew"),
                 "listeports"=> array( "text"=>_CATALOGONGLETDELIV, "url"=>"system.php?".$vars_mod["action"]."=list_ports&op=catalog&onglet=listeports"),
                 "newport"=> array( "text"=>_CATALOGONGLETDELIVNEW, "url"=>"system.php?".$vars_mod["action"]."=new_port&op=catalog&onglet=newport"));
	
	require_once("system/header_system.php");
	GraphicAdmin(_SIMPLECATALOG);
	OpenOngletTable();
	displayOngletBar($onglet,_CATALOGONGLET.$operationOnglet,$ongletDef);
	
	OpenSysTable();
	echo $scriptstyle;
	echo $corpsadmincatalog;
	CloseSysTable();
	CloseOngletTable();
    require_once("system/footer_system.php");    
}

/**
* Renvoie l'interface d'administration de ce module.
* 
* Les listes des commandes, leur dition et le rsultats des oprations sont affichs par cette fonction.
* Elle ne retourne aucune valeur mais effectue rellement l'affichage.
*/
function editcommand(){
	global $prefix, $db, $language, $multilingual, $Default_Skin, $SkinPath, $onglet,$module_name, $aid;

	require_once("modules/$module_name/lib/g_params.php");
	require_once("system/header_system.php");
	
	$My_SQL["maBase"] = $db;
	$vars_mod["auteur"] = $aid;
	$form_command = "";	
	$objetCommand = new adminCommand();
	$script_init_catalog = "";
	$corpsadmincommand = "";
	$message = "";
	
	switch ($vars_mod[$vars_mod["action"]]) {
		case "list" :
			$corpsadmincommand = $objetCommand->get_list_command($My_SQL,$vars_mod,$seps,$crit_admin_article);
			$operationOnglet = _COMMANDONGLETLIST;
			break;
		case "edit" :
			$corpsadmincommand = $objetCommand->edit_command($My_SQL,$vars_mod,$seps,$crit_admin_article);
			$operationOnglet = _COMMANDONGLETEDIT;
			break;
		case "save" :
			if ($objetCommand->save_commande ($My_SQL,$vars_mod,$new_command)) {
				$message = "<div class=\"resultop\">"._COMMANDSAVED."</div>";
			}
			else {
				$message = "<div class=\"resultop\">"._COMMANDNOTSAVED."</div>";
			}
			$corpsadmincommand = $objetCommand->get_list_command($My_SQL,$vars_mod,$seps,$crit_admin_article);
			$operationOnglet = _COMMANDONGLETLIST;
			break;
		case "delete" :
			if ($vars_mod[$vars_mod["confirm"]] == "y") {
				$message = "<div class=\"resultop\">".$objetCommand->delete_command($My_SQL,$vars_mod)."</div>";
				$corpsadmincommand = $objetCommand->get_list_command($My_SQL,$vars_mod,$seps,$crit_admin_article);
				$operationOnglet = _COMMANDONGLETSUPPR;
			}
			else {
				$message = "<div class=\"resultop\">".$objetCommand->confirm_delete($My_SQL,$vars_mod,_COMMANDCONFSUPPR)."</div>";
				$operationOnglet = _COMMANDONGLETSUPPR;
			}
			break;
	}
	
	$scriptstyle = '
	<link href="modules/'.$module_name.'/lib/style-edit-catalog.css" rel="stylesheet" type="text/css" media="all" />';
	
	$corpsadmincommand = $message.$corpsadmincommand;
	
	if (!isset($onglet)) {
		$onglet = "command";
	}
	if ($onglet == "") {
		$onglet = "command";
	}

	$ongletDef=array("command"=> array( "text"=>_COMMANDONGLETCOMMAND, "url"=>"system.php?".$vars_mod["action"]."=list&op=command&onglet=command"));

    GraphicAdmin(_SIMPLECOMMAND);
	OpenOngletTable();
	displayOngletBar($onglet,_COMMANDONGLET.$operationOnglet,$ongletDef);
	
	OpenSysTable();
	echo $scriptstyle;
	echo $corpsadmincommand;
	CloseSysTable();
	CloseOngletTable();
    require_once("system/footer_system.php");    
}

/**
* Renvoie l'interface d'administration de ce module.
* 
* Les listes des promos, leur dition et le rsultats des oprations sont affichs par cette fonction.
* Elle ne retourne aucune valeur mais effectue rellement l'affichage.
*/
function editpromo(){
	global $prefix, $db, $language, $multilingual, $Default_Skin, $SkinPath, $onglet,$module_name, $aid;

	require_once("modules/$module_name/lib/g_params.php");
	require_once("system/header_system.php");
	
	$My_SQL["maBase"] = $db;
	$vars_mod["auteur"] = $aid;
	$form_command = "";	
	$objetPromo = new adminPromo();
	$script_init_catalog = "";
	$corpsadminpromo = "";
	$message = "";
	
	switch ($vars_mod[$vars_mod["action"]]) {
		case "list" :
			$corpsadminpromo = $objetPromo->get_list_promo($My_SQL,$vars_mod,$crit_admin_article);
			$operationOnglet = _PROMOONGLETLIST;
			break;
		case "edit" :
			$corpsadminpromo = $objetPromo->edit_promo($My_SQL,$vars_mod,$crit_admin_article);
			$operationOnglet = _PROMOONGLETEDIT;
			break;
		case "new" :
			$corpsadminpromo = $objetPromo->edit_promo($My_SQL,$vars_mod,$crit_admin_article);
			$operationOnglet = _PROMOONGLETNEW;
			break;
		case "save" :
			if ($objetPromo->save_promo($My_SQL,$vars_mod,$new_promo)) {
				$message = "<div class=\"resultop\">"._PROMOSAVED."</div>";
			}
			else {
				$message = "<div class=\"resultop\">"._PROMONOTSAVED."</div>";
			}
			$corpsadminpromo = $objetPromo->get_list_promo($My_SQL,$vars_mod,$crit_admin_article);
			$operationOnglet = _PROMOONGLETLIST;
			break;
		case "delete" :
			if ($vars_mod[$vars_mod["confirm"]] == "y") {
				$message = "<div class=\"resultop\">".$objetPromo->delete_promo($My_SQL,$vars_mod)."</div>";
				$corpsadminpromo = $objetPromo->get_list_promo($My_SQL,$vars_mod,$crit_admin_article);
				$operationOnglet = _PROMOONGLETSUPPR;
			}
			else {
				$message = "<div class=\"resultop\">".$objetPromo->confirm_delete($My_SQL,$vars_mod,_PROMOCONFSUPPR)."</div>";
				$operationOnglet = _PROMOONGLETSUPPR;
			}
			break;
	}
	
	$scriptstyle = '
	<link href="modules/'.$module_name.'/lib/style-edit-catalog.css" rel="stylesheet" type="text/css" media="all" />';
	
	$corpsadminpromo = $message.$corpsadminpromo;
	
	if (!isset($onglet)) {
		$onglet = "promo";
	}
	if ($onglet == "") {
		$onglet = "promo";
	}

	$ongletDef=array("promo"=> array( "text"=>_PROMOONGLETPROMO, "url"=>"system.php?".$vars_mod["action"]."=list&op=promo&onglet=promo"),
					"promo_new"=> array( "text"=>_PROMOONGLETNEWPROMO, "url"=>"system.php?".$vars_mod["action"]."=new&op=promo&onglet=promo_new"));

    GraphicAdmin(_SIMPLEPROMO);
	OpenOngletTable();
	displayOngletBar($onglet,_PROMOONGLET.$operationOnglet,$ongletDef);
	
	OpenSysTable();
	echo $scriptstyle;
	echo $corpsadminpromo;
	CloseSysTable();
	CloseOngletTable();
    require_once("system/footer_system.php");    
}

/**
* Vrifie que le paramtre d'opration est bien "catalog" ou "command", sinon affiche "Access denied".
*/
	switch ($op) {
	    case "catalog":
			editcatalog();
	    	break;
		case "command":
			editcommand();
	    	break;
		case "promo":
			editpromo();
	    	break;
	}
}
else {
    display_denied();
}

?>