<?php
if (!preg_match("#mobiles.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

require_once("core/becms_mainlib_lib.php");

$module_name = basename(dirname(__FILE__));
get_lang($module_name);
require_once("modules/$module_name/utils.php");

function get_values_lang($tab, $prefixe) {
	global $currentlang;
	
	$suffixes = array("french"=>"_F", "english"=>"_E", "german"=>"_A", "italian"=>"_I", "spanish"=>"_S");
	if ($tab[$prefixe.$suffixes[$currentlang]] != "") {
		return $tab[$prefixe.$suffixes[$currentlang]];
	}
	else {
		if ($tab[$prefixe.$suffixes["french"]] != "") {
			return $tab[$prefixe.$suffixes["french"]];
		}
		else {
			if ($tab[$prefixe.$suffixes["english"]] != "") {
				return $tab[$prefixe.$suffixes["english"]];
			}
			else {
				return "";
			}
		}
	}
}
function display_articles($select) {
	global $prefix,$db,$currentlang, $pagetitle,$Default_Theme;
	
	$sql = 'SELECT `Id`,ref_article` , `photo` , `marque` , `designation_F` , `designation_E` , `designation_A` , `designation_I` , `designation_S` , `description_F` , `description_E` , `description_A` , `description_I` , `description_S` , `options_F` , `options_E` , `options_A` , `options_I` , `options_S` , `tarif_ht` , `taux_tva` , `tarif_promo` , `taux_solde` , `deb_promo` , `fin_promo` , `deb_solde` , `fin_solde` , `valide` , `list_pays`';
	$sql .= ' FROM `'.$prefix.'_commerce_catalog`';
	$sql .= ' LIMIT 0 , 30';
	
	$resultat = $db->sql_query($sql);
	if ($db->sql_numrows($resultat) != 0) {
		while ($ligneCourante = $db->sql_fetchrow($resultat)) {
			$articles[] = $ligneCourante;
		}
	}
	
	$aujourdhui = date("Y-m-d");
	$periodes = array();
	$sql = "SELECT `Id`,`deb_solde`, `fin_solde` FROM `'.$prefix.'_commerce_soldes ` ORDER BY `deb_solde` DESC";
	$search = $db->sql_query($sql);
	if ($db->sql_numrows($search) != 0) {
		while ($ligneencours = $db->sql_fetchrow($search)) {
			$periodes[] = $ligneencours;
		}
	}
	$en_periode_solde = false;
	foreach($periodes as $periode_solde) {
		if ($aujourdhui >= $periode_solde["deb_solde"] && $aujourdhui <= $periode_solde["fin_solde"]) {
			$en_periode_solde = true;
		}
	}
	
	$sortie = "";
	
	if (file_exists("themes/".$Default_Theme."/pattern_cat_list.php")) {
		//il y a un pattern de listing de catalogue
	}
	else {
		foreach ($articles as $unarticle) {
			$prix_affiche = number_format((($article["tarif_ht"])*(1+($article["taux_tva"])/100)), 2 , ","," ").'&nbsp;&euro; TTC';
			if ($aujourdhui >= $article["deb_promo"] && $aujourdhui <= $article["fin_promo"]) {
				$prix_affiche = '<span class="barre">'.number_format((($article["tarif_ht"])*(1+($article["taux_tva"])/100)), 2 , ","," ").'&euro;</span> '
				.' '
				.number_format((($article["tarif_promo"])*(1+($article["taux_tva"])/100)), 2 , ","," ").'&euro;';
			}
			if ($en_periode_solde && $article["taux_solde"] != 0) {
				//if ($aujourdhui >= $article["deb_solde"] && $aujourdhui <= $article["fin_solde"]) {
				$prix_affiche = '<span class="barre">'.number_format((($article["tarif_ht"])*(1+($article["taux_tva"])/100)), 2 , ","," ").'&euro;</span>'
				.' '
				.number_format((($article["tarif_ht"])*(1-($article["taux_solde"])/100)*(1+($article["taux_tva"])/100)), 2 , ","," ").'&euro; ';
			}		
			
			$sortie .= '<div class="article">';
			$sortie .= '<img src="'.$unarticle["photo"].'" class="full">';
			$sortie .= '<div class="designation">';
			$sortie .= get_values_lang($unarticle, "designation");
			$sortie .= '</div>';
			$sortie .= '<div class="option">';
			$sortie .= get_values_lang($unarticle, "options");
			$sortie .= '</div>';
			$sortie .= '<div class="tarif">';
			$sortie .= _CATALOGARTICLESPRIXFROM.$prix_affiche.'&euro;';
			$sortie .= '</div>';
			$sortie .= '</div>';
		}
	}
	
}

switch($op) {
	default:
	case "display":
		display_articles($select);
		break;
}

?>