<?php
/**
* Classes d'accs  la base de donnes pour manipuler le catalogue et les commandes.
* 
* Toutes les fonctions utilisent l'API de la plateforme pour tre indpendante de la base de donnes utilise
* @package becmsSimpleCatalog
* @version 1.0
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

/**
* Classe d'accs  la base de donnes catalogue pour isoler les fonctions.
* 
* Il existe six types de donnes :
* - les articles
* - les catgories (et leur arborescence)
* - les liens entre les catgories et les articles (liaison n-n)
* - les priodes de soldes
* - les client (en liaison avec le module clients)
* - les commandes, cot FrontOffice
* @package becmsSimpleCatalog
*/
class BD_Catalog {
/**
* Renvoie les commandes recherches.
* @param array $My_SQL Paramtres de la base de donnes.
* @param string $refcomm Identifiant de la commande.
* @return array Retourne la liste des commandes trouves.
*/
	function getCommandesTemp($My_SQL,$refcomm="") {
		$db=$My_SQL["maBase"];
		$cond = "";
		if ($refcomm != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`paie-refcomm`='".$refcomm."'";
		}
		$commandes = array();
		$sql = "SELECT `id_client`,`nom_client_civilite`,`nom_client_prenom`,`nom_client_nom`,`id_port`,`id_reglement`,`code_promo`,`lesremarques`,`paie-total`,`paie-refcomm`,`paie-porteur`,`caddie`,`total_caddie_ht`,`lang_client` FROM `".$My_SQL["tempcomm"]."` ".$cond." ORDER BY `date` ASC";
		$search = $db->sql_query($sql);
		if ($db->sql_numrows($search) != 0) {
			while ($ligneencours = $db->sql_fetchrow($search)) {
				array_push($commandes,array("id_client"=>$ligneencours["id_client"],"nom_client_civilite"=>$ligneencours["nom_client_civilite"],"nom_client_prenom"=>$ligneencours["nom_client_prenom"],"nom_client_nom"=>$ligneencours["nom_client_nom"],"id_port"=>$ligneencours["id_port"],"id_reglement"=>$ligneencours["id_reglement"],"code_promo"=>$ligneencours["code_promo"],"lesremarques"=>$ligneencours["lesremarques"],"paie-total"=>$ligneencours["paie-total"],"paie-refcomm"=>$ligneencours["paie-refcomm"],"paie-porteur"=>$ligneencours["paie-porteur"],"caddie"=>$ligneencours["caddie"],"total_caddie_ht"=>$ligneencours["total_caddie_ht"],"lang_client"=>$ligneencours["lang_client"]));
			}
		}
		return $commandes;
	}
	
/**
* Enregistre une commande temporaire avant paiement
* 
* supprime une commande qui aurait le mme identifiant auparavant.
* @param array $My_SQL Paramtres de la base de donnes
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/	
	function saveCommandeTemp($My_SQL) {
		global $currentlang;
		$db=$My_SQL["maBase"];
		
		//dtruit les commande temp qui ont plus de 15 jours (pour les retrouver ventuellement) !
		$limite = time() - 15*60*60*24;
		$sql= "DELETE FROM `".$My_SQL["tempcomm"]."` WHERE `date`<'".$limite."'";
		$db->sql_query($sql);
		
		$sql= "DELETE FROM `".$My_SQL["tempcomm"]."` WHERE `paie-refcomm`='".$_SESSION["paie-refcomm"]."'";
		$db->sql_query($sql);

		$comm = array();
		$comm["id_client"] = $_SESSION["id_s_client"];
		$comm["nom_client_civilite"] = $_SESSION["nom_client"]["civilite"];
		$comm["nom_client_prenom"] = $_SESSION["nom_client"]["prenom"];
		$comm["nom_client_nom"] = $_SESSION["nom_client"]["nom"];
		$comm["id_port"] = $_SESSION["id_port"];
		$comm["id_reglement"] = $_SESSION["id_reglement"];
		$comm["code_promo"] = $_SESSION["code_s_promo"];
		$comm["lesremarques"] = $_SESSION["lesremarques"];
		$comm["paie-total"] = $_SESSION["paie-total"];
		$comm["paie-refcomm"] = $_SESSION["paie-refcomm"];
		$comm["paie-porteur"] = $_SESSION["paie-porteur"];
		$comm["caddie"] = $_SESSION["caddie"];
		$comm["total_caddie_ht"] = $_SESSION["total_caddie_ht"];
		$comm = array_map(array('adminCatalog', 'conditionnertodb'), $comm);
		
		$sql = "INSERT INTO `".$My_SQL["tempcomm"]."` (`date`,`id_client`,`nom_client_civilite`,`nom_client_prenom`,`nom_client_nom`,`id_port`,`id_reglement`,`code_promo`,`lesremarques`,`paie-total`,`paie-refcomm`,`paie-porteur`,`caddie`,`total_caddie_ht`,`lang_client`)";
		$sql .= " VALUES ('".time()."','".$comm["id_client"]."','".$comm["nom_client_civilite"]."','".$comm["nom_client_prenom"]."','".$comm["nom_client_nom"]."','".$comm["id_port"]."','".$comm["id_reglement"]."','".$comm["code_promo"]."','".$comm["lesremarques"]."','".$comm["paie-total"]."','".$comm["paie-refcomm"]."','".$comm["paie-porteur"]."','".$comm["caddie"]."','".$comm["total_caddie_ht"]."','".$currentlang."');";

		return $db->sql_query($sql);
	}
	
/**
* Efface la commande temporaire dsigne.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Identifiant de la facture temporaire  supprimer.
* @return boolean Retourne true si l'opration s'est bien passe, false sinon.
*/		
	function delCommandeTemp($My_SQL,$Id) {
		$db=$My_SQL["maBase"];
		
		if ($Id != "") {
			$sql= "DELETE FROM `".$My_SQL["tempcomm"]."` WHERE `paie-refcomm`='".$Id."'";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
	
/**
* Efface l'article dsign.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Identifiant de l'article  supprimer.
* @return boolean Retourne true si l'opration s'est bien passe, false sinon.
*/		
	function delArticle($My_SQL,$Id) {
		$db=$My_SQL["maBase"];
		
		if ($Id != "") {
			$cond = "`Id` = ".$Id;
			$sql = "DELETE FROM `".$My_SQL["articles"]."` WHERE ".$cond.";";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
	
/**
* Enregistre un article
* 
* Si le l'article esiste dj, il est simplement modifi, sinon il est cr.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $article Tableau contenant tous les champs de l'article  enregistrer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/	
	function saveArticle($My_SQL,$article) {
		$db=$My_SQL["maBase"];
		$article = array_map(array('adminCatalog', 'conditionnertodb'), $article);
		if ($article["Id"] == "-1") {
			$sql = "INSERT INTO `".$My_SQL["articles"]."` (`ref_article`,`photo`,`marque`,`designation_F`,`designation_E`,`designation_A`,`designation_I`,`designation_S`,`description_F`,`description_E`,`description_A`,`description_I`,`description_S`,`conditionnement_F`,`conditionnement_E`,`conditionnement_A`,`conditionnement_I`,`conditionnement_S`,`options_F`,`options_E`,`options_A`,`options_I`,`options_S`,`tarif_ht`,`taux_tva`,`tarif_promo`,`taux_solde`,`deb_promo`,`fin_promo`,`deb_solde`,`fin_solde`,`valide`,`list_pays`)";
			$sql .= " VALUES ('".$article["ref_article"]."','".$article["photo"]."','".$article["marque"]."','".$article["designation_F"]."','".$article["designation_E"]."','".$article["designation_A"]."','".$article["designation_I"]."','".$article["designation_S"]."','".$article["description_F"]."','".$article["description_E"]."','".$article["description_A"]."','".$article["description_I"]."','".$article["description_S"]."','".$article["conditionnement_F"]."','".$article["conditionnement_E"]."','".$article["conditionnement_A"]."','".$article["conditionnement_I"]."','".$article["conditionnement_S"]."','".$article["options_F"]."','".$article["options_E"]."','".$article["options_A"]."','".$article["options_I"]."','".$article["options_S"]."','".$article["tarif_ht"]."','".$article["taux_tva"]."','".$article["tarif_promo"]."','".$article["taux_solde"]."','".$article["deb_promo"]."','".$article["fin_promo"]."','".$article["deb_solde"]."','".$article["fin_solde"]."','".$article["valide"]."','".$article["list_pays"]."');";
		}
		else {
			$sql = "UPDATE `".$My_SQL["articles"]."` SET `ref_article`='".$article["ref_article"]."',`photo`='".$article["photo"]."',`marque`='".$article["marque"]."',`designation_F`='".$article["designation_F"]."', `designation_E`='".$article["designation_E"]."', `designation_A`='".$article["designation_A"]."', `designation_I` = '".$article["designation_I"]."', `designation_S` = '".$article["designation_S"]."', `description_F` = '".$article["description_F"]."', `description_E` = '".$article["description_E"]."', `description_A` = '".$article["description_A"]."', `description_I` = '".$article["description_I"]."', `description_S` = '".$article["description_S"]."',`conditionnement_F`='".$article["conditionnement_F"]."',`conditionnement_E`='".$article["conditionnement_E"]."',`conditionnement_A`='".$article["conditionnement_A"]."',`conditionnement_I`='".$article["conditionnement_I"]."',`conditionnement_S`='".$article["conditionnement_S"]."', `options_F` = '".$article["options_F"]."', `options_E` = '".$article["options_E"]."', `options_A` = '".$article["options_A"]."', `options_I` = '".$article["options_I"]."', `options_S` = '".$article["options_S"]."', `tarif_ht` = '".$article["tarif_ht"]."', `taux_tva` = '".$article["taux_tva"]."', `tarif_promo` = '".$article["tarif_promo"]."', `taux_solde` = '".$article["taux_solde"]."', `deb_promo` = '".$article["deb_promo"]."', `fin_promo` = '".$article["fin_promo"]."', `deb_solde` = '".$article["deb_solde"]."', `fin_solde` = '".$article["fin_solde"]."', `valide` = '".$article["valide"]."', `list_pays` = '".$article["list_pays"]."' WHERE `Id` = '".$article["Id"]."';";
		}
		$ok = $db->sql_query($sql);
		if ($ok && $article["Id"] == "-1") {
			$idarticle = $this->getLastId($My_SQL);
			$sql = "UPDATE `".$My_SQL["tarifs"]."` SET `id_produit`='".$idarticle."' WHERE `id_produit`='-1'";
			$ok &= $db->sql_query($sql);
		}
		return $ok;
	}
	
/**
* Renvoie la liste des articles correspondants  la demande.
* 
* Un tableau vide est renvoy si aucun article n'est trouv. Si Id vaut "", tous les articles sont renvoys.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Identifiant de l'article  renvoyer.
* @param string $tri_par Nom de la rubrique servant au tri.
* @param string $limit Bornes de recherche des articles ( partir de,nbre).
* @return array Retourne la liste des articles retrouvs.
*/	
	function getArticles($My_SQL,$Id,$tri_par="",$limit="") {
		$db=$My_SQL["maBase"];
		
		$articles = array();
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["articles"]."`.`Id`='".$Id."'";
		}
		$oderby = "";
		if ($tri_par =="") {
			$oderby = " ORDER BY `".$My_SQL["articles"]."`.`designation_F` ASC";
		}
		if ($tri_par == "designation_F") {
			$oderby = " ORDER BY `".$My_SQL["articles"]."`.`designation_F` ASC";
		}
		if ($tri_par == "marque") {
			$oderby = " ORDER BY `".$My_SQL["articles"]."`.`marque` ASC";
		}
		if ($tri_par == "ref_article") {
			$oderby = " ORDER BY `".$My_SQL["articles"]."`.`ref_article` ASC";
		}
		if ($tri_par == "valide") {
			$oderby = " ORDER BY `".$My_SQL["articles"]."`.`valide` ASC";
		}
		if ($limit != "") {
			$limit = " LIMIT ".trim($limit);
		}
		$resultatRecherche = $db->sql_query("SELECT `".$My_SQL["articles"]."`.`Id`,`".$My_SQL["articles"]."`.`ref_article`,`".$My_SQL["articles"]."`.`photo`,`".$My_SQL["articles"]."`.`marque`,`".$My_SQL["articles"]."`.`designation_F`,`".$My_SQL["articles"]."`.`designation_E`,`".$My_SQL["articles"]."`.`designation_A`,`".$My_SQL["articles"]."`.`designation_I`,`".$My_SQL["articles"]."`.`designation_S`,`".$My_SQL["articles"]."`.`description_F`,`".$My_SQL["articles"]."`.`description_E`,`".$My_SQL["articles"]."`.`description_A`,`".$My_SQL["articles"]."`.`description_I`,`".$My_SQL["articles"]."`.`description_S`,`".$My_SQL["articles"]."`.`conditionnement_F`,`".$My_SQL["articles"]."`.`conditionnement_E`,`".$My_SQL["articles"]."`.`conditionnement_A`,`".$My_SQL["articles"]."`.`conditionnement_I`,`".$My_SQL["articles"]."`.`conditionnement_S`,`".$My_SQL["articles"]."`.`options_F`,`".$My_SQL["articles"]."`.`options_E`,`".$My_SQL["articles"]."`.`options_A`,`".$My_SQL["articles"]."`.`options_I`,`".$My_SQL["articles"]."`.`options_S`,`".$My_SQL["articles"]."`.`tarif_ht`,`".$My_SQL["articles"]."`.`taux_tva`,`".$My_SQL["articles"]."`.`tarif_promo`,`".$My_SQL["articles"]."`.`taux_solde`,`".$My_SQL["articles"]."`.`deb_promo`,`".$My_SQL["articles"]."`.`fin_promo`,`".$My_SQL["articles"]."`.`deb_solde`,`".$My_SQL["articles"]."`.`fin_solde`,`".$My_SQL["articles"]."`.`valide`,`".$My_SQL["articles"]."`.`list_pays` FROM `".$My_SQL["articles"]."` ".$cond.$oderby.$limit.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				array_push($articles, $ligneCourante);
			}
		}
		return $articles;
	}
	
/**
* Renvoie la liste des marque attribues aux articles.
* 
* Un tableau vide est renvoy si aucune marque n'est trouve.
* @param array $My_SQL Paramtres de la base de donnes.
* @return array Retourne la liste des marques trouvs.
*/	
	function getMarques($My_SQL) {
		$db=$My_SQL["maBase"];
		
		$marques = array();
		$oderby = " ORDER BY `marque` ASC";
		$resultatRecherche = $db->sql_query("SELECT DISTINCT `marque` FROM `".$My_SQL["articles"]."` WHERE `marque`<>'' ".$oderby.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				array_push($marques, $ligneCourante["marque"]);
			}
		}
		return $marques;
	}
	
/**
* Renvoie le nombre d'articles correspondants  la demande.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Identifiant de l'article  renvoyer.
* @return integer Retourne le nombre d'articles trouvs.
*/	
	function getNumArticles($My_SQL,$Id="",$status="") {
		$db=$My_SQL["maBase"];
		
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["articles"]."`.`Id`='".$Id."'";
		}
		if ($status != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			//si valide
			if ($status == "1") {
				$cond .= "`".$My_SQL["articles"]."`.`valide`='1'";
			}
			//si non valide
			if ($status == "0") {
				$cond .= "`".$My_SQL["articles"]."`.`valide`='0'";
			}
		}
		$resultatRecherche = $db->sql_query("SELECT COUNT(`".$My_SQL["articles"]."`.`Id`) as `nbrefiches` FROM `".$My_SQL["articles"]."` ".$cond.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			if ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				return $ligneCourante["nbrefiches"];
			}
		}
		return 0;
	}
	
/**
* Renvoie la liste des articles correspondants  la demande tris par pertinence. ************* Ajouter le conditionnement et les nouveaux tarifs !!!!!*****************
* 
* Un tableau vide est renvoy si aucun article n'est trouv. Si le tableau est vide, tous les lieux sont renvoys.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $criteres Tableau contenant les critres de recherche.
* @return array Retourne la liste des articles retrouvs.
*/		
	function searchArticles($My_SQL,$criteres) {
		$db=$My_SQL["maBase"];
		$ref = $criteres["ref"];
		$kwz = $criteres["kwz"];
		if ($criteres["categorie"] != "" && $criteres["kwz"] != "") {
			$kwz .= " ";
		}
		$kwz .= $criteres["categorie"];
		$marque = $criteres["marque"];
		$page_en_cours = $criteres["page_en_cours"];
		$articles_par_page = $criteres["articles_par_page"];
		
		$articles = array();
		
		if ($ref != "") {
			$kwz = "";
			$ref = str_replace(",", " ", $ref);
			$ref = str_replace("+", " ", $ref);
			//$ref = str_replace("-", " ", $ref);
			$ref = str_replace("*", " ", $ref);
			do {
				$oldref = $ref;
				$ref = str_replace("  ", " ", $ref);
			} while ($ref != $oldref);
			$refs = explode(" ",$ref);
			$clauseWhere = "";
			foreach ($refs as $uneref) {
				$uneref = trim($uneref);
				if ($clauseWhere != "") {
					$clauseWhere .= " OR ";
				}
				$clauseWhere .= "`ref_article` = '$uneref'";
			}
			$clauseWhere = '('.$clauseWhere.') AND (`valide`=\'1\')';
			$sql = "SELECT `Id`, `ref_article`, `photo`,`marque`,`designation_F`, `designation_E`, `designation_A`, `designation_I`, `designation_S`, `description_F`, `description_E`, `description_A`, `description_I`, `description_S`, `options_F`, `options_E`, `options_A`, `options_I`, `options_S`, `tarif_ht`, `taux_tva`, `tarif_promo`, `taux_solde`, `deb_promo`, `fin_promo`, `deb_solde`, `fin_solde`, '1.0' as `score` FROM `".$My_SQL["articles"]."` WHERE $clauseWhere;";
			$search = $db->sql_query("SELECT COUNT(`Id`) AS nbreFiches FROM `".$My_SQL["articles"]."` WHERE $clauseWhere");
			if ($db->sql_numrows($search) != 0) {
				if ($ligneencours = $db->sql_fetchrow($search))	{
					$nbreFiches = $ligneencours["nbreFiches"];
				}
			}
			else {
				$error = $db->sql_error($maBase);
				die("Une erreur s'est produite : ".$error["message"]);
			}
		}
		else {
			if ($kwz != "") {
				//prpare la chaine des mots clefs  tre explose
				$kwz = str_replace(",", " ", $kwz);
				$kwz = str_replace("+", " ", $kwz);
				//$kwz = str_replace("-", " ", $kwz);
				$kwz = str_replace("*", " ", $kwz);
				do {
					$oldkwz = $kwz;
					$kwz = str_replace("  ", " ", $kwz);
				} while ($kwz != $oldkwz);
				//explosion
				$keywords = explode(" ",$kwz);
				
				$clauseWhere1 = "";
				foreach ($keywords as $unkwz) {
					$unkwz = trim($unkwz);
					if ($clauseWhere1 != "") {
						$clauseWhere1 .= " OR ";
					}
					$clauseWhere1 .= "`designation_F` LIKE '%$unkwz%' OR `designation_E` LIKE '%$unkwz%' OR `designation_A` LIKE '%$unkwz%' OR `designation_I` LIKE '%$unkwz%'OR `designation_S` LIKE '%$unkwz%'";
				}
				$sql1 = "SELECT `".$My_SQL["articles"]."`.`Id`, `ref_article`, `photo`,`marque`,`designation_F`, `designation_E`, `designation_A`, `designation_I`, `designation_S`, `description_F`, `description_E`, `description_A`, `description_I`, `description_S`, `options_F`, `options_E`, `options_A`, `options_I`, `options_S`, `tarif_ht`, `taux_tva`, `tarif_promo`, `taux_solde`, `deb_promo`, `fin_promo`, `deb_solde`, `fin_solde`, `valide`, '0.40' as `score` FROM `".$My_SQL["articles"]."` WHERE ".$clauseWhere1;
				
				$clauseWhere2 = "";
				foreach ($keywords as $unkwz) {
					$unkwz = trim($unkwz);
					if ($clauseWhere2 != "") {
						$clauseWhere2 .= " OR ";
					}
					$clauseWhere2 .= "`".$My_SQL["categories"]."`.`categorie` LIKE '%$unkwz%'";
				}
				$sql2 = "SELECT `".$My_SQL["articles"]."`.`Id`, `ref_article`, `photo`,`marque`,`designation_F`, `designation_E`, `designation_A`, `designation_I`, `designation_S`, `description_F`, `description_E`, `description_A`, `description_I`, `description_S`, `options_F`, `options_E`, `options_A`, `options_I`, `options_S`, `tarif_ht`, `taux_tva`, `tarif_promo`, `taux_solde`, `deb_promo`, `fin_promo`, `deb_solde`, `fin_solde`, `valide`, '0.35' as `score` FROM (`".$My_SQL["liens-cat"]."` INNER JOIN `".$My_SQL["articles"]."` ON `".$My_SQL["liens-cat"]."`.`id_article`=`".$My_SQL["articles"]."`.Id) INNER JOIN `".$My_SQL["categories"]."` ON `".$My_SQL["liens-cat"]."`.`id_categorie`=`".$My_SQL["categories"]."`.Id WHERE ($clauseWhere2)";
				
				$clauseWhere3 = "";
				foreach ($keywords as $unkwz) {
					$unkwz = trim($unkwz);
					if ($clauseWhere3 != "") {
						$clauseWhere3 .= " OR ";
					}
					$clauseWhere3 .= "`description_F` LIKE '%$unkwz%' OR `description_E` LIKE '%$unkwz%' OR `description_A` LIKE '%$unkwz%' OR `description_I` LIKE '%$unkwz%'OR `description_S` LIKE '%$unkwz%'";
				}
				$sql3 = "SELECT `".$My_SQL["articles"]."`.`Id`, `ref_article`, `photo`,`marque`,`designation_F`, `designation_E`, `designation_A`, `designation_I`, `designation_S`, `description_F`, `description_E`, `description_A`, `description_I`, `description_S`, `options_F`, `options_E`, `options_A`, `options_I`, `options_S`, `tarif_ht`, `taux_tva`, `tarif_promo`, `taux_solde`, `deb_promo`, `fin_promo`, `deb_solde`, `fin_solde`, `valide`, '0.25' as `score` FROM `".$My_SQL["articles"]."` WHERE $clauseWhere3";
				
				//creation d'une table temporaire reunissant toutes les recherches et ajoutant les auteurs
				$sql = "CREATE TEMPORARY TABLE `search_cat_temp` ($sql1) UNION ALL ($sql2) UNION ALL ($sql3)";
				$db->sql_query($sql);
				$clauseWhere = "HAVING `valide`='1'";
				$sql = "CREATE TEMPORARY TABLE `find_cat_temp` SELECT `Id`, `ref_article`, `photo`,`marque`,`designation_F`, `designation_E`, `designation_A`, `designation_I`, `designation_S`, `description_F`, `description_E`, `description_A`, `description_I`, `description_S`, `options_F`, `options_E`, `options_A`, `options_I`, `options_S`, `tarif_ht`, `taux_tva`, `tarif_promo`, `taux_solde`, `deb_promo`, `fin_promo`, `deb_solde`, `fin_solde`, `valide`, SUM(`score`) AS `score` FROM `search_cat_temp` GROUP BY `Id` $clauseWhere ORDER BY score DESC, `designation_F` ASC";
				$db->sql_query($sql);
				
				$db->sql_query("DROP TEMPORARY TABLE `search_cat_temp`");
				
				//prise en compte de la marque
				$condplus = "";
				/*if ($marque != "") {
					$marque = str_replace(",", " ", $marque);
					$marque = str_replace("+", " ", $marque);
					//$marque = str_replace("-", " ", $marque);
					$marque = str_replace("*", " ", $marque);
					do {
						$oldmarque = $marque;
						$marque = str_replace("  ", " ", $marque);
					} while ($marque != $oldmarque);
					$marque = explode(" ",$marque);
					$condplus = "";
					foreach ($marque as $unemarque) {
						$unemarque = trim($unemarque);
						if ($condplus == "") {
							$condplus .= " WHERE ";
						}
						else {
							$condplus .= " OR ";
						}
						$condplus .= "`marque` = '$unemarque'";
					}
				}*/
				if ($marque != "") {
					$condplus = " WHERE ";
					$condplus .= "`marque` = '$marque'";
				}
				
				//recherche du nombre de photos trouves au total
				$search = $db->sql_query("SELECT COUNT(`Id`) AS nbreFiches FROM `find_cat_temp` $condplus");
				if ($db->sql_numrows($search) != 0) {
					if ($ligneencours = $db->sql_fetchrow($search))	{
						$nbreFiches = $ligneencours["nbreFiches"];
					}
				}
				else {
					$error = $db->sql_error($maBase);
					die("Une erreur s'est produite : ".$error["message"]);
				}
			
				//photos  afficher dans cette page
				$limites = "LIMIT ".($page_en_cours-1)*$articles_par_page.",".$articles_par_page;
				$sql = "SELECT `Id`, `ref_article`, `photo`,`marque`,`designation_F`, `designation_E`, `designation_A`, `designation_I`, `designation_S`, `description_F`, `description_E`, `description_A`, `description_I`, `description_S`, `options_F`, `options_E`, `options_A`, `options_I`, `options_S`, `tarif_ht`, `taux_tva`, `tarif_promo`, `taux_solde`, `deb_promo`, `fin_promo`, `deb_solde`, `fin_solde`, `score` FROM `find_cat_temp` $condplus ORDER BY score DESC $limites";
			}
			else {
				if ($marque != "") {
					/*$marque = str_replace(",", " ", $marque);
					$marque = str_replace("+", " ", $marque);
					//$marque = str_replace("-", " ", $marque);
					$marque = str_replace("*", " ", $marque);
					do {
						$oldmarque = $marque;
						$marque = str_replace("  ", " ", $marque);
					} while ($marque != $oldmarque);
					$marque = explode(" ",$marque);
					$clauseWhere = "";
					foreach ($marque as $unemarque) {
						$unemarque = trim($unemarque);
						if ($clauseWhere != "") {
							$clauseWhere .= " OR ";
						}
						$clauseWhere .= "`marque` = '$unemarque'";
					}*/
					if ($marque != "") {
						$clauseWhere = "`marque` = '$marque'";
					}
					$clauseWhere = '('.$clauseWhere.') AND (`valide`=\'1\')';
					$limites = "LIMIT ".($page_en_cours-1)*$articles_par_page.",".$articles_par_page;
					$sql = "SELECT `Id`, `ref_article`, `photo`,`marque`,`designation_F`, `designation_E`, `designation_A`, `designation_I`, `designation_S`, `description_F`, `description_E`, `description_A`, `description_I`, `description_S`, `options_F`, `options_E`, `options_A`, `options_I`, `options_S`, `tarif_ht`, `taux_tva`, `tarif_promo`, `taux_solde`, `deb_promo`, `fin_promo`, `deb_solde`, `fin_solde`, '1.0' as `score` FROM `".$My_SQL["articles"]."` WHERE $clauseWhere $limites;";
					$search = $db->sql_query("SELECT COUNT(`Id`) AS nbreFiches FROM `".$My_SQL["articles"]."` WHERE $clauseWhere");
					if ($db->sql_numrows($search) != 0) {
						if ($ligneencours = $db->sql_fetchrow($search))	{
							$nbreFiches = $ligneencours["nbreFiches"];
						}
					}
					else {
						$error = $db->sql_error($maBase);
						die("Une erreur s'est produite : ".$error["message"]);
					}
				}
				else {
					//$ref, $kwz et marque vides
					$clauseWhere = "WHERE `valide`='1'";
					$search = $db->sql_query("SELECT COUNT(`Id`) AS nbreFiches FROM `".$My_SQL["articles"]."` $clauseWhere;");
					if ($db->sql_numrows($search) != 0) {
						if ($ligneencours = $db->sql_fetchrow($search))
						{
							$nbreFiches = $ligneencours["nbreFiches"];
						}
					}
					else {
						die("Une erreur s'est produite : MySQL n'a pas trouv de photos dans la base !");
					}
					$limites = "LIMIT ".($page_en_cours-1)*$articles_par_page.",".$articles_par_page;
					$sql = "SELECT `".$My_SQL["articles"]."`.*, '1.0' as `score` FROM `".$My_SQL["articles"]."` $clauseWhere ORDER BY `designation_F` ASC $limites";
				}
			}
		}
		
		$search = $db->sql_query($sql);
		if ($db->sql_numrows($search) != 0) {
			while ($ligneencours = $db->sql_fetchrow($search)) {
				array_push($articles, array("Id"=>$ligneencours["Id"],"ref_article"=>$ligneencours["ref_article"], "photo"=>$ligneencours["photo"],"marque"=>$ligneencours["marque"],"designation_F"=>$ligneencours["designation_F"], "designation_E"=>$ligneencours["designation_E"],
				 "designation_A"=>$ligneencours["designation_A"], "designation_I"=>$ligneencours["designation_I"], "designation_S"=>$ligneencours["designation_S"],
				 "description_F"=>$ligneencours["description_F"], "description_E"=>$ligneencours["description_E"], "description_A"=>$ligneencours["description_A"],
				 "description_I"=>$ligneencours["description_I"], "description_S"=>$ligneencours["description_S"], "options_F"=>$ligneencours["options_F"],
				 "options_E"=>$ligneencours["options_E"], "options_A"=>$ligneencours["options_A"], "options_I"=>$ligneencours["options_I"], "options_S"=>$ligneencours["options_S"],
				 "tarif_ht"=>$ligneencours["tarif_ht"], "taux_tva"=>$ligneencours["taux_tva"], "tarif_promo"=>$ligneencours["tarif_promo"],
				 "taux_solde"=>$ligneencours["taux_solde"], "deb_promo"=>$ligneencours["deb_promo"], "fin_promo"=>$ligneencours["fin_promo"], "deb_solde"=>$ligneencours["deb_solde"],
				 "fin_solde"=>$ligneencours["fin_solde"], "score"=>$ligneencours["score"], "nbreFiches"=>$nbreFiches));
			}
		}
		
		if ($kwz != "") {
			$db->sql_query("DROP TEMPORARY TABLE `find_cat_temp`");
		}	
	
		return $articles;
	}
	
/**
* Rcupre la valeur de l'indentifiant du dernier enregistrement cr.
* @param array $My_SQL Paramtres de la base de donnes.
* @return integer Identifiant.
*/
	function getLastId($My_SQL) {
		$db=$My_SQL["maBase"];
		return $db->sql_nextid();
	}
	
/**
* Renvoie les catgories recherches.
* 
* Si $id_article n'est pas fix, toutes les catgories sont renvoyes. Si $id_article est fix, toutes les catgories attaches  un article sont renvoyes.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $id_article Tableau contenant les critres de recherche.
* @return array Retourne la liste des catgories retrouvs.
*/
	function getCategories($My_SQL, $id_article="-1") {
		$db=$My_SQL["maBase"];
		
		$mcs = array();
		if ($id_article == "-1") {
			$sql = "SELECT `categorie` FROM `".$My_SQL["categories"]."` ORDER BY `categorie` ASC";
		}
		else {
			$sql = "SELECT `".$My_SQL["categories"]."`.categorie FROM (`".$My_SQL["articles"]."` INNER JOIN `".$My_SQL["liens-cat"]."` ON `".$My_SQL["articles"]."`.Id = `".$My_SQL["liens-cat"]."`.id_article) INNER JOIN `".$My_SQL["categories"]."` ON `".$My_SQL["liens-cat"]."`.id_categorie = `".$My_SQL["categories"]."`.Id WHERE (((`".$My_SQL["articles"]."`.Id)='".$id_article."')) ORDER BY `".$My_SQL["categories"]."`.`categorie` ASC";
		}
		$search = $db->sql_query($sql);
		if ($db->sql_numrows($search) != 0) {
			while ($ligneencours = $db->sql_fetchrow($search)) {
				array_push($mcs,$ligneencours["categorie"]);
			}
		}
		return $mcs;
	}
	
/**
* Renvoie l'identifiant d'une catgorie donne.
* 
* Si la catgorie n'existe pas , "-1" est renvoy.
* @param array $My_SQL Paramtres de la base de donnes.
* @param string $categorie Catgorie recherche.
* @return integer Retourne l'identifiant de la fiche.
*/
	function getCategorieId($My_SQL, $categorie) {
		$db=$My_SQL["maBase"];
		
		$sql = "SELECT Id FROM `".$My_SQL["categories"]."` WHERE `categorie`='".$categorie."';";
		$search = $db->sql_query($sql);
		if ($db->sql_numrows($search) != 0) {
			if ($ligneencours = $db->sql_fetchrow($search)) {
				$Id = $ligneencours["Id"];
			}
		}
		else {
			$Id = "-1";
		}
		return $Id;
	}
	
/**
* Renvoie la catgorie recherche.
* 
* Si $Id="", toutes les catgories enregistres sont renvoyes.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Idengtifiant de la catgorie recherche.
* @return array Retourne le tableau des catgories trouves.
*/
	function getAllCategories($My_SQL,$Id="") {
		$db=$My_SQL["maBase"];
		$cond = "";
		if ($Id != "") {
			$cond .= "WHERE `Id`='".$Id."'";
		}
		$mcs = array();
		$sql = "SELECT `Id`,`categorie` FROM `".$My_SQL["categories"]."` ".$cond." ORDER BY `categorie` ASC";
		$search = $db->sql_query($sql);
		if ($db->sql_numrows($search) != 0) {
			while ($ligneencours = $db->sql_fetchrow($search)) {
				array_push($mcs,array("Id"=>$ligneencours["Id"],"categorie"=>$ligneencours["categorie"]));
			}
		}
		return $mcs;
	}

/**
* Enregistre une catgorie.
* 
* Si $Id="", une nouvelle catgorie est cre, sinon la fiche correspondant est modifie.
* @param array $My_SQL Paramtres de la base de donnes.
* @param string $categorie Catgorie  enregistre.
* @param string $Id Identifiant de la fiche.
* @return boolean Retourne true si l'opration s'est bien passe, false sinon.
*/
	function saveCategorie($My_SQL,$categorie,$Id="") {
		$db=$My_SQL["maBase"];
		$categorie = adminCatalog::conditionnertodb($categorie);
		if ($Id == "") {
			$sql = "INSERT INTO `".$My_SQL["categories"]."` (`categorie`)";
			$sql .= " VALUES ('".$categorie."');";
		}
		else {
			$sql = "UPDATE `".$My_SQL["categories"]."` SET `categorie`='".$categorie."' WHERE `Id` = '".$Id."';";
			
		}
		return $db->sql_query($sql);
	}
	
/**
* Supprime une catgorie.
* 
* Tous les liens entre la catgorie et les article sont galement supprims.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $id_categorie Identifiant de la catgorie  supprimer.
* @return boolean Retourne true si les liens et la catgorie ont t effacs, false sinon.
*/
	function delCategorie($My_SQL,$id_categorie) {
		$db=$My_SQL["maBase"];
		if ($id_categorie != "") {
			$sql1 = "DELETE FROM `".$My_SQL["liens-cat"]."` WHERE `id_categorie` = '".$id_categorie."';";
			$sql2 = "DELETE FROM `".$My_SQL["categories"]."` WHERE `Id` = '".$id_categorie."';";
			return ($db->sql_query($sql1) && $db->sql_query($sql2));
		}
		else {
			return false;
		}
	}
	
/**
* Renvoie la liste des priodes de solde.
* 
* Si l'identifiant est vide, toutes les priodes sont renvoyes.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Identifiant de la priode recherche.
* @return array Retourne le tableau de toutes les priodes trouves.
*/
	function getAllPeriodSolde($My_SQL,$Id="") {
		$db=$My_SQL["maBase"];
		$cond = "";
		if ($Id != "") {
			$cond .= "WHERE `Id`='".$Id."'";
		}
		$mcs = array();
		$sql = "SELECT `Id`,`deb_solde`, `fin_solde` FROM `".$My_SQL["solde"]."` ".$cond." ORDER BY `deb_solde` DESC";
		$search = $db->sql_query($sql);
		if ($db->sql_numrows($search) != 0) {
			while ($ligneencours = $db->sql_fetchrow($search)) {
				array_push($mcs,array("Id"=>$ligneencours["Id"],"deb_solde"=>$ligneencours["deb_solde"],"fin_solde"=>$ligneencours["fin_solde"]));
			}
		}
		return $mcs;
	}

/**
* Enregistre une priode de solde.
* 
* Si l'identifiant vaut "-1", une nouvelle priode est enregistre.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $period_solde Tableau contenant les champs de la priode  enregistrer.
* @return boolean Retourne le rsultat de l'opration.
*/
	function savePeriodSolde($My_SQL,$period_solde) {
		$db=$My_SQL["maBase"];
		$categorie = adminCatalog::conditionnertodb($categorie);
		if ($period_solde["Id"] == "-1") {
			$sql = "INSERT INTO `".$My_SQL["solde"]."` (`deb_solde`,`fin_solde`)";
			$sql .= " VALUES ('".$period_solde["deb_solde"]."', '".$period_solde["fin_solde"]."');";
		}
		else {
			$sql = "UPDATE `".$My_SQL["solde"]."` SET `deb_solde`='".$period_solde["deb_solde"]."', `fin_solde`='".$period_solde["fin_solde"]."' WHERE `Id` = '".$period_solde["Id"]."';";
			
		}
		return $db->sql_query($sql);
	}

/**
* Supprime une priode de soldes.
* 
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $id_period_solde Identifiant de la priode  supprimer.
* @return boolean Retourne true si la priode a t efface, false sinon.
*/
	function delPeriodSolde($My_SQL,$id_period_solde) {
		$db=$My_SQL["maBase"];
		if ($id_period_solde != "") {
			$sql1 = "DELETE FROM `".$My_SQL["solde"]."` WHERE `Id` = '".$id_period_solde."';";
			return $db->sql_query($sql1);
		}
		else {
			return false;
		}
	}

/**
* Renvoie la liste des arborescences des catgories utilises.
* 
* Si l'identifiant est vide, toutes les arborescnces sont renvoyes.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Identifiant de l'arborescence recherche.
* @return array Retourne les arborescences trouves.
*/
	function getArborescence($My_SQL,$Id="") {
		$db=$My_SQL["maBase"];
		$cond = "";
		if ($Id != "") {
			$cond .= "WHERE `Id`='".$Id."'";
		}
		$mcs = array();
		$sql = "SELECT `Id`,`nom`,`arbo` FROM `".$My_SQL["arbo"]."` ".$cond." ORDER BY `nom` ASC";
		$search = $db->sql_query($sql);
		if ($db->sql_numrows($search) != 0) {
			while ($ligneencours = $db->sql_fetchrow($search)) {
				array_push($mcs,array("Id"=>$ligneencours["Id"],"nom"=>$ligneencours["nom"],"arbo"=>$ligneencours["arbo"]));
			}
		}
		return $mcs;
	}

/**
* Enregistre une arborescence de catgories.
* 
* Si l'identifiant de l'orborescence vaut "-1", une nouvelle orborescence est enregistre.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $new_arbo Tableau contenant les champs de l'arborescence  enregistrer.
* @return boolean Retourne le rsultat de l'opration.
*/
	function saveArborescence($My_SQL,$new_arbo) {
		$db=$My_SQL["maBase"];
		$new_arbo = array_map(array('adminCatalog', 'conditionnertodb'), $new_arbo);
		//$new_arbo["arbo"] = addslashes($new_arbo["arbo"]);
		$new_arbo["arbo"] = str_replace('\\n','\\\\n',$new_arbo["arbo"]);
		if ($new_arbo["Id"] == "-1") {
			$sql = "INSERT INTO `".$My_SQL["arbo"]."` (`nom`,`arbo`)";
			$sql .= " VALUES ('".$new_arbo["nom"]."','".$new_arbo["arbo"]."');";
		}
		else {
			$sql = "UPDATE `".$My_SQL["arbo"]."` SET `nom`='".$new_arbo["nom"]."', `arbo`='".$new_arbo["arbo"]."' WHERE `Id` = '".$new_arbo["Id"]."';";
		}
		return $db->sql_query($sql);
	}
	
/**
* Supprime une arborescence de catgories.
* 
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Identifiant de l'arborescence  supprimer.
* @return boolean Retourne true si l'arborescence a t efface, false sinon.
*/
	function delArborescence($My_SQL,$Id) {
		$db=$My_SQL["maBase"];
		
		if ($Id != "") {
			$cond = "`Id` = ".$Id;
			$sql = "DELETE FROM `".$My_SQL["arbo"]."` WHERE ".$cond.";";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
	
/**
* Enregistre un nouveau lien entre une fiche catgorie et une fiche article.
* 
* Ne cre que de nouvelles fiches.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $id_article Indentifiant de la fiche article.
* @param integer $id_categorie Indentifiant de la fiche catgorie.
* @return boolean Retourne le rsultat de l'opration.
*/
	function saveLien($My_SQL,$id_article,$id_categorie) {
		$db=$My_SQL["maBase"];
		$sql = "INSERT INTO `".$My_SQL["liens-cat"]."` (`id_categorie`,`id_article`)";
		$sql .= " VALUES ('".$id_categorie."','".$id_article."');";
		return $db->sql_query($sql);
	}

/**
* Supprime une ou plusieurs fiches de lien entre une fiche catgorie et une fiche article.
* 
* Si $id_article!="" et $id_categorie=="" toutes les fiches lies  cet article sont supprimes.
* Si $id_article=="" et $id_categorie!="" toutes les fiches lies  cette catgorie sont supprimes.
* Si $id_article!="" et $id_categorie!="" la fiche correspondante est supprime.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $id_article Indentifiant de la fiche article.
* @param integer $id_categorie Indentifiant de la fiche catgorie.
* @return boolean Retourne le rsultat de l'opration.
*/
	function delLien($My_SQL,$id_article,$id_categorie) {
		$db=$My_SQL["maBase"];
		$cond = "";
		if ($id_article != "") {
				if ($cond != "") {
					$cond .= " AND ";
				}
			$cond .= "`id_article` = '".$id_article."'";
		}
		if ($id_categorie != "") {
				if ($cond != "") {
					$cond .= " AND ";
				}
			$cond .= "`id_categorie` = '".$id_categorie."'";
		}
		if ($cond != "") {
			$sql = "DELETE FROM `".$My_SQL["liens-cat"]."` WHERE ".$cond.";";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}

/**
* Enregistre un compte client  partir du front-office.
* 
* Si le compte client existe dj, il est simplement modifi, sinon il est cr.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $client Tableau contenant tous les champs du compte  enregistrer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/	
	function saveClient($My_SQL,$client) {
		$db=$My_SQL["maBase"];
		$client = array_map(array('adminCatalog', 'conditionnertodb'), $client);
		if ($client["Id"] == "-1") {
			$sql = "INSERT INTO `".$My_SQL["clients"]."` (`civilite`,`nom`,`prenom`,`societe`,`adresse`,`codepostal`,`ville`,`pays`,`tel`,`fax`,`portable`,`email`,`services`,`codeclient`,`passwd`,`valide`,`divers`,`datenaissance`,`newsletter`)";
			$sql .= " VALUES ('".$client["civilite"]."','".$client["nom"]."','".$client["prenom"]."','".$client["societe"]."','".$client["adresse"]."','".$client["codepostal"]."','".$client["ville"]."','".$client["pays"]."','".$client["tel"]."','".$client["fax"]."','".$client["portable"]."','".$client["email"]."','".$client["services"]."','".$client["codeclient"]."','".$client["passwd"]."','".$client["valide"]."','".$client["divers"]."','".$client["datenaissance"]."','".$client["newsletter"]."');";
		}
		else {
			$sql = "UPDATE `".$My_SQL["clients"]."` SET `civilite` = '".$client["civilite"]."',`nom` = '".$client["nom"]."',`prenom` = '".$client["prenom"]."',`societe` = '".$client["societe"]."', `adresse` = '".$client["adresse"]."', `codepostal` = '".$client["codepostal"]."', `ville` = '".$client["ville"]."', `pays` = '".$client["pays"]."', `tel` = '".$client["tel"]."', `fax` = '".$client["fax"]."', `portable` = '".$client["portable"]."', `email` = '".$client["email"]."', `services` = '".$client["services"]."', `codeclient` = '".$client["codeclient"]."', `passwd` = '".$client["passwd"]."', `valide` = '".$client["valide"]."', `divers` = '".$client["divers"]."', `datenaissance` = '".$client["datenaissance"]."', `newsletter` = '".$client["newsletter"]."' WHERE `Id` = '".$client["Id"]."';";
		}
		return $db->sql_query($sql);
	}
	
/**
* Renvoie le compte client recherch.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $clef Tableau contenant les identifiants du compte.
* @return array Retourne la fiche du compte client trouv.
*/
	function getClient($My_SQL,$clef) {
		$db=$My_SQL["maBase"];
		$client = array();
		$cond = "";
		if ($clef["Id"] != "-1" && $clef["Id"] != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`Id`='".$clef["Id"]."'";
		}
		if ($clef["codeclient"] != "" && $clef["passwd"] != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`codeclient`='".$clef["codeclient"]."' AND `passwd`='".$clef["passwd"]."'";
		}
		$resultatRecherche = $db->sql_query("SELECT `Id`,`civilite`,`nom`,`prenom`,`societe`,`adresse`,`codepostal`,`ville`,`pays`,`tel`,`fax`,`portable`,`email`,`services`,`codeclient`,`passwd`,`valide`,`divers`,`datenaissance`,`newsletter` FROM `".$My_SQL["clients"]."` ".$cond.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			$client = $db->sql_fetchrow($resultatRecherche);
		}
		return $client;
	}
	
/**
* Teste l'existance d'un compte client.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $clef Tableau contenant les identifiants du compte.
* @return boolean Retourne vrai si une unique fiche a t trouve, et faux sinon.
*/
	function exists_client($My_SQL,$clef) {
		$db=$My_SQL["maBase"];
		$cond = "";
		if ($clef["Id"] != "-1" && $clef["Id"] != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`Id`='".$clef["Id"]."'";
		}
		if ($clef["codeclient"] != "" && $clef["passwd"] != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`codeclient`='".$clef["codeclient"]."' AND `passwd`='".$clef["passwd"]."'";
		}
		$resultatRecherche = $db->sql_query("SELECT count(`Id`) as `nbrefiches` FROM `".$My_SQL["clients"]."` ".$cond." GROUP BY `Id`;");
		if ($db->sql_numrows($resultatRecherche) == 1) {
			$fiche = $db->sql_fetchrow($resultatRecherche);
			return ($fiche["nbrefiches"] == "1");
		}
		return false;
	}

/**
* Teste l'existance d'un code client.
* 
* Ce code client doit tre unique par client.
* @param array $My_SQL Paramtres de la base de donnes.
* @param string $code Tableau contenant les identifiants du compte.
* @return boolean Retourne vrai si une unique fiche a t trouve, et faux sinon.
*/
	function exists_code($My_SQL,$code) {
		$db=$My_SQL["maBase"];
		$cond = "";
		if ($code != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`codeclient`='".$code."'";
		}
		else {
			return true;
		}
		$resultatRecherche = $db->sql_query("SELECT count(`Id`) as `nbrefiches` FROM `".$My_SQL["clients"]."` ".$cond." GROUP BY `Id`;");
		$fiche = $db->sql_fetchrow($resultatRecherche);
		return ($fiche["nbrefiches"] != "0");
	}
	
/**
* Retourne l'identifiant d'un compte client.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $clef Tableau contenant les identifiants du compte.
* @return integer Retourne l'identifiant du compte client s'il est trouv ou "-1" sinon.
*/
	function get_client_id($My_SQL,$clef) {
		$db=$My_SQL["maBase"];
		$cond = "";
		if ($clef["codeclient"] != "" && $clef["passwd"] != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`codeclient`='".$clef["codeclient"]."' AND `passwd`='".$clef["passwd"]."'";
		}
		$resultatRecherche = $db->sql_query("SELECT `Id` FROM `".$My_SQL["clients"]."` ".$cond.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			$fiche = $db->sql_fetchrow($resultatRecherche);
			return $fiche["Id"];
		}
		return "-1";
	}
	
/**
* Retourne le code client et le mot de passe d'un compte client.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $email E-mail du compte  retrouver.
* @return integer Retourne les identifiants du compte client s'il est trouv ou un tableau vide sinon.
*/
	function get_client_ids($My_SQL,$email) {
		$db=$My_SQL["maBase"];
		$clients = array();
		$cond = "";
		if ($email != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`email`='".$email."'";
		}
		$resultatRecherche = $db->sql_query("SELECT `nom`,`prenom`,`codeclient`,`passwd` FROM `".$My_SQL["clients"]."` ".$cond.";");
		if ($db->sql_numrows($resultatRecherche) != 0 && $email != "") {
			while ($fiche = $db->sql_fetchrow($resultatRecherche)) {
				array_push($clients,$fiche);
			}
		}
		return $clients;
	}
	
/**
* Retourne les civilit, noms et prnom d'un compte client.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Identifiant de la fiche client.
* @return array Retourne les champs nom du client correspond  l'Id.
*/
	function get_client_identity($My_SQL,$Id) {
		$db=$My_SQL["maBase"];
		$cond = "";
		if ($Id != "" && $Id != "-1") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`Id`='".$Id."'";
		}
		$resultatRecherche = $db->sql_query("SELECT `civilite`, `nom`, `prenom` FROM `".$My_SQL["clients"]."` ".$cond.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			$fiche = $db->sql_fetchrow($resultatRecherche);
			return array("civilite" => $fiche["civilite"], "prenom" => $fiche["prenom"],"nom" => $fiche["nom"]);
		}
		return "";
	}
	
/**
* Enregistre une commande.
* 
* Si la commande existe dj, elle est simplement modifie, sinon elle est cre.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $commande Tableau contenant tous les champs du compte  enregistrer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/
	function saveCommande($My_SQL,$commande) {
		$db=$My_SQL["maBase"];
		$commande = array_map(array('adminCatalog', 'conditionnertodb'), $commande);
		if ($commande["Id"] == "-1") {
			$sql = "INSERT INTO `".$My_SQL["commandes"]."` (`id_client`,`client`,`date`,`numero`,`commande`,`total_ht`,`total_tva`,`total_ttc`, `status`,`port_ht`,`port`,`paye`,`reglement`,`code_promo`,`reduc_ht`,`remarques`)";
			$sql .= " VALUES ('".$commande["id_client"]."','".$commande["client"]."','".$commande["date"]."','".$commande["numero"]."','".$commande["commande"]."','".$commande["total_ht"]."','".$commande["total_tva"]."','".$commande["total_ttc"]."','".$commande["status"]."','".$commande["port_ht"]."','".$commande["port"]."','".$commande["paye"]."','".$commande["reglement"]."','".$commande["code_promo"]."','".$commande["reduc_ht"]."','".$commande["remarques"]."');";
		}
		else {
			$sql = "UPDATE `".$My_SQL["commandes"]."` SET `id_client`='".$commande["id_client"]."',`client`='".$commande["client"]."',`date`='".$commande["date"]."',`numero`='".$commande["numero"]."',`commande`='".$commande["commande"]."',`total_ht`='".$commande["total_ht"]."', `total_tva`='".$commande["total_tva"]."', `total_ttc`='".$commande["total_ttc"]."', `status`='".$commande["status"]."', `port`='".$commande["port"]."', `port_ht`='".$commande["port_ht"]."', `paye`='".$commande["paye"]."', `reglement`='".$commande["reglement"]."', `code_promo`='".$commande["code_promo"]."', `reduc_ht`='".$commande["reduc_ht"]."', `remarques`='".$commande["remarques"]."' WHERE `Id` = '".$commande["Id"]."';";
		}
		return $db->sql_query($sql);
	}
	
/**
* Renvoie les commandes recherches.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Identifiant de la commande.
* @param integer $ident_client Identifiant du client ayant pass la commande.
* @param integer $numero Numro unique de la commande.
* @return array Retourne la liste des commandes trouves.
*/
	function getCommandes($My_SQL,$Id="",$ident_client="",$numero="",$code_promo="") {
		$db=$My_SQL["maBase"];
		$cond = "";
		if ($Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`Id`='".$Id."'";
		}
		if ($ident_client != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`id_client`='".$ident_client."'";
		}
		if ($numero != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`numero`='".$numero."'";
		}
		if ($code_promo != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`code_promo`='".$code_promo."'";
		}
		$commandes = array();
		$sql = "SELECT `Id`,`id_client`, `client`, `date`, `numero`, `commande`, `total_ht`, `total_tva`, `total_ttc`,`status`, `port_ht`,`port`,`paye`,`reglement`,`code_promo`,`reduc_ht`,`remarques` FROM `".$My_SQL["commandes"]."` ".$cond." ORDER BY `numero` DESC";
		$search = $db->sql_query($sql);
		if ($db->sql_numrows($search) != 0) {
			while ($ligneencours = $db->sql_fetchrow($search)) {
				array_push($commandes,array("Id"=>$ligneencours["Id"],"id_client"=>$ligneencours["id_client"],"client"=>$ligneencours["client"],"date"=>$ligneencours["date"],"numero"=>$ligneencours["numero"],"commande"=>$ligneencours["commande"],"total_ht"=>$ligneencours["total_ht"],"total_tva"=>$ligneencours["total_tva"],"total_ttc"=>$ligneencours["total_ttc"],"status"=>$ligneencours["status"],"port"=>$ligneencours["port"],"port_ht"=>$ligneencours["port_ht"],"paye"=>$ligneencours["paye"],"reglement"=>$ligneencours["reglement"],"code_promo"=>$ligneencours["code_promo"],"reduc_ht"=>$ligneencours["reduc_ht"],"remarques"=>$ligneencours["remarques"]));
			}
		}
		return $commandes;
	}
	
/**
* Supprime une commande. Fonction non utilise !!!
* 
* Si $Id=="" aucune fiche n'est supprime.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Indentifiant de la fiche commande.
* @return boolean Retourne le rsultat de l'opration.
*/
	function delCommande($My_SQL,$Id) {
		$db=$My_SQL["maBase"];
		if ($Id != "") {
			$sql = "DELETE FROM `".$My_SQL["commandes"]."` WHERE `Id` = '".$Id."';";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
	
/**
* Renvoie la liste des pays.
* 
* Seuls les pays actifs sont retourns.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $tri Suffixe de la langue dans laquelle el tri doit tre effectu (_F;_E;_A;_I;_S).
* @param string $code Code du pays  retrouver.
* @return array Retourne la liste des pays retrouvs.
*/
	function getPays($My_SQL, $tri="",$code="") {
		$db=$My_SQL["maBase"];
		if ($tri != "") {
			$orderby = " ORDER BY `pays".$tri."` ASC";
		}
		else {
			$orderby = "";
		}
		$cond = " WHERE `active`='1'";
		if ($code != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`code` = '".$code."'";
		}
		$pays = array();
		$sql = "SELECT `code`,`pays_F`,`pays_E`,`pays_A`,`pays_I`,`pays_S` FROM `".$My_SQL["pays"]."`".$cond.$orderby.";";
		$search = $db->sql_query($sql);
		if ($db->sql_numrows($search) != 0) {
			while ($ligneencours = $db->sql_fetchrow($search)) {
				array_push($pays,$ligneencours);
			}
		}
		return $pays;
	}

/**
* Renvoie la liste des moyens de transport.
* 
* Seuls les pays actifs sont retourns.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Identifiant du moyen de livraison  diter.
* @param integer $pays Code du pays  livrer.
* @return array Retourne la liste des moyens de transports.
*/
	function getPorts($My_SQL, $Id="", $pays="") {
		$db=$My_SQL["maBase"];
		if ($Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`Id`='".$Id."'";
		}
		if ($pays != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "(`list_pays` LIKE '%".$pays."%' OR `list_pays`='')";
		}
		$ports = array();
		$sql = "SELECT `Id` , `designation` , `tarif` , `tva` , `seuilfranco` , `delai` , `list_pays` FROM `".$My_SQL["ports"]."`".$cond." ORDER BY `tarif` ASC;";
		$search = $db->sql_query($sql);
		if ($db->sql_numrows($search) != 0) {
			while ($ligneencours = $db->sql_fetchrow($search)) {
				array_push($ports,$ligneencours);
			}
		}
		return $ports;
	}
	
/**
* Enregistre un moyen de livraison.
* 
* Si l'identifiant vaut "-1", un nouveau moyen de livraison est enregistre.
* @param array $My_SQL Paramtres de la base de donnes.
* @param array $port Tableau contenant les champs du moyen de livraison  enregistrer.
* @return boolean Retourne le rsultat de l'opration.
*/
	function savePort($My_SQL,$port) {
		$db=$My_SQL["maBase"];
		$port = array_map(array('adminCatalog', 'conditionnertodb'), $port);
		if ($port["Id"] == "-1") {
			$sql = "INSERT INTO `".$My_SQL["ports"]."` (`designation` , `tarif` , `tva` , `seuilfranco` , `delai` , `list_pays`)";
			$sql .= " VALUES ('".$port["designation"]."', '".$port["tarif"]."', '".$port["tva"]."', '".$port["seuilfranco"]."', '".$port["delai"]."', '".$port["list_pays"]."');";
		}
		else {
			$sql = "UPDATE `".$My_SQL["ports"]."` SET `designation`='".$port["designation"]."', `tarif`='".$port["tarif"]."', `tva`='".$port["tva"]."', `seuilfranco`='".$port["seuilfranco"]."', `delai`='".$port["delai"]."', `list_pays`='".$port["list_pays"]."' WHERE `Id` = '".$port["Id"]."';";
			
		}
		return $db->sql_query($sql);
	}

/**
* Supprime un moyen d'expdition.
* 
* Si $Id=="" aucune fiche n'est supprime.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Indentifiant de la fiche commande.
* @return boolean Retourne le rsultat de l'opration.
*/
	function delPort($My_SQL,$Id) {
		$db=$My_SQL["maBase"];
		if ($Id != "") {
			$sql = "DELETE FROM `".$My_SQL["ports"]."` WHERE `Id` = '".$Id."';";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
	
	function getTarif($My_SQL,$Id="",$id_produit="") {
		$db=$My_SQL["maBase"];
		$cond = "";
		if ($Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`Id`='".$Id."'";
		}
		if ($id_produit != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`id_produit`='".$id_produit."'";
		}
		$oderby = " ORDER BY `tarif_ht` DESC";
		$tarifs = array();
		$sql = "SELECT `Id`,`id_produit`, `tarif_ht`, `tarif_promo`, `taux_solde`, `deb_promo`, `fin_promo`, `seuil` FROM `".$My_SQL["tarifs"]."` ".$cond.$oderby.";";
		$search = $db->sql_query($sql);
		if ($db->sql_numrows($search) != 0) {
			while ($ligneencours = $db->sql_fetchrow($search)) {
				$tarifs[] = $ligneencours;
			}
		}
		return $tarifs;
	}
	
	function saveTarif($My_SQL,$new_tarif) {
		$db=$My_SQL["maBase"];
		$new_tarif = array_map(array('adminCatalog', 'conditionnertodb'), $new_tarif);
		$list_champs = "";
		$list_valeurs = "";
		if ($new_tarif["Id"] == "-1" || $new_tarif["Id"] == "" || $new_tarif["Id"] == "0") {
			$list_champs = ""; $list_valeurs="";
			foreach($new_tarif as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."`";
					$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
					$list_valeurs .= "'".$value."'";
				}
			}
			$sql = "INSERT INTO ".$My_SQL["tarifs"]." (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		}
		else {
			$list_champs = ""; $list_valeurs="";
			foreach($new_tarif as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."` = '".$value."'";
				}
			}
			$sql = "UPDATE ".$My_SQL["tarifs"]." SET ".$list_champs." WHERE `Id` = '".$new_tarif["Id"]."';";
		}
		return $db->sql_query($sql);
	}
	
	function delTarif($My_SQL,$Id) {
		$db=$My_SQL["maBase"];
		if ($Id != "") {
			$sql = "DELETE FROM `".$My_SQL["tarifs"]."` WHERE `Id` = '".$Id."';";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
}

/**
* Classe d'accs  la base de donnes commandes pour isoler les fonctions.
* @package becmsSimpleCatalog
*/
class BD_Command {

/**
* Enregistre une commande.
* 
* Si la commande existe dj, elle est simplement modifie, sinon elle est cre.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $commande Tableau contenant tous les champs du compte  enregistrer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/
	function saveCommande($My_SQL,$commande) {
		$db=$My_SQL["maBase"];
		$commande = array_map(array('adminCatalog', 'conditionnertodb'), $commande);
		if ($commande["Id"] == "-1") {
			$sql = "INSERT INTO `".$My_SQL["commandes"]."` (`id_client`,`client`,`date`,`numero`,`commande`,`total_ht`,`total_tva`,`total_ttc`, `status`,`port_ht`,`port`,`paye`,`reglement`,`code_promo`,`reduc_ht`,`remarques`)";
			$sql .= " VALUES ('".$commande["id_client"]."','".$commande["client"]."','".$commande["date"]."','".$commande["numero"]."','".$commande["commande"]."','".$commande["total_ht"]."','".$commande["total_tva"]."','".$commande["total_ttc"]."','".$commande["status"]."','".$commande["port_ht"]."','".$commande["port"]."','".$commande["paye"]."','".$commande["reglement"]."','".$commande["code_promo"]."','".$commande["reduc_ht"]."','".$commande["remarques"]."');";
		}
		else {
			$sql = "UPDATE `".$My_SQL["commandes"]."` SET `id_client`='".$commande["id_client"]."',`client`='".$commande["client"]."',`date`='".$commande["date"]."',`numero`='".$commande["numero"]."',`commande`='".$commande["commande"]."',`total_ht`='".$commande["total_ht"]."', `total_tva`='".$commande["total_tva"]."', `total_ttc`='".$commande["total_ttc"]."', `status`='".$commande["status"]."', `port_ht`='".$commande["port_ht"]."', `port`='".$commande["port"]."', `paye`='".$commande["paye"]."', `reglement`='".$commande["reglement"]."', `code_promo`='".$commande["code_promo"]."', `reduc_ht`='".$commande["reduc_ht"]."', `remarques`='".$commande["remarques"]."' WHERE `Id` = '".$commande["Id"]."';";
		}
		return $db->sql_query($sql);
	}
/**
* Renvoie les commandes recherches.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Identifiant de la commande.
* @param integer $ident_client Identifiant du client ayant pass la commande.
* @param string $numero Numro unique de la commande.
* @param string $tri_par Rubrique de tri.
* @param string $limit Bornes de recherche des commandes ( partir de,nbre).
* @return array Retourne la liste des fiches de commandes trouves.
*/
	function getCommandes($My_SQL,$Id="",$ident_client="",$numero="",$tri_par="",$limit="") {
		$db=$My_SQL["maBase"];
		$cond = "";
		if ($Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`Id`='".$Id."'";
		}
		if ($ident_client != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`id_client`='".$ident_client."'";
		}
		if ($numero != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`numero`='".$numero."'";
		}
		$oderby = "";
		if ($tri_par =="") {
			$oderby = " ORDER BY `numero` DESC";
		}
		if ($tri_par == "client") {
			$oderby = " ORDER BY `client` ASC, `numero` DESC";
		}
		if ($tri_par == "date") {
			$oderby = " ORDER BY `date` DESC";
		}
		if ($tri_par == "paid") {
			$oderby = " ORDER BY `paye` ASC";
		}
		if ($tri_par == "status") {
			$oderby = " ORDER BY `status` ASC";
		}
		if ($limit != "") {
			$limit = " LIMIT ".trim($limit);
		}
		$commandes = array();
		$sql = "SELECT `Id`,`id_client`, `client`, `date`, `numero`, `commande`, `total_ht`, `total_tva`, `total_ttc`,`status`,`port`,`port_ht`,`paye`,`reglement`,`code_promo`,`reduc_ht`,`remarques` FROM `".$My_SQL["commandes"]."` ".$cond.$oderby.$limit.";";
		$search = $db->sql_query($sql);
		if ($db->sql_numrows($search) != 0) {
			while ($ligneencours = $db->sql_fetchrow($search)) {
				array_push($commandes,array("Id"=>$ligneencours["Id"],"id_client"=>$ligneencours["id_client"],"client"=>$ligneencours["client"],"date"=>$ligneencours["date"],"numero"=>$ligneencours["numero"],"commande"=>$ligneencours["commande"],"total_ht"=>$ligneencours["total_ht"],"total_tva"=>$ligneencours["total_tva"],"total_ttc"=>$ligneencours["total_ttc"],"status"=>$ligneencours["status"],"port_ht"=>$ligneencours["port_ht"],"port"=>$ligneencours["port"],"paye"=>$ligneencours["paye"],"reglement"=>$ligneencours["reglement"],"code_promo"=>$ligneencours["code_promo"],"reduc_ht"=>$ligneencours["reduc_ht"],"remarques"=>$ligneencours["remarques"]));
			}
		}
		return $commandes;
	}

/**
* Renvoie le nombre de commandes correspondants  la demande.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Identifiant de la commande  renvoyer.
* @return integer Retourne le nombre de commandes trouvs.
*/	
	function getNumCommandes($My_SQL,$Id="",$status="") {
		$db=$My_SQL["maBase"];
		
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["commandes"]."`.`Id`='".$Id."'";
		}
		if ($status != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			//si traite
			if ($status == "-1") {
				$cond .= "`".$My_SQL["commandes"]."`.`status`<>'0'";
			}
			//si non traite
			if ($status == "0") {
				$cond .= "`".$My_SQL["commandes"]."`.`status`='0'";
			}
			//si non payes
			if ($status == "-10") {
				$cond .= "`".$My_SQL["commandes"]."`.`paye`='0'";
			}
		}
		$resultatRecherche = $db->sql_query("SELECT COUNT(`".$My_SQL["commandes"]."`.`Id`) as `nbrefiches` FROM `".$My_SQL["commandes"]."` ".$cond.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			if ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				return $ligneCourante["nbrefiches"];
			}
		}
		return 0;
	}
	
/**
* Supprime une commande.
* 
* Si $Id=="" aucune fiche n'est supprime.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Indentifiant de la fiche commande.
* @return boolean Retourne le rsultat de l'opration.
*/
	function delCommande($My_SQL,$Id) {
		$db=$My_SQL["maBase"];
		if ($Id != "") {
			$sql = "DELETE FROM `".$My_SQL["commandes"]."` WHERE `Id` = '".$Id."';";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
}
/**
* Classe d'accs  la base de donnes commandes pour isoler les fonctions.
* @package becmsSimpleCatalog
*/
class BD_Promo {

/**
* Enregistre une promotion.
* 
* Si la promotion existe dj, elle est simplement modifie, sinon elle est cre.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $promo Tableau contenant tous les champs de la promo  enregistrer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/
	function savePromo($My_SQL,$promo) {
		$db=$My_SQL["maBase"];
		$promo = array_map(array('adminCatalog', 'conditionnertodb'), $promo);
		if ($promo["Id"] == "-1") {
			$sql = "INSERT INTO `".$My_SQL["promos"]."` (`code`,`debut`,`fin`,`pourcent`,`somme`,`noport`,`seuil`,`multiple`, `id_produit`)";
			$sql .= " VALUES ('".$promo["code"]."','".$promo["debut"]."','".$promo["fin"]."','".$promo["pourcent"]."','".$promo["somme"]."','".$promo["noport"]."','".$promo["seuil"]."','".$promo["multiple"]."','".$promo["id_produit"]."');";
		}
		else {
			$sql = "UPDATE `".$My_SQL["promos"]."` SET `code`='".$promo["code"]."',`debut`='".$promo["debut"]."',`fin`='".$promo["fin"]."',`pourcent`='".$promo["pourcent"]."',`somme`='".$promo["somme"]."',`noport`='".$promo["noport"]."', `seuil`='".$promo["seuil"]."', `multiple`='".$promo["multiple"]."', `id_produit`='".$promo["id_produit"]."' WHERE `Id` = '".$promo["Id"]."';";
		}
		return $db->sql_query($sql);
	}
/**
* Renvoie les promotions recherches.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Identifiant de la promotion.
* @param integer $code Code public de la promotion.
* @param string $tri_par Rubrique de tri.
* @param string $limit Bornes de recherche des promotions ( partir de,nbre).
* @return array Retourne la liste des fiches de promotions trouves.
*/
	function getPromo($My_SQL,$Id="",$code="",$tri_par="",$limit="") {
		$db=$My_SQL["maBase"];
		$cond = "";
		if ($Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`Id`='".$Id."'";
		}
		if ($code != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`code`='".$code."'";
		}
		$oderby = "";
		if ($tri_par == "" || $tri_par == "code") {
			$oderby = " ORDER BY `code` ASC";
		}
		if ($tri_par == "date") {
			$oderby = " ORDER BY `debut` DESC, `fin` ASC";
		}
		if ($limit != "") {
			$limit = " LIMIT ".trim($limit);
		}
		$promos = array();
		$sql = "SELECT `Id`,`code`, `debut`, `fin`, `pourcent`, `somme`, `noport`, `seuil`,`multiple`, `id_produit` FROM `".$My_SQL["promos"]."` ".$cond.$oderby.$limit.";";
		$search = $db->sql_query($sql);
		if ($db->sql_numrows($search) != 0) {
			while ($ligneencours = $db->sql_fetchrow($search)) {
				array_push($promos,array("Id"=>$ligneencours["Id"],"code"=>$ligneencours["code"],"debut"=>$ligneencours["debut"],"fin"=>$ligneencours["fin"],"pourcent"=>$ligneencours["pourcent"],"somme"=>$ligneencours["somme"],"noport"=>$ligneencours["noport"],"seuil"=>$ligneencours["seuil"],"multiple"=>$ligneencours["multiple"],"id_produit"=>$ligneencours["id_produit"]));
			}
		}
		return $promos;
	}

/**
* Renvoie le nombre de promotions correspondants  la demande.
* @param array $My_SQL Paramtres de la base de donnes.
* @return integer Retourne le nombre de promotions trouvs.
*/	
	function getNumPromos($My_SQL) {
		$db=$My_SQL["maBase"];
		
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["promos"]."`.`Id`='".$Id."'";
		}
		$resultatRecherche = $db->sql_query("SELECT COUNT(`".$My_SQL["promos"]."`.`Id`) as `nbrefiches` FROM `".$My_SQL["promos"]."` ".$cond.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			if ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				return $ligneCourante["nbrefiches"];
			}
		}
		return 0;
	}
	
/**
* Supprime une promo.
* 
* Si $Id=="" aucune fiche n'est supprime.
* @param array $My_SQL Paramtres de la base de donnes.
* @param integer $Id Indentifiant de la fiche promo.
* @return boolean Retourne le rsultat de l'opration.
*/
	function delPromo($My_SQL,$Id) {
		$db=$My_SQL["maBase"];
		if ($Id != "") {
			$sql = "DELETE FROM `".$My_SQL["promos"]."` WHERE `Id` = '".$Id."';";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
}
/**
* Classe d'enregistrement des variables des session dans la base de donnes.
* @package becmsSimpleCatalog
*/
class BD_Sessions_catalog { 
/**
* @var integer Dure de vie des variables de session.
*/
	var $lifeTime;
/**
* @var mixed Objet base de donnes utilisant l'API de la plateforme.
*/
	var $dbHandle;
/**
* Initialisation des sessions.
* 
* @param string $savePath Chemin de sauvegarde des variables de session. Non utilise.
* @param string $sessName Nom de la session. Non utilise.
* @return boolean Retourne true si la base de donnes est ouverte, false sinon.
*/
	function open($savePath, $sessName) {
		// get session-lifetime 
		//$this->lifeTime = get_cfg_var("session.gc_maxlifetime");
		$this->lifeTime = 24 * 60 * 60; //dure de vie d'une journe
		// open database-connection 
		global $db;
		$dbHandle = $db;
		if(!$dbHandle) {
			return false;
		} 
		$this->dbHandle = $dbHandle;
		return true;
	}
/**
* Fermeture des sessions. Dtruit les sesssions arrives  terme
*/
	function close() {
		$this->gc(ini_get('session.gc_maxlifetime')); 
	}
/**
* Lecture des variables de session.
* 
* @param integer $sessID Identifiant de la session.
* @return mixed Retourne la valeur trouvs ou NULL. NULL est utilis pour que isset($SESSION["xxx"]) renvoie false.
*/	
	function read($sessID) {
		// fetch session-data 
		$res = $this->dbHandle->sql_query("SELECT session_data AS d FROM becms_commerce_sessions 
							WHERE session_id = '$sessID' 
							AND session_expires > ".time()); 
		// return data or NULL at failure 
		if($row = $this->dbHandle->sql_fetchrow($res)) 
			return $row['d']; 
		return NULL; 
	}
/**
* Ecriture des variables de session.
* 
* Chaque criture repousse le dlai d'expiration.
* @param integer $sessID Identifiant des variables de session en cours.
* @param mixed $sessData Variables de session  mmoriser.
* @return boolean Retourne true les donnes sont enregistres, false sinon.
*/	
	function write($sessID,$sessData) {
		// new session-expire-time
		$newExp = time() + $this->lifeTime; 
		// is a session with this id in the database? 
		$res = $this->dbHandle->sql_query("SELECT * FROM becms_commerce_sessions
						WHERE session_id = '$sessID'"); 
		// if yes, 
		if($this->dbHandle->sql_numrows($res)) {
			// ...update session-data 
			$this->dbHandle->sql_query("UPDATE becms_commerce_sessions 
						 SET session_expires = '$newExp', 
						 session_data = '$sessData' 
						 WHERE session_id = '$sessID'"); 
			// if something happened, return true 
			if($this->dbHandle->sql_affectedrows()) 
				return true; 
		}
		// if no session-data was found, 
		else { 
			// create a new row
			$this->dbHandle->sql_query("INSERT INTO becms_commerce_sessions ( 
						 session_id, 
						 session_expires, 
						 session_data) 
						 VALUES( 
						 '$sessID', 
						 '$newExp', 
						 '$sessData')"); 
			// if row was created, return true 
			if($this->dbHandle->sql_affectedrows()) 
				return true;
		} 
		// an unknown error occured 
		return false;
	}
/**
* Dtruit une session particulire.
* 
* @param integer $sessID Identifiant des variables de session  dtruire.
* @return boolean Retourne true si la session a t dtruite, false sinon.
*/
	function destroy($sessID) { 
		// delete session-data 
		$this->dbHandle->sql_query("DELETE FROM becms_commerce_sessions WHERE session_id = '$sessID'"); 
		// if session was deleted, return true, 
		if($this->dbHandle->sql_affectedrows()) 
			return true; 
		// ...else return false 
		return false; 
	}
/**
* Dtruit les sessions trop anciennes.
* 
* @param string $sessMaxLifeTime Dure de survie d'une variable de session. Non utilise.
* @return boolean Retourne true si une ou plusieurs session ont t dtruites, false sinon.
*/
	function gc($sessMaxLifeTime) { 
		// delete old sessions 
		$this->dbHandle->sql_query("DELETE FROM becms_commerce_sessions WHERE session_expires < ".time()); 
		// return affected rows 
		return $this->dbHandle->sql_affectedrows(); 
	}
 }

?>