<?php
/**
 * Interfaage du module avec le Front Office du CMS.
 *
 * Son inclusion dans le Back Office est automatique, et son accs se trouve dans le menu "Modules"
 * @package becmsSimpleCatalog
 * @version 1.0
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2007, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @todo Au cas o un lment n'exiterait pas dans une langue (description, intitul,...), l'afficher dans une langue disponible.
 * @todo Prvoir une clef de contrle captcha pour l'identification (idem site acmo).
 * @todo Inscription automatique  la newsletter si e-mail non vide - prvoir confirmation d'inscription avec case  cocher
 */

/**
 * Structure des six tables utilises par ce module
 * --
 * -- Structure de la table `becms_commerce_catalog`
 * --
 *
 * DROP TABLE IF EXISTS `becms_commerce_catalog`;
 * CREATE TABLE `becms_commerce_catalog` (
 *   `Id` int(11) NOT NULL auto_increment,
 *   `ref_article` varchar(50) collate latin1_general_ci NOT NULL,
 *   `photo` varchar(50) collate latin1_general_ci NOT NULL,
 *   `marque` varchar(50) collate latin1_general_ci NOT NULL,
 *   `designation_F` varchar(100) collate latin1_general_ci NOT NULL,
 *   `designation_E` varchar(100) collate latin1_general_ci NOT NULL,
 *   `designation_A` varchar(100) collate latin1_general_ci NOT NULL,
 *   `designation_I` varchar(100) collate latin1_general_ci NOT NULL,
 *   `designation_S` varchar(100) collate latin1_general_ci NOT NULL,
 *   `description_F` text collate latin1_general_ci NOT NULL,
 *   `description_E` text collate latin1_general_ci NOT NULL,
 *   `description_A` text collate latin1_general_ci NOT NULL,
 *   `description_I` text collate latin1_general_ci NOT NULL,
 *   `description_S` text collate latin1_general_ci NOT NULL,
 *   `options_F` text collate latin1_general_ci NOT NULL,
 *   `options_E` text collate latin1_general_ci NOT NULL,
 *   `options_A` text collate latin1_general_ci NOT NULL,
 *   `options_I` text collate latin1_general_ci NOT NULL,
 *   `options_S` text collate latin1_general_ci NOT NULL,
 *   `tarif_ht` decimal(10,2) NOT NULL,
 *   `taux_tva` decimal(10,2) NOT NULL,
 *   `tarif_promo` decimal(10,2) NOT NULL,
 *   `taux_solde` decimal(10,2) NOT NULL,
 *   `deb_promo` date NOT NULL,
 *   `fin_promo` date NOT NULL,
 *   `deb_solde` date NOT NULL,
 *   `fin_solde` date NOT NULL,
 *   `valide` tinyint(4) NOT NULL,
 *   PRIMARY KEY  (`Id`),
 *   KEY `valide` (`valide`),
 *   KEY `marque` (`marque`),
 *   KEY `designation_F` (`designation_F`,`designation_E`,`designation_A`,`designation_I`,`designation_S`),
 *   KEY `reference` (`ref_article`)
 * ) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci COMMENT='Catalogue produits' AUTO_INCREMENT=30 ;
 *
 * -- --------------------------------------------------------
 *
 * --
 * -- Structure de la table `becms_commerce_categories`
 * --
 *
 * DROP TABLE IF EXISTS `becms_commerce_categories`;
 * CREATE TABLE `becms_commerce_categories` (
 *   `Id` int(11) NOT NULL auto_increment,
 *   `categorie` varchar(100) collate latin1_general_ci NOT NULL,
 *   PRIMARY KEY  (`Id`),
 *   KEY `categorie` (`categorie`)
 * ) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci COMMENT='Liste des catgories d''articles' AUTO_INCREMENT=7 ;
 *
 * -- --------------------------------------------------------
 *
 * --
 * -- Structure de la table `becms_commerce_categories_arbo`
 * --
 *
 * DROP TABLE IF EXISTS `becms_commerce_categories_arbo`;
 * CREATE TABLE `becms_commerce_categories_arbo` (
 *   `Id` int(11) NOT NULL auto_increment,
 *   `nom` varchar(50) collate latin1_general_ci NOT NULL,
 *   `arbo` text collate latin1_general_ci NOT NULL,
 *   PRIMARY KEY  (`Id`),
 *   KEY `nom` (`nom`)
 * ) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci COMMENT='arborescence des catgories' AUTO_INCREMENT=3 ;
 *
 * -- --------------------------------------------------------
 *
 * --
 * -- Structure de la table `becms_commerce_commandes`
 * --
 *
 * DROP TABLE IF EXISTS `becms_commerce_commandes`;
 * CREATE TABLE `becms_commerce_commandes` (
 *   `Id` int(11) NOT NULL auto_increment,
 *   `id_client` int(11) NOT NULL,
 *   `client` text collate latin1_general_ci NOT NULL,
 *   `date` date NOT NULL,
 *   `numero` varchar(20) collate latin1_general_ci NOT NULL,
 *   `commande` text collate latin1_general_ci NOT NULL,
 *   `total_ht` decimal(10,2) NOT NULL,
 *   `total_tva` decimal(10,2) NOT NULL,
 *   `total_ttc` decimal(10,2) NOT NULL,
 *   `status` int(11) NOT NULL,
 *   PRIMARY KEY  (`Id`),
 *   KEY `id_client` (`id_client`,`date`,`numero`),
 *   KEY `status` (`status`)
 * ) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci COMMENT='Contient toutes les commandes passe sur le site' AUTO_INCREMENT=49 ;
 *
 * -- --------------------------------------------------------
 *
 * --
 * -- Structure de la table `becms_commerce_liens_cat`
 * --
 *
 * DROP TABLE IF EXISTS `becms_commerce_liens_cat`;
 * CREATE TABLE `becms_commerce_liens_cat` (
 *   `id_article` int(11) NOT NULL,
 *   `id_categorie` int(11) NOT NULL,
 *   KEY `id_article` (`id_article`,`id_categorie`)
 * ) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci COMMENT='Liens entre les catgories et les articles';
 *
 * -- --------------------------------------------------------
 *
 * --
 * -- Structure de la table `becms_commerce_soldes`
 * --
 *
 * DROP TABLE IF EXISTS `becms_commerce_soldes`;
 * CREATE TABLE `becms_commerce_soldes` (
 *   `Id` int(11) NOT NULL auto_increment,
 *   `deb_solde` date NOT NULL,
 *   `fin_solde` date NOT NULL,
 *   PRIMARY KEY  (`Id`),
 *   KEY `deb_solde` (`deb_solde`,`fin_solde`)
 * ) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci COMMENT='table contenant les priodes des soldes' AUTO_INCREMENT=4 ;
 */

if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once("core/becms_mainlib_lib.php");
require_once("modules/$module_name/lib/g_params.php");
require_once("modules/$module_name/lib/ba_displaycatalog.php");
require_once("modules/$module_name/lib/ba_admincatalog.php");

$My_SQL["maBase"] = $db;

/**
 * Affiche la liste des articles correspondant aux critres.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @param array $criteres Tableau contenant les paramtres de recherche et d'affichage des articles
 */
function displayListArticles($My_SQL,$vars_mod,$criteres) {
	global $pagetitle;
	$objetCatalog = new displayCatalog();
	$pagetitle = "- "._CATALOGARTICLES;
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	echo $objetCatalog->get_list_articles($My_SQL,$vars_mod,$criteres);
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print_list_article",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	"top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

/**
 * Affiche la grille des articles correspondant aux critres.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @param array $criteres Tableau contenant les paramtres de recherche et d'affichage des articles
 */
function displayGridArticles($My_SQL,$vars_mod,$criteres) {
	global $pagetitle;
	$objetCatalog = new displayCatalog();
	$pagetitle = "- "._CATALOGARTICLES;
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	echo $objetCatalog->get_grid_articles($My_SQL,$vars_mod,$criteres);
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print_list_article",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	"top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

/**
 * Clos le compte client en cours puis affiche la liste des articles correspondant aux critres.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @param array $criteres Tableau contenant les paramtres de recherche et d'affichage des articles
 */
function closeClient($My_SQL,$vars_mod,$criteres) {
	$_SESSION["id_s_client"] = "";
	$_SESSION["nom_client"] = array();
	if ($vars_mod["default_list"] == "display") {
		displayListArticles($My_SQL,$vars_mod,$criteres);
	}
	else {
		displayGridArticles($My_SQL,$vars_mod,$criteres);
	}
}

/**
 * Affiche la fiche d'un article.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @param array $criteres Tableau contenant les paramtres de recherche et d'affichage de l'article
 */
function displayArticle($My_SQL,$vars_mod,$criteres) {
	$objetCatalog = new displayCatalog();
	$sortie = "";
	$sortie .= $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	$sortie .= $objetCatalog->get_one_article($My_SQL,$vars_mod,$criteres);
	$sortie .=  $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	include ('header.php');
	echo $sortie;
	$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print_article",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	"top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

/**
 * Ajoute l'article dsign dans le caddie.
 *
 * Le caddie est ensuite affich pour tre modifi ou pour terminer la commande.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @param array $new_line_caddie Tableau contenant les paramtres de l'article  ajouter dans le caddie.
 */
function addCaddie($My_SQL,$vars_mod,$new_line_caddie=array()) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	echo $objetCatalog->add_caddie($My_SQL,$vars_mod,$new_line_caddie);
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print_caddie",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	"top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

/**
 * Enregistre les modifications du caddie.
 *
 * Le caddie est ensuite affich pour tre modifi ou pour terminer la commande.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @param string $new_caddie Chaine de caractres contenant le nouveau caddie.
 */
function updateCaddie($My_SQL,$vars_mod,$new_caddie) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	echo $objetCatalog->update_caddie($My_SQL,$vars_mod,$new_caddie);
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print_caddie",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	"top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

/**
 * Affiche le contenu du caddie.
 *
 * Il peut alors tre modifi ou utilis pour terminer la commande.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function displayCaddie($My_SQL,$vars_mod) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	echo $objetCatalog->display_caddie($My_SQL,$vars_mod,$new_caddie);
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print_caddie",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	"top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

/**
 * Affiche le dialogue de confirmation de la commande.
 *
 * Ce dialogue permet au client de vrifier ses coordonnes, la liste des articles commands, le total de la commande et l'acceptation des CGV.
 * Si le client ne s'est pas encore identifi, un dialogue lui permet d'utiliser son compte existant ou de crer un nouveau compte.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function setClientCaddie($My_SQL,$vars_mod) {
	$objetCatalog = new displayCatalog();
	include ('header.php');

	if ($_SESSION["id_s_client"] == "") {
		echo $objetCatalog->set_client_caddie($My_SQL,$vars_mod);
		echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	}
	else {
		echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
		$clef = array();
		$clef["Id"] = $_SESSION["id_s_client"];
		$clef["codeclient"] = "";
		$clef["passwd"] = "";
		echo $objetCatalog->affiche_client_caddie($My_SQL,$vars_mod,$clef);
		echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
		$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print_client_caddie",
		//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
		//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
		"top"=>"#top" );
		buttonBar($bardef, "align");
	}
	include ('footer.php');
}

/**
 * Affiche les informations du compte client.
 *
 * Ce dialogue permet au client d'ouvrir son compte client et de vrifier ses coordonnes.
 * Si le client ne s'est pas encore identifi, un dialogue lui permet d'utiliser son compte existant ou de crer un nouveau compte.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function setClient($My_SQL,$vars_mod) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	if ($_SESSION["id_s_client"] == "") {
		echo $objetCatalog->set_client($My_SQL,$vars_mod);
		echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	}
	else {
		echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
		$clef = array();
		$clef["Id"] = $_SESSION["id_s_client"];
		$clef["codeclient"] = "";
		$clef["passwd"] = "";
		echo $objetCatalog->affiche_client($My_SQL,$vars_mod,$clef);
		echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
		$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print_client",
		//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
		//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
		"top"=>"#top" );
		buttonBar($bardef, "align");
	}
	include ('footer.php');
}

/**
 * Permet au client de rcuprer son identifiant et son son password.
 *
 * Ce dialogue permet au client de saisir son e-mail.
 * Si celui -ci est reconnu dans les comptes clients, son identifiant et son son password sont expdis.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function getIds($My_SQL,$vars_mod) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	echo $objetCatalog->get_Ids($My_SQL,$vars_mod);
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	/*$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print",
	 //"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	 //"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	 "top"=>"#top" );
	 buttonBar($bardef, "align");*/
	include ('footer.php');
}

/**
 * Permet au client de rcuprer son identifiant et son son password.
 *
 * Si les identifiants sont retrouvs, il sont expdis, sinon le formulaire de saisie d'e-mail est  nouveau propos.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function sendIds($My_SQL,$vars_mod) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	echo $objetCatalog->send_Ids($My_SQL,$vars_mod);
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	/*$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print",
	 //"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	 //"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	 "top"=>"#top" );
	 buttonBar($bardef, "align");*/
	include ('footer.php');
}

/**
 * Permet la cration d'un nouveau compte client.
 *
 * Ce dialogue permet au client de crer son compte client aprs avoir dcid de terminer la commande.
 * L'enregistrement de sa fiche client lui affichera le dialogue de confirmations de la commande.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @param array $new_client Tableau contenant les informations de la fiche client (vide pour cette fonction).
 */
function newClientCaddie($My_SQL,$vars_mod,$new_client) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	echo $objetCatalog->edit_client($My_SQL,$vars_mod,$new_client,"","","save_new_client_caddie");
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	/*$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print",
	 //"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	 //"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	 "top"=>"#top" );
	 buttonBar($bardef, "align");*/
	include ('footer.php');
}

/**
 * Permet la cration d'un nouveau compte client.
 *
 * Ce dialogue permet au client de crer son compte client.
 * L'enregistrement de sa fiche client lui affichera le dialogue de confirmations de la commande.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @param array $new_client Tableau contenant les informations de la fiche client (vide pour cette fonction).
 */
function newClient($My_SQL,$vars_mod,$new_client) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	echo $objetCatalog->edit_client($My_SQL,$vars_mod,$new_client,"","","save_new_client");
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	/*$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print",
	 //"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	 //"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	 "top"=>"#top" );
	 buttonBar($bardef, "align");*/
	include ('footer.php');
}

/**
 * Affiche le dialogue de confirmation de la commande.
 *
 * Ce dialogue permet au client de vrifier ses coordonnes, la liste des articles commands, le total de la commande et l'acceptation des CGV.
 * Si le client ne s'est pas encore identifi, un dialogue lui permet d'utiliser son compte existant ou de crer un nouveau compte.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @param array $clef Identifiant du client en cours : Id ou login/password.
 */
function getClientCaddie($My_SQL,$vars_mod,$clef) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	if ($objetCatalog->sgbd->exists_client($My_SQL,$clef)) {
		$_SESSION["id_s_client"] = $objetCatalog->sgbd->get_client_id($My_SQL,$clef);
		$_SESSION["nom_client"] = $objetCatalog->sgbd->get_client_identity($My_SQL,$_SESSION["id_s_client"]);
		echo $objetCatalog->affiche_client_caddie($My_SQL,$vars_mod,$clef);
		echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
		$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print_client_caddie",
		//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
		//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
		"top"=>"#top" );
		buttonBar($bardef, "align");
	}
	else {
		$erreur = _CATALOGClIENTBADPASS;
		echo $objetCatalog->set_client_caddie($My_SQL,$vars_mod,$erreur);
		echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	}

	include ('footer.php');
}

/**
 * Affiche les informations du compte client.
 *
 * Ce dialogue permet au client d'ouvrir son compte client et de vrifier ses coordonnes.
 * Cette fonction fixe galement le compte client en cours.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @param array $clef Identifiant du client en cours : Id ou login/password.
 */
function getClient($My_SQL,$vars_mod,$clef) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	if ($objetCatalog->sgbd->exists_client($My_SQL,$clef)) {
		$_SESSION["id_s_client"] = $objetCatalog->sgbd->get_client_id($My_SQL,$clef);
		$_SESSION["nom_client"] = $objetCatalog->sgbd->get_client_identity($My_SQL,$_SESSION["id_s_client"]);
		echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
		echo $objetCatalog->affiche_client_seul($My_SQL,$vars_mod,$clef);
	}
	else {
		$erreur = _CATALOGClIENTBADPASS;
		echo $objetCatalog->set_client($My_SQL,$vars_mod,$erreur);
	}
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print_client",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	"top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

/**
 * Affiche le dialogue de confirmation de la commande aprs cration d'un nouveau compte.
 *
 * Ce dialogue permet au client de vrifier ses coordonnes, la liste des articles commands, le total de la commande et l'acceptation des CGV.
 * Si le client ne s'est pas encore identifi, un dialogue lui permet d'utiliser son compte existant ou de crer un nouveau compte.
 * Un e-mail de confirmation de cration de compte est envoy au client si son adresse e-mail est valide.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @param array $new_client Tableau contenant les informations de la fiche client.
 */
function saveNewClientCaddie($My_SQL,$vars_mod,$new_client) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	if ($objetCatalog->save_client($My_SQL,$vars_mod,$new_client)) {
		$clef = array();
		$clef["Id"] = $objetCatalog->sgbd->getLastId($My_SQL);
		$clef["codeclient"] = "";
		$clef["passwd"] = "";
		$_SESSION["id_s_client"] = $clef["Id"];
		$_SESSION["nom_client"] = $objetCatalog->sgbd->get_client_identity($My_SQL,$_SESSION["id_s_client"]);
		echo $objetCatalog->confirm_client($My_SQL,$vars_mod,$clef,_CATALOGMESSAGESUBJECTNEWCLIENT,_CATALOGMESSAGENEWCLIENT);
		echo $objetCatalog->affiche_client_caddie($My_SQL,$vars_mod,$clef);
		echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
		$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print_client_caddie",
		//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
		//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
		"top"=>"#top" );
		buttonBar($bardef, "align");
	}
	else {
		//erreur : client non enregistr
		$erreur = _CATALOGClIENTBADSAVE;
		if ($objetCatalog->sgbd->exists_code($My_SQL,$new_client["codeclient"])) {
			$alertecode = _CATALOGClIENTBADCODE;
		}
		echo $objetCatalog->edit_client($My_SQL,$vars_mod,$new_client,$erreur,$alertecode);
		echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	}
	include ('footer.php');
}

/**
 * Enregistre le compte client.
 *
 * Si le compte est modifi, les modifications sont enregistres, sinon un nouveau compte est cr.
 * Un e-mail de confirmation de cration ou de modifcation de compte est envoy au client si son adresse e-mail est valide.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @param array $new_client Tableau contenant les informations de la fiche client.
 */
function saveNewClient($My_SQL,$vars_mod,$new_client) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	if ($objetCatalog->save_client($My_SQL,$vars_mod,$new_client)) {
		$clef = array();
		$clef["codeclient"] = "";
		$clef["passwd"] = "";
		if ($_SESSION["id_s_client"] != "") {
			$clef["Id"] = $_SESSION["id_s_client"];
			echo $objetCatalog->confirm_client($My_SQL,$vars_mod,$clef,_CATALOGMESSAGESUBJECTCHANGEDCLIENT,_CATALOGMESSAGECHANGEDCLIENT);
		}
		else {
			$clef["Id"] = $objetCatalog->sgbd->getLastId($My_SQL);
			echo $objetCatalog->confirm_client($My_SQL,$vars_mod,$clef,_CATALOGMESSAGESUBJECTNEWCLIENT,_CATALOGMESSAGENEWCLIENT);
		}
		$_SESSION["id_s_client"] = $clef["Id"];
		$_SESSION["nom_client"] = $objetCatalog->sgbd->get_client_identity($My_SQL,$_SESSION["id_s_client"]);
		echo $objetCatalog->affiche_client_seul($My_SQL,$vars_mod,$clef);
	}
	else {
		//erreur : client non enregistr
		$erreur = _CATALOGClIENTBADSAVE;
		if ($objetCatalog->sgbd->exists_code($My_SQL,$new_client["codeclient"])) {
			$alertecode = _CATALOGClIENTBADCODE;
		}
		echo $objetCatalog->edit_client($My_SQL,$vars_mod,$new_client,$erreur,$alertecode);
	}
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print_client",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	"top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

/**
 * Edite le compte client.
 *
 * Affiche le formulaire de modification d'un compte client existant.
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 * @param array $clef Identifiant du client en cours : Id ou login/password.
 */
function editClient($My_SQL,$vars_mod,$clef) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	$clef["Id"] = $_SESSION["id_s_client"];
	$clef["codeclient"] = "";
	$clef["passwd"] = "";
	if ($objetCatalog->sgbd->exists_client($My_SQL,$clef)) {
		$new_client = $objetCatalog->sgbd->getClient($My_SQL,$clef);
		echo $objetCatalog->edit_client($My_SQL,$vars_mod,$new_client,$erreur,$alertecode,$operation="save_new_client");
	}
	else {
		echo "Erreur : client introuvable";
	}
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print_client",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	"top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

/**
 * Enregistre une commande  partir du caddie, aprs confirmation.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function saveCommande($My_SQL,$vars_mod) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	$clef = array();
	$clef["Id"] = $_SESSION["id_s_client"];
	$clef["codeclient"] = "";
	$clef["passwd"] = "";
	$new_commande= $objetCatalog->caddie_to_commande($My_SQL,$vars_mod,$clef);
	echo $objetCatalog->save_commande($My_SQL,$vars_mod,$new_commande);
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	/*$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print",
	 //"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	 //"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	 "top"=>"#top" );
	 buttonBar($bardef, "align");*/
	include ('footer.php');
}

/**
 * Affiche la confirmation qu'une commande est enregistre, aprs paiement assynchrone.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function commandPaid($My_SQL,$vars_mod) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	echo $objetCatalog->paiment_accepted($My_SQL,$vars_mod);
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	/*$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print",
	 //"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	 //"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	 "top"=>"#top" );
	 buttonBar($bardef, "align");*/
	include ('footer.php');
}

/**
 * Enregistre une commande  partir du caddie, aprs confirmation.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function goToPay($My_SQL,$vars_mod) {
	/*header("Status: 301 Moved Permanently");
	 header("Location: /cgibin/modulev2.cgi");
	 exit();*/
	$sortie = '<html>
		<head>
			<title> </title>
		</head>
		<body onload="document.formulaire.submit()">
		<form name="formulaire" method="post" action= "/cgibin/modulev2.cgi">
		<INPUT TYPE="hidden" NAME="PBX_MODE" VALUE="13">
		<INPUT TYPE="hidden" NAME="PBX_TOTAL" VALUE="'.$_SESSION["paie-total"].'">
		<INPUT TYPE="hidden" NAME="PBX_CMD" VALUE="'.$_SESSION["paie-refcomm"].'">
		<INPUT TYPE="hidden" NAME="PBX_PORTEUR" VALUE="'.$_SESSION["paie-porteur"].'">
		<INPUT TYPE="hidden" NAME="PBX_TXT" VALUE=" ">
		<INPUT TYPE="hidden" NAME="PBX_LANGUE" VALUE="FRA">
		<INPUT TYPE="hidden" NAME="PBX_OPT" VALUE="./PARAMS.TXT">
		</form>
		</body>
	</html>';
	echo $sortie;
}

/**
 * Enregistre une commande  partir du caddie, aprs confirmation.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function goToPaypal($My_SQL,$vars_mod) {
	global $vars_mail, $Default_Theme;
	
	$objetDB = new BD_Catalog();
	if ($objetDB->saveCommandeTemp($My_SQL)) {
		$sortie = '<html>
			<head>
				<title> </title>
				<link rel="stylesheet" href="themes/'.$Default_Theme.'/style/style.css" type="text/css">
			</head>
			<body onload="document.formulaire.submit()">
			<div align="center"><p style="width: 400px">'._PAYPALWAIT.'<br></p>
			<form action="https://www.paypal.com/cgi-bin/webscr" method="post" name="formulaire">
	<!--<form action="https://www.sandbox.paypal.com/cgi-bin/webscr" method="post" name="formulaire">-->
			<input type="hidden" name="cmd" value="_xclick">
			<input type="hidden" name="business" value="'.$vars_mail["from"].'">
	<!--<input type="hidden" name="business" value="webmaster@arobase.fr">-->
			<input type="hidden" name="item_name" value="'._PAYPALTOTALOBJ.'">
			<input type="hidden" name="amount" value="'.($_SESSION["paie-total"]/100).'">
			<input type="hidden" name="cancel_return" value="http://www.toutpourlui.eu/modules.php?name=SimpleCatalog&sop=paiement_canceled">
			<input type="hidden" name="no_note" value="1">
			<input type="hidden" name="no_shipping" value="1">
			<input type="hidden" name="return" value="http://www.toutpourlui.eu/modules/SimpleCatalog/paypal_return.php">
			<input type="hidden" name="rm" value="1">
			<input type="hidden" name="currency_code" value="EUR">
			<input type="hidden" name="invoice" value="'.$_SESSION["paie-refcomm"].'">
			<input type="hidden" name="upload" value="1">
			<input type="submit" value="PayPal">
			</form>
			</div>
			</body>
		</html>';
	}
	else {
		$sortie = '<html>
		<head>
			<title> </title>
			<link rel="stylesheet" href="themes/'.$Default_Theme.'/style/style.css" type="text/css">
		</head>
		<body>
		<div align="center"><p>Erreur !</p></div>
		</body>
		</html>';
	}
	echo $sortie;
}



/**
 * Enregistre un fichier texte et le cre s'il n'existe pas.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */

function writeOneFile($nom, $contenu) {
	$ok = true;
	if (file_exists($nom)) {
		if (is_writable($nom)) {
			$ok = true;
		}
		else {
			$ok = false;
		}
	}
	else {
		$ok = true;
	}
	$sortie = $ok;
	if ($ok) {
		if (!$handle = fopen($nom, 'w')) {
			$sortie = false;
		}
		else {
			if (fwrite($handle, $contenu,strlen($contenu)) === false) {
				$sortie = false;
			}
			else {
				$sortie = true;
				fclose($handle);
			}
		}
	}
	else {
		$sortie = false;
	}
	return $sortie;
}

/**
 * Affiche un avertissement aprs le refus de paiement de la banque.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function refusePaiment($My_SQL,$vars_mod) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	echo $objetCatalog->paiment_refused($My_SQL,$vars_mod);
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print_list_article",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	"top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

/**
 * Affiche un avertissement aprs l'annulation du paiement par le client.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function cancelPaiment($My_SQL,$vars_mod) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	echo $objetCatalog->paiment_canceled($My_SQL,$vars_mod);
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print_list_article",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	"top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

/**
 * Affiche toutes les commandes du client en cours.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function displayAllCommands($My_SQL,$vars_mod) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	echo $objetCatalog->display_all_commands($My_SQL,$vars_mod);
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=print_all_commands",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	"top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}

/**
 * Affiche les dtail d'une commandes du client en cours.
 *
 * @param array $My_SQL Paramtres de la base de donnes
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
 */
function displayOneCommand($My_SQL,$vars_mod) {
	$objetCatalog = new displayCatalog();
	include ('header.php');
	echo $objetCatalog->display_identity_client($vars_mod,$_SESSION["nom_client"]);
	echo $objetCatalog->display_one_command($My_SQL,$vars_mod);
	echo $objetCatalog->catalog_bar($My_SQL,$vars_mod);
	$bardef=array("print"=>"modules.php?".$objetCatalog->getVars("sop")."&sop=printonecommand",
	//"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	//"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid",
	"top"=>"#top" );
	buttonBar($bardef, "align");
	include ('footer.php');
}



/**
 * Renvoie l'en-tte et le pied de page pour tout document  imprimer du module SimpleCatalog.
 *
 * Le commentaire <!--contenu--> est  remplacer par le vritable contenu  imprimer.
 * @param array $My_SQL Paramtres de la base de donnes.
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
 * @param string $sop type du document  imprimer.
 * @return string Code HTML de l'en-tte et du pied de page.
 */
function printheadbottom($My_SQL,$vars_mod) {
	global $site_logo,$Default_Theme, $nukeurl, $sitename, $module_name;

	$tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}

	if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
		$stylecarto = '		<link href="themes/'.get_theme().'/style/'.$module_name.'.css" rel="stylesheet" type="text/css" media="all"/>
		';
	}
	else {
		$stylecarto = '		<link href="'.$vars_mod["cheminModule"].'lib/style-catalog.css" rel="stylesheet" type="text/css" media="all"/>
		';
	}

	$contenu = "
    <html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:v=\"urn:schemas-microsoft-com:vml\">
    <head>
    <title>$sitename</title>
    <META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=ISO-8859-1\">\n
    <LINK REL=\"StyleSheet\" HREF=\"themes/$Default_Theme/style/style.css\" TYPE=\"text/css\">\n
	".$stylecarto."
	</head>
    <body bgcolor=\"#FFFFFF\" text=\"#000000\">
    <table border=\"0\"><tr><td>
    <table border=\"0\" width=\"650\" cellpadding=\"0\" cellspacing=\"1\" bgcolor=\"#000000\"><tr><td>
    <table border=\"0\" width=\"650\" cellpadding=\"20\" cellspacing=\"1\" bgcolor=\"#FFFFFF\"><tr><td>
    <div class=\"printHeader\"><img src=\"images/$site_logo\" border=\"0\" alt=\"\"><span class=\"title\">$title_section</span></div>
    <div class=\"zprint\">
    <!--contenuprint-->
    </div>
    </td></tr></table></td></tr></table>
    
    <div class=\"printFooter\">
    <div class=\"siteName\">
    "._COMESFROM." $sitename<br>
    <a href=\"$racine\">$racine</a>
    </div>
    <div class=\"pageURL\">
    "._THEURL."<br>
    <a href=\"$racine/modules.php?name=SimpleCarto&sop=printMap&amp;".$vars_mod["id_carte"]."=".$vars_mod[$vars_mod["id_carte"]]."\">$racine/modules.php?name=SimpleCarto&sop=printMap&amp;".$vars_mod["id_carte"]."=".$vars_mod[$vars_mod["id_carte"]]."</a>
    </div>
    </div>
    </td></tr></table>
    </body>
    </html>
    ";

	return $contenu;
}

/**
 * Imprime le contenu d'une commande.
 *
 * @param array $My_SQL Paramtres de la base de donnes.
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
 */
function printOneCommand($My_SQL,$vars_mod) {
	$sortie = printheadbottom($My_SQL,$vars_mod);
	$objetCatalog = new displayCatalog();
	$contenu = $objetCatalog->display_one_command($My_SQL,$vars_mod);
	$sortie = str_replace("<!--contenuprint-->", $contenu, $sortie);
	echo $sortie;
}

/**
 * Imprime le lmisting des commandes.
 *
 * @param array $My_SQL Paramtres de la base de donnes.
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
 */
function printAllCommands($My_SQL,$vars_mod) {
	$sortie = printheadbottom($My_SQL,$vars_mod);
	$objetCatalog = new displayCatalog();
	$contenu = $objetCatalog->display_all_commands($My_SQL,$vars_mod);;
	$sortie = str_replace("<!--contenuprint-->", $contenu, $sortie);
	echo $sortie;
}

/**
 * Imprime le dtail d'un article.
 *
 * @param array $My_SQL Paramtres de la base de donnes.
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
 * @param array $criteres Tableau contenant les paramtres de recherche et d'affichage des articles
 */
function printOneArticle($My_SQL,$vars_mod,$criteres) {
	$sortie = printheadbottom($My_SQL,$vars_mod);
	$objetCatalog = new displayCatalog();
	$contenu = $objetCatalog->get_one_article($My_SQL,$vars_mod,$criteres);
	$sortie = str_replace("<!--contenuprint-->", $contenu, $sortie);
	echo $sortie;
}

/**
 * Imprime le listing des articles trouvs.
 *
 * @param array $My_SQL Paramtres de la base de donnes.
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
 * @param array $criteres Tableau contenant les paramtres de recherche et d'affichage des articles
 */
function printListArticle($My_SQL,$vars_mod,$criteres) {
	$sortie = printheadbottom($My_SQL,$vars_mod);
	$objetCatalog = new displayCatalog();
	$contenu = $objetCatalog->get_list_articles($My_SQL,$vars_mod,$criteres);;
	$sortie = str_replace("<!--contenuprint-->", $contenu, $sortie);
	echo $sortie;
}

/**
 * Imprime le contenu du caddie.
 *
 * @param array $My_SQL Paramtres de la base de donnes.
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
 * @param string $new_caddie Chaine de caractres contenant le nouveau caddie.
 */
function printCaddie($My_SQL,$vars_mod,$new_caddie) {
	$sortie = printheadbottom($My_SQL,$vars_mod);
	$objetCatalog = new displayCatalog();
	$contenu = $objetCatalog->display_caddie($My_SQL,$vars_mod,$new_caddie);
	$sortie = str_replace("<!--contenuprint-->", $contenu, $sortie);
	echo $sortie;
}

/**
 * Imprime les paramtres du compte d'un client.
 *
 * @param array $My_SQL Paramtres de la base de donnes.
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
 * @param array $clef Identifiant du client en cours : Id ou login/password.
 */
function printClient($My_SQL,$vars_mod,$clef) {
	$sortie = printheadbottom($My_SQL,$vars_mod);
	$objetCatalog = new displayCatalog();
	$clef["Id"] = $_SESSION["id_s_client"];
	$clef["codeclient"] = "";
	$clef["passwd"] = "";
	$contenu = $objetCatalog->affiche_client($My_SQL,$vars_mod,$clef);
	$sortie = str_replace("<!--contenuprint-->", $contenu, $sortie);
	echo $sortie;
}

/**
 * Imprime la commande en cours.
 *
 * @param array $My_SQL Paramtres de la base de donnes.
 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
 */
function printClientCaddie($My_SQL,$vars_mod) {
	$sortie = printheadbottom($My_SQL,$vars_mod);
	$objetCatalog = new displayCatalog();
	$clef = array();
	$clef["Id"] = $_SESSION["id_s_client"];
	$clef["codeclient"] = "";
	$clef["passwd"] = "";
	$contenu = $objetCatalog->affiche_client_caddie($My_SQL,$vars_mod,$clef);
	$sortie = str_replace("<!--contenuprint-->", $contenu, $sortie);
	echo $sortie;
}

/**
 * Appel des fonctions en fonction du paramtre $sop.
 */
switch($sop) {
	case "display":
		displayListArticles($My_SQL,$vars_mod,$crit_find_article);
		break;
	case "display_grid":
		displayGridArticles($My_SQL,$vars_mod,$crit_find_article);
		break;
	case "print_list_article":
		printListArticle($My_SQL,$vars_mod,$crit_find_article);
		break;
	case "display_article":
		displayArticle($My_SQL,$vars_mod,$crit_find_article);
		break;
	case "print_article":
		printOneArticle($My_SQL,$vars_mod,$crit_find_article);
		break;
	case "add_caddie":
		addCaddie($My_SQL,$vars_mod,$new_line_caddie);
		break;
	case "update_caddie":
		updateCaddie($My_SQL,$vars_mod,$new_caddie);
		break;
	case "display_caddie":
		displayCaddie($My_SQL,$vars_mod,$new_caddie);
		break;
	case "print_caddie":
		printCaddie($My_SQL,$vars_mod,$new_caddie);
		break;
	case "set_client_caddie":
		setClientCaddie($My_SQL,$vars_mod);
		break;
	case "set_client":
		setClient($My_SQL,$vars_mod);
		break;
	case "new_client":
		newClient($My_SQL,$vars_mod,$new_client);
		break;
	case "new_client_caddie":
		newClientCaddie($My_SQL,$vars_mod,$new_client);
		break;
	case "save_new_client_caddie":
		saveNewClientCaddie($My_SQL,$vars_mod,$new_client);
		break;
	case "save_new_client":
		saveNewClient($My_SQL,$vars_mod,$new_client);
		break;
	case "get_client_caddie":
		getClientCaddie($My_SQL,$vars_mod,$clef);
		break;
	case "get_client":
		getClient($My_SQL,$vars_mod,$clef);
		break;
	case "edit_client":
		editClient($My_SQL,$vars_mod,$clef);
		break;
	case "close_client":
		closeClient($My_SQL,$vars_mod,$crit_find_article);
		break;
	case "print_client":
		printClient($My_SQL,$vars_mod,$clef);
		break;
	case "get_ids":
		getIds($My_SQL,$vars_mod);
		break;
	case "send_ids":
		sendIds($My_SQL,$vars_mod);
		break;
	case "command_paid":
		saveCommande($My_SQL,$vars_mod);
		break;
	case "go_to_pay":
		goToPay($My_SQL,$vars_mod);
		break;
	case "go_to_paypal":
		goToPaypal($My_SQL,$vars_mod);
		break;
	case "command_paid_paypal":
		commandPaid($My_SQL,$vars_mod);
		break;
	case "paiement_refused":
		refusePaiment($My_SQL,$vars_mod);
		break;
	case "paiement_canceled":
		cancelPaiment($My_SQL,$vars_mod);
		break;
	case "direct_from_bank":
		break;
	case "display_all_commands":
		displayAllCommands($My_SQL,$vars_mod);
		break;
	case "print_all_commands":
		printAllCommands($My_SQL,$vars_mod);
		break;
	case "display_one_command":
		displayOneCommand($My_SQL,$vars_mod);
		break;
	case "printonecommand":
		printonecommand($My_SQL,$vars_mod,$keymap);
		break;
	case "print_client_caddie":
		printClientCaddie($My_SQL,$vars_mod);
		break;
	  
	default:
		displayListArticles($My_SQL,$vars_mod,$crit_find_article);
		break;
}

session_write_close();

?>