<?php
/**
* Fichier qui fabrique une image en fonction des paramtres d'entre.
* 
* Cela permet de raliser des petits textes sous forme d'images  inclure dans le fonds de carte
* Les paramtres reus dans l'URL sont :
* - $p : police de caractre  utiliser. Toutes les polices TrueType sont  priori valides
* - $s : taille du texte en pixels
* - $c : couleur en hexadecimal
* - $a : angle d'orientation du texte en degrs
* - $t : texte  afficher
* 
* @package becmsSimpleCarto 
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2006, Vincent RUIZ
* @version 0.1
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*/

require("g_params.php");
require("ba_admincarto.php");

foreach($_GET as $key=>$value) {
	$$key = $value;
}

$objetCarte = new adminCartos();

if (!isset($s)) {
	$s = "8";
}
if (!isset($c)) {
	$c = "#FF0000";
}
list($c_r,$c_v,$c_b) = $objetCarte->html2rgb($c);
if (!isset($t)) {
	$t = "Aucun texte !";
}
$t = str_replace("\'","'",$t);
if (!isset($a)) {
	$a = "0";
}
if (!isset($marge)) {
	$marge = "2";
}
if (!isset($p)) {
	$p="fonts/arial.ttf";
}
else {
	$chemsFontes = explode("/",$p);
	$p = $chemsFontes[count($chemsFontes)-2]."/".$chemsFontes[count($chemsFontes)-1];
}
$p = realpath($p);

//coordonnes du rectangle contenant le texte
$boiteTexte = imageftbbox ($s, $a, $p, $t,array("linespacing" => 1.0));
//$boiteTexte = imagettfbbox ($s, $a, $p, $t);
$gauche = min($boiteTexte[0],$boiteTexte[2],$boiteTexte[4],$boiteTexte[6]);
$haut = min($boiteTexte[1],$boiteTexte[3],$boiteTexte[5],$boiteTexte[7]);
$droite = max($boiteTexte[0],$boiteTexte[2],$boiteTexte[4],$boiteTexte[6]);
$bas = max($boiteTexte[1],$boiteTexte[3],$boiteTexte[5],$boiteTexte[7]);
//dimensions de l'image
$largeur = $droite - $gauche;
$hauteur = $bas - $haut;
//calcul de la hauteur de texte et du point d'origine du texte
$x0 = $boiteTexte[6] - $gauche + $s * sin($a*pi()/180.0);
$y0 = $boiteTexte[7] - $haut + $s * cos($a*pi()/180.0);
//cration image
$image = imagecreatetruecolor($largeur+($marge*2),$hauteur+($marge*2));
$back = imagecolorallocate($image, 237, 234, 226);
//$couleur = imagecolorallocate($image, 0, 155, 241);
$couleur = imagecolorallocate($image, $c_r,$c_v,$c_b);
$ombre = imagecolorallocate($image, 184, 182, 175);

$blanc = imagecolorallocate($image, 255, 255, 255);
$noir = imagecolorallocate($image, 0, 0, 0);
$blanc_fond = imagecolorallocate($image, 61, 92, 41);

/*$encadrement = $boiteTexte;
$encadrement[0] -= $gauche-$marge;
$encadrement[2] -= $gauche-$marge;
$encadrement[4] -= $gauche-$marge;
$encadrement[6] -= $gauche-$marge;
$encadrement[1] -= $haut-$marge;
$encadrement[3] -= $haut-$marge;
$encadrement[5] -= $haut-$marge;
$encadrement[7] -= $haut-$marge;

//imagesetthickness($image, 4);
imagepolygon($image, $encadrement, 4, $ombre);*/
if ($m == "P") {
	imagefill($image, 0, 0, $back);
	imagefttext($image, $s, $a, $x0+$marge+1, $y0+$marge+1, $ombre, $p, $t, array("linespacing" => 1.0));
	imagefttext ($image, $s, $a, $x0+$marge, $y0+$marge, $couleur, $p, $t, array("linespacing" => 1.0));
	imagecolortransparent($image,$back);
}
else {
	imagefill($image, 0, 0, $blanc_fond);
	imagefttext($image, $s, $a, $x0+$marge+1, $y0+$marge+1, $blanc, $p, $t, array("linespacing" => 1.0));
	imagefttext($image, $s, $a, $x0+$marge+1, $y0+$marge-1, $blanc, $p, $t, array("linespacing" => 1.0));
	imagefttext($image, $s, $a, $x0+$marge-1, $y0+$marge+1, $blanc, $p, $t, array("linespacing" => 1.0));
	imagefttext($image, $s, $a, $x0+$marge-1, $y0+$marge-1, $blanc, $p, $t, array("linespacing" => 1.0));
	//imagefttext($image, $s, $a, $x0+$marge+2, $y0+$marge+1, $blanc, $p, $t, array("linespacing" => 1.0));
	//imagefttext($image, $s, $a, $x0+$marge+2, $y0+$marge-1, $blanc, $p, $t, array("linespacing" => 1.0));
	//imagefttext($image, $s, $a, $x0+$marge-2, $y0+$marge+1, $blanc, $p, $t, array("linespacing" => 1.0));
	//imagefttext($image, $s, $a, $x0+$marge-2, $y0+$marge-1, $blanc, $p, $t, array("linespacing" => 1.0));
	imagefttext ($image, $s, $a, $x0+$marge, $y0+$marge, $noir, $p, $t, array("linespacing" => 1.0));
	imagecolortransparent($image,$blanc_fond);
}
//imagettftext($image, $s, $a, 0+$marge+1, $s+$marge+1, $ombre, $p, $t);
//imagettftext($image, $s, $a, 0+$marge, $s+$marge, $couleur, $p, $t);




//imagefilter($image,IMG_FILTER_EMBOSS);

imagetruecolortopalette($image, true, 256);
imageinterlace($image);
header("content-type: image/gif");
imagegif($image);

ImageDestroy($image);
?>