//Encode point
function encodeSignedNumber(num) {
  var sgn_num = num << 1;

  if (num < 0) {
    sgn_num = ~(sgn_num);
  }

  return(encodeNumber(sgn_num));
}
function encodeNumber(num) {
  var encodeString = "";

  while (num >= 0x20) {
    encodeString += (String.fromCharCode((0x20 | (num & 0x1f)) + 63));
    num >>= 5;
  }

  encodeString += (String.fromCharCode(num + 63));
  return encodeString;
}
function createEncodings(points) {
  var i = 0;
  var plat = 0;
  var plng = 0;
  var encoded_points = "";

  for(i = 0; i < points.length; ++i) {
    var point = points[i];
    var lat = point.lat();
    var lng = point.lng();

    var late5 = Math.floor(lat * 1e5);
    var lnge5 = Math.floor(lng * 1e5);

    dlat = late5 - plat;
    dlng = lnge5 - plng;

    plat = late5;
    plng = lnge5;

    encoded_points += encodeSignedNumber(dlat) + encodeSignedNumber(dlng);
  } 
  return encoded_points;
}
//Decode points
function decodeLine(encoded) {
    var len = encoded.length;
    var index = 0;
    var array = [];
    var lat = 0;
    var lng = 0;
    try
    {
        while (index < len) {
            var b;
            var shift = 0;
            var result = 0;
            do {
                  b = encoded.charCodeAt(index++) - 63;
                  result |= (b & 0x1f) << shift;
                  shift += 5;
            } while (b >= 0x20);
            var dlat = ((result & 1) ? ~(result >> 1) : (result >> 1));
            lat += dlat;

            shift = 0;
            result = 0;
            do {
                  b = encoded.charCodeAt(index++) - 63;
                  result |= (b & 0x1f) << shift;
                  shift += 5;
            } while (b >= 0x20);
            var dlng = ((result & 1) ? ~(result >> 1) : (result >> 1));
            lng += dlng;

            array.push(new GLatLng((lat * 1e-5), (lng * 1e-5)));
        }
    } catch(ex)
    {
        //error in encoding.
    }
    return array;
}
//Manage points
function supprimer() {
	//document.getpoly.liste_points.options[document.getpoly.liste_points.selectedIndex]=null;
}
 
function getCoords(marqueur) {
	if (marqueur == null) {
		alert("Aucun point � m�moriser");
		return false;
	}
	else {
		var lepoint = marqueur.getLatLng();
		var valeur = lepoint.lat()+" "+lepoint.lng();
		document.formfiche.listlatlong.options[document.formfiche.listlatlong.length]=new Option(valeur, valeur);
		var tabpoints = [];
		var visibilitepoly = "";
		for(var i=0; i<document.formfiche.listlatlong.length;i++){
			tablatlong = document.formfiche.listlatlong.options[i].value.split(" ");
			tabpoints.push(new GLatLng((tablatlong[0]), (tablatlong[1])));
			visibilitepoly += "?";
		}
		document.formfiche.polyencode.value = createEncodings(tabpoints);
		document.formfiche.polyvisible.value = visibilitepoly;
		return true;
	}
}

function supprCoords(marqueur) {
	if (marqueur == null) {
		alert("Erreur : Aucun point � supprimer !");
		return false;
	}
	else {
		var lepoint = marqueur.getLatLng();
		for(var i=0; i<document.formfiche.listlatlong.length;i++){
			tablatlong = document.formfiche.listlatlong.options[i].value.split(" ");
			if ((tablatlong[0] == lepoint.lat()) && (tablatlong[1] == lepoint.lng())) {
				document.formfiche.listlatlong.options[i] = null;
				i--;
			}
		}
		var tabpoints = [];
		var visibilitepoly = "";
		for(var i=0; i<document.formfiche.listlatlong.length;i++){
			tablatlong = document.formfiche.listlatlong.options[i].value.split(" ");
			tabpoints.push(new GLatLng((tablatlong[0]), (tablatlong[1])));
			visibilitepoly += "?";
		}
		document.formfiche.polyencode.value = createEncodings(tabpoints);
		document.formfiche.polyvisible.value = visibilitepoly;
		return true;
	}
}

function deplace_point(coords_start_drag,coords_end_drag) {
	for(var i=0; i<document.formfiche.listlatlong.length;i++){
		coordsencours = document.formfiche.listlatlong.options[i].value;
		if (coords_start_drag == coordsencours) {
			document.formfiche.listlatlong.options[i].text = coords_end_drag;
			document.formfiche.listlatlong.options[i].value = coords_end_drag;
		}
	}
	var tabpoints = [];
	for(var i=0; i<document.formfiche.listlatlong.length;i++){
		tablatlong = document.formfiche.listlatlong.options[i].value.split(" ");
		tabpoints.push(new GLatLng((tablatlong[0]), (tablatlong[1])));
	}
	document.formfiche.polyencode.value = createEncodings(tabpoints);
}

function moyenne_poly() {
	var latMin = eval(document.formfiche.listlatlong.options[0].value.split(" ")[0]);
	var latMax = eval(document.formfiche.listlatlong.options[0].value.split(" ")[1]);
	var lngMin = eval(document.formfiche.listlatlong.options[0].value.split(" ")[0]);
	var lngMax = eval(document.formfiche.listlatlong.options[0].value.split(" ")[1]);
	var latencours = "";
	var lngencours = "";
	for(var i=0; i<document.formfiche.listlatlong.length;i++){
		tablatlong = document.formfiche.listlatlong.options[i].value.split(" ");
		latencours = eval(tablatlong[0]);
		lngencours = eval(tablatlong[1]);
		if (latencours < latMin) {
			latMin = latencours;
		}
		if (latencours > latMax) {
			latMax = latencours;
		}
		if (lngencours < lngMin) {
			lngMin = lngencours;
		}
		if (lngencours > lngMax) {
			lngMax = lngencours;
		}
	}
	var lat_moyen = eval(latMin+latMax)/2;
	var lng_moyen = eval(lngMin+lngMax)/2;
	var point_moyen = new GLatLng(lat_moyen, lng_moyen); 
	return point_moyen;
}

function return_poly() {
	if (confirm("�tes-vous s�r de vouloir valider ce trac� ?")) {
		if (window.opener != null) {
			window.opener.document.formfiche.bordure.value = document.formfiche.polyencode.value;
			var visible_prim = document.formfiche.polyvisible.value;
			var visible_out = "";
			var niveau = "A";
			for (var i=1;i<visible_prim.length;i++) {
				visible_out += niveau;
				//niveau = (niveau=="A")?"@":"A";
				niveau = (niveau=="A")?"A":"A";
			}
			visible_out += "A";
			window.opener.document.formfiche.b_visibilite.value = visible_out;
			/*
			var tab_latlong = moyenne_poly();
			if (window.opener.document.formfiche.latitude != null && window.opener.document.formfiche.longitude != null) {
				window.opener.document.formfiche.latitude.value = tab_latlong.lat();
				window.opener.document.formfiche.longitude.value = tab_latlong.lng();
			}
			*/
			if (ie) {
				var objCouleurBout = window.opener.document.all["pick1101735856"];
			}
			else {
				var objCouleurBout = window.opener.document.getElementById("pick1101735856");
			}
			objCouleurBout.style.backgroundColor = document.polyfiche.b_couleur.value;
			window.opener.document.formfiche.b_couleur.value = document.polyfiche.b_couleur.value;
			window.opener.document.formfiche.b_epaisseur.value = document.polyfiche.b_epaisseur.value;
			window.opener.document.formfiche.b_opacite.value = document.polyfiche.b_opacite.value;
			
			window.opener.bordureCEdit = document.formfiche.polyencode.value;
			window.opener.visibiliteCEdit = visible_out;
			window.opener.couleurCEdit = document.polyfiche.b_couleur.value;
			window.opener.epaisseurCEdit = document.polyfiche.b_epaisseur.value;
			window.opener.opaciteCEdit = document.polyfiche.b_opacite.value;
			window.opener.afficherCBordure();

			window.close();
		}
	}
}

var map = null;
var montrace = null;
var icon_normal = null;
var coords_start_drag = "";
var coords_end_drag = "";
if (window.opener != null && window.opener.document.formfiche.b_epaisseur.value != "" && window.opener.document.formfiche.b_epaisseur.value != "0" && window.opener.document.formfiche.b_opacite.value != "" && window.opener.document.formfiche.b_opacite.value != "0" && window.opener.document.formfiche.b_couleur.value != "" ) {
	var couleur_poly = window.opener.document.formfiche.b_couleur.value;
	var epaisseur_poly = window.opener.document.formfiche.b_epaisseur.value;
	var opacite_poly = window.opener.document.formfiche.b_opacite.value;
}
else {
	var couleur_poly = "#FF0000";
	var epaisseur_poly = "3";
	var opacite_poly = "1.0";
}

function initForm () {
	if (ie) {
		var objCouleurBout = document.all["pick1101735856"];
	}
	else {
		var objCouleurBout = document.getElementById("pick1101735856");
	}
	objCouleurBout.style.backgroundColor = couleur_poly;
	document.polyfiche.b_couleur.value = couleur_poly;
	document.polyfiche.b_epaisseur.value = epaisseur_poly;
	document.polyfiche.b_opacite.value = opacite_poly;
}

function Gload() {
	//v�rification de l'existence du div de la carte
	var ie = false;
	if (document.all) {
		ie = true;
	}
	if (ie) {
		var objMenu = document.all["map"];
	}
	else {
		var objMenu = document.getElementById("map");
	}
	if (objMenu == null) {
		return false;
	}
		
    //traitements cartos
	if (GBrowserIsCompatible()) {
		var latitudeinit = "42.30162";
        var longitudeinit = "9.15847334655762";
        var zoominit = 13;
        var typecarte = G_NORMAL_MAP;
        if (window.opener != null) {
	        	var latlonginit = window.opener.map.getCenter();
	        	latitudeinit = latlonginit.lat();
	        	longitudeinit = latlonginit.lng();
	        zoominit = 	window.opener.map.getZoom();
	        typecarte = 	window.opener.map.getCurrentMapType();
        }
        
        map = new GMap2(document.getElementById("map"));
        map.addControl(new GMapTypeControl());
		map.addControl(new GLargeMapControl());
        map.addControl(new GScaleControl()) ;
        map.addControl(new GOverviewMapControl()) ;
        map.setCenter(new GLatLng(latitudeinit, longitudeinit), zoominit, typecarte);
        
        var MapDiv = document.getElementById("map");
		var CopyrightDiv = MapDiv.firstChild.nextSibling;
		var CopyrightImg = MapDiv.firstChild.nextSibling.nextSibling;
		CopyrightDiv.style.display = "none"; 
		CopyrightImg.style.display = "none";
        /*
		//ajout bouton de fermeture du polygone
		function JoinPolygone() {
		}
		JoinPolygone.prototype = new GControl();
		JoinPolygone.prototype.initialize = function(map) {
		  	var container = document.createElement("div");
		
			var zoomInDiv = document.createElement("div");
			this.setButtonStyle_(zoomInDiv);
			container.appendChild(zoomInDiv);
			//zoomInDiv.appendChild(document.createTextNode("Zoom in"));
			image = document.createElement('img');
			image.src = "icns/join.gif";
			image.title = "Fermer le trac�";
			zoomInDiv.appendChild(image);
			GEvent.addDomListener(zoomInDiv, "click", function() {
		   		//window.print();
		   		join_poly();
			});
			map.getContainer().appendChild(container);
			return container;
		}
		
		JoinPolygone.prototype.getDefaultPosition = function() {
		  return new GControlPosition(G_ANCHOR_TOP_LEFT, new GSize(24, 290));
		}
		
		// Sets the proper CSS for the given button element.
		JoinPolygone.prototype.setButtonStyle_ = function(button) {
			button.style.textDecoration = "none";
			button.style.lineHeight = "12px";
			button.style.color = "#0000cc";
			button.style.backgroundColor = "white";
			//button.style.font = "small Arial";
			button.style.border = "1px solid black";
			button.style.padding = "2px";
			button.style.marginBottom = "3px";
			button.style.textAlign = "center";
			//button.style.width = "6em";
			button.style.cursor = "pointer";
		}
		map.addControl(new JoinPolygone());
		//fin bouton
		
		//ajout bouton de validation de polygone
		function ValidPolygone() {
		}
		ValidPolygone.prototype = new GControl();
		ValidPolygone.prototype.initialize = function(map) {
		  	var container = document.createElement("div");
		
			var zoomInDiv = document.createElement("div");
			this.setButtonStyle_(zoomInDiv);
			container.appendChild(zoomInDiv);
			//zoomInDiv.appendChild(document.createTextNode("Zoom in"));
			image = document.createElement('img');
			image.src = "icns/valid.gif";
			image.title = "Enregistrer le trac�";
			zoomInDiv.appendChild(image);
			GEvent.addDomListener(zoomInDiv, "click", function() {
		   		return_poly();
			});
			map.getContainer().appendChild(container);
			return container;
		}
		
		ValidPolygone.prototype.getDefaultPosition = function() {
		  return new GControlPosition(G_ANCHOR_TOP_LEFT, new GSize(24, 320));
		}
		
		// Sets the proper CSS for the given button element.
		ValidPolygone.prototype.setButtonStyle_ = function(button) {
			button.style.textDecoration = "none";
			button.style.lineHeight = "12px";
			button.style.color = "#0000cc";
			button.style.backgroundColor = "white";
			//button.style.font = "small Arial";
			button.style.border = "1px solid black";
			button.style.padding = "2px";
			button.style.marginBottom = "3px";
			button.style.textAlign = "center";
			//button.style.width = "6em";
			button.style.cursor = "pointer";
		}
		map.addControl(new ValidPolygone());
		//fin bouton
		*/
		icon_normal = new GIcon();
		icon_normal.image = "http://labs.google.com/ridefinder/images/mm_20_red.png";
        icon_normal.shadow = "http://labs.google.com/ridefinder/images/mm_20_shadow.png";
        icon_normal.iconSize = new GSize(12, 20);
        icon_normal.shadowSize = new GSize(22, 20);
        icon_normal.iconAnchor = new GPoint(6, 20);
        
        var icon_first = new GIcon();
		icon_first.image = "http://labs.google.com/ridefinder/images/mm_20_blue.png";
        icon_first.shadow = "http://labs.google.com/ridefinder/images/mm_20_shadow.png";
        icon_first.iconSize = new GSize(12, 20);
        icon_first.shadowSize = new GSize(22, 20);
        icon_first.iconAnchor = new GPoint(6, 20);

		
		GEvent.addListener(map, "click", function(marker, point) {
			if (marker) {
				if (confirm("�tes-vous s�r de vouloir supprimer ce point ?")) {
					map.removeOverlay(marker);
					if (supprCoords(marker)) {
						afficherPolygone(document.formfiche.polyencode.value,document.formfiche.polyvisible.value);
					}
				}
			}
			else {
				ajout_marker(point,false);
			}
		});
		
		function ajout_marker(point,first) {
			if (first) {
				var monmarker = new GMarker(point, {icon:icon_first, draggable: true});
			}
			else {
				var monmarker = new GMarker(point, {icon:icon_normal, draggable: true});
			}
			map.addOverlay(monmarker);
			GEvent.addListener(monmarker, "dragstart", function() {
				var point_start_drag = this.getLatLng();
				coords_start_drag = point_start_drag.lat()+" "+point_start_drag.lng();
			});
			GEvent.addListener(monmarker, "dragend", function() {
				var point_end_drag = this.getLatLng();
				coords_end_drag = point_end_drag.lat()+" "+point_end_drag.lng();
				deplace_point(coords_start_drag,coords_end_drag);
				afficherPolygone(document.formfiche.polyencode.value,document.formfiche.polyvisible.value);
			});
			
			if (getCoords(monmarker)) {
		   		afficherPolygone(document.formfiche.polyencode.value,document.formfiche.polyvisible.value);
		   	}
		}
		
		//lanc� au lancement de la fen�tre
		function get_poly() {
			if (window.opener != null) {
				document.formfiche.polyencode.value = window.opener.document.formfiche.bordure.value;
				document.formfiche.polyvisible.value = "";
				var les_points = decodeLine(document.formfiche.polyencode.value);
				for (var i=0;i<les_points.length;i++){
					if ((les_points[i].lat() == les_points[0].lat()) && (les_points[i].lng() == les_points[0].lng()) && (i!=0)) {
						var monmarker = new GMarker(les_points[i],icon_normal);
						if (getCoords(monmarker)) {
							afficherPolygone(document.formfiche.polyencode.value,document.formfiche.polyvisible.value);
						}
						monmarker = null;
					}
					else {
						if ((i==0) || (i==les_points.length-1)) {
							ajout_marker(les_points[i],true);
						}
						else {
							ajout_marker(les_points[i],false);
						}
					}
				}
				if (les_points.length > 0) {
					map.panTo(moyenne_poly());
				}
			}
		}
		get_poly();
	}
}

function afficherPolygone(polygone,visibilite) {
  	if (montrace != null) {
  		map.removeOverlay(montrace);
  		couleur_poly = document.polyfiche.b_couleur.value;
		epaisseur_poly = document.polyfiche.b_epaisseur.value;
		opacite_poly = document.polyfiche.b_opacite.value;
  	}
  	montrace = new GPolyline.fromEncoded({
		color: couleur_poly,
		weight: epaisseur_poly,
		opacity: opacite_poly,
		points: polygone,
		levels: visibilite,
		numLevels: 1,
		zoomFactor: 36
	});
	map.addOverlay(montrace);
}

function join_poly() {
	if (confirm("�tes-vous s�r de vouloir joindre les extr�mit�s de ce trac� ?")) {
		if (document.formfiche.listlatlong.length > 1) {
			valeur = document.formfiche.listlatlong.options[0].text;
			tablatlong = valeur.split(" ");
			var npoint = new GLatLng((tablatlong[0]), (tablatlong[1]));
			var monmarker = new GMarker(npoint,icon_normal);
			if (getCoords(monmarker)) {
	   			afficherPolygone(document.formfiche.polyencode.value,document.formfiche.polyvisible.value);
	   		}
		}
	}
}

function action_preview() {
	afficherPolygone(document.formfiche.polyencode.value,document.formfiche.polyvisible.value);
}