if (latitudeLieuEdit != "" && longitudeLieuEdit != "") {
	var zoomclic = init_zoomclic;
	var zoominit = init_zoominit;
	var latitudeinit = latitudeLieuEdit;
	var longitudeinit = longitudeLieuEdit;
}
else {
	var zoomclic = 16;
	var zoominit = 8;
	var latitudeinit = 42.167475;
	var longitudeinit = 9.695434;
}

var icon = null;

function getCoords(monpoint) {
	if (monpoint == null) {
		//document.fiche.coords.value = "";
		document.formfiche.latitude.value = "";
		document.formfiche.longitude.value = "";
	}
	else {
		//document.fiche.coords.value = monpoint.toString();
		document.formfiche.latitude.value = monpoint.lat();
		document.formfiche.longitude.value = monpoint.lng();
	}
}

function getZoom(rubrique) {
	rubrique.value = momzoom;
}

function action_preview() {
	for (var i=0;i<document.formfiche.typeLieu.length;i++) {
		if (document.formfiche.typeLieu[i].checked) {
			type_symbole = document.formfiche.typeLieu[i].value;
		}
	}
	if (type_symbole == "texte") {
		fix_texte(document.formfiche);
	}
	if (type_symbole == "polygone") {
		fix_poly(document.formfiche);
	}
}

function fix_texte(formulaire) {
	angleEdit= formulaire.angle.value;
	tailleEdit= formulaire.taille.value;
	couleurEdit = formulaire.couleur.value;
	policeEdit = formulaire.police.value;
	lieuEdit = formulaire.lieu.value;
	if (map.getMapTypeId() == google.maps.MapTypeId.ROADMAP) {
		modeEdit = "P";
	}
	else {
		modeEdit = "S";
	}
	load_picto();
}

function fix_poly(formulaire) {
	bordureEdit = formulaire.bordure.value;
	visibiliteEdit = formulaire.b_visibilite.value;
	epaisseurEdit = formulaire.b_epaisseur.value;
	couleurEdit2 = formulaire.b_couleur.value;
	opaciteEdit = formulaire.b_opacite.value;
	pleinEdit = formulaire.b_plein.checked;
	point = map.getCenter();
	creer_polygone(bordureEdit,visibiliteEdit,epaisseurEdit,couleurEdit2,opaciteEdit,pleinEdit,point);
}

function fix_picto(init) {	
	if (isPicto(document.formfiche) || isPolygone(document.formfiche) || isTexte(document.formfiche)) {
		if (icon != null) {
			icon = null;
		}
		icon = {};
		if ((iconLieuEdit != "") || (istextEdit == "1") || (isbordureEdit == "1")){
			if (istextEdit == "1") {
				var nom_image = init_chemin_icones + "/lieudit.php?a="+angleEdit+"&s="+tailleEdit+"&c="+escape(couleurEdit)+"&p="+escape(policeEdit)+"&m="+modeEdit+"&t="+escape(lieuEdit);
				if (!init) {
					var img_temp = new Image();
					img_temp.src = nom_image;
					tailleTab = new Array(img_temp.width,img_temp.height);
				}
				else {
					tailleTab = tailleTextEdit.split(",");
				}
				icon.url = nom_image;
				icon.scaledSize = new google.maps.Size(tailleTab[0], tailleTab[1]);
				icon.anchor = new google.maps.Point(Math.ceil(tailleTab[0]/2), Math.ceil(tailleTab[1]/2));
				if ((document.formfiche.latitude.value!= "") && (document.formfiche.longitude.value)) {
					var point = new google.maps.LatLng(eval(document.formfiche.latitude.value), eval(document.formfiche.longitude.value));
					if (monmarker != null) {
						monmarker.setMap(null);
						monmarker = null;
					}
					creer_marker(point);
				}
	        }
	        else {
	        	if (isbordureEdit == "1") {
					/*
					icon.image = init_chemin_icones + "/icns/spacer.gif";
					icon.iconSize = new GSize(1, 1);
					icon.iconAnchor = new GPoint(1, 1);
					*/
					if (monmarker != null) {
						monmarker.setMap(null);
						monmarker = null;
					}
				}
				else {
					icon.url = iconLieuEdit;
					icon.scaledSize = new google.maps.Size(21, 21);
					icon.anchor = new google.maps.Point(11, 11);
					if (monmarker != null) {
						monmarker.setMap(null);
						monmarker = null;
					}
					if ((document.formfiche.latitude.value != "") && (document.formfiche.longitude.value != "")) {
						var point = new google.maps.LatLng(eval(document.formfiche.latitude.value), eval(document.formfiche.longitude.value));
						creer_marker(point);
					}
				}
	        }
		}
		else {
			if ((document.formfiche.latitude.value!= "") && (document.formfiche.longitude.value)) {
		        	icon.url = "http://labs.google.com/ridefinder/images/mm_20_red.png";
		        	icon.scaledSize = new google.maps.Size(12, 20);
		        	icon.anchor = new google.maps.Point(6, 20);
		        	//icon.infoWindowAnchor = new GPoint(5, 1);
				var point = new google.maps.LatLng(eval(document.formfiche.latitude.value), eval(document.formfiche.longitude.value));
				if (monmarker != null) {
					monmarker.setMap(null);
					monmarker = null;
				}
				creer_marker(point);
			}
	    }
	}
    return true;
}

var temp = null;

function img_loaded () {
	fix_picto(false);
}

function load_picto() {
	if (lieuEdit != "") {
		var nom_image = init_chemin_icones + "/lieudit.php?a="+angleEdit+"&s="+tailleEdit+"&c="+escape(couleurEdit)+"&p="+escape(policeEdit)+"&m="+modeEdit+"&t="+escape(lieuEdit);	
		temp = null;
		temp = new Image();
		if (temp.addEventListener) {
	   		temp.addEventListener("load", img_loaded, false);
	   	} else if (temp.attachEvent) {
	      	temp.attachEvent("onload", img_loaded);
	   	}
	   	else {
	   		alert("Ca ne marche pas ! Changez de navigateur SVP.");
	   	}
		temp.src = nom_image;
	}
	else {
		alert(lang_cartolieunotempty);
	}
   	return true;
}

//Decode points
function decodeLine(encoded) {
    var len = encoded.length;
    var index = 0;
    var array = [];
    var lat = 0;
    var lng = 0;
    try
    {
        while (index < len) {
            var b;
            var shift = 0;
            var result = 0;
            do {
                  b = encoded.charCodeAt(index++) - 63;
                  result |= (b & 0x1f) << shift;
                  shift += 5;
            } while (b >= 0x20);
            var dlat = ((result & 1) ? ~(result >> 1) : (result >> 1));
            lat += dlat;

            shift = 0;
            result = 0;
            do {
                  b = encoded.charCodeAt(index++) - 63;
                  result |= (b & 0x1f) << shift;
                  shift += 5;
            } while (b >= 0x20);
            var dlng = ((result & 1) ? ~(result >> 1) : (result >> 1));
            lng += dlng;

            array.push(new google.maps.LatLng((lat * 1e-5), (lng * 1e-5)));
        }
    } catch(ex)
    {
        //error in encoding.
    }
    return array;
}

function creer_marker(point) {
	monmarker = new google.maps.Marker({
		position: point,
		draggable: true,
		crossOnDrag: false,
		icon: icon,
		map: map
	});
	
	google.maps.event.addListener(monmarker, 'dragstart', function() {
		getCoords(this.getPosition());
	});
	
	google.maps.event.addListener(monmarker, 'dragend', function() {
		point = this.getPosition();
		getCoords(point);
		/*monmarker.setMap(null);
		monmarker = null;
		creer_marker(point);*/
	});
}

function creer_polygone(bordure,visibilite,epaisseur,couleur,opacite,plein,point) {
	if (monpolygone != null) {
		monpolygone.setMap(null);
		monpolygone = null;
	}
  	if (plein=="1") {
  		monpolygone = new google.maps.Polygon({
  			paths: decodeLine(bordure),
  			strokeColor: couleur,
  			strokeWeight: epaisseur,
  			strokeOpacity: 1,
  			fillColor: couleur,
  			fillOpacity: opacite,
  			map: map
  		});
	}
	else {
		monpolygone = new google.maps.Polyline({
			path: decodeLine(bordure),
  			strokeColor: couleur,
  			strokeWeight: epaisseur,
  			strokeOpacity: opacite,
  			map: map
  		});
	}
	var monPoint = new google.maps.LatLng(point.lat(), point.lng());
	map.panTo(monPoint);
}

function Gload() {
	//v�rification de l'existence du div de la carte
	var ie = false;
	if (document.all) {
		ie = true;
	}
	if (ie) {
		var objMenu = document.all["map"];
	}
	else {
		var objMenu = document.getElementById("map");
	}
	if (objMenu == null) {
		return false;
	}
		
    //traitements cartos
	if (window.JSON) {
		var mapOptions = {
			center: new google.maps.LatLng(latitudeinit, longitudeinit),
	        zoom: zoominit,
	        mapTypeId: google.maps.MapTypeId.HYBRID,
	        panControl: true,
			zoomControl: true,
			scaleControl: true,
			streetViewControl: false,
			mapTypeControlOptions: {
		    	mapTypeIds: [
		    		google.maps.MapTypeId.ROADMAP,
		    		google.maps.MapTypeId.SATELLITE,
		    		google.maps.MapTypeId.TERRAIN
		    	]
		    }
	    };
		map = new google.maps.Map(document.getElementById("map"), mapOptions);
		
		/*var MapDiv = document.getElementById("map");
		var CopyrightDiv = MapDiv.firstChild.nextSibling;
		var CopyrightImg = MapDiv.firstChild.nextSibling.nextSibling;
		CopyrightDiv.style.display = "none"; 
		CopyrightImg.style.display = "none";*/
		
		fix_picto(true);
		
		/*
			if (latitudeLieuEdit != "" && longitudeLieuEdit != "" && isbordureEdit == "0") {
			var point2 = new GLatLng(latitudeLieuEdit, longitudeLieuEdit);
	 		creer_marker(point2);
		}
		*/
		
		google.maps.event.addListener(map, 'click', function(event) {
			var point = event.latLng;
			if (monmarker == null) {
				var type_symbole = "";
				for (var i=0;i<document.formfiche.typeLieu.length;i++) {
					if (document.formfiche.typeLieu[i].checked) {
						type_symbole = document.formfiche.typeLieu[i].value;
					}
				}
				if (type_symbole == "") {
					alert(lang_cartolieuveriftype3);
				}
				else {
					getCoords(point);
					if (type_symbole == "picto") {
						fix_picto(false);
					}
					if (type_symbole == "texte") {
						load_picto();
					}
					if ((type_symbole == "polygone")) {
						map.panTo(point);
					}
				}
			}
			else {
				map.panTo(point);
			}
		});
		
		google.maps.event.addListener(map, 'maptypeid_changed', function() {
			if (monmarker != null) {
				var type_symbole = "";
				for (var i=0;i<document.formfiche.typeLieu.length;i++) {
					if (document.formfiche.typeLieu[i].checked) {
						type_symbole = document.formfiche.typeLieu[i].value;
					}
				}
				if (type_symbole == "texte") {
					if (map.getMapTypeId() == google.maps.MapTypeId.ROADMAP) {
						modeEdit = "P";
					}
					else {
						modeEdit = "S";
					}
					load_picto();
				}
			}
		});
		
		function afficherCBordure() {
    		if (bordureCEdit != "") {
				var bordure = new google.maps.Polyline({
					path: decodeLine(bordureCEdit),
		  			strokeColor: couleurCEdit,
		  			strokeWeight: epaisseurCEdit,
		  			strokeOpacity: opaciteCEdit,
		  			map: map
		  		});
			}
		}
		
		function afficherBordure(bordure,visibilite,epaisseur,couleur,opacite,plein) {
    			creer_polygone(bordure,visibilite,epaisseur,couleur,opacite,plein, new google.maps.LatLng(eval(document.formfiche.latitude.value),eval(document.formfiche.longitude.value)));
		}
		
		google.maps.event.addListener(map, 'zoom_changed', function() {
			momzoom = map.getZoom();
		});
		
		afficherCBordure();
		if (isbordureEdit == "1") {
			afficherBordure(bordureEdit,visibiliteEdit,epaisseurEdit,couleurEdit2,opaciteEdit,pleinEdit);
		}
	}
}

//diverses fonction de controles
var uneDate = new RegExp("^([0-9]{1,2})[/]([0-9]{1,2})[/]([0-9]{2}||[0-9]{4})$");
function isDate(dateStr) {

	var datePat = /^(\d{1,2})(\/|-)(\d{1,2})(\/|-)(\d{1,4})$/;
	var matchArray = dateStr.match(datePat); // is the format ok?
	
	if (matchArray == null) {
		//alert("Please enter date as either mm/dd/yyyy or mm-dd-yyyy.");
		return false;
	}
	
	month = matchArray[3]; // p@rse date into variables
	day = matchArray[1];
	year = matchArray[5];
	year = year/1;
	if (year < 10) {
		year = "0"+year;
	}
	if (year < 100) {
		year = "20"+year;
	}
	if (year.length < 4) {
		return false;
	}
	
	if (month < 1 || month > 12) { // check month range
		//alert("Month must be between 1 and 12.");
		return false;
	}
	
	if (day < 1 || day > 31) {
		//alert("Day must be between 1 and 31.");
		return false;
	}
	
	if ((month==4 || month==6 || month==9 || month==11) && day==31) {
		//alert("Month "+month+" doesn`t have 31 days!")
		return false;
	}
	
	if (month == 2) { // check for february 29th
		var isleap = (year % 4 == 0 && (year % 100 != 0 || year % 400 == 0));
		if (day > 29 || (day==29 && !isleap)) {
			//alert("February " + year + " doesn`t have " + day + " days!");
			return false;
		}
	}
	return true; // date is valid
}

function formeDate(valeur) {
	if (valeur != "") {
		if (uneDate.test(valeur)) {
			var LeTab = uneDate.exec(valeur);
			jour = LeTab[1];
			mois = LeTab[2];
			an = LeTab[3];
			jour = eval(jour);
			mois = eval(mois) - 1;
			if (an.length == 2) {
				an = "20" + an;
			}
			an = eval(an);
			var unedate = new Date(an,mois,jour);
			var annee = unedate.getYear();
	   		if ((Math.abs(annee)+"").length < 4) {
	   			annee = annee + 1900;
	   		}
	   		return ((unedate.getDate() == jour) && (unedate.getMonth() == mois && (annee == an)));
	   		//return true;
		}
		else {
			return false;
		}
	}
	else {
		return true;
	}
}

function validForm(formulaire) {
	if (formulaire.elements[init_chemin_id_carte].value == "") {
		alert(lang_cartolieuvarifcarte);
		return false;
	}
	if (formulaire.latitude.value == "") {
		alert(lang_cartolieuveriflat);
		return false;
	}
	if (formulaire.longitude.value == "") {
		alert(lang_cartolieuveriflong);
		return false;
	}
	if ((formulaire.icone.value != "" && isTexte(document.formfiche)) || (formulaire.icone.value != "" && isPolygone(document.formfiche)) || (isTexte(document.formfiche) && isPolygone(document.formfiche))) {
		alert(lang_cartolieuveriftype);
		return false;
	}
	if (formulaire.icone.value == "" && !isTexte(document.formfiche) && !isPolygone(document.formfiche)) {
		alert(lang_cartolieuveriftype2);
		return false;
	}
	if (isPolygone(document.formfiche) && (formulaire.bordure.value == "" || formulaire.b_epaisseur.value == "" || formulaire.b_couleur.value == "" || formulaire.b_opacite.value == "" || formulaire.b_visibilite.value == "")) {
		alert(lang_cartolieuverifparam);
		return false;
	}
	if (formulaire.lieu.value == "") {
		alert(lang_cartolieuverifnom);
		return false;
	}
	return true;
}

function confirmer() {
	return confirm(lang_cartoconfirm);
}

function isPicto(formulaire) {
	for (var i=0;i<formulaire.typeLieu.length;i++) {
		if (formulaire.typeLieu[i].checked) {
			var type_symbole = formulaire.typeLieu[i].value;
		}
	}
	return (type_symbole == "picto");
}

function isTexte(formulaire) {
	for (var i=0;i<formulaire.typeLieu.length;i++) {
		if (formulaire.typeLieu[i].checked) {
			var type_symbole = formulaire.typeLieu[i].value;
		}
	}
	return (type_symbole == "texte");
}

function isPolygone(formulaire) {
	for (var i=0;i<formulaire.typeLieu.length;i++) {
		if (formulaire.typeLieu[i].checked) {
			var type_symbole = formulaire.typeLieu[i].value;
		}
	}
	return (type_symbole == "polygone");
}

function typepointInit(formulaire) {
	if (formulaire == null) {
		return true;
	}
	if (formulaire.istext == null || formulaire.isbordure == null) {
		return true;
	}
	
	var ie = false;
	if (document.all) {
		ie = true;
	}
	if (ie) {
		var objMenuBout = document.all["menupict"];
		var objMenuPol = document.all["menutypo"];
		var objCouleurBout = document.all["pick1101735855"];
		var objCouleurBordure = document.all["pick1101735856"];
	}
	else {
		var objMenuBout = document.getElementById("menupict");
		var objMenuPol = document.getElementById("menutypo");
		var objCouleurBout = document.getElementById("pick1101735855");
		var objCouleurBordure = document.getElementById("pick1101735856");
	}
	
	for (var i=0;i<formulaire.typeLieu.length;i++) {
		if (formulaire.typeLieu[i].checked) {
			var type_symbole = formulaire.typeLieu[i].value;
		}
	}
	
	if (type_symbole == "texte" || type_symbole == "polygone") {
		//d�sactivation icone
		formulaire.icone.value="";
		formulaire.imgicone.src=init_chemin_icones + "/icns/empty.gif";
		objMenuBout.style.color="#CCCCCC";
	}
	if (type_symbole != "texte") {
		objCouleurBout.style.backgroundColor="#FFFFFF";
		formulaire.pick1101735855field.value="#FFFFFF";
		objMenuPol.style.color="#CCCCCC";
	}
	if (type_symbole != "polygone") {
		objCouleurBordure.style.backgroundColor="#FFFFFF";
		formulaire.pick1101735856field.value="#FFFFFF";
	}
}

function typepoint(formulaire, type_symbole) {
	var ie = false;
	if (document.all) {
		ie = true;
	}
	if (ie) {
		var objMenuBout = document.all["menupict"];
		var objMenuPol = document.all["menutypo"];
		var objCouleurBout = document.all["pick1101735855"];
		var objCouleurBordure = document.all["pick1101735856"];
	}
	else {
		var objMenuBout = document.getElementById("menupict");
		var objMenuPol = document.getElementById("menutypo");
		var objCouleurBout = document.getElementById("pick1101735855");
		var objCouleurBordure = document.getElementById("pick1101735856");
	}
	
	if (type_symbole == "texte") {
		//activation texte
		formulaire.angle.disabled = false;
		formulaire.angle.value="0";
		formulaire.taille.disabled = false;
		formulaire.taille.value="8";
		objMenuPol.style.color="#0E18A3";
		formulaire.police.value = "modules/SimpleCarto/lib/fonts/arial.ttf";
		formulaire.policetemp.value = "arial.ttf";
		objCouleurBout.style.backgroundColor="#FF0000";
		formulaire.pick1101735855field.value="#FF0000";
		istextEdit = "1";
	}
	else {
		//d�sactivation texte
		formulaire.angle.disabled = true;
		formulaire.angle.value="0";
		formulaire.taille.disabled = true;
		formulaire.taille.value="8";
		formulaire.policetemp.value="";
		objMenuPol.style.color="#CCCCCC";
		formulaire.police.value = "";
		objCouleurBout.style.backgroundColor="#FFFFFF";
		formulaire.pick1101735855field.value="#FFFFFF";
		istextEdit = "0";
	}
	if (type_symbole == "polygone") {
		//activation polygone
		formulaire.b_epaisseur.disabled = false;
		formulaire.b_opacite.disabled = false;
		formulaire.bordure.disabled = false;
		formulaire.b_visibilite.disabled = false;
		formulaire.newpoly.disabled = false;
		objCouleurBordure.style.backgroundColor="#FF0000";
		formulaire.pick1101735856field.value="#FF0000";
		isbordureEdit = "1";
		formulaire.b_plein.disabled = false;
	}
	else {
		//d�sactivation polygone
		formulaire.b_epaisseur.disabled = true;
		formulaire.b_epaisseur.value="3";
		formulaire.b_opacite.disabled = true;
		formulaire.b_opacite.value="1.00";
		formulaire.bordure.disabled = true;
		formulaire.bordure.value = "";
		formulaire.b_visibilite.disabled = true;
		formulaire.b_visibilite.value = "";
		formulaire.newpoly.disabled = true;
		objCouleurBordure.style.backgroundColor="#FFFFFF";
		formulaire.pick1101735856field.value="#FFFFFF";
		isbordureEdit = "0";
		formulaire.b_plein.disabled = true;
		formulaire.b_plein.checked = false;
	}
	if (type_symbole == "picto") {
		//activation icone
		objMenuBout.style.color="#0E18A3";
	}
	else {
		//d�sactivation icone
		formulaire.icone.value="";
		formulaire.imgicone.src=init_chemin_icones + "/icns/empty.gif";
		objMenuBout.style.color="#CCCCCC";
	}
	angleEdit= formulaire.angle.value;
	tailleEdit= formulaire.taille.value;
	couleurEdit = formulaire.couleur.value;
	policeEdit = formulaire.police.value;
	iconLieuEdit = formulaire.icone.value;
	lieuEdit = formulaire.lieu.value;
	
	if (monmarker != null) {
		monmarker.setMap(null);
		monmarker = null;
	}
	if (monpolygone != null) {
		monpolygone.setMap(null);
		monpolygone = null;
		//getCoords(null);
	}

	if (type_symbole == "picto") {
		fix_picto();
	}	
	if (type_symbole == "texte") {
		load_picto();
	}
	if (type_symbole == "polygone") {
		//getCoords(null);
	}
	return true;
}

function fixPicto(picto) {
	document.images["imgicone"].src = picto;
	document.formfiche.icone.value = picto;
	hidePopUpZPop();
	iconLieuEdit = picto;
	lieuEdit = "";
	fix_picto();
	return false;
}

function fixPolice(police) {
	document.formfiche.police.value = police;
	hidePopUpZPop();
	policeEdit = police;
	var tab = police.split("/");
	document.formfiche.policetemp.value = tab[eval(tab.length - 1)];
	
	fix_texte(document.formfiche);
	
	return false;
}

function showPictos(id) {
	var ie = false;
	if (document.all) {
		ie = true;
	}
	if (ie) {
		var objMenu = document.all["listic"+id];
		objMenu.style.display='block';
		var headerMenu = document.all["headeric"+id];
		headerMenu.style.backgroundImage='url(init_chemin_icones + "/icns/open2.gif")';
	}
	else {
		var objMenu = document.getElementById("listic"+id);
		objMenu.style.display='table-row';
		var headerMenu = document.getElementById("headeric"+id);
		headerMenu.style.backgroundImage='url(init_chemin_icones + "/icns/open2.gif")';
	}
}

function hidePictos(id) {
	var ie = false;
	if (document.all) {
		ie = true;
	}
	if (ie) {
		var objMenu = document.all[id];
	}
	else {
		var objMenu = document.getElementById(id);
	}
	objMenu.style.visibility='hidden';
}

function hideAllPictos() {
	var compteur = 1;
	var ie = false;
	if (document.all) {
		ie = true;
	}
	if (ie) {
		var objMenu = document.all["listic"+compteur];
		var headerMenu = document.all["headeric"+compteur];
	}
	else {
		var objMenu = document.getElementById("listic"+compteur);
		var headerMenu = document.getElementById("headeric"+compteur);
	}
	while (objMenu != null && headerMenu != null) {
		objMenu.style.display='none';
		headerMenu.style.backgroundImage='url(init_chemin_icones + "/icns/open.gif")';
		compteur++;
		if (ie) {
			objMenu = document.all["listic"+compteur];
			headerMenu = document.all["headeric"+compteur];
		}
		else {
			objMenu = document.getElementById("listic"+compteur);
			headerMenu = document.getElementById("headeric"+compteur);
		}
	}
}

function open_new_poly() {
	window.open(init_chemin_icones + "/pro/newpoly_lieu.php","Polygone","menubar=no,status=no,scrollbars=no,menubar=no,resizable=no,height=480,width=640");
}