<?php
/**
* Classes d'accs  la base de donnes pour manipuler les cartes.
* 
* Toutes les fonctions utilisent l'API de la plateforme pour tre indpendante de la base de donnes utilise
* @package becmsSimpleCarto
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

/**
* Classe d'accs  la base de donnes carto pour isoler les fonctions.
* 
* Il existe deux types de donnes :
* - les cartes, o le nom, le centre, le contours et les zooms sont spcifis
* - les lieux, o toutes les donnes des points sont spcifies (texte, polygone, icne,...)
* @package becmsSimpleCarto
*/
class BD_Cartos {
/**
* Efface le lieu d'une carte
* @param array $My_SQL Paramtres de la base de donnes
* @param integer $Id Identifiant du lieu  supprimer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/		
	function delLieu($My_SQL,$Id) {
		$db=$My_SQL["maBase"];
		
		if ($Id != "") {
			$cond = "`Id` = ".$Id;
			$sql = "DELETE FROM `".$My_SQL["lieux"]."` WHERE ".$cond.";";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
/**
* Enregistre le lieu d'une carte
* 
* Si le lieu esiste dj, il est simplement modifi, sinon il est cr.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $lieu Tableau contenant tous les champs du lieu  enregistrer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/	
	function saveLieu($My_SQL,$lieu) {
		$db=$My_SQL["maBase"];
		
		$lieu = array_map(array('adminCartos', 'conditionnertodb'), $lieu);
		$lieu['bordure'] = str_replace("\\", "\\\\", $lieu['bordure']);
		if ($lieu["Id"] == "-1") {
			$sql = "INSERT INTO `".$My_SQL["lieux"]."` (`id_carte`,`latitude`,`longitude`,`icone`,`lieu`,`fiche`,`target`,`commentaire`,`istext`,`angle`,`taille`,`typo`,`couleur`,`isbordure`,`bordure`,`b_visibilite`,`b_couleur`,`b_epaisseur`,`b_opacite`,`b_plein`)";
			$sql .= " VALUES ('".$lieu["id_carte"]."','".$lieu["latitude"]."','".$lieu["longitude"]."','".$lieu["icone"]."','".$lieu["lieu"]."','".$lieu["fiche"]."','".$lieu["target"]."','".$lieu["commentaire"]."','".$lieu["istext"]."','".$lieu["angle"]."','".$lieu["taille"]."','".$lieu["typo"]."','".$lieu["couleur"]."','".$lieu["isbordure"]."','".$lieu["bordure"]."','".$lieu["b_visibilite"]."','".$lieu["b_couleur"]."','".$lieu["b_epaisseur"]."','".$lieu["b_opacite"]."','".$lieu["b_plein"]."');";
		}
		else {
			$sql = "UPDATE `".$My_SQL["lieux"]."` SET `id_carte` = '".$lieu["id_carte"]."',`latitude` = '".$lieu["latitude"]."', `longitude` = '".$lieu["longitude"]."', `icone` = '".$lieu["icone"]."', `lieu` = '".$lieu["lieu"]."', `fiche` = '".$lieu["fiche"]."', `target` = '".$lieu["target"]."', `commentaire` = '".$lieu["commentaire"]."', `istext` = '".$lieu["istext"]."', `angle` = '".$lieu["angle"]."', `taille` = '".$lieu["taille"]."', `typo` = '".$lieu["typo"]."', `couleur` = '".$lieu["couleur"]."', `isbordure` = '".$lieu["isbordure"]."', `bordure` = '".$lieu["bordure"]."', `b_visibilite` = '".$lieu["b_visibilite"]."', `b_couleur` = '".$lieu["b_couleur"]."', `b_epaisseur` = '".$lieu["b_epaisseur"]."', `b_opacite` = '".$lieu["b_opacite"]."', `b_plein` = '".$lieu["b_plein"]."' WHERE `Id` = '".$lieu["Id"]."';";
		}
		return $db->sql_query($sql);
	}
/**
* Renvoie la liste des lieux correspondants  la demande
* 
* Un tableau vide est renvoy si aucun lieu n'est trouv. Si Id et $Idc valent "", tous les lieux sont renvoys.
* @param array $My_SQL Paramtres de la base de donnes
* @param integer $Id Identifiant du lieu  renvoyer
* @param integer $Idc Identifiant de la carte  laquelle les lieux appartiennent.
* @param string $tri_par Nom de la rubrique servant au tri.
* @return array Retourne la liste des lieux retrouvs
*/	
	function getLieux($My_SQL,$Id,$Idc,$tri_par="") {
		$db=$My_SQL["maBase"];
		
		$points = array();
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["lieux"]."`.`Id`='".$Id."'";
		}
		if ($Idc != "-1" && $Idc != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$My_SQL["lieux"]."`.`id_carte`='".$Idc."'";
		}
		$oderby = "";
		if ($tri_par =="") {
			$oderby = " ORDER BY `".$My_SQL["lieux"]."`.`istext` ASC, `".$My_SQL["lieux"]."`.`isbordure` ASC, `".$My_SQL["lieux"]."`.`lieu` ASC";
		}
		if ($tri_par == "symbol") {
			$oderby = " ORDER BY `".$My_SQL["lieux"]."`.`istext` ASC, `".$My_SQL["lieux"]."`.`isbordure` ASC, `".$My_SQL["lieux"]."`.`lieu` ASC";
		}
		if ($tri_par == "designation") {
			$oderby = " ORDER BY `".$My_SQL["cartes"]."`.`designation` ASC, `".$My_SQL["lieux"]."`.`lieu` ASC";
		}
		$resultatRecherche = $db->sql_query("SELECT `".$My_SQL["lieux"]."`.`Id`,`".$My_SQL["lieux"]."`.`id_carte`,`".$My_SQL["lieux"]."`.`latitude`,`".$My_SQL["lieux"]."`.`longitude`,`".$My_SQL["lieux"]."`.`icone`,`".$My_SQL["lieux"]."`.`lieu`,`".$My_SQL["lieux"]."`.`fiche`,`".$My_SQL["lieux"]."`.`target`,`".$My_SQL["lieux"]."`.`commentaire`,`".$My_SQL["lieux"]."`.`istext`,`".$My_SQL["lieux"]."`.`angle`,`".$My_SQL["lieux"]."`.`taille`,`".$My_SQL["lieux"]."`.`typo`,`".$My_SQL["lieux"]."`.`couleur`,`isbordure`,`".$My_SQL["lieux"]."`.`bordure`,`".$My_SQL["lieux"]."`.`b_visibilite`,`".$My_SQL["lieux"]."`.`b_couleur`,`".$My_SQL["lieux"]."`.`b_epaisseur`,`".$My_SQL["lieux"]."`.`b_opacite`,`".$My_SQL["lieux"]."`.`b_plein`,`".$My_SQL["cartes"]."`.designation FROM `".$My_SQL["lieux"]."` LEFT JOIN `".$My_SQL["cartes"]."` ON `".$My_SQL["lieux"]."`.id_carte = `".$My_SQL["cartes"]."`.`Id`".$cond.$oderby.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			if ($db->sql_numrows($resultatRecherche) != 0) {
				while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
					$temp = array("Id"=>$ligneCourante["Id"],"id_carte"=>$ligneCourante["id_carte"],"latitude"=>$ligneCourante["latitude"],"longitude"=>$ligneCourante["longitude"],"icone"=>$ligneCourante["icone"],"lieu"=>$ligneCourante["lieu"],"fiche"=>$ligneCourante["fiche"],"target"=>$ligneCourante["target"],"commentaire"=>$ligneCourante["commentaire"],"istext"=>$ligneCourante["istext"],"angle"=>$ligneCourante["angle"],"taille"=>$ligneCourante["taille"],"typo"=>$ligneCourante["typo"],"couleur"=>$ligneCourante["couleur"],"isbordure"=>$ligneCourante["isbordure"],"bordure"=>$ligneCourante["bordure"],"b_visibilite"=>$ligneCourante["b_visibilite"],"b_couleur"=>$ligneCourante["b_couleur"],"b_epaisseur"=>$ligneCourante["b_epaisseur"],"b_opacite"=>$ligneCourante["b_opacite"],"b_plein"=>$ligneCourante["b_plein"],"designation"=>$ligneCourante["designation"]);
					array_push($points, $temp);
				}
			}
		}
		return $points;
	}
/**
* Duplique un lieu d'une carte
* 
* @param array $My_SQL Paramtres de la base de donnes
* @param Integer $Id Identifiant du lieu  dupliquer
* @param Integer $Id_new Identifiant de la carte  laquelle appartient le lieu (utilis pour la duplication de carte)
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/	
	function dupplLieu($My_SQL,$Id,$Id_new="") {
		$db=$My_SQL["maBase"];
		
		$lieux = $this->getLieux($My_SQL,$Id,"","");
		$lieu = $lieux[0];
		//$lieu['bordure'] = str_replace("\\", "\\\\\\\\", $lieu['bordure']);
		//$lieu = array_map(array('adminCartos', 'conditionnertodb'), $lieu);
		$lieu['bordure'] = str_replace("\\", "\\\\", $lieu['bordure']);
		
		$lieu["Id"] = "-1";
		if ($Id_new != "") {
			$lieu["id_carte"] = $Id_new;
		}
		return $this->saveLieu($My_SQL,$lieu);
	}
/**
* Enregistre une carte
* 
* Si la carte esiste dj, elle est simplement modifie, sinon elle est cre.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $carte Tableau contenant tous les champs de la carte  enregistrer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/
	function saveCarte($My_SQL,$carte) {
		$db=$My_SQL["maBase"];
		$carte = array_map(array('adminCartos', 'conditionnertodb'), $carte);
		if ($carte["Id"] == "-1") {
			$sql = "INSERT INTO `".$My_SQL["cartes"]."` (`designation`,`latitudeinit`,`longitudeinit`,`zoominit`,`zoomclic`,`bordure`,`visibilite`,`couleur`,`epaisseur`,`opacite`,`auteur`,`creation`,`commentaire`,`page`,`print`,`bulles`,`limites`,`polygones`,`pictos`,`legende`,`type`,`mini`,`titre`,`commenter`, `seuil`,`controles`,`taille`, `zoommin`, `zoommax`)";
			$sql .= " VALUES ('".$carte["designation"]."','".$carte["latitudeinit"]."','".$carte["longitudeinit"]."','".$carte["zoominit"]."','".$carte["zoomclic"]."','".$carte["bordure"]."','".$carte["visibilite"]."','".$carte["couleur"]."','".$carte["epaisseur"]."','".$carte["opacite"]."','".$carte["auteur"]."',now(),'".$carte["commentaire"]."','".$carte["page"]."','".$carte["print"]."','".$carte["bulles"]."','".$carte["limites"]."','".$carte["polygones"]."','".$carte["pictos"]."','".$carte["legende"]."','".$carte["type"]."','".$carte["mini"]."','".$carte["titre"]."','".$carte["commenter"]."','".$carte["seuil"]."','".$carte["controles"]."','".$carte["taille"]."','".$carte["zoommin"]."','".$carte["zoommax"]."');";
		}
		else {
			$sql = "UPDATE `".$My_SQL["cartes"]."` SET `designation` = '".$carte["designation"]."',`latitudeinit` = '".$carte["latitudeinit"]."',`longitudeinit` = '".$carte["longitudeinit"]."',`zoominit` = '".$carte["zoominit"]."',`zoomclic` = '".$carte["zoomclic"]."',`bordure` = '".$carte["bordure"]."',`visibilite` = '".$carte["visibilite"]."',`couleur` = '".$carte["couleur"]."',`epaisseur` = '".$carte["epaisseur"]."',`opacite` = '".$carte["opacite"]."', `commentaire` = '".$carte["commentaire"]."', `page` = '".$carte["page"]."', `print` = '".$carte["print"]."',`bulles` = '".$carte["bulles"]."',`limites` = '".$carte["limites"]."',`polygones` = '".$carte["polygones"]."',`pictos` = '".$carte["pictos"]."',`legende` = '".$carte["legende"]."',`type` = '".$carte["type"]."',`mini` = '".$carte["mini"]."',`titre` = '".$carte["titre"]."',`commenter` = '".$carte["commenter"]."',`seuil` = '".$carte["seuil"]."',`controles` = '".$carte["controles"]."',`taille` = '".$carte["taille"]."',`zoommin` = '".$carte["zoommin"]."',`zoommax` = '".$carte["zoommax"]."' WHERE `Id` = '".$carte["Id"]."';";
		}
		return $db->sql_query($sql);
	}
/**
* Renvoie la liste des cartes correspondants  la demande
* 
* Un tableau vide est renvoy si aucune carte n'est trouv. Si $Id = "", toutes les cartes sont renvoyes.
* @param array $My_SQL Paramtres de la base de donnes
* @param integer $Id Identifiant de la carte.
* @param string $tri_par Nom de la rubrique servant au tri.
* @return array Retourne la liste des lieux retrouvs
*/	
	function getCartes($My_SQL,$Id,$tri_par="") {
		$db=$My_SQL["maBase"];
		
		$cartes = array();
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`Id`='".$Id."'";
		}
		if ($tri_par !="") {
			$oderby = " ORDER BY `".$tri_par."` ASC, `designation` ASC";
		}
		else {
			$oderby = " ORDER BY `creation` DESC";
		}
		if ($tri_par =="creation") {
			$oderby = " ORDER BY `creation` DESC";
		}
		$resultatRecherche = $db->sql_query("SELECT `Id`,`designation`,`latitudeinit`,`longitudeinit`,`zoominit`,`zoomclic`,`bordure`,`visibilite`,`couleur`,`epaisseur`,`opacite`,`auteur`,`creation`,`commentaire`,`page`,`print`,`bulles`,`limites`,`polygones`,`pictos`,`legende`,`type`,`mini`,`titre`,`commenter`,`seuil`,`controles`,`taille`,`zoommin`,`zoommax` FROM `".$My_SQL["cartes"]."`".$cond.$oderby.";",$My_SQL["maBase"]);
		if ($db->sql_numrows($resultatRecherche) != 0) {
			while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				$temp = array(
				"Id"=>$ligneCourante["Id"],
				"designation"=>$ligneCourante["designation"],
				"latitudeinit"=>$ligneCourante["latitudeinit"],
				"longitudeinit"=>$ligneCourante["longitudeinit"],
				"zoominit"=>$ligneCourante["zoominit"],
				"zoomclic"=>$ligneCourante["zoomclic"],
				"bordure"=>$ligneCourante["bordure"],
				"visibilite"=>$ligneCourante["visibilite"],
				"couleur"=>$ligneCourante["couleur"],
				"epaisseur"=>$ligneCourante["epaisseur"],
				"opacite"=>$ligneCourante["opacite"],
				"auteur"=>$ligneCourante["auteur"],
				"creation"=>$ligneCourante["creation"],
				"commentaire"=>$ligneCourante["commentaire"],
				"page"=>$ligneCourante["page"],
				"print"=>$ligneCourante["print"],
				"bulles"=>$ligneCourante["bulles"],
				"limites"=>$ligneCourante["limites"],
				"polygones"=>$ligneCourante["polygones"],
				"pictos"=>$ligneCourante["pictos"],
				"legende"=>$ligneCourante["legende"],
				"type"=>$ligneCourante["type"],
				"mini"=>$ligneCourante["mini"],
				"titre"=>$ligneCourante["titre"],
				"commenter"=>$ligneCourante["commenter"],
				"seuil"=>$ligneCourante["seuil"],
				"controles"=>$ligneCourante["controles"],
				"taille"=>$ligneCourante["taille"],
				"zoommin"=>$ligneCourante["zoommin"],
				"zoommax"=>$ligneCourante["zoommax"]
				);
				array_push($cartes, $temp);
			}
		}
		return $cartes;
	}
/**
* Duplique une carte
* 
* @param array $My_SQL Paramtres de la base de donnes
* @param Integer $Id Identifiant de la carte  dupliquer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/	
	function dupplCarte($My_SQL,$Id) {
		$db=$My_SQL["maBase"];
		
		$cartes = $this->getCartes($My_SQL,$Id,"");
		$carte = $cartes[0];
		//$carte = array_map(array('adminCartos', 'conditionnertodb'), $carte);
		$carte["Id"] = "-1";
		$ok = $this->saveCarte($My_SQL,$carte);
		$Id_new = $this->getLastId($My_SQL);
		$lieux = $this->getLieux($My_SQL,"",$Id,"");
		foreach($lieux as $lieu){
			$ok = $ok && $this->dupplLieu($My_SQL,$lieu["Id"],$Id_new);
		}
		return $ok;
	}
/**
* Efface une carte.
* 
* Tous les lieux relis  cette carte sont galement supprims.
* @param array $My_SQL Paramtres de la base de donnes
* @param integer $Id Identifiant de la carte  supprimer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/	
	function delCarte($My_SQL,$Id) {
		$db=$My_SQL["maBase"];
		
		if ($Id != "") {
			$lieux = $this->getLieux($My_SQL,"",$Id);
			foreach($lieux as $lieu) {
				if (!$this->delLieu($My_SQL,$lieu["Id"])) {
					return false;
				}
			}
			$cond = "`Id` = ".$Id;
			$sql = "DELETE FROM `".$My_SQL["cartes"]."` WHERE ".$cond.";";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
/**
* Rcupre la valeur de l'indentifiant du dernier enregistrement cr.
* @param array $My_SQL Paramtres de la base de donnes
* @return integer Identifiant
*/
	function getLastId($My_SQL) {
		$db=$My_SQL["maBase"];
		return $db->sql_nextid();
	}
}
?>