<?php
/**
* Classes des fonctions pour manipuler les cartes.
* 
* Elles sont dans une classe pour les isoler des autres fonctions. 
* @package becmsSimpleCarto
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/
require_once("g_db.php");

/**
* Classe des fonctions.
* 
* Cette clase contient galement les fonctions utiles (calcul de taille de texte, conversion de couleurs,...).
* @package becmsSimpleCarto
*/
class adminCartos {
/**
* @var object Classe qui donne accs au fonctions de manipulation des carte.
*/		
	var $sgbd;
/**
* Initialise $sgbd avec la classe des fonctions d'accs  la base de donnes des cartes
*/	
	function adminCartos() {
		$this->sgbd = new BD_Cartos();
	}
/**
* Renvoie un tableau HTML listant tous les lieux de la carte dsigne.
* 
* Ce tableau permet de crer, modifier ou supprimer les lieux.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @return string Tableau HTML des lieux.
*/	
	function get_observations ($My_SQL,$vars_mod) {
		if ($vars_mod[$vars_mod["id_carte"]] == "-1") {
			$id_carte = "";
			$critTriPlus = "";
		}
		else {
			$id_carte = $vars_mod[$vars_mod["id_carte"]];
			$critTriPlus = "&".$vars_mod["id_carte"]."=".$id_carte;
		}
		$lieux = $this->sgbd->getLieux($My_SQL,"",$id_carte,$vars_mod[$vars_mod["tri"]]);
		
		$observations = '
				<table  class="lisTable">
				<tr class="systemTabHeader">
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=carto&onglet=lieu&'.$vars_mod["tri"].'=symbol'.$critTriPlus.'">'._CARTOICONE.'</a></th>
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=carto&onglet=lieu&'.$vars_mod["tri"].'=lieu'.$critTriPlus.'">'._CARTOLIEU.'</a></th>
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list&op=carto&onglet=lieu&'.$vars_mod["tri"].'=designation'.$critTriPlus.'">'._CARTONOMCARTE.'</a></th>
					<th class="systemTabHeader">'._CARTOCOMMENTAIRE.'</th>
    					<th class="systemTabHeader">'._CARTOLIEN.'</th>
    					<th class="systemTabHeader">'._CARTOACTIONLIEUCARTE.'</th>
    				</tr>';
		$pos=0;
		if (count($lieux) != 0) {
			foreach ($lieux as $lieuS) {
				if ($lieuS["icone"] == "") {
					$v_icone1 = $vars_mod["cheminIcones"]."/icns/spacer.gif";					$v_icone2 = "";
					if ($lieuS["istext"]) {
						$v_icone1 = $vars_mod["cheminIcones"]."/icns/texte.gif";
					}
					if ($lieuS["isbordure"]) {
						$v_icone1 = $vars_mod["cheminIcones"]."/icns/polygone.gif";
					}
				}
				else {
					$v_icone1 = $lieuS["icone"];
				}
				if ($this->conditionnerHTML($lieuS["fiche"]) !="") {
					$aveclien = "&bull;";
				}
				else {
					$aveclien = "";
				}
				
				if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
				$pos++;
				
				$observations .= '<tr class="'.$thestyle.'">';
				$observations .= '<td>';
				//$observations .= '<a href="?'.$vars_mod["action"].'=edit&'.$vars_mod["id_lieu"].'='.$lieuS["Id"].'"><img src="'.$v_icone1.'" border="0" /></a>';
				$observations .= '<img src="'.$v_icone1.'" border="0" />';
				$observations .= '</td><td align="center">';
				$observations .= $this->conditionnerHTML($lieuS["lieu"]);
				$observations .= '</td><td align="center">';
				$observations .= $this->conditionnerHTML($lieuS["designation"]);
				$observations .= '</td><td align="center">';
				$observations .= $this->conditionnerHTML($lieuS["commentaire"]);
				$observations .= '</td><td align="center">';
				$observations .= $aveclien;
				$observations .= '</td><td align="center">';
				//$observations .= '<a href="?'.$vars_mod["action"].'=edit&'.$vars_mod["id_lieu"].'='.$lieuS["Id"].'">[Editer]</a> <a href="?'.$vars_mod["action"].'=delete&'.$vars_mod["id_lieu"].'='.$lieuS["Id"].'" onclick="return confirmer()">[Supprimer]</a>';
				
				//version pro
				global $module_name;
				if (file_exists("modules/".$module_name."/lib/pro/admin.inc")){
					require("pro/admin.inc");
				}
				else {
					$barDef=array(	"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=carto&onglet=lieu&".$vars_mod["action"]."=edit&".$vars_mod["id_lieu"]."=".$lieuS["Id"],"comment"=>_EDIT, "status"=>"ON"),
  					  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=carto&"."&onglet=lieu&".$vars_mod["action"]."=delete&".$vars_mod["id_lieu"]."=".$lieuS["Id"]."&".$vars_mod["id_carte"]."=".$vars_mod[$vars_mod["id_carte"]],"comment"=>_DELETE,"status"=>"ON"));
				}
				
	    			$observations .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
				$observations .= '</td>';
				$observations .= '</tr>';
			}
			
		}
		$observations .= '</table>';
		/*$observations .= '
		<form id="formfiche" action="editplot.php?'.$vars_mod["action"].'=list_carte" method="post" name="formfiche">
		<input type="submit" name="submitButtonName" value="Liste cartes" style="margin: 10px"/>
		</form>
		';*/
		return $observations;
	}
/**
* Renvoie le lieu dsign.
* 
* Si le lieu est introuvable ou que sont identifiant est -1, un lieu vide est retourn.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @return array Tous les champs du lieu.
*/	
	function get_lieu_edit($My_SQL,$vars_mod) {
		if ($vars_mod[$vars_mod["id_lieu"]] != "-1") {
			$lieuxEdit = $this->sgbd->getLieux($My_SQL,$vars_mod[$vars_mod["id_lieu"]],"");
			if (count($lieuxEdit) == 0) {
				$LieuEdit = array("Id"=>"","latitude"=>"","longitude"=>"","icone"=>"","lieu"=>"","fiche"=>"","target"=>"","commentaire"=>"","istext"=>"","angle"=>"","taille"=>"","typo"=>"","couleur"=>"","id_carte"=>"","bordure"=>"","b_visibilite"=>"","b_epaisseur"=>"","b_opacite"=>"","b_couleur"=>"","isbordure"=>"","b_plein"=>"");
			}
			else {
				$LieuEdit = $lieuxEdit[0];
			}
		}
		else {
			$LieuEdit = array("Id"=>"","latitude"=>"","longitude"=>"","icone"=>"","lieu"=>"","fiche"=>"","target"=>"","commentaire"=>"","istext"=>"","angle"=>"","taille"=>"","typo"=>"","couleur"=>"","id_carte"=>"","bordure"=>"","b_visibilite"=>"","b_epaisseur"=>"","b_opacite"=>"","b_couleur"=>"","isbordure"=>"","b_plein"=>"");
		}
		return $LieuEdit;
	}


	function get_links_modules($current_link="") {
		global $db;
		
		require_once 'modules/becmsDynMenu/lib/g_params.php';
		$Myqsl["maBase"] = $db;
		$langueMenuEnCours = "French";
		$rub_url = "fiche";
		$urlEnCours = $current_link;
		require_once 'modules/becmsDynMenu/lib/get_all_urls_modules.php';
		$sortie_locale = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"2\" id=\"links\"><tr><td>";
		$sortie_locale .= $menus_modules;
		$sortie_locale .= "</td></tr></table>";
		return $sortie_locale;
		
		
		/*$menus_modules = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"2\" id=\"links\">";
		$counter = 0;
		global $db, $prefix,$currentlang;
	    $result = $db->sql_query("SELECT title, custom_title FROM ".$prefix."_modules WHERE active='1' ORDER BY custom_title ASC");
		while (list($mod_title,$custom_title) = $db->sql_fetchrow($result)) {
			if (file_exists("modules/$mod_title/system/menus.php")) {
				include("modules/$mod_title/system/language/lang-".$currentlang.".php");
				include("modules/$mod_title/system/menus.php");
				$menus_modules .= "<tr>";
				$menus_modules .= "<td>".$label_menu."</td>";
				$menus_modules .= "<td><select name=\"dispo$counter\" size=\"1\" onchange=\"if (this.value != '') {this.form.fiche.value = this.value; }\" class=\"pages\">";
				$menus_modules .= "<option value=\"\">"._DEITMENUFIRSTLINEDISPOS."</option>";
				$withgroup = false;
				foreach ($module_menus as $module_menu) {
					//if (strtoupper($module_menu["language"]) == strtoupper($typeMenu[0]["langue"]) || $module_menu["language"] == "") {
						if ($module_menu["link"] == "") {
							//$menus_modules .= "<option value=\"\">".$module_menu["label"]."</option>";
							$menus_modules .= ($withgroup) ? "</optgroup>" : "";
							$menus_modules .= "<optgroup label=\"".$module_menu["label"]."\">";
						}
						else {
							if ($module_menu["link"] == $current_link) {
								$selected = " selected=\"selected\"";
							} else {
								$selected = "";
							}
							if ($multilingual=="1" && $module_menu["language"] != "") {
								$lalangue = " (".$module_menu["language"].")";
							}
							else {
								$lalangue = "";
							}
							$menus_modules .= "<option value=\"".$module_menu["link"]."\"".$selected.">".$module_menu["label"].$lalangue."</option>";
						}
					//}
				}
				$menus_modules .= ($withgroup) ? "</optgroup>" : "";
				$menus_modules .= "</select></td>";
				$menus_modules .= "</tr>";
			}
			$counter++;
		}
		$menus_modules .= "</table>";
		return $menus_modules;*/
	}

/**
* Renvoie le formulaire d'dition du lieu dsign.
* 
* Ce tableau permet de crer, modifier ou supprimer les lieux.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @return string Formulaire HTML du lieu.
*/		
	function edit_lieu($My_SQL,$vars_mod) {
		$latitude = "";
		$longitude = "";
		$icone = "";
		$fiche = "";
		$target = "";
		$lieu = "";
		$carte = $vars_mod[$vars_mod["id_carte"]];
		$commentaire = "";
		$istext ="";
		$police="";
		$taille="8";
		$couleur = "#FFFFFF";
		$angle ="0";
		//$cc_istext = '<input type="checkbox" name="istext" value="1"  onclick="typepoint(this.form)" />';
		$angleEnabled = "disabled=\"disabled\"";
		
		$bordure = "";
		$b_visibilite = "";
		$b_epaisseur = "3";
		$b_opacite = "1.00";
		$b_couleur = "#FFFFFF";
		//$cc_isbordure = '<input type="checkbox" name="isbordure" value="1"  onclick="typepoint(this.form)" />';
		$opaciteEnabled = "disabled=\"disabled\"";
		
		$br_ispicto = '<input type="radio" name="typeLieu" value="picto" onclick="typepoint(this.form,this.value)" />';
		$br_istexte = '<input type="radio" name="typeLieu" value="texte" onclick="typepoint(this.form,this.value)" />';
		$br_ispolygone = '<input type="radio" name="typeLieu" value="polygone" onclick="typepoint(this.form,this.value)" />';
		$cb_plein = '<input type="checkbox" name="b_plein" value="1" onchange="fix_poly(this.form)" />';
		if ($vars_mod[$vars_mod["id_lieu"]] != "-1") {
			$LieuEdit = $this->get_lieu_edit($My_SQL,$vars_mod);
			$carte = $LieuEdit["id_carte"];
			$latitude = $LieuEdit["latitude"];
			$longitude = $LieuEdit["longitude"];
			$icone = $this->conditionnerFORM($LieuEdit["icone"]);
			$fiche = $this->conditionnerFORM($LieuEdit["fiche"]);
			$target = $this->conditionnerFORM($LieuEdit["target"]);
			$lieu = $this->conditionnerFORM($LieuEdit["lieu"]);
			$commentaire = $this->conditionnerFORM($LieuEdit["commentaire"]);
			$istext = $LieuEdit["istext"];
			$taille = $this->conditionnerFORM($LieuEdit["taille"]);
			$police = $this->conditionnerFORM($LieuEdit["typo"]);
			$couleur = $LieuEdit["couleur"];
			$angle = $LieuEdit["angle"];
			if ($LieuEdit["istext"] == "0") {
				//$checked = "";
				$angleEnabled = "disabled=\"disabled\"";
			}
			else {
				//$checked = " checked";
				$angleEnabled = "";
			}
			//$cc_istext = '<input type="checkbox" name="istext" value="1"'.$checked.' onclick="this.form.isbordure.checked=false;typepoint(this.form)" />';
			
			$bordure = $LieuEdit["bordure"];
			$b_visibilite = $LieuEdit["b_visibilite"];
			$b_epaisseur = $LieuEdit["b_epaisseur"];
			$b_opacite = $LieuEdit["b_opacite"];
			$b_couleur = $LieuEdit["b_couleur"];
			if ($LieuEdit["isbordure"] == "0") {
				//$checked_b = "";
				$opaciteEnabled = "disabled=\"disabled\"";
			}
			else {
				//$checked_b = " checked";
				$opaciteEnabled = "";
			}
			//$cc_isbordure = '<input type="checkbox" name="isbordure" value="1"'.$checked_b.' onclick="this.form.istext.checked=false;typepoint(this.form)" />';
			
			if ($LieuEdit["istext"] == "0" && $LieuEdit["isbordure"] == "0"){
				$br_ispicto = '<input type="radio" name="typeLieu" value="picto" checked onclick="typepoint(this.form,this.value)" />';
			}
			if ($LieuEdit["istext"] == "1"){
				$br_istexte = '<input type="radio" name="typeLieu" value="texte" checked onclick="typepoint(this.form,this.value)" />';
			}
			if ($LieuEdit["isbordure"] == "1"){
				$br_ispolygone = '<input type="radio" name="typeLieu" value="polygone" checked onclick="typepoint(this.form,this.value)" />';
			}
			if ($LieuEdit["b_plein"] == "1"){
				$cb_plein = '<input type="checkbox" name="b_plein" value="1" checked onchange="fix_poly(this.form)" />';
			}
		}
		
		$cb_plein = str_replace("<input", "<input ".$opaciteEnabled." ", $cb_plein);;
		
		$local_icone = ($icone=="")?$vars_mod["cheminIcones"]."/icns/empty.gif":$icone;
		
		//$menu_icones = $this->getMenuIcones($vars_mod["cheminIcones"],$icone);
		$menu_polices = $this->getMenuPolices($vars_mod["cheminPolices"],$police);
		$menu_polices = str_replace("<select", "<select ".$angleEnabled." ", $menu_polices);
		
		$lescartes = $this->sgbd->getCartes($My_SQL,"");
		$menu_cartes = '<select name="'.$vars_mod["id_carte"].'" size="1" class="saisie">';
		$menu_cartes .= '<option value="">'._CARTOCHOIXCARTEMENU.'</option>';
		foreach($lescartes as $unecarte) {
			if ($unecarte["Id"] == $carte) {
				$selected = " selected";
			}
			else {
				$selected = "";
			}
			$menu_cartes .= '<option value="'.$unecarte["Id"].'"'.$selected.'>'.$this->conditionnerHTML($unecarte["designation"]).'</option>';
		}
		$menu_cartes .= '</select>';
		
		//version pro
		global $module_name,$multilingual;
		if (file_exists("modules/".$module_name."/lib/pro/admin.inc")){
			require("pro/admin.inc");
		}
		else {
			$edit_lieu_pro = '
			<tr style="display: none">
				<td></td>
				<td>'.$br_istexte.'<input type="hidden" name="police" value="'.$police.'">
					<input type="hidden" name="policetemp" value="'.$this->lastElement($police,"/").'" /><input type="hidden" name="taille" value="'.$taille.'" />
					<input type="hidden" id="pick1101735855field" name="couleur" value="'.$couleur.'" /><input type="hidden" name="angle" value="'.$angle.'" />
					'.$br_ispolygone.'<input type="hidden" name="b_epaisseur" value="'.$b_epaisseur.'" />
					<input type="hidden" id="pick1101735856field" name="b_couleur" value="'.$b_couleur.'" /><input type="hidden" name="b_opacite" value="'.$b_opacite.'" />
					'.$cb_plein.'<br><textarea class="saisie" name="bordure" rows="4">'.$bordure.'</textarea>
					<br><textarea class="saisie" name="b_visibilite" rows="4">'.$b_visibilite.'</textarea>
					<a id="pick1101735855" href="#"></a>
					<a id="pick1101735856" href="#"></a><a id= "menutypo" href="#"></a>
					<br><input type="button" name="newpoly" /></td>
			</tr>';
		}
		
		//liens vers les autres modules
		$menus_modules = $this->get_links_modules($fiche);

		$formedit = '
		<center>
		<table border="0" cellpadding="0" cellspacing="0"><tr><td  valign="top">
		<div id="map" style="width: 630px; height: 430px"></div>
		<div align="center">
			<p>'._CARTOCLICKDESIGN.'</p>
		</div>
		</td><td>
		&nbsp;&nbsp;
		</td><td valign="top">
		<table border="0" cellpadding="0" cellspacing="0" class="observations">
		'.$vars_mod["sortie_action"].'
		<tr><td align="center">
			<form id="formfiche" action="system.php?op=carto&onglet=lieu&'.$vars_mod["action"].'=save" method="post" name="formfiche" onsubmit="return validForm(this);">
				<table border="0" cellspacing="2" cellpadding="0" class="noborder">
					<tr style="display: none">
						<td width="80" valign="top">'._CARTOLNGLIEU.'</td>
						<td align="left"><input class="saisie" type="text" name="longitude" value="'.$longitude.'" size="24"/></td>
					</tr>
					<tr>
						<td width="80" valign="top">'._CARTOMAP.'</td>
						<td align="left">'.$menu_cartes.'</td>
					</tr>
					<tr>
						<td width="80" valign="top">'._CARTONOMLIEU.'</td>
						<td align="left"><textarea class="saisie" name="lieu" rows="2" cols="40" onchange="fix_texte(this.form)">'.$lieu.'</textarea></td>
					</tr>
					<tr style="display: none">
						<td width="80" valign="top">'._CARTOLATLIEU.'</td>
						<td align="left"><input class="saisie" type="text" name="latitude" value="'.$latitude.'" size="24"/></td>
					</tr>
					<tr>
						<td width="80">'._CARTOPICTO.'</td>
						<td align = "left">
							<table border="0" cellpadding="0" cellspacing="0"><tr>
							<td  width="80">'.$br_ispicto.'</td>
							<td><input type="hidden" name="icone" value="'.$icone.'" />
							<img src="'.$local_icone.'" name="imgicone" /></td>
							<td><a id= "menupict" class="menupict" href="#" onclick="if (isPicto(document.formfiche)) { togglePopUpZPop(this,\''.addslashes(str_replace("\n"," ", str_replace("\"","'",$this->getLegendeIcones($vars_mod["cheminIcones"]."/pictos")))).'\',\'Choisissez un pictogramme\');hideAllPictos();};return false" title="'._CARTOPICTOBROWSE.'">'._CARTOPICTODISPO.'</a></td>
							</tr></table></td>
					</tr>
					'.$edit_lieu_pro.'
					<tr>
						<td width="80" valign="top">'._CARTOCOMMENTEDITLIEU.'</td>
						<td align="left"><textarea class="saisie" name="commentaire" rows="2" cols="40">'.$commentaire.'</textarea></td>
					</tr>
					<tr>
						<td width="80" valign="top">'._CARTOURL.'</td>
						<td align="left"><input class="saisie" type="text" name="fiche" id="fiche" value="'.$fiche.'" size="24"/><br/>
								'/*._CARTOPAGESDISPO.' '.$this->makeListPages("fixURL", $fiche).'<br/>
								'._CARTOMAPSSDISPO.' '.$this->makeListMaps("fixURL", $fiche).'<br>'*/.'</td>
					</tr>
					<tr>
						<td colspan="2">'.$menus_modules.'</td
					</tr>
					<tr>
						<td width="80" valign="top">'._CARTOTARGET.'</td>
						<td align="left"><input class="saisie" type="text" name="target" value="'.$target.'" size="24"/></td>
					</tr>
				</table>
				<p><input type="hidden" name="'.$vars_mod["id_lieu"].'" value="'.$vars_mod[$vars_mod["id_lieu"]].'"/><input type="reset" value="'._CARTOBOUTONANNUL.'" style="margin: 10px"/> <input type="submit" name="submitButtonName" value="'._CARTOBOUTONVALID.'" style="margin: 10px"/></p>
			</form>
		</td></tr>
		</table>
		</td></tr></table>
		</center>';
		return $formedit;
	}
	
	
/**
* Cre un menu pop-up contenant la liste des pages disponibles ordonnes par rubrique.
* 
* Cette fonction s'appuie sur la methode "getSectionList" du module "Sections".
* Elle est utilise pour lier le lien d'un picto  une page du site.
* @param string $nomselect Nom du menu pop-up
* @param string $link URL de le ligne de menu en cours
* @return string Chaine contenant le code HTML du menu pop-up
*/
	function makeListPages($nomselect, $link,$langue_en_cours="All") {
		$urlprefix = "modules.php?name=Sections&sop=viewarticle&artid=";
		$cc = new pageconnector();
		$sections = $cc->getSectionList();
		//$articles = $cc->getPageList("",false);
		$sortie = "<select name=\"$nomselect\" size=\"1\" onchange=\"if (this.value != '') {this.form.fiche.value = '$urlprefix'+this.value; }\" class=\"mpages\">";
		$sortie .= "<option value=\"\">" . _CARTOPAGESSDISPOCHOIX . "</option>";
		foreach ($sections as $section) {
			$sortie .= "<option value=\"\">" . $section[1] . "</option>";
			$articles = $cc->getPageList($section[0], false);
			if ($articles != "") {
				foreach ($articles as $article) {
					if ($urlprefix . $article[0] == $link) {
						$selected = "selected=\"selected\"";
					} else {
						$selected = "";
					}
					$sortie .= "<option value=\"" . $article[0] . "\" $selected> -> " . $article[1] . "</option>";
				}
			}
		}
		$sortie .= "</select>";
		return $sortie;
	}
/**
* Cre un menu pop-up contenant la liste des pages disponibles ordonnes par rubrique.
* 
* Cette fonction s'appuie sur la methode "getSectionList" du module "Sections".
* Elle est utilise pour lier une page du site  la carte.
* @param string $nomselect Nom du menu pop-up
* @param string $link URL de le ligne de menu en cours
* @return string Chaine contenant le code HTML du menu pop-up
*/
	function makeListPagesContent($nomselect, $link,$langue_en_cours="All") {
		$urlprefix = "";
		$cc = new pageconnector();
		$sections = $cc->getSectionList();
		//$articles = $cc->getPageList("",false);
		$sortie = "<select name=\"$nomselect\" size=\"1\" class=\"mpages\">";
		$sortie .= "<option value=\"\">" . _CARTOPAGESSDISPOCHOIX . "</option>";
		foreach ($sections as $section) {
			$sortie .= "<option value=\"\">" . $section[1] . "</option>";
			$articles = $cc->getPageList($section[0], false);
			if ($articles != "") {
				foreach ($articles as $article) {
					if ($urlprefix . $article[0] == $link) {
						$selected = "selected=\"selected\"";
					} else {
						$selected = "";
					}
					$sortie .= "<option value=\"" . $article[0] . "\" $selected> -> " . $article[1] . "</option>";
				}
			}
		}
		$sortie .= "</select>";
		return $sortie;
	}
/**
* Cre un menu pop-up contenant la liste des cartes disponibles.
* 
* Cette fonction s'appuie sur la methode "getMaps" du module "SimpleCarto".
* Elle est utilise pour lier le lien d'un oicto  une autre carte du site.
* @param string $nomselect Nom du menu pop-up
* @param string $link URL de le ligne de menu en cours
* @return string Chaine contenant le code HTML du menu pop-up
*/
	function makeListMaps($nomselect, $link,$langue_en_cours="All") {
		global $module_name;
		if (file_exists("modules/".$module_name."/lib/pro/admin.inc")){
			$urlprefix = "modules.php?name=".$module_name."&sop=display&br=1&bl=TC&tl=0&ic=1&pl=1&Idc=";
		}
		else {
			$urlprefix = "modules.php?name=".$module_name."&sop=display&br=1&bl=T&tl=0&ic=1&pl=0&Idc=";
		}
		$cc = new mapconnector();
		$maps = $cc->getMaps();
		$sortie = "<select name=\"$nomselect\" size=\"1\" onchange=\"if (this.value != '') {this.form.Furl.value = '$urlprefix'+this.value; }\" class=\"pages\">";
		$sortie .= "<option value=\"\">" . _CARTOMAPSSDISPOCHOIX . "</option>";
		foreach ($maps as $map) {
			if ($urlprefix . $map[0] == $link) {
				$selected = "selected=\"selected\"";
			} else {
				$selected = "";
			}
			$sortie .= "<option value=\"" . $map[0] . "\" $selected> -> " . $map[1] . "</option>";
		}
		$sortie .= "</select>";
		return $sortie;
	}
/**
* Duplique le lieu dsign et renvoie le rsultat de l'opration en HTML.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @return string Rsultat de l'opration en HTML.
*/
	function duppl_lieu($My_SQL,$vars_mod) {
		if ($this->sgbd->dupplLieu($My_SQL,$vars_mod[$vars_mod["id_lieu"]],"")) {
			$sortie = "<tr><th colspan=\"2\">"._CARTOLIEUDUPPLOK."</th></tr>";
		}
		else {
			$sortie = "<tr><th colspan=\"2\">"._CARTOLIEUDUPPLPASOK."</th></tr>";
		}
		return $sortie;
	}
/**
* Enregistre le lieu transmis et renvoie le rsultat de l'opration en HTML.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $lelieu Tableau contenant toutes les variables passes dans l'URL
* @return string Rsultat de l'opration en HTML.
*/
	function save_lieu ($My_SQL,$lelieu) {
		if ($this->sgbd->saveLieu($My_SQL,$lelieu)) {
			if ($lelieu["Id"] == "-1") {
				$savedIndex = $this->sgbd->getLastId($My_SQL);
			}
			else {
				$savedIndex = $lelieu["Id"];
			}
			$sortie = "<tr><th colspan=\"2\">"._CARTOLIEUSAVEOK."</th></tr>";
		}
		else {
			$sortie = "<tr><th colspan=\"2\">"._CARTOLIEUSAVEPASOK."</th></tr>";
		}
		return $sortie;
	}
/**
* Demande confirmation de la suppression de l'lment dsign.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @param message $message Message affich  l'utilisateur pour confirmer la suppression
* @return string Message  afficher en HTML.
*/	
	function confirm_delete($My_SQL,$vars_mod,$message) {
		$sortie = "<center>";
		$sortie .= "<p>$message</p>";
		$sortie .= "<p>&nbsp;</p>";
		$sortie .= "<p>";
		if ($vars_mod[$vars_mod["action"]] == "delete") {
			$sortie .= '<a href="system.php?op=carto&onglet=lieu&'.$vars_mod["action"].'='.$vars_mod[$vars_mod["action"]].'&'.$vars_mod["id_lieu"].'='.$vars_mod[$vars_mod["id_lieu"]].'&'.$vars_mod["id_carte"].'='.$vars_mod[$vars_mod["id_carte"]].'&'.$vars_mod["confirm"].'=y">';
		}
		if ($vars_mod[$vars_mod["action"]] == "delete_carte"){
			$sortie .= '<a href="system.php?op=carto&onglet=carte&'.$vars_mod["action"].'='.$vars_mod[$vars_mod["action"]].'&'.$vars_mod["id_carte"].'='.$vars_mod[$vars_mod["id_carte"]].'&'.$vars_mod["confirm"].'=y">';
		}
		$sortie .= "["._CARTOCONFSUPPROUI."]";
		$sortie .= "</a>";
		$sortie .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
		$sortie .= '<a href="javascript:window.history.back()">';
		$sortie .= "["._CARTOCONFSUPPRNON."]";
		$sortie .= '</a>';
		$sortie .= "</p>";
		$sortie .= "</center>";
		return $sortie;
	}
/**
* Supprime le lieu transmis et renvoie le rsultat de l'opration en HTML.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @return string Rsultat de l'opration en HTML.
*/
	function delete_lieu($My_SQL,$vars_mod) {
		if ($this->sgbd->delLieu($My_SQL,$vars_mod[$vars_mod["id_lieu"]])) {
			$sortie = "<tr><th colspan=\"2\">"._CARTOLIEUDELOK."</th></tr>";
		}
		else {
			$sortie = "<tr><th colspan=\"2\">"._CARTOLIEUDELPASOK."</th></tr>";
		}
		return $sortie;
	}
	
function get_links_pages($current_link="") {
		global $currentlang;
		$mod_title = "Sections";
		$menus_modules = "";
		if (file_exists("modules/$mod_title/system/menus.php")) {
			include("modules/$mod_title/system/language/lang-".$currentlang.".php");
			include("modules/$mod_title/system/menus.php");
			$menus_modules .= "<tr>";
			$menus_modules .= "<td width=\"130\">".$label_menu_ids."</td>";
			$menus_modules .= "<td><select name=\"page\" size=\"1\" class=\"pages\">";
			$menus_modules .= "<option value=\"\">"._DEITMENUFIRSTLINEDISPOS."</option>";
			$withgroup = false;
			foreach ($module_menus_ids as $module_menu) {
				//if (strtoupper($module_menu["language"]) == strtoupper($typeMenu[0]["langue"]) || $module_menu["language"] == "") {
					if ($module_menu["link"] == "") {
						//$menus_modules .= "<option value=\"\">".$module_menu["label"]."</option>";
						$menus_modules .= ($withgroup) ? "</optgroup>" : "";
						$menus_modules .= "<optgroup label=\"".$module_menu["label"]."\">";
					}
					else {
						if ($module_menu["link"] == $current_link) {
							$selected = " selected=\"selected\"";
						} else {
							$selected = "";
						}
						if ($multilingual=="1" && $module_menu["language"] != "") {
							$lalangue = " (".$module_menu["language"].")";
						}
						else {
							$lalangue = "";
						}
						$menus_modules .= "<option value=\"".$module_menu["link"]."\"".$selected.">".$module_menu["label"].$lalangue."</option>";
					}
				//}
			}
			$menus_modules .= ($withgroup) ? "</optgroup>" : "";
			$menus_modules .= "</select></td>";
			$menus_modules .= "</tr>";
		}	
		$menus_modules .= "";
		return $menus_modules;
	}
	
/**
* Renvoie le formulaire d'dition de la carte dsigne.
* 
* Ce tableau permet de crer, modifier ou supprimer la carte.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @return string Formulaire HTML de la carte.
*/
	function edit_carte($My_SQL,$vars_mod) {
		
		$latitudeinit = "";
		$longitudeinit = "";
		$zoominit = "";
		$zoomclic = "";
		$designation = "";
		$bordure = "";
		$visibilite = "";
		$couleur = "";
		$epaisseur = "";
		$opacite = "";
		$commentaire = "";
		$page = "";
		$print = "0";
		$bulles = "1";
		$limites = "1";
		$polygones = "1";
		$pictos = "1";
		$legende = "0";
		$type = "M";
		$mini = "1";
		$titre = "1";
		$commenter = "1";
		$seuil = "0";
		$controles = "1";
		$taille = "";
		$zoommax = "";
		$zoommin = "";
	
		if ($vars_mod[$vars_mod["id_carte"]] != "-1") {
			$carteEdit = $this->sgbd->getCartes($My_SQL,$vars_mod[$vars_mod["id_carte"]]);
			$CarteEdit = $carteEdit[0];
			$latitudeinit = $CarteEdit["latitudeinit"];
			$longitudeinit = $CarteEdit["longitudeinit"];
			$zoominit = $CarteEdit["zoominit"];
			$zoomclic = $CarteEdit["zoomclic"];
			$designation = $this->conditionnerFORM($CarteEdit["designation"]);
			$bordure = $CarteEdit["bordure"];
			$visibilite = $CarteEdit["visibilite"];
			$epaisseur = $CarteEdit["epaisseur"];
			$couleur = $CarteEdit["couleur"];
			$opacite = $CarteEdit["opacite"];
			$commentaire = $CarteEdit["commentaire"];
			$page = $CarteEdit["page"];
			$print = $CarteEdit["print"];
			$bulles = $CarteEdit["bulles"];
			$limites = $CarteEdit["limites"];
			$polygones = $CarteEdit["polygones"];
			$pictos = $CarteEdit["pictos"];
			$legende = $CarteEdit["legende"];
			$type = $CarteEdit["type"];
			$mini = $CarteEdit["mini"];
			$titre = $CarteEdit["titre"];
			$commenter = $CarteEdit["commenter"];
			$seuil = $CarteEdit["seuil"];
			$controles = $CarteEdit["controles"];
			$taille = $CarteEdit["taille"];
			$zoommax = $CarteEdit["zoommax"];
			$zoommin = $CarteEdit["zoommin"];
		}
		
		$all_options = '<table border="0" cellpadding="2" cellspacing="0"></tr><td>';
		$checked1 = ($print == "1") ? ' checked="checked"' : "";
		$checked2 = ($print != "1") ? ' checked="checked"' : "";
		$all_options .= 'Bouton impression : </td><td><input type ="radio" name="print" value="1" '.$checked1.'id="printon" disabled="disabled"><label for="printon">oui</label> <input type ="radio" name="print" value="0" '.$checked2.' id="printoff"><label for="printoff">non</label>';
		$all_options .= "</td></tr>\n<tr><td>";
		$vals = array ("Texte"=>"T", "Texte et carte"=>"TC", "Carte"=>"C");
		$menu = '<select name="bulles" size="1">';
		foreach ($vals as $key=>$val) {
			$sel = ($val == $bulles) ? ' selected="selected"' : "";
			$menu .= '<option value="'.$val.'"'.$sel.'>'.$key.'</option>';
		}
		$menu .= "</select>";
		$all_options .= 'Type de bulle : </td><td>'.$menu;
		$all_options .= "</td></tr>\n<tr><td>";
		$checked1 = ($limites == "1") ? ' checked="checked"' : "";
		$checked2 = ($limites != "1") ? ' checked="checked"' : "";
		$all_options .= 'Trac : </td><td><input type ="radio" name="limites" value="1" '.$checked1.'id="limon"><label for="limon">oui</label> <input type ="radio" name="limites" value="0" '.$checked2.' id="limoff"><label for="limoff">non</label>';
		$all_options .= "</td></tr>\n<tr><td>";
		$checked1 = ($polygones == "1") ? ' checked="checked"' : "";
		$checked2 = ($polygones != "1") ? ' checked="checked"' : "";
		$all_options .= 'Polygones : </td><td><input type ="radio" name="polygones" value="1" '.$checked1.'id="polyon"><label for="polyon">oui</label> <input type ="radio" name="polygones" value="0" '.$checked2.' id="polyoff"><label for="polyoff">non</label>';
		$all_options .= "</td></tr>\n<tr><td>";
		$checked1 = ($pictos == "1") ? ' checked="checked"' : "";
		$checked2 = ($pictos != "1") ? ' checked="checked"' : "";
		$all_options .= 'Pictos : </td><td><input type ="radio" name="pictos" value="1" '.$checked1.'id="pictoson"><label for="pictoson">oui</label> <input type ="radio" name="pictos" value="0" '.$checked2.' id="pictosoff"><label for="pictosoff">non</label>';
		$all_options .= "</td></tr>\n<tr><td>";
		$checked1 = ($legende == "1") ? ' checked="checked"' : "";
		$checked2 = ($legende != "1") ? ' checked="checked"' : "";
		$all_options .= 'Lgende : </td><td><input type ="radio" name="legende" value="1" '.$checked1.'id="legon"><label for="legon">oui</label> <input type ="radio" name="legende" value="0" '.$checked2.' id="legoff"><label for="legoff">non</label>';
		$all_options .= "</td></tr>\n<tr><td>";
		//$vals = array ("Plan"=>"P", "Satellite"=>"S", "Mixte"=>"M", "Relief"=>"R", "Earth"=>"3D");
		$vals = array ("Plan"=>"P", "Satellite"=>"S", "Mixte"=>"M", "Relief"=>"R");
		$menu = '<select name="type" size="1">';
		foreach ($vals as $key=>$val) {
			$sel = ($val == $type) ? ' selected="selected"' : "";
			$menu .= '<option value="'.$val.'"'.$sel.'>'.$key.'</option>';
		}
		$menu .= "</select>";
		$all_options .= 'Type de carte : </td><td>'.$menu;
		$all_options .= "</td></tr>\n<tr><td>";
		$checked1 = ($mini == "1") ? ' checked="checked"' : "";
		$checked2 = ($mini != "1") ? ' checked="checked"' : "";
		$all_options .= 'Mini carte : </td><td><input type ="radio" name="mini" value="1" '.$checked1.'id="minion"><label for="minion">oui</label> <input type ="radio" name="mini" value="0" '.$checked2.' id="minioff"><label for="minioff">non</label>';
		$all_options .= "</td></tr>\n<tr><td>";
		$checked1 = ($titre == "1") ? ' checked="checked"' : "";
		$checked2 = ($titre != "1") ? ' checked="checked"' : "";
		$all_options .= 'Titre : </td><td><input type ="radio" name="titre" value="1" '.$checked1.'id="titreon"><label for="titreon">oui</label> <input type ="radio" name="titre" value="0" '.$checked2.' id="titreoff"><label for="titreoff">non</label>';
		$all_options .= "</td></tr>\n<tr><td>";
		$checked1 = ($commenter == "1") ? ' checked="checked"' : "";
		$checked2 = ($commenter != "1") ? ' checked="checked"' : "";
		$all_options .= 'Commentaires : </td><td><input type ="radio" name="commenter" value="1" '.$checked1.'id="common"><label for="common">oui</label> <input type ="radio" name="commenter" value="0" '.$checked2.' id="commoff"><label for="commoff">non</label>';
		$all_options .= "</td></tr>\n<tr><td>";
		$all_options .= 'Seuil texte : </td><td><input type ="text" name="seuil" value="'.$seuil.'" size ="10">';
		$all_options .= "</td></tr>\n<tr><td>";
		$checked1 = ($controles == "1") ? ' checked="checked"' : "";
		$checked2 = ($controles != "1") ? ' checked="checked"' : "";
		$all_options .= 'Controles : </td><td><input type ="radio" name="controles" value="1" '.$checked1.'id="ctlon"><label for="ctlon">oui</label> <input type ="radio" name="controles" value="0" '.$checked2.' id="ctloff"><label for="ctloff">non</label>';
		$all_options .= "</td></tr>\n<tr><td>";
		$all_options .= 'Dimensions (l/h) : </td><td><input type ="text" name="taille" value="'.$taille.'" size ="10">';
		$all_options .= "</td></tr>\n<tr><td>";
		$all_options .= 'Zoom minimal : </td><td><input type ="text" name="zoommin" value="'.$zoommin.'" size ="10">';
		$all_options .= "</td></tr>\n<tr><td>";
		$all_options .= 'Zoom maximal : </td><td><input type ="text" name="zoommax" value="'.$zoommax.'" size ="10">';
		$all_options .= '</td></tr></table>';
		/*
		$menu_icones = getMenuIcones($vars_mod["cheminIcones"],$icone);
		$menu_polices = getMenuPolices($vars_mod["cheminPolices"],$police);
		$menu_polices = str_replace("<select", "<select ".$angleEnabled." ", $menu_polices);
		*/
		$formedit = '
		<center>
		<table border="0" cellpadding="0" cellspacing="0"><tr><td  valign="top">
		<div id="map" style="width: 630px; height: 430px"></div>
		<!--<div align="center">
			<p>'._CARTOCLICKCENTER.'.</p>
		</div>-->
		</td><td>
		&nbsp;&nbsp;
		</td><td valign="top">
		<table border="0" cellpadding="0" cellspacing="0" class="observations">
		'.$vars_mod["sortie_action"].'
		<tr><td align="center">
			<form id="formfiche" action="system.php?op=carto&onglet=carte&'.$vars_mod["action"].'=save_carte" method="post" name="formfiche" onsubmit="return validForm2(this);">
				<table border="0" cellspacing="2" cellpadding="0" class="noborder">
					<tr>
						<td width="130">'._CARTOCARTEEDIT.'</td>
						<td><input class="saisie" type="text" name="designation" value="'.$designation.'" size="24"/></td>
					</tr>
					<tr>
						<td colspan="2">
							<table border="0" cellspacing="2" cellpadding="0">
								<tr>
									<td width="130">'._CARTOLAT.'</td>
									<td><input class="saisie" type="text" name="latitude" value="'.$latitudeinit.'" size="24"/></td>
								</tr>
								<tr>
									<td width="130">'._CARTOLNG.'</td>
									<td><input class="saisie" type="text" name="longitude" value="'.$longitudeinit.'" size="24"/></td>
								</tr>
								<tr>
									<td width="130">'._CARTOZOOMINIT.'</td>
									<td><input class="saisie" type="text" name="zoominit" value="'.$zoominit.'" size="24"/></td>
								</tr>
								<tr>
									<td width="130"></td>
									<td><input type="button" value="'._CARTOBOUTONRECUP.'" onclick="getMapValues(this.form.latitude,this.form.longitude,this.form.zoominit )"></td>
								</tr>
							</table>	</td>
					</tr>
					<tr style="display: none">
						<td width="130">'._CARTOZOOMCLIC.'</td>
						<td><input class="saisie" type="text" name="zoomclic" value="'.$zoomclic.'" size="24"/><br /><input type="button" value="'._CARTOBOUTONRECUP.'" onclick="getZoomClic(this.form.zoomclic)"></td>
					</tr>
					<tr>
						<td width="130">'._CARTOZOOMTRACE.'</td>
						<td align="left" nowrap="nowrap">
							<table border="0" cellspacing="2" cellpadding="0">
								<tr>
									<td rowspan="3"><input type="button" name="newpoly" value="'._CARTOPOLYEDIT.'" onclick="open_new_poly()" />&nbsp;&nbsp;</td>
									<td>'._CARTOPOLYEPAISSEUR.'</td>
									<td><input type="text" name="b_epaisseur" value="'.$epaisseur.'" size="3" maxlength="3" onchange="fix_poly(this.form)" /></td>
								</tr>
								<tr>
									<td>'._CARTOPOLYCOULEUR.'</td>
									<td><input type="hidden" id="pick1101735856field" name="b_couleur" value="'.$couleur.'" size="7"/><a id="pick1101735856" style="display: block; width: 20px; margin: 2px; padding: 0; border: 1px solid #000000; font-family: \'verdana\'; font-size: 12px; text-decoration: none" onclick="pickColor(\'pick1101735856\');return false" href="#">&nbsp</a><script type="text/javascript">relateColor(\'pick1101735856\', getObj(\'pick1101735856field\').value);</script></td>
								</tr>
								<tr>
									<td>'._CARTOPOLYOPACITE.'</td>
									<td><input type="text" name="b_opacite" value="'.$opacite.'" size="3" maxlength="3" onchange="fix_poly(this.form)" /></td>
								</tr>
							</table>
							<div style="display: none">
							<p>Bordure :<br /><!--<input type="text" class="saisie" name="bordure" cols="40" value="'.$bordure.'" />-->
									<textarea class="saisie" name="bordure" rows="4">'.$bordure.'</textarea>
							<p>Visibilit :<br /><!--<input type="text" class="saisie" name="b_visibilite" cols="40" value="'.$visibilite.'" />-->
									<textarea class="saisie" name="b_visibilite" rows="3">'.$visibilite.'</textarea></p>
							</div></td>
					</tr>
					<tr>
						<td width="130">'._CARTOCOMMENTEDIT.'</td>
						<td><textarea class="saisie" name="commentaire" rows="3">'.$commentaire.'</textarea></td>
					</tr>
					'/*.'<tr>
						<td width="130">'._CARTOPAGESDISPO.'</td>
						<td>'.$this->makeListPagesContent("page", $page).'</td>
					</tr>
					'*/.$this->get_links_pages($page).'
					<tr>
						<td width="130">'._CARTOOPTIONEDIT.'</td>
						<td>'.$all_options.'</td>
					</tr>
					<tr style="height: 20px">
						<td width="130"> </td>
						<td> </td>
					</tr>
				</table>
				<p><input type="hidden" name="auteur" value="'.$vars_mod["auteur"].'"/><input type="hidden" name="'.$vars_mod["id_carte"].'" value="'.$vars_mod[$vars_mod["id_carte"]].'"/><input type="reset" name="cancelButtonName" value="'._CARTOBOUTONANNUL.'" style="margin: 10px" /><input type="submit" name="submitButtonName" value="'._CARTOBOUTONVALID.'" style="margin: 10px" /></p>
			</form>
		</td></tr>
		</table>
		</td></tr>
		</table>
		</center>';
		return $formedit;
	}
/**
* Duplique la carte dsigne et renvoie le rsultat de l'opration en HTML.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @return string Rsultat de l'opration en HTML.
*/
	function duppl_carte($My_SQL,$vars_mod) {
		if ($this->sgbd->dupplCarte($My_SQL,$vars_mod[$vars_mod["id_carte"]])) {
			$sortie = "<tr><th colspan=\"2\">"._CARTODUPPLOK."</th></tr>";
		}
		else {
			$sortie = "<tr><th colspan=\"2\">"._CARTODUPPLPASOK."</th></tr>";
		}
		return $sortie;
	}
/**
* Enregistre la carte transmise et renvoie le rsultat de l'opration en HTML.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $lacarte Tableau contenant toutes les variables passes dans l'URL
* @return string Rsultat de l'opration en HTML.
*/
	function save_carte ($My_SQL,$lacarte) {
		if ($this->sgbd->saveCarte($My_SQL,$lacarte)) {
			if ($lacarte["Id"] == "-1") {
				$savedIndex = $this->sgbd->getLastId($My_SQL);
			}
			else {
				$savedIndex = $lacarte["Id"];
			}
			$sortie = "<tr><th colspan=\"2\">"._CARTOSAVEOK."</th></tr>";
		}
		else {
			$sortie = "<tr><th colspan=\"2\">"._CARTOSAVEPASOK."</th></tr>";
		}
		return $sortie;
	}
/**
* Supprime la carte dsigne et renvoie le rsultat de l'opration en HTML.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @return string Rsultat de l'opration en HTML.
*/
	function delete_carte($My_SQL,$vars_mod) {
		if ($this->sgbd->delCarte($My_SQL,$vars_mod[$vars_mod["id_carte"]])) {
			$sortie = "<tr><th colspan=\"2\">"._CARTODELOK."</th></tr>";
		}
		else {
			$sortie = "<tr><th colspan=\"2\">"._CARTODELPASOK."</th></tr>";
		}
		return $sortie;
	}
/**
* Renvoie un tableau HTML listant toutes les cartes.
* 
* Ce tableau permet de crer, modifier ou supprimer les cartes.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @return string Tableau HTML des cartes.
*/
	function get_cartes($My_SQL,$vars_mod) {
		$cartes = $this->sgbd->getCartes($My_SQL,"",$vars_mod[$vars_mod["tri"]]);
		$lescartes = "";
		if (count($cartes) != 0) {
			$lescartes = '
				<table  class=lisTable>
				<tr class=systemTabHeader>
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list_carte&op=carto&onglet=carte&'.$vars_mod["tri"].'=designation">'._CARTOCARTE.'</a></th>
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list_carte&op=carto&onglet=carte&'.$vars_mod["tri"].'=auteur">'._CARTOAUTEUR.'</a></th>
					<th class="systemTabHeader"><a href="system.php?'.$vars_mod["action"].'=list_carte&op=carto&onglet=carte&'.$vars_mod["tri"].'=creation">'._CARTOCREATION.'</a></th>
    					<th class="systemTabHeader">'._CARTOCOMMENT.'</th>
    					<th class="systemTabHeader">'._CARTOACTIONCARTE.'</th>
    					<th class="systemTabHeader">'._CARTOACTIONLIEUCARTE.'</th>
    				</tr>';	
			/*
			$lescartes = '<table border="0" cellpadding="0" cellspacing="0" class="observations">';
			$lescartes .= '<tr><th colspan="5">Lieux cartogaphi&eacute;s</th><td rowspan="2"><a href="editplot.php?'.$vars_mod["action"].'=new_carte">[nouvelle]</a></td></tr>';
			$lescartes .= '<tr><th>Dsignation</th><th>Latitude centre</th><th>Longitude centre</th><th>Zoom init</th><th>ZoomClic</th></tr>';
			*/
			$pos=0;
			foreach ($cartes as $carte) {
				if ($pos % 2 ==0){$thestyle="listTableOdd";} else {$thestyle="listTableNone";}
				$pos++;
				
				$lescartes .= '<tr class="'.$thestyle.'">';
				$lescartes .= '<td>';
				//$lescartes .= '<a href="system.php?op=carto&'.$vars_mod["action"].'=list&'.$vars_mod["id_carte"].'='.$carte["Id"].'&onglet=lieu">';
				$lescartes .= '<b>';
				$lescartes .= $this->conditionnerHTML($carte["designation"]);
				$lescartes .= '</b>';
				//$lescartes .= '</a>';
				$lescartes .= '</td><td align="center">';
				$lescartes .= $this->conditionnerHTML($carte["auteur"]);
				$lescartes .= '</td><td align="center">';
				$lescartes .= $this->conditionnerHTML($carte["creation"]);
				$lescartes .= '</td><td align="center">';
				$lescartes .= $this->conditionnerHTML($carte["commentaire"]);
				$lescartes .= '</td><td  align="center">';
				
				//version pro
				global $module_name;
				if (file_exists("modules/".$module_name."/lib/pro/admin.inc")){
					require("pro/admin.inc");
				}
				else {
					$barDefL=array(	"view"=> array( "text"=>_PREVIEW,"icon"=>"icon_eye.gif","url"=>"modules.php?name=SimpleCarto&sop=display&".$vars_mod["limites"]."=1&".$vars_mod["bulles"]."=T&".$vars_mod["legende"]."=1&".$vars_mod["pictos"]."=1&".$vars_mod["id_carte"]."=".$carte["Id"]."&".$vars_mod["polygones"]."=1","comment"=>_PREVIEW, "status"=>"ON"),
								"edit"=> array( "text"=>_EDIT,"icon"=>"edit_16x16.png","url"=>"system.php?op=carto&".$vars_mod["action"]."=edit_carte&".$vars_mod["id_carte"]."=".$carte["Id"]."&onglet=carte","comment"=>_EDIT, "status"=>"ON"),
  					  			"delete"=> array( "text"=>_DELETE,"icon"=>"delete_16x16.png","url"=>"system.php?op=carto&".$vars_mod["action"]."=delete_carte&".$vars_mod["id_carte"]."=".$carte["Id"]."&onglet=carte","comment"=>_DELETE,"status"=>"ON"));
				}
				

	    			$lescartes .= displayActionBar("add","Bar d'action",$barDefL,"img","",true);
				$lescartes .= '</td>';
				$lescartes .= '</td><td  align="center">';
				$barDef=array(	"listing"=> array( "text"=>_CARTOLISTING,"icon"=>"folder.gif","url"=>"system.php?op=carto&".$vars_mod["action"]."=list&".$vars_mod["id_carte"]."=".$carte["Id"]."&onglet=lieu","comment"=>_CARTOLISTING,"status"=>"ON"),
  					  			"add"=> array( "text"=>_CARTOADD,"icon"=>"folderPlus.gif","url"=>"system.php?".$vars_mod["action"]."=new&op=carto&onglet=lieunew&".$vars_mod["id_carte"]."=".$carte["Id"],"comment"=>_CARTOADD,"status"=>"ON"));

	    			$lescartes .= displayActionBar("add","Bar d'action",$barDef,"img","",true);
				$lescartes .= '</td>';
				$lescartes .= '</tr>';
			}
			$lescartes .= '</table>';
		}
		return $lescartes;
	}
/**
* Renvoie la carte dsigne.
* 
* Si la carte est introuvable ou que sont identifiant est -1, une carte vide est retourn.
* @param array $My_SQL Paramtres de la base de donnes
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @return array Tous les champs de la carte.
*/
	function get_carte_edit($My_SQL,$vars_mod) {
		if ($vars_mod[$vars_mod["id_carte"]] != "-1") {
			$carteEdit = $this->sgbd->getCartes($My_SQL,$vars_mod[$vars_mod["id_carte"]],"");
			if (count($carteEdit) == 0) {
				$CarteEdit = array("Id" => "","latitudeinit" => "","longitudeinit" => "","zoominit" => "","zoomclic" => "","designation" => "","bordure" => "","visibilite" => "","couleur" => "","epaisseur" => "","opacite" => "","auteur" => "", "commentaire" => "", "page" => "");
							
			}
			else {
				$CarteEdit = $carteEdit[0];
			}
		}
		else {
			$CarteEdit = array("Id" => "","latitudeinit" => "","longitudeinit" => "","zoominit" => "","zoomclic" => "","designation" => "","bordure" => "","visibilite" => "","couleur" => "","epaisseur" => "","opacite" => "","auteur" => "", "commentaire" => "", "page" => "");
		}
		return $CarteEdit;
	}
/**
* Rcupre la valeur de l'indentifiant du dernier enregistrement cr.
* @param array $My_SQL Paramtres de la base de donnes
* @return integer Identifiant
*/
	function getLastId($My_SQL) {
		return $this->sgbd->getLastId($My_SQL);
	}
/**
* Prpare les donnes  tre enregistres dans la base de donnes en codant les apostrophes.
* @param string $texte Texte  prparer
* @return string Texte encod.
*/
	function conditionnertodb($texte) {
		//$texte = utf8_encode($texte);
		return (str_replace("'","''",stripslashes($texte)));
	}
/**
* Prpare les donnes  tre affiches en HTML.
* @param string $texte Texte  prparer
* @return string Texte encod.
*/
	function conditionnerHTML($texte) {
		//return (htmlentities($texte,ENT_QUOTES,UTF-8));
		return $texte;
	}
/**
* Prpare les donnes  tre envoyes aux procdures Javascript.
* @param string $texte Texte  prparer
* @return string Texte encod.
*/
	function conditionnerJS($texte, $doubleSlash=false) {
		if ($doubleSlash) {
			$texte = str_replace('"','\\\\"',$texte);
		}
		else {
			$texte = str_replace('"','\"',$texte);
		}
		$texte = str_replace("\n",'\n',$texte);
		$texte = str_replace("\r","",$texte);
		return $texte;
	}
/**
* Prpare les donnes  tre incluses dans les formulaires.
* @param string $texte Texte  prparer
* @return string texte encod.
*/
	function conditionnerFORM($texte) {
		return (str_replace('"','&quot;',$texte));
	}
/**
* Remplace une donne nulle ou vide par zero.
* @param string $valeur Valeur  tester.
* @return integer Valeur ou zero.
*/
	function notVide($valeur) {
		if ($valeur == "") {
			return 0;
		}
		else {
			return $valeur;
		}
	}
/**
* Prpare les donnes  tre exportes en XML.
* @param string $texte Texte  prparer
* @return string Texte encod.
*/
	function conditionnerXML($texte) {
		//$texte = str_replace("\n",'\n',$texte);
		//$texte = str_replace("\r","",$texte);
		$texte = utf8_encode($texte);
		return $texte;
	}
/**
* Retourne une date en format franais.
* @param string $valeur Date  convertir du format yyyymmdd
* @return string Date en format dd/mm/yyyy.
*/
	function dateF($valeur) {
		$an=substr($valeur, 0, 4);
		$mois=substr($valeur, 4, 2);
		$jour=substr($valeur, 6, 2);
		return $jour."/".$mois."/".$an;
	}
/**
* Retourne la dernire valeur de la chaine dont le sparateur est indiqu.
* @param string $valeur Chaine  traiter
* @param string $sep Sparateur  utiliser
* @return string Dernier lment de la chaine.
*/
	function lastElement($valeur, $sep) {
		$tab = explode($sep,$valeur);
		return $tab[count($tab)-1];
	}
/**
* Retourne la valeur octale envoye sous forme de droits (lecture, ecriture, excution).
* @param string $nombre Nombre  convertir
* @return string Texte encod.
*/
	function convertDroits($nombre) {
		switch ($nombre) {
			case 0:
				return "---";
				break;
			case 1:
				return "--x";
				break;
			case 2:
				return "-w-";
				break;
			case 3:
				return "-wx";
				break;
			case 4:
				return "r--";
				break;
			case 5:
				return "r-x";
				break;
			case 6:
				return "rw-";
				break;
			case 7:
				return "rwx";
				break;
			default:
				echo "Cette valeur de permission n'est pas valable : $droits !!!";
				return "error";
		}
	}
/**
* Convertit les droits d'un fichiers de la forme octale  la forme chaine de caractre.
* @param string $droits Droits  convertir.
* @return string Texte encod.
*/
	function num2strRights($droits) {
		$retour = "";
		for ($i=-3;$i<=-1;$i++) {
			$retour .= $this->convertDroits(substr($droits, $i, 1));
		}
		return $retour;
	}
/**
* Renvoie un tableau avec la liste des fichiers  partir de $chemin.
* 
* Tableau avec les champs suivants : ["name"],["path"],["level"],["kind"],["date"],["perms"],["size"],["owner"]
* @param string $chemin Chemin du dossier dont on veut lister le contenu.
* @param boolean $recursive Indique si le conteu des dossiers inclus doit galement tre list de manire rcursive.
* @return array Tableau contenant la liste des documents.
*/
	function listDossier($chemin,$recursive) {
		$temp=array();
		if ($chemin == "") {
			$chemin= ".";
		}
		$toutesFoncs =get_defined_functions ();
		$avecPosix = in_array ("posix_getpwuid",$toutesFoncs["internal"]);
		if (file_exists($chemin)) {
			if (is_dir($chemin)) {
				$niveau = substr_count ($chemin, "/");
				$handle = opendir("$chemin");
				while ($file = readdir($handle)) {
					if ($file != "." && $file != "..") {
						//cette partie est mise en commentaire pour des raisons de performances
						/*$laDate = date("d/m/Y H:i:s",filemtime("$chemin/$file"));
						$lesPerms = $this->num2strRights(decoct(fileperms("$chemin/$file")));
						$laTaille = filesize("$chemin/$file");
						if ($avecPosix) {
							$tabProprio = posix_getpwuid(fileowner("$chemin/$file"));
							$proprio = $tabProprio["name"];
						}
						else {
							$proprio = fileowner("$chemin");
						}*/
						$laDate = "";
						$lesPerms = "";
						$laTaille = "";
						$proprio = "";
						
						if (is_dir("$chemin/$file")) {
							array_push($temp,array("name" => $file, "path" => $chemin, "level" => $niveau, "kind" => "dir", "date" => $laDate, "perms" => $lesPerms, "size" => $laTaille, "owner" => $proprio));
							if ($recursive) {
								//array_push($temp,$this->listDossier("$chemin/$file",true)); //fabrique un tableau imbriqu
								$newTemp = $this->listDossier("$chemin/$file",$recursive); // fabrique (avec la boucle ci-dessous) un tableau linaire
								foreach ($newTemp as $ligne) {
									array_push($temp,array("name" => $ligne["name"], "path" => $ligne["path"], "level" => $ligne["level"], "kind" => $ligne["kind"], "date" => $ligne["date"], "perms" => $ligne["perms"], "size" => $ligne["size"], "owner" => $ligne["owner"]));
								}
							}
						}
						else {
							if (is_link("$chemin/$file")) {
								array_push($temp,array("name" => $file, "path" => $chemin, "level" => $niveau, "kind" => "link", "date" => $laDate, "perms" => $lesPerms, "size" => $laTaille, "owner" => $proprio));
							}
							else {
								array_push($temp,array("name" => $file, "path" => $chemin, "level" => $niveau, "kind" => "file", "date" => $laDate, "perms" => $lesPerms, "size" => $laTaille, "owner" => $proprio));
							}
						}
					}
				}
				closedir($handle);
			}
			else {
				array_push($temp,array("name" => "chemin incorrect - contactez votre webmaster !!", "path" => $chemin, "level" => 0, "kind" => "error"));
			}
		}
		return $temp;
	}
/**
* Renvoie un tableau HTML utilis pour faire le menu des icnes.
* 
* Ce tableau contient l'icne cliquable et leur nom, le tout tri par catgorie.
* @param string $chemin Chemin du dossier contenat les icnes.
* @return string Liste les icones encod en un tableau HTML et actions Javascript.
*/
	function getLegendeIcones($chemin) {
	
		$icones = $this->listDossier($chemin,"true");
		//print_r($icones);
		$premier = true;
		$compteur = 1;
		$legende = '<table border="0" cellspacing="0" cellpadding="0" class="menuPictolegende">';
		foreach ($icones as $icone) {
			if (substr($icone["name"],0,1) != "." && (!preg_match("#\.svn#",$icone["path"]))) {
				//$actiondeb = '<a href"#" onclick="document.images[&quot;imgicone&quot;].src=&quot;'.$icone["path"]."/".$icone["name"].'&quot; ; return false">';
				$actiondeb = '<a href"#" onclick="return fixPicto(&quot;'.$icone["path"]."/".$icone["name"].'&quot;)">';
				$actionfin = '</a>';
				$label = $this->conditionnerHTML($this->calibrer($icone["name"]));
				if ($icone["kind"] == "dir") {
					
					if (!$premier) {
						$legende .= '</table>';
						$legende .= '</td></tr>';
					}
					
					$cheminicone = "";
					$legende .= '<tr><th class="menuPictoGroup" id="headeric'.$compteur.'"><a href="#" onclick=" hideAllPictos();showPictos(&quot;'.$compteur.'&quot;);return false">'.$label.'</a></th></tr>';
					
					$legende .= '<tr id="listic'.$compteur.'"><td>';
					$legende .= '<table border="0" cellspacing="0" cellpadding="0" class="menuPictolegende2">';
					$compteur++;
				}
				if ($icone["kind"] == "file") {
					//$label = "&nbsp;&nbsp;&nbsp;&nbsp;&bull;".$label;
					$cheminicone = $icone["path"]."/".$icone["name"];
					$legende .= '<tr><td width="30">'.$actiondeb.'<img src="'.$cheminicone.'" />'.$actionfin.'</td><td>'.$actiondeb.$label.$actionfin.'</td></tr>';
				}
				$premier = false;
			}
		}
		$legende .= '</table>';
		$legende .= '</td></tr>';
		$legende .= '</table>';
		return $legende;
	}
/**
* Renvoie un tableau HTML utilis pour faire le menu des polices.
* 
* Ce tableau contient les polices disponibles.
* @param string $chemin Chemin du dossier contenat les polices.
* @param string $policeEnCours Police en cours.
* @return string Liste les polices encod en un tableau HTML et actions Javascript.
*/
	function getLegendePolices($chemin, $policeEnCours) {
		$polices = $this->listDossier($chemin,"true");
		$legende = '<table border="0" cellspacing="0" cellpadding="0" class="menuPolicelegende">';
		foreach ($polices as $police) {
			if (substr($police["name"],0,1) != "."  && (!preg_match("#\.svn#",$police["path"]))) {
				$actiondeb = '<a href"#" onclick="return fixPolice(&quot;'.$police["path"]."/".$police["name"].'&quot;)">';
				$actionfin = '</a>';
				$label = $this->conditionnerHTML($this->calibrer($police["name"]));
				$cheminpolice = $police["path"]."/".$police["name"];
				if ($policeEnCours == $police["path"]."/".$police["name"]) {
					$legende .= '<tr><td class="selected">&bull;'.$label.'</td></tr>';
				}
				else {
					$legende .= '<tr><td>'.$actiondeb.$label.$actionfin.'</td></tr>';
				}
			}
		}
		$legende .= '</table>';
		return $legende;
		
		
		/*
		$menu = "<select name=\"police\" size=\"1\" class=\"msaisie\">";
		$menu .= "<option value=\"\">"._CARTOCHOIXPOLICE."</option>";
		foreach ($polices as $police) {
			$label = htmlentities($police["name"], ENT_QUOTES);
			$cheminpolice = $police["path"]."/".$police["name"];
			if ($policeEnCours == $cheminpolice) {
				$selected = " selected";
			}
			else {
				$selected = "";
			}
			$menu .= "<option value=\"$cheminpolice\"$selected>$label</option>";
		}
		$menu .= "</select>";
		return $menu;
		*/
	}
/**
* Renvoie le nom des icnes modifi pour tre inclus dans le menu.
* @param string $texte Nom de l'icne.
* @return string Nom de l'icne trait.
*/
	function calibrer($texte) {
		$texte = str_replace("_"," ",$texte);
		$texte = str_replace("-"," ",$texte);
		$texte = preg_replace("#\.gif$#i", "", $texte);
		$texte = preg_replace("#\.jpg$#i", "", $texte);
		$texte = preg_replace("#\.jpeg$#i", "", $texte);
		$texte = preg_replace("#\.png$#i", "", $texte);
		return $texte;
	}
/**
* Renvoie un contrle SELECT contenant la liste des icnes.
* 
* Cette fonction n'est plus utilise. Elle a t remplace par getLegendeIcone, beaucoup plus sympathique.
* @param string $chemin Chemin du dossier contenant les icnes.
* @param string $iconeEnCours Nom de l'icne en cours pour fixer la position par dfaut du menu.
* @return string Liste les icones encode en un controle SELECT.
*/
	function getMenuIcones($chemin, $iconeEnCours) {
	
		$icones = $this->listDossier($chemin,"true");
		$menu = "<select name=\"icone\" size=\"1\"  class=\"saisie\">";
		$menu .= "<option value=\"\">Choisissez :</option>";
		$bascule = true;
		foreach ($icones as $icone) {
			if (substr($icone["name"],0,1) != ".") {
				$label = $this->conditionnerHTML($icone["name"]);
				if ($icone["kind"] == "dir") {
					$label = $label;
					$cheminicone = "";
				}
				if ($icone["kind"] == "file") {
					$label = "&nbsp;&nbsp;&nbsp;&nbsp;&bull;".$label;
					$cheminicone = $icone["path"]."/".$icone["name"];
				}
				if ($iconeEnCours == $cheminicone & $iconeEnCours != "") {
					$selected = " selected";
				}
				else {
					$selected = "";
				}
				$menu .= "<option value=\"$cheminicone\"$selected>$label</option>";
			}
		}
		$menu .= "</select>";
		return $menu;
	}
/**
* Fabrique le menu contenant la liste des polices.
* @param string $chemin Chemin du dossier contenant les police.
* @param string $policeEnCours Nom de la police en cours pour fixer la position par dfaut du menu.
* @return string Liste les polices encode en un controle SELECT.
*/
	function getMenuPolices($chemin, $policeEnCours) {
		$polices = $this->listDossier($chemin,"true");
		$menu = "<select name=\"police\" size=\"1\" class=\"msaisie\">";
		$menu .= "<option value=\"\">"._CARTOCHOIXPOLICE."</option>";
		foreach ($polices as $police) {
			$label = htmlentities($police["name"], ENT_QUOTES);
			$cheminpolice = $police["path"]."/".$police["name"];
			if ($policeEnCours == $cheminpolice) {
				$selected = " selected";
			}
			else {
				$selected = "";
			}
			$menu .= "<option value=\"$cheminpolice\"$selected>$label</option>";
		}
		$menu .= "</select>";
		return $menu;
	}
/**
* Calcule la taille du rectangle contenant un texte.
* 
* Ce texte peut tre inclin, de taille variable et de police quelconque
* @param string $t Texte dont la taille doit tre calcule.
* @param integer $angle Angle de la ligne de base du texte en degrs.
* @param string $fonte Nom de la police  utiliser.
* @param integer $taille Taille en pixels de la police  utiliser.
* @return string Largeur,Hauteur du rectangle contenant le texte.
*/	
	function tailleLieuDit($t,$angle,$fonte,$taille,$cheminPolices) {
		global $marge;
		
		if ($fonte == "") {
	        $fonte = $cheminPolices."/verdana.ttf";
	    }
		$police = realpath($fonte);
		if ($taille == "") {
			$taille = "8";
		}
		if ($t == "") {
			$t = "Aucun texte !";
		}
		if ($angle == "") {
			$angle = "0";
		}
		if (!isset($marge)) {
			$marge = "2";
		}
		
		//coordonnes du rectangle contenant le texte
		$boiteTexte = imageftbbox ($taille, $angle, $police, $t,array("linespacing" => 1.0));
		//$boiteTexte = imagettfbbox ($taille, $angle, $police, $t);
		$gauche = min($boiteTexte[0],$boiteTexte[2],$boiteTexte[4],$boiteTexte[6]);
		$haut = min($boiteTexte[1],$boiteTexte[3],$boiteTexte[5],$boiteTexte[7]);
		$droite = max($boiteTexte[0],$boiteTexte[2],$boiteTexte[4],$boiteTexte[6]);
		$bas = max($boiteTexte[1],$boiteTexte[3],$boiteTexte[5],$boiteTexte[7]);
		//dimensions de l'image
		$largeur = $droite - $gauche+(2*$marge);
		$hauteur = $bas - $haut+(2*$marge);
		
		return $largeur.",".$hauteur;
	}
	
/**
* Renvoie une valeur borne.
* 
* Groupe des fonction conversion de couleurs HTML <-> RVB
* @param integer $nb Valeur  borner.
* @param integer $min Borne minimale (0).
* @param integer $max Borne maximale (255).
* @return integer Valeur borne.
*/
	function bornes($nb,$min,$max) {
	  if ($nb<$min) $nb=$min;
	  if ($nb>$max) $nb=$max;
	  return $nb;
	}
/**
* Convertit une valeur de couleur hexadecimale en RVB
* 
* Groupe des fonction conversion de couleurs HTML <-> RVB
* @param string $color Couleur  convertir.
* @return array Tableau des valeurs R (0), V (1) et B(2).
*/
	function html2rgb($color) {
		if (substr($color,0,1)=="#") $color=substr($color,1,6);
		$tablo[0] = hexdec(substr($color, 0, 2));
		$tablo[1] = hexdec(substr($color, 2, 2));
		$tablo[2] = hexdec(substr($color, 4, 2));
		return $tablo;
	}
/**
* Convertit une valeur de couleur RVB en hexadecimal.
* 
* Groupe des fonction conversion de couleurs HTML <-> RVB
* @param integer $r Valeur de la composante rouge.
* @param integer $v Valeur de la composante verte.
* @param integer $b Valeur de la composante bleue.
* @return string Valeur de couleur en hexadecimal.
*/
	function rgb2html($r,$v,$b) {
		$tablo = array($r,$v,$b);
		for($i=0;$i<=2;$i++)
		{
		  $tablo[$i]=$this->bornes($tablo[$i],0,255);
		}
		return "#" . str_pad(dechex( ($tablo[0]<<16)|($tablo[1]<<8)|$tablo[2] ), 6, "0", STR_PAD_LEFT);
	}
/**
* Fonction de cration du code Javascript utilis pour effectuer l'administration des cartes.
* 
* Il est inclus sous cette forme pour rcuprer les valeurs PHP dont il a besoin.
* @param array $LieuEdit Tableau contenant tous les champs du lieu  diter.
* @param array $CarteEdit Tableau contenant tous les champs de la carte  diter.
* @param string $keymap Clef d'inscription du site  l'API Googgle Map.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @return string Message  afficher en HTML.
*/
 	function lib_carto_edit_carte_js($LieuEdit,$CarteEdit,$keymap,$vars_mod) {
		//formatage des donnes
		if ($LieuEdit['Id'] != "") {
			$local_icone = $this->conditionnerJS($LieuEdit['icone']);
			if ($LieuEdit['Id'] == "-1") {
				$local_latitude = $this->conditionnerJS($CarteEdit['latitude']);
				$local_longitude = $this->conditionnerJS($CarteEdit['longitude']);
			}
			else {
				$local_latitude = $this->conditionnerJS($LieuEdit['latitude']);
				$local_longitude = $this->conditionnerJS($LieuEdit['longitude']);
			}
			$local_zoominit = $this->conditionnerJS($CarteEdit['zoominit']);
			$local_zoomclic = $this->conditionnerJS($CarteEdit['zoomclic']);
			$local_istext = $this->conditionnerJS($LieuEdit['istext']);
			$local_lieu = $this->conditionnerJS($LieuEdit['lieu']);
			if ($LieuEdit['istext'] == "1") {
				$local_angle = $this->conditionnerJS($LieuEdit['angle']);
				$local_typo = $this->conditionnerJS($LieuEdit['typo']);
				$local_couleur = $this->conditionnerJS($LieuEdit['couleur']);
				$local_taille = $this->conditionnerJS($LieuEdit['taille']);
				$local_taille_text = $this->tailleLieuDit($this->conditionnerFORM($LieuEdit['lieu']),$this->conditionnerFORM($LieuEdit['angle']),$this->conditionnerFORM($LieuEdit['typo']),$this->conditionnerFORM($LieuEdit['taille']),$vars_mod['cheminPolices']);
			}
			else {
				$local_angle = "";
				$local_typo = "";
				$local_couleur = "";
				$local_taille = "";
				$local_taille_text = "";
			}
			$local_isbordure = $this->conditionnerJS($LieuEdit['isbordure']);
			if ($LieuEdit['isbordure'] == "1") {
				$local_b_bordure = $this->conditionnerJS($LieuEdit['bordure']);
				$local_b_visibilite = $this->conditionnerJS($LieuEdit['b_visibilite']);
				$local_b_couleur = $this->conditionnerJS($LieuEdit['b_couleur']);
				$local_b_epaisseur = $this->conditionnerJS($LieuEdit['b_epaisseur']);
				$local_b_opacite = $this->conditionnerJS($LieuEdit['b_opacite']);
			}
			else {
				$local_b_bordure = "";
				$local_b_visibilite = "";
				$local_b_couleur = "";
				$local_b_epaisseur = "";
				$local_b_opacite = "";
			}
			$local_c_bordure = $CarteEdit['bordure'];
			$local_c_visibilite = $CarteEdit['visibilite'];
			$local_c_couleur = $CarteEdit['couleur'];
			$local_c_epaisseur = $CarteEdit['epaisseur'];
			$local_c_opacite = $CarteEdit['opacite'];
		}
		else {
			$local_icone = "";
			$local_latitude = $this->conditionnerJS($CarteEdit['latitudeinit']);
			$local_longitude = $this->conditionnerJS($CarteEdit['longitudeinit']);
			$local_zoominit = $this->conditionnerJS($CarteEdit['zoominit']);
			$local_zoomclic = $this->conditionnerJS($CarteEdit['zoomclic']);
			$local_istext = "";
			$local_lieu = "";
			$local_angle = "";
			$local_typo = "";
			$local_couleur = "";
			$local_taille = "";
			$local_taille_text = "";
			$local_c_bordure = $CarteEdit['bordure'];
			$local_c_visibilite = $CarteEdit['visibilite'];
			$local_c_couleur = $CarteEdit['couleur'];
			$local_c_epaisseur = $CarteEdit['epaisseur'];
			$local_c_opacite = $CarteEdit['opacite'];
			$local_isbordure = "";
		    $local_b_bordure = "";
		    $local_b_visibilite = "";
		    $local_b_couleur = "";
		    $local_b_epaisseur = "";
		    $local_b_opacite = "";
		}
		$lib_carto_edit_js ='
<!--<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key='.$keymap.'" charset="UTF-8"></script>-->
<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?v=3&key='.$keymap.'" charset="UTF-8"></script>
<script type="text/javascript">
 //<![CDATA[

var monmarker = null;
var map = null;
var istextEdit = "'.$local_istext.'";
var isbordureEdit = "'.$local_isbordure.'";
 
var bordure = null;

var bordureCEdit = "'.$local_c_bordure.'";
var visibiliteCEdit = "'.$local_c_visibilite.'";
var couleurCEdit = "'.$local_c_couleur.'";
var epaisseurCEdit = "'.$local_c_epaisseur.'";
var opaciteCEdit = "'.$local_c_opacite.'";   

var init_icone = "'.$local_icone.'";
var init_latitude = "'.$local_latitude.'";
var init_longitude = "'.$local_longitude.'";
var init_lieu = "'.$local_lieu.'";
        
var init_b_bordure = "'.$local_b_bordure.'";
var init_b_visibilite = "'.$local_b_visibilite.'";
var init_b_couleur = "'.$local_b_couleur.'";
var init_b_epaisseur = "'.$local_b_epaisseur.'";
var init_b_opacite = "'.$local_b_opacite.'";

var init_angle = "'.$local_angle.'";
var init_typo = "'.$local_typo.'";
var init_couleur = "'.$local_couleur.'";
var init_taille = "'.$local_taille.'";
var init_taille_text = "'.$local_taille_text.'";

var init_zoomclic = '.$this->notVide($local_zoomclic).';
var init_zoominit = '.$this->notVide($local_zoominit).';
var init_chemin_icones = "'.$vars_mod["cheminIcones"].'";
var init_chemin_id_carte = "'.$vars_mod["id_carte"].'";

var lang_cartoconfirm = "'._CARTOCONFIRM.'";
var lang_cartoverifnom = "'._CARTOVERIFNOM.'";
var lang_cartoveriflat = "'._CARTOVERIFLAT.'";
var lang_cartoveriflong = "'._CARTOVERIFLONG.'";
var lang_cartoverifzoominit = "'._CARTOVERIFZOOMINIT.'";
var lang_cartoverifzoomclic = "'._CARTOVERIFZOOMCLIC.'";

    //]]>
</script>
<script type="text/javascript" src="'.$vars_mod["cheminIcones"].'/getscript_admin_carte.php"  charset="UTF-8"></script>';
		return $lib_carto_edit_js;
 	}
/**
* Fonction de cration du code Javascript utilis pour effectuer l'administration des lieux.
* 
* Il est inclus sous cette forme pour rcuprer les valeurs PHP dont il a besoin.
* @param array $LieuEdit Tableau contenant tous les champs du lieu  diter.
* @param array $CarteEdit Tableau contenant tous les champs de la carte  diter.
* @param string $keymap Clef d'inscription du site  l'API Googgle Map.
* @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL
* @return string Message  afficher en HTML.
*/
 	function lib_carto_edit_lieu_js($LieuEdit,$CarteEdit,$keymap,$vars_mod) {
		//formatage des donnes
		if ($LieuEdit['Id'] != "") {
			$local_icone = $this->conditionnerJS($LieuEdit['icone']);
			if ($LieuEdit['Id'] == "-1") {
				$local_latitude = $this->conditionnerJS($CarteEdit['latitude']);
				$local_longitude = $this->conditionnerJS($CarteEdit['longitude']);
			}
			else {
				$local_latitude = $this->conditionnerJS($LieuEdit['latitude']);
				$local_longitude = $this->conditionnerJS($LieuEdit['longitude']);
			}
			$local_zoominit = $this->conditionnerJS($CarteEdit['zoominit']);
			$local_zoomclic = $this->conditionnerJS($CarteEdit['zoomclic']);
			$local_istext = $this->conditionnerJS($LieuEdit['istext']);
			$local_lieu = $this->conditionnerJS($LieuEdit['lieu']);
			if ($LieuEdit['istext'] == "1") {
				$local_angle = $this->conditionnerJS($LieuEdit['angle']);
				$local_typo = $this->conditionnerJS($LieuEdit['typo']);
				$local_couleur = $this->conditionnerJS($LieuEdit['couleur']);
				$local_taille = $this->conditionnerJS($LieuEdit['taille']);
				$local_taille_text = $this->tailleLieuDit($this->conditionnerFORM($LieuEdit['lieu']),$this->conditionnerFORM($LieuEdit['angle']),$this->conditionnerFORM($LieuEdit['typo']),$this->conditionnerFORM($LieuEdit['taille']),$vars_mod['cheminPolices']);
			}
			else {
				$local_angle = "";
				$local_typo = "";
				$local_couleur = "";
				$local_taille = "";
				$local_taille_text = "";
			}
			$local_isbordure = $this->conditionnerJS($LieuEdit['isbordure']);
			if ($LieuEdit['isbordure'] == "1") {
				$local_b_bordure = $this->conditionnerJS($LieuEdit['bordure']);
				$local_b_visibilite = $this->conditionnerJS($LieuEdit['b_visibilite']);
				$local_b_couleur = $this->conditionnerJS($LieuEdit['b_couleur']);
				$local_b_epaisseur = $this->conditionnerJS($LieuEdit['b_epaisseur']);
				$local_b_opacite = $this->conditionnerJS($LieuEdit['b_opacite']);
				$local_b_plein = $this->conditionnerJS($LieuEdit['b_plein']);
			}
			else {
				$local_b_bordure = "";
				$local_b_visibilite = "";
				$local_b_couleur = "";
				$local_b_epaisseur = "";
				$local_b_opacite = "";
				$local_b_plein = "0";
			}
			$local_c_bordure = $CarteEdit['bordure'];
			$local_c_visibilite = $CarteEdit['visibilite'];
			$local_c_couleur = $CarteEdit['couleur'];
			$local_c_epaisseur = $CarteEdit['epaisseur'];
			$local_c_opacite = $CarteEdit['opacite'];
		}
		else {
			$local_icone = "";
			$local_latitude = $this->conditionnerJS($CarteEdit['latitudeinit']);
			$local_longitude = $this->conditionnerJS($CarteEdit['longitudeinit']);
			$local_zoominit = $this->conditionnerJS($CarteEdit['zoominit']);
			$local_zoomclic = $this->conditionnerJS($CarteEdit['zoomclic']);
			$local_istext = "";
			$local_lieu = "";
			$local_angle = "";
			$local_typo = "";
			$local_couleur = "";
			$local_taille = "";
			$local_taille_text = "";
			$local_c_bordure = $CarteEdit['bordure'];
			$local_c_visibilite = $CarteEdit['visibilite'];
			$local_c_couleur = $CarteEdit['couleur'];
			$local_c_epaisseur = $CarteEdit['epaisseur'];
			$local_c_opacite = $CarteEdit['opacite'];
			$local_isbordure = "";
		    $local_b_bordure = "";
		    $local_b_visibilite = "";
		    $local_b_couleur = "";
		    $local_b_epaisseur = "";
		    $local_b_opacite = "";
		    $local_b_plein = "0";
		}
		$lib_carto_edit_js ='
<!--<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key='.$keymap.'" charset="UTF-8"></script>-->
<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?v=3&key='.$keymap.'" charset="UTF-8"></script>
<script type="text/javascript">
 //<![CDATA[
 
var monmarker = null;
var monpolygone = null;
var momzoom = 14;
var map = "";
var istextEdit = "'.$local_istext.'";
var isbordureEdit = "'.$local_isbordure.'";
var iconLieuEdit = "'.$local_icone.'";
var latitudeLieuEdit = "'.$local_latitude.'";
var longitudeLieuEdit = "'.$local_longitude.'";
var lieuEdit = "'.$local_lieu.'";

var bordureEdit = "'.str_replace("\\", "\\\\", $local_b_bordure).'";
var visibiliteEdit = "'.$local_b_visibilite.'";
var couleurEdit2 = "'.$local_b_couleur.'";
var epaisseurEdit = "'.$local_b_epaisseur.'";
var opaciteEdit = "'.$local_b_opacite.'";
var pleinEdit = "'.$local_b_plein.'";

var bordureCEdit = "'.$local_c_bordure.'";
var visibiliteCEdit = "'.$local_c_visibilite.'";
var couleurCEdit = "'.$local_c_couleur.'";
var epaisseurCEdit = "'.$local_c_epaisseur.'";
var opaciteCEdit = "'.$local_c_opacite.'";

var angleEdit = "'.$local_angle.'";
var policeEdit = "'.$local_typo.'";
var couleurEdit = "'.$local_couleur.'";
var tailleEdit = "'.$local_taille.'";
var tailleTextEdit = "'.$local_taille_text.'";
var modeEdit = "S";

var init_zoomclic = '.$this->notVide($local_zoomclic).';
var init_zoominit = '.$this->notVide($local_zoominit).';

var init_chemin_icones = "'.$vars_mod["cheminIcones"].'";
var init_chemin_id_carte = "'.$vars_mod["id_carte"].'";

var lang_cartolieunotempty = "'._CARTOLIEUNOTEMPTY.'";
var lang_cartolieuveriftype3 = "'._CARTOLIEUVERIFTYPE3.'";
var lang_cartolieuvarifcarte = "'._CARTOLIEUVERIFCARTE.'";
var lang_cartolieuveriflat = "'._CARTOLIEUVERIFLAT.'";
var lang_cartolieuveriflong = "'._CARTOLIEUVERIFLONG.'";
var lang_cartolieuveriftype = "'._CARTOLIEUVERIFTYPE.'";
var lang_cartolieuveriftype2 = "'._CARTOLIEUVERIFTYPE2.'";
var lang_cartolieuverifparam = "'._CARTOLIEUVERIFPARAM.'";
var lang_cartolieuverifnom = "'._CARTOLIEUVERIFNOM.'";
var lang_cartoconfirm = "'._CARTOCONFIRM.'";

    //]]>
</script>
<script type="text/javascript" src="'.$vars_mod["cheminIcones"].'/getscript_admin_symbol.php"  charset="UTF-8"></script>';
		return $lib_carto_edit_js;
 	}
}
?>