<?php
/**
* Interfaage du module avec le Front Office du CMS.
* 
* Son inclusion dans le Back Office est automatique, et son accs se trouve dans le menu "Modules"
* @package becmsSimpleCarto
* @version 1.0
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
* @todo Crer un systme de partens dans le thme pour modifier l'apparence de la page de golocalisation
* @todo Ajouter le champ target pour le lien sur une icne
* @todo Duplication de carte pour les langues trangres
*/

/**
* Modification de la plateforme : il faut ajouter 
* <html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml">
* dans l'en-tte de la page qui affiche les tracs des cartes (ou toutes les pages)
* 
* Structure des deux tables utilises par ce module
* -- 
* -- Structure de la table `becms_simplecarto_cartes`
* --
* CREATE TABLE `becms_cartes` (
* `Id` int(11) NOT NULL auto_increment,
* `designation` text character set latin1 collate latin1_general_ci NOT NULL,
* `latitudeinit` decimal(15,12) NOT NULL default '42.130821301888',
* `longitudeinit` decimal(15,12) NOT NULL default '9.080200195313',
* `zoominit` int(11) NOT NULL default '8',
* `zoomclic` int(11) NOT NULL default '16',
* `bordure` text character set latin1 collate latin1_general_ci NOT NULL,
* `visibilite` text character set latin1 collate latin1_general_ci NOT NULL,
* `couleur` varchar(7) character set latin1 collate latin1_general_ci NOT NULL default '#00FF00',
* `epaisseur` int(11) NOT NULL default '3',
* `opacite` decimal(10,2) NOT NULL default '1.00',
* `auteur` varchar(50) NOT NULL,
* `creation` datetime NOT NULL default '0000-00-00 00:00:00',
* `commentaire` text NOT NULL,
* `page` varchar(10) collate latin1_general_ci NOT NULL,
* PRIMARY KEY  (`Id`),
* KEY `couleur` (`couleur`),
* KEY `epaisseur` (`epaisseur`),
* KEY `Id` (`Id`),
* KEY `latitudeinit` (`latitudeinit`),
* KEY `longitudeinit` (`longitudeinit`),
* KEY `opacite` (`opacite`),
* KEY `zoomclic` (`zoomclic`),
* KEY `zoominit` (`zoominit`)
* ) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 PACK_KEYS=0 COMMENT='Nom des cartes' AUTO_INCREMENT=7 ;
* 
* -- --------------------------------------------------------
* -- 
* -- Structure de la table `becms_simplecarto_symboles`
* -- 
* 
* CREATE TABLE `becms_lieux` (
* `Id` int(11) NOT NULL auto_increment,
* `id_carte` int(11) NOT NULL default '1',
* `latitude` decimal(15,12) NOT NULL default '0.000000000000',
* `longitude` decimal(15,12) NOT NULL default '0.000000000000',
* `icone` varchar(100) character set latin1 collate latin1_general_ci NOT NULL,
* `istext` char(1) character set latin1 collate latin1_general_ci NOT NULL default '0',
* `taille` int(11) NOT NULL default '8',
* `typo` varchar(250) character set latin1 collate latin1_general_ci NOT NULL default 'modules/SimpleCarto/lib/fonts/verdana.ttf',
* `couleur` varchar(7) character set latin1 collate latin1_general_ci NOT NULL default '#FF0000',
* `angle` int(11) NOT NULL default '0',
* `isbordure` char(1) character set latin1 collate latin1_general_ci NOT NULL default '0',
* `bordure` text character set latin1 collate latin1_general_ci NOT NULL,
* `b_visibilite` text character set latin1 collate latin1_general_ci NOT NULL,
* `b_couleur` varchar(7) character set latin1 collate latin1_general_ci NOT NULL default '#00FF00',
* `b_epaisseur` int(11) NOT NULL default '3',
* `b_opacite` decimal(10,2) NOT NULL default '1.00',
* `b_plein` char(1) character NOT NULL default '0',
* `fiche` text character set latin1 collate latin1_general_ci NOT NULL,
* `target` varchar(50) NOT NULL,
* `lieu` varchar(100) character set latin1 collate latin1_general_ci NOT NULL,
* `commentaire` text character set latin1 collate latin1_general_ci NOT NULL,
* KEY `commune` (`Id`,`latitude`,`longitude`),
* KEY `id_carte` (`id_carte`),
* KEY `isbordure` (`isbordure`),
* KEY `angle` (`angle`),
* KEY `b_couleur` (`b_couleur`),
* KEY `b_epaisseur` (`b_epaisseur`),
* KEY `b_opacite` (`b_opacite`),
* KEY `couleur` (`couleur`),
* KEY `icone` (`icone`),
* KEY `Id` (`Id`),
* KEY `istext` (`istext`),
* KEY `latitude` (`latitude`),
* KEY `lieu` (`lieu`),
* KEY `longitude` (`longitude`),
* KEY `taille` (`taille`),
* KEY `typo` (`typo`)
* ) ENGINE=MyISAM AUTO_INCREMENT=55 DEFAULT CHARSET=latin1 COMMENT='contient toutes les observations';
*/

if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once("core/becms_mainlib_lib.php");
require_once("modules/$module_name/lib/g_params.php");
require_once("modules/$module_name/lib/ba_displaycarto.php");

$My_SQL["maBase"] = $db;

function displayMap($My_SQL,$vars_mod,$keymap,$useTheme=true) {
	global $Default_Theme;
    $objetCarte = new displayCartos();
    if ($useTheme) {
    		include ('header.php');
    }
    else {
    		echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml">
<link rel="StyleSheet" href="themes/'.$Default_Theme.'/style/style.css" type="text/css" media="screen">
<link rel="StyleSheet" href="themes/'.$Default_Theme.'/style/SimpleCarto.css" type="text/css">
<body>';
	    	echo '<div class="popup">';
    }
    echo $objetCarte->get_map($My_SQL,$vars_mod,$keymap);
    if ($useTheme) {
	    $bardef=array("print"=>"modules.php?name=SimpleCarto&sop=print&".$vars_mod["id_carte"]."=".$vars_mod[$vars_mod["id_carte"]]."&".$vars_mod["limites"]."=".$vars_mod[$vars_mod["limites"]]."&".$vars_mod["bulles"]."=".$vars_mod[$vars_mod["bulles"]]."&".$vars_mod["legende"]."=".$vars_mod[$vars_mod["legende"]]."&".$vars_mod["pictos"]."=".$vars_mod[$vars_mod["pictos"]]."&".$vars_mod["polygones"]."=".$vars_mod[$vars_mod["polygones"]]."&".$vars_mod["type_map"]."=".$vars_mod[$vars_mod["type_map"]],
	                  //"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
	                  "back"=>"javascript:window.history.back();", 
	                  "top"=>"#top" );
	    buttonBar($bardef, "align");
	    adminEditButton("system.php?op=carto&".$vars_mod["action"]."=list&".$vars_mod["id_carte"]."=".$vars_mod[$vars_mod["id_carte"]]."&onglet=lieu");
	    include ('footer.php');
    }
	else {
		echo '		</div>
	</body>
</html>';
	}
}

function displayListMap($My_SQL,$vars_mod,$keymap) {
    $objetCarte = new displayCartos();
    include ('header.php');
    echo $objetCarte->get_list_map($My_SQL,$vars_mod,$keymap);
    /*$bardef=array("print"=>"modules.php?name=SimpleCarto&sop=print&".$vars_mod["id_carte"]."=".$vars_mod[$vars_mod["id_carte"]]."&".$vars_mod["limites"]."=".$vars_mod[$vars_mod["limites"]]."&".$vars_mod["bulles"]."=".$vars_mod[$vars_mod["bulles"]]."&".$vars_mod["legende"]."=".$vars_mod[$vars_mod["legende"]]."&".$vars_mod["pictos"]."=".$vars_mod[$vars_mod["pictos"]]."&".$vars_mod["polygones"]."=".$vars_mod[$vars_mod["polygones"]]."&".$vars_mod["type_map"]."=".$vars_mod[$vars_mod["type_map"]],
                  //"pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
                  //"back"=>"modules.php?name=Sections&sop=listarticles&amp;secid=$secid", 
                  "top"=>"#top" );
    buttonBar($bardef, "align");
    adminEditButton("system.php?op=carto&".$vars_mod["action"]."=list&".$vars_mod["id_carte"]."=".$vars_mod[$vars_mod["id_carte"]]."&onglet=lieu");*/
    include ('footer.php');
}

function printMap($My_SQL,$vars_mod,$keymap) {
    global $site_logo,$Default_Theme, $nukeurl, $sitename, $module_name;
    
    $tab_serveur = parse_url($nukeurl);
	$racine = $tab_serveur["scheme"]."://";
	if ($tab_serveur["user"] != "") {
		$racine .= $tab_serveur["user"];
	}
	if ($tab_serveur["pass"] != "") {
		$racine .= ":".$tab_serveur["pass"];
	}
	if ($tab_serveur["pass"] != "" || $tab_serveur["user"] != "") {
		$racine .= "@";
	}
	$racine .= $tab_serveur["host"];
	if ($tab_serveur["port"] != "") {
		$racine .= ":".$tab_serveur["port"];
	}
	
	if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecarto = '		<link href="themes/'.get_theme().'/style/'.$module_name.'.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		else {
			$stylecarto = '		<link href="'.$vars_mod["cheminIcones"].'/style-map.css" rel="stylesheet" type="text/css" media="all"/>
		';
	}
    
    echo "
    <html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:v=\"urn:schemas-microsoft-com:vml\">
    <head>
    <title>$sitename</title>
    <META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=ISO-8859-1\">\n
    <LINK REL=\"StyleSheet\" HREF=\"themes/$Default_Theme/style/style.css\" TYPE=\"text/css\">\n
	".$stylecarto."
	</head>
    <body bgcolor=\"#FFFFFF\" text=\"#000000\">
    <table border=\"0\"><tr><td>
    <table border=\"0\" width=\"650\" cellpadding=\"0\" cellspacing=\"1\" bgcolor=\"#000000\"><tr><td>
    <table border=\"0\" width=\"650\" cellpadding=\"20\" cellspacing=\"1\" bgcolor=\"#FFFFFF\"><tr><td>
    <div class=\"printHeader\"><img src=\"images/$site_logo\" border=\"0\" alt=\"\"><span class=\"title\">$title_section</span></div>
    <div class=\"zprint\">
    ";
    $objetCarte = new displayCartos();
    echo $objetCarte->get_map($My_SQL,$vars_mod,$keymap);
    echo "
    </div>
    </td></tr></table></td></tr></table>
    
    <div class=\"printFooter\">
    <div class=\"siteName\">
    "._COMESFROM." $sitename<br>
    <a href=\"$racine\">$racine</a>
    </div>
    <div class=\"pageURL\">
    "._THEURL."<br>
    <a href=\"$racine/modules.php?name=SimpleCarto&sop=printMap&amp;".$vars_mod["id_carte"]."=".$vars_mod[$vars_mod["id_carte"]]."\">$racine/modules.php?name=SimpleCarto&sop=printMap&amp;".$vars_mod["id_carte"]."=".$vars_mod[$vars_mod["id_carte"]]."</a>
    </div>
    </div>
    </td></tr></table>
    </body>
    </html>
    ";
}

function sendXML($Idc) {
	require_once("connector_lib.php");
	$sortie = getXMLMaps($Idc);
	header("Content-Type: text/xml; charset=UTF-8");
	echo $sortie;
}

function listMap($My_SQL,$vars_mod) {
	$objetCarte = new displayCartos();
    $cartes = $objetCarte->get_all_maps($My_SQL);
    
    $iconeAdd = "<img src=\"images/balisteNukeBrowse/link.gif\" border=\"0\">";
	$iconeDoc = "<img src=\"images/smallicone/globe1.png\" border=\"0\" />";
	
    $sortie = '<html>
<head>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=ISO-8859-1">
<LINK rel="stylesheet" type="text/css" href="includes/styles/dialog.css">
<title>Browse</title>
<script src="javascripts/overlib.js" type="text/javascript"></script>
<script src="javascripts/fckeditor/editor/dialog/common/fck_dialog_common.js" type="text/javascript"></script>
<script language="JavaScript" src="javascripts/becmsInsert.js"></script>
<script language="JavaScript" src="javascripts/includeImage.js"></script>
</head>
<body topmargin="0" leftmargin="0" style="border: 0; margin: 0;" scroll="yes">
<table border="0"  cellpadding="0" cellspacing="0" bordercolor="#ece9d8"><tr><td>';
    
    $sortie .= '<table border="0" width="547" cellpadding="0">';
	foreach ($cartes as $carte) {
		$sortie .= "<tr bgcolor=\"#FFFFFF\">\n";
		$title = $carte["designation"];
		$title = str_replace("'", "\'", $title);
    		$title = str_replace('"', "&quot;", $title);
    		$url = $carte["Id"];
    		$taille = explode("/",$carte["taille"]);
    		$sortie .= '<td><table border="0" cellpadding="0" cellspacing="0"><tr><td>&nbsp;'.$iconeDoc.'&nbsp;</td>';
		$sortie .= '<td><a href="javascript:displayObject(\''.$url.'\',\''.$title.'\',\'googlemap\',\''.$taille[0].'\',\''.$taille[1].'\')">'.$title.'</a></td></tr></table></td>';
		$sortie .= '</tr>';
    }
    $sortie .= '</table>';
    
    $sortie .= '</td></tr></table>
</body>
</html>';
    echo $sortie;
}
/**
 * Appel des fonctions en fonction du paramtre $sop.
 */
switch($sop) {
	case "list_to_include":
		listMap($My_SQL,$vars_mod);
		break;
    case "display":
    		displayMap($My_SQL,$vars_mod,$keymap);
	    break;
	case "displaynotheme":
    		displayMap($My_SQL,$vars_mod,$keymap,false);
	    break;
	case "print":
    		printMap($My_SQL,$vars_mod,$keymap);
	    break;
	case "mapsXML":
    		sendXML($vars_mod[$vars_mod["id_carte"]]);
	    break;
    default:
    		displayListMap($My_SQL,$vars_mod,$keymap);
	    //echo "Aucune opration  effectuer n'a t choisie'";
	    break;
}

?>