<?php
/**
* Classes d'accs  la base de donnes pour la gestion des petites annonces.
* 
* Toutes les fonctions utilisent l'API de la plateforme pour tre indpendante de la base de donnes utilise
* @package becmsSimpleAnnonce
* @version 0.1
* @author Vincent RUIZ <webmaster@arobase.fr>
* @copyright Copyright  2007, Vincent RUIZ
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*/

require_once("utils.php");

/**
* Classe d'accs  la base de donnes petites annonces pour isoler les fonctions.
* 
* @package becmsSimpleAnnonce
*/
class BD_Annonce {
	var $My_SQL = array();
	
	function BD_Annonce() {
		global $db,$prefix;
		$this->My_SQL["maBase"] = $db;
		$this->My_SQL["ads"] = $prefix."_annonce";
		$this->My_SQL["cats"] = $prefix."_annonce_categorie";
		$this->My_SQL["stats"] = $prefix."_annonce_stats";
	}
	
/**
* Efface la fiche de la petite annonce dsigne
* @param integer $Id Identifiant de l'annonce  supprimer
* @param integer $cat Identifiant de la catgorie dont toutes les annonces doivent tre supprimes
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/		
	function delAds($Id,$cat="") {
		$db=$this->My_SQL["maBase"];
		
		if ($Id != "" || $cat != "") {
			$cond = "";
			if ($Id != "-1" && $Id != "") {
				if ($cond == "") {
					$cond .= " WHERE ";
				}
				else {
					$cond .= " AND ";
				}
				$cond .= "`Id`='".$Id."'";
			}
			if ($cat != "-1" && $cat != "") {
				if ($cond == "") {
					$cond .= " WHERE ";
				}
				else {
					$cond .= " AND ";
				}
				$cond .= "`categorie`='".$cat."'";
			}
			$sql = "DELETE FROM `".$this->My_SQL["ads"]."`".$cond.";";
			return $db->sql_query($sql);
		}
		else {
			return false;
		}
	}
	
/**
* Efface les fiches des petites annonces dont la date est expire
* * Cette fonction est appelle par la fonction de rcupration des annonces.
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/		
	function cleanAds() {
		global $adsdelaisupprauto;
		if ($adsdelaisupprauto != "") {
			list($delaiJour,$delaiMois) = explode(",",$adsdelaisupprauto);
		}
		else {
			$delaiMois = 1;
			$delaiJour = 0;
		}
		$db=$this->My_SQL["maBase"];
		$aujourdhui = date("Y-m-d H:i:s");
		$date_moins_mois = date("Y-m-d H:i:s",mktime(date("h"),date("i"), date("s"), date ("m")-$delaiMois, date("d")-$delaiJour, date("Y")));
		//dbut stats
		$sql = "SELECT count(`Id`) AS Nbre FROM ".$this->My_SQL["ads"]." WHERE `date_saisie`<'".$date_moins_mois."' AND `date_valid`='0000-00-00 00:00:00';";
		$resultatRecherche = $db->sql_query($sql);
		$ligneCourante = $db->sql_fetchrow($resultatRecherche);
		$nbre = $ligneCourante["Nbre"];
		if ($nbre != "0") {
			$this->ajoutRefus("",$nbre);
		}
		//fin stats

		$non_valides = "(`date_saisie`<'".$date_moins_mois."' AND `date_valid`='0000-00-00 00:00:00') OR (`date_limite`<'".$aujourdhui."' AND `date_limite`<>'0000-00-00 00:00:00')";
		$sql = "DELETE FROM `".$this->My_SQL["ads"]."` WHERE $non_valides;";
		return $db->sql_query($sql);
	}
/**
* Enregistre une fiche annonce
* 
* Si l'annonce existe dj, elle est simplement modifie, sinon elle est cre.
* @param array $ads Tableau contenant tous les champs de l'annonce  enregistrer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/	
	function saveAds($ads) {
		$db=$this->My_SQL["maBase"];
		$ads = array_map(array('utilFuncs', 'conditionnertodb'), $ads);
		$list_champs = "";
		$list_valeurs = "";
		if ($ads["Id"] == "-1") {
			foreach($ads as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."`";
					$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
					$list_valeurs .= "'".$value."'";
				}
			}
			$sql = "INSERT INTO `".$this->My_SQL["ads"]."` (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		}
		else {
			foreach($ads as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."` = '".$value."'";
				}
			}
			$sql = "UPDATE `".$this->My_SQL["ads"]."` SET ".$list_champs." WHERE `Id` = '".$ads["Id"]."';";
		}
		return $db->sql_query($sql);
	}
/**
* Renvoie la liste des annonces correspondants  la demande
* 
* Un tableau vide est renvoy si aucune annonce n'est trouve. Si tous les critres sont vides,toutes les annonces sont renvoyes.
* @param string $the_type Type de recherche (fiches/nbre de fiches) dont les valeurs sont "files" ou "count"
* @param integer $Id Identifiant de l'annonce  retrouver
* @param integer $categorie Identifiant pour limiter la recherche  cette catgorie.
* @param date $le Date du jour de la recherche.
* @param string $redateur Utilisateur ayant rdig l'annonce.
* @param string $content Texte contenu dans le sujet ou le texte de l'annonce.
* @param string $tri_par Nom de la rubrique servant au tri.
* @param string $limit Indication des enregistrements  retourner (index et nombre).
* @return array Retourne la liste des clients retrouvs
*/	
	function getAds($the_type="files", $Id="" , $categorie = "", $le="", $redacteur="", $content="", $tri_par="",$limit="",$valid="") {
		$this->cleanAds();
		$db=$this->My_SQL["maBase"];
		
		$ads = array();
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["ads"]."`.`Id`='".$Id."'";
		}
		if ($categorie != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["ads"]."`.`categorie`='".$categorie."'";
		}
		if ($le != "") {
			/*$le = utilFuncs::date2AMJ($le);
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["ads"]."`.`date_valid`<='".$le."' AND `".$this->My_SQL["ads"]."`.`date_limite`>='".$le;*/
		}
		if ($redacteur != "") {
			$redacteur = utilFuncs::conditionnertodb($redacteur);
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["ads"]."`.`redacteur`='".$redacteur."'";
		}
		if ($content != "") {
			$content = utilFuncs::conditionnertodb($content);
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["ads"]."`.`annonce` LIKE '%".$content."%'";
		}
		if ($Id=="") {
			if ($valid) {
				if ($cond == "") {
					$cond .= " WHERE ";
				}
				else {
					$cond .= " AND ";
				}
				$cond .= "`".$this->My_SQL["ads"]."`.`date_valid` <> '0000-00-00 00:00:00'";
			}
			else {
				if ($cond == "") {
					$cond .= " WHERE ";
				}
				else {
					$cond .= " AND ";
				}
				$cond .= "`".$this->My_SQL["ads"]."`.`date_valid` = '0000-00-00 00:00:00'";
			}
		}
		//echo  "//$cond//";
		if ($the_type == "files") {
			$oderby = "";
			if ($tri_par =="") {
				$oderby = " ORDER BY `".$this->My_SQL["ads"]."`.`date_saisie` DESC";
			}
			if ($tri_par =="date") {
				$oderby = " ORDER BY `".$this->My_SQL["ads"]."`.`date_valid` DESC";
			}
			if ($tri_par == "categorie") {
				$oderby = " ORDER BY `".$this->My_SQL["ads"]."`.`categorie` ASC, `".$this->My_SQL["ads"]."`.`date_saisie` DESC";
			}
			if ($tri_par == "redacteur") {
				$oderby = " ORDER BY `".$this->My_SQL["ads"]."`.`redacteur` ASC, `".$this->My_SQL["ads"]."`.`date_saisie` DESC";
			}
			if ($limit != "") {
				$limit = " LIMIT ".trim($limit);
			}
			$resultatRecherche = $db->sql_query("SELECT `".$this->My_SQL["ads"]."`.`Id`,`".$this->My_SQL["ads"]."`.`annonce`,`".$this->My_SQL["ads"]."`.`auteur`,`".$this->My_SQL["ads"]."`.`categorie`,`".$this->My_SQL["ads"]."`.`date_saisie`,`".$this->My_SQL["ads"]."`.`date_valid`,`".$this->My_SQL["ads"]."`.`date_limite`,`".$this->My_SQL["ads"]."`.`adresse`,`".$this->My_SQL["ads"]."`.`email`,`".$this->My_SQL["ads"]."`.`tel`,`".$this->My_SQL["ads"]."`.`duree` FROM `".$this->My_SQL["ads"]."` ".$cond.$oderby.$limit.";");
			if ($db->sql_numrows($resultatRecherche) != 0) {
				while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
					array_push($ads, $ligneCourante);
				}
			}
			return $ads;
		}
		if ($the_type == "count") {
			$sql = "SELECT count(Id) AS nbre FROM `".$this->My_SQL["ads"]."` ".$cond.";";
			$result = $db->sql_query($sql);
			list($nbrefiches) = $db->sql_fetchrow($result);
			return $nbrefiches;
		}
	}
	
/**
* Renvoie la liste des catgories des annonces correspondants  la demande
* 
* Un tableau vide est renvoy si aucune catgorie n'est trouve. Si tous les critres sont vides,toutes les catgories sont renvoyes.
* @param integer $Id Identifiant de l'annonce  retrouver
* @return array Retourne la liste des catgories retrouvs
*/	
	function getCats($Id="") {
	$db=$this->My_SQL["maBase"];
		
		$ads = array();
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["cats"]."`.`Id`='".$Id."'";
		}
		$oderby = " ORDER BY `".$this->My_SQL["cats"]."`.`categorie` ASC";
		$resultatRecherche = $db->sql_query("SELECT `".$this->My_SQL["cats"]."`.`Id`,`".$this->My_SQL["cats"]."`.`categorie`,`".$this->My_SQL["cats"]."`.`image` FROM `".$this->My_SQL["cats"]."` ".$cond.$oderby.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				array_push($ads, $ligneCourante);
			}
		}
		return $ads;
	}
/**
* Efface la fiche de la catgorie et des petites annonces incluses
* @param integer $Id Identifiant la catgorie  supprimer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/		
	function delCat($Id) {
		$db=$this->My_SQL["maBase"];
		
		if ($Id != "") {
			$cond = "`Id` = ".$Id;
			$sql = "DELETE FROM `".$this->My_SQL["cats"]."` WHERE ".$cond.";";
			return $db->sql_query($sql) && $this->delAds("",$Id);
		}
		else {
			return false;
		}
	}
/**
* Enregistre une catgorie
* 
* Si la catgorie esiste dj, elle est simplement modifie, sinon elle est cre.
* @param array $ads Tableau contenant tous les champs de la catgorie  enregistrer
* @return boolean Retourne true si l'opration s'est bien passe, false sinon
*/	
	function saveCat($cat) {
		$db=$this->My_SQL["maBase"];
		$cat = array_map(array('utilFuncs', 'conditionnertodb'), $cat);
		$list_champs = "";
		$list_valeurs = "";
		if ($cat["Id"] == "-1") {
			foreach($cat as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."`";
					$list_valeurs .= ($list_valeurs == "") ? "" : ", ";
					$list_valeurs .= "'".$value."'";
				}
			}
			$sql = "INSERT INTO `".$this->My_SQL["cats"]."` (".$list_champs.")";
			$sql .= " VALUES (".$list_valeurs.");";
		}
		else {
			foreach($cat as $key => $value) {
				if ($key != "Id") {
					$list_champs .= ($list_champs == "") ? "" : ", ";
					$list_champs .= "`".$key."` = '".$value."'";
				}
			}
			$sql = "UPDATE `".$this->My_SQL["cats"]."` SET ".$list_champs." WHERE `Id` = '".$cat["Id"]."';";
		}
		return $db->sql_query($sql);
	}
	
/**
* Renvoie la liste des statistiques des annonces correspondants  la demande
* 
* Un tableau vide est renvoy si aucune stat n'est trouve. Si tous les critres sont vides,toutes les stats sont renvoyes.
* @param integer $Id Identifiant de l'annonce  retrouver
* @return array Retourne la liste des catgories retrouvs
*/	
	function getStats($Id="",$le="") {
		$db=$this->My_SQL["maBase"];
		
		$stats = array();
		$cond = "";
		if ($Id != "-1" && $Id != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["stats"]."`.`Id`='".$Id."'";
		}
		if ($le != "") {
			if ($cond == "") {
				$cond .= " WHERE ";
			}
			else {
				$cond .= " AND ";
			}
			$cond .= "`".$this->My_SQL["stats"]."`.`mois`='".$le."'";
		}
		$oderby = " ORDER BY `".$this->My_SQL["stats"]."`.`mois` DESC";
		$resultatRecherche = $db->sql_query("SELECT `".$this->My_SQL["stats"]."`.`Id`,`".$this->My_SQL["stats"]."`.`mois`,`".$this->My_SQL["stats"]."`.`proposees`,`".$this->My_SQL["stats"]."`.`validees`,`".$this->My_SQL["stats"]."`.`reponses`,`".$this->My_SQL["stats"]."`.`refusees` FROM `".$this->My_SQL["stats"]."` ".$cond.$oderby.";");
		if ($db->sql_numrows($resultatRecherche) != 0) {
			while ($ligneCourante = $db->sql_fetchrow($resultatRecherche)) {
				array_push($stats, $ligneCourante);
			}
		}
		return $stats;
	}

/**
* Enregistre la statistique d'un mois donn
* 
* Le mois est modifi s'il existe dj ou ajout s'il n'existe pas.
* @param array $stat Tableau des stats du mois en cours
* @return array Retourne le rsultat de l'opration
*/	
	function saveStat($stat) {
		$db=$this->My_SQL["maBase"];
		if ($stat["Id"] == "-1") {
			$sql = "INSERT INTO `".$this->My_SQL["stats"]."` (`mois`,`proposees`,`validees`,`reponses`,`refusees`)";
			$sql .= " VALUES ('".$stat["mois"]."','".$stat["proposees"]."','".$stat["validees"]."','".$stat["reponses"]."','".$stat["refusees"]."');";
		}
		else {
			$sql = "UPDATE `".$this->My_SQL["stats"]."` SET `mois`='".$stat["mois"]."', `proposees`='".$stat["proposees"]."', `validees`='".$stat["validees"]."', `reponses`='".$stat["reponses"]."', `refusees`='".$stat["refusees"]."' WHERE `Id` = '".$stat["Id"]."';";
		}
		//echo $sql;
		return $db->sql_query($sql);
	}
	
/**
* Incrmente les statistiques de proposition de 1
* @param string $date Date de la statistique  incrmenter - paramtre optionnel
* @return array Retourne le rsultat de l'opration
*/
	function ajoutProp($date="") {
		$db=$this->My_SQL["maBase"];
		
		if ($date=="") {
			$date = date("Y-m")."-01";
		}
		$results = $this->getStats("",$date);
		if (count($results) == 0) {
			$result = array("Id"=>"-1","mois"=>date("Y-m")."-01","proposees"=>0,"validees"=>0,"reponses"=>0,"refusees"=>0);
		}
		else {
			$result = $results[0];	
		}
		$result["proposees"]++;
		$this->saveStat($result);
	}

/**
* Incrmente les statistiques de validation de 1
* @param string $date Date de la statistique  incrmenter - paramtre optionnel
* @return array Retourne le rsultat de l'opration
*/
	function ajoutValid($date="") {
		$db=$this->My_SQL["maBase"];
		
		if ($date=="") {
			$date = date("Y-m")."-01";
		}
		$results = $this->getStats("",$date);
		if (count($results) == 0) {
			$result = array("Id"=>"-1","mois"=>date("Y-m")."-01","proposees"=>0,"validees"=>0,"reponses"=>0,"refusees"=>0);
		}
		else {
			$result = $results[0];	
		}
		$result["validees"]++;
		$this->saveStat($result);
	}

/**
* Incrmente les statistiques de rponse de 1
* @param string $date Date de la statistique  incrmenter - paramtre optionnel
* @return array Retourne le rsultat de l'opration
*/
	function ajoutReponse($date="") {
		$db=$this->My_SQL["maBase"];
		
		if ($date=="") {
			$date = date("Y-m")."-01";
		}
		$results = $this->getStats("",$date);
		if (count($results) == 0) {
			$result = array("Id"=>"-1","mois"=>date("Y-m")."-01","proposees"=>0,"validees"=>0,"reponses"=>0,"refusees"=>0);
		}
		else {
			$result = $results[0];	
		}
		$result["reponses"]++;
		$this->saveStat($result);
	}

/**
* Incrmente les statistiques de refus de 1
* @param string $date Date de la statistique  incrmenter - paramtre optionnel
* @param integer $valeur Nbre d'annonces non valides  ajouter  la statistique
* @return array Retourne le rsultat de l'opration
*/
	function ajoutRefus($date="",$valeur=1) {
		$db=$this->My_SQL["maBase"];
		
		if ($date=="") {
			$date = date("Y-m")."-01";
		}
		$results = $this->getStats("",$date);
		if (count($results) == 0) {
			$result = array("Id"=>"-1","mois"=>date("Y-m")."-01","proposees"=>0,"validees"=>0,"reponses"=>0,"refusees"=>0);
		}
		else {
			$result = $results[0];	
		}
		$result["refusees"]+=$valeur;
		$this->saveStat($result);
	}
}
?>