<?php
/* ----------------------------------------------------------------
Script coming with JonDesign's SmoothGallery (http://smoothgallery.jondesign.net).

It is an adapted version of
http://sneak.co.nz/2006/10/27/dynamic-image-resizing/
which is itself an improvement of the original script from
Timothy Crowe's 'veryraw' website, with caching additions added by Trent Davies:
http://veryraw.com/history/2005/03/image-resizing-with-php/

Thanks to:
Tim Novinger for finding the image extension problem (fixed by an strtolower())
---------------------------------------------------------------- */

if(!function_exists("imageantialias")){
	function imageantialias($ressource, $bool){
	}
}

$max_height = 1000;
$max_width = 2000;
if (isset($_GET["imgfile"]))
{
	$image = $_GET["imgfile"];
	if (isset($_GET["max_width"])) { if($_GET["max_width"] < 2000) $max_width = $_GET["max_width"]; }
	if (isset($_GET["max_height"])) { if($_GET["max_height"] < 1000) $max_height = $_GET["max_height"]; }
	
	if (strrchr($image, '/')) {
		$filename = substr(strrchr($image, '/'), 1); // remove folder references
	} else {
		$filename = $image;
	}
	
	$size = getimagesize($image);
	$width = $size[0];
	$height = $size[1];
	
	// get the ratio needed
	$x_ratio = $max_width / $width;
	$y_ratio = $max_height / $height;
	
	// if image already meets criteria, load current values in
	// if not, use ratios to load new size info
	if (($width <= $max_width) && ($height <= $max_height) ) {
		$tn_width = $width;
		$tn_height = $height;
	} else if (($x_ratio * $height) < $max_height) {
		$tn_height = ceil($x_ratio * $height);
		$tn_width = $max_width;
	} else {
		$tn_width = ceil($y_ratio * $width);
		$tn_height = $max_height;
	}
	
	/* Caching additions by Trent Davies */
	// first check cache
	// cache must be world-readable
	/*$resized = 'cache/'.$tn_width.'x'.$tn_height.'-'.$filename;
	$imageModified = @filemtime($image);
	$thumbModified = @filemtime($resized);
	
	
	// if thumbnail is newer than image then output cached thumbnail and exit
	if($imageModified<$thumbModified) {
		header("Content-type: image/jpeg");
		header("Last-Modified: ".gmdate("D, d M Y H:i:s",$thumbModified)." GMT");
		readfile($resized);
		exit;
	}// le chache est dsactiv*/
	
	// read image
	$ext = strtolower(substr(strrchr($image, '.'), 1)); // get the file extension
	switch ($ext) { 
		case 'jpg':     // jpg
			$src = imagecreatefromjpeg($image) or notfound();
			break;
		case 'png':     // png
			$src = imagecreatefrompng($image) or notfound();
			break;
		case 'gif':     // gif
			$src = imagecreatefromgif($image) or notfound();
			break;
		default:
			notfound();
	}
	
	// set up canvas
	$dst = imagecreatetruecolor($tn_width,$tn_height);
	if ($ext == "jpg" || $extension == "jpeg") {
		imageantialias ($dst, true);
		ImageCopyResampled($dst,$src,0,0,0,0,$tn_width, $tn_height, $width, $height);
		header("Content-type: image/jpeg");
		imagejpeg($dst, null, 90);
		//imagejpeg($dst, $resized, 90); le chache est dsactiv
	}
	if ($ext == "gif") {
		//nouvelle mthode
		imagealphablending($dst, false);
		$transindex = imagecolortransparent($src);
		if($transindex >= 0) {
		  $transcol = imagecolorsforindex($src, $transindex);
		  $transindex = imagecolorallocatealpha($dst, $transcol['red'], $transcol['green'], $transcol['blue'], 127);
		  imagefill($dst, 0, 0, $transindex);
		}
		imagecopyresampled($dst, $src, 0, 0, 0, 0, $tn_width, $tn_height, $width, $height);
		if($transindex >= 0) {
		  imagecolortransparent($dst, $transindex);
		  for($y=0; $y<$tn_height; ++$y)
		    for($x=0; $x<$tn_width; ++$x)
		      if(((imagecolorat($dst, $x, $y)>>24) & 0x7F) >= 100) imagesetpixel($dst, $x, $y, $transindex);
		}
		imagetruecolortopalette($dst, true, 255);
		imagesavealpha($dst, false);
		//fin nouvelle mthode

		/*ancienne mthode
		$trans = imagecolorallocate($dst,255,255,255);
		imagefilledrectangle($dst,0,0,$tn_width, $tn_height,$trans);
		imagecolortransparent($dst,$trans);
		ImageCopyResampled($dst,$src,0,0,0,0,$tn_width, $tn_height, $width, $height);
		imagetruecolortopalette($dst, true, 256);
		fin ancienne mthode*/

		imageinterlace($dst);
		header("Content-type: image/gif");
		imagegif($dst);
		//imagegif($dst, $resized); //le chache est dsactiv
	}
	if ($ext == "png") {
		imageantialias ($dst, true);
		imagealphablending($dst, false);
		ImageCopyResampled($dst,$src,0,0,0,0,$tn_width, $tn_height, $width, $height);
		imagesavealpha($dst, true);
		header("Content-type: image/png");
		imagepng($dst);
		//imagepng($dst,$resized); //le chache est dsactiv
	}
	
	
	
	// copy resized image to new canvas
	//imagecopyresampled ($dst, $src, 0, 0, 0, 0, $tn_width, $tn_height, $width, $height);
	
	/* Sharpening adddition by Mike Harding */
	// sharpen the image (only available in PHP5.1)
	/*if (function_exists("imageconvolution")) {
		$matrix = array(    array( -1, -1, -1 ),
	                    array( -1, 32, -1 ),
	                    array( -1, -1, -1 ) );
		$divisor = 24;
		$offset = 0;
	
		imageconvolution($dst, $matrix, $divisor, $offset);
	}*/
	
	// send the header and new image
	//imagejpeg($dst, null, 90);
	//imagejpeg($dst, $resized, 90); // write the thumbnail to cache as well...
	
	// clear out the resources
	imagedestroy($src);
	imagedestroy($dst);
}
?>