<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2002 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("You can't access this file directly...");
}

$index = 1;
require_once("core/becms_mainlib_lib.php");
require_once("includes/truncate_string.php");
$module_name = basename(dirname(__FILE__));
get_lang($module_name);

automated_news();

if (file_exists("modules/SimpleUsersStats/stats.php")) {
	require_once("modules/SimpleUsersStats/stats.php");
	$stat_membre = new membersStats();
}
function ajoutStat($action) {
	global $stat_membre;
	if (isset($stat_membre)) {
		$stat_membre->add_action($action);
	}
}

function theindex($new_topic=0, $dateOrder="yes", $nocat="no", $nolimit="no") {
	global $db, $storyhome, $topicname, $topicimage, $topictext, $datetime, $user, $cookie, $nukeurl, $prefix, $multilingual, $currentlang, $articlecomm, $sitename, $module_name, $pagetitle;
	global $home;
	if ($multilingual == 1) {
		$querylang = "AND (alanguage='$currentlang' OR alanguage='')";
	}
	else {
		$querylang = "";
	}
	$theOrder="";
	if ($dateOrder=="yes") {
		$theOrder="time DESC, ";
	}
	if (isset($cookie[3])) {
		$storynum = $cookie[3];
	}
	else {
		$storynum = $storyhome;
	}
	if ($new_topic == 0) {
		$qdb = "WHERE (ihome='0' OR catid='0')";
		$qdb .= " AND status='P'";
		$home_msg = "";
		include("header.php");
	}
	elseif ($new_topic == -1) {
		$qdb = "WHERE status='P'";
		$querylang = "AND (alanguage='$currentlang' OR alanguage='')";
		$home_msg = "";
		include("header.php");
	}
	else {
		$qdb = "WHERE topic='$new_topic'";
		$qdb .= " AND status='P'";
		$res = $db->sql_query("select topicname,topictext from ".$prefix."_topics where topicid='$new_topic'");
		list($topic_name,$topic_title) = $db->sql_fetchrow($res);
		$pagetitle = "- ".$topic_name;
		include("header.php");
		if ($db->sql_numrows($res) == 0) {
			echo "<div class=\"news_seach_title\">$sitename</div>"._NOINFO4TOPIC."<br><br>[ <a href=\"modules.php?name=News\">"._GOTONEWSINDEX."</a> | <a href=\"modules.php?name=Topics\">"._SELECTNEWTOPIC."</a> ]</center>";
		}
		else {
			//$bardef=array("back"=>"javascript:window.history.back()");
			//buttonBar($bardef, "align");
			//echo "<h1>"._SUBJECT_NEWS.$topic_title."</h1>";
			echo "<h1>".$topic_title."</h1>";
			echo "<fieldset><legend>"._SEARCHACTUS."</legend>";
			echo "<form action=\"modules.php?name=Search\" method=\"post\">";
			echo "<p style=\"text-align: center\"><b>"._KEYWORDS.$topic_title."</b><br />&nbsp;<br />"
			."<input type=\"hidden\" name=\"topic\" value=\"$new_topic\">"
			."<input type=\"hidden\" name=\"type\" value=\"stories\">"
			."<input type=\"text\" name=\"query\" size=\"30\" id=\"zquery\">&nbsp;&nbsp;"
			."<input type=\"submit\" value=\""._GOSEARCH."\"></p>"
			//."<a href=\"javascript:document.theform.submit();\">"._GOSEARCH."</a>"
			."</form>";
			/*echo "<hr class=\"sepRec\" />";
			echo "<form>";
			echo "<p style=\"text-align: center\">&nbsp;<br />";
			echo "<input type=\"button\" value=\""._GOTOHOME."\" onclick=\"window.location.href='index.php'\">";
			echo " ";
			echo "<input type=\"button\" value=\""._SELECTNEWTOPIC."\" onclick=\"window.location.href='modules.php?name=Topics'\">";
			echo "</p>";
			echo "</form>";*/
			echo "</fieldset>";
			echo "<br />";
		}
	}
	$result = $db->sql_query("SELECT distinct catid, count(catid) as nbre FROM ".$prefix."_stories $qdb $querylang group by catid"); 
	//$result = $db->sql_query("SELECT distinct catid, count(catid) as nbre FROM ".$prefix."_stories WHERE status='P' $querylang group by catid");
	if ($db->sql_numrows($result)!= 0 && $nocat=="no") {
		echo "<fieldset><legend>"._NEWSCATLIST."</legend>";
		echo "<ul class=\"listcatnews\">";
		global $withrewriting, $maxtitlerewriting;
		while (list($categorie,$nbre)=$db->sql_fetchrow($result)) {
			if ($categorie == "0") {
				$title1 = _ARTICLES;
			}
			else {
				$resultc = $db->sql_query("select title from ".$prefix."_stories_cat where catid='$categorie'");
				list($title1) = $db->sql_fetchrow($resultc);
			}
			if (!$withrewriting) {
				if ($categorie == "0") {
					$urlcat = "modules.php?name=News&nocat=yes";
				}
				else {
					$urlcat = "modules.php?name=News&amp;file=categories&amp;op=newindex&amp;catid=$categorie";
				}
			}
			else {
				$pagename = $title1;
				if (strlen($pagename) > $maxtitlerewriting) {
					do {
						$pagename = substr($pagename, 0, strrpos($pagename, " "));
					} while(strlen($pagename) > $maxtitlerewriting);
				}
				if ($categorie == "0") {
					$urlcat = normalize_name($pagename)."_actu_nocat,yes.htm";
				}
				else {
					$urlcat = normalize_name($pagename)."_actu_cat_".$categorie."_nocat,yes.htm";
				}
			}
			echo "<li><a href=\"$urlcat\">$title1</a> ($nbre)</li>";
			//echo "<li><a href=\"modules.php?name=News&amp;file=categories&amp;op=newindex&amp;catid=$categorie\">$title1</a> ($nbre)</li>";
		}
		echo "</ul>";
		echo "</fieldset>";
		echo "<br />";
	}
	if ($nolimit == "no") {
		$limit = " limit $storynum";
	}
	
	$result = $db->sql_query("SELECT sid, catid, aid, title, time, hometext, bodytext, comments, counter, topic, informant, notes, acomm, score, ratings FROM ".$prefix."_stories $qdb $querylang ORDER BY $theOrder sid DESC".$limit);
	if (!$result) {
		print_r($db->sql_error());
		die('Invalid query');
	}
	if ($db->sql_numrows($result) != 0) {
		echo "<h1>"._SELECTEDARTICLES."</h1>";
	}
	global $maxtitlerewriting, $withrewriting;
	while (list($s_sid, $catid, $aid, $title, $time, $hometext, $bodytext, $comments, $counter, $topic, $informant, $notes, $acomm, $score, $ratings) = $db->sql_fetchrow($result)) {
		/*
		 if ($catid > 0) {
			list($cattitle) = $db->sql_fetchrow($db->sql_query("select title from ".$prefix."_stories_cat where catid='$catid'"));
		}
		*/
		getTopics($s_sid);
		formatTimestamp($time);
		$subject = stripslashes($subject);
		$hometext = stripslashes($hometext);
		$notes = stripslashes($notes);
		$introcount = strlen($hometext);
		$fullcount = strlen($bodytext);
		$totalcount = $introcount + $fullcount;
		$c_count = $comments;
		if (is_user($user)) {
			$the_icons = " &bull; <a href=\"modules.php?name=News&amp;file=print&amp;sid=$s_sid\"><img src=\"images/print.gif\" border=\"0\" Alt=\""._PRINTER."\"></a>&nbsp;&nbsp;<a href=\"modules.php?name=News&amp;file=friend&amp;op=FriendSend&amp;sid=$s_sid\"><img src=\"images/friend.gif\" border=\"0\" Alt=\""._FRIEND."\"></a>";
		}
		else {
			$the_icons = "";
		}
		if (!$withrewriting) {
			$r_options = "";
			if (isset($cookie[4]) && !empty($cookie[4])) { $r_options .= "&amp;mode=$cookie[4]"; }
			if (isset($cookie[5]) && !empty($cookie[5])) { $r_options .= "&amp;order=$cookie[5]"; }
			if (isset($cookie[6]) && !empty($cookie[6])) { $r_options .= "&amp;thold=$cookie[6]"; }
			$pagename = "";
			$urlprefix = "modules.php?name=".$module_name."&file=article&sid=";
			$urlmedium = "";
			$urlpostfix = $r_options;
		}
		else {
			$pagename = $title;
			if (strlen($pagename) > $maxtitlerewriting) {
				do {
					$pagename = substr($pagename, 0, strrpos($pagename, " "));
				} while(strlen($pagename) > $maxtitlerewriting);
			}
			$urlprefix = "";
			$urlmedium = "_actu_";
			$urlpostfix = ".htm";
			$r_options = "";
			if (isset($cookie[4]) && !empty($cookie[4])) { $r_options .= "_mode,$cookie[4]"; }
			if (isset($cookie[5]) && !empty($cookie[5])) { $r_options .= "_order,$cookie[5]"; }
			if (isset($cookie[6]) && !empty($cookie[6])) { $r_options .= "_thold,$cookie[6]"; }
		}
		//$story_link = "<a href=\"modules.php?name=News&amp;file=article&amp;sid=$s_sid$r_options\">";
		$story_link = "<a href=\"".$urlprefix.normalize_name($pagename).$urlmedium.$s_sid.$r_options.$urlpostfix."\">";
		//$morelink = "(";
		$morelink = "";
		if (($fullcount > 0) OR ($c_count > 0)) {
			$morelink .= "$story_link"._READMORE."</a> &bull; ";
		}
		else {
			$morelink .= "";
		}
		/*if ($fullcount > 0) {
			$morelink .= "$totalcount "._BYTESMORE." &bull; ";
		}
		if ($score != 0) {
			$rated = substr($score / $ratings, 0, 4);
		}
		else {
			$rated = 0;
		}
		$morelink .= " &bull; "._SCORE." $rated";
		if ($articlecomm == 1 AND $acomm == 0) {
			$morelink .= " &bull; ";
			if ($c_count == 0) {
				$morelink .= _COMMENTSQ;
			}
			elseif ($c_count == 1) {
				$morelink .= "$c_count "._COMMENT;
			}
			elseif ($c_count > 1) {
				$morelink .= "$c_count "._COMMENTS;
			}
		}*/
		if ($fullcount == 0 AND $acomm == 1) {
			$morelink .= "$story_link<b>"._READMORE."</b></a>";
			if (!is_user($user)) {
				$morelink .= " &bull; ";
			}
		}
		$sid = $s_sid;
		if ($catid != 0) {
			$resultm = $db->sql_query("select title from ".$prefix."_stories_cat where catid='$catid'");
			list($title1) = $db->sql_fetchrow($resultm);
			
		
			if (!$withrewriting) {
				$urlcat = "modules.php?name=News&amp;file=categories&amp;op=newindex&amp;catid=$catid";
			}
			else {
				$pagename = $title1;
				if (strlen($pagename) > $maxtitlerewriting) {
					do {
						$pagename = substr($pagename, 0, strrpos($pagename, " "));
					} while(strlen($pagename) > $maxtitlerewriting);
				}
				$urlcat = normalize_name($pagename)."_actu_cat_".$catid."_nocat,yes.htm";
			}
			//$title = "<a href=\"modules.php?name=News&amp;file=categories&amp;op=newindex&amp;catid=$catid\">$title1</a> : $title";
			//$morelink .= " &bull; <a href=\"modules.php?name=News&amp;file=categories&amp;op=newindex&amp;catid=$catid\">$title1</a>";
			$morelink .= ($morelink != "") ? " &bull; " : "";
			$morelink .= "<a href=\"$urlcat\">$title1</a>";
		}
		$morelink .= "$the_icons";
		//$morelink .= ")";
		$morelink = str_replace(" &bull;  &bull; ", " &bull; ", $morelink);
		themeindex($aid, $informant, $datetime, $title, $counter, $topic, $hometext, $notes, $morelink, $topicname, $topicimage, $topictext);
	}
	if ($home != 1) {
		/*$bardef=array("back"=>"javascript:window.history.back()",
				//"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",
				//"mailto"=>"modules.php?name=News&amp;file=friend&amp;op=FriendSend&amp;sid=$sid",
				"top"=>"#top" );*/
		$bardef=array("back"=>$_SERVER["HTTP_REFERER"],
				//"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",
				//"mailto"=>"modules.php?name=News&amp;file=friend&amp;op=FriendSend&amp;sid=$sid",
				"top"=>"#top" );
		
		buttonBar($bardef, "align");
	}
	include("footer.php");
}

function liste($valeur) {
	$sortie = "";
	if (count($valeur) > 0) {
		$sortie .= "<ul>";
		foreach ($valeur as $elt) {
			$sortie .= "<li>".$elt."</li>";
		}
		$sortie .= "</ul>";
	}
	return $sortie;
}
	
function colonnes($valeurs = array(), $nbcols = 1, $largeur = "", $equicols = false, $senslecture = "v") {
	$nbrevals = count($valeurs);
	if ($nbrevals > 0) {
		$largeurscols = array();
		if ($equicols) { //calcul des largeurs de colonnes si elles doivent tre gales
			$largeurcol = floor(100/$nbcols);
			$total = 0;
			for ($i=0;$i<$nbcols-1;$i++) {
				$largeurscols[] = ' width="'.$largeurcol.'%"';
				$total += $largeurcol;
			}
			$largeurscols[] = $largeurscols[] = ' width="'.(100 - $total).'%"';
		}
		$lignesMax = ceil(count($valeurs)/$nbcols); //nbre de lignes maximal
		
		$sortie = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"";
		if ($largeur != "") {
			$sortie .= " width=\"".$largeur."\"";
		}
		$sortie .= ">";
		$contenus = array();
		if ($senslecture == "v") {
			for ($c=0;$c<$nbcols;$c++) {
				$contenus[$c] = '<td'.$largeurscols[$c].'>';
				$contenus[$c] .= liste(array_slice($valeurs,$lignesMax*$c,$lignesMax));
				$contenus[$c] .= '</td>';
			}
		}
		if ($senslecture == "h") {
			for ($c=0;$c<$nbcols;$c++) {
				$cvaleurs = array();
				for ($i=0;$i<$lignesMax;$i++) {
					$indice = $i*$nbcols+$c;
					if (isset($valeurs[$indice])) {
						$cvaleurs[] = $valeurs[$indice];
					}
				}
				$contenus[$c] = '<td'.$largeurscols[$c].'>';
				$contenus[$c] .= liste($cvaleurs);
				$contenus[$c] .= '</td>';
			}
		}
		$sortie .= '<tr>';
		foreach($contenus as $contenu) {
			$sortie .= $contenu;
		}
		$sortie .= '</tr>';
		$sortie .= "</table>";
	}
	else {
		$sortie = "";
	}
	return $sortie;
}

function thenewindex($new_topic=0, $dateOrder="yes", $nocat="no", $nolimit="no") {
	global $db, $storyhome, $topicname, $topicimage, $topictext, $datetime, $user, $cookie, $nukeurl, $prefix, $multilingual, $currentlang, $articlecomm, $sitename, $module_name, $pagetitle;
	global $home, $locale;
	if ($multilingual == 1) {
		$querylang = "AND (alanguage='$currentlang' OR alanguage='')";
	}
	else {
		$querylang = "";
	}
	$theOrder="time DESC";
	if (isset($cookie[3])) {
		$storynum = $cookie[3];
	}
	else {
		$storynum = $storyhome;
	}
	if ($new_topic == 0) {
		$qdb = "WHERE (ihome='0' OR catid='0')";
		$qdb .= " AND status='P'";
		$home_msg = "";
		include("header.php");
	}
	elseif ($new_topic == -1) {
		$qdb = "WHERE status='P'";
		$querylang = "AND (alanguage='$currentlang' OR alanguage='')";
		$home_msg = "";
		include("header.php");
	}
	else {
		$qdb = "WHERE topic='$new_topic'";
		$qdb .= " AND status='P'";
		$res = $db->sql_query("select topicname,topictext from ".$prefix."_topics where topicid='$new_topic'");
		list($topic_name,$topic_title) = $db->sql_fetchrow($res);
		$pagetitle = "- ".$topic_name;
		include("header.php");
		if ($db->sql_numrows($res) == 0) {
			echo "<div class=\"news_seach_title\">$sitename</div>"._NOINFO4TOPIC."<br><br>[ <a href=\"modules.php?name=News\">"._GOTONEWSINDEX."</a> | <a href=\"modules.php?name=Topics\">"._SELECTNEWTOPIC."</a> ]</center>";
		}
		else {
			//$bardef=array("back"=>"javascript:window.history.back()");
			//buttonBar($bardef, "align");
			//echo "<h1>"._SUBJECT_NEWS.$topic_title."</h1>";
			echo "<h1>".$topic_title."</h1>";
			echo "<fieldset><legend>"._SEARCHACTUS."</legend>";
			echo "<form action=\"modules.php?name=Search\" method=\"post\">";
			echo "<p style=\"text-align: center\"><b>"._KEYWORDS.$topic_title."</b><br />&nbsp;<br />"
			."<input type=\"hidden\" name=\"topic\" value=\"$new_topic\">"
			."<input type=\"hidden\" name=\"type\" value=\"stories\">"
			."<input type=\"text\" name=\"query\" size=\"30\" id=\"zquery\">&nbsp;&nbsp;"
			."<input type=\"submit\" value=\""._GOSEARCH."\"></p>"
			//."<a href=\"javascript:document.theform.submit();\">"._GOSEARCH."</a>"
			."</form>";
			/*echo "<hr class=\"sepRec\" />";
			echo "<form>";
			echo "<p style=\"text-align: center\">&nbsp;<br />";
			echo "<input type=\"button\" value=\""._GOTOHOME."\" onclick=\"window.location.href='index.php'\">";
			echo " ";
			echo "<input type=\"button\" value=\""._SELECTNEWTOPIC."\" onclick=\"window.location.href='modules.php?name=Topics'\">";
			echo "</p>";
			echo "</form>";*/
			echo "</fieldset>";
			echo "<br />";
		}
	}
	$result = $db->sql_query("SELECT distinct catid, count(catid) as nbre FROM ".$prefix."_stories $qdb $querylang group by catid"); 
	//$result = $db->sql_query("SELECT distinct catid, count(catid) as nbre FROM ".$prefix."_stories WHERE status='P' $querylang group by catid");
	if ($db->sql_numrows($result)!= 0 && $nocat=="no") {
		echo "<fieldset><legend>"._NEWSCATLIST."</legend>";
		//echo "<ul class=\"listcatnews\">";
		global $withrewriting, $maxtitlerewriting;
		$cats = array();
		while (list($categorie,$nbre)=$db->sql_fetchrow($result)) {
			if ($categorie == "0") {
				$title1 = _ARTICLES;
			}
			else {
				$resultc = $db->sql_query("select title from ".$prefix."_stories_cat where catid='$categorie'");
				list($title1) = $db->sql_fetchrow($resultc);
			}
			if (!$withrewriting) {
				if ($categorie == "0") {
					$urlcat = "modules.php?name=News&nocat=yes";
				}
				else {
					$urlcat = "modules.php?name=News&amp;file=categories&amp;op=newindex&amp;catid=$categorie";
				}
			}
			else {
				$pagename = $title1;
				if (strlen($pagename) > $maxtitlerewriting) {
					do {
						$pagename = substr($pagename, 0, strrpos($pagename, " "));
					} while(strlen($pagename) > $maxtitlerewriting);
				}
				if ($categorie == "0") {
					$urlcat = normalize_name($pagename)."_actu_nocat,yes.htm";
				}
				else {
					$urlcat = normalize_name($pagename)."_actu_cat_".$categorie."_nocat,yes.htm";
				}
			}
			//echo "<li><a href=\"$urlcat\">$title1</a> ($nbre)</li>";
			$cats[] =  "<a href=\"$urlcat\">$title1</a> ($nbre)";
			//echo "<li><a href=\"modules.php?name=News&amp;file=categories&amp;op=newindex&amp;catid=$categorie\">$title1</a> ($nbre)</li>";
		}
		echo '<div class="listcatnews">';
		echo colonnes($cats,4);
		echo '</div>';
		//echo "</ul>";
		echo "</fieldset>";
		echo "<br />";
	}
	$result = $db->sql_query("select topicid, topicname,topictext from ".$prefix."_topics");
	//$result = $db->sql_query("SELECT distinct catid, count(catid) as nbre FROM ".$prefix."_stories WHERE status='P' $querylang group by catid");
	if ($db->sql_numrows($result)!= 0 && $nocat=="no") {
		echo "<fieldset><legend>"._NEWSUBLIST."</legend>";
		//echo "<ul class=\"listcatnews\">";
		global $withrewriting, $maxtitlerewriting;
		$cats = array();
		while (list($catid,$categorie,$description)=$db->sql_fetchrow($result)) {
			$title1 = $categorie;
			if (!$withrewriting) {
				$urlcat = "modules.php?name=News&new_topic=$catid";
			}
			else {
				$pagename = $title1;
				if (strlen($pagename) > $maxtitlerewriting) {
					do {
						$pagename = substr($pagename, 0, strrpos($pagename, " "));
					} while(strlen($pagename) > $maxtitlerewriting);
				}
				$urlcat = normalize_name($pagename)."_actu_cat_".$catid.".htm";
			}
			//echo "<li><a href=\"$urlcat\">$title1</a> ($nbre)</li>";
			$cats[] =  "<a href=\"$urlcat\">$title1</a>";
			//echo "<li><a href=\"modules.php?name=News&amp;file=categories&amp;op=newindex&amp;catid=$categorie\">$title1</a> ($nbre)</li>";
		}
		echo '<div class="listcatnews">';
		echo colonnes($cats,4);
		echo '</div>';
		//echo "</ul>";
		echo "</fieldset>";
		echo "<br />";
	}
	if ($nolimit == "no") {
		$limit = " limit $storynum";
	}
	
	$result = $db->sql_query("SELECT sid, catid, aid, title, time, hometext, bodytext, comments, counter, topic, informant, notes, acomm, score, ratings FROM ".$prefix."_stories $qdb $querylang ORDER BY $theOrder ".$limit);
	if (!$result) {
		print_r($db->sql_error());
		die('Invalid query');
	}
	if ($db->sql_numrows($result) != 0) {
		echo "<h1>"._SELECTEDARTICLES."</h1>";
	}
	global $maxtitlerewriting, $withrewriting;
	$oldmois = "";
	while (list($s_sid, $catid, $aid, $title, $time, $hometext, $bodytext, $comments, $counter, $topic, $informant, $notes, $acomm, $score, $ratings) = $db->sql_fetchrow($result)) {
		getTopics($s_sid);
		formatTimestamp($time);
		$subject = stripslashes($subject);
		$hometext = stripslashes($hometext);
		$notes = stripslashes($notes);
		$introcount = strlen($hometext);
		$fullcount = strlen($bodytext);
		$totalcount = $introcount + $fullcount;
		$c_count = $comments;
		$the_icons = "";
		if (!$withrewriting) {
			$r_options = "";
			if (isset($cookie[4]) && !empty($cookie[4])) { $r_options .= "&amp;mode=$cookie[4]"; }
			if (isset($cookie[5]) && !empty($cookie[5])) { $r_options .= "&amp;order=$cookie[5]"; }
			if (isset($cookie[6]) && !empty($cookie[6])) { $r_options .= "&amp;thold=$cookie[6]"; }
			$pagename = "";
			$urlprefix = "modules.php?name=".$module_name."&file=article&sid=";
			$urlmedium = "";
			$urlpostfix = $r_options;
		}
		else {
			$pagename = $title;
			if (strlen($pagename) > $maxtitlerewriting) {
				do {
					$pagename = substr($pagename, 0, strrpos($pagename, " "));
				} while(strlen($pagename) > $maxtitlerewriting);
			}
			$urlprefix = "";
			$urlmedium = "_actu_";
			$urlpostfix = ".htm";
			$r_options = "";
			if (isset($cookie[4]) && !empty($cookie[4])) { $r_options .= "_mode,$cookie[4]"; }
			if (isset($cookie[5]) && !empty($cookie[5])) { $r_options .= "_order,$cookie[5]"; }
			if (isset($cookie[6]) && !empty($cookie[6])) { $r_options .= "_thold,$cookie[6]"; }
		}
		$story_link = "<a href=\"".$urlprefix.normalize_name($pagename).$urlmedium.$s_sid.$r_options.$urlpostfix."\">";
		$morelink = "";
		if (($fullcount > 0) OR ($c_count > 0)) {
			$morelink .= "$story_link"._READMORE."</a> &bull; ";
		}
		else {
			$morelink .= "";
		}
		if ($fullcount == 0 AND $acomm == 1) {
			$morelink .= "$story_link<b>"._READMORE."</b></a>";
			if (!is_user($user)) {
				$morelink .= " &bull; ";
			}
		}
		$sid = $s_sid;
		if ($catid != 0) {
			$resultm = $db->sql_query("select title from ".$prefix."_stories_cat where catid='$catid'");
			list($title1) = $db->sql_fetchrow($resultm);
			
		
			if (!$withrewriting) {
				$urlcat = "modules.php?name=News&amp;file=categories&amp;op=newindex&amp;catid=$catid";
			}
			else {
				$pagename = $title1;
				if (strlen($pagename) > $maxtitlerewriting) {
					do {
						$pagename = substr($pagename, 0, strrpos($pagename, " "));
					} while(strlen($pagename) > $maxtitlerewriting);
				}
				$urlcat = normalize_name($pagename)."_actu_cat_".$catid."_nocat,yes.htm";
			}
			$morelink .= ($morelink != "") ? " &bull; " : "";
			$morelink .= "<a href=\"$urlcat\">$title1</a>";
		}
		$morelink .= "$the_icons";
		$morelink = str_replace(" &bull;  &bull; ", " &bull; ", $morelink);
		preg_match("/^([0-9]{4}-[0-9]{2})/i",$time,$tabtime);
		if ($tabtime[1] != $oldmois) {
			preg_match("/^([0-9]{4})-([0-9]{2})-([0-9]{2})/i",$time,$tabtime2);
			$letemps = strftime("%B %Y", mktime(0,0,1,$tabtime2[2],$tabtime2[3],$tabtime2[1]));
			$letemps = ucfirst($letemps);
			//$letemps = date("F Y",mktime(0,0,1,$tabtime2[2],$tabtime2[3],$tabtime2[1]));
			echo "<div class=\"actumois\">$letemps</div>";
			$oldmois = $tabtime[1];	
		}
		themeindexthumb($aid, $informant, $datetime, $title, $counter, $topic, $hometext, $notes, $morelink, $topicname, $topicimage, $topictext);
	}
	if ($home != 1) {
		/*$bardef=array("back"=>"javascript:window.history.back()",
				//"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",
				//"mailto"=>"modules.php?name=News&amp;file=friend&amp;op=FriendSend&amp;sid=$sid",
				"top"=>"#top" );*/
		$bardef=array("back"=>$_SERVER["HTTP_REFERER"],
				//"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",
				//"mailto"=>"modules.php?name=News&amp;file=friend&amp;op=FriendSend&amp;sid=$sid",
				"top"=>"#top" );
				
		buttonBar($bardef, "align");
	}
	include("footer.php");
}

function list_index($nbreFiches, $page, $ligne_par_page, $theurl) {
	global $module_name,$withrewriting;
	
	$nboites = 5;
	$liminf = $page - floor($nboites/2);
	$limsup = $page + floor($nboites/2);
	if ($liminf < 1) {
		$liminf = 1;
		$limsup = $nboites;
		if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
			$limsup = ceil($nbreFiches/$ligne_par_page);
		}
	}
	if ($limsup > ceil($nbreFiches/$ligne_par_page)) {
		$limsup = ceil($nbreFiches/$ligne_par_page);
		$liminf = $limsup - $nboites;
		if ($liminf < 1) {
			$liminf = 1;
		}
	}
	$min = 1;
	$max = ceil($nbreFiches/$ligne_par_page);
	
	$repParPage = $ligne_par_page;
	$p = $page;
	$nbrepages = ceil($nbreFiches/$repParPage);
	if ($p>$nbrepages) {
		$p = $nbrepages;
	}
	$indexPages .= "<div class=\"pages\">";
	if ($nbreFiches != 0) {
		$indexPages .= $nbreFiches._NEWSFOUND;
		$indexPages .= _NEWSPAGES;
		if ($min < $liminf) {
			if ($min == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$min";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"$theurl&page=$min\">$min</a>";
				$indexPages .= "</div>";
			}
			if ($min < $liminf - 1) {
				$indexPages .= "...";
			}
		}
		for ($i=$liminf;$i<=$limsup;$i++) {
			if ($i == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$i";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"$theurl&page=$i\">$i</a>";
				$indexPages .= "</div>";
			}
		}
		if ($max > $limsup) {
			if ($max > $limsup + 1) {
				$indexPages .= "...";
			}
			if ($max == $p ) {
				$indexPages .= "<div class=\"pagevide\">";
				$indexPages .= "$max";
				$indexPages .= "</div>";
			}
			else {
				$indexPages .= "<div class=\"page\">";
				$indexPages .= "<a href=\"$theurl&page=$max\">$max</a>";
				$indexPages .= "</div>";
			}
	
		}
	}
	else {
		$indexPages .= _NEWSNOTFOUND;
	}
	$indexPages .= "</div>";
	return $indexPages;
}

function listactus($new_topic=0, $catid=0, $dateOrder="yes") {
	global $db, $storyhome, $topicname, $topicimage, $topictext, $datetime, $user, $cookie, $nukeurl, $prefix, $multilingual, $currentlang, $articlecomm, $sitename, $module_name, $pagetitle;
	global $home, $locale, $newscatorsubject,$page,$newsarticlesperpage,$newsvignettes;
	global $Default_Theme;
	if ($multilingual == 1) {
		$querylang = "AND (alanguage='$currentlang' OR alanguage='')";
	}
	else {
		$querylang = "";
	}
	$theOrder="time DESC";
	if (isset($cookie[3])) {
		$storynum = $cookie[3];
	}
	else {
		$storynum = $newsarticlesperpage;
	}
	
	$theurl ="modules.php?name=".$module_name;
	if ($new_topic == 0 || $new_topic == -1 || $new_topic == "") {
		$qdb = "WHERE status='P'";
		$pagetitle = " - "._ALLACTUSLIST;
		$topic_name = _ALLACTUSLIST;
	}
	else {
		$qdb = "WHERE topic='$new_topic'";
		$qdb .= " AND status='P'";
		$res = $db->sql_query("select topicname,topictext from ".$prefix."_topics where topicid='$new_topic'");
		list($topic_name,$topic_title) = $db->sql_fetchrow($res);
		$pagetitle = "- ".$topic_name;
		$theurl.="&new_topic=".$new_topic;
	}
	if ($catid != 0 && $catid != -1 && $catid != "") {
		$qdb .= " AND catid='$catid'";
		$theurl.="&catid=".$catid;
	}
	if ($home == 1) {
		$qdb .= " AND ihome='0'"; //oui, la valeur est enregistre  l'envers : 0 pour dire oui...
		$storynum = $storyhome;
		$pagetitle = "";
	}
	//pages
	if ($home != 1) {
		$result = $db->sql_query("SELECT sid FROM ".$prefix."_stories $qdb $querylang");
		$nbrefiches = $db->sql_numrows($result);
		if ($page=="-1" || $page=="0" || $page=="" || !isset($page)) {
			$page = "1";
		}
		$indexlist = list_index($nbrefiches, $page, $storynum, $theurl);
	}
	else {
		$indexlist = "";
		$page = "1";
	}
		
	include("header.php");
	if (file_exists("themes/".$Default_Theme."/pattern_news_list.php")) {
		$sortie = "";
		//$limit = " limit ".(($page-1) * $storynum).",".($storynum);
		$limit = "";
		$result = $db->sql_query("SELECT sid, catid, aid, title, time, hometext, bodytext, comments, counter, topic, informant, notes, acomm, score, ratings FROM ".$prefix."_stories $qdb $querylang ORDER BY $theOrder ".$limit);
		global $maxtitlerewriting, $withrewriting;
		$tab_news = array();
		while (list($s_sid, $catid, $aid, $title, $time, $hometext, $bodytext, $comments, $counter, $topic, $informant, $notes, $acomm, $score, $ratings) = $db->sql_fetchrow($result)) {
			$item = array(
				"s_sid" => $s_sid,
				"catid" => $catid,
				"aid" => $aid,
				"title" => $title,
				"time" => $time,
				"hometext" => $hometext,
				"bodytext" => $bodytext,
				"comments" => $comments,
				"counter" => $counter,
				"topic" => $topic,
				"informant" => $informant,
				"notes" => $notes,
				"acomm" => $acomm,
				"score" => $score,
				"ratings" => $ratings
			);
			$tab_news[] = $item;
		}
		require("themes/".$Default_Theme."/pattern_news_list.php");
		echo $sortie;
	}
	else {
		if ($home != 1) {
			if (function_exists('SearchStory')){
				$tabsujets = array();
				$result = $db->sql_query("select count(sid) as nbre, topic, topicname from ".$prefix."_topics inner join ".$prefix."_stories on topic=topicid  where status='P' group by topic");
				if ($db->sql_numrows($result)!= 0) {
					global $withrewriting,$maxtitlerewriting;
					while (list($nbre,$topic,$topicname)=$db->sql_fetchrow($result)) {
						if (!$withrewriting) {
								$urlcat = "modules.php?name=News&new_topic=$topic";
						}
						else {
							if (strlen($topicname) > $maxtitlerewriting) {
								do {
									$topicname = substr($topicname, 0, strrpos($topicname, " "));
								} while(strlen($topicname) > $maxtitlerewriting);
							}
							$urlcat = normalize_name($topicname)."_topics_".$topic.".htm";
						}
						$tabsujets[] = array("topic"=>$topicname,"nbre"=>$nbre, "url"=>$urlcat);
					}
				}
				SearchStory($topic_name, $new_topic, $qdb, $querylang,$tabsujets);
			}
			else {
				echo "<h1>".$topic_name."</h1>";
				
				//recherche
				$blocsearch = "<fieldset><legend>"._SEARCHACTUS."</legend>";
				$blocsearch .= "<form action=\"modules.php?name=Search\" method=\"post\">";
				$blocsearch .= "<p style=\"text-align: center\"><b>"._KEYWORDS.$topic_name."</b><br />&nbsp;<br />"
				."<input type=\"hidden\" name=\"topic\" value=\"$new_topic\">"
				."<input type=\"hidden\" name=\"type\" value=\"stories\">"
				."<input type=\"text\" name=\"query\" size=\"30\" id=\"zquery\">&nbsp;&nbsp;"
				."<input type=\"submit\" value=\""._GOSEARCH."\"></p>"
					."</form>";
				$blocsearch .= "</fieldset>";
				$blocsearch .= "<br />";
			
				//categories
				if ($newscatorsubject == "cats") {
					$result = $db->sql_query("SELECT distinct catid, count(catid) as nbre FROM ".$prefix."_stories $qdb $querylang group by catid"); 
					if ($db->sql_numrows($result)!= 0) {
						$bloccats = "<fieldset><legend>"._NEWSCATLIST."</legend>";
						global $withrewriting, $maxtitlerewriting;
						$cats = array();
						while (list($categorie,$nbre)=$db->sql_fetchrow($result)) {
							/*if ($categorie == "0") {
								$title1 = _ARTICLES;
							}
							else {*/
								$resultc = $db->sql_query("select title from ".$prefix."_stories_cat where catid='$categorie'");
								list($title1) = $db->sql_fetchrow($resultc);
							//}
							if (!$withrewriting) {
								if ($categorie == "0") {
									$urlcat = "modules.php?name=News";
								}
								else {
									$urlcat = "modules.php?name=News&file=categories&op=newindex&catid=$categorie";
								}
							}
							else {
								$pagename = $title1;
								if (strlen($pagename) > $maxtitlerewriting) {
									do {
										$pagename = substr($pagename, 0, strrpos($pagename, " "));
									} while(strlen($pagename) > $maxtitlerewriting);
								}
								if ($categorie == "0") {
									$urlcat = normalize_name($pagename)."_actu.htm";
								}
								else {
									$urlcat = normalize_name($pagename)."_actu_cat_".$categorie.".htm";
								}
							}
							$cats[] =  "<a href=\"$urlcat\">$title1</a> ($nbre)";
						}
						$bloccats .= '<div class="listcatnews">';
						$bloccats .= colonnes($cats,4);
						$bloccats .= '</div>';
						$bloccats .= "</fieldset>";
						$bloccats .= "<br />";
					}
				}
				//sujets
				if ($newscatorsubject == "subs") {
					//calcul du nombre d'articles par sujets
					$tabsujets = array();
					$result = $db->sql_query("select count(sid) as nbre, topic from ".$prefix."_stories  where status='P' group by topic");
					if ($db->sql_numrows($result)!= 0) {
						while (list($nbre,$topic)=$db->sql_fetchrow($result)) {
							$tabsujets["$topic"] = $nbre;
						}
					}
					//fin du calcul
					$result = $db->sql_query("select topicid, topicname,topictext from ".$prefix."_topics order by topicname ASC");
					if ($db->sql_numrows($result)!= 0) {
						$blocsubs = "<fieldset><legend>"._NEWSUBLIST."</legend>";
						global $withrewriting, $maxtitlerewriting;
						$cats = array();
						while (list($topicid,$categorie,$description)=$db->sql_fetchrow($result)) {
							$title1 = $categorie;
							if (!$withrewriting) {
								$urlcat = "modules.php?name=News&new_topic=$topicid";
							}
							else {
								$pagename = $title1;
								if (strlen($pagename) > $maxtitlerewriting) {
									do {
										$pagename = substr($pagename, 0, strrpos($pagename, " "));
									} while(strlen($pagename) > $maxtitlerewriting);
								}
								$urlcat = normalize_name($pagename)."_topics_".$topicid.".htm";
							}
							$nbre = (isset($tabsujets["$topicid"])) ? $tabsujets["$topicid"] : "0";
							$cats[] =  "<a href=\"$urlcat\">$title1 ($nbre)</a>";
						}
						$blocsubs .= '<div class="listcatnews">';
						$blocsubs .= colonnes($cats,4);
						$blocsubs .= '</div>';
						$blocsubs .= "</fieldset>";
						$blocsubs .= "<br />";
					}
				}
				echo $blocsearch.$bloccats.$blocsubs;
			}
		}
		
	
		//articles
		$limit = " limit ".(($page-1) * $storynum).",".($storynum);
		$result = $db->sql_query("SELECT sid, catid, aid, title, time, hometext, bodytext, comments, counter, topic, informant, notes, acomm, score, ratings FROM ".$prefix."_stories $qdb $querylang ORDER BY $theOrder ".$limit);
		if (!$result) {
			print_r($db->sql_error());
			die('Invalid query');
		}
		if (!function_exists('SearchStory')) {
			if ($db->sql_numrows($result) != 0) {
				//echo "<h1>"._SELECTEDARTICLES."</h1>";
			}
			if ($home != 1) {
				echo "<hr class=\"pages\">".$indexlist."<hr class=\"pages\">";
			}
			else {
				echo "<p>&nbsp;</p>";
			}
		}
		global $maxtitlerewriting, $withrewriting;
		$oldmois = "";
		echo "<fieldset id=\"lesactus\"><legend>News</legend>";//mis l pour la compatibilit des coins ronds pour IE
		while (list($s_sid, $catid, $aid, $title, $time, $hometext, $bodytext, $comments, $counter, $topic, $informant, $notes, $acomm, $score, $ratings) = $db->sql_fetchrow($result)) {
			getTopics($s_sid);
			formatTimestamp($time, "%d %B %Y");
			$subject = stripslashes($subject);
			$hometext = stripslashes($hometext);
			$notes = stripslashes($notes);
			$introcount = strlen($hometext);
			$fullcount = strlen($bodytext);
			if ($introcount == 0) {
				if ($fullcount > 0) {
					//$hometext = substr($bodytext,0, stripos($bodytext,".",stripos($bodytext,".") + 1) + 1);
					$hometext = truncate_string($bodytext,"250");
				}
				else {
					$hometext = "";
				}
				$introcount = strlen($hometext);
			}
			
			$totalcount = $introcount + $fullcount;
			$c_count = $comments;
			$the_icons = "";
			if (!$withrewriting) {
				$r_options = "";
				if (isset($cookie[4]) && !empty($cookie[4])) { $r_options .= "&amp;mode=$cookie[4]"; }
				if (isset($cookie[5]) && !empty($cookie[5])) { $r_options .= "&amp;order=$cookie[5]"; }
				if (isset($cookie[6]) && !empty($cookie[6])) { $r_options .= "&amp;thold=$cookie[6]"; }
				$pagename = "";
				$urlprefix = "modules.php?name=".$module_name."&file=article&sid=";
				$urlmedium = "";
				$urlpostfix = $r_options;
			}
			else {
				$pagename = $title;
				if (strlen($pagename) > $maxtitlerewriting) {
					do {
						$pagename = substr($pagename, 0, strrpos($pagename, " "));
					} while(strlen($pagename) > $maxtitlerewriting);
				}
				$urlprefix = "";
				$urlmedium = "_actu_";
				$urlpostfix = ".htm";
				$r_options = "";
				if (isset($cookie[4]) && !empty($cookie[4])) { $r_options .= "_mode,$cookie[4]"; }
				if (isset($cookie[5]) && !empty($cookie[5])) { $r_options .= "_order,$cookie[5]"; }
				if (isset($cookie[6]) && !empty($cookie[6])) { $r_options .= "_thold,$cookie[6]"; }
			}
			$story_link = "<a href=\"".$urlprefix.normalize_name($pagename).$urlmedium.$s_sid.$r_options.$urlpostfix."\">";
			$morelink = "";
			if (($fullcount > 0) OR ($c_count > 0)) {
				$morelink .= "$story_link"._READMORE."</a>";
			}
			else {
				$morelink .= "";
			}
			if ($fullcount == 0 AND $acomm == 0) {
				$morelink .= "$story_link"._READMORE."</a>";
				if (!is_user($user)) {
					$morelink .= " &bull; ";
				}
			}
			$sid = $s_sid;
			if ($catid != 0) {
				$resultm = $db->sql_query("select title from ".$prefix."_stories_cat where catid='$catid'");
				list($title1) = $db->sql_fetchrow($resultm);
				
			
				if (!$withrewriting) {
					$urlcat = "modules.php?name=News&amp;file=categories&amp;op=newindex&amp;catid=$catid";
				}
				else {
					$pagename = $title1;
					if (strlen($pagename) > $maxtitlerewriting) {
						do {
							$pagename = substr($pagename, 0, strrpos($pagename, " "));
						} while(strlen($pagename) > $maxtitlerewriting);
					}
					$urlcat = normalize_name($pagename)."_actu_cat_".$catid."_nocat,yes.htm";
				}
				$morelink .= ($morelink != "") ? " &bull; " : "";
				$morelink .= "<a href=\"$urlcat\">$title1</a>";
			}
			$morelink .= "$the_icons";
			$morelink = str_replace(" &bull;  &bull; ", " &bull; ", $morelink);
			preg_match("/^([0-9]{4}-[0-9]{2})/i",$time,$tabtime);
			if ($tabtime[1] != $oldmois) {
				preg_match("/^([0-9]{4})-([0-9]{2})-([0-9]{2})/i",$time,$tabtime2);
				$letemps = strftime("%B %Y", mktime(0,0,1,$tabtime2[2],$tabtime2[3],$tabtime2[1]));
				$letemps = ucfirst($letemps);
				//$letemps = date("F Y",mktime(0,0,1,$tabtime2[2],$tabtime2[3],$tabtime2[1]));
				echo "<div class=\"actumois\"><span class=\"texte\">$letemps</span></div>";
				$oldmois = $tabtime[1];	
			}
			if ($newsvignettes == "1") {
				themeindexthumb($aid, $informant, $datetime, $title, $counter, $topic, $hometext, $notes, $morelink, $topicname, $topicimage, $topictext,$story_link);
			}
			else {
				themeindexnothumb($aid, $informant, $datetime, $title, $counter, $topic, $hometext, $notes, $morelink, $topicname, $topicimage, $topictext,$story_link);
			}
		}
		echo "</fieldset>";
		if ($home != 1 && $nbrefiches > 0) {
			echo "<hr class=\"pages\">".$indexlist."<hr class=\"pages\">";
		}
	}
	
	if ($home != 1) {
		/*$bardef=array("back"=>"javascript:window.history.back()",
				//"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",
				//"mailto"=>"modules.php?name=News&amp;file=friend&amp;op=FriendSend&amp;sid=$sid",
				"top"=>"#top" );*/
		$bardef=array("back"=>$_SERVER["HTTP_REFERER"],
				"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",
				//"mailto"=>"modules.php?name=News&amp;file=friend&amp;op=FriendSend&amp;sid=$sid",
				"top"=>"#top" );
		buttonBar($bardef, "align");
	}
	include("footer.php");
}

function rate_article($sid, $score) {
	global $prefix, $db, $ratecookie, $sitename, $r_options;
	if ($score) {
		if ($score > 5) { $score = 5; }
		if ($score < 1) { $score = 1; }
		if (isset($ratecookie)) {
			$rcookie = base64_decode($ratecookie);
			$r_cookie = explode(":", $rcookie);
		}
		for ($i=0; $i < sizeof($r_cookie); $i++) {
			if ($r_cookie[$i] == $sid) {
				$a = 1;
			}
		}
		if ($a == 1) {
			Header("Location:
	modules.php?name=News&op=rate_complete&sid=$sid&rated=1");
		} else {
			$result = $db->sql_query("update ".$prefix."_stories set
	score=score+$score, 
	ratings=ratings+1 where sid='$sid'");
			$info = base64_encode("$rcookie$sid:");
			setcookie("ratecookie","$info",time()+3600);
			Header("Location:
	modules.php?name=News&op=rate_complete&sid=$sid$r_options");
		}
	}
	else {
		include("header.php");
		echo "<h1>"._ARTICLERATING."</h1>";
		
		echo "<br /><br /><center>"._DIDNTRATE."<br><br>"
		.""._GOBACK."</center>";
		
		include("footer.php");
	}
}

function rate_complete($sid, $rated=0) {
	global $sitename, $r_options;
	include("header.php");
	echo "<h1>"._ARTICLERATING."</h1>";

	if ($rated == 0) {
		echo "<center><br /><br />"._THANKSVOTEARTICLE."<br><br>"
		."[ <a href=\"modules.php?name=News&amp;file=article&amp;sid=$sid$r_options\">"._BACKTOARTICLEPAGE."</a> ]</center>";
	}
	elseif ($rated == 1) {
		echo "<center>"._ALREADYVOTEDARTICLE."<br><br>"
		."[ <a href=\"modules.php?name=News&amp;file=article&amp;sid=$sid$r_options\">"._BACKTOARTICLEPAGE."</a> ]</center>";
	}

	include("footer.php");
}

function listMarches($new_topic=0, $dateOrder="yes",$nocat="no", $nolimit="yes") {
	global $db, $storyhome, $topicname, $topicimage, $topictext, $datetime, $user, $cookie, $nukeurl, $prefix, $multilingual, $currentlang, $articlecomm, $sitename;
	global $home;
	global $user;
	if (is_user($user)) {
		
		ajoutStat("301 : consultation des marchs publics");
		
		if ($multilingual == 1) {
			$querylang = "AND (alanguage='$currentlang' OR alanguage='')";
		} else {
			$querylang = "";
		}
		include("header.php");
		$theOrder="";
		if ($dateOrder=="yes") {$theOrder="time ASC, ";}
		automated_news();
		if (isset($cookie[3])) {
			$storynum = $cookie[3];
		}
		else {
			$storynum = $storyhome;
		}
		if ($new_topic == 0) {
			$qdb = "WHERE (time > '".date("Y-m-d H:i:s")."') AND (ihome='0' OR catid='0')";
			$home_msg = "";
		}
		elseif ($new_topic == -1){
			$qdb = "WHERE ";
			$querylang = "(time > '".date("Y-m-d H:i:s")."') AND (alanguage='$currentlang' OR alanguage='')";
			$home_msg = "";
		}
		else {
			$qdb = "WHERE (time > '".date("Y-m-d H:i:s")."') AND (topic='$new_topic')";
			$res = $db->sql_query("select topicname,topictext from ".$prefix."_topics where topicid='$new_topic'");
			list($topic_name,$topic_title) = $db->sql_fetchrow($res);
	
			if ($db->sql_numrows($res) == 0) {
				echo "<div class=\"news_seach_title\">$sitename</div>"._NOINFO4TOPIC."<br><br>[ <a href=\"modules.php?name=News\">"._GOTONEWSINDEX."</a> | <a href=\"modules.php?name=Topics\">"._SELECTNEWTOPIC."</a> ]</center>";
			}
			else {
				echo "<h1>".$topic_title."</h1>";
				echo "<fieldset><legend>"._SEARCHACTUS."</legend>";
				echo "<form action=\"modules.php?name=Search\" method=\"post\">";
				echo "<p style=\"text-align: center\"><b>"._KEYWORDS.$topic_title."</b><br />&nbsp;<br />"
				."<input type=\"hidden\" name=\"topic\" value=\"$new_topic\">"
				."<input type=\"hidden\" name=\"type\" value=\"stories\">"
				."<input type=\"text\" name=\"query\" size=\"30\" id=\"zquery\">&nbsp;&nbsp;"
				."<input type=\"submit\" value=\""._GOSEARCH."\"><br />&nbsp;</p>"
				."</form>";
				echo "</fieldset>";
				echo "<br />";
			}
		}
		$result = $db->sql_query("SELECT distinct catid, count(catid) as nbre FROM ".$prefix."_stories $qdb $querylang group by catid");
		if ($db->sql_numrows($result)!= 0 && $nocat=="no") {
			echo "<fieldset><legend>"._CATSCALS."</legend>";
			echo "<ul class=\"listcatnews\">";
			while (list($categorie,$nbre)=$db->sql_fetchrow($result)) {
				$resultc = $db->sql_query("select title from ".$prefix."_stories_cat where catid='$categorie'");
				list($title1) = $db->sql_fetchrow($resultc);
				echo "<li><a href=\"modules.php?name=News&amp;file=categories&amp;op=newindex&amp;catid=$categorie\">$title1</a> ($nbre)</li>";
			}
			echo "</ul>";
			echo "</fieldset>";
			echo "<br />";
		}
		$limit = "";
		if ($nolimit == "no") {
			$limit = " limit $storynum";
		}
		
		$result = $db->sql_query("SELECT sid, catid, aid, title, time, hometext, bodytext, comments, counter, topic, informant, notes, acomm, score, ratings FROM ".$prefix."_stories $qdb $querylang ORDER BY $theOrder sid DESC".$limit);
		if (!$result) {
			print_r($db->sql_error());
			die('Invalid query');
		}
		if ($db->sql_numrows($result) != 0) {
			echo "<h1>"._SELECTEDCALLS."</h1>";
		}
		while (list($s_sid, $catid, $aid, $title, $time, $hometext, $bodytext, $comments, $counter, $topic, $informant, $notes, $acomm, $score, $ratings) = $db->sql_fetchrow($result)) {
			if ($catid > 0) {
				list($cattitle) = $db->sql_fetchrow($db->sql_query("select title from ".$prefix."_stories_cat where catid='$catid'"));
			}
			getTopics($s_sid);
			formatTimestamp($time);
			$subject = stripslashes($subject);
			$hometext = stripslashes($hometext);
			$notes = stripslashes($notes);
			$introcount = strlen($hometext);
			$fullcount = strlen($bodytext);
			$totalcount = $introcount + $fullcount;
			$c_count = $comments;
			$r_options = "";
			if (isset($cookie[4]) && !empty($cookie[4])) { $r_options .= "&amp;mode=$cookie[4]"; }
			if (isset($cookie[5]) && !empty($cookie[5])) { $r_options .= "&amp;order=$cookie[5]"; }
			if (isset($cookie[6]) && !empty($cookie[6])) { $r_options .= "&amp;thold=$cookie[6]"; }
			if (is_user($user)) {
				$the_icons = " &bull; <a href=\"modules.php?name=News&amp;file=print&amp;sid=$s_sid\"><img src=\"images/print.gif\" border=\"0\" Alt=\""._PRINTER."\"></a>&nbsp;&nbsp;<a href=\"modules.php?name=News&amp;file=friend&amp;op=FriendSend&amp;sid=$s_sid\"><img src=\"images/friend.gif\" border=\"0\" Alt=\""._FRIEND."\"></a>";
			}
			else {
				$the_icons = "";
			}
			$story_link = "<a href=\"modules.php?name=News&amp;file=article&amp;sid=$s_sid$r_options\">";
			$morelink = "";
			if (($fullcount > 0) OR ($c_count > 0)) {
				$morelink .= "$story_link"._READMORE."</a>";
			}
			else {
				$morelink .= "";
			}
			$sid = $s_sid;
			if ($catid != 0) {
				$resultm = $db->sql_query("select title from ".$prefix."_stories_cat where catid='$catid'");
				list($title1) = $db->sql_fetchrow($resultm);
				if ($morelink != "") {
					$morelink .= " &bull; ";
				}
				$morelink .= "<a href=\"modules.php?name=News&amp;file=categories&amp;op=newindex&amp;catid=$catid\">$title1</a>";
			}
			$morelink .= "$the_icons";
			$morelink = str_replace(" &bull;  &bull; ", " &bull; ", $morelink);
			
			echo '<fieldset><legend>'."<img src=\"images/topics/$topicimage\" class=\"topicImg\" border=\"0\" alt=\"$topictext\">".$title.'</legend>';
			$time = preg_replace("#([0-9]{4})-([0-9]{2})-([0-9]{2}) ([0-9]+):([0-9]+):([0-9]+)#i","\\3/\\2/\\1 \\4:\\5",$time);
			if ($notes != "") {
				$notes = "<hr class=\"news\" /><p class=\"note\"><span class=\"title\">"._NOTE."</span> $notes</p>\n";
			}
			else {
				$notes = "";
			}
			echo "<p class=\"redactorcalls\">".ucfirst(_LIMITDATECALLS)." ";
			echo "$time $timezone</p>";
			echo "$hometext$notes\n";
			
			echo "<hr  class=\"news\" /><p class=\"actions\">".$morelink."</p>";
			echo '</fieldset>&nbsp;<br />';
			
			/*echo '<h2>'."<img src=\"images/topics/$topicimage\" class=\"topicImg\" border=\"0\" alt=\"$topictext\">".$title.'</h2>';
			$time = preg_replace("# ([^\ ])+ ([0-9]+):([0-9]+):([0-9]+)#","",$time);
			if ($notes != "") {
				$notes = "<hr class=\"news\" /><p class=\"note\"><span class=\"title\">"._NOTE."</span> $notes</p>\n";
			}
			else {
				$notes = "";
			}
			echo "<p class=\"redactor\">".ucfirst(_LIMITDATECALLS)." ";
			echo "$time $timezone</p>";
			echo "$hometext$notes\n";
			echo "<hr  class=\"newscalls\" /><p class=\"actions\">".$morelink."</p>";*/
			
			
			
			
		}
		if ($home != 1) {
			$bardef=array(//"back"=>"javascript:window.history.back()",
					//"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",
					//"mailto"=>"modules.php?name=News&amp;file=friend&amp;op=FriendSend&amp;sid=$sid",
					"top"=>"#top" );
			buttonBar($bardef, "align");
		}
		include("footer.php");
	}
	else {
		die("You're not allowed !");
	}
}



function display_actu_flash($new_topic) {
	global $prefix, $db, $module_name,$album_type,$_headerContent,$Default_Theme, $pagetitle;
	global $galleryCarouselAdministration, $newsCarouselWidth, $newsCarouselHeight;

	if (file_exists("themes/$Default_Theme/actus.swf")) {
		$src = "themes/$Default_Theme/actus";
	}
	else {
		$src = "modules/$module_name/actus";
	}

	if (function_exists("format_topic")) {
		list($_headerContent, $actus_flash) = format_topic($new_topic);
	}
	else {
		$_headerContent .= '
<script language="javascript">AC_FL_RunContent = 0;</script>
<script src="modules/'.$module_name.'/AC_RunActiveContent.js" language="javascript"></script>
';
		$actus_flash = "
<script language=\"javascript\">
	if (AC_FL_RunContent == 0) {
		alert(\"Cette page ncessite le fichier AC_RunActiveContent.js.\");
	} else {
		AC_FL_RunContent(
			'codebase', 'http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=10,0,0,0',
			'width', '$newsCarouselWidth',
			'height', '$newsCarouselHeight',
			'src', '$src',
			'quality', 'high',
			'pluginspage', 'http://www.macromedia.com/go/getflashplayer',
			'align', 'middle',
			'play', 'true',
			'loop', 'true',
			'scale', 'showall',
			'wmode', 'transparent',
			'devicefont', 'false',
			'id', 'myMenu',
			'bgcolor', 'false',
			'name', 'actus',
			'menu', 'true',
			'allowFullScreen', 'true',
			'allowScriptAccess','samedomain',
			'movie', '$src',
			'salign', '',
			'FlashVars', 'parametre=modules/$module_name/params.xml&librairie=actusXML_$new_topic.htm'
			); //end AC code
	}
</script>"
	.'<noscript>
	<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=10,0,0,0" id="actus" name="actus" />
</noscript>';
	}
	include("header.php");
	
	echo "$actus_flash";
	
	if ($home != 1) {
		/*$bardef=array("back"=>"javascript:window.history.back()",
				//"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",
				//"mailto"=>"modules.php?name=News&amp;file=friend&amp;op=FriendSend&amp;sid=$sid",
				"top"=>"#top" );*/
		$bardef=array("back"=>$_SERVER["HTTP_REFERER"],
				//"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",
				//"mailto"=>"modules.php?name=News&amp;file=friend&amp;op=FriendSend&amp;sid=$sid",
				"top"=>"#top" );
		buttonBar($bardef, "align");
	}
	include("footer.php");
}

function display_actus_rss($artid) {
	include("header.php");
	if ($artid != "") {
		require_once("modules/Sections/connector_class.php");
		$sectmodule = new pageconnector();
		echo  "\n".$sectmodule->getPageContent($artid);
	}
	else {
		echo "<h1>"._NEWSPAGERSS."</h1>";
		echo "<p><br /><br />"._NEWSPAGERSSBODY."<br /></p>";
	}
	include("footer.php");
}

function getXML($new_topic) {
	global $prefix, $db, $module_name;
    require_once("modules/$module_name/connector_lib.php");
	$sortie = getnewsXML($new_topic);
	header("Content-Type: text/xml; charset=UTF-8");
	echo $sortie;
}

function sendJSONNews($max_width, $max_height, $longtitle, $longdesc, $topicid, $nbre) {
	require_once("connector_lib.php");
	$sortie = getJSONNews($max_width, $max_height, $longtitle, $longdesc, $topicid, $nbre, false);
	header("Content-Type: application/json; charset=UTF-8");
	echo "{".$sortie."}";
}

switch ($op) {
	default:
		listactus($new_topic, $catid, $dateOrder);
		break;
	/*default:
		if (!isset($nocat)) {
			$nocat="no";
		}
		if (!isset($nolimit)) {
			$nolimit="no";
		}
		if (!isset($dateOrder)) {
			$dateOrder = "yes";
		}
		theindex($new_topic, $dateOrder, $nocat, $nolimit);
		break;*/
	case "newlist":
		if (!isset($nocat)) {
			$nocat="no";
		}
		if (!isset($nolimit)) {
			$nolimit="no";
		}
		if (!isset($dateOrder)) {
			$dateOrder = "yes";
		}
		thenewindex($new_topic, $dateOrder, $nocat, $nolimit);
		break;

	case "listmarches":
		listMarches($new_topic);
		break;
		
	case "rate_article":
		rate_article($sid, $score);
		break;

	case "rate_complete":
		rate_complete($sid, $rated);
		break;

	case "actus_flash":
		require_once("themes/$Default_Theme/theme.php");
		display_actu_flash($new_topic);
		break;
	
	case "actus_rss":
		display_actus_rss($newssectionrss);
		break;
	case "getXML":
		getXML($new_topic);
		break;
	case "newsJSON":
		sendJSONNews($max_width, $max_height, $longtitle, $longdesc,$topicid,$nbre);
		break;
}

?>
