/**
 * 
 */
var VIDEOS_SERVICE_URL = 'https://www.googleapis.com/youtube/v3/videos';
var CHANNELS_SERVICE_URL = 'https://www.googleapis.com/youtube/v3/channels';
var PLAYLISTS_SERVICE_URL = 'https://www.googleapis.com/youtube/v3/playlists';
var PLAYLISTSITEMS_SERVICE_URL = 'https://www.googleapis.com/youtube/v3/playlistItems';
var video = null;
var category;

/**
 * Permet d'initialiser les valeur de la video
 */
function initYouTube() {
	var videoId = document.getElementById('url').value;
	checkVideo(videoId);
	var selectElmt = document.getElementById("cat");
	var tab = selectElmt.options[selectElmt.selectedIndex].text.split("/");
	category = "";
	if(tab.length > 1) {
		tab.shift();
		category = tab.join(" / ");
	} else {
		category = tab[0];
	}
}

/**
 * Peremt de recuperer la chaine courante 
 */
function getChannel() {
	$.ajax({
		url: CHANNELS_SERVICE_URL,
		method: 'GET',
		headers: {
			Authorization: 'Bearer ' + accessToken
		},
		data: {
			part: 'id,snippet',
			mine: true
		}
	}).done(function(response) {
		if( response.items.length == 1 ) {
			channelId = response.items[0].id;
			getPlayLists();
		}
	});
}

/**
 * Permet de vérifier si la playlist existe, sinon on la cré
 */
function getPlayLists() {
	var selectElmt = document.getElementById("cat");
	var tab = selectElmt.options[selectElmt.selectedIndex].text.split("/");
	var cat = "";
	if(tab.length > 1) {
		tab.shift();
		cat = tab.join(" / ");
	} else {
		cat = tab[0];
	}
	$.ajax({
		url: PLAYLISTS_SERVICE_URL,
		method: 'GET',
		headers: {
			Authorization: 'Bearer ' + accessToken
		},
		data: {
			part: 'id,snippet',
			maxResults: 50,
			channelId: channelId,
			snippet: {
				title: cat
			}
		}
	}).done(function(response) {
		var existe = false;
		if( response ) {
			for(var i = 0; i < response.items.length; i++) {
				var title = response.items[i].snippet.title;
				if( title == cat ) {
					playlistId = response.items[i].id;
					existe = true;
					break;
				}
			}
		}
		if( existe ) {
			var videoId = document.getElementById('url').value;
			updateVideo(videoId);
		} else {
			createPlaylist(cat, "", 'public');
		}
	});
}

/**
 * Permet de créé la playlist
 * @param title le titre
 * @param description la description
 * @param status le status
 */
function createPlaylist(title, description, status) {
	var request = gapi.client.youtube.playlists.insert({
		part: 'snippet,status',
		resource: {
			snippet: {
				title: title,
				description: description
			},
			status: {
				privacyStatus: status
			}
		}
	});
	request.execute(function(response) {
		var result = response.result;
		if (result) {
			playlistId = result.id;
			var videoId = document.getElementById('url').value;
			updateVideo(videoId);
		}
	});
}

/**
 * Peremt de récupérer les infos d'une video
 * @param videoId l'id de la video
 */
function checkVideo(videoId) {
	$.ajax({
		url: VIDEOS_SERVICE_URL,
		method: 'GET',
    	headers: {
    		Authorization: 'Bearer ' + accessToken
    	},
    	data: {
    		part: 'snippet,status',
    		id: videoId
    	}
	}).done(function(response) {
		video = response;
		var title = response.items[0].snippet.title;
		var description = response.items[0].snippet.description;
		var arrayTags = response.items[0].snippet.tags;
		var tags = "";
		for(var i = 0; i < arrayTags.length; i++) {
			tags += arrayTags[i] + ", ";
		}
		var statusPub = response.items[0].status.privacyStatus;
		//var fileSize = response.items[0].fileDetails.fileSize;
		document.getElementById('title').value = title;
		document.getElementById('description').value = description;
		document.getElementById('tags').value = tags;
		document.getElementById('status').value = statusPub;
		//document.getElementById('filesize').value = fileSize;
   	});
}

/**
 * Peremt d'uploader la video
 */
function updateVideo(videoId) {
	if( video != null ) {
		var title = document.getElementById('title').value;
		var description = document.getElementById('description').value;
		var tags = document.getElementById('tags').value;
		var arrayTags = tags.split(',');
		for(var i = 0; i < arrayTags.length; i++) {
			arrayTags[i] = arrayTags[i].trim();
		}
		var statusPub = document.getElementById('status').value;
		
		if( video.items.length == 1 ) {
			video.items[0].snippet.title = title;
			video.items[0].snippet.description = description;
			video.items[0].snippet.tags = arrayTags;
			video.items[0].status.privacyStatus = statusPub;

			var request = gapi.client.youtube.videos.update({
				part: "id,snippet,status",
				resource: video.items[0]
			});
			request.execute(function(response, raw) {
				var selectElmt = document.getElementById("cat");
				var tab = selectElmt.options[selectElmt.selectedIndex].text.split("/");
				var cat = "";
				if(tab.length > 1) {
					tab.shift();
					cat = tab.join(" / ");
				} else {
					cat = tab[0];
				}
				if( category != cat) {
					moveToPlaylist(video.items[0].id);
					getPlayListsPrec(video.items[0].id);
				} else {
					document.forms['theForm'].submit();
				}
			});
		}
	}
}

/**
 * Peremt de mettre la video dans une autre playlist
 * @param id l'id de la video
 * @param startPos
 * @param endPos
 */
function moveToPlaylist(id, startPos, endPos) {
	var details = {
		videoId: id,
	    kind: 'youtube#video'
	}
	if (startPos != undefined) {
		details['startAt'] = startPos;
	}
	if (endPos != undefined) {
		details['endAt'] = endPos;
	}
	var request = gapi.client.youtube.playlistItems.insert({
		part: 'snippet',
	    resource: {
	    	snippet: {
	    		playlistId: playlistId,
	    		resourceId: details
	    	}
	    }
	});
	request.execute(function(response) {
		document.forms['theForm'].submit();
	});
}

/**
 * Permet de recuperer la playlist precedente et de supprimer la video si elle existe
 * @param videoId l'id de la video
 */
function getPlayListsPrec(videoId) {
	$.ajax({
		url: PLAYLISTS_SERVICE_URL,
		method: 'GET',
		headers: {
			Authorization: 'Bearer ' + accessToken
		},
		data: {
			part: 'id,snippet',
			maxResults: 50,
			channelId: channelId,
			snippet: {
				title: category
			}
		}
	}).done(function(response) {
		var existe = false;
		if( response ) {
			for(var i = 0; i < response.items.length; i++) {
				var title = response.items[i].snippet.title;
				if( title == category ) {
					playlistId = response.items[i].id;
					existe = true;
					break;
				}
			}
		}
		if( existe ) {
			$.ajax({
				url: PLAYLISTSITEMS_SERVICE_URL,
				method: 'GET',
				headers: {
					Authorization: 'Bearer ' + accessToken
				},
				data: {
					part: 'id,snippet,contentDetails',
					maxResults: 50,
					playlistId: playlistId
				}
			}).done(function(response) {
				var existe = false;
				var id;
				if( response ) {
					for(var i = 0; i < response.items.length; i++) {
						var title = response.items[i].snippet.title;
						if( videoId == response.items[i].contentDetails.videoId ) {
							id = response.items[i].id;
							//id = i;
							existe = true;
							break;
						}
					}
				}
				if( existe ) {
					deleteVideoPlayList(videoId, id);
				}
			});
		}
	});
}

/**
 * Peremt de supprimer la video
 */
function deleteVideoPlayList(videoId, id) {
	var request = gapi.client.youtube.playlistItems.delete({
		id: id
	});
	request.execute(function(response) {
		//alert(JSON.stringify(response));
		//moveToPlaylist(videoId);
	});
}
