<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Calendrier Module      	            								*/
/* Copyright (c) 2006  Stephan Acquatella								*/
/* Integration in BECMS (rewrite admin UI), add registration managment	*/
/*																		*/
/* Based on code done by Amine Laurent BENKHOUCHA 2003/2004				*/
/* http://phpnuke-france.org											*/
/* Version Amliore de Event Calendar version 2.0						*/
/* D'aprs les travaux de Rob Sutton et Aleks A.Lessmann				*/
/* Prefix and minor bugfixes by                         				*/
/* fsz dESIGN & maaX dESIGN                             				*/
/* http://www.fsz-design.de  http://www.maax-design.de  				*/
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2002 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

$index = 0;
$module_name = basename(dirname(__FILE__));
include("modules/$module_name/config.php");
include_once("modules/Calendrier/connector_lib.php");
require_once("includes/truncate_string.php");

/********************************************************/

if (!preg_match("#modules.php#i", $_SERVER['PHP_SELF'])) {
	die ("Erreur:Vous ne pouvez pas acceder directement  ce fichier...");
}

function buildMonthSelect($month) {
	for ($i = 1; $i <= 12; $i++) {
		if ($i == $month) $sel = "SELECTED";
		else $sel = "";
		echo "<option $sel value=\"$i\">$i\n</option>";
	}
}

function buildDaySelect($day) {
	for ($i = 1; $i <= 31; $i++) {
		if ($i == $day) $sel = "SELECTED";
		else $sel = "";
		echo "<option $sel value=\"$i\">$i\n</option>";
	}
}

function buildYearSelect($year) {
	for ($i = 1997; $i <= 2030; $i++) {
		if ($i == $year) $sel = "SELECTED";
		else $sel = "";
		echo "<option $sel value=\"$i\">$i\n</option>";
	}
}

function printAppt($sql) {
	global $module_name,$eventsopeninnewwindow,$time24Hour, $db;
	$sortie = "";
	$result = $db->sql_query($sql);
	//if ($db->sql_numrows($result) == 0) echo "<br>";
	if ($eventsopeninnewwindow) {
		$frame = "target=\"blank\"";
	} else {
		$frame = "";
	}
	while(list($eid, $title, $startTime, $endTime, $barcolor) = $db->sql_fetchrow($result)) {
		if ($barcolor == "r") $barcolorchar="r";
		elseif ($barcolor == "g") $barcolorchar="g";
		elseif ($barcolor == "b") $barcolorchar="b";
		elseif ($barcolor == "y") $barcolorchar="y";
		else $barcolorchar="w";
		if ($time24Hour) {
			$time_Array = explode(":",$startTime);
			$startTime = $time_Array[0].":".$time_Array[1];
			$time_Array = explode(":",$endTime);
			$endTime = $time_Array[0].":".$time_Array[1];
		}
		else {
			$startTime = getTime($startTime);
			$endTime = getTime($endTime);
		}
		$sortie .= ($sortie != "") ? "<br />" : "";
		$sortie .= "<img src=\"modules/$module_name/images/ball$barcolorchar.gif\" border=0> "
		."<a href=\"modules.php?op=modload&amp;name=$module_name&amp;file=index&amp;type=view&amp;eid=$eid\"$frame>$startTime-$endTime, $title</a>";
	}
	echo $sortie;
	$db->sql_freeresult($result);
}

function getTime($time) {
	$time_Array = explode(":",$time);
	$min = $time_Array[1];
	if ($time_Array[0] == "00") {
		$hour = "12";
		$ampm = "AM";
	} elseif ($time_Array[0] == "12") {
		$hour = "12";
		$ampm = "PM";
	} elseif ($time_Array[0] > 12) {
		$hour = $time_Array[0] - 12;
		$ampm = "PM";
	} else {
		if ($time_Array[0] < 10)
		$hour = substr($time_Array[0],1,1);
		else
		$hour = $time_Array[0];
		$ampm = "AM";
	}
	$time = "$hour:$min $ampm";
	return $time;
}

function getMonthName($Date) {
	$month = Date("m",$Date);
	if ($month == "01") {
		$monthname = _CALJAN;
	} elseif ($month == "02") {
		$monthname = _CALFEB;
	} elseif ($month == "03") {
		$monthname = _CALMAR;
	} elseif ($month == "04") {
		$monthname = _CALAPR;
	} elseif ($month == "05") {
		$monthname = _CALMAY;
	} elseif ($month == "06") {
		$monthname = _CALJUN;
	} elseif ($month == "07") {
		$monthname = _CALJUL;
	} elseif ($month == "08") {
		$monthname = _CALAUG;
	} elseif ($month == "09") {
		$monthname = _CALSEP;
	} elseif ($month == "10") {
		$monthname = _CALOCT;
	} elseif ($month == "11") {
		$monthname = _CALNOV;
	} elseif ($month == "12") {
		$monthname = _CALDEC;
	}
	return $monthname;
}

function getLongDayName($Date) {
	$month = Date("w",$Date);
	if ($month == "0") {
		$dayname = _CALLONGFIRSTDAY;
	} elseif ($month == "1") {
		$dayname = _CALLONGSECONDDAY;
	} elseif ($month == "2") {
		$dayname = _CALLONGTHIRDDAY;
	} elseif ($month == "3") {
		$dayname = _CALLONGFOURTHDAY;
	} elseif ($month == "4") {
		$dayname = _CALLONGFIFTHDAY;
	} elseif ($month == "5") {
		$dayname = _CALLONGSIXTHDAY;
	} elseif ($month == "6") {
		$dayname = _CALLONGSEVENTHDAY;
	}
	return $dayname;
}

function valueToText($tmp) {
	$tmp = preg_replace("#10#","",$tmp);
	$tmp = preg_replace("#9#","&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;",$tmp);
	$tmp = preg_replace("#<#","&lt;",$tmp);
	$tmp = preg_replace("#>#","&gt;",$tmp);
	$tmp = preg_replace("#\"#","&quot;",$tmp);
	$tmp = preg_replace("#13#","<br>",$tmp);
	//$tmp = str_replace("\\","\\\\",$tmp);
	$tmp = preg_replace("#'#","`",$tmp);

	return $tmp;

}

function loadStyle() {
	echo" <STYLE TYPE=\"text/css\">
        <!--
                .popper      { position: absolute; visibility: hidden }
        //-->
        </STYLE>";
}

function loadPopups() {
	global $popcolormain,$popbgcolorcontent,$popcolormainheadfont;

	echo "<DIV ID=\"topdeck\" CLASS=\"popper\">
	&nbsp;
	</DIV>
	<SCRIPT>
	var popback = \"$popbgcolorcontent\";
	var popbord = \"$popcolormain\";
	var nav = (document.layers);
	var iex = (document.all);
	var skn = (nav) ? document.topdeck : topdeck.style;
	if (nav) document.captureEvents(Event.MOUSEMOVE);
	document.onmousemove = get_mouse;

	function pop(title,msg,bord,back)
	{
	var content =\"<TABLE WIDTH=260 BORDER=0 CELLPADDING=2 CELLSPACING=0 BGCOLOR=\"+bord+\"><TR><TD><TABLE WIDTH=100% BORDER=0 CELLPADDING=0 CELLSPACING=0><TR><TD><CENTER><FONT COLOR=$popcolormainheadfont SIZE=2><B>\"+title+\"</B></FONT></CENTER></TD></TR></TABLE><TABLE WIDTH=100% BORDER=0 CELLPADDING=2 CELLSPACING=0 BGCOLOR=\"+back+\"><TR><TD>\"+msg+\"</TD></TR></TABLE></TD></TR></TABLE>\";


	if (nav)
	{
	skn.document.write(content);
	skn.document.close();
	skn.visibility = \"visible\";
}
else if (iex)
{
document.all(\"topdeck\").innerHTML = content;
skn.visibility = \"visible\";
}
}

function get_mouse(e)
{
if (navigator.appName==\"Microsoft Internet Explorer\"){
var x = (nav) ? e.pageX : event.x+document.body.scrollLeft;
var y = (nav) ? e.pageY : event.y+document.body.scrollTop;
} else {
var x = (nav) ? e.pageX : e.x+document.body.scrollLeft;
var y = (nav) ? e.pageY : e.y+document.body.scrollTop;
}
skn.left = x - 60;
skn.top  = y+20;
}

function kill()
{
skn.visibility = \"hidden\";
}
</SCRIPT>";
}

function buildYear($Date) {
	global $module_name,$yeartableborder,$yeartablecellspacing,$yeartablecellpadding,$trimbgcolor,$trimtextcolor,$yearbgcolor,$selecteddaycolor,$yeartextcolor;
	global $prefix,$db;
	if (!$Date) {
		$Date = Date("m/d/Y");
	}
	$Date_Array = explode("/", $Date);
	if ($Date_Array[2] < 1970)
	print("ERROR! System can not interpret dates before 01/01/1970");
	else {
		$Date = mktime(0, 0, 0, $Date_Array[0], $Date_Array[1], $Date_Array[2]);

		/**** Header */
		$Prev_Year = mktime(0, 0, 0, $Date_Array[0], $Date_Array[1], $Date_Array[2] - 1);
		$Prev_Date = Date("m/d/Y",$Prev_Year);
		$Next_Year = mktime(0, 0, 0, $Date_Array[0], $Date_Array[1], $Date_Array[2] + 1);
		$Next_Date = Date("m/d/Y",$Next_Year);

		/**** rcup les vnements */
		$evenements = array();
		$resultEvtMois = $db->sql_query("SELECT eid,title,eventDate,endDate,startTime,endTime,barcolor FROM ".$prefix."_events WHERE (eventDate <= '".$Date_Array[2]."-12-31' AND endDate >= '".$Date_Array[2]."-01-01') ORDER BY startTime, endTime ASC");
		while(list($eid, $title, $eventDate, $endDate, $startTime, $endTime, $barcolor) = $db->sql_fetchrow($resultAPPT)) {
			list($an,$mois,$jour) = explode("-",$eventDate);
			do {
				$date_en_cours = date("Y-m-d",mktime(0,0,0,$mois,$jour,$an));
				$evenements[$date_en_cours] = "1";
				$jour++;
			} while($date_en_cours<$endDate);
		}

		echo "<fieldset><legend>".Date("Y",$Date)."</legend>";

		print("<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"calaction\"><tr>");

		/**** Print Previous Year Button */
		print("<td width=width=\"50%\"><a href=\"modules.php?op=modload&name=$module_name&file=index&Date=$Prev_Date&type=year\"><<< "._CALPREVIOUS."</a></td>");

		/**** Print Next Year Button */
		print("<td width=\"50%\" align=right><a href=\"modules.php?op=modload&name=$module_name&file=index&Date=$Next_Date&type=year\">"._CALNEXT." >>></a></TD>");
		print("</TR></table>");
		echo "<table border=\"0\" cellpadding=\"6\" width=\"100%\"><TR>";
		for ($i=1;$i<13;$i++) {
			/**** Get the Day (Integer) for the first day in the month */
			$First_Day_of_Month_Date = mktime(0, 0, 0, $i, 1, $Date_Array[2]);
			$Date = $First_Day_of_Month_Date;
			$Date_Array[0] = $i;
			$Day_of_First_Week = date("w",$First_Day_of_Month_Date)-1;
			$Day_of_First_Week = ($Day_of_First_Week == -1) ? 6 : $Day_of_First_Week;

			/**** Find the last day of the month */
			$Month = Date("m",$Date);
			$day = 27;
			do {
				$End_of_Month_Date = mktime(0, 0, 0, $Date_Array[0], $day, $Date_Array[2]);
				$Test_Month = Date("m",$End_of_Month_Date);
				$day += 1;
			} while ( $Month == $Test_Month );
			$Last_Day = $day - 2;

			/**** Get todays date */
			$Today_d = Date("d");
			$Today_m = Date("m");
			$Today_y = Date("Y");
				
			/**** Build Month */
			if (($i == 4) || ($i == 7) || ($i == 10)) {
				print("</TR><TR><TD colspan=\"3\"></TD></TR><TR>");
			}
			echo "<TD valign=\"top\" align=\"center\">\n";
			//."<TABLE border=$yeartableborder cellspacing=$yeartablecellspacing cellpadding=$yeartablecellpadding>";
			echo "<TABLE class=\"eventMonth\">";
			echo "<TR class=\"eventTrimMonth\"><TH colspan=\"7\" class=\"eventTrimMonth\"><a href=\"modules.php?op=modload&name=$module_name&file=index&Date=$i/1/$Date_Array[2]&type=month\">";
			print( getMonthName($Date) );
			echo "</a></TH></TR>";
				
			echo "<tr class=\"eventTrimMonth\">";
			echo "<th class=\"eventTrimMonth\">"._CALFIRSTDAYSMALL."</th>";
			echo "<th class=\"eventTrimMonth\">"._CALSECONDDAYSMALL."</th>";
			echo "<th class=\"eventTrimMonth\">"._CALTHIRDDAYSMALL."</th>";
			echo "<th class=\"eventTrimMonth\">"._CALFOURTHDAYSMALL."</th>";
			echo "<th class=\"eventTrimMonth\">"._CALFIFTHDAYSMALL."</th>";
			echo "<th class=\"eventTrimMonth\">"._CALSIXTHDAYSMALL."</th>";
			echo "<th class=\"eventTrimMonth\">"._CALSEVENTHDAYSMALL."</th>";
			echo "</tr>";

			/**** Previous Greyed month days */
			if ($Day_of_First_Week != 0) {
				echo "<TR>";
				//print("<TD colspan=$Day_of_First_Week></TD>");
				for ($j=1;$j<=$Day_of_First_Week;$j++) {
					echo "<td class=\"eventDayMonth2\"></td>";
				}
			}
			$day_of_week = $Day_of_First_Week + 1;

			/**** Build Current Month */
			for ($day = 1 ; $day <= $Last_Day ; $day++) {
				if ($evenements[$Date_Array[2]."-".str_pad($i,2,"0",STR_PAD_LEFT)."-".str_pad($day,2,"0",STR_PAD_LEFT)] == "1") {
					if (($day == $Today_d) && ($Date_Array[0] == $Today_m) && ($Date_Array[2] == $Today_y)){
						$class_evt = ' class="eventDayMonthTodayWith"';
					}
					else {
						$class_evt = ' class="eventDayMonthWith"';
					}
				}
				else {
					if (($day == $Today_d) && ($Date_Array[0] == $Today_m) && ($Date_Array[2] == $Today_y)){
						$class_evt = ' class="eventDayMonthToday"';
					}
					else {
						$class_evt = ' class="eventDayMonth"';
					}
				}
				if ($day_of_week == 1) {
					print("<TR>");
				}
				/*if (($day == $Today_d) && ($Date_Array[0] == $Today_m) && ($Date_Array[2] == $Today_y)){
					echo "<TD class=\"eventDayMonth2\"><div class=\"eventDayMonthToday\"><a href=\"modules.php?op=modload&name=$module_name&file=index&Date=$Date_Array[0]/$day/$Date_Array[2]&type=day\">$day</a></div></TD>";
					}
					else {
					print("<TD  class=\"eventDayMonth2\"><div class=\"eventDayMonth\"><a href=\"modules.php?op=modload&name=$module_name&file=index&Date=$Date_Array[0]/$day/$Date_Array[2]&type=day\">$day</a></div></TD>");
					}*/
				echo "<TD class=\"eventDayMonth2\"><div$class_evt><a href=\"modules.php?op=modload&name=$module_name&file=index&Date=$Date_Array[0]/$day/$Date_Array[2]&type=day\">$day</a></div></TD>";
				if ($day_of_week == 7) {
					$day_of_week = 0;
					print("</TR>");
				}
				$day_of_week += 1;
			}

			/**** Next Greyed month days */
			$day = 1;
			if ($day_of_week != 1) {
				$tmp = 8 - $day_of_week;
				//print("<TD colspan=$tmp><font size=1 color=ffffff>.</TD>");
				for ($j=1;$j<=$tmp;$j++) {
					echo "<td class=\"eventDayMonth2\"></td>";
				}
				echo "</tr>";
			}
			print("</TABLE>");
			echo "</TD>";
		}
		print("</TR></TABLE>");
		echo "</fieldset>";
	}

}

function addTimeRange($startTime,$endTime,$year,$month,$day) {
	global $time24Hour,$daytextcolor;
	global $prefix, $db;
	if ($time24Hour) {
		$tmpTime = substr($startTime,0,5);
		$tmpTime2 = substr($endTime,0,5);
	} else {
		$tmpTime = getTime($startTime);
		$tmpTime2 = getTime($endTime);
	}
	echo "<tr class=\"timeEvent\">"
	."<td class=\"hourTimeEvent\">"."$tmpTime - $tmpTime2</td>";
	//$sql = "SELECT eid, title, startTime, endTime, barcolor FROM ".$prefix."_events WHERE (eventDate<='".$year."-".$month."-".$day."' AND endDate >=   '".$year."-".$month."-".$day."' AND alldayevent='0' AND startTime >= '".$startTime."' AND startTime < '".$endTime."') ORDER BY startTime, endTime ASC;";
	$sql = "SELECT eid, title, startTime, endTime, barcolor FROM ".$prefix."_events";
	$sql .= " WHERE (eventDate<='".$year."-".$month."-".$day."' AND endDate >=   '".$year."-".$month."-".$day."' AND alldayevent='0'";
	$sql .= " AND startTime < '".$endTime."' AND endTime > '".$startTime."') ORDER BY startTime, endTime ASC;";
	echo "<td class=\"eventTimeEvent\">";
	//echo $sql;
	printAppt($sql);
	echo "</td></tr>";
}

function buildDay($Date) {
	global $module_name, $trimbgcolor, $trimtextcolor, $trimbgcolor2, $trimtextcolor2, $daybgcolor;
	global $daytextcolor, $eventsopeninnewwindow,$times;
	global $prefix, $db;

	if (!$Date) {
		$Date = Date("m/d/Y");
	}
	$Date_Array = explode("/", $Date);
	if ($Date_Array[2] < 1970) {
		print("ERREUR!<br> Le systme ne prend pas en charge les dates avant le 01/01/1970, Si vous avez utilis avec 2 chiffres veuillez l'crire avec 4 chiffres.");
	}
	else {
		$Date = mktime(0, 0, 0, $Date_Array[0], $Date_Array[1], $Date_Array[2]);

		/**** Header */
		$Prev_Month = mktime(0, 0, 0, $Date_Array[0], $Date_Array[1] - 1, $Date_Array[2]);
		$Prev_Date = Date("m/d/Y",$Prev_Month);
		$Next_Month = mktime(0, 0, 0, $Date_Array[0], $Date_Array[1] + 1, $Date_Array[2]);
		$Next_Date = Date("m/d/Y",$Next_Month);
		global $useInternationalDates;
		if ($useInternationalDates == 0)
		{
			$titredate = getLongDayName($Date)." ".getMonthName($Date)." ".Date("d, Y",$Date);
		}
		else
		{
			$titredate = getLongDayName($Date)." ".Date("d ",$Date).getMonthName($Date)." ".Date("Y",$Date);
		}
		echo "<fieldset><legend>".$titredate."</legend>";
		print("<TABLE width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"calaction\"><TR>");
		/**** Print Previous Month Button */
		print("<TD width=\"50%\"><a href=\"modules.php?op=modload&name=$module_name&file=index&Date=$Prev_Date&type=day\"><<< "._CALPREVIOUS."</a></TD>");
		/**** Print Next Month Button */
		print("<TD width=\"50%\" align=\"right\"><a href=\"modules.php?op=modload&name=$module_name&file=index&Date=$Next_Date&type=day\">"._CALNEXT." >>></a></TD>");
		print("</TR></TABLE>");

		print("<TABLE border=\"0\" cellspacing=\"5\" cellpadding=\"6\" width=\"100%\"><TR>");

		/**** Appointments */
		echo "<TD class=\"evenDay\">";
		echo "<div class=\"evenDayTitle\">"._CALHOUREVENT."</div>";

		echo "<table class=\"timeEvent\"><tr class=\"timeEvent\">"
		."<td class=\"hourTimeEvent\">"."Matin"."</td>";
		echo "<td class=\"eventTimeEvent\">";
		$sql = "SELECT eid, title, startTime, endTime, barcolor FROM ".$prefix."_events WHERE (eventDate<='".$Date_Array[2]."-".$Date_Array[0]."-".$Date_Array[1]."' AND endDate >= '".$Date_Array[2]."-".$Date_Array[0]."-".$Date_Array[1]."' AND alldayevent='0' AND startTime < '".$times[0]."') ORDER BY startTime, endTime ASC";
		printAppt($sql);
		echo "</td></tr>";
		$i = 0;
		while ($times[$i]) {
			addTimeRange($times[$i],$times[$i+1],$Date_Array[2],$Date_Array[0],$Date_Array[1]);
			//echo $times[$i]."<br>";
			$i++;
			if (!($times[$i+1])) {
				break;
			}
		}
		echo "<tr class=\"timeEvent\">"
		."<td class=\"hourTimeEvent\">"."Soir"."</td>";
		echo "<td class=\"eventTimeEvent\">";
		$sql = "SELECT eid, title, startTime, endTime, barcolor FROM ".$prefix."_events WHERE (eventDate<='".$Date_Array[2]."-".$Date_Array[0]."-".$Date_Array[1]."' AND endDate >= '".$Date_Array[2]."-".$Date_Array[0]."-".$Date_Array[1]."' AND alldayevent='0' AND startTime >= '".$times[$i]."') ORDER BY startTime, endTime ASC;";
		printAppt($sql);
		echo "</td></tr></table>";


		print("</TD>");

		/**** Events */
		echo "\n\t<TD class=\"evenDay\">";
		echo "\n\t\t<div class=\"evenDayTitle\">"._CALEVENTALLDAY."</div>";
		$result = $db->sql_query("SELECT eid,title,barcolor FROM ".$prefix."_events WHERE (eventDate <= '".$Date_Array[2]."-".$Date_Array[0]."-".$Date_Array[1]."' AND endDate >= '".$Date_Array[2]."-".$Date_Array[0]."-".$Date_Array[1]."' AND alldayevent='1') ORDER BY title ASC");
		if ($eventsopeninnewwindow) {
			$frame = "target=\"blank\"";
		}
		else {
			$frame = "";
		}
		while(list($eid, $title, $barcolor) = $db->sql_fetchrow($result)) {
			if ($barcolor == "r") $barcolorchar="r";
			elseif ($barcolor == "g") $barcolorchar="g";
			elseif ($barcolor == "b") $barcolorchar="b";
			elseif ($barcolor == "y") $barcolorchar="y";
			else $barcolorchar="w";
			print("<img src=\"modules/$module_name/images/ball$barcolorchar.gif\" border=0>&nbsp;<a href=\"modules.php?op=modload&name=$module_name&file=index&type=view&eid=$eid\" $frame>$title</a><br>");
		}

		print("\n\t</TD>\n</TR>");
		print("\n</TABLE>");

		echo "</fieldset>";
	}

}

function buildMonth($Date) {
	global $module_name, $trimbgcolor, $trimtextcolor, $trimbgcolor2, $trimtextcolor2,$textEvents,
	$monthtableborder, $monthtablecellspacing, $monthtablecellpadding, $monthbgcolor, $selecteddaycolor,
	$eventsopeninnewwindow, $monthshadedbgcolor, $monthshadedtextcolor,$time24Hour;
	global $prefix, $db;

	if (!$Date) {
		$Date = Date("m/d/Y");
	}
	$Date_Array = explode("/", $Date);
	if ($Date_Array[2] < 1970) {
		print("ERREUR! Le systme ne prend pas en charge les date avant le 01/01/1970");
	}
	else {
		loadStyle();
		loadPopups();
		$Date = mktime(0, 0, 0, $Date_Array[0], $Date_Array[1], $Date_Array[2]);

		/**** Header */
		$Prev_Month = mktime(0, 0, 0, $Date_Array[0] - 1, 1, $Date_Array[2]);
		$Prev_Date = Date("m/d/Y",$Prev_Month);
		$Next_Month = mktime(0, 0, 0, $Date_Array[0] + 1, 1, $Date_Array[2]);
		$Next_Date = Date("m/d/Y",$Next_Month);

		echo "<fieldset><legend>".getMonthName($Date)." ".Date("Y",$Date)."</legend>";
		print("<TABLE width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"calaction\"><TR>");
		/**** Print Previous Month Button */
		print("\n<TD width=\"50%\"><a href=\"modules.php?op=modload&name=$module_name&file=index&Date=$Prev_Date&type=month\"><<< "._CALPREVIOUS."</a></TD>");
		/**** Print Next Month Button */
		print("\n<TD width=\"50%\" align=\"right\"><a href=\"modules.php?op=modload&name=$module_name&file=index&Date=$Next_Date&type=month\">"._CALNEXT." >>></a></TD>");
		echo "</tr><tr height=\"4\"><td height=\"4\"></td><td height=\"4\"></td>";
		print("</TR></TABLE>");

		/**** Get the Day (Integer) for the first day in the month */
		$First_Day_of_Month_Date = mktime(0, 0, 0, $Date_Array[0], 1, $Date_Array[2]);
		$Day_of_First_Week = date("w",$First_Day_of_Month_Date)-1;
		$Day_of_First_Week = ($Day_of_First_Week == -1) ? 6 : $Day_of_First_Week;

		/**** Find the last day of the month */
		$Month = Date("m",$Date);
		$day = 27;
		do {
			$End_of_Month_Date = mktime(0, 0, 0, $Date_Array[0], $day, $Date_Array[2]);
			$Test_Month = Date("m",$End_of_Month_Date);
			$day += 1;
		} while ( $Month == $Test_Month );
		$Last_Day = $day - 2;

		/**** Get todays date */
		$Today_d = Date("d");
		$Today_m = Date("m");
		$Today_y = Date("Y");

		/**** Set up data */
		$count = -1;
		$result = $db->sql_query("SELECT eid,title,hometext,eventDate,endDate,barcolor FROM ".$prefix."_events WHERE (((eventDate >= '".$Date_Array[2]."-".$Date_Array[0]."-1' AND eventDate <= '".$Date_Array[2]."-".$Date_Array[0]."-".$Last_Day."') OR (endDate >= '".$Date_Array[2]."-".$Date_Array[0]."-1' AND endDate <= '".$Date_Array[2]."-".$Date_Array[0]."-".$Last_Day."') OR (endDate >= '".$Date_Array[2]."-".$Date_Array[0]."-".$Last_Day."' AND eventDate <= '".$Date_Array[2]."-".$Date_Array[0]."-1')) AND alldayevent='1') ORDER BY eventDate ASC");

		while(list($eid, $title, $description, $eventDate, $endDate,$barcolor) = $db->sql_fetchrow($result)) {
			$eid_Array[] = $eid;
			$title_Array[] = $title;
			$eventDate_Array[] = $eventDate;
			$endDate_Array[] = $endDate;
			$barcolor_Array[] = $barcolor;
			$desc_Array[] = valueToText($description);
			$count++;
		}
		//$count = $count - 1;
		$db->sql_freeresult($result);
		/**** Build Month */
		echo "<TABLE class=\"eventMonth\" cellspacing=\"2\" cellpadding=\"2\" border=\"0\">";
		$day_of_week = 1;

		echo "<TR class=\"eventTrimMonth\">
                        <TH class=\"eventTrimMonth\">"._CALFIRSTDAY."</TH>
                        <TH class=\"eventTrimMonth\">"._CALSECONDDAY."</TH>
                        <TH class=\"eventTrimMonth\">"._CALTHIRDDAY."</TH>
                        <TH class=\"eventTrimMonth\">"._CALFOURTHDAY."</TH>
                        <TH class=\"eventTrimMonth\">"._CALFIFTHDAY."</TH>
                        <TH class=\"eventTrimMonth\">"._CALSIXTHDAY."</TH>
                        <TH class=\"eventTrimMonth\">"._CALSEVENTHDAY."</TH>
                      </TR>";

		/**** Previous Greyed month days */
		While ($day_of_week < ($Day_of_First_Week + 1)) {
			if ($day_of_week == 1) {
				print("\n<TR>");
			}
			$Tmp_Date = mktime(0, 0, 0, $Date_Array[0], 1 - (($Day_of_First_Week + 1) - $day_of_week), $Date_Array[2]);
			$Tmp_Day = Date("d",$Tmp_Date);
			echo "<TD class=\"eventShadedMonth\">$Tmp_Day</TD>";
			$day_of_week += 1;
		}
		$usedcount = 0;
		$cellcount = 0;
		/**** Build Current Month */
		for ($day = 1 ; $day <= $Last_Day ; $day++) {
			if ($day_of_week == 1) {
				print("<TR>");
			}
			if (($day == $Today_d) && ($Date_Array[0] == $Today_m) && ($Date_Array[2] == $Today_y)){
				echo "<TD class=\"eventDayMonthToday\"><div class=\"eventDayMonthToday\"><a href=\"modules.php?op=modload&name=$module_name&file=index&Date=$Date_Array[0]/$day/$Date_Array[2]&type=day\">$day</a></div>";
			}
			else {
				echo "<TD class=\"eventDayMonth\"><div class=\"eventDayMonth\"><a href=\"modules.php?op=modload&name=$module_name&file=index&Date=$Date_Array[0]/$day/$Date_Array[2]&type=day\">$day</a></div>";
			}
			/************************/
			/**** SET UP DATA!!! ****/
			/************************/

			/**** Reset Cell Array */
			$cellDate = mktime (0, 0, 0, $Date_Array[0], $day, $Date_Array[2]);
			for ($i=0;$i <= $cellcount - 1;$i++) {
				$tmpEndDate_Array = explode("-", $cellArrayEndDate[$i]);
				$tmpEndDate = mktime (0, 0, 0, $tmpEndDate_Array[1], $tmpEndDate_Array[2], $tmpEndDate_Array[0]);
				if ($tmpEndDate < $cellDate) {
					$cellArray[$i] = "FALSE";
				}
			}

			/**** Clean out Cell Array */
			if ($cellcount != 0) {
				$j = $cellcount;
				for ($i=$cellcount - 1;$i >= 0;$i--) {
					if ($cellArray[$i] == "FALSE") {
						Array_pop($cellArray);
						Array_pop($cellArrayTitle);
						Array_pop($cellArrayEventDate);
						Array_pop($cellArrayEndDate);
						Array_pop($cellArrayBarColor);
						Array_pop($cellArrayDesc);
						$j--;
					}
					else {
						break;
					}
				}
				$cellcount = $j;
			}
			/**** Add neccessary additions to cellArray */
			while ((mystrtotime($eventDate_Array[$usedcount]) <= mystrtotime("$Date_Array[2]-$Date_Array[0]-$day")) && ($usedcount <= $count)) {
				$added = "FALSE";
				/**** First Try to find a spot in the cell for the event */
				for ($i=0;$i <= $cellcount - 1;$i++) {
					if ($cellArray[$i] == "FALSE") {
						/**** Found spot in cellArray */
						$cellArray[$i] = $eid_Array[$usedcount];
						$cellArrayTitle[$i] = $title_Array[$usedcount];
						$cellArrayEventDate[$i] = $eventDate_Array[$usedcount];
						$cellArrayEndDate[$i] = $endDate_Array[$usedcount];
						$cellArrayBarColor[$i] = $barcolor_Array[$usedcount];
						$cellArrayDesc[$i] = $desc_Array[$usedcount];
						$added = "TRUE";
						break 1;
					}
				}

				/**** If all spots are taken in the current cellArray then add it to the end */
				if ($added == "FALSE") {
					$cellArray[] = $eid_Array[$usedcount];
					$cellArrayTitle[] = $title_Array[$usedcount];
					$cellArrayEventDate[] = $eventDate_Array[$usedcount];
					$cellArrayEndDate[] = $endDate_Array[$usedcount];
					$cellArrayBarColor[] = $barcolor_Array[$usedcount];
					$cellArrayDesc[] = $desc_Array[$usedcount];
					$cellcount++;  /**** Increase cell count since added to the end of the array */
				}
				$usedcount++;
			}

			/**************************************/
			/**** INSERT DATA INTO CALENDAR!!! ****/
			/**************************************/
			if ($eventsopeninnewwindow == 1) {
				$frame = "target=\"blank\"";
			} else {
				$frame = "";
			}
			for ($i=0;$i<=$cellcount - 1;$i++) {

				if ($cellArrayBarColor[$i] == "r") $barcolorchar="r";
				elseif ($cellArrayBarColor[$i] == "g") $barcolorchar="g";
				elseif ($cellArrayBarColor[$i] == "b") $barcolorchar="b";
				elseif ($cellArrayBarColor[$i] == "y") $barcolorchar="y";
				else $barcolorchar="w";

				if ($cellArray[$i] != "FALSE") {
					$tmpEventDate_Array = explode("-", $cellArrayEventDate[$i]);
					$tmpEventDate = mktime (0, 0, 0, $tmpEventDate_Array[1], $tmpEventDate_Array[2], $tmpEventDate_Array[0]);
					$tmpEndDate_Array = explode("-", $cellArrayEndDate[$i]);
					$tmpEndDate = mktime (0, 0, 0, $tmpEndDate_Array[1], $tmpEndDate_Array[2], $tmpEndDate_Array[0]);
					if ($textEvents) {
						echo "<img src=\"modules/$module_name/images/ball$barcolorchar.gif\" border=0> <a href=\"modules.php?op=modload&name=$module_name&file=index&type=view&eid=$cellArray[$i]\" $frame>"._CALEVENTALLDAY2."<br />$cellArrayTitle[$i]</a><br />";
					}
					else {
						echo "<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr>";
						//$popuptext = " onmouseover=\"pop('$cellArrayTitle[$i]','$cellArrayDesc[$i]',popbord,popback)\" onmouseout=\"kill()\"";
						$popuptext = "";
						if (($cellDate == $tmpEndDate) && ($tmpEndDate == $tmpEventDate)) {
							/*echo "<td><a href=\"modules.php?op=modload&name=$module_name&file=index&type=view&eid=$cellArray[$i]\" $frame $popuptext><img src=\"modules/$module_name/images/leftbar$barcolorchar.gif\" border=\"0\"></a></td>
							 <td align=\"right\" width=\"100%\" background=\"modules/$module_name/images/mainbar$barcolorchar.gif\"><a href=\"modules.php?op=modload&name=$module_name&file=index&type=view&eid=$cellArray[$i]\" $frame $popuptext><img src=\"modules/$module_name/images/mainbar2$barcolorchar.gif\" border=\"0\"></a></td>
							 <td align=\"right\"><a href=\"modules.php?op=modload&name=$module_name&file=index&type=view&eid=$cellArray[$i]\" $frame $popuptext><img src=\"modules/$module_name/images/rightbarcap$barcolorchar.gif\" border=\"0\"></a></td>";*/
							echo "<td><img src=\"modules/$module_name/images/leftbar$barcolorchar.gif\" border=\"0\"></td>
							<td align=\"right\" width=\"100%\" background=\"modules/$module_name/images/mainbar$barcolorchar.gif\"><img src=\"modules/$module_name/images/mainbar2$barcolorchar.gif\" border=\"0\"></td>
							<td align=\"right\"><img src=\"modules/$module_name/images/rightbarcap$barcolorchar.gif\" border=\"0\"></td>";
						}
						elseif ($cellDate == $tmpEventDate) {
							/*echo "<td><a href=\"modules.php?op=modload&name=$module_name&file=index&type=view&eid=$cellArray[$i]\" $frame $popuptext><img src=\"modules/$module_name/images/leftbar$barcolorchar.gif\" border=\"0\"></a></td>
							 <td align=\"center\" width=100% background=\"modules/$module_name/images/mainbar$barcolorchar.gif\"><a href=\"modules.php?op=modload&name=$module_name&file=index&type=view&eid=$cellArray[$i]\" $frame $popuptext><img src=\"modules/$module_name/images/mainbar2$barcolorchar.gif\" border=\"0\"></a></td>";*/
							echo "<td><img src=\"modules/$module_name/images/leftbar$barcolorchar.gif\" border=\"0\"></td>
							<td align=\"center\" width=100% background=\"modules/$module_name/images/mainbar$barcolorchar.gif\"><img src=\"modules/$module_name/images/mainbar2$barcolorchar.gif\" border=\"0\"></td>";
						}
						elseif ($cellDate == $tmpEndDate) {
							/*echo "<td align=\"center\" width=100% background=\"modules/$module_name/images/mainbar$barcolorchar.gif\"><a href=\"modules.php?op=modload&name=$module_name&file=index&type=view&eid=$cellArray[$i]\" $frame $popuptext><img src=\"modules/$module_name/images/mainbar2$barcolorchar.gif\" border=\"0\"></a></td>
							 <td><a href=\"modules.php?op=modload&name=$module_name&file=index&type=view&eid=$cellArray[$i]\" $frame $popuptext><img src=\"modules/$module_name/images/rightbar$barcolorchar.gif\" border=\"0\"></a></td>";*/
							echo "<td align=\"center\" width=100% background=\"modules/$module_name/images/mainbar$barcolorchar.gif\"><img src=\"modules/$module_name/images/mainbar2$barcolorchar.gif\" border=\"0\"></td>
							<td><img src=\"modules/$module_name/images/rightbar$barcolorchar.gif\" border=\"0\"></td>";
						}
						else {
							if ($day == 1) {
								/*echo "<td><a href=\"modules.php?op=modload&name=$module_name&file=index&type=view&eid=$cellArray[$i]\" $frame $popuptext><img src=\"modules/$module_name/images/leftbar2$barcolorchar.gif\" border=\"0\"></a></td>
								 <td align=\"center\" width=99% background=\"modules/$module_name/images/mainbar$barcolorchar.gif\"><a href=\"modules.php?op=modload&name=$module_name&file=index&type=view&eid=$cellArray[$i]\" $frame $popuptext><img src=\"modules/$module_name/images/mainbar2$barcolorchar.gif\" border=\"0\"></a></td>";*/
								echo "<td><img src=\"modules/$module_name/images/leftbar2$barcolorchar.gif\" border=\"0\"></td>
								<td align=\"center\" width=99% background=\"modules/$module_name/images/mainbar$barcolorchar.gif\"><img src=\"modules/$module_name/images/mainbar2$barcolorchar.gif\" border=\"0\"></td>";
							}
							else {
								//echo "<td align=\"center\" background=\"modules/$module_name/images/mainbar$barcolorchar.gif\"><a href=\"modules.php?op=modload&name=$module_name&file=index&type=view&eid=$cellArray[$i]\" $frame $popuptext><img src=\"modules/$module_name/images/mainbar$barcolorchar.gif\" border=\"0\"></a></td>";
								echo "<td align=\"center\" background=\"modules/$module_name/images/mainbar$barcolorchar.gif\"><img src=\"modules/$module_name/images/mainbar$barcolorchar.gif\" border=\"0\"></td>";
							}
						}
						echo "</tr></table>";
						echo "<a href=\"modules.php?op=modload&name=$module_name&file=index&type=view&eid=$cellArray[$i]\" $frame>".$cellArrayTitle[$i]."</a><br />";
					}
				}
				else {
					if (!$textEvents) {
						echo "<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr>";
						echo "<td width=\"100%\"><img src=\"modules/$module_name/images/blankbar.gif\"></td>";
						echo "</tr></table>";
					}
				}

			}

			$resultAPPT = $db->sql_query("SELECT eid,title,eventDate,endDate,startTime,endTime,barcolor FROM ".$prefix."_events WHERE (eventDate <= '".$Date_Array[2]."-".$Date_Array[0]."-".$day."' AND endDate >= '".$Date_Array[2]."-".$Date_Array[0]."-".$day."' AND alldayevent='0') ORDER BY startTime, endTime ASC");
			while(list($eid, $title, $eventDate, $endDate, $startTime, $endTime, $barcolor) = $db->sql_fetchrow($resultAPPT)) {
				if ($barcolor == "r") $barcolorchar="r";
				elseif ($barcolor == "g") $barcolorchar="g";
				elseif ($barcolor == "b") $barcolorchar="b";
				elseif ($barcolor == "y") $barcolorchar="y";
				else $barcolorchar="w";
				if ($time24Hour) {
					$time_Array = explode(":",$startTime);
					$startTime = $time_Array[0].":".$time_Array[1];
					$time_Array = explode(":",$endTime);
					$endTime = $time_Array[0].":".$time_Array[1];
				} else {
					$startTime = getTime($startTime);
					$endTime = getTime($endTime);
				}
				echo "<img src=\"modules/$module_name/images/ball$barcolorchar.gif\" border=0> <a href=\"modules.php?op=modload&name=$module_name&file=index&type=view&eid=$eid\" $frame>$startTime-$endTime<br />$title</a><br>";
			}
			$db->sql_freeresult($resultAPPT);
			print("</td>");
			if ($day_of_week == 7) {
				$day_of_week = 0;
				print("\n</TR>");
			}
			$day_of_week += 1;
		}

		/**** Next Greyed month days */
		$day = 1;
		While (($day_of_week <= 7) && ($day_of_week != 1)) {
			print("<TD class=\"eventShadedMonth\">$day</TD>");
			$day_of_week += 1;
			$day += 1;
		}
		print("\n</TR>\n</TABLE>");
		echo "</fieldset>";
	}
}

function buildMonthforNetscape($Date) {
	global $module_name, $trimbgcolor, $trimtextcolor, $trimbgcolor2, $trimtextcolor2,$textEvents,
	$monthtableborder, $monthtablecellspacing, $monthtablecellpadding, $monthbgcolor, $selecteddaycolor,
	$eventsopeninnewwindow, $monthshadedbgcolor, $monthshadedtextcolor,$time24Hour;
	global $prefix, $db;
	if (!$Date) {
		$Date = Date("m/d/Y");
	}
	$Date_Array = explode("/", $Date);
	if ($Date_Array[2] < 1970)
	print("ERROR! System can not interpret dates befor 01/01/1970");
	else {
		$Date = mktime(0, 0, 0, $Date_Array[0], $Date_Array[1], $Date_Array[2]);

		/**** Header */
		$Prev_Month = mktime(0, 0, 0, $Date_Array[0] - 1, 1, $Date_Array[2]);
		$Prev_Date = Date("m/d/Y",$Prev_Month);
		$Next_Month = mktime(0, 0, 0, $Date_Array[0] + 1, 1, $Date_Array[2]);
		$Next_Date = Date("m/d/Y",$Next_Month);
		print("\n<TABLE width=100%><TR>");

		/**** Print Previous Month Button */
		print("\n<TD width=100><FONT SIZE=2><a href=\"modules.php?op=modload&amp;name=$module_name&amp;file=index&amp;Date=$Prev_Date&amp;type=month\"><<< "._CALPREVIOUS."</a></TD>");
		print("\n<TD align=center><FONT size=4>");

		/**** Print Month Name and Year */
		print(getMonthName($Date)." ".Date("Y",$Date));
		print("</FONT></TD>");

		/**** Print Next Month Button */
		print("\n<TD width=100 align=right><FONT SIZE=2><a href=\"modules.php?op=modload&amp;name=$module_name&amp;file=index&amp;Date=$Next_Date&amp;type=month\">"._CALNEXT." >>></a></TD>");
		print("</TR></TABLE>");

		/**** Get the Day (Integer) for the first day in the month */
		$First_Day_of_Month_Date = mktime(0, 0, 0, $Date_Array[0], 1, $Date_Array[2]);
		$Day_of_First_Week = Date("w",$First_Day_of_Month_Date);

		/**** Find the last day of the month */
		$Month = Date("m",$Date);
		$day = 27;
		do {
			$End_of_Month_Date = mktime(0, 0, 0, $Date_Array[0], $day, $Date_Array[2]);
			$Test_Month = Date("m",$End_of_Month_Date);
			$day += 1;
		} while ( $Month == $Test_Month );
		$Last_Day = $day - 2;

		/**** Get todays date */
		$Today_d = Date("d");
		$Today_m = Date("m");
		$Today_y = Date("Y");

		//$result = $db->sql_query("SELECT eid,title,hometext,eventDate,endDate,barcolor FROM ".$prefix."_events WHERE (((eventDate >= '".$Date_Array[2]."-".$Date_Array[0]."-1' AND eventDate <= '".$Date_Array[2]."-".$Date_Array[0]."-".$Last_Day."') OR (endDate >= '".$Date_Array[2]."-".$Date_Array[0]."-1' AND endDate <= '".$Date_Array[2]."-".$Date_Array[0]."-".$Last_Day."') OR (endDate >= '".$Date_Array[2]."-".$Date_Array[0]."-".$Last_Day."' AND eventDate <= '".$Date_Array[2]."-".$Date_Array[0]."-1')) AND alldayevent='1') ORDER BY eventDate ASC");

		/**** Build Month */
		print("\n<CENTER>\n<TABLE border=$monthtableborder cellspacing=$monthtablecellspacing cellpadding=$monthtablecellpadding width=100% bgcolor=$monthbgcolor>");
		$day_of_week = 1;

		echo "<TR bgcolor=$trimbgcolor>
		<TH width=15%><FONT SIZE=2 color=$trimtextcolor>"._CALFIRSTDAY."</TH>
		<TH width=15%><FONT color=$trimtextcolor SIZE=2>"._CALSECONDDAY."</TH>
		<TH width=15%><FONT color=$trimtextcolor SIZE=2>"._CALTHIRDDAY."</TH>
		<TH width=15%><FONT color=$trimtextcolor SIZE=2>"._CALFOURTHDAY."</TH>
		<TH width=15%><FONT color=$trimtextcolor SIZE=2>"._CALFIFTHDAY."</TH>
		<TH width=15%><FONT color=$trimtextcolor SIZE=2>"._CALSIXTHDAY."</TH>
		<TH width=15%><FONT color=$trimtextcolor SIZE=2>"._CALSEVENTHDAY."</TH>
                      </TR>";

		/**** Previous Greyed month days */
		While ($day_of_week < ($Day_of_First_Week + 1)) {
			if ($day_of_week == 1) {
				print("\n<TR>");
			}
			$Tmp_Date = mktime(0, 0, 0, $Date_Array[0], 1 - (($Day_of_First_Week + 1) - $day_of_week), $Date_Array[2]);
			$Tmp_Day = Date("d",$Tmp_Date);
			print("<TD bgcolor=$monthshadedbgcolor align=center valign=top><FONT SIZE=2 color=$monthshadedtextcolor>$Tmp_Day</TD>");
			$day_of_week += 1;
		}

		/**** Build Current Month */
		for ($day = 1 ; $day <= $Last_Day ; $day++) {
			if ($day_of_week == 1) {
				print("\n<TR>");
			}
			if (($day == $Today_d) && ($Date_Array[0] == $Today_m) && ($Date_Array[2] == $Today_y))
			print("\n\t<TD valign=top><center><FONT SIZE=2><b><a href=\"modules.php?op=modload&amp;name=$module_name&amp;file=index&amp;Date=$Date_Array[0]/$day/$Date_Array[2]&amp;type=day\">$day</a></b></center>");
			else
			print("\n\t<TD valign=top><center><FONT SIZE=2><b><a href=\"modules.php?op=modload&amp;name=$module_name&amp;file=index&amp;Date=$Date_Array[0]/$day/$Date_Array[2]&amp;type=day\">$day</a></b></center></font>");


			/**************************************/
			/**** INSERT DATA INTO CALENDAR!!! ****/
			/**************************************/
			if ($eventsopeninnewwindow == 1) {
				$frame = "target=\"blank\"";
			} else {
				$frame = "";
			}

			$result = $db->sql_query("SELECT eid,title,eventDate,endDate,barcolor FROM ".$prefix."_events WHERE (eventDate <= '".$Date_Array[2]."-".$Date_Array[0]."-".$day."' AND endDate >= '".$Date_Array[2]."-".$Date_Array[0]."-".$day."' AND alldayevent='1') ORDER BY title ASC");
			while(list($eid, $title, $eventDate, $endDate, $barcolor) = $db->sql_fetchrow($result)) {
				if ($barcolor == "r") $barcolorchar="r";
				elseif ($barcolor == "g") $barcolorchar="g";
				elseif ($barcolor == "b") $barcolorchar="b";
				elseif ($barcolor == "y") $barcolorchar="y";
				else $barcolorchar="w";
				echo "<font size=2><img src=\"modules/$module_name/images/ball$barcolorchar.gif\" border=0> <a href=\"modules.php?op=modload&amp;name=$module_name&amp;file=index&amp;type=view&amp;eid=$eid\" $frame>$title</a></font><br>";
			}
			$db->sql_freeresult($result);

			$resultAPPT = $db->sql_query("SELECT eid,title,eventDate,endDate,startTime,endTime,barcolor FROM ".$prefix."_events WHERE (eventDate <= '".$Date_Array[2]."-".$Date_Array[0]."-".$day."' AND endDate >= '".$Date_Array[2]."-".$Date_Array[0]."-".$day."' AND alldayevent='0') ORDER BY startTime, endTime ASC");
			while(list($eid, $title, $eventDate, $endDate, $startTime, $endTime, $barcolor) = $db->sql_fetchrow($resultAPPT)) {
				if ($barcolor == "r") $barcolorchar="r";
				elseif ($barcolor == "g") $barcolorchar="g";
				elseif ($barcolor == "b") $barcolorchar="b";
				elseif ($barcolor == "y") $barcolorchar="y";
				else $barcolorchar="w";
				if ($time24Hour) {
					$time_Array = explode(":",$startTime);
					$startTime = $time_Array[0].":".$time_Array[1];
					$time_Array = explode(":",$endTime);
					$endTime = $time_Array[0].":".$time_Array[1];
				} else {
					$startTime = getTime($startTime);
					$endTime = getTime($endTime);
				}
				echo "<font size=2><img src=\"modules/$module_name/images/ball$barcolorchar.gif\" border=0> <a href=\"modules.php?op=modload&amp;name=$module_name&amp;file=index&amp;type=view&amp;eid=$eid\" $frame>$startTime - $endTime<br> $title</a></font><br>";
			}
			$db->sql_freeresult($resultAPPT);

			print("</td>");
			if ($day_of_week == 7) {
				$day_of_week = 0;
				print("\n</TR>");
			}
			$day_of_week += 1;
		}

		/**** Next Greyed month days */
		$day = 1;
		While (($day_of_week <= 7) && ($day_of_week != 1)) {
			print("<TD bgcolor=$monthshadedbgcolor align=center valign=top><FONT SIZE=2 color=$monthshadedtextcolor>$day</TD>");
			$day_of_week += 1;
			$day += 1;
		}
		print("\n</TR>\n</TABLE>\n</CENTER>");
	}
}
/**
 *
 *
 *
 */
function viewEvent_old($eid) {
	global $admin,$module_name,$time24Hour,$useInternationalDates;
	global $prefix, $db;

	$result = $db->sql_query("SELECT * FROM ".$prefix."_events WHERE eid=$eid");
	list($eid,$aid,$title,$datePosted,$body,$comments,$counter,$topic,$informant,$eventDate,$endDate,$startTime,$endTime,$alldayevent,$barcolor,$withregistration) = $db->sql_fetchrow($result);
	$ta = $db->sql_query("select topicname,topicimage,topictext from ".$prefix."_topics where topicid='$topic'");
	list($topicname,$topicimage,$topictext) = $db->sql_fetchrow($ta);

	$Date_Array = explode("-", $eventDate);
	$endDate_Array = explode("-", $endDate);
	$Date_Array2 = explode(" ", $datePosted);
	$Date_Array2 = explode("-",$Date_Array2[0]);
	if ($time24Hour) {
		$time_Array = explode(":",$startTime);
		$startTime = $time_Array[0].":".$time_Array[1];
		$time_Array = explode(":",$endTime);
		$endTime = $time_Array[0].":".$time_Array[1];
	}
	else {
		$startTime = getTime($startTime);
		$endTime = getTime($endTime);
	}
	$debut = $Date_Array[2]."/".$Date_Array[1]."/".$Date_Array[0];
	$fin = $endDate_Array[2]."/".$endDate_Array[1]."/".$endDate_Array[0];
	if ($debut == $fin) {
		$journee = _CALTHE.$debut;
	}
	else {
		$journee = _CALFROM.$debut._CALTO.$fin;
	}
	if ($alldayevent == "1") {
		$horaire = _CALALLDAYLONG;
	}
	else {
		$horaire = _CALHOURFROM.$startTime._CALHOURTO.$endTime;
	}

	echo "<fieldset><legend><img src=\"images/topics/$topicimage\" class=\"topicImg\" border=\"0\" alt=\"$topictext\">$topictext</legend>";
	echo "<p class=\"redactor\">"._CALPOSTEDBY." <a href=\"modules.php?name=Your_Account&amp;op=userinfo&amp;username=$informant\">$informant</a> "._CALPOSTEDON." $Date_Array2[2]/$Date_Array2[1]/$Date_Array2[0] "._CALACCEPTEDBY." $aid</p>";
	echo "<hr class=\"event\">";
	echo "<p class=\"horaires\">"._CALTHEEVENT.$journee.$horaire."</p>";
	echo "<hr class=\"event\">";
	echo "<h1>".$title."</h1>";
	echo "<div class=\"corpsevt\">".$body."</div>";
	if ($withregistration == "1") {
		echo "<hr class=\"event\">";
		echo "<p class=\"action\"><a href=\"modules.php?op=modload&amp;name=$module_name&amp;file=register&amp;eid=$eid\">"._REGISTERTOEVENT."</a></p>";
	}
	echo "</fieldset>";
	if (is_admin($admin)) {
		echo "<p class=\"action\">[ <a href=\"system.php?op=CalendarEditStory&amp;eid=$eid\">"._EDIT."</a> | <a href=\"system.php?op=CalendarRemoveStory&amp;eid=$eid\">"._DELETE."</a> ]</p";
	}
}
function viewEvent($eid) {
	global $admin,$module_name,$time24Hour,$useInternationalDates;
	global $prefix, $db;

	$result = $db->sql_query("SELECT * FROM ".$prefix."_events WHERE eid=$eid");
	list($eid,$aid,$title,$datePosted,$body,$comments,$counter,$topic,$informant,$eventDate,$endDate,$startTime,$endTime,$alldayevent,$barcolor,$withregistration) = $db->sql_fetchrow($result);
	$ta = $db->sql_query("select topicname,topicimage,topictext from ".$prefix."_topics where topicid='$topic'");
	list($topicname,$topicimage,$topictext) = $db->sql_fetchrow($ta);

	$Date_Array = explode("-", $eventDate);
	$endDate_Array = explode("-", $endDate);
	$Date_Array2 = explode(" ", $datePosted);
	$Date_Array2 = explode("-",$Date_Array2[0]);
	if ($time24Hour) {
		$time_Array = explode(":",$startTime);
		$startTime = $time_Array[0].":".$time_Array[1];
		$time_Array = explode(":",$endTime);
		$endTime = $time_Array[0].":".$time_Array[1];
	}
	else {
		$startTime = getTime($startTime);
		$endTime = getTime($endTime);
	}
	$debut = $Date_Array[2]."/".$Date_Array[1]."/".$Date_Array[0];
	$fin = $endDate_Array[2]."/".$endDate_Array[1]."/".$endDate_Array[0];
	if ($debut == $fin) {
		$journee = _CALTHE.$debut;
	}
	else {
		$journee = _CALFROM.$debut._CALTO.$fin;
	}
	if ($alldayevent == "1") {
		$horaire = _CALALLDAYLONG;
	}
	else {
		$horaire = _CALHOURFROM.$startTime._CALHOURTO.$endTime;
	}

	echo "<h1>$topictext</h1>";
	echo "<p class=\"redactor\">"._CALPOSTEDBY." <a href=\"modules.php?name=Your_Account&amp;op=userinfo&amp;username=$informant\">$informant</a> "._CALPOSTEDON." $Date_Array2[2]/$Date_Array2[1]/$Date_Array2[0] "._CALACCEPTEDBY." $aid</p>";
	echo "<hr class=\"event\">";
	//echo "<p class=\"horaires\">"._CALTHEEVENT.$journee.$horaire."</p>";
	echo "<p class=\"horaires\">".$journee.$horaire."</p>";
	echo "<hr class=\"event\">";
	//echo "<h1>".$title."</h1>";
	echo "<div class=\"corpsevt\">".$body."</div>";
	if ($withregistration == "1") {
		echo "<hr class=\"event\">";
		echo "<p class=\"action\"><a href=\"modules.php?op=modload&amp;name=$module_name&amp;file=register&amp;eid=$eid\">"._REGISTERTOEVENT."</a></p>";
	}

	if (is_admin($admin)) {
		echo "<p class=\"action\">[ <a href=\"system.php?op=CalendarEditStory&amp;eid=$eid\">"._EDIT."</a> | <a href=\"system.php?op=CalendarRemoveStory&amp;eid=$eid\">"._DELETE."</a> ]</p";
	}
}
/**
 * CalendarIndexOld()
 * @param date Date
 * @param int type
 * @param int eid
 *
 */
function CalendarIndexOld($Date,$type,$eid) {
	global $storyhome, $httpref, $httprefmax, $topicname, $topicimage, $topictext, $datetime, $user, $cookie, $nuke_url,
	$module_name,$eventsopeninnewwindow,$netscapeFriendlyMonthView,$useInternationalDates;
	global $prefix, $db;

	if (isset($cookie[3])) {
		$storynum = $cookie[3];
	} else {
		$storynum = $storyhome;
	}
	$result = $db->sql_query("SELECT eid, aid, title, time, hometext, comments, counter, topic, informant FROM ".$prefix."_events ORDER BY eid DESC limit $storynum");
	if(!$result) {
		print_r ( $db->sql_error () );
		echo "<br>"; exit();
	}

	if (!(($eventsopeninnewwindow) && ($type == "view"))) {
		include("header.php");
		OpenTable();

		/**** Get todays date */
		$Today_d = Date("d");
		$Today_m = Date("m");
		$Today_y = Date("Y");
		echo "<tr><td class=evenTitle>"._CALNAME."</td>";
		echo "<td rowspan=2 align=right>";
		//	echo "<font size=\"2\"><b>"._CALVIEWTEXT."</b></font><br>";
		echo "<a href=modules.php?op=modload&amp;name=Calendrier&amp;file=index&amp;type=day&amp;Date=$Date>["._CALDAYLINK."]</a><br>";
		echo "<a href=modules.php?op=modload&amp;name=Calendrier&amp;file=index&amp;type=month&amp;Date=$Date>["._CALMONTHLINK."]</a><br>";
		echo "<a href=modules.php?op=modload&amp;name=Calendrier&amp;file=index&amp;type=year&amp;Date=$Date>["._CALYEARLINK."]</a>";
		echo "</td>";
		echo "</tr>";

		echo "<form name=\"jump\">"
		."<tr>"
		."<td valign=\"top\">"
		."<br><font size=\"2\"><b>"._CALJUMPTOTEXT."</b>:";
		if ($useInternationalDates) {
			echo "<select name=\"jumpday\">";
			if ($Date){
				$Date_Array = explode("/", $Date);
				$tag = $Date_Array[1];
				buildDaySelect($tag);
			} else {
				buildDaySelect($Today_d);
			}
			echo "</select>
          <select name=\"jumpmonth\">";
			if ($Date){
				$Date_Array = explode("/", $Date);
				$monat = $Date_Array[0];
				buildMonthSelect($monat);
			}else{
				buildMonthSelect($Today_m);
			}
			echo "</select>
          <select name=\"jumpyear\">";
			if ($Date){
				$Date_Array = explode("/", $Date);
				$jahr = $Date_Array[2];
				buildYearSelect($jahr);
			} else {
				buildYearSelect($Today_y);
			}
			echo "</select>";
		} else {
			echo "<br><select name=\"jumpmonth\">";
			buildMonthSelect($Today_m);
			echo "</select>
                  <select name=\"jumpday\">";
			buildDaySelect($Today_d);
			echo "</select>
                  <select name=\"jumpyear\">";
			buildYearSelect($Today_y);
			echo "</select>";
		}

		echo " ";
		echo "<input type=\"button\" value=\""._CALJUMPBUTTON."\" onClick=\"location.href='modules.php?op=modload&amp;name=$module_name&amp;file=index&amp;type=' +  '&amp;Date=' + document.jump.jumpmonth.options[document.jump.jumpmonth.options.selectedIndex].value + '/' + document.jump.jumpday.options[document.jump.jumpday.options.selectedIndex].value + '/' + document.jump.jumpyear.options[document.jump.jumpyear.options.selectedIndex].value;\"> ";
		echo "<input type=\"button\" value=\"Aujourd'hui\" onClick=\"location.href='modules.php?op=modload&amp;name=$module_name&amp;file=index&amp;type=' +  '&amp;Date=$Today_m/$Today_d/$Today_y';\"></td>";
			
		echo "</tr>";
		echo "</form>";
		echo "<tr><td colspan=2><a href=\"modules.php?op=modload&amp;name=$module_name&amp;file=submit\">"._CALSUBMITEVENT."</a></td></tr>";
			
		CloseTable();
	}

	formatTimestamp($time);
	$subject = stripslashes($subject);
	$hometext = stripslashes($hometext);
	$introcount = strlen($hometext);
	$totalcount = $introcount + $fullcount;
	echo "<table cellpadding=8 width=\"100%\"><tr><td>";
	if (($type == "month") || !($type)) {
		if($netscapeFriendlyMonthView)
		buildMonthforNetscape($Date);
		else
		buildMonth($Date);
	} elseif ($type == "day") {
		buildDay($Date);
	} elseif ($type == "year") {
		buildYear($Date);
	} elseif ($type == "view") {
		viewEvent($eid);
	}
	echo "</td></tr></table>";

	$db->sql_freeresult($result);
	if ($httpref==1) {
		$referer = getenv("HTTP_REFERER");
		if ($referer=="" OR preg_match("#^unknown#i", $referer) OR substr("$referer",0,strlen($nuke_url))==$nuke_url OR preg_match("#^bookmark#i",$referer)) {
		} else {
			$db->sql_query("insert into ".$prefix."_referer values (NULL, '$referer')");
		}
		$result = $db->sql_query("select * from ".$prefix."_referer");
		$numrows =$db->sql_numrows($result);
		if($numrows>=$httprefmax) {
			$db->sql_query("delete from ".$prefix."_referer");
		}
	}

	if (!(($eventsopeninnewwindow) && ($type == "view"))) {
		include("footer.php");
	}
}
/**
 * CalendarIndex()
 * @param date Date
 * @param int type
 * @param int eid
 *
 */
function CalendarIndex_old($Date,$type,$eid) {
	global $storyhome, $httpref, $httprefmax, $topicname, $topicimage, $topictext, $datetime, $user, $cookie, $nuke_url,
	$module_name,$eventsopeninnewwindow,$netscapeFriendlyMonthView,$useInternationalDates;
	global $prefix, $db;

	if (isset($cookie[3])) {
		$storynum = $cookie[3];
	} else {
		$storynum = $storyhome;
	}
	$result = $db->sql_query("SELECT eid, aid, title, time, hometext, comments, counter, topic, informant FROM ".$prefix."_events ORDER BY eid DESC limit $storynum");
	if(!$result) {
		print_r ( $db->sql_error () );
		echo "<br>"; exit();
	}

	if (!(($eventsopeninnewwindow) && ($type == "view"))) {
		include("header.php");

		/**** Get todays date */
		$Today_d = Date("d");
		$Today_m = Date("m");
		$Today_y = Date("Y");

		echo "<h1>"._CALNAME."</h1>";
		echo "<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" href=\"javascripts/calendar/styles/calendar-win2k-cold-1.css\" title=\"win2k-cold-1\" />\n";
		echo "<script type=\"text/javascript\" src=\"javascripts/calendar/calendar.js\"></script>\n";
		echo "<script type=\"text/javascript\" src=\"javascripts/calendar/lang/calendar-fr.js\"></script>\n";
		echo "<script type=\"text/javascript\" src=\"javascripts/calendar/calendar-setup.js\"></script>\n";
		/*echo "<fieldset><legend>"._CALVIEWTEXT."</legend>";
		 echo "<a href=modules.php?op=modload&name=$module_name&file=index&type=day&Date=$Date>"._CALDAYLINK." <img src=\"modules/$module_name/images/calendar_view_day.gif\" border=0 title=\""._CALDAYLINK."\"></a>";
		 echo " - ";
		 echo "<a href=modules.php?op=modload&name=$module_name&file=index&type=month&Date=$Date>"._CALMONTHLINK." <img src=\"modules/$module_name/images/calendar_view_month.gif\" border=0 title=\""._CALMONTHLINK."\"></a>";
		 echo " - ";
		 echo "<a href=modules.php?op=modload&name=$module_name&file=index&type=year&Date=$Date>"._CALYEARLINK." <img src=\"modules/$module_name/images/calendar_view_year.gif\" border=0 title=\""._CALYEARLINK."\"></a>";
		 echo " - ";
		 echo "<a href=modules.php?op=modload&name=$module_name&op=listevents>"._CALLISTEVENTLINK." <img src=\"modules/$module_name/images/calendar_list_events.gif\" border=0 title=\""._CALYEARLINK."\"></a>";
		 echo " - ";
		 echo "<a href=modules.php?op=modload&name=$module_name&file=index&type=month&Date=$Today_m/$Today_d/$Today_y>"._CALTHISMONTHLINK." <img src=\"modules/$module_name/images/today.gif\" border=0 title=\""._TODAY."\"></a>";
		 echo " - ";
		 echo "<a href=\"modules.php?op=modload&amp;name=$module_name&amp;file=submit\">"._CALSUBMITEVENT." <img src=\"modules/$module_name/images/calendar_edit.gif\" border=0 title=\""._CALSUBMITEVENT."\"></a>";
		 echo "</fieldset>";*/
		global $menusevts;
		$lemenu = "";
		if (in_array("Q", $menusevts)) {
			$lemenu .= "<a href=modules.php?op=modload&name=$module_name&file=index&type=day&Date=$Date><img src=\"modules/$module_name/images/calendar_view_day.gif\" border=0 title=\""._CALDAYLINK."\"> "._CALDAYLINK."</a>";
			$lemenu .= ($lemenu != "") ? "<br />" : "";
		}
		if (in_array("M", $menusevts)) {
			$lemenu .= "<a href=modules.php?op=modload&name=$module_name&file=index&type=month&Date=$Date><img src=\"modules/$module_name/images/calendar_view_month.gif\" border=0 title=\""._CALMONTHLINK."\"> "._CALMONTHLINK."</a>";
			$lemenu .= ($lemenu != "") ? "<br />" : "";
		}
		if (in_array("A", $menusevts)) {
			$lemenu .= "<a href=modules.php?op=modload&name=$module_name&file=index&type=year&Date=$Date><img src=\"modules/$module_name/images/calendar_view_year.gif\" border=0 title=\""._CALYEARLINK."\"> "._CALYEARLINK."</a>";
			$lemenu .= ($lemenu != "") ? "<br />" : "";
		}
		//$lemenu .= "<a href=modules.php?op=modload&name=$module_name&op=listevents><img src=\"modules/$module_name/images/calendar_list_events.gif\" border=0 title=\""._CALLISTEVENTLINK."\"> "._CALLISTEVENTLINK."</a>";
		if (in_array("L", $menusevts)) {
			$lemenu .= "<a href=modules.php?op=modload&name=$module_name&file=index&type=list&Date=$Date><img src=\"modules/$module_name/images/calendar_list_events.gif\" border=0 title=\""._CALLISTEVENTLINK."\"> "._CALLISTEVENTLINK."</a>";
			$lemenu .= ($lemenu != "") ? "<br />" : "";
		}
		if (in_array("N", $menusevts)) {
			$lemenu .= "<a href=modules.php?op=modload&name=$module_name&file=index&type=month&Date=$Today_m/$Today_d/$Today_y><img src=\"modules/$module_name/images/today.gif\" border=0 title=\""._TODAY."\"> "._CALTHISMONTHLINK."</a>";
			$lemenu .= ($lemenu != "") ? "<br />" : "";
		}
		if (in_array("P", $menusevts)) {
			$lemenu .= "<a href=\"modules.php?op=modload&amp;name=$module_name&amp;file=submit\"><img src=\"modules/$module_name/images/calendar_edit.gif\" border=0 title=\""._CALSUBMITEVENT."\"> "._CALSUBMITEVENT."</a>";
		}
		if ($lemenu != "") {
			echo "<div class=\"cal_buttonBarDiv\">";
			themesidebox(_CALVIEWTEXT, $lemenu);
			echo "</div>";
		}
		echo "<p>"._CALHOMETEXT."</p>";
		echo "<div style=\"clear: both\"></div>";
		/*// date form
		 $thetype=$type;
		 if ($thetype=="view") $thetype="day";

		 echo "<form name=\"jump\">";
		 echo "<table cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse: collapse\" ><tr><td><input type=\"hidden\" name=\"mydate\" id=\"mydate\" readonly=\"1\" value=\"$Date\" OnChange=\"location.href='modules.php?op=modload&amp;name=$module_name&amp;file=index&amp;type=$thetype' +  '&amp;Date=' + document.jump.mydate.value;\"></td>"
		 ."<td><img src=\"modules/$module_name/images/view.gif\" id=\"f_trigger_c\" style=\"cursor: pointer; border: 0px solid red;\" title=\""._CALJUMPBUTTON."\" "
		 ."onmouseover=\"this.style.background='red';\" onmouseout=\"this.style.background=''\" /></td>";
		 //echo "<input type=\"text\" name=\"date\" id=\"f_date_b\" /><button type=\"reset\" id=\"f_trigger_b\">...</button>\n";
		 // init calendar
		 echo "<script type=\"text/javascript\">\n"
		 ."Calendar.setup({\n"
		 ."   inputField     :    \"mydate\",\n"
		 ."	 ifFormat       :    \"%m/%d/%Y\",\n"
		 ."   showsTime      :    false,\n  "
		 ."    button         :    \"f_trigger_c\",\n"
		 ."    align          :    \"Tl\",\n"
		 ."    singleClick    :    true\n"
		 ."});\n"
		 ."</script>\n";

		 echo " ";
		 //echo "<input type=\"button\" value=\""._CALJUMPBUTTON."\" onClick=\"location.href='modules.php?op=modload&amp;name=$module_name&amp;file=index&amp;type=$type' +  '&amp;Date=' + document.jump.mydate.value\"> ";
		 echo "<td><img src=\"modules/$module_name/images/today.gif\" title=\""._TODAY."\" onClick=\"location.href='modules.php?op=modload&amp;name=$module_name&amp;file=index&amp;type=' +  '&amp;Date=$Today_m/$Today_d/$Today_y';\"></td>";
		 echo "</tr></table>";

		 echo "</form>";
		 echo "<p><a href=\"modules.php?op=modload&amp;name=$module_name&amp;file=submit\">"._CALSUBMITEVENT."</a></p>";*/
	}

	formatTimestamp($time);
	$subject = stripslashes($subject);
	$hometext = stripslashes($hometext);
	$introcount = strlen($hometext);
	$totalcount = $introcount + $fullcount;

	if (($type == "month") || !($type)) {
		if($netscapeFriendlyMonthView)
		buildMonthforNetscape($Date);
		else
		buildMonth($Date);
	}
	elseif ($type == "day") {
		buildDay($Date);
	}
	elseif ($type == "year") {
		buildYear($Date);
	}
	elseif ($type == "view") {
		viewEvent($eid);
	}
	elseif ($type == "list") {
		listEvents($Date);
	}

	$bardef=array("back"=>"javascript:window.history.back()", "top"=>"#top" );
	buttonBar($bardef, "align") ;
	
	$db->sql_freeresult($result);
	if ($httpref==1) {
		$referer = getenv("HTTP_REFERER");
		if ($referer=="" OR preg_match("#^unknown#i", $referer) OR substr("$referer",0,strlen($nuke_url))==$nuke_url OR preg_match("#^bookmark#i",$referer)) {
		} else {
			$db->sql_query("insert into ".$prefix."_referer values (NULL, '$referer')");
		}
		$result = $db->sql_query("select * from ".$prefix."_referer");
		$numrows =$db->sql_numrows($result);
		if($numrows>=$httprefmax) {
			$db->sql_query("delete from ".$prefix."_referer");
		}
	}

	if (!(($eventsopeninnewwindow) && ($type == "view"))) {
		include("footer.php");
	}
}

function CalendarIndex($Date,$type,$eid) {
	global $storyhome, $httpref, $httprefmax, $topicname, $topicimage, $topictext, $datetime, $user, $cookie, $nuke_url,
	$module_name,$eventsopeninnewwindow,$netscapeFriendlyMonthView,$useInternationalDates;
	global $prefix, $db;

	if (isset($cookie[3])) {
		$storynum = $cookie[3];
	} else {
		$storynum = $storyhome;
	}
	$result = $db->sql_query("SELECT eid, aid, title, time, hometext, comments, counter, topic, informant FROM ".$prefix."_events ORDER BY eid DESC limit $storynum");
	if(!$result) {
		print_r ( $db->sql_error () );
		echo "<br>"; exit();
	}
	
	include("header.php");

	/**** Get todays date */
	$Today_d = Date("d");
	$Today_m = Date("m");
	$Today_y = Date("Y");

	if ($type != "view") {
		echo "<h1>"._CALNAME."</h1>";
		echo "<p>"._CALHOMETEXT."</p>";
		echo "<div style=\"clear: both\"></div>";
	}

	formatTimestamp($time);
	$subject = stripslashes($subject);
	$hometext = stripslashes($hometext);
	$introcount = strlen($hometext);
	$totalcount = $introcount + $fullcount;

	if (($type == "month") || !($type)) {
		if($netscapeFriendlyMonthView)
		buildMonthforNetscape($Date);
		else
		buildMonth($Date);
	}
	elseif ($type == "day") {
		buildDay($Date);
	}
	elseif ($type == "year") {
		buildYear($Date);
	}
	elseif ($type == "view") {
		viewEvent($eid);
	}
	elseif ($type == "list") {
		listEvents($Date);
	}

	$bardef=array("back"=>"javascript:window.history.back()", "top"=>"#top" );
	buttonBar($bardef, "align") ;
	
	$db->sql_freeresult($result);
	if ($httpref==1) {
		$referer = getenv("HTTP_REFERER");
		if ($referer=="" OR preg_match("#^unknown#i", $referer) OR substr("$referer",0,strlen($nuke_url))==$nuke_url OR preg_match("#^bookmark#i",$referer)) {
		} else {
			$db->sql_query("insert into ".$prefix."_referer values (NULL, '$referer')");
		}
		$result = $db->sql_query("select * from ".$prefix."_referer");
		$numrows =$db->sql_numrows($result);
		if($numrows>=$httprefmax) {
			$db->sql_query("delete from ".$prefix."_referer");
		}
	}

	if (!(($eventsopeninnewwindow) && ($type == "view"))) {
		include("footer.php");
	}
}

/**
 * listEvents()
 * return list of exixting event
 *
 */
function listEvents($Date){
	global $module_name, $db, $prefix,$time24Hour,$useInternationalDates;
	if (!$Date) {
		$Date = Date("m/d/Y");
	}
	$Date_Array = explode("/", $Date);
	$result = $db->sql_query("select eid, title, hometext, eventDate, endDate, startTime, endTime, topic,alldayevent,barcolor,withregistration from ".$prefix."_events where endDate >= '".$Date_Array[2]."-01-01' and eventDate < '".($Date_Array[2]+1)."-01-01' order by topic ASC,eventDate ASC,startTime ASC");
	//	for ($i=1;$i<=366;$i++) {
	//		echo date("Y-m-d",mktime(0,0,0,1,$i,$Date_Array[2]))."<br>";
	//	}
	$Prev_Month = mktime(0, 0, 0, $Date_Array[0], 1, $Date_Array[2] - 1);
	$Prev_Date = Date("m/d/Y",$Prev_Month);
	$Next_Month = mktime(0, 0, 0, $Date_Array[0], 1, $Date_Array[2] + 1);
	$Next_Date = Date("m/d/Y",$Next_Month);

	$topic_en_cours = -1;
	$topicname = "";
	if ($Date_Array[2] < 1970)
	print("ERROR! System can not interpret dates befor 01/01/1970");
	else {
		echo "<fieldset><legend>"._EVEN_LIST.$Date_Array[2]."</legend>";
		print("<TABLE width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"calaction\"><TR>");
		/**** Print Previous Month Button */
		print("\n<TD width=\"50%\"><a href=\"modules.php?op=modload&name=$module_name&file=index&Date=$Prev_Date&type=list\">"._CALPREVIOUS."</a></TD>");
		/**** Print Next Month Button */
		print("\n<TD width=\"50%\" align=\"right\"><a href=\"modules.php?op=modload&name=$module_name&file=index&Date=$Next_Date&type=list\">"._CALNEXT."</a></TD>");
		//echo "</tr><tr height=\"4\"><td height=\"4\"></td><td height=\"4\"></td>";
		print("</TR></TABLE>");
		if ($db->sql_numrows($result) != 0) {
			echo '<table border="0" cellpaggin="0" cellspacing="0" class="listevent">';
			while (list($eid, $title, $hometext, $eventDate, $endDate, $startTime, $endTime, $topic, $alldayevent, $barcolor, $withregistration) = $db->sql_fetchrow($result)) {
				if ($topic_en_cours != $topic) {
					$ta = $db->sql_query("select topicname,topicimage,topictext from ".$prefix."_topics where topicid='$topic'");
					list($topicname,$topicimage,$topictext) = $db->sql_fetchrow($ta);
				}
				if ($topicname != $topicname_prev) {
					echo "<tr>";
					echo "<th colspan=\"3\" class=\"sujet\">"."<img src=\"images/topics/$topicimage\" class=\"topicImg\" border=\"0\" alt=\"$topictext\">".$topicname."</tr>";
					echo "</tr>";
					$topicname_prev = $topicname;
				}
				$Date_Array = explode("-", $eventDate);
				$endDate_Array = explode("-", $endDate);
				if ($time24Hour) {
					$time_Array = explode(":",$startTime);
					$startTime = $time_Array[0].":".$time_Array[1];
					$time_Array = explode(":",$endTime);
					$endTime = $time_Array[0].":".$time_Array[1];
				}
				else {
					$startTime = getTime($startTime);
					$endTime = getTime($endTime);
				}
				$debut = $Date_Array[2]."/".$Date_Array[1]."/".$Date_Array[0];
				$fin = $endDate_Array[2]."/".$endDate_Array[1]."/".$endDate_Array[0];
				if ($debut == $fin) {
					$journee = _CALTHE.$debut;
				}
				else {
					$journee = _CALFROM.$debut._CALTO.$fin;
				}
				if ($alldayevent == "1") {
					$horaire = _CALALLDAYLONG;
				}
				else {
					$horaire = _CALHOURFROM.$startTime._CALHOURTO.$endTime;
				}
				echo "<tr>";
				echo "<th><img src=\"modules/".$module_name."/images/ball".$barcolor.".gif\" border=0>  <a href=\"modules.php?name=Calendrier&type=view&eid=$eid\">".$title."</a></th>";
				echo "<td>".$journee.$horaire."</td>";
				if ($withregistration == "1") {
					echo "<td align=\"center\" nowrap> <a href=\"modules.php?op=modload&name=Calendrier&file=register&eid=$eid\">"._REGISTER."</a></td>";
				}
				else {
					echo "<td></td>";
				}
				echo "</tr>";
			}
			echo "</table>";
		}
		else {
			echo "<p>"._CALNOEVENTFOUND."</p>";
		}
		echo "</fieldset>";
	}

	/*$bardef=array("back"=>"javascript:window.history.back()", "top"=>"#top" );
	buttonBar($bardef, "align") ;*/
}

/**
 * listEvents()
 * return list of exixting event
 *
 */
function listEventsOld(){
	global $db, $prefix,$time24Hour,$useInternationalDates;
	include ('header.php');
	OpenTable();
	// ---------------- Title ----------------------------
	echo "<table width=100%>";
	echo "<tr><td class=evenTitle>"._CALNAME."</td></tr>";
	//echo "<tr><td class=evenDesc>$data_theme_description</td></tr>";
	echo "</table>";
	echo "<BR><div class=evenMess>"._EVENLIST_MESS."</div><BR><BR>";

	echo"<TABLE  class=\"tab\" cellSpacing=2  cellPadding=2 width=90% border=0>";
	echo"<TBODY>";
	echo"<TR>";
	echo"<TD height=39 align=center class=\"titretab\" colspan=5>";
	echo""._EVEN_LIST."</TD>";
	echo"</TR>";

	$result = $db->sql_query("select eid, title, hometext, eventDate, endDate, startTime, endTime, topic from ".$prefix."_events order by time");

	while(list($eid, $title, $hometext, $eventDate, $endDate, $startTime, $endTime, $topic) = $db->sql_fetchrow($result)) {
		$ta = $db->sql_query("select topicname from ".$prefix."_topics where topicid='$topic'");
		list($topicname) = $db->sql_fetchrow($ta);
		//formatTimestamp($time);
		$Date_Array = explode("-", $eventDate);
		$endDate_Array = explode("-", $endDate);
		if ($time24Hour) {
			$time_Array = explode(":",$startTime);
			$startTime = $time_Array[0].":".$time_Array[1];
			$time_Array = explode(":",$endTime);
			$endTime = $time_Array[0].":".$time_Array[1];
		} else {
			$startTime = getTime($startTime);
			$endTime = getTime($endTime);
		}

		echo "<tr>"
		."<td align=\"left\"><a href=\"modules.php?name=Calendrier&type=view&eid=$eid\">$title</a></td>"
		."<td align=\"left\">$hometext</a></td>"
		."<td align=\"center\">$Date_Array[2]/$Date_Array[1]/$Date_Array[0]</td>"
		."<td align=\"center\">"._FROM." $startTime "._TO." $endTime</td>";
		echo "<td align=\"center\" nowrap> <a href=\"modules.php?op=modload&name=Calendrier&file=register&eid=$eid\">"._REGISTER."</a></td></tr>";
	}
	echo "</TBODY></table><br>";

	/*$bardef=array("back"=>"",
                  "top"=>"#top" );
	buttonBar($bardef, "align");*/

	echo CloseTable();
	include("footer.php");
}

function date2JMA($ladate, $formatdate="d/m/Y H:i:s"){
	if ($ladate == "0000-00-00 00:00:00" || $ladate == "0000-00-00" || $ladate == "") {
		return "";
	}
	else {
		list($lejour,$lemoment) = explode(" ",$ladate);
		list($an,$mois,$jour) = explode("-",$lejour);
		if ($lemoment != "") {
			list($heure, $minute,$seconde) = explode(":", $lemoment);
		}
		else {
			list($heure, $minute,$seconde) = array(0,0,0);
		}
		$ladate = date($formatdate, mktime($heure, $minute,$seconde, $mois,$jour,$an));
		return $ladate;
		//return preg_replace("#([0-9]{4})-([0-9]{2})-([0-9]{2})#i","\\3/\\2/\\1",$ladate);
	}
}

function list_manifs($topicid="") {
	global $module_name, $db, $prefix,$time24Hour,$useInternationalDates,$Default_Theme, $manifsparpage;
	global $pagetitle;
	global $agendapageentete;
	global $page;
	
	$pagetitle = " - "._CAL_TITLETRAVELBOOK;

	$sortie = "";
	
	$where = "";
	if ($topicid) {
		$where = " where topic='".$topicid."' ";
	}
	
	if (file_exists("themes/".$Default_Theme."/pattern_cal_list.php")) {
		$result = $db->sql_query("select eid, title, hometext, eventDate, endDate, startTime, endTime, topic from ".$prefix."_events ".$where." order by eventDate DESC, startTime DESC");
		$tab_manifs = array();
		while(list($eid, $title, $hometext, $eventDate, $endDate, $startTime, $endTime, $topic) = $db->sql_fetchrow($result)) {
			$ta = $db->sql_query("select topicname from ".$prefix."_topics where topicid='$topic'");
			list($topicname) = $db->sql_fetchrow($ta);
			$tab_manifs[] = array(
				"eid" =>$eid,
				"title" => $title,
				"hometext" => $hometext,
				"eventDate" => $eventDate,
				"endDate" => $endDate,
				"startTime" => $startTime,
				"endTime" => $endTime,
				"topic" => $topic,
				"topicname" => $topicname
			);
		}
		require("themes/".$Default_Theme."/pattern_cal_list.php");
	}
	else {
		$limit= "";
		if ($manifsparpage != "") {
			$limit = " limit 0,$manifsparpage";
		}
		$result = $db->sql_query("select eid, title, hometext, eventDate, endDate, startTime, endTime, topic from ".$prefix."_events ".$where." order by eventDate DESC, startTime DESC".$limit);
		while(list($eid, $title, $hometext, $eventDate, $endDate, $startTime, $endTime, $topic) = $db->sql_fetchrow($result)) {
			$ta = $db->sql_query("select topicname from ".$prefix."_topics where topicid='$topic'");
			list($topicname) = $db->sql_fetchrow($ta);
			if (preg_match("/(<img[^>]+>)/mi",$hometext,$tabimages)) {
				$vignette = $tabimages[1];
				$hometext = preg_replace("/(<img[^>]+>)/mi","",$hometext);
				preg_match("/src=\"([^\"]+)\"/i",$vignette,$taburls);
				$urlvignette = $taburls[1];
				$urlvignetteredim = "modules/becmsGallery/resizer_big.php?imgfile=../../$urlvignette&max_width=80&max_height=80";
			}
			else {
				if (file_exists("themes/$Default_Theme/images/nopict.gif")) {
					$urlvignetteredim = "modules/becmsGallery/resizer_big.php?imgfile=../../themes/$Default_Theme/images/nopict.gif&max_width=80&max_height=80";
				}
				else {
					$urlvignetteredim = "modules/becmsGallery/resizer_big.php?imgfile=images/nopict.gif&max_width=80&max_height=80";
				}
			}
			preg_match("#(<p class=\"date\">)(.*)(</p>)#mi",$hometext,$tabtext);
			$ladate = $tabtext[0];
			$description = str_replace($ladate, "", $hometext);
			$description = strip_tags($description);
			/*$description = preg_replace("#<ul(.|\n)+$#mi", "", $hometext);
			//$description = $hometext;*/
			$description = $ladate."<p>".truncate_string($description,"200")."</p>";
			$maclasse = "listingLegend";
			$maclasseimg = "thumb";
			if ($endDate < date("Y-m-d")) {
				$maclasse = "listingLegendpast";
				$maclasseimg = "thumbpast";
			}
			$sortie .= '
	                        	<li>
	                            	<a class="'.$maclasseimg.'" href="modules.php?name='.$module_name.'&op=viewmanif&eid='.$eid.'" title="'.$title.'"><img src="'.$urlvignetteredim.'" width="80" height="80" alt="'.$title.'"/></a>
	                            	<div class="'.$maclasse.'">
	                                	<div class="titreListing"><a href="modules.php?name='.$module_name.'&op=viewmanif&eid='.$eid.'">'.$title.'</a><span class="categorie">'.$topicname.'</span>
	                                    </div>
	                                	'.$description.'
	                                    <a class="more" href="modules.php?name='.$module_name.'&op=viewmanif&eid='.$eid.'" title="'.$title.'">Lire la suite</a>
	                                </div>
	                                <div style="clear:both"></div>
	                            </li>
			';
		}
		if ($sortie != "") {
			$sortie = '<ul class="listingAgenda">'.$sortie.'</ul>';
		}
		else {
			$sortie = "<p>Aucune manifestation !</p>";
		}
	}
	
	if ($agendapageentete != 0 && $agendapageentete != "") {
		require_once("modules/Sections/connector_class.php");
		$sectmodule = new pageconnector();
		$entete = $sectmodule->getPageContent($agendapageentete,"", true);
	}
	else {
		$entete = "<h1>Agenda des manifestations</h1>";
	}
	
	include("header.php");
	
	echo $entete;
	echo $sortie;
	$bardef=array("back"=>"javascript:window.history.back()",
			"carnetvoyage"=>"@");
		/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",
		"mailto"=>"#",
		"top"=>"#top"*/
	buttonBar($bardef, "align");
	include("footer.php");
}

function view_manif($eid,$highlite="") {
	global $admin,$module_name,$time24Hour,$useInternationalDates,$Default_Theme;
	global $prefix, $db;
	global $pagetitle;
	global $meta_keyword, $meta_description, $meta_twitter_card, $meta_twitter_site, $meta_twitter_creator, $meta_og_url, $meta_og_title, $meta_og_description, $meta_og_image, $meta_og_type;

	$result = $db->sql_query("SELECT * FROM ".$prefix."_events WHERE eid=$eid");
	list($eid,$aid,$title,$datePosted,$body,$comments,$counter,$topic,$informant,$eventDate,$endDate,$startTime,$endTime,$alldayevent,$barcolor,$withregistration, $album, $keywords, $description, $twitter_card, $twitter_site, $twitter_creator, $og_url, $og_title, $og_description, $og_image, $og_type) = $db->sql_fetchrow($result);
	$ta = $db->sql_query("select topicname,topicimage,topictext from ".$prefix."_topics where topicid='$topic'");
	list($topicname,$topicimage,$topictext) = $db->sql_fetchrow($ta);

	$pagetitle = " - ".$title;
	if ($keywords != "") {
		$meta_keyword = $keywords;
	}
	if ($description != "") {
		$meta_description = $description;
	}
	if ($twitter_card != "") {
		$meta_twitter_card = $twitter_card;
	}
	if ($twitter_site != "") {
		$meta_twitter_site = $twitter_site;
	}
	if ($twitter_creator != "") {
		$meta_twitter_creator = $twitter_creator;
	}
	if ($og_url != "") {
		$meta_og_url = $og_url;
	}
	if ($og_title != "") {
		$meta_og_title = $og_title;
	}
	if ($og_description != "") {
		$meta_og_description = $og_description;
	}
	if ($og_image != "") {
		$meta_og_image = $og_image;
	}
	if ($og_type != "") {
		$meta_og_type = $og_type;
	}
	
	if ($highlite != "") {
		$title = preg_replace("#($highlite)#i","<span class=\"highlite\">\\1</span>" ,$title);
		//$content = preg_replace("#(<script[^>]*>.*)($highlite)(.*</script)#i","_codearemplaceravanthilite_" ,$content);
		
		$matches = array();
		$matchessortie = array();
		if (preg_match_all("#(<script[^>]*>)(.*)(</script)#imsU", $body, $matches)) {
			for ($i=1;$i<count($matches); $i++) {
				$matchessortie[$i] = preg_replace("#$highlite#im", "_codearemplaceravanthilite_", $matches[$i]);
				if (htmlentities($highlite,ENT_NOQUOTES, "ISO-8859-1") != $highlite) {
					$matchessortie[$i] = preg_replace("#".htmlentities($highlite,ENT_NOQUOTES, "ISO-8859-1")."#im", "_codearemplaceravanthilite2_", $matchessortie[$i]);
				}
				$body = str_replace($matches[$i], $matchessortie[$i], $body);
			}
		}
		
		$body = preg_replace("#(>[^<]*)($highlite)#i","\\1<span class=\"highlite\">\\2</span>" ,$body);
		if (htmlentities($highlite,ENT_NOQUOTES, "ISO-8859-1") != $highlite) {
			$body = preg_replace("#(>[^<]*)(".htmlentities($highlite,ENT_NOQUOTES, "ISO-8859-1").")#i","\\1<span class=\"highlite\">\\2</span>" ,$body);
		}
		
		$body = str_replace("_codearemplaceravanthilite_", $highlite, $body);
		$body = str_replace("_codearemplaceravanthilite2_", htmlentities($highlite,ENT_NOQUOTES, "ISO-8859-1"), $body);
	}
	$body = insert_video_player($body);
	$body = insert_simple_map($body);
	$body = insert_photo_zoom($body);
	
	if (file_exists("themes/".$Default_Theme."/pattern_cal_evt.php")) {
		$tab_manif = array(
			"eid" => $eid,
			"aid" => $aid,
			"title" => $title,
			"datePosted" => $datePosted,
			"body" =>  $body,
			"comments" => $comments,
			"counter" => $counter,
			"topic" => $topic,
			"informant" => $informant,
			"eventDate" => $eventDate,
			"endDate" => $endDate,
			"startTime" => $startTime,
			"endTime" => $endTime,
			"alldayevent" => $alldayevent,
			"barcolor" => $barcolor,
			"withregistration" => $withregistration,
			"topicname" => $topicname,
			"topicimage" => $topicimage,
			"topictext" => $topictext
		);
		require("themes/".$Default_Theme."/pattern_cal_evt.php");
	}
	else {
		$sortie = "<h1>$title</h1>";
		$sortie .= "<div class=\"corpsevt\">".$body."</div>";
		
	}
	
	include("header.php");
	echo $sortie;
	
	$bardef=array("back"=>"javascript:window.history.back()",
			/*"print"=>"modules.php?name=News&amp;file=print&amp;sid=$sid",
			"mailto"=>"#",*/
			"top"=>"#top",
			"carnetvoyage"=>"@");
	buttonBar($bardef, "align");
	include("footer.php");
}

function sendJSONCals($max_width, $max_height, $longtitle, $longdesc,$topicid,$nbre) {
	require_once("connector_lib.php");
	$sortie = getJSONCals($max_width, $max_height, $longtitle, $longdesc,$topicid,$nbre,false);
	header("Content-Type: application/json; charset=UTF-8");
	echo "{".$sortie."}";
}

// ------------------------------ switch part -----------------------
if (!isset($highlite)) {
	$highlite = "";
}
switch ($op) {
	case "listemanifs":
		list_manifs($topicid);
		break;
	case "viewmanif":
		view_manif($eid,$highlite);
		break;
	case "listevents":
		listEvents();
		break;
	case "calsJSON":
		sendJSONCals($max_width, $max_height, $longtitle, $longdesc,$topicid,$nbre);
		break;
	default:
		CalendarIndex($Date,$type,$eid);
		break;
}

?>