/**
* getCookieVal(offset)
*
*/
function getCookieVal(offset)
{
 var endstr=document.cookie.indexOf (";", offset);
 if (endstr==-1) endstr=document.cookie.length;
 return unescape(document.cookie.substring(offset, endstr));
}
/**
* LireCookie(nom)
* @param nom du cookie
* @return value associed to cookies name
*/
function readCookie(nom)
{
 var arg=nom+"=";
 var alen=arg.length;
 var clen=document.cookie.length;
 var i=0;
 while (i<clen) {
 var j=i+alen;
 if (document.cookie.substring(i, j)==arg) return getCookieVal(j);
 i=document.cookie.indexOf(" ",i)+1;
 if (i==0) break;
 }
return null;
}
/**
* Exemple#1
* <script type="text/javascript" language="JavaScript">
* <!--
* EcrireCookie("dejavenu", "oui");
* //-->
* </script>
* ? Le cookie dejavenu prend la valeur "oui".
* ? Aucune date d'expiration n'?tant sp?cifi?e, il expirera ? la fin de la session en cours du navigateur.
* ? Son chemin d'acc?s, non sp?cifi?, est celui de la page HTML qui l'?crit.
* ? Son domaine de validit?, non sp?cifi?, est celui de la page HTML qui l'?crit.
* ? Secure n'?tant pas sp?cifi?, il est accessible par une connexion non s?curis?e (HTTP).
*
*
*/
function saveCookie(nom, valeur)
{
 var argv=saveCookie.arguments;
 var argc=saveCookie.arguments.length;
 var expires=(argc > 2) ? argv[2] : null;
 var path=(argc > 3) ? argv[3] : null;
 var domain=(argc > 4) ? argv[4] : null;
 var secure=(argc > 5) ? argv[5] : false;
 document.cookie=nom+"="+escape(valeur)+
 ((expires==null) ? "" : ("; expires="+expires.toGMTString()))+
 ((path==null) ? "" : ("; path="+path))+
 ((domain==null) ? "" : ("; domain="+domain))+
 ((secure==true) ? "; secure" : "");
}

/**
* EffaceCookie(nom)
* Efface un cookie
* Notez que la fonction EffaceCookie fixe la date d'expiration ? moins 1an. Ce choix est arbitraire. Moins un jour ou moins une heure auraient tout aussi bien fonctionn?.
* Pour effacer un cookie, il suffit maintenant d'appeler la fonction EffaceCookie depuis le corps de la page HTML. Voici un exemple de script ? ins?rer entre les balises <body> et </body>:
*
* <script type="text/javascript" language="JavaScript">
* EffaceCookie("email");
* </script>
* @param nom du cookies
*/
function delCookie(nom)
{
 date=new Date;
 date.setFullYear(date.getFullYear()-1);
 saveCookie(nom,null,date);
}