
/* ************************************** 				  	*/
/* Balistis ECMS                          				  	*/
/* Based on code done by Bernard Martin-Rabaud 			  	*/
/* CONTROLE DE FORMULAIRE VERSION 2 (AVEC CHAMPS INDEXS) 	*/
/* Date de cration: 18/12/2004 						  	*/
/* 														  	*/
/* Rewrited by Stephan Acquatella stephan@balistis.com    	*/
/* Add multi language support 								*/
/* Solve String error 										*/
// CONTROLE DE FORMULAIRE VERSION 2 (AVEC CHAMPS INDEXS)

var g_lim_index = 100;
var g_lim_champs_obligatoires = 100;

function alert_control_form(message) {
	if (typeof alerte_erreur == "undefined") {
		alert(message);
	}
	else {
		var reg = new RegExp("\n- ", "g");
		var tabmessage = message.split(reg);
		var new_message = tabmessage[0];
		new_message += "<ul>";
		for(var i=1 ; i<tabmessage.length ; i++) {
			new_message += "<li>" + tabmessage[i] + "</li>";
		}
		new_message += "</ul>";
		//message = message.replace(reg,"<br />");
		alerte_erreur("Erreur",new_message);
	}
}

function submit_form(formulaire) {
    var champs = lireChampsObligatoires(formulaire);
    if (champs.length > 0) {
        var ok = true;
        for (var i=0;i<champs.length;i++) ok &= champs[i].controler();
        if (ok) return true; 
        else {
            editerErreurs(champs);
            return false;
        }
    }
    else {
        alert_control_form(TXT_NO_FIELD_FOR_CONTROL); 
        return false;
    }
} 

function click_form(formulaire) {
    var champs = lireChampsObligatoires(formulaire);
    var ok = true;
    if (champs.length > 0) {
        for (var i=0;i<champs.length;i++) ok &= champs[i].controler();
        if (ok) formulaire.submit();
        else editerErreurs(champs);
    }
    else alert_control_form(TXT_NO_FIELD_FOR_CONTROL);
} 

function lireChampsObligatoires(formulaire) {
    var champs = new Array();
    for (var i=0;i<g_lim_champs_obligatoires;i++) {
        champ = formulaire.getElementsByTagName("champ")[i];
        if (champ) {
            if (champ.attributes["lib"]) lib = champ.attributes["lib"].nodeValue;
            else lib = null;
            if (champ.attributes["ctl"]) ctl = champ.attributes["ctl"].nodeValue;
            else ctl = null;
            if (champ.attributes["lim"]) lim = champ.attributes["lim"].nodeValue;
            else lim = null;
            champs[champs.length] = new ChampForm(formulaire, champ.attributes["nom"].nodeValue, lib, ctl, lim);
        }
        else break;
    }    
    return champs;
}

function editerErreurs(champs) {
    var html = TXT_FORM_CANNOT_BESENT+"\n";
    for (var i=0;i<champs.length;i++) html += champs[i].editerErreurs();
    alert_control_form(html);
}

function ChampForm(formulaire, nom, lib, ctl, lim) {
    this.form = formulaire;
    if (nom.lastChar() == "#") {
        this.nom = nom.slice(0, -1);
        this.index = true;
    }
    else {
        this.nom = nom; 
        this.index = false;
    }
    this.type = null; 
    this.lib = lib; 
    this.format = null; 
    this.args = null; 
    this.min = null; 
    this.max = null;
    this.idx = null;
    this.erreurs = new Array();
    if (ctl) this._analyserFormat(ctl);
    if (lim) this._analyserLim(lim);
}

ChampForm.prototype.controler = function() {
    ok = true;
    if (this.index) {
    	var etat = 0;
        var i = 0;
        var type = null;
        while (i < g_lim_index) {
            this._indexer(i);
            if (this._champExiste()) {
            	var type = this._lireType();
                if (this.type == null) this.type = type;
                else if (this.type != type) {
                    ok &= this._ajouterErreurIndex("champ_index_types_diff");
                    break;
                }
                if (this._estVide(i)) {
                    if ((etat == 0) || (etat == 2)) etat++;
                }
                else {
                    if (etat != 2) etat = 2;
                    if (this.min || this.max) ok &= this._controlerTaille();
                    if (this.format) ok &= this._controlerFormat();
                }
            }
            else {
                if ((etat != 0) || (i > parseInt(g_lim_index/4))) break;
            }
            i++;
        }
        if (etat == 0) {
            ok = false;
            this._ajouterErreurIndex(TXT_UKNONE_FIELD);
        }
        else if (etat == 1) {
            if (this.type.estChampTexte()) this._ajouterErreurIndex("champ_non_rempli");
            else if (this.type.indexOf("select") != -1) this._ajouterErreurIndex("option_non_selec");
            else this._ajouterErreurIndex("case_non_cochee");
            ok = false;
        }
    }
    else {
        if (this._champExiste()) {
            this.type = this._lireType();
            if (this.min == null || this.min > 0) {
            	if (this._estVide()) {
            		ok = false;
            	}
            	else {
            		if (this.min || this.max) ok = this._controlerTaille();
	                if (this.format) ok &= this._controlerFormat();
            	}
            }
            else {
            	if (!this._estVide_simple()) {
            		if (this.min || this.max) ok = this._controlerTaille();
		            if (this.format) ok &= this._controlerFormat();
            	}
            }  
        }
        else {
            this._ajouterErreur(TXT_UKNONE_FIELD);
            ok = false;
        }
    }
    return ok;
}

ChampForm.prototype.editerErreurs = function() {
    var texte = "";
    if (this.erreurs.length > 0) {
        for (var i=0;i<this.erreurs.length;i++) texte += "- " + this.erreurs[i] + "\n";
    }
    return texte;
}

ChampForm.prototype._analyserFormat = function(format) {
	var args = format.split(/,\s?/);
    if (args) {
        this.format = args.shift();
        if (args.length == 1) this.args = args[0];
        else this.args = args;
    }
}

ChampForm.prototype._analyserLim = function(lim) {
    var min_max = lim.match(/(\d+)(,\s?)?(\d+)?/);
    if (min_max) {
        if (!isNaN(min_max[1])) this.min = min_max[1];
        if (min_max[2]) {
            if (min_max[3] && !isNaN(min_max[3])) this.max = min_max[3];
            else this.max = 0;
        }
        else this.max = -1;
    }
}

ChampForm.prototype._champExiste = function() {
    if (this.index) var nom_champ = this.nom + this.idx;
    else var nom_champ = this.nom;
    if (this.form.elements[nom_champ]) return true;
    else return false;
}

ChampForm.prototype._estVide = function() {
    if (this.index) var nom_champ = this.nom + this.idx;
    else var nom_champ = this.nom;
    if (this.type == null) return null;
    var vide = true;
    with (this.form) {
        if ((this.type == "checkbox") || (this.type == "radio")) {
            if (elements[nom_champ].checked) vide = false;
            else if (!this.index) this._ajouterErreur("case_non_cochee");
        }
        else if ((this.type == "radio-set") || (this.type == "checkbox-set")) {
            var i = 0;
            while (i<elements[nom_champ].length) {
                if (elements[nom_champ][i].checked) break;
                else i++;
            }
            if ((i == elements[nom_champ].length) && !this.index) this._ajouterErreur("case_non_cochee");
            else vide = false;
        }
        else if (this.type == "select-multiple") {
            var i = 0;
            while (i<elements[nom_champ].options.length) {
                if (elements[nom_champ].options[i].selected) break;
                else i++;
            }
            if ((i == elements[nom_champ].options.length) && !this.index) this._ajouterErreur("option_non_selec");
            else vide = false;
        }
        else if (this.type.estChampTexte() || (this.type == "select-one")) {
            if ((elements[nom_champ].value.trim()) || (elements[nom_champ].value.trim() !== "")) vide = false
            else if (!this.index) this._ajouterErreur("champ_non_rempli");
        }
        else vide = undefined;
    }
    return vide;
}

ChampForm.prototype._estVide_simple = function() {
    if (this.index) var nom_champ = this.nom + this.idx;
    else var nom_champ = this.nom;
    if (this.type == null) return null;
    var vide = true;
    with (this.form) {
        if ((this.type == "checkbox") || (this.type == "radio")) {
            if (elements[nom_champ].checked) vide = false;
            else if (!this.index) {};
        }
        else if ((this.type == "radio-set") || (this.type == "checkbox-set")) {
            var i = 0;
            while (i<elements[nom_champ].length) {
                if (elements[nom_champ][i].checked) break;
                else i++;
            }
            if ((i == elements[nom_champ].length) && !this.index) {}
            else vide = false;
        }
        else if (this.type == "select-multiple") {
            var i = 0;
            while (i<elements[nom_champ].options.length) {
                if (elements[nom_champ].options[i].selected) break;
                else i++;
            }
            if ((i == elements[nom_champ].options.length) && !this.index) {}
            else vide = false;
        }
        else if (this.type.estChampTexte() || (this.type == "select-one")) {
            if ((elements[nom_champ].value.trim()) || (elements[nom_champ].value.trim() !== "")) vide = false
            else if (!this.index) {}
        }
        else vide = undefined;
    }
    return vide;
}

ChampForm.prototype._lireType = function() {
    if (this.index) var nom_champ = this.nom + this.idx;
    else var nom_champ = this.nom;
    var letype = null;
    with (this.form) {
        if (elements[nom_champ]) {
            if (elements[nom_champ].type == undefined) {
                if ((elements[nom_champ].length != undefined) && (elements[nom_champ].length > 1))
                    letype = elements[nom_champ][0].type + "-set";
                else this._ajouterErreur("type_inconnu");
            }
            else letype = elements[nom_champ].type;
        }
        else this._ajouterErreur("champ_inconnu");
    }
    return letype;
}

ChampForm.prototype._controlerTaille = function() {
    if (this.index) var nom_champ = this.nom + this.idx;
    else var nom_champ = this.nom;
    if (this.type.estChampTexte()) {
        var taille = this.form.elements[nom_champ].value.length;
        var ok = false;
        if (this.max == -1) {
            if (taille == this.min) ok = true; 
            else this._ajouterErreur("champ_longueur", this.min);
        }
        else if (taille >= this.min) {
            if (this.max) {
                if (taille <= this.max) ok = true; 
                else this._ajouterErreur("champ_trop_long", this.max);
            }
            else ok = true;
        }
        else this._ajouterErreur("champ_trop_court", this.min);
    }
    return ok;
}

ChampForm.prototype._controlerFormat = function() {
    if (this.index) var nom_champ = this.nom + this.idx;
    else var nom_champ = this.nom;
    if (this.type.estChampTexte()) {
        var valeur = this.form.elements[nom_champ].value;
        var ok = false;
        switch (this.format) {
            case "date" :        
                if (!(ok = controlerDate(valeur))) this._ajouterErreur("format_date"); break;
            case "date-sql" :        
        		if (!(ok = controlerDateSQL(valeur))) this._ajouterErreur("format_date_sql"); break;
            case "heure" :        
                if (!(ok = controlerHeure(valeur))) this._ajouterErreur("format_heure"); break;
            case "date-heure" :    
            case "dateheure" :    
            case "date_heure" :    
                if (!(ok = controlerDateHeure(valeur))) this._ajouterErreur("format_date_heure"); break;
            case "email" :        
                if (!(ok = controlerEmail(valeur))) this._ajouterErreur("format_email"); break;
            case "url" :        
                if (!(ok = controlerUrl(valeur))) this._ajouterErreur("format_url"); break;
            case "cp" :            
                if (!(ok = controlerCP(valeur))) this._ajouterErreur("format_cp"); break;
            case "tel" :        
                if (!(ok = controlerTel(valeur))) this._ajouterErreur("format_tel"); break;
            case "nombre" :        
                if (!(ok = controlerNombre(valeur, this.args))) this._ajouterErreur("format_nombre"); break;
            case "latitude" :        
                if (!(ok = controlerLatitude(valeur, this.args))) this._ajouterErreur("format_latitude"); break;
            case "longitude" :        
                if (!(ok = controlerLongitude(valeur, this.args))) this._ajouterErreur("format_longitude"); break;
            case "html" :        
                if (!(ok = controlerBalisesHTML(valeur))) this._ajouterErreur("format_html"); break;
            case "propre" :    
                this.form.elements[this.nom].value = controlerPropre(valeur); ok = true; break;
            default    :            
                var erreur = controlerFonction(this.format, valeur, this.args); 
                if (erreur) this._ajouterErreur("format_fonction",  erreur);
                else ok = true;
        }
    }
    else this._ajouterErreur("controle_non_texte");
    return ok;
}

ChampForm.prototype._ajouterErreur = function(erreur) {
    if (this.index) {
    	var lib_champ = this.lib + " " + this.idx;
    } else { 
    	var lib_champ = this.lib;
//    	var lib_champ = this.name;
    	}
    switch (erreur) {
        case "champ_mal_ecrit" :        
            this.erreurs.push(lib_champ + " : erreur dans la syntaxe du champ  la cration du formulaire"); break;
        case "champ_inconnu" :        
            this.erreurs.push("Le champ '" + lib_champ + "' est inconnu"); break;
        case "champ_vide" :        
            this.erreurs.push("Le champ '" + lib_champ + "' n'a pas t rempli ou slectionn"); break;
        case "champ_non_rempli" :        
            this.erreurs.push("Le champ '" + lib_champ + "' n'a pas t rempli"); break;
        case "case_non_cochee" :    
            this.erreurs.push("La case '" + lib_champ + "' n'a pas t coche"); break;
        case "option_non_selec" :    
            this.erreurs.push("Aucune option n'a t slectionne dans la liste '" + lib_champ); break;
        case "type_inconnu" :        
            this.erreurs.push("Le type du champ '" + lib_champ + "' est inconnu"); break;
        case "champ_index_types_diff" :        
            this.erreurs.push("Les champs '" + lib_champ + "' doivent tre de type identique"); break;
        case "champ_longueur" :    
            this.erreurs.push("Le champ '" + lib_champ + "' doit avoir " + arguments[1] + " caractres"); break;
        case "champ_trop_long" :    
            this.erreurs.push("Le champ '" + lib_champ + "' ne doit pas excder " + arguments[1] + " caractres"); break;
        case "champ_trop_court" :    
            this.erreurs.push("Le champ '" + lib_champ + "' doit avoir au minimum " + arguments[1] + " caractres"); break;
        case "format_date" :        
            this.erreurs.push("Le champ '" + lib_champ + "' n'est pas une date conforme"); break;
        case "format_date_sql" :        
            this.erreurs.push("Le champ '" + lib_champ + "' n'est pas une date SQL conforme"); break;
        case "format_heure" :        
            this.erreurs.push("Le champ '" + lib_champ + "' n'est pas une heure conforme"); break;
        case "format_date_heure" :    
            this.erreurs.push("Le champ '" + lib_champ + "' n'est pas une date/heure conforme"); break;
        case "format_email" :        
            this.erreurs.push("Le champ '" + lib_champ + "' n'est pas une adresse e-mail conforme"); break;
        case "format_url" :        
            this.erreurs.push("Le champ '" + lib_champ + "' n'est pas une url (adresse internet) conforme"); break;
        case "format_cp" :            
            this.erreurs.push("Le champ '" + lib_champ + "' n'est pas un code postal conforme"); break;
        case "format_tel" :        
            this.erreurs.push("Le champ '" + lib_champ + "' n'est pas un numro de tlphone conforme"); break;
        case "format_nombre" :        
            this.erreurs.push("Le champ '" + lib_champ + "' est un nombre non valide"); break;
        case "format_html" :        
            this.erreurs.push("Le champ '" + lib_champ + "' ne contient pas de balises HTML"); break;
        case "format_fonction" :    
            this.erreurs.push("Le champ '" + lib_champ + "' a l'erreur suivante: " + arguments[1]); break;
        case "controle_non_texte" : 
            this.erreurs.push("Le champ '" + lib_champ + "' n'est pas un champ de type texte"); break;
        case "format_latitude" :        
            this.erreurs.push("Le champ '" + lib_champ + "' n'est pas une latitude conforme"); break;
        case "format_longitude" :        
            this.erreurs.push("Le champ '" + lib_champ + "' n'est pas une longitude conforme"); break;
    }
}

ChampForm.prototype._ajouterErreurIndex = function(erreur) {
    switch (erreur) {
        case "champ_inconnu" :         
            this.erreurs.push("Les champs '" + this.lib + "' sont inconnus"); break;
        case "champ_non_rempli" :         
            this.erreurs.push("Aucun champ '" + this.lib + "' n'a t rempli"); break;
        case "case_non_cochee" :     
            this.erreurs.push("Aucune case '" + this.lib + "' n'a t coche"); break;
        case "option_non_selec" :     
            this.erreurs.push("Aucune option n'a t slectionne dans les listes '" + this.lib); break;
        case "champ_index_types_diff" :         
            this.erreurs.push("Les champs '" + this.lib + "' doivent tre de type identique"); break;
    }
}
    
ChampForm.prototype._indexer = function(index) {
    this.idx = index;
}

String.prototype.lastChar = function() {
    return this.substr(-1, 1);
}

String.prototype.trim = function() {
    chaine = unescape(this);
     return chaine.replace(/(^\s*)|(\s*$)/g, "");
}

String.prototype.estChampTexte = function() {
    return ((this == "text") || (this == "password") || (this == "textarea") || (this == "hidden") || (this == "file"));
}

function is_array(valeur) {
    var source = valeur.toSource();
    return (source.search(/^\[([^,]*,)+[^,]*\]/) != -1);
}

function controlerDateSQL(valeur) {
    var ok = false;
    ctl = /^(\d{4,})[\-](\d{2,})[\-](\d{2,})$/;
    var tab = valeur.match(ctl);
    if (tab) {
    		var unedate = new Date(tab[1], parseInt(tab[2],10)-1, tab[3]);
    		if ((unedate.getFullYear() == tab[1]) && (unedate.getMonth() == tab[2]-1) && (unedate.getDate() == tab[3])) ok = true;
    }    
    return ok;
}

function controlerDate(valeur) {
    var ok = false;
    ctl = /^(\d\d?)[\/\-\.](\d\d?)[\/\-\.](\d{4,})$/;
    var tab = valeur.match(ctl);
    if (tab) {
    		var unedate = new Date(tab[3], parseInt(tab[2],10)-1, tab[1]);
    		if ((unedate.getFullYear() == tab[3]) && (unedate.getMonth() == tab[2]-1) && (unedate.getDate() == tab[1])) ok = true;
    }    
    return ok;
}

function controlerHeure(valeur) {
    ctl = /^([0-1]?[0-9]|2[0-4]):([0-5][0-9])(:[0-5][0-9])?$/;
    if (valeur.search(ctl) != -1) return true;
    else return false;
}

function controlerDateHeure(valeur) {
    var date_heure = valeur.split(/\s+/);
    return (controlerDate(date_heure[0]) && controlerHeure(date_heure[1]));
}

function controlerEmail(valeur) {
    ctl = /^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+([\.][a-z0-9-]+)+$/;
    if (valeur.search(ctl) != -1) return true;
    else return false;
}

function controlerUrl(valeur) {
    ctl = /^((http(s?)|ftp):\/\/)?([\w\-]+\.)+([\w\-]+)(\/[\w\-\s]+)*(\/(([\w\-]+)(\.[\w]+)*)?(#\w+)?(\?.+)?)?$/;
    if (valeur.search(ctl) != -1) return true;
    else {
        ctl = /^mailto:[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+([\.][a-z0-9-]+)+$/;
        if (valeur.search(ctl) != -1) return true;
        else return false;
    }
}

function controlerCP(valeur) {
    ctl = /^([A-Z]+\-)?[\d]{5}$/;
    if (valeur.search(ctl) != -1) return true;
    else return false;
}

function controlerTel(valeur) {
    ctl = /^(\(\d+\))?([\s\.\-]?\d{2,})+$/;
    if (valeur.search(ctl) != -1) return true;
    else return false;
}

function controlerNombre(valeur, limites) {
	//console.log(limites);
    valeur = valeur.replace(" ", "");
    valeur = valeur.replace(",", ".");
    if (isNaN(valeur)) var ok = false;
    else {
        if (limites != "") {
            if (typeof limites == "string") {
            	//console.log("ok = (" + valeur + " >= " + limites + ");");
            	eval("ok = (" + valeur + " >= " + limites + ");");
            }
            else if (limites.length == 2) {
            	//console.log("ok = ((" + valeur + " >= " + limites[0] + ") && (" + valeur + " <= " + limites[1] + "));");
                eval("ok = ((" + valeur + " >= " + limites[0] + ") && (" + valeur + " <= " + limites[1] + "));");
            }
        }
        else var ok = true;
    }
    return ok;
}

function controlerLatitude(valeur, limites) {
	//console.log(limites);
    valeur = valeur.replace(" ", "");
    valeur = valeur.replace(",", ".");
    if (isNaN(valeur)) var ok = false;
    else {
        if (limites != "") {
            if (typeof limites == "string") {
            	//console.log("ok = (" + valeur + " >= " + limites + ");");
            	eval("ok = (" + valeur + " >= " + limites + ");");
            }
            else if (limites.length == 2) {
            	//console.log("ok = ((" + valeur + " >= " + limites[0] + ") && (" + valeur + " <= " + limites[1] + "));");
                eval("ok = ((" + valeur + " >= " + limites[0] + ") && (" + valeur + " <= " + limites[1] + "));");
            }
        }
        else if (valeur >= -90 && valeur <= 90) var ok = true;
    }
    return ok;
}

function controlerLongitude(valeur, limites) {
	//console.log(limites);
    valeur = valeur.replace(" ", "");
    valeur = valeur.replace(",", ".");
    if (isNaN(valeur)) var ok = false;
    else {
        if (limites != "") {
            if (typeof limites == "string") {
            	//console.log("ok = (" + valeur + " >= " + limites + ");");
            	eval("ok = (" + valeur + " >= " + limites + ");");
            }
            else if (limites.length == 2) {
            	//console.log("ok = ((" + valeur + " >= " + limites[0] + ") && (" + valeur + " <= " + limites[1] + "));");
                eval("ok = ((" + valeur + " >= " + limites[0] + ") && (" + valeur + " <= " + limites[1] + "));");
            }
        }
        else if (valeur >= -180 && valeur <= 180) var ok = true;
    }
    return ok;
}

function controlerBalisesHTML(valeur) {
    if (valeur.search(/<\/?(\w+)(\s[^>]+)?>/) != -1) return true;
    else return false;
}

function controlerPropre(valeur) {
    valeur = valeur.replace(/<(\w+)(\s[^>]+)?>/g, "&lt;$1$2&gt;");
    valeur = valeur.replace(/<\/(\w+)>/g, "&lt;/$1&gt;");
    valeur = valeur.replace(/<([\?%])(\w*)/, "&lt;$1$2");
    valeur = valeur.replace(/([\?%])>/, "$1&gt;");
    return valeur;
}

function controlerFonction(fonction, valeur, args) {
    if (isNaN(valeur)) var ch_eval = fonction + "(\"" + valeur.replace(/\"/, '\\"') + "\"";
    else var ch_eval = fonction + "(" + valeur;
    if (args) {
        if (is_array(args)) {
            for (i=0;i<args.length;i++) ch_eval += "," + variable_selon_type(args[i]);
        }
        else ch_eval += "," + variable_selon_type(args);
    }
    ch_eval += ");";
    return eval(ch_eval);
}

function variable_selon_type(valeur) {
    var variable = "";
    if (isNaN(valeur)) {
        if (valeur.search(/^'([^'])+'$/) != -1) valeur = valeur.slice(1, -1);
        if (valeur.indexOf("var ") == 0) variable = valeur.substring(4);
        else variable = "\"" + valeur.replace(/\"/, '\\"') + "\"";
    }
    else variable = valeur;
    return variable;
}